# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetSiteSlotResult',
    'AwaitableGetSiteSlotResult',
    'get_site_slot',
    'get_site_slot_output',
]

warnings.warn("""Version 2015-08-01 will be removed in v2 of the provider.""", DeprecationWarning)

@pulumi.output_type
class GetSiteSlotResult:
    """
    Represents a web app
    """
    def __init__(__self__, availability_state=None, client_affinity_enabled=None, client_cert_enabled=None, cloning_info=None, container_size=None, default_host_name=None, enabled=None, enabled_host_names=None, gateway_site_name=None, host_name_ssl_states=None, host_names=None, host_names_disabled=None, hosting_environment_profile=None, id=None, is_default_container=None, kind=None, last_modified_time_utc=None, location=None, max_number_of_workers=None, micro_service=None, name=None, outbound_ip_addresses=None, premium_app_deployed=None, repository_site_name=None, resource_group=None, scm_site_also_stopped=None, server_farm_id=None, site_config=None, state=None, tags=None, target_swap_slot=None, traffic_manager_host_names=None, type=None, usage_state=None):
        if availability_state and not isinstance(availability_state, str):
            raise TypeError("Expected argument 'availability_state' to be a str")
        pulumi.set(__self__, "availability_state", availability_state)
        if client_affinity_enabled and not isinstance(client_affinity_enabled, bool):
            raise TypeError("Expected argument 'client_affinity_enabled' to be a bool")
        pulumi.set(__self__, "client_affinity_enabled", client_affinity_enabled)
        if client_cert_enabled and not isinstance(client_cert_enabled, bool):
            raise TypeError("Expected argument 'client_cert_enabled' to be a bool")
        pulumi.set(__self__, "client_cert_enabled", client_cert_enabled)
        if cloning_info and not isinstance(cloning_info, dict):
            raise TypeError("Expected argument 'cloning_info' to be a dict")
        pulumi.set(__self__, "cloning_info", cloning_info)
        if container_size and not isinstance(container_size, int):
            raise TypeError("Expected argument 'container_size' to be a int")
        pulumi.set(__self__, "container_size", container_size)
        if default_host_name and not isinstance(default_host_name, str):
            raise TypeError("Expected argument 'default_host_name' to be a str")
        pulumi.set(__self__, "default_host_name", default_host_name)
        if enabled and not isinstance(enabled, bool):
            raise TypeError("Expected argument 'enabled' to be a bool")
        pulumi.set(__self__, "enabled", enabled)
        if enabled_host_names and not isinstance(enabled_host_names, list):
            raise TypeError("Expected argument 'enabled_host_names' to be a list")
        pulumi.set(__self__, "enabled_host_names", enabled_host_names)
        if gateway_site_name and not isinstance(gateway_site_name, str):
            raise TypeError("Expected argument 'gateway_site_name' to be a str")
        pulumi.set(__self__, "gateway_site_name", gateway_site_name)
        if host_name_ssl_states and not isinstance(host_name_ssl_states, list):
            raise TypeError("Expected argument 'host_name_ssl_states' to be a list")
        pulumi.set(__self__, "host_name_ssl_states", host_name_ssl_states)
        if host_names and not isinstance(host_names, list):
            raise TypeError("Expected argument 'host_names' to be a list")
        pulumi.set(__self__, "host_names", host_names)
        if host_names_disabled and not isinstance(host_names_disabled, bool):
            raise TypeError("Expected argument 'host_names_disabled' to be a bool")
        pulumi.set(__self__, "host_names_disabled", host_names_disabled)
        if hosting_environment_profile and not isinstance(hosting_environment_profile, dict):
            raise TypeError("Expected argument 'hosting_environment_profile' to be a dict")
        pulumi.set(__self__, "hosting_environment_profile", hosting_environment_profile)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_default_container and not isinstance(is_default_container, bool):
            raise TypeError("Expected argument 'is_default_container' to be a bool")
        pulumi.set(__self__, "is_default_container", is_default_container)
        if kind and not isinstance(kind, str):
            raise TypeError("Expected argument 'kind' to be a str")
        pulumi.set(__self__, "kind", kind)
        if last_modified_time_utc and not isinstance(last_modified_time_utc, str):
            raise TypeError("Expected argument 'last_modified_time_utc' to be a str")
        pulumi.set(__self__, "last_modified_time_utc", last_modified_time_utc)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if max_number_of_workers and not isinstance(max_number_of_workers, int):
            raise TypeError("Expected argument 'max_number_of_workers' to be a int")
        pulumi.set(__self__, "max_number_of_workers", max_number_of_workers)
        if micro_service and not isinstance(micro_service, str):
            raise TypeError("Expected argument 'micro_service' to be a str")
        pulumi.set(__self__, "micro_service", micro_service)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if outbound_ip_addresses and not isinstance(outbound_ip_addresses, str):
            raise TypeError("Expected argument 'outbound_ip_addresses' to be a str")
        pulumi.set(__self__, "outbound_ip_addresses", outbound_ip_addresses)
        if premium_app_deployed and not isinstance(premium_app_deployed, bool):
            raise TypeError("Expected argument 'premium_app_deployed' to be a bool")
        pulumi.set(__self__, "premium_app_deployed", premium_app_deployed)
        if repository_site_name and not isinstance(repository_site_name, str):
            raise TypeError("Expected argument 'repository_site_name' to be a str")
        pulumi.set(__self__, "repository_site_name", repository_site_name)
        if resource_group and not isinstance(resource_group, str):
            raise TypeError("Expected argument 'resource_group' to be a str")
        pulumi.set(__self__, "resource_group", resource_group)
        if scm_site_also_stopped and not isinstance(scm_site_also_stopped, bool):
            raise TypeError("Expected argument 'scm_site_also_stopped' to be a bool")
        pulumi.set(__self__, "scm_site_also_stopped", scm_site_also_stopped)
        if server_farm_id and not isinstance(server_farm_id, str):
            raise TypeError("Expected argument 'server_farm_id' to be a str")
        pulumi.set(__self__, "server_farm_id", server_farm_id)
        if site_config and not isinstance(site_config, dict):
            raise TypeError("Expected argument 'site_config' to be a dict")
        pulumi.set(__self__, "site_config", site_config)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if target_swap_slot and not isinstance(target_swap_slot, str):
            raise TypeError("Expected argument 'target_swap_slot' to be a str")
        pulumi.set(__self__, "target_swap_slot", target_swap_slot)
        if traffic_manager_host_names and not isinstance(traffic_manager_host_names, list):
            raise TypeError("Expected argument 'traffic_manager_host_names' to be a list")
        pulumi.set(__self__, "traffic_manager_host_names", traffic_manager_host_names)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)
        if usage_state and not isinstance(usage_state, str):
            raise TypeError("Expected argument 'usage_state' to be a str")
        pulumi.set(__self__, "usage_state", usage_state)

    @property
    @pulumi.getter(name="availabilityState")
    def availability_state(self) -> str:
        """
        Management information availability state for the web app. Possible values are Normal or Limited. 
                    Normal means that the site is running correctly and that management information for the site is available. 
                    Limited means that only partial management information for the site is available and that detailed site information is unavailable.
        """
        return pulumi.get(self, "availability_state")

    @property
    @pulumi.getter(name="clientAffinityEnabled")
    def client_affinity_enabled(self) -> Optional[bool]:
        """
        Specifies if the client affinity is enabled when load balancing http request for multiple instances of the web app
        """
        return pulumi.get(self, "client_affinity_enabled")

    @property
    @pulumi.getter(name="clientCertEnabled")
    def client_cert_enabled(self) -> Optional[bool]:
        """
        Specifies if the client certificate is enabled for the web app
        """
        return pulumi.get(self, "client_cert_enabled")

    @property
    @pulumi.getter(name="cloningInfo")
    def cloning_info(self) -> Optional['outputs.CloningInfoResponse']:
        """
        This is only valid for web app creation. If specified, web app is cloned from 
                    a source web app
        """
        return pulumi.get(self, "cloning_info")

    @property
    @pulumi.getter(name="containerSize")
    def container_size(self) -> Optional[int]:
        """
        Size of a function container
        """
        return pulumi.get(self, "container_size")

    @property
    @pulumi.getter(name="defaultHostName")
    def default_host_name(self) -> str:
        """
        Default hostname of the web app
        """
        return pulumi.get(self, "default_host_name")

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        """
        True if the site is enabled; otherwise, false. Setting this  value to false disables the site (takes the site off line).
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="enabledHostNames")
    def enabled_host_names(self) -> Sequence[str]:
        """
        Hostnames for the web app that are enabled. Hostnames need to be assigned and enabled. If some hostnames are assigned but not enabled
                    the app is not served on those hostnames
        """
        return pulumi.get(self, "enabled_host_names")

    @property
    @pulumi.getter(name="gatewaySiteName")
    def gateway_site_name(self) -> Optional[str]:
        """
        Name of gateway app associated with web app
        """
        return pulumi.get(self, "gateway_site_name")

    @property
    @pulumi.getter(name="hostNameSslStates")
    def host_name_ssl_states(self) -> Optional[Sequence['outputs.HostNameSslStateResponse']]:
        """
        Hostname SSL states are  used to manage the SSL bindings for site's hostnames.
        """
        return pulumi.get(self, "host_name_ssl_states")

    @property
    @pulumi.getter(name="hostNames")
    def host_names(self) -> Sequence[str]:
        """
        Hostnames associated with web app
        """
        return pulumi.get(self, "host_names")

    @property
    @pulumi.getter(name="hostNamesDisabled")
    def host_names_disabled(self) -> Optional[bool]:
        """
        Specifies if the public hostnames are disabled the web app.
                    If set to true the app is only accessible via API Management process
        """
        return pulumi.get(self, "host_names_disabled")

    @property
    @pulumi.getter(name="hostingEnvironmentProfile")
    def hosting_environment_profile(self) -> Optional['outputs.HostingEnvironmentProfileResponse']:
        """
        Specification for the hosting environment (App Service Environment) to use for the web app
        """
        return pulumi.get(self, "hosting_environment_profile")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource Id
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isDefaultContainer")
    def is_default_container(self) -> bool:
        """
        Site is a default container
        """
        return pulumi.get(self, "is_default_container")

    @property
    @pulumi.getter
    def kind(self) -> Optional[str]:
        """
        Kind of resource
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter(name="lastModifiedTimeUtc")
    def last_modified_time_utc(self) -> str:
        """
        Last time web app was modified in UTC
        """
        return pulumi.get(self, "last_modified_time_utc")

    @property
    @pulumi.getter
    def location(self) -> str:
        """
        Resource Location
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="maxNumberOfWorkers")
    def max_number_of_workers(self) -> Optional[int]:
        """
        Maximum number of workers
                    This only applies to function container
        """
        return pulumi.get(self, "max_number_of_workers")

    @property
    @pulumi.getter(name="microService")
    def micro_service(self) -> Optional[str]:
        return pulumi.get(self, "micro_service")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Resource Name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="outboundIpAddresses")
    def outbound_ip_addresses(self) -> str:
        """
        List of comma separated IP addresses that this web app uses for outbound connections. Those can be used when configuring firewall rules for databases accessed by this web app.
        """
        return pulumi.get(self, "outbound_ip_addresses")

    @property
    @pulumi.getter(name="premiumAppDeployed")
    def premium_app_deployed(self) -> bool:
        """
        If set indicates whether web app is deployed as a premium app
        """
        return pulumi.get(self, "premium_app_deployed")

    @property
    @pulumi.getter(name="repositorySiteName")
    def repository_site_name(self) -> str:
        """
        Name of repository site
        """
        return pulumi.get(self, "repository_site_name")

    @property
    @pulumi.getter(name="resourceGroup")
    def resource_group(self) -> str:
        """
        Resource group web app belongs to
        """
        return pulumi.get(self, "resource_group")

    @property
    @pulumi.getter(name="scmSiteAlsoStopped")
    def scm_site_also_stopped(self) -> Optional[bool]:
        """
        If set indicates whether to stop SCM (KUDU) site when the web app is stopped. Default is false.
        """
        return pulumi.get(self, "scm_site_also_stopped")

    @property
    @pulumi.getter(name="serverFarmId")
    def server_farm_id(self) -> Optional[str]:
        return pulumi.get(self, "server_farm_id")

    @property
    @pulumi.getter(name="siteConfig")
    def site_config(self) -> Optional['outputs.SiteConfigResponse']:
        """
        Configuration of web app
        """
        return pulumi.get(self, "site_config")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        State of the web app
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        Resource tags
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="targetSwapSlot")
    def target_swap_slot(self) -> str:
        """
        Read-only property that specifies which slot this app will swap into
        """
        return pulumi.get(self, "target_swap_slot")

    @property
    @pulumi.getter(name="trafficManagerHostNames")
    def traffic_manager_host_names(self) -> Sequence[str]:
        """
        Read-only list of Azure Traffic manager hostnames associated with web app
        """
        return pulumi.get(self, "traffic_manager_host_names")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        Resource type
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="usageState")
    def usage_state(self) -> str:
        """
        State indicating whether web app has exceeded its quota usage
        """
        return pulumi.get(self, "usage_state")


class AwaitableGetSiteSlotResult(GetSiteSlotResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSiteSlotResult(
            availability_state=self.availability_state,
            client_affinity_enabled=self.client_affinity_enabled,
            client_cert_enabled=self.client_cert_enabled,
            cloning_info=self.cloning_info,
            container_size=self.container_size,
            default_host_name=self.default_host_name,
            enabled=self.enabled,
            enabled_host_names=self.enabled_host_names,
            gateway_site_name=self.gateway_site_name,
            host_name_ssl_states=self.host_name_ssl_states,
            host_names=self.host_names,
            host_names_disabled=self.host_names_disabled,
            hosting_environment_profile=self.hosting_environment_profile,
            id=self.id,
            is_default_container=self.is_default_container,
            kind=self.kind,
            last_modified_time_utc=self.last_modified_time_utc,
            location=self.location,
            max_number_of_workers=self.max_number_of_workers,
            micro_service=self.micro_service,
            name=self.name,
            outbound_ip_addresses=self.outbound_ip_addresses,
            premium_app_deployed=self.premium_app_deployed,
            repository_site_name=self.repository_site_name,
            resource_group=self.resource_group,
            scm_site_also_stopped=self.scm_site_also_stopped,
            server_farm_id=self.server_farm_id,
            site_config=self.site_config,
            state=self.state,
            tags=self.tags,
            target_swap_slot=self.target_swap_slot,
            traffic_manager_host_names=self.traffic_manager_host_names,
            type=self.type,
            usage_state=self.usage_state)


def get_site_slot(name: Optional[str] = None,
                  properties_to_include: Optional[str] = None,
                  resource_group_name: Optional[str] = None,
                  slot: Optional[str] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSiteSlotResult:
    """
    Represents a web app


    :param str name: Name of web app
    :param str properties_to_include: Additional web app properties included in the response
    :param str resource_group_name: Name of resource group
    :param str slot: Name of web app slot. If not specified then will default to production slot.
    """
    pulumi.log.warn("""get_site_slot is deprecated: Version 2015-08-01 will be removed in v2 of the provider.""")
    __args__ = dict()
    __args__['name'] = name
    __args__['propertiesToInclude'] = properties_to_include
    __args__['resourceGroupName'] = resource_group_name
    __args__['slot'] = slot
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('azure-native:web/v20150801:getSiteSlot', __args__, opts=opts, typ=GetSiteSlotResult).value

    return AwaitableGetSiteSlotResult(
        availability_state=__ret__.availability_state,
        client_affinity_enabled=__ret__.client_affinity_enabled,
        client_cert_enabled=__ret__.client_cert_enabled,
        cloning_info=__ret__.cloning_info,
        container_size=__ret__.container_size,
        default_host_name=__ret__.default_host_name,
        enabled=__ret__.enabled,
        enabled_host_names=__ret__.enabled_host_names,
        gateway_site_name=__ret__.gateway_site_name,
        host_name_ssl_states=__ret__.host_name_ssl_states,
        host_names=__ret__.host_names,
        host_names_disabled=__ret__.host_names_disabled,
        hosting_environment_profile=__ret__.hosting_environment_profile,
        id=__ret__.id,
        is_default_container=__ret__.is_default_container,
        kind=__ret__.kind,
        last_modified_time_utc=__ret__.last_modified_time_utc,
        location=__ret__.location,
        max_number_of_workers=__ret__.max_number_of_workers,
        micro_service=__ret__.micro_service,
        name=__ret__.name,
        outbound_ip_addresses=__ret__.outbound_ip_addresses,
        premium_app_deployed=__ret__.premium_app_deployed,
        repository_site_name=__ret__.repository_site_name,
        resource_group=__ret__.resource_group,
        scm_site_also_stopped=__ret__.scm_site_also_stopped,
        server_farm_id=__ret__.server_farm_id,
        site_config=__ret__.site_config,
        state=__ret__.state,
        tags=__ret__.tags,
        target_swap_slot=__ret__.target_swap_slot,
        traffic_manager_host_names=__ret__.traffic_manager_host_names,
        type=__ret__.type,
        usage_state=__ret__.usage_state)


@_utilities.lift_output_func(get_site_slot)
def get_site_slot_output(name: Optional[pulumi.Input[str]] = None,
                         properties_to_include: Optional[pulumi.Input[Optional[str]]] = None,
                         resource_group_name: Optional[pulumi.Input[str]] = None,
                         slot: Optional[pulumi.Input[str]] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetSiteSlotResult]:
    """
    Represents a web app


    :param str name: Name of web app
    :param str properties_to_include: Additional web app properties included in the response
    :param str resource_group_name: Name of resource group
    :param str slot: Name of web app slot. If not specified then will default to production slot.
    """
    pulumi.log.warn("""get_site_slot is deprecated: Version 2015-08-01 will be removed in v2 of the provider.""")
    ...
