# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'AacAudioArgs',
    'AbsoluteClipTimeArgs',
    'AccessControlArgs',
    'AccountEncryptionArgs',
    'AkamaiAccessControlArgs',
    'AkamaiSignatureHeaderAuthenticationKeyArgs',
    'ArmStreamingEndpointCurrentSkuArgs',
    'AudioAnalyzerPresetArgs',
    'AudioOverlayArgs',
    'AudioTrackDescriptorArgs',
    'AudioTrackArgs',
    'AudioArgs',
    'BuiltInStandardEncoderPresetArgs',
    'CbcsDrmConfigurationArgs',
    'CencDrmConfigurationArgs',
    'CommonEncryptionCbcsArgs',
    'CommonEncryptionCencArgs',
    'ContentKeyPolicyClearKeyConfigurationArgs',
    'ContentKeyPolicyFairPlayConfigurationArgs',
    'ContentKeyPolicyFairPlayOfflineRentalConfigurationArgs',
    'ContentKeyPolicyOpenRestrictionArgs',
    'ContentKeyPolicyOptionArgs',
    'ContentKeyPolicyPlayReadyConfigurationArgs',
    'ContentKeyPolicyPlayReadyContentEncryptionKeyFromHeaderArgs',
    'ContentKeyPolicyPlayReadyContentEncryptionKeyFromKeyIdentifierArgs',
    'ContentKeyPolicyPlayReadyExplicitAnalogTelevisionRestrictionArgs',
    'ContentKeyPolicyPlayReadyLicenseArgs',
    'ContentKeyPolicyPlayReadyPlayRightArgs',
    'ContentKeyPolicyRsaTokenKeyArgs',
    'ContentKeyPolicySymmetricTokenKeyArgs',
    'ContentKeyPolicyTokenClaimArgs',
    'ContentKeyPolicyTokenRestrictionArgs',
    'ContentKeyPolicyUnknownConfigurationArgs',
    'ContentKeyPolicyUnknownRestrictionArgs',
    'ContentKeyPolicyWidevineConfigurationArgs',
    'ContentKeyPolicyX509CertificateTokenKeyArgs',
    'CopyAudioArgs',
    'CopyVideoArgs',
    'CrossSiteAccessPoliciesArgs',
    'DefaultKeyArgs',
    'DeinterlaceArgs',
    'EnabledProtocolsArgs',
    'EnvelopeEncryptionArgs',
    'FaceDetectorPresetArgs',
    'FilterTrackPropertyConditionArgs',
    'FilterTrackSelectionArgs',
    'FiltersArgs',
    'FirstQualityArgs',
    'FromAllInputFileArgs',
    'FromEachInputFileArgs',
    'H264LayerArgs',
    'H264VideoArgs',
    'H265LayerArgs',
    'H265VideoArgs',
    'HlsSettingsArgs',
    'HlsArgs',
    'IPAccessControlArgs',
    'IPRangeArgs',
    'ImageFormatArgs',
    'ImageArgs',
    'InputFileArgs',
    'JobInputAssetArgs',
    'JobInputClipArgs',
    'JobInputHttpArgs',
    'JobInputSequenceArgs',
    'JobInputsArgs',
    'JobOutputAssetArgs',
    'JpgFormatArgs',
    'JpgImageArgs',
    'JpgLayerArgs',
    'KeyDeliveryArgs',
    'KeyVaultPropertiesArgs',
    'LiveEventEncodingArgs',
    'LiveEventEndpointArgs',
    'LiveEventInputAccessControlArgs',
    'LiveEventInputTrackSelectionArgs',
    'LiveEventInputArgs',
    'LiveEventOutputTranscriptionTrackArgs',
    'LiveEventPreviewAccessControlArgs',
    'LiveEventPreviewArgs',
    'LiveEventTranscriptionArgs',
    'MediaServiceIdentityArgs',
    'Mp4FormatArgs',
    'MultiBitrateFormatArgs',
    'NoEncryptionArgs',
    'OutputFileArgs',
    'PngFormatArgs',
    'PngImageArgs',
    'PngLayerArgs',
    'PresentationTimeRangeArgs',
    'PresetConfigurationsArgs',
    'PrivateLinkServiceConnectionStateArgs',
    'RectangleArgs',
    'ResourceIdentityArgs',
    'SelectAudioTrackByAttributeArgs',
    'SelectAudioTrackByIdArgs',
    'SelectVideoTrackByAttributeArgs',
    'SelectVideoTrackByIdArgs',
    'StandardEncoderPresetArgs',
    'StorageAccountArgs',
    'StreamingEndpointAccessControlArgs',
    'StreamingLocatorContentKeyArgs',
    'StreamingPolicyContentKeysArgs',
    'StreamingPolicyContentKeyArgs',
    'StreamingPolicyFairPlayConfigurationArgs',
    'StreamingPolicyPlayReadyConfigurationArgs',
    'StreamingPolicyWidevineConfigurationArgs',
    'TextTrackArgs',
    'TrackPropertyConditionArgs',
    'TrackSelectionArgs',
    'TransformOutputArgs',
    'TransportStreamFormatArgs',
    'UtcClipTimeArgs',
    'VideoAnalyzerPresetArgs',
    'VideoOverlayArgs',
    'VideoTrackDescriptorArgs',
    'VideoTrackArgs',
    'VideoArgs',
]

@pulumi.input_type
class AacAudioArgs:
    def __init__(__self__, *,
                 odata_type: pulumi.Input[str],
                 bitrate: Optional[pulumi.Input[int]] = None,
                 channels: Optional[pulumi.Input[int]] = None,
                 label: Optional[pulumi.Input[str]] = None,
                 profile: Optional[pulumi.Input[Union[str, 'AacAudioProfile']]] = None,
                 sampling_rate: Optional[pulumi.Input[int]] = None):
        """
        Describes Advanced Audio Codec (AAC) audio encoding settings.
        :param pulumi.Input[str] odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.AacAudio'.
        :param pulumi.Input[int] bitrate: The bitrate, in bits per second, of the output encoded audio.
        :param pulumi.Input[int] channels: The number of channels in the audio.
        :param pulumi.Input[str] label: An optional label for the codec. The label can be used to control muxing behavior.
        :param pulumi.Input[Union[str, 'AacAudioProfile']] profile: The encoding profile to be used when encoding audio with AAC.
        :param pulumi.Input[int] sampling_rate: The sampling rate to use for encoding in hertz.
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.AacAudio')
        if bitrate is not None:
            pulumi.set(__self__, "bitrate", bitrate)
        if channels is not None:
            pulumi.set(__self__, "channels", channels)
        if label is not None:
            pulumi.set(__self__, "label", label)
        if profile is not None:
            pulumi.set(__self__, "profile", profile)
        if sampling_rate is not None:
            pulumi.set(__self__, "sampling_rate", sampling_rate)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> pulumi.Input[str]:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.AacAudio'.
        """
        return pulumi.get(self, "odata_type")

    @odata_type.setter
    def odata_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "odata_type", value)

    @property
    @pulumi.getter
    def bitrate(self) -> Optional[pulumi.Input[int]]:
        """
        The bitrate, in bits per second, of the output encoded audio.
        """
        return pulumi.get(self, "bitrate")

    @bitrate.setter
    def bitrate(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "bitrate", value)

    @property
    @pulumi.getter
    def channels(self) -> Optional[pulumi.Input[int]]:
        """
        The number of channels in the audio.
        """
        return pulumi.get(self, "channels")

    @channels.setter
    def channels(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "channels", value)

    @property
    @pulumi.getter
    def label(self) -> Optional[pulumi.Input[str]]:
        """
        An optional label for the codec. The label can be used to control muxing behavior.
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "label", value)

    @property
    @pulumi.getter
    def profile(self) -> Optional[pulumi.Input[Union[str, 'AacAudioProfile']]]:
        """
        The encoding profile to be used when encoding audio with AAC.
        """
        return pulumi.get(self, "profile")

    @profile.setter
    def profile(self, value: Optional[pulumi.Input[Union[str, 'AacAudioProfile']]]):
        pulumi.set(self, "profile", value)

    @property
    @pulumi.getter(name="samplingRate")
    def sampling_rate(self) -> Optional[pulumi.Input[int]]:
        """
        The sampling rate to use for encoding in hertz.
        """
        return pulumi.get(self, "sampling_rate")

    @sampling_rate.setter
    def sampling_rate(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "sampling_rate", value)


@pulumi.input_type
class AbsoluteClipTimeArgs:
    def __init__(__self__, *,
                 odata_type: pulumi.Input[str],
                 time: pulumi.Input[str]):
        """
        Specifies the clip time as an absolute time position in the media file.  The absolute time can point to a different position depending on whether the media file starts from a timestamp of zero or not.
        :param pulumi.Input[str] odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.AbsoluteClipTime'.
        :param pulumi.Input[str] time: The time position on the timeline of the input media. It is usually specified as an ISO8601 period. e.g PT30S for 30 seconds.
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.AbsoluteClipTime')
        pulumi.set(__self__, "time", time)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> pulumi.Input[str]:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.AbsoluteClipTime'.
        """
        return pulumi.get(self, "odata_type")

    @odata_type.setter
    def odata_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "odata_type", value)

    @property
    @pulumi.getter
    def time(self) -> pulumi.Input[str]:
        """
        The time position on the timeline of the input media. It is usually specified as an ISO8601 period. e.g PT30S for 30 seconds.
        """
        return pulumi.get(self, "time")

    @time.setter
    def time(self, value: pulumi.Input[str]):
        pulumi.set(self, "time", value)


@pulumi.input_type
class AccessControlArgs:
    def __init__(__self__, *,
                 default_action: Optional[pulumi.Input[Union[str, 'DefaultAction']]] = None,
                 ip_allow_list: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[Union[str, 'DefaultAction']] default_action: The behavior for IP access control in Key Delivery.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ip_allow_list: The IP allow list for access control in Key Delivery. If the default action is set to 'Allow', the IP allow list must be empty.
        """
        if default_action is not None:
            pulumi.set(__self__, "default_action", default_action)
        if ip_allow_list is not None:
            pulumi.set(__self__, "ip_allow_list", ip_allow_list)

    @property
    @pulumi.getter(name="defaultAction")
    def default_action(self) -> Optional[pulumi.Input[Union[str, 'DefaultAction']]]:
        """
        The behavior for IP access control in Key Delivery.
        """
        return pulumi.get(self, "default_action")

    @default_action.setter
    def default_action(self, value: Optional[pulumi.Input[Union[str, 'DefaultAction']]]):
        pulumi.set(self, "default_action", value)

    @property
    @pulumi.getter(name="ipAllowList")
    def ip_allow_list(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The IP allow list for access control in Key Delivery. If the default action is set to 'Allow', the IP allow list must be empty.
        """
        return pulumi.get(self, "ip_allow_list")

    @ip_allow_list.setter
    def ip_allow_list(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "ip_allow_list", value)


@pulumi.input_type
class AccountEncryptionArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[Union[str, 'AccountEncryptionKeyType']],
                 identity: Optional[pulumi.Input['ResourceIdentityArgs']] = None,
                 key_vault_properties: Optional[pulumi.Input['KeyVaultPropertiesArgs']] = None):
        """
        :param pulumi.Input[Union[str, 'AccountEncryptionKeyType']] type: The type of key used to encrypt the Account Key.
        :param pulumi.Input['ResourceIdentityArgs'] identity: The Key Vault identity.
        :param pulumi.Input['KeyVaultPropertiesArgs'] key_vault_properties: The properties of the key used to encrypt the account.
        """
        pulumi.set(__self__, "type", type)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if key_vault_properties is not None:
            pulumi.set(__self__, "key_vault_properties", key_vault_properties)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[Union[str, 'AccountEncryptionKeyType']]:
        """
        The type of key used to encrypt the Account Key.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[Union[str, 'AccountEncryptionKeyType']]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['ResourceIdentityArgs']]:
        """
        The Key Vault identity.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['ResourceIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @property
    @pulumi.getter(name="keyVaultProperties")
    def key_vault_properties(self) -> Optional[pulumi.Input['KeyVaultPropertiesArgs']]:
        """
        The properties of the key used to encrypt the account.
        """
        return pulumi.get(self, "key_vault_properties")

    @key_vault_properties.setter
    def key_vault_properties(self, value: Optional[pulumi.Input['KeyVaultPropertiesArgs']]):
        pulumi.set(self, "key_vault_properties", value)


@pulumi.input_type
class AkamaiAccessControlArgs:
    def __init__(__self__, *,
                 akamai_signature_header_authentication_key_list: Optional[pulumi.Input[Sequence[pulumi.Input['AkamaiSignatureHeaderAuthenticationKeyArgs']]]] = None):
        """
        Akamai access control
        :param pulumi.Input[Sequence[pulumi.Input['AkamaiSignatureHeaderAuthenticationKeyArgs']]] akamai_signature_header_authentication_key_list: authentication key list
        """
        if akamai_signature_header_authentication_key_list is not None:
            pulumi.set(__self__, "akamai_signature_header_authentication_key_list", akamai_signature_header_authentication_key_list)

    @property
    @pulumi.getter(name="akamaiSignatureHeaderAuthenticationKeyList")
    def akamai_signature_header_authentication_key_list(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AkamaiSignatureHeaderAuthenticationKeyArgs']]]]:
        """
        authentication key list
        """
        return pulumi.get(self, "akamai_signature_header_authentication_key_list")

    @akamai_signature_header_authentication_key_list.setter
    def akamai_signature_header_authentication_key_list(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AkamaiSignatureHeaderAuthenticationKeyArgs']]]]):
        pulumi.set(self, "akamai_signature_header_authentication_key_list", value)


@pulumi.input_type
class AkamaiSignatureHeaderAuthenticationKeyArgs:
    def __init__(__self__, *,
                 base64_key: Optional[pulumi.Input[str]] = None,
                 expiration: Optional[pulumi.Input[str]] = None,
                 identifier: Optional[pulumi.Input[str]] = None):
        """
        Akamai Signature Header authentication key.
        :param pulumi.Input[str] base64_key: authentication key
        :param pulumi.Input[str] expiration: The expiration time of the authentication key.
        :param pulumi.Input[str] identifier: identifier of the key
        """
        if base64_key is not None:
            pulumi.set(__self__, "base64_key", base64_key)
        if expiration is not None:
            pulumi.set(__self__, "expiration", expiration)
        if identifier is not None:
            pulumi.set(__self__, "identifier", identifier)

    @property
    @pulumi.getter(name="base64Key")
    def base64_key(self) -> Optional[pulumi.Input[str]]:
        """
        authentication key
        """
        return pulumi.get(self, "base64_key")

    @base64_key.setter
    def base64_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "base64_key", value)

    @property
    @pulumi.getter
    def expiration(self) -> Optional[pulumi.Input[str]]:
        """
        The expiration time of the authentication key.
        """
        return pulumi.get(self, "expiration")

    @expiration.setter
    def expiration(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expiration", value)

    @property
    @pulumi.getter
    def identifier(self) -> Optional[pulumi.Input[str]]:
        """
        identifier of the key
        """
        return pulumi.get(self, "identifier")

    @identifier.setter
    def identifier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "identifier", value)


@pulumi.input_type
class ArmStreamingEndpointCurrentSkuArgs:
    def __init__(__self__, *,
                 capacity: Optional[pulumi.Input[int]] = None):
        """
        The streaming endpoint current sku.
        :param pulumi.Input[int] capacity: The streaming endpoint sku capacity.
        """
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)

    @property
    @pulumi.getter
    def capacity(self) -> Optional[pulumi.Input[int]]:
        """
        The streaming endpoint sku capacity.
        """
        return pulumi.get(self, "capacity")

    @capacity.setter
    def capacity(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "capacity", value)


@pulumi.input_type
class AudioAnalyzerPresetArgs:
    def __init__(__self__, *,
                 odata_type: pulumi.Input[str],
                 audio_language: Optional[pulumi.Input[str]] = None,
                 experimental_options: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 mode: Optional[pulumi.Input[Union[str, 'AudioAnalysisMode']]] = None):
        """
        The Audio Analyzer preset applies a pre-defined set of AI-based analysis operations, including speech transcription. Currently, the preset supports processing of content with a single audio track.
        :param pulumi.Input[str] odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.AudioAnalyzerPreset'.
        :param pulumi.Input[str] audio_language: The language for the audio payload in the input using the BCP-47 format of 'language tag-region' (e.g: 'en-US').  If you know the language of your content, it is recommended that you specify it. The language must be specified explicitly for AudioAnalysisMode::Basic, since automatic language detection is not included in basic mode. If the language isn't specified or set to null, automatic language detection will choose the first language detected and process with the selected language for the duration of the file. It does not currently support dynamically switching between languages after the first language is detected. The automatic detection works best with audio recordings with clearly discernable speech. If automatic detection fails to find the language, transcription would fallback to 'en-US'." The list of supported languages is available here: https://go.microsoft.com/fwlink/?linkid=2109463
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] experimental_options: Dictionary containing key value pairs for parameters not exposed in the preset itself
        :param pulumi.Input[Union[str, 'AudioAnalysisMode']] mode: Determines the set of audio analysis operations to be performed. If unspecified, the Standard AudioAnalysisMode would be chosen.
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.AudioAnalyzerPreset')
        if audio_language is not None:
            pulumi.set(__self__, "audio_language", audio_language)
        if experimental_options is not None:
            pulumi.set(__self__, "experimental_options", experimental_options)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> pulumi.Input[str]:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.AudioAnalyzerPreset'.
        """
        return pulumi.get(self, "odata_type")

    @odata_type.setter
    def odata_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "odata_type", value)

    @property
    @pulumi.getter(name="audioLanguage")
    def audio_language(self) -> Optional[pulumi.Input[str]]:
        """
        The language for the audio payload in the input using the BCP-47 format of 'language tag-region' (e.g: 'en-US').  If you know the language of your content, it is recommended that you specify it. The language must be specified explicitly for AudioAnalysisMode::Basic, since automatic language detection is not included in basic mode. If the language isn't specified or set to null, automatic language detection will choose the first language detected and process with the selected language for the duration of the file. It does not currently support dynamically switching between languages after the first language is detected. The automatic detection works best with audio recordings with clearly discernable speech. If automatic detection fails to find the language, transcription would fallback to 'en-US'." The list of supported languages is available here: https://go.microsoft.com/fwlink/?linkid=2109463
        """
        return pulumi.get(self, "audio_language")

    @audio_language.setter
    def audio_language(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "audio_language", value)

    @property
    @pulumi.getter(name="experimentalOptions")
    def experimental_options(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Dictionary containing key value pairs for parameters not exposed in the preset itself
        """
        return pulumi.get(self, "experimental_options")

    @experimental_options.setter
    def experimental_options(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "experimental_options", value)

    @property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input[Union[str, 'AudioAnalysisMode']]]:
        """
        Determines the set of audio analysis operations to be performed. If unspecified, the Standard AudioAnalysisMode would be chosen.
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input[Union[str, 'AudioAnalysisMode']]]):
        pulumi.set(self, "mode", value)


@pulumi.input_type
class AudioOverlayArgs:
    def __init__(__self__, *,
                 input_label: pulumi.Input[str],
                 odata_type: pulumi.Input[str],
                 audio_gain_level: Optional[pulumi.Input[float]] = None,
                 end: Optional[pulumi.Input[str]] = None,
                 fade_in_duration: Optional[pulumi.Input[str]] = None,
                 fade_out_duration: Optional[pulumi.Input[str]] = None,
                 start: Optional[pulumi.Input[str]] = None):
        """
        Describes the properties of an audio overlay.
        :param pulumi.Input[str] input_label: The label of the job input which is to be used as an overlay. The Input must specify exactly one file. You can specify an image file in JPG, PNG, GIF or BMP format, or an audio file (such as a WAV, MP3, WMA or M4A file), or a video file. See https://aka.ms/mesformats for the complete list of supported audio and video file formats.
        :param pulumi.Input[str] odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.AudioOverlay'.
        :param pulumi.Input[float] audio_gain_level: The gain level of audio in the overlay. The value should be in the range [0, 1.0]. The default is 1.0.
        :param pulumi.Input[str] end: The end position, with reference to the input video, at which the overlay ends. The value should be in ISO 8601 format. For example, PT30S to end the overlay at 30 seconds into the input video. If not specified or the value is greater than the input video duration, the overlay will be applied until the end of the input video if the overlay media duration is greater than the input video duration, else the overlay will last as long as the overlay media duration.
        :param pulumi.Input[str] fade_in_duration: The duration over which the overlay fades in onto the input video. The value should be in ISO 8601 duration format. If not specified the default behavior is to have no fade in (same as PT0S).
        :param pulumi.Input[str] fade_out_duration: The duration over which the overlay fades out of the input video. The value should be in ISO 8601 duration format. If not specified the default behavior is to have no fade out (same as PT0S).
        :param pulumi.Input[str] start: The start position, with reference to the input video, at which the overlay starts. The value should be in ISO 8601 format. For example, PT05S to start the overlay at 5 seconds into the input video. If not specified the overlay starts from the beginning of the input video.
        """
        pulumi.set(__self__, "input_label", input_label)
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.AudioOverlay')
        if audio_gain_level is not None:
            pulumi.set(__self__, "audio_gain_level", audio_gain_level)
        if end is not None:
            pulumi.set(__self__, "end", end)
        if fade_in_duration is not None:
            pulumi.set(__self__, "fade_in_duration", fade_in_duration)
        if fade_out_duration is not None:
            pulumi.set(__self__, "fade_out_duration", fade_out_duration)
        if start is not None:
            pulumi.set(__self__, "start", start)

    @property
    @pulumi.getter(name="inputLabel")
    def input_label(self) -> pulumi.Input[str]:
        """
        The label of the job input which is to be used as an overlay. The Input must specify exactly one file. You can specify an image file in JPG, PNG, GIF or BMP format, or an audio file (such as a WAV, MP3, WMA or M4A file), or a video file. See https://aka.ms/mesformats for the complete list of supported audio and video file formats.
        """
        return pulumi.get(self, "input_label")

    @input_label.setter
    def input_label(self, value: pulumi.Input[str]):
        pulumi.set(self, "input_label", value)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> pulumi.Input[str]:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.AudioOverlay'.
        """
        return pulumi.get(self, "odata_type")

    @odata_type.setter
    def odata_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "odata_type", value)

    @property
    @pulumi.getter(name="audioGainLevel")
    def audio_gain_level(self) -> Optional[pulumi.Input[float]]:
        """
        The gain level of audio in the overlay. The value should be in the range [0, 1.0]. The default is 1.0.
        """
        return pulumi.get(self, "audio_gain_level")

    @audio_gain_level.setter
    def audio_gain_level(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "audio_gain_level", value)

    @property
    @pulumi.getter
    def end(self) -> Optional[pulumi.Input[str]]:
        """
        The end position, with reference to the input video, at which the overlay ends. The value should be in ISO 8601 format. For example, PT30S to end the overlay at 30 seconds into the input video. If not specified or the value is greater than the input video duration, the overlay will be applied until the end of the input video if the overlay media duration is greater than the input video duration, else the overlay will last as long as the overlay media duration.
        """
        return pulumi.get(self, "end")

    @end.setter
    def end(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "end", value)

    @property
    @pulumi.getter(name="fadeInDuration")
    def fade_in_duration(self) -> Optional[pulumi.Input[str]]:
        """
        The duration over which the overlay fades in onto the input video. The value should be in ISO 8601 duration format. If not specified the default behavior is to have no fade in (same as PT0S).
        """
        return pulumi.get(self, "fade_in_duration")

    @fade_in_duration.setter
    def fade_in_duration(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fade_in_duration", value)

    @property
    @pulumi.getter(name="fadeOutDuration")
    def fade_out_duration(self) -> Optional[pulumi.Input[str]]:
        """
        The duration over which the overlay fades out of the input video. The value should be in ISO 8601 duration format. If not specified the default behavior is to have no fade out (same as PT0S).
        """
        return pulumi.get(self, "fade_out_duration")

    @fade_out_duration.setter
    def fade_out_duration(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fade_out_duration", value)

    @property
    @pulumi.getter
    def start(self) -> Optional[pulumi.Input[str]]:
        """
        The start position, with reference to the input video, at which the overlay starts. The value should be in ISO 8601 format. For example, PT05S to start the overlay at 5 seconds into the input video. If not specified the overlay starts from the beginning of the input video.
        """
        return pulumi.get(self, "start")

    @start.setter
    def start(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "start", value)


@pulumi.input_type
class AudioTrackDescriptorArgs:
    def __init__(__self__, *,
                 odata_type: pulumi.Input[str],
                 channel_mapping: Optional[pulumi.Input[Union[str, 'ChannelMapping']]] = None):
        """
        A TrackSelection to select audio tracks.
        :param pulumi.Input[str] odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.AudioTrackDescriptor'.
        :param pulumi.Input[Union[str, 'ChannelMapping']] channel_mapping: Optional designation for single channel audio tracks.  Can be used to combine the tracks into stereo or multi-channel audio tracks.
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.AudioTrackDescriptor')
        if channel_mapping is not None:
            pulumi.set(__self__, "channel_mapping", channel_mapping)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> pulumi.Input[str]:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.AudioTrackDescriptor'.
        """
        return pulumi.get(self, "odata_type")

    @odata_type.setter
    def odata_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "odata_type", value)

    @property
    @pulumi.getter(name="channelMapping")
    def channel_mapping(self) -> Optional[pulumi.Input[Union[str, 'ChannelMapping']]]:
        """
        Optional designation for single channel audio tracks.  Can be used to combine the tracks into stereo or multi-channel audio tracks.
        """
        return pulumi.get(self, "channel_mapping")

    @channel_mapping.setter
    def channel_mapping(self, value: Optional[pulumi.Input[Union[str, 'ChannelMapping']]]):
        pulumi.set(self, "channel_mapping", value)


@pulumi.input_type
class AudioTrackArgs:
    def __init__(__self__, *,
                 odata_type: pulumi.Input[str]):
        """
        Represents an audio track in the asset.
        :param pulumi.Input[str] odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.AudioTrack'.
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.AudioTrack')

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> pulumi.Input[str]:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.AudioTrack'.
        """
        return pulumi.get(self, "odata_type")

    @odata_type.setter
    def odata_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "odata_type", value)


@pulumi.input_type
class AudioArgs:
    def __init__(__self__, *,
                 odata_type: pulumi.Input[str],
                 bitrate: Optional[pulumi.Input[int]] = None,
                 channels: Optional[pulumi.Input[int]] = None,
                 label: Optional[pulumi.Input[str]] = None,
                 sampling_rate: Optional[pulumi.Input[int]] = None):
        """
        Defines the common properties for all audio codecs.
        :param pulumi.Input[str] odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.Audio'.
        :param pulumi.Input[int] bitrate: The bitrate, in bits per second, of the output encoded audio.
        :param pulumi.Input[int] channels: The number of channels in the audio.
        :param pulumi.Input[str] label: An optional label for the codec. The label can be used to control muxing behavior.
        :param pulumi.Input[int] sampling_rate: The sampling rate to use for encoding in hertz.
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.Audio')
        if bitrate is not None:
            pulumi.set(__self__, "bitrate", bitrate)
        if channels is not None:
            pulumi.set(__self__, "channels", channels)
        if label is not None:
            pulumi.set(__self__, "label", label)
        if sampling_rate is not None:
            pulumi.set(__self__, "sampling_rate", sampling_rate)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> pulumi.Input[str]:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.Audio'.
        """
        return pulumi.get(self, "odata_type")

    @odata_type.setter
    def odata_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "odata_type", value)

    @property
    @pulumi.getter
    def bitrate(self) -> Optional[pulumi.Input[int]]:
        """
        The bitrate, in bits per second, of the output encoded audio.
        """
        return pulumi.get(self, "bitrate")

    @bitrate.setter
    def bitrate(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "bitrate", value)

    @property
    @pulumi.getter
    def channels(self) -> Optional[pulumi.Input[int]]:
        """
        The number of channels in the audio.
        """
        return pulumi.get(self, "channels")

    @channels.setter
    def channels(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "channels", value)

    @property
    @pulumi.getter
    def label(self) -> Optional[pulumi.Input[str]]:
        """
        An optional label for the codec. The label can be used to control muxing behavior.
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "label", value)

    @property
    @pulumi.getter(name="samplingRate")
    def sampling_rate(self) -> Optional[pulumi.Input[int]]:
        """
        The sampling rate to use for encoding in hertz.
        """
        return pulumi.get(self, "sampling_rate")

    @sampling_rate.setter
    def sampling_rate(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "sampling_rate", value)


@pulumi.input_type
class BuiltInStandardEncoderPresetArgs:
    def __init__(__self__, *,
                 odata_type: pulumi.Input[str],
                 preset_name: pulumi.Input[Union[str, 'EncoderNamedPreset']],
                 configurations: Optional[pulumi.Input['PresetConfigurationsArgs']] = None):
        """
        Describes a built-in preset for encoding the input video with the Standard Encoder.
        :param pulumi.Input[str] odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.BuiltInStandardEncoderPreset'.
        :param pulumi.Input[Union[str, 'EncoderNamedPreset']] preset_name: The built-in preset to be used for encoding videos.
        :param pulumi.Input['PresetConfigurationsArgs'] configurations: Optional configuration settings for encoder. Configurations is only supported for ContentAwareEncoding and H265ContentAwareEncoding BuiltInStandardEncoderPreset.
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.BuiltInStandardEncoderPreset')
        pulumi.set(__self__, "preset_name", preset_name)
        if configurations is not None:
            pulumi.set(__self__, "configurations", configurations)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> pulumi.Input[str]:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.BuiltInStandardEncoderPreset'.
        """
        return pulumi.get(self, "odata_type")

    @odata_type.setter
    def odata_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "odata_type", value)

    @property
    @pulumi.getter(name="presetName")
    def preset_name(self) -> pulumi.Input[Union[str, 'EncoderNamedPreset']]:
        """
        The built-in preset to be used for encoding videos.
        """
        return pulumi.get(self, "preset_name")

    @preset_name.setter
    def preset_name(self, value: pulumi.Input[Union[str, 'EncoderNamedPreset']]):
        pulumi.set(self, "preset_name", value)

    @property
    @pulumi.getter
    def configurations(self) -> Optional[pulumi.Input['PresetConfigurationsArgs']]:
        """
        Optional configuration settings for encoder. Configurations is only supported for ContentAwareEncoding and H265ContentAwareEncoding BuiltInStandardEncoderPreset.
        """
        return pulumi.get(self, "configurations")

    @configurations.setter
    def configurations(self, value: Optional[pulumi.Input['PresetConfigurationsArgs']]):
        pulumi.set(self, "configurations", value)


@pulumi.input_type
class CbcsDrmConfigurationArgs:
    def __init__(__self__, *,
                 fair_play: Optional[pulumi.Input['StreamingPolicyFairPlayConfigurationArgs']] = None,
                 play_ready: Optional[pulumi.Input['StreamingPolicyPlayReadyConfigurationArgs']] = None,
                 widevine: Optional[pulumi.Input['StreamingPolicyWidevineConfigurationArgs']] = None):
        """
        Class to specify DRM configurations of CommonEncryptionCbcs scheme in Streaming Policy
        :param pulumi.Input['StreamingPolicyFairPlayConfigurationArgs'] fair_play: FairPlay configurations
        :param pulumi.Input['StreamingPolicyPlayReadyConfigurationArgs'] play_ready: PlayReady configurations
        :param pulumi.Input['StreamingPolicyWidevineConfigurationArgs'] widevine: Widevine configurations
        """
        if fair_play is not None:
            pulumi.set(__self__, "fair_play", fair_play)
        if play_ready is not None:
            pulumi.set(__self__, "play_ready", play_ready)
        if widevine is not None:
            pulumi.set(__self__, "widevine", widevine)

    @property
    @pulumi.getter(name="fairPlay")
    def fair_play(self) -> Optional[pulumi.Input['StreamingPolicyFairPlayConfigurationArgs']]:
        """
        FairPlay configurations
        """
        return pulumi.get(self, "fair_play")

    @fair_play.setter
    def fair_play(self, value: Optional[pulumi.Input['StreamingPolicyFairPlayConfigurationArgs']]):
        pulumi.set(self, "fair_play", value)

    @property
    @pulumi.getter(name="playReady")
    def play_ready(self) -> Optional[pulumi.Input['StreamingPolicyPlayReadyConfigurationArgs']]:
        """
        PlayReady configurations
        """
        return pulumi.get(self, "play_ready")

    @play_ready.setter
    def play_ready(self, value: Optional[pulumi.Input['StreamingPolicyPlayReadyConfigurationArgs']]):
        pulumi.set(self, "play_ready", value)

    @property
    @pulumi.getter
    def widevine(self) -> Optional[pulumi.Input['StreamingPolicyWidevineConfigurationArgs']]:
        """
        Widevine configurations
        """
        return pulumi.get(self, "widevine")

    @widevine.setter
    def widevine(self, value: Optional[pulumi.Input['StreamingPolicyWidevineConfigurationArgs']]):
        pulumi.set(self, "widevine", value)


@pulumi.input_type
class CencDrmConfigurationArgs:
    def __init__(__self__, *,
                 play_ready: Optional[pulumi.Input['StreamingPolicyPlayReadyConfigurationArgs']] = None,
                 widevine: Optional[pulumi.Input['StreamingPolicyWidevineConfigurationArgs']] = None):
        """
        Class to specify DRM configurations of CommonEncryptionCenc scheme in Streaming Policy
        :param pulumi.Input['StreamingPolicyPlayReadyConfigurationArgs'] play_ready: PlayReady configurations
        :param pulumi.Input['StreamingPolicyWidevineConfigurationArgs'] widevine: Widevine configurations
        """
        if play_ready is not None:
            pulumi.set(__self__, "play_ready", play_ready)
        if widevine is not None:
            pulumi.set(__self__, "widevine", widevine)

    @property
    @pulumi.getter(name="playReady")
    def play_ready(self) -> Optional[pulumi.Input['StreamingPolicyPlayReadyConfigurationArgs']]:
        """
        PlayReady configurations
        """
        return pulumi.get(self, "play_ready")

    @play_ready.setter
    def play_ready(self, value: Optional[pulumi.Input['StreamingPolicyPlayReadyConfigurationArgs']]):
        pulumi.set(self, "play_ready", value)

    @property
    @pulumi.getter
    def widevine(self) -> Optional[pulumi.Input['StreamingPolicyWidevineConfigurationArgs']]:
        """
        Widevine configurations
        """
        return pulumi.get(self, "widevine")

    @widevine.setter
    def widevine(self, value: Optional[pulumi.Input['StreamingPolicyWidevineConfigurationArgs']]):
        pulumi.set(self, "widevine", value)


@pulumi.input_type
class CommonEncryptionCbcsArgs:
    def __init__(__self__, *,
                 clear_tracks: Optional[pulumi.Input[Sequence[pulumi.Input['TrackSelectionArgs']]]] = None,
                 content_keys: Optional[pulumi.Input['StreamingPolicyContentKeysArgs']] = None,
                 drm: Optional[pulumi.Input['CbcsDrmConfigurationArgs']] = None,
                 enabled_protocols: Optional[pulumi.Input['EnabledProtocolsArgs']] = None):
        """
        Class for CommonEncryptionCbcs encryption scheme
        :param pulumi.Input[Sequence[pulumi.Input['TrackSelectionArgs']]] clear_tracks: Representing which tracks should not be encrypted
        :param pulumi.Input['StreamingPolicyContentKeysArgs'] content_keys: Representing default content key for each encryption scheme and separate content keys for specific tracks
        :param pulumi.Input['CbcsDrmConfigurationArgs'] drm: Configuration of DRMs for current encryption scheme
        :param pulumi.Input['EnabledProtocolsArgs'] enabled_protocols: Representing supported protocols
        """
        if clear_tracks is not None:
            pulumi.set(__self__, "clear_tracks", clear_tracks)
        if content_keys is not None:
            pulumi.set(__self__, "content_keys", content_keys)
        if drm is not None:
            pulumi.set(__self__, "drm", drm)
        if enabled_protocols is not None:
            pulumi.set(__self__, "enabled_protocols", enabled_protocols)

    @property
    @pulumi.getter(name="clearTracks")
    def clear_tracks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TrackSelectionArgs']]]]:
        """
        Representing which tracks should not be encrypted
        """
        return pulumi.get(self, "clear_tracks")

    @clear_tracks.setter
    def clear_tracks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TrackSelectionArgs']]]]):
        pulumi.set(self, "clear_tracks", value)

    @property
    @pulumi.getter(name="contentKeys")
    def content_keys(self) -> Optional[pulumi.Input['StreamingPolicyContentKeysArgs']]:
        """
        Representing default content key for each encryption scheme and separate content keys for specific tracks
        """
        return pulumi.get(self, "content_keys")

    @content_keys.setter
    def content_keys(self, value: Optional[pulumi.Input['StreamingPolicyContentKeysArgs']]):
        pulumi.set(self, "content_keys", value)

    @property
    @pulumi.getter
    def drm(self) -> Optional[pulumi.Input['CbcsDrmConfigurationArgs']]:
        """
        Configuration of DRMs for current encryption scheme
        """
        return pulumi.get(self, "drm")

    @drm.setter
    def drm(self, value: Optional[pulumi.Input['CbcsDrmConfigurationArgs']]):
        pulumi.set(self, "drm", value)

    @property
    @pulumi.getter(name="enabledProtocols")
    def enabled_protocols(self) -> Optional[pulumi.Input['EnabledProtocolsArgs']]:
        """
        Representing supported protocols
        """
        return pulumi.get(self, "enabled_protocols")

    @enabled_protocols.setter
    def enabled_protocols(self, value: Optional[pulumi.Input['EnabledProtocolsArgs']]):
        pulumi.set(self, "enabled_protocols", value)


@pulumi.input_type
class CommonEncryptionCencArgs:
    def __init__(__self__, *,
                 clear_tracks: Optional[pulumi.Input[Sequence[pulumi.Input['TrackSelectionArgs']]]] = None,
                 content_keys: Optional[pulumi.Input['StreamingPolicyContentKeysArgs']] = None,
                 drm: Optional[pulumi.Input['CencDrmConfigurationArgs']] = None,
                 enabled_protocols: Optional[pulumi.Input['EnabledProtocolsArgs']] = None):
        """
        Class for envelope encryption scheme
        :param pulumi.Input[Sequence[pulumi.Input['TrackSelectionArgs']]] clear_tracks: Representing which tracks should not be encrypted
        :param pulumi.Input['StreamingPolicyContentKeysArgs'] content_keys: Representing default content key for each encryption scheme and separate content keys for specific tracks
        :param pulumi.Input['CencDrmConfigurationArgs'] drm: Configuration of DRMs for CommonEncryptionCenc encryption scheme
        :param pulumi.Input['EnabledProtocolsArgs'] enabled_protocols: Representing supported protocols
        """
        if clear_tracks is not None:
            pulumi.set(__self__, "clear_tracks", clear_tracks)
        if content_keys is not None:
            pulumi.set(__self__, "content_keys", content_keys)
        if drm is not None:
            pulumi.set(__self__, "drm", drm)
        if enabled_protocols is not None:
            pulumi.set(__self__, "enabled_protocols", enabled_protocols)

    @property
    @pulumi.getter(name="clearTracks")
    def clear_tracks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TrackSelectionArgs']]]]:
        """
        Representing which tracks should not be encrypted
        """
        return pulumi.get(self, "clear_tracks")

    @clear_tracks.setter
    def clear_tracks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TrackSelectionArgs']]]]):
        pulumi.set(self, "clear_tracks", value)

    @property
    @pulumi.getter(name="contentKeys")
    def content_keys(self) -> Optional[pulumi.Input['StreamingPolicyContentKeysArgs']]:
        """
        Representing default content key for each encryption scheme and separate content keys for specific tracks
        """
        return pulumi.get(self, "content_keys")

    @content_keys.setter
    def content_keys(self, value: Optional[pulumi.Input['StreamingPolicyContentKeysArgs']]):
        pulumi.set(self, "content_keys", value)

    @property
    @pulumi.getter
    def drm(self) -> Optional[pulumi.Input['CencDrmConfigurationArgs']]:
        """
        Configuration of DRMs for CommonEncryptionCenc encryption scheme
        """
        return pulumi.get(self, "drm")

    @drm.setter
    def drm(self, value: Optional[pulumi.Input['CencDrmConfigurationArgs']]):
        pulumi.set(self, "drm", value)

    @property
    @pulumi.getter(name="enabledProtocols")
    def enabled_protocols(self) -> Optional[pulumi.Input['EnabledProtocolsArgs']]:
        """
        Representing supported protocols
        """
        return pulumi.get(self, "enabled_protocols")

    @enabled_protocols.setter
    def enabled_protocols(self, value: Optional[pulumi.Input['EnabledProtocolsArgs']]):
        pulumi.set(self, "enabled_protocols", value)


@pulumi.input_type
class ContentKeyPolicyClearKeyConfigurationArgs:
    def __init__(__self__, *,
                 odata_type: pulumi.Input[str]):
        """
        Represents a configuration for non-DRM keys.
        :param pulumi.Input[str] odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.ContentKeyPolicyClearKeyConfiguration'.
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.ContentKeyPolicyClearKeyConfiguration')

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> pulumi.Input[str]:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.ContentKeyPolicyClearKeyConfiguration'.
        """
        return pulumi.get(self, "odata_type")

    @odata_type.setter
    def odata_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "odata_type", value)


@pulumi.input_type
class ContentKeyPolicyFairPlayConfigurationArgs:
    def __init__(__self__, *,
                 ask: pulumi.Input[str],
                 fair_play_pfx: pulumi.Input[str],
                 fair_play_pfx_password: pulumi.Input[str],
                 odata_type: pulumi.Input[str],
                 rental_and_lease_key_type: pulumi.Input[Union[str, 'ContentKeyPolicyFairPlayRentalAndLeaseKeyType']],
                 rental_duration: pulumi.Input[float],
                 offline_rental_configuration: Optional[pulumi.Input['ContentKeyPolicyFairPlayOfflineRentalConfigurationArgs']] = None):
        """
        Specifies a configuration for FairPlay licenses.
        :param pulumi.Input[str] ask: The key that must be used as FairPlay Application Secret key.
        :param pulumi.Input[str] fair_play_pfx: The Base64 representation of FairPlay certificate in PKCS 12 (pfx) format (including private key).
        :param pulumi.Input[str] fair_play_pfx_password: The password encrypting FairPlay certificate in PKCS 12 (pfx) format.
        :param pulumi.Input[str] odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.ContentKeyPolicyFairPlayConfiguration'.
        :param pulumi.Input[Union[str, 'ContentKeyPolicyFairPlayRentalAndLeaseKeyType']] rental_and_lease_key_type: The rental and lease key type.
        :param pulumi.Input[float] rental_duration: The rental duration. Must be greater than or equal to 0.
        :param pulumi.Input['ContentKeyPolicyFairPlayOfflineRentalConfigurationArgs'] offline_rental_configuration: Offline rental policy
        """
        pulumi.set(__self__, "ask", ask)
        pulumi.set(__self__, "fair_play_pfx", fair_play_pfx)
        pulumi.set(__self__, "fair_play_pfx_password", fair_play_pfx_password)
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.ContentKeyPolicyFairPlayConfiguration')
        pulumi.set(__self__, "rental_and_lease_key_type", rental_and_lease_key_type)
        pulumi.set(__self__, "rental_duration", rental_duration)
        if offline_rental_configuration is not None:
            pulumi.set(__self__, "offline_rental_configuration", offline_rental_configuration)

    @property
    @pulumi.getter
    def ask(self) -> pulumi.Input[str]:
        """
        The key that must be used as FairPlay Application Secret key.
        """
        return pulumi.get(self, "ask")

    @ask.setter
    def ask(self, value: pulumi.Input[str]):
        pulumi.set(self, "ask", value)

    @property
    @pulumi.getter(name="fairPlayPfx")
    def fair_play_pfx(self) -> pulumi.Input[str]:
        """
        The Base64 representation of FairPlay certificate in PKCS 12 (pfx) format (including private key).
        """
        return pulumi.get(self, "fair_play_pfx")

    @fair_play_pfx.setter
    def fair_play_pfx(self, value: pulumi.Input[str]):
        pulumi.set(self, "fair_play_pfx", value)

    @property
    @pulumi.getter(name="fairPlayPfxPassword")
    def fair_play_pfx_password(self) -> pulumi.Input[str]:
        """
        The password encrypting FairPlay certificate in PKCS 12 (pfx) format.
        """
        return pulumi.get(self, "fair_play_pfx_password")

    @fair_play_pfx_password.setter
    def fair_play_pfx_password(self, value: pulumi.Input[str]):
        pulumi.set(self, "fair_play_pfx_password", value)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> pulumi.Input[str]:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.ContentKeyPolicyFairPlayConfiguration'.
        """
        return pulumi.get(self, "odata_type")

    @odata_type.setter
    def odata_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "odata_type", value)

    @property
    @pulumi.getter(name="rentalAndLeaseKeyType")
    def rental_and_lease_key_type(self) -> pulumi.Input[Union[str, 'ContentKeyPolicyFairPlayRentalAndLeaseKeyType']]:
        """
        The rental and lease key type.
        """
        return pulumi.get(self, "rental_and_lease_key_type")

    @rental_and_lease_key_type.setter
    def rental_and_lease_key_type(self, value: pulumi.Input[Union[str, 'ContentKeyPolicyFairPlayRentalAndLeaseKeyType']]):
        pulumi.set(self, "rental_and_lease_key_type", value)

    @property
    @pulumi.getter(name="rentalDuration")
    def rental_duration(self) -> pulumi.Input[float]:
        """
        The rental duration. Must be greater than or equal to 0.
        """
        return pulumi.get(self, "rental_duration")

    @rental_duration.setter
    def rental_duration(self, value: pulumi.Input[float]):
        pulumi.set(self, "rental_duration", value)

    @property
    @pulumi.getter(name="offlineRentalConfiguration")
    def offline_rental_configuration(self) -> Optional[pulumi.Input['ContentKeyPolicyFairPlayOfflineRentalConfigurationArgs']]:
        """
        Offline rental policy
        """
        return pulumi.get(self, "offline_rental_configuration")

    @offline_rental_configuration.setter
    def offline_rental_configuration(self, value: Optional[pulumi.Input['ContentKeyPolicyFairPlayOfflineRentalConfigurationArgs']]):
        pulumi.set(self, "offline_rental_configuration", value)


@pulumi.input_type
class ContentKeyPolicyFairPlayOfflineRentalConfigurationArgs:
    def __init__(__self__, *,
                 playback_duration_seconds: pulumi.Input[float],
                 storage_duration_seconds: pulumi.Input[float]):
        """
        :param pulumi.Input[float] playback_duration_seconds: Playback duration
        :param pulumi.Input[float] storage_duration_seconds: Storage duration
        """
        pulumi.set(__self__, "playback_duration_seconds", playback_duration_seconds)
        pulumi.set(__self__, "storage_duration_seconds", storage_duration_seconds)

    @property
    @pulumi.getter(name="playbackDurationSeconds")
    def playback_duration_seconds(self) -> pulumi.Input[float]:
        """
        Playback duration
        """
        return pulumi.get(self, "playback_duration_seconds")

    @playback_duration_seconds.setter
    def playback_duration_seconds(self, value: pulumi.Input[float]):
        pulumi.set(self, "playback_duration_seconds", value)

    @property
    @pulumi.getter(name="storageDurationSeconds")
    def storage_duration_seconds(self) -> pulumi.Input[float]:
        """
        Storage duration
        """
        return pulumi.get(self, "storage_duration_seconds")

    @storage_duration_seconds.setter
    def storage_duration_seconds(self, value: pulumi.Input[float]):
        pulumi.set(self, "storage_duration_seconds", value)


@pulumi.input_type
class ContentKeyPolicyOpenRestrictionArgs:
    def __init__(__self__, *,
                 odata_type: pulumi.Input[str]):
        """
        Represents an open restriction. License or key will be delivered on every request.
        :param pulumi.Input[str] odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.ContentKeyPolicyOpenRestriction'.
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.ContentKeyPolicyOpenRestriction')

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> pulumi.Input[str]:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.ContentKeyPolicyOpenRestriction'.
        """
        return pulumi.get(self, "odata_type")

    @odata_type.setter
    def odata_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "odata_type", value)


@pulumi.input_type
class ContentKeyPolicyOptionArgs:
    def __init__(__self__, *,
                 configuration: pulumi.Input[Union['ContentKeyPolicyClearKeyConfigurationArgs', 'ContentKeyPolicyFairPlayConfigurationArgs', 'ContentKeyPolicyPlayReadyConfigurationArgs', 'ContentKeyPolicyUnknownConfigurationArgs', 'ContentKeyPolicyWidevineConfigurationArgs']],
                 restriction: pulumi.Input[Union['ContentKeyPolicyOpenRestrictionArgs', 'ContentKeyPolicyTokenRestrictionArgs', 'ContentKeyPolicyUnknownRestrictionArgs']],
                 name: Optional[pulumi.Input[str]] = None):
        """
        Represents a policy option.
        :param pulumi.Input[Union['ContentKeyPolicyClearKeyConfigurationArgs', 'ContentKeyPolicyFairPlayConfigurationArgs', 'ContentKeyPolicyPlayReadyConfigurationArgs', 'ContentKeyPolicyUnknownConfigurationArgs', 'ContentKeyPolicyWidevineConfigurationArgs']] configuration: The key delivery configuration.
        :param pulumi.Input[Union['ContentKeyPolicyOpenRestrictionArgs', 'ContentKeyPolicyTokenRestrictionArgs', 'ContentKeyPolicyUnknownRestrictionArgs']] restriction: The requirements that must be met to deliver keys with this configuration
        :param pulumi.Input[str] name: The Policy Option description.
        """
        pulumi.set(__self__, "configuration", configuration)
        pulumi.set(__self__, "restriction", restriction)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def configuration(self) -> pulumi.Input[Union['ContentKeyPolicyClearKeyConfigurationArgs', 'ContentKeyPolicyFairPlayConfigurationArgs', 'ContentKeyPolicyPlayReadyConfigurationArgs', 'ContentKeyPolicyUnknownConfigurationArgs', 'ContentKeyPolicyWidevineConfigurationArgs']]:
        """
        The key delivery configuration.
        """
        return pulumi.get(self, "configuration")

    @configuration.setter
    def configuration(self, value: pulumi.Input[Union['ContentKeyPolicyClearKeyConfigurationArgs', 'ContentKeyPolicyFairPlayConfigurationArgs', 'ContentKeyPolicyPlayReadyConfigurationArgs', 'ContentKeyPolicyUnknownConfigurationArgs', 'ContentKeyPolicyWidevineConfigurationArgs']]):
        pulumi.set(self, "configuration", value)

    @property
    @pulumi.getter
    def restriction(self) -> pulumi.Input[Union['ContentKeyPolicyOpenRestrictionArgs', 'ContentKeyPolicyTokenRestrictionArgs', 'ContentKeyPolicyUnknownRestrictionArgs']]:
        """
        The requirements that must be met to deliver keys with this configuration
        """
        return pulumi.get(self, "restriction")

    @restriction.setter
    def restriction(self, value: pulumi.Input[Union['ContentKeyPolicyOpenRestrictionArgs', 'ContentKeyPolicyTokenRestrictionArgs', 'ContentKeyPolicyUnknownRestrictionArgs']]):
        pulumi.set(self, "restriction", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The Policy Option description.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class ContentKeyPolicyPlayReadyConfigurationArgs:
    def __init__(__self__, *,
                 licenses: pulumi.Input[Sequence[pulumi.Input['ContentKeyPolicyPlayReadyLicenseArgs']]],
                 odata_type: pulumi.Input[str],
                 response_custom_data: Optional[pulumi.Input[str]] = None):
        """
        Specifies a configuration for PlayReady licenses.
        :param pulumi.Input[Sequence[pulumi.Input['ContentKeyPolicyPlayReadyLicenseArgs']]] licenses: The PlayReady licenses.
        :param pulumi.Input[str] odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.ContentKeyPolicyPlayReadyConfiguration'.
        :param pulumi.Input[str] response_custom_data: The custom response data.
        """
        pulumi.set(__self__, "licenses", licenses)
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.ContentKeyPolicyPlayReadyConfiguration')
        if response_custom_data is not None:
            pulumi.set(__self__, "response_custom_data", response_custom_data)

    @property
    @pulumi.getter
    def licenses(self) -> pulumi.Input[Sequence[pulumi.Input['ContentKeyPolicyPlayReadyLicenseArgs']]]:
        """
        The PlayReady licenses.
        """
        return pulumi.get(self, "licenses")

    @licenses.setter
    def licenses(self, value: pulumi.Input[Sequence[pulumi.Input['ContentKeyPolicyPlayReadyLicenseArgs']]]):
        pulumi.set(self, "licenses", value)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> pulumi.Input[str]:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.ContentKeyPolicyPlayReadyConfiguration'.
        """
        return pulumi.get(self, "odata_type")

    @odata_type.setter
    def odata_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "odata_type", value)

    @property
    @pulumi.getter(name="responseCustomData")
    def response_custom_data(self) -> Optional[pulumi.Input[str]]:
        """
        The custom response data.
        """
        return pulumi.get(self, "response_custom_data")

    @response_custom_data.setter
    def response_custom_data(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "response_custom_data", value)


@pulumi.input_type
class ContentKeyPolicyPlayReadyContentEncryptionKeyFromHeaderArgs:
    def __init__(__self__, *,
                 odata_type: pulumi.Input[str]):
        """
        Specifies that the content key ID is in the PlayReady header.
        :param pulumi.Input[str] odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.ContentKeyPolicyPlayReadyContentEncryptionKeyFromHeader'.
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.ContentKeyPolicyPlayReadyContentEncryptionKeyFromHeader')

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> pulumi.Input[str]:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.ContentKeyPolicyPlayReadyContentEncryptionKeyFromHeader'.
        """
        return pulumi.get(self, "odata_type")

    @odata_type.setter
    def odata_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "odata_type", value)


@pulumi.input_type
class ContentKeyPolicyPlayReadyContentEncryptionKeyFromKeyIdentifierArgs:
    def __init__(__self__, *,
                 key_id: pulumi.Input[str],
                 odata_type: pulumi.Input[str]):
        """
        Specifies that the content key ID is specified in the PlayReady configuration.
        :param pulumi.Input[str] key_id: The content key ID.
        :param pulumi.Input[str] odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.ContentKeyPolicyPlayReadyContentEncryptionKeyFromKeyIdentifier'.
        """
        pulumi.set(__self__, "key_id", key_id)
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.ContentKeyPolicyPlayReadyContentEncryptionKeyFromKeyIdentifier')

    @property
    @pulumi.getter(name="keyId")
    def key_id(self) -> pulumi.Input[str]:
        """
        The content key ID.
        """
        return pulumi.get(self, "key_id")

    @key_id.setter
    def key_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "key_id", value)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> pulumi.Input[str]:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.ContentKeyPolicyPlayReadyContentEncryptionKeyFromKeyIdentifier'.
        """
        return pulumi.get(self, "odata_type")

    @odata_type.setter
    def odata_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "odata_type", value)


@pulumi.input_type
class ContentKeyPolicyPlayReadyExplicitAnalogTelevisionRestrictionArgs:
    def __init__(__self__, *,
                 best_effort: pulumi.Input[bool],
                 configuration_data: pulumi.Input[int]):
        """
        Configures the Explicit Analog Television Output Restriction control bits. For further details see the PlayReady Compliance Rules.
        :param pulumi.Input[bool] best_effort: Indicates whether this restriction is enforced on a Best Effort basis.
        :param pulumi.Input[int] configuration_data: Configures the restriction control bits. Must be between 0 and 3 inclusive.
        """
        pulumi.set(__self__, "best_effort", best_effort)
        pulumi.set(__self__, "configuration_data", configuration_data)

    @property
    @pulumi.getter(name="bestEffort")
    def best_effort(self) -> pulumi.Input[bool]:
        """
        Indicates whether this restriction is enforced on a Best Effort basis.
        """
        return pulumi.get(self, "best_effort")

    @best_effort.setter
    def best_effort(self, value: pulumi.Input[bool]):
        pulumi.set(self, "best_effort", value)

    @property
    @pulumi.getter(name="configurationData")
    def configuration_data(self) -> pulumi.Input[int]:
        """
        Configures the restriction control bits. Must be between 0 and 3 inclusive.
        """
        return pulumi.get(self, "configuration_data")

    @configuration_data.setter
    def configuration_data(self, value: pulumi.Input[int]):
        pulumi.set(self, "configuration_data", value)


@pulumi.input_type
class ContentKeyPolicyPlayReadyLicenseArgs:
    def __init__(__self__, *,
                 allow_test_devices: pulumi.Input[bool],
                 content_key_location: pulumi.Input[Union['ContentKeyPolicyPlayReadyContentEncryptionKeyFromHeaderArgs', 'ContentKeyPolicyPlayReadyContentEncryptionKeyFromKeyIdentifierArgs']],
                 content_type: pulumi.Input[Union[str, 'ContentKeyPolicyPlayReadyContentType']],
                 license_type: pulumi.Input[Union[str, 'ContentKeyPolicyPlayReadyLicenseType']],
                 begin_date: Optional[pulumi.Input[str]] = None,
                 expiration_date: Optional[pulumi.Input[str]] = None,
                 grace_period: Optional[pulumi.Input[str]] = None,
                 play_right: Optional[pulumi.Input['ContentKeyPolicyPlayReadyPlayRightArgs']] = None,
                 relative_begin_date: Optional[pulumi.Input[str]] = None,
                 relative_expiration_date: Optional[pulumi.Input[str]] = None):
        """
        The PlayReady license
        :param pulumi.Input[bool] allow_test_devices: A flag indicating whether test devices can use the license.
        :param pulumi.Input[Union['ContentKeyPolicyPlayReadyContentEncryptionKeyFromHeaderArgs', 'ContentKeyPolicyPlayReadyContentEncryptionKeyFromKeyIdentifierArgs']] content_key_location: The content key location.
        :param pulumi.Input[Union[str, 'ContentKeyPolicyPlayReadyContentType']] content_type: The PlayReady content type.
        :param pulumi.Input[Union[str, 'ContentKeyPolicyPlayReadyLicenseType']] license_type: The license type.
        :param pulumi.Input[str] begin_date: The begin date of license
        :param pulumi.Input[str] expiration_date: The expiration date of license.
        :param pulumi.Input[str] grace_period: The grace period of license.
        :param pulumi.Input['ContentKeyPolicyPlayReadyPlayRightArgs'] play_right: The license PlayRight
        :param pulumi.Input[str] relative_begin_date: The relative begin date of license.
        :param pulumi.Input[str] relative_expiration_date: The relative expiration date of license.
        """
        pulumi.set(__self__, "allow_test_devices", allow_test_devices)
        pulumi.set(__self__, "content_key_location", content_key_location)
        pulumi.set(__self__, "content_type", content_type)
        pulumi.set(__self__, "license_type", license_type)
        if begin_date is not None:
            pulumi.set(__self__, "begin_date", begin_date)
        if expiration_date is not None:
            pulumi.set(__self__, "expiration_date", expiration_date)
        if grace_period is not None:
            pulumi.set(__self__, "grace_period", grace_period)
        if play_right is not None:
            pulumi.set(__self__, "play_right", play_right)
        if relative_begin_date is not None:
            pulumi.set(__self__, "relative_begin_date", relative_begin_date)
        if relative_expiration_date is not None:
            pulumi.set(__self__, "relative_expiration_date", relative_expiration_date)

    @property
    @pulumi.getter(name="allowTestDevices")
    def allow_test_devices(self) -> pulumi.Input[bool]:
        """
        A flag indicating whether test devices can use the license.
        """
        return pulumi.get(self, "allow_test_devices")

    @allow_test_devices.setter
    def allow_test_devices(self, value: pulumi.Input[bool]):
        pulumi.set(self, "allow_test_devices", value)

    @property
    @pulumi.getter(name="contentKeyLocation")
    def content_key_location(self) -> pulumi.Input[Union['ContentKeyPolicyPlayReadyContentEncryptionKeyFromHeaderArgs', 'ContentKeyPolicyPlayReadyContentEncryptionKeyFromKeyIdentifierArgs']]:
        """
        The content key location.
        """
        return pulumi.get(self, "content_key_location")

    @content_key_location.setter
    def content_key_location(self, value: pulumi.Input[Union['ContentKeyPolicyPlayReadyContentEncryptionKeyFromHeaderArgs', 'ContentKeyPolicyPlayReadyContentEncryptionKeyFromKeyIdentifierArgs']]):
        pulumi.set(self, "content_key_location", value)

    @property
    @pulumi.getter(name="contentType")
    def content_type(self) -> pulumi.Input[Union[str, 'ContentKeyPolicyPlayReadyContentType']]:
        """
        The PlayReady content type.
        """
        return pulumi.get(self, "content_type")

    @content_type.setter
    def content_type(self, value: pulumi.Input[Union[str, 'ContentKeyPolicyPlayReadyContentType']]):
        pulumi.set(self, "content_type", value)

    @property
    @pulumi.getter(name="licenseType")
    def license_type(self) -> pulumi.Input[Union[str, 'ContentKeyPolicyPlayReadyLicenseType']]:
        """
        The license type.
        """
        return pulumi.get(self, "license_type")

    @license_type.setter
    def license_type(self, value: pulumi.Input[Union[str, 'ContentKeyPolicyPlayReadyLicenseType']]):
        pulumi.set(self, "license_type", value)

    @property
    @pulumi.getter(name="beginDate")
    def begin_date(self) -> Optional[pulumi.Input[str]]:
        """
        The begin date of license
        """
        return pulumi.get(self, "begin_date")

    @begin_date.setter
    def begin_date(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "begin_date", value)

    @property
    @pulumi.getter(name="expirationDate")
    def expiration_date(self) -> Optional[pulumi.Input[str]]:
        """
        The expiration date of license.
        """
        return pulumi.get(self, "expiration_date")

    @expiration_date.setter
    def expiration_date(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expiration_date", value)

    @property
    @pulumi.getter(name="gracePeriod")
    def grace_period(self) -> Optional[pulumi.Input[str]]:
        """
        The grace period of license.
        """
        return pulumi.get(self, "grace_period")

    @grace_period.setter
    def grace_period(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "grace_period", value)

    @property
    @pulumi.getter(name="playRight")
    def play_right(self) -> Optional[pulumi.Input['ContentKeyPolicyPlayReadyPlayRightArgs']]:
        """
        The license PlayRight
        """
        return pulumi.get(self, "play_right")

    @play_right.setter
    def play_right(self, value: Optional[pulumi.Input['ContentKeyPolicyPlayReadyPlayRightArgs']]):
        pulumi.set(self, "play_right", value)

    @property
    @pulumi.getter(name="relativeBeginDate")
    def relative_begin_date(self) -> Optional[pulumi.Input[str]]:
        """
        The relative begin date of license.
        """
        return pulumi.get(self, "relative_begin_date")

    @relative_begin_date.setter
    def relative_begin_date(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "relative_begin_date", value)

    @property
    @pulumi.getter(name="relativeExpirationDate")
    def relative_expiration_date(self) -> Optional[pulumi.Input[str]]:
        """
        The relative expiration date of license.
        """
        return pulumi.get(self, "relative_expiration_date")

    @relative_expiration_date.setter
    def relative_expiration_date(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "relative_expiration_date", value)


@pulumi.input_type
class ContentKeyPolicyPlayReadyPlayRightArgs:
    def __init__(__self__, *,
                 allow_passing_video_content_to_unknown_output: pulumi.Input[Union[str, 'ContentKeyPolicyPlayReadyUnknownOutputPassingOption']],
                 digital_video_only_content_restriction: pulumi.Input[bool],
                 image_constraint_for_analog_component_video_restriction: pulumi.Input[bool],
                 image_constraint_for_analog_computer_monitor_restriction: pulumi.Input[bool],
                 agc_and_color_stripe_restriction: Optional[pulumi.Input[int]] = None,
                 analog_video_opl: Optional[pulumi.Input[int]] = None,
                 compressed_digital_audio_opl: Optional[pulumi.Input[int]] = None,
                 compressed_digital_video_opl: Optional[pulumi.Input[int]] = None,
                 explicit_analog_television_output_restriction: Optional[pulumi.Input['ContentKeyPolicyPlayReadyExplicitAnalogTelevisionRestrictionArgs']] = None,
                 first_play_expiration: Optional[pulumi.Input[str]] = None,
                 scms_restriction: Optional[pulumi.Input[int]] = None,
                 uncompressed_digital_audio_opl: Optional[pulumi.Input[int]] = None,
                 uncompressed_digital_video_opl: Optional[pulumi.Input[int]] = None):
        """
        Configures the Play Right in the PlayReady license.
        :param pulumi.Input[Union[str, 'ContentKeyPolicyPlayReadyUnknownOutputPassingOption']] allow_passing_video_content_to_unknown_output: Configures Unknown output handling settings of the license.
        :param pulumi.Input[bool] digital_video_only_content_restriction: Enables the Image Constraint For Analog Component Video Restriction in the license.
        :param pulumi.Input[bool] image_constraint_for_analog_component_video_restriction: Enables the Image Constraint For Analog Component Video Restriction in the license.
        :param pulumi.Input[bool] image_constraint_for_analog_computer_monitor_restriction: Enables the Image Constraint For Analog Component Video Restriction in the license.
        :param pulumi.Input[int] agc_and_color_stripe_restriction: Configures Automatic Gain Control (AGC) and Color Stripe in the license. Must be between 0 and 3 inclusive.
        :param pulumi.Input[int] analog_video_opl: Specifies the output protection level for compressed digital audio.
        :param pulumi.Input[int] compressed_digital_audio_opl: Specifies the output protection level for compressed digital audio.
        :param pulumi.Input[int] compressed_digital_video_opl: Specifies the output protection level for compressed digital video.
        :param pulumi.Input['ContentKeyPolicyPlayReadyExplicitAnalogTelevisionRestrictionArgs'] explicit_analog_television_output_restriction: Configures the Explicit Analog Television Output Restriction in the license. Configuration data must be between 0 and 3 inclusive.
        :param pulumi.Input[str] first_play_expiration: The amount of time that the license is valid after the license is first used to play content.
        :param pulumi.Input[int] scms_restriction: Configures the Serial Copy Management System (SCMS) in the license. Must be between 0 and 3 inclusive.
        :param pulumi.Input[int] uncompressed_digital_audio_opl: Specifies the output protection level for uncompressed digital audio.
        :param pulumi.Input[int] uncompressed_digital_video_opl: Specifies the output protection level for uncompressed digital video.
        """
        pulumi.set(__self__, "allow_passing_video_content_to_unknown_output", allow_passing_video_content_to_unknown_output)
        pulumi.set(__self__, "digital_video_only_content_restriction", digital_video_only_content_restriction)
        pulumi.set(__self__, "image_constraint_for_analog_component_video_restriction", image_constraint_for_analog_component_video_restriction)
        pulumi.set(__self__, "image_constraint_for_analog_computer_monitor_restriction", image_constraint_for_analog_computer_monitor_restriction)
        if agc_and_color_stripe_restriction is not None:
            pulumi.set(__self__, "agc_and_color_stripe_restriction", agc_and_color_stripe_restriction)
        if analog_video_opl is not None:
            pulumi.set(__self__, "analog_video_opl", analog_video_opl)
        if compressed_digital_audio_opl is not None:
            pulumi.set(__self__, "compressed_digital_audio_opl", compressed_digital_audio_opl)
        if compressed_digital_video_opl is not None:
            pulumi.set(__self__, "compressed_digital_video_opl", compressed_digital_video_opl)
        if explicit_analog_television_output_restriction is not None:
            pulumi.set(__self__, "explicit_analog_television_output_restriction", explicit_analog_television_output_restriction)
        if first_play_expiration is not None:
            pulumi.set(__self__, "first_play_expiration", first_play_expiration)
        if scms_restriction is not None:
            pulumi.set(__self__, "scms_restriction", scms_restriction)
        if uncompressed_digital_audio_opl is not None:
            pulumi.set(__self__, "uncompressed_digital_audio_opl", uncompressed_digital_audio_opl)
        if uncompressed_digital_video_opl is not None:
            pulumi.set(__self__, "uncompressed_digital_video_opl", uncompressed_digital_video_opl)

    @property
    @pulumi.getter(name="allowPassingVideoContentToUnknownOutput")
    def allow_passing_video_content_to_unknown_output(self) -> pulumi.Input[Union[str, 'ContentKeyPolicyPlayReadyUnknownOutputPassingOption']]:
        """
        Configures Unknown output handling settings of the license.
        """
        return pulumi.get(self, "allow_passing_video_content_to_unknown_output")

    @allow_passing_video_content_to_unknown_output.setter
    def allow_passing_video_content_to_unknown_output(self, value: pulumi.Input[Union[str, 'ContentKeyPolicyPlayReadyUnknownOutputPassingOption']]):
        pulumi.set(self, "allow_passing_video_content_to_unknown_output", value)

    @property
    @pulumi.getter(name="digitalVideoOnlyContentRestriction")
    def digital_video_only_content_restriction(self) -> pulumi.Input[bool]:
        """
        Enables the Image Constraint For Analog Component Video Restriction in the license.
        """
        return pulumi.get(self, "digital_video_only_content_restriction")

    @digital_video_only_content_restriction.setter
    def digital_video_only_content_restriction(self, value: pulumi.Input[bool]):
        pulumi.set(self, "digital_video_only_content_restriction", value)

    @property
    @pulumi.getter(name="imageConstraintForAnalogComponentVideoRestriction")
    def image_constraint_for_analog_component_video_restriction(self) -> pulumi.Input[bool]:
        """
        Enables the Image Constraint For Analog Component Video Restriction in the license.
        """
        return pulumi.get(self, "image_constraint_for_analog_component_video_restriction")

    @image_constraint_for_analog_component_video_restriction.setter
    def image_constraint_for_analog_component_video_restriction(self, value: pulumi.Input[bool]):
        pulumi.set(self, "image_constraint_for_analog_component_video_restriction", value)

    @property
    @pulumi.getter(name="imageConstraintForAnalogComputerMonitorRestriction")
    def image_constraint_for_analog_computer_monitor_restriction(self) -> pulumi.Input[bool]:
        """
        Enables the Image Constraint For Analog Component Video Restriction in the license.
        """
        return pulumi.get(self, "image_constraint_for_analog_computer_monitor_restriction")

    @image_constraint_for_analog_computer_monitor_restriction.setter
    def image_constraint_for_analog_computer_monitor_restriction(self, value: pulumi.Input[bool]):
        pulumi.set(self, "image_constraint_for_analog_computer_monitor_restriction", value)

    @property
    @pulumi.getter(name="agcAndColorStripeRestriction")
    def agc_and_color_stripe_restriction(self) -> Optional[pulumi.Input[int]]:
        """
        Configures Automatic Gain Control (AGC) and Color Stripe in the license. Must be between 0 and 3 inclusive.
        """
        return pulumi.get(self, "agc_and_color_stripe_restriction")

    @agc_and_color_stripe_restriction.setter
    def agc_and_color_stripe_restriction(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "agc_and_color_stripe_restriction", value)

    @property
    @pulumi.getter(name="analogVideoOpl")
    def analog_video_opl(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the output protection level for compressed digital audio.
        """
        return pulumi.get(self, "analog_video_opl")

    @analog_video_opl.setter
    def analog_video_opl(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "analog_video_opl", value)

    @property
    @pulumi.getter(name="compressedDigitalAudioOpl")
    def compressed_digital_audio_opl(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the output protection level for compressed digital audio.
        """
        return pulumi.get(self, "compressed_digital_audio_opl")

    @compressed_digital_audio_opl.setter
    def compressed_digital_audio_opl(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "compressed_digital_audio_opl", value)

    @property
    @pulumi.getter(name="compressedDigitalVideoOpl")
    def compressed_digital_video_opl(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the output protection level for compressed digital video.
        """
        return pulumi.get(self, "compressed_digital_video_opl")

    @compressed_digital_video_opl.setter
    def compressed_digital_video_opl(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "compressed_digital_video_opl", value)

    @property
    @pulumi.getter(name="explicitAnalogTelevisionOutputRestriction")
    def explicit_analog_television_output_restriction(self) -> Optional[pulumi.Input['ContentKeyPolicyPlayReadyExplicitAnalogTelevisionRestrictionArgs']]:
        """
        Configures the Explicit Analog Television Output Restriction in the license. Configuration data must be between 0 and 3 inclusive.
        """
        return pulumi.get(self, "explicit_analog_television_output_restriction")

    @explicit_analog_television_output_restriction.setter
    def explicit_analog_television_output_restriction(self, value: Optional[pulumi.Input['ContentKeyPolicyPlayReadyExplicitAnalogTelevisionRestrictionArgs']]):
        pulumi.set(self, "explicit_analog_television_output_restriction", value)

    @property
    @pulumi.getter(name="firstPlayExpiration")
    def first_play_expiration(self) -> Optional[pulumi.Input[str]]:
        """
        The amount of time that the license is valid after the license is first used to play content.
        """
        return pulumi.get(self, "first_play_expiration")

    @first_play_expiration.setter
    def first_play_expiration(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "first_play_expiration", value)

    @property
    @pulumi.getter(name="scmsRestriction")
    def scms_restriction(self) -> Optional[pulumi.Input[int]]:
        """
        Configures the Serial Copy Management System (SCMS) in the license. Must be between 0 and 3 inclusive.
        """
        return pulumi.get(self, "scms_restriction")

    @scms_restriction.setter
    def scms_restriction(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "scms_restriction", value)

    @property
    @pulumi.getter(name="uncompressedDigitalAudioOpl")
    def uncompressed_digital_audio_opl(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the output protection level for uncompressed digital audio.
        """
        return pulumi.get(self, "uncompressed_digital_audio_opl")

    @uncompressed_digital_audio_opl.setter
    def uncompressed_digital_audio_opl(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "uncompressed_digital_audio_opl", value)

    @property
    @pulumi.getter(name="uncompressedDigitalVideoOpl")
    def uncompressed_digital_video_opl(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the output protection level for uncompressed digital video.
        """
        return pulumi.get(self, "uncompressed_digital_video_opl")

    @uncompressed_digital_video_opl.setter
    def uncompressed_digital_video_opl(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "uncompressed_digital_video_opl", value)


@pulumi.input_type
class ContentKeyPolicyRsaTokenKeyArgs:
    def __init__(__self__, *,
                 exponent: pulumi.Input[str],
                 modulus: pulumi.Input[str],
                 odata_type: pulumi.Input[str]):
        """
        Specifies a RSA key for token validation
        :param pulumi.Input[str] exponent: The RSA Parameter exponent
        :param pulumi.Input[str] modulus: The RSA Parameter modulus
        :param pulumi.Input[str] odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.ContentKeyPolicyRsaTokenKey'.
        """
        pulumi.set(__self__, "exponent", exponent)
        pulumi.set(__self__, "modulus", modulus)
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.ContentKeyPolicyRsaTokenKey')

    @property
    @pulumi.getter
    def exponent(self) -> pulumi.Input[str]:
        """
        The RSA Parameter exponent
        """
        return pulumi.get(self, "exponent")

    @exponent.setter
    def exponent(self, value: pulumi.Input[str]):
        pulumi.set(self, "exponent", value)

    @property
    @pulumi.getter
    def modulus(self) -> pulumi.Input[str]:
        """
        The RSA Parameter modulus
        """
        return pulumi.get(self, "modulus")

    @modulus.setter
    def modulus(self, value: pulumi.Input[str]):
        pulumi.set(self, "modulus", value)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> pulumi.Input[str]:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.ContentKeyPolicyRsaTokenKey'.
        """
        return pulumi.get(self, "odata_type")

    @odata_type.setter
    def odata_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "odata_type", value)


@pulumi.input_type
class ContentKeyPolicySymmetricTokenKeyArgs:
    def __init__(__self__, *,
                 key_value: pulumi.Input[str],
                 odata_type: pulumi.Input[str]):
        """
        Specifies a symmetric key for token validation.
        :param pulumi.Input[str] key_value: The key value of the key
        :param pulumi.Input[str] odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.ContentKeyPolicySymmetricTokenKey'.
        """
        pulumi.set(__self__, "key_value", key_value)
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.ContentKeyPolicySymmetricTokenKey')

    @property
    @pulumi.getter(name="keyValue")
    def key_value(self) -> pulumi.Input[str]:
        """
        The key value of the key
        """
        return pulumi.get(self, "key_value")

    @key_value.setter
    def key_value(self, value: pulumi.Input[str]):
        pulumi.set(self, "key_value", value)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> pulumi.Input[str]:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.ContentKeyPolicySymmetricTokenKey'.
        """
        return pulumi.get(self, "odata_type")

    @odata_type.setter
    def odata_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "odata_type", value)


@pulumi.input_type
class ContentKeyPolicyTokenClaimArgs:
    def __init__(__self__, *,
                 claim_type: Optional[pulumi.Input[str]] = None,
                 claim_value: Optional[pulumi.Input[str]] = None):
        """
        Represents a token claim.
        :param pulumi.Input[str] claim_type: Token claim type.
        :param pulumi.Input[str] claim_value: Token claim value.
        """
        if claim_type is not None:
            pulumi.set(__self__, "claim_type", claim_type)
        if claim_value is not None:
            pulumi.set(__self__, "claim_value", claim_value)

    @property
    @pulumi.getter(name="claimType")
    def claim_type(self) -> Optional[pulumi.Input[str]]:
        """
        Token claim type.
        """
        return pulumi.get(self, "claim_type")

    @claim_type.setter
    def claim_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "claim_type", value)

    @property
    @pulumi.getter(name="claimValue")
    def claim_value(self) -> Optional[pulumi.Input[str]]:
        """
        Token claim value.
        """
        return pulumi.get(self, "claim_value")

    @claim_value.setter
    def claim_value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "claim_value", value)


@pulumi.input_type
class ContentKeyPolicyTokenRestrictionArgs:
    def __init__(__self__, *,
                 audience: pulumi.Input[str],
                 issuer: pulumi.Input[str],
                 odata_type: pulumi.Input[str],
                 primary_verification_key: pulumi.Input[Union['ContentKeyPolicyRsaTokenKeyArgs', 'ContentKeyPolicySymmetricTokenKeyArgs', 'ContentKeyPolicyX509CertificateTokenKeyArgs']],
                 restriction_token_type: pulumi.Input[Union[str, 'ContentKeyPolicyRestrictionTokenType']],
                 alternate_verification_keys: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ContentKeyPolicyRsaTokenKeyArgs', 'ContentKeyPolicySymmetricTokenKeyArgs', 'ContentKeyPolicyX509CertificateTokenKeyArgs']]]]] = None,
                 open_id_connect_discovery_document: Optional[pulumi.Input[str]] = None,
                 required_claims: Optional[pulumi.Input[Sequence[pulumi.Input['ContentKeyPolicyTokenClaimArgs']]]] = None):
        """
        Represents a token restriction. Provided token must match these requirements for successful license or key delivery.
        :param pulumi.Input[str] audience: The audience for the token.
        :param pulumi.Input[str] issuer: The token issuer.
        :param pulumi.Input[str] odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.ContentKeyPolicyTokenRestriction'.
        :param pulumi.Input[Union['ContentKeyPolicyRsaTokenKeyArgs', 'ContentKeyPolicySymmetricTokenKeyArgs', 'ContentKeyPolicyX509CertificateTokenKeyArgs']] primary_verification_key: The primary verification key.
        :param pulumi.Input[Union[str, 'ContentKeyPolicyRestrictionTokenType']] restriction_token_type: The type of token.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ContentKeyPolicyRsaTokenKeyArgs', 'ContentKeyPolicySymmetricTokenKeyArgs', 'ContentKeyPolicyX509CertificateTokenKeyArgs']]]] alternate_verification_keys: A list of alternative verification keys.
        :param pulumi.Input[str] open_id_connect_discovery_document: The OpenID connect discovery document.
        :param pulumi.Input[Sequence[pulumi.Input['ContentKeyPolicyTokenClaimArgs']]] required_claims: A list of required token claims.
        """
        pulumi.set(__self__, "audience", audience)
        pulumi.set(__self__, "issuer", issuer)
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.ContentKeyPolicyTokenRestriction')
        pulumi.set(__self__, "primary_verification_key", primary_verification_key)
        pulumi.set(__self__, "restriction_token_type", restriction_token_type)
        if alternate_verification_keys is not None:
            pulumi.set(__self__, "alternate_verification_keys", alternate_verification_keys)
        if open_id_connect_discovery_document is not None:
            pulumi.set(__self__, "open_id_connect_discovery_document", open_id_connect_discovery_document)
        if required_claims is not None:
            pulumi.set(__self__, "required_claims", required_claims)

    @property
    @pulumi.getter
    def audience(self) -> pulumi.Input[str]:
        """
        The audience for the token.
        """
        return pulumi.get(self, "audience")

    @audience.setter
    def audience(self, value: pulumi.Input[str]):
        pulumi.set(self, "audience", value)

    @property
    @pulumi.getter
    def issuer(self) -> pulumi.Input[str]:
        """
        The token issuer.
        """
        return pulumi.get(self, "issuer")

    @issuer.setter
    def issuer(self, value: pulumi.Input[str]):
        pulumi.set(self, "issuer", value)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> pulumi.Input[str]:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.ContentKeyPolicyTokenRestriction'.
        """
        return pulumi.get(self, "odata_type")

    @odata_type.setter
    def odata_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "odata_type", value)

    @property
    @pulumi.getter(name="primaryVerificationKey")
    def primary_verification_key(self) -> pulumi.Input[Union['ContentKeyPolicyRsaTokenKeyArgs', 'ContentKeyPolicySymmetricTokenKeyArgs', 'ContentKeyPolicyX509CertificateTokenKeyArgs']]:
        """
        The primary verification key.
        """
        return pulumi.get(self, "primary_verification_key")

    @primary_verification_key.setter
    def primary_verification_key(self, value: pulumi.Input[Union['ContentKeyPolicyRsaTokenKeyArgs', 'ContentKeyPolicySymmetricTokenKeyArgs', 'ContentKeyPolicyX509CertificateTokenKeyArgs']]):
        pulumi.set(self, "primary_verification_key", value)

    @property
    @pulumi.getter(name="restrictionTokenType")
    def restriction_token_type(self) -> pulumi.Input[Union[str, 'ContentKeyPolicyRestrictionTokenType']]:
        """
        The type of token.
        """
        return pulumi.get(self, "restriction_token_type")

    @restriction_token_type.setter
    def restriction_token_type(self, value: pulumi.Input[Union[str, 'ContentKeyPolicyRestrictionTokenType']]):
        pulumi.set(self, "restriction_token_type", value)

    @property
    @pulumi.getter(name="alternateVerificationKeys")
    def alternate_verification_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Union['ContentKeyPolicyRsaTokenKeyArgs', 'ContentKeyPolicySymmetricTokenKeyArgs', 'ContentKeyPolicyX509CertificateTokenKeyArgs']]]]]:
        """
        A list of alternative verification keys.
        """
        return pulumi.get(self, "alternate_verification_keys")

    @alternate_verification_keys.setter
    def alternate_verification_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ContentKeyPolicyRsaTokenKeyArgs', 'ContentKeyPolicySymmetricTokenKeyArgs', 'ContentKeyPolicyX509CertificateTokenKeyArgs']]]]]):
        pulumi.set(self, "alternate_verification_keys", value)

    @property
    @pulumi.getter(name="openIdConnectDiscoveryDocument")
    def open_id_connect_discovery_document(self) -> Optional[pulumi.Input[str]]:
        """
        The OpenID connect discovery document.
        """
        return pulumi.get(self, "open_id_connect_discovery_document")

    @open_id_connect_discovery_document.setter
    def open_id_connect_discovery_document(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "open_id_connect_discovery_document", value)

    @property
    @pulumi.getter(name="requiredClaims")
    def required_claims(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ContentKeyPolicyTokenClaimArgs']]]]:
        """
        A list of required token claims.
        """
        return pulumi.get(self, "required_claims")

    @required_claims.setter
    def required_claims(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ContentKeyPolicyTokenClaimArgs']]]]):
        pulumi.set(self, "required_claims", value)


@pulumi.input_type
class ContentKeyPolicyUnknownConfigurationArgs:
    def __init__(__self__, *,
                 odata_type: pulumi.Input[str]):
        """
        Represents a ContentKeyPolicyConfiguration that is unavailable in the current API version.
        :param pulumi.Input[str] odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.ContentKeyPolicyUnknownConfiguration'.
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.ContentKeyPolicyUnknownConfiguration')

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> pulumi.Input[str]:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.ContentKeyPolicyUnknownConfiguration'.
        """
        return pulumi.get(self, "odata_type")

    @odata_type.setter
    def odata_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "odata_type", value)


@pulumi.input_type
class ContentKeyPolicyUnknownRestrictionArgs:
    def __init__(__self__, *,
                 odata_type: pulumi.Input[str]):
        """
        Represents a ContentKeyPolicyRestriction that is unavailable in the current API version.
        :param pulumi.Input[str] odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.ContentKeyPolicyUnknownRestriction'.
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.ContentKeyPolicyUnknownRestriction')

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> pulumi.Input[str]:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.ContentKeyPolicyUnknownRestriction'.
        """
        return pulumi.get(self, "odata_type")

    @odata_type.setter
    def odata_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "odata_type", value)


@pulumi.input_type
class ContentKeyPolicyWidevineConfigurationArgs:
    def __init__(__self__, *,
                 odata_type: pulumi.Input[str],
                 widevine_template: pulumi.Input[str]):
        """
        Specifies a configuration for Widevine licenses.
        :param pulumi.Input[str] odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.ContentKeyPolicyWidevineConfiguration'.
        :param pulumi.Input[str] widevine_template: The Widevine template.
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.ContentKeyPolicyWidevineConfiguration')
        pulumi.set(__self__, "widevine_template", widevine_template)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> pulumi.Input[str]:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.ContentKeyPolicyWidevineConfiguration'.
        """
        return pulumi.get(self, "odata_type")

    @odata_type.setter
    def odata_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "odata_type", value)

    @property
    @pulumi.getter(name="widevineTemplate")
    def widevine_template(self) -> pulumi.Input[str]:
        """
        The Widevine template.
        """
        return pulumi.get(self, "widevine_template")

    @widevine_template.setter
    def widevine_template(self, value: pulumi.Input[str]):
        pulumi.set(self, "widevine_template", value)


@pulumi.input_type
class ContentKeyPolicyX509CertificateTokenKeyArgs:
    def __init__(__self__, *,
                 odata_type: pulumi.Input[str],
                 raw_body: pulumi.Input[str]):
        """
        Specifies a certificate for token validation.
        :param pulumi.Input[str] odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.ContentKeyPolicyX509CertificateTokenKey'.
        :param pulumi.Input[str] raw_body: The raw data field of a certificate in PKCS 12 format (X509Certificate2 in .NET)
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.ContentKeyPolicyX509CertificateTokenKey')
        pulumi.set(__self__, "raw_body", raw_body)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> pulumi.Input[str]:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.ContentKeyPolicyX509CertificateTokenKey'.
        """
        return pulumi.get(self, "odata_type")

    @odata_type.setter
    def odata_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "odata_type", value)

    @property
    @pulumi.getter(name="rawBody")
    def raw_body(self) -> pulumi.Input[str]:
        """
        The raw data field of a certificate in PKCS 12 format (X509Certificate2 in .NET)
        """
        return pulumi.get(self, "raw_body")

    @raw_body.setter
    def raw_body(self, value: pulumi.Input[str]):
        pulumi.set(self, "raw_body", value)


@pulumi.input_type
class CopyAudioArgs:
    def __init__(__self__, *,
                 odata_type: pulumi.Input[str],
                 label: Optional[pulumi.Input[str]] = None):
        """
        A codec flag, which tells the encoder to copy the input audio bitstream.
        :param pulumi.Input[str] odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.CopyAudio'.
        :param pulumi.Input[str] label: An optional label for the codec. The label can be used to control muxing behavior.
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.CopyAudio')
        if label is not None:
            pulumi.set(__self__, "label", label)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> pulumi.Input[str]:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.CopyAudio'.
        """
        return pulumi.get(self, "odata_type")

    @odata_type.setter
    def odata_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "odata_type", value)

    @property
    @pulumi.getter
    def label(self) -> Optional[pulumi.Input[str]]:
        """
        An optional label for the codec. The label can be used to control muxing behavior.
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "label", value)


@pulumi.input_type
class CopyVideoArgs:
    def __init__(__self__, *,
                 odata_type: pulumi.Input[str],
                 label: Optional[pulumi.Input[str]] = None):
        """
        A codec flag, which tells the encoder to copy the input video bitstream without re-encoding.
        :param pulumi.Input[str] odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.CopyVideo'.
        :param pulumi.Input[str] label: An optional label for the codec. The label can be used to control muxing behavior.
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.CopyVideo')
        if label is not None:
            pulumi.set(__self__, "label", label)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> pulumi.Input[str]:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.CopyVideo'.
        """
        return pulumi.get(self, "odata_type")

    @odata_type.setter
    def odata_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "odata_type", value)

    @property
    @pulumi.getter
    def label(self) -> Optional[pulumi.Input[str]]:
        """
        An optional label for the codec. The label can be used to control muxing behavior.
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "label", value)


@pulumi.input_type
class CrossSiteAccessPoliciesArgs:
    def __init__(__self__, *,
                 client_access_policy: Optional[pulumi.Input[str]] = None,
                 cross_domain_policy: Optional[pulumi.Input[str]] = None):
        """
        The client access policy.
        :param pulumi.Input[str] client_access_policy: The content of clientaccesspolicy.xml used by Silverlight.
        :param pulumi.Input[str] cross_domain_policy: The content of crossdomain.xml used by Silverlight.
        """
        if client_access_policy is not None:
            pulumi.set(__self__, "client_access_policy", client_access_policy)
        if cross_domain_policy is not None:
            pulumi.set(__self__, "cross_domain_policy", cross_domain_policy)

    @property
    @pulumi.getter(name="clientAccessPolicy")
    def client_access_policy(self) -> Optional[pulumi.Input[str]]:
        """
        The content of clientaccesspolicy.xml used by Silverlight.
        """
        return pulumi.get(self, "client_access_policy")

    @client_access_policy.setter
    def client_access_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_access_policy", value)

    @property
    @pulumi.getter(name="crossDomainPolicy")
    def cross_domain_policy(self) -> Optional[pulumi.Input[str]]:
        """
        The content of crossdomain.xml used by Silverlight.
        """
        return pulumi.get(self, "cross_domain_policy")

    @cross_domain_policy.setter
    def cross_domain_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cross_domain_policy", value)


@pulumi.input_type
class DefaultKeyArgs:
    def __init__(__self__, *,
                 label: Optional[pulumi.Input[str]] = None,
                 policy_name: Optional[pulumi.Input[str]] = None):
        """
        Class to specify properties of default content key for each encryption scheme
        :param pulumi.Input[str] label: Label can be used to specify Content Key when creating a Streaming Locator
        :param pulumi.Input[str] policy_name: Policy used by Default Key
        """
        if label is not None:
            pulumi.set(__self__, "label", label)
        if policy_name is not None:
            pulumi.set(__self__, "policy_name", policy_name)

    @property
    @pulumi.getter
    def label(self) -> Optional[pulumi.Input[str]]:
        """
        Label can be used to specify Content Key when creating a Streaming Locator
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "label", value)

    @property
    @pulumi.getter(name="policyName")
    def policy_name(self) -> Optional[pulumi.Input[str]]:
        """
        Policy used by Default Key
        """
        return pulumi.get(self, "policy_name")

    @policy_name.setter
    def policy_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "policy_name", value)


@pulumi.input_type
class DeinterlaceArgs:
    def __init__(__self__, *,
                 mode: Optional[pulumi.Input[Union[str, 'DeinterlaceMode']]] = None,
                 parity: Optional[pulumi.Input[Union[str, 'DeinterlaceParity']]] = None):
        """
        Describes the de-interlacing settings.
        :param pulumi.Input[Union[str, 'DeinterlaceMode']] mode: The deinterlacing mode. Defaults to AutoPixelAdaptive.
        :param pulumi.Input[Union[str, 'DeinterlaceParity']] parity: The field parity for de-interlacing, defaults to Auto.
        """
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if parity is not None:
            pulumi.set(__self__, "parity", parity)

    @property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input[Union[str, 'DeinterlaceMode']]]:
        """
        The deinterlacing mode. Defaults to AutoPixelAdaptive.
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input[Union[str, 'DeinterlaceMode']]]):
        pulumi.set(self, "mode", value)

    @property
    @pulumi.getter
    def parity(self) -> Optional[pulumi.Input[Union[str, 'DeinterlaceParity']]]:
        """
        The field parity for de-interlacing, defaults to Auto.
        """
        return pulumi.get(self, "parity")

    @parity.setter
    def parity(self, value: Optional[pulumi.Input[Union[str, 'DeinterlaceParity']]]):
        pulumi.set(self, "parity", value)


@pulumi.input_type
class EnabledProtocolsArgs:
    def __init__(__self__, *,
                 dash: pulumi.Input[bool],
                 download: pulumi.Input[bool],
                 hls: pulumi.Input[bool],
                 smooth_streaming: pulumi.Input[bool]):
        """
        Class to specify which protocols are enabled
        :param pulumi.Input[bool] dash: Enable DASH protocol or not
        :param pulumi.Input[bool] download: Enable Download protocol or not
        :param pulumi.Input[bool] hls: Enable HLS protocol or not
        :param pulumi.Input[bool] smooth_streaming: Enable SmoothStreaming protocol or not
        """
        pulumi.set(__self__, "dash", dash)
        pulumi.set(__self__, "download", download)
        pulumi.set(__self__, "hls", hls)
        pulumi.set(__self__, "smooth_streaming", smooth_streaming)

    @property
    @pulumi.getter
    def dash(self) -> pulumi.Input[bool]:
        """
        Enable DASH protocol or not
        """
        return pulumi.get(self, "dash")

    @dash.setter
    def dash(self, value: pulumi.Input[bool]):
        pulumi.set(self, "dash", value)

    @property
    @pulumi.getter
    def download(self) -> pulumi.Input[bool]:
        """
        Enable Download protocol or not
        """
        return pulumi.get(self, "download")

    @download.setter
    def download(self, value: pulumi.Input[bool]):
        pulumi.set(self, "download", value)

    @property
    @pulumi.getter
    def hls(self) -> pulumi.Input[bool]:
        """
        Enable HLS protocol or not
        """
        return pulumi.get(self, "hls")

    @hls.setter
    def hls(self, value: pulumi.Input[bool]):
        pulumi.set(self, "hls", value)

    @property
    @pulumi.getter(name="smoothStreaming")
    def smooth_streaming(self) -> pulumi.Input[bool]:
        """
        Enable SmoothStreaming protocol or not
        """
        return pulumi.get(self, "smooth_streaming")

    @smooth_streaming.setter
    def smooth_streaming(self, value: pulumi.Input[bool]):
        pulumi.set(self, "smooth_streaming", value)


@pulumi.input_type
class EnvelopeEncryptionArgs:
    def __init__(__self__, *,
                 clear_tracks: Optional[pulumi.Input[Sequence[pulumi.Input['TrackSelectionArgs']]]] = None,
                 content_keys: Optional[pulumi.Input['StreamingPolicyContentKeysArgs']] = None,
                 custom_key_acquisition_url_template: Optional[pulumi.Input[str]] = None,
                 enabled_protocols: Optional[pulumi.Input['EnabledProtocolsArgs']] = None):
        """
        Class for EnvelopeEncryption encryption scheme
        :param pulumi.Input[Sequence[pulumi.Input['TrackSelectionArgs']]] clear_tracks: Representing which tracks should not be encrypted
        :param pulumi.Input['StreamingPolicyContentKeysArgs'] content_keys: Representing default content key for each encryption scheme and separate content keys for specific tracks
        :param pulumi.Input[str] custom_key_acquisition_url_template: Template for the URL of the custom service delivering keys to end user players.  Not required when using Azure Media Services for issuing keys.  The template supports replaceable tokens that the service will update at runtime with the value specific to the request.  The currently supported token values are {AlternativeMediaId}, which is replaced with the value of StreamingLocatorId.AlternativeMediaId, and {ContentKeyId}, which is replaced with the value of identifier of the key being requested.
        :param pulumi.Input['EnabledProtocolsArgs'] enabled_protocols: Representing supported protocols
        """
        if clear_tracks is not None:
            pulumi.set(__self__, "clear_tracks", clear_tracks)
        if content_keys is not None:
            pulumi.set(__self__, "content_keys", content_keys)
        if custom_key_acquisition_url_template is not None:
            pulumi.set(__self__, "custom_key_acquisition_url_template", custom_key_acquisition_url_template)
        if enabled_protocols is not None:
            pulumi.set(__self__, "enabled_protocols", enabled_protocols)

    @property
    @pulumi.getter(name="clearTracks")
    def clear_tracks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TrackSelectionArgs']]]]:
        """
        Representing which tracks should not be encrypted
        """
        return pulumi.get(self, "clear_tracks")

    @clear_tracks.setter
    def clear_tracks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TrackSelectionArgs']]]]):
        pulumi.set(self, "clear_tracks", value)

    @property
    @pulumi.getter(name="contentKeys")
    def content_keys(self) -> Optional[pulumi.Input['StreamingPolicyContentKeysArgs']]:
        """
        Representing default content key for each encryption scheme and separate content keys for specific tracks
        """
        return pulumi.get(self, "content_keys")

    @content_keys.setter
    def content_keys(self, value: Optional[pulumi.Input['StreamingPolicyContentKeysArgs']]):
        pulumi.set(self, "content_keys", value)

    @property
    @pulumi.getter(name="customKeyAcquisitionUrlTemplate")
    def custom_key_acquisition_url_template(self) -> Optional[pulumi.Input[str]]:
        """
        Template for the URL of the custom service delivering keys to end user players.  Not required when using Azure Media Services for issuing keys.  The template supports replaceable tokens that the service will update at runtime with the value specific to the request.  The currently supported token values are {AlternativeMediaId}, which is replaced with the value of StreamingLocatorId.AlternativeMediaId, and {ContentKeyId}, which is replaced with the value of identifier of the key being requested.
        """
        return pulumi.get(self, "custom_key_acquisition_url_template")

    @custom_key_acquisition_url_template.setter
    def custom_key_acquisition_url_template(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "custom_key_acquisition_url_template", value)

    @property
    @pulumi.getter(name="enabledProtocols")
    def enabled_protocols(self) -> Optional[pulumi.Input['EnabledProtocolsArgs']]:
        """
        Representing supported protocols
        """
        return pulumi.get(self, "enabled_protocols")

    @enabled_protocols.setter
    def enabled_protocols(self, value: Optional[pulumi.Input['EnabledProtocolsArgs']]):
        pulumi.set(self, "enabled_protocols", value)


@pulumi.input_type
class FaceDetectorPresetArgs:
    def __init__(__self__, *,
                 odata_type: pulumi.Input[str],
                 blur_type: Optional[pulumi.Input[Union[str, 'BlurType']]] = None,
                 experimental_options: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 mode: Optional[pulumi.Input[Union[str, 'FaceRedactorMode']]] = None,
                 resolution: Optional[pulumi.Input[Union[str, 'AnalysisResolution']]] = None):
        """
        Describes all the settings to be used when analyzing a video in order to detect (and optionally redact) all the faces present.
        :param pulumi.Input[str] odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.FaceDetectorPreset'.
        :param pulumi.Input[Union[str, 'BlurType']] blur_type: Blur type
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] experimental_options: Dictionary containing key value pairs for parameters not exposed in the preset itself
        :param pulumi.Input[Union[str, 'FaceRedactorMode']] mode: This mode provides the ability to choose between the following settings: 1) Analyze - For detection only.This mode generates a metadata JSON file marking appearances of faces throughout the video.Where possible, appearances of the same person are assigned the same ID. 2) Combined - Additionally redacts(blurs) detected faces. 3) Redact - This enables a 2-pass process, allowing for selective redaction of a subset of detected faces.It takes in the metadata file from a prior analyze pass, along with the source video, and a user-selected subset of IDs that require redaction.
        :param pulumi.Input[Union[str, 'AnalysisResolution']] resolution: Specifies the maximum resolution at which your video is analyzed. The default behavior is "SourceResolution," which will keep the input video at its original resolution when analyzed. Using "StandardDefinition" will resize input videos to standard definition while preserving the appropriate aspect ratio. It will only resize if the video is of higher resolution. For example, a 1920x1080 input would be scaled to 640x360 before processing. Switching to "StandardDefinition" will reduce the time it takes to process high resolution video. It may also reduce the cost of using this component (see https://azure.microsoft.com/en-us/pricing/details/media-services/#analytics for details). However, faces that end up being too small in the resized video may not be detected.
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.FaceDetectorPreset')
        if blur_type is not None:
            pulumi.set(__self__, "blur_type", blur_type)
        if experimental_options is not None:
            pulumi.set(__self__, "experimental_options", experimental_options)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if resolution is not None:
            pulumi.set(__self__, "resolution", resolution)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> pulumi.Input[str]:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.FaceDetectorPreset'.
        """
        return pulumi.get(self, "odata_type")

    @odata_type.setter
    def odata_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "odata_type", value)

    @property
    @pulumi.getter(name="blurType")
    def blur_type(self) -> Optional[pulumi.Input[Union[str, 'BlurType']]]:
        """
        Blur type
        """
        return pulumi.get(self, "blur_type")

    @blur_type.setter
    def blur_type(self, value: Optional[pulumi.Input[Union[str, 'BlurType']]]):
        pulumi.set(self, "blur_type", value)

    @property
    @pulumi.getter(name="experimentalOptions")
    def experimental_options(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Dictionary containing key value pairs for parameters not exposed in the preset itself
        """
        return pulumi.get(self, "experimental_options")

    @experimental_options.setter
    def experimental_options(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "experimental_options", value)

    @property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input[Union[str, 'FaceRedactorMode']]]:
        """
        This mode provides the ability to choose between the following settings: 1) Analyze - For detection only.This mode generates a metadata JSON file marking appearances of faces throughout the video.Where possible, appearances of the same person are assigned the same ID. 2) Combined - Additionally redacts(blurs) detected faces. 3) Redact - This enables a 2-pass process, allowing for selective redaction of a subset of detected faces.It takes in the metadata file from a prior analyze pass, along with the source video, and a user-selected subset of IDs that require redaction.
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input[Union[str, 'FaceRedactorMode']]]):
        pulumi.set(self, "mode", value)

    @property
    @pulumi.getter
    def resolution(self) -> Optional[pulumi.Input[Union[str, 'AnalysisResolution']]]:
        """
        Specifies the maximum resolution at which your video is analyzed. The default behavior is "SourceResolution," which will keep the input video at its original resolution when analyzed. Using "StandardDefinition" will resize input videos to standard definition while preserving the appropriate aspect ratio. It will only resize if the video is of higher resolution. For example, a 1920x1080 input would be scaled to 640x360 before processing. Switching to "StandardDefinition" will reduce the time it takes to process high resolution video. It may also reduce the cost of using this component (see https://azure.microsoft.com/en-us/pricing/details/media-services/#analytics for details). However, faces that end up being too small in the resized video may not be detected.
        """
        return pulumi.get(self, "resolution")

    @resolution.setter
    def resolution(self, value: Optional[pulumi.Input[Union[str, 'AnalysisResolution']]]):
        pulumi.set(self, "resolution", value)


@pulumi.input_type
class FilterTrackPropertyConditionArgs:
    def __init__(__self__, *,
                 operation: pulumi.Input[Union[str, 'FilterTrackPropertyCompareOperation']],
                 property: pulumi.Input[Union[str, 'FilterTrackPropertyType']],
                 value: pulumi.Input[str]):
        """
        The class to specify one track property condition.
        :param pulumi.Input[Union[str, 'FilterTrackPropertyCompareOperation']] operation: The track property condition operation.
        :param pulumi.Input[Union[str, 'FilterTrackPropertyType']] property: The track property type.
        :param pulumi.Input[str] value: The track property value.
        """
        pulumi.set(__self__, "operation", operation)
        pulumi.set(__self__, "property", property)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def operation(self) -> pulumi.Input[Union[str, 'FilterTrackPropertyCompareOperation']]:
        """
        The track property condition operation.
        """
        return pulumi.get(self, "operation")

    @operation.setter
    def operation(self, value: pulumi.Input[Union[str, 'FilterTrackPropertyCompareOperation']]):
        pulumi.set(self, "operation", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        The track property value.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)

    @property
    @pulumi.getter
    def property(self) -> pulumi.Input[Union[str, 'FilterTrackPropertyType']]:
        """
        The track property type.
        """
        return pulumi.get(self, "property")

    @property.setter
    def property(self, value: pulumi.Input[Union[str, 'FilterTrackPropertyType']]):
        pulumi.set(self, "property", value)


@pulumi.input_type
class FilterTrackSelectionArgs:
    def __init__(__self__, *,
                 track_selections: pulumi.Input[Sequence[pulumi.Input['FilterTrackPropertyConditionArgs']]]):
        """
        Representing a list of FilterTrackPropertyConditions to select a track.  The filters are combined using a logical AND operation.
        :param pulumi.Input[Sequence[pulumi.Input['FilterTrackPropertyConditionArgs']]] track_selections: The track selections.
        """
        pulumi.set(__self__, "track_selections", track_selections)

    @property
    @pulumi.getter(name="trackSelections")
    def track_selections(self) -> pulumi.Input[Sequence[pulumi.Input['FilterTrackPropertyConditionArgs']]]:
        """
        The track selections.
        """
        return pulumi.get(self, "track_selections")

    @track_selections.setter
    def track_selections(self, value: pulumi.Input[Sequence[pulumi.Input['FilterTrackPropertyConditionArgs']]]):
        pulumi.set(self, "track_selections", value)


@pulumi.input_type
class FiltersArgs:
    def __init__(__self__, *,
                 crop: Optional[pulumi.Input['RectangleArgs']] = None,
                 deinterlace: Optional[pulumi.Input['DeinterlaceArgs']] = None,
                 overlays: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AudioOverlayArgs', 'VideoOverlayArgs']]]]] = None,
                 rotation: Optional[pulumi.Input[Union[str, 'Rotation']]] = None):
        """
        Describes all the filtering operations, such as de-interlacing, rotation etc. that are to be applied to the input media before encoding.
        :param pulumi.Input['RectangleArgs'] crop: The parameters for the rectangular window with which to crop the input video.
        :param pulumi.Input['DeinterlaceArgs'] deinterlace: The de-interlacing settings.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AudioOverlayArgs', 'VideoOverlayArgs']]]] overlays: The properties of overlays to be applied to the input video. These could be audio, image or video overlays.
        :param pulumi.Input[Union[str, 'Rotation']] rotation: The rotation, if any, to be applied to the input video, before it is encoded. Default is Auto
        """
        if crop is not None:
            pulumi.set(__self__, "crop", crop)
        if deinterlace is not None:
            pulumi.set(__self__, "deinterlace", deinterlace)
        if overlays is not None:
            pulumi.set(__self__, "overlays", overlays)
        if rotation is not None:
            pulumi.set(__self__, "rotation", rotation)

    @property
    @pulumi.getter
    def crop(self) -> Optional[pulumi.Input['RectangleArgs']]:
        """
        The parameters for the rectangular window with which to crop the input video.
        """
        return pulumi.get(self, "crop")

    @crop.setter
    def crop(self, value: Optional[pulumi.Input['RectangleArgs']]):
        pulumi.set(self, "crop", value)

    @property
    @pulumi.getter
    def deinterlace(self) -> Optional[pulumi.Input['DeinterlaceArgs']]:
        """
        The de-interlacing settings.
        """
        return pulumi.get(self, "deinterlace")

    @deinterlace.setter
    def deinterlace(self, value: Optional[pulumi.Input['DeinterlaceArgs']]):
        pulumi.set(self, "deinterlace", value)

    @property
    @pulumi.getter
    def overlays(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Union['AudioOverlayArgs', 'VideoOverlayArgs']]]]]:
        """
        The properties of overlays to be applied to the input video. These could be audio, image or video overlays.
        """
        return pulumi.get(self, "overlays")

    @overlays.setter
    def overlays(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AudioOverlayArgs', 'VideoOverlayArgs']]]]]):
        pulumi.set(self, "overlays", value)

    @property
    @pulumi.getter
    def rotation(self) -> Optional[pulumi.Input[Union[str, 'Rotation']]]:
        """
        The rotation, if any, to be applied to the input video, before it is encoded. Default is Auto
        """
        return pulumi.get(self, "rotation")

    @rotation.setter
    def rotation(self, value: Optional[pulumi.Input[Union[str, 'Rotation']]]):
        pulumi.set(self, "rotation", value)


@pulumi.input_type
class FirstQualityArgs:
    def __init__(__self__, *,
                 bitrate: pulumi.Input[int]):
        """
        Filter First Quality
        :param pulumi.Input[int] bitrate: The first quality bitrate.
        """
        pulumi.set(__self__, "bitrate", bitrate)

    @property
    @pulumi.getter
    def bitrate(self) -> pulumi.Input[int]:
        """
        The first quality bitrate.
        """
        return pulumi.get(self, "bitrate")

    @bitrate.setter
    def bitrate(self, value: pulumi.Input[int]):
        pulumi.set(self, "bitrate", value)


@pulumi.input_type
class FromAllInputFileArgs:
    def __init__(__self__, *,
                 odata_type: pulumi.Input[str],
                 included_tracks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AudioTrackDescriptorArgs', 'SelectAudioTrackByAttributeArgs', 'SelectAudioTrackByIdArgs', 'SelectVideoTrackByAttributeArgs', 'SelectVideoTrackByIdArgs', 'VideoTrackDescriptorArgs']]]]] = None):
        """
        An InputDefinition that looks across all of the files provided to select tracks specified by the IncludedTracks property. Generally used with the AudioTrackByAttribute and VideoTrackByAttribute to allow selection of a single track across a set of input files.
        :param pulumi.Input[str] odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.FromAllInputFile'.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AudioTrackDescriptorArgs', 'SelectAudioTrackByAttributeArgs', 'SelectAudioTrackByIdArgs', 'SelectVideoTrackByAttributeArgs', 'SelectVideoTrackByIdArgs', 'VideoTrackDescriptorArgs']]]] included_tracks: The list of TrackDescriptors which define the metadata and selection of tracks in the input.
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.FromAllInputFile')
        if included_tracks is not None:
            pulumi.set(__self__, "included_tracks", included_tracks)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> pulumi.Input[str]:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.FromAllInputFile'.
        """
        return pulumi.get(self, "odata_type")

    @odata_type.setter
    def odata_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "odata_type", value)

    @property
    @pulumi.getter(name="includedTracks")
    def included_tracks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Union['AudioTrackDescriptorArgs', 'SelectAudioTrackByAttributeArgs', 'SelectAudioTrackByIdArgs', 'SelectVideoTrackByAttributeArgs', 'SelectVideoTrackByIdArgs', 'VideoTrackDescriptorArgs']]]]]:
        """
        The list of TrackDescriptors which define the metadata and selection of tracks in the input.
        """
        return pulumi.get(self, "included_tracks")

    @included_tracks.setter
    def included_tracks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AudioTrackDescriptorArgs', 'SelectAudioTrackByAttributeArgs', 'SelectAudioTrackByIdArgs', 'SelectVideoTrackByAttributeArgs', 'SelectVideoTrackByIdArgs', 'VideoTrackDescriptorArgs']]]]]):
        pulumi.set(self, "included_tracks", value)


@pulumi.input_type
class FromEachInputFileArgs:
    def __init__(__self__, *,
                 odata_type: pulumi.Input[str],
                 included_tracks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AudioTrackDescriptorArgs', 'SelectAudioTrackByAttributeArgs', 'SelectAudioTrackByIdArgs', 'SelectVideoTrackByAttributeArgs', 'SelectVideoTrackByIdArgs', 'VideoTrackDescriptorArgs']]]]] = None):
        """
        An InputDefinition that looks at each input file provided to select tracks specified by the IncludedTracks property. Generally used with the AudioTrackByAttribute and VideoTrackByAttribute to select tracks from each file given.
        :param pulumi.Input[str] odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.FromEachInputFile'.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AudioTrackDescriptorArgs', 'SelectAudioTrackByAttributeArgs', 'SelectAudioTrackByIdArgs', 'SelectVideoTrackByAttributeArgs', 'SelectVideoTrackByIdArgs', 'VideoTrackDescriptorArgs']]]] included_tracks: The list of TrackDescriptors which define the metadata and selection of tracks in the input.
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.FromEachInputFile')
        if included_tracks is not None:
            pulumi.set(__self__, "included_tracks", included_tracks)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> pulumi.Input[str]:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.FromEachInputFile'.
        """
        return pulumi.get(self, "odata_type")

    @odata_type.setter
    def odata_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "odata_type", value)

    @property
    @pulumi.getter(name="includedTracks")
    def included_tracks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Union['AudioTrackDescriptorArgs', 'SelectAudioTrackByAttributeArgs', 'SelectAudioTrackByIdArgs', 'SelectVideoTrackByAttributeArgs', 'SelectVideoTrackByIdArgs', 'VideoTrackDescriptorArgs']]]]]:
        """
        The list of TrackDescriptors which define the metadata and selection of tracks in the input.
        """
        return pulumi.get(self, "included_tracks")

    @included_tracks.setter
    def included_tracks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AudioTrackDescriptorArgs', 'SelectAudioTrackByAttributeArgs', 'SelectAudioTrackByIdArgs', 'SelectVideoTrackByAttributeArgs', 'SelectVideoTrackByIdArgs', 'VideoTrackDescriptorArgs']]]]]):
        pulumi.set(self, "included_tracks", value)


@pulumi.input_type
class H264LayerArgs:
    def __init__(__self__, *,
                 bitrate: pulumi.Input[int],
                 adaptive_b_frame: Optional[pulumi.Input[bool]] = None,
                 b_frames: Optional[pulumi.Input[int]] = None,
                 buffer_window: Optional[pulumi.Input[str]] = None,
                 crf: Optional[pulumi.Input[float]] = None,
                 entropy_mode: Optional[pulumi.Input[Union[str, 'EntropyMode']]] = None,
                 frame_rate: Optional[pulumi.Input[str]] = None,
                 height: Optional[pulumi.Input[str]] = None,
                 label: Optional[pulumi.Input[str]] = None,
                 level: Optional[pulumi.Input[str]] = None,
                 max_bitrate: Optional[pulumi.Input[int]] = None,
                 profile: Optional[pulumi.Input[Union[str, 'H264VideoProfile']]] = None,
                 reference_frames: Optional[pulumi.Input[int]] = None,
                 slices: Optional[pulumi.Input[int]] = None,
                 width: Optional[pulumi.Input[str]] = None):
        """
        Describes the settings to be used when encoding the input video into a desired output bitrate layer with the H.264 video codec.
        :param pulumi.Input[int] bitrate: The average bitrate in bits per second at which to encode the input video when generating this layer. This is a required field.
        :param pulumi.Input[bool] adaptive_b_frame: Whether or not adaptive B-frames are to be used when encoding this layer. If not specified, the encoder will turn it on whenever the video profile permits its use.
        :param pulumi.Input[int] b_frames: The number of B-frames to be used when encoding this layer.  If not specified, the encoder chooses an appropriate number based on the video profile and level.
        :param pulumi.Input[str] buffer_window: The VBV buffer window length. The value should be in ISO 8601 format. The value should be in the range [0.1-100] seconds. The default is 5 seconds (for example, PT5S).
        :param pulumi.Input[float] crf: The value of CRF to be used when encoding this layer. This setting takes effect when RateControlMode of video codec is set at CRF mode. The range of CRF value is between 0 and 51, where lower values would result in better quality, at the expense of higher file sizes. Higher values mean more compression, but at some point quality degradation will be noticed. Default value is 23.
        :param pulumi.Input[Union[str, 'EntropyMode']] entropy_mode: The entropy mode to be used for this layer. If not specified, the encoder chooses the mode that is appropriate for the profile and level.
        :param pulumi.Input[str] frame_rate: The frame rate (in frames per second) at which to encode this layer. The value can be in the form of M/N where M and N are integers (For example, 30000/1001), or in the form of a number (For example, 30, or 29.97). The encoder enforces constraints on allowed frame rates based on the profile and level. If it is not specified, the encoder will use the same frame rate as the input video.
        :param pulumi.Input[str] height: The height of the output video for this layer. The value can be absolute (in pixels) or relative (in percentage). For example 50% means the output video has half as many pixels in height as the input.
        :param pulumi.Input[str] label: The alphanumeric label for this layer, which can be used in multiplexing different video and audio layers, or in naming the output file.
        :param pulumi.Input[str] level: We currently support Level up to 6.2. The value can be Auto, or a number that matches the H.264 profile. If not specified, the default is Auto, which lets the encoder choose the Level that is appropriate for this layer.
        :param pulumi.Input[int] max_bitrate: The maximum bitrate (in bits per second), at which the VBV buffer should be assumed to refill. If not specified, defaults to the same value as bitrate.
        :param pulumi.Input[Union[str, 'H264VideoProfile']] profile: We currently support Baseline, Main, High, High422, High444. Default is Auto.
        :param pulumi.Input[int] reference_frames: The number of reference frames to be used when encoding this layer. If not specified, the encoder determines an appropriate number based on the encoder complexity setting.
        :param pulumi.Input[int] slices: The number of slices to be used when encoding this layer. If not specified, default is zero, which means that encoder will use a single slice for each frame.
        :param pulumi.Input[str] width: The width of the output video for this layer. The value can be absolute (in pixels) or relative (in percentage). For example 50% means the output video has half as many pixels in width as the input.
        """
        pulumi.set(__self__, "bitrate", bitrate)
        if adaptive_b_frame is not None:
            pulumi.set(__self__, "adaptive_b_frame", adaptive_b_frame)
        if b_frames is not None:
            pulumi.set(__self__, "b_frames", b_frames)
        if buffer_window is not None:
            pulumi.set(__self__, "buffer_window", buffer_window)
        if crf is not None:
            pulumi.set(__self__, "crf", crf)
        if entropy_mode is not None:
            pulumi.set(__self__, "entropy_mode", entropy_mode)
        if frame_rate is not None:
            pulumi.set(__self__, "frame_rate", frame_rate)
        if height is not None:
            pulumi.set(__self__, "height", height)
        if label is not None:
            pulumi.set(__self__, "label", label)
        if level is not None:
            pulumi.set(__self__, "level", level)
        if max_bitrate is not None:
            pulumi.set(__self__, "max_bitrate", max_bitrate)
        if profile is not None:
            pulumi.set(__self__, "profile", profile)
        if reference_frames is not None:
            pulumi.set(__self__, "reference_frames", reference_frames)
        if slices is not None:
            pulumi.set(__self__, "slices", slices)
        if width is not None:
            pulumi.set(__self__, "width", width)

    @property
    @pulumi.getter
    def bitrate(self) -> pulumi.Input[int]:
        """
        The average bitrate in bits per second at which to encode the input video when generating this layer. This is a required field.
        """
        return pulumi.get(self, "bitrate")

    @bitrate.setter
    def bitrate(self, value: pulumi.Input[int]):
        pulumi.set(self, "bitrate", value)

    @property
    @pulumi.getter(name="adaptiveBFrame")
    def adaptive_b_frame(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not adaptive B-frames are to be used when encoding this layer. If not specified, the encoder will turn it on whenever the video profile permits its use.
        """
        return pulumi.get(self, "adaptive_b_frame")

    @adaptive_b_frame.setter
    def adaptive_b_frame(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "adaptive_b_frame", value)

    @property
    @pulumi.getter(name="bFrames")
    def b_frames(self) -> Optional[pulumi.Input[int]]:
        """
        The number of B-frames to be used when encoding this layer.  If not specified, the encoder chooses an appropriate number based on the video profile and level.
        """
        return pulumi.get(self, "b_frames")

    @b_frames.setter
    def b_frames(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "b_frames", value)

    @property
    @pulumi.getter(name="bufferWindow")
    def buffer_window(self) -> Optional[pulumi.Input[str]]:
        """
        The VBV buffer window length. The value should be in ISO 8601 format. The value should be in the range [0.1-100] seconds. The default is 5 seconds (for example, PT5S).
        """
        return pulumi.get(self, "buffer_window")

    @buffer_window.setter
    def buffer_window(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "buffer_window", value)

    @property
    @pulumi.getter
    def crf(self) -> Optional[pulumi.Input[float]]:
        """
        The value of CRF to be used when encoding this layer. This setting takes effect when RateControlMode of video codec is set at CRF mode. The range of CRF value is between 0 and 51, where lower values would result in better quality, at the expense of higher file sizes. Higher values mean more compression, but at some point quality degradation will be noticed. Default value is 23.
        """
        return pulumi.get(self, "crf")

    @crf.setter
    def crf(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "crf", value)

    @property
    @pulumi.getter(name="entropyMode")
    def entropy_mode(self) -> Optional[pulumi.Input[Union[str, 'EntropyMode']]]:
        """
        The entropy mode to be used for this layer. If not specified, the encoder chooses the mode that is appropriate for the profile and level.
        """
        return pulumi.get(self, "entropy_mode")

    @entropy_mode.setter
    def entropy_mode(self, value: Optional[pulumi.Input[Union[str, 'EntropyMode']]]):
        pulumi.set(self, "entropy_mode", value)

    @property
    @pulumi.getter(name="frameRate")
    def frame_rate(self) -> Optional[pulumi.Input[str]]:
        """
        The frame rate (in frames per second) at which to encode this layer. The value can be in the form of M/N where M and N are integers (For example, 30000/1001), or in the form of a number (For example, 30, or 29.97). The encoder enforces constraints on allowed frame rates based on the profile and level. If it is not specified, the encoder will use the same frame rate as the input video.
        """
        return pulumi.get(self, "frame_rate")

    @frame_rate.setter
    def frame_rate(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "frame_rate", value)

    @property
    @pulumi.getter
    def height(self) -> Optional[pulumi.Input[str]]:
        """
        The height of the output video for this layer. The value can be absolute (in pixels) or relative (in percentage). For example 50% means the output video has half as many pixels in height as the input.
        """
        return pulumi.get(self, "height")

    @height.setter
    def height(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "height", value)

    @property
    @pulumi.getter
    def label(self) -> Optional[pulumi.Input[str]]:
        """
        The alphanumeric label for this layer, which can be used in multiplexing different video and audio layers, or in naming the output file.
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "label", value)

    @property
    @pulumi.getter
    def level(self) -> Optional[pulumi.Input[str]]:
        """
        We currently support Level up to 6.2. The value can be Auto, or a number that matches the H.264 profile. If not specified, the default is Auto, which lets the encoder choose the Level that is appropriate for this layer.
        """
        return pulumi.get(self, "level")

    @level.setter
    def level(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "level", value)

    @property
    @pulumi.getter(name="maxBitrate")
    def max_bitrate(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum bitrate (in bits per second), at which the VBV buffer should be assumed to refill. If not specified, defaults to the same value as bitrate.
        """
        return pulumi.get(self, "max_bitrate")

    @max_bitrate.setter
    def max_bitrate(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_bitrate", value)

    @property
    @pulumi.getter
    def profile(self) -> Optional[pulumi.Input[Union[str, 'H264VideoProfile']]]:
        """
        We currently support Baseline, Main, High, High422, High444. Default is Auto.
        """
        return pulumi.get(self, "profile")

    @profile.setter
    def profile(self, value: Optional[pulumi.Input[Union[str, 'H264VideoProfile']]]):
        pulumi.set(self, "profile", value)

    @property
    @pulumi.getter(name="referenceFrames")
    def reference_frames(self) -> Optional[pulumi.Input[int]]:
        """
        The number of reference frames to be used when encoding this layer. If not specified, the encoder determines an appropriate number based on the encoder complexity setting.
        """
        return pulumi.get(self, "reference_frames")

    @reference_frames.setter
    def reference_frames(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "reference_frames", value)

    @property
    @pulumi.getter
    def slices(self) -> Optional[pulumi.Input[int]]:
        """
        The number of slices to be used when encoding this layer. If not specified, default is zero, which means that encoder will use a single slice for each frame.
        """
        return pulumi.get(self, "slices")

    @slices.setter
    def slices(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "slices", value)

    @property
    @pulumi.getter
    def width(self) -> Optional[pulumi.Input[str]]:
        """
        The width of the output video for this layer. The value can be absolute (in pixels) or relative (in percentage). For example 50% means the output video has half as many pixels in width as the input.
        """
        return pulumi.get(self, "width")

    @width.setter
    def width(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "width", value)


@pulumi.input_type
class H264VideoArgs:
    def __init__(__self__, *,
                 odata_type: pulumi.Input[str],
                 complexity: Optional[pulumi.Input[Union[str, 'H264Complexity']]] = None,
                 key_frame_interval: Optional[pulumi.Input[str]] = None,
                 label: Optional[pulumi.Input[str]] = None,
                 layers: Optional[pulumi.Input[Sequence[pulumi.Input['H264LayerArgs']]]] = None,
                 rate_control_mode: Optional[pulumi.Input[Union[str, 'H264RateControlMode']]] = None,
                 scene_change_detection: Optional[pulumi.Input[bool]] = None,
                 stretch_mode: Optional[pulumi.Input[Union[str, 'StretchMode']]] = None,
                 sync_mode: Optional[pulumi.Input[Union[str, 'VideoSyncMode']]] = None):
        """
        Describes all the properties for encoding a video with the H.264 codec.
        :param pulumi.Input[str] odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.H264Video'.
        :param pulumi.Input[Union[str, 'H264Complexity']] complexity: Tells the encoder how to choose its encoding settings. The default value is Balanced.
        :param pulumi.Input[str] key_frame_interval: The distance between two key frames. The value should be non-zero in the range [0.5, 20] seconds, specified in ISO 8601 format. The default is 2 seconds(PT2S). Note that this setting is ignored if VideoSyncMode.Passthrough is set, where the KeyFrameInterval value will follow the input source setting.
        :param pulumi.Input[str] label: An optional label for the codec. The label can be used to control muxing behavior.
        :param pulumi.Input[Sequence[pulumi.Input['H264LayerArgs']]] layers: The collection of output H.264 layers to be produced by the encoder.
        :param pulumi.Input[Union[str, 'H264RateControlMode']] rate_control_mode: The video rate control mode
        :param pulumi.Input[bool] scene_change_detection: Whether or not the encoder should insert key frames at scene changes. If not specified, the default is false. This flag should be set to true only when the encoder is being configured to produce a single output video.
        :param pulumi.Input[Union[str, 'StretchMode']] stretch_mode: The resizing mode - how the input video will be resized to fit the desired output resolution(s). Default is AutoSize
        :param pulumi.Input[Union[str, 'VideoSyncMode']] sync_mode: The Video Sync Mode
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.H264Video')
        if complexity is not None:
            pulumi.set(__self__, "complexity", complexity)
        if key_frame_interval is not None:
            pulumi.set(__self__, "key_frame_interval", key_frame_interval)
        if label is not None:
            pulumi.set(__self__, "label", label)
        if layers is not None:
            pulumi.set(__self__, "layers", layers)
        if rate_control_mode is not None:
            pulumi.set(__self__, "rate_control_mode", rate_control_mode)
        if scene_change_detection is not None:
            pulumi.set(__self__, "scene_change_detection", scene_change_detection)
        if stretch_mode is not None:
            pulumi.set(__self__, "stretch_mode", stretch_mode)
        if sync_mode is not None:
            pulumi.set(__self__, "sync_mode", sync_mode)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> pulumi.Input[str]:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.H264Video'.
        """
        return pulumi.get(self, "odata_type")

    @odata_type.setter
    def odata_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "odata_type", value)

    @property
    @pulumi.getter
    def complexity(self) -> Optional[pulumi.Input[Union[str, 'H264Complexity']]]:
        """
        Tells the encoder how to choose its encoding settings. The default value is Balanced.
        """
        return pulumi.get(self, "complexity")

    @complexity.setter
    def complexity(self, value: Optional[pulumi.Input[Union[str, 'H264Complexity']]]):
        pulumi.set(self, "complexity", value)

    @property
    @pulumi.getter(name="keyFrameInterval")
    def key_frame_interval(self) -> Optional[pulumi.Input[str]]:
        """
        The distance between two key frames. The value should be non-zero in the range [0.5, 20] seconds, specified in ISO 8601 format. The default is 2 seconds(PT2S). Note that this setting is ignored if VideoSyncMode.Passthrough is set, where the KeyFrameInterval value will follow the input source setting.
        """
        return pulumi.get(self, "key_frame_interval")

    @key_frame_interval.setter
    def key_frame_interval(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_frame_interval", value)

    @property
    @pulumi.getter
    def label(self) -> Optional[pulumi.Input[str]]:
        """
        An optional label for the codec. The label can be used to control muxing behavior.
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "label", value)

    @property
    @pulumi.getter
    def layers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['H264LayerArgs']]]]:
        """
        The collection of output H.264 layers to be produced by the encoder.
        """
        return pulumi.get(self, "layers")

    @layers.setter
    def layers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['H264LayerArgs']]]]):
        pulumi.set(self, "layers", value)

    @property
    @pulumi.getter(name="rateControlMode")
    def rate_control_mode(self) -> Optional[pulumi.Input[Union[str, 'H264RateControlMode']]]:
        """
        The video rate control mode
        """
        return pulumi.get(self, "rate_control_mode")

    @rate_control_mode.setter
    def rate_control_mode(self, value: Optional[pulumi.Input[Union[str, 'H264RateControlMode']]]):
        pulumi.set(self, "rate_control_mode", value)

    @property
    @pulumi.getter(name="sceneChangeDetection")
    def scene_change_detection(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not the encoder should insert key frames at scene changes. If not specified, the default is false. This flag should be set to true only when the encoder is being configured to produce a single output video.
        """
        return pulumi.get(self, "scene_change_detection")

    @scene_change_detection.setter
    def scene_change_detection(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "scene_change_detection", value)

    @property
    @pulumi.getter(name="stretchMode")
    def stretch_mode(self) -> Optional[pulumi.Input[Union[str, 'StretchMode']]]:
        """
        The resizing mode - how the input video will be resized to fit the desired output resolution(s). Default is AutoSize
        """
        return pulumi.get(self, "stretch_mode")

    @stretch_mode.setter
    def stretch_mode(self, value: Optional[pulumi.Input[Union[str, 'StretchMode']]]):
        pulumi.set(self, "stretch_mode", value)

    @property
    @pulumi.getter(name="syncMode")
    def sync_mode(self) -> Optional[pulumi.Input[Union[str, 'VideoSyncMode']]]:
        """
        The Video Sync Mode
        """
        return pulumi.get(self, "sync_mode")

    @sync_mode.setter
    def sync_mode(self, value: Optional[pulumi.Input[Union[str, 'VideoSyncMode']]]):
        pulumi.set(self, "sync_mode", value)


@pulumi.input_type
class H265LayerArgs:
    def __init__(__self__, *,
                 bitrate: pulumi.Input[int],
                 adaptive_b_frame: Optional[pulumi.Input[bool]] = None,
                 b_frames: Optional[pulumi.Input[int]] = None,
                 buffer_window: Optional[pulumi.Input[str]] = None,
                 crf: Optional[pulumi.Input[float]] = None,
                 frame_rate: Optional[pulumi.Input[str]] = None,
                 height: Optional[pulumi.Input[str]] = None,
                 label: Optional[pulumi.Input[str]] = None,
                 level: Optional[pulumi.Input[str]] = None,
                 max_bitrate: Optional[pulumi.Input[int]] = None,
                 profile: Optional[pulumi.Input[Union[str, 'H265VideoProfile']]] = None,
                 reference_frames: Optional[pulumi.Input[int]] = None,
                 slices: Optional[pulumi.Input[int]] = None,
                 width: Optional[pulumi.Input[str]] = None):
        """
        Describes the settings to be used when encoding the input video into a desired output bitrate layer with the H.265 video codec.
        :param pulumi.Input[int] bitrate: The average bitrate in bits per second at which to encode the input video when generating this layer. For example: a target bitrate of 3000Kbps or 3Mbps means this value should be 3000000 This is a required field.
        :param pulumi.Input[bool] adaptive_b_frame: Specifies whether or not adaptive B-frames are to be used when encoding this layer. If not specified, the encoder will turn it on whenever the video profile permits its use.
        :param pulumi.Input[int] b_frames: The number of B-frames to be used when encoding this layer.  If not specified, the encoder chooses an appropriate number based on the video profile and level.
        :param pulumi.Input[str] buffer_window: The VBV buffer window length. The value should be in ISO 8601 format. The value should be in the range [0.1-100] seconds. The default is 5 seconds (for example, PT5S).
        :param pulumi.Input[float] crf: The value of CRF to be used when encoding this layer. This setting takes effect when RateControlMode of video codec is set at CRF mode. The range of CRF value is between 0 and 51, where lower values would result in better quality, at the expense of higher file sizes. Higher values mean more compression, but at some point quality degradation will be noticed. Default value is 28.
        :param pulumi.Input[str] frame_rate: The frame rate (in frames per second) at which to encode this layer. The value can be in the form of M/N where M and N are integers (For example, 30000/1001), or in the form of a number (For example, 30, or 29.97). The encoder enforces constraints on allowed frame rates based on the profile and level. If it is not specified, the encoder will use the same frame rate as the input video.
        :param pulumi.Input[str] height: The height of the output video for this layer. The value can be absolute (in pixels) or relative (in percentage). For example 50% means the output video has half as many pixels in height as the input.
        :param pulumi.Input[str] label: The alphanumeric label for this layer, which can be used in multiplexing different video and audio layers, or in naming the output file.
        :param pulumi.Input[str] level: We currently support Level up to 6.2. The value can be Auto, or a number that matches the H.265 profile. If not specified, the default is Auto, which lets the encoder choose the Level that is appropriate for this layer.
        :param pulumi.Input[int] max_bitrate: The maximum bitrate (in bits per second), at which the VBV buffer should be assumed to refill. If not specified, defaults to the same value as bitrate.
        :param pulumi.Input[Union[str, 'H265VideoProfile']] profile: We currently support Main. Default is Auto.
        :param pulumi.Input[int] reference_frames: The number of reference frames to be used when encoding this layer. If not specified, the encoder determines an appropriate number based on the encoder complexity setting.
        :param pulumi.Input[int] slices: The number of slices to be used when encoding this layer. If not specified, default is zero, which means that encoder will use a single slice for each frame.
        :param pulumi.Input[str] width: The width of the output video for this layer. The value can be absolute (in pixels) or relative (in percentage). For example 50% means the output video has half as many pixels in width as the input.
        """
        pulumi.set(__self__, "bitrate", bitrate)
        if adaptive_b_frame is not None:
            pulumi.set(__self__, "adaptive_b_frame", adaptive_b_frame)
        if b_frames is not None:
            pulumi.set(__self__, "b_frames", b_frames)
        if buffer_window is not None:
            pulumi.set(__self__, "buffer_window", buffer_window)
        if crf is not None:
            pulumi.set(__self__, "crf", crf)
        if frame_rate is not None:
            pulumi.set(__self__, "frame_rate", frame_rate)
        if height is not None:
            pulumi.set(__self__, "height", height)
        if label is not None:
            pulumi.set(__self__, "label", label)
        if level is not None:
            pulumi.set(__self__, "level", level)
        if max_bitrate is not None:
            pulumi.set(__self__, "max_bitrate", max_bitrate)
        if profile is not None:
            pulumi.set(__self__, "profile", profile)
        if reference_frames is not None:
            pulumi.set(__self__, "reference_frames", reference_frames)
        if slices is not None:
            pulumi.set(__self__, "slices", slices)
        if width is not None:
            pulumi.set(__self__, "width", width)

    @property
    @pulumi.getter
    def bitrate(self) -> pulumi.Input[int]:
        """
        The average bitrate in bits per second at which to encode the input video when generating this layer. For example: a target bitrate of 3000Kbps or 3Mbps means this value should be 3000000 This is a required field.
        """
        return pulumi.get(self, "bitrate")

    @bitrate.setter
    def bitrate(self, value: pulumi.Input[int]):
        pulumi.set(self, "bitrate", value)

    @property
    @pulumi.getter(name="adaptiveBFrame")
    def adaptive_b_frame(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether or not adaptive B-frames are to be used when encoding this layer. If not specified, the encoder will turn it on whenever the video profile permits its use.
        """
        return pulumi.get(self, "adaptive_b_frame")

    @adaptive_b_frame.setter
    def adaptive_b_frame(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "adaptive_b_frame", value)

    @property
    @pulumi.getter(name="bFrames")
    def b_frames(self) -> Optional[pulumi.Input[int]]:
        """
        The number of B-frames to be used when encoding this layer.  If not specified, the encoder chooses an appropriate number based on the video profile and level.
        """
        return pulumi.get(self, "b_frames")

    @b_frames.setter
    def b_frames(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "b_frames", value)

    @property
    @pulumi.getter(name="bufferWindow")
    def buffer_window(self) -> Optional[pulumi.Input[str]]:
        """
        The VBV buffer window length. The value should be in ISO 8601 format. The value should be in the range [0.1-100] seconds. The default is 5 seconds (for example, PT5S).
        """
        return pulumi.get(self, "buffer_window")

    @buffer_window.setter
    def buffer_window(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "buffer_window", value)

    @property
    @pulumi.getter
    def crf(self) -> Optional[pulumi.Input[float]]:
        """
        The value of CRF to be used when encoding this layer. This setting takes effect when RateControlMode of video codec is set at CRF mode. The range of CRF value is between 0 and 51, where lower values would result in better quality, at the expense of higher file sizes. Higher values mean more compression, but at some point quality degradation will be noticed. Default value is 28.
        """
        return pulumi.get(self, "crf")

    @crf.setter
    def crf(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "crf", value)

    @property
    @pulumi.getter(name="frameRate")
    def frame_rate(self) -> Optional[pulumi.Input[str]]:
        """
        The frame rate (in frames per second) at which to encode this layer. The value can be in the form of M/N where M and N are integers (For example, 30000/1001), or in the form of a number (For example, 30, or 29.97). The encoder enforces constraints on allowed frame rates based on the profile and level. If it is not specified, the encoder will use the same frame rate as the input video.
        """
        return pulumi.get(self, "frame_rate")

    @frame_rate.setter
    def frame_rate(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "frame_rate", value)

    @property
    @pulumi.getter
    def height(self) -> Optional[pulumi.Input[str]]:
        """
        The height of the output video for this layer. The value can be absolute (in pixels) or relative (in percentage). For example 50% means the output video has half as many pixels in height as the input.
        """
        return pulumi.get(self, "height")

    @height.setter
    def height(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "height", value)

    @property
    @pulumi.getter
    def label(self) -> Optional[pulumi.Input[str]]:
        """
        The alphanumeric label for this layer, which can be used in multiplexing different video and audio layers, or in naming the output file.
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "label", value)

    @property
    @pulumi.getter
    def level(self) -> Optional[pulumi.Input[str]]:
        """
        We currently support Level up to 6.2. The value can be Auto, or a number that matches the H.265 profile. If not specified, the default is Auto, which lets the encoder choose the Level that is appropriate for this layer.
        """
        return pulumi.get(self, "level")

    @level.setter
    def level(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "level", value)

    @property
    @pulumi.getter(name="maxBitrate")
    def max_bitrate(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum bitrate (in bits per second), at which the VBV buffer should be assumed to refill. If not specified, defaults to the same value as bitrate.
        """
        return pulumi.get(self, "max_bitrate")

    @max_bitrate.setter
    def max_bitrate(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_bitrate", value)

    @property
    @pulumi.getter
    def profile(self) -> Optional[pulumi.Input[Union[str, 'H265VideoProfile']]]:
        """
        We currently support Main. Default is Auto.
        """
        return pulumi.get(self, "profile")

    @profile.setter
    def profile(self, value: Optional[pulumi.Input[Union[str, 'H265VideoProfile']]]):
        pulumi.set(self, "profile", value)

    @property
    @pulumi.getter(name="referenceFrames")
    def reference_frames(self) -> Optional[pulumi.Input[int]]:
        """
        The number of reference frames to be used when encoding this layer. If not specified, the encoder determines an appropriate number based on the encoder complexity setting.
        """
        return pulumi.get(self, "reference_frames")

    @reference_frames.setter
    def reference_frames(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "reference_frames", value)

    @property
    @pulumi.getter
    def slices(self) -> Optional[pulumi.Input[int]]:
        """
        The number of slices to be used when encoding this layer. If not specified, default is zero, which means that encoder will use a single slice for each frame.
        """
        return pulumi.get(self, "slices")

    @slices.setter
    def slices(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "slices", value)

    @property
    @pulumi.getter
    def width(self) -> Optional[pulumi.Input[str]]:
        """
        The width of the output video for this layer. The value can be absolute (in pixels) or relative (in percentage). For example 50% means the output video has half as many pixels in width as the input.
        """
        return pulumi.get(self, "width")

    @width.setter
    def width(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "width", value)


@pulumi.input_type
class H265VideoArgs:
    def __init__(__self__, *,
                 odata_type: pulumi.Input[str],
                 complexity: Optional[pulumi.Input[Union[str, 'H265Complexity']]] = None,
                 key_frame_interval: Optional[pulumi.Input[str]] = None,
                 label: Optional[pulumi.Input[str]] = None,
                 layers: Optional[pulumi.Input[Sequence[pulumi.Input['H265LayerArgs']]]] = None,
                 scene_change_detection: Optional[pulumi.Input[bool]] = None,
                 stretch_mode: Optional[pulumi.Input[Union[str, 'StretchMode']]] = None,
                 sync_mode: Optional[pulumi.Input[Union[str, 'VideoSyncMode']]] = None):
        """
        Describes all the properties for encoding a video with the H.265 codec.
        :param pulumi.Input[str] odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.H265Video'.
        :param pulumi.Input[Union[str, 'H265Complexity']] complexity: Tells the encoder how to choose its encoding settings.  Quality will provide for a higher compression ratio but at a higher cost and longer compute time.  Speed will produce a relatively larger file but is faster and more economical. The default value is Balanced.
        :param pulumi.Input[str] key_frame_interval: The distance between two key frames. The value should be non-zero in the range [0.5, 20] seconds, specified in ISO 8601 format. The default is 2 seconds(PT2S). Note that this setting is ignored if VideoSyncMode.Passthrough is set, where the KeyFrameInterval value will follow the input source setting.
        :param pulumi.Input[str] label: An optional label for the codec. The label can be used to control muxing behavior.
        :param pulumi.Input[Sequence[pulumi.Input['H265LayerArgs']]] layers: The collection of output H.265 layers to be produced by the encoder.
        :param pulumi.Input[bool] scene_change_detection: Specifies whether or not the encoder should insert key frames at scene changes. If not specified, the default is false. This flag should be set to true only when the encoder is being configured to produce a single output video.
        :param pulumi.Input[Union[str, 'StretchMode']] stretch_mode: The resizing mode - how the input video will be resized to fit the desired output resolution(s). Default is AutoSize
        :param pulumi.Input[Union[str, 'VideoSyncMode']] sync_mode: The Video Sync Mode
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.H265Video')
        if complexity is not None:
            pulumi.set(__self__, "complexity", complexity)
        if key_frame_interval is not None:
            pulumi.set(__self__, "key_frame_interval", key_frame_interval)
        if label is not None:
            pulumi.set(__self__, "label", label)
        if layers is not None:
            pulumi.set(__self__, "layers", layers)
        if scene_change_detection is not None:
            pulumi.set(__self__, "scene_change_detection", scene_change_detection)
        if stretch_mode is not None:
            pulumi.set(__self__, "stretch_mode", stretch_mode)
        if sync_mode is not None:
            pulumi.set(__self__, "sync_mode", sync_mode)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> pulumi.Input[str]:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.H265Video'.
        """
        return pulumi.get(self, "odata_type")

    @odata_type.setter
    def odata_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "odata_type", value)

    @property
    @pulumi.getter
    def complexity(self) -> Optional[pulumi.Input[Union[str, 'H265Complexity']]]:
        """
        Tells the encoder how to choose its encoding settings.  Quality will provide for a higher compression ratio but at a higher cost and longer compute time.  Speed will produce a relatively larger file but is faster and more economical. The default value is Balanced.
        """
        return pulumi.get(self, "complexity")

    @complexity.setter
    def complexity(self, value: Optional[pulumi.Input[Union[str, 'H265Complexity']]]):
        pulumi.set(self, "complexity", value)

    @property
    @pulumi.getter(name="keyFrameInterval")
    def key_frame_interval(self) -> Optional[pulumi.Input[str]]:
        """
        The distance between two key frames. The value should be non-zero in the range [0.5, 20] seconds, specified in ISO 8601 format. The default is 2 seconds(PT2S). Note that this setting is ignored if VideoSyncMode.Passthrough is set, where the KeyFrameInterval value will follow the input source setting.
        """
        return pulumi.get(self, "key_frame_interval")

    @key_frame_interval.setter
    def key_frame_interval(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_frame_interval", value)

    @property
    @pulumi.getter
    def label(self) -> Optional[pulumi.Input[str]]:
        """
        An optional label for the codec. The label can be used to control muxing behavior.
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "label", value)

    @property
    @pulumi.getter
    def layers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['H265LayerArgs']]]]:
        """
        The collection of output H.265 layers to be produced by the encoder.
        """
        return pulumi.get(self, "layers")

    @layers.setter
    def layers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['H265LayerArgs']]]]):
        pulumi.set(self, "layers", value)

    @property
    @pulumi.getter(name="sceneChangeDetection")
    def scene_change_detection(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether or not the encoder should insert key frames at scene changes. If not specified, the default is false. This flag should be set to true only when the encoder is being configured to produce a single output video.
        """
        return pulumi.get(self, "scene_change_detection")

    @scene_change_detection.setter
    def scene_change_detection(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "scene_change_detection", value)

    @property
    @pulumi.getter(name="stretchMode")
    def stretch_mode(self) -> Optional[pulumi.Input[Union[str, 'StretchMode']]]:
        """
        The resizing mode - how the input video will be resized to fit the desired output resolution(s). Default is AutoSize
        """
        return pulumi.get(self, "stretch_mode")

    @stretch_mode.setter
    def stretch_mode(self, value: Optional[pulumi.Input[Union[str, 'StretchMode']]]):
        pulumi.set(self, "stretch_mode", value)

    @property
    @pulumi.getter(name="syncMode")
    def sync_mode(self) -> Optional[pulumi.Input[Union[str, 'VideoSyncMode']]]:
        """
        The Video Sync Mode
        """
        return pulumi.get(self, "sync_mode")

    @sync_mode.setter
    def sync_mode(self, value: Optional[pulumi.Input[Union[str, 'VideoSyncMode']]]):
        pulumi.set(self, "sync_mode", value)


@pulumi.input_type
class HlsSettingsArgs:
    def __init__(__self__, *,
                 characteristics: Optional[pulumi.Input[str]] = None,
                 default: Optional[pulumi.Input[bool]] = None,
                 forced: Optional[pulumi.Input[bool]] = None):
        """
        The HLS setting for a text track.
        :param pulumi.Input[str] characteristics: The characteristics for the HLS setting.
        :param pulumi.Input[bool] default: The default for the HLS setting.
        :param pulumi.Input[bool] forced: The forced for the HLS setting.
        """
        if characteristics is not None:
            pulumi.set(__self__, "characteristics", characteristics)
        if default is not None:
            pulumi.set(__self__, "default", default)
        if forced is not None:
            pulumi.set(__self__, "forced", forced)

    @property
    @pulumi.getter
    def characteristics(self) -> Optional[pulumi.Input[str]]:
        """
        The characteristics for the HLS setting.
        """
        return pulumi.get(self, "characteristics")

    @characteristics.setter
    def characteristics(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "characteristics", value)

    @property
    @pulumi.getter
    def default(self) -> Optional[pulumi.Input[bool]]:
        """
        The default for the HLS setting.
        """
        return pulumi.get(self, "default")

    @default.setter
    def default(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "default", value)

    @property
    @pulumi.getter
    def forced(self) -> Optional[pulumi.Input[bool]]:
        """
        The forced for the HLS setting.
        """
        return pulumi.get(self, "forced")

    @forced.setter
    def forced(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "forced", value)


@pulumi.input_type
class HlsArgs:
    def __init__(__self__, *,
                 fragments_per_ts_segment: Optional[pulumi.Input[int]] = None):
        """
        HTTP Live Streaming (HLS) packing setting for the live output.
        :param pulumi.Input[int] fragments_per_ts_segment: The number of fragments in an HTTP Live Streaming (HLS) TS segment in the output of the live event. This value does not affect the packing ratio for HLS CMAF output.
        """
        if fragments_per_ts_segment is not None:
            pulumi.set(__self__, "fragments_per_ts_segment", fragments_per_ts_segment)

    @property
    @pulumi.getter(name="fragmentsPerTsSegment")
    def fragments_per_ts_segment(self) -> Optional[pulumi.Input[int]]:
        """
        The number of fragments in an HTTP Live Streaming (HLS) TS segment in the output of the live event. This value does not affect the packing ratio for HLS CMAF output.
        """
        return pulumi.get(self, "fragments_per_ts_segment")

    @fragments_per_ts_segment.setter
    def fragments_per_ts_segment(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "fragments_per_ts_segment", value)


@pulumi.input_type
class IPAccessControlArgs:
    def __init__(__self__, *,
                 allow: Optional[pulumi.Input[Sequence[pulumi.Input['IPRangeArgs']]]] = None):
        """
        The IP access control.
        :param pulumi.Input[Sequence[pulumi.Input['IPRangeArgs']]] allow: The IP allow list.
        """
        if allow is not None:
            pulumi.set(__self__, "allow", allow)

    @property
    @pulumi.getter
    def allow(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IPRangeArgs']]]]:
        """
        The IP allow list.
        """
        return pulumi.get(self, "allow")

    @allow.setter
    def allow(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IPRangeArgs']]]]):
        pulumi.set(self, "allow", value)


@pulumi.input_type
class IPRangeArgs:
    def __init__(__self__, *,
                 address: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 subnet_prefix_length: Optional[pulumi.Input[int]] = None):
        """
        The IP address range in the CIDR scheme.
        :param pulumi.Input[str] address: The IP address.
        :param pulumi.Input[str] name: The friendly name for the IP address range.
        :param pulumi.Input[int] subnet_prefix_length: The subnet mask prefix length (see CIDR notation).
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if subnet_prefix_length is not None:
            pulumi.set(__self__, "subnet_prefix_length", subnet_prefix_length)

    @property
    @pulumi.getter
    def address(self) -> Optional[pulumi.Input[str]]:
        """
        The IP address.
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "address", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The friendly name for the IP address range.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="subnetPrefixLength")
    def subnet_prefix_length(self) -> Optional[pulumi.Input[int]]:
        """
        The subnet mask prefix length (see CIDR notation).
        """
        return pulumi.get(self, "subnet_prefix_length")

    @subnet_prefix_length.setter
    def subnet_prefix_length(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "subnet_prefix_length", value)


@pulumi.input_type
class ImageFormatArgs:
    def __init__(__self__, *,
                 filename_pattern: pulumi.Input[str],
                 odata_type: pulumi.Input[str]):
        """
        Describes the properties for an output image file.
        :param pulumi.Input[str] filename_pattern: The pattern of the file names for the generated output files. The following macros are supported in the file name: {Basename} - An expansion macro that will use the name of the input video file. If the base name(the file suffix is not included) of the input video file is less than 32 characters long, the base name of input video files will be used. If the length of base name of the input video file exceeds 32 characters, the base name is truncated to the first 32 characters in total length. {Extension} - The appropriate extension for this format. {Label} - The label assigned to the codec/layer. {Index} - A unique index for thumbnails. Only applicable to thumbnails. {Bitrate} - The audio/video bitrate. Not applicable to thumbnails. {Codec} - The type of the audio/video codec. {Resolution} - The video resolution. Any unsubstituted macros will be collapsed and removed from the filename.
        :param pulumi.Input[str] odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.ImageFormat'.
        """
        pulumi.set(__self__, "filename_pattern", filename_pattern)
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.ImageFormat')

    @property
    @pulumi.getter(name="filenamePattern")
    def filename_pattern(self) -> pulumi.Input[str]:
        """
        The pattern of the file names for the generated output files. The following macros are supported in the file name: {Basename} - An expansion macro that will use the name of the input video file. If the base name(the file suffix is not included) of the input video file is less than 32 characters long, the base name of input video files will be used. If the length of base name of the input video file exceeds 32 characters, the base name is truncated to the first 32 characters in total length. {Extension} - The appropriate extension for this format. {Label} - The label assigned to the codec/layer. {Index} - A unique index for thumbnails. Only applicable to thumbnails. {Bitrate} - The audio/video bitrate. Not applicable to thumbnails. {Codec} - The type of the audio/video codec. {Resolution} - The video resolution. Any unsubstituted macros will be collapsed and removed from the filename.
        """
        return pulumi.get(self, "filename_pattern")

    @filename_pattern.setter
    def filename_pattern(self, value: pulumi.Input[str]):
        pulumi.set(self, "filename_pattern", value)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> pulumi.Input[str]:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.ImageFormat'.
        """
        return pulumi.get(self, "odata_type")

    @odata_type.setter
    def odata_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "odata_type", value)


@pulumi.input_type
class ImageArgs:
    def __init__(__self__, *,
                 odata_type: pulumi.Input[str],
                 start: pulumi.Input[str],
                 key_frame_interval: Optional[pulumi.Input[str]] = None,
                 label: Optional[pulumi.Input[str]] = None,
                 range: Optional[pulumi.Input[str]] = None,
                 step: Optional[pulumi.Input[str]] = None,
                 stretch_mode: Optional[pulumi.Input[Union[str, 'StretchMode']]] = None,
                 sync_mode: Optional[pulumi.Input[Union[str, 'VideoSyncMode']]] = None):
        """
        Describes the basic properties for generating thumbnails from the input video
        :param pulumi.Input[str] odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.Image'.
        :param pulumi.Input[str] start: The position in the input video from where to start generating thumbnails. The value can be in ISO 8601 format (For example, PT05S to start at 5 seconds), or a frame count (For example, 10 to start at the 10th frame), or a relative value to stream duration (For example, 10% to start at 10% of stream duration). Also supports a macro {Best}, which tells the encoder to select the best thumbnail from the first few seconds of the video and will only produce one thumbnail, no matter what other settings are for Step and Range. The default value is macro {Best}.
        :param pulumi.Input[str] key_frame_interval: The distance between two key frames. The value should be non-zero in the range [0.5, 20] seconds, specified in ISO 8601 format. The default is 2 seconds(PT2S). Note that this setting is ignored if VideoSyncMode.Passthrough is set, where the KeyFrameInterval value will follow the input source setting.
        :param pulumi.Input[str] label: An optional label for the codec. The label can be used to control muxing behavior.
        :param pulumi.Input[str] range: The position relative to transform preset start time in the input video at which to stop generating thumbnails. The value can be in ISO 8601 format (For example, PT5M30S to stop at 5 minutes and 30 seconds from start time), or a frame count (For example, 300 to stop at the 300th frame from the frame at start time. If this value is 1, it means only producing one thumbnail at start time), or a relative value to the stream duration (For example, 50% to stop at half of stream duration from start time). The default value is 100%, which means to stop at the end of the stream.
        :param pulumi.Input[str] step: The intervals at which thumbnails are generated. The value can be in ISO 8601 format (For example, PT05S for one image every 5 seconds), or a frame count (For example, 30 for one image every 30 frames), or a relative value to stream duration (For example, 10% for one image every 10% of stream duration). Note: Step value will affect the first generated thumbnail, which may not be exactly the one specified at transform preset start time. This is due to the encoder, which tries to select the best thumbnail between start time and Step position from start time as the first output. As the default value is 10%, it means if stream has long duration, the first generated thumbnail might be far away from the one specified at start time. Try to select reasonable value for Step if the first thumbnail is expected close to start time, or set Range value at 1 if only one thumbnail is needed at start time.
        :param pulumi.Input[Union[str, 'StretchMode']] stretch_mode: The resizing mode - how the input video will be resized to fit the desired output resolution(s). Default is AutoSize
        :param pulumi.Input[Union[str, 'VideoSyncMode']] sync_mode: The Video Sync Mode
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.Image')
        pulumi.set(__self__, "start", start)
        if key_frame_interval is not None:
            pulumi.set(__self__, "key_frame_interval", key_frame_interval)
        if label is not None:
            pulumi.set(__self__, "label", label)
        if range is not None:
            pulumi.set(__self__, "range", range)
        if step is not None:
            pulumi.set(__self__, "step", step)
        if stretch_mode is not None:
            pulumi.set(__self__, "stretch_mode", stretch_mode)
        if sync_mode is not None:
            pulumi.set(__self__, "sync_mode", sync_mode)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> pulumi.Input[str]:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.Image'.
        """
        return pulumi.get(self, "odata_type")

    @odata_type.setter
    def odata_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "odata_type", value)

    @property
    @pulumi.getter
    def start(self) -> pulumi.Input[str]:
        """
        The position in the input video from where to start generating thumbnails. The value can be in ISO 8601 format (For example, PT05S to start at 5 seconds), or a frame count (For example, 10 to start at the 10th frame), or a relative value to stream duration (For example, 10% to start at 10% of stream duration). Also supports a macro {Best}, which tells the encoder to select the best thumbnail from the first few seconds of the video and will only produce one thumbnail, no matter what other settings are for Step and Range. The default value is macro {Best}.
        """
        return pulumi.get(self, "start")

    @start.setter
    def start(self, value: pulumi.Input[str]):
        pulumi.set(self, "start", value)

    @property
    @pulumi.getter(name="keyFrameInterval")
    def key_frame_interval(self) -> Optional[pulumi.Input[str]]:
        """
        The distance between two key frames. The value should be non-zero in the range [0.5, 20] seconds, specified in ISO 8601 format. The default is 2 seconds(PT2S). Note that this setting is ignored if VideoSyncMode.Passthrough is set, where the KeyFrameInterval value will follow the input source setting.
        """
        return pulumi.get(self, "key_frame_interval")

    @key_frame_interval.setter
    def key_frame_interval(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_frame_interval", value)

    @property
    @pulumi.getter
    def label(self) -> Optional[pulumi.Input[str]]:
        """
        An optional label for the codec. The label can be used to control muxing behavior.
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "label", value)

    @property
    @pulumi.getter
    def range(self) -> Optional[pulumi.Input[str]]:
        """
        The position relative to transform preset start time in the input video at which to stop generating thumbnails. The value can be in ISO 8601 format (For example, PT5M30S to stop at 5 minutes and 30 seconds from start time), or a frame count (For example, 300 to stop at the 300th frame from the frame at start time. If this value is 1, it means only producing one thumbnail at start time), or a relative value to the stream duration (For example, 50% to stop at half of stream duration from start time). The default value is 100%, which means to stop at the end of the stream.
        """
        return pulumi.get(self, "range")

    @range.setter
    def range(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "range", value)

    @property
    @pulumi.getter
    def step(self) -> Optional[pulumi.Input[str]]:
        """
        The intervals at which thumbnails are generated. The value can be in ISO 8601 format (For example, PT05S for one image every 5 seconds), or a frame count (For example, 30 for one image every 30 frames), or a relative value to stream duration (For example, 10% for one image every 10% of stream duration). Note: Step value will affect the first generated thumbnail, which may not be exactly the one specified at transform preset start time. This is due to the encoder, which tries to select the best thumbnail between start time and Step position from start time as the first output. As the default value is 10%, it means if stream has long duration, the first generated thumbnail might be far away from the one specified at start time. Try to select reasonable value for Step if the first thumbnail is expected close to start time, or set Range value at 1 if only one thumbnail is needed at start time.
        """
        return pulumi.get(self, "step")

    @step.setter
    def step(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "step", value)

    @property
    @pulumi.getter(name="stretchMode")
    def stretch_mode(self) -> Optional[pulumi.Input[Union[str, 'StretchMode']]]:
        """
        The resizing mode - how the input video will be resized to fit the desired output resolution(s). Default is AutoSize
        """
        return pulumi.get(self, "stretch_mode")

    @stretch_mode.setter
    def stretch_mode(self, value: Optional[pulumi.Input[Union[str, 'StretchMode']]]):
        pulumi.set(self, "stretch_mode", value)

    @property
    @pulumi.getter(name="syncMode")
    def sync_mode(self) -> Optional[pulumi.Input[Union[str, 'VideoSyncMode']]]:
        """
        The Video Sync Mode
        """
        return pulumi.get(self, "sync_mode")

    @sync_mode.setter
    def sync_mode(self, value: Optional[pulumi.Input[Union[str, 'VideoSyncMode']]]):
        pulumi.set(self, "sync_mode", value)


@pulumi.input_type
class InputFileArgs:
    def __init__(__self__, *,
                 odata_type: pulumi.Input[str],
                 filename: Optional[pulumi.Input[str]] = None,
                 included_tracks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AudioTrackDescriptorArgs', 'SelectAudioTrackByAttributeArgs', 'SelectAudioTrackByIdArgs', 'SelectVideoTrackByAttributeArgs', 'SelectVideoTrackByIdArgs', 'VideoTrackDescriptorArgs']]]]] = None):
        """
        An InputDefinition for a single file.  TrackSelections are scoped to the file specified.
        :param pulumi.Input[str] odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.InputFile'.
        :param pulumi.Input[str] filename: Name of the file that this input definition applies to.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AudioTrackDescriptorArgs', 'SelectAudioTrackByAttributeArgs', 'SelectAudioTrackByIdArgs', 'SelectVideoTrackByAttributeArgs', 'SelectVideoTrackByIdArgs', 'VideoTrackDescriptorArgs']]]] included_tracks: The list of TrackDescriptors which define the metadata and selection of tracks in the input.
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.InputFile')
        if filename is not None:
            pulumi.set(__self__, "filename", filename)
        if included_tracks is not None:
            pulumi.set(__self__, "included_tracks", included_tracks)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> pulumi.Input[str]:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.InputFile'.
        """
        return pulumi.get(self, "odata_type")

    @odata_type.setter
    def odata_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "odata_type", value)

    @property
    @pulumi.getter
    def filename(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the file that this input definition applies to.
        """
        return pulumi.get(self, "filename")

    @filename.setter
    def filename(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "filename", value)

    @property
    @pulumi.getter(name="includedTracks")
    def included_tracks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Union['AudioTrackDescriptorArgs', 'SelectAudioTrackByAttributeArgs', 'SelectAudioTrackByIdArgs', 'SelectVideoTrackByAttributeArgs', 'SelectVideoTrackByIdArgs', 'VideoTrackDescriptorArgs']]]]]:
        """
        The list of TrackDescriptors which define the metadata and selection of tracks in the input.
        """
        return pulumi.get(self, "included_tracks")

    @included_tracks.setter
    def included_tracks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AudioTrackDescriptorArgs', 'SelectAudioTrackByAttributeArgs', 'SelectAudioTrackByIdArgs', 'SelectVideoTrackByAttributeArgs', 'SelectVideoTrackByIdArgs', 'VideoTrackDescriptorArgs']]]]]):
        pulumi.set(self, "included_tracks", value)


@pulumi.input_type
class JobInputAssetArgs:
    def __init__(__self__, *,
                 asset_name: pulumi.Input[str],
                 odata_type: pulumi.Input[str],
                 end: Optional[pulumi.Input[Union['AbsoluteClipTimeArgs', 'UtcClipTimeArgs']]] = None,
                 files: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 input_definitions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FromAllInputFileArgs', 'FromEachInputFileArgs', 'InputFileArgs']]]]] = None,
                 label: Optional[pulumi.Input[str]] = None,
                 start: Optional[pulumi.Input[Union['AbsoluteClipTimeArgs', 'UtcClipTimeArgs']]] = None):
        """
        Represents an Asset for input into a Job.
        :param pulumi.Input[str] asset_name: The name of the input Asset.
        :param pulumi.Input[str] odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.JobInputAsset'.
        :param pulumi.Input[Union['AbsoluteClipTimeArgs', 'UtcClipTimeArgs']] end: Defines a point on the timeline of the input media at which processing will end. Defaults to the end of the input media.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] files: List of files. Required for JobInputHttp. Maximum of 4000 characters each. Query strings will not be returned in service responses to prevent sensitive data exposure.
        :param pulumi.Input[Sequence[pulumi.Input[Union['FromAllInputFileArgs', 'FromEachInputFileArgs', 'InputFileArgs']]]] input_definitions: Defines a list of InputDefinitions. For each InputDefinition, it defines a list of track selections and related metadata.
        :param pulumi.Input[str] label: A label that is assigned to a JobInputClip, that is used to satisfy a reference used in the Transform. For example, a Transform can be authored so as to take an image file with the label 'xyz' and apply it as an overlay onto the input video before it is encoded. When submitting a Job, exactly one of the JobInputs should be the image file, and it should have the label 'xyz'.
        :param pulumi.Input[Union['AbsoluteClipTimeArgs', 'UtcClipTimeArgs']] start: Defines a point on the timeline of the input media at which processing will start. Defaults to the beginning of the input media.
        """
        pulumi.set(__self__, "asset_name", asset_name)
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.JobInputAsset')
        if end is not None:
            pulumi.set(__self__, "end", end)
        if files is not None:
            pulumi.set(__self__, "files", files)
        if input_definitions is not None:
            pulumi.set(__self__, "input_definitions", input_definitions)
        if label is not None:
            pulumi.set(__self__, "label", label)
        if start is not None:
            pulumi.set(__self__, "start", start)

    @property
    @pulumi.getter(name="assetName")
    def asset_name(self) -> pulumi.Input[str]:
        """
        The name of the input Asset.
        """
        return pulumi.get(self, "asset_name")

    @asset_name.setter
    def asset_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "asset_name", value)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> pulumi.Input[str]:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.JobInputAsset'.
        """
        return pulumi.get(self, "odata_type")

    @odata_type.setter
    def odata_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "odata_type", value)

    @property
    @pulumi.getter
    def end(self) -> Optional[pulumi.Input[Union['AbsoluteClipTimeArgs', 'UtcClipTimeArgs']]]:
        """
        Defines a point on the timeline of the input media at which processing will end. Defaults to the end of the input media.
        """
        return pulumi.get(self, "end")

    @end.setter
    def end(self, value: Optional[pulumi.Input[Union['AbsoluteClipTimeArgs', 'UtcClipTimeArgs']]]):
        pulumi.set(self, "end", value)

    @property
    @pulumi.getter
    def files(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of files. Required for JobInputHttp. Maximum of 4000 characters each. Query strings will not be returned in service responses to prevent sensitive data exposure.
        """
        return pulumi.get(self, "files")

    @files.setter
    def files(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "files", value)

    @property
    @pulumi.getter(name="inputDefinitions")
    def input_definitions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Union['FromAllInputFileArgs', 'FromEachInputFileArgs', 'InputFileArgs']]]]]:
        """
        Defines a list of InputDefinitions. For each InputDefinition, it defines a list of track selections and related metadata.
        """
        return pulumi.get(self, "input_definitions")

    @input_definitions.setter
    def input_definitions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FromAllInputFileArgs', 'FromEachInputFileArgs', 'InputFileArgs']]]]]):
        pulumi.set(self, "input_definitions", value)

    @property
    @pulumi.getter
    def label(self) -> Optional[pulumi.Input[str]]:
        """
        A label that is assigned to a JobInputClip, that is used to satisfy a reference used in the Transform. For example, a Transform can be authored so as to take an image file with the label 'xyz' and apply it as an overlay onto the input video before it is encoded. When submitting a Job, exactly one of the JobInputs should be the image file, and it should have the label 'xyz'.
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "label", value)

    @property
    @pulumi.getter
    def start(self) -> Optional[pulumi.Input[Union['AbsoluteClipTimeArgs', 'UtcClipTimeArgs']]]:
        """
        Defines a point on the timeline of the input media at which processing will start. Defaults to the beginning of the input media.
        """
        return pulumi.get(self, "start")

    @start.setter
    def start(self, value: Optional[pulumi.Input[Union['AbsoluteClipTimeArgs', 'UtcClipTimeArgs']]]):
        pulumi.set(self, "start", value)


@pulumi.input_type
class JobInputClipArgs:
    def __init__(__self__, *,
                 odata_type: pulumi.Input[str],
                 end: Optional[pulumi.Input[Union['AbsoluteClipTimeArgs', 'UtcClipTimeArgs']]] = None,
                 files: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 input_definitions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FromAllInputFileArgs', 'FromEachInputFileArgs', 'InputFileArgs']]]]] = None,
                 label: Optional[pulumi.Input[str]] = None,
                 start: Optional[pulumi.Input[Union['AbsoluteClipTimeArgs', 'UtcClipTimeArgs']]] = None):
        """
        Represents input files for a Job.
        :param pulumi.Input[str] odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.JobInputClip'.
        :param pulumi.Input[Union['AbsoluteClipTimeArgs', 'UtcClipTimeArgs']] end: Defines a point on the timeline of the input media at which processing will end. Defaults to the end of the input media.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] files: List of files. Required for JobInputHttp. Maximum of 4000 characters each. Query strings will not be returned in service responses to prevent sensitive data exposure.
        :param pulumi.Input[Sequence[pulumi.Input[Union['FromAllInputFileArgs', 'FromEachInputFileArgs', 'InputFileArgs']]]] input_definitions: Defines a list of InputDefinitions. For each InputDefinition, it defines a list of track selections and related metadata.
        :param pulumi.Input[str] label: A label that is assigned to a JobInputClip, that is used to satisfy a reference used in the Transform. For example, a Transform can be authored so as to take an image file with the label 'xyz' and apply it as an overlay onto the input video before it is encoded. When submitting a Job, exactly one of the JobInputs should be the image file, and it should have the label 'xyz'.
        :param pulumi.Input[Union['AbsoluteClipTimeArgs', 'UtcClipTimeArgs']] start: Defines a point on the timeline of the input media at which processing will start. Defaults to the beginning of the input media.
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.JobInputClip')
        if end is not None:
            pulumi.set(__self__, "end", end)
        if files is not None:
            pulumi.set(__self__, "files", files)
        if input_definitions is not None:
            pulumi.set(__self__, "input_definitions", input_definitions)
        if label is not None:
            pulumi.set(__self__, "label", label)
        if start is not None:
            pulumi.set(__self__, "start", start)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> pulumi.Input[str]:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.JobInputClip'.
        """
        return pulumi.get(self, "odata_type")

    @odata_type.setter
    def odata_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "odata_type", value)

    @property
    @pulumi.getter
    def end(self) -> Optional[pulumi.Input[Union['AbsoluteClipTimeArgs', 'UtcClipTimeArgs']]]:
        """
        Defines a point on the timeline of the input media at which processing will end. Defaults to the end of the input media.
        """
        return pulumi.get(self, "end")

    @end.setter
    def end(self, value: Optional[pulumi.Input[Union['AbsoluteClipTimeArgs', 'UtcClipTimeArgs']]]):
        pulumi.set(self, "end", value)

    @property
    @pulumi.getter
    def files(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of files. Required for JobInputHttp. Maximum of 4000 characters each. Query strings will not be returned in service responses to prevent sensitive data exposure.
        """
        return pulumi.get(self, "files")

    @files.setter
    def files(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "files", value)

    @property
    @pulumi.getter(name="inputDefinitions")
    def input_definitions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Union['FromAllInputFileArgs', 'FromEachInputFileArgs', 'InputFileArgs']]]]]:
        """
        Defines a list of InputDefinitions. For each InputDefinition, it defines a list of track selections and related metadata.
        """
        return pulumi.get(self, "input_definitions")

    @input_definitions.setter
    def input_definitions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FromAllInputFileArgs', 'FromEachInputFileArgs', 'InputFileArgs']]]]]):
        pulumi.set(self, "input_definitions", value)

    @property
    @pulumi.getter
    def label(self) -> Optional[pulumi.Input[str]]:
        """
        A label that is assigned to a JobInputClip, that is used to satisfy a reference used in the Transform. For example, a Transform can be authored so as to take an image file with the label 'xyz' and apply it as an overlay onto the input video before it is encoded. When submitting a Job, exactly one of the JobInputs should be the image file, and it should have the label 'xyz'.
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "label", value)

    @property
    @pulumi.getter
    def start(self) -> Optional[pulumi.Input[Union['AbsoluteClipTimeArgs', 'UtcClipTimeArgs']]]:
        """
        Defines a point on the timeline of the input media at which processing will start. Defaults to the beginning of the input media.
        """
        return pulumi.get(self, "start")

    @start.setter
    def start(self, value: Optional[pulumi.Input[Union['AbsoluteClipTimeArgs', 'UtcClipTimeArgs']]]):
        pulumi.set(self, "start", value)


@pulumi.input_type
class JobInputHttpArgs:
    def __init__(__self__, *,
                 odata_type: pulumi.Input[str],
                 base_uri: Optional[pulumi.Input[str]] = None,
                 end: Optional[pulumi.Input[Union['AbsoluteClipTimeArgs', 'UtcClipTimeArgs']]] = None,
                 files: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 input_definitions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FromAllInputFileArgs', 'FromEachInputFileArgs', 'InputFileArgs']]]]] = None,
                 label: Optional[pulumi.Input[str]] = None,
                 start: Optional[pulumi.Input[Union['AbsoluteClipTimeArgs', 'UtcClipTimeArgs']]] = None):
        """
        Represents HTTPS job input.
        :param pulumi.Input[str] odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.JobInputHttp'.
        :param pulumi.Input[str] base_uri: Base URI for HTTPS job input. It will be concatenated with provided file names. If no base uri is given, then the provided file list is assumed to be fully qualified uris. Maximum length of 4000 characters. The query strings will not be returned in service responses to prevent sensitive data exposure.
        :param pulumi.Input[Union['AbsoluteClipTimeArgs', 'UtcClipTimeArgs']] end: Defines a point on the timeline of the input media at which processing will end. Defaults to the end of the input media.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] files: List of files. Required for JobInputHttp. Maximum of 4000 characters each. Query strings will not be returned in service responses to prevent sensitive data exposure.
        :param pulumi.Input[Sequence[pulumi.Input[Union['FromAllInputFileArgs', 'FromEachInputFileArgs', 'InputFileArgs']]]] input_definitions: Defines a list of InputDefinitions. For each InputDefinition, it defines a list of track selections and related metadata.
        :param pulumi.Input[str] label: A label that is assigned to a JobInputClip, that is used to satisfy a reference used in the Transform. For example, a Transform can be authored so as to take an image file with the label 'xyz' and apply it as an overlay onto the input video before it is encoded. When submitting a Job, exactly one of the JobInputs should be the image file, and it should have the label 'xyz'.
        :param pulumi.Input[Union['AbsoluteClipTimeArgs', 'UtcClipTimeArgs']] start: Defines a point on the timeline of the input media at which processing will start. Defaults to the beginning of the input media.
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.JobInputHttp')
        if base_uri is not None:
            pulumi.set(__self__, "base_uri", base_uri)
        if end is not None:
            pulumi.set(__self__, "end", end)
        if files is not None:
            pulumi.set(__self__, "files", files)
        if input_definitions is not None:
            pulumi.set(__self__, "input_definitions", input_definitions)
        if label is not None:
            pulumi.set(__self__, "label", label)
        if start is not None:
            pulumi.set(__self__, "start", start)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> pulumi.Input[str]:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.JobInputHttp'.
        """
        return pulumi.get(self, "odata_type")

    @odata_type.setter
    def odata_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "odata_type", value)

    @property
    @pulumi.getter(name="baseUri")
    def base_uri(self) -> Optional[pulumi.Input[str]]:
        """
        Base URI for HTTPS job input. It will be concatenated with provided file names. If no base uri is given, then the provided file list is assumed to be fully qualified uris. Maximum length of 4000 characters. The query strings will not be returned in service responses to prevent sensitive data exposure.
        """
        return pulumi.get(self, "base_uri")

    @base_uri.setter
    def base_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "base_uri", value)

    @property
    @pulumi.getter
    def end(self) -> Optional[pulumi.Input[Union['AbsoluteClipTimeArgs', 'UtcClipTimeArgs']]]:
        """
        Defines a point on the timeline of the input media at which processing will end. Defaults to the end of the input media.
        """
        return pulumi.get(self, "end")

    @end.setter
    def end(self, value: Optional[pulumi.Input[Union['AbsoluteClipTimeArgs', 'UtcClipTimeArgs']]]):
        pulumi.set(self, "end", value)

    @property
    @pulumi.getter
    def files(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of files. Required for JobInputHttp. Maximum of 4000 characters each. Query strings will not be returned in service responses to prevent sensitive data exposure.
        """
        return pulumi.get(self, "files")

    @files.setter
    def files(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "files", value)

    @property
    @pulumi.getter(name="inputDefinitions")
    def input_definitions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Union['FromAllInputFileArgs', 'FromEachInputFileArgs', 'InputFileArgs']]]]]:
        """
        Defines a list of InputDefinitions. For each InputDefinition, it defines a list of track selections and related metadata.
        """
        return pulumi.get(self, "input_definitions")

    @input_definitions.setter
    def input_definitions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FromAllInputFileArgs', 'FromEachInputFileArgs', 'InputFileArgs']]]]]):
        pulumi.set(self, "input_definitions", value)

    @property
    @pulumi.getter
    def label(self) -> Optional[pulumi.Input[str]]:
        """
        A label that is assigned to a JobInputClip, that is used to satisfy a reference used in the Transform. For example, a Transform can be authored so as to take an image file with the label 'xyz' and apply it as an overlay onto the input video before it is encoded. When submitting a Job, exactly one of the JobInputs should be the image file, and it should have the label 'xyz'.
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "label", value)

    @property
    @pulumi.getter
    def start(self) -> Optional[pulumi.Input[Union['AbsoluteClipTimeArgs', 'UtcClipTimeArgs']]]:
        """
        Defines a point on the timeline of the input media at which processing will start. Defaults to the beginning of the input media.
        """
        return pulumi.get(self, "start")

    @start.setter
    def start(self, value: Optional[pulumi.Input[Union['AbsoluteClipTimeArgs', 'UtcClipTimeArgs']]]):
        pulumi.set(self, "start", value)


@pulumi.input_type
class JobInputSequenceArgs:
    def __init__(__self__, *,
                 odata_type: pulumi.Input[str],
                 inputs: Optional[pulumi.Input[Sequence[pulumi.Input['JobInputClipArgs']]]] = None):
        """
        A Sequence contains an ordered list of Clips where each clip is a JobInput.  The Sequence will be treated as a single input.
        :param pulumi.Input[str] odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.JobInputSequence'.
        :param pulumi.Input[Sequence[pulumi.Input['JobInputClipArgs']]] inputs: JobInputs that make up the timeline.
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.JobInputSequence')
        if inputs is not None:
            pulumi.set(__self__, "inputs", inputs)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> pulumi.Input[str]:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.JobInputSequence'.
        """
        return pulumi.get(self, "odata_type")

    @odata_type.setter
    def odata_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "odata_type", value)

    @property
    @pulumi.getter
    def inputs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['JobInputClipArgs']]]]:
        """
        JobInputs that make up the timeline.
        """
        return pulumi.get(self, "inputs")

    @inputs.setter
    def inputs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['JobInputClipArgs']]]]):
        pulumi.set(self, "inputs", value)


@pulumi.input_type
class JobInputsArgs:
    def __init__(__self__, *,
                 odata_type: pulumi.Input[str],
                 inputs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['JobInputAssetArgs', 'JobInputClipArgs', 'JobInputHttpArgs', 'JobInputSequenceArgs', 'JobInputsArgs']]]]] = None):
        """
        Describes a list of inputs to a Job.
        :param pulumi.Input[str] odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.JobInputs'.
        :param pulumi.Input[Sequence[pulumi.Input[Union['JobInputAssetArgs', 'JobInputClipArgs', 'JobInputHttpArgs', 'JobInputSequenceArgs', 'JobInputsArgs']]]] inputs: List of inputs to a Job.
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.JobInputs')
        if inputs is not None:
            pulumi.set(__self__, "inputs", inputs)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> pulumi.Input[str]:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.JobInputs'.
        """
        return pulumi.get(self, "odata_type")

    @odata_type.setter
    def odata_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "odata_type", value)

    @property
    @pulumi.getter
    def inputs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Union['JobInputAssetArgs', 'JobInputClipArgs', 'JobInputHttpArgs', 'JobInputSequenceArgs', 'JobInputsArgs']]]]]:
        """
        List of inputs to a Job.
        """
        return pulumi.get(self, "inputs")

    @inputs.setter
    def inputs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Union['JobInputAssetArgs', 'JobInputClipArgs', 'JobInputHttpArgs', 'JobInputSequenceArgs', 'JobInputsArgs']]]]]):
        pulumi.set(self, "inputs", value)


@pulumi.input_type
class JobOutputAssetArgs:
    def __init__(__self__, *,
                 asset_name: pulumi.Input[str],
                 odata_type: pulumi.Input[str],
                 label: Optional[pulumi.Input[str]] = None,
                 preset_override: Optional[pulumi.Input[Union['AudioAnalyzerPresetArgs', 'BuiltInStandardEncoderPresetArgs', 'FaceDetectorPresetArgs', 'StandardEncoderPresetArgs', 'VideoAnalyzerPresetArgs']]] = None):
        """
        Represents an Asset used as a JobOutput.
        :param pulumi.Input[str] asset_name: The name of the output Asset.
        :param pulumi.Input[str] odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.JobOutputAsset'.
        :param pulumi.Input[str] label: A label that is assigned to a JobOutput in order to help uniquely identify it. This is useful when your Transform has more than one TransformOutput, whereby your Job has more than one JobOutput. In such cases, when you submit the Job, you will add two or more JobOutputs, in the same order as TransformOutputs in the Transform. Subsequently, when you retrieve the Job, either through events or on a GET request, you can use the label to easily identify the JobOutput. If a label is not provided, a default value of '{presetName}_{outputIndex}' will be used, where the preset name is the name of the preset in the corresponding TransformOutput and the output index is the relative index of the this JobOutput within the Job. Note that this index is the same as the relative index of the corresponding TransformOutput within its Transform.
        :param pulumi.Input[Union['AudioAnalyzerPresetArgs', 'BuiltInStandardEncoderPresetArgs', 'FaceDetectorPresetArgs', 'StandardEncoderPresetArgs', 'VideoAnalyzerPresetArgs']] preset_override: A preset used to override the preset in the corresponding transform output.
        """
        pulumi.set(__self__, "asset_name", asset_name)
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.JobOutputAsset')
        if label is not None:
            pulumi.set(__self__, "label", label)
        if preset_override is not None:
            pulumi.set(__self__, "preset_override", preset_override)

    @property
    @pulumi.getter(name="assetName")
    def asset_name(self) -> pulumi.Input[str]:
        """
        The name of the output Asset.
        """
        return pulumi.get(self, "asset_name")

    @asset_name.setter
    def asset_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "asset_name", value)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> pulumi.Input[str]:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.JobOutputAsset'.
        """
        return pulumi.get(self, "odata_type")

    @odata_type.setter
    def odata_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "odata_type", value)

    @property
    @pulumi.getter
    def label(self) -> Optional[pulumi.Input[str]]:
        """
        A label that is assigned to a JobOutput in order to help uniquely identify it. This is useful when your Transform has more than one TransformOutput, whereby your Job has more than one JobOutput. In such cases, when you submit the Job, you will add two or more JobOutputs, in the same order as TransformOutputs in the Transform. Subsequently, when you retrieve the Job, either through events or on a GET request, you can use the label to easily identify the JobOutput. If a label is not provided, a default value of '{presetName}_{outputIndex}' will be used, where the preset name is the name of the preset in the corresponding TransformOutput and the output index is the relative index of the this JobOutput within the Job. Note that this index is the same as the relative index of the corresponding TransformOutput within its Transform.
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "label", value)

    @property
    @pulumi.getter(name="presetOverride")
    def preset_override(self) -> Optional[pulumi.Input[Union['AudioAnalyzerPresetArgs', 'BuiltInStandardEncoderPresetArgs', 'FaceDetectorPresetArgs', 'StandardEncoderPresetArgs', 'VideoAnalyzerPresetArgs']]]:
        """
        A preset used to override the preset in the corresponding transform output.
        """
        return pulumi.get(self, "preset_override")

    @preset_override.setter
    def preset_override(self, value: Optional[pulumi.Input[Union['AudioAnalyzerPresetArgs', 'BuiltInStandardEncoderPresetArgs', 'FaceDetectorPresetArgs', 'StandardEncoderPresetArgs', 'VideoAnalyzerPresetArgs']]]):
        pulumi.set(self, "preset_override", value)


@pulumi.input_type
class JpgFormatArgs:
    def __init__(__self__, *,
                 filename_pattern: pulumi.Input[str],
                 odata_type: pulumi.Input[str]):
        """
        Describes the settings for producing JPEG thumbnails.
        :param pulumi.Input[str] filename_pattern: The pattern of the file names for the generated output files. The following macros are supported in the file name: {Basename} - An expansion macro that will use the name of the input video file. If the base name(the file suffix is not included) of the input video file is less than 32 characters long, the base name of input video files will be used. If the length of base name of the input video file exceeds 32 characters, the base name is truncated to the first 32 characters in total length. {Extension} - The appropriate extension for this format. {Label} - The label assigned to the codec/layer. {Index} - A unique index for thumbnails. Only applicable to thumbnails. {Bitrate} - The audio/video bitrate. Not applicable to thumbnails. {Codec} - The type of the audio/video codec. {Resolution} - The video resolution. Any unsubstituted macros will be collapsed and removed from the filename.
        :param pulumi.Input[str] odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.JpgFormat'.
        """
        pulumi.set(__self__, "filename_pattern", filename_pattern)
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.JpgFormat')

    @property
    @pulumi.getter(name="filenamePattern")
    def filename_pattern(self) -> pulumi.Input[str]:
        """
        The pattern of the file names for the generated output files. The following macros are supported in the file name: {Basename} - An expansion macro that will use the name of the input video file. If the base name(the file suffix is not included) of the input video file is less than 32 characters long, the base name of input video files will be used. If the length of base name of the input video file exceeds 32 characters, the base name is truncated to the first 32 characters in total length. {Extension} - The appropriate extension for this format. {Label} - The label assigned to the codec/layer. {Index} - A unique index for thumbnails. Only applicable to thumbnails. {Bitrate} - The audio/video bitrate. Not applicable to thumbnails. {Codec} - The type of the audio/video codec. {Resolution} - The video resolution. Any unsubstituted macros will be collapsed and removed from the filename.
        """
        return pulumi.get(self, "filename_pattern")

    @filename_pattern.setter
    def filename_pattern(self, value: pulumi.Input[str]):
        pulumi.set(self, "filename_pattern", value)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> pulumi.Input[str]:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.JpgFormat'.
        """
        return pulumi.get(self, "odata_type")

    @odata_type.setter
    def odata_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "odata_type", value)


@pulumi.input_type
class JpgImageArgs:
    def __init__(__self__, *,
                 odata_type: pulumi.Input[str],
                 start: pulumi.Input[str],
                 key_frame_interval: Optional[pulumi.Input[str]] = None,
                 label: Optional[pulumi.Input[str]] = None,
                 layers: Optional[pulumi.Input[Sequence[pulumi.Input['JpgLayerArgs']]]] = None,
                 range: Optional[pulumi.Input[str]] = None,
                 sprite_column: Optional[pulumi.Input[int]] = None,
                 step: Optional[pulumi.Input[str]] = None,
                 stretch_mode: Optional[pulumi.Input[Union[str, 'StretchMode']]] = None,
                 sync_mode: Optional[pulumi.Input[Union[str, 'VideoSyncMode']]] = None):
        """
        Describes the properties for producing a series of JPEG images from the input video.
        :param pulumi.Input[str] odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.JpgImage'.
        :param pulumi.Input[str] start: The position in the input video from where to start generating thumbnails. The value can be in ISO 8601 format (For example, PT05S to start at 5 seconds), or a frame count (For example, 10 to start at the 10th frame), or a relative value to stream duration (For example, 10% to start at 10% of stream duration). Also supports a macro {Best}, which tells the encoder to select the best thumbnail from the first few seconds of the video and will only produce one thumbnail, no matter what other settings are for Step and Range. The default value is macro {Best}.
        :param pulumi.Input[str] key_frame_interval: The distance between two key frames. The value should be non-zero in the range [0.5, 20] seconds, specified in ISO 8601 format. The default is 2 seconds(PT2S). Note that this setting is ignored if VideoSyncMode.Passthrough is set, where the KeyFrameInterval value will follow the input source setting.
        :param pulumi.Input[str] label: An optional label for the codec. The label can be used to control muxing behavior.
        :param pulumi.Input[Sequence[pulumi.Input['JpgLayerArgs']]] layers: A collection of output JPEG image layers to be produced by the encoder.
        :param pulumi.Input[str] range: The position relative to transform preset start time in the input video at which to stop generating thumbnails. The value can be in ISO 8601 format (For example, PT5M30S to stop at 5 minutes and 30 seconds from start time), or a frame count (For example, 300 to stop at the 300th frame from the frame at start time. If this value is 1, it means only producing one thumbnail at start time), or a relative value to the stream duration (For example, 50% to stop at half of stream duration from start time). The default value is 100%, which means to stop at the end of the stream.
        :param pulumi.Input[int] sprite_column: Sets the number of columns used in thumbnail sprite image.  The number of rows are automatically calculated and a VTT file is generated with the coordinate mappings for each thumbnail in the sprite. Note: this value should be a positive integer and a proper value is recommended so that the output image resolution will not go beyond JPEG maximum pixel resolution limit 65535x65535.
        :param pulumi.Input[str] step: The intervals at which thumbnails are generated. The value can be in ISO 8601 format (For example, PT05S for one image every 5 seconds), or a frame count (For example, 30 for one image every 30 frames), or a relative value to stream duration (For example, 10% for one image every 10% of stream duration). Note: Step value will affect the first generated thumbnail, which may not be exactly the one specified at transform preset start time. This is due to the encoder, which tries to select the best thumbnail between start time and Step position from start time as the first output. As the default value is 10%, it means if stream has long duration, the first generated thumbnail might be far away from the one specified at start time. Try to select reasonable value for Step if the first thumbnail is expected close to start time, or set Range value at 1 if only one thumbnail is needed at start time.
        :param pulumi.Input[Union[str, 'StretchMode']] stretch_mode: The resizing mode - how the input video will be resized to fit the desired output resolution(s). Default is AutoSize
        :param pulumi.Input[Union[str, 'VideoSyncMode']] sync_mode: The Video Sync Mode
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.JpgImage')
        pulumi.set(__self__, "start", start)
        if key_frame_interval is not None:
            pulumi.set(__self__, "key_frame_interval", key_frame_interval)
        if label is not None:
            pulumi.set(__self__, "label", label)
        if layers is not None:
            pulumi.set(__self__, "layers", layers)
        if range is not None:
            pulumi.set(__self__, "range", range)
        if sprite_column is not None:
            pulumi.set(__self__, "sprite_column", sprite_column)
        if step is not None:
            pulumi.set(__self__, "step", step)
        if stretch_mode is not None:
            pulumi.set(__self__, "stretch_mode", stretch_mode)
        if sync_mode is not None:
            pulumi.set(__self__, "sync_mode", sync_mode)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> pulumi.Input[str]:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.JpgImage'.
        """
        return pulumi.get(self, "odata_type")

    @odata_type.setter
    def odata_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "odata_type", value)

    @property
    @pulumi.getter
    def start(self) -> pulumi.Input[str]:
        """
        The position in the input video from where to start generating thumbnails. The value can be in ISO 8601 format (For example, PT05S to start at 5 seconds), or a frame count (For example, 10 to start at the 10th frame), or a relative value to stream duration (For example, 10% to start at 10% of stream duration). Also supports a macro {Best}, which tells the encoder to select the best thumbnail from the first few seconds of the video and will only produce one thumbnail, no matter what other settings are for Step and Range. The default value is macro {Best}.
        """
        return pulumi.get(self, "start")

    @start.setter
    def start(self, value: pulumi.Input[str]):
        pulumi.set(self, "start", value)

    @property
    @pulumi.getter(name="keyFrameInterval")
    def key_frame_interval(self) -> Optional[pulumi.Input[str]]:
        """
        The distance between two key frames. The value should be non-zero in the range [0.5, 20] seconds, specified in ISO 8601 format. The default is 2 seconds(PT2S). Note that this setting is ignored if VideoSyncMode.Passthrough is set, where the KeyFrameInterval value will follow the input source setting.
        """
        return pulumi.get(self, "key_frame_interval")

    @key_frame_interval.setter
    def key_frame_interval(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_frame_interval", value)

    @property
    @pulumi.getter
    def label(self) -> Optional[pulumi.Input[str]]:
        """
        An optional label for the codec. The label can be used to control muxing behavior.
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "label", value)

    @property
    @pulumi.getter
    def layers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['JpgLayerArgs']]]]:
        """
        A collection of output JPEG image layers to be produced by the encoder.
        """
        return pulumi.get(self, "layers")

    @layers.setter
    def layers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['JpgLayerArgs']]]]):
        pulumi.set(self, "layers", value)

    @property
    @pulumi.getter
    def range(self) -> Optional[pulumi.Input[str]]:
        """
        The position relative to transform preset start time in the input video at which to stop generating thumbnails. The value can be in ISO 8601 format (For example, PT5M30S to stop at 5 minutes and 30 seconds from start time), or a frame count (For example, 300 to stop at the 300th frame from the frame at start time. If this value is 1, it means only producing one thumbnail at start time), or a relative value to the stream duration (For example, 50% to stop at half of stream duration from start time). The default value is 100%, which means to stop at the end of the stream.
        """
        return pulumi.get(self, "range")

    @range.setter
    def range(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "range", value)

    @property
    @pulumi.getter(name="spriteColumn")
    def sprite_column(self) -> Optional[pulumi.Input[int]]:
        """
        Sets the number of columns used in thumbnail sprite image.  The number of rows are automatically calculated and a VTT file is generated with the coordinate mappings for each thumbnail in the sprite. Note: this value should be a positive integer and a proper value is recommended so that the output image resolution will not go beyond JPEG maximum pixel resolution limit 65535x65535.
        """
        return pulumi.get(self, "sprite_column")

    @sprite_column.setter
    def sprite_column(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "sprite_column", value)

    @property
    @pulumi.getter
    def step(self) -> Optional[pulumi.Input[str]]:
        """
        The intervals at which thumbnails are generated. The value can be in ISO 8601 format (For example, PT05S for one image every 5 seconds), or a frame count (For example, 30 for one image every 30 frames), or a relative value to stream duration (For example, 10% for one image every 10% of stream duration). Note: Step value will affect the first generated thumbnail, which may not be exactly the one specified at transform preset start time. This is due to the encoder, which tries to select the best thumbnail between start time and Step position from start time as the first output. As the default value is 10%, it means if stream has long duration, the first generated thumbnail might be far away from the one specified at start time. Try to select reasonable value for Step if the first thumbnail is expected close to start time, or set Range value at 1 if only one thumbnail is needed at start time.
        """
        return pulumi.get(self, "step")

    @step.setter
    def step(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "step", value)

    @property
    @pulumi.getter(name="stretchMode")
    def stretch_mode(self) -> Optional[pulumi.Input[Union[str, 'StretchMode']]]:
        """
        The resizing mode - how the input video will be resized to fit the desired output resolution(s). Default is AutoSize
        """
        return pulumi.get(self, "stretch_mode")

    @stretch_mode.setter
    def stretch_mode(self, value: Optional[pulumi.Input[Union[str, 'StretchMode']]]):
        pulumi.set(self, "stretch_mode", value)

    @property
    @pulumi.getter(name="syncMode")
    def sync_mode(self) -> Optional[pulumi.Input[Union[str, 'VideoSyncMode']]]:
        """
        The Video Sync Mode
        """
        return pulumi.get(self, "sync_mode")

    @sync_mode.setter
    def sync_mode(self, value: Optional[pulumi.Input[Union[str, 'VideoSyncMode']]]):
        pulumi.set(self, "sync_mode", value)


@pulumi.input_type
class JpgLayerArgs:
    def __init__(__self__, *,
                 height: Optional[pulumi.Input[str]] = None,
                 label: Optional[pulumi.Input[str]] = None,
                 quality: Optional[pulumi.Input[int]] = None,
                 width: Optional[pulumi.Input[str]] = None):
        """
        Describes the settings to produce a JPEG image from the input video.
        :param pulumi.Input[str] height: The height of the output video for this layer. The value can be absolute (in pixels) or relative (in percentage). For example 50% means the output video has half as many pixels in height as the input.
        :param pulumi.Input[str] label: The alphanumeric label for this layer, which can be used in multiplexing different video and audio layers, or in naming the output file.
        :param pulumi.Input[int] quality: The compression quality of the JPEG output. Range is from 0-100 and the default is 70.
        :param pulumi.Input[str] width: The width of the output video for this layer. The value can be absolute (in pixels) or relative (in percentage). For example 50% means the output video has half as many pixels in width as the input.
        """
        if height is not None:
            pulumi.set(__self__, "height", height)
        if label is not None:
            pulumi.set(__self__, "label", label)
        if quality is not None:
            pulumi.set(__self__, "quality", quality)
        if width is not None:
            pulumi.set(__self__, "width", width)

    @property
    @pulumi.getter
    def height(self) -> Optional[pulumi.Input[str]]:
        """
        The height of the output video for this layer. The value can be absolute (in pixels) or relative (in percentage). For example 50% means the output video has half as many pixels in height as the input.
        """
        return pulumi.get(self, "height")

    @height.setter
    def height(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "height", value)

    @property
    @pulumi.getter
    def label(self) -> Optional[pulumi.Input[str]]:
        """
        The alphanumeric label for this layer, which can be used in multiplexing different video and audio layers, or in naming the output file.
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "label", value)

    @property
    @pulumi.getter
    def quality(self) -> Optional[pulumi.Input[int]]:
        """
        The compression quality of the JPEG output. Range is from 0-100 and the default is 70.
        """
        return pulumi.get(self, "quality")

    @quality.setter
    def quality(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "quality", value)

    @property
    @pulumi.getter
    def width(self) -> Optional[pulumi.Input[str]]:
        """
        The width of the output video for this layer. The value can be absolute (in pixels) or relative (in percentage). For example 50% means the output video has half as many pixels in width as the input.
        """
        return pulumi.get(self, "width")

    @width.setter
    def width(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "width", value)


@pulumi.input_type
class KeyDeliveryArgs:
    def __init__(__self__, *,
                 access_control: Optional[pulumi.Input['AccessControlArgs']] = None):
        """
        :param pulumi.Input['AccessControlArgs'] access_control: The access control properties for Key Delivery.
        """
        if access_control is not None:
            pulumi.set(__self__, "access_control", access_control)

    @property
    @pulumi.getter(name="accessControl")
    def access_control(self) -> Optional[pulumi.Input['AccessControlArgs']]:
        """
        The access control properties for Key Delivery.
        """
        return pulumi.get(self, "access_control")

    @access_control.setter
    def access_control(self, value: Optional[pulumi.Input['AccessControlArgs']]):
        pulumi.set(self, "access_control", value)


@pulumi.input_type
class KeyVaultPropertiesArgs:
    def __init__(__self__, *,
                 key_identifier: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] key_identifier: The URL of the Key Vault key used to encrypt the account. The key may either be versioned (for example https://vault/keys/mykey/version1) or reference a key without a version (for example https://vault/keys/mykey).
        """
        if key_identifier is not None:
            pulumi.set(__self__, "key_identifier", key_identifier)

    @property
    @pulumi.getter(name="keyIdentifier")
    def key_identifier(self) -> Optional[pulumi.Input[str]]:
        """
        The URL of the Key Vault key used to encrypt the account. The key may either be versioned (for example https://vault/keys/mykey/version1) or reference a key without a version (for example https://vault/keys/mykey).
        """
        return pulumi.get(self, "key_identifier")

    @key_identifier.setter
    def key_identifier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_identifier", value)


@pulumi.input_type
class LiveEventEncodingArgs:
    def __init__(__self__, *,
                 encoding_type: Optional[pulumi.Input[Union[str, 'LiveEventEncodingType']]] = None,
                 key_frame_interval: Optional[pulumi.Input[str]] = None,
                 preset_name: Optional[pulumi.Input[str]] = None,
                 stretch_mode: Optional[pulumi.Input[Union[str, 'StretchMode']]] = None):
        """
        Specifies the live event type and optional encoding settings for encoding live events.
        :param pulumi.Input[Union[str, 'LiveEventEncodingType']] encoding_type: Live event type. When encodingType is set to PassthroughBasic or PassthroughStandard, the service simply passes through the incoming video and audio layer(s) to the output. When encodingType is set to Standard or Premium1080p, a live encoder transcodes the incoming stream into multiple bitrates or layers. See https://go.microsoft.com/fwlink/?linkid=2095101 for more information. This property cannot be modified after the live event is created.
        :param pulumi.Input[str] key_frame_interval: Use an ISO 8601 time value between 0.5 to 20 seconds to specify the output fragment length for the video and audio tracks of an encoding live event. For example, use PT2S to indicate 2 seconds. For the video track it also defines the key frame interval, or the length of a GoP (group of pictures).   If this value is not set for an encoding live event, the fragment duration defaults to 2 seconds. The value cannot be set for pass-through live events.
        :param pulumi.Input[str] preset_name: The optional encoding preset name, used when encodingType is not None. This value is specified at creation time and cannot be updated. If the encodingType is set to Standard, then the default preset name is ‘Default720p’. Else if the encodingType is set to Premium1080p, the default preset is ‘Default1080p’.
        :param pulumi.Input[Union[str, 'StretchMode']] stretch_mode: Specifies how the input video will be resized to fit the desired output resolution(s). Default is None
        """
        if encoding_type is not None:
            pulumi.set(__self__, "encoding_type", encoding_type)
        if key_frame_interval is not None:
            pulumi.set(__self__, "key_frame_interval", key_frame_interval)
        if preset_name is not None:
            pulumi.set(__self__, "preset_name", preset_name)
        if stretch_mode is not None:
            pulumi.set(__self__, "stretch_mode", stretch_mode)

    @property
    @pulumi.getter(name="encodingType")
    def encoding_type(self) -> Optional[pulumi.Input[Union[str, 'LiveEventEncodingType']]]:
        """
        Live event type. When encodingType is set to PassthroughBasic or PassthroughStandard, the service simply passes through the incoming video and audio layer(s) to the output. When encodingType is set to Standard or Premium1080p, a live encoder transcodes the incoming stream into multiple bitrates or layers. See https://go.microsoft.com/fwlink/?linkid=2095101 for more information. This property cannot be modified after the live event is created.
        """
        return pulumi.get(self, "encoding_type")

    @encoding_type.setter
    def encoding_type(self, value: Optional[pulumi.Input[Union[str, 'LiveEventEncodingType']]]):
        pulumi.set(self, "encoding_type", value)

    @property
    @pulumi.getter(name="keyFrameInterval")
    def key_frame_interval(self) -> Optional[pulumi.Input[str]]:
        """
        Use an ISO 8601 time value between 0.5 to 20 seconds to specify the output fragment length for the video and audio tracks of an encoding live event. For example, use PT2S to indicate 2 seconds. For the video track it also defines the key frame interval, or the length of a GoP (group of pictures).   If this value is not set for an encoding live event, the fragment duration defaults to 2 seconds. The value cannot be set for pass-through live events.
        """
        return pulumi.get(self, "key_frame_interval")

    @key_frame_interval.setter
    def key_frame_interval(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_frame_interval", value)

    @property
    @pulumi.getter(name="presetName")
    def preset_name(self) -> Optional[pulumi.Input[str]]:
        """
        The optional encoding preset name, used when encodingType is not None. This value is specified at creation time and cannot be updated. If the encodingType is set to Standard, then the default preset name is ‘Default720p’. Else if the encodingType is set to Premium1080p, the default preset is ‘Default1080p’.
        """
        return pulumi.get(self, "preset_name")

    @preset_name.setter
    def preset_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "preset_name", value)

    @property
    @pulumi.getter(name="stretchMode")
    def stretch_mode(self) -> Optional[pulumi.Input[Union[str, 'StretchMode']]]:
        """
        Specifies how the input video will be resized to fit the desired output resolution(s). Default is None
        """
        return pulumi.get(self, "stretch_mode")

    @stretch_mode.setter
    def stretch_mode(self, value: Optional[pulumi.Input[Union[str, 'StretchMode']]]):
        pulumi.set(self, "stretch_mode", value)


@pulumi.input_type
class LiveEventEndpointArgs:
    def __init__(__self__, *,
                 protocol: Optional[pulumi.Input[str]] = None,
                 url: Optional[pulumi.Input[str]] = None):
        """
        The live event endpoint.
        :param pulumi.Input[str] protocol: The endpoint protocol.
        :param pulumi.Input[str] url: The endpoint URL.
        """
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[str]]:
        """
        The endpoint protocol.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[str]]:
        """
        The endpoint URL.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "url", value)


@pulumi.input_type
class LiveEventInputAccessControlArgs:
    def __init__(__self__, *,
                 ip: Optional[pulumi.Input['IPAccessControlArgs']] = None):
        """
        The IP access control for live event input.
        :param pulumi.Input['IPAccessControlArgs'] ip: The IP access control properties.
        """
        if ip is not None:
            pulumi.set(__self__, "ip", ip)

    @property
    @pulumi.getter
    def ip(self) -> Optional[pulumi.Input['IPAccessControlArgs']]:
        """
        The IP access control properties.
        """
        return pulumi.get(self, "ip")

    @ip.setter
    def ip(self, value: Optional[pulumi.Input['IPAccessControlArgs']]):
        pulumi.set(self, "ip", value)


@pulumi.input_type
class LiveEventInputTrackSelectionArgs:
    def __init__(__self__, *,
                 operation: Optional[pulumi.Input[str]] = None,
                 property: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None):
        """
        A track selection condition. This property is reserved for future use, any value set on this property will be ignored.
        :param pulumi.Input[str] operation: Comparing operation. This property is reserved for future use, any value set on this property will be ignored.
        :param pulumi.Input[str] property: Property name to select. This property is reserved for future use, any value set on this property will be ignored.
        :param pulumi.Input[str] value: Property value to select. This property is reserved for future use, any value set on this property will be ignored.
        """
        if operation is not None:
            pulumi.set(__self__, "operation", operation)
        if property is not None:
            pulumi.set(__self__, "property", property)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def operation(self) -> Optional[pulumi.Input[str]]:
        """
        Comparing operation. This property is reserved for future use, any value set on this property will be ignored.
        """
        return pulumi.get(self, "operation")

    @operation.setter
    def operation(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "operation", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        Property value to select. This property is reserved for future use, any value set on this property will be ignored.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)

    @property
    @pulumi.getter
    def property(self) -> Optional[pulumi.Input[str]]:
        """
        Property name to select. This property is reserved for future use, any value set on this property will be ignored.
        """
        return pulumi.get(self, "property")

    @property.setter
    def property(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "property", value)


@pulumi.input_type
class LiveEventInputArgs:
    def __init__(__self__, *,
                 streaming_protocol: pulumi.Input[Union[str, 'LiveEventInputProtocol']],
                 access_control: Optional[pulumi.Input['LiveEventInputAccessControlArgs']] = None,
                 access_token: Optional[pulumi.Input[str]] = None,
                 endpoints: Optional[pulumi.Input[Sequence[pulumi.Input['LiveEventEndpointArgs']]]] = None,
                 key_frame_interval_duration: Optional[pulumi.Input[str]] = None):
        """
        The live event input.
        :param pulumi.Input[Union[str, 'LiveEventInputProtocol']] streaming_protocol: The input protocol for the live event. This is specified at creation time and cannot be updated.
        :param pulumi.Input['LiveEventInputAccessControlArgs'] access_control: Access control for live event input.
        :param pulumi.Input[str] access_token: A UUID in string form to uniquely identify the stream. This can be specified at creation time but cannot be updated. If omitted, the service will generate a unique value.
        :param pulumi.Input[Sequence[pulumi.Input['LiveEventEndpointArgs']]] endpoints: The input endpoints for the live event.
        :param pulumi.Input[str] key_frame_interval_duration: ISO 8601 time duration of the key frame interval duration of the input. This value sets the EXT-X-TARGETDURATION property in the HLS output. For example, use PT2S to indicate 2 seconds. Leave the value empty for encoding live events.
        """
        pulumi.set(__self__, "streaming_protocol", streaming_protocol)
        if access_control is not None:
            pulumi.set(__self__, "access_control", access_control)
        if access_token is not None:
            pulumi.set(__self__, "access_token", access_token)
        if endpoints is not None:
            pulumi.set(__self__, "endpoints", endpoints)
        if key_frame_interval_duration is not None:
            pulumi.set(__self__, "key_frame_interval_duration", key_frame_interval_duration)

    @property
    @pulumi.getter(name="streamingProtocol")
    def streaming_protocol(self) -> pulumi.Input[Union[str, 'LiveEventInputProtocol']]:
        """
        The input protocol for the live event. This is specified at creation time and cannot be updated.
        """
        return pulumi.get(self, "streaming_protocol")

    @streaming_protocol.setter
    def streaming_protocol(self, value: pulumi.Input[Union[str, 'LiveEventInputProtocol']]):
        pulumi.set(self, "streaming_protocol", value)

    @property
    @pulumi.getter(name="accessControl")
    def access_control(self) -> Optional[pulumi.Input['LiveEventInputAccessControlArgs']]:
        """
        Access control for live event input.
        """
        return pulumi.get(self, "access_control")

    @access_control.setter
    def access_control(self, value: Optional[pulumi.Input['LiveEventInputAccessControlArgs']]):
        pulumi.set(self, "access_control", value)

    @property
    @pulumi.getter(name="accessToken")
    def access_token(self) -> Optional[pulumi.Input[str]]:
        """
        A UUID in string form to uniquely identify the stream. This can be specified at creation time but cannot be updated. If omitted, the service will generate a unique value.
        """
        return pulumi.get(self, "access_token")

    @access_token.setter
    def access_token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "access_token", value)

    @property
    @pulumi.getter
    def endpoints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LiveEventEndpointArgs']]]]:
        """
        The input endpoints for the live event.
        """
        return pulumi.get(self, "endpoints")

    @endpoints.setter
    def endpoints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LiveEventEndpointArgs']]]]):
        pulumi.set(self, "endpoints", value)

    @property
    @pulumi.getter(name="keyFrameIntervalDuration")
    def key_frame_interval_duration(self) -> Optional[pulumi.Input[str]]:
        """
        ISO 8601 time duration of the key frame interval duration of the input. This value sets the EXT-X-TARGETDURATION property in the HLS output. For example, use PT2S to indicate 2 seconds. Leave the value empty for encoding live events.
        """
        return pulumi.get(self, "key_frame_interval_duration")

    @key_frame_interval_duration.setter
    def key_frame_interval_duration(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_frame_interval_duration", value)


@pulumi.input_type
class LiveEventOutputTranscriptionTrackArgs:
    def __init__(__self__, *,
                 track_name: pulumi.Input[str]):
        """
        Describes a transcription track in the output of a live event, generated using speech-to-text transcription. This property is reserved for future use, any value set on this property will be ignored.
        :param pulumi.Input[str] track_name: The output track name. This property is reserved for future use, any value set on this property will be ignored.
        """
        pulumi.set(__self__, "track_name", track_name)

    @property
    @pulumi.getter(name="trackName")
    def track_name(self) -> pulumi.Input[str]:
        """
        The output track name. This property is reserved for future use, any value set on this property will be ignored.
        """
        return pulumi.get(self, "track_name")

    @track_name.setter
    def track_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "track_name", value)


@pulumi.input_type
class LiveEventPreviewAccessControlArgs:
    def __init__(__self__, *,
                 ip: Optional[pulumi.Input['IPAccessControlArgs']] = None):
        """
        The IP access control for the live event preview endpoint.
        :param pulumi.Input['IPAccessControlArgs'] ip: The IP access control properties.
        """
        if ip is not None:
            pulumi.set(__self__, "ip", ip)

    @property
    @pulumi.getter
    def ip(self) -> Optional[pulumi.Input['IPAccessControlArgs']]:
        """
        The IP access control properties.
        """
        return pulumi.get(self, "ip")

    @ip.setter
    def ip(self, value: Optional[pulumi.Input['IPAccessControlArgs']]):
        pulumi.set(self, "ip", value)


@pulumi.input_type
class LiveEventPreviewArgs:
    def __init__(__self__, *,
                 access_control: Optional[pulumi.Input['LiveEventPreviewAccessControlArgs']] = None,
                 alternative_media_id: Optional[pulumi.Input[str]] = None,
                 endpoints: Optional[pulumi.Input[Sequence[pulumi.Input['LiveEventEndpointArgs']]]] = None,
                 preview_locator: Optional[pulumi.Input[str]] = None,
                 streaming_policy_name: Optional[pulumi.Input[str]] = None):
        """
        Live event preview settings.
        :param pulumi.Input['LiveEventPreviewAccessControlArgs'] access_control: The access control for live event preview.
        :param pulumi.Input[str] alternative_media_id: An alternative media identifier associated with the streaming locator created for the preview. This value is specified at creation time and cannot be updated. The identifier can be used in the CustomLicenseAcquisitionUrlTemplate or the CustomKeyAcquisitionUrlTemplate of the StreamingPolicy specified in the StreamingPolicyName field.
        :param pulumi.Input[Sequence[pulumi.Input['LiveEventEndpointArgs']]] endpoints: The endpoints for preview. Do not share the preview URL with the live event audience.
        :param pulumi.Input[str] preview_locator: The identifier of the preview locator in Guid format. Specifying this at creation time allows the caller to know the preview locator url before the event is created. If omitted, the service will generate a random identifier. This value cannot be updated once the live event is created.
        :param pulumi.Input[str] streaming_policy_name: The name of streaming policy used for the live event preview. This value is specified at creation time and cannot be updated.
        """
        if access_control is not None:
            pulumi.set(__self__, "access_control", access_control)
        if alternative_media_id is not None:
            pulumi.set(__self__, "alternative_media_id", alternative_media_id)
        if endpoints is not None:
            pulumi.set(__self__, "endpoints", endpoints)
        if preview_locator is not None:
            pulumi.set(__self__, "preview_locator", preview_locator)
        if streaming_policy_name is not None:
            pulumi.set(__self__, "streaming_policy_name", streaming_policy_name)

    @property
    @pulumi.getter(name="accessControl")
    def access_control(self) -> Optional[pulumi.Input['LiveEventPreviewAccessControlArgs']]:
        """
        The access control for live event preview.
        """
        return pulumi.get(self, "access_control")

    @access_control.setter
    def access_control(self, value: Optional[pulumi.Input['LiveEventPreviewAccessControlArgs']]):
        pulumi.set(self, "access_control", value)

    @property
    @pulumi.getter(name="alternativeMediaId")
    def alternative_media_id(self) -> Optional[pulumi.Input[str]]:
        """
        An alternative media identifier associated with the streaming locator created for the preview. This value is specified at creation time and cannot be updated. The identifier can be used in the CustomLicenseAcquisitionUrlTemplate or the CustomKeyAcquisitionUrlTemplate of the StreamingPolicy specified in the StreamingPolicyName field.
        """
        return pulumi.get(self, "alternative_media_id")

    @alternative_media_id.setter
    def alternative_media_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "alternative_media_id", value)

    @property
    @pulumi.getter
    def endpoints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LiveEventEndpointArgs']]]]:
        """
        The endpoints for preview. Do not share the preview URL with the live event audience.
        """
        return pulumi.get(self, "endpoints")

    @endpoints.setter
    def endpoints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LiveEventEndpointArgs']]]]):
        pulumi.set(self, "endpoints", value)

    @property
    @pulumi.getter(name="previewLocator")
    def preview_locator(self) -> Optional[pulumi.Input[str]]:
        """
        The identifier of the preview locator in Guid format. Specifying this at creation time allows the caller to know the preview locator url before the event is created. If omitted, the service will generate a random identifier. This value cannot be updated once the live event is created.
        """
        return pulumi.get(self, "preview_locator")

    @preview_locator.setter
    def preview_locator(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "preview_locator", value)

    @property
    @pulumi.getter(name="streamingPolicyName")
    def streaming_policy_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of streaming policy used for the live event preview. This value is specified at creation time and cannot be updated.
        """
        return pulumi.get(self, "streaming_policy_name")

    @streaming_policy_name.setter
    def streaming_policy_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "streaming_policy_name", value)


@pulumi.input_type
class LiveEventTranscriptionArgs:
    def __init__(__self__, *,
                 input_track_selection: Optional[pulumi.Input[Sequence[pulumi.Input['LiveEventInputTrackSelectionArgs']]]] = None,
                 language: Optional[pulumi.Input[str]] = None,
                 output_transcription_track: Optional[pulumi.Input['LiveEventOutputTranscriptionTrackArgs']] = None):
        """
        Describes the transcription tracks in the output of a live event, generated using speech-to-text transcription. This property is reserved for future use, any value set on this property will be ignored.
        :param pulumi.Input[Sequence[pulumi.Input['LiveEventInputTrackSelectionArgs']]] input_track_selection: Provides a mechanism to select the audio track in the input live feed, to which speech-to-text transcription is applied. This property is reserved for future use, any value set on this property will be ignored.
        :param pulumi.Input[str] language: Specifies the language (locale) to be used for speech-to-text transcription – it should match the spoken language in the audio track. The value should be in BCP-47 format (e.g: 'en-US'). See https://go.microsoft.com/fwlink/?linkid=2133742 for more information about the live transcription feature and the list of supported languages.
        :param pulumi.Input['LiveEventOutputTranscriptionTrackArgs'] output_transcription_track: Describes a transcription track in the output of a live event, generated using speech-to-text transcription. This property is reserved for future use, any value set on this property will be ignored.
        """
        if input_track_selection is not None:
            pulumi.set(__self__, "input_track_selection", input_track_selection)
        if language is not None:
            pulumi.set(__self__, "language", language)
        if output_transcription_track is not None:
            pulumi.set(__self__, "output_transcription_track", output_transcription_track)

    @property
    @pulumi.getter(name="inputTrackSelection")
    def input_track_selection(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LiveEventInputTrackSelectionArgs']]]]:
        """
        Provides a mechanism to select the audio track in the input live feed, to which speech-to-text transcription is applied. This property is reserved for future use, any value set on this property will be ignored.
        """
        return pulumi.get(self, "input_track_selection")

    @input_track_selection.setter
    def input_track_selection(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LiveEventInputTrackSelectionArgs']]]]):
        pulumi.set(self, "input_track_selection", value)

    @property
    @pulumi.getter
    def language(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the language (locale) to be used for speech-to-text transcription – it should match the spoken language in the audio track. The value should be in BCP-47 format (e.g: 'en-US'). See https://go.microsoft.com/fwlink/?linkid=2133742 for more information about the live transcription feature and the list of supported languages.
        """
        return pulumi.get(self, "language")

    @language.setter
    def language(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "language", value)

    @property
    @pulumi.getter(name="outputTranscriptionTrack")
    def output_transcription_track(self) -> Optional[pulumi.Input['LiveEventOutputTranscriptionTrackArgs']]:
        """
        Describes a transcription track in the output of a live event, generated using speech-to-text transcription. This property is reserved for future use, any value set on this property will be ignored.
        """
        return pulumi.get(self, "output_transcription_track")

    @output_transcription_track.setter
    def output_transcription_track(self, value: Optional[pulumi.Input['LiveEventOutputTranscriptionTrackArgs']]):
        pulumi.set(self, "output_transcription_track", value)


@pulumi.input_type
class MediaServiceIdentityArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 user_assigned_identities: Optional[pulumi.Input[Mapping[str, Any]]] = None):
        """
        :param pulumi.Input[str] type: The identity type.
        :param pulumi.Input[Mapping[str, Any]] user_assigned_identities: The user assigned managed identities.
        """
        pulumi.set(__self__, "type", type)
        if user_assigned_identities is not None:
            pulumi.set(__self__, "user_assigned_identities", user_assigned_identities)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The identity type.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="userAssignedIdentities")
    def user_assigned_identities(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        The user assigned managed identities.
        """
        return pulumi.get(self, "user_assigned_identities")

    @user_assigned_identities.setter
    def user_assigned_identities(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "user_assigned_identities", value)


@pulumi.input_type
class Mp4FormatArgs:
    def __init__(__self__, *,
                 filename_pattern: pulumi.Input[str],
                 odata_type: pulumi.Input[str],
                 output_files: Optional[pulumi.Input[Sequence[pulumi.Input['OutputFileArgs']]]] = None):
        """
        Describes the properties for an output ISO MP4 file.
        :param pulumi.Input[str] filename_pattern: The pattern of the file names for the generated output files. The following macros are supported in the file name: {Basename} - An expansion macro that will use the name of the input video file. If the base name(the file suffix is not included) of the input video file is less than 32 characters long, the base name of input video files will be used. If the length of base name of the input video file exceeds 32 characters, the base name is truncated to the first 32 characters in total length. {Extension} - The appropriate extension for this format. {Label} - The label assigned to the codec/layer. {Index} - A unique index for thumbnails. Only applicable to thumbnails. {Bitrate} - The audio/video bitrate. Not applicable to thumbnails. {Codec} - The type of the audio/video codec. {Resolution} - The video resolution. Any unsubstituted macros will be collapsed and removed from the filename.
        :param pulumi.Input[str] odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.Mp4Format'.
        :param pulumi.Input[Sequence[pulumi.Input['OutputFileArgs']]] output_files: The list of output files to produce.  Each entry in the list is a set of audio and video layer labels to be muxed together .
        """
        pulumi.set(__self__, "filename_pattern", filename_pattern)
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.Mp4Format')
        if output_files is not None:
            pulumi.set(__self__, "output_files", output_files)

    @property
    @pulumi.getter(name="filenamePattern")
    def filename_pattern(self) -> pulumi.Input[str]:
        """
        The pattern of the file names for the generated output files. The following macros are supported in the file name: {Basename} - An expansion macro that will use the name of the input video file. If the base name(the file suffix is not included) of the input video file is less than 32 characters long, the base name of input video files will be used. If the length of base name of the input video file exceeds 32 characters, the base name is truncated to the first 32 characters in total length. {Extension} - The appropriate extension for this format. {Label} - The label assigned to the codec/layer. {Index} - A unique index for thumbnails. Only applicable to thumbnails. {Bitrate} - The audio/video bitrate. Not applicable to thumbnails. {Codec} - The type of the audio/video codec. {Resolution} - The video resolution. Any unsubstituted macros will be collapsed and removed from the filename.
        """
        return pulumi.get(self, "filename_pattern")

    @filename_pattern.setter
    def filename_pattern(self, value: pulumi.Input[str]):
        pulumi.set(self, "filename_pattern", value)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> pulumi.Input[str]:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.Mp4Format'.
        """
        return pulumi.get(self, "odata_type")

    @odata_type.setter
    def odata_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "odata_type", value)

    @property
    @pulumi.getter(name="outputFiles")
    def output_files(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OutputFileArgs']]]]:
        """
        The list of output files to produce.  Each entry in the list is a set of audio and video layer labels to be muxed together .
        """
        return pulumi.get(self, "output_files")

    @output_files.setter
    def output_files(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OutputFileArgs']]]]):
        pulumi.set(self, "output_files", value)


@pulumi.input_type
class MultiBitrateFormatArgs:
    def __init__(__self__, *,
                 filename_pattern: pulumi.Input[str],
                 odata_type: pulumi.Input[str],
                 output_files: Optional[pulumi.Input[Sequence[pulumi.Input['OutputFileArgs']]]] = None):
        """
        Describes the properties for producing a collection of GOP aligned multi-bitrate files. The default behavior is to produce one output file for each video layer which is muxed together with all the audios. The exact output files produced can be controlled by specifying the outputFiles collection.
        :param pulumi.Input[str] filename_pattern: The pattern of the file names for the generated output files. The following macros are supported in the file name: {Basename} - An expansion macro that will use the name of the input video file. If the base name(the file suffix is not included) of the input video file is less than 32 characters long, the base name of input video files will be used. If the length of base name of the input video file exceeds 32 characters, the base name is truncated to the first 32 characters in total length. {Extension} - The appropriate extension for this format. {Label} - The label assigned to the codec/layer. {Index} - A unique index for thumbnails. Only applicable to thumbnails. {Bitrate} - The audio/video bitrate. Not applicable to thumbnails. {Codec} - The type of the audio/video codec. {Resolution} - The video resolution. Any unsubstituted macros will be collapsed and removed from the filename.
        :param pulumi.Input[str] odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.MultiBitrateFormat'.
        :param pulumi.Input[Sequence[pulumi.Input['OutputFileArgs']]] output_files: The list of output files to produce.  Each entry in the list is a set of audio and video layer labels to be muxed together .
        """
        pulumi.set(__self__, "filename_pattern", filename_pattern)
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.MultiBitrateFormat')
        if output_files is not None:
            pulumi.set(__self__, "output_files", output_files)

    @property
    @pulumi.getter(name="filenamePattern")
    def filename_pattern(self) -> pulumi.Input[str]:
        """
        The pattern of the file names for the generated output files. The following macros are supported in the file name: {Basename} - An expansion macro that will use the name of the input video file. If the base name(the file suffix is not included) of the input video file is less than 32 characters long, the base name of input video files will be used. If the length of base name of the input video file exceeds 32 characters, the base name is truncated to the first 32 characters in total length. {Extension} - The appropriate extension for this format. {Label} - The label assigned to the codec/layer. {Index} - A unique index for thumbnails. Only applicable to thumbnails. {Bitrate} - The audio/video bitrate. Not applicable to thumbnails. {Codec} - The type of the audio/video codec. {Resolution} - The video resolution. Any unsubstituted macros will be collapsed and removed from the filename.
        """
        return pulumi.get(self, "filename_pattern")

    @filename_pattern.setter
    def filename_pattern(self, value: pulumi.Input[str]):
        pulumi.set(self, "filename_pattern", value)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> pulumi.Input[str]:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.MultiBitrateFormat'.
        """
        return pulumi.get(self, "odata_type")

    @odata_type.setter
    def odata_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "odata_type", value)

    @property
    @pulumi.getter(name="outputFiles")
    def output_files(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OutputFileArgs']]]]:
        """
        The list of output files to produce.  Each entry in the list is a set of audio and video layer labels to be muxed together .
        """
        return pulumi.get(self, "output_files")

    @output_files.setter
    def output_files(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OutputFileArgs']]]]):
        pulumi.set(self, "output_files", value)


@pulumi.input_type
class NoEncryptionArgs:
    def __init__(__self__, *,
                 enabled_protocols: Optional[pulumi.Input['EnabledProtocolsArgs']] = None):
        """
        Class for NoEncryption scheme
        :param pulumi.Input['EnabledProtocolsArgs'] enabled_protocols: Representing supported protocols
        """
        if enabled_protocols is not None:
            pulumi.set(__self__, "enabled_protocols", enabled_protocols)

    @property
    @pulumi.getter(name="enabledProtocols")
    def enabled_protocols(self) -> Optional[pulumi.Input['EnabledProtocolsArgs']]:
        """
        Representing supported protocols
        """
        return pulumi.get(self, "enabled_protocols")

    @enabled_protocols.setter
    def enabled_protocols(self, value: Optional[pulumi.Input['EnabledProtocolsArgs']]):
        pulumi.set(self, "enabled_protocols", value)


@pulumi.input_type
class OutputFileArgs:
    def __init__(__self__, *,
                 labels: pulumi.Input[Sequence[pulumi.Input[str]]]):
        """
        Represents an output file produced.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] labels: The list of labels that describe how the encoder should multiplex video and audio into an output file. For example, if the encoder is producing two video layers with labels v1 and v2, and one audio layer with label a1, then an array like '[v1, a1]' tells the encoder to produce an output file with the video track represented by v1 and the audio track represented by a1.
        """
        pulumi.set(__self__, "labels", labels)

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        The list of labels that describe how the encoder should multiplex video and audio into an output file. For example, if the encoder is producing two video layers with labels v1 and v2, and one audio layer with label a1, then an array like '[v1, a1]' tells the encoder to produce an output file with the video track represented by v1 and the audio track represented by a1.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "labels", value)


@pulumi.input_type
class PngFormatArgs:
    def __init__(__self__, *,
                 filename_pattern: pulumi.Input[str],
                 odata_type: pulumi.Input[str]):
        """
        Describes the settings for producing PNG thumbnails.
        :param pulumi.Input[str] filename_pattern: The pattern of the file names for the generated output files. The following macros are supported in the file name: {Basename} - An expansion macro that will use the name of the input video file. If the base name(the file suffix is not included) of the input video file is less than 32 characters long, the base name of input video files will be used. If the length of base name of the input video file exceeds 32 characters, the base name is truncated to the first 32 characters in total length. {Extension} - The appropriate extension for this format. {Label} - The label assigned to the codec/layer. {Index} - A unique index for thumbnails. Only applicable to thumbnails. {Bitrate} - The audio/video bitrate. Not applicable to thumbnails. {Codec} - The type of the audio/video codec. {Resolution} - The video resolution. Any unsubstituted macros will be collapsed and removed from the filename.
        :param pulumi.Input[str] odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.PngFormat'.
        """
        pulumi.set(__self__, "filename_pattern", filename_pattern)
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.PngFormat')

    @property
    @pulumi.getter(name="filenamePattern")
    def filename_pattern(self) -> pulumi.Input[str]:
        """
        The pattern of the file names for the generated output files. The following macros are supported in the file name: {Basename} - An expansion macro that will use the name of the input video file. If the base name(the file suffix is not included) of the input video file is less than 32 characters long, the base name of input video files will be used. If the length of base name of the input video file exceeds 32 characters, the base name is truncated to the first 32 characters in total length. {Extension} - The appropriate extension for this format. {Label} - The label assigned to the codec/layer. {Index} - A unique index for thumbnails. Only applicable to thumbnails. {Bitrate} - The audio/video bitrate. Not applicable to thumbnails. {Codec} - The type of the audio/video codec. {Resolution} - The video resolution. Any unsubstituted macros will be collapsed and removed from the filename.
        """
        return pulumi.get(self, "filename_pattern")

    @filename_pattern.setter
    def filename_pattern(self, value: pulumi.Input[str]):
        pulumi.set(self, "filename_pattern", value)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> pulumi.Input[str]:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.PngFormat'.
        """
        return pulumi.get(self, "odata_type")

    @odata_type.setter
    def odata_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "odata_type", value)


@pulumi.input_type
class PngImageArgs:
    def __init__(__self__, *,
                 odata_type: pulumi.Input[str],
                 start: pulumi.Input[str],
                 key_frame_interval: Optional[pulumi.Input[str]] = None,
                 label: Optional[pulumi.Input[str]] = None,
                 layers: Optional[pulumi.Input[Sequence[pulumi.Input['PngLayerArgs']]]] = None,
                 range: Optional[pulumi.Input[str]] = None,
                 step: Optional[pulumi.Input[str]] = None,
                 stretch_mode: Optional[pulumi.Input[Union[str, 'StretchMode']]] = None,
                 sync_mode: Optional[pulumi.Input[Union[str, 'VideoSyncMode']]] = None):
        """
        Describes the properties for producing a series of PNG images from the input video.
        :param pulumi.Input[str] odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.PngImage'.
        :param pulumi.Input[str] start: The position in the input video from where to start generating thumbnails. The value can be in ISO 8601 format (For example, PT05S to start at 5 seconds), or a frame count (For example, 10 to start at the 10th frame), or a relative value to stream duration (For example, 10% to start at 10% of stream duration). Also supports a macro {Best}, which tells the encoder to select the best thumbnail from the first few seconds of the video and will only produce one thumbnail, no matter what other settings are for Step and Range. The default value is macro {Best}.
        :param pulumi.Input[str] key_frame_interval: The distance between two key frames. The value should be non-zero in the range [0.5, 20] seconds, specified in ISO 8601 format. The default is 2 seconds(PT2S). Note that this setting is ignored if VideoSyncMode.Passthrough is set, where the KeyFrameInterval value will follow the input source setting.
        :param pulumi.Input[str] label: An optional label for the codec. The label can be used to control muxing behavior.
        :param pulumi.Input[Sequence[pulumi.Input['PngLayerArgs']]] layers: A collection of output PNG image layers to be produced by the encoder.
        :param pulumi.Input[str] range: The position relative to transform preset start time in the input video at which to stop generating thumbnails. The value can be in ISO 8601 format (For example, PT5M30S to stop at 5 minutes and 30 seconds from start time), or a frame count (For example, 300 to stop at the 300th frame from the frame at start time. If this value is 1, it means only producing one thumbnail at start time), or a relative value to the stream duration (For example, 50% to stop at half of stream duration from start time). The default value is 100%, which means to stop at the end of the stream.
        :param pulumi.Input[str] step: The intervals at which thumbnails are generated. The value can be in ISO 8601 format (For example, PT05S for one image every 5 seconds), or a frame count (For example, 30 for one image every 30 frames), or a relative value to stream duration (For example, 10% for one image every 10% of stream duration). Note: Step value will affect the first generated thumbnail, which may not be exactly the one specified at transform preset start time. This is due to the encoder, which tries to select the best thumbnail between start time and Step position from start time as the first output. As the default value is 10%, it means if stream has long duration, the first generated thumbnail might be far away from the one specified at start time. Try to select reasonable value for Step if the first thumbnail is expected close to start time, or set Range value at 1 if only one thumbnail is needed at start time.
        :param pulumi.Input[Union[str, 'StretchMode']] stretch_mode: The resizing mode - how the input video will be resized to fit the desired output resolution(s). Default is AutoSize
        :param pulumi.Input[Union[str, 'VideoSyncMode']] sync_mode: The Video Sync Mode
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.PngImage')
        pulumi.set(__self__, "start", start)
        if key_frame_interval is not None:
            pulumi.set(__self__, "key_frame_interval", key_frame_interval)
        if label is not None:
            pulumi.set(__self__, "label", label)
        if layers is not None:
            pulumi.set(__self__, "layers", layers)
        if range is not None:
            pulumi.set(__self__, "range", range)
        if step is not None:
            pulumi.set(__self__, "step", step)
        if stretch_mode is not None:
            pulumi.set(__self__, "stretch_mode", stretch_mode)
        if sync_mode is not None:
            pulumi.set(__self__, "sync_mode", sync_mode)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> pulumi.Input[str]:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.PngImage'.
        """
        return pulumi.get(self, "odata_type")

    @odata_type.setter
    def odata_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "odata_type", value)

    @property
    @pulumi.getter
    def start(self) -> pulumi.Input[str]:
        """
        The position in the input video from where to start generating thumbnails. The value can be in ISO 8601 format (For example, PT05S to start at 5 seconds), or a frame count (For example, 10 to start at the 10th frame), or a relative value to stream duration (For example, 10% to start at 10% of stream duration). Also supports a macro {Best}, which tells the encoder to select the best thumbnail from the first few seconds of the video and will only produce one thumbnail, no matter what other settings are for Step and Range. The default value is macro {Best}.
        """
        return pulumi.get(self, "start")

    @start.setter
    def start(self, value: pulumi.Input[str]):
        pulumi.set(self, "start", value)

    @property
    @pulumi.getter(name="keyFrameInterval")
    def key_frame_interval(self) -> Optional[pulumi.Input[str]]:
        """
        The distance between two key frames. The value should be non-zero in the range [0.5, 20] seconds, specified in ISO 8601 format. The default is 2 seconds(PT2S). Note that this setting is ignored if VideoSyncMode.Passthrough is set, where the KeyFrameInterval value will follow the input source setting.
        """
        return pulumi.get(self, "key_frame_interval")

    @key_frame_interval.setter
    def key_frame_interval(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_frame_interval", value)

    @property
    @pulumi.getter
    def label(self) -> Optional[pulumi.Input[str]]:
        """
        An optional label for the codec. The label can be used to control muxing behavior.
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "label", value)

    @property
    @pulumi.getter
    def layers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PngLayerArgs']]]]:
        """
        A collection of output PNG image layers to be produced by the encoder.
        """
        return pulumi.get(self, "layers")

    @layers.setter
    def layers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PngLayerArgs']]]]):
        pulumi.set(self, "layers", value)

    @property
    @pulumi.getter
    def range(self) -> Optional[pulumi.Input[str]]:
        """
        The position relative to transform preset start time in the input video at which to stop generating thumbnails. The value can be in ISO 8601 format (For example, PT5M30S to stop at 5 minutes and 30 seconds from start time), or a frame count (For example, 300 to stop at the 300th frame from the frame at start time. If this value is 1, it means only producing one thumbnail at start time), or a relative value to the stream duration (For example, 50% to stop at half of stream duration from start time). The default value is 100%, which means to stop at the end of the stream.
        """
        return pulumi.get(self, "range")

    @range.setter
    def range(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "range", value)

    @property
    @pulumi.getter
    def step(self) -> Optional[pulumi.Input[str]]:
        """
        The intervals at which thumbnails are generated. The value can be in ISO 8601 format (For example, PT05S for one image every 5 seconds), or a frame count (For example, 30 for one image every 30 frames), or a relative value to stream duration (For example, 10% for one image every 10% of stream duration). Note: Step value will affect the first generated thumbnail, which may not be exactly the one specified at transform preset start time. This is due to the encoder, which tries to select the best thumbnail between start time and Step position from start time as the first output. As the default value is 10%, it means if stream has long duration, the first generated thumbnail might be far away from the one specified at start time. Try to select reasonable value for Step if the first thumbnail is expected close to start time, or set Range value at 1 if only one thumbnail is needed at start time.
        """
        return pulumi.get(self, "step")

    @step.setter
    def step(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "step", value)

    @property
    @pulumi.getter(name="stretchMode")
    def stretch_mode(self) -> Optional[pulumi.Input[Union[str, 'StretchMode']]]:
        """
        The resizing mode - how the input video will be resized to fit the desired output resolution(s). Default is AutoSize
        """
        return pulumi.get(self, "stretch_mode")

    @stretch_mode.setter
    def stretch_mode(self, value: Optional[pulumi.Input[Union[str, 'StretchMode']]]):
        pulumi.set(self, "stretch_mode", value)

    @property
    @pulumi.getter(name="syncMode")
    def sync_mode(self) -> Optional[pulumi.Input[Union[str, 'VideoSyncMode']]]:
        """
        The Video Sync Mode
        """
        return pulumi.get(self, "sync_mode")

    @sync_mode.setter
    def sync_mode(self, value: Optional[pulumi.Input[Union[str, 'VideoSyncMode']]]):
        pulumi.set(self, "sync_mode", value)


@pulumi.input_type
class PngLayerArgs:
    def __init__(__self__, *,
                 height: Optional[pulumi.Input[str]] = None,
                 label: Optional[pulumi.Input[str]] = None,
                 width: Optional[pulumi.Input[str]] = None):
        """
        Describes the settings to produce a PNG image from the input video.
        :param pulumi.Input[str] height: The height of the output video for this layer. The value can be absolute (in pixels) or relative (in percentage). For example 50% means the output video has half as many pixels in height as the input.
        :param pulumi.Input[str] label: The alphanumeric label for this layer, which can be used in multiplexing different video and audio layers, or in naming the output file.
        :param pulumi.Input[str] width: The width of the output video for this layer. The value can be absolute (in pixels) or relative (in percentage). For example 50% means the output video has half as many pixels in width as the input.
        """
        if height is not None:
            pulumi.set(__self__, "height", height)
        if label is not None:
            pulumi.set(__self__, "label", label)
        if width is not None:
            pulumi.set(__self__, "width", width)

    @property
    @pulumi.getter
    def height(self) -> Optional[pulumi.Input[str]]:
        """
        The height of the output video for this layer. The value can be absolute (in pixels) or relative (in percentage). For example 50% means the output video has half as many pixels in height as the input.
        """
        return pulumi.get(self, "height")

    @height.setter
    def height(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "height", value)

    @property
    @pulumi.getter
    def label(self) -> Optional[pulumi.Input[str]]:
        """
        The alphanumeric label for this layer, which can be used in multiplexing different video and audio layers, or in naming the output file.
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "label", value)

    @property
    @pulumi.getter
    def width(self) -> Optional[pulumi.Input[str]]:
        """
        The width of the output video for this layer. The value can be absolute (in pixels) or relative (in percentage). For example 50% means the output video has half as many pixels in width as the input.
        """
        return pulumi.get(self, "width")

    @width.setter
    def width(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "width", value)


@pulumi.input_type
class PresentationTimeRangeArgs:
    def __init__(__self__, *,
                 end_timestamp: Optional[pulumi.Input[float]] = None,
                 force_end_timestamp: Optional[pulumi.Input[bool]] = None,
                 live_backoff_duration: Optional[pulumi.Input[float]] = None,
                 presentation_window_duration: Optional[pulumi.Input[float]] = None,
                 start_timestamp: Optional[pulumi.Input[float]] = None,
                 timescale: Optional[pulumi.Input[float]] = None):
        """
        The presentation time range, this is asset related and not recommended for Account Filter.
        :param pulumi.Input[float] end_timestamp: The absolute end time boundary.
        :param pulumi.Input[bool] force_end_timestamp: The indicator of forcing existing of end time stamp.
        :param pulumi.Input[float] live_backoff_duration: The relative to end right edge.
        :param pulumi.Input[float] presentation_window_duration: The relative to end sliding window.
        :param pulumi.Input[float] start_timestamp: The absolute start time boundary.
        :param pulumi.Input[float] timescale: The time scale of time stamps.
        """
        if end_timestamp is not None:
            pulumi.set(__self__, "end_timestamp", end_timestamp)
        if force_end_timestamp is not None:
            pulumi.set(__self__, "force_end_timestamp", force_end_timestamp)
        if live_backoff_duration is not None:
            pulumi.set(__self__, "live_backoff_duration", live_backoff_duration)
        if presentation_window_duration is not None:
            pulumi.set(__self__, "presentation_window_duration", presentation_window_duration)
        if start_timestamp is not None:
            pulumi.set(__self__, "start_timestamp", start_timestamp)
        if timescale is not None:
            pulumi.set(__self__, "timescale", timescale)

    @property
    @pulumi.getter(name="endTimestamp")
    def end_timestamp(self) -> Optional[pulumi.Input[float]]:
        """
        The absolute end time boundary.
        """
        return pulumi.get(self, "end_timestamp")

    @end_timestamp.setter
    def end_timestamp(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "end_timestamp", value)

    @property
    @pulumi.getter(name="forceEndTimestamp")
    def force_end_timestamp(self) -> Optional[pulumi.Input[bool]]:
        """
        The indicator of forcing existing of end time stamp.
        """
        return pulumi.get(self, "force_end_timestamp")

    @force_end_timestamp.setter
    def force_end_timestamp(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "force_end_timestamp", value)

    @property
    @pulumi.getter(name="liveBackoffDuration")
    def live_backoff_duration(self) -> Optional[pulumi.Input[float]]:
        """
        The relative to end right edge.
        """
        return pulumi.get(self, "live_backoff_duration")

    @live_backoff_duration.setter
    def live_backoff_duration(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "live_backoff_duration", value)

    @property
    @pulumi.getter(name="presentationWindowDuration")
    def presentation_window_duration(self) -> Optional[pulumi.Input[float]]:
        """
        The relative to end sliding window.
        """
        return pulumi.get(self, "presentation_window_duration")

    @presentation_window_duration.setter
    def presentation_window_duration(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "presentation_window_duration", value)

    @property
    @pulumi.getter(name="startTimestamp")
    def start_timestamp(self) -> Optional[pulumi.Input[float]]:
        """
        The absolute start time boundary.
        """
        return pulumi.get(self, "start_timestamp")

    @start_timestamp.setter
    def start_timestamp(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "start_timestamp", value)

    @property
    @pulumi.getter
    def timescale(self) -> Optional[pulumi.Input[float]]:
        """
        The time scale of time stamps.
        """
        return pulumi.get(self, "timescale")

    @timescale.setter
    def timescale(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "timescale", value)


@pulumi.input_type
class PresetConfigurationsArgs:
    def __init__(__self__, *,
                 complexity: Optional[pulumi.Input[Union[str, 'Complexity']]] = None,
                 interleave_output: Optional[pulumi.Input[Union[str, 'InterleaveOutput']]] = None,
                 key_frame_interval_in_seconds: Optional[pulumi.Input[float]] = None,
                 max_bitrate_bps: Optional[pulumi.Input[int]] = None,
                 max_height: Optional[pulumi.Input[int]] = None,
                 max_layers: Optional[pulumi.Input[int]] = None,
                 min_bitrate_bps: Optional[pulumi.Input[int]] = None,
                 min_height: Optional[pulumi.Input[int]] = None):
        """
        An object of optional configuration settings for encoder.
        :param pulumi.Input[Union[str, 'Complexity']] complexity: Allows you to configure the encoder settings to control the balance between speed and quality. Example: set Complexity as Speed for faster encoding but less compression efficiency.
        :param pulumi.Input[Union[str, 'InterleaveOutput']] interleave_output: Sets the interleave mode of the output to control how audio and video are stored in the container format. Example: set InterleavedOutput as NonInterleavedOutput to produce audio-only and video-only outputs in separate MP4 files.
        :param pulumi.Input[float] key_frame_interval_in_seconds: The key frame interval in seconds. Example: set KeyFrameIntervalInSeconds as 2 to reduce the playback buffering for some players.
        :param pulumi.Input[int] max_bitrate_bps: The maximum bitrate in bits per second (threshold for the top video layer). Example: set MaxBitrateBps as 6000000 to avoid producing very high bitrate outputs for contents with high complexity.
        :param pulumi.Input[int] max_height: The maximum height of output video layers. Example: set MaxHeight as 720 to produce output layers up to 720P even if the input is 4K.
        :param pulumi.Input[int] max_layers: The maximum number of output video layers. Example: set MaxLayers as 4 to make sure at most 4 output layers are produced to control the overall cost of the encoding job.
        :param pulumi.Input[int] min_bitrate_bps: The minimum bitrate in bits per second (threshold for the bottom video layer). Example: set MinBitrateBps as 200000 to have a bottom layer that covers users with low network bandwidth.
        :param pulumi.Input[int] min_height: The minimum height of output video layers. Example: set MinHeight as 360 to avoid output layers of smaller resolutions like 180P.
        """
        if complexity is not None:
            pulumi.set(__self__, "complexity", complexity)
        if interleave_output is not None:
            pulumi.set(__self__, "interleave_output", interleave_output)
        if key_frame_interval_in_seconds is not None:
            pulumi.set(__self__, "key_frame_interval_in_seconds", key_frame_interval_in_seconds)
        if max_bitrate_bps is not None:
            pulumi.set(__self__, "max_bitrate_bps", max_bitrate_bps)
        if max_height is not None:
            pulumi.set(__self__, "max_height", max_height)
        if max_layers is not None:
            pulumi.set(__self__, "max_layers", max_layers)
        if min_bitrate_bps is not None:
            pulumi.set(__self__, "min_bitrate_bps", min_bitrate_bps)
        if min_height is not None:
            pulumi.set(__self__, "min_height", min_height)

    @property
    @pulumi.getter
    def complexity(self) -> Optional[pulumi.Input[Union[str, 'Complexity']]]:
        """
        Allows you to configure the encoder settings to control the balance between speed and quality. Example: set Complexity as Speed for faster encoding but less compression efficiency.
        """
        return pulumi.get(self, "complexity")

    @complexity.setter
    def complexity(self, value: Optional[pulumi.Input[Union[str, 'Complexity']]]):
        pulumi.set(self, "complexity", value)

    @property
    @pulumi.getter(name="interleaveOutput")
    def interleave_output(self) -> Optional[pulumi.Input[Union[str, 'InterleaveOutput']]]:
        """
        Sets the interleave mode of the output to control how audio and video are stored in the container format. Example: set InterleavedOutput as NonInterleavedOutput to produce audio-only and video-only outputs in separate MP4 files.
        """
        return pulumi.get(self, "interleave_output")

    @interleave_output.setter
    def interleave_output(self, value: Optional[pulumi.Input[Union[str, 'InterleaveOutput']]]):
        pulumi.set(self, "interleave_output", value)

    @property
    @pulumi.getter(name="keyFrameIntervalInSeconds")
    def key_frame_interval_in_seconds(self) -> Optional[pulumi.Input[float]]:
        """
        The key frame interval in seconds. Example: set KeyFrameIntervalInSeconds as 2 to reduce the playback buffering for some players.
        """
        return pulumi.get(self, "key_frame_interval_in_seconds")

    @key_frame_interval_in_seconds.setter
    def key_frame_interval_in_seconds(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "key_frame_interval_in_seconds", value)

    @property
    @pulumi.getter(name="maxBitrateBps")
    def max_bitrate_bps(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum bitrate in bits per second (threshold for the top video layer). Example: set MaxBitrateBps as 6000000 to avoid producing very high bitrate outputs for contents with high complexity.
        """
        return pulumi.get(self, "max_bitrate_bps")

    @max_bitrate_bps.setter
    def max_bitrate_bps(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_bitrate_bps", value)

    @property
    @pulumi.getter(name="maxHeight")
    def max_height(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum height of output video layers. Example: set MaxHeight as 720 to produce output layers up to 720P even if the input is 4K.
        """
        return pulumi.get(self, "max_height")

    @max_height.setter
    def max_height(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_height", value)

    @property
    @pulumi.getter(name="maxLayers")
    def max_layers(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum number of output video layers. Example: set MaxLayers as 4 to make sure at most 4 output layers are produced to control the overall cost of the encoding job.
        """
        return pulumi.get(self, "max_layers")

    @max_layers.setter
    def max_layers(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_layers", value)

    @property
    @pulumi.getter(name="minBitrateBps")
    def min_bitrate_bps(self) -> Optional[pulumi.Input[int]]:
        """
        The minimum bitrate in bits per second (threshold for the bottom video layer). Example: set MinBitrateBps as 200000 to have a bottom layer that covers users with low network bandwidth.
        """
        return pulumi.get(self, "min_bitrate_bps")

    @min_bitrate_bps.setter
    def min_bitrate_bps(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_bitrate_bps", value)

    @property
    @pulumi.getter(name="minHeight")
    def min_height(self) -> Optional[pulumi.Input[int]]:
        """
        The minimum height of output video layers. Example: set MinHeight as 360 to avoid output layers of smaller resolutions like 180P.
        """
        return pulumi.get(self, "min_height")

    @min_height.setter
    def min_height(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_height", value)


@pulumi.input_type
class PrivateLinkServiceConnectionStateArgs:
    def __init__(__self__, *,
                 actions_required: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[Union[str, 'PrivateEndpointServiceConnectionStatus']]] = None):
        """
        A collection of information about the state of the connection between service consumer and provider.
        :param pulumi.Input[str] actions_required: A message indicating if changes on the service provider require any updates on the consumer.
        :param pulumi.Input[str] description: The reason for approval/rejection of the connection.
        :param pulumi.Input[Union[str, 'PrivateEndpointServiceConnectionStatus']] status: Indicates whether the connection has been Approved/Rejected/Removed by the owner of the service.
        """
        if actions_required is not None:
            pulumi.set(__self__, "actions_required", actions_required)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="actionsRequired")
    def actions_required(self) -> Optional[pulumi.Input[str]]:
        """
        A message indicating if changes on the service provider require any updates on the consumer.
        """
        return pulumi.get(self, "actions_required")

    @actions_required.setter
    def actions_required(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "actions_required", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The reason for approval/rejection of the connection.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[Union[str, 'PrivateEndpointServiceConnectionStatus']]]:
        """
        Indicates whether the connection has been Approved/Rejected/Removed by the owner of the service.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[Union[str, 'PrivateEndpointServiceConnectionStatus']]]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class RectangleArgs:
    def __init__(__self__, *,
                 height: Optional[pulumi.Input[str]] = None,
                 left: Optional[pulumi.Input[str]] = None,
                 top: Optional[pulumi.Input[str]] = None,
                 width: Optional[pulumi.Input[str]] = None):
        """
        Describes the properties of a rectangular window applied to the input media before processing it.
        :param pulumi.Input[str] height: The height of the rectangular region in pixels. This can be absolute pixel value (e.g 100), or relative to the size of the video (For example, 50%).
        :param pulumi.Input[str] left: The number of pixels from the left-margin. This can be absolute pixel value (e.g 100), or relative to the size of the video (For example, 50%).
        :param pulumi.Input[str] top: The number of pixels from the top-margin. This can be absolute pixel value (e.g 100), or relative to the size of the video (For example, 50%).
        :param pulumi.Input[str] width: The width of the rectangular region in pixels. This can be absolute pixel value (e.g 100), or relative to the size of the video (For example, 50%).
        """
        if height is not None:
            pulumi.set(__self__, "height", height)
        if left is not None:
            pulumi.set(__self__, "left", left)
        if top is not None:
            pulumi.set(__self__, "top", top)
        if width is not None:
            pulumi.set(__self__, "width", width)

    @property
    @pulumi.getter
    def height(self) -> Optional[pulumi.Input[str]]:
        """
        The height of the rectangular region in pixels. This can be absolute pixel value (e.g 100), or relative to the size of the video (For example, 50%).
        """
        return pulumi.get(self, "height")

    @height.setter
    def height(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "height", value)

    @property
    @pulumi.getter
    def left(self) -> Optional[pulumi.Input[str]]:
        """
        The number of pixels from the left-margin. This can be absolute pixel value (e.g 100), or relative to the size of the video (For example, 50%).
        """
        return pulumi.get(self, "left")

    @left.setter
    def left(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "left", value)

    @property
    @pulumi.getter
    def top(self) -> Optional[pulumi.Input[str]]:
        """
        The number of pixels from the top-margin. This can be absolute pixel value (e.g 100), or relative to the size of the video (For example, 50%).
        """
        return pulumi.get(self, "top")

    @top.setter
    def top(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "top", value)

    @property
    @pulumi.getter
    def width(self) -> Optional[pulumi.Input[str]]:
        """
        The width of the rectangular region in pixels. This can be absolute pixel value (e.g 100), or relative to the size of the video (For example, 50%).
        """
        return pulumi.get(self, "width")

    @width.setter
    def width(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "width", value)


@pulumi.input_type
class ResourceIdentityArgs:
    def __init__(__self__, *,
                 use_system_assigned_identity: pulumi.Input[bool],
                 user_assigned_identity: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[bool] use_system_assigned_identity: Indicates whether to use System Assigned Managed Identity. Mutual exclusive with User Assigned Managed Identity.
        :param pulumi.Input[str] user_assigned_identity: The user assigned managed identity's ARM ID to use when accessing a resource.
        """
        pulumi.set(__self__, "use_system_assigned_identity", use_system_assigned_identity)
        if user_assigned_identity is not None:
            pulumi.set(__self__, "user_assigned_identity", user_assigned_identity)

    @property
    @pulumi.getter(name="useSystemAssignedIdentity")
    def use_system_assigned_identity(self) -> pulumi.Input[bool]:
        """
        Indicates whether to use System Assigned Managed Identity. Mutual exclusive with User Assigned Managed Identity.
        """
        return pulumi.get(self, "use_system_assigned_identity")

    @use_system_assigned_identity.setter
    def use_system_assigned_identity(self, value: pulumi.Input[bool]):
        pulumi.set(self, "use_system_assigned_identity", value)

    @property
    @pulumi.getter(name="userAssignedIdentity")
    def user_assigned_identity(self) -> Optional[pulumi.Input[str]]:
        """
        The user assigned managed identity's ARM ID to use when accessing a resource.
        """
        return pulumi.get(self, "user_assigned_identity")

    @user_assigned_identity.setter
    def user_assigned_identity(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_assigned_identity", value)


@pulumi.input_type
class SelectAudioTrackByAttributeArgs:
    def __init__(__self__, *,
                 attribute: pulumi.Input[Union[str, 'TrackAttribute']],
                 filter: pulumi.Input[Union[str, 'AttributeFilter']],
                 odata_type: pulumi.Input[str],
                 channel_mapping: Optional[pulumi.Input[Union[str, 'ChannelMapping']]] = None,
                 filter_value: Optional[pulumi.Input[str]] = None):
        """
        Select audio tracks from the input by specifying an attribute and an attribute filter.
        :param pulumi.Input[Union[str, 'TrackAttribute']] attribute: The TrackAttribute to filter the tracks by.
        :param pulumi.Input[Union[str, 'AttributeFilter']] filter: The type of AttributeFilter to apply to the TrackAttribute in order to select the tracks.
        :param pulumi.Input[str] odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.SelectAudioTrackByAttribute'.
        :param pulumi.Input[Union[str, 'ChannelMapping']] channel_mapping: Optional designation for single channel audio tracks.  Can be used to combine the tracks into stereo or multi-channel audio tracks.
        :param pulumi.Input[str] filter_value: The value to filter the tracks by.  Only used when AttributeFilter.ValueEquals is specified for the Filter property.
        """
        pulumi.set(__self__, "attribute", attribute)
        pulumi.set(__self__, "filter", filter)
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.SelectAudioTrackByAttribute')
        if channel_mapping is not None:
            pulumi.set(__self__, "channel_mapping", channel_mapping)
        if filter_value is not None:
            pulumi.set(__self__, "filter_value", filter_value)

    @property
    @pulumi.getter
    def attribute(self) -> pulumi.Input[Union[str, 'TrackAttribute']]:
        """
        The TrackAttribute to filter the tracks by.
        """
        return pulumi.get(self, "attribute")

    @attribute.setter
    def attribute(self, value: pulumi.Input[Union[str, 'TrackAttribute']]):
        pulumi.set(self, "attribute", value)

    @property
    @pulumi.getter
    def filter(self) -> pulumi.Input[Union[str, 'AttributeFilter']]:
        """
        The type of AttributeFilter to apply to the TrackAttribute in order to select the tracks.
        """
        return pulumi.get(self, "filter")

    @filter.setter
    def filter(self, value: pulumi.Input[Union[str, 'AttributeFilter']]):
        pulumi.set(self, "filter", value)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> pulumi.Input[str]:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.SelectAudioTrackByAttribute'.
        """
        return pulumi.get(self, "odata_type")

    @odata_type.setter
    def odata_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "odata_type", value)

    @property
    @pulumi.getter(name="channelMapping")
    def channel_mapping(self) -> Optional[pulumi.Input[Union[str, 'ChannelMapping']]]:
        """
        Optional designation for single channel audio tracks.  Can be used to combine the tracks into stereo or multi-channel audio tracks.
        """
        return pulumi.get(self, "channel_mapping")

    @channel_mapping.setter
    def channel_mapping(self, value: Optional[pulumi.Input[Union[str, 'ChannelMapping']]]):
        pulumi.set(self, "channel_mapping", value)

    @property
    @pulumi.getter(name="filterValue")
    def filter_value(self) -> Optional[pulumi.Input[str]]:
        """
        The value to filter the tracks by.  Only used when AttributeFilter.ValueEquals is specified for the Filter property.
        """
        return pulumi.get(self, "filter_value")

    @filter_value.setter
    def filter_value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "filter_value", value)


@pulumi.input_type
class SelectAudioTrackByIdArgs:
    def __init__(__self__, *,
                 odata_type: pulumi.Input[str],
                 track_id: pulumi.Input[float],
                 channel_mapping: Optional[pulumi.Input[Union[str, 'ChannelMapping']]] = None):
        """
        Select audio tracks from the input by specifying a track identifier.
        :param pulumi.Input[str] odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.SelectAudioTrackById'.
        :param pulumi.Input[float] track_id: Track identifier to select
        :param pulumi.Input[Union[str, 'ChannelMapping']] channel_mapping: Optional designation for single channel audio tracks.  Can be used to combine the tracks into stereo or multi-channel audio tracks.
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.SelectAudioTrackById')
        pulumi.set(__self__, "track_id", track_id)
        if channel_mapping is not None:
            pulumi.set(__self__, "channel_mapping", channel_mapping)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> pulumi.Input[str]:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.SelectAudioTrackById'.
        """
        return pulumi.get(self, "odata_type")

    @odata_type.setter
    def odata_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "odata_type", value)

    @property
    @pulumi.getter(name="trackId")
    def track_id(self) -> pulumi.Input[float]:
        """
        Track identifier to select
        """
        return pulumi.get(self, "track_id")

    @track_id.setter
    def track_id(self, value: pulumi.Input[float]):
        pulumi.set(self, "track_id", value)

    @property
    @pulumi.getter(name="channelMapping")
    def channel_mapping(self) -> Optional[pulumi.Input[Union[str, 'ChannelMapping']]]:
        """
        Optional designation for single channel audio tracks.  Can be used to combine the tracks into stereo or multi-channel audio tracks.
        """
        return pulumi.get(self, "channel_mapping")

    @channel_mapping.setter
    def channel_mapping(self, value: Optional[pulumi.Input[Union[str, 'ChannelMapping']]]):
        pulumi.set(self, "channel_mapping", value)


@pulumi.input_type
class SelectVideoTrackByAttributeArgs:
    def __init__(__self__, *,
                 attribute: pulumi.Input[Union[str, 'TrackAttribute']],
                 filter: pulumi.Input[Union[str, 'AttributeFilter']],
                 odata_type: pulumi.Input[str],
                 filter_value: Optional[pulumi.Input[str]] = None):
        """
        Select video tracks from the input by specifying an attribute and an attribute filter.
        :param pulumi.Input[Union[str, 'TrackAttribute']] attribute: The TrackAttribute to filter the tracks by.
        :param pulumi.Input[Union[str, 'AttributeFilter']] filter: The type of AttributeFilter to apply to the TrackAttribute in order to select the tracks.
        :param pulumi.Input[str] odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.SelectVideoTrackByAttribute'.
        :param pulumi.Input[str] filter_value: The value to filter the tracks by.  Only used when AttributeFilter.ValueEquals is specified for the Filter property. For TrackAttribute.Bitrate, this should be an integer value in bits per second (e.g: '1500000').  The TrackAttribute.Language is not supported for video tracks.
        """
        pulumi.set(__self__, "attribute", attribute)
        pulumi.set(__self__, "filter", filter)
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.SelectVideoTrackByAttribute')
        if filter_value is not None:
            pulumi.set(__self__, "filter_value", filter_value)

    @property
    @pulumi.getter
    def attribute(self) -> pulumi.Input[Union[str, 'TrackAttribute']]:
        """
        The TrackAttribute to filter the tracks by.
        """
        return pulumi.get(self, "attribute")

    @attribute.setter
    def attribute(self, value: pulumi.Input[Union[str, 'TrackAttribute']]):
        pulumi.set(self, "attribute", value)

    @property
    @pulumi.getter
    def filter(self) -> pulumi.Input[Union[str, 'AttributeFilter']]:
        """
        The type of AttributeFilter to apply to the TrackAttribute in order to select the tracks.
        """
        return pulumi.get(self, "filter")

    @filter.setter
    def filter(self, value: pulumi.Input[Union[str, 'AttributeFilter']]):
        pulumi.set(self, "filter", value)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> pulumi.Input[str]:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.SelectVideoTrackByAttribute'.
        """
        return pulumi.get(self, "odata_type")

    @odata_type.setter
    def odata_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "odata_type", value)

    @property
    @pulumi.getter(name="filterValue")
    def filter_value(self) -> Optional[pulumi.Input[str]]:
        """
        The value to filter the tracks by.  Only used when AttributeFilter.ValueEquals is specified for the Filter property. For TrackAttribute.Bitrate, this should be an integer value in bits per second (e.g: '1500000').  The TrackAttribute.Language is not supported for video tracks.
        """
        return pulumi.get(self, "filter_value")

    @filter_value.setter
    def filter_value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "filter_value", value)


@pulumi.input_type
class SelectVideoTrackByIdArgs:
    def __init__(__self__, *,
                 odata_type: pulumi.Input[str],
                 track_id: pulumi.Input[float]):
        """
        Select video tracks from the input by specifying a track identifier.
        :param pulumi.Input[str] odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.SelectVideoTrackById'.
        :param pulumi.Input[float] track_id: Track identifier to select
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.SelectVideoTrackById')
        pulumi.set(__self__, "track_id", track_id)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> pulumi.Input[str]:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.SelectVideoTrackById'.
        """
        return pulumi.get(self, "odata_type")

    @odata_type.setter
    def odata_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "odata_type", value)

    @property
    @pulumi.getter(name="trackId")
    def track_id(self) -> pulumi.Input[float]:
        """
        Track identifier to select
        """
        return pulumi.get(self, "track_id")

    @track_id.setter
    def track_id(self, value: pulumi.Input[float]):
        pulumi.set(self, "track_id", value)


@pulumi.input_type
class StandardEncoderPresetArgs:
    def __init__(__self__, *,
                 codecs: pulumi.Input[Sequence[pulumi.Input[Union['AacAudioArgs', 'AudioArgs', 'CopyAudioArgs', 'CopyVideoArgs', 'H264VideoArgs', 'H265VideoArgs', 'ImageArgs', 'JpgImageArgs', 'PngImageArgs', 'VideoArgs']]]],
                 formats: pulumi.Input[Sequence[pulumi.Input[Union['ImageFormatArgs', 'JpgFormatArgs', 'Mp4FormatArgs', 'MultiBitrateFormatArgs', 'PngFormatArgs', 'TransportStreamFormatArgs']]]],
                 odata_type: pulumi.Input[str],
                 filters: Optional[pulumi.Input['FiltersArgs']] = None):
        """
        Describes all the settings to be used when encoding the input video with the Standard Encoder.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AacAudioArgs', 'AudioArgs', 'CopyAudioArgs', 'CopyVideoArgs', 'H264VideoArgs', 'H265VideoArgs', 'ImageArgs', 'JpgImageArgs', 'PngImageArgs', 'VideoArgs']]]] codecs: The list of codecs to be used when encoding the input video.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ImageFormatArgs', 'JpgFormatArgs', 'Mp4FormatArgs', 'MultiBitrateFormatArgs', 'PngFormatArgs', 'TransportStreamFormatArgs']]]] formats: The list of outputs to be produced by the encoder.
        :param pulumi.Input[str] odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.StandardEncoderPreset'.
        :param pulumi.Input['FiltersArgs'] filters: One or more filtering operations that are applied to the input media before encoding.
        """
        pulumi.set(__self__, "codecs", codecs)
        pulumi.set(__self__, "formats", formats)
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.StandardEncoderPreset')
        if filters is not None:
            pulumi.set(__self__, "filters", filters)

    @property
    @pulumi.getter
    def codecs(self) -> pulumi.Input[Sequence[pulumi.Input[Union['AacAudioArgs', 'AudioArgs', 'CopyAudioArgs', 'CopyVideoArgs', 'H264VideoArgs', 'H265VideoArgs', 'ImageArgs', 'JpgImageArgs', 'PngImageArgs', 'VideoArgs']]]]:
        """
        The list of codecs to be used when encoding the input video.
        """
        return pulumi.get(self, "codecs")

    @codecs.setter
    def codecs(self, value: pulumi.Input[Sequence[pulumi.Input[Union['AacAudioArgs', 'AudioArgs', 'CopyAudioArgs', 'CopyVideoArgs', 'H264VideoArgs', 'H265VideoArgs', 'ImageArgs', 'JpgImageArgs', 'PngImageArgs', 'VideoArgs']]]]):
        pulumi.set(self, "codecs", value)

    @property
    @pulumi.getter
    def formats(self) -> pulumi.Input[Sequence[pulumi.Input[Union['ImageFormatArgs', 'JpgFormatArgs', 'Mp4FormatArgs', 'MultiBitrateFormatArgs', 'PngFormatArgs', 'TransportStreamFormatArgs']]]]:
        """
        The list of outputs to be produced by the encoder.
        """
        return pulumi.get(self, "formats")

    @formats.setter
    def formats(self, value: pulumi.Input[Sequence[pulumi.Input[Union['ImageFormatArgs', 'JpgFormatArgs', 'Mp4FormatArgs', 'MultiBitrateFormatArgs', 'PngFormatArgs', 'TransportStreamFormatArgs']]]]):
        pulumi.set(self, "formats", value)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> pulumi.Input[str]:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.StandardEncoderPreset'.
        """
        return pulumi.get(self, "odata_type")

    @odata_type.setter
    def odata_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "odata_type", value)

    @property
    @pulumi.getter
    def filters(self) -> Optional[pulumi.Input['FiltersArgs']]:
        """
        One or more filtering operations that are applied to the input media before encoding.
        """
        return pulumi.get(self, "filters")

    @filters.setter
    def filters(self, value: Optional[pulumi.Input['FiltersArgs']]):
        pulumi.set(self, "filters", value)


@pulumi.input_type
class StorageAccountArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[Union[str, 'StorageAccountType']],
                 id: Optional[pulumi.Input[str]] = None,
                 identity: Optional[pulumi.Input['ResourceIdentityArgs']] = None):
        """
        The storage account details.
        :param pulumi.Input[Union[str, 'StorageAccountType']] type: The type of the storage account.
        :param pulumi.Input[str] id: The ID of the storage account resource. Media Services relies on tables and queues as well as blobs, so the primary storage account must be a Standard Storage account (either Microsoft.ClassicStorage or Microsoft.Storage). Blob only storage accounts can be added as secondary storage accounts.
        :param pulumi.Input['ResourceIdentityArgs'] identity: The storage account identity.
        """
        pulumi.set(__self__, "type", type)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[Union[str, 'StorageAccountType']]:
        """
        The type of the storage account.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[Union[str, 'StorageAccountType']]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the storage account resource. Media Services relies on tables and queues as well as blobs, so the primary storage account must be a Standard Storage account (either Microsoft.ClassicStorage or Microsoft.Storage). Blob only storage accounts can be added as secondary storage accounts.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['ResourceIdentityArgs']]:
        """
        The storage account identity.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['ResourceIdentityArgs']]):
        pulumi.set(self, "identity", value)


@pulumi.input_type
class StreamingEndpointAccessControlArgs:
    def __init__(__self__, *,
                 akamai: Optional[pulumi.Input['AkamaiAccessControlArgs']] = None,
                 ip: Optional[pulumi.Input['IPAccessControlArgs']] = None):
        """
        Streaming endpoint access control definition.
        :param pulumi.Input['AkamaiAccessControlArgs'] akamai: The access control of Akamai
        :param pulumi.Input['IPAccessControlArgs'] ip: The IP access control of the streaming endpoint.
        """
        if akamai is not None:
            pulumi.set(__self__, "akamai", akamai)
        if ip is not None:
            pulumi.set(__self__, "ip", ip)

    @property
    @pulumi.getter
    def akamai(self) -> Optional[pulumi.Input['AkamaiAccessControlArgs']]:
        """
        The access control of Akamai
        """
        return pulumi.get(self, "akamai")

    @akamai.setter
    def akamai(self, value: Optional[pulumi.Input['AkamaiAccessControlArgs']]):
        pulumi.set(self, "akamai", value)

    @property
    @pulumi.getter
    def ip(self) -> Optional[pulumi.Input['IPAccessControlArgs']]:
        """
        The IP access control of the streaming endpoint.
        """
        return pulumi.get(self, "ip")

    @ip.setter
    def ip(self, value: Optional[pulumi.Input['IPAccessControlArgs']]):
        pulumi.set(self, "ip", value)


@pulumi.input_type
class StreamingLocatorContentKeyArgs:
    def __init__(__self__, *,
                 id: pulumi.Input[str],
                 label_reference_in_streaming_policy: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None):
        """
        Class for content key in Streaming Locator
        :param pulumi.Input[str] id: ID of Content Key
        :param pulumi.Input[str] label_reference_in_streaming_policy: Label of Content Key as specified in the Streaming Policy
        :param pulumi.Input[str] value: Value of Content Key
        """
        pulumi.set(__self__, "id", id)
        if label_reference_in_streaming_policy is not None:
            pulumi.set(__self__, "label_reference_in_streaming_policy", label_reference_in_streaming_policy)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def id(self) -> pulumi.Input[str]:
        """
        ID of Content Key
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: pulumi.Input[str]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="labelReferenceInStreamingPolicy")
    def label_reference_in_streaming_policy(self) -> Optional[pulumi.Input[str]]:
        """
        Label of Content Key as specified in the Streaming Policy
        """
        return pulumi.get(self, "label_reference_in_streaming_policy")

    @label_reference_in_streaming_policy.setter
    def label_reference_in_streaming_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "label_reference_in_streaming_policy", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        Value of Content Key
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class StreamingPolicyContentKeysArgs:
    def __init__(__self__, *,
                 default_key: Optional[pulumi.Input['DefaultKeyArgs']] = None,
                 key_to_track_mappings: Optional[pulumi.Input[Sequence[pulumi.Input['StreamingPolicyContentKeyArgs']]]] = None):
        """
        Class to specify properties of all content keys in Streaming Policy
        :param pulumi.Input['DefaultKeyArgs'] default_key: Default content key for an encryption scheme
        :param pulumi.Input[Sequence[pulumi.Input['StreamingPolicyContentKeyArgs']]] key_to_track_mappings: Representing tracks needs separate content key
        """
        if default_key is not None:
            pulumi.set(__self__, "default_key", default_key)
        if key_to_track_mappings is not None:
            pulumi.set(__self__, "key_to_track_mappings", key_to_track_mappings)

    @property
    @pulumi.getter(name="defaultKey")
    def default_key(self) -> Optional[pulumi.Input['DefaultKeyArgs']]:
        """
        Default content key for an encryption scheme
        """
        return pulumi.get(self, "default_key")

    @default_key.setter
    def default_key(self, value: Optional[pulumi.Input['DefaultKeyArgs']]):
        pulumi.set(self, "default_key", value)

    @property
    @pulumi.getter(name="keyToTrackMappings")
    def key_to_track_mappings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['StreamingPolicyContentKeyArgs']]]]:
        """
        Representing tracks needs separate content key
        """
        return pulumi.get(self, "key_to_track_mappings")

    @key_to_track_mappings.setter
    def key_to_track_mappings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['StreamingPolicyContentKeyArgs']]]]):
        pulumi.set(self, "key_to_track_mappings", value)


@pulumi.input_type
class StreamingPolicyContentKeyArgs:
    def __init__(__self__, *,
                 label: Optional[pulumi.Input[str]] = None,
                 policy_name: Optional[pulumi.Input[str]] = None,
                 tracks: Optional[pulumi.Input[Sequence[pulumi.Input['TrackSelectionArgs']]]] = None):
        """
        Class to specify properties of content key
        :param pulumi.Input[str] label: Label can be used to specify Content Key when creating a Streaming Locator
        :param pulumi.Input[str] policy_name: Policy used by Content Key
        :param pulumi.Input[Sequence[pulumi.Input['TrackSelectionArgs']]] tracks: Tracks which use this content key
        """
        if label is not None:
            pulumi.set(__self__, "label", label)
        if policy_name is not None:
            pulumi.set(__self__, "policy_name", policy_name)
        if tracks is not None:
            pulumi.set(__self__, "tracks", tracks)

    @property
    @pulumi.getter
    def label(self) -> Optional[pulumi.Input[str]]:
        """
        Label can be used to specify Content Key when creating a Streaming Locator
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "label", value)

    @property
    @pulumi.getter(name="policyName")
    def policy_name(self) -> Optional[pulumi.Input[str]]:
        """
        Policy used by Content Key
        """
        return pulumi.get(self, "policy_name")

    @policy_name.setter
    def policy_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "policy_name", value)

    @property
    @pulumi.getter
    def tracks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TrackSelectionArgs']]]]:
        """
        Tracks which use this content key
        """
        return pulumi.get(self, "tracks")

    @tracks.setter
    def tracks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TrackSelectionArgs']]]]):
        pulumi.set(self, "tracks", value)


@pulumi.input_type
class StreamingPolicyFairPlayConfigurationArgs:
    def __init__(__self__, *,
                 allow_persistent_license: pulumi.Input[bool],
                 custom_license_acquisition_url_template: Optional[pulumi.Input[str]] = None):
        """
        Class to specify configurations of FairPlay in Streaming Policy
        :param pulumi.Input[bool] allow_persistent_license: All license to be persistent or not
        :param pulumi.Input[str] custom_license_acquisition_url_template: Template for the URL of the custom service delivering licenses to end user players.  Not required when using Azure Media Services for issuing licenses.  The template supports replaceable tokens that the service will update at runtime with the value specific to the request.  The currently supported token values are {AlternativeMediaId}, which is replaced with the value of StreamingLocatorId.AlternativeMediaId, and {ContentKeyId}, which is replaced with the value of identifier of the key being requested.
        """
        pulumi.set(__self__, "allow_persistent_license", allow_persistent_license)
        if custom_license_acquisition_url_template is not None:
            pulumi.set(__self__, "custom_license_acquisition_url_template", custom_license_acquisition_url_template)

    @property
    @pulumi.getter(name="allowPersistentLicense")
    def allow_persistent_license(self) -> pulumi.Input[bool]:
        """
        All license to be persistent or not
        """
        return pulumi.get(self, "allow_persistent_license")

    @allow_persistent_license.setter
    def allow_persistent_license(self, value: pulumi.Input[bool]):
        pulumi.set(self, "allow_persistent_license", value)

    @property
    @pulumi.getter(name="customLicenseAcquisitionUrlTemplate")
    def custom_license_acquisition_url_template(self) -> Optional[pulumi.Input[str]]:
        """
        Template for the URL of the custom service delivering licenses to end user players.  Not required when using Azure Media Services for issuing licenses.  The template supports replaceable tokens that the service will update at runtime with the value specific to the request.  The currently supported token values are {AlternativeMediaId}, which is replaced with the value of StreamingLocatorId.AlternativeMediaId, and {ContentKeyId}, which is replaced with the value of identifier of the key being requested.
        """
        return pulumi.get(self, "custom_license_acquisition_url_template")

    @custom_license_acquisition_url_template.setter
    def custom_license_acquisition_url_template(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "custom_license_acquisition_url_template", value)


@pulumi.input_type
class StreamingPolicyPlayReadyConfigurationArgs:
    def __init__(__self__, *,
                 custom_license_acquisition_url_template: Optional[pulumi.Input[str]] = None,
                 play_ready_custom_attributes: Optional[pulumi.Input[str]] = None):
        """
        Class to specify configurations of PlayReady in Streaming Policy
        :param pulumi.Input[str] custom_license_acquisition_url_template: Template for the URL of the custom service delivering licenses to end user players.  Not required when using Azure Media Services for issuing licenses.  The template supports replaceable tokens that the service will update at runtime with the value specific to the request.  The currently supported token values are {AlternativeMediaId}, which is replaced with the value of StreamingLocatorId.AlternativeMediaId, and {ContentKeyId}, which is replaced with the value of identifier of the key being requested.
        :param pulumi.Input[str] play_ready_custom_attributes: Custom attributes for PlayReady
        """
        if custom_license_acquisition_url_template is not None:
            pulumi.set(__self__, "custom_license_acquisition_url_template", custom_license_acquisition_url_template)
        if play_ready_custom_attributes is not None:
            pulumi.set(__self__, "play_ready_custom_attributes", play_ready_custom_attributes)

    @property
    @pulumi.getter(name="customLicenseAcquisitionUrlTemplate")
    def custom_license_acquisition_url_template(self) -> Optional[pulumi.Input[str]]:
        """
        Template for the URL of the custom service delivering licenses to end user players.  Not required when using Azure Media Services for issuing licenses.  The template supports replaceable tokens that the service will update at runtime with the value specific to the request.  The currently supported token values are {AlternativeMediaId}, which is replaced with the value of StreamingLocatorId.AlternativeMediaId, and {ContentKeyId}, which is replaced with the value of identifier of the key being requested.
        """
        return pulumi.get(self, "custom_license_acquisition_url_template")

    @custom_license_acquisition_url_template.setter
    def custom_license_acquisition_url_template(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "custom_license_acquisition_url_template", value)

    @property
    @pulumi.getter(name="playReadyCustomAttributes")
    def play_ready_custom_attributes(self) -> Optional[pulumi.Input[str]]:
        """
        Custom attributes for PlayReady
        """
        return pulumi.get(self, "play_ready_custom_attributes")

    @play_ready_custom_attributes.setter
    def play_ready_custom_attributes(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "play_ready_custom_attributes", value)


@pulumi.input_type
class StreamingPolicyWidevineConfigurationArgs:
    def __init__(__self__, *,
                 custom_license_acquisition_url_template: Optional[pulumi.Input[str]] = None):
        """
        Class to specify configurations of Widevine in Streaming Policy
        :param pulumi.Input[str] custom_license_acquisition_url_template: Template for the URL of the custom service delivering licenses to end user players.  Not required when using Azure Media Services for issuing licenses.  The template supports replaceable tokens that the service will update at runtime with the value specific to the request.  The currently supported token values are {AlternativeMediaId}, which is replaced with the value of StreamingLocatorId.AlternativeMediaId, and {ContentKeyId}, which is replaced with the value of identifier of the key being requested.
        """
        if custom_license_acquisition_url_template is not None:
            pulumi.set(__self__, "custom_license_acquisition_url_template", custom_license_acquisition_url_template)

    @property
    @pulumi.getter(name="customLicenseAcquisitionUrlTemplate")
    def custom_license_acquisition_url_template(self) -> Optional[pulumi.Input[str]]:
        """
        Template for the URL of the custom service delivering licenses to end user players.  Not required when using Azure Media Services for issuing licenses.  The template supports replaceable tokens that the service will update at runtime with the value specific to the request.  The currently supported token values are {AlternativeMediaId}, which is replaced with the value of StreamingLocatorId.AlternativeMediaId, and {ContentKeyId}, which is replaced with the value of identifier of the key being requested.
        """
        return pulumi.get(self, "custom_license_acquisition_url_template")

    @custom_license_acquisition_url_template.setter
    def custom_license_acquisition_url_template(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "custom_license_acquisition_url_template", value)


@pulumi.input_type
class TextTrackArgs:
    def __init__(__self__, *,
                 odata_type: pulumi.Input[str],
                 display_name: Optional[pulumi.Input[str]] = None,
                 file_name: Optional[pulumi.Input[str]] = None,
                 hls_settings: Optional[pulumi.Input['HlsSettingsArgs']] = None,
                 player_visibility: Optional[pulumi.Input[Union[str, 'Visibility']]] = None):
        """
        Represents a text track in an asset. A text track is usually used for sparse data related to the audio or video tracks.
        :param pulumi.Input[str] odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.TextTrack'.
        :param pulumi.Input[str] display_name: The display name of the text track on a video player. In HLS, this maps to the NAME attribute of EXT-X-MEDIA.
        :param pulumi.Input[str] file_name: The file name to the source file. This file is located in the storage container of the asset.
        :param pulumi.Input['HlsSettingsArgs'] hls_settings: The HLS specific setting for the text track.
        :param pulumi.Input[Union[str, 'Visibility']] player_visibility: When PlayerVisibility is set to "Visible", the text track will be present in the DASH manifest or HLS playlist when requested by a client. When the PlayerVisibility is set to "Hidden", the text will not be available to the client. The default value is "Visible".
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.TextTrack')
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if file_name is not None:
            pulumi.set(__self__, "file_name", file_name)
        if hls_settings is not None:
            pulumi.set(__self__, "hls_settings", hls_settings)
        if player_visibility is not None:
            pulumi.set(__self__, "player_visibility", player_visibility)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> pulumi.Input[str]:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.TextTrack'.
        """
        return pulumi.get(self, "odata_type")

    @odata_type.setter
    def odata_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "odata_type", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        The display name of the text track on a video player. In HLS, this maps to the NAME attribute of EXT-X-MEDIA.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="fileName")
    def file_name(self) -> Optional[pulumi.Input[str]]:
        """
        The file name to the source file. This file is located in the storage container of the asset.
        """
        return pulumi.get(self, "file_name")

    @file_name.setter
    def file_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "file_name", value)

    @property
    @pulumi.getter(name="hlsSettings")
    def hls_settings(self) -> Optional[pulumi.Input['HlsSettingsArgs']]:
        """
        The HLS specific setting for the text track.
        """
        return pulumi.get(self, "hls_settings")

    @hls_settings.setter
    def hls_settings(self, value: Optional[pulumi.Input['HlsSettingsArgs']]):
        pulumi.set(self, "hls_settings", value)

    @property
    @pulumi.getter(name="playerVisibility")
    def player_visibility(self) -> Optional[pulumi.Input[Union[str, 'Visibility']]]:
        """
        When PlayerVisibility is set to "Visible", the text track will be present in the DASH manifest or HLS playlist when requested by a client. When the PlayerVisibility is set to "Hidden", the text will not be available to the client. The default value is "Visible".
        """
        return pulumi.get(self, "player_visibility")

    @player_visibility.setter
    def player_visibility(self, value: Optional[pulumi.Input[Union[str, 'Visibility']]]):
        pulumi.set(self, "player_visibility", value)


@pulumi.input_type
class TrackPropertyConditionArgs:
    def __init__(__self__, *,
                 operation: pulumi.Input[Union[str, 'TrackPropertyCompareOperation']],
                 property: pulumi.Input[Union[str, 'TrackPropertyType']],
                 value: Optional[pulumi.Input[str]] = None):
        """
        Class to specify one track property condition
        :param pulumi.Input[Union[str, 'TrackPropertyCompareOperation']] operation: Track property condition operation
        :param pulumi.Input[Union[str, 'TrackPropertyType']] property: Track property type
        :param pulumi.Input[str] value: Track property value
        """
        pulumi.set(__self__, "operation", operation)
        pulumi.set(__self__, "property", property)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def operation(self) -> pulumi.Input[Union[str, 'TrackPropertyCompareOperation']]:
        """
        Track property condition operation
        """
        return pulumi.get(self, "operation")

    @operation.setter
    def operation(self, value: pulumi.Input[Union[str, 'TrackPropertyCompareOperation']]):
        pulumi.set(self, "operation", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        Track property value
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)

    @property
    @pulumi.getter
    def property(self) -> pulumi.Input[Union[str, 'TrackPropertyType']]:
        """
        Track property type
        """
        return pulumi.get(self, "property")

    @property.setter
    def property(self, value: pulumi.Input[Union[str, 'TrackPropertyType']]):
        pulumi.set(self, "property", value)


@pulumi.input_type
class TrackSelectionArgs:
    def __init__(__self__, *,
                 track_selections: Optional[pulumi.Input[Sequence[pulumi.Input['TrackPropertyConditionArgs']]]] = None):
        """
        Class to select a track
        :param pulumi.Input[Sequence[pulumi.Input['TrackPropertyConditionArgs']]] track_selections: TrackSelections is a track property condition list which can specify track(s)
        """
        if track_selections is not None:
            pulumi.set(__self__, "track_selections", track_selections)

    @property
    @pulumi.getter(name="trackSelections")
    def track_selections(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TrackPropertyConditionArgs']]]]:
        """
        TrackSelections is a track property condition list which can specify track(s)
        """
        return pulumi.get(self, "track_selections")

    @track_selections.setter
    def track_selections(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TrackPropertyConditionArgs']]]]):
        pulumi.set(self, "track_selections", value)


@pulumi.input_type
class TransformOutputArgs:
    def __init__(__self__, *,
                 preset: pulumi.Input[Union['AudioAnalyzerPresetArgs', 'BuiltInStandardEncoderPresetArgs', 'FaceDetectorPresetArgs', 'StandardEncoderPresetArgs', 'VideoAnalyzerPresetArgs']],
                 on_error: Optional[pulumi.Input[Union[str, 'OnErrorType']]] = None,
                 relative_priority: Optional[pulumi.Input[Union[str, 'Priority']]] = None):
        """
        Describes the properties of a TransformOutput, which are the rules to be applied while generating the desired output.
        :param pulumi.Input[Union['AudioAnalyzerPresetArgs', 'BuiltInStandardEncoderPresetArgs', 'FaceDetectorPresetArgs', 'StandardEncoderPresetArgs', 'VideoAnalyzerPresetArgs']] preset: Preset that describes the operations that will be used to modify, transcode, or extract insights from the source file to generate the output.
        :param pulumi.Input[Union[str, 'OnErrorType']] on_error: A Transform can define more than one outputs. This property defines what the service should do when one output fails - either continue to produce other outputs, or, stop the other outputs. The overall Job state will not reflect failures of outputs that are specified with 'ContinueJob'. The default is 'StopProcessingJob'.
        :param pulumi.Input[Union[str, 'Priority']] relative_priority: Sets the relative priority of the TransformOutputs within a Transform. This sets the priority that the service uses for processing TransformOutputs. The default priority is Normal.
        """
        pulumi.set(__self__, "preset", preset)
        if on_error is not None:
            pulumi.set(__self__, "on_error", on_error)
        if relative_priority is not None:
            pulumi.set(__self__, "relative_priority", relative_priority)

    @property
    @pulumi.getter
    def preset(self) -> pulumi.Input[Union['AudioAnalyzerPresetArgs', 'BuiltInStandardEncoderPresetArgs', 'FaceDetectorPresetArgs', 'StandardEncoderPresetArgs', 'VideoAnalyzerPresetArgs']]:
        """
        Preset that describes the operations that will be used to modify, transcode, or extract insights from the source file to generate the output.
        """
        return pulumi.get(self, "preset")

    @preset.setter
    def preset(self, value: pulumi.Input[Union['AudioAnalyzerPresetArgs', 'BuiltInStandardEncoderPresetArgs', 'FaceDetectorPresetArgs', 'StandardEncoderPresetArgs', 'VideoAnalyzerPresetArgs']]):
        pulumi.set(self, "preset", value)

    @property
    @pulumi.getter(name="onError")
    def on_error(self) -> Optional[pulumi.Input[Union[str, 'OnErrorType']]]:
        """
        A Transform can define more than one outputs. This property defines what the service should do when one output fails - either continue to produce other outputs, or, stop the other outputs. The overall Job state will not reflect failures of outputs that are specified with 'ContinueJob'. The default is 'StopProcessingJob'.
        """
        return pulumi.get(self, "on_error")

    @on_error.setter
    def on_error(self, value: Optional[pulumi.Input[Union[str, 'OnErrorType']]]):
        pulumi.set(self, "on_error", value)

    @property
    @pulumi.getter(name="relativePriority")
    def relative_priority(self) -> Optional[pulumi.Input[Union[str, 'Priority']]]:
        """
        Sets the relative priority of the TransformOutputs within a Transform. This sets the priority that the service uses for processing TransformOutputs. The default priority is Normal.
        """
        return pulumi.get(self, "relative_priority")

    @relative_priority.setter
    def relative_priority(self, value: Optional[pulumi.Input[Union[str, 'Priority']]]):
        pulumi.set(self, "relative_priority", value)


@pulumi.input_type
class TransportStreamFormatArgs:
    def __init__(__self__, *,
                 filename_pattern: pulumi.Input[str],
                 odata_type: pulumi.Input[str],
                 output_files: Optional[pulumi.Input[Sequence[pulumi.Input['OutputFileArgs']]]] = None):
        """
        Describes the properties for generating an MPEG-2 Transport Stream (ISO/IEC 13818-1) output video file(s).
        :param pulumi.Input[str] filename_pattern: The pattern of the file names for the generated output files. The following macros are supported in the file name: {Basename} - An expansion macro that will use the name of the input video file. If the base name(the file suffix is not included) of the input video file is less than 32 characters long, the base name of input video files will be used. If the length of base name of the input video file exceeds 32 characters, the base name is truncated to the first 32 characters in total length. {Extension} - The appropriate extension for this format. {Label} - The label assigned to the codec/layer. {Index} - A unique index for thumbnails. Only applicable to thumbnails. {Bitrate} - The audio/video bitrate. Not applicable to thumbnails. {Codec} - The type of the audio/video codec. {Resolution} - The video resolution. Any unsubstituted macros will be collapsed and removed from the filename.
        :param pulumi.Input[str] odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.TransportStreamFormat'.
        :param pulumi.Input[Sequence[pulumi.Input['OutputFileArgs']]] output_files: The list of output files to produce.  Each entry in the list is a set of audio and video layer labels to be muxed together .
        """
        pulumi.set(__self__, "filename_pattern", filename_pattern)
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.TransportStreamFormat')
        if output_files is not None:
            pulumi.set(__self__, "output_files", output_files)

    @property
    @pulumi.getter(name="filenamePattern")
    def filename_pattern(self) -> pulumi.Input[str]:
        """
        The pattern of the file names for the generated output files. The following macros are supported in the file name: {Basename} - An expansion macro that will use the name of the input video file. If the base name(the file suffix is not included) of the input video file is less than 32 characters long, the base name of input video files will be used. If the length of base name of the input video file exceeds 32 characters, the base name is truncated to the first 32 characters in total length. {Extension} - The appropriate extension for this format. {Label} - The label assigned to the codec/layer. {Index} - A unique index for thumbnails. Only applicable to thumbnails. {Bitrate} - The audio/video bitrate. Not applicable to thumbnails. {Codec} - The type of the audio/video codec. {Resolution} - The video resolution. Any unsubstituted macros will be collapsed and removed from the filename.
        """
        return pulumi.get(self, "filename_pattern")

    @filename_pattern.setter
    def filename_pattern(self, value: pulumi.Input[str]):
        pulumi.set(self, "filename_pattern", value)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> pulumi.Input[str]:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.TransportStreamFormat'.
        """
        return pulumi.get(self, "odata_type")

    @odata_type.setter
    def odata_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "odata_type", value)

    @property
    @pulumi.getter(name="outputFiles")
    def output_files(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OutputFileArgs']]]]:
        """
        The list of output files to produce.  Each entry in the list is a set of audio and video layer labels to be muxed together .
        """
        return pulumi.get(self, "output_files")

    @output_files.setter
    def output_files(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OutputFileArgs']]]]):
        pulumi.set(self, "output_files", value)


@pulumi.input_type
class UtcClipTimeArgs:
    def __init__(__self__, *,
                 odata_type: pulumi.Input[str],
                 time: pulumi.Input[str]):
        """
        Specifies the clip time as a Utc time position in the media file.  The Utc time can point to a different position depending on whether the media file starts from a timestamp of zero or not.
        :param pulumi.Input[str] odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.UtcClipTime'.
        :param pulumi.Input[str] time: The time position on the timeline of the input media based on Utc time.
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.UtcClipTime')
        pulumi.set(__self__, "time", time)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> pulumi.Input[str]:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.UtcClipTime'.
        """
        return pulumi.get(self, "odata_type")

    @odata_type.setter
    def odata_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "odata_type", value)

    @property
    @pulumi.getter
    def time(self) -> pulumi.Input[str]:
        """
        The time position on the timeline of the input media based on Utc time.
        """
        return pulumi.get(self, "time")

    @time.setter
    def time(self, value: pulumi.Input[str]):
        pulumi.set(self, "time", value)


@pulumi.input_type
class VideoAnalyzerPresetArgs:
    def __init__(__self__, *,
                 odata_type: pulumi.Input[str],
                 audio_language: Optional[pulumi.Input[str]] = None,
                 experimental_options: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 insights_to_extract: Optional[pulumi.Input[Union[str, 'InsightsType']]] = None,
                 mode: Optional[pulumi.Input[Union[str, 'AudioAnalysisMode']]] = None):
        """
        A video analyzer preset that extracts insights (rich metadata) from both audio and video, and outputs a JSON format file.
        :param pulumi.Input[str] odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.VideoAnalyzerPreset'.
        :param pulumi.Input[str] audio_language: The language for the audio payload in the input using the BCP-47 format of 'language tag-region' (e.g: 'en-US').  If you know the language of your content, it is recommended that you specify it. The language must be specified explicitly for AudioAnalysisMode::Basic, since automatic language detection is not included in basic mode. If the language isn't specified or set to null, automatic language detection will choose the first language detected and process with the selected language for the duration of the file. It does not currently support dynamically switching between languages after the first language is detected. The automatic detection works best with audio recordings with clearly discernable speech. If automatic detection fails to find the language, transcription would fallback to 'en-US'." The list of supported languages is available here: https://go.microsoft.com/fwlink/?linkid=2109463
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] experimental_options: Dictionary containing key value pairs for parameters not exposed in the preset itself
        :param pulumi.Input[Union[str, 'InsightsType']] insights_to_extract: Defines the type of insights that you want the service to generate. The allowed values are 'AudioInsightsOnly', 'VideoInsightsOnly', and 'AllInsights'. The default is AllInsights. If you set this to AllInsights and the input is audio only, then only audio insights are generated. Similarly if the input is video only, then only video insights are generated. It is recommended that you not use AudioInsightsOnly if you expect some of your inputs to be video only; or use VideoInsightsOnly if you expect some of your inputs to be audio only. Your Jobs in such conditions would error out.
        :param pulumi.Input[Union[str, 'AudioAnalysisMode']] mode: Determines the set of audio analysis operations to be performed. If unspecified, the Standard AudioAnalysisMode would be chosen.
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.VideoAnalyzerPreset')
        if audio_language is not None:
            pulumi.set(__self__, "audio_language", audio_language)
        if experimental_options is not None:
            pulumi.set(__self__, "experimental_options", experimental_options)
        if insights_to_extract is not None:
            pulumi.set(__self__, "insights_to_extract", insights_to_extract)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> pulumi.Input[str]:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.VideoAnalyzerPreset'.
        """
        return pulumi.get(self, "odata_type")

    @odata_type.setter
    def odata_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "odata_type", value)

    @property
    @pulumi.getter(name="audioLanguage")
    def audio_language(self) -> Optional[pulumi.Input[str]]:
        """
        The language for the audio payload in the input using the BCP-47 format of 'language tag-region' (e.g: 'en-US').  If you know the language of your content, it is recommended that you specify it. The language must be specified explicitly for AudioAnalysisMode::Basic, since automatic language detection is not included in basic mode. If the language isn't specified or set to null, automatic language detection will choose the first language detected and process with the selected language for the duration of the file. It does not currently support dynamically switching between languages after the first language is detected. The automatic detection works best with audio recordings with clearly discernable speech. If automatic detection fails to find the language, transcription would fallback to 'en-US'." The list of supported languages is available here: https://go.microsoft.com/fwlink/?linkid=2109463
        """
        return pulumi.get(self, "audio_language")

    @audio_language.setter
    def audio_language(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "audio_language", value)

    @property
    @pulumi.getter(name="experimentalOptions")
    def experimental_options(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Dictionary containing key value pairs for parameters not exposed in the preset itself
        """
        return pulumi.get(self, "experimental_options")

    @experimental_options.setter
    def experimental_options(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "experimental_options", value)

    @property
    @pulumi.getter(name="insightsToExtract")
    def insights_to_extract(self) -> Optional[pulumi.Input[Union[str, 'InsightsType']]]:
        """
        Defines the type of insights that you want the service to generate. The allowed values are 'AudioInsightsOnly', 'VideoInsightsOnly', and 'AllInsights'. The default is AllInsights. If you set this to AllInsights and the input is audio only, then only audio insights are generated. Similarly if the input is video only, then only video insights are generated. It is recommended that you not use AudioInsightsOnly if you expect some of your inputs to be video only; or use VideoInsightsOnly if you expect some of your inputs to be audio only. Your Jobs in such conditions would error out.
        """
        return pulumi.get(self, "insights_to_extract")

    @insights_to_extract.setter
    def insights_to_extract(self, value: Optional[pulumi.Input[Union[str, 'InsightsType']]]):
        pulumi.set(self, "insights_to_extract", value)

    @property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input[Union[str, 'AudioAnalysisMode']]]:
        """
        Determines the set of audio analysis operations to be performed. If unspecified, the Standard AudioAnalysisMode would be chosen.
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input[Union[str, 'AudioAnalysisMode']]]):
        pulumi.set(self, "mode", value)


@pulumi.input_type
class VideoOverlayArgs:
    def __init__(__self__, *,
                 input_label: pulumi.Input[str],
                 odata_type: pulumi.Input[str],
                 audio_gain_level: Optional[pulumi.Input[float]] = None,
                 crop_rectangle: Optional[pulumi.Input['RectangleArgs']] = None,
                 end: Optional[pulumi.Input[str]] = None,
                 fade_in_duration: Optional[pulumi.Input[str]] = None,
                 fade_out_duration: Optional[pulumi.Input[str]] = None,
                 opacity: Optional[pulumi.Input[float]] = None,
                 position: Optional[pulumi.Input['RectangleArgs']] = None,
                 start: Optional[pulumi.Input[str]] = None):
        """
        Describes the properties of a video overlay.
        :param pulumi.Input[str] input_label: The label of the job input which is to be used as an overlay. The Input must specify exactly one file. You can specify an image file in JPG, PNG, GIF or BMP format, or an audio file (such as a WAV, MP3, WMA or M4A file), or a video file. See https://aka.ms/mesformats for the complete list of supported audio and video file formats.
        :param pulumi.Input[str] odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.VideoOverlay'.
        :param pulumi.Input[float] audio_gain_level: The gain level of audio in the overlay. The value should be in the range [0, 1.0]. The default is 1.0.
        :param pulumi.Input['RectangleArgs'] crop_rectangle: An optional rectangular window used to crop the overlay image or video.
        :param pulumi.Input[str] end: The end position, with reference to the input video, at which the overlay ends. The value should be in ISO 8601 format. For example, PT30S to end the overlay at 30 seconds into the input video. If not specified or the value is greater than the input video duration, the overlay will be applied until the end of the input video if the overlay media duration is greater than the input video duration, else the overlay will last as long as the overlay media duration.
        :param pulumi.Input[str] fade_in_duration: The duration over which the overlay fades in onto the input video. The value should be in ISO 8601 duration format. If not specified the default behavior is to have no fade in (same as PT0S).
        :param pulumi.Input[str] fade_out_duration: The duration over which the overlay fades out of the input video. The value should be in ISO 8601 duration format. If not specified the default behavior is to have no fade out (same as PT0S).
        :param pulumi.Input[float] opacity: The opacity of the overlay. This is a value in the range [0 - 1.0]. Default is 1.0 which mean the overlay is opaque.
        :param pulumi.Input['RectangleArgs'] position: The location in the input video where the overlay is applied.
        :param pulumi.Input[str] start: The start position, with reference to the input video, at which the overlay starts. The value should be in ISO 8601 format. For example, PT05S to start the overlay at 5 seconds into the input video. If not specified the overlay starts from the beginning of the input video.
        """
        pulumi.set(__self__, "input_label", input_label)
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.VideoOverlay')
        if audio_gain_level is not None:
            pulumi.set(__self__, "audio_gain_level", audio_gain_level)
        if crop_rectangle is not None:
            pulumi.set(__self__, "crop_rectangle", crop_rectangle)
        if end is not None:
            pulumi.set(__self__, "end", end)
        if fade_in_duration is not None:
            pulumi.set(__self__, "fade_in_duration", fade_in_duration)
        if fade_out_duration is not None:
            pulumi.set(__self__, "fade_out_duration", fade_out_duration)
        if opacity is not None:
            pulumi.set(__self__, "opacity", opacity)
        if position is not None:
            pulumi.set(__self__, "position", position)
        if start is not None:
            pulumi.set(__self__, "start", start)

    @property
    @pulumi.getter(name="inputLabel")
    def input_label(self) -> pulumi.Input[str]:
        """
        The label of the job input which is to be used as an overlay. The Input must specify exactly one file. You can specify an image file in JPG, PNG, GIF or BMP format, or an audio file (such as a WAV, MP3, WMA or M4A file), or a video file. See https://aka.ms/mesformats for the complete list of supported audio and video file formats.
        """
        return pulumi.get(self, "input_label")

    @input_label.setter
    def input_label(self, value: pulumi.Input[str]):
        pulumi.set(self, "input_label", value)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> pulumi.Input[str]:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.VideoOverlay'.
        """
        return pulumi.get(self, "odata_type")

    @odata_type.setter
    def odata_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "odata_type", value)

    @property
    @pulumi.getter(name="audioGainLevel")
    def audio_gain_level(self) -> Optional[pulumi.Input[float]]:
        """
        The gain level of audio in the overlay. The value should be in the range [0, 1.0]. The default is 1.0.
        """
        return pulumi.get(self, "audio_gain_level")

    @audio_gain_level.setter
    def audio_gain_level(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "audio_gain_level", value)

    @property
    @pulumi.getter(name="cropRectangle")
    def crop_rectangle(self) -> Optional[pulumi.Input['RectangleArgs']]:
        """
        An optional rectangular window used to crop the overlay image or video.
        """
        return pulumi.get(self, "crop_rectangle")

    @crop_rectangle.setter
    def crop_rectangle(self, value: Optional[pulumi.Input['RectangleArgs']]):
        pulumi.set(self, "crop_rectangle", value)

    @property
    @pulumi.getter
    def end(self) -> Optional[pulumi.Input[str]]:
        """
        The end position, with reference to the input video, at which the overlay ends. The value should be in ISO 8601 format. For example, PT30S to end the overlay at 30 seconds into the input video. If not specified or the value is greater than the input video duration, the overlay will be applied until the end of the input video if the overlay media duration is greater than the input video duration, else the overlay will last as long as the overlay media duration.
        """
        return pulumi.get(self, "end")

    @end.setter
    def end(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "end", value)

    @property
    @pulumi.getter(name="fadeInDuration")
    def fade_in_duration(self) -> Optional[pulumi.Input[str]]:
        """
        The duration over which the overlay fades in onto the input video. The value should be in ISO 8601 duration format. If not specified the default behavior is to have no fade in (same as PT0S).
        """
        return pulumi.get(self, "fade_in_duration")

    @fade_in_duration.setter
    def fade_in_duration(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fade_in_duration", value)

    @property
    @pulumi.getter(name="fadeOutDuration")
    def fade_out_duration(self) -> Optional[pulumi.Input[str]]:
        """
        The duration over which the overlay fades out of the input video. The value should be in ISO 8601 duration format. If not specified the default behavior is to have no fade out (same as PT0S).
        """
        return pulumi.get(self, "fade_out_duration")

    @fade_out_duration.setter
    def fade_out_duration(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fade_out_duration", value)

    @property
    @pulumi.getter
    def opacity(self) -> Optional[pulumi.Input[float]]:
        """
        The opacity of the overlay. This is a value in the range [0 - 1.0]. Default is 1.0 which mean the overlay is opaque.
        """
        return pulumi.get(self, "opacity")

    @opacity.setter
    def opacity(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "opacity", value)

    @property
    @pulumi.getter
    def position(self) -> Optional[pulumi.Input['RectangleArgs']]:
        """
        The location in the input video where the overlay is applied.
        """
        return pulumi.get(self, "position")

    @position.setter
    def position(self, value: Optional[pulumi.Input['RectangleArgs']]):
        pulumi.set(self, "position", value)

    @property
    @pulumi.getter
    def start(self) -> Optional[pulumi.Input[str]]:
        """
        The start position, with reference to the input video, at which the overlay starts. The value should be in ISO 8601 format. For example, PT05S to start the overlay at 5 seconds into the input video. If not specified the overlay starts from the beginning of the input video.
        """
        return pulumi.get(self, "start")

    @start.setter
    def start(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "start", value)


@pulumi.input_type
class VideoTrackDescriptorArgs:
    def __init__(__self__, *,
                 odata_type: pulumi.Input[str]):
        """
        A TrackSelection to select video tracks.
        :param pulumi.Input[str] odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.VideoTrackDescriptor'.
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.VideoTrackDescriptor')

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> pulumi.Input[str]:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.VideoTrackDescriptor'.
        """
        return pulumi.get(self, "odata_type")

    @odata_type.setter
    def odata_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "odata_type", value)


@pulumi.input_type
class VideoTrackArgs:
    def __init__(__self__, *,
                 odata_type: pulumi.Input[str]):
        """
        Represents a video track in the asset.
        :param pulumi.Input[str] odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.VideoTrack'.
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.VideoTrack')

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> pulumi.Input[str]:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.VideoTrack'.
        """
        return pulumi.get(self, "odata_type")

    @odata_type.setter
    def odata_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "odata_type", value)


@pulumi.input_type
class VideoArgs:
    def __init__(__self__, *,
                 odata_type: pulumi.Input[str],
                 key_frame_interval: Optional[pulumi.Input[str]] = None,
                 label: Optional[pulumi.Input[str]] = None,
                 stretch_mode: Optional[pulumi.Input[Union[str, 'StretchMode']]] = None,
                 sync_mode: Optional[pulumi.Input[Union[str, 'VideoSyncMode']]] = None):
        """
        Describes the basic properties for encoding the input video.
        :param pulumi.Input[str] odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.Video'.
        :param pulumi.Input[str] key_frame_interval: The distance between two key frames. The value should be non-zero in the range [0.5, 20] seconds, specified in ISO 8601 format. The default is 2 seconds(PT2S). Note that this setting is ignored if VideoSyncMode.Passthrough is set, where the KeyFrameInterval value will follow the input source setting.
        :param pulumi.Input[str] label: An optional label for the codec. The label can be used to control muxing behavior.
        :param pulumi.Input[Union[str, 'StretchMode']] stretch_mode: The resizing mode - how the input video will be resized to fit the desired output resolution(s). Default is AutoSize
        :param pulumi.Input[Union[str, 'VideoSyncMode']] sync_mode: The Video Sync Mode
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.Video')
        if key_frame_interval is not None:
            pulumi.set(__self__, "key_frame_interval", key_frame_interval)
        if label is not None:
            pulumi.set(__self__, "label", label)
        if stretch_mode is not None:
            pulumi.set(__self__, "stretch_mode", stretch_mode)
        if sync_mode is not None:
            pulumi.set(__self__, "sync_mode", sync_mode)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> pulumi.Input[str]:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.Video'.
        """
        return pulumi.get(self, "odata_type")

    @odata_type.setter
    def odata_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "odata_type", value)

    @property
    @pulumi.getter(name="keyFrameInterval")
    def key_frame_interval(self) -> Optional[pulumi.Input[str]]:
        """
        The distance between two key frames. The value should be non-zero in the range [0.5, 20] seconds, specified in ISO 8601 format. The default is 2 seconds(PT2S). Note that this setting is ignored if VideoSyncMode.Passthrough is set, where the KeyFrameInterval value will follow the input source setting.
        """
        return pulumi.get(self, "key_frame_interval")

    @key_frame_interval.setter
    def key_frame_interval(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_frame_interval", value)

    @property
    @pulumi.getter
    def label(self) -> Optional[pulumi.Input[str]]:
        """
        An optional label for the codec. The label can be used to control muxing behavior.
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "label", value)

    @property
    @pulumi.getter(name="stretchMode")
    def stretch_mode(self) -> Optional[pulumi.Input[Union[str, 'StretchMode']]]:
        """
        The resizing mode - how the input video will be resized to fit the desired output resolution(s). Default is AutoSize
        """
        return pulumi.get(self, "stretch_mode")

    @stretch_mode.setter
    def stretch_mode(self, value: Optional[pulumi.Input[Union[str, 'StretchMode']]]):
        pulumi.set(self, "stretch_mode", value)

    @property
    @pulumi.getter(name="syncMode")
    def sync_mode(self) -> Optional[pulumi.Input[Union[str, 'VideoSyncMode']]]:
        """
        The Video Sync Mode
        """
        return pulumi.get(self, "sync_mode")

    @sync_mode.setter
    def sync_mode(self, value: Optional[pulumi.Input[Union[str, 'VideoSyncMode']]]):
        pulumi.set(self, "sync_mode", value)


