# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'CommunityGalleryInfoArgs',
    'DataDiskImageEncryptionArgs',
    'DisallowedArgs',
    'EncryptionImagesArgs',
    'GalleryApplicationVersionPublishingProfileArgs',
    'GalleryArtifactVersionSourceArgs',
    'GalleryDataDiskImageArgs',
    'GalleryExtendedLocationArgs',
    'GalleryImageFeatureArgs',
    'GalleryImageIdentifierArgs',
    'GalleryImageVersionPublishingProfileArgs',
    'GalleryImageVersionStorageProfileArgs',
    'GalleryOSDiskImageArgs',
    'GalleryTargetExtendedLocationArgs',
    'ImagePurchasePlanArgs',
    'OSDiskImageEncryptionArgs',
    'OSDiskImageSecurityProfileArgs',
    'RecommendedMachineConfigurationArgs',
    'ResourceRangeArgs',
    'SharingProfileArgs',
    'SoftDeletePolicyArgs',
    'TargetRegionArgs',
    'UserArtifactManageArgs',
    'UserArtifactSourceArgs',
]

@pulumi.input_type
class CommunityGalleryInfoArgs:
    def __init__(__self__, *,
                 eula: Optional[pulumi.Input[str]] = None,
                 public_name_prefix: Optional[pulumi.Input[str]] = None,
                 publisher_contact: Optional[pulumi.Input[str]] = None,
                 publisher_uri: Optional[pulumi.Input[str]] = None):
        """
        Information of community gallery if current gallery is shared to community
        :param pulumi.Input[str] eula: Community gallery publisher eula
        :param pulumi.Input[str] public_name_prefix: Community gallery public name prefix
        :param pulumi.Input[str] publisher_contact: Community gallery publisher contact email
        :param pulumi.Input[str] publisher_uri: Community gallery publisher uri
        """
        if eula is not None:
            pulumi.set(__self__, "eula", eula)
        if public_name_prefix is not None:
            pulumi.set(__self__, "public_name_prefix", public_name_prefix)
        if publisher_contact is not None:
            pulumi.set(__self__, "publisher_contact", publisher_contact)
        if publisher_uri is not None:
            pulumi.set(__self__, "publisher_uri", publisher_uri)

    @property
    @pulumi.getter
    def eula(self) -> Optional[pulumi.Input[str]]:
        """
        Community gallery publisher eula
        """
        return pulumi.get(self, "eula")

    @eula.setter
    def eula(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "eula", value)

    @property
    @pulumi.getter(name="publicNamePrefix")
    def public_name_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        Community gallery public name prefix
        """
        return pulumi.get(self, "public_name_prefix")

    @public_name_prefix.setter
    def public_name_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "public_name_prefix", value)

    @property
    @pulumi.getter(name="publisherContact")
    def publisher_contact(self) -> Optional[pulumi.Input[str]]:
        """
        Community gallery publisher contact email
        """
        return pulumi.get(self, "publisher_contact")

    @publisher_contact.setter
    def publisher_contact(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "publisher_contact", value)

    @property
    @pulumi.getter(name="publisherUri")
    def publisher_uri(self) -> Optional[pulumi.Input[str]]:
        """
        Community gallery publisher uri
        """
        return pulumi.get(self, "publisher_uri")

    @publisher_uri.setter
    def publisher_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "publisher_uri", value)


@pulumi.input_type
class DataDiskImageEncryptionArgs:
    def __init__(__self__, *,
                 lun: pulumi.Input[int],
                 disk_encryption_set_id: Optional[pulumi.Input[str]] = None):
        """
        Contains encryption settings for a data disk image.
        :param pulumi.Input[int] lun: This property specifies the logical unit number of the data disk. This value is used to identify data disks within the Virtual Machine and therefore must be unique for each data disk attached to the Virtual Machine.
        :param pulumi.Input[str] disk_encryption_set_id: A relative URI containing the resource ID of the disk encryption set.
        """
        pulumi.set(__self__, "lun", lun)
        if disk_encryption_set_id is not None:
            pulumi.set(__self__, "disk_encryption_set_id", disk_encryption_set_id)

    @property
    @pulumi.getter
    def lun(self) -> pulumi.Input[int]:
        """
        This property specifies the logical unit number of the data disk. This value is used to identify data disks within the Virtual Machine and therefore must be unique for each data disk attached to the Virtual Machine.
        """
        return pulumi.get(self, "lun")

    @lun.setter
    def lun(self, value: pulumi.Input[int]):
        pulumi.set(self, "lun", value)

    @property
    @pulumi.getter(name="diskEncryptionSetId")
    def disk_encryption_set_id(self) -> Optional[pulumi.Input[str]]:
        """
        A relative URI containing the resource ID of the disk encryption set.
        """
        return pulumi.get(self, "disk_encryption_set_id")

    @disk_encryption_set_id.setter
    def disk_encryption_set_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "disk_encryption_set_id", value)


@pulumi.input_type
class DisallowedArgs:
    def __init__(__self__, *,
                 disk_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Describes the disallowed disk types.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] disk_types: A list of disk types.
        """
        if disk_types is not None:
            pulumi.set(__self__, "disk_types", disk_types)

    @property
    @pulumi.getter(name="diskTypes")
    def disk_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of disk types.
        """
        return pulumi.get(self, "disk_types")

    @disk_types.setter
    def disk_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "disk_types", value)


@pulumi.input_type
class EncryptionImagesArgs:
    def __init__(__self__, *,
                 data_disk_images: Optional[pulumi.Input[Sequence[pulumi.Input['DataDiskImageEncryptionArgs']]]] = None,
                 os_disk_image: Optional[pulumi.Input['OSDiskImageEncryptionArgs']] = None):
        """
        Optional. Allows users to provide customer managed keys for encrypting the OS and data disks in the gallery artifact.
        :param pulumi.Input[Sequence[pulumi.Input['DataDiskImageEncryptionArgs']]] data_disk_images: A list of encryption specifications for data disk images.
        :param pulumi.Input['OSDiskImageEncryptionArgs'] os_disk_image: Contains encryption settings for an OS disk image.
        """
        if data_disk_images is not None:
            pulumi.set(__self__, "data_disk_images", data_disk_images)
        if os_disk_image is not None:
            pulumi.set(__self__, "os_disk_image", os_disk_image)

    @property
    @pulumi.getter(name="dataDiskImages")
    def data_disk_images(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DataDiskImageEncryptionArgs']]]]:
        """
        A list of encryption specifications for data disk images.
        """
        return pulumi.get(self, "data_disk_images")

    @data_disk_images.setter
    def data_disk_images(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DataDiskImageEncryptionArgs']]]]):
        pulumi.set(self, "data_disk_images", value)

    @property
    @pulumi.getter(name="osDiskImage")
    def os_disk_image(self) -> Optional[pulumi.Input['OSDiskImageEncryptionArgs']]:
        """
        Contains encryption settings for an OS disk image.
        """
        return pulumi.get(self, "os_disk_image")

    @os_disk_image.setter
    def os_disk_image(self, value: Optional[pulumi.Input['OSDiskImageEncryptionArgs']]):
        pulumi.set(self, "os_disk_image", value)


@pulumi.input_type
class GalleryApplicationVersionPublishingProfileArgs:
    def __init__(__self__, *,
                 source: pulumi.Input['UserArtifactSourceArgs'],
                 enable_health_check: Optional[pulumi.Input[bool]] = None,
                 end_of_life_date: Optional[pulumi.Input[str]] = None,
                 exclude_from_latest: Optional[pulumi.Input[bool]] = None,
                 manage_actions: Optional[pulumi.Input['UserArtifactManageArgs']] = None,
                 replica_count: Optional[pulumi.Input[int]] = None,
                 replication_mode: Optional[pulumi.Input[Union[str, 'ReplicationMode']]] = None,
                 storage_account_type: Optional[pulumi.Input[Union[str, 'StorageAccountType']]] = None,
                 target_extended_locations: Optional[pulumi.Input[Sequence[pulumi.Input['GalleryTargetExtendedLocationArgs']]]] = None,
                 target_regions: Optional[pulumi.Input[Sequence[pulumi.Input['TargetRegionArgs']]]] = None):
        """
        The publishing profile of a gallery image version.
        :param pulumi.Input['UserArtifactSourceArgs'] source: The source image from which the Image Version is going to be created.
        :param pulumi.Input[bool] enable_health_check: Optional. Whether or not this application reports health.
        :param pulumi.Input[str] end_of_life_date: The end of life date of the gallery image version. This property can be used for decommissioning purposes. This property is updatable.
        :param pulumi.Input[bool] exclude_from_latest: If set to true, Virtual Machines deployed from the latest version of the Image Definition won't use this Image Version.
        :param pulumi.Input[int] replica_count: The number of replicas of the Image Version to be created per region. This property would take effect for a region when regionalReplicaCount is not specified. This property is updatable.
        :param pulumi.Input[Union[str, 'ReplicationMode']] replication_mode: Optional parameter which specifies the mode to be used for replication. This property is not updatable.
        :param pulumi.Input[Union[str, 'StorageAccountType']] storage_account_type: Specifies the storage account type to be used to store the image. This property is not updatable.
        :param pulumi.Input[Sequence[pulumi.Input['GalleryTargetExtendedLocationArgs']]] target_extended_locations: The target extended locations where the Image Version is going to be replicated to. This property is updatable.
        :param pulumi.Input[Sequence[pulumi.Input['TargetRegionArgs']]] target_regions: The target regions where the Image Version is going to be replicated to. This property is updatable.
        """
        pulumi.set(__self__, "source", source)
        if enable_health_check is not None:
            pulumi.set(__self__, "enable_health_check", enable_health_check)
        if end_of_life_date is not None:
            pulumi.set(__self__, "end_of_life_date", end_of_life_date)
        if exclude_from_latest is not None:
            pulumi.set(__self__, "exclude_from_latest", exclude_from_latest)
        if manage_actions is not None:
            pulumi.set(__self__, "manage_actions", manage_actions)
        if replica_count is not None:
            pulumi.set(__self__, "replica_count", replica_count)
        if replication_mode is not None:
            pulumi.set(__self__, "replication_mode", replication_mode)
        if storage_account_type is not None:
            pulumi.set(__self__, "storage_account_type", storage_account_type)
        if target_extended_locations is not None:
            pulumi.set(__self__, "target_extended_locations", target_extended_locations)
        if target_regions is not None:
            pulumi.set(__self__, "target_regions", target_regions)

    @property
    @pulumi.getter
    def source(self) -> pulumi.Input['UserArtifactSourceArgs']:
        """
        The source image from which the Image Version is going to be created.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: pulumi.Input['UserArtifactSourceArgs']):
        pulumi.set(self, "source", value)

    @property
    @pulumi.getter(name="enableHealthCheck")
    def enable_health_check(self) -> Optional[pulumi.Input[bool]]:
        """
        Optional. Whether or not this application reports health.
        """
        return pulumi.get(self, "enable_health_check")

    @enable_health_check.setter
    def enable_health_check(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_health_check", value)

    @property
    @pulumi.getter(name="endOfLifeDate")
    def end_of_life_date(self) -> Optional[pulumi.Input[str]]:
        """
        The end of life date of the gallery image version. This property can be used for decommissioning purposes. This property is updatable.
        """
        return pulumi.get(self, "end_of_life_date")

    @end_of_life_date.setter
    def end_of_life_date(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "end_of_life_date", value)

    @property
    @pulumi.getter(name="excludeFromLatest")
    def exclude_from_latest(self) -> Optional[pulumi.Input[bool]]:
        """
        If set to true, Virtual Machines deployed from the latest version of the Image Definition won't use this Image Version.
        """
        return pulumi.get(self, "exclude_from_latest")

    @exclude_from_latest.setter
    def exclude_from_latest(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "exclude_from_latest", value)

    @property
    @pulumi.getter(name="manageActions")
    def manage_actions(self) -> Optional[pulumi.Input['UserArtifactManageArgs']]:
        return pulumi.get(self, "manage_actions")

    @manage_actions.setter
    def manage_actions(self, value: Optional[pulumi.Input['UserArtifactManageArgs']]):
        pulumi.set(self, "manage_actions", value)

    @property
    @pulumi.getter(name="replicaCount")
    def replica_count(self) -> Optional[pulumi.Input[int]]:
        """
        The number of replicas of the Image Version to be created per region. This property would take effect for a region when regionalReplicaCount is not specified. This property is updatable.
        """
        return pulumi.get(self, "replica_count")

    @replica_count.setter
    def replica_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "replica_count", value)

    @property
    @pulumi.getter(name="replicationMode")
    def replication_mode(self) -> Optional[pulumi.Input[Union[str, 'ReplicationMode']]]:
        """
        Optional parameter which specifies the mode to be used for replication. This property is not updatable.
        """
        return pulumi.get(self, "replication_mode")

    @replication_mode.setter
    def replication_mode(self, value: Optional[pulumi.Input[Union[str, 'ReplicationMode']]]):
        pulumi.set(self, "replication_mode", value)

    @property
    @pulumi.getter(name="storageAccountType")
    def storage_account_type(self) -> Optional[pulumi.Input[Union[str, 'StorageAccountType']]]:
        """
        Specifies the storage account type to be used to store the image. This property is not updatable.
        """
        return pulumi.get(self, "storage_account_type")

    @storage_account_type.setter
    def storage_account_type(self, value: Optional[pulumi.Input[Union[str, 'StorageAccountType']]]):
        pulumi.set(self, "storage_account_type", value)

    @property
    @pulumi.getter(name="targetExtendedLocations")
    def target_extended_locations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GalleryTargetExtendedLocationArgs']]]]:
        """
        The target extended locations where the Image Version is going to be replicated to. This property is updatable.
        """
        return pulumi.get(self, "target_extended_locations")

    @target_extended_locations.setter
    def target_extended_locations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GalleryTargetExtendedLocationArgs']]]]):
        pulumi.set(self, "target_extended_locations", value)

    @property
    @pulumi.getter(name="targetRegions")
    def target_regions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TargetRegionArgs']]]]:
        """
        The target regions where the Image Version is going to be replicated to. This property is updatable.
        """
        return pulumi.get(self, "target_regions")

    @target_regions.setter
    def target_regions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TargetRegionArgs']]]]):
        pulumi.set(self, "target_regions", value)


@pulumi.input_type
class GalleryArtifactVersionSourceArgs:
    def __init__(__self__, *,
                 id: Optional[pulumi.Input[str]] = None,
                 uri: Optional[pulumi.Input[str]] = None):
        """
        The gallery artifact version source.
        :param pulumi.Input[str] id: The id of the gallery artifact version source. Can specify a disk uri, snapshot uri, user image or storage account resource.
        :param pulumi.Input[str] uri: The uri of the gallery artifact version source. Currently used to specify vhd/blob source.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if uri is not None:
            pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        The id of the gallery artifact version source. Can specify a disk uri, snapshot uri, user image or storage account resource.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def uri(self) -> Optional[pulumi.Input[str]]:
        """
        The uri of the gallery artifact version source. Currently used to specify vhd/blob source.
        """
        return pulumi.get(self, "uri")

    @uri.setter
    def uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "uri", value)


@pulumi.input_type
class GalleryDataDiskImageArgs:
    def __init__(__self__, *,
                 lun: pulumi.Input[int],
                 host_caching: Optional[pulumi.Input['HostCaching']] = None,
                 source: Optional[pulumi.Input['GalleryArtifactVersionSourceArgs']] = None):
        """
        This is the data disk image.
        :param pulumi.Input[int] lun: This property specifies the logical unit number of the data disk. This value is used to identify data disks within the Virtual Machine and therefore must be unique for each data disk attached to the Virtual Machine.
        :param pulumi.Input['HostCaching'] host_caching: The host caching of the disk. Valid values are 'None', 'ReadOnly', and 'ReadWrite'
        :param pulumi.Input['GalleryArtifactVersionSourceArgs'] source: The gallery artifact version source.
        """
        pulumi.set(__self__, "lun", lun)
        if host_caching is not None:
            pulumi.set(__self__, "host_caching", host_caching)
        if source is not None:
            pulumi.set(__self__, "source", source)

    @property
    @pulumi.getter
    def lun(self) -> pulumi.Input[int]:
        """
        This property specifies the logical unit number of the data disk. This value is used to identify data disks within the Virtual Machine and therefore must be unique for each data disk attached to the Virtual Machine.
        """
        return pulumi.get(self, "lun")

    @lun.setter
    def lun(self, value: pulumi.Input[int]):
        pulumi.set(self, "lun", value)

    @property
    @pulumi.getter(name="hostCaching")
    def host_caching(self) -> Optional[pulumi.Input['HostCaching']]:
        """
        The host caching of the disk. Valid values are 'None', 'ReadOnly', and 'ReadWrite'
        """
        return pulumi.get(self, "host_caching")

    @host_caching.setter
    def host_caching(self, value: Optional[pulumi.Input['HostCaching']]):
        pulumi.set(self, "host_caching", value)

    @property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input['GalleryArtifactVersionSourceArgs']]:
        """
        The gallery artifact version source.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input['GalleryArtifactVersionSourceArgs']]):
        pulumi.set(self, "source", value)


@pulumi.input_type
class GalleryExtendedLocationArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[Union[str, 'GalleryExtendedLocationType']]] = None):
        """
        The name of the extended location.
        :param pulumi.Input[Union[str, 'GalleryExtendedLocationType']] type: It is type of the extended location.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[Union[str, 'GalleryExtendedLocationType']]]:
        """
        It is type of the extended location.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[Union[str, 'GalleryExtendedLocationType']]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class GalleryImageFeatureArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None):
        """
        A feature for gallery image.
        :param pulumi.Input[str] name: The name of the gallery image feature.
        :param pulumi.Input[str] value: The value of the gallery image feature.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the gallery image feature.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        The value of the gallery image feature.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class GalleryImageIdentifierArgs:
    def __init__(__self__, *,
                 offer: pulumi.Input[str],
                 publisher: pulumi.Input[str],
                 sku: pulumi.Input[str]):
        """
        This is the gallery image definition identifier.
        :param pulumi.Input[str] offer: The name of the gallery image definition offer.
        :param pulumi.Input[str] publisher: The name of the gallery image definition publisher.
        :param pulumi.Input[str] sku: The name of the gallery image definition SKU.
        """
        pulumi.set(__self__, "offer", offer)
        pulumi.set(__self__, "publisher", publisher)
        pulumi.set(__self__, "sku", sku)

    @property
    @pulumi.getter
    def offer(self) -> pulumi.Input[str]:
        """
        The name of the gallery image definition offer.
        """
        return pulumi.get(self, "offer")

    @offer.setter
    def offer(self, value: pulumi.Input[str]):
        pulumi.set(self, "offer", value)

    @property
    @pulumi.getter
    def publisher(self) -> pulumi.Input[str]:
        """
        The name of the gallery image definition publisher.
        """
        return pulumi.get(self, "publisher")

    @publisher.setter
    def publisher(self, value: pulumi.Input[str]):
        pulumi.set(self, "publisher", value)

    @property
    @pulumi.getter
    def sku(self) -> pulumi.Input[str]:
        """
        The name of the gallery image definition SKU.
        """
        return pulumi.get(self, "sku")

    @sku.setter
    def sku(self, value: pulumi.Input[str]):
        pulumi.set(self, "sku", value)


@pulumi.input_type
class GalleryImageVersionPublishingProfileArgs:
    def __init__(__self__, *,
                 end_of_life_date: Optional[pulumi.Input[str]] = None,
                 exclude_from_latest: Optional[pulumi.Input[bool]] = None,
                 replica_count: Optional[pulumi.Input[int]] = None,
                 replication_mode: Optional[pulumi.Input[Union[str, 'ReplicationMode']]] = None,
                 storage_account_type: Optional[pulumi.Input[Union[str, 'StorageAccountType']]] = None,
                 target_extended_locations: Optional[pulumi.Input[Sequence[pulumi.Input['GalleryTargetExtendedLocationArgs']]]] = None,
                 target_regions: Optional[pulumi.Input[Sequence[pulumi.Input['TargetRegionArgs']]]] = None):
        """
        The publishing profile of a gallery image Version.
        :param pulumi.Input[str] end_of_life_date: The end of life date of the gallery image version. This property can be used for decommissioning purposes. This property is updatable.
        :param pulumi.Input[bool] exclude_from_latest: If set to true, Virtual Machines deployed from the latest version of the Image Definition won't use this Image Version.
        :param pulumi.Input[int] replica_count: The number of replicas of the Image Version to be created per region. This property would take effect for a region when regionalReplicaCount is not specified. This property is updatable.
        :param pulumi.Input[Union[str, 'ReplicationMode']] replication_mode: Optional parameter which specifies the mode to be used for replication. This property is not updatable.
        :param pulumi.Input[Union[str, 'StorageAccountType']] storage_account_type: Specifies the storage account type to be used to store the image. This property is not updatable.
        :param pulumi.Input[Sequence[pulumi.Input['GalleryTargetExtendedLocationArgs']]] target_extended_locations: The target extended locations where the Image Version is going to be replicated to. This property is updatable.
        :param pulumi.Input[Sequence[pulumi.Input['TargetRegionArgs']]] target_regions: The target regions where the Image Version is going to be replicated to. This property is updatable.
        """
        if end_of_life_date is not None:
            pulumi.set(__self__, "end_of_life_date", end_of_life_date)
        if exclude_from_latest is not None:
            pulumi.set(__self__, "exclude_from_latest", exclude_from_latest)
        if replica_count is not None:
            pulumi.set(__self__, "replica_count", replica_count)
        if replication_mode is not None:
            pulumi.set(__self__, "replication_mode", replication_mode)
        if storage_account_type is not None:
            pulumi.set(__self__, "storage_account_type", storage_account_type)
        if target_extended_locations is not None:
            pulumi.set(__self__, "target_extended_locations", target_extended_locations)
        if target_regions is not None:
            pulumi.set(__self__, "target_regions", target_regions)

    @property
    @pulumi.getter(name="endOfLifeDate")
    def end_of_life_date(self) -> Optional[pulumi.Input[str]]:
        """
        The end of life date of the gallery image version. This property can be used for decommissioning purposes. This property is updatable.
        """
        return pulumi.get(self, "end_of_life_date")

    @end_of_life_date.setter
    def end_of_life_date(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "end_of_life_date", value)

    @property
    @pulumi.getter(name="excludeFromLatest")
    def exclude_from_latest(self) -> Optional[pulumi.Input[bool]]:
        """
        If set to true, Virtual Machines deployed from the latest version of the Image Definition won't use this Image Version.
        """
        return pulumi.get(self, "exclude_from_latest")

    @exclude_from_latest.setter
    def exclude_from_latest(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "exclude_from_latest", value)

    @property
    @pulumi.getter(name="replicaCount")
    def replica_count(self) -> Optional[pulumi.Input[int]]:
        """
        The number of replicas of the Image Version to be created per region. This property would take effect for a region when regionalReplicaCount is not specified. This property is updatable.
        """
        return pulumi.get(self, "replica_count")

    @replica_count.setter
    def replica_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "replica_count", value)

    @property
    @pulumi.getter(name="replicationMode")
    def replication_mode(self) -> Optional[pulumi.Input[Union[str, 'ReplicationMode']]]:
        """
        Optional parameter which specifies the mode to be used for replication. This property is not updatable.
        """
        return pulumi.get(self, "replication_mode")

    @replication_mode.setter
    def replication_mode(self, value: Optional[pulumi.Input[Union[str, 'ReplicationMode']]]):
        pulumi.set(self, "replication_mode", value)

    @property
    @pulumi.getter(name="storageAccountType")
    def storage_account_type(self) -> Optional[pulumi.Input[Union[str, 'StorageAccountType']]]:
        """
        Specifies the storage account type to be used to store the image. This property is not updatable.
        """
        return pulumi.get(self, "storage_account_type")

    @storage_account_type.setter
    def storage_account_type(self, value: Optional[pulumi.Input[Union[str, 'StorageAccountType']]]):
        pulumi.set(self, "storage_account_type", value)

    @property
    @pulumi.getter(name="targetExtendedLocations")
    def target_extended_locations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GalleryTargetExtendedLocationArgs']]]]:
        """
        The target extended locations where the Image Version is going to be replicated to. This property is updatable.
        """
        return pulumi.get(self, "target_extended_locations")

    @target_extended_locations.setter
    def target_extended_locations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GalleryTargetExtendedLocationArgs']]]]):
        pulumi.set(self, "target_extended_locations", value)

    @property
    @pulumi.getter(name="targetRegions")
    def target_regions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TargetRegionArgs']]]]:
        """
        The target regions where the Image Version is going to be replicated to. This property is updatable.
        """
        return pulumi.get(self, "target_regions")

    @target_regions.setter
    def target_regions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TargetRegionArgs']]]]):
        pulumi.set(self, "target_regions", value)


@pulumi.input_type
class GalleryImageVersionStorageProfileArgs:
    def __init__(__self__, *,
                 data_disk_images: Optional[pulumi.Input[Sequence[pulumi.Input['GalleryDataDiskImageArgs']]]] = None,
                 os_disk_image: Optional[pulumi.Input['GalleryOSDiskImageArgs']] = None,
                 source: Optional[pulumi.Input['GalleryArtifactVersionSourceArgs']] = None):
        """
        This is the storage profile of a Gallery Image Version.
        :param pulumi.Input[Sequence[pulumi.Input['GalleryDataDiskImageArgs']]] data_disk_images: A list of data disk images.
        :param pulumi.Input['GalleryOSDiskImageArgs'] os_disk_image: This is the OS disk image.
        :param pulumi.Input['GalleryArtifactVersionSourceArgs'] source: The gallery artifact version source.
        """
        if data_disk_images is not None:
            pulumi.set(__self__, "data_disk_images", data_disk_images)
        if os_disk_image is not None:
            pulumi.set(__self__, "os_disk_image", os_disk_image)
        if source is not None:
            pulumi.set(__self__, "source", source)

    @property
    @pulumi.getter(name="dataDiskImages")
    def data_disk_images(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GalleryDataDiskImageArgs']]]]:
        """
        A list of data disk images.
        """
        return pulumi.get(self, "data_disk_images")

    @data_disk_images.setter
    def data_disk_images(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GalleryDataDiskImageArgs']]]]):
        pulumi.set(self, "data_disk_images", value)

    @property
    @pulumi.getter(name="osDiskImage")
    def os_disk_image(self) -> Optional[pulumi.Input['GalleryOSDiskImageArgs']]:
        """
        This is the OS disk image.
        """
        return pulumi.get(self, "os_disk_image")

    @os_disk_image.setter
    def os_disk_image(self, value: Optional[pulumi.Input['GalleryOSDiskImageArgs']]):
        pulumi.set(self, "os_disk_image", value)

    @property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input['GalleryArtifactVersionSourceArgs']]:
        """
        The gallery artifact version source.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input['GalleryArtifactVersionSourceArgs']]):
        pulumi.set(self, "source", value)


@pulumi.input_type
class GalleryOSDiskImageArgs:
    def __init__(__self__, *,
                 host_caching: Optional[pulumi.Input['HostCaching']] = None,
                 source: Optional[pulumi.Input['GalleryArtifactVersionSourceArgs']] = None):
        """
        This is the OS disk image.
        :param pulumi.Input['HostCaching'] host_caching: The host caching of the disk. Valid values are 'None', 'ReadOnly', and 'ReadWrite'
        :param pulumi.Input['GalleryArtifactVersionSourceArgs'] source: The gallery artifact version source.
        """
        if host_caching is not None:
            pulumi.set(__self__, "host_caching", host_caching)
        if source is not None:
            pulumi.set(__self__, "source", source)

    @property
    @pulumi.getter(name="hostCaching")
    def host_caching(self) -> Optional[pulumi.Input['HostCaching']]:
        """
        The host caching of the disk. Valid values are 'None', 'ReadOnly', and 'ReadWrite'
        """
        return pulumi.get(self, "host_caching")

    @host_caching.setter
    def host_caching(self, value: Optional[pulumi.Input['HostCaching']]):
        pulumi.set(self, "host_caching", value)

    @property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input['GalleryArtifactVersionSourceArgs']]:
        """
        The gallery artifact version source.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input['GalleryArtifactVersionSourceArgs']]):
        pulumi.set(self, "source", value)


@pulumi.input_type
class GalleryTargetExtendedLocationArgs:
    def __init__(__self__, *,
                 encryption: Optional[pulumi.Input['EncryptionImagesArgs']] = None,
                 extended_location: Optional[pulumi.Input['GalleryExtendedLocationArgs']] = None,
                 extended_location_replica_count: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 storage_account_type: Optional[pulumi.Input[Union[str, 'StorageAccountType']]] = None):
        """
        :param pulumi.Input['EncryptionImagesArgs'] encryption: Optional. Allows users to provide customer managed keys for encrypting the OS and data disks in the gallery artifact.
        :param pulumi.Input['GalleryExtendedLocationArgs'] extended_location: The name of the extended location.
        :param pulumi.Input[int] extended_location_replica_count: The number of replicas of the Image Version to be created per extended location. This property is updatable.
        :param pulumi.Input[str] name: The name of the region.
        :param pulumi.Input[Union[str, 'StorageAccountType']] storage_account_type: Specifies the storage account type to be used to store the image. This property is not updatable.
        """
        if encryption is not None:
            pulumi.set(__self__, "encryption", encryption)
        if extended_location is not None:
            pulumi.set(__self__, "extended_location", extended_location)
        if extended_location_replica_count is not None:
            pulumi.set(__self__, "extended_location_replica_count", extended_location_replica_count)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if storage_account_type is not None:
            pulumi.set(__self__, "storage_account_type", storage_account_type)

    @property
    @pulumi.getter
    def encryption(self) -> Optional[pulumi.Input['EncryptionImagesArgs']]:
        """
        Optional. Allows users to provide customer managed keys for encrypting the OS and data disks in the gallery artifact.
        """
        return pulumi.get(self, "encryption")

    @encryption.setter
    def encryption(self, value: Optional[pulumi.Input['EncryptionImagesArgs']]):
        pulumi.set(self, "encryption", value)

    @property
    @pulumi.getter(name="extendedLocation")
    def extended_location(self) -> Optional[pulumi.Input['GalleryExtendedLocationArgs']]:
        """
        The name of the extended location.
        """
        return pulumi.get(self, "extended_location")

    @extended_location.setter
    def extended_location(self, value: Optional[pulumi.Input['GalleryExtendedLocationArgs']]):
        pulumi.set(self, "extended_location", value)

    @property
    @pulumi.getter(name="extendedLocationReplicaCount")
    def extended_location_replica_count(self) -> Optional[pulumi.Input[int]]:
        """
        The number of replicas of the Image Version to be created per extended location. This property is updatable.
        """
        return pulumi.get(self, "extended_location_replica_count")

    @extended_location_replica_count.setter
    def extended_location_replica_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "extended_location_replica_count", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the region.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="storageAccountType")
    def storage_account_type(self) -> Optional[pulumi.Input[Union[str, 'StorageAccountType']]]:
        """
        Specifies the storage account type to be used to store the image. This property is not updatable.
        """
        return pulumi.get(self, "storage_account_type")

    @storage_account_type.setter
    def storage_account_type(self, value: Optional[pulumi.Input[Union[str, 'StorageAccountType']]]):
        pulumi.set(self, "storage_account_type", value)


@pulumi.input_type
class ImagePurchasePlanArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 product: Optional[pulumi.Input[str]] = None,
                 publisher: Optional[pulumi.Input[str]] = None):
        """
        Describes the gallery image definition purchase plan. This is used by marketplace images.
        :param pulumi.Input[str] name: The plan ID.
        :param pulumi.Input[str] product: The product ID.
        :param pulumi.Input[str] publisher: The publisher ID.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if product is not None:
            pulumi.set(__self__, "product", product)
        if publisher is not None:
            pulumi.set(__self__, "publisher", publisher)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The plan ID.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def product(self) -> Optional[pulumi.Input[str]]:
        """
        The product ID.
        """
        return pulumi.get(self, "product")

    @product.setter
    def product(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "product", value)

    @property
    @pulumi.getter
    def publisher(self) -> Optional[pulumi.Input[str]]:
        """
        The publisher ID.
        """
        return pulumi.get(self, "publisher")

    @publisher.setter
    def publisher(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "publisher", value)


@pulumi.input_type
class OSDiskImageEncryptionArgs:
    def __init__(__self__, *,
                 disk_encryption_set_id: Optional[pulumi.Input[str]] = None,
                 security_profile: Optional[pulumi.Input['OSDiskImageSecurityProfileArgs']] = None):
        """
        Contains encryption settings for an OS disk image.
        :param pulumi.Input[str] disk_encryption_set_id: A relative URI containing the resource ID of the disk encryption set.
        :param pulumi.Input['OSDiskImageSecurityProfileArgs'] security_profile: This property specifies the security profile of an OS disk image.
        """
        if disk_encryption_set_id is not None:
            pulumi.set(__self__, "disk_encryption_set_id", disk_encryption_set_id)
        if security_profile is not None:
            pulumi.set(__self__, "security_profile", security_profile)

    @property
    @pulumi.getter(name="diskEncryptionSetId")
    def disk_encryption_set_id(self) -> Optional[pulumi.Input[str]]:
        """
        A relative URI containing the resource ID of the disk encryption set.
        """
        return pulumi.get(self, "disk_encryption_set_id")

    @disk_encryption_set_id.setter
    def disk_encryption_set_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "disk_encryption_set_id", value)

    @property
    @pulumi.getter(name="securityProfile")
    def security_profile(self) -> Optional[pulumi.Input['OSDiskImageSecurityProfileArgs']]:
        """
        This property specifies the security profile of an OS disk image.
        """
        return pulumi.get(self, "security_profile")

    @security_profile.setter
    def security_profile(self, value: Optional[pulumi.Input['OSDiskImageSecurityProfileArgs']]):
        pulumi.set(self, "security_profile", value)


@pulumi.input_type
class OSDiskImageSecurityProfileArgs:
    def __init__(__self__, *,
                 confidential_vm_encryption_type: Optional[pulumi.Input[Union[str, 'ConfidentialVMEncryptionType']]] = None,
                 secure_vm_disk_encryption_set_id: Optional[pulumi.Input[str]] = None):
        """
        Contains security profile for an OS disk image.
        :param pulumi.Input[Union[str, 'ConfidentialVMEncryptionType']] confidential_vm_encryption_type: confidential VM encryption types
        :param pulumi.Input[str] secure_vm_disk_encryption_set_id: secure VM disk encryption set id
        """
        if confidential_vm_encryption_type is not None:
            pulumi.set(__self__, "confidential_vm_encryption_type", confidential_vm_encryption_type)
        if secure_vm_disk_encryption_set_id is not None:
            pulumi.set(__self__, "secure_vm_disk_encryption_set_id", secure_vm_disk_encryption_set_id)

    @property
    @pulumi.getter(name="confidentialVMEncryptionType")
    def confidential_vm_encryption_type(self) -> Optional[pulumi.Input[Union[str, 'ConfidentialVMEncryptionType']]]:
        """
        confidential VM encryption types
        """
        return pulumi.get(self, "confidential_vm_encryption_type")

    @confidential_vm_encryption_type.setter
    def confidential_vm_encryption_type(self, value: Optional[pulumi.Input[Union[str, 'ConfidentialVMEncryptionType']]]):
        pulumi.set(self, "confidential_vm_encryption_type", value)

    @property
    @pulumi.getter(name="secureVMDiskEncryptionSetId")
    def secure_vm_disk_encryption_set_id(self) -> Optional[pulumi.Input[str]]:
        """
        secure VM disk encryption set id
        """
        return pulumi.get(self, "secure_vm_disk_encryption_set_id")

    @secure_vm_disk_encryption_set_id.setter
    def secure_vm_disk_encryption_set_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secure_vm_disk_encryption_set_id", value)


@pulumi.input_type
class RecommendedMachineConfigurationArgs:
    def __init__(__self__, *,
                 memory: Optional[pulumi.Input['ResourceRangeArgs']] = None,
                 v_cpus: Optional[pulumi.Input['ResourceRangeArgs']] = None):
        """
        The properties describe the recommended machine configuration for this Image Definition. These properties are updatable.
        :param pulumi.Input['ResourceRangeArgs'] memory: Describes the resource range.
        :param pulumi.Input['ResourceRangeArgs'] v_cpus: Describes the resource range.
        """
        if memory is not None:
            pulumi.set(__self__, "memory", memory)
        if v_cpus is not None:
            pulumi.set(__self__, "v_cpus", v_cpus)

    @property
    @pulumi.getter
    def memory(self) -> Optional[pulumi.Input['ResourceRangeArgs']]:
        """
        Describes the resource range.
        """
        return pulumi.get(self, "memory")

    @memory.setter
    def memory(self, value: Optional[pulumi.Input['ResourceRangeArgs']]):
        pulumi.set(self, "memory", value)

    @property
    @pulumi.getter(name="vCPUs")
    def v_cpus(self) -> Optional[pulumi.Input['ResourceRangeArgs']]:
        """
        Describes the resource range.
        """
        return pulumi.get(self, "v_cpus")

    @v_cpus.setter
    def v_cpus(self, value: Optional[pulumi.Input['ResourceRangeArgs']]):
        pulumi.set(self, "v_cpus", value)


@pulumi.input_type
class ResourceRangeArgs:
    def __init__(__self__, *,
                 max: Optional[pulumi.Input[int]] = None,
                 min: Optional[pulumi.Input[int]] = None):
        """
        Describes the resource range.
        :param pulumi.Input[int] max: The maximum number of the resource.
        :param pulumi.Input[int] min: The minimum number of the resource.
        """
        if max is not None:
            pulumi.set(__self__, "max", max)
        if min is not None:
            pulumi.set(__self__, "min", min)

    @property
    @pulumi.getter
    def max(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum number of the resource.
        """
        return pulumi.get(self, "max")

    @max.setter
    def max(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max", value)

    @property
    @pulumi.getter
    def min(self) -> Optional[pulumi.Input[int]]:
        """
        The minimum number of the resource.
        """
        return pulumi.get(self, "min")

    @min.setter
    def min(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min", value)


@pulumi.input_type
class SharingProfileArgs:
    def __init__(__self__, *,
                 community_gallery_info: Optional[pulumi.Input['CommunityGalleryInfoArgs']] = None,
                 permissions: Optional[pulumi.Input[Union[str, 'GallerySharingPermissionTypes']]] = None):
        """
        Profile for gallery sharing to subscription or tenant
        :param pulumi.Input['CommunityGalleryInfoArgs'] community_gallery_info: Information of community gallery if current gallery is shared to community.
        :param pulumi.Input[Union[str, 'GallerySharingPermissionTypes']] permissions: This property allows you to specify the permission of sharing gallery. <br><br> Possible values are: <br><br> **Private** <br><br> **Groups**
        """
        if community_gallery_info is not None:
            pulumi.set(__self__, "community_gallery_info", community_gallery_info)
        if permissions is not None:
            pulumi.set(__self__, "permissions", permissions)

    @property
    @pulumi.getter(name="communityGalleryInfo")
    def community_gallery_info(self) -> Optional[pulumi.Input['CommunityGalleryInfoArgs']]:
        """
        Information of community gallery if current gallery is shared to community.
        """
        return pulumi.get(self, "community_gallery_info")

    @community_gallery_info.setter
    def community_gallery_info(self, value: Optional[pulumi.Input['CommunityGalleryInfoArgs']]):
        pulumi.set(self, "community_gallery_info", value)

    @property
    @pulumi.getter
    def permissions(self) -> Optional[pulumi.Input[Union[str, 'GallerySharingPermissionTypes']]]:
        """
        This property allows you to specify the permission of sharing gallery. <br><br> Possible values are: <br><br> **Private** <br><br> **Groups**
        """
        return pulumi.get(self, "permissions")

    @permissions.setter
    def permissions(self, value: Optional[pulumi.Input[Union[str, 'GallerySharingPermissionTypes']]]):
        pulumi.set(self, "permissions", value)


@pulumi.input_type
class SoftDeletePolicyArgs:
    def __init__(__self__, *,
                 is_soft_delete_enabled: Optional[pulumi.Input[bool]] = None):
        """
        Contains information about the soft deletion policy of the gallery.
        :param pulumi.Input[bool] is_soft_delete_enabled: Enables soft-deletion for resources in this gallery, allowing them to be recovered within retention time.
        """
        if is_soft_delete_enabled is not None:
            pulumi.set(__self__, "is_soft_delete_enabled", is_soft_delete_enabled)

    @property
    @pulumi.getter(name="isSoftDeleteEnabled")
    def is_soft_delete_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Enables soft-deletion for resources in this gallery, allowing them to be recovered within retention time.
        """
        return pulumi.get(self, "is_soft_delete_enabled")

    @is_soft_delete_enabled.setter
    def is_soft_delete_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_soft_delete_enabled", value)


@pulumi.input_type
class TargetRegionArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 encryption: Optional[pulumi.Input['EncryptionImagesArgs']] = None,
                 regional_replica_count: Optional[pulumi.Input[int]] = None,
                 storage_account_type: Optional[pulumi.Input[Union[str, 'StorageAccountType']]] = None):
        """
        Describes the target region information.
        :param pulumi.Input[str] name: The name of the region.
        :param pulumi.Input['EncryptionImagesArgs'] encryption: Optional. Allows users to provide customer managed keys for encrypting the OS and data disks in the gallery artifact.
        :param pulumi.Input[int] regional_replica_count: The number of replicas of the Image Version to be created per region. This property is updatable.
        :param pulumi.Input[Union[str, 'StorageAccountType']] storage_account_type: Specifies the storage account type to be used to store the image. This property is not updatable.
        """
        pulumi.set(__self__, "name", name)
        if encryption is not None:
            pulumi.set(__self__, "encryption", encryption)
        if regional_replica_count is not None:
            pulumi.set(__self__, "regional_replica_count", regional_replica_count)
        if storage_account_type is not None:
            pulumi.set(__self__, "storage_account_type", storage_account_type)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the region.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def encryption(self) -> Optional[pulumi.Input['EncryptionImagesArgs']]:
        """
        Optional. Allows users to provide customer managed keys for encrypting the OS and data disks in the gallery artifact.
        """
        return pulumi.get(self, "encryption")

    @encryption.setter
    def encryption(self, value: Optional[pulumi.Input['EncryptionImagesArgs']]):
        pulumi.set(self, "encryption", value)

    @property
    @pulumi.getter(name="regionalReplicaCount")
    def regional_replica_count(self) -> Optional[pulumi.Input[int]]:
        """
        The number of replicas of the Image Version to be created per region. This property is updatable.
        """
        return pulumi.get(self, "regional_replica_count")

    @regional_replica_count.setter
    def regional_replica_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "regional_replica_count", value)

    @property
    @pulumi.getter(name="storageAccountType")
    def storage_account_type(self) -> Optional[pulumi.Input[Union[str, 'StorageAccountType']]]:
        """
        Specifies the storage account type to be used to store the image. This property is not updatable.
        """
        return pulumi.get(self, "storage_account_type")

    @storage_account_type.setter
    def storage_account_type(self, value: Optional[pulumi.Input[Union[str, 'StorageAccountType']]]):
        pulumi.set(self, "storage_account_type", value)


@pulumi.input_type
class UserArtifactManageArgs:
    def __init__(__self__, *,
                 install: pulumi.Input[str],
                 remove: pulumi.Input[str],
                 update: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] install: Required. The path and arguments to install the gallery application. This is limited to 4096 characters.
        :param pulumi.Input[str] remove: Required. The path and arguments to remove the gallery application. This is limited to 4096 characters.
        :param pulumi.Input[str] update: Optional. The path and arguments to update the gallery application. If not present, then update operation will invoke remove command on the previous version and install command on the current version of the gallery application. This is limited to 4096 characters.
        """
        pulumi.set(__self__, "install", install)
        pulumi.set(__self__, "remove", remove)
        if update is not None:
            pulumi.set(__self__, "update", update)

    @property
    @pulumi.getter
    def install(self) -> pulumi.Input[str]:
        """
        Required. The path and arguments to install the gallery application. This is limited to 4096 characters.
        """
        return pulumi.get(self, "install")

    @install.setter
    def install(self, value: pulumi.Input[str]):
        pulumi.set(self, "install", value)

    @property
    @pulumi.getter
    def remove(self) -> pulumi.Input[str]:
        """
        Required. The path and arguments to remove the gallery application. This is limited to 4096 characters.
        """
        return pulumi.get(self, "remove")

    @remove.setter
    def remove(self, value: pulumi.Input[str]):
        pulumi.set(self, "remove", value)

    @property
    @pulumi.getter
    def update(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The path and arguments to update the gallery application. If not present, then update operation will invoke remove command on the previous version and install command on the current version of the gallery application. This is limited to 4096 characters.
        """
        return pulumi.get(self, "update")

    @update.setter
    def update(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "update", value)


@pulumi.input_type
class UserArtifactSourceArgs:
    def __init__(__self__, *,
                 media_link: pulumi.Input[str],
                 default_configuration_link: Optional[pulumi.Input[str]] = None):
        """
        The source image from which the Image Version is going to be created.
        :param pulumi.Input[str] media_link: Required. The mediaLink of the artifact, must be a readable storage page blob.
        :param pulumi.Input[str] default_configuration_link: Optional. The defaultConfigurationLink of the artifact, must be a readable storage page blob.
        """
        pulumi.set(__self__, "media_link", media_link)
        if default_configuration_link is not None:
            pulumi.set(__self__, "default_configuration_link", default_configuration_link)

    @property
    @pulumi.getter(name="mediaLink")
    def media_link(self) -> pulumi.Input[str]:
        """
        Required. The mediaLink of the artifact, must be a readable storage page blob.
        """
        return pulumi.get(self, "media_link")

    @media_link.setter
    def media_link(self, value: pulumi.Input[str]):
        pulumi.set(self, "media_link", value)

    @property
    @pulumi.getter(name="defaultConfigurationLink")
    def default_configuration_link(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The defaultConfigurationLink of the artifact, must be a readable storage page blob.
        """
        return pulumi.get(self, "default_configuration_link")

    @default_configuration_link.setter
    def default_configuration_link(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "default_configuration_link", value)


