# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = ['PublishedBlueprintArgs', 'PublishedBlueprint']

@pulumi.input_type
class PublishedBlueprintArgs:
    def __init__(__self__, *,
                 blueprint_name: pulumi.Input[str],
                 management_group_name: pulumi.Input[str],
                 version_id: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a PublishedBlueprint resource.
        :param pulumi.Input[str] blueprint_name: name of the blueprint.
        :param pulumi.Input[str] management_group_name: ManagementGroup where blueprint stores.
        :param pulumi.Input[str] version_id: version of the published blueprint.
        """
        pulumi.set(__self__, "blueprint_name", blueprint_name)
        pulumi.set(__self__, "management_group_name", management_group_name)
        if version_id is not None:
            pulumi.set(__self__, "version_id", version_id)

    @property
    @pulumi.getter(name="blueprintName")
    def blueprint_name(self) -> pulumi.Input[str]:
        """
        name of the blueprint.
        """
        return pulumi.get(self, "blueprint_name")

    @blueprint_name.setter
    def blueprint_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "blueprint_name", value)

    @property
    @pulumi.getter(name="managementGroupName")
    def management_group_name(self) -> pulumi.Input[str]:
        """
        ManagementGroup where blueprint stores.
        """
        return pulumi.get(self, "management_group_name")

    @management_group_name.setter
    def management_group_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "management_group_name", value)

    @property
    @pulumi.getter(name="versionId")
    def version_id(self) -> Optional[pulumi.Input[str]]:
        """
        version of the published blueprint.
        """
        return pulumi.get(self, "version_id")

    @version_id.setter
    def version_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version_id", value)


warnings.warn("""Version 2017-11-11-preview will be removed in v2 of the provider.""", DeprecationWarning)


class PublishedBlueprint(pulumi.CustomResource):
    warnings.warn("""Version 2017-11-11-preview will be removed in v2 of the provider.""", DeprecationWarning)

    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 blueprint_name: Optional[pulumi.Input[str]] = None,
                 management_group_name: Optional[pulumi.Input[str]] = None,
                 version_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Represents a published Blueprint.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] blueprint_name: name of the blueprint.
        :param pulumi.Input[str] management_group_name: ManagementGroup where blueprint stores.
        :param pulumi.Input[str] version_id: version of the published blueprint.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PublishedBlueprintArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Represents a published Blueprint.

        :param str resource_name: The name of the resource.
        :param PublishedBlueprintArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PublishedBlueprintArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 blueprint_name: Optional[pulumi.Input[str]] = None,
                 management_group_name: Optional[pulumi.Input[str]] = None,
                 version_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        pulumi.log.warn("""PublishedBlueprint is deprecated: Version 2017-11-11-preview will be removed in v2 of the provider.""")
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PublishedBlueprintArgs.__new__(PublishedBlueprintArgs)

            if blueprint_name is None and not opts.urn:
                raise TypeError("Missing required property 'blueprint_name'")
            __props__.__dict__["blueprint_name"] = blueprint_name
            if management_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'management_group_name'")
            __props__.__dict__["management_group_name"] = management_group_name
            __props__.__dict__["version_id"] = version_id
            __props__.__dict__["change_notes"] = None
            __props__.__dict__["description"] = None
            __props__.__dict__["display_name"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["parameters"] = None
            __props__.__dict__["resource_groups"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["target_scope"] = None
            __props__.__dict__["type"] = None
        super(PublishedBlueprint, __self__).__init__(
            'azure-native:blueprint/v20171111preview:PublishedBlueprint',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'PublishedBlueprint':
        """
        Get an existing PublishedBlueprint resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = PublishedBlueprintArgs.__new__(PublishedBlueprintArgs)

        __props__.__dict__["blueprint_name"] = None
        __props__.__dict__["change_notes"] = None
        __props__.__dict__["description"] = None
        __props__.__dict__["display_name"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["parameters"] = None
        __props__.__dict__["resource_groups"] = None
        __props__.__dict__["status"] = None
        __props__.__dict__["target_scope"] = None
        __props__.__dict__["type"] = None
        return PublishedBlueprint(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="blueprintName")
    def blueprint_name(self) -> pulumi.Output[Optional[str]]:
        """
        Name of the Blueprint definition.
        """
        return pulumi.get(self, "blueprint_name")

    @property
    @pulumi.getter(name="changeNotes")
    def change_notes(self) -> pulumi.Output[Optional[str]]:
        """
        Version-specific change notes
        """
        return pulumi.get(self, "change_notes")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Multi-line explain this resource.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[Optional[str]]:
        """
        One-liner string explain this resource.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of this resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def parameters(self) -> pulumi.Output[Optional[Mapping[str, 'outputs.ParameterDefinitionResponse']]]:
        """
        Parameters required by this Blueprint definition.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter(name="resourceGroups")
    def resource_groups(self) -> pulumi.Output[Optional[Mapping[str, 'outputs.ResourceGroupDefinitionResponse']]]:
        """
        Resource group placeholders defined by this Blueprint definition.
        """
        return pulumi.get(self, "resource_groups")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output['outputs.BlueprintStatusResponse']:
        """
        Status of the Blueprint. This field is readonly.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="targetScope")
    def target_scope(self) -> pulumi.Output[Optional[str]]:
        """
        The scope where this Blueprint can be applied.
        """
        return pulumi.get(self, "target_scope")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        Type of this resource.
        """
        return pulumi.get(self, "type")

