# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'DatabaseVulnerabilityAssessmentRuleBaselineItemResponse',
    'ElasticPoolPerDatabaseSettingsResponse',
    'InstanceFailoverGroupReadOnlyEndpointResponse',
    'InstanceFailoverGroupReadWriteEndpointResponse',
    'ManagedInstancePairInfoResponse',
    'PartnerRegionInfoResponse',
    'SkuResponse',
    'VulnerabilityAssessmentRecurringScansPropertiesResponse',
]

@pulumi.output_type
class DatabaseVulnerabilityAssessmentRuleBaselineItemResponse(dict):
    """
    Properties for an Azure SQL Database Vulnerability Assessment rule baseline's result.
    """
    def __init__(__self__, *,
                 result: Sequence[str]):
        """
        Properties for an Azure SQL Database Vulnerability Assessment rule baseline's result.
        :param Sequence[str] result: The rule baseline result
        """
        pulumi.set(__self__, "result", result)

    @property
    @pulumi.getter
    def result(self) -> Sequence[str]:
        """
        The rule baseline result
        """
        return pulumi.get(self, "result")


@pulumi.output_type
class ElasticPoolPerDatabaseSettingsResponse(dict):
    """
    Per database settings of an elastic pool.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxCapacity":
            suggest = "max_capacity"
        elif key == "minCapacity":
            suggest = "min_capacity"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ElasticPoolPerDatabaseSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ElasticPoolPerDatabaseSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ElasticPoolPerDatabaseSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_capacity: Optional[float] = None,
                 min_capacity: Optional[float] = None):
        """
        Per database settings of an elastic pool.
        :param float max_capacity: The maximum capacity any one database can consume.
        :param float min_capacity: The minimum capacity all databases are guaranteed.
        """
        if max_capacity is not None:
            pulumi.set(__self__, "max_capacity", max_capacity)
        if min_capacity is not None:
            pulumi.set(__self__, "min_capacity", min_capacity)

    @property
    @pulumi.getter(name="maxCapacity")
    def max_capacity(self) -> Optional[float]:
        """
        The maximum capacity any one database can consume.
        """
        return pulumi.get(self, "max_capacity")

    @property
    @pulumi.getter(name="minCapacity")
    def min_capacity(self) -> Optional[float]:
        """
        The minimum capacity all databases are guaranteed.
        """
        return pulumi.get(self, "min_capacity")


@pulumi.output_type
class InstanceFailoverGroupReadOnlyEndpointResponse(dict):
    """
    Read-only endpoint of the failover group instance.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "failoverPolicy":
            suggest = "failover_policy"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceFailoverGroupReadOnlyEndpointResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceFailoverGroupReadOnlyEndpointResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceFailoverGroupReadOnlyEndpointResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 failover_policy: Optional[str] = None):
        """
        Read-only endpoint of the failover group instance.
        :param str failover_policy: Failover policy of the read-only endpoint for the failover group.
        """
        if failover_policy is not None:
            pulumi.set(__self__, "failover_policy", failover_policy)

    @property
    @pulumi.getter(name="failoverPolicy")
    def failover_policy(self) -> Optional[str]:
        """
        Failover policy of the read-only endpoint for the failover group.
        """
        return pulumi.get(self, "failover_policy")


@pulumi.output_type
class InstanceFailoverGroupReadWriteEndpointResponse(dict):
    """
    Read-write endpoint of the failover group instance.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "failoverPolicy":
            suggest = "failover_policy"
        elif key == "failoverWithDataLossGracePeriodMinutes":
            suggest = "failover_with_data_loss_grace_period_minutes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceFailoverGroupReadWriteEndpointResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceFailoverGroupReadWriteEndpointResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceFailoverGroupReadWriteEndpointResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 failover_policy: str,
                 failover_with_data_loss_grace_period_minutes: Optional[int] = None):
        """
        Read-write endpoint of the failover group instance.
        :param str failover_policy: Failover policy of the read-write endpoint for the failover group. If failoverPolicy is Automatic then failoverWithDataLossGracePeriodMinutes is required.
        :param int failover_with_data_loss_grace_period_minutes: Grace period before failover with data loss is attempted for the read-write endpoint. If failoverPolicy is Automatic then failoverWithDataLossGracePeriodMinutes is required.
        """
        pulumi.set(__self__, "failover_policy", failover_policy)
        if failover_with_data_loss_grace_period_minutes is not None:
            pulumi.set(__self__, "failover_with_data_loss_grace_period_minutes", failover_with_data_loss_grace_period_minutes)

    @property
    @pulumi.getter(name="failoverPolicy")
    def failover_policy(self) -> str:
        """
        Failover policy of the read-write endpoint for the failover group. If failoverPolicy is Automatic then failoverWithDataLossGracePeriodMinutes is required.
        """
        return pulumi.get(self, "failover_policy")

    @property
    @pulumi.getter(name="failoverWithDataLossGracePeriodMinutes")
    def failover_with_data_loss_grace_period_minutes(self) -> Optional[int]:
        """
        Grace period before failover with data loss is attempted for the read-write endpoint. If failoverPolicy is Automatic then failoverWithDataLossGracePeriodMinutes is required.
        """
        return pulumi.get(self, "failover_with_data_loss_grace_period_minutes")


@pulumi.output_type
class ManagedInstancePairInfoResponse(dict):
    """
    Pairs of Managed Instances in the failover group.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "partnerManagedInstanceId":
            suggest = "partner_managed_instance_id"
        elif key == "primaryManagedInstanceId":
            suggest = "primary_managed_instance_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagedInstancePairInfoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagedInstancePairInfoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagedInstancePairInfoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 partner_managed_instance_id: Optional[str] = None,
                 primary_managed_instance_id: Optional[str] = None):
        """
        Pairs of Managed Instances in the failover group.
        :param str partner_managed_instance_id: Id of Partner Managed Instance in pair.
        :param str primary_managed_instance_id: Id of Primary Managed Instance in pair.
        """
        if partner_managed_instance_id is not None:
            pulumi.set(__self__, "partner_managed_instance_id", partner_managed_instance_id)
        if primary_managed_instance_id is not None:
            pulumi.set(__self__, "primary_managed_instance_id", primary_managed_instance_id)

    @property
    @pulumi.getter(name="partnerManagedInstanceId")
    def partner_managed_instance_id(self) -> Optional[str]:
        """
        Id of Partner Managed Instance in pair.
        """
        return pulumi.get(self, "partner_managed_instance_id")

    @property
    @pulumi.getter(name="primaryManagedInstanceId")
    def primary_managed_instance_id(self) -> Optional[str]:
        """
        Id of Primary Managed Instance in pair.
        """
        return pulumi.get(self, "primary_managed_instance_id")


@pulumi.output_type
class PartnerRegionInfoResponse(dict):
    """
    Partner region information for the failover group.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "replicationRole":
            suggest = "replication_role"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PartnerRegionInfoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PartnerRegionInfoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PartnerRegionInfoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 replication_role: str,
                 location: Optional[str] = None):
        """
        Partner region information for the failover group.
        :param str replication_role: Replication role of the partner managed instances.
        :param str location: Geo location of the partner managed instances.
        """
        pulumi.set(__self__, "replication_role", replication_role)
        if location is not None:
            pulumi.set(__self__, "location", location)

    @property
    @pulumi.getter(name="replicationRole")
    def replication_role(self) -> str:
        """
        Replication role of the partner managed instances.
        """
        return pulumi.get(self, "replication_role")

    @property
    @pulumi.getter
    def location(self) -> Optional[str]:
        """
        Geo location of the partner managed instances.
        """
        return pulumi.get(self, "location")


@pulumi.output_type
class SkuResponse(dict):
    """
    An ARM Resource SKU.
    """
    def __init__(__self__, *,
                 name: str,
                 capacity: Optional[int] = None,
                 family: Optional[str] = None,
                 size: Optional[str] = None,
                 tier: Optional[str] = None):
        """
        An ARM Resource SKU.
        :param str name: The name of the SKU, typically, a letter + Number code, e.g. P3.
        :param int capacity: Capacity of the particular SKU.
        :param str family: If the service has different generations of hardware, for the same SKU, then that can be captured here.
        :param str size: Size of the particular SKU
        :param str tier: The tier or edition of the particular SKU, e.g. Basic, Premium.
        """
        pulumi.set(__self__, "name", name)
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)
        if family is not None:
            pulumi.set(__self__, "family", family)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if tier is not None:
            pulumi.set(__self__, "tier", tier)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the SKU, typically, a letter + Number code, e.g. P3.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def capacity(self) -> Optional[int]:
        """
        Capacity of the particular SKU.
        """
        return pulumi.get(self, "capacity")

    @property
    @pulumi.getter
    def family(self) -> Optional[str]:
        """
        If the service has different generations of hardware, for the same SKU, then that can be captured here.
        """
        return pulumi.get(self, "family")

    @property
    @pulumi.getter
    def size(self) -> Optional[str]:
        """
        Size of the particular SKU
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter
    def tier(self) -> Optional[str]:
        """
        The tier or edition of the particular SKU, e.g. Basic, Premium.
        """
        return pulumi.get(self, "tier")


@pulumi.output_type
class VulnerabilityAssessmentRecurringScansPropertiesResponse(dict):
    """
    Properties of a Vulnerability Assessment recurring scans.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "emailSubscriptionAdmins":
            suggest = "email_subscription_admins"
        elif key == "isEnabled":
            suggest = "is_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VulnerabilityAssessmentRecurringScansPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VulnerabilityAssessmentRecurringScansPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VulnerabilityAssessmentRecurringScansPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 email_subscription_admins: Optional[bool] = None,
                 emails: Optional[Sequence[str]] = None,
                 is_enabled: Optional[bool] = None):
        """
        Properties of a Vulnerability Assessment recurring scans.
        :param bool email_subscription_admins: Specifies that the schedule scan notification will be is sent to the subscription administrators.
        :param Sequence[str] emails: Specifies an array of e-mail addresses to which the scan notification is sent.
        :param bool is_enabled: Recurring scans state.
        """
        if email_subscription_admins is None:
            email_subscription_admins = True
        if email_subscription_admins is not None:
            pulumi.set(__self__, "email_subscription_admins", email_subscription_admins)
        if emails is not None:
            pulumi.set(__self__, "emails", emails)
        if is_enabled is not None:
            pulumi.set(__self__, "is_enabled", is_enabled)

    @property
    @pulumi.getter(name="emailSubscriptionAdmins")
    def email_subscription_admins(self) -> Optional[bool]:
        """
        Specifies that the schedule scan notification will be is sent to the subscription administrators.
        """
        return pulumi.get(self, "email_subscription_admins")

    @property
    @pulumi.getter
    def emails(self) -> Optional[Sequence[str]]:
        """
        Specifies an array of e-mail addresses to which the scan notification is sent.
        """
        return pulumi.get(self, "emails")

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> Optional[bool]:
        """
        Recurring scans state.
        """
        return pulumi.get(self, "is_enabled")


