# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'AadAuthenticationParametersArgs',
    'AddressSpaceArgs',
    'ApplicationGatewayAuthenticationCertificateArgs',
    'ApplicationGatewayAutoscaleConfigurationArgs',
    'ApplicationGatewayBackendAddressPoolArgs',
    'ApplicationGatewayBackendAddressArgs',
    'ApplicationGatewayBackendHttpSettingsArgs',
    'ApplicationGatewayConnectionDrainingArgs',
    'ApplicationGatewayCustomErrorArgs',
    'ApplicationGatewayFirewallDisabledRuleGroupArgs',
    'ApplicationGatewayFirewallExclusionArgs',
    'ApplicationGatewayFrontendIPConfigurationArgs',
    'ApplicationGatewayFrontendPortArgs',
    'ApplicationGatewayHeaderConfigurationArgs',
    'ApplicationGatewayHttpListenerArgs',
    'ApplicationGatewayIPConfigurationArgs',
    'ApplicationGatewayPathRuleArgs',
    'ApplicationGatewayPrivateLinkConfigurationArgs',
    'ApplicationGatewayPrivateLinkIpConfigurationArgs',
    'ApplicationGatewayProbeHealthResponseMatch',
    'ApplicationGatewayProbeHealthResponseMatchArgs',
    'ApplicationGatewayProbeArgs',
    'ApplicationGatewayRedirectConfigurationArgs',
    'ApplicationGatewayRequestRoutingRuleArgs',
    'ApplicationGatewayRewriteRuleActionSetArgs',
    'ApplicationGatewayRewriteRuleConditionArgs',
    'ApplicationGatewayRewriteRuleSetArgs',
    'ApplicationGatewayRewriteRuleArgs',
    'ApplicationGatewaySkuArgs',
    'ApplicationGatewaySslCertificateArgs',
    'ApplicationGatewaySslPolicyArgs',
    'ApplicationGatewayTrustedRootCertificateArgs',
    'ApplicationGatewayUrlConfigurationArgs',
    'ApplicationGatewayUrlPathMapArgs',
    'ApplicationGatewayWebApplicationFirewallConfigurationArgs',
    'ApplicationRuleArgs',
    'ApplicationSecurityGroupArgs',
    'AzureFirewallApplicationRuleCollectionArgs',
    'AzureFirewallApplicationRuleProtocolArgs',
    'AzureFirewallApplicationRuleArgs',
    'AzureFirewallIPConfigurationArgs',
    'AzureFirewallNatRCActionArgs',
    'AzureFirewallNatRuleCollectionArgs',
    'AzureFirewallNatRuleArgs',
    'AzureFirewallNetworkRuleCollectionArgs',
    'AzureFirewallNetworkRuleArgs',
    'AzureFirewallPublicIPAddressArgs',
    'AzureFirewallRCActionArgs',
    'AzureFirewallSkuArgs',
    'BackendAddressPoolArgs',
    'BackendPoolsSettingsArgs',
    'BackendPoolArgs',
    'BackendArgs',
    'BastionHostIPConfigurationArgs',
    'BastionShareableLink',
    'BgpSettingsArgs',
    'BreakOutCategoryPoliciesArgs',
    'CacheConfigurationArgs',
    'ConnectionMonitorDestinationArgs',
    'ConnectionMonitorEndpointFilterItemArgs',
    'ConnectionMonitorEndpointFilterArgs',
    'ConnectionMonitorEndpointArgs',
    'ConnectionMonitorHttpConfigurationArgs',
    'ConnectionMonitorIcmpConfigurationArgs',
    'ConnectionMonitorOutputArgs',
    'ConnectionMonitorSourceArgs',
    'ConnectionMonitorSuccessThresholdArgs',
    'ConnectionMonitorTcpConfigurationArgs',
    'ConnectionMonitorTestConfigurationArgs',
    'ConnectionMonitorTestGroupArgs',
    'ConnectionMonitorWorkspaceSettingsArgs',
    'ContainerNetworkInterfaceConfigurationArgs',
    'CustomDnsConfigPropertiesFormatArgs',
    'DdosSettingsArgs',
    'DelegationArgs',
    'DevicePropertiesArgs',
    'DhcpOptionsArgs',
    'DnsSettingsArgs',
    'ExpressRouteCircuitAuthorizationArgs',
    'ExpressRouteCircuitConnectionArgs',
    'ExpressRouteCircuitPeeringConfigArgs',
    'ExpressRouteCircuitPeeringIdArgs',
    'ExpressRouteCircuitPeeringArgs',
    'ExpressRouteCircuitServiceProviderPropertiesArgs',
    'ExpressRouteCircuitSkuArgs',
    'ExpressRouteCircuitStatsArgs',
    'ExpressRouteGatewayPropertiesAutoScaleConfigurationArgs',
    'ExpressRouteGatewayPropertiesBoundsArgs',
    'ExpressRouteLinkMacSecConfigArgs',
    'ExpressRouteLinkArgs',
    'FirewallPolicyFilterRuleCollectionActionArgs',
    'FirewallPolicyFilterRuleCollectionArgs',
    'FirewallPolicyNatRuleCollectionActionArgs',
    'FirewallPolicyNatRuleCollectionArgs',
    'FirewallPolicyRuleApplicationProtocolArgs',
    'FirewallPolicyThreatIntelWhitelistArgs',
    'FlowLogFormatParametersArgs',
    'ForwardingConfigurationArgs',
    'FrontendEndpointUpdateParametersWebApplicationFirewallPolicyLinkArgs',
    'FrontendEndpointArgs',
    'FrontendIPConfigurationArgs',
    'HTTPHeaderArgs',
    'HeaderActionArgs',
    'HealthProbeSettingsModelArgs',
    'HubIPAddressesArgs',
    'HubPublicIPAddressesArgs',
    'HubRouteArgs',
    'IPConfigurationBgpPeeringAddressArgs',
    'IPConfigurationProfileArgs',
    'InboundNatPoolArgs',
    'InboundNatRuleArgs',
    'IpTagArgs',
    'IpsecPolicyArgs',
    'Ipv6CircuitConnectionConfigArgs',
    'Ipv6ExpressRouteCircuitPeeringConfigArgs',
    'LoadBalancerBackendAddressArgs',
    'LoadBalancerSkuArgs',
    'LoadBalancingRuleArgs',
    'LoadBalancingSettingsModelArgs',
    'LocalNetworkGatewayArgs',
    'ManagedRuleGroupOverrideArgs',
    'ManagedRuleOverrideArgs',
    'ManagedRuleSetArgs',
    'ManagedRulesDefinitionArgs',
    'ManagedServiceIdentityArgs',
    'MatchConditionArgs',
    'MatchVariableArgs',
    'NatGatewaySkuArgs',
    'NatRuleArgs',
    'NetworkInterfaceDnsSettingsArgs',
    'NetworkInterfaceIPConfigurationArgs',
    'NetworkRuleArgs',
    'NetworkSecurityGroupArgs',
    'Office365PolicyPropertiesArgs',
    'OutboundRuleArgs',
    'OwaspCrsExclusionEntryArgs',
    'P2SConnectionConfigurationArgs',
    'PacketCaptureFilterArgs',
    'PacketCaptureStorageLocationArgs',
    'PolicySettingsArgs',
    'PrivateDnsZoneConfigArgs',
    'PrivateLinkServiceConnectionStateArgs',
    'PrivateLinkServiceConnectionArgs',
    'PrivateLinkServiceIpConfigurationArgs',
    'PrivateLinkServicePropertiesAutoApprovalArgs',
    'PrivateLinkServicePropertiesVisibilityArgs',
    'ProbeArgs',
    'PropagatedRouteTableArgs',
    'ProtocolCustomSettingsFormatArgs',
    'PublicIPAddressDnsSettingsArgs',
    'PublicIPAddressSkuArgs',
    'PublicIPAddressArgs',
    'PublicIPPrefixSkuArgs',
    'RadiusServerArgs',
    'RedirectConfigurationArgs',
    'RetentionPolicyParametersArgs',
    'RouteFilterRuleArgs',
    'RouteTableArgs',
    'RouteArgs',
    'RoutingConfigurationArgs',
    'RoutingRuleUpdateParametersWebApplicationFirewallPolicyLinkArgs',
    'RoutingRuleArgs',
    'RulesEngineActionArgs',
    'RulesEngineMatchConditionArgs',
    'RulesEngineRuleArgs',
    'SecurityRuleArgs',
    'ServiceEndpointPolicyDefinitionArgs',
    'ServiceEndpointPolicyArgs',
    'ServiceEndpointPropertiesFormatArgs',
    'StaticRouteArgs',
    'SubResource',
    'SubResourceArgs',
    'SubnetArgs',
    'TrafficAnalyticsConfigurationPropertiesArgs',
    'TrafficAnalyticsPropertiesArgs',
    'TrafficSelectorPolicyArgs',
    'VM',
    'VirtualApplianceSkuPropertiesArgs',
    'VirtualHubIdArgs',
    'VirtualHubRouteTableV2Args',
    'VirtualHubRouteTableArgs',
    'VirtualHubRouteV2Args',
    'VirtualHubRouteArgs',
    'VirtualNetworkBgpCommunitiesArgs',
    'VirtualNetworkGatewayIPConfigurationArgs',
    'VirtualNetworkGatewaySkuArgs',
    'VirtualNetworkGatewayArgs',
    'VirtualNetworkPeeringArgs',
    'VirtualNetworkTapArgs',
    'VnetRouteArgs',
    'VpnClientConfigurationArgs',
    'VpnClientRevokedCertificateArgs',
    'VpnClientRootCertificateArgs',
    'VpnConnectionArgs',
    'VpnLinkBgpSettingsArgs',
    'VpnLinkProviderPropertiesArgs',
    'VpnServerConfigRadiusClientRootCertificateArgs',
    'VpnServerConfigRadiusServerRootCertificateArgs',
    'VpnServerConfigVpnClientRevokedCertificateArgs',
    'VpnServerConfigVpnClientRootCertificateArgs',
    'VpnSiteLinkConnectionArgs',
    'VpnSiteLinkArgs',
    'WebApplicationFirewallCustomRuleArgs',
]

@pulumi.input_type
class AadAuthenticationParametersArgs:
    def __init__(__self__, *,
                 aad_audience: Optional[pulumi.Input[str]] = None,
                 aad_issuer: Optional[pulumi.Input[str]] = None,
                 aad_tenant: Optional[pulumi.Input[str]] = None):
        """
        AAD Vpn authentication type related parameters.
        :param pulumi.Input[str] aad_audience: AAD Vpn authentication parameter AAD audience.
        :param pulumi.Input[str] aad_issuer: AAD Vpn authentication parameter AAD issuer.
        :param pulumi.Input[str] aad_tenant: AAD Vpn authentication parameter AAD tenant.
        """
        if aad_audience is not None:
            pulumi.set(__self__, "aad_audience", aad_audience)
        if aad_issuer is not None:
            pulumi.set(__self__, "aad_issuer", aad_issuer)
        if aad_tenant is not None:
            pulumi.set(__self__, "aad_tenant", aad_tenant)

    @property
    @pulumi.getter(name="aadAudience")
    def aad_audience(self) -> Optional[pulumi.Input[str]]:
        """
        AAD Vpn authentication parameter AAD audience.
        """
        return pulumi.get(self, "aad_audience")

    @aad_audience.setter
    def aad_audience(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "aad_audience", value)

    @property
    @pulumi.getter(name="aadIssuer")
    def aad_issuer(self) -> Optional[pulumi.Input[str]]:
        """
        AAD Vpn authentication parameter AAD issuer.
        """
        return pulumi.get(self, "aad_issuer")

    @aad_issuer.setter
    def aad_issuer(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "aad_issuer", value)

    @property
    @pulumi.getter(name="aadTenant")
    def aad_tenant(self) -> Optional[pulumi.Input[str]]:
        """
        AAD Vpn authentication parameter AAD tenant.
        """
        return pulumi.get(self, "aad_tenant")

    @aad_tenant.setter
    def aad_tenant(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "aad_tenant", value)


@pulumi.input_type
class AddressSpaceArgs:
    def __init__(__self__, *,
                 address_prefixes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        AddressSpace contains an array of IP address ranges that can be used by subnets of the virtual network.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] address_prefixes: A list of address blocks reserved for this virtual network in CIDR notation.
        """
        if address_prefixes is not None:
            pulumi.set(__self__, "address_prefixes", address_prefixes)

    @property
    @pulumi.getter(name="addressPrefixes")
    def address_prefixes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of address blocks reserved for this virtual network in CIDR notation.
        """
        return pulumi.get(self, "address_prefixes")

    @address_prefixes.setter
    def address_prefixes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "address_prefixes", value)


@pulumi.input_type
class ApplicationGatewayAuthenticationCertificateArgs:
    def __init__(__self__, *,
                 data: Optional[pulumi.Input[str]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        Authentication certificates of an application gateway.
        :param pulumi.Input[str] data: Certificate public data.
        :param pulumi.Input[str] id: Resource ID.
        :param pulumi.Input[str] name: Name of the authentication certificate that is unique within an Application Gateway.
        """
        if data is not None:
            pulumi.set(__self__, "data", data)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def data(self) -> Optional[pulumi.Input[str]]:
        """
        Certificate public data.
        """
        return pulumi.get(self, "data")

    @data.setter
    def data(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "data", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the authentication certificate that is unique within an Application Gateway.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class ApplicationGatewayAutoscaleConfigurationArgs:
    def __init__(__self__, *,
                 min_capacity: pulumi.Input[int],
                 max_capacity: Optional[pulumi.Input[int]] = None):
        """
        Application Gateway autoscale configuration.
        :param pulumi.Input[int] min_capacity: Lower bound on number of Application Gateway capacity.
        :param pulumi.Input[int] max_capacity: Upper bound on number of Application Gateway capacity.
        """
        pulumi.set(__self__, "min_capacity", min_capacity)
        if max_capacity is not None:
            pulumi.set(__self__, "max_capacity", max_capacity)

    @property
    @pulumi.getter(name="minCapacity")
    def min_capacity(self) -> pulumi.Input[int]:
        """
        Lower bound on number of Application Gateway capacity.
        """
        return pulumi.get(self, "min_capacity")

    @min_capacity.setter
    def min_capacity(self, value: pulumi.Input[int]):
        pulumi.set(self, "min_capacity", value)

    @property
    @pulumi.getter(name="maxCapacity")
    def max_capacity(self) -> Optional[pulumi.Input[int]]:
        """
        Upper bound on number of Application Gateway capacity.
        """
        return pulumi.get(self, "max_capacity")

    @max_capacity.setter
    def max_capacity(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_capacity", value)


@pulumi.input_type
class ApplicationGatewayBackendAddressPoolArgs:
    def __init__(__self__, *,
                 backend_addresses: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayBackendAddressArgs']]]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        Backend Address Pool of an application gateway.
        :param pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayBackendAddressArgs']]] backend_addresses: Backend addresses.
        :param pulumi.Input[str] id: Resource ID.
        :param pulumi.Input[str] name: Name of the backend address pool that is unique within an Application Gateway.
        """
        if backend_addresses is not None:
            pulumi.set(__self__, "backend_addresses", backend_addresses)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="backendAddresses")
    def backend_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayBackendAddressArgs']]]]:
        """
        Backend addresses.
        """
        return pulumi.get(self, "backend_addresses")

    @backend_addresses.setter
    def backend_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayBackendAddressArgs']]]]):
        pulumi.set(self, "backend_addresses", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the backend address pool that is unique within an Application Gateway.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class ApplicationGatewayBackendAddressArgs:
    def __init__(__self__, *,
                 fqdn: Optional[pulumi.Input[str]] = None,
                 ip_address: Optional[pulumi.Input[str]] = None):
        """
        Backend address of an application gateway.
        :param pulumi.Input[str] fqdn: Fully qualified domain name (FQDN).
        :param pulumi.Input[str] ip_address: IP address.
        """
        if fqdn is not None:
            pulumi.set(__self__, "fqdn", fqdn)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)

    @property
    @pulumi.getter
    def fqdn(self) -> Optional[pulumi.Input[str]]:
        """
        Fully qualified domain name (FQDN).
        """
        return pulumi.get(self, "fqdn")

    @fqdn.setter
    def fqdn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fqdn", value)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[pulumi.Input[str]]:
        """
        IP address.
        """
        return pulumi.get(self, "ip_address")

    @ip_address.setter
    def ip_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip_address", value)


@pulumi.input_type
class ApplicationGatewayBackendHttpSettingsArgs:
    def __init__(__self__, *,
                 affinity_cookie_name: Optional[pulumi.Input[str]] = None,
                 authentication_certificates: Optional[pulumi.Input[Sequence[pulumi.Input['SubResourceArgs']]]] = None,
                 connection_draining: Optional[pulumi.Input['ApplicationGatewayConnectionDrainingArgs']] = None,
                 cookie_based_affinity: Optional[pulumi.Input[Union[str, 'ApplicationGatewayCookieBasedAffinity']]] = None,
                 host_name: Optional[pulumi.Input[str]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 path: Optional[pulumi.Input[str]] = None,
                 pick_host_name_from_backend_address: Optional[pulumi.Input[bool]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 probe: Optional[pulumi.Input['SubResourceArgs']] = None,
                 probe_enabled: Optional[pulumi.Input[bool]] = None,
                 protocol: Optional[pulumi.Input[Union[str, 'ApplicationGatewayProtocol']]] = None,
                 request_timeout: Optional[pulumi.Input[int]] = None,
                 trusted_root_certificates: Optional[pulumi.Input[Sequence[pulumi.Input['SubResourceArgs']]]] = None):
        """
        Backend address pool settings of an application gateway.
        :param pulumi.Input[str] affinity_cookie_name: Cookie name to use for the affinity cookie.
        :param pulumi.Input[Sequence[pulumi.Input['SubResourceArgs']]] authentication_certificates: Array of references to application gateway authentication certificates.
        :param pulumi.Input['ApplicationGatewayConnectionDrainingArgs'] connection_draining: Connection draining of the backend http settings resource.
        :param pulumi.Input[Union[str, 'ApplicationGatewayCookieBasedAffinity']] cookie_based_affinity: Cookie based affinity.
        :param pulumi.Input[str] host_name: Host header to be sent to the backend servers.
        :param pulumi.Input[str] id: Resource ID.
        :param pulumi.Input[str] name: Name of the backend http settings that is unique within an Application Gateway.
        :param pulumi.Input[str] path: Path which should be used as a prefix for all HTTP requests. Null means no path will be prefixed. Default value is null.
        :param pulumi.Input[bool] pick_host_name_from_backend_address: Whether to pick host header should be picked from the host name of the backend server. Default value is false.
        :param pulumi.Input[int] port: The destination port on the backend.
        :param pulumi.Input['SubResourceArgs'] probe: Probe resource of an application gateway.
        :param pulumi.Input[bool] probe_enabled: Whether the probe is enabled. Default value is false.
        :param pulumi.Input[Union[str, 'ApplicationGatewayProtocol']] protocol: The protocol used to communicate with the backend.
        :param pulumi.Input[int] request_timeout: Request timeout in seconds. Application Gateway will fail the request if response is not received within RequestTimeout. Acceptable values are from 1 second to 86400 seconds.
        :param pulumi.Input[Sequence[pulumi.Input['SubResourceArgs']]] trusted_root_certificates: Array of references to application gateway trusted root certificates.
        """
        if affinity_cookie_name is not None:
            pulumi.set(__self__, "affinity_cookie_name", affinity_cookie_name)
        if authentication_certificates is not None:
            pulumi.set(__self__, "authentication_certificates", authentication_certificates)
        if connection_draining is not None:
            pulumi.set(__self__, "connection_draining", connection_draining)
        if cookie_based_affinity is not None:
            pulumi.set(__self__, "cookie_based_affinity", cookie_based_affinity)
        if host_name is not None:
            pulumi.set(__self__, "host_name", host_name)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if pick_host_name_from_backend_address is not None:
            pulumi.set(__self__, "pick_host_name_from_backend_address", pick_host_name_from_backend_address)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if probe is not None:
            pulumi.set(__self__, "probe", probe)
        if probe_enabled is not None:
            pulumi.set(__self__, "probe_enabled", probe_enabled)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if request_timeout is not None:
            pulumi.set(__self__, "request_timeout", request_timeout)
        if trusted_root_certificates is not None:
            pulumi.set(__self__, "trusted_root_certificates", trusted_root_certificates)

    @property
    @pulumi.getter(name="affinityCookieName")
    def affinity_cookie_name(self) -> Optional[pulumi.Input[str]]:
        """
        Cookie name to use for the affinity cookie.
        """
        return pulumi.get(self, "affinity_cookie_name")

    @affinity_cookie_name.setter
    def affinity_cookie_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "affinity_cookie_name", value)

    @property
    @pulumi.getter(name="authenticationCertificates")
    def authentication_certificates(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SubResourceArgs']]]]:
        """
        Array of references to application gateway authentication certificates.
        """
        return pulumi.get(self, "authentication_certificates")

    @authentication_certificates.setter
    def authentication_certificates(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SubResourceArgs']]]]):
        pulumi.set(self, "authentication_certificates", value)

    @property
    @pulumi.getter(name="connectionDraining")
    def connection_draining(self) -> Optional[pulumi.Input['ApplicationGatewayConnectionDrainingArgs']]:
        """
        Connection draining of the backend http settings resource.
        """
        return pulumi.get(self, "connection_draining")

    @connection_draining.setter
    def connection_draining(self, value: Optional[pulumi.Input['ApplicationGatewayConnectionDrainingArgs']]):
        pulumi.set(self, "connection_draining", value)

    @property
    @pulumi.getter(name="cookieBasedAffinity")
    def cookie_based_affinity(self) -> Optional[pulumi.Input[Union[str, 'ApplicationGatewayCookieBasedAffinity']]]:
        """
        Cookie based affinity.
        """
        return pulumi.get(self, "cookie_based_affinity")

    @cookie_based_affinity.setter
    def cookie_based_affinity(self, value: Optional[pulumi.Input[Union[str, 'ApplicationGatewayCookieBasedAffinity']]]):
        pulumi.set(self, "cookie_based_affinity", value)

    @property
    @pulumi.getter(name="hostName")
    def host_name(self) -> Optional[pulumi.Input[str]]:
        """
        Host header to be sent to the backend servers.
        """
        return pulumi.get(self, "host_name")

    @host_name.setter
    def host_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host_name", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the backend http settings that is unique within an Application Gateway.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        Path which should be used as a prefix for all HTTP requests. Null means no path will be prefixed. Default value is null.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter(name="pickHostNameFromBackendAddress")
    def pick_host_name_from_backend_address(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to pick host header should be picked from the host name of the backend server. Default value is false.
        """
        return pulumi.get(self, "pick_host_name_from_backend_address")

    @pick_host_name_from_backend_address.setter
    def pick_host_name_from_backend_address(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "pick_host_name_from_backend_address", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        The destination port on the backend.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def probe(self) -> Optional[pulumi.Input['SubResourceArgs']]:
        """
        Probe resource of an application gateway.
        """
        return pulumi.get(self, "probe")

    @probe.setter
    def probe(self, value: Optional[pulumi.Input['SubResourceArgs']]):
        pulumi.set(self, "probe", value)

    @property
    @pulumi.getter(name="probeEnabled")
    def probe_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the probe is enabled. Default value is false.
        """
        return pulumi.get(self, "probe_enabled")

    @probe_enabled.setter
    def probe_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "probe_enabled", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[Union[str, 'ApplicationGatewayProtocol']]]:
        """
        The protocol used to communicate with the backend.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[Union[str, 'ApplicationGatewayProtocol']]]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter(name="requestTimeout")
    def request_timeout(self) -> Optional[pulumi.Input[int]]:
        """
        Request timeout in seconds. Application Gateway will fail the request if response is not received within RequestTimeout. Acceptable values are from 1 second to 86400 seconds.
        """
        return pulumi.get(self, "request_timeout")

    @request_timeout.setter
    def request_timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "request_timeout", value)

    @property
    @pulumi.getter(name="trustedRootCertificates")
    def trusted_root_certificates(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SubResourceArgs']]]]:
        """
        Array of references to application gateway trusted root certificates.
        """
        return pulumi.get(self, "trusted_root_certificates")

    @trusted_root_certificates.setter
    def trusted_root_certificates(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SubResourceArgs']]]]):
        pulumi.set(self, "trusted_root_certificates", value)


@pulumi.input_type
class ApplicationGatewayConnectionDrainingArgs:
    def __init__(__self__, *,
                 drain_timeout_in_sec: pulumi.Input[int],
                 enabled: pulumi.Input[bool]):
        """
        Connection draining allows open connections to a backend server to be active for a specified time after the backend server got removed from the configuration.
        :param pulumi.Input[int] drain_timeout_in_sec: The number of seconds connection draining is active. Acceptable values are from 1 second to 3600 seconds.
        :param pulumi.Input[bool] enabled: Whether connection draining is enabled or not.
        """
        pulumi.set(__self__, "drain_timeout_in_sec", drain_timeout_in_sec)
        pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter(name="drainTimeoutInSec")
    def drain_timeout_in_sec(self) -> pulumi.Input[int]:
        """
        The number of seconds connection draining is active. Acceptable values are from 1 second to 3600 seconds.
        """
        return pulumi.get(self, "drain_timeout_in_sec")

    @drain_timeout_in_sec.setter
    def drain_timeout_in_sec(self, value: pulumi.Input[int]):
        pulumi.set(self, "drain_timeout_in_sec", value)

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[bool]:
        """
        Whether connection draining is enabled or not.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[bool]):
        pulumi.set(self, "enabled", value)


@pulumi.input_type
class ApplicationGatewayCustomErrorArgs:
    def __init__(__self__, *,
                 custom_error_page_url: Optional[pulumi.Input[str]] = None,
                 status_code: Optional[pulumi.Input[Union[str, 'ApplicationGatewayCustomErrorStatusCode']]] = None):
        """
        Customer error of an application gateway.
        :param pulumi.Input[str] custom_error_page_url: Error page URL of the application gateway customer error.
        :param pulumi.Input[Union[str, 'ApplicationGatewayCustomErrorStatusCode']] status_code: Status code of the application gateway customer error.
        """
        if custom_error_page_url is not None:
            pulumi.set(__self__, "custom_error_page_url", custom_error_page_url)
        if status_code is not None:
            pulumi.set(__self__, "status_code", status_code)

    @property
    @pulumi.getter(name="customErrorPageUrl")
    def custom_error_page_url(self) -> Optional[pulumi.Input[str]]:
        """
        Error page URL of the application gateway customer error.
        """
        return pulumi.get(self, "custom_error_page_url")

    @custom_error_page_url.setter
    def custom_error_page_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "custom_error_page_url", value)

    @property
    @pulumi.getter(name="statusCode")
    def status_code(self) -> Optional[pulumi.Input[Union[str, 'ApplicationGatewayCustomErrorStatusCode']]]:
        """
        Status code of the application gateway customer error.
        """
        return pulumi.get(self, "status_code")

    @status_code.setter
    def status_code(self, value: Optional[pulumi.Input[Union[str, 'ApplicationGatewayCustomErrorStatusCode']]]):
        pulumi.set(self, "status_code", value)


@pulumi.input_type
class ApplicationGatewayFirewallDisabledRuleGroupArgs:
    def __init__(__self__, *,
                 rule_group_name: pulumi.Input[str],
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None):
        """
        Allows to disable rules within a rule group or an entire rule group.
        :param pulumi.Input[str] rule_group_name: The name of the rule group that will be disabled.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] rules: The list of rules that will be disabled. If null, all rules of the rule group will be disabled.
        """
        pulumi.set(__self__, "rule_group_name", rule_group_name)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)

    @property
    @pulumi.getter(name="ruleGroupName")
    def rule_group_name(self) -> pulumi.Input[str]:
        """
        The name of the rule group that will be disabled.
        """
        return pulumi.get(self, "rule_group_name")

    @rule_group_name.setter
    def rule_group_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "rule_group_name", value)

    @property
    @pulumi.getter
    def rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]:
        """
        The list of rules that will be disabled. If null, all rules of the rule group will be disabled.
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]):
        pulumi.set(self, "rules", value)


@pulumi.input_type
class ApplicationGatewayFirewallExclusionArgs:
    def __init__(__self__, *,
                 match_variable: pulumi.Input[str],
                 selector: pulumi.Input[str],
                 selector_match_operator: pulumi.Input[str]):
        """
        Allow to exclude some variable satisfy the condition for the WAF check.
        :param pulumi.Input[str] match_variable: The variable to be excluded.
        :param pulumi.Input[str] selector: When matchVariable is a collection, operator used to specify which elements in the collection this exclusion applies to.
        :param pulumi.Input[str] selector_match_operator: When matchVariable is a collection, operate on the selector to specify which elements in the collection this exclusion applies to.
        """
        pulumi.set(__self__, "match_variable", match_variable)
        pulumi.set(__self__, "selector", selector)
        pulumi.set(__self__, "selector_match_operator", selector_match_operator)

    @property
    @pulumi.getter(name="matchVariable")
    def match_variable(self) -> pulumi.Input[str]:
        """
        The variable to be excluded.
        """
        return pulumi.get(self, "match_variable")

    @match_variable.setter
    def match_variable(self, value: pulumi.Input[str]):
        pulumi.set(self, "match_variable", value)

    @property
    @pulumi.getter
    def selector(self) -> pulumi.Input[str]:
        """
        When matchVariable is a collection, operator used to specify which elements in the collection this exclusion applies to.
        """
        return pulumi.get(self, "selector")

    @selector.setter
    def selector(self, value: pulumi.Input[str]):
        pulumi.set(self, "selector", value)

    @property
    @pulumi.getter(name="selectorMatchOperator")
    def selector_match_operator(self) -> pulumi.Input[str]:
        """
        When matchVariable is a collection, operate on the selector to specify which elements in the collection this exclusion applies to.
        """
        return pulumi.get(self, "selector_match_operator")

    @selector_match_operator.setter
    def selector_match_operator(self, value: pulumi.Input[str]):
        pulumi.set(self, "selector_match_operator", value)


@pulumi.input_type
class ApplicationGatewayFrontendIPConfigurationArgs:
    def __init__(__self__, *,
                 id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 private_ip_address: Optional[pulumi.Input[str]] = None,
                 private_ip_allocation_method: Optional[pulumi.Input[Union[str, 'IPAllocationMethod']]] = None,
                 private_link_configuration: Optional[pulumi.Input['SubResourceArgs']] = None,
                 public_ip_address: Optional[pulumi.Input['SubResourceArgs']] = None,
                 subnet: Optional[pulumi.Input['SubResourceArgs']] = None):
        """
        Frontend IP configuration of an application gateway.
        :param pulumi.Input[str] id: Resource ID.
        :param pulumi.Input[str] name: Name of the frontend IP configuration that is unique within an Application Gateway.
        :param pulumi.Input[str] private_ip_address: PrivateIPAddress of the network interface IP Configuration.
        :param pulumi.Input[Union[str, 'IPAllocationMethod']] private_ip_allocation_method: The private IP address allocation method.
        :param pulumi.Input['SubResourceArgs'] private_link_configuration: Reference to the application gateway private link configuration.
        :param pulumi.Input['SubResourceArgs'] public_ip_address: Reference to the PublicIP resource.
        :param pulumi.Input['SubResourceArgs'] subnet: Reference to the subnet resource.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if private_ip_address is not None:
            pulumi.set(__self__, "private_ip_address", private_ip_address)
        if private_ip_allocation_method is not None:
            pulumi.set(__self__, "private_ip_allocation_method", private_ip_allocation_method)
        if private_link_configuration is not None:
            pulumi.set(__self__, "private_link_configuration", private_link_configuration)
        if public_ip_address is not None:
            pulumi.set(__self__, "public_ip_address", public_ip_address)
        if subnet is not None:
            pulumi.set(__self__, "subnet", subnet)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the frontend IP configuration that is unique within an Application Gateway.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="privateIPAddress")
    def private_ip_address(self) -> Optional[pulumi.Input[str]]:
        """
        PrivateIPAddress of the network interface IP Configuration.
        """
        return pulumi.get(self, "private_ip_address")

    @private_ip_address.setter
    def private_ip_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_ip_address", value)

    @property
    @pulumi.getter(name="privateIPAllocationMethod")
    def private_ip_allocation_method(self) -> Optional[pulumi.Input[Union[str, 'IPAllocationMethod']]]:
        """
        The private IP address allocation method.
        """
        return pulumi.get(self, "private_ip_allocation_method")

    @private_ip_allocation_method.setter
    def private_ip_allocation_method(self, value: Optional[pulumi.Input[Union[str, 'IPAllocationMethod']]]):
        pulumi.set(self, "private_ip_allocation_method", value)

    @property
    @pulumi.getter(name="privateLinkConfiguration")
    def private_link_configuration(self) -> Optional[pulumi.Input['SubResourceArgs']]:
        """
        Reference to the application gateway private link configuration.
        """
        return pulumi.get(self, "private_link_configuration")

    @private_link_configuration.setter
    def private_link_configuration(self, value: Optional[pulumi.Input['SubResourceArgs']]):
        pulumi.set(self, "private_link_configuration", value)

    @property
    @pulumi.getter(name="publicIPAddress")
    def public_ip_address(self) -> Optional[pulumi.Input['SubResourceArgs']]:
        """
        Reference to the PublicIP resource.
        """
        return pulumi.get(self, "public_ip_address")

    @public_ip_address.setter
    def public_ip_address(self, value: Optional[pulumi.Input['SubResourceArgs']]):
        pulumi.set(self, "public_ip_address", value)

    @property
    @pulumi.getter
    def subnet(self) -> Optional[pulumi.Input['SubResourceArgs']]:
        """
        Reference to the subnet resource.
        """
        return pulumi.get(self, "subnet")

    @subnet.setter
    def subnet(self, value: Optional[pulumi.Input['SubResourceArgs']]):
        pulumi.set(self, "subnet", value)


@pulumi.input_type
class ApplicationGatewayFrontendPortArgs:
    def __init__(__self__, *,
                 id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[int]] = None):
        """
        Frontend port of an application gateway.
        :param pulumi.Input[str] id: Resource ID.
        :param pulumi.Input[str] name: Name of the frontend port that is unique within an Application Gateway.
        :param pulumi.Input[int] port: Frontend port.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the frontend port that is unique within an Application Gateway.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        Frontend port.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)


@pulumi.input_type
class ApplicationGatewayHeaderConfigurationArgs:
    def __init__(__self__, *,
                 header_name: Optional[pulumi.Input[str]] = None,
                 header_value: Optional[pulumi.Input[str]] = None):
        """
        Header configuration of the Actions set in Application Gateway.
        :param pulumi.Input[str] header_name: Header name of the header configuration.
        :param pulumi.Input[str] header_value: Header value of the header configuration.
        """
        if header_name is not None:
            pulumi.set(__self__, "header_name", header_name)
        if header_value is not None:
            pulumi.set(__self__, "header_value", header_value)

    @property
    @pulumi.getter(name="headerName")
    def header_name(self) -> Optional[pulumi.Input[str]]:
        """
        Header name of the header configuration.
        """
        return pulumi.get(self, "header_name")

    @header_name.setter
    def header_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "header_name", value)

    @property
    @pulumi.getter(name="headerValue")
    def header_value(self) -> Optional[pulumi.Input[str]]:
        """
        Header value of the header configuration.
        """
        return pulumi.get(self, "header_value")

    @header_value.setter
    def header_value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "header_value", value)


@pulumi.input_type
class ApplicationGatewayHttpListenerArgs:
    def __init__(__self__, *,
                 custom_error_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayCustomErrorArgs']]]] = None,
                 firewall_policy: Optional[pulumi.Input['SubResourceArgs']] = None,
                 frontend_ip_configuration: Optional[pulumi.Input['SubResourceArgs']] = None,
                 frontend_port: Optional[pulumi.Input['SubResourceArgs']] = None,
                 host_name: Optional[pulumi.Input[str]] = None,
                 host_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 protocol: Optional[pulumi.Input[Union[str, 'ApplicationGatewayProtocol']]] = None,
                 require_server_name_indication: Optional[pulumi.Input[bool]] = None,
                 ssl_certificate: Optional[pulumi.Input['SubResourceArgs']] = None):
        """
        Http listener of an application gateway.
        :param pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayCustomErrorArgs']]] custom_error_configurations: Custom error configurations of the HTTP listener.
        :param pulumi.Input['SubResourceArgs'] firewall_policy: Reference to the FirewallPolicy resource.
        :param pulumi.Input['SubResourceArgs'] frontend_ip_configuration: Frontend IP configuration resource of an application gateway.
        :param pulumi.Input['SubResourceArgs'] frontend_port: Frontend port resource of an application gateway.
        :param pulumi.Input[str] host_name: Host name of HTTP listener.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] host_names: List of Host names for HTTP Listener that allows special wildcard characters as well.
        :param pulumi.Input[str] id: Resource ID.
        :param pulumi.Input[str] name: Name of the HTTP listener that is unique within an Application Gateway.
        :param pulumi.Input[Union[str, 'ApplicationGatewayProtocol']] protocol: Protocol of the HTTP listener.
        :param pulumi.Input[bool] require_server_name_indication: Applicable only if protocol is https. Enables SNI for multi-hosting.
        :param pulumi.Input['SubResourceArgs'] ssl_certificate: SSL certificate resource of an application gateway.
        """
        if custom_error_configurations is not None:
            pulumi.set(__self__, "custom_error_configurations", custom_error_configurations)
        if firewall_policy is not None:
            pulumi.set(__self__, "firewall_policy", firewall_policy)
        if frontend_ip_configuration is not None:
            pulumi.set(__self__, "frontend_ip_configuration", frontend_ip_configuration)
        if frontend_port is not None:
            pulumi.set(__self__, "frontend_port", frontend_port)
        if host_name is not None:
            pulumi.set(__self__, "host_name", host_name)
        if host_names is not None:
            pulumi.set(__self__, "host_names", host_names)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if require_server_name_indication is not None:
            pulumi.set(__self__, "require_server_name_indication", require_server_name_indication)
        if ssl_certificate is not None:
            pulumi.set(__self__, "ssl_certificate", ssl_certificate)

    @property
    @pulumi.getter(name="customErrorConfigurations")
    def custom_error_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayCustomErrorArgs']]]]:
        """
        Custom error configurations of the HTTP listener.
        """
        return pulumi.get(self, "custom_error_configurations")

    @custom_error_configurations.setter
    def custom_error_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayCustomErrorArgs']]]]):
        pulumi.set(self, "custom_error_configurations", value)

    @property
    @pulumi.getter(name="firewallPolicy")
    def firewall_policy(self) -> Optional[pulumi.Input['SubResourceArgs']]:
        """
        Reference to the FirewallPolicy resource.
        """
        return pulumi.get(self, "firewall_policy")

    @firewall_policy.setter
    def firewall_policy(self, value: Optional[pulumi.Input['SubResourceArgs']]):
        pulumi.set(self, "firewall_policy", value)

    @property
    @pulumi.getter(name="frontendIPConfiguration")
    def frontend_ip_configuration(self) -> Optional[pulumi.Input['SubResourceArgs']]:
        """
        Frontend IP configuration resource of an application gateway.
        """
        return pulumi.get(self, "frontend_ip_configuration")

    @frontend_ip_configuration.setter
    def frontend_ip_configuration(self, value: Optional[pulumi.Input['SubResourceArgs']]):
        pulumi.set(self, "frontend_ip_configuration", value)

    @property
    @pulumi.getter(name="frontendPort")
    def frontend_port(self) -> Optional[pulumi.Input['SubResourceArgs']]:
        """
        Frontend port resource of an application gateway.
        """
        return pulumi.get(self, "frontend_port")

    @frontend_port.setter
    def frontend_port(self, value: Optional[pulumi.Input['SubResourceArgs']]):
        pulumi.set(self, "frontend_port", value)

    @property
    @pulumi.getter(name="hostName")
    def host_name(self) -> Optional[pulumi.Input[str]]:
        """
        Host name of HTTP listener.
        """
        return pulumi.get(self, "host_name")

    @host_name.setter
    def host_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host_name", value)

    @property
    @pulumi.getter(name="hostNames")
    def host_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of Host names for HTTP Listener that allows special wildcard characters as well.
        """
        return pulumi.get(self, "host_names")

    @host_names.setter
    def host_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "host_names", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the HTTP listener that is unique within an Application Gateway.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[Union[str, 'ApplicationGatewayProtocol']]]:
        """
        Protocol of the HTTP listener.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[Union[str, 'ApplicationGatewayProtocol']]]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter(name="requireServerNameIndication")
    def require_server_name_indication(self) -> Optional[pulumi.Input[bool]]:
        """
        Applicable only if protocol is https. Enables SNI for multi-hosting.
        """
        return pulumi.get(self, "require_server_name_indication")

    @require_server_name_indication.setter
    def require_server_name_indication(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "require_server_name_indication", value)

    @property
    @pulumi.getter(name="sslCertificate")
    def ssl_certificate(self) -> Optional[pulumi.Input['SubResourceArgs']]:
        """
        SSL certificate resource of an application gateway.
        """
        return pulumi.get(self, "ssl_certificate")

    @ssl_certificate.setter
    def ssl_certificate(self, value: Optional[pulumi.Input['SubResourceArgs']]):
        pulumi.set(self, "ssl_certificate", value)


@pulumi.input_type
class ApplicationGatewayIPConfigurationArgs:
    def __init__(__self__, *,
                 id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 subnet: Optional[pulumi.Input['SubResourceArgs']] = None):
        """
        IP configuration of an application gateway. Currently 1 public and 1 private IP configuration is allowed.
        :param pulumi.Input[str] id: Resource ID.
        :param pulumi.Input[str] name: Name of the IP configuration that is unique within an Application Gateway.
        :param pulumi.Input['SubResourceArgs'] subnet: Reference to the subnet resource. A subnet from where application gateway gets its private address.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if subnet is not None:
            pulumi.set(__self__, "subnet", subnet)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the IP configuration that is unique within an Application Gateway.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def subnet(self) -> Optional[pulumi.Input['SubResourceArgs']]:
        """
        Reference to the subnet resource. A subnet from where application gateway gets its private address.
        """
        return pulumi.get(self, "subnet")

    @subnet.setter
    def subnet(self, value: Optional[pulumi.Input['SubResourceArgs']]):
        pulumi.set(self, "subnet", value)


@pulumi.input_type
class ApplicationGatewayPathRuleArgs:
    def __init__(__self__, *,
                 backend_address_pool: Optional[pulumi.Input['SubResourceArgs']] = None,
                 backend_http_settings: Optional[pulumi.Input['SubResourceArgs']] = None,
                 firewall_policy: Optional[pulumi.Input['SubResourceArgs']] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 paths: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 redirect_configuration: Optional[pulumi.Input['SubResourceArgs']] = None,
                 rewrite_rule_set: Optional[pulumi.Input['SubResourceArgs']] = None):
        """
        Path rule of URL path map of an application gateway.
        :param pulumi.Input['SubResourceArgs'] backend_address_pool: Backend address pool resource of URL path map path rule.
        :param pulumi.Input['SubResourceArgs'] backend_http_settings: Backend http settings resource of URL path map path rule.
        :param pulumi.Input['SubResourceArgs'] firewall_policy: Reference to the FirewallPolicy resource.
        :param pulumi.Input[str] id: Resource ID.
        :param pulumi.Input[str] name: Name of the path rule that is unique within an Application Gateway.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] paths: Path rules of URL path map.
        :param pulumi.Input['SubResourceArgs'] redirect_configuration: Redirect configuration resource of URL path map path rule.
        :param pulumi.Input['SubResourceArgs'] rewrite_rule_set: Rewrite rule set resource of URL path map path rule.
        """
        if backend_address_pool is not None:
            pulumi.set(__self__, "backend_address_pool", backend_address_pool)
        if backend_http_settings is not None:
            pulumi.set(__self__, "backend_http_settings", backend_http_settings)
        if firewall_policy is not None:
            pulumi.set(__self__, "firewall_policy", firewall_policy)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if paths is not None:
            pulumi.set(__self__, "paths", paths)
        if redirect_configuration is not None:
            pulumi.set(__self__, "redirect_configuration", redirect_configuration)
        if rewrite_rule_set is not None:
            pulumi.set(__self__, "rewrite_rule_set", rewrite_rule_set)

    @property
    @pulumi.getter(name="backendAddressPool")
    def backend_address_pool(self) -> Optional[pulumi.Input['SubResourceArgs']]:
        """
        Backend address pool resource of URL path map path rule.
        """
        return pulumi.get(self, "backend_address_pool")

    @backend_address_pool.setter
    def backend_address_pool(self, value: Optional[pulumi.Input['SubResourceArgs']]):
        pulumi.set(self, "backend_address_pool", value)

    @property
    @pulumi.getter(name="backendHttpSettings")
    def backend_http_settings(self) -> Optional[pulumi.Input['SubResourceArgs']]:
        """
        Backend http settings resource of URL path map path rule.
        """
        return pulumi.get(self, "backend_http_settings")

    @backend_http_settings.setter
    def backend_http_settings(self, value: Optional[pulumi.Input['SubResourceArgs']]):
        pulumi.set(self, "backend_http_settings", value)

    @property
    @pulumi.getter(name="firewallPolicy")
    def firewall_policy(self) -> Optional[pulumi.Input['SubResourceArgs']]:
        """
        Reference to the FirewallPolicy resource.
        """
        return pulumi.get(self, "firewall_policy")

    @firewall_policy.setter
    def firewall_policy(self, value: Optional[pulumi.Input['SubResourceArgs']]):
        pulumi.set(self, "firewall_policy", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the path rule that is unique within an Application Gateway.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def paths(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Path rules of URL path map.
        """
        return pulumi.get(self, "paths")

    @paths.setter
    def paths(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "paths", value)

    @property
    @pulumi.getter(name="redirectConfiguration")
    def redirect_configuration(self) -> Optional[pulumi.Input['SubResourceArgs']]:
        """
        Redirect configuration resource of URL path map path rule.
        """
        return pulumi.get(self, "redirect_configuration")

    @redirect_configuration.setter
    def redirect_configuration(self, value: Optional[pulumi.Input['SubResourceArgs']]):
        pulumi.set(self, "redirect_configuration", value)

    @property
    @pulumi.getter(name="rewriteRuleSet")
    def rewrite_rule_set(self) -> Optional[pulumi.Input['SubResourceArgs']]:
        """
        Rewrite rule set resource of URL path map path rule.
        """
        return pulumi.get(self, "rewrite_rule_set")

    @rewrite_rule_set.setter
    def rewrite_rule_set(self, value: Optional[pulumi.Input['SubResourceArgs']]):
        pulumi.set(self, "rewrite_rule_set", value)


@pulumi.input_type
class ApplicationGatewayPrivateLinkConfigurationArgs:
    def __init__(__self__, *,
                 id: Optional[pulumi.Input[str]] = None,
                 ip_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayPrivateLinkIpConfigurationArgs']]]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        Private Link Configuration on an application gateway.
        :param pulumi.Input[str] id: Resource ID.
        :param pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayPrivateLinkIpConfigurationArgs']]] ip_configurations: An array of application gateway private link ip configurations.
        :param pulumi.Input[str] name: Name of the private link configuration that is unique within an Application Gateway.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if ip_configurations is not None:
            pulumi.set(__self__, "ip_configurations", ip_configurations)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="ipConfigurations")
    def ip_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayPrivateLinkIpConfigurationArgs']]]]:
        """
        An array of application gateway private link ip configurations.
        """
        return pulumi.get(self, "ip_configurations")

    @ip_configurations.setter
    def ip_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayPrivateLinkIpConfigurationArgs']]]]):
        pulumi.set(self, "ip_configurations", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the private link configuration that is unique within an Application Gateway.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class ApplicationGatewayPrivateLinkIpConfigurationArgs:
    def __init__(__self__, *,
                 id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 primary: Optional[pulumi.Input[bool]] = None,
                 private_ip_address: Optional[pulumi.Input[str]] = None,
                 private_ip_allocation_method: Optional[pulumi.Input[Union[str, 'IPAllocationMethod']]] = None,
                 subnet: Optional[pulumi.Input['SubResourceArgs']] = None):
        """
        The application gateway private link ip configuration.
        :param pulumi.Input[str] id: Resource ID.
        :param pulumi.Input[str] name: The name of application gateway private link ip configuration.
        :param pulumi.Input[bool] primary: Whether the ip configuration is primary or not.
        :param pulumi.Input[str] private_ip_address: The private IP address of the IP configuration.
        :param pulumi.Input[Union[str, 'IPAllocationMethod']] private_ip_allocation_method: The private IP address allocation method.
        :param pulumi.Input['SubResourceArgs'] subnet: Reference to the subnet resource.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if primary is not None:
            pulumi.set(__self__, "primary", primary)
        if private_ip_address is not None:
            pulumi.set(__self__, "private_ip_address", private_ip_address)
        if private_ip_allocation_method is not None:
            pulumi.set(__self__, "private_ip_allocation_method", private_ip_allocation_method)
        if subnet is not None:
            pulumi.set(__self__, "subnet", subnet)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of application gateway private link ip configuration.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def primary(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the ip configuration is primary or not.
        """
        return pulumi.get(self, "primary")

    @primary.setter
    def primary(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "primary", value)

    @property
    @pulumi.getter(name="privateIPAddress")
    def private_ip_address(self) -> Optional[pulumi.Input[str]]:
        """
        The private IP address of the IP configuration.
        """
        return pulumi.get(self, "private_ip_address")

    @private_ip_address.setter
    def private_ip_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_ip_address", value)

    @property
    @pulumi.getter(name="privateIPAllocationMethod")
    def private_ip_allocation_method(self) -> Optional[pulumi.Input[Union[str, 'IPAllocationMethod']]]:
        """
        The private IP address allocation method.
        """
        return pulumi.get(self, "private_ip_allocation_method")

    @private_ip_allocation_method.setter
    def private_ip_allocation_method(self, value: Optional[pulumi.Input[Union[str, 'IPAllocationMethod']]]):
        pulumi.set(self, "private_ip_allocation_method", value)

    @property
    @pulumi.getter
    def subnet(self) -> Optional[pulumi.Input['SubResourceArgs']]:
        """
        Reference to the subnet resource.
        """
        return pulumi.get(self, "subnet")

    @subnet.setter
    def subnet(self, value: Optional[pulumi.Input['SubResourceArgs']]):
        pulumi.set(self, "subnet", value)


@pulumi.input_type
class ApplicationGatewayProbeHealthResponseMatch:
    def __init__(__self__, *,
                 body: Optional[str] = None,
                 status_codes: Optional[Sequence[str]] = None):
        """
        Application gateway probe health response match.
        :param str body: Body that must be contained in the health response. Default value is empty.
        :param Sequence[str] status_codes: Allowed ranges of healthy status codes. Default range of healthy status codes is 200-399.
        """
        if body is not None:
            pulumi.set(__self__, "body", body)
        if status_codes is not None:
            pulumi.set(__self__, "status_codes", status_codes)

    @property
    @pulumi.getter
    def body(self) -> Optional[str]:
        """
        Body that must be contained in the health response. Default value is empty.
        """
        return pulumi.get(self, "body")

    @body.setter
    def body(self, value: Optional[str]):
        pulumi.set(self, "body", value)

    @property
    @pulumi.getter(name="statusCodes")
    def status_codes(self) -> Optional[Sequence[str]]:
        """
        Allowed ranges of healthy status codes. Default range of healthy status codes is 200-399.
        """
        return pulumi.get(self, "status_codes")

    @status_codes.setter
    def status_codes(self, value: Optional[Sequence[str]]):
        pulumi.set(self, "status_codes", value)


@pulumi.input_type
class ApplicationGatewayProbeHealthResponseMatchArgs:
    def __init__(__self__, *,
                 body: Optional[pulumi.Input[str]] = None,
                 status_codes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Application gateway probe health response match.
        :param pulumi.Input[str] body: Body that must be contained in the health response. Default value is empty.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] status_codes: Allowed ranges of healthy status codes. Default range of healthy status codes is 200-399.
        """
        if body is not None:
            pulumi.set(__self__, "body", body)
        if status_codes is not None:
            pulumi.set(__self__, "status_codes", status_codes)

    @property
    @pulumi.getter
    def body(self) -> Optional[pulumi.Input[str]]:
        """
        Body that must be contained in the health response. Default value is empty.
        """
        return pulumi.get(self, "body")

    @body.setter
    def body(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "body", value)

    @property
    @pulumi.getter(name="statusCodes")
    def status_codes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Allowed ranges of healthy status codes. Default range of healthy status codes is 200-399.
        """
        return pulumi.get(self, "status_codes")

    @status_codes.setter
    def status_codes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "status_codes", value)


@pulumi.input_type
class ApplicationGatewayProbeArgs:
    def __init__(__self__, *,
                 host: Optional[pulumi.Input[str]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 interval: Optional[pulumi.Input[int]] = None,
                 match: Optional[pulumi.Input['ApplicationGatewayProbeHealthResponseMatchArgs']] = None,
                 min_servers: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 path: Optional[pulumi.Input[str]] = None,
                 pick_host_name_from_backend_http_settings: Optional[pulumi.Input[bool]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 protocol: Optional[pulumi.Input[Union[str, 'ApplicationGatewayProtocol']]] = None,
                 timeout: Optional[pulumi.Input[int]] = None,
                 unhealthy_threshold: Optional[pulumi.Input[int]] = None):
        """
        Probe of the application gateway.
        :param pulumi.Input[str] host: Host name to send the probe to.
        :param pulumi.Input[str] id: Resource ID.
        :param pulumi.Input[int] interval: The probing interval in seconds. This is the time interval between two consecutive probes. Acceptable values are from 1 second to 86400 seconds.
        :param pulumi.Input['ApplicationGatewayProbeHealthResponseMatchArgs'] match: Criterion for classifying a healthy probe response.
        :param pulumi.Input[int] min_servers: Minimum number of servers that are always marked healthy. Default value is 0.
        :param pulumi.Input[str] name: Name of the probe that is unique within an Application Gateway.
        :param pulumi.Input[str] path: Relative path of probe. Valid path starts from '/'. Probe is sent to <Protocol>://<host>:<port><path>.
        :param pulumi.Input[bool] pick_host_name_from_backend_http_settings: Whether the host header should be picked from the backend http settings. Default value is false.
        :param pulumi.Input[int] port: Custom port which will be used for probing the backend servers. The valid value ranges from 1 to 65535. In case not set, port from http settings will be used. This property is valid for Standard_v2 and WAF_v2 only.
        :param pulumi.Input[Union[str, 'ApplicationGatewayProtocol']] protocol: The protocol used for the probe.
        :param pulumi.Input[int] timeout: The probe timeout in seconds. Probe marked as failed if valid response is not received with this timeout period. Acceptable values are from 1 second to 86400 seconds.
        :param pulumi.Input[int] unhealthy_threshold: The probe retry count. Backend server is marked down after consecutive probe failure count reaches UnhealthyThreshold. Acceptable values are from 1 second to 20.
        """
        if host is not None:
            pulumi.set(__self__, "host", host)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if interval is not None:
            pulumi.set(__self__, "interval", interval)
        if match is not None:
            pulumi.set(__self__, "match", match)
        if min_servers is not None:
            pulumi.set(__self__, "min_servers", min_servers)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if pick_host_name_from_backend_http_settings is not None:
            pulumi.set(__self__, "pick_host_name_from_backend_http_settings", pick_host_name_from_backend_http_settings)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)
        if unhealthy_threshold is not None:
            pulumi.set(__self__, "unhealthy_threshold", unhealthy_threshold)

    @property
    @pulumi.getter
    def host(self) -> Optional[pulumi.Input[str]]:
        """
        Host name to send the probe to.
        """
        return pulumi.get(self, "host")

    @host.setter
    def host(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def interval(self) -> Optional[pulumi.Input[int]]:
        """
        The probing interval in seconds. This is the time interval between two consecutive probes. Acceptable values are from 1 second to 86400 seconds.
        """
        return pulumi.get(self, "interval")

    @interval.setter
    def interval(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "interval", value)

    @property
    @pulumi.getter
    def match(self) -> Optional[pulumi.Input['ApplicationGatewayProbeHealthResponseMatchArgs']]:
        """
        Criterion for classifying a healthy probe response.
        """
        return pulumi.get(self, "match")

    @match.setter
    def match(self, value: Optional[pulumi.Input['ApplicationGatewayProbeHealthResponseMatchArgs']]):
        pulumi.set(self, "match", value)

    @property
    @pulumi.getter(name="minServers")
    def min_servers(self) -> Optional[pulumi.Input[int]]:
        """
        Minimum number of servers that are always marked healthy. Default value is 0.
        """
        return pulumi.get(self, "min_servers")

    @min_servers.setter
    def min_servers(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_servers", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the probe that is unique within an Application Gateway.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        Relative path of probe. Valid path starts from '/'. Probe is sent to <Protocol>://<host>:<port><path>.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter(name="pickHostNameFromBackendHttpSettings")
    def pick_host_name_from_backend_http_settings(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the host header should be picked from the backend http settings. Default value is false.
        """
        return pulumi.get(self, "pick_host_name_from_backend_http_settings")

    @pick_host_name_from_backend_http_settings.setter
    def pick_host_name_from_backend_http_settings(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "pick_host_name_from_backend_http_settings", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        Custom port which will be used for probing the backend servers. The valid value ranges from 1 to 65535. In case not set, port from http settings will be used. This property is valid for Standard_v2 and WAF_v2 only.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[Union[str, 'ApplicationGatewayProtocol']]]:
        """
        The protocol used for the probe.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[Union[str, 'ApplicationGatewayProtocol']]]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[int]]:
        """
        The probe timeout in seconds. Probe marked as failed if valid response is not received with this timeout period. Acceptable values are from 1 second to 86400 seconds.
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "timeout", value)

    @property
    @pulumi.getter(name="unhealthyThreshold")
    def unhealthy_threshold(self) -> Optional[pulumi.Input[int]]:
        """
        The probe retry count. Backend server is marked down after consecutive probe failure count reaches UnhealthyThreshold. Acceptable values are from 1 second to 20.
        """
        return pulumi.get(self, "unhealthy_threshold")

    @unhealthy_threshold.setter
    def unhealthy_threshold(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "unhealthy_threshold", value)


@pulumi.input_type
class ApplicationGatewayRedirectConfigurationArgs:
    def __init__(__self__, *,
                 id: Optional[pulumi.Input[str]] = None,
                 include_path: Optional[pulumi.Input[bool]] = None,
                 include_query_string: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 path_rules: Optional[pulumi.Input[Sequence[pulumi.Input['SubResourceArgs']]]] = None,
                 redirect_type: Optional[pulumi.Input[Union[str, 'ApplicationGatewayRedirectType']]] = None,
                 request_routing_rules: Optional[pulumi.Input[Sequence[pulumi.Input['SubResourceArgs']]]] = None,
                 target_listener: Optional[pulumi.Input['SubResourceArgs']] = None,
                 target_url: Optional[pulumi.Input[str]] = None,
                 url_path_maps: Optional[pulumi.Input[Sequence[pulumi.Input['SubResourceArgs']]]] = None):
        """
        Redirect configuration of an application gateway.
        :param pulumi.Input[str] id: Resource ID.
        :param pulumi.Input[bool] include_path: Include path in the redirected url.
        :param pulumi.Input[bool] include_query_string: Include query string in the redirected url.
        :param pulumi.Input[str] name: Name of the redirect configuration that is unique within an Application Gateway.
        :param pulumi.Input[Sequence[pulumi.Input['SubResourceArgs']]] path_rules: Path rules specifying redirect configuration.
        :param pulumi.Input[Union[str, 'ApplicationGatewayRedirectType']] redirect_type: HTTP redirection type.
        :param pulumi.Input[Sequence[pulumi.Input['SubResourceArgs']]] request_routing_rules: Request routing specifying redirect configuration.
        :param pulumi.Input['SubResourceArgs'] target_listener: Reference to a listener to redirect the request to.
        :param pulumi.Input[str] target_url: Url to redirect the request to.
        :param pulumi.Input[Sequence[pulumi.Input['SubResourceArgs']]] url_path_maps: Url path maps specifying default redirect configuration.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if include_path is not None:
            pulumi.set(__self__, "include_path", include_path)
        if include_query_string is not None:
            pulumi.set(__self__, "include_query_string", include_query_string)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if path_rules is not None:
            pulumi.set(__self__, "path_rules", path_rules)
        if redirect_type is not None:
            pulumi.set(__self__, "redirect_type", redirect_type)
        if request_routing_rules is not None:
            pulumi.set(__self__, "request_routing_rules", request_routing_rules)
        if target_listener is not None:
            pulumi.set(__self__, "target_listener", target_listener)
        if target_url is not None:
            pulumi.set(__self__, "target_url", target_url)
        if url_path_maps is not None:
            pulumi.set(__self__, "url_path_maps", url_path_maps)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="includePath")
    def include_path(self) -> Optional[pulumi.Input[bool]]:
        """
        Include path in the redirected url.
        """
        return pulumi.get(self, "include_path")

    @include_path.setter
    def include_path(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "include_path", value)

    @property
    @pulumi.getter(name="includeQueryString")
    def include_query_string(self) -> Optional[pulumi.Input[bool]]:
        """
        Include query string in the redirected url.
        """
        return pulumi.get(self, "include_query_string")

    @include_query_string.setter
    def include_query_string(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "include_query_string", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the redirect configuration that is unique within an Application Gateway.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="pathRules")
    def path_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SubResourceArgs']]]]:
        """
        Path rules specifying redirect configuration.
        """
        return pulumi.get(self, "path_rules")

    @path_rules.setter
    def path_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SubResourceArgs']]]]):
        pulumi.set(self, "path_rules", value)

    @property
    @pulumi.getter(name="redirectType")
    def redirect_type(self) -> Optional[pulumi.Input[Union[str, 'ApplicationGatewayRedirectType']]]:
        """
        HTTP redirection type.
        """
        return pulumi.get(self, "redirect_type")

    @redirect_type.setter
    def redirect_type(self, value: Optional[pulumi.Input[Union[str, 'ApplicationGatewayRedirectType']]]):
        pulumi.set(self, "redirect_type", value)

    @property
    @pulumi.getter(name="requestRoutingRules")
    def request_routing_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SubResourceArgs']]]]:
        """
        Request routing specifying redirect configuration.
        """
        return pulumi.get(self, "request_routing_rules")

    @request_routing_rules.setter
    def request_routing_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SubResourceArgs']]]]):
        pulumi.set(self, "request_routing_rules", value)

    @property
    @pulumi.getter(name="targetListener")
    def target_listener(self) -> Optional[pulumi.Input['SubResourceArgs']]:
        """
        Reference to a listener to redirect the request to.
        """
        return pulumi.get(self, "target_listener")

    @target_listener.setter
    def target_listener(self, value: Optional[pulumi.Input['SubResourceArgs']]):
        pulumi.set(self, "target_listener", value)

    @property
    @pulumi.getter(name="targetUrl")
    def target_url(self) -> Optional[pulumi.Input[str]]:
        """
        Url to redirect the request to.
        """
        return pulumi.get(self, "target_url")

    @target_url.setter
    def target_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_url", value)

    @property
    @pulumi.getter(name="urlPathMaps")
    def url_path_maps(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SubResourceArgs']]]]:
        """
        Url path maps specifying default redirect configuration.
        """
        return pulumi.get(self, "url_path_maps")

    @url_path_maps.setter
    def url_path_maps(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SubResourceArgs']]]]):
        pulumi.set(self, "url_path_maps", value)


@pulumi.input_type
class ApplicationGatewayRequestRoutingRuleArgs:
    def __init__(__self__, *,
                 backend_address_pool: Optional[pulumi.Input['SubResourceArgs']] = None,
                 backend_http_settings: Optional[pulumi.Input['SubResourceArgs']] = None,
                 http_listener: Optional[pulumi.Input['SubResourceArgs']] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 priority: Optional[pulumi.Input[int]] = None,
                 redirect_configuration: Optional[pulumi.Input['SubResourceArgs']] = None,
                 rewrite_rule_set: Optional[pulumi.Input['SubResourceArgs']] = None,
                 rule_type: Optional[pulumi.Input[Union[str, 'ApplicationGatewayRequestRoutingRuleType']]] = None,
                 url_path_map: Optional[pulumi.Input['SubResourceArgs']] = None):
        """
        Request routing rule of an application gateway.
        :param pulumi.Input['SubResourceArgs'] backend_address_pool: Backend address pool resource of the application gateway.
        :param pulumi.Input['SubResourceArgs'] backend_http_settings: Backend http settings resource of the application gateway.
        :param pulumi.Input['SubResourceArgs'] http_listener: Http listener resource of the application gateway.
        :param pulumi.Input[str] id: Resource ID.
        :param pulumi.Input[str] name: Name of the request routing rule that is unique within an Application Gateway.
        :param pulumi.Input[int] priority: Priority of the request routing rule.
        :param pulumi.Input['SubResourceArgs'] redirect_configuration: Redirect configuration resource of the application gateway.
        :param pulumi.Input['SubResourceArgs'] rewrite_rule_set: Rewrite Rule Set resource in Basic rule of the application gateway.
        :param pulumi.Input[Union[str, 'ApplicationGatewayRequestRoutingRuleType']] rule_type: Rule type.
        :param pulumi.Input['SubResourceArgs'] url_path_map: URL path map resource of the application gateway.
        """
        if backend_address_pool is not None:
            pulumi.set(__self__, "backend_address_pool", backend_address_pool)
        if backend_http_settings is not None:
            pulumi.set(__self__, "backend_http_settings", backend_http_settings)
        if http_listener is not None:
            pulumi.set(__self__, "http_listener", http_listener)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if redirect_configuration is not None:
            pulumi.set(__self__, "redirect_configuration", redirect_configuration)
        if rewrite_rule_set is not None:
            pulumi.set(__self__, "rewrite_rule_set", rewrite_rule_set)
        if rule_type is not None:
            pulumi.set(__self__, "rule_type", rule_type)
        if url_path_map is not None:
            pulumi.set(__self__, "url_path_map", url_path_map)

    @property
    @pulumi.getter(name="backendAddressPool")
    def backend_address_pool(self) -> Optional[pulumi.Input['SubResourceArgs']]:
        """
        Backend address pool resource of the application gateway.
        """
        return pulumi.get(self, "backend_address_pool")

    @backend_address_pool.setter
    def backend_address_pool(self, value: Optional[pulumi.Input['SubResourceArgs']]):
        pulumi.set(self, "backend_address_pool", value)

    @property
    @pulumi.getter(name="backendHttpSettings")
    def backend_http_settings(self) -> Optional[pulumi.Input['SubResourceArgs']]:
        """
        Backend http settings resource of the application gateway.
        """
        return pulumi.get(self, "backend_http_settings")

    @backend_http_settings.setter
    def backend_http_settings(self, value: Optional[pulumi.Input['SubResourceArgs']]):
        pulumi.set(self, "backend_http_settings", value)

    @property
    @pulumi.getter(name="httpListener")
    def http_listener(self) -> Optional[pulumi.Input['SubResourceArgs']]:
        """
        Http listener resource of the application gateway.
        """
        return pulumi.get(self, "http_listener")

    @http_listener.setter
    def http_listener(self, value: Optional[pulumi.Input['SubResourceArgs']]):
        pulumi.set(self, "http_listener", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the request routing rule that is unique within an Application Gateway.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[int]]:
        """
        Priority of the request routing rule.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "priority", value)

    @property
    @pulumi.getter(name="redirectConfiguration")
    def redirect_configuration(self) -> Optional[pulumi.Input['SubResourceArgs']]:
        """
        Redirect configuration resource of the application gateway.
        """
        return pulumi.get(self, "redirect_configuration")

    @redirect_configuration.setter
    def redirect_configuration(self, value: Optional[pulumi.Input['SubResourceArgs']]):
        pulumi.set(self, "redirect_configuration", value)

    @property
    @pulumi.getter(name="rewriteRuleSet")
    def rewrite_rule_set(self) -> Optional[pulumi.Input['SubResourceArgs']]:
        """
        Rewrite Rule Set resource in Basic rule of the application gateway.
        """
        return pulumi.get(self, "rewrite_rule_set")

    @rewrite_rule_set.setter
    def rewrite_rule_set(self, value: Optional[pulumi.Input['SubResourceArgs']]):
        pulumi.set(self, "rewrite_rule_set", value)

    @property
    @pulumi.getter(name="ruleType")
    def rule_type(self) -> Optional[pulumi.Input[Union[str, 'ApplicationGatewayRequestRoutingRuleType']]]:
        """
        Rule type.
        """
        return pulumi.get(self, "rule_type")

    @rule_type.setter
    def rule_type(self, value: Optional[pulumi.Input[Union[str, 'ApplicationGatewayRequestRoutingRuleType']]]):
        pulumi.set(self, "rule_type", value)

    @property
    @pulumi.getter(name="urlPathMap")
    def url_path_map(self) -> Optional[pulumi.Input['SubResourceArgs']]:
        """
        URL path map resource of the application gateway.
        """
        return pulumi.get(self, "url_path_map")

    @url_path_map.setter
    def url_path_map(self, value: Optional[pulumi.Input['SubResourceArgs']]):
        pulumi.set(self, "url_path_map", value)


@pulumi.input_type
class ApplicationGatewayRewriteRuleActionSetArgs:
    def __init__(__self__, *,
                 request_header_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayHeaderConfigurationArgs']]]] = None,
                 response_header_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayHeaderConfigurationArgs']]]] = None,
                 url_configuration: Optional[pulumi.Input['ApplicationGatewayUrlConfigurationArgs']] = None):
        """
        Set of actions in the Rewrite Rule in Application Gateway.
        :param pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayHeaderConfigurationArgs']]] request_header_configurations: Request Header Actions in the Action Set.
        :param pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayHeaderConfigurationArgs']]] response_header_configurations: Response Header Actions in the Action Set.
        :param pulumi.Input['ApplicationGatewayUrlConfigurationArgs'] url_configuration: Url Configuration Action in the Action Set.
        """
        if request_header_configurations is not None:
            pulumi.set(__self__, "request_header_configurations", request_header_configurations)
        if response_header_configurations is not None:
            pulumi.set(__self__, "response_header_configurations", response_header_configurations)
        if url_configuration is not None:
            pulumi.set(__self__, "url_configuration", url_configuration)

    @property
    @pulumi.getter(name="requestHeaderConfigurations")
    def request_header_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayHeaderConfigurationArgs']]]]:
        """
        Request Header Actions in the Action Set.
        """
        return pulumi.get(self, "request_header_configurations")

    @request_header_configurations.setter
    def request_header_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayHeaderConfigurationArgs']]]]):
        pulumi.set(self, "request_header_configurations", value)

    @property
    @pulumi.getter(name="responseHeaderConfigurations")
    def response_header_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayHeaderConfigurationArgs']]]]:
        """
        Response Header Actions in the Action Set.
        """
        return pulumi.get(self, "response_header_configurations")

    @response_header_configurations.setter
    def response_header_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayHeaderConfigurationArgs']]]]):
        pulumi.set(self, "response_header_configurations", value)

    @property
    @pulumi.getter(name="urlConfiguration")
    def url_configuration(self) -> Optional[pulumi.Input['ApplicationGatewayUrlConfigurationArgs']]:
        """
        Url Configuration Action in the Action Set.
        """
        return pulumi.get(self, "url_configuration")

    @url_configuration.setter
    def url_configuration(self, value: Optional[pulumi.Input['ApplicationGatewayUrlConfigurationArgs']]):
        pulumi.set(self, "url_configuration", value)


@pulumi.input_type
class ApplicationGatewayRewriteRuleConditionArgs:
    def __init__(__self__, *,
                 ignore_case: Optional[pulumi.Input[bool]] = None,
                 negate: Optional[pulumi.Input[bool]] = None,
                 pattern: Optional[pulumi.Input[str]] = None,
                 variable: Optional[pulumi.Input[str]] = None):
        """
        Set of conditions in the Rewrite Rule in Application Gateway.
        :param pulumi.Input[bool] ignore_case: Setting this parameter to truth value with force the pattern to do a case in-sensitive comparison.
        :param pulumi.Input[bool] negate: Setting this value as truth will force to check the negation of the condition given by the user.
        :param pulumi.Input[str] pattern: The pattern, either fixed string or regular expression, that evaluates the truthfulness of the condition.
        :param pulumi.Input[str] variable: The condition parameter of the RewriteRuleCondition.
        """
        if ignore_case is not None:
            pulumi.set(__self__, "ignore_case", ignore_case)
        if negate is not None:
            pulumi.set(__self__, "negate", negate)
        if pattern is not None:
            pulumi.set(__self__, "pattern", pattern)
        if variable is not None:
            pulumi.set(__self__, "variable", variable)

    @property
    @pulumi.getter(name="ignoreCase")
    def ignore_case(self) -> Optional[pulumi.Input[bool]]:
        """
        Setting this parameter to truth value with force the pattern to do a case in-sensitive comparison.
        """
        return pulumi.get(self, "ignore_case")

    @ignore_case.setter
    def ignore_case(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ignore_case", value)

    @property
    @pulumi.getter
    def negate(self) -> Optional[pulumi.Input[bool]]:
        """
        Setting this value as truth will force to check the negation of the condition given by the user.
        """
        return pulumi.get(self, "negate")

    @negate.setter
    def negate(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "negate", value)

    @property
    @pulumi.getter
    def pattern(self) -> Optional[pulumi.Input[str]]:
        """
        The pattern, either fixed string or regular expression, that evaluates the truthfulness of the condition.
        """
        return pulumi.get(self, "pattern")

    @pattern.setter
    def pattern(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pattern", value)

    @property
    @pulumi.getter
    def variable(self) -> Optional[pulumi.Input[str]]:
        """
        The condition parameter of the RewriteRuleCondition.
        """
        return pulumi.get(self, "variable")

    @variable.setter
    def variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "variable", value)


@pulumi.input_type
class ApplicationGatewayRewriteRuleSetArgs:
    def __init__(__self__, *,
                 id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 rewrite_rules: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayRewriteRuleArgs']]]] = None):
        """
        Rewrite rule set of an application gateway.
        :param pulumi.Input[str] id: Resource ID.
        :param pulumi.Input[str] name: Name of the rewrite rule set that is unique within an Application Gateway.
        :param pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayRewriteRuleArgs']]] rewrite_rules: Rewrite rules in the rewrite rule set.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if rewrite_rules is not None:
            pulumi.set(__self__, "rewrite_rules", rewrite_rules)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the rewrite rule set that is unique within an Application Gateway.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="rewriteRules")
    def rewrite_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayRewriteRuleArgs']]]]:
        """
        Rewrite rules in the rewrite rule set.
        """
        return pulumi.get(self, "rewrite_rules")

    @rewrite_rules.setter
    def rewrite_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayRewriteRuleArgs']]]]):
        pulumi.set(self, "rewrite_rules", value)


@pulumi.input_type
class ApplicationGatewayRewriteRuleArgs:
    def __init__(__self__, *,
                 action_set: Optional[pulumi.Input['ApplicationGatewayRewriteRuleActionSetArgs']] = None,
                 conditions: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayRewriteRuleConditionArgs']]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 rule_sequence: Optional[pulumi.Input[int]] = None):
        """
        Rewrite rule of an application gateway.
        :param pulumi.Input['ApplicationGatewayRewriteRuleActionSetArgs'] action_set: Set of actions to be done as part of the rewrite Rule.
        :param pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayRewriteRuleConditionArgs']]] conditions: Conditions based on which the action set execution will be evaluated.
        :param pulumi.Input[str] name: Name of the rewrite rule that is unique within an Application Gateway.
        :param pulumi.Input[int] rule_sequence: Rule Sequence of the rewrite rule that determines the order of execution of a particular rule in a RewriteRuleSet.
        """
        if action_set is not None:
            pulumi.set(__self__, "action_set", action_set)
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if rule_sequence is not None:
            pulumi.set(__self__, "rule_sequence", rule_sequence)

    @property
    @pulumi.getter(name="actionSet")
    def action_set(self) -> Optional[pulumi.Input['ApplicationGatewayRewriteRuleActionSetArgs']]:
        """
        Set of actions to be done as part of the rewrite Rule.
        """
        return pulumi.get(self, "action_set")

    @action_set.setter
    def action_set(self, value: Optional[pulumi.Input['ApplicationGatewayRewriteRuleActionSetArgs']]):
        pulumi.set(self, "action_set", value)

    @property
    @pulumi.getter
    def conditions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayRewriteRuleConditionArgs']]]]:
        """
        Conditions based on which the action set execution will be evaluated.
        """
        return pulumi.get(self, "conditions")

    @conditions.setter
    def conditions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayRewriteRuleConditionArgs']]]]):
        pulumi.set(self, "conditions", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the rewrite rule that is unique within an Application Gateway.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="ruleSequence")
    def rule_sequence(self) -> Optional[pulumi.Input[int]]:
        """
        Rule Sequence of the rewrite rule that determines the order of execution of a particular rule in a RewriteRuleSet.
        """
        return pulumi.get(self, "rule_sequence")

    @rule_sequence.setter
    def rule_sequence(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "rule_sequence", value)


@pulumi.input_type
class ApplicationGatewaySkuArgs:
    def __init__(__self__, *,
                 capacity: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[Union[str, 'ApplicationGatewaySkuName']]] = None,
                 tier: Optional[pulumi.Input[Union[str, 'ApplicationGatewayTier']]] = None):
        """
        SKU of an application gateway.
        :param pulumi.Input[int] capacity: Capacity (instance count) of an application gateway.
        :param pulumi.Input[Union[str, 'ApplicationGatewaySkuName']] name: Name of an application gateway SKU.
        :param pulumi.Input[Union[str, 'ApplicationGatewayTier']] tier: Tier of an application gateway.
        """
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tier is not None:
            pulumi.set(__self__, "tier", tier)

    @property
    @pulumi.getter
    def capacity(self) -> Optional[pulumi.Input[int]]:
        """
        Capacity (instance count) of an application gateway.
        """
        return pulumi.get(self, "capacity")

    @capacity.setter
    def capacity(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "capacity", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[Union[str, 'ApplicationGatewaySkuName']]]:
        """
        Name of an application gateway SKU.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[Union[str, 'ApplicationGatewaySkuName']]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def tier(self) -> Optional[pulumi.Input[Union[str, 'ApplicationGatewayTier']]]:
        """
        Tier of an application gateway.
        """
        return pulumi.get(self, "tier")

    @tier.setter
    def tier(self, value: Optional[pulumi.Input[Union[str, 'ApplicationGatewayTier']]]):
        pulumi.set(self, "tier", value)


@pulumi.input_type
class ApplicationGatewaySslCertificateArgs:
    def __init__(__self__, *,
                 data: Optional[pulumi.Input[str]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 key_vault_secret_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None):
        """
        SSL certificates of an application gateway.
        :param pulumi.Input[str] data: Base-64 encoded pfx certificate. Only applicable in PUT Request.
        :param pulumi.Input[str] id: Resource ID.
        :param pulumi.Input[str] key_vault_secret_id: Secret Id of (base-64 encoded unencrypted pfx) 'Secret' or 'Certificate' object stored in KeyVault.
        :param pulumi.Input[str] name: Name of the SSL certificate that is unique within an Application Gateway.
        :param pulumi.Input[str] password: Password for the pfx file specified in data. Only applicable in PUT request.
        """
        if data is not None:
            pulumi.set(__self__, "data", data)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if key_vault_secret_id is not None:
            pulumi.set(__self__, "key_vault_secret_id", key_vault_secret_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if password is not None:
            pulumi.set(__self__, "password", password)

    @property
    @pulumi.getter
    def data(self) -> Optional[pulumi.Input[str]]:
        """
        Base-64 encoded pfx certificate. Only applicable in PUT Request.
        """
        return pulumi.get(self, "data")

    @data.setter
    def data(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "data", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="keyVaultSecretId")
    def key_vault_secret_id(self) -> Optional[pulumi.Input[str]]:
        """
        Secret Id of (base-64 encoded unencrypted pfx) 'Secret' or 'Certificate' object stored in KeyVault.
        """
        return pulumi.get(self, "key_vault_secret_id")

    @key_vault_secret_id.setter
    def key_vault_secret_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_vault_secret_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the SSL certificate that is unique within an Application Gateway.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        Password for the pfx file specified in data. Only applicable in PUT request.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)


@pulumi.input_type
class ApplicationGatewaySslPolicyArgs:
    def __init__(__self__, *,
                 cipher_suites: Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'ApplicationGatewaySslCipherSuite']]]]] = None,
                 disabled_ssl_protocols: Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'ApplicationGatewaySslProtocol']]]]] = None,
                 min_protocol_version: Optional[pulumi.Input[Union[str, 'ApplicationGatewaySslProtocol']]] = None,
                 policy_name: Optional[pulumi.Input[Union[str, 'ApplicationGatewaySslPolicyName']]] = None,
                 policy_type: Optional[pulumi.Input[Union[str, 'ApplicationGatewaySslPolicyType']]] = None):
        """
        Application Gateway Ssl policy.
        :param pulumi.Input[Sequence[pulumi.Input[Union[str, 'ApplicationGatewaySslCipherSuite']]]] cipher_suites: Ssl cipher suites to be enabled in the specified order to application gateway.
        :param pulumi.Input[Sequence[pulumi.Input[Union[str, 'ApplicationGatewaySslProtocol']]]] disabled_ssl_protocols: Ssl protocols to be disabled on application gateway.
        :param pulumi.Input[Union[str, 'ApplicationGatewaySslProtocol']] min_protocol_version: Minimum version of Ssl protocol to be supported on application gateway.
        :param pulumi.Input[Union[str, 'ApplicationGatewaySslPolicyName']] policy_name: Name of Ssl predefined policy.
        :param pulumi.Input[Union[str, 'ApplicationGatewaySslPolicyType']] policy_type: Type of Ssl Policy.
        """
        if cipher_suites is not None:
            pulumi.set(__self__, "cipher_suites", cipher_suites)
        if disabled_ssl_protocols is not None:
            pulumi.set(__self__, "disabled_ssl_protocols", disabled_ssl_protocols)
        if min_protocol_version is not None:
            pulumi.set(__self__, "min_protocol_version", min_protocol_version)
        if policy_name is not None:
            pulumi.set(__self__, "policy_name", policy_name)
        if policy_type is not None:
            pulumi.set(__self__, "policy_type", policy_type)

    @property
    @pulumi.getter(name="cipherSuites")
    def cipher_suites(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'ApplicationGatewaySslCipherSuite']]]]]:
        """
        Ssl cipher suites to be enabled in the specified order to application gateway.
        """
        return pulumi.get(self, "cipher_suites")

    @cipher_suites.setter
    def cipher_suites(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'ApplicationGatewaySslCipherSuite']]]]]):
        pulumi.set(self, "cipher_suites", value)

    @property
    @pulumi.getter(name="disabledSslProtocols")
    def disabled_ssl_protocols(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'ApplicationGatewaySslProtocol']]]]]:
        """
        Ssl protocols to be disabled on application gateway.
        """
        return pulumi.get(self, "disabled_ssl_protocols")

    @disabled_ssl_protocols.setter
    def disabled_ssl_protocols(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'ApplicationGatewaySslProtocol']]]]]):
        pulumi.set(self, "disabled_ssl_protocols", value)

    @property
    @pulumi.getter(name="minProtocolVersion")
    def min_protocol_version(self) -> Optional[pulumi.Input[Union[str, 'ApplicationGatewaySslProtocol']]]:
        """
        Minimum version of Ssl protocol to be supported on application gateway.
        """
        return pulumi.get(self, "min_protocol_version")

    @min_protocol_version.setter
    def min_protocol_version(self, value: Optional[pulumi.Input[Union[str, 'ApplicationGatewaySslProtocol']]]):
        pulumi.set(self, "min_protocol_version", value)

    @property
    @pulumi.getter(name="policyName")
    def policy_name(self) -> Optional[pulumi.Input[Union[str, 'ApplicationGatewaySslPolicyName']]]:
        """
        Name of Ssl predefined policy.
        """
        return pulumi.get(self, "policy_name")

    @policy_name.setter
    def policy_name(self, value: Optional[pulumi.Input[Union[str, 'ApplicationGatewaySslPolicyName']]]):
        pulumi.set(self, "policy_name", value)

    @property
    @pulumi.getter(name="policyType")
    def policy_type(self) -> Optional[pulumi.Input[Union[str, 'ApplicationGatewaySslPolicyType']]]:
        """
        Type of Ssl Policy.
        """
        return pulumi.get(self, "policy_type")

    @policy_type.setter
    def policy_type(self, value: Optional[pulumi.Input[Union[str, 'ApplicationGatewaySslPolicyType']]]):
        pulumi.set(self, "policy_type", value)


@pulumi.input_type
class ApplicationGatewayTrustedRootCertificateArgs:
    def __init__(__self__, *,
                 data: Optional[pulumi.Input[str]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 key_vault_secret_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        Trusted Root certificates of an application gateway.
        :param pulumi.Input[str] data: Certificate public data.
        :param pulumi.Input[str] id: Resource ID.
        :param pulumi.Input[str] key_vault_secret_id: Secret Id of (base-64 encoded unencrypted pfx) 'Secret' or 'Certificate' object stored in KeyVault.
        :param pulumi.Input[str] name: Name of the trusted root certificate that is unique within an Application Gateway.
        """
        if data is not None:
            pulumi.set(__self__, "data", data)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if key_vault_secret_id is not None:
            pulumi.set(__self__, "key_vault_secret_id", key_vault_secret_id)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def data(self) -> Optional[pulumi.Input[str]]:
        """
        Certificate public data.
        """
        return pulumi.get(self, "data")

    @data.setter
    def data(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "data", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="keyVaultSecretId")
    def key_vault_secret_id(self) -> Optional[pulumi.Input[str]]:
        """
        Secret Id of (base-64 encoded unencrypted pfx) 'Secret' or 'Certificate' object stored in KeyVault.
        """
        return pulumi.get(self, "key_vault_secret_id")

    @key_vault_secret_id.setter
    def key_vault_secret_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_vault_secret_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the trusted root certificate that is unique within an Application Gateway.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class ApplicationGatewayUrlConfigurationArgs:
    def __init__(__self__, *,
                 modified_path: Optional[pulumi.Input[str]] = None,
                 modified_query_string: Optional[pulumi.Input[str]] = None,
                 reroute: Optional[pulumi.Input[bool]] = None):
        """
        Url configuration of the Actions set in Application Gateway.
        :param pulumi.Input[str] modified_path: Url path which user has provided for url rewrite. Null means no path will be updated. Default value is null.
        :param pulumi.Input[str] modified_query_string: Query string which user has provided for url rewrite. Null means no query string will be updated. Default value is null.
        :param pulumi.Input[bool] reroute: If set as true, it will re-evaluate the url path map provided in path based request routing rules using modified path. Default value is false.
        """
        if modified_path is not None:
            pulumi.set(__self__, "modified_path", modified_path)
        if modified_query_string is not None:
            pulumi.set(__self__, "modified_query_string", modified_query_string)
        if reroute is not None:
            pulumi.set(__self__, "reroute", reroute)

    @property
    @pulumi.getter(name="modifiedPath")
    def modified_path(self) -> Optional[pulumi.Input[str]]:
        """
        Url path which user has provided for url rewrite. Null means no path will be updated. Default value is null.
        """
        return pulumi.get(self, "modified_path")

    @modified_path.setter
    def modified_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "modified_path", value)

    @property
    @pulumi.getter(name="modifiedQueryString")
    def modified_query_string(self) -> Optional[pulumi.Input[str]]:
        """
        Query string which user has provided for url rewrite. Null means no query string will be updated. Default value is null.
        """
        return pulumi.get(self, "modified_query_string")

    @modified_query_string.setter
    def modified_query_string(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "modified_query_string", value)

    @property
    @pulumi.getter
    def reroute(self) -> Optional[pulumi.Input[bool]]:
        """
        If set as true, it will re-evaluate the url path map provided in path based request routing rules using modified path. Default value is false.
        """
        return pulumi.get(self, "reroute")

    @reroute.setter
    def reroute(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "reroute", value)


@pulumi.input_type
class ApplicationGatewayUrlPathMapArgs:
    def __init__(__self__, *,
                 default_backend_address_pool: Optional[pulumi.Input['SubResourceArgs']] = None,
                 default_backend_http_settings: Optional[pulumi.Input['SubResourceArgs']] = None,
                 default_redirect_configuration: Optional[pulumi.Input['SubResourceArgs']] = None,
                 default_rewrite_rule_set: Optional[pulumi.Input['SubResourceArgs']] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 path_rules: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayPathRuleArgs']]]] = None):
        """
        UrlPathMaps give a url path to the backend mapping information for PathBasedRouting.
        :param pulumi.Input['SubResourceArgs'] default_backend_address_pool: Default backend address pool resource of URL path map.
        :param pulumi.Input['SubResourceArgs'] default_backend_http_settings: Default backend http settings resource of URL path map.
        :param pulumi.Input['SubResourceArgs'] default_redirect_configuration: Default redirect configuration resource of URL path map.
        :param pulumi.Input['SubResourceArgs'] default_rewrite_rule_set: Default Rewrite rule set resource of URL path map.
        :param pulumi.Input[str] id: Resource ID.
        :param pulumi.Input[str] name: Name of the URL path map that is unique within an Application Gateway.
        :param pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayPathRuleArgs']]] path_rules: Path rule of URL path map resource.
        """
        if default_backend_address_pool is not None:
            pulumi.set(__self__, "default_backend_address_pool", default_backend_address_pool)
        if default_backend_http_settings is not None:
            pulumi.set(__self__, "default_backend_http_settings", default_backend_http_settings)
        if default_redirect_configuration is not None:
            pulumi.set(__self__, "default_redirect_configuration", default_redirect_configuration)
        if default_rewrite_rule_set is not None:
            pulumi.set(__self__, "default_rewrite_rule_set", default_rewrite_rule_set)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if path_rules is not None:
            pulumi.set(__self__, "path_rules", path_rules)

    @property
    @pulumi.getter(name="defaultBackendAddressPool")
    def default_backend_address_pool(self) -> Optional[pulumi.Input['SubResourceArgs']]:
        """
        Default backend address pool resource of URL path map.
        """
        return pulumi.get(self, "default_backend_address_pool")

    @default_backend_address_pool.setter
    def default_backend_address_pool(self, value: Optional[pulumi.Input['SubResourceArgs']]):
        pulumi.set(self, "default_backend_address_pool", value)

    @property
    @pulumi.getter(name="defaultBackendHttpSettings")
    def default_backend_http_settings(self) -> Optional[pulumi.Input['SubResourceArgs']]:
        """
        Default backend http settings resource of URL path map.
        """
        return pulumi.get(self, "default_backend_http_settings")

    @default_backend_http_settings.setter
    def default_backend_http_settings(self, value: Optional[pulumi.Input['SubResourceArgs']]):
        pulumi.set(self, "default_backend_http_settings", value)

    @property
    @pulumi.getter(name="defaultRedirectConfiguration")
    def default_redirect_configuration(self) -> Optional[pulumi.Input['SubResourceArgs']]:
        """
        Default redirect configuration resource of URL path map.
        """
        return pulumi.get(self, "default_redirect_configuration")

    @default_redirect_configuration.setter
    def default_redirect_configuration(self, value: Optional[pulumi.Input['SubResourceArgs']]):
        pulumi.set(self, "default_redirect_configuration", value)

    @property
    @pulumi.getter(name="defaultRewriteRuleSet")
    def default_rewrite_rule_set(self) -> Optional[pulumi.Input['SubResourceArgs']]:
        """
        Default Rewrite rule set resource of URL path map.
        """
        return pulumi.get(self, "default_rewrite_rule_set")

    @default_rewrite_rule_set.setter
    def default_rewrite_rule_set(self, value: Optional[pulumi.Input['SubResourceArgs']]):
        pulumi.set(self, "default_rewrite_rule_set", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the URL path map that is unique within an Application Gateway.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="pathRules")
    def path_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayPathRuleArgs']]]]:
        """
        Path rule of URL path map resource.
        """
        return pulumi.get(self, "path_rules")

    @path_rules.setter
    def path_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayPathRuleArgs']]]]):
        pulumi.set(self, "path_rules", value)


@pulumi.input_type
class ApplicationGatewayWebApplicationFirewallConfigurationArgs:
    def __init__(__self__, *,
                 enabled: pulumi.Input[bool],
                 firewall_mode: pulumi.Input[Union[str, 'ApplicationGatewayFirewallMode']],
                 rule_set_type: pulumi.Input[str],
                 rule_set_version: pulumi.Input[str],
                 disabled_rule_groups: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayFirewallDisabledRuleGroupArgs']]]] = None,
                 exclusions: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayFirewallExclusionArgs']]]] = None,
                 file_upload_limit_in_mb: Optional[pulumi.Input[int]] = None,
                 max_request_body_size: Optional[pulumi.Input[int]] = None,
                 max_request_body_size_in_kb: Optional[pulumi.Input[int]] = None,
                 request_body_check: Optional[pulumi.Input[bool]] = None):
        """
        Application gateway web application firewall configuration.
        :param pulumi.Input[bool] enabled: Whether the web application firewall is enabled or not.
        :param pulumi.Input[Union[str, 'ApplicationGatewayFirewallMode']] firewall_mode: Web application firewall mode.
        :param pulumi.Input[str] rule_set_type: The type of the web application firewall rule set. Possible values are: 'OWASP'.
        :param pulumi.Input[str] rule_set_version: The version of the rule set type.
        :param pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayFirewallDisabledRuleGroupArgs']]] disabled_rule_groups: The disabled rule groups.
        :param pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayFirewallExclusionArgs']]] exclusions: The exclusion list.
        :param pulumi.Input[int] file_upload_limit_in_mb: Maximum file upload size in Mb for WAF.
        :param pulumi.Input[int] max_request_body_size: Maximum request body size for WAF.
        :param pulumi.Input[int] max_request_body_size_in_kb: Maximum request body size in Kb for WAF.
        :param pulumi.Input[bool] request_body_check: Whether allow WAF to check request Body.
        """
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "firewall_mode", firewall_mode)
        pulumi.set(__self__, "rule_set_type", rule_set_type)
        pulumi.set(__self__, "rule_set_version", rule_set_version)
        if disabled_rule_groups is not None:
            pulumi.set(__self__, "disabled_rule_groups", disabled_rule_groups)
        if exclusions is not None:
            pulumi.set(__self__, "exclusions", exclusions)
        if file_upload_limit_in_mb is not None:
            pulumi.set(__self__, "file_upload_limit_in_mb", file_upload_limit_in_mb)
        if max_request_body_size is not None:
            pulumi.set(__self__, "max_request_body_size", max_request_body_size)
        if max_request_body_size_in_kb is not None:
            pulumi.set(__self__, "max_request_body_size_in_kb", max_request_body_size_in_kb)
        if request_body_check is not None:
            pulumi.set(__self__, "request_body_check", request_body_check)

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[bool]:
        """
        Whether the web application firewall is enabled or not.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[bool]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="firewallMode")
    def firewall_mode(self) -> pulumi.Input[Union[str, 'ApplicationGatewayFirewallMode']]:
        """
        Web application firewall mode.
        """
        return pulumi.get(self, "firewall_mode")

    @firewall_mode.setter
    def firewall_mode(self, value: pulumi.Input[Union[str, 'ApplicationGatewayFirewallMode']]):
        pulumi.set(self, "firewall_mode", value)

    @property
    @pulumi.getter(name="ruleSetType")
    def rule_set_type(self) -> pulumi.Input[str]:
        """
        The type of the web application firewall rule set. Possible values are: 'OWASP'.
        """
        return pulumi.get(self, "rule_set_type")

    @rule_set_type.setter
    def rule_set_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "rule_set_type", value)

    @property
    @pulumi.getter(name="ruleSetVersion")
    def rule_set_version(self) -> pulumi.Input[str]:
        """
        The version of the rule set type.
        """
        return pulumi.get(self, "rule_set_version")

    @rule_set_version.setter
    def rule_set_version(self, value: pulumi.Input[str]):
        pulumi.set(self, "rule_set_version", value)

    @property
    @pulumi.getter(name="disabledRuleGroups")
    def disabled_rule_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayFirewallDisabledRuleGroupArgs']]]]:
        """
        The disabled rule groups.
        """
        return pulumi.get(self, "disabled_rule_groups")

    @disabled_rule_groups.setter
    def disabled_rule_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayFirewallDisabledRuleGroupArgs']]]]):
        pulumi.set(self, "disabled_rule_groups", value)

    @property
    @pulumi.getter
    def exclusions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayFirewallExclusionArgs']]]]:
        """
        The exclusion list.
        """
        return pulumi.get(self, "exclusions")

    @exclusions.setter
    def exclusions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayFirewallExclusionArgs']]]]):
        pulumi.set(self, "exclusions", value)

    @property
    @pulumi.getter(name="fileUploadLimitInMb")
    def file_upload_limit_in_mb(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum file upload size in Mb for WAF.
        """
        return pulumi.get(self, "file_upload_limit_in_mb")

    @file_upload_limit_in_mb.setter
    def file_upload_limit_in_mb(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "file_upload_limit_in_mb", value)

    @property
    @pulumi.getter(name="maxRequestBodySize")
    def max_request_body_size(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum request body size for WAF.
        """
        return pulumi.get(self, "max_request_body_size")

    @max_request_body_size.setter
    def max_request_body_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_request_body_size", value)

    @property
    @pulumi.getter(name="maxRequestBodySizeInKb")
    def max_request_body_size_in_kb(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum request body size in Kb for WAF.
        """
        return pulumi.get(self, "max_request_body_size_in_kb")

    @max_request_body_size_in_kb.setter
    def max_request_body_size_in_kb(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_request_body_size_in_kb", value)

    @property
    @pulumi.getter(name="requestBodyCheck")
    def request_body_check(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether allow WAF to check request Body.
        """
        return pulumi.get(self, "request_body_check")

    @request_body_check.setter
    def request_body_check(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "request_body_check", value)


@pulumi.input_type
class ApplicationRuleArgs:
    def __init__(__self__, *,
                 rule_type: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 destination_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 fqdn_tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 protocols: Optional[pulumi.Input[Sequence[pulumi.Input['FirewallPolicyRuleApplicationProtocolArgs']]]] = None,
                 source_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 source_ip_groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 target_fqdns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Rule of type application.
        :param pulumi.Input[str] rule_type: Rule Type.
               Expected value is 'ApplicationRule'.
        :param pulumi.Input[str] description: Description of the rule.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] destination_addresses: List of destination IP addresses or Service Tags.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] fqdn_tags: List of FQDN Tags for this rule.
        :param pulumi.Input[str] name: Name of the rule.
        :param pulumi.Input[Sequence[pulumi.Input['FirewallPolicyRuleApplicationProtocolArgs']]] protocols: Array of Application Protocols.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] source_addresses: List of source IP addresses for this rule.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] source_ip_groups: List of source IpGroups for this rule.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] target_fqdns: List of FQDNs for this rule.
        """
        pulumi.set(__self__, "rule_type", 'ApplicationRule')
        if description is not None:
            pulumi.set(__self__, "description", description)
        if destination_addresses is not None:
            pulumi.set(__self__, "destination_addresses", destination_addresses)
        if fqdn_tags is not None:
            pulumi.set(__self__, "fqdn_tags", fqdn_tags)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if protocols is not None:
            pulumi.set(__self__, "protocols", protocols)
        if source_addresses is not None:
            pulumi.set(__self__, "source_addresses", source_addresses)
        if source_ip_groups is not None:
            pulumi.set(__self__, "source_ip_groups", source_ip_groups)
        if target_fqdns is not None:
            pulumi.set(__self__, "target_fqdns", target_fqdns)

    @property
    @pulumi.getter(name="ruleType")
    def rule_type(self) -> pulumi.Input[str]:
        """
        Rule Type.
        Expected value is 'ApplicationRule'.
        """
        return pulumi.get(self, "rule_type")

    @rule_type.setter
    def rule_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "rule_type", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the rule.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="destinationAddresses")
    def destination_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of destination IP addresses or Service Tags.
        """
        return pulumi.get(self, "destination_addresses")

    @destination_addresses.setter
    def destination_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "destination_addresses", value)

    @property
    @pulumi.getter(name="fqdnTags")
    def fqdn_tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of FQDN Tags for this rule.
        """
        return pulumi.get(self, "fqdn_tags")

    @fqdn_tags.setter
    def fqdn_tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "fqdn_tags", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the rule.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def protocols(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FirewallPolicyRuleApplicationProtocolArgs']]]]:
        """
        Array of Application Protocols.
        """
        return pulumi.get(self, "protocols")

    @protocols.setter
    def protocols(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FirewallPolicyRuleApplicationProtocolArgs']]]]):
        pulumi.set(self, "protocols", value)

    @property
    @pulumi.getter(name="sourceAddresses")
    def source_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of source IP addresses for this rule.
        """
        return pulumi.get(self, "source_addresses")

    @source_addresses.setter
    def source_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "source_addresses", value)

    @property
    @pulumi.getter(name="sourceIpGroups")
    def source_ip_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of source IpGroups for this rule.
        """
        return pulumi.get(self, "source_ip_groups")

    @source_ip_groups.setter
    def source_ip_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "source_ip_groups", value)

    @property
    @pulumi.getter(name="targetFqdns")
    def target_fqdns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of FQDNs for this rule.
        """
        return pulumi.get(self, "target_fqdns")

    @target_fqdns.setter
    def target_fqdns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "target_fqdns", value)


@pulumi.input_type
class ApplicationSecurityGroupArgs:
    def __init__(__self__, *,
                 id: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        An application security group in a resource group.
        :param pulumi.Input[str] id: Resource ID.
        :param pulumi.Input[str] location: Resource location.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Resource tags.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        Resource location.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Resource tags.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class AzureFirewallApplicationRuleCollectionArgs:
    def __init__(__self__, *,
                 action: Optional[pulumi.Input['AzureFirewallRCActionArgs']] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 priority: Optional[pulumi.Input[int]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input['AzureFirewallApplicationRuleArgs']]]] = None):
        """
        Application rule collection resource.
        :param pulumi.Input['AzureFirewallRCActionArgs'] action: The action type of a rule collection.
        :param pulumi.Input[str] id: Resource ID.
        :param pulumi.Input[str] name: The name of the resource that is unique within the Azure firewall. This name can be used to access the resource.
        :param pulumi.Input[int] priority: Priority of the application rule collection resource.
        :param pulumi.Input[Sequence[pulumi.Input['AzureFirewallApplicationRuleArgs']]] rules: Collection of rules used by a application rule collection.
        """
        if action is not None:
            pulumi.set(__self__, "action", action)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)

    @property
    @pulumi.getter
    def action(self) -> Optional[pulumi.Input['AzureFirewallRCActionArgs']]:
        """
        The action type of a rule collection.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: Optional[pulumi.Input['AzureFirewallRCActionArgs']]):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the resource that is unique within the Azure firewall. This name can be used to access the resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[int]]:
        """
        Priority of the application rule collection resource.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "priority", value)

    @property
    @pulumi.getter
    def rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AzureFirewallApplicationRuleArgs']]]]:
        """
        Collection of rules used by a application rule collection.
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AzureFirewallApplicationRuleArgs']]]]):
        pulumi.set(self, "rules", value)


@pulumi.input_type
class AzureFirewallApplicationRuleProtocolArgs:
    def __init__(__self__, *,
                 port: Optional[pulumi.Input[int]] = None,
                 protocol_type: Optional[pulumi.Input[Union[str, 'AzureFirewallApplicationRuleProtocolType']]] = None):
        """
        Properties of the application rule protocol.
        :param pulumi.Input[int] port: Port number for the protocol, cannot be greater than 64000. This field is optional.
        :param pulumi.Input[Union[str, 'AzureFirewallApplicationRuleProtocolType']] protocol_type: Protocol type.
        """
        if port is not None:
            pulumi.set(__self__, "port", port)
        if protocol_type is not None:
            pulumi.set(__self__, "protocol_type", protocol_type)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        Port number for the protocol, cannot be greater than 64000. This field is optional.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter(name="protocolType")
    def protocol_type(self) -> Optional[pulumi.Input[Union[str, 'AzureFirewallApplicationRuleProtocolType']]]:
        """
        Protocol type.
        """
        return pulumi.get(self, "protocol_type")

    @protocol_type.setter
    def protocol_type(self, value: Optional[pulumi.Input[Union[str, 'AzureFirewallApplicationRuleProtocolType']]]):
        pulumi.set(self, "protocol_type", value)


@pulumi.input_type
class AzureFirewallApplicationRuleArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 fqdn_tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 protocols: Optional[pulumi.Input[Sequence[pulumi.Input['AzureFirewallApplicationRuleProtocolArgs']]]] = None,
                 source_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 source_ip_groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 target_fqdns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Properties of an application rule.
        :param pulumi.Input[str] description: Description of the rule.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] fqdn_tags: List of FQDN Tags for this rule.
        :param pulumi.Input[str] name: Name of the application rule.
        :param pulumi.Input[Sequence[pulumi.Input['AzureFirewallApplicationRuleProtocolArgs']]] protocols: Array of ApplicationRuleProtocols.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] source_addresses: List of source IP addresses for this rule.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] source_ip_groups: List of source IpGroups for this rule.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] target_fqdns: List of FQDNs for this rule.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if fqdn_tags is not None:
            pulumi.set(__self__, "fqdn_tags", fqdn_tags)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if protocols is not None:
            pulumi.set(__self__, "protocols", protocols)
        if source_addresses is not None:
            pulumi.set(__self__, "source_addresses", source_addresses)
        if source_ip_groups is not None:
            pulumi.set(__self__, "source_ip_groups", source_ip_groups)
        if target_fqdns is not None:
            pulumi.set(__self__, "target_fqdns", target_fqdns)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the rule.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="fqdnTags")
    def fqdn_tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of FQDN Tags for this rule.
        """
        return pulumi.get(self, "fqdn_tags")

    @fqdn_tags.setter
    def fqdn_tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "fqdn_tags", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the application rule.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def protocols(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AzureFirewallApplicationRuleProtocolArgs']]]]:
        """
        Array of ApplicationRuleProtocols.
        """
        return pulumi.get(self, "protocols")

    @protocols.setter
    def protocols(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AzureFirewallApplicationRuleProtocolArgs']]]]):
        pulumi.set(self, "protocols", value)

    @property
    @pulumi.getter(name="sourceAddresses")
    def source_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of source IP addresses for this rule.
        """
        return pulumi.get(self, "source_addresses")

    @source_addresses.setter
    def source_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "source_addresses", value)

    @property
    @pulumi.getter(name="sourceIpGroups")
    def source_ip_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of source IpGroups for this rule.
        """
        return pulumi.get(self, "source_ip_groups")

    @source_ip_groups.setter
    def source_ip_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "source_ip_groups", value)

    @property
    @pulumi.getter(name="targetFqdns")
    def target_fqdns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of FQDNs for this rule.
        """
        return pulumi.get(self, "target_fqdns")

    @target_fqdns.setter
    def target_fqdns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "target_fqdns", value)


@pulumi.input_type
class AzureFirewallIPConfigurationArgs:
    def __init__(__self__, *,
                 id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 public_ip_address: Optional[pulumi.Input['SubResourceArgs']] = None,
                 subnet: Optional[pulumi.Input['SubResourceArgs']] = None):
        """
        IP configuration of an Azure Firewall.
        :param pulumi.Input[str] id: Resource ID.
        :param pulumi.Input[str] name: Name of the resource that is unique within a resource group. This name can be used to access the resource.
        :param pulumi.Input['SubResourceArgs'] public_ip_address: Reference to the PublicIP resource. This field is a mandatory input if subnet is not null.
        :param pulumi.Input['SubResourceArgs'] subnet: Reference to the subnet resource. This resource must be named 'AzureFirewallSubnet' or 'AzureFirewallManagementSubnet'.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if public_ip_address is not None:
            pulumi.set(__self__, "public_ip_address", public_ip_address)
        if subnet is not None:
            pulumi.set(__self__, "subnet", subnet)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the resource that is unique within a resource group. This name can be used to access the resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="publicIPAddress")
    def public_ip_address(self) -> Optional[pulumi.Input['SubResourceArgs']]:
        """
        Reference to the PublicIP resource. This field is a mandatory input if subnet is not null.
        """
        return pulumi.get(self, "public_ip_address")

    @public_ip_address.setter
    def public_ip_address(self, value: Optional[pulumi.Input['SubResourceArgs']]):
        pulumi.set(self, "public_ip_address", value)

    @property
    @pulumi.getter
    def subnet(self) -> Optional[pulumi.Input['SubResourceArgs']]:
        """
        Reference to the subnet resource. This resource must be named 'AzureFirewallSubnet' or 'AzureFirewallManagementSubnet'.
        """
        return pulumi.get(self, "subnet")

    @subnet.setter
    def subnet(self, value: Optional[pulumi.Input['SubResourceArgs']]):
        pulumi.set(self, "subnet", value)


@pulumi.input_type
class AzureFirewallNatRCActionArgs:
    def __init__(__self__, *,
                 type: Optional[pulumi.Input[Union[str, 'AzureFirewallNatRCActionType']]] = None):
        """
        AzureFirewall NAT Rule Collection Action.
        :param pulumi.Input[Union[str, 'AzureFirewallNatRCActionType']] type: The type of action.
        """
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[Union[str, 'AzureFirewallNatRCActionType']]]:
        """
        The type of action.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[Union[str, 'AzureFirewallNatRCActionType']]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class AzureFirewallNatRuleCollectionArgs:
    def __init__(__self__, *,
                 action: Optional[pulumi.Input['AzureFirewallNatRCActionArgs']] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 priority: Optional[pulumi.Input[int]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input['AzureFirewallNatRuleArgs']]]] = None):
        """
        NAT rule collection resource.
        :param pulumi.Input['AzureFirewallNatRCActionArgs'] action: The action type of a NAT rule collection.
        :param pulumi.Input[str] id: Resource ID.
        :param pulumi.Input[str] name: The name of the resource that is unique within the Azure firewall. This name can be used to access the resource.
        :param pulumi.Input[int] priority: Priority of the NAT rule collection resource.
        :param pulumi.Input[Sequence[pulumi.Input['AzureFirewallNatRuleArgs']]] rules: Collection of rules used by a NAT rule collection.
        """
        if action is not None:
            pulumi.set(__self__, "action", action)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)

    @property
    @pulumi.getter
    def action(self) -> Optional[pulumi.Input['AzureFirewallNatRCActionArgs']]:
        """
        The action type of a NAT rule collection.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: Optional[pulumi.Input['AzureFirewallNatRCActionArgs']]):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the resource that is unique within the Azure firewall. This name can be used to access the resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[int]]:
        """
        Priority of the NAT rule collection resource.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "priority", value)

    @property
    @pulumi.getter
    def rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AzureFirewallNatRuleArgs']]]]:
        """
        Collection of rules used by a NAT rule collection.
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AzureFirewallNatRuleArgs']]]]):
        pulumi.set(self, "rules", value)


@pulumi.input_type
class AzureFirewallNatRuleArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 destination_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 destination_ports: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 protocols: Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'AzureFirewallNetworkRuleProtocol']]]]] = None,
                 source_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 source_ip_groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 translated_address: Optional[pulumi.Input[str]] = None,
                 translated_fqdn: Optional[pulumi.Input[str]] = None,
                 translated_port: Optional[pulumi.Input[str]] = None):
        """
        Properties of a NAT rule.
        :param pulumi.Input[str] description: Description of the rule.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] destination_addresses: List of destination IP addresses for this rule. Supports IP ranges, prefixes, and service tags.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] destination_ports: List of destination ports.
        :param pulumi.Input[str] name: Name of the NAT rule.
        :param pulumi.Input[Sequence[pulumi.Input[Union[str, 'AzureFirewallNetworkRuleProtocol']]]] protocols: Array of AzureFirewallNetworkRuleProtocols applicable to this NAT rule.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] source_addresses: List of source IP addresses for this rule.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] source_ip_groups: List of source IpGroups for this rule.
        :param pulumi.Input[str] translated_address: The translated address for this NAT rule.
        :param pulumi.Input[str] translated_fqdn: The translated FQDN for this NAT rule.
        :param pulumi.Input[str] translated_port: The translated port for this NAT rule.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if destination_addresses is not None:
            pulumi.set(__self__, "destination_addresses", destination_addresses)
        if destination_ports is not None:
            pulumi.set(__self__, "destination_ports", destination_ports)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if protocols is not None:
            pulumi.set(__self__, "protocols", protocols)
        if source_addresses is not None:
            pulumi.set(__self__, "source_addresses", source_addresses)
        if source_ip_groups is not None:
            pulumi.set(__self__, "source_ip_groups", source_ip_groups)
        if translated_address is not None:
            pulumi.set(__self__, "translated_address", translated_address)
        if translated_fqdn is not None:
            pulumi.set(__self__, "translated_fqdn", translated_fqdn)
        if translated_port is not None:
            pulumi.set(__self__, "translated_port", translated_port)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the rule.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="destinationAddresses")
    def destination_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of destination IP addresses for this rule. Supports IP ranges, prefixes, and service tags.
        """
        return pulumi.get(self, "destination_addresses")

    @destination_addresses.setter
    def destination_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "destination_addresses", value)

    @property
    @pulumi.getter(name="destinationPorts")
    def destination_ports(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of destination ports.
        """
        return pulumi.get(self, "destination_ports")

    @destination_ports.setter
    def destination_ports(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "destination_ports", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the NAT rule.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def protocols(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'AzureFirewallNetworkRuleProtocol']]]]]:
        """
        Array of AzureFirewallNetworkRuleProtocols applicable to this NAT rule.
        """
        return pulumi.get(self, "protocols")

    @protocols.setter
    def protocols(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'AzureFirewallNetworkRuleProtocol']]]]]):
        pulumi.set(self, "protocols", value)

    @property
    @pulumi.getter(name="sourceAddresses")
    def source_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of source IP addresses for this rule.
        """
        return pulumi.get(self, "source_addresses")

    @source_addresses.setter
    def source_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "source_addresses", value)

    @property
    @pulumi.getter(name="sourceIpGroups")
    def source_ip_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of source IpGroups for this rule.
        """
        return pulumi.get(self, "source_ip_groups")

    @source_ip_groups.setter
    def source_ip_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "source_ip_groups", value)

    @property
    @pulumi.getter(name="translatedAddress")
    def translated_address(self) -> Optional[pulumi.Input[str]]:
        """
        The translated address for this NAT rule.
        """
        return pulumi.get(self, "translated_address")

    @translated_address.setter
    def translated_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "translated_address", value)

    @property
    @pulumi.getter(name="translatedFqdn")
    def translated_fqdn(self) -> Optional[pulumi.Input[str]]:
        """
        The translated FQDN for this NAT rule.
        """
        return pulumi.get(self, "translated_fqdn")

    @translated_fqdn.setter
    def translated_fqdn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "translated_fqdn", value)

    @property
    @pulumi.getter(name="translatedPort")
    def translated_port(self) -> Optional[pulumi.Input[str]]:
        """
        The translated port for this NAT rule.
        """
        return pulumi.get(self, "translated_port")

    @translated_port.setter
    def translated_port(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "translated_port", value)


@pulumi.input_type
class AzureFirewallNetworkRuleCollectionArgs:
    def __init__(__self__, *,
                 action: Optional[pulumi.Input['AzureFirewallRCActionArgs']] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 priority: Optional[pulumi.Input[int]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input['AzureFirewallNetworkRuleArgs']]]] = None):
        """
        Network rule collection resource.
        :param pulumi.Input['AzureFirewallRCActionArgs'] action: The action type of a rule collection.
        :param pulumi.Input[str] id: Resource ID.
        :param pulumi.Input[str] name: The name of the resource that is unique within the Azure firewall. This name can be used to access the resource.
        :param pulumi.Input[int] priority: Priority of the network rule collection resource.
        :param pulumi.Input[Sequence[pulumi.Input['AzureFirewallNetworkRuleArgs']]] rules: Collection of rules used by a network rule collection.
        """
        if action is not None:
            pulumi.set(__self__, "action", action)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)

    @property
    @pulumi.getter
    def action(self) -> Optional[pulumi.Input['AzureFirewallRCActionArgs']]:
        """
        The action type of a rule collection.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: Optional[pulumi.Input['AzureFirewallRCActionArgs']]):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the resource that is unique within the Azure firewall. This name can be used to access the resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[int]]:
        """
        Priority of the network rule collection resource.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "priority", value)

    @property
    @pulumi.getter
    def rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AzureFirewallNetworkRuleArgs']]]]:
        """
        Collection of rules used by a network rule collection.
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AzureFirewallNetworkRuleArgs']]]]):
        pulumi.set(self, "rules", value)


@pulumi.input_type
class AzureFirewallNetworkRuleArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 destination_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 destination_fqdns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 destination_ip_groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 destination_ports: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 protocols: Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'AzureFirewallNetworkRuleProtocol']]]]] = None,
                 source_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 source_ip_groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Properties of the network rule.
        :param pulumi.Input[str] description: Description of the rule.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] destination_addresses: List of destination IP addresses.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] destination_fqdns: List of destination FQDNs.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] destination_ip_groups: List of destination IpGroups for this rule.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] destination_ports: List of destination ports.
        :param pulumi.Input[str] name: Name of the network rule.
        :param pulumi.Input[Sequence[pulumi.Input[Union[str, 'AzureFirewallNetworkRuleProtocol']]]] protocols: Array of AzureFirewallNetworkRuleProtocols.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] source_addresses: List of source IP addresses for this rule.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] source_ip_groups: List of source IpGroups for this rule.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if destination_addresses is not None:
            pulumi.set(__self__, "destination_addresses", destination_addresses)
        if destination_fqdns is not None:
            pulumi.set(__self__, "destination_fqdns", destination_fqdns)
        if destination_ip_groups is not None:
            pulumi.set(__self__, "destination_ip_groups", destination_ip_groups)
        if destination_ports is not None:
            pulumi.set(__self__, "destination_ports", destination_ports)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if protocols is not None:
            pulumi.set(__self__, "protocols", protocols)
        if source_addresses is not None:
            pulumi.set(__self__, "source_addresses", source_addresses)
        if source_ip_groups is not None:
            pulumi.set(__self__, "source_ip_groups", source_ip_groups)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the rule.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="destinationAddresses")
    def destination_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of destination IP addresses.
        """
        return pulumi.get(self, "destination_addresses")

    @destination_addresses.setter
    def destination_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "destination_addresses", value)

    @property
    @pulumi.getter(name="destinationFqdns")
    def destination_fqdns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of destination FQDNs.
        """
        return pulumi.get(self, "destination_fqdns")

    @destination_fqdns.setter
    def destination_fqdns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "destination_fqdns", value)

    @property
    @pulumi.getter(name="destinationIpGroups")
    def destination_ip_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of destination IpGroups for this rule.
        """
        return pulumi.get(self, "destination_ip_groups")

    @destination_ip_groups.setter
    def destination_ip_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "destination_ip_groups", value)

    @property
    @pulumi.getter(name="destinationPorts")
    def destination_ports(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of destination ports.
        """
        return pulumi.get(self, "destination_ports")

    @destination_ports.setter
    def destination_ports(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "destination_ports", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the network rule.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def protocols(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'AzureFirewallNetworkRuleProtocol']]]]]:
        """
        Array of AzureFirewallNetworkRuleProtocols.
        """
        return pulumi.get(self, "protocols")

    @protocols.setter
    def protocols(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'AzureFirewallNetworkRuleProtocol']]]]]):
        pulumi.set(self, "protocols", value)

    @property
    @pulumi.getter(name="sourceAddresses")
    def source_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of source IP addresses for this rule.
        """
        return pulumi.get(self, "source_addresses")

    @source_addresses.setter
    def source_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "source_addresses", value)

    @property
    @pulumi.getter(name="sourceIpGroups")
    def source_ip_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of source IpGroups for this rule.
        """
        return pulumi.get(self, "source_ip_groups")

    @source_ip_groups.setter
    def source_ip_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "source_ip_groups", value)


@pulumi.input_type
class AzureFirewallPublicIPAddressArgs:
    def __init__(__self__, *,
                 address: Optional[pulumi.Input[str]] = None):
        """
        Public IP Address associated with azure firewall.
        :param pulumi.Input[str] address: Public IP Address value.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)

    @property
    @pulumi.getter
    def address(self) -> Optional[pulumi.Input[str]]:
        """
        Public IP Address value.
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "address", value)


@pulumi.input_type
class AzureFirewallRCActionArgs:
    def __init__(__self__, *,
                 type: Optional[pulumi.Input[Union[str, 'AzureFirewallRCActionType']]] = None):
        """
        Properties of the AzureFirewallRCAction.
        :param pulumi.Input[Union[str, 'AzureFirewallRCActionType']] type: The type of action.
        """
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[Union[str, 'AzureFirewallRCActionType']]]:
        """
        The type of action.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[Union[str, 'AzureFirewallRCActionType']]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class AzureFirewallSkuArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[Union[str, 'AzureFirewallSkuName']]] = None,
                 tier: Optional[pulumi.Input[Union[str, 'AzureFirewallSkuTier']]] = None):
        """
        SKU of an Azure Firewall.
        :param pulumi.Input[Union[str, 'AzureFirewallSkuName']] name: Name of an Azure Firewall SKU.
        :param pulumi.Input[Union[str, 'AzureFirewallSkuTier']] tier: Tier of an Azure Firewall.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tier is not None:
            pulumi.set(__self__, "tier", tier)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[Union[str, 'AzureFirewallSkuName']]]:
        """
        Name of an Azure Firewall SKU.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[Union[str, 'AzureFirewallSkuName']]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def tier(self) -> Optional[pulumi.Input[Union[str, 'AzureFirewallSkuTier']]]:
        """
        Tier of an Azure Firewall.
        """
        return pulumi.get(self, "tier")

    @tier.setter
    def tier(self, value: Optional[pulumi.Input[Union[str, 'AzureFirewallSkuTier']]]):
        pulumi.set(self, "tier", value)


@pulumi.input_type
class BackendAddressPoolArgs:
    def __init__(__self__, *,
                 id: Optional[pulumi.Input[str]] = None,
                 load_balancer_backend_addresses: Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerBackendAddressArgs']]]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        Pool of backend IP addresses.
        :param pulumi.Input[str] id: Resource ID.
        :param pulumi.Input[Sequence[pulumi.Input['LoadBalancerBackendAddressArgs']]] load_balancer_backend_addresses: An array of backend addresses.
        :param pulumi.Input[str] name: The name of the resource that is unique within the set of backend address pools used by the load balancer. This name can be used to access the resource.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if load_balancer_backend_addresses is not None:
            pulumi.set(__self__, "load_balancer_backend_addresses", load_balancer_backend_addresses)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="loadBalancerBackendAddresses")
    def load_balancer_backend_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerBackendAddressArgs']]]]:
        """
        An array of backend addresses.
        """
        return pulumi.get(self, "load_balancer_backend_addresses")

    @load_balancer_backend_addresses.setter
    def load_balancer_backend_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerBackendAddressArgs']]]]):
        pulumi.set(self, "load_balancer_backend_addresses", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the resource that is unique within the set of backend address pools used by the load balancer. This name can be used to access the resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class BackendPoolsSettingsArgs:
    def __init__(__self__, *,
                 enforce_certificate_name_check: Optional[pulumi.Input[Union[str, 'EnforceCertificateNameCheckEnabledState']]] = None,
                 send_recv_timeout_seconds: Optional[pulumi.Input[int]] = None):
        """
        Settings that apply to all backend pools.
        :param pulumi.Input[Union[str, 'EnforceCertificateNameCheckEnabledState']] enforce_certificate_name_check: Whether to enforce certificate name check on HTTPS requests to all backend pools. No effect on non-HTTPS requests.
        :param pulumi.Input[int] send_recv_timeout_seconds: Send and receive timeout on forwarding request to the backend. When timeout is reached, the request fails and returns.
        """
        if enforce_certificate_name_check is None:
            enforce_certificate_name_check = 'Enabled'
        if enforce_certificate_name_check is not None:
            pulumi.set(__self__, "enforce_certificate_name_check", enforce_certificate_name_check)
        if send_recv_timeout_seconds is not None:
            pulumi.set(__self__, "send_recv_timeout_seconds", send_recv_timeout_seconds)

    @property
    @pulumi.getter(name="enforceCertificateNameCheck")
    def enforce_certificate_name_check(self) -> Optional[pulumi.Input[Union[str, 'EnforceCertificateNameCheckEnabledState']]]:
        """
        Whether to enforce certificate name check on HTTPS requests to all backend pools. No effect on non-HTTPS requests.
        """
        return pulumi.get(self, "enforce_certificate_name_check")

    @enforce_certificate_name_check.setter
    def enforce_certificate_name_check(self, value: Optional[pulumi.Input[Union[str, 'EnforceCertificateNameCheckEnabledState']]]):
        pulumi.set(self, "enforce_certificate_name_check", value)

    @property
    @pulumi.getter(name="sendRecvTimeoutSeconds")
    def send_recv_timeout_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        Send and receive timeout on forwarding request to the backend. When timeout is reached, the request fails and returns.
        """
        return pulumi.get(self, "send_recv_timeout_seconds")

    @send_recv_timeout_seconds.setter
    def send_recv_timeout_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "send_recv_timeout_seconds", value)


@pulumi.input_type
class BackendPoolArgs:
    def __init__(__self__, *,
                 backends: Optional[pulumi.Input[Sequence[pulumi.Input['BackendArgs']]]] = None,
                 health_probe_settings: Optional[pulumi.Input['SubResourceArgs']] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 load_balancing_settings: Optional[pulumi.Input['SubResourceArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        A backend pool is a collection of backends that can be routed to.
        :param pulumi.Input[Sequence[pulumi.Input['BackendArgs']]] backends: The set of backends for this pool
        :param pulumi.Input['SubResourceArgs'] health_probe_settings: L7 health probe settings for a backend pool
        :param pulumi.Input[str] id: Resource ID.
        :param pulumi.Input['SubResourceArgs'] load_balancing_settings: Load balancing settings for a backend pool
        :param pulumi.Input[str] name: Resource name.
        """
        if backends is not None:
            pulumi.set(__self__, "backends", backends)
        if health_probe_settings is not None:
            pulumi.set(__self__, "health_probe_settings", health_probe_settings)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if load_balancing_settings is not None:
            pulumi.set(__self__, "load_balancing_settings", load_balancing_settings)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def backends(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BackendArgs']]]]:
        """
        The set of backends for this pool
        """
        return pulumi.get(self, "backends")

    @backends.setter
    def backends(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BackendArgs']]]]):
        pulumi.set(self, "backends", value)

    @property
    @pulumi.getter(name="healthProbeSettings")
    def health_probe_settings(self) -> Optional[pulumi.Input['SubResourceArgs']]:
        """
        L7 health probe settings for a backend pool
        """
        return pulumi.get(self, "health_probe_settings")

    @health_probe_settings.setter
    def health_probe_settings(self, value: Optional[pulumi.Input['SubResourceArgs']]):
        pulumi.set(self, "health_probe_settings", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="loadBalancingSettings")
    def load_balancing_settings(self) -> Optional[pulumi.Input['SubResourceArgs']]:
        """
        Load balancing settings for a backend pool
        """
        return pulumi.get(self, "load_balancing_settings")

    @load_balancing_settings.setter
    def load_balancing_settings(self, value: Optional[pulumi.Input['SubResourceArgs']]):
        pulumi.set(self, "load_balancing_settings", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Resource name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class BackendArgs:
    def __init__(__self__, *,
                 address: Optional[pulumi.Input[str]] = None,
                 backend_host_header: Optional[pulumi.Input[str]] = None,
                 enabled_state: Optional[pulumi.Input[Union[str, 'BackendEnabledState']]] = None,
                 http_port: Optional[pulumi.Input[int]] = None,
                 https_port: Optional[pulumi.Input[int]] = None,
                 priority: Optional[pulumi.Input[int]] = None,
                 private_link_alias: Optional[pulumi.Input[str]] = None,
                 private_link_approval_message: Optional[pulumi.Input[str]] = None,
                 private_link_location: Optional[pulumi.Input[str]] = None,
                 private_link_resource_id: Optional[pulumi.Input[str]] = None,
                 weight: Optional[pulumi.Input[int]] = None):
        """
        Backend address of a frontDoor load balancer.
        :param pulumi.Input[str] address: Location of the backend (IP address or FQDN)
        :param pulumi.Input[str] backend_host_header: The value to use as the host header sent to the backend. If blank or unspecified, this defaults to the incoming host.
        :param pulumi.Input[Union[str, 'BackendEnabledState']] enabled_state: Whether to enable use of this backend. Permitted values are 'Enabled' or 'Disabled'
        :param pulumi.Input[int] http_port: The HTTP TCP port number. Must be between 1 and 65535.
        :param pulumi.Input[int] https_port: The HTTPS TCP port number. Must be between 1 and 65535.
        :param pulumi.Input[int] priority: Priority to use for load balancing. Higher priorities will not be used for load balancing if any lower priority backend is healthy.
        :param pulumi.Input[str] private_link_alias: The Alias of the Private Link resource. Populating this optional field indicates that this backend is 'Private'
        :param pulumi.Input[str] private_link_approval_message: A custom message to be included in the approval request to connect to the Private Link
        :param pulumi.Input[str] private_link_location: The location of the Private Link resource. Required only if 'privateLinkResourceId' is populated
        :param pulumi.Input[str] private_link_resource_id: The Resource Id of the Private Link resource. Populating this optional field indicates that this backend is 'Private'
        :param pulumi.Input[int] weight: Weight of this endpoint for load balancing purposes.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if backend_host_header is not None:
            pulumi.set(__self__, "backend_host_header", backend_host_header)
        if enabled_state is not None:
            pulumi.set(__self__, "enabled_state", enabled_state)
        if http_port is not None:
            pulumi.set(__self__, "http_port", http_port)
        if https_port is not None:
            pulumi.set(__self__, "https_port", https_port)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if private_link_alias is not None:
            pulumi.set(__self__, "private_link_alias", private_link_alias)
        if private_link_approval_message is not None:
            pulumi.set(__self__, "private_link_approval_message", private_link_approval_message)
        if private_link_location is not None:
            pulumi.set(__self__, "private_link_location", private_link_location)
        if private_link_resource_id is not None:
            pulumi.set(__self__, "private_link_resource_id", private_link_resource_id)
        if weight is not None:
            pulumi.set(__self__, "weight", weight)

    @property
    @pulumi.getter
    def address(self) -> Optional[pulumi.Input[str]]:
        """
        Location of the backend (IP address or FQDN)
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "address", value)

    @property
    @pulumi.getter(name="backendHostHeader")
    def backend_host_header(self) -> Optional[pulumi.Input[str]]:
        """
        The value to use as the host header sent to the backend. If blank or unspecified, this defaults to the incoming host.
        """
        return pulumi.get(self, "backend_host_header")

    @backend_host_header.setter
    def backend_host_header(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backend_host_header", value)

    @property
    @pulumi.getter(name="enabledState")
    def enabled_state(self) -> Optional[pulumi.Input[Union[str, 'BackendEnabledState']]]:
        """
        Whether to enable use of this backend. Permitted values are 'Enabled' or 'Disabled'
        """
        return pulumi.get(self, "enabled_state")

    @enabled_state.setter
    def enabled_state(self, value: Optional[pulumi.Input[Union[str, 'BackendEnabledState']]]):
        pulumi.set(self, "enabled_state", value)

    @property
    @pulumi.getter(name="httpPort")
    def http_port(self) -> Optional[pulumi.Input[int]]:
        """
        The HTTP TCP port number. Must be between 1 and 65535.
        """
        return pulumi.get(self, "http_port")

    @http_port.setter
    def http_port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "http_port", value)

    @property
    @pulumi.getter(name="httpsPort")
    def https_port(self) -> Optional[pulumi.Input[int]]:
        """
        The HTTPS TCP port number. Must be between 1 and 65535.
        """
        return pulumi.get(self, "https_port")

    @https_port.setter
    def https_port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "https_port", value)

    @property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[int]]:
        """
        Priority to use for load balancing. Higher priorities will not be used for load balancing if any lower priority backend is healthy.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "priority", value)

    @property
    @pulumi.getter(name="privateLinkAlias")
    def private_link_alias(self) -> Optional[pulumi.Input[str]]:
        """
        The Alias of the Private Link resource. Populating this optional field indicates that this backend is 'Private'
        """
        return pulumi.get(self, "private_link_alias")

    @private_link_alias.setter
    def private_link_alias(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_link_alias", value)

    @property
    @pulumi.getter(name="privateLinkApprovalMessage")
    def private_link_approval_message(self) -> Optional[pulumi.Input[str]]:
        """
        A custom message to be included in the approval request to connect to the Private Link
        """
        return pulumi.get(self, "private_link_approval_message")

    @private_link_approval_message.setter
    def private_link_approval_message(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_link_approval_message", value)

    @property
    @pulumi.getter(name="privateLinkLocation")
    def private_link_location(self) -> Optional[pulumi.Input[str]]:
        """
        The location of the Private Link resource. Required only if 'privateLinkResourceId' is populated
        """
        return pulumi.get(self, "private_link_location")

    @private_link_location.setter
    def private_link_location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_link_location", value)

    @property
    @pulumi.getter(name="privateLinkResourceId")
    def private_link_resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        The Resource Id of the Private Link resource. Populating this optional field indicates that this backend is 'Private'
        """
        return pulumi.get(self, "private_link_resource_id")

    @private_link_resource_id.setter
    def private_link_resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_link_resource_id", value)

    @property
    @pulumi.getter
    def weight(self) -> Optional[pulumi.Input[int]]:
        """
        Weight of this endpoint for load balancing purposes.
        """
        return pulumi.get(self, "weight")

    @weight.setter
    def weight(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "weight", value)


@pulumi.input_type
class BastionHostIPConfigurationArgs:
    def __init__(__self__, *,
                 public_ip_address: pulumi.Input['SubResourceArgs'],
                 subnet: pulumi.Input['SubResourceArgs'],
                 id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 private_ip_allocation_method: Optional[pulumi.Input[Union[str, 'IPAllocationMethod']]] = None):
        """
        IP configuration of an Bastion Host.
        :param pulumi.Input['SubResourceArgs'] public_ip_address: Reference of the PublicIP resource.
        :param pulumi.Input['SubResourceArgs'] subnet: Reference of the subnet resource.
        :param pulumi.Input[str] id: Resource ID.
        :param pulumi.Input[str] name: Name of the resource that is unique within a resource group. This name can be used to access the resource.
        :param pulumi.Input[Union[str, 'IPAllocationMethod']] private_ip_allocation_method: Private IP allocation method.
        """
        pulumi.set(__self__, "public_ip_address", public_ip_address)
        pulumi.set(__self__, "subnet", subnet)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if private_ip_allocation_method is not None:
            pulumi.set(__self__, "private_ip_allocation_method", private_ip_allocation_method)

    @property
    @pulumi.getter(name="publicIPAddress")
    def public_ip_address(self) -> pulumi.Input['SubResourceArgs']:
        """
        Reference of the PublicIP resource.
        """
        return pulumi.get(self, "public_ip_address")

    @public_ip_address.setter
    def public_ip_address(self, value: pulumi.Input['SubResourceArgs']):
        pulumi.set(self, "public_ip_address", value)

    @property
    @pulumi.getter
    def subnet(self) -> pulumi.Input['SubResourceArgs']:
        """
        Reference of the subnet resource.
        """
        return pulumi.get(self, "subnet")

    @subnet.setter
    def subnet(self, value: pulumi.Input['SubResourceArgs']):
        pulumi.set(self, "subnet", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the resource that is unique within a resource group. This name can be used to access the resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="privateIPAllocationMethod")
    def private_ip_allocation_method(self) -> Optional[pulumi.Input[Union[str, 'IPAllocationMethod']]]:
        """
        Private IP allocation method.
        """
        return pulumi.get(self, "private_ip_allocation_method")

    @private_ip_allocation_method.setter
    def private_ip_allocation_method(self, value: Optional[pulumi.Input[Union[str, 'IPAllocationMethod']]]):
        pulumi.set(self, "private_ip_allocation_method", value)


@pulumi.input_type
class BastionShareableLink:
    def __init__(__self__, *,
                 vm: 'VM'):
        """
        Bastion Shareable Link.
        :param 'VM' vm: Reference of the virtual machine resource.
        """
        pulumi.set(__self__, "vm", vm)

    @property
    @pulumi.getter
    def vm(self) -> 'VM':
        """
        Reference of the virtual machine resource.
        """
        return pulumi.get(self, "vm")

    @vm.setter
    def vm(self, value: 'VM'):
        pulumi.set(self, "vm", value)


@pulumi.input_type
class BgpSettingsArgs:
    def __init__(__self__, *,
                 asn: Optional[pulumi.Input[float]] = None,
                 bgp_peering_address: Optional[pulumi.Input[str]] = None,
                 bgp_peering_addresses: Optional[pulumi.Input[Sequence[pulumi.Input['IPConfigurationBgpPeeringAddressArgs']]]] = None,
                 peer_weight: Optional[pulumi.Input[int]] = None):
        """
        BGP settings details.
        :param pulumi.Input[float] asn: The BGP speaker's ASN.
        :param pulumi.Input[str] bgp_peering_address: The BGP peering address and BGP identifier of this BGP speaker.
        :param pulumi.Input[Sequence[pulumi.Input['IPConfigurationBgpPeeringAddressArgs']]] bgp_peering_addresses: BGP peering address with IP configuration ID for virtual network gateway.
        :param pulumi.Input[int] peer_weight: The weight added to routes learned from this BGP speaker.
        """
        if asn is not None:
            pulumi.set(__self__, "asn", asn)
        if bgp_peering_address is not None:
            pulumi.set(__self__, "bgp_peering_address", bgp_peering_address)
        if bgp_peering_addresses is not None:
            pulumi.set(__self__, "bgp_peering_addresses", bgp_peering_addresses)
        if peer_weight is not None:
            pulumi.set(__self__, "peer_weight", peer_weight)

    @property
    @pulumi.getter
    def asn(self) -> Optional[pulumi.Input[float]]:
        """
        The BGP speaker's ASN.
        """
        return pulumi.get(self, "asn")

    @asn.setter
    def asn(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "asn", value)

    @property
    @pulumi.getter(name="bgpPeeringAddress")
    def bgp_peering_address(self) -> Optional[pulumi.Input[str]]:
        """
        The BGP peering address and BGP identifier of this BGP speaker.
        """
        return pulumi.get(self, "bgp_peering_address")

    @bgp_peering_address.setter
    def bgp_peering_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bgp_peering_address", value)

    @property
    @pulumi.getter(name="bgpPeeringAddresses")
    def bgp_peering_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IPConfigurationBgpPeeringAddressArgs']]]]:
        """
        BGP peering address with IP configuration ID for virtual network gateway.
        """
        return pulumi.get(self, "bgp_peering_addresses")

    @bgp_peering_addresses.setter
    def bgp_peering_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IPConfigurationBgpPeeringAddressArgs']]]]):
        pulumi.set(self, "bgp_peering_addresses", value)

    @property
    @pulumi.getter(name="peerWeight")
    def peer_weight(self) -> Optional[pulumi.Input[int]]:
        """
        The weight added to routes learned from this BGP speaker.
        """
        return pulumi.get(self, "peer_weight")

    @peer_weight.setter
    def peer_weight(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "peer_weight", value)


@pulumi.input_type
class BreakOutCategoryPoliciesArgs:
    def __init__(__self__, *,
                 allow: Optional[pulumi.Input[bool]] = None,
                 default: Optional[pulumi.Input[bool]] = None,
                 optimize: Optional[pulumi.Input[bool]] = None):
        """
        Network Virtual Appliance Sku Properties.
        :param pulumi.Input[bool] allow: Flag to control breakout of o365 allow category.
        :param pulumi.Input[bool] default: Flag to control breakout of o365 default category.
        :param pulumi.Input[bool] optimize: Flag to control breakout of o365 optimize category.
        """
        if allow is not None:
            pulumi.set(__self__, "allow", allow)
        if default is not None:
            pulumi.set(__self__, "default", default)
        if optimize is not None:
            pulumi.set(__self__, "optimize", optimize)

    @property
    @pulumi.getter
    def allow(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag to control breakout of o365 allow category.
        """
        return pulumi.get(self, "allow")

    @allow.setter
    def allow(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow", value)

    @property
    @pulumi.getter
    def default(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag to control breakout of o365 default category.
        """
        return pulumi.get(self, "default")

    @default.setter
    def default(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "default", value)

    @property
    @pulumi.getter
    def optimize(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag to control breakout of o365 optimize category.
        """
        return pulumi.get(self, "optimize")

    @optimize.setter
    def optimize(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "optimize", value)


@pulumi.input_type
class CacheConfigurationArgs:
    def __init__(__self__, *,
                 cache_duration: Optional[pulumi.Input[str]] = None,
                 dynamic_compression: Optional[pulumi.Input[Union[str, 'DynamicCompressionEnabled']]] = None,
                 query_parameter_strip_directive: Optional[pulumi.Input[Union[str, 'FrontDoorQuery']]] = None,
                 query_parameters: Optional[pulumi.Input[str]] = None):
        """
        Caching settings for a caching-type route. To disable caching, do not provide a cacheConfiguration object.
        :param pulumi.Input[str] cache_duration: The duration for which the content needs to be cached. Allowed format is in ISO 8601 format (http://en.wikipedia.org/wiki/ISO_8601#Durations). HTTP requires the value to be no more than a year
        :param pulumi.Input[Union[str, 'DynamicCompressionEnabled']] dynamic_compression: Whether to use dynamic compression for cached content
        :param pulumi.Input[Union[str, 'FrontDoorQuery']] query_parameter_strip_directive: Treatment of URL query terms when forming the cache key.
        :param pulumi.Input[str] query_parameters: query parameters to include or exclude (comma separated).
        """
        if cache_duration is not None:
            pulumi.set(__self__, "cache_duration", cache_duration)
        if dynamic_compression is not None:
            pulumi.set(__self__, "dynamic_compression", dynamic_compression)
        if query_parameter_strip_directive is not None:
            pulumi.set(__self__, "query_parameter_strip_directive", query_parameter_strip_directive)
        if query_parameters is not None:
            pulumi.set(__self__, "query_parameters", query_parameters)

    @property
    @pulumi.getter(name="cacheDuration")
    def cache_duration(self) -> Optional[pulumi.Input[str]]:
        """
        The duration for which the content needs to be cached. Allowed format is in ISO 8601 format (http://en.wikipedia.org/wiki/ISO_8601#Durations). HTTP requires the value to be no more than a year
        """
        return pulumi.get(self, "cache_duration")

    @cache_duration.setter
    def cache_duration(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cache_duration", value)

    @property
    @pulumi.getter(name="dynamicCompression")
    def dynamic_compression(self) -> Optional[pulumi.Input[Union[str, 'DynamicCompressionEnabled']]]:
        """
        Whether to use dynamic compression for cached content
        """
        return pulumi.get(self, "dynamic_compression")

    @dynamic_compression.setter
    def dynamic_compression(self, value: Optional[pulumi.Input[Union[str, 'DynamicCompressionEnabled']]]):
        pulumi.set(self, "dynamic_compression", value)

    @property
    @pulumi.getter(name="queryParameterStripDirective")
    def query_parameter_strip_directive(self) -> Optional[pulumi.Input[Union[str, 'FrontDoorQuery']]]:
        """
        Treatment of URL query terms when forming the cache key.
        """
        return pulumi.get(self, "query_parameter_strip_directive")

    @query_parameter_strip_directive.setter
    def query_parameter_strip_directive(self, value: Optional[pulumi.Input[Union[str, 'FrontDoorQuery']]]):
        pulumi.set(self, "query_parameter_strip_directive", value)

    @property
    @pulumi.getter(name="queryParameters")
    def query_parameters(self) -> Optional[pulumi.Input[str]]:
        """
        query parameters to include or exclude (comma separated).
        """
        return pulumi.get(self, "query_parameters")

    @query_parameters.setter
    def query_parameters(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "query_parameters", value)


@pulumi.input_type
class ConnectionMonitorDestinationArgs:
    def __init__(__self__, *,
                 address: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 resource_id: Optional[pulumi.Input[str]] = None):
        """
        Describes the destination of connection monitor.
        :param pulumi.Input[str] address: Address of the connection monitor destination (IP or domain name).
        :param pulumi.Input[int] port: The destination port used by connection monitor.
        :param pulumi.Input[str] resource_id: The ID of the resource used as the destination by connection monitor.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)

    @property
    @pulumi.getter
    def address(self) -> Optional[pulumi.Input[str]]:
        """
        Address of the connection monitor destination (IP or domain name).
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "address", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        The destination port used by connection monitor.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the resource used as the destination by connection monitor.
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_id", value)


@pulumi.input_type
class ConnectionMonitorEndpointFilterItemArgs:
    def __init__(__self__, *,
                 address: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[Union[str, 'ConnectionMonitorEndpointFilterItemType']]] = None):
        """
        Describes the connection monitor endpoint filter item.
        :param pulumi.Input[str] address: The address of the filter item.
        :param pulumi.Input[Union[str, 'ConnectionMonitorEndpointFilterItemType']] type: The type of item included in the filter. Currently only 'AgentAddress' is supported.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def address(self) -> Optional[pulumi.Input[str]]:
        """
        The address of the filter item.
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "address", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[Union[str, 'ConnectionMonitorEndpointFilterItemType']]]:
        """
        The type of item included in the filter. Currently only 'AgentAddress' is supported.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[Union[str, 'ConnectionMonitorEndpointFilterItemType']]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class ConnectionMonitorEndpointFilterArgs:
    def __init__(__self__, *,
                 items: Optional[pulumi.Input[Sequence[pulumi.Input['ConnectionMonitorEndpointFilterItemArgs']]]] = None,
                 type: Optional[pulumi.Input[Union[str, 'ConnectionMonitorEndpointFilterType']]] = None):
        """
        Describes the connection monitor endpoint filter.
        :param pulumi.Input[Sequence[pulumi.Input['ConnectionMonitorEndpointFilterItemArgs']]] items: List of items in the filter.
        :param pulumi.Input[Union[str, 'ConnectionMonitorEndpointFilterType']] type: The behavior of the endpoint filter. Currently only 'Include' is supported.
        """
        if items is not None:
            pulumi.set(__self__, "items", items)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def items(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ConnectionMonitorEndpointFilterItemArgs']]]]:
        """
        List of items in the filter.
        """
        return pulumi.get(self, "items")

    @items.setter
    def items(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ConnectionMonitorEndpointFilterItemArgs']]]]):
        pulumi.set(self, "items", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[Union[str, 'ConnectionMonitorEndpointFilterType']]]:
        """
        The behavior of the endpoint filter. Currently only 'Include' is supported.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[Union[str, 'ConnectionMonitorEndpointFilterType']]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class ConnectionMonitorEndpointArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 address: Optional[pulumi.Input[str]] = None,
                 filter: Optional[pulumi.Input['ConnectionMonitorEndpointFilterArgs']] = None,
                 resource_id: Optional[pulumi.Input[str]] = None):
        """
        Describes the connection monitor endpoint.
        :param pulumi.Input[str] name: The name of the connection monitor endpoint.
        :param pulumi.Input[str] address: Address of the connection monitor endpoint (IP or domain name).
        :param pulumi.Input['ConnectionMonitorEndpointFilterArgs'] filter: Filter for sub-items within the endpoint.
        :param pulumi.Input[str] resource_id: Resource ID of the connection monitor endpoint.
        """
        pulumi.set(__self__, "name", name)
        if address is not None:
            pulumi.set(__self__, "address", address)
        if filter is not None:
            pulumi.set(__self__, "filter", filter)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the connection monitor endpoint.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def address(self) -> Optional[pulumi.Input[str]]:
        """
        Address of the connection monitor endpoint (IP or domain name).
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "address", value)

    @property
    @pulumi.getter
    def filter(self) -> Optional[pulumi.Input['ConnectionMonitorEndpointFilterArgs']]:
        """
        Filter for sub-items within the endpoint.
        """
        return pulumi.get(self, "filter")

    @filter.setter
    def filter(self, value: Optional[pulumi.Input['ConnectionMonitorEndpointFilterArgs']]):
        pulumi.set(self, "filter", value)

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        Resource ID of the connection monitor endpoint.
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_id", value)


@pulumi.input_type
class ConnectionMonitorHttpConfigurationArgs:
    def __init__(__self__, *,
                 method: Optional[pulumi.Input[Union[str, 'HTTPConfigurationMethod']]] = None,
                 path: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 prefer_https: Optional[pulumi.Input[bool]] = None,
                 request_headers: Optional[pulumi.Input[Sequence[pulumi.Input['HTTPHeaderArgs']]]] = None,
                 valid_status_code_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Describes the HTTP configuration.
        :param pulumi.Input[Union[str, 'HTTPConfigurationMethod']] method: The HTTP method to use.
        :param pulumi.Input[str] path: The path component of the URI. For instance, "/dir1/dir2".
        :param pulumi.Input[int] port: The port to connect to.
        :param pulumi.Input[bool] prefer_https: Value indicating whether HTTPS is preferred over HTTP in cases where the choice is not explicit.
        :param pulumi.Input[Sequence[pulumi.Input['HTTPHeaderArgs']]] request_headers: The HTTP headers to transmit with the request.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] valid_status_code_ranges: HTTP status codes to consider successful. For instance, "2xx,301-304,418".
        """
        if method is not None:
            pulumi.set(__self__, "method", method)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if prefer_https is not None:
            pulumi.set(__self__, "prefer_https", prefer_https)
        if request_headers is not None:
            pulumi.set(__self__, "request_headers", request_headers)
        if valid_status_code_ranges is not None:
            pulumi.set(__self__, "valid_status_code_ranges", valid_status_code_ranges)

    @property
    @pulumi.getter
    def method(self) -> Optional[pulumi.Input[Union[str, 'HTTPConfigurationMethod']]]:
        """
        The HTTP method to use.
        """
        return pulumi.get(self, "method")

    @method.setter
    def method(self, value: Optional[pulumi.Input[Union[str, 'HTTPConfigurationMethod']]]):
        pulumi.set(self, "method", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        The path component of the URI. For instance, "/dir1/dir2".
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        The port to connect to.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter(name="preferHTTPS")
    def prefer_https(self) -> Optional[pulumi.Input[bool]]:
        """
        Value indicating whether HTTPS is preferred over HTTP in cases where the choice is not explicit.
        """
        return pulumi.get(self, "prefer_https")

    @prefer_https.setter
    def prefer_https(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "prefer_https", value)

    @property
    @pulumi.getter(name="requestHeaders")
    def request_headers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['HTTPHeaderArgs']]]]:
        """
        The HTTP headers to transmit with the request.
        """
        return pulumi.get(self, "request_headers")

    @request_headers.setter
    def request_headers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['HTTPHeaderArgs']]]]):
        pulumi.set(self, "request_headers", value)

    @property
    @pulumi.getter(name="validStatusCodeRanges")
    def valid_status_code_ranges(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        HTTP status codes to consider successful. For instance, "2xx,301-304,418".
        """
        return pulumi.get(self, "valid_status_code_ranges")

    @valid_status_code_ranges.setter
    def valid_status_code_ranges(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "valid_status_code_ranges", value)


@pulumi.input_type
class ConnectionMonitorIcmpConfigurationArgs:
    def __init__(__self__, *,
                 disable_trace_route: Optional[pulumi.Input[bool]] = None):
        """
        Describes the ICMP configuration.
        :param pulumi.Input[bool] disable_trace_route: Value indicating whether path evaluation with trace route should be disabled.
        """
        if disable_trace_route is not None:
            pulumi.set(__self__, "disable_trace_route", disable_trace_route)

    @property
    @pulumi.getter(name="disableTraceRoute")
    def disable_trace_route(self) -> Optional[pulumi.Input[bool]]:
        """
        Value indicating whether path evaluation with trace route should be disabled.
        """
        return pulumi.get(self, "disable_trace_route")

    @disable_trace_route.setter
    def disable_trace_route(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable_trace_route", value)


@pulumi.input_type
class ConnectionMonitorOutputArgs:
    def __init__(__self__, *,
                 type: Optional[pulumi.Input[Union[str, 'OutputType']]] = None,
                 workspace_settings: Optional[pulumi.Input['ConnectionMonitorWorkspaceSettingsArgs']] = None):
        """
        Describes a connection monitor output destination.
        :param pulumi.Input[Union[str, 'OutputType']] type: Connection monitor output destination type. Currently, only "Workspace" is supported.
        :param pulumi.Input['ConnectionMonitorWorkspaceSettingsArgs'] workspace_settings: Describes the settings for producing output into a log analytics workspace.
        """
        if type is not None:
            pulumi.set(__self__, "type", type)
        if workspace_settings is not None:
            pulumi.set(__self__, "workspace_settings", workspace_settings)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[Union[str, 'OutputType']]]:
        """
        Connection monitor output destination type. Currently, only "Workspace" is supported.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[Union[str, 'OutputType']]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="workspaceSettings")
    def workspace_settings(self) -> Optional[pulumi.Input['ConnectionMonitorWorkspaceSettingsArgs']]:
        """
        Describes the settings for producing output into a log analytics workspace.
        """
        return pulumi.get(self, "workspace_settings")

    @workspace_settings.setter
    def workspace_settings(self, value: Optional[pulumi.Input['ConnectionMonitorWorkspaceSettingsArgs']]):
        pulumi.set(self, "workspace_settings", value)


@pulumi.input_type
class ConnectionMonitorSourceArgs:
    def __init__(__self__, *,
                 resource_id: pulumi.Input[str],
                 port: Optional[pulumi.Input[int]] = None):
        """
        Describes the source of connection monitor.
        :param pulumi.Input[str] resource_id: The ID of the resource used as the source by connection monitor.
        :param pulumi.Input[int] port: The source port used by connection monitor.
        """
        pulumi.set(__self__, "resource_id", resource_id)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> pulumi.Input[str]:
        """
        The ID of the resource used as the source by connection monitor.
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "resource_id", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        The source port used by connection monitor.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)


@pulumi.input_type
class ConnectionMonitorSuccessThresholdArgs:
    def __init__(__self__, *,
                 checks_failed_percent: Optional[pulumi.Input[int]] = None,
                 round_trip_time_ms: Optional[pulumi.Input[float]] = None):
        """
        Describes the threshold for declaring a test successful.
        :param pulumi.Input[int] checks_failed_percent: The maximum percentage of failed checks permitted for a test to evaluate as successful.
        :param pulumi.Input[float] round_trip_time_ms: The maximum round-trip time in milliseconds permitted for a test to evaluate as successful.
        """
        if checks_failed_percent is not None:
            pulumi.set(__self__, "checks_failed_percent", checks_failed_percent)
        if round_trip_time_ms is not None:
            pulumi.set(__self__, "round_trip_time_ms", round_trip_time_ms)

    @property
    @pulumi.getter(name="checksFailedPercent")
    def checks_failed_percent(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum percentage of failed checks permitted for a test to evaluate as successful.
        """
        return pulumi.get(self, "checks_failed_percent")

    @checks_failed_percent.setter
    def checks_failed_percent(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "checks_failed_percent", value)

    @property
    @pulumi.getter(name="roundTripTimeMs")
    def round_trip_time_ms(self) -> Optional[pulumi.Input[float]]:
        """
        The maximum round-trip time in milliseconds permitted for a test to evaluate as successful.
        """
        return pulumi.get(self, "round_trip_time_ms")

    @round_trip_time_ms.setter
    def round_trip_time_ms(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "round_trip_time_ms", value)


@pulumi.input_type
class ConnectionMonitorTcpConfigurationArgs:
    def __init__(__self__, *,
                 disable_trace_route: Optional[pulumi.Input[bool]] = None,
                 port: Optional[pulumi.Input[int]] = None):
        """
        Describes the TCP configuration.
        :param pulumi.Input[bool] disable_trace_route: Value indicating whether path evaluation with trace route should be disabled.
        :param pulumi.Input[int] port: The port to connect to.
        """
        if disable_trace_route is not None:
            pulumi.set(__self__, "disable_trace_route", disable_trace_route)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter(name="disableTraceRoute")
    def disable_trace_route(self) -> Optional[pulumi.Input[bool]]:
        """
        Value indicating whether path evaluation with trace route should be disabled.
        """
        return pulumi.get(self, "disable_trace_route")

    @disable_trace_route.setter
    def disable_trace_route(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable_trace_route", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        The port to connect to.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)


@pulumi.input_type
class ConnectionMonitorTestConfigurationArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 protocol: pulumi.Input[Union[str, 'ConnectionMonitorTestConfigurationProtocol']],
                 http_configuration: Optional[pulumi.Input['ConnectionMonitorHttpConfigurationArgs']] = None,
                 icmp_configuration: Optional[pulumi.Input['ConnectionMonitorIcmpConfigurationArgs']] = None,
                 preferred_ip_version: Optional[pulumi.Input[Union[str, 'PreferredIPVersion']]] = None,
                 success_threshold: Optional[pulumi.Input['ConnectionMonitorSuccessThresholdArgs']] = None,
                 tcp_configuration: Optional[pulumi.Input['ConnectionMonitorTcpConfigurationArgs']] = None,
                 test_frequency_sec: Optional[pulumi.Input[int]] = None):
        """
        Describes a connection monitor test configuration.
        :param pulumi.Input[str] name: The name of the connection monitor test configuration.
        :param pulumi.Input[Union[str, 'ConnectionMonitorTestConfigurationProtocol']] protocol: The protocol to use in test evaluation.
        :param pulumi.Input['ConnectionMonitorHttpConfigurationArgs'] http_configuration: The parameters used to perform test evaluation over HTTP.
        :param pulumi.Input['ConnectionMonitorIcmpConfigurationArgs'] icmp_configuration: The parameters used to perform test evaluation over ICMP.
        :param pulumi.Input[Union[str, 'PreferredIPVersion']] preferred_ip_version: The preferred IP version to use in test evaluation. The connection monitor may choose to use a different version depending on other parameters.
        :param pulumi.Input['ConnectionMonitorSuccessThresholdArgs'] success_threshold: The threshold for declaring a test successful.
        :param pulumi.Input['ConnectionMonitorTcpConfigurationArgs'] tcp_configuration: The parameters used to perform test evaluation over TCP.
        :param pulumi.Input[int] test_frequency_sec: The frequency of test evaluation, in seconds.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "protocol", protocol)
        if http_configuration is not None:
            pulumi.set(__self__, "http_configuration", http_configuration)
        if icmp_configuration is not None:
            pulumi.set(__self__, "icmp_configuration", icmp_configuration)
        if preferred_ip_version is not None:
            pulumi.set(__self__, "preferred_ip_version", preferred_ip_version)
        if success_threshold is not None:
            pulumi.set(__self__, "success_threshold", success_threshold)
        if tcp_configuration is not None:
            pulumi.set(__self__, "tcp_configuration", tcp_configuration)
        if test_frequency_sec is not None:
            pulumi.set(__self__, "test_frequency_sec", test_frequency_sec)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the connection monitor test configuration.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def protocol(self) -> pulumi.Input[Union[str, 'ConnectionMonitorTestConfigurationProtocol']]:
        """
        The protocol to use in test evaluation.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: pulumi.Input[Union[str, 'ConnectionMonitorTestConfigurationProtocol']]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter(name="httpConfiguration")
    def http_configuration(self) -> Optional[pulumi.Input['ConnectionMonitorHttpConfigurationArgs']]:
        """
        The parameters used to perform test evaluation over HTTP.
        """
        return pulumi.get(self, "http_configuration")

    @http_configuration.setter
    def http_configuration(self, value: Optional[pulumi.Input['ConnectionMonitorHttpConfigurationArgs']]):
        pulumi.set(self, "http_configuration", value)

    @property
    @pulumi.getter(name="icmpConfiguration")
    def icmp_configuration(self) -> Optional[pulumi.Input['ConnectionMonitorIcmpConfigurationArgs']]:
        """
        The parameters used to perform test evaluation over ICMP.
        """
        return pulumi.get(self, "icmp_configuration")

    @icmp_configuration.setter
    def icmp_configuration(self, value: Optional[pulumi.Input['ConnectionMonitorIcmpConfigurationArgs']]):
        pulumi.set(self, "icmp_configuration", value)

    @property
    @pulumi.getter(name="preferredIPVersion")
    def preferred_ip_version(self) -> Optional[pulumi.Input[Union[str, 'PreferredIPVersion']]]:
        """
        The preferred IP version to use in test evaluation. The connection monitor may choose to use a different version depending on other parameters.
        """
        return pulumi.get(self, "preferred_ip_version")

    @preferred_ip_version.setter
    def preferred_ip_version(self, value: Optional[pulumi.Input[Union[str, 'PreferredIPVersion']]]):
        pulumi.set(self, "preferred_ip_version", value)

    @property
    @pulumi.getter(name="successThreshold")
    def success_threshold(self) -> Optional[pulumi.Input['ConnectionMonitorSuccessThresholdArgs']]:
        """
        The threshold for declaring a test successful.
        """
        return pulumi.get(self, "success_threshold")

    @success_threshold.setter
    def success_threshold(self, value: Optional[pulumi.Input['ConnectionMonitorSuccessThresholdArgs']]):
        pulumi.set(self, "success_threshold", value)

    @property
    @pulumi.getter(name="tcpConfiguration")
    def tcp_configuration(self) -> Optional[pulumi.Input['ConnectionMonitorTcpConfigurationArgs']]:
        """
        The parameters used to perform test evaluation over TCP.
        """
        return pulumi.get(self, "tcp_configuration")

    @tcp_configuration.setter
    def tcp_configuration(self, value: Optional[pulumi.Input['ConnectionMonitorTcpConfigurationArgs']]):
        pulumi.set(self, "tcp_configuration", value)

    @property
    @pulumi.getter(name="testFrequencySec")
    def test_frequency_sec(self) -> Optional[pulumi.Input[int]]:
        """
        The frequency of test evaluation, in seconds.
        """
        return pulumi.get(self, "test_frequency_sec")

    @test_frequency_sec.setter
    def test_frequency_sec(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "test_frequency_sec", value)


@pulumi.input_type
class ConnectionMonitorTestGroupArgs:
    def __init__(__self__, *,
                 destinations: pulumi.Input[Sequence[pulumi.Input[str]]],
                 name: pulumi.Input[str],
                 sources: pulumi.Input[Sequence[pulumi.Input[str]]],
                 test_configurations: pulumi.Input[Sequence[pulumi.Input[str]]],
                 disable: Optional[pulumi.Input[bool]] = None):
        """
        Describes the connection monitor test group.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] destinations: List of destination endpoint names.
        :param pulumi.Input[str] name: The name of the connection monitor test group.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] sources: List of source endpoint names.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] test_configurations: List of test configuration names.
        :param pulumi.Input[bool] disable: Value indicating whether test group is disabled.
        """
        pulumi.set(__self__, "destinations", destinations)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "sources", sources)
        pulumi.set(__self__, "test_configurations", test_configurations)
        if disable is not None:
            pulumi.set(__self__, "disable", disable)

    @property
    @pulumi.getter
    def destinations(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        List of destination endpoint names.
        """
        return pulumi.get(self, "destinations")

    @destinations.setter
    def destinations(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "destinations", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the connection monitor test group.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def sources(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        List of source endpoint names.
        """
        return pulumi.get(self, "sources")

    @sources.setter
    def sources(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "sources", value)

    @property
    @pulumi.getter(name="testConfigurations")
    def test_configurations(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        List of test configuration names.
        """
        return pulumi.get(self, "test_configurations")

    @test_configurations.setter
    def test_configurations(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "test_configurations", value)

    @property
    @pulumi.getter
    def disable(self) -> Optional[pulumi.Input[bool]]:
        """
        Value indicating whether test group is disabled.
        """
        return pulumi.get(self, "disable")

    @disable.setter
    def disable(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable", value)


@pulumi.input_type
class ConnectionMonitorWorkspaceSettingsArgs:
    def __init__(__self__, *,
                 workspace_resource_id: Optional[pulumi.Input[str]] = None):
        """
        Describes the settings for producing output into a log analytics workspace.
        :param pulumi.Input[str] workspace_resource_id: Log analytics workspace resource ID.
        """
        if workspace_resource_id is not None:
            pulumi.set(__self__, "workspace_resource_id", workspace_resource_id)

    @property
    @pulumi.getter(name="workspaceResourceId")
    def workspace_resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        Log analytics workspace resource ID.
        """
        return pulumi.get(self, "workspace_resource_id")

    @workspace_resource_id.setter
    def workspace_resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "workspace_resource_id", value)


@pulumi.input_type
class ContainerNetworkInterfaceConfigurationArgs:
    def __init__(__self__, *,
                 container_network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input['SubResourceArgs']]]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 ip_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['IPConfigurationProfileArgs']]]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        Container network interface configuration child resource.
        :param pulumi.Input[Sequence[pulumi.Input['SubResourceArgs']]] container_network_interfaces: A list of container network interfaces created from this container network interface configuration.
        :param pulumi.Input[str] id: Resource ID.
        :param pulumi.Input[Sequence[pulumi.Input['IPConfigurationProfileArgs']]] ip_configurations: A list of ip configurations of the container network interface configuration.
        :param pulumi.Input[str] name: The name of the resource. This name can be used to access the resource.
        """
        if container_network_interfaces is not None:
            pulumi.set(__self__, "container_network_interfaces", container_network_interfaces)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if ip_configurations is not None:
            pulumi.set(__self__, "ip_configurations", ip_configurations)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="containerNetworkInterfaces")
    def container_network_interfaces(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SubResourceArgs']]]]:
        """
        A list of container network interfaces created from this container network interface configuration.
        """
        return pulumi.get(self, "container_network_interfaces")

    @container_network_interfaces.setter
    def container_network_interfaces(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SubResourceArgs']]]]):
        pulumi.set(self, "container_network_interfaces", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="ipConfigurations")
    def ip_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IPConfigurationProfileArgs']]]]:
        """
        A list of ip configurations of the container network interface configuration.
        """
        return pulumi.get(self, "ip_configurations")

    @ip_configurations.setter
    def ip_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IPConfigurationProfileArgs']]]]):
        pulumi.set(self, "ip_configurations", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the resource. This name can be used to access the resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class CustomDnsConfigPropertiesFormatArgs:
    def __init__(__self__, *,
                 fqdn: Optional[pulumi.Input[str]] = None,
                 ip_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Contains custom Dns resolution configuration from customer.
        :param pulumi.Input[str] fqdn: Fqdn that resolves to private endpoint ip address.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ip_addresses: A list of private ip addresses of the private endpoint.
        """
        if fqdn is not None:
            pulumi.set(__self__, "fqdn", fqdn)
        if ip_addresses is not None:
            pulumi.set(__self__, "ip_addresses", ip_addresses)

    @property
    @pulumi.getter
    def fqdn(self) -> Optional[pulumi.Input[str]]:
        """
        Fqdn that resolves to private endpoint ip address.
        """
        return pulumi.get(self, "fqdn")

    @fqdn.setter
    def fqdn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fqdn", value)

    @property
    @pulumi.getter(name="ipAddresses")
    def ip_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of private ip addresses of the private endpoint.
        """
        return pulumi.get(self, "ip_addresses")

    @ip_addresses.setter
    def ip_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "ip_addresses", value)


@pulumi.input_type
class DdosSettingsArgs:
    def __init__(__self__, *,
                 ddos_custom_policy: Optional[pulumi.Input['SubResourceArgs']] = None,
                 protected_ip: Optional[pulumi.Input[bool]] = None,
                 protection_coverage: Optional[pulumi.Input[Union[str, 'DdosSettingsProtectionCoverage']]] = None):
        """
        Contains the DDoS protection settings of the public IP.
        :param pulumi.Input['SubResourceArgs'] ddos_custom_policy: The DDoS custom policy associated with the public IP.
        :param pulumi.Input[bool] protected_ip: Enables DDoS protection on the public IP.
        :param pulumi.Input[Union[str, 'DdosSettingsProtectionCoverage']] protection_coverage: The DDoS protection policy customizability of the public IP. Only standard coverage will have the ability to be customized.
        """
        if ddos_custom_policy is not None:
            pulumi.set(__self__, "ddos_custom_policy", ddos_custom_policy)
        if protected_ip is not None:
            pulumi.set(__self__, "protected_ip", protected_ip)
        if protection_coverage is not None:
            pulumi.set(__self__, "protection_coverage", protection_coverage)

    @property
    @pulumi.getter(name="ddosCustomPolicy")
    def ddos_custom_policy(self) -> Optional[pulumi.Input['SubResourceArgs']]:
        """
        The DDoS custom policy associated with the public IP.
        """
        return pulumi.get(self, "ddos_custom_policy")

    @ddos_custom_policy.setter
    def ddos_custom_policy(self, value: Optional[pulumi.Input['SubResourceArgs']]):
        pulumi.set(self, "ddos_custom_policy", value)

    @property
    @pulumi.getter(name="protectedIP")
    def protected_ip(self) -> Optional[pulumi.Input[bool]]:
        """
        Enables DDoS protection on the public IP.
        """
        return pulumi.get(self, "protected_ip")

    @protected_ip.setter
    def protected_ip(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "protected_ip", value)

    @property
    @pulumi.getter(name="protectionCoverage")
    def protection_coverage(self) -> Optional[pulumi.Input[Union[str, 'DdosSettingsProtectionCoverage']]]:
        """
        The DDoS protection policy customizability of the public IP. Only standard coverage will have the ability to be customized.
        """
        return pulumi.get(self, "protection_coverage")

    @protection_coverage.setter
    def protection_coverage(self, value: Optional[pulumi.Input[Union[str, 'DdosSettingsProtectionCoverage']]]):
        pulumi.set(self, "protection_coverage", value)


@pulumi.input_type
class DelegationArgs:
    def __init__(__self__, *,
                 id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 service_name: Optional[pulumi.Input[str]] = None):
        """
        Details the service to which the subnet is delegated.
        :param pulumi.Input[str] id: Resource ID.
        :param pulumi.Input[str] name: The name of the resource that is unique within a subnet. This name can be used to access the resource.
        :param pulumi.Input[str] service_name: The name of the service to whom the subnet should be delegated (e.g. Microsoft.Sql/servers).
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if service_name is not None:
            pulumi.set(__self__, "service_name", service_name)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the resource that is unique within a subnet. This name can be used to access the resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the service to whom the subnet should be delegated (e.g. Microsoft.Sql/servers).
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_name", value)


@pulumi.input_type
class DevicePropertiesArgs:
    def __init__(__self__, *,
                 device_model: Optional[pulumi.Input[str]] = None,
                 device_vendor: Optional[pulumi.Input[str]] = None,
                 link_speed_in_mbps: Optional[pulumi.Input[int]] = None):
        """
        List of properties of the device.
        :param pulumi.Input[str] device_model: Model of the device.
        :param pulumi.Input[str] device_vendor: Name of the device Vendor.
        :param pulumi.Input[int] link_speed_in_mbps: Link speed.
        """
        if device_model is not None:
            pulumi.set(__self__, "device_model", device_model)
        if device_vendor is not None:
            pulumi.set(__self__, "device_vendor", device_vendor)
        if link_speed_in_mbps is not None:
            pulumi.set(__self__, "link_speed_in_mbps", link_speed_in_mbps)

    @property
    @pulumi.getter(name="deviceModel")
    def device_model(self) -> Optional[pulumi.Input[str]]:
        """
        Model of the device.
        """
        return pulumi.get(self, "device_model")

    @device_model.setter
    def device_model(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "device_model", value)

    @property
    @pulumi.getter(name="deviceVendor")
    def device_vendor(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the device Vendor.
        """
        return pulumi.get(self, "device_vendor")

    @device_vendor.setter
    def device_vendor(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "device_vendor", value)

    @property
    @pulumi.getter(name="linkSpeedInMbps")
    def link_speed_in_mbps(self) -> Optional[pulumi.Input[int]]:
        """
        Link speed.
        """
        return pulumi.get(self, "link_speed_in_mbps")

    @link_speed_in_mbps.setter
    def link_speed_in_mbps(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "link_speed_in_mbps", value)


@pulumi.input_type
class DhcpOptionsArgs:
    def __init__(__self__, *,
                 dns_servers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        DhcpOptions contains an array of DNS servers available to VMs deployed in the virtual network. Standard DHCP option for a subnet overrides VNET DHCP options.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] dns_servers: The list of DNS servers IP addresses.
        """
        if dns_servers is not None:
            pulumi.set(__self__, "dns_servers", dns_servers)

    @property
    @pulumi.getter(name="dnsServers")
    def dns_servers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of DNS servers IP addresses.
        """
        return pulumi.get(self, "dns_servers")

    @dns_servers.setter
    def dns_servers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "dns_servers", value)


@pulumi.input_type
class DnsSettingsArgs:
    def __init__(__self__, *,
                 enable_proxy: Optional[pulumi.Input[bool]] = None,
                 require_proxy_for_network_rules: Optional[pulumi.Input[bool]] = None,
                 servers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        DNS Proxy Settings in Firewall Policy.
        :param pulumi.Input[bool] enable_proxy: Enable DNS Proxy on Firewalls attached to the Firewall Policy.
        :param pulumi.Input[bool] require_proxy_for_network_rules: FQDNs in Network Rules are supported when set to true.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] servers: List of Custom DNS Servers.
        """
        if enable_proxy is not None:
            pulumi.set(__self__, "enable_proxy", enable_proxy)
        if require_proxy_for_network_rules is not None:
            pulumi.set(__self__, "require_proxy_for_network_rules", require_proxy_for_network_rules)
        if servers is not None:
            pulumi.set(__self__, "servers", servers)

    @property
    @pulumi.getter(name="enableProxy")
    def enable_proxy(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable DNS Proxy on Firewalls attached to the Firewall Policy.
        """
        return pulumi.get(self, "enable_proxy")

    @enable_proxy.setter
    def enable_proxy(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_proxy", value)

    @property
    @pulumi.getter(name="requireProxyForNetworkRules")
    def require_proxy_for_network_rules(self) -> Optional[pulumi.Input[bool]]:
        """
        FQDNs in Network Rules are supported when set to true.
        """
        return pulumi.get(self, "require_proxy_for_network_rules")

    @require_proxy_for_network_rules.setter
    def require_proxy_for_network_rules(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "require_proxy_for_network_rules", value)

    @property
    @pulumi.getter
    def servers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of Custom DNS Servers.
        """
        return pulumi.get(self, "servers")

    @servers.setter
    def servers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "servers", value)


@pulumi.input_type
class ExpressRouteCircuitAuthorizationArgs:
    def __init__(__self__, *,
                 authorization_key: Optional[pulumi.Input[str]] = None,
                 authorization_use_status: Optional[pulumi.Input[Union[str, 'AuthorizationUseStatus']]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        Authorization in an ExpressRouteCircuit resource.
        :param pulumi.Input[str] authorization_key: The authorization key.
        :param pulumi.Input[Union[str, 'AuthorizationUseStatus']] authorization_use_status: The authorization use status.
        :param pulumi.Input[str] id: Resource ID.
        :param pulumi.Input[str] name: The name of the resource that is unique within a resource group. This name can be used to access the resource.
        """
        if authorization_key is not None:
            pulumi.set(__self__, "authorization_key", authorization_key)
        if authorization_use_status is not None:
            pulumi.set(__self__, "authorization_use_status", authorization_use_status)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="authorizationKey")
    def authorization_key(self) -> Optional[pulumi.Input[str]]:
        """
        The authorization key.
        """
        return pulumi.get(self, "authorization_key")

    @authorization_key.setter
    def authorization_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "authorization_key", value)

    @property
    @pulumi.getter(name="authorizationUseStatus")
    def authorization_use_status(self) -> Optional[pulumi.Input[Union[str, 'AuthorizationUseStatus']]]:
        """
        The authorization use status.
        """
        return pulumi.get(self, "authorization_use_status")

    @authorization_use_status.setter
    def authorization_use_status(self, value: Optional[pulumi.Input[Union[str, 'AuthorizationUseStatus']]]):
        pulumi.set(self, "authorization_use_status", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the resource that is unique within a resource group. This name can be used to access the resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class ExpressRouteCircuitConnectionArgs:
    def __init__(__self__, *,
                 address_prefix: Optional[pulumi.Input[str]] = None,
                 authorization_key: Optional[pulumi.Input[str]] = None,
                 express_route_circuit_peering: Optional[pulumi.Input['SubResourceArgs']] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 ipv6_circuit_connection_config: Optional[pulumi.Input['Ipv6CircuitConnectionConfigArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 peer_express_route_circuit_peering: Optional[pulumi.Input['SubResourceArgs']] = None):
        """
        Express Route Circuit Connection in an ExpressRouteCircuitPeering resource.
        :param pulumi.Input[str] address_prefix: /29 IP address space to carve out Customer addresses for tunnels.
        :param pulumi.Input[str] authorization_key: The authorization key.
        :param pulumi.Input['SubResourceArgs'] express_route_circuit_peering: Reference to Express Route Circuit Private Peering Resource of the circuit initiating connection.
        :param pulumi.Input[str] id: Resource ID.
        :param pulumi.Input['Ipv6CircuitConnectionConfigArgs'] ipv6_circuit_connection_config: IPv6 Address PrefixProperties of the express route circuit connection.
        :param pulumi.Input[str] name: The name of the resource that is unique within a resource group. This name can be used to access the resource.
        :param pulumi.Input['SubResourceArgs'] peer_express_route_circuit_peering: Reference to Express Route Circuit Private Peering Resource of the peered circuit.
        """
        if address_prefix is not None:
            pulumi.set(__self__, "address_prefix", address_prefix)
        if authorization_key is not None:
            pulumi.set(__self__, "authorization_key", authorization_key)
        if express_route_circuit_peering is not None:
            pulumi.set(__self__, "express_route_circuit_peering", express_route_circuit_peering)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if ipv6_circuit_connection_config is not None:
            pulumi.set(__self__, "ipv6_circuit_connection_config", ipv6_circuit_connection_config)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if peer_express_route_circuit_peering is not None:
            pulumi.set(__self__, "peer_express_route_circuit_peering", peer_express_route_circuit_peering)

    @property
    @pulumi.getter(name="addressPrefix")
    def address_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        /29 IP address space to carve out Customer addresses for tunnels.
        """
        return pulumi.get(self, "address_prefix")

    @address_prefix.setter
    def address_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "address_prefix", value)

    @property
    @pulumi.getter(name="authorizationKey")
    def authorization_key(self) -> Optional[pulumi.Input[str]]:
        """
        The authorization key.
        """
        return pulumi.get(self, "authorization_key")

    @authorization_key.setter
    def authorization_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "authorization_key", value)

    @property
    @pulumi.getter(name="expressRouteCircuitPeering")
    def express_route_circuit_peering(self) -> Optional[pulumi.Input['SubResourceArgs']]:
        """
        Reference to Express Route Circuit Private Peering Resource of the circuit initiating connection.
        """
        return pulumi.get(self, "express_route_circuit_peering")

    @express_route_circuit_peering.setter
    def express_route_circuit_peering(self, value: Optional[pulumi.Input['SubResourceArgs']]):
        pulumi.set(self, "express_route_circuit_peering", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="ipv6CircuitConnectionConfig")
    def ipv6_circuit_connection_config(self) -> Optional[pulumi.Input['Ipv6CircuitConnectionConfigArgs']]:
        """
        IPv6 Address PrefixProperties of the express route circuit connection.
        """
        return pulumi.get(self, "ipv6_circuit_connection_config")

    @ipv6_circuit_connection_config.setter
    def ipv6_circuit_connection_config(self, value: Optional[pulumi.Input['Ipv6CircuitConnectionConfigArgs']]):
        pulumi.set(self, "ipv6_circuit_connection_config", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the resource that is unique within a resource group. This name can be used to access the resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="peerExpressRouteCircuitPeering")
    def peer_express_route_circuit_peering(self) -> Optional[pulumi.Input['SubResourceArgs']]:
        """
        Reference to Express Route Circuit Private Peering Resource of the peered circuit.
        """
        return pulumi.get(self, "peer_express_route_circuit_peering")

    @peer_express_route_circuit_peering.setter
    def peer_express_route_circuit_peering(self, value: Optional[pulumi.Input['SubResourceArgs']]):
        pulumi.set(self, "peer_express_route_circuit_peering", value)


@pulumi.input_type
class ExpressRouteCircuitPeeringConfigArgs:
    def __init__(__self__, *,
                 advertised_communities: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 advertised_public_prefixes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 customer_asn: Optional[pulumi.Input[int]] = None,
                 legacy_mode: Optional[pulumi.Input[int]] = None,
                 routing_registry_name: Optional[pulumi.Input[str]] = None):
        """
        Specifies the peering configuration.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] advertised_communities: The communities of bgp peering. Specified for microsoft peering.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] advertised_public_prefixes: The reference to AdvertisedPublicPrefixes.
        :param pulumi.Input[int] customer_asn: The CustomerASN of the peering.
        :param pulumi.Input[int] legacy_mode: The legacy mode of the peering.
        :param pulumi.Input[str] routing_registry_name: The RoutingRegistryName of the configuration.
        """
        if advertised_communities is not None:
            pulumi.set(__self__, "advertised_communities", advertised_communities)
        if advertised_public_prefixes is not None:
            pulumi.set(__self__, "advertised_public_prefixes", advertised_public_prefixes)
        if customer_asn is not None:
            pulumi.set(__self__, "customer_asn", customer_asn)
        if legacy_mode is not None:
            pulumi.set(__self__, "legacy_mode", legacy_mode)
        if routing_registry_name is not None:
            pulumi.set(__self__, "routing_registry_name", routing_registry_name)

    @property
    @pulumi.getter(name="advertisedCommunities")
    def advertised_communities(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The communities of bgp peering. Specified for microsoft peering.
        """
        return pulumi.get(self, "advertised_communities")

    @advertised_communities.setter
    def advertised_communities(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "advertised_communities", value)

    @property
    @pulumi.getter(name="advertisedPublicPrefixes")
    def advertised_public_prefixes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The reference to AdvertisedPublicPrefixes.
        """
        return pulumi.get(self, "advertised_public_prefixes")

    @advertised_public_prefixes.setter
    def advertised_public_prefixes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "advertised_public_prefixes", value)

    @property
    @pulumi.getter(name="customerASN")
    def customer_asn(self) -> Optional[pulumi.Input[int]]:
        """
        The CustomerASN of the peering.
        """
        return pulumi.get(self, "customer_asn")

    @customer_asn.setter
    def customer_asn(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "customer_asn", value)

    @property
    @pulumi.getter(name="legacyMode")
    def legacy_mode(self) -> Optional[pulumi.Input[int]]:
        """
        The legacy mode of the peering.
        """
        return pulumi.get(self, "legacy_mode")

    @legacy_mode.setter
    def legacy_mode(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "legacy_mode", value)

    @property
    @pulumi.getter(name="routingRegistryName")
    def routing_registry_name(self) -> Optional[pulumi.Input[str]]:
        """
        The RoutingRegistryName of the configuration.
        """
        return pulumi.get(self, "routing_registry_name")

    @routing_registry_name.setter
    def routing_registry_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "routing_registry_name", value)


@pulumi.input_type
class ExpressRouteCircuitPeeringIdArgs:
    def __init__(__self__, *,
                 id: Optional[pulumi.Input[str]] = None):
        """
        ExpressRoute circuit peering identifier.
        :param pulumi.Input[str] id: The ID of the ExpressRoute circuit peering.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the ExpressRoute circuit peering.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)


@pulumi.input_type
class ExpressRouteCircuitPeeringArgs:
    def __init__(__self__, *,
                 azure_asn: Optional[pulumi.Input[int]] = None,
                 connections: Optional[pulumi.Input[Sequence[pulumi.Input['ExpressRouteCircuitConnectionArgs']]]] = None,
                 gateway_manager_etag: Optional[pulumi.Input[str]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 ipv6_peering_config: Optional[pulumi.Input['Ipv6ExpressRouteCircuitPeeringConfigArgs']] = None,
                 microsoft_peering_config: Optional[pulumi.Input['ExpressRouteCircuitPeeringConfigArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 peer_asn: Optional[pulumi.Input[float]] = None,
                 peering_type: Optional[pulumi.Input[Union[str, 'ExpressRoutePeeringType']]] = None,
                 primary_azure_port: Optional[pulumi.Input[str]] = None,
                 primary_peer_address_prefix: Optional[pulumi.Input[str]] = None,
                 route_filter: Optional[pulumi.Input['SubResourceArgs']] = None,
                 secondary_azure_port: Optional[pulumi.Input[str]] = None,
                 secondary_peer_address_prefix: Optional[pulumi.Input[str]] = None,
                 shared_key: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[Union[str, 'ExpressRoutePeeringState']]] = None,
                 stats: Optional[pulumi.Input['ExpressRouteCircuitStatsArgs']] = None,
                 vlan_id: Optional[pulumi.Input[int]] = None):
        """
        Peering in an ExpressRouteCircuit resource.
        :param pulumi.Input[int] azure_asn: The Azure ASN.
        :param pulumi.Input[Sequence[pulumi.Input['ExpressRouteCircuitConnectionArgs']]] connections: The list of circuit connections associated with Azure Private Peering for this circuit.
        :param pulumi.Input[str] gateway_manager_etag: The GatewayManager Etag.
        :param pulumi.Input[str] id: Resource ID.
        :param pulumi.Input['Ipv6ExpressRouteCircuitPeeringConfigArgs'] ipv6_peering_config: The IPv6 peering configuration.
        :param pulumi.Input['ExpressRouteCircuitPeeringConfigArgs'] microsoft_peering_config: The Microsoft peering configuration.
        :param pulumi.Input[str] name: The name of the resource that is unique within a resource group. This name can be used to access the resource.
        :param pulumi.Input[float] peer_asn: The peer ASN.
        :param pulumi.Input[Union[str, 'ExpressRoutePeeringType']] peering_type: The peering type.
        :param pulumi.Input[str] primary_azure_port: The primary port.
        :param pulumi.Input[str] primary_peer_address_prefix: The primary address prefix.
        :param pulumi.Input['SubResourceArgs'] route_filter: The reference to the RouteFilter resource.
        :param pulumi.Input[str] secondary_azure_port: The secondary port.
        :param pulumi.Input[str] secondary_peer_address_prefix: The secondary address prefix.
        :param pulumi.Input[str] shared_key: The shared key.
        :param pulumi.Input[Union[str, 'ExpressRoutePeeringState']] state: The peering state.
        :param pulumi.Input['ExpressRouteCircuitStatsArgs'] stats: The peering stats of express route circuit.
        :param pulumi.Input[int] vlan_id: The VLAN ID.
        """
        if azure_asn is not None:
            pulumi.set(__self__, "azure_asn", azure_asn)
        if connections is not None:
            pulumi.set(__self__, "connections", connections)
        if gateway_manager_etag is not None:
            pulumi.set(__self__, "gateway_manager_etag", gateway_manager_etag)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if ipv6_peering_config is not None:
            pulumi.set(__self__, "ipv6_peering_config", ipv6_peering_config)
        if microsoft_peering_config is not None:
            pulumi.set(__self__, "microsoft_peering_config", microsoft_peering_config)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if peer_asn is not None:
            pulumi.set(__self__, "peer_asn", peer_asn)
        if peering_type is not None:
            pulumi.set(__self__, "peering_type", peering_type)
        if primary_azure_port is not None:
            pulumi.set(__self__, "primary_azure_port", primary_azure_port)
        if primary_peer_address_prefix is not None:
            pulumi.set(__self__, "primary_peer_address_prefix", primary_peer_address_prefix)
        if route_filter is not None:
            pulumi.set(__self__, "route_filter", route_filter)
        if secondary_azure_port is not None:
            pulumi.set(__self__, "secondary_azure_port", secondary_azure_port)
        if secondary_peer_address_prefix is not None:
            pulumi.set(__self__, "secondary_peer_address_prefix", secondary_peer_address_prefix)
        if shared_key is not None:
            pulumi.set(__self__, "shared_key", shared_key)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if stats is not None:
            pulumi.set(__self__, "stats", stats)
        if vlan_id is not None:
            pulumi.set(__self__, "vlan_id", vlan_id)

    @property
    @pulumi.getter(name="azureASN")
    def azure_asn(self) -> Optional[pulumi.Input[int]]:
        """
        The Azure ASN.
        """
        return pulumi.get(self, "azure_asn")

    @azure_asn.setter
    def azure_asn(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "azure_asn", value)

    @property
    @pulumi.getter
    def connections(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ExpressRouteCircuitConnectionArgs']]]]:
        """
        The list of circuit connections associated with Azure Private Peering for this circuit.
        """
        return pulumi.get(self, "connections")

    @connections.setter
    def connections(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ExpressRouteCircuitConnectionArgs']]]]):
        pulumi.set(self, "connections", value)

    @property
    @pulumi.getter(name="gatewayManagerEtag")
    def gateway_manager_etag(self) -> Optional[pulumi.Input[str]]:
        """
        The GatewayManager Etag.
        """
        return pulumi.get(self, "gateway_manager_etag")

    @gateway_manager_etag.setter
    def gateway_manager_etag(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "gateway_manager_etag", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="ipv6PeeringConfig")
    def ipv6_peering_config(self) -> Optional[pulumi.Input['Ipv6ExpressRouteCircuitPeeringConfigArgs']]:
        """
        The IPv6 peering configuration.
        """
        return pulumi.get(self, "ipv6_peering_config")

    @ipv6_peering_config.setter
    def ipv6_peering_config(self, value: Optional[pulumi.Input['Ipv6ExpressRouteCircuitPeeringConfigArgs']]):
        pulumi.set(self, "ipv6_peering_config", value)

    @property
    @pulumi.getter(name="microsoftPeeringConfig")
    def microsoft_peering_config(self) -> Optional[pulumi.Input['ExpressRouteCircuitPeeringConfigArgs']]:
        """
        The Microsoft peering configuration.
        """
        return pulumi.get(self, "microsoft_peering_config")

    @microsoft_peering_config.setter
    def microsoft_peering_config(self, value: Optional[pulumi.Input['ExpressRouteCircuitPeeringConfigArgs']]):
        pulumi.set(self, "microsoft_peering_config", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the resource that is unique within a resource group. This name can be used to access the resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="peerASN")
    def peer_asn(self) -> Optional[pulumi.Input[float]]:
        """
        The peer ASN.
        """
        return pulumi.get(self, "peer_asn")

    @peer_asn.setter
    def peer_asn(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "peer_asn", value)

    @property
    @pulumi.getter(name="peeringType")
    def peering_type(self) -> Optional[pulumi.Input[Union[str, 'ExpressRoutePeeringType']]]:
        """
        The peering type.
        """
        return pulumi.get(self, "peering_type")

    @peering_type.setter
    def peering_type(self, value: Optional[pulumi.Input[Union[str, 'ExpressRoutePeeringType']]]):
        pulumi.set(self, "peering_type", value)

    @property
    @pulumi.getter(name="primaryAzurePort")
    def primary_azure_port(self) -> Optional[pulumi.Input[str]]:
        """
        The primary port.
        """
        return pulumi.get(self, "primary_azure_port")

    @primary_azure_port.setter
    def primary_azure_port(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "primary_azure_port", value)

    @property
    @pulumi.getter(name="primaryPeerAddressPrefix")
    def primary_peer_address_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        The primary address prefix.
        """
        return pulumi.get(self, "primary_peer_address_prefix")

    @primary_peer_address_prefix.setter
    def primary_peer_address_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "primary_peer_address_prefix", value)

    @property
    @pulumi.getter(name="routeFilter")
    def route_filter(self) -> Optional[pulumi.Input['SubResourceArgs']]:
        """
        The reference to the RouteFilter resource.
        """
        return pulumi.get(self, "route_filter")

    @route_filter.setter
    def route_filter(self, value: Optional[pulumi.Input['SubResourceArgs']]):
        pulumi.set(self, "route_filter", value)

    @property
    @pulumi.getter(name="secondaryAzurePort")
    def secondary_azure_port(self) -> Optional[pulumi.Input[str]]:
        """
        The secondary port.
        """
        return pulumi.get(self, "secondary_azure_port")

    @secondary_azure_port.setter
    def secondary_azure_port(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secondary_azure_port", value)

    @property
    @pulumi.getter(name="secondaryPeerAddressPrefix")
    def secondary_peer_address_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        The secondary address prefix.
        """
        return pulumi.get(self, "secondary_peer_address_prefix")

    @secondary_peer_address_prefix.setter
    def secondary_peer_address_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secondary_peer_address_prefix", value)

    @property
    @pulumi.getter(name="sharedKey")
    def shared_key(self) -> Optional[pulumi.Input[str]]:
        """
        The shared key.
        """
        return pulumi.get(self, "shared_key")

    @shared_key.setter
    def shared_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "shared_key", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[Union[str, 'ExpressRoutePeeringState']]]:
        """
        The peering state.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[Union[str, 'ExpressRoutePeeringState']]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter
    def stats(self) -> Optional[pulumi.Input['ExpressRouteCircuitStatsArgs']]:
        """
        The peering stats of express route circuit.
        """
        return pulumi.get(self, "stats")

    @stats.setter
    def stats(self, value: Optional[pulumi.Input['ExpressRouteCircuitStatsArgs']]):
        pulumi.set(self, "stats", value)

    @property
    @pulumi.getter(name="vlanId")
    def vlan_id(self) -> Optional[pulumi.Input[int]]:
        """
        The VLAN ID.
        """
        return pulumi.get(self, "vlan_id")

    @vlan_id.setter
    def vlan_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "vlan_id", value)


@pulumi.input_type
class ExpressRouteCircuitServiceProviderPropertiesArgs:
    def __init__(__self__, *,
                 bandwidth_in_mbps: Optional[pulumi.Input[int]] = None,
                 peering_location: Optional[pulumi.Input[str]] = None,
                 service_provider_name: Optional[pulumi.Input[str]] = None):
        """
        Contains ServiceProviderProperties in an ExpressRouteCircuit.
        :param pulumi.Input[int] bandwidth_in_mbps: The BandwidthInMbps.
        :param pulumi.Input[str] peering_location: The peering location.
        :param pulumi.Input[str] service_provider_name: The serviceProviderName.
        """
        if bandwidth_in_mbps is not None:
            pulumi.set(__self__, "bandwidth_in_mbps", bandwidth_in_mbps)
        if peering_location is not None:
            pulumi.set(__self__, "peering_location", peering_location)
        if service_provider_name is not None:
            pulumi.set(__self__, "service_provider_name", service_provider_name)

    @property
    @pulumi.getter(name="bandwidthInMbps")
    def bandwidth_in_mbps(self) -> Optional[pulumi.Input[int]]:
        """
        The BandwidthInMbps.
        """
        return pulumi.get(self, "bandwidth_in_mbps")

    @bandwidth_in_mbps.setter
    def bandwidth_in_mbps(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "bandwidth_in_mbps", value)

    @property
    @pulumi.getter(name="peeringLocation")
    def peering_location(self) -> Optional[pulumi.Input[str]]:
        """
        The peering location.
        """
        return pulumi.get(self, "peering_location")

    @peering_location.setter
    def peering_location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "peering_location", value)

    @property
    @pulumi.getter(name="serviceProviderName")
    def service_provider_name(self) -> Optional[pulumi.Input[str]]:
        """
        The serviceProviderName.
        """
        return pulumi.get(self, "service_provider_name")

    @service_provider_name.setter
    def service_provider_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_provider_name", value)


@pulumi.input_type
class ExpressRouteCircuitSkuArgs:
    def __init__(__self__, *,
                 family: Optional[pulumi.Input[Union[str, 'ExpressRouteCircuitSkuFamily']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 tier: Optional[pulumi.Input[Union[str, 'ExpressRouteCircuitSkuTier']]] = None):
        """
        Contains SKU in an ExpressRouteCircuit.
        :param pulumi.Input[Union[str, 'ExpressRouteCircuitSkuFamily']] family: The family of the SKU.
        :param pulumi.Input[str] name: The name of the SKU.
        :param pulumi.Input[Union[str, 'ExpressRouteCircuitSkuTier']] tier: The tier of the SKU.
        """
        if family is not None:
            pulumi.set(__self__, "family", family)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tier is not None:
            pulumi.set(__self__, "tier", tier)

    @property
    @pulumi.getter
    def family(self) -> Optional[pulumi.Input[Union[str, 'ExpressRouteCircuitSkuFamily']]]:
        """
        The family of the SKU.
        """
        return pulumi.get(self, "family")

    @family.setter
    def family(self, value: Optional[pulumi.Input[Union[str, 'ExpressRouteCircuitSkuFamily']]]):
        pulumi.set(self, "family", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the SKU.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def tier(self) -> Optional[pulumi.Input[Union[str, 'ExpressRouteCircuitSkuTier']]]:
        """
        The tier of the SKU.
        """
        return pulumi.get(self, "tier")

    @tier.setter
    def tier(self, value: Optional[pulumi.Input[Union[str, 'ExpressRouteCircuitSkuTier']]]):
        pulumi.set(self, "tier", value)


@pulumi.input_type
class ExpressRouteCircuitStatsArgs:
    def __init__(__self__, *,
                 primarybytes_in: Optional[pulumi.Input[float]] = None,
                 primarybytes_out: Optional[pulumi.Input[float]] = None,
                 secondarybytes_in: Optional[pulumi.Input[float]] = None,
                 secondarybytes_out: Optional[pulumi.Input[float]] = None):
        """
        Contains stats associated with the peering.
        :param pulumi.Input[float] primarybytes_in: The Primary BytesIn of the peering.
        :param pulumi.Input[float] primarybytes_out: The primary BytesOut of the peering.
        :param pulumi.Input[float] secondarybytes_in: The secondary BytesIn of the peering.
        :param pulumi.Input[float] secondarybytes_out: The secondary BytesOut of the peering.
        """
        if primarybytes_in is not None:
            pulumi.set(__self__, "primarybytes_in", primarybytes_in)
        if primarybytes_out is not None:
            pulumi.set(__self__, "primarybytes_out", primarybytes_out)
        if secondarybytes_in is not None:
            pulumi.set(__self__, "secondarybytes_in", secondarybytes_in)
        if secondarybytes_out is not None:
            pulumi.set(__self__, "secondarybytes_out", secondarybytes_out)

    @property
    @pulumi.getter(name="primarybytesIn")
    def primarybytes_in(self) -> Optional[pulumi.Input[float]]:
        """
        The Primary BytesIn of the peering.
        """
        return pulumi.get(self, "primarybytes_in")

    @primarybytes_in.setter
    def primarybytes_in(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "primarybytes_in", value)

    @property
    @pulumi.getter(name="primarybytesOut")
    def primarybytes_out(self) -> Optional[pulumi.Input[float]]:
        """
        The primary BytesOut of the peering.
        """
        return pulumi.get(self, "primarybytes_out")

    @primarybytes_out.setter
    def primarybytes_out(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "primarybytes_out", value)

    @property
    @pulumi.getter(name="secondarybytesIn")
    def secondarybytes_in(self) -> Optional[pulumi.Input[float]]:
        """
        The secondary BytesIn of the peering.
        """
        return pulumi.get(self, "secondarybytes_in")

    @secondarybytes_in.setter
    def secondarybytes_in(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "secondarybytes_in", value)

    @property
    @pulumi.getter(name="secondarybytesOut")
    def secondarybytes_out(self) -> Optional[pulumi.Input[float]]:
        """
        The secondary BytesOut of the peering.
        """
        return pulumi.get(self, "secondarybytes_out")

    @secondarybytes_out.setter
    def secondarybytes_out(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "secondarybytes_out", value)


@pulumi.input_type
class ExpressRouteGatewayPropertiesAutoScaleConfigurationArgs:
    def __init__(__self__, *,
                 bounds: Optional[pulumi.Input['ExpressRouteGatewayPropertiesBoundsArgs']] = None):
        """
        Configuration for auto scaling.
        :param pulumi.Input['ExpressRouteGatewayPropertiesBoundsArgs'] bounds: Minimum and maximum number of scale units to deploy.
        """
        if bounds is not None:
            pulumi.set(__self__, "bounds", bounds)

    @property
    @pulumi.getter
    def bounds(self) -> Optional[pulumi.Input['ExpressRouteGatewayPropertiesBoundsArgs']]:
        """
        Minimum and maximum number of scale units to deploy.
        """
        return pulumi.get(self, "bounds")

    @bounds.setter
    def bounds(self, value: Optional[pulumi.Input['ExpressRouteGatewayPropertiesBoundsArgs']]):
        pulumi.set(self, "bounds", value)


@pulumi.input_type
class ExpressRouteGatewayPropertiesBoundsArgs:
    def __init__(__self__, *,
                 max: Optional[pulumi.Input[int]] = None,
                 min: Optional[pulumi.Input[int]] = None):
        """
        Minimum and maximum number of scale units to deploy.
        :param pulumi.Input[int] max: Maximum number of scale units deployed for ExpressRoute gateway.
        :param pulumi.Input[int] min: Minimum number of scale units deployed for ExpressRoute gateway.
        """
        if max is not None:
            pulumi.set(__self__, "max", max)
        if min is not None:
            pulumi.set(__self__, "min", min)

    @property
    @pulumi.getter
    def max(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum number of scale units deployed for ExpressRoute gateway.
        """
        return pulumi.get(self, "max")

    @max.setter
    def max(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max", value)

    @property
    @pulumi.getter
    def min(self) -> Optional[pulumi.Input[int]]:
        """
        Minimum number of scale units deployed for ExpressRoute gateway.
        """
        return pulumi.get(self, "min")

    @min.setter
    def min(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min", value)


@pulumi.input_type
class ExpressRouteLinkMacSecConfigArgs:
    def __init__(__self__, *,
                 cak_secret_identifier: Optional[pulumi.Input[str]] = None,
                 cipher: Optional[pulumi.Input[Union[str, 'ExpressRouteLinkMacSecCipher']]] = None,
                 ckn_secret_identifier: Optional[pulumi.Input[str]] = None):
        """
        ExpressRouteLink Mac Security Configuration.
        :param pulumi.Input[str] cak_secret_identifier: Keyvault Secret Identifier URL containing Mac security CAK key.
        :param pulumi.Input[Union[str, 'ExpressRouteLinkMacSecCipher']] cipher: Mac security cipher.
        :param pulumi.Input[str] ckn_secret_identifier: Keyvault Secret Identifier URL containing Mac security CKN key.
        """
        if cak_secret_identifier is not None:
            pulumi.set(__self__, "cak_secret_identifier", cak_secret_identifier)
        if cipher is not None:
            pulumi.set(__self__, "cipher", cipher)
        if ckn_secret_identifier is not None:
            pulumi.set(__self__, "ckn_secret_identifier", ckn_secret_identifier)

    @property
    @pulumi.getter(name="cakSecretIdentifier")
    def cak_secret_identifier(self) -> Optional[pulumi.Input[str]]:
        """
        Keyvault Secret Identifier URL containing Mac security CAK key.
        """
        return pulumi.get(self, "cak_secret_identifier")

    @cak_secret_identifier.setter
    def cak_secret_identifier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cak_secret_identifier", value)

    @property
    @pulumi.getter
    def cipher(self) -> Optional[pulumi.Input[Union[str, 'ExpressRouteLinkMacSecCipher']]]:
        """
        Mac security cipher.
        """
        return pulumi.get(self, "cipher")

    @cipher.setter
    def cipher(self, value: Optional[pulumi.Input[Union[str, 'ExpressRouteLinkMacSecCipher']]]):
        pulumi.set(self, "cipher", value)

    @property
    @pulumi.getter(name="cknSecretIdentifier")
    def ckn_secret_identifier(self) -> Optional[pulumi.Input[str]]:
        """
        Keyvault Secret Identifier URL containing Mac security CKN key.
        """
        return pulumi.get(self, "ckn_secret_identifier")

    @ckn_secret_identifier.setter
    def ckn_secret_identifier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ckn_secret_identifier", value)


@pulumi.input_type
class ExpressRouteLinkArgs:
    def __init__(__self__, *,
                 admin_state: Optional[pulumi.Input[Union[str, 'ExpressRouteLinkAdminState']]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 mac_sec_config: Optional[pulumi.Input['ExpressRouteLinkMacSecConfigArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        ExpressRouteLink child resource definition.
        :param pulumi.Input[Union[str, 'ExpressRouteLinkAdminState']] admin_state: Administrative state of the physical port.
        :param pulumi.Input[str] id: Resource ID.
        :param pulumi.Input['ExpressRouteLinkMacSecConfigArgs'] mac_sec_config: MacSec configuration.
        :param pulumi.Input[str] name: Name of child port resource that is unique among child port resources of the parent.
        """
        if admin_state is not None:
            pulumi.set(__self__, "admin_state", admin_state)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if mac_sec_config is not None:
            pulumi.set(__self__, "mac_sec_config", mac_sec_config)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="adminState")
    def admin_state(self) -> Optional[pulumi.Input[Union[str, 'ExpressRouteLinkAdminState']]]:
        """
        Administrative state of the physical port.
        """
        return pulumi.get(self, "admin_state")

    @admin_state.setter
    def admin_state(self, value: Optional[pulumi.Input[Union[str, 'ExpressRouteLinkAdminState']]]):
        pulumi.set(self, "admin_state", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="macSecConfig")
    def mac_sec_config(self) -> Optional[pulumi.Input['ExpressRouteLinkMacSecConfigArgs']]:
        """
        MacSec configuration.
        """
        return pulumi.get(self, "mac_sec_config")

    @mac_sec_config.setter
    def mac_sec_config(self, value: Optional[pulumi.Input['ExpressRouteLinkMacSecConfigArgs']]):
        pulumi.set(self, "mac_sec_config", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of child port resource that is unique among child port resources of the parent.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class FirewallPolicyFilterRuleCollectionActionArgs:
    def __init__(__self__, *,
                 type: Optional[pulumi.Input[Union[str, 'FirewallPolicyFilterRuleCollectionActionType']]] = None):
        """
        Properties of the FirewallPolicyFilterRuleCollectionAction.
        :param pulumi.Input[Union[str, 'FirewallPolicyFilterRuleCollectionActionType']] type: The type of action.
        """
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[Union[str, 'FirewallPolicyFilterRuleCollectionActionType']]]:
        """
        The type of action.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[Union[str, 'FirewallPolicyFilterRuleCollectionActionType']]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class FirewallPolicyFilterRuleCollectionArgs:
    def __init__(__self__, *,
                 rule_collection_type: pulumi.Input[str],
                 action: Optional[pulumi.Input['FirewallPolicyFilterRuleCollectionActionArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 priority: Optional[pulumi.Input[int]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApplicationRuleArgs', 'NatRuleArgs', 'NetworkRuleArgs']]]]] = None):
        """
        Firewall Policy Filter Rule Collection.
        :param pulumi.Input[str] rule_collection_type: The type of the rule collection.
               Expected value is 'FirewallPolicyFilterRuleCollection'.
        :param pulumi.Input['FirewallPolicyFilterRuleCollectionActionArgs'] action: The action type of a Filter rule collection.
        :param pulumi.Input[str] name: The name of the rule collection.
        :param pulumi.Input[int] priority: Priority of the Firewall Policy Rule Collection resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ApplicationRuleArgs', 'NatRuleArgs', 'NetworkRuleArgs']]]] rules: List of rules included in a rule collection.
        """
        pulumi.set(__self__, "rule_collection_type", 'FirewallPolicyFilterRuleCollection')
        if action is not None:
            pulumi.set(__self__, "action", action)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)

    @property
    @pulumi.getter(name="ruleCollectionType")
    def rule_collection_type(self) -> pulumi.Input[str]:
        """
        The type of the rule collection.
        Expected value is 'FirewallPolicyFilterRuleCollection'.
        """
        return pulumi.get(self, "rule_collection_type")

    @rule_collection_type.setter
    def rule_collection_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "rule_collection_type", value)

    @property
    @pulumi.getter
    def action(self) -> Optional[pulumi.Input['FirewallPolicyFilterRuleCollectionActionArgs']]:
        """
        The action type of a Filter rule collection.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: Optional[pulumi.Input['FirewallPolicyFilterRuleCollectionActionArgs']]):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the rule collection.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[int]]:
        """
        Priority of the Firewall Policy Rule Collection resource.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "priority", value)

    @property
    @pulumi.getter
    def rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApplicationRuleArgs', 'NatRuleArgs', 'NetworkRuleArgs']]]]]:
        """
        List of rules included in a rule collection.
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApplicationRuleArgs', 'NatRuleArgs', 'NetworkRuleArgs']]]]]):
        pulumi.set(self, "rules", value)


@pulumi.input_type
class FirewallPolicyNatRuleCollectionActionArgs:
    def __init__(__self__, *,
                 type: Optional[pulumi.Input[Union[str, 'FirewallPolicyNatRuleCollectionActionType']]] = None):
        """
        Properties of the FirewallPolicyNatRuleCollectionAction.
        :param pulumi.Input[Union[str, 'FirewallPolicyNatRuleCollectionActionType']] type: The type of action.
        """
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[Union[str, 'FirewallPolicyNatRuleCollectionActionType']]]:
        """
        The type of action.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[Union[str, 'FirewallPolicyNatRuleCollectionActionType']]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class FirewallPolicyNatRuleCollectionArgs:
    def __init__(__self__, *,
                 rule_collection_type: pulumi.Input[str],
                 action: Optional[pulumi.Input['FirewallPolicyNatRuleCollectionActionArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 priority: Optional[pulumi.Input[int]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApplicationRuleArgs', 'NatRuleArgs', 'NetworkRuleArgs']]]]] = None):
        """
        Firewall Policy NAT Rule Collection.
        :param pulumi.Input[str] rule_collection_type: The type of the rule collection.
               Expected value is 'FirewallPolicyNatRuleCollection'.
        :param pulumi.Input['FirewallPolicyNatRuleCollectionActionArgs'] action: The action type of a Nat rule collection.
        :param pulumi.Input[str] name: The name of the rule collection.
        :param pulumi.Input[int] priority: Priority of the Firewall Policy Rule Collection resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ApplicationRuleArgs', 'NatRuleArgs', 'NetworkRuleArgs']]]] rules: List of rules included in a rule collection.
        """
        pulumi.set(__self__, "rule_collection_type", 'FirewallPolicyNatRuleCollection')
        if action is not None:
            pulumi.set(__self__, "action", action)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)

    @property
    @pulumi.getter(name="ruleCollectionType")
    def rule_collection_type(self) -> pulumi.Input[str]:
        """
        The type of the rule collection.
        Expected value is 'FirewallPolicyNatRuleCollection'.
        """
        return pulumi.get(self, "rule_collection_type")

    @rule_collection_type.setter
    def rule_collection_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "rule_collection_type", value)

    @property
    @pulumi.getter
    def action(self) -> Optional[pulumi.Input['FirewallPolicyNatRuleCollectionActionArgs']]:
        """
        The action type of a Nat rule collection.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: Optional[pulumi.Input['FirewallPolicyNatRuleCollectionActionArgs']]):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the rule collection.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[int]]:
        """
        Priority of the Firewall Policy Rule Collection resource.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "priority", value)

    @property
    @pulumi.getter
    def rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApplicationRuleArgs', 'NatRuleArgs', 'NetworkRuleArgs']]]]]:
        """
        List of rules included in a rule collection.
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApplicationRuleArgs', 'NatRuleArgs', 'NetworkRuleArgs']]]]]):
        pulumi.set(self, "rules", value)


@pulumi.input_type
class FirewallPolicyRuleApplicationProtocolArgs:
    def __init__(__self__, *,
                 port: Optional[pulumi.Input[int]] = None,
                 protocol_type: Optional[pulumi.Input[Union[str, 'FirewallPolicyRuleApplicationProtocolType']]] = None):
        """
        Properties of the application rule protocol.
        :param pulumi.Input[int] port: Port number for the protocol, cannot be greater than 64000.
        :param pulumi.Input[Union[str, 'FirewallPolicyRuleApplicationProtocolType']] protocol_type: Protocol type.
        """
        if port is not None:
            pulumi.set(__self__, "port", port)
        if protocol_type is not None:
            pulumi.set(__self__, "protocol_type", protocol_type)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        Port number for the protocol, cannot be greater than 64000.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter(name="protocolType")
    def protocol_type(self) -> Optional[pulumi.Input[Union[str, 'FirewallPolicyRuleApplicationProtocolType']]]:
        """
        Protocol type.
        """
        return pulumi.get(self, "protocol_type")

    @protocol_type.setter
    def protocol_type(self, value: Optional[pulumi.Input[Union[str, 'FirewallPolicyRuleApplicationProtocolType']]]):
        pulumi.set(self, "protocol_type", value)


@pulumi.input_type
class FirewallPolicyThreatIntelWhitelistArgs:
    def __init__(__self__, *,
                 fqdns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 ip_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        ThreatIntel Whitelist for Firewall Policy.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] fqdns: List of FQDNs for the ThreatIntel Whitelist.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ip_addresses: List of IP addresses for the ThreatIntel Whitelist.
        """
        if fqdns is not None:
            pulumi.set(__self__, "fqdns", fqdns)
        if ip_addresses is not None:
            pulumi.set(__self__, "ip_addresses", ip_addresses)

    @property
    @pulumi.getter
    def fqdns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of FQDNs for the ThreatIntel Whitelist.
        """
        return pulumi.get(self, "fqdns")

    @fqdns.setter
    def fqdns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "fqdns", value)

    @property
    @pulumi.getter(name="ipAddresses")
    def ip_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of IP addresses for the ThreatIntel Whitelist.
        """
        return pulumi.get(self, "ip_addresses")

    @ip_addresses.setter
    def ip_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "ip_addresses", value)


@pulumi.input_type
class FlowLogFormatParametersArgs:
    def __init__(__self__, *,
                 type: Optional[pulumi.Input[Union[str, 'FlowLogFormatType']]] = None,
                 version: Optional[pulumi.Input[int]] = None):
        """
        Parameters that define the flow log format.
        :param pulumi.Input[Union[str, 'FlowLogFormatType']] type: The file type of flow log.
        :param pulumi.Input[int] version: The version (revision) of the flow log.
        """
        if type is not None:
            pulumi.set(__self__, "type", type)
        if version is None:
            version = 0
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[Union[str, 'FlowLogFormatType']]]:
        """
        The file type of flow log.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[Union[str, 'FlowLogFormatType']]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[int]]:
        """
        The version (revision) of the flow log.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class ForwardingConfigurationArgs:
    def __init__(__self__, *,
                 odata_type: pulumi.Input[str],
                 backend_pool: Optional[pulumi.Input['SubResourceArgs']] = None,
                 cache_configuration: Optional[pulumi.Input['CacheConfigurationArgs']] = None,
                 custom_forwarding_path: Optional[pulumi.Input[str]] = None,
                 forwarding_protocol: Optional[pulumi.Input[Union[str, 'FrontDoorForwardingProtocol']]] = None):
        """
        Describes Forwarding Route.
        :param pulumi.Input[str] odata_type: 
               Expected value is '#Microsoft.Azure.FrontDoor.Models.FrontdoorForwardingConfiguration'.
        :param pulumi.Input['SubResourceArgs'] backend_pool: A reference to the BackendPool which this rule routes to.
        :param pulumi.Input['CacheConfigurationArgs'] cache_configuration: The caching configuration associated with this rule.
        :param pulumi.Input[str] custom_forwarding_path: A custom path used to rewrite resource paths matched by this rule. Leave empty to use incoming path.
        :param pulumi.Input[Union[str, 'FrontDoorForwardingProtocol']] forwarding_protocol: Protocol this rule will use when forwarding traffic to backends.
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Azure.FrontDoor.Models.FrontdoorForwardingConfiguration')
        if backend_pool is not None:
            pulumi.set(__self__, "backend_pool", backend_pool)
        if cache_configuration is not None:
            pulumi.set(__self__, "cache_configuration", cache_configuration)
        if custom_forwarding_path is not None:
            pulumi.set(__self__, "custom_forwarding_path", custom_forwarding_path)
        if forwarding_protocol is not None:
            pulumi.set(__self__, "forwarding_protocol", forwarding_protocol)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> pulumi.Input[str]:
        """

        Expected value is '#Microsoft.Azure.FrontDoor.Models.FrontdoorForwardingConfiguration'.
        """
        return pulumi.get(self, "odata_type")

    @odata_type.setter
    def odata_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "odata_type", value)

    @property
    @pulumi.getter(name="backendPool")
    def backend_pool(self) -> Optional[pulumi.Input['SubResourceArgs']]:
        """
        A reference to the BackendPool which this rule routes to.
        """
        return pulumi.get(self, "backend_pool")

    @backend_pool.setter
    def backend_pool(self, value: Optional[pulumi.Input['SubResourceArgs']]):
        pulumi.set(self, "backend_pool", value)

    @property
    @pulumi.getter(name="cacheConfiguration")
    def cache_configuration(self) -> Optional[pulumi.Input['CacheConfigurationArgs']]:
        """
        The caching configuration associated with this rule.
        """
        return pulumi.get(self, "cache_configuration")

    @cache_configuration.setter
    def cache_configuration(self, value: Optional[pulumi.Input['CacheConfigurationArgs']]):
        pulumi.set(self, "cache_configuration", value)

    @property
    @pulumi.getter(name="customForwardingPath")
    def custom_forwarding_path(self) -> Optional[pulumi.Input[str]]:
        """
        A custom path used to rewrite resource paths matched by this rule. Leave empty to use incoming path.
        """
        return pulumi.get(self, "custom_forwarding_path")

    @custom_forwarding_path.setter
    def custom_forwarding_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "custom_forwarding_path", value)

    @property
    @pulumi.getter(name="forwardingProtocol")
    def forwarding_protocol(self) -> Optional[pulumi.Input[Union[str, 'FrontDoorForwardingProtocol']]]:
        """
        Protocol this rule will use when forwarding traffic to backends.
        """
        return pulumi.get(self, "forwarding_protocol")

    @forwarding_protocol.setter
    def forwarding_protocol(self, value: Optional[pulumi.Input[Union[str, 'FrontDoorForwardingProtocol']]]):
        pulumi.set(self, "forwarding_protocol", value)


@pulumi.input_type
class FrontendEndpointUpdateParametersWebApplicationFirewallPolicyLinkArgs:
    def __init__(__self__, *,
                 id: Optional[pulumi.Input[str]] = None):
        """
        Defines the Web Application Firewall policy for each host (if applicable)
        :param pulumi.Input[str] id: Resource ID.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)


@pulumi.input_type
class FrontendEndpointArgs:
    def __init__(__self__, *,
                 host_name: Optional[pulumi.Input[str]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 session_affinity_enabled_state: Optional[pulumi.Input[Union[str, 'SessionAffinityEnabledState']]] = None,
                 session_affinity_ttl_seconds: Optional[pulumi.Input[int]] = None,
                 web_application_firewall_policy_link: Optional[pulumi.Input['FrontendEndpointUpdateParametersWebApplicationFirewallPolicyLinkArgs']] = None):
        """
        A frontend endpoint used for routing.
        :param pulumi.Input[str] host_name: The host name of the frontendEndpoint. Must be a domain name.
        :param pulumi.Input[str] id: Resource ID.
        :param pulumi.Input[str] name: Resource name.
        :param pulumi.Input[Union[str, 'SessionAffinityEnabledState']] session_affinity_enabled_state: Whether to allow session affinity on this host. Valid options are 'Enabled' or 'Disabled'
        :param pulumi.Input[int] session_affinity_ttl_seconds: UNUSED. This field will be ignored. The TTL to use in seconds for session affinity, if applicable.
        :param pulumi.Input['FrontendEndpointUpdateParametersWebApplicationFirewallPolicyLinkArgs'] web_application_firewall_policy_link: Defines the Web Application Firewall policy for each host (if applicable)
        """
        if host_name is not None:
            pulumi.set(__self__, "host_name", host_name)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if session_affinity_enabled_state is not None:
            pulumi.set(__self__, "session_affinity_enabled_state", session_affinity_enabled_state)
        if session_affinity_ttl_seconds is not None:
            pulumi.set(__self__, "session_affinity_ttl_seconds", session_affinity_ttl_seconds)
        if web_application_firewall_policy_link is not None:
            pulumi.set(__self__, "web_application_firewall_policy_link", web_application_firewall_policy_link)

    @property
    @pulumi.getter(name="hostName")
    def host_name(self) -> Optional[pulumi.Input[str]]:
        """
        The host name of the frontendEndpoint. Must be a domain name.
        """
        return pulumi.get(self, "host_name")

    @host_name.setter
    def host_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host_name", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Resource name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="sessionAffinityEnabledState")
    def session_affinity_enabled_state(self) -> Optional[pulumi.Input[Union[str, 'SessionAffinityEnabledState']]]:
        """
        Whether to allow session affinity on this host. Valid options are 'Enabled' or 'Disabled'
        """
        return pulumi.get(self, "session_affinity_enabled_state")

    @session_affinity_enabled_state.setter
    def session_affinity_enabled_state(self, value: Optional[pulumi.Input[Union[str, 'SessionAffinityEnabledState']]]):
        pulumi.set(self, "session_affinity_enabled_state", value)

    @property
    @pulumi.getter(name="sessionAffinityTtlSeconds")
    def session_affinity_ttl_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        UNUSED. This field will be ignored. The TTL to use in seconds for session affinity, if applicable.
        """
        return pulumi.get(self, "session_affinity_ttl_seconds")

    @session_affinity_ttl_seconds.setter
    def session_affinity_ttl_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "session_affinity_ttl_seconds", value)

    @property
    @pulumi.getter(name="webApplicationFirewallPolicyLink")
    def web_application_firewall_policy_link(self) -> Optional[pulumi.Input['FrontendEndpointUpdateParametersWebApplicationFirewallPolicyLinkArgs']]:
        """
        Defines the Web Application Firewall policy for each host (if applicable)
        """
        return pulumi.get(self, "web_application_firewall_policy_link")

    @web_application_firewall_policy_link.setter
    def web_application_firewall_policy_link(self, value: Optional[pulumi.Input['FrontendEndpointUpdateParametersWebApplicationFirewallPolicyLinkArgs']]):
        pulumi.set(self, "web_application_firewall_policy_link", value)


@pulumi.input_type
class FrontendIPConfigurationArgs:
    def __init__(__self__, *,
                 id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 private_ip_address: Optional[pulumi.Input[str]] = None,
                 private_ip_address_version: Optional[pulumi.Input[Union[str, 'IPVersion']]] = None,
                 private_ip_allocation_method: Optional[pulumi.Input[Union[str, 'IPAllocationMethod']]] = None,
                 public_ip_address: Optional[pulumi.Input['PublicIPAddressArgs']] = None,
                 public_ip_prefix: Optional[pulumi.Input['SubResourceArgs']] = None,
                 subnet: Optional[pulumi.Input['SubnetArgs']] = None,
                 zones: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Frontend IP address of the load balancer.
        :param pulumi.Input[str] id: Resource ID.
        :param pulumi.Input[str] name: The name of the resource that is unique within the set of frontend IP configurations used by the load balancer. This name can be used to access the resource.
        :param pulumi.Input[str] private_ip_address: The private IP address of the IP configuration.
        :param pulumi.Input[Union[str, 'IPVersion']] private_ip_address_version: Whether the specific ipconfiguration is IPv4 or IPv6. Default is taken as IPv4.
        :param pulumi.Input[Union[str, 'IPAllocationMethod']] private_ip_allocation_method: The Private IP allocation method.
        :param pulumi.Input['PublicIPAddressArgs'] public_ip_address: The reference to the Public IP resource.
        :param pulumi.Input['SubResourceArgs'] public_ip_prefix: The reference to the Public IP Prefix resource.
        :param pulumi.Input['SubnetArgs'] subnet: The reference to the subnet resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] zones: A list of availability zones denoting the IP allocated for the resource needs to come from.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if private_ip_address is not None:
            pulumi.set(__self__, "private_ip_address", private_ip_address)
        if private_ip_address_version is not None:
            pulumi.set(__self__, "private_ip_address_version", private_ip_address_version)
        if private_ip_allocation_method is not None:
            pulumi.set(__self__, "private_ip_allocation_method", private_ip_allocation_method)
        if public_ip_address is not None:
            pulumi.set(__self__, "public_ip_address", public_ip_address)
        if public_ip_prefix is not None:
            pulumi.set(__self__, "public_ip_prefix", public_ip_prefix)
        if subnet is not None:
            pulumi.set(__self__, "subnet", subnet)
        if zones is not None:
            pulumi.set(__self__, "zones", zones)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the resource that is unique within the set of frontend IP configurations used by the load balancer. This name can be used to access the resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="privateIPAddress")
    def private_ip_address(self) -> Optional[pulumi.Input[str]]:
        """
        The private IP address of the IP configuration.
        """
        return pulumi.get(self, "private_ip_address")

    @private_ip_address.setter
    def private_ip_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_ip_address", value)

    @property
    @pulumi.getter(name="privateIPAddressVersion")
    def private_ip_address_version(self) -> Optional[pulumi.Input[Union[str, 'IPVersion']]]:
        """
        Whether the specific ipconfiguration is IPv4 or IPv6. Default is taken as IPv4.
        """
        return pulumi.get(self, "private_ip_address_version")

    @private_ip_address_version.setter
    def private_ip_address_version(self, value: Optional[pulumi.Input[Union[str, 'IPVersion']]]):
        pulumi.set(self, "private_ip_address_version", value)

    @property
    @pulumi.getter(name="privateIPAllocationMethod")
    def private_ip_allocation_method(self) -> Optional[pulumi.Input[Union[str, 'IPAllocationMethod']]]:
        """
        The Private IP allocation method.
        """
        return pulumi.get(self, "private_ip_allocation_method")

    @private_ip_allocation_method.setter
    def private_ip_allocation_method(self, value: Optional[pulumi.Input[Union[str, 'IPAllocationMethod']]]):
        pulumi.set(self, "private_ip_allocation_method", value)

    @property
    @pulumi.getter(name="publicIPAddress")
    def public_ip_address(self) -> Optional[pulumi.Input['PublicIPAddressArgs']]:
        """
        The reference to the Public IP resource.
        """
        return pulumi.get(self, "public_ip_address")

    @public_ip_address.setter
    def public_ip_address(self, value: Optional[pulumi.Input['PublicIPAddressArgs']]):
        pulumi.set(self, "public_ip_address", value)

    @property
    @pulumi.getter(name="publicIPPrefix")
    def public_ip_prefix(self) -> Optional[pulumi.Input['SubResourceArgs']]:
        """
        The reference to the Public IP Prefix resource.
        """
        return pulumi.get(self, "public_ip_prefix")

    @public_ip_prefix.setter
    def public_ip_prefix(self, value: Optional[pulumi.Input['SubResourceArgs']]):
        pulumi.set(self, "public_ip_prefix", value)

    @property
    @pulumi.getter
    def subnet(self) -> Optional[pulumi.Input['SubnetArgs']]:
        """
        The reference to the subnet resource.
        """
        return pulumi.get(self, "subnet")

    @subnet.setter
    def subnet(self, value: Optional[pulumi.Input['SubnetArgs']]):
        pulumi.set(self, "subnet", value)

    @property
    @pulumi.getter
    def zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of availability zones denoting the IP allocated for the resource needs to come from.
        """
        return pulumi.get(self, "zones")

    @zones.setter
    def zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "zones", value)


@pulumi.input_type
class HTTPHeaderArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None):
        """
        The HTTP header.
        :param pulumi.Input[str] name: The name in HTTP header.
        :param pulumi.Input[str] value: The value in HTTP header.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name in HTTP header.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        The value in HTTP header.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class HeaderActionArgs:
    def __init__(__self__, *,
                 header_action_type: pulumi.Input[Union[str, 'HeaderActionType']],
                 header_name: pulumi.Input[str],
                 value: Optional[pulumi.Input[str]] = None):
        """
        An action that can manipulate an http header.
        :param pulumi.Input[Union[str, 'HeaderActionType']] header_action_type: Which type of manipulation to apply to the header.
        :param pulumi.Input[str] header_name: The name of the header this action will apply to.
        :param pulumi.Input[str] value: The value to update the given header name with. This value is not used if the actionType is Delete.
        """
        pulumi.set(__self__, "header_action_type", header_action_type)
        pulumi.set(__self__, "header_name", header_name)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter(name="headerActionType")
    def header_action_type(self) -> pulumi.Input[Union[str, 'HeaderActionType']]:
        """
        Which type of manipulation to apply to the header.
        """
        return pulumi.get(self, "header_action_type")

    @header_action_type.setter
    def header_action_type(self, value: pulumi.Input[Union[str, 'HeaderActionType']]):
        pulumi.set(self, "header_action_type", value)

    @property
    @pulumi.getter(name="headerName")
    def header_name(self) -> pulumi.Input[str]:
        """
        The name of the header this action will apply to.
        """
        return pulumi.get(self, "header_name")

    @header_name.setter
    def header_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "header_name", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        The value to update the given header name with. This value is not used if the actionType is Delete.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class HealthProbeSettingsModelArgs:
    def __init__(__self__, *,
                 enabled_state: Optional[pulumi.Input[Union[str, 'HealthProbeEnabled']]] = None,
                 health_probe_method: Optional[pulumi.Input[Union[str, 'FrontDoorHealthProbeMethod']]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 interval_in_seconds: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 path: Optional[pulumi.Input[str]] = None,
                 protocol: Optional[pulumi.Input[Union[str, 'FrontDoorProtocol']]] = None):
        """
        Load balancing settings for a backend pool
        :param pulumi.Input[Union[str, 'HealthProbeEnabled']] enabled_state: Whether to enable health probes to be made against backends defined under backendPools. Health probes can only be disabled if there is a single enabled backend in single enabled backend pool.
        :param pulumi.Input[Union[str, 'FrontDoorHealthProbeMethod']] health_probe_method: Configures which HTTP method to use to probe the backends defined under backendPools.
        :param pulumi.Input[str] id: Resource ID.
        :param pulumi.Input[int] interval_in_seconds: The number of seconds between health probes.
        :param pulumi.Input[str] name: Resource name.
        :param pulumi.Input[str] path: The path to use for the health probe. Default is /
        :param pulumi.Input[Union[str, 'FrontDoorProtocol']] protocol: Protocol scheme to use for this probe
        """
        if enabled_state is not None:
            pulumi.set(__self__, "enabled_state", enabled_state)
        if health_probe_method is None:
            health_probe_method = 'HEAD'
        if health_probe_method is not None:
            pulumi.set(__self__, "health_probe_method", health_probe_method)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if interval_in_seconds is not None:
            pulumi.set(__self__, "interval_in_seconds", interval_in_seconds)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)

    @property
    @pulumi.getter(name="enabledState")
    def enabled_state(self) -> Optional[pulumi.Input[Union[str, 'HealthProbeEnabled']]]:
        """
        Whether to enable health probes to be made against backends defined under backendPools. Health probes can only be disabled if there is a single enabled backend in single enabled backend pool.
        """
        return pulumi.get(self, "enabled_state")

    @enabled_state.setter
    def enabled_state(self, value: Optional[pulumi.Input[Union[str, 'HealthProbeEnabled']]]):
        pulumi.set(self, "enabled_state", value)

    @property
    @pulumi.getter(name="healthProbeMethod")
    def health_probe_method(self) -> Optional[pulumi.Input[Union[str, 'FrontDoorHealthProbeMethod']]]:
        """
        Configures which HTTP method to use to probe the backends defined under backendPools.
        """
        return pulumi.get(self, "health_probe_method")

    @health_probe_method.setter
    def health_probe_method(self, value: Optional[pulumi.Input[Union[str, 'FrontDoorHealthProbeMethod']]]):
        pulumi.set(self, "health_probe_method", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="intervalInSeconds")
    def interval_in_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        The number of seconds between health probes.
        """
        return pulumi.get(self, "interval_in_seconds")

    @interval_in_seconds.setter
    def interval_in_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "interval_in_seconds", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Resource name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        The path to use for the health probe. Default is /
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[Union[str, 'FrontDoorProtocol']]]:
        """
        Protocol scheme to use for this probe
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[Union[str, 'FrontDoorProtocol']]]):
        pulumi.set(self, "protocol", value)


@pulumi.input_type
class HubIPAddressesArgs:
    def __init__(__self__, *,
                 private_ip_address: Optional[pulumi.Input[str]] = None,
                 public_ips: Optional[pulumi.Input['HubPublicIPAddressesArgs']] = None):
        """
        IP addresses associated with azure firewall.
        :param pulumi.Input[str] private_ip_address: Private IP Address associated with azure firewall.
        :param pulumi.Input['HubPublicIPAddressesArgs'] public_ips: Public IP addresses associated with azure firewall.
        """
        if private_ip_address is not None:
            pulumi.set(__self__, "private_ip_address", private_ip_address)
        if public_ips is not None:
            pulumi.set(__self__, "public_ips", public_ips)

    @property
    @pulumi.getter(name="privateIPAddress")
    def private_ip_address(self) -> Optional[pulumi.Input[str]]:
        """
        Private IP Address associated with azure firewall.
        """
        return pulumi.get(self, "private_ip_address")

    @private_ip_address.setter
    def private_ip_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_ip_address", value)

    @property
    @pulumi.getter(name="publicIPs")
    def public_ips(self) -> Optional[pulumi.Input['HubPublicIPAddressesArgs']]:
        """
        Public IP addresses associated with azure firewall.
        """
        return pulumi.get(self, "public_ips")

    @public_ips.setter
    def public_ips(self, value: Optional[pulumi.Input['HubPublicIPAddressesArgs']]):
        pulumi.set(self, "public_ips", value)


@pulumi.input_type
class HubPublicIPAddressesArgs:
    def __init__(__self__, *,
                 addresses: Optional[pulumi.Input[Sequence[pulumi.Input['AzureFirewallPublicIPAddressArgs']]]] = None,
                 count: Optional[pulumi.Input[int]] = None):
        """
        Public IP addresses associated with azure firewall.
        :param pulumi.Input[Sequence[pulumi.Input['AzureFirewallPublicIPAddressArgs']]] addresses: The list of Public IP addresses associated with azure firewall or IP addresses to be retained.
        :param pulumi.Input[int] count: The number of Public IP addresses associated with azure firewall.
        """
        if addresses is not None:
            pulumi.set(__self__, "addresses", addresses)
        if count is not None:
            pulumi.set(__self__, "count", count)

    @property
    @pulumi.getter
    def addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AzureFirewallPublicIPAddressArgs']]]]:
        """
        The list of Public IP addresses associated with azure firewall or IP addresses to be retained.
        """
        return pulumi.get(self, "addresses")

    @addresses.setter
    def addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AzureFirewallPublicIPAddressArgs']]]]):
        pulumi.set(self, "addresses", value)

    @property
    @pulumi.getter
    def count(self) -> Optional[pulumi.Input[int]]:
        """
        The number of Public IP addresses associated with azure firewall.
        """
        return pulumi.get(self, "count")

    @count.setter
    def count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "count", value)


@pulumi.input_type
class HubRouteArgs:
    def __init__(__self__, *,
                 destination_type: pulumi.Input[str],
                 destinations: pulumi.Input[Sequence[pulumi.Input[str]]],
                 name: pulumi.Input[str],
                 next_hop: pulumi.Input[str],
                 next_hop_type: pulumi.Input[str]):
        """
        RouteTable route.
        :param pulumi.Input[str] destination_type: The type of destinations (eg: CIDR, ResourceId, Service).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] destinations: List of all destinations.
        :param pulumi.Input[str] name: The name of the Route that is unique within a RouteTable. This name can be used to access this route.
        :param pulumi.Input[str] next_hop: NextHop resource ID.
        :param pulumi.Input[str] next_hop_type: The type of next hop (eg: ResourceId).
        """
        pulumi.set(__self__, "destination_type", destination_type)
        pulumi.set(__self__, "destinations", destinations)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "next_hop", next_hop)
        pulumi.set(__self__, "next_hop_type", next_hop_type)

    @property
    @pulumi.getter(name="destinationType")
    def destination_type(self) -> pulumi.Input[str]:
        """
        The type of destinations (eg: CIDR, ResourceId, Service).
        """
        return pulumi.get(self, "destination_type")

    @destination_type.setter
    def destination_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "destination_type", value)

    @property
    @pulumi.getter
    def destinations(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        List of all destinations.
        """
        return pulumi.get(self, "destinations")

    @destinations.setter
    def destinations(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "destinations", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the Route that is unique within a RouteTable. This name can be used to access this route.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="nextHop")
    def next_hop(self) -> pulumi.Input[str]:
        """
        NextHop resource ID.
        """
        return pulumi.get(self, "next_hop")

    @next_hop.setter
    def next_hop(self, value: pulumi.Input[str]):
        pulumi.set(self, "next_hop", value)

    @property
    @pulumi.getter(name="nextHopType")
    def next_hop_type(self) -> pulumi.Input[str]:
        """
        The type of next hop (eg: ResourceId).
        """
        return pulumi.get(self, "next_hop_type")

    @next_hop_type.setter
    def next_hop_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "next_hop_type", value)


@pulumi.input_type
class IPConfigurationBgpPeeringAddressArgs:
    def __init__(__self__, *,
                 custom_bgp_ip_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 ipconfiguration_id: Optional[pulumi.Input[str]] = None):
        """
        Properties of IPConfigurationBgpPeeringAddress.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] custom_bgp_ip_addresses: The list of custom BGP peering addresses which belong to IP configuration.
        :param pulumi.Input[str] ipconfiguration_id: The ID of IP configuration which belongs to gateway.
        """
        if custom_bgp_ip_addresses is not None:
            pulumi.set(__self__, "custom_bgp_ip_addresses", custom_bgp_ip_addresses)
        if ipconfiguration_id is not None:
            pulumi.set(__self__, "ipconfiguration_id", ipconfiguration_id)

    @property
    @pulumi.getter(name="customBgpIpAddresses")
    def custom_bgp_ip_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of custom BGP peering addresses which belong to IP configuration.
        """
        return pulumi.get(self, "custom_bgp_ip_addresses")

    @custom_bgp_ip_addresses.setter
    def custom_bgp_ip_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "custom_bgp_ip_addresses", value)

    @property
    @pulumi.getter(name="ipconfigurationId")
    def ipconfiguration_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of IP configuration which belongs to gateway.
        """
        return pulumi.get(self, "ipconfiguration_id")

    @ipconfiguration_id.setter
    def ipconfiguration_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipconfiguration_id", value)


@pulumi.input_type
class IPConfigurationProfileArgs:
    def __init__(__self__, *,
                 id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 subnet: Optional[pulumi.Input['SubnetArgs']] = None):
        """
        IP configuration profile child resource.
        :param pulumi.Input[str] id: Resource ID.
        :param pulumi.Input[str] name: The name of the resource. This name can be used to access the resource.
        :param pulumi.Input['SubnetArgs'] subnet: The reference to the subnet resource to create a container network interface ip configuration.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if subnet is not None:
            pulumi.set(__self__, "subnet", subnet)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the resource. This name can be used to access the resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def subnet(self) -> Optional[pulumi.Input['SubnetArgs']]:
        """
        The reference to the subnet resource to create a container network interface ip configuration.
        """
        return pulumi.get(self, "subnet")

    @subnet.setter
    def subnet(self, value: Optional[pulumi.Input['SubnetArgs']]):
        pulumi.set(self, "subnet", value)


@pulumi.input_type
class InboundNatPoolArgs:
    def __init__(__self__, *,
                 backend_port: pulumi.Input[int],
                 frontend_port_range_end: pulumi.Input[int],
                 frontend_port_range_start: pulumi.Input[int],
                 protocol: pulumi.Input[Union[str, 'TransportProtocol']],
                 enable_floating_ip: Optional[pulumi.Input[bool]] = None,
                 enable_tcp_reset: Optional[pulumi.Input[bool]] = None,
                 frontend_ip_configuration: Optional[pulumi.Input['SubResourceArgs']] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 idle_timeout_in_minutes: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        Inbound NAT pool of the load balancer.
        :param pulumi.Input[int] backend_port: The port used for internal connections on the endpoint. Acceptable values are between 1 and 65535.
        :param pulumi.Input[int] frontend_port_range_end: The last port number in the range of external ports that will be used to provide Inbound Nat to NICs associated with a load balancer. Acceptable values range between 1 and 65535.
        :param pulumi.Input[int] frontend_port_range_start: The first port number in the range of external ports that will be used to provide Inbound Nat to NICs associated with a load balancer. Acceptable values range between 1 and 65534.
        :param pulumi.Input[Union[str, 'TransportProtocol']] protocol: The reference to the transport protocol used by the inbound NAT pool.
        :param pulumi.Input[bool] enable_floating_ip: Configures a virtual machine's endpoint for the floating IP capability required to configure a SQL AlwaysOn Availability Group. This setting is required when using the SQL AlwaysOn Availability Groups in SQL server. This setting can't be changed after you create the endpoint.
        :param pulumi.Input[bool] enable_tcp_reset: Receive bidirectional TCP Reset on TCP flow idle timeout or unexpected connection termination. This element is only used when the protocol is set to TCP.
        :param pulumi.Input['SubResourceArgs'] frontend_ip_configuration: A reference to frontend IP addresses.
        :param pulumi.Input[str] id: Resource ID.
        :param pulumi.Input[int] idle_timeout_in_minutes: The timeout for the TCP idle connection. The value can be set between 4 and 30 minutes. The default value is 4 minutes. This element is only used when the protocol is set to TCP.
        :param pulumi.Input[str] name: The name of the resource that is unique within the set of inbound NAT pools used by the load balancer. This name can be used to access the resource.
        """
        pulumi.set(__self__, "backend_port", backend_port)
        pulumi.set(__self__, "frontend_port_range_end", frontend_port_range_end)
        pulumi.set(__self__, "frontend_port_range_start", frontend_port_range_start)
        pulumi.set(__self__, "protocol", protocol)
        if enable_floating_ip is not None:
            pulumi.set(__self__, "enable_floating_ip", enable_floating_ip)
        if enable_tcp_reset is not None:
            pulumi.set(__self__, "enable_tcp_reset", enable_tcp_reset)
        if frontend_ip_configuration is not None:
            pulumi.set(__self__, "frontend_ip_configuration", frontend_ip_configuration)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if idle_timeout_in_minutes is not None:
            pulumi.set(__self__, "idle_timeout_in_minutes", idle_timeout_in_minutes)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="backendPort")
    def backend_port(self) -> pulumi.Input[int]:
        """
        The port used for internal connections on the endpoint. Acceptable values are between 1 and 65535.
        """
        return pulumi.get(self, "backend_port")

    @backend_port.setter
    def backend_port(self, value: pulumi.Input[int]):
        pulumi.set(self, "backend_port", value)

    @property
    @pulumi.getter(name="frontendPortRangeEnd")
    def frontend_port_range_end(self) -> pulumi.Input[int]:
        """
        The last port number in the range of external ports that will be used to provide Inbound Nat to NICs associated with a load balancer. Acceptable values range between 1 and 65535.
        """
        return pulumi.get(self, "frontend_port_range_end")

    @frontend_port_range_end.setter
    def frontend_port_range_end(self, value: pulumi.Input[int]):
        pulumi.set(self, "frontend_port_range_end", value)

    @property
    @pulumi.getter(name="frontendPortRangeStart")
    def frontend_port_range_start(self) -> pulumi.Input[int]:
        """
        The first port number in the range of external ports that will be used to provide Inbound Nat to NICs associated with a load balancer. Acceptable values range between 1 and 65534.
        """
        return pulumi.get(self, "frontend_port_range_start")

    @frontend_port_range_start.setter
    def frontend_port_range_start(self, value: pulumi.Input[int]):
        pulumi.set(self, "frontend_port_range_start", value)

    @property
    @pulumi.getter
    def protocol(self) -> pulumi.Input[Union[str, 'TransportProtocol']]:
        """
        The reference to the transport protocol used by the inbound NAT pool.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: pulumi.Input[Union[str, 'TransportProtocol']]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter(name="enableFloatingIP")
    def enable_floating_ip(self) -> Optional[pulumi.Input[bool]]:
        """
        Configures a virtual machine's endpoint for the floating IP capability required to configure a SQL AlwaysOn Availability Group. This setting is required when using the SQL AlwaysOn Availability Groups in SQL server. This setting can't be changed after you create the endpoint.
        """
        return pulumi.get(self, "enable_floating_ip")

    @enable_floating_ip.setter
    def enable_floating_ip(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_floating_ip", value)

    @property
    @pulumi.getter(name="enableTcpReset")
    def enable_tcp_reset(self) -> Optional[pulumi.Input[bool]]:
        """
        Receive bidirectional TCP Reset on TCP flow idle timeout or unexpected connection termination. This element is only used when the protocol is set to TCP.
        """
        return pulumi.get(self, "enable_tcp_reset")

    @enable_tcp_reset.setter
    def enable_tcp_reset(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_tcp_reset", value)

    @property
    @pulumi.getter(name="frontendIPConfiguration")
    def frontend_ip_configuration(self) -> Optional[pulumi.Input['SubResourceArgs']]:
        """
        A reference to frontend IP addresses.
        """
        return pulumi.get(self, "frontend_ip_configuration")

    @frontend_ip_configuration.setter
    def frontend_ip_configuration(self, value: Optional[pulumi.Input['SubResourceArgs']]):
        pulumi.set(self, "frontend_ip_configuration", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="idleTimeoutInMinutes")
    def idle_timeout_in_minutes(self) -> Optional[pulumi.Input[int]]:
        """
        The timeout for the TCP idle connection. The value can be set between 4 and 30 minutes. The default value is 4 minutes. This element is only used when the protocol is set to TCP.
        """
        return pulumi.get(self, "idle_timeout_in_minutes")

    @idle_timeout_in_minutes.setter
    def idle_timeout_in_minutes(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "idle_timeout_in_minutes", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the resource that is unique within the set of inbound NAT pools used by the load balancer. This name can be used to access the resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class InboundNatRuleArgs:
    def __init__(__self__, *,
                 backend_port: Optional[pulumi.Input[int]] = None,
                 enable_floating_ip: Optional[pulumi.Input[bool]] = None,
                 enable_tcp_reset: Optional[pulumi.Input[bool]] = None,
                 frontend_ip_configuration: Optional[pulumi.Input['SubResourceArgs']] = None,
                 frontend_port: Optional[pulumi.Input[int]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 idle_timeout_in_minutes: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 protocol: Optional[pulumi.Input[Union[str, 'TransportProtocol']]] = None):
        """
        Inbound NAT rule of the load balancer.
        :param pulumi.Input[int] backend_port: The port used for the internal endpoint. Acceptable values range from 1 to 65535.
        :param pulumi.Input[bool] enable_floating_ip: Configures a virtual machine's endpoint for the floating IP capability required to configure a SQL AlwaysOn Availability Group. This setting is required when using the SQL AlwaysOn Availability Groups in SQL server. This setting can't be changed after you create the endpoint.
        :param pulumi.Input[bool] enable_tcp_reset: Receive bidirectional TCP Reset on TCP flow idle timeout or unexpected connection termination. This element is only used when the protocol is set to TCP.
        :param pulumi.Input['SubResourceArgs'] frontend_ip_configuration: A reference to frontend IP addresses.
        :param pulumi.Input[int] frontend_port: The port for the external endpoint. Port numbers for each rule must be unique within the Load Balancer. Acceptable values range from 1 to 65534.
        :param pulumi.Input[str] id: Resource ID.
        :param pulumi.Input[int] idle_timeout_in_minutes: The timeout for the TCP idle connection. The value can be set between 4 and 30 minutes. The default value is 4 minutes. This element is only used when the protocol is set to TCP.
        :param pulumi.Input[str] name: The name of the resource that is unique within the set of inbound NAT rules used by the load balancer. This name can be used to access the resource.
        :param pulumi.Input[Union[str, 'TransportProtocol']] protocol: The reference to the transport protocol used by the load balancing rule.
        """
        if backend_port is not None:
            pulumi.set(__self__, "backend_port", backend_port)
        if enable_floating_ip is not None:
            pulumi.set(__self__, "enable_floating_ip", enable_floating_ip)
        if enable_tcp_reset is not None:
            pulumi.set(__self__, "enable_tcp_reset", enable_tcp_reset)
        if frontend_ip_configuration is not None:
            pulumi.set(__self__, "frontend_ip_configuration", frontend_ip_configuration)
        if frontend_port is not None:
            pulumi.set(__self__, "frontend_port", frontend_port)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if idle_timeout_in_minutes is not None:
            pulumi.set(__self__, "idle_timeout_in_minutes", idle_timeout_in_minutes)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)

    @property
    @pulumi.getter(name="backendPort")
    def backend_port(self) -> Optional[pulumi.Input[int]]:
        """
        The port used for the internal endpoint. Acceptable values range from 1 to 65535.
        """
        return pulumi.get(self, "backend_port")

    @backend_port.setter
    def backend_port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "backend_port", value)

    @property
    @pulumi.getter(name="enableFloatingIP")
    def enable_floating_ip(self) -> Optional[pulumi.Input[bool]]:
        """
        Configures a virtual machine's endpoint for the floating IP capability required to configure a SQL AlwaysOn Availability Group. This setting is required when using the SQL AlwaysOn Availability Groups in SQL server. This setting can't be changed after you create the endpoint.
        """
        return pulumi.get(self, "enable_floating_ip")

    @enable_floating_ip.setter
    def enable_floating_ip(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_floating_ip", value)

    @property
    @pulumi.getter(name="enableTcpReset")
    def enable_tcp_reset(self) -> Optional[pulumi.Input[bool]]:
        """
        Receive bidirectional TCP Reset on TCP flow idle timeout or unexpected connection termination. This element is only used when the protocol is set to TCP.
        """
        return pulumi.get(self, "enable_tcp_reset")

    @enable_tcp_reset.setter
    def enable_tcp_reset(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_tcp_reset", value)

    @property
    @pulumi.getter(name="frontendIPConfiguration")
    def frontend_ip_configuration(self) -> Optional[pulumi.Input['SubResourceArgs']]:
        """
        A reference to frontend IP addresses.
        """
        return pulumi.get(self, "frontend_ip_configuration")

    @frontend_ip_configuration.setter
    def frontend_ip_configuration(self, value: Optional[pulumi.Input['SubResourceArgs']]):
        pulumi.set(self, "frontend_ip_configuration", value)

    @property
    @pulumi.getter(name="frontendPort")
    def frontend_port(self) -> Optional[pulumi.Input[int]]:
        """
        The port for the external endpoint. Port numbers for each rule must be unique within the Load Balancer. Acceptable values range from 1 to 65534.
        """
        return pulumi.get(self, "frontend_port")

    @frontend_port.setter
    def frontend_port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "frontend_port", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="idleTimeoutInMinutes")
    def idle_timeout_in_minutes(self) -> Optional[pulumi.Input[int]]:
        """
        The timeout for the TCP idle connection. The value can be set between 4 and 30 minutes. The default value is 4 minutes. This element is only used when the protocol is set to TCP.
        """
        return pulumi.get(self, "idle_timeout_in_minutes")

    @idle_timeout_in_minutes.setter
    def idle_timeout_in_minutes(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "idle_timeout_in_minutes", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the resource that is unique within the set of inbound NAT rules used by the load balancer. This name can be used to access the resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[Union[str, 'TransportProtocol']]]:
        """
        The reference to the transport protocol used by the load balancing rule.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[Union[str, 'TransportProtocol']]]):
        pulumi.set(self, "protocol", value)


@pulumi.input_type
class IpTagArgs:
    def __init__(__self__, *,
                 ip_tag_type: Optional[pulumi.Input[str]] = None,
                 tag: Optional[pulumi.Input[str]] = None):
        """
        Contains the IpTag associated with the object.
        :param pulumi.Input[str] ip_tag_type: The IP tag type. Example: FirstPartyUsage.
        :param pulumi.Input[str] tag: The value of the IP tag associated with the public IP. Example: SQL.
        """
        if ip_tag_type is not None:
            pulumi.set(__self__, "ip_tag_type", ip_tag_type)
        if tag is not None:
            pulumi.set(__self__, "tag", tag)

    @property
    @pulumi.getter(name="ipTagType")
    def ip_tag_type(self) -> Optional[pulumi.Input[str]]:
        """
        The IP tag type. Example: FirstPartyUsage.
        """
        return pulumi.get(self, "ip_tag_type")

    @ip_tag_type.setter
    def ip_tag_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip_tag_type", value)

    @property
    @pulumi.getter
    def tag(self) -> Optional[pulumi.Input[str]]:
        """
        The value of the IP tag associated with the public IP. Example: SQL.
        """
        return pulumi.get(self, "tag")

    @tag.setter
    def tag(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tag", value)


@pulumi.input_type
class IpsecPolicyArgs:
    def __init__(__self__, *,
                 dh_group: pulumi.Input[Union[str, 'DhGroup']],
                 ike_encryption: pulumi.Input[Union[str, 'IkeEncryption']],
                 ike_integrity: pulumi.Input[Union[str, 'IkeIntegrity']],
                 ipsec_encryption: pulumi.Input[Union[str, 'IpsecEncryption']],
                 ipsec_integrity: pulumi.Input[Union[str, 'IpsecIntegrity']],
                 pfs_group: pulumi.Input[Union[str, 'PfsGroup']],
                 sa_data_size_kilobytes: pulumi.Input[int],
                 sa_life_time_seconds: pulumi.Input[int]):
        """
        An IPSec Policy configuration for a virtual network gateway connection.
        :param pulumi.Input[Union[str, 'DhGroup']] dh_group: The DH Group used in IKE Phase 1 for initial SA.
        :param pulumi.Input[Union[str, 'IkeEncryption']] ike_encryption: The IKE encryption algorithm (IKE phase 2).
        :param pulumi.Input[Union[str, 'IkeIntegrity']] ike_integrity: The IKE integrity algorithm (IKE phase 2).
        :param pulumi.Input[Union[str, 'IpsecEncryption']] ipsec_encryption: The IPSec encryption algorithm (IKE phase 1).
        :param pulumi.Input[Union[str, 'IpsecIntegrity']] ipsec_integrity: The IPSec integrity algorithm (IKE phase 1).
        :param pulumi.Input[Union[str, 'PfsGroup']] pfs_group: The Pfs Group used in IKE Phase 2 for new child SA.
        :param pulumi.Input[int] sa_data_size_kilobytes: The IPSec Security Association (also called Quick Mode or Phase 2 SA) payload size in KB for a site to site VPN tunnel.
        :param pulumi.Input[int] sa_life_time_seconds: The IPSec Security Association (also called Quick Mode or Phase 2 SA) lifetime in seconds for a site to site VPN tunnel.
        """
        pulumi.set(__self__, "dh_group", dh_group)
        pulumi.set(__self__, "ike_encryption", ike_encryption)
        pulumi.set(__self__, "ike_integrity", ike_integrity)
        pulumi.set(__self__, "ipsec_encryption", ipsec_encryption)
        pulumi.set(__self__, "ipsec_integrity", ipsec_integrity)
        pulumi.set(__self__, "pfs_group", pfs_group)
        pulumi.set(__self__, "sa_data_size_kilobytes", sa_data_size_kilobytes)
        pulumi.set(__self__, "sa_life_time_seconds", sa_life_time_seconds)

    @property
    @pulumi.getter(name="dhGroup")
    def dh_group(self) -> pulumi.Input[Union[str, 'DhGroup']]:
        """
        The DH Group used in IKE Phase 1 for initial SA.
        """
        return pulumi.get(self, "dh_group")

    @dh_group.setter
    def dh_group(self, value: pulumi.Input[Union[str, 'DhGroup']]):
        pulumi.set(self, "dh_group", value)

    @property
    @pulumi.getter(name="ikeEncryption")
    def ike_encryption(self) -> pulumi.Input[Union[str, 'IkeEncryption']]:
        """
        The IKE encryption algorithm (IKE phase 2).
        """
        return pulumi.get(self, "ike_encryption")

    @ike_encryption.setter
    def ike_encryption(self, value: pulumi.Input[Union[str, 'IkeEncryption']]):
        pulumi.set(self, "ike_encryption", value)

    @property
    @pulumi.getter(name="ikeIntegrity")
    def ike_integrity(self) -> pulumi.Input[Union[str, 'IkeIntegrity']]:
        """
        The IKE integrity algorithm (IKE phase 2).
        """
        return pulumi.get(self, "ike_integrity")

    @ike_integrity.setter
    def ike_integrity(self, value: pulumi.Input[Union[str, 'IkeIntegrity']]):
        pulumi.set(self, "ike_integrity", value)

    @property
    @pulumi.getter(name="ipsecEncryption")
    def ipsec_encryption(self) -> pulumi.Input[Union[str, 'IpsecEncryption']]:
        """
        The IPSec encryption algorithm (IKE phase 1).
        """
        return pulumi.get(self, "ipsec_encryption")

    @ipsec_encryption.setter
    def ipsec_encryption(self, value: pulumi.Input[Union[str, 'IpsecEncryption']]):
        pulumi.set(self, "ipsec_encryption", value)

    @property
    @pulumi.getter(name="ipsecIntegrity")
    def ipsec_integrity(self) -> pulumi.Input[Union[str, 'IpsecIntegrity']]:
        """
        The IPSec integrity algorithm (IKE phase 1).
        """
        return pulumi.get(self, "ipsec_integrity")

    @ipsec_integrity.setter
    def ipsec_integrity(self, value: pulumi.Input[Union[str, 'IpsecIntegrity']]):
        pulumi.set(self, "ipsec_integrity", value)

    @property
    @pulumi.getter(name="pfsGroup")
    def pfs_group(self) -> pulumi.Input[Union[str, 'PfsGroup']]:
        """
        The Pfs Group used in IKE Phase 2 for new child SA.
        """
        return pulumi.get(self, "pfs_group")

    @pfs_group.setter
    def pfs_group(self, value: pulumi.Input[Union[str, 'PfsGroup']]):
        pulumi.set(self, "pfs_group", value)

    @property
    @pulumi.getter(name="saDataSizeKilobytes")
    def sa_data_size_kilobytes(self) -> pulumi.Input[int]:
        """
        The IPSec Security Association (also called Quick Mode or Phase 2 SA) payload size in KB for a site to site VPN tunnel.
        """
        return pulumi.get(self, "sa_data_size_kilobytes")

    @sa_data_size_kilobytes.setter
    def sa_data_size_kilobytes(self, value: pulumi.Input[int]):
        pulumi.set(self, "sa_data_size_kilobytes", value)

    @property
    @pulumi.getter(name="saLifeTimeSeconds")
    def sa_life_time_seconds(self) -> pulumi.Input[int]:
        """
        The IPSec Security Association (also called Quick Mode or Phase 2 SA) lifetime in seconds for a site to site VPN tunnel.
        """
        return pulumi.get(self, "sa_life_time_seconds")

    @sa_life_time_seconds.setter
    def sa_life_time_seconds(self, value: pulumi.Input[int]):
        pulumi.set(self, "sa_life_time_seconds", value)


@pulumi.input_type
class Ipv6CircuitConnectionConfigArgs:
    def __init__(__self__, *,
                 address_prefix: Optional[pulumi.Input[str]] = None):
        """
        IPv6 Circuit Connection properties for global reach.
        :param pulumi.Input[str] address_prefix: /125 IP address space to carve out customer addresses for global reach.
        """
        if address_prefix is not None:
            pulumi.set(__self__, "address_prefix", address_prefix)

    @property
    @pulumi.getter(name="addressPrefix")
    def address_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        /125 IP address space to carve out customer addresses for global reach.
        """
        return pulumi.get(self, "address_prefix")

    @address_prefix.setter
    def address_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "address_prefix", value)


@pulumi.input_type
class Ipv6ExpressRouteCircuitPeeringConfigArgs:
    def __init__(__self__, *,
                 microsoft_peering_config: Optional[pulumi.Input['ExpressRouteCircuitPeeringConfigArgs']] = None,
                 primary_peer_address_prefix: Optional[pulumi.Input[str]] = None,
                 route_filter: Optional[pulumi.Input['SubResourceArgs']] = None,
                 secondary_peer_address_prefix: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[Union[str, 'ExpressRouteCircuitPeeringState']]] = None):
        """
        Contains IPv6 peering config.
        :param pulumi.Input['ExpressRouteCircuitPeeringConfigArgs'] microsoft_peering_config: The Microsoft peering configuration.
        :param pulumi.Input[str] primary_peer_address_prefix: The primary address prefix.
        :param pulumi.Input['SubResourceArgs'] route_filter: The reference to the RouteFilter resource.
        :param pulumi.Input[str] secondary_peer_address_prefix: The secondary address prefix.
        :param pulumi.Input[Union[str, 'ExpressRouteCircuitPeeringState']] state: The state of peering.
        """
        if microsoft_peering_config is not None:
            pulumi.set(__self__, "microsoft_peering_config", microsoft_peering_config)
        if primary_peer_address_prefix is not None:
            pulumi.set(__self__, "primary_peer_address_prefix", primary_peer_address_prefix)
        if route_filter is not None:
            pulumi.set(__self__, "route_filter", route_filter)
        if secondary_peer_address_prefix is not None:
            pulumi.set(__self__, "secondary_peer_address_prefix", secondary_peer_address_prefix)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="microsoftPeeringConfig")
    def microsoft_peering_config(self) -> Optional[pulumi.Input['ExpressRouteCircuitPeeringConfigArgs']]:
        """
        The Microsoft peering configuration.
        """
        return pulumi.get(self, "microsoft_peering_config")

    @microsoft_peering_config.setter
    def microsoft_peering_config(self, value: Optional[pulumi.Input['ExpressRouteCircuitPeeringConfigArgs']]):
        pulumi.set(self, "microsoft_peering_config", value)

    @property
    @pulumi.getter(name="primaryPeerAddressPrefix")
    def primary_peer_address_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        The primary address prefix.
        """
        return pulumi.get(self, "primary_peer_address_prefix")

    @primary_peer_address_prefix.setter
    def primary_peer_address_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "primary_peer_address_prefix", value)

    @property
    @pulumi.getter(name="routeFilter")
    def route_filter(self) -> Optional[pulumi.Input['SubResourceArgs']]:
        """
        The reference to the RouteFilter resource.
        """
        return pulumi.get(self, "route_filter")

    @route_filter.setter
    def route_filter(self, value: Optional[pulumi.Input['SubResourceArgs']]):
        pulumi.set(self, "route_filter", value)

    @property
    @pulumi.getter(name="secondaryPeerAddressPrefix")
    def secondary_peer_address_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        The secondary address prefix.
        """
        return pulumi.get(self, "secondary_peer_address_prefix")

    @secondary_peer_address_prefix.setter
    def secondary_peer_address_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secondary_peer_address_prefix", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[Union[str, 'ExpressRouteCircuitPeeringState']]]:
        """
        The state of peering.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[Union[str, 'ExpressRouteCircuitPeeringState']]]):
        pulumi.set(self, "state", value)


@pulumi.input_type
class LoadBalancerBackendAddressArgs:
    def __init__(__self__, *,
                 ip_address: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 virtual_network: Optional[pulumi.Input['SubResourceArgs']] = None):
        """
        Load balancer backend addresses.
        :param pulumi.Input[str] ip_address: IP Address belonging to the referenced virtual network.
        :param pulumi.Input[str] name: Name of the backend address.
        :param pulumi.Input['SubResourceArgs'] virtual_network: Reference to an existing virtual network.
        """
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if virtual_network is not None:
            pulumi.set(__self__, "virtual_network", virtual_network)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[pulumi.Input[str]]:
        """
        IP Address belonging to the referenced virtual network.
        """
        return pulumi.get(self, "ip_address")

    @ip_address.setter
    def ip_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip_address", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the backend address.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="virtualNetwork")
    def virtual_network(self) -> Optional[pulumi.Input['SubResourceArgs']]:
        """
        Reference to an existing virtual network.
        """
        return pulumi.get(self, "virtual_network")

    @virtual_network.setter
    def virtual_network(self, value: Optional[pulumi.Input['SubResourceArgs']]):
        pulumi.set(self, "virtual_network", value)


@pulumi.input_type
class LoadBalancerSkuArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[Union[str, 'LoadBalancerSkuName']]] = None):
        """
        SKU of a load balancer.
        :param pulumi.Input[Union[str, 'LoadBalancerSkuName']] name: Name of a load balancer SKU.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[Union[str, 'LoadBalancerSkuName']]]:
        """
        Name of a load balancer SKU.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[Union[str, 'LoadBalancerSkuName']]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class LoadBalancingRuleArgs:
    def __init__(__self__, *,
                 frontend_port: pulumi.Input[int],
                 protocol: pulumi.Input[Union[str, 'TransportProtocol']],
                 backend_address_pool: Optional[pulumi.Input['SubResourceArgs']] = None,
                 backend_port: Optional[pulumi.Input[int]] = None,
                 disable_outbound_snat: Optional[pulumi.Input[bool]] = None,
                 enable_floating_ip: Optional[pulumi.Input[bool]] = None,
                 enable_tcp_reset: Optional[pulumi.Input[bool]] = None,
                 frontend_ip_configuration: Optional[pulumi.Input['SubResourceArgs']] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 idle_timeout_in_minutes: Optional[pulumi.Input[int]] = None,
                 load_distribution: Optional[pulumi.Input[Union[str, 'LoadDistribution']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 probe: Optional[pulumi.Input['SubResourceArgs']] = None):
        """
        A load balancing rule for a load balancer.
        :param pulumi.Input[int] frontend_port: The port for the external endpoint. Port numbers for each rule must be unique within the Load Balancer. Acceptable values are between 0 and 65534. Note that value 0 enables "Any Port".
        :param pulumi.Input[Union[str, 'TransportProtocol']] protocol: The reference to the transport protocol used by the load balancing rule.
        :param pulumi.Input['SubResourceArgs'] backend_address_pool: A reference to a pool of DIPs. Inbound traffic is randomly load balanced across IPs in the backend IPs.
        :param pulumi.Input[int] backend_port: The port used for internal connections on the endpoint. Acceptable values are between 0 and 65535. Note that value 0 enables "Any Port".
        :param pulumi.Input[bool] disable_outbound_snat: Configures SNAT for the VMs in the backend pool to use the publicIP address specified in the frontend of the load balancing rule.
        :param pulumi.Input[bool] enable_floating_ip: Configures a virtual machine's endpoint for the floating IP capability required to configure a SQL AlwaysOn Availability Group. This setting is required when using the SQL AlwaysOn Availability Groups in SQL server. This setting can't be changed after you create the endpoint.
        :param pulumi.Input[bool] enable_tcp_reset: Receive bidirectional TCP Reset on TCP flow idle timeout or unexpected connection termination. This element is only used when the protocol is set to TCP.
        :param pulumi.Input['SubResourceArgs'] frontend_ip_configuration: A reference to frontend IP addresses.
        :param pulumi.Input[str] id: Resource ID.
        :param pulumi.Input[int] idle_timeout_in_minutes: The timeout for the TCP idle connection. The value can be set between 4 and 30 minutes. The default value is 4 minutes. This element is only used when the protocol is set to TCP.
        :param pulumi.Input[Union[str, 'LoadDistribution']] load_distribution: The load distribution policy for this rule.
        :param pulumi.Input[str] name: The name of the resource that is unique within the set of load balancing rules used by the load balancer. This name can be used to access the resource.
        :param pulumi.Input['SubResourceArgs'] probe: The reference to the load balancer probe used by the load balancing rule.
        """
        pulumi.set(__self__, "frontend_port", frontend_port)
        pulumi.set(__self__, "protocol", protocol)
        if backend_address_pool is not None:
            pulumi.set(__self__, "backend_address_pool", backend_address_pool)
        if backend_port is not None:
            pulumi.set(__self__, "backend_port", backend_port)
        if disable_outbound_snat is not None:
            pulumi.set(__self__, "disable_outbound_snat", disable_outbound_snat)
        if enable_floating_ip is not None:
            pulumi.set(__self__, "enable_floating_ip", enable_floating_ip)
        if enable_tcp_reset is not None:
            pulumi.set(__self__, "enable_tcp_reset", enable_tcp_reset)
        if frontend_ip_configuration is not None:
            pulumi.set(__self__, "frontend_ip_configuration", frontend_ip_configuration)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if idle_timeout_in_minutes is not None:
            pulumi.set(__self__, "idle_timeout_in_minutes", idle_timeout_in_minutes)
        if load_distribution is not None:
            pulumi.set(__self__, "load_distribution", load_distribution)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if probe is not None:
            pulumi.set(__self__, "probe", probe)

    @property
    @pulumi.getter(name="frontendPort")
    def frontend_port(self) -> pulumi.Input[int]:
        """
        The port for the external endpoint. Port numbers for each rule must be unique within the Load Balancer. Acceptable values are between 0 and 65534. Note that value 0 enables "Any Port".
        """
        return pulumi.get(self, "frontend_port")

    @frontend_port.setter
    def frontend_port(self, value: pulumi.Input[int]):
        pulumi.set(self, "frontend_port", value)

    @property
    @pulumi.getter
    def protocol(self) -> pulumi.Input[Union[str, 'TransportProtocol']]:
        """
        The reference to the transport protocol used by the load balancing rule.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: pulumi.Input[Union[str, 'TransportProtocol']]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter(name="backendAddressPool")
    def backend_address_pool(self) -> Optional[pulumi.Input['SubResourceArgs']]:
        """
        A reference to a pool of DIPs. Inbound traffic is randomly load balanced across IPs in the backend IPs.
        """
        return pulumi.get(self, "backend_address_pool")

    @backend_address_pool.setter
    def backend_address_pool(self, value: Optional[pulumi.Input['SubResourceArgs']]):
        pulumi.set(self, "backend_address_pool", value)

    @property
    @pulumi.getter(name="backendPort")
    def backend_port(self) -> Optional[pulumi.Input[int]]:
        """
        The port used for internal connections on the endpoint. Acceptable values are between 0 and 65535. Note that value 0 enables "Any Port".
        """
        return pulumi.get(self, "backend_port")

    @backend_port.setter
    def backend_port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "backend_port", value)

    @property
    @pulumi.getter(name="disableOutboundSnat")
    def disable_outbound_snat(self) -> Optional[pulumi.Input[bool]]:
        """
        Configures SNAT for the VMs in the backend pool to use the publicIP address specified in the frontend of the load balancing rule.
        """
        return pulumi.get(self, "disable_outbound_snat")

    @disable_outbound_snat.setter
    def disable_outbound_snat(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable_outbound_snat", value)

    @property
    @pulumi.getter(name="enableFloatingIP")
    def enable_floating_ip(self) -> Optional[pulumi.Input[bool]]:
        """
        Configures a virtual machine's endpoint for the floating IP capability required to configure a SQL AlwaysOn Availability Group. This setting is required when using the SQL AlwaysOn Availability Groups in SQL server. This setting can't be changed after you create the endpoint.
        """
        return pulumi.get(self, "enable_floating_ip")

    @enable_floating_ip.setter
    def enable_floating_ip(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_floating_ip", value)

    @property
    @pulumi.getter(name="enableTcpReset")
    def enable_tcp_reset(self) -> Optional[pulumi.Input[bool]]:
        """
        Receive bidirectional TCP Reset on TCP flow idle timeout or unexpected connection termination. This element is only used when the protocol is set to TCP.
        """
        return pulumi.get(self, "enable_tcp_reset")

    @enable_tcp_reset.setter
    def enable_tcp_reset(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_tcp_reset", value)

    @property
    @pulumi.getter(name="frontendIPConfiguration")
    def frontend_ip_configuration(self) -> Optional[pulumi.Input['SubResourceArgs']]:
        """
        A reference to frontend IP addresses.
        """
        return pulumi.get(self, "frontend_ip_configuration")

    @frontend_ip_configuration.setter
    def frontend_ip_configuration(self, value: Optional[pulumi.Input['SubResourceArgs']]):
        pulumi.set(self, "frontend_ip_configuration", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="idleTimeoutInMinutes")
    def idle_timeout_in_minutes(self) -> Optional[pulumi.Input[int]]:
        """
        The timeout for the TCP idle connection. The value can be set between 4 and 30 minutes. The default value is 4 minutes. This element is only used when the protocol is set to TCP.
        """
        return pulumi.get(self, "idle_timeout_in_minutes")

    @idle_timeout_in_minutes.setter
    def idle_timeout_in_minutes(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "idle_timeout_in_minutes", value)

    @property
    @pulumi.getter(name="loadDistribution")
    def load_distribution(self) -> Optional[pulumi.Input[Union[str, 'LoadDistribution']]]:
        """
        The load distribution policy for this rule.
        """
        return pulumi.get(self, "load_distribution")

    @load_distribution.setter
    def load_distribution(self, value: Optional[pulumi.Input[Union[str, 'LoadDistribution']]]):
        pulumi.set(self, "load_distribution", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the resource that is unique within the set of load balancing rules used by the load balancer. This name can be used to access the resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def probe(self) -> Optional[pulumi.Input['SubResourceArgs']]:
        """
        The reference to the load balancer probe used by the load balancing rule.
        """
        return pulumi.get(self, "probe")

    @probe.setter
    def probe(self, value: Optional[pulumi.Input['SubResourceArgs']]):
        pulumi.set(self, "probe", value)


@pulumi.input_type
class LoadBalancingSettingsModelArgs:
    def __init__(__self__, *,
                 additional_latency_milliseconds: Optional[pulumi.Input[int]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 sample_size: Optional[pulumi.Input[int]] = None,
                 successful_samples_required: Optional[pulumi.Input[int]] = None):
        """
        Load balancing settings for a backend pool
        :param pulumi.Input[int] additional_latency_milliseconds: The additional latency in milliseconds for probes to fall into the lowest latency bucket
        :param pulumi.Input[str] id: Resource ID.
        :param pulumi.Input[str] name: Resource name.
        :param pulumi.Input[int] sample_size: The number of samples to consider for load balancing decisions
        :param pulumi.Input[int] successful_samples_required: The number of samples within the sample period that must succeed
        """
        if additional_latency_milliseconds is not None:
            pulumi.set(__self__, "additional_latency_milliseconds", additional_latency_milliseconds)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if sample_size is not None:
            pulumi.set(__self__, "sample_size", sample_size)
        if successful_samples_required is not None:
            pulumi.set(__self__, "successful_samples_required", successful_samples_required)

    @property
    @pulumi.getter(name="additionalLatencyMilliseconds")
    def additional_latency_milliseconds(self) -> Optional[pulumi.Input[int]]:
        """
        The additional latency in milliseconds for probes to fall into the lowest latency bucket
        """
        return pulumi.get(self, "additional_latency_milliseconds")

    @additional_latency_milliseconds.setter
    def additional_latency_milliseconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "additional_latency_milliseconds", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Resource name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="sampleSize")
    def sample_size(self) -> Optional[pulumi.Input[int]]:
        """
        The number of samples to consider for load balancing decisions
        """
        return pulumi.get(self, "sample_size")

    @sample_size.setter
    def sample_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "sample_size", value)

    @property
    @pulumi.getter(name="successfulSamplesRequired")
    def successful_samples_required(self) -> Optional[pulumi.Input[int]]:
        """
        The number of samples within the sample period that must succeed
        """
        return pulumi.get(self, "successful_samples_required")

    @successful_samples_required.setter
    def successful_samples_required(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "successful_samples_required", value)


@pulumi.input_type
class LocalNetworkGatewayArgs:
    def __init__(__self__, *,
                 bgp_settings: Optional[pulumi.Input['BgpSettingsArgs']] = None,
                 fqdn: Optional[pulumi.Input[str]] = None,
                 gateway_ip_address: Optional[pulumi.Input[str]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 local_network_address_space: Optional[pulumi.Input['AddressSpaceArgs']] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        A common class for general resource information.
        :param pulumi.Input['BgpSettingsArgs'] bgp_settings: Local network gateway's BGP speaker settings.
        :param pulumi.Input[str] fqdn: FQDN of local network gateway.
        :param pulumi.Input[str] gateway_ip_address: IP address of local network gateway.
        :param pulumi.Input[str] id: Resource ID.
        :param pulumi.Input['AddressSpaceArgs'] local_network_address_space: Local network site address space.
        :param pulumi.Input[str] location: Resource location.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Resource tags.
        """
        if bgp_settings is not None:
            pulumi.set(__self__, "bgp_settings", bgp_settings)
        if fqdn is not None:
            pulumi.set(__self__, "fqdn", fqdn)
        if gateway_ip_address is not None:
            pulumi.set(__self__, "gateway_ip_address", gateway_ip_address)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if local_network_address_space is not None:
            pulumi.set(__self__, "local_network_address_space", local_network_address_space)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="bgpSettings")
    def bgp_settings(self) -> Optional[pulumi.Input['BgpSettingsArgs']]:
        """
        Local network gateway's BGP speaker settings.
        """
        return pulumi.get(self, "bgp_settings")

    @bgp_settings.setter
    def bgp_settings(self, value: Optional[pulumi.Input['BgpSettingsArgs']]):
        pulumi.set(self, "bgp_settings", value)

    @property
    @pulumi.getter
    def fqdn(self) -> Optional[pulumi.Input[str]]:
        """
        FQDN of local network gateway.
        """
        return pulumi.get(self, "fqdn")

    @fqdn.setter
    def fqdn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fqdn", value)

    @property
    @pulumi.getter(name="gatewayIpAddress")
    def gateway_ip_address(self) -> Optional[pulumi.Input[str]]:
        """
        IP address of local network gateway.
        """
        return pulumi.get(self, "gateway_ip_address")

    @gateway_ip_address.setter
    def gateway_ip_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "gateway_ip_address", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="localNetworkAddressSpace")
    def local_network_address_space(self) -> Optional[pulumi.Input['AddressSpaceArgs']]:
        """
        Local network site address space.
        """
        return pulumi.get(self, "local_network_address_space")

    @local_network_address_space.setter
    def local_network_address_space(self, value: Optional[pulumi.Input['AddressSpaceArgs']]):
        pulumi.set(self, "local_network_address_space", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        Resource location.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Resource tags.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class ManagedRuleGroupOverrideArgs:
    def __init__(__self__, *,
                 rule_group_name: pulumi.Input[str],
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input['ManagedRuleOverrideArgs']]]] = None):
        """
        Defines a managed rule group override setting.
        :param pulumi.Input[str] rule_group_name: The managed rule group to override.
        :param pulumi.Input[Sequence[pulumi.Input['ManagedRuleOverrideArgs']]] rules: List of rules that will be disabled. If none specified, all rules in the group will be disabled.
        """
        pulumi.set(__self__, "rule_group_name", rule_group_name)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)

    @property
    @pulumi.getter(name="ruleGroupName")
    def rule_group_name(self) -> pulumi.Input[str]:
        """
        The managed rule group to override.
        """
        return pulumi.get(self, "rule_group_name")

    @rule_group_name.setter
    def rule_group_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "rule_group_name", value)

    @property
    @pulumi.getter
    def rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ManagedRuleOverrideArgs']]]]:
        """
        List of rules that will be disabled. If none specified, all rules in the group will be disabled.
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ManagedRuleOverrideArgs']]]]):
        pulumi.set(self, "rules", value)


@pulumi.input_type
class ManagedRuleOverrideArgs:
    def __init__(__self__, *,
                 rule_id: pulumi.Input[str],
                 state: Optional[pulumi.Input[Union[str, 'ManagedRuleEnabledState']]] = None):
        """
        Defines a managed rule group override setting.
        :param pulumi.Input[str] rule_id: Identifier for the managed rule.
        :param pulumi.Input[Union[str, 'ManagedRuleEnabledState']] state: The state of the managed rule. Defaults to Disabled if not specified.
        """
        pulumi.set(__self__, "rule_id", rule_id)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="ruleId")
    def rule_id(self) -> pulumi.Input[str]:
        """
        Identifier for the managed rule.
        """
        return pulumi.get(self, "rule_id")

    @rule_id.setter
    def rule_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "rule_id", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[Union[str, 'ManagedRuleEnabledState']]]:
        """
        The state of the managed rule. Defaults to Disabled if not specified.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[Union[str, 'ManagedRuleEnabledState']]]):
        pulumi.set(self, "state", value)


@pulumi.input_type
class ManagedRuleSetArgs:
    def __init__(__self__, *,
                 rule_set_type: pulumi.Input[str],
                 rule_set_version: pulumi.Input[str],
                 rule_group_overrides: Optional[pulumi.Input[Sequence[pulumi.Input['ManagedRuleGroupOverrideArgs']]]] = None):
        """
        Defines a managed rule set.
        :param pulumi.Input[str] rule_set_type: Defines the rule set type to use.
        :param pulumi.Input[str] rule_set_version: Defines the version of the rule set to use.
        :param pulumi.Input[Sequence[pulumi.Input['ManagedRuleGroupOverrideArgs']]] rule_group_overrides: Defines the rule group overrides to apply to the rule set.
        """
        pulumi.set(__self__, "rule_set_type", rule_set_type)
        pulumi.set(__self__, "rule_set_version", rule_set_version)
        if rule_group_overrides is not None:
            pulumi.set(__self__, "rule_group_overrides", rule_group_overrides)

    @property
    @pulumi.getter(name="ruleSetType")
    def rule_set_type(self) -> pulumi.Input[str]:
        """
        Defines the rule set type to use.
        """
        return pulumi.get(self, "rule_set_type")

    @rule_set_type.setter
    def rule_set_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "rule_set_type", value)

    @property
    @pulumi.getter(name="ruleSetVersion")
    def rule_set_version(self) -> pulumi.Input[str]:
        """
        Defines the version of the rule set to use.
        """
        return pulumi.get(self, "rule_set_version")

    @rule_set_version.setter
    def rule_set_version(self, value: pulumi.Input[str]):
        pulumi.set(self, "rule_set_version", value)

    @property
    @pulumi.getter(name="ruleGroupOverrides")
    def rule_group_overrides(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ManagedRuleGroupOverrideArgs']]]]:
        """
        Defines the rule group overrides to apply to the rule set.
        """
        return pulumi.get(self, "rule_group_overrides")

    @rule_group_overrides.setter
    def rule_group_overrides(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ManagedRuleGroupOverrideArgs']]]]):
        pulumi.set(self, "rule_group_overrides", value)


@pulumi.input_type
class ManagedRulesDefinitionArgs:
    def __init__(__self__, *,
                 managed_rule_sets: pulumi.Input[Sequence[pulumi.Input['ManagedRuleSetArgs']]],
                 exclusions: Optional[pulumi.Input[Sequence[pulumi.Input['OwaspCrsExclusionEntryArgs']]]] = None):
        """
        Allow to exclude some variable satisfy the condition for the WAF check.
        :param pulumi.Input[Sequence[pulumi.Input['ManagedRuleSetArgs']]] managed_rule_sets: The managed rule sets that are associated with the policy.
        :param pulumi.Input[Sequence[pulumi.Input['OwaspCrsExclusionEntryArgs']]] exclusions: The Exclusions that are applied on the policy.
        """
        pulumi.set(__self__, "managed_rule_sets", managed_rule_sets)
        if exclusions is not None:
            pulumi.set(__self__, "exclusions", exclusions)

    @property
    @pulumi.getter(name="managedRuleSets")
    def managed_rule_sets(self) -> pulumi.Input[Sequence[pulumi.Input['ManagedRuleSetArgs']]]:
        """
        The managed rule sets that are associated with the policy.
        """
        return pulumi.get(self, "managed_rule_sets")

    @managed_rule_sets.setter
    def managed_rule_sets(self, value: pulumi.Input[Sequence[pulumi.Input['ManagedRuleSetArgs']]]):
        pulumi.set(self, "managed_rule_sets", value)

    @property
    @pulumi.getter
    def exclusions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OwaspCrsExclusionEntryArgs']]]]:
        """
        The Exclusions that are applied on the policy.
        """
        return pulumi.get(self, "exclusions")

    @exclusions.setter
    def exclusions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OwaspCrsExclusionEntryArgs']]]]):
        pulumi.set(self, "exclusions", value)


@pulumi.input_type
class ManagedServiceIdentityArgs:
    def __init__(__self__, *,
                 type: Optional[pulumi.Input['ResourceIdentityType']] = None,
                 user_assigned_identities: Optional[pulumi.Input[Mapping[str, Any]]] = None):
        """
        Identity for the resource.
        :param pulumi.Input['ResourceIdentityType'] type: The type of identity used for the resource. The type 'SystemAssigned, UserAssigned' includes both an implicitly created identity and a set of user assigned identities. The type 'None' will remove any identities from the virtual machine.
        :param pulumi.Input[Mapping[str, Any]] user_assigned_identities: The list of user identities associated with resource. The user identity dictionary key references will be ARM resource ids in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
        """
        if type is not None:
            pulumi.set(__self__, "type", type)
        if user_assigned_identities is not None:
            pulumi.set(__self__, "user_assigned_identities", user_assigned_identities)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input['ResourceIdentityType']]:
        """
        The type of identity used for the resource. The type 'SystemAssigned, UserAssigned' includes both an implicitly created identity and a set of user assigned identities. The type 'None' will remove any identities from the virtual machine.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input['ResourceIdentityType']]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="userAssignedIdentities")
    def user_assigned_identities(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        The list of user identities associated with resource. The user identity dictionary key references will be ARM resource ids in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
        """
        return pulumi.get(self, "user_assigned_identities")

    @user_assigned_identities.setter
    def user_assigned_identities(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "user_assigned_identities", value)


@pulumi.input_type
class MatchConditionArgs:
    def __init__(__self__, *,
                 match_values: pulumi.Input[Sequence[pulumi.Input[str]]],
                 match_variables: pulumi.Input[Sequence[pulumi.Input['MatchVariableArgs']]],
                 operator: pulumi.Input[Union[str, 'WebApplicationFirewallOperator']],
                 negation_conditon: Optional[pulumi.Input[bool]] = None,
                 transforms: Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'WebApplicationFirewallTransform']]]]] = None):
        """
        Define match conditions.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] match_values: Match value.
        :param pulumi.Input[Sequence[pulumi.Input['MatchVariableArgs']]] match_variables: List of match variables.
        :param pulumi.Input[Union[str, 'WebApplicationFirewallOperator']] operator: The operator to be matched.
        :param pulumi.Input[bool] negation_conditon: Whether this is negate condition or not.
        :param pulumi.Input[Sequence[pulumi.Input[Union[str, 'WebApplicationFirewallTransform']]]] transforms: List of transforms.
        """
        pulumi.set(__self__, "match_values", match_values)
        pulumi.set(__self__, "match_variables", match_variables)
        pulumi.set(__self__, "operator", operator)
        if negation_conditon is not None:
            pulumi.set(__self__, "negation_conditon", negation_conditon)
        if transforms is not None:
            pulumi.set(__self__, "transforms", transforms)

    @property
    @pulumi.getter(name="matchValues")
    def match_values(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        Match value.
        """
        return pulumi.get(self, "match_values")

    @match_values.setter
    def match_values(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "match_values", value)

    @property
    @pulumi.getter(name="matchVariables")
    def match_variables(self) -> pulumi.Input[Sequence[pulumi.Input['MatchVariableArgs']]]:
        """
        List of match variables.
        """
        return pulumi.get(self, "match_variables")

    @match_variables.setter
    def match_variables(self, value: pulumi.Input[Sequence[pulumi.Input['MatchVariableArgs']]]):
        pulumi.set(self, "match_variables", value)

    @property
    @pulumi.getter
    def operator(self) -> pulumi.Input[Union[str, 'WebApplicationFirewallOperator']]:
        """
        The operator to be matched.
        """
        return pulumi.get(self, "operator")

    @operator.setter
    def operator(self, value: pulumi.Input[Union[str, 'WebApplicationFirewallOperator']]):
        pulumi.set(self, "operator", value)

    @property
    @pulumi.getter(name="negationConditon")
    def negation_conditon(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether this is negate condition or not.
        """
        return pulumi.get(self, "negation_conditon")

    @negation_conditon.setter
    def negation_conditon(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "negation_conditon", value)

    @property
    @pulumi.getter
    def transforms(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'WebApplicationFirewallTransform']]]]]:
        """
        List of transforms.
        """
        return pulumi.get(self, "transforms")

    @transforms.setter
    def transforms(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'WebApplicationFirewallTransform']]]]]):
        pulumi.set(self, "transforms", value)


@pulumi.input_type
class MatchVariableArgs:
    def __init__(__self__, *,
                 variable_name: pulumi.Input[Union[str, 'WebApplicationFirewallMatchVariable']],
                 selector: Optional[pulumi.Input[str]] = None):
        """
        Define match variables.
        :param pulumi.Input[Union[str, 'WebApplicationFirewallMatchVariable']] variable_name: Match Variable.
        :param pulumi.Input[str] selector: The selector of match variable.
        """
        pulumi.set(__self__, "variable_name", variable_name)
        if selector is not None:
            pulumi.set(__self__, "selector", selector)

    @property
    @pulumi.getter(name="variableName")
    def variable_name(self) -> pulumi.Input[Union[str, 'WebApplicationFirewallMatchVariable']]:
        """
        Match Variable.
        """
        return pulumi.get(self, "variable_name")

    @variable_name.setter
    def variable_name(self, value: pulumi.Input[Union[str, 'WebApplicationFirewallMatchVariable']]):
        pulumi.set(self, "variable_name", value)

    @property
    @pulumi.getter
    def selector(self) -> Optional[pulumi.Input[str]]:
        """
        The selector of match variable.
        """
        return pulumi.get(self, "selector")

    @selector.setter
    def selector(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "selector", value)


@pulumi.input_type
class NatGatewaySkuArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[Union[str, 'NatGatewaySkuName']]] = None):
        """
        SKU of nat gateway.
        :param pulumi.Input[Union[str, 'NatGatewaySkuName']] name: Name of Nat Gateway SKU.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[Union[str, 'NatGatewaySkuName']]]:
        """
        Name of Nat Gateway SKU.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[Union[str, 'NatGatewaySkuName']]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class NatRuleArgs:
    def __init__(__self__, *,
                 rule_type: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 destination_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 destination_ports: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 ip_protocols: Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'FirewallPolicyRuleNetworkProtocol']]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 source_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 source_ip_groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 translated_address: Optional[pulumi.Input[str]] = None,
                 translated_port: Optional[pulumi.Input[str]] = None):
        """
        Rule of type nat.
        :param pulumi.Input[str] rule_type: Rule Type.
               Expected value is 'NatRule'.
        :param pulumi.Input[str] description: Description of the rule.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] destination_addresses: List of destination IP addresses or Service Tags.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] destination_ports: List of destination ports.
        :param pulumi.Input[Sequence[pulumi.Input[Union[str, 'FirewallPolicyRuleNetworkProtocol']]]] ip_protocols: Array of FirewallPolicyRuleNetworkProtocols.
        :param pulumi.Input[str] name: Name of the rule.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] source_addresses: List of source IP addresses for this rule.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] source_ip_groups: List of source IpGroups for this rule.
        :param pulumi.Input[str] translated_address: The translated address for this NAT rule.
        :param pulumi.Input[str] translated_port: The translated port for this NAT rule.
        """
        pulumi.set(__self__, "rule_type", 'NatRule')
        if description is not None:
            pulumi.set(__self__, "description", description)
        if destination_addresses is not None:
            pulumi.set(__self__, "destination_addresses", destination_addresses)
        if destination_ports is not None:
            pulumi.set(__self__, "destination_ports", destination_ports)
        if ip_protocols is not None:
            pulumi.set(__self__, "ip_protocols", ip_protocols)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if source_addresses is not None:
            pulumi.set(__self__, "source_addresses", source_addresses)
        if source_ip_groups is not None:
            pulumi.set(__self__, "source_ip_groups", source_ip_groups)
        if translated_address is not None:
            pulumi.set(__self__, "translated_address", translated_address)
        if translated_port is not None:
            pulumi.set(__self__, "translated_port", translated_port)

    @property
    @pulumi.getter(name="ruleType")
    def rule_type(self) -> pulumi.Input[str]:
        """
        Rule Type.
        Expected value is 'NatRule'.
        """
        return pulumi.get(self, "rule_type")

    @rule_type.setter
    def rule_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "rule_type", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the rule.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="destinationAddresses")
    def destination_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of destination IP addresses or Service Tags.
        """
        return pulumi.get(self, "destination_addresses")

    @destination_addresses.setter
    def destination_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "destination_addresses", value)

    @property
    @pulumi.getter(name="destinationPorts")
    def destination_ports(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of destination ports.
        """
        return pulumi.get(self, "destination_ports")

    @destination_ports.setter
    def destination_ports(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "destination_ports", value)

    @property
    @pulumi.getter(name="ipProtocols")
    def ip_protocols(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'FirewallPolicyRuleNetworkProtocol']]]]]:
        """
        Array of FirewallPolicyRuleNetworkProtocols.
        """
        return pulumi.get(self, "ip_protocols")

    @ip_protocols.setter
    def ip_protocols(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'FirewallPolicyRuleNetworkProtocol']]]]]):
        pulumi.set(self, "ip_protocols", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the rule.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="sourceAddresses")
    def source_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of source IP addresses for this rule.
        """
        return pulumi.get(self, "source_addresses")

    @source_addresses.setter
    def source_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "source_addresses", value)

    @property
    @pulumi.getter(name="sourceIpGroups")
    def source_ip_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of source IpGroups for this rule.
        """
        return pulumi.get(self, "source_ip_groups")

    @source_ip_groups.setter
    def source_ip_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "source_ip_groups", value)

    @property
    @pulumi.getter(name="translatedAddress")
    def translated_address(self) -> Optional[pulumi.Input[str]]:
        """
        The translated address for this NAT rule.
        """
        return pulumi.get(self, "translated_address")

    @translated_address.setter
    def translated_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "translated_address", value)

    @property
    @pulumi.getter(name="translatedPort")
    def translated_port(self) -> Optional[pulumi.Input[str]]:
        """
        The translated port for this NAT rule.
        """
        return pulumi.get(self, "translated_port")

    @translated_port.setter
    def translated_port(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "translated_port", value)


@pulumi.input_type
class NetworkInterfaceDnsSettingsArgs:
    def __init__(__self__, *,
                 dns_servers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 internal_dns_name_label: Optional[pulumi.Input[str]] = None):
        """
        DNS settings of a network interface.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] dns_servers: List of DNS servers IP addresses. Use 'AzureProvidedDNS' to switch to azure provided DNS resolution. 'AzureProvidedDNS' value cannot be combined with other IPs, it must be the only value in dnsServers collection.
        :param pulumi.Input[str] internal_dns_name_label: Relative DNS name for this NIC used for internal communications between VMs in the same virtual network.
        """
        if dns_servers is not None:
            pulumi.set(__self__, "dns_servers", dns_servers)
        if internal_dns_name_label is not None:
            pulumi.set(__self__, "internal_dns_name_label", internal_dns_name_label)

    @property
    @pulumi.getter(name="dnsServers")
    def dns_servers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of DNS servers IP addresses. Use 'AzureProvidedDNS' to switch to azure provided DNS resolution. 'AzureProvidedDNS' value cannot be combined with other IPs, it must be the only value in dnsServers collection.
        """
        return pulumi.get(self, "dns_servers")

    @dns_servers.setter
    def dns_servers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "dns_servers", value)

    @property
    @pulumi.getter(name="internalDnsNameLabel")
    def internal_dns_name_label(self) -> Optional[pulumi.Input[str]]:
        """
        Relative DNS name for this NIC used for internal communications between VMs in the same virtual network.
        """
        return pulumi.get(self, "internal_dns_name_label")

    @internal_dns_name_label.setter
    def internal_dns_name_label(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "internal_dns_name_label", value)


@pulumi.input_type
class NetworkInterfaceIPConfigurationArgs:
    def __init__(__self__, *,
                 application_gateway_backend_address_pools: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayBackendAddressPoolArgs']]]] = None,
                 application_security_groups: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationSecurityGroupArgs']]]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 load_balancer_backend_address_pools: Optional[pulumi.Input[Sequence[pulumi.Input['BackendAddressPoolArgs']]]] = None,
                 load_balancer_inbound_nat_rules: Optional[pulumi.Input[Sequence[pulumi.Input['InboundNatRuleArgs']]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 primary: Optional[pulumi.Input[bool]] = None,
                 private_ip_address: Optional[pulumi.Input[str]] = None,
                 private_ip_address_version: Optional[pulumi.Input[Union[str, 'IPVersion']]] = None,
                 private_ip_allocation_method: Optional[pulumi.Input[Union[str, 'IPAllocationMethod']]] = None,
                 public_ip_address: Optional[pulumi.Input['PublicIPAddressArgs']] = None,
                 subnet: Optional[pulumi.Input['SubnetArgs']] = None,
                 virtual_network_taps: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualNetworkTapArgs']]]] = None):
        """
        IPConfiguration in a network interface.
        :param pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayBackendAddressPoolArgs']]] application_gateway_backend_address_pools: The reference to ApplicationGatewayBackendAddressPool resource.
        :param pulumi.Input[Sequence[pulumi.Input['ApplicationSecurityGroupArgs']]] application_security_groups: Application security groups in which the IP configuration is included.
        :param pulumi.Input[str] id: Resource ID.
        :param pulumi.Input[Sequence[pulumi.Input['BackendAddressPoolArgs']]] load_balancer_backend_address_pools: The reference to LoadBalancerBackendAddressPool resource.
        :param pulumi.Input[Sequence[pulumi.Input['InboundNatRuleArgs']]] load_balancer_inbound_nat_rules: A list of references of LoadBalancerInboundNatRules.
        :param pulumi.Input[str] name: The name of the resource that is unique within a resource group. This name can be used to access the resource.
        :param pulumi.Input[bool] primary: Whether this is a primary customer address on the network interface.
        :param pulumi.Input[str] private_ip_address: Private IP address of the IP configuration.
        :param pulumi.Input[Union[str, 'IPVersion']] private_ip_address_version: Whether the specific IP configuration is IPv4 or IPv6. Default is IPv4.
        :param pulumi.Input[Union[str, 'IPAllocationMethod']] private_ip_allocation_method: The private IP address allocation method.
        :param pulumi.Input['PublicIPAddressArgs'] public_ip_address: Public IP address bound to the IP configuration.
        :param pulumi.Input['SubnetArgs'] subnet: Subnet bound to the IP configuration.
        :param pulumi.Input[Sequence[pulumi.Input['VirtualNetworkTapArgs']]] virtual_network_taps: The reference to Virtual Network Taps.
        """
        if application_gateway_backend_address_pools is not None:
            pulumi.set(__self__, "application_gateway_backend_address_pools", application_gateway_backend_address_pools)
        if application_security_groups is not None:
            pulumi.set(__self__, "application_security_groups", application_security_groups)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if load_balancer_backend_address_pools is not None:
            pulumi.set(__self__, "load_balancer_backend_address_pools", load_balancer_backend_address_pools)
        if load_balancer_inbound_nat_rules is not None:
            pulumi.set(__self__, "load_balancer_inbound_nat_rules", load_balancer_inbound_nat_rules)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if primary is not None:
            pulumi.set(__self__, "primary", primary)
        if private_ip_address is not None:
            pulumi.set(__self__, "private_ip_address", private_ip_address)
        if private_ip_address_version is not None:
            pulumi.set(__self__, "private_ip_address_version", private_ip_address_version)
        if private_ip_allocation_method is not None:
            pulumi.set(__self__, "private_ip_allocation_method", private_ip_allocation_method)
        if public_ip_address is not None:
            pulumi.set(__self__, "public_ip_address", public_ip_address)
        if subnet is not None:
            pulumi.set(__self__, "subnet", subnet)
        if virtual_network_taps is not None:
            pulumi.set(__self__, "virtual_network_taps", virtual_network_taps)

    @property
    @pulumi.getter(name="applicationGatewayBackendAddressPools")
    def application_gateway_backend_address_pools(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayBackendAddressPoolArgs']]]]:
        """
        The reference to ApplicationGatewayBackendAddressPool resource.
        """
        return pulumi.get(self, "application_gateway_backend_address_pools")

    @application_gateway_backend_address_pools.setter
    def application_gateway_backend_address_pools(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayBackendAddressPoolArgs']]]]):
        pulumi.set(self, "application_gateway_backend_address_pools", value)

    @property
    @pulumi.getter(name="applicationSecurityGroups")
    def application_security_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationSecurityGroupArgs']]]]:
        """
        Application security groups in which the IP configuration is included.
        """
        return pulumi.get(self, "application_security_groups")

    @application_security_groups.setter
    def application_security_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationSecurityGroupArgs']]]]):
        pulumi.set(self, "application_security_groups", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="loadBalancerBackendAddressPools")
    def load_balancer_backend_address_pools(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BackendAddressPoolArgs']]]]:
        """
        The reference to LoadBalancerBackendAddressPool resource.
        """
        return pulumi.get(self, "load_balancer_backend_address_pools")

    @load_balancer_backend_address_pools.setter
    def load_balancer_backend_address_pools(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BackendAddressPoolArgs']]]]):
        pulumi.set(self, "load_balancer_backend_address_pools", value)

    @property
    @pulumi.getter(name="loadBalancerInboundNatRules")
    def load_balancer_inbound_nat_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InboundNatRuleArgs']]]]:
        """
        A list of references of LoadBalancerInboundNatRules.
        """
        return pulumi.get(self, "load_balancer_inbound_nat_rules")

    @load_balancer_inbound_nat_rules.setter
    def load_balancer_inbound_nat_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InboundNatRuleArgs']]]]):
        pulumi.set(self, "load_balancer_inbound_nat_rules", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the resource that is unique within a resource group. This name can be used to access the resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def primary(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether this is a primary customer address on the network interface.
        """
        return pulumi.get(self, "primary")

    @primary.setter
    def primary(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "primary", value)

    @property
    @pulumi.getter(name="privateIPAddress")
    def private_ip_address(self) -> Optional[pulumi.Input[str]]:
        """
        Private IP address of the IP configuration.
        """
        return pulumi.get(self, "private_ip_address")

    @private_ip_address.setter
    def private_ip_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_ip_address", value)

    @property
    @pulumi.getter(name="privateIPAddressVersion")
    def private_ip_address_version(self) -> Optional[pulumi.Input[Union[str, 'IPVersion']]]:
        """
        Whether the specific IP configuration is IPv4 or IPv6. Default is IPv4.
        """
        return pulumi.get(self, "private_ip_address_version")

    @private_ip_address_version.setter
    def private_ip_address_version(self, value: Optional[pulumi.Input[Union[str, 'IPVersion']]]):
        pulumi.set(self, "private_ip_address_version", value)

    @property
    @pulumi.getter(name="privateIPAllocationMethod")
    def private_ip_allocation_method(self) -> Optional[pulumi.Input[Union[str, 'IPAllocationMethod']]]:
        """
        The private IP address allocation method.
        """
        return pulumi.get(self, "private_ip_allocation_method")

    @private_ip_allocation_method.setter
    def private_ip_allocation_method(self, value: Optional[pulumi.Input[Union[str, 'IPAllocationMethod']]]):
        pulumi.set(self, "private_ip_allocation_method", value)

    @property
    @pulumi.getter(name="publicIPAddress")
    def public_ip_address(self) -> Optional[pulumi.Input['PublicIPAddressArgs']]:
        """
        Public IP address bound to the IP configuration.
        """
        return pulumi.get(self, "public_ip_address")

    @public_ip_address.setter
    def public_ip_address(self, value: Optional[pulumi.Input['PublicIPAddressArgs']]):
        pulumi.set(self, "public_ip_address", value)

    @property
    @pulumi.getter
    def subnet(self) -> Optional[pulumi.Input['SubnetArgs']]:
        """
        Subnet bound to the IP configuration.
        """
        return pulumi.get(self, "subnet")

    @subnet.setter
    def subnet(self, value: Optional[pulumi.Input['SubnetArgs']]):
        pulumi.set(self, "subnet", value)

    @property
    @pulumi.getter(name="virtualNetworkTaps")
    def virtual_network_taps(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VirtualNetworkTapArgs']]]]:
        """
        The reference to Virtual Network Taps.
        """
        return pulumi.get(self, "virtual_network_taps")

    @virtual_network_taps.setter
    def virtual_network_taps(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualNetworkTapArgs']]]]):
        pulumi.set(self, "virtual_network_taps", value)


@pulumi.input_type
class NetworkRuleArgs:
    def __init__(__self__, *,
                 rule_type: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 destination_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 destination_fqdns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 destination_ip_groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 destination_ports: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 ip_protocols: Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'FirewallPolicyRuleNetworkProtocol']]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 source_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 source_ip_groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Rule of type network.
        :param pulumi.Input[str] rule_type: Rule Type.
               Expected value is 'NetworkRule'.
        :param pulumi.Input[str] description: Description of the rule.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] destination_addresses: List of destination IP addresses or Service Tags.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] destination_fqdns: List of destination FQDNs.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] destination_ip_groups: List of destination IpGroups for this rule.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] destination_ports: List of destination ports.
        :param pulumi.Input[Sequence[pulumi.Input[Union[str, 'FirewallPolicyRuleNetworkProtocol']]]] ip_protocols: Array of FirewallPolicyRuleNetworkProtocols.
        :param pulumi.Input[str] name: Name of the rule.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] source_addresses: List of source IP addresses for this rule.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] source_ip_groups: List of source IpGroups for this rule.
        """
        pulumi.set(__self__, "rule_type", 'NetworkRule')
        if description is not None:
            pulumi.set(__self__, "description", description)
        if destination_addresses is not None:
            pulumi.set(__self__, "destination_addresses", destination_addresses)
        if destination_fqdns is not None:
            pulumi.set(__self__, "destination_fqdns", destination_fqdns)
        if destination_ip_groups is not None:
            pulumi.set(__self__, "destination_ip_groups", destination_ip_groups)
        if destination_ports is not None:
            pulumi.set(__self__, "destination_ports", destination_ports)
        if ip_protocols is not None:
            pulumi.set(__self__, "ip_protocols", ip_protocols)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if source_addresses is not None:
            pulumi.set(__self__, "source_addresses", source_addresses)
        if source_ip_groups is not None:
            pulumi.set(__self__, "source_ip_groups", source_ip_groups)

    @property
    @pulumi.getter(name="ruleType")
    def rule_type(self) -> pulumi.Input[str]:
        """
        Rule Type.
        Expected value is 'NetworkRule'.
        """
        return pulumi.get(self, "rule_type")

    @rule_type.setter
    def rule_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "rule_type", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the rule.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="destinationAddresses")
    def destination_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of destination IP addresses or Service Tags.
        """
        return pulumi.get(self, "destination_addresses")

    @destination_addresses.setter
    def destination_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "destination_addresses", value)

    @property
    @pulumi.getter(name="destinationFqdns")
    def destination_fqdns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of destination FQDNs.
        """
        return pulumi.get(self, "destination_fqdns")

    @destination_fqdns.setter
    def destination_fqdns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "destination_fqdns", value)

    @property
    @pulumi.getter(name="destinationIpGroups")
    def destination_ip_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of destination IpGroups for this rule.
        """
        return pulumi.get(self, "destination_ip_groups")

    @destination_ip_groups.setter
    def destination_ip_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "destination_ip_groups", value)

    @property
    @pulumi.getter(name="destinationPorts")
    def destination_ports(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of destination ports.
        """
        return pulumi.get(self, "destination_ports")

    @destination_ports.setter
    def destination_ports(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "destination_ports", value)

    @property
    @pulumi.getter(name="ipProtocols")
    def ip_protocols(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'FirewallPolicyRuleNetworkProtocol']]]]]:
        """
        Array of FirewallPolicyRuleNetworkProtocols.
        """
        return pulumi.get(self, "ip_protocols")

    @ip_protocols.setter
    def ip_protocols(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'FirewallPolicyRuleNetworkProtocol']]]]]):
        pulumi.set(self, "ip_protocols", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the rule.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="sourceAddresses")
    def source_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of source IP addresses for this rule.
        """
        return pulumi.get(self, "source_addresses")

    @source_addresses.setter
    def source_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "source_addresses", value)

    @property
    @pulumi.getter(name="sourceIpGroups")
    def source_ip_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of source IpGroups for this rule.
        """
        return pulumi.get(self, "source_ip_groups")

    @source_ip_groups.setter
    def source_ip_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "source_ip_groups", value)


@pulumi.input_type
class NetworkSecurityGroupArgs:
    def __init__(__self__, *,
                 id: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 security_rules: Optional[pulumi.Input[Sequence[pulumi.Input['SecurityRuleArgs']]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        NetworkSecurityGroup resource.
        :param pulumi.Input[str] id: Resource ID.
        :param pulumi.Input[str] location: Resource location.
        :param pulumi.Input[Sequence[pulumi.Input['SecurityRuleArgs']]] security_rules: A collection of security rules of the network security group.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Resource tags.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if security_rules is not None:
            pulumi.set(__self__, "security_rules", security_rules)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        Resource location.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="securityRules")
    def security_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SecurityRuleArgs']]]]:
        """
        A collection of security rules of the network security group.
        """
        return pulumi.get(self, "security_rules")

    @security_rules.setter
    def security_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SecurityRuleArgs']]]]):
        pulumi.set(self, "security_rules", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Resource tags.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class Office365PolicyPropertiesArgs:
    def __init__(__self__, *,
                 break_out_categories: Optional[pulumi.Input['BreakOutCategoryPoliciesArgs']] = None):
        """
        Network Virtual Appliance Sku Properties.
        :param pulumi.Input['BreakOutCategoryPoliciesArgs'] break_out_categories: Office 365 breakout categories.
        """
        if break_out_categories is not None:
            pulumi.set(__self__, "break_out_categories", break_out_categories)

    @property
    @pulumi.getter(name="breakOutCategories")
    def break_out_categories(self) -> Optional[pulumi.Input['BreakOutCategoryPoliciesArgs']]:
        """
        Office 365 breakout categories.
        """
        return pulumi.get(self, "break_out_categories")

    @break_out_categories.setter
    def break_out_categories(self, value: Optional[pulumi.Input['BreakOutCategoryPoliciesArgs']]):
        pulumi.set(self, "break_out_categories", value)


@pulumi.input_type
class OutboundRuleArgs:
    def __init__(__self__, *,
                 backend_address_pool: pulumi.Input['SubResourceArgs'],
                 frontend_ip_configurations: pulumi.Input[Sequence[pulumi.Input['SubResourceArgs']]],
                 protocol: pulumi.Input[Union[str, 'LoadBalancerOutboundRuleProtocol']],
                 allocated_outbound_ports: Optional[pulumi.Input[int]] = None,
                 enable_tcp_reset: Optional[pulumi.Input[bool]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 idle_timeout_in_minutes: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        Outbound rule of the load balancer.
        :param pulumi.Input['SubResourceArgs'] backend_address_pool: A reference to a pool of DIPs. Outbound traffic is randomly load balanced across IPs in the backend IPs.
        :param pulumi.Input[Sequence[pulumi.Input['SubResourceArgs']]] frontend_ip_configurations: The Frontend IP addresses of the load balancer.
        :param pulumi.Input[Union[str, 'LoadBalancerOutboundRuleProtocol']] protocol: The protocol for the outbound rule in load balancer.
        :param pulumi.Input[int] allocated_outbound_ports: The number of outbound ports to be used for NAT.
        :param pulumi.Input[bool] enable_tcp_reset: Receive bidirectional TCP Reset on TCP flow idle timeout or unexpected connection termination. This element is only used when the protocol is set to TCP.
        :param pulumi.Input[str] id: Resource ID.
        :param pulumi.Input[int] idle_timeout_in_minutes: The timeout for the TCP idle connection.
        :param pulumi.Input[str] name: The name of the resource that is unique within the set of outbound rules used by the load balancer. This name can be used to access the resource.
        """
        pulumi.set(__self__, "backend_address_pool", backend_address_pool)
        pulumi.set(__self__, "frontend_ip_configurations", frontend_ip_configurations)
        pulumi.set(__self__, "protocol", protocol)
        if allocated_outbound_ports is not None:
            pulumi.set(__self__, "allocated_outbound_ports", allocated_outbound_ports)
        if enable_tcp_reset is not None:
            pulumi.set(__self__, "enable_tcp_reset", enable_tcp_reset)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if idle_timeout_in_minutes is not None:
            pulumi.set(__self__, "idle_timeout_in_minutes", idle_timeout_in_minutes)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="backendAddressPool")
    def backend_address_pool(self) -> pulumi.Input['SubResourceArgs']:
        """
        A reference to a pool of DIPs. Outbound traffic is randomly load balanced across IPs in the backend IPs.
        """
        return pulumi.get(self, "backend_address_pool")

    @backend_address_pool.setter
    def backend_address_pool(self, value: pulumi.Input['SubResourceArgs']):
        pulumi.set(self, "backend_address_pool", value)

    @property
    @pulumi.getter(name="frontendIPConfigurations")
    def frontend_ip_configurations(self) -> pulumi.Input[Sequence[pulumi.Input['SubResourceArgs']]]:
        """
        The Frontend IP addresses of the load balancer.
        """
        return pulumi.get(self, "frontend_ip_configurations")

    @frontend_ip_configurations.setter
    def frontend_ip_configurations(self, value: pulumi.Input[Sequence[pulumi.Input['SubResourceArgs']]]):
        pulumi.set(self, "frontend_ip_configurations", value)

    @property
    @pulumi.getter
    def protocol(self) -> pulumi.Input[Union[str, 'LoadBalancerOutboundRuleProtocol']]:
        """
        The protocol for the outbound rule in load balancer.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: pulumi.Input[Union[str, 'LoadBalancerOutboundRuleProtocol']]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter(name="allocatedOutboundPorts")
    def allocated_outbound_ports(self) -> Optional[pulumi.Input[int]]:
        """
        The number of outbound ports to be used for NAT.
        """
        return pulumi.get(self, "allocated_outbound_ports")

    @allocated_outbound_ports.setter
    def allocated_outbound_ports(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "allocated_outbound_ports", value)

    @property
    @pulumi.getter(name="enableTcpReset")
    def enable_tcp_reset(self) -> Optional[pulumi.Input[bool]]:
        """
        Receive bidirectional TCP Reset on TCP flow idle timeout or unexpected connection termination. This element is only used when the protocol is set to TCP.
        """
        return pulumi.get(self, "enable_tcp_reset")

    @enable_tcp_reset.setter
    def enable_tcp_reset(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_tcp_reset", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="idleTimeoutInMinutes")
    def idle_timeout_in_minutes(self) -> Optional[pulumi.Input[int]]:
        """
        The timeout for the TCP idle connection.
        """
        return pulumi.get(self, "idle_timeout_in_minutes")

    @idle_timeout_in_minutes.setter
    def idle_timeout_in_minutes(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "idle_timeout_in_minutes", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the resource that is unique within the set of outbound rules used by the load balancer. This name can be used to access the resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class OwaspCrsExclusionEntryArgs:
    def __init__(__self__, *,
                 match_variable: pulumi.Input[Union[str, 'OwaspCrsExclusionEntryMatchVariable']],
                 selector: pulumi.Input[str],
                 selector_match_operator: pulumi.Input[Union[str, 'OwaspCrsExclusionEntrySelectorMatchOperator']]):
        """
        Allow to exclude some variable satisfy the condition for the WAF check.
        :param pulumi.Input[Union[str, 'OwaspCrsExclusionEntryMatchVariable']] match_variable: The variable to be excluded.
        :param pulumi.Input[str] selector: When matchVariable is a collection, operator used to specify which elements in the collection this exclusion applies to.
        :param pulumi.Input[Union[str, 'OwaspCrsExclusionEntrySelectorMatchOperator']] selector_match_operator: When matchVariable is a collection, operate on the selector to specify which elements in the collection this exclusion applies to.
        """
        pulumi.set(__self__, "match_variable", match_variable)
        pulumi.set(__self__, "selector", selector)
        pulumi.set(__self__, "selector_match_operator", selector_match_operator)

    @property
    @pulumi.getter(name="matchVariable")
    def match_variable(self) -> pulumi.Input[Union[str, 'OwaspCrsExclusionEntryMatchVariable']]:
        """
        The variable to be excluded.
        """
        return pulumi.get(self, "match_variable")

    @match_variable.setter
    def match_variable(self, value: pulumi.Input[Union[str, 'OwaspCrsExclusionEntryMatchVariable']]):
        pulumi.set(self, "match_variable", value)

    @property
    @pulumi.getter
    def selector(self) -> pulumi.Input[str]:
        """
        When matchVariable is a collection, operator used to specify which elements in the collection this exclusion applies to.
        """
        return pulumi.get(self, "selector")

    @selector.setter
    def selector(self, value: pulumi.Input[str]):
        pulumi.set(self, "selector", value)

    @property
    @pulumi.getter(name="selectorMatchOperator")
    def selector_match_operator(self) -> pulumi.Input[Union[str, 'OwaspCrsExclusionEntrySelectorMatchOperator']]:
        """
        When matchVariable is a collection, operate on the selector to specify which elements in the collection this exclusion applies to.
        """
        return pulumi.get(self, "selector_match_operator")

    @selector_match_operator.setter
    def selector_match_operator(self, value: pulumi.Input[Union[str, 'OwaspCrsExclusionEntrySelectorMatchOperator']]):
        pulumi.set(self, "selector_match_operator", value)


@pulumi.input_type
class P2SConnectionConfigurationArgs:
    def __init__(__self__, *,
                 id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 routing_configuration: Optional[pulumi.Input['RoutingConfigurationArgs']] = None,
                 vpn_client_address_pool: Optional[pulumi.Input['AddressSpaceArgs']] = None):
        """
        P2SConnectionConfiguration Resource.
        :param pulumi.Input[str] id: Resource ID.
        :param pulumi.Input[str] name: The name of the resource that is unique within a resource group. This name can be used to access the resource.
        :param pulumi.Input['RoutingConfigurationArgs'] routing_configuration: The Routing Configuration indicating the associated and propagated route tables on this connection.
        :param pulumi.Input['AddressSpaceArgs'] vpn_client_address_pool: The reference to the address space resource which represents Address space for P2S VpnClient.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if routing_configuration is not None:
            pulumi.set(__self__, "routing_configuration", routing_configuration)
        if vpn_client_address_pool is not None:
            pulumi.set(__self__, "vpn_client_address_pool", vpn_client_address_pool)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the resource that is unique within a resource group. This name can be used to access the resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="routingConfiguration")
    def routing_configuration(self) -> Optional[pulumi.Input['RoutingConfigurationArgs']]:
        """
        The Routing Configuration indicating the associated and propagated route tables on this connection.
        """
        return pulumi.get(self, "routing_configuration")

    @routing_configuration.setter
    def routing_configuration(self, value: Optional[pulumi.Input['RoutingConfigurationArgs']]):
        pulumi.set(self, "routing_configuration", value)

    @property
    @pulumi.getter(name="vpnClientAddressPool")
    def vpn_client_address_pool(self) -> Optional[pulumi.Input['AddressSpaceArgs']]:
        """
        The reference to the address space resource which represents Address space for P2S VpnClient.
        """
        return pulumi.get(self, "vpn_client_address_pool")

    @vpn_client_address_pool.setter
    def vpn_client_address_pool(self, value: Optional[pulumi.Input['AddressSpaceArgs']]):
        pulumi.set(self, "vpn_client_address_pool", value)


@pulumi.input_type
class PacketCaptureFilterArgs:
    def __init__(__self__, *,
                 local_ip_address: Optional[pulumi.Input[str]] = None,
                 local_port: Optional[pulumi.Input[str]] = None,
                 protocol: Optional[pulumi.Input[Union[str, 'PcProtocol']]] = None,
                 remote_ip_address: Optional[pulumi.Input[str]] = None,
                 remote_port: Optional[pulumi.Input[str]] = None):
        """
        Filter that is applied to packet capture request. Multiple filters can be applied.
        :param pulumi.Input[str] local_ip_address: Local IP Address to be filtered on. Notation: "127.0.0.1" for single address entry. "127.0.0.1-127.0.0.255" for range. "127.0.0.1;127.0.0.5"? for multiple entries. Multiple ranges not currently supported. Mixing ranges with multiple entries not currently supported. Default = null.
        :param pulumi.Input[str] local_port: Local port to be filtered on. Notation: "80" for single port entry."80-85" for range. "80;443;" for multiple entries. Multiple ranges not currently supported. Mixing ranges with multiple entries not currently supported. Default = null.
        :param pulumi.Input[Union[str, 'PcProtocol']] protocol: Protocol to be filtered on.
        :param pulumi.Input[str] remote_ip_address: Local IP Address to be filtered on. Notation: "127.0.0.1" for single address entry. "127.0.0.1-127.0.0.255" for range. "127.0.0.1;127.0.0.5;" for multiple entries. Multiple ranges not currently supported. Mixing ranges with multiple entries not currently supported. Default = null.
        :param pulumi.Input[str] remote_port: Remote port to be filtered on. Notation: "80" for single port entry."80-85" for range. "80;443;" for multiple entries. Multiple ranges not currently supported. Mixing ranges with multiple entries not currently supported. Default = null.
        """
        if local_ip_address is not None:
            pulumi.set(__self__, "local_ip_address", local_ip_address)
        if local_port is not None:
            pulumi.set(__self__, "local_port", local_port)
        if protocol is None:
            protocol = 'Any'
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if remote_ip_address is not None:
            pulumi.set(__self__, "remote_ip_address", remote_ip_address)
        if remote_port is not None:
            pulumi.set(__self__, "remote_port", remote_port)

    @property
    @pulumi.getter(name="localIPAddress")
    def local_ip_address(self) -> Optional[pulumi.Input[str]]:
        """
        Local IP Address to be filtered on. Notation: "127.0.0.1" for single address entry. "127.0.0.1-127.0.0.255" for range. "127.0.0.1;127.0.0.5"? for multiple entries. Multiple ranges not currently supported. Mixing ranges with multiple entries not currently supported. Default = null.
        """
        return pulumi.get(self, "local_ip_address")

    @local_ip_address.setter
    def local_ip_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "local_ip_address", value)

    @property
    @pulumi.getter(name="localPort")
    def local_port(self) -> Optional[pulumi.Input[str]]:
        """
        Local port to be filtered on. Notation: "80" for single port entry."80-85" for range. "80;443;" for multiple entries. Multiple ranges not currently supported. Mixing ranges with multiple entries not currently supported. Default = null.
        """
        return pulumi.get(self, "local_port")

    @local_port.setter
    def local_port(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "local_port", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[Union[str, 'PcProtocol']]]:
        """
        Protocol to be filtered on.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[Union[str, 'PcProtocol']]]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter(name="remoteIPAddress")
    def remote_ip_address(self) -> Optional[pulumi.Input[str]]:
        """
        Local IP Address to be filtered on. Notation: "127.0.0.1" for single address entry. "127.0.0.1-127.0.0.255" for range. "127.0.0.1;127.0.0.5;" for multiple entries. Multiple ranges not currently supported. Mixing ranges with multiple entries not currently supported. Default = null.
        """
        return pulumi.get(self, "remote_ip_address")

    @remote_ip_address.setter
    def remote_ip_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "remote_ip_address", value)

    @property
    @pulumi.getter(name="remotePort")
    def remote_port(self) -> Optional[pulumi.Input[str]]:
        """
        Remote port to be filtered on. Notation: "80" for single port entry."80-85" for range. "80;443;" for multiple entries. Multiple ranges not currently supported. Mixing ranges with multiple entries not currently supported. Default = null.
        """
        return pulumi.get(self, "remote_port")

    @remote_port.setter
    def remote_port(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "remote_port", value)


@pulumi.input_type
class PacketCaptureStorageLocationArgs:
    def __init__(__self__, *,
                 file_path: Optional[pulumi.Input[str]] = None,
                 storage_id: Optional[pulumi.Input[str]] = None,
                 storage_path: Optional[pulumi.Input[str]] = None):
        """
        The storage location for a packet capture session.
        :param pulumi.Input[str] file_path: A valid local path on the targeting VM. Must include the name of the capture file (*.cap). For linux virtual machine it must start with /var/captures. Required if no storage ID is provided, otherwise optional.
        :param pulumi.Input[str] storage_id: The ID of the storage account to save the packet capture session. Required if no local file path is provided.
        :param pulumi.Input[str] storage_path: The URI of the storage path to save the packet capture. Must be a well-formed URI describing the location to save the packet capture.
        """
        if file_path is not None:
            pulumi.set(__self__, "file_path", file_path)
        if storage_id is not None:
            pulumi.set(__self__, "storage_id", storage_id)
        if storage_path is not None:
            pulumi.set(__self__, "storage_path", storage_path)

    @property
    @pulumi.getter(name="filePath")
    def file_path(self) -> Optional[pulumi.Input[str]]:
        """
        A valid local path on the targeting VM. Must include the name of the capture file (*.cap). For linux virtual machine it must start with /var/captures. Required if no storage ID is provided, otherwise optional.
        """
        return pulumi.get(self, "file_path")

    @file_path.setter
    def file_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "file_path", value)

    @property
    @pulumi.getter(name="storageId")
    def storage_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the storage account to save the packet capture session. Required if no local file path is provided.
        """
        return pulumi.get(self, "storage_id")

    @storage_id.setter
    def storage_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "storage_id", value)

    @property
    @pulumi.getter(name="storagePath")
    def storage_path(self) -> Optional[pulumi.Input[str]]:
        """
        The URI of the storage path to save the packet capture. Must be a well-formed URI describing the location to save the packet capture.
        """
        return pulumi.get(self, "storage_path")

    @storage_path.setter
    def storage_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "storage_path", value)


@pulumi.input_type
class PolicySettingsArgs:
    def __init__(__self__, *,
                 file_upload_limit_in_mb: Optional[pulumi.Input[int]] = None,
                 max_request_body_size_in_kb: Optional[pulumi.Input[int]] = None,
                 mode: Optional[pulumi.Input[Union[str, 'WebApplicationFirewallMode']]] = None,
                 request_body_check: Optional[pulumi.Input[bool]] = None,
                 state: Optional[pulumi.Input[Union[str, 'WebApplicationFirewallEnabledState']]] = None):
        """
        Defines contents of a web application firewall global configuration.
        :param pulumi.Input[int] file_upload_limit_in_mb: Maximum file upload size in Mb for WAF.
        :param pulumi.Input[int] max_request_body_size_in_kb: Maximum request body size in Kb for WAF.
        :param pulumi.Input[Union[str, 'WebApplicationFirewallMode']] mode: The mode of the policy.
        :param pulumi.Input[bool] request_body_check: Whether to allow WAF to check request Body.
        :param pulumi.Input[Union[str, 'WebApplicationFirewallEnabledState']] state: The state of the policy.
        """
        if file_upload_limit_in_mb is not None:
            pulumi.set(__self__, "file_upload_limit_in_mb", file_upload_limit_in_mb)
        if max_request_body_size_in_kb is not None:
            pulumi.set(__self__, "max_request_body_size_in_kb", max_request_body_size_in_kb)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if request_body_check is not None:
            pulumi.set(__self__, "request_body_check", request_body_check)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="fileUploadLimitInMb")
    def file_upload_limit_in_mb(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum file upload size in Mb for WAF.
        """
        return pulumi.get(self, "file_upload_limit_in_mb")

    @file_upload_limit_in_mb.setter
    def file_upload_limit_in_mb(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "file_upload_limit_in_mb", value)

    @property
    @pulumi.getter(name="maxRequestBodySizeInKb")
    def max_request_body_size_in_kb(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum request body size in Kb for WAF.
        """
        return pulumi.get(self, "max_request_body_size_in_kb")

    @max_request_body_size_in_kb.setter
    def max_request_body_size_in_kb(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_request_body_size_in_kb", value)

    @property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input[Union[str, 'WebApplicationFirewallMode']]]:
        """
        The mode of the policy.
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input[Union[str, 'WebApplicationFirewallMode']]]):
        pulumi.set(self, "mode", value)

    @property
    @pulumi.getter(name="requestBodyCheck")
    def request_body_check(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to allow WAF to check request Body.
        """
        return pulumi.get(self, "request_body_check")

    @request_body_check.setter
    def request_body_check(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "request_body_check", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[Union[str, 'WebApplicationFirewallEnabledState']]]:
        """
        The state of the policy.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[Union[str, 'WebApplicationFirewallEnabledState']]]):
        pulumi.set(self, "state", value)


@pulumi.input_type
class PrivateDnsZoneConfigArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 private_dns_zone_id: Optional[pulumi.Input[str]] = None):
        """
        PrivateDnsZoneConfig resource.
        :param pulumi.Input[str] name: Name of the resource that is unique within a resource group. This name can be used to access the resource.
        :param pulumi.Input[str] private_dns_zone_id: The resource id of the private dns zone.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if private_dns_zone_id is not None:
            pulumi.set(__self__, "private_dns_zone_id", private_dns_zone_id)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the resource that is unique within a resource group. This name can be used to access the resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="privateDnsZoneId")
    def private_dns_zone_id(self) -> Optional[pulumi.Input[str]]:
        """
        The resource id of the private dns zone.
        """
        return pulumi.get(self, "private_dns_zone_id")

    @private_dns_zone_id.setter
    def private_dns_zone_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_dns_zone_id", value)


@pulumi.input_type
class PrivateLinkServiceConnectionStateArgs:
    def __init__(__self__, *,
                 actions_required: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None):
        """
        A collection of information about the state of the connection between service consumer and provider.
        :param pulumi.Input[str] actions_required: A message indicating if changes on the service provider require any updates on the consumer.
        :param pulumi.Input[str] description: The reason for approval/rejection of the connection.
        :param pulumi.Input[str] status: Indicates whether the connection has been Approved/Rejected/Removed by the owner of the service.
        """
        if actions_required is not None:
            pulumi.set(__self__, "actions_required", actions_required)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="actionsRequired")
    def actions_required(self) -> Optional[pulumi.Input[str]]:
        """
        A message indicating if changes on the service provider require any updates on the consumer.
        """
        return pulumi.get(self, "actions_required")

    @actions_required.setter
    def actions_required(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "actions_required", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The reason for approval/rejection of the connection.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates whether the connection has been Approved/Rejected/Removed by the owner of the service.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class PrivateLinkServiceConnectionArgs:
    def __init__(__self__, *,
                 group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 private_link_service_connection_state: Optional[pulumi.Input['PrivateLinkServiceConnectionStateArgs']] = None,
                 private_link_service_id: Optional[pulumi.Input[str]] = None,
                 request_message: Optional[pulumi.Input[str]] = None):
        """
        PrivateLinkServiceConnection resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] group_ids: The ID(s) of the group(s) obtained from the remote resource that this private endpoint should connect to.
        :param pulumi.Input[str] id: Resource ID.
        :param pulumi.Input[str] name: The name of the resource that is unique within a resource group. This name can be used to access the resource.
        :param pulumi.Input['PrivateLinkServiceConnectionStateArgs'] private_link_service_connection_state: A collection of read-only information about the state of the connection to the remote resource.
        :param pulumi.Input[str] private_link_service_id: The resource id of private link service.
        :param pulumi.Input[str] request_message: A message passed to the owner of the remote resource with this connection request. Restricted to 140 chars.
        """
        if group_ids is not None:
            pulumi.set(__self__, "group_ids", group_ids)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if private_link_service_connection_state is not None:
            pulumi.set(__self__, "private_link_service_connection_state", private_link_service_connection_state)
        if private_link_service_id is not None:
            pulumi.set(__self__, "private_link_service_id", private_link_service_id)
        if request_message is not None:
            pulumi.set(__self__, "request_message", request_message)

    @property
    @pulumi.getter(name="groupIds")
    def group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The ID(s) of the group(s) obtained from the remote resource that this private endpoint should connect to.
        """
        return pulumi.get(self, "group_ids")

    @group_ids.setter
    def group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "group_ids", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the resource that is unique within a resource group. This name can be used to access the resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="privateLinkServiceConnectionState")
    def private_link_service_connection_state(self) -> Optional[pulumi.Input['PrivateLinkServiceConnectionStateArgs']]:
        """
        A collection of read-only information about the state of the connection to the remote resource.
        """
        return pulumi.get(self, "private_link_service_connection_state")

    @private_link_service_connection_state.setter
    def private_link_service_connection_state(self, value: Optional[pulumi.Input['PrivateLinkServiceConnectionStateArgs']]):
        pulumi.set(self, "private_link_service_connection_state", value)

    @property
    @pulumi.getter(name="privateLinkServiceId")
    def private_link_service_id(self) -> Optional[pulumi.Input[str]]:
        """
        The resource id of private link service.
        """
        return pulumi.get(self, "private_link_service_id")

    @private_link_service_id.setter
    def private_link_service_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_link_service_id", value)

    @property
    @pulumi.getter(name="requestMessage")
    def request_message(self) -> Optional[pulumi.Input[str]]:
        """
        A message passed to the owner of the remote resource with this connection request. Restricted to 140 chars.
        """
        return pulumi.get(self, "request_message")

    @request_message.setter
    def request_message(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "request_message", value)


@pulumi.input_type
class PrivateLinkServiceIpConfigurationArgs:
    def __init__(__self__, *,
                 id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 primary: Optional[pulumi.Input[bool]] = None,
                 private_ip_address: Optional[pulumi.Input[str]] = None,
                 private_ip_address_version: Optional[pulumi.Input[Union[str, 'IPVersion']]] = None,
                 private_ip_allocation_method: Optional[pulumi.Input[Union[str, 'IPAllocationMethod']]] = None,
                 subnet: Optional[pulumi.Input['SubnetArgs']] = None):
        """
        The private link service ip configuration.
        :param pulumi.Input[str] id: Resource ID.
        :param pulumi.Input[str] name: The name of private link service ip configuration.
        :param pulumi.Input[bool] primary: Whether the ip configuration is primary or not.
        :param pulumi.Input[str] private_ip_address: The private IP address of the IP configuration.
        :param pulumi.Input[Union[str, 'IPVersion']] private_ip_address_version: Whether the specific IP configuration is IPv4 or IPv6. Default is IPv4.
        :param pulumi.Input[Union[str, 'IPAllocationMethod']] private_ip_allocation_method: The private IP address allocation method.
        :param pulumi.Input['SubnetArgs'] subnet: The reference to the subnet resource.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if primary is not None:
            pulumi.set(__self__, "primary", primary)
        if private_ip_address is not None:
            pulumi.set(__self__, "private_ip_address", private_ip_address)
        if private_ip_address_version is not None:
            pulumi.set(__self__, "private_ip_address_version", private_ip_address_version)
        if private_ip_allocation_method is not None:
            pulumi.set(__self__, "private_ip_allocation_method", private_ip_allocation_method)
        if subnet is not None:
            pulumi.set(__self__, "subnet", subnet)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of private link service ip configuration.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def primary(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the ip configuration is primary or not.
        """
        return pulumi.get(self, "primary")

    @primary.setter
    def primary(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "primary", value)

    @property
    @pulumi.getter(name="privateIPAddress")
    def private_ip_address(self) -> Optional[pulumi.Input[str]]:
        """
        The private IP address of the IP configuration.
        """
        return pulumi.get(self, "private_ip_address")

    @private_ip_address.setter
    def private_ip_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_ip_address", value)

    @property
    @pulumi.getter(name="privateIPAddressVersion")
    def private_ip_address_version(self) -> Optional[pulumi.Input[Union[str, 'IPVersion']]]:
        """
        Whether the specific IP configuration is IPv4 or IPv6. Default is IPv4.
        """
        return pulumi.get(self, "private_ip_address_version")

    @private_ip_address_version.setter
    def private_ip_address_version(self, value: Optional[pulumi.Input[Union[str, 'IPVersion']]]):
        pulumi.set(self, "private_ip_address_version", value)

    @property
    @pulumi.getter(name="privateIPAllocationMethod")
    def private_ip_allocation_method(self) -> Optional[pulumi.Input[Union[str, 'IPAllocationMethod']]]:
        """
        The private IP address allocation method.
        """
        return pulumi.get(self, "private_ip_allocation_method")

    @private_ip_allocation_method.setter
    def private_ip_allocation_method(self, value: Optional[pulumi.Input[Union[str, 'IPAllocationMethod']]]):
        pulumi.set(self, "private_ip_allocation_method", value)

    @property
    @pulumi.getter
    def subnet(self) -> Optional[pulumi.Input['SubnetArgs']]:
        """
        The reference to the subnet resource.
        """
        return pulumi.get(self, "subnet")

    @subnet.setter
    def subnet(self, value: Optional[pulumi.Input['SubnetArgs']]):
        pulumi.set(self, "subnet", value)


@pulumi.input_type
class PrivateLinkServicePropertiesAutoApprovalArgs:
    def __init__(__self__, *,
                 subscriptions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The auto-approval list of the private link service.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] subscriptions: The list of subscriptions.
        """
        if subscriptions is not None:
            pulumi.set(__self__, "subscriptions", subscriptions)

    @property
    @pulumi.getter
    def subscriptions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of subscriptions.
        """
        return pulumi.get(self, "subscriptions")

    @subscriptions.setter
    def subscriptions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "subscriptions", value)


@pulumi.input_type
class PrivateLinkServicePropertiesVisibilityArgs:
    def __init__(__self__, *,
                 subscriptions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The visibility list of the private link service.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] subscriptions: The list of subscriptions.
        """
        if subscriptions is not None:
            pulumi.set(__self__, "subscriptions", subscriptions)

    @property
    @pulumi.getter
    def subscriptions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of subscriptions.
        """
        return pulumi.get(self, "subscriptions")

    @subscriptions.setter
    def subscriptions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "subscriptions", value)


@pulumi.input_type
class ProbeArgs:
    def __init__(__self__, *,
                 port: pulumi.Input[int],
                 protocol: pulumi.Input[Union[str, 'ProbeProtocol']],
                 id: Optional[pulumi.Input[str]] = None,
                 interval_in_seconds: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 number_of_probes: Optional[pulumi.Input[int]] = None,
                 request_path: Optional[pulumi.Input[str]] = None):
        """
        A load balancer probe.
        :param pulumi.Input[int] port: The port for communicating the probe. Possible values range from 1 to 65535, inclusive.
        :param pulumi.Input[Union[str, 'ProbeProtocol']] protocol: The protocol of the end point. If 'Tcp' is specified, a received ACK is required for the probe to be successful. If 'Http' or 'Https' is specified, a 200 OK response from the specifies URI is required for the probe to be successful.
        :param pulumi.Input[str] id: Resource ID.
        :param pulumi.Input[int] interval_in_seconds: The interval, in seconds, for how frequently to probe the endpoint for health status. Typically, the interval is slightly less than half the allocated timeout period (in seconds) which allows two full probes before taking the instance out of rotation. The default value is 15, the minimum value is 5.
        :param pulumi.Input[str] name: The name of the resource that is unique within the set of probes used by the load balancer. This name can be used to access the resource.
        :param pulumi.Input[int] number_of_probes: The number of probes where if no response, will result in stopping further traffic from being delivered to the endpoint. This values allows endpoints to be taken out of rotation faster or slower than the typical times used in Azure.
        :param pulumi.Input[str] request_path: The URI used for requesting health status from the VM. Path is required if a protocol is set to http. Otherwise, it is not allowed. There is no default value.
        """
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "protocol", protocol)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if interval_in_seconds is not None:
            pulumi.set(__self__, "interval_in_seconds", interval_in_seconds)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if number_of_probes is not None:
            pulumi.set(__self__, "number_of_probes", number_of_probes)
        if request_path is not None:
            pulumi.set(__self__, "request_path", request_path)

    @property
    @pulumi.getter
    def port(self) -> pulumi.Input[int]:
        """
        The port for communicating the probe. Possible values range from 1 to 65535, inclusive.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: pulumi.Input[int]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def protocol(self) -> pulumi.Input[Union[str, 'ProbeProtocol']]:
        """
        The protocol of the end point. If 'Tcp' is specified, a received ACK is required for the probe to be successful. If 'Http' or 'Https' is specified, a 200 OK response from the specifies URI is required for the probe to be successful.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: pulumi.Input[Union[str, 'ProbeProtocol']]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="intervalInSeconds")
    def interval_in_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        The interval, in seconds, for how frequently to probe the endpoint for health status. Typically, the interval is slightly less than half the allocated timeout period (in seconds) which allows two full probes before taking the instance out of rotation. The default value is 15, the minimum value is 5.
        """
        return pulumi.get(self, "interval_in_seconds")

    @interval_in_seconds.setter
    def interval_in_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "interval_in_seconds", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the resource that is unique within the set of probes used by the load balancer. This name can be used to access the resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="numberOfProbes")
    def number_of_probes(self) -> Optional[pulumi.Input[int]]:
        """
        The number of probes where if no response, will result in stopping further traffic from being delivered to the endpoint. This values allows endpoints to be taken out of rotation faster or slower than the typical times used in Azure.
        """
        return pulumi.get(self, "number_of_probes")

    @number_of_probes.setter
    def number_of_probes(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "number_of_probes", value)

    @property
    @pulumi.getter(name="requestPath")
    def request_path(self) -> Optional[pulumi.Input[str]]:
        """
        The URI used for requesting health status from the VM. Path is required if a protocol is set to http. Otherwise, it is not allowed. There is no default value.
        """
        return pulumi.get(self, "request_path")

    @request_path.setter
    def request_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "request_path", value)


@pulumi.input_type
class PropagatedRouteTableArgs:
    def __init__(__self__, *,
                 ids: Optional[pulumi.Input[Sequence[pulumi.Input['SubResourceArgs']]]] = None,
                 labels: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The list of RouteTables to advertise the routes to.
        :param pulumi.Input[Sequence[pulumi.Input['SubResourceArgs']]] ids: The list of resource ids of all the RouteTables.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] labels: The list of labels.
        """
        if ids is not None:
            pulumi.set(__self__, "ids", ids)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)

    @property
    @pulumi.getter
    def ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SubResourceArgs']]]]:
        """
        The list of resource ids of all the RouteTables.
        """
        return pulumi.get(self, "ids")

    @ids.setter
    def ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SubResourceArgs']]]]):
        pulumi.set(self, "ids", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of labels.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)


@pulumi.input_type
class ProtocolCustomSettingsFormatArgs:
    def __init__(__self__, *,
                 protocol: Optional[pulumi.Input[Union[str, 'DdosCustomPolicyProtocol']]] = None,
                 source_rate_override: Optional[pulumi.Input[str]] = None,
                 trigger_rate_override: Optional[pulumi.Input[str]] = None,
                 trigger_sensitivity_override: Optional[pulumi.Input[Union[str, 'DdosCustomPolicyTriggerSensitivityOverride']]] = None):
        """
        DDoS custom policy properties.
        :param pulumi.Input[Union[str, 'DdosCustomPolicyProtocol']] protocol: The protocol for which the DDoS protection policy is being customized.
        :param pulumi.Input[str] source_rate_override: The customized DDoS protection source rate.
        :param pulumi.Input[str] trigger_rate_override: The customized DDoS protection trigger rate.
        :param pulumi.Input[Union[str, 'DdosCustomPolicyTriggerSensitivityOverride']] trigger_sensitivity_override: The customized DDoS protection trigger rate sensitivity degrees. High: Trigger rate set with most sensitivity w.r.t. normal traffic. Default: Trigger rate set with moderate sensitivity w.r.t. normal traffic. Low: Trigger rate set with less sensitivity w.r.t. normal traffic. Relaxed: Trigger rate set with least sensitivity w.r.t. normal traffic.
        """
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if source_rate_override is not None:
            pulumi.set(__self__, "source_rate_override", source_rate_override)
        if trigger_rate_override is not None:
            pulumi.set(__self__, "trigger_rate_override", trigger_rate_override)
        if trigger_sensitivity_override is not None:
            pulumi.set(__self__, "trigger_sensitivity_override", trigger_sensitivity_override)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[Union[str, 'DdosCustomPolicyProtocol']]]:
        """
        The protocol for which the DDoS protection policy is being customized.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[Union[str, 'DdosCustomPolicyProtocol']]]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter(name="sourceRateOverride")
    def source_rate_override(self) -> Optional[pulumi.Input[str]]:
        """
        The customized DDoS protection source rate.
        """
        return pulumi.get(self, "source_rate_override")

    @source_rate_override.setter
    def source_rate_override(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_rate_override", value)

    @property
    @pulumi.getter(name="triggerRateOverride")
    def trigger_rate_override(self) -> Optional[pulumi.Input[str]]:
        """
        The customized DDoS protection trigger rate.
        """
        return pulumi.get(self, "trigger_rate_override")

    @trigger_rate_override.setter
    def trigger_rate_override(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "trigger_rate_override", value)

    @property
    @pulumi.getter(name="triggerSensitivityOverride")
    def trigger_sensitivity_override(self) -> Optional[pulumi.Input[Union[str, 'DdosCustomPolicyTriggerSensitivityOverride']]]:
        """
        The customized DDoS protection trigger rate sensitivity degrees. High: Trigger rate set with most sensitivity w.r.t. normal traffic. Default: Trigger rate set with moderate sensitivity w.r.t. normal traffic. Low: Trigger rate set with less sensitivity w.r.t. normal traffic. Relaxed: Trigger rate set with least sensitivity w.r.t. normal traffic.
        """
        return pulumi.get(self, "trigger_sensitivity_override")

    @trigger_sensitivity_override.setter
    def trigger_sensitivity_override(self, value: Optional[pulumi.Input[Union[str, 'DdosCustomPolicyTriggerSensitivityOverride']]]):
        pulumi.set(self, "trigger_sensitivity_override", value)


@pulumi.input_type
class PublicIPAddressDnsSettingsArgs:
    def __init__(__self__, *,
                 domain_name_label: Optional[pulumi.Input[str]] = None,
                 fqdn: Optional[pulumi.Input[str]] = None,
                 reverse_fqdn: Optional[pulumi.Input[str]] = None):
        """
        Contains FQDN of the DNS record associated with the public IP address.
        :param pulumi.Input[str] domain_name_label: The domain name label. The concatenation of the domain name label and the regionalized DNS zone make up the fully qualified domain name associated with the public IP address. If a domain name label is specified, an A DNS record is created for the public IP in the Microsoft Azure DNS system.
        :param pulumi.Input[str] fqdn: The Fully Qualified Domain Name of the A DNS record associated with the public IP. This is the concatenation of the domainNameLabel and the regionalized DNS zone.
        :param pulumi.Input[str] reverse_fqdn: The reverse FQDN. A user-visible, fully qualified domain name that resolves to this public IP address. If the reverseFqdn is specified, then a PTR DNS record is created pointing from the IP address in the in-addr.arpa domain to the reverse FQDN.
        """
        if domain_name_label is not None:
            pulumi.set(__self__, "domain_name_label", domain_name_label)
        if fqdn is not None:
            pulumi.set(__self__, "fqdn", fqdn)
        if reverse_fqdn is not None:
            pulumi.set(__self__, "reverse_fqdn", reverse_fqdn)

    @property
    @pulumi.getter(name="domainNameLabel")
    def domain_name_label(self) -> Optional[pulumi.Input[str]]:
        """
        The domain name label. The concatenation of the domain name label and the regionalized DNS zone make up the fully qualified domain name associated with the public IP address. If a domain name label is specified, an A DNS record is created for the public IP in the Microsoft Azure DNS system.
        """
        return pulumi.get(self, "domain_name_label")

    @domain_name_label.setter
    def domain_name_label(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "domain_name_label", value)

    @property
    @pulumi.getter
    def fqdn(self) -> Optional[pulumi.Input[str]]:
        """
        The Fully Qualified Domain Name of the A DNS record associated with the public IP. This is the concatenation of the domainNameLabel and the regionalized DNS zone.
        """
        return pulumi.get(self, "fqdn")

    @fqdn.setter
    def fqdn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fqdn", value)

    @property
    @pulumi.getter(name="reverseFqdn")
    def reverse_fqdn(self) -> Optional[pulumi.Input[str]]:
        """
        The reverse FQDN. A user-visible, fully qualified domain name that resolves to this public IP address. If the reverseFqdn is specified, then a PTR DNS record is created pointing from the IP address in the in-addr.arpa domain to the reverse FQDN.
        """
        return pulumi.get(self, "reverse_fqdn")

    @reverse_fqdn.setter
    def reverse_fqdn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "reverse_fqdn", value)


@pulumi.input_type
class PublicIPAddressSkuArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[Union[str, 'PublicIPAddressSkuName']]] = None):
        """
        SKU of a public IP address.
        :param pulumi.Input[Union[str, 'PublicIPAddressSkuName']] name: Name of a public IP address SKU.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[Union[str, 'PublicIPAddressSkuName']]]:
        """
        Name of a public IP address SKU.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[Union[str, 'PublicIPAddressSkuName']]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class PublicIPAddressArgs:
    def __init__(__self__, *,
                 ddos_settings: Optional[pulumi.Input['DdosSettingsArgs']] = None,
                 dns_settings: Optional[pulumi.Input['PublicIPAddressDnsSettingsArgs']] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 idle_timeout_in_minutes: Optional[pulumi.Input[int]] = None,
                 ip_address: Optional[pulumi.Input[str]] = None,
                 ip_tags: Optional[pulumi.Input[Sequence[pulumi.Input['IpTagArgs']]]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 public_ip_address_version: Optional[pulumi.Input[Union[str, 'IPVersion']]] = None,
                 public_ip_allocation_method: Optional[pulumi.Input[Union[str, 'IPAllocationMethod']]] = None,
                 public_ip_prefix: Optional[pulumi.Input['SubResourceArgs']] = None,
                 sku: Optional[pulumi.Input['PublicIPAddressSkuArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 zones: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Public IP address resource.
        :param pulumi.Input['DdosSettingsArgs'] ddos_settings: The DDoS protection custom policy associated with the public IP address.
        :param pulumi.Input['PublicIPAddressDnsSettingsArgs'] dns_settings: The FQDN of the DNS record associated with the public IP address.
        :param pulumi.Input[str] id: Resource ID.
        :param pulumi.Input[int] idle_timeout_in_minutes: The idle timeout of the public IP address.
        :param pulumi.Input[str] ip_address: The IP address associated with the public IP address resource.
        :param pulumi.Input[Sequence[pulumi.Input['IpTagArgs']]] ip_tags: The list of tags associated with the public IP address.
        :param pulumi.Input[str] location: Resource location.
        :param pulumi.Input[Union[str, 'IPVersion']] public_ip_address_version: The public IP address version.
        :param pulumi.Input[Union[str, 'IPAllocationMethod']] public_ip_allocation_method: The public IP address allocation method.
        :param pulumi.Input['SubResourceArgs'] public_ip_prefix: The Public IP Prefix this Public IP Address should be allocated from.
        :param pulumi.Input['PublicIPAddressSkuArgs'] sku: The public IP address SKU.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Resource tags.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] zones: A list of availability zones denoting the IP allocated for the resource needs to come from.
        """
        if ddos_settings is not None:
            pulumi.set(__self__, "ddos_settings", ddos_settings)
        if dns_settings is not None:
            pulumi.set(__self__, "dns_settings", dns_settings)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if idle_timeout_in_minutes is not None:
            pulumi.set(__self__, "idle_timeout_in_minutes", idle_timeout_in_minutes)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if ip_tags is not None:
            pulumi.set(__self__, "ip_tags", ip_tags)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if public_ip_address_version is not None:
            pulumi.set(__self__, "public_ip_address_version", public_ip_address_version)
        if public_ip_allocation_method is not None:
            pulumi.set(__self__, "public_ip_allocation_method", public_ip_allocation_method)
        if public_ip_prefix is not None:
            pulumi.set(__self__, "public_ip_prefix", public_ip_prefix)
        if sku is not None:
            pulumi.set(__self__, "sku", sku)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if zones is not None:
            pulumi.set(__self__, "zones", zones)

    @property
    @pulumi.getter(name="ddosSettings")
    def ddos_settings(self) -> Optional[pulumi.Input['DdosSettingsArgs']]:
        """
        The DDoS protection custom policy associated with the public IP address.
        """
        return pulumi.get(self, "ddos_settings")

    @ddos_settings.setter
    def ddos_settings(self, value: Optional[pulumi.Input['DdosSettingsArgs']]):
        pulumi.set(self, "ddos_settings", value)

    @property
    @pulumi.getter(name="dnsSettings")
    def dns_settings(self) -> Optional[pulumi.Input['PublicIPAddressDnsSettingsArgs']]:
        """
        The FQDN of the DNS record associated with the public IP address.
        """
        return pulumi.get(self, "dns_settings")

    @dns_settings.setter
    def dns_settings(self, value: Optional[pulumi.Input['PublicIPAddressDnsSettingsArgs']]):
        pulumi.set(self, "dns_settings", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="idleTimeoutInMinutes")
    def idle_timeout_in_minutes(self) -> Optional[pulumi.Input[int]]:
        """
        The idle timeout of the public IP address.
        """
        return pulumi.get(self, "idle_timeout_in_minutes")

    @idle_timeout_in_minutes.setter
    def idle_timeout_in_minutes(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "idle_timeout_in_minutes", value)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[pulumi.Input[str]]:
        """
        The IP address associated with the public IP address resource.
        """
        return pulumi.get(self, "ip_address")

    @ip_address.setter
    def ip_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip_address", value)

    @property
    @pulumi.getter(name="ipTags")
    def ip_tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IpTagArgs']]]]:
        """
        The list of tags associated with the public IP address.
        """
        return pulumi.get(self, "ip_tags")

    @ip_tags.setter
    def ip_tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IpTagArgs']]]]):
        pulumi.set(self, "ip_tags", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        Resource location.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="publicIPAddressVersion")
    def public_ip_address_version(self) -> Optional[pulumi.Input[Union[str, 'IPVersion']]]:
        """
        The public IP address version.
        """
        return pulumi.get(self, "public_ip_address_version")

    @public_ip_address_version.setter
    def public_ip_address_version(self, value: Optional[pulumi.Input[Union[str, 'IPVersion']]]):
        pulumi.set(self, "public_ip_address_version", value)

    @property
    @pulumi.getter(name="publicIPAllocationMethod")
    def public_ip_allocation_method(self) -> Optional[pulumi.Input[Union[str, 'IPAllocationMethod']]]:
        """
        The public IP address allocation method.
        """
        return pulumi.get(self, "public_ip_allocation_method")

    @public_ip_allocation_method.setter
    def public_ip_allocation_method(self, value: Optional[pulumi.Input[Union[str, 'IPAllocationMethod']]]):
        pulumi.set(self, "public_ip_allocation_method", value)

    @property
    @pulumi.getter(name="publicIPPrefix")
    def public_ip_prefix(self) -> Optional[pulumi.Input['SubResourceArgs']]:
        """
        The Public IP Prefix this Public IP Address should be allocated from.
        """
        return pulumi.get(self, "public_ip_prefix")

    @public_ip_prefix.setter
    def public_ip_prefix(self, value: Optional[pulumi.Input['SubResourceArgs']]):
        pulumi.set(self, "public_ip_prefix", value)

    @property
    @pulumi.getter
    def sku(self) -> Optional[pulumi.Input['PublicIPAddressSkuArgs']]:
        """
        The public IP address SKU.
        """
        return pulumi.get(self, "sku")

    @sku.setter
    def sku(self, value: Optional[pulumi.Input['PublicIPAddressSkuArgs']]):
        pulumi.set(self, "sku", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Resource tags.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of availability zones denoting the IP allocated for the resource needs to come from.
        """
        return pulumi.get(self, "zones")

    @zones.setter
    def zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "zones", value)


@pulumi.input_type
class PublicIPPrefixSkuArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[Union[str, 'PublicIPPrefixSkuName']]] = None):
        """
        SKU of a public IP prefix.
        :param pulumi.Input[Union[str, 'PublicIPPrefixSkuName']] name: Name of a public IP prefix SKU.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[Union[str, 'PublicIPPrefixSkuName']]]:
        """
        Name of a public IP prefix SKU.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[Union[str, 'PublicIPPrefixSkuName']]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class RadiusServerArgs:
    def __init__(__self__, *,
                 radius_server_address: pulumi.Input[str],
                 radius_server_score: Optional[pulumi.Input[float]] = None,
                 radius_server_secret: Optional[pulumi.Input[str]] = None):
        """
        Radius Server Settings.
        :param pulumi.Input[str] radius_server_address: The address of this radius server.
        :param pulumi.Input[float] radius_server_score: The initial score assigned to this radius server.
        :param pulumi.Input[str] radius_server_secret: The secret used for this radius server.
        """
        pulumi.set(__self__, "radius_server_address", radius_server_address)
        if radius_server_score is not None:
            pulumi.set(__self__, "radius_server_score", radius_server_score)
        if radius_server_secret is not None:
            pulumi.set(__self__, "radius_server_secret", radius_server_secret)

    @property
    @pulumi.getter(name="radiusServerAddress")
    def radius_server_address(self) -> pulumi.Input[str]:
        """
        The address of this radius server.
        """
        return pulumi.get(self, "radius_server_address")

    @radius_server_address.setter
    def radius_server_address(self, value: pulumi.Input[str]):
        pulumi.set(self, "radius_server_address", value)

    @property
    @pulumi.getter(name="radiusServerScore")
    def radius_server_score(self) -> Optional[pulumi.Input[float]]:
        """
        The initial score assigned to this radius server.
        """
        return pulumi.get(self, "radius_server_score")

    @radius_server_score.setter
    def radius_server_score(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "radius_server_score", value)

    @property
    @pulumi.getter(name="radiusServerSecret")
    def radius_server_secret(self) -> Optional[pulumi.Input[str]]:
        """
        The secret used for this radius server.
        """
        return pulumi.get(self, "radius_server_secret")

    @radius_server_secret.setter
    def radius_server_secret(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "radius_server_secret", value)


@pulumi.input_type
class RedirectConfigurationArgs:
    def __init__(__self__, *,
                 odata_type: pulumi.Input[str],
                 custom_fragment: Optional[pulumi.Input[str]] = None,
                 custom_host: Optional[pulumi.Input[str]] = None,
                 custom_path: Optional[pulumi.Input[str]] = None,
                 custom_query_string: Optional[pulumi.Input[str]] = None,
                 redirect_protocol: Optional[pulumi.Input[Union[str, 'FrontDoorRedirectProtocol']]] = None,
                 redirect_type: Optional[pulumi.Input[Union[str, 'FrontDoorRedirectType']]] = None):
        """
        Describes Redirect Route.
        :param pulumi.Input[str] odata_type: 
               Expected value is '#Microsoft.Azure.FrontDoor.Models.FrontdoorRedirectConfiguration'.
        :param pulumi.Input[str] custom_fragment: Fragment to add to the redirect URL. Fragment is the part of the URL that comes after #. Do not include the #.
        :param pulumi.Input[str] custom_host: Host to redirect. Leave empty to use the incoming host as the destination host.
        :param pulumi.Input[str] custom_path: The full path to redirect. Path cannot be empty and must start with /. Leave empty to use the incoming path as destination path.
        :param pulumi.Input[str] custom_query_string: The set of query strings to be placed in the redirect URL. Setting this value would replace any existing query string; leave empty to preserve the incoming query string. Query string must be in <key>=<value> format. The first ? and & will be added automatically so do not include them in the front, but do separate multiple query strings with &.
        :param pulumi.Input[Union[str, 'FrontDoorRedirectProtocol']] redirect_protocol: The protocol of the destination to where the traffic is redirected
        :param pulumi.Input[Union[str, 'FrontDoorRedirectType']] redirect_type: The redirect type the rule will use when redirecting traffic.
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Azure.FrontDoor.Models.FrontdoorRedirectConfiguration')
        if custom_fragment is not None:
            pulumi.set(__self__, "custom_fragment", custom_fragment)
        if custom_host is not None:
            pulumi.set(__self__, "custom_host", custom_host)
        if custom_path is not None:
            pulumi.set(__self__, "custom_path", custom_path)
        if custom_query_string is not None:
            pulumi.set(__self__, "custom_query_string", custom_query_string)
        if redirect_protocol is not None:
            pulumi.set(__self__, "redirect_protocol", redirect_protocol)
        if redirect_type is not None:
            pulumi.set(__self__, "redirect_type", redirect_type)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> pulumi.Input[str]:
        """

        Expected value is '#Microsoft.Azure.FrontDoor.Models.FrontdoorRedirectConfiguration'.
        """
        return pulumi.get(self, "odata_type")

    @odata_type.setter
    def odata_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "odata_type", value)

    @property
    @pulumi.getter(name="customFragment")
    def custom_fragment(self) -> Optional[pulumi.Input[str]]:
        """
        Fragment to add to the redirect URL. Fragment is the part of the URL that comes after #. Do not include the #.
        """
        return pulumi.get(self, "custom_fragment")

    @custom_fragment.setter
    def custom_fragment(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "custom_fragment", value)

    @property
    @pulumi.getter(name="customHost")
    def custom_host(self) -> Optional[pulumi.Input[str]]:
        """
        Host to redirect. Leave empty to use the incoming host as the destination host.
        """
        return pulumi.get(self, "custom_host")

    @custom_host.setter
    def custom_host(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "custom_host", value)

    @property
    @pulumi.getter(name="customPath")
    def custom_path(self) -> Optional[pulumi.Input[str]]:
        """
        The full path to redirect. Path cannot be empty and must start with /. Leave empty to use the incoming path as destination path.
        """
        return pulumi.get(self, "custom_path")

    @custom_path.setter
    def custom_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "custom_path", value)

    @property
    @pulumi.getter(name="customQueryString")
    def custom_query_string(self) -> Optional[pulumi.Input[str]]:
        """
        The set of query strings to be placed in the redirect URL. Setting this value would replace any existing query string; leave empty to preserve the incoming query string. Query string must be in <key>=<value> format. The first ? and & will be added automatically so do not include them in the front, but do separate multiple query strings with &.
        """
        return pulumi.get(self, "custom_query_string")

    @custom_query_string.setter
    def custom_query_string(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "custom_query_string", value)

    @property
    @pulumi.getter(name="redirectProtocol")
    def redirect_protocol(self) -> Optional[pulumi.Input[Union[str, 'FrontDoorRedirectProtocol']]]:
        """
        The protocol of the destination to where the traffic is redirected
        """
        return pulumi.get(self, "redirect_protocol")

    @redirect_protocol.setter
    def redirect_protocol(self, value: Optional[pulumi.Input[Union[str, 'FrontDoorRedirectProtocol']]]):
        pulumi.set(self, "redirect_protocol", value)

    @property
    @pulumi.getter(name="redirectType")
    def redirect_type(self) -> Optional[pulumi.Input[Union[str, 'FrontDoorRedirectType']]]:
        """
        The redirect type the rule will use when redirecting traffic.
        """
        return pulumi.get(self, "redirect_type")

    @redirect_type.setter
    def redirect_type(self, value: Optional[pulumi.Input[Union[str, 'FrontDoorRedirectType']]]):
        pulumi.set(self, "redirect_type", value)


@pulumi.input_type
class RetentionPolicyParametersArgs:
    def __init__(__self__, *,
                 days: Optional[pulumi.Input[int]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None):
        """
        Parameters that define the retention policy for flow log.
        :param pulumi.Input[int] days: Number of days to retain flow log records.
        :param pulumi.Input[bool] enabled: Flag to enable/disable retention.
        """
        if days is None:
            days = 0
        if days is not None:
            pulumi.set(__self__, "days", days)
        if enabled is None:
            enabled = False
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def days(self) -> Optional[pulumi.Input[int]]:
        """
        Number of days to retain flow log records.
        """
        return pulumi.get(self, "days")

    @days.setter
    def days(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "days", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag to enable/disable retention.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)


@pulumi.input_type
class RouteFilterRuleArgs:
    def __init__(__self__, *,
                 access: pulumi.Input[Union[str, 'Access']],
                 communities: pulumi.Input[Sequence[pulumi.Input[str]]],
                 route_filter_rule_type: pulumi.Input[Union[str, 'RouteFilterRuleType']],
                 id: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        Route Filter Rule Resource.
        :param pulumi.Input[Union[str, 'Access']] access: The access type of the rule.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] communities: The collection for bgp community values to filter on. e.g. ['12076:5010','12076:5020'].
        :param pulumi.Input[Union[str, 'RouteFilterRuleType']] route_filter_rule_type: The rule type of the rule.
        :param pulumi.Input[str] id: Resource ID.
        :param pulumi.Input[str] location: Resource location.
        :param pulumi.Input[str] name: The name of the resource that is unique within a resource group. This name can be used to access the resource.
        """
        pulumi.set(__self__, "access", access)
        pulumi.set(__self__, "communities", communities)
        pulumi.set(__self__, "route_filter_rule_type", route_filter_rule_type)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def access(self) -> pulumi.Input[Union[str, 'Access']]:
        """
        The access type of the rule.
        """
        return pulumi.get(self, "access")

    @access.setter
    def access(self, value: pulumi.Input[Union[str, 'Access']]):
        pulumi.set(self, "access", value)

    @property
    @pulumi.getter
    def communities(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        The collection for bgp community values to filter on. e.g. ['12076:5010','12076:5020'].
        """
        return pulumi.get(self, "communities")

    @communities.setter
    def communities(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "communities", value)

    @property
    @pulumi.getter(name="routeFilterRuleType")
    def route_filter_rule_type(self) -> pulumi.Input[Union[str, 'RouteFilterRuleType']]:
        """
        The rule type of the rule.
        """
        return pulumi.get(self, "route_filter_rule_type")

    @route_filter_rule_type.setter
    def route_filter_rule_type(self, value: pulumi.Input[Union[str, 'RouteFilterRuleType']]):
        pulumi.set(self, "route_filter_rule_type", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        Resource location.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the resource that is unique within a resource group. This name can be used to access the resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class RouteTableArgs:
    def __init__(__self__, *,
                 disable_bgp_route_propagation: Optional[pulumi.Input[bool]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 routes: Optional[pulumi.Input[Sequence[pulumi.Input['RouteArgs']]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        Route table resource.
        :param pulumi.Input[bool] disable_bgp_route_propagation: Whether to disable the routes learned by BGP on that route table. True means disable.
        :param pulumi.Input[str] id: Resource ID.
        :param pulumi.Input[str] location: Resource location.
        :param pulumi.Input[Sequence[pulumi.Input['RouteArgs']]] routes: Collection of routes contained within a route table.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Resource tags.
        """
        if disable_bgp_route_propagation is not None:
            pulumi.set(__self__, "disable_bgp_route_propagation", disable_bgp_route_propagation)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if routes is not None:
            pulumi.set(__self__, "routes", routes)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="disableBgpRoutePropagation")
    def disable_bgp_route_propagation(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to disable the routes learned by BGP on that route table. True means disable.
        """
        return pulumi.get(self, "disable_bgp_route_propagation")

    @disable_bgp_route_propagation.setter
    def disable_bgp_route_propagation(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable_bgp_route_propagation", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        Resource location.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def routes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RouteArgs']]]]:
        """
        Collection of routes contained within a route table.
        """
        return pulumi.get(self, "routes")

    @routes.setter
    def routes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RouteArgs']]]]):
        pulumi.set(self, "routes", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Resource tags.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class RouteArgs:
    def __init__(__self__, *,
                 next_hop_type: pulumi.Input[Union[str, 'RouteNextHopType']],
                 address_prefix: Optional[pulumi.Input[str]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 next_hop_ip_address: Optional[pulumi.Input[str]] = None):
        """
        Route resource.
        :param pulumi.Input[Union[str, 'RouteNextHopType']] next_hop_type: The type of Azure hop the packet should be sent to.
        :param pulumi.Input[str] address_prefix: The destination CIDR to which the route applies.
        :param pulumi.Input[str] id: Resource ID.
        :param pulumi.Input[str] name: The name of the resource that is unique within a resource group. This name can be used to access the resource.
        :param pulumi.Input[str] next_hop_ip_address: The IP address packets should be forwarded to. Next hop values are only allowed in routes where the next hop type is VirtualAppliance.
        """
        pulumi.set(__self__, "next_hop_type", next_hop_type)
        if address_prefix is not None:
            pulumi.set(__self__, "address_prefix", address_prefix)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if next_hop_ip_address is not None:
            pulumi.set(__self__, "next_hop_ip_address", next_hop_ip_address)

    @property
    @pulumi.getter(name="nextHopType")
    def next_hop_type(self) -> pulumi.Input[Union[str, 'RouteNextHopType']]:
        """
        The type of Azure hop the packet should be sent to.
        """
        return pulumi.get(self, "next_hop_type")

    @next_hop_type.setter
    def next_hop_type(self, value: pulumi.Input[Union[str, 'RouteNextHopType']]):
        pulumi.set(self, "next_hop_type", value)

    @property
    @pulumi.getter(name="addressPrefix")
    def address_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        The destination CIDR to which the route applies.
        """
        return pulumi.get(self, "address_prefix")

    @address_prefix.setter
    def address_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "address_prefix", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the resource that is unique within a resource group. This name can be used to access the resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="nextHopIpAddress")
    def next_hop_ip_address(self) -> Optional[pulumi.Input[str]]:
        """
        The IP address packets should be forwarded to. Next hop values are only allowed in routes where the next hop type is VirtualAppliance.
        """
        return pulumi.get(self, "next_hop_ip_address")

    @next_hop_ip_address.setter
    def next_hop_ip_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "next_hop_ip_address", value)


@pulumi.input_type
class RoutingConfigurationArgs:
    def __init__(__self__, *,
                 associated_route_table: Optional[pulumi.Input['SubResourceArgs']] = None,
                 propagated_route_tables: Optional[pulumi.Input['PropagatedRouteTableArgs']] = None,
                 vnet_routes: Optional[pulumi.Input['VnetRouteArgs']] = None):
        """
        Routing Configuration indicating the associated and propagated route tables for this connection.
        :param pulumi.Input['SubResourceArgs'] associated_route_table: The resource id RouteTable associated with this RoutingConfiguration.
        :param pulumi.Input['PropagatedRouteTableArgs'] propagated_route_tables: The list of RouteTables to advertise the routes to.
        :param pulumi.Input['VnetRouteArgs'] vnet_routes: List of routes that control routing from VirtualHub into a virtual network connection.
        """
        if associated_route_table is not None:
            pulumi.set(__self__, "associated_route_table", associated_route_table)
        if propagated_route_tables is not None:
            pulumi.set(__self__, "propagated_route_tables", propagated_route_tables)
        if vnet_routes is not None:
            pulumi.set(__self__, "vnet_routes", vnet_routes)

    @property
    @pulumi.getter(name="associatedRouteTable")
    def associated_route_table(self) -> Optional[pulumi.Input['SubResourceArgs']]:
        """
        The resource id RouteTable associated with this RoutingConfiguration.
        """
        return pulumi.get(self, "associated_route_table")

    @associated_route_table.setter
    def associated_route_table(self, value: Optional[pulumi.Input['SubResourceArgs']]):
        pulumi.set(self, "associated_route_table", value)

    @property
    @pulumi.getter(name="propagatedRouteTables")
    def propagated_route_tables(self) -> Optional[pulumi.Input['PropagatedRouteTableArgs']]:
        """
        The list of RouteTables to advertise the routes to.
        """
        return pulumi.get(self, "propagated_route_tables")

    @propagated_route_tables.setter
    def propagated_route_tables(self, value: Optional[pulumi.Input['PropagatedRouteTableArgs']]):
        pulumi.set(self, "propagated_route_tables", value)

    @property
    @pulumi.getter(name="vnetRoutes")
    def vnet_routes(self) -> Optional[pulumi.Input['VnetRouteArgs']]:
        """
        List of routes that control routing from VirtualHub into a virtual network connection.
        """
        return pulumi.get(self, "vnet_routes")

    @vnet_routes.setter
    def vnet_routes(self, value: Optional[pulumi.Input['VnetRouteArgs']]):
        pulumi.set(self, "vnet_routes", value)


@pulumi.input_type
class RoutingRuleUpdateParametersWebApplicationFirewallPolicyLinkArgs:
    def __init__(__self__, *,
                 id: Optional[pulumi.Input[str]] = None):
        """
        Defines the Web Application Firewall policy for each routing rule (if applicable)
        :param pulumi.Input[str] id: Resource ID.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)


@pulumi.input_type
class RoutingRuleArgs:
    def __init__(__self__, *,
                 accepted_protocols: Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'FrontDoorProtocol']]]]] = None,
                 enabled_state: Optional[pulumi.Input[Union[str, 'RoutingRuleEnabledState']]] = None,
                 frontend_endpoints: Optional[pulumi.Input[Sequence[pulumi.Input['SubResourceArgs']]]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 patterns_to_match: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 route_configuration: Optional[pulumi.Input[Union['ForwardingConfigurationArgs', 'RedirectConfigurationArgs']]] = None,
                 rules_engine: Optional[pulumi.Input['SubResourceArgs']] = None,
                 web_application_firewall_policy_link: Optional[pulumi.Input['RoutingRuleUpdateParametersWebApplicationFirewallPolicyLinkArgs']] = None):
        """
        A routing rule represents a specification for traffic to treat and where to send it, along with health probe information.
        :param pulumi.Input[Sequence[pulumi.Input[Union[str, 'FrontDoorProtocol']]]] accepted_protocols: Protocol schemes to match for this rule
        :param pulumi.Input[Union[str, 'RoutingRuleEnabledState']] enabled_state: Whether to enable use of this rule. Permitted values are 'Enabled' or 'Disabled'
        :param pulumi.Input[Sequence[pulumi.Input['SubResourceArgs']]] frontend_endpoints: Frontend endpoints associated with this rule
        :param pulumi.Input[str] id: Resource ID.
        :param pulumi.Input[str] name: Resource name.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] patterns_to_match: The route patterns of the rule.
        :param pulumi.Input[Union['ForwardingConfigurationArgs', 'RedirectConfigurationArgs']] route_configuration: A reference to the routing configuration.
        :param pulumi.Input['SubResourceArgs'] rules_engine: A reference to a specific Rules Engine Configuration to apply to this route.
        :param pulumi.Input['RoutingRuleUpdateParametersWebApplicationFirewallPolicyLinkArgs'] web_application_firewall_policy_link: Defines the Web Application Firewall policy for each routing rule (if applicable)
        """
        if accepted_protocols is not None:
            pulumi.set(__self__, "accepted_protocols", accepted_protocols)
        if enabled_state is not None:
            pulumi.set(__self__, "enabled_state", enabled_state)
        if frontend_endpoints is not None:
            pulumi.set(__self__, "frontend_endpoints", frontend_endpoints)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if patterns_to_match is not None:
            pulumi.set(__self__, "patterns_to_match", patterns_to_match)
        if route_configuration is not None:
            pulumi.set(__self__, "route_configuration", route_configuration)
        if rules_engine is not None:
            pulumi.set(__self__, "rules_engine", rules_engine)
        if web_application_firewall_policy_link is not None:
            pulumi.set(__self__, "web_application_firewall_policy_link", web_application_firewall_policy_link)

    @property
    @pulumi.getter(name="acceptedProtocols")
    def accepted_protocols(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'FrontDoorProtocol']]]]]:
        """
        Protocol schemes to match for this rule
        """
        return pulumi.get(self, "accepted_protocols")

    @accepted_protocols.setter
    def accepted_protocols(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'FrontDoorProtocol']]]]]):
        pulumi.set(self, "accepted_protocols", value)

    @property
    @pulumi.getter(name="enabledState")
    def enabled_state(self) -> Optional[pulumi.Input[Union[str, 'RoutingRuleEnabledState']]]:
        """
        Whether to enable use of this rule. Permitted values are 'Enabled' or 'Disabled'
        """
        return pulumi.get(self, "enabled_state")

    @enabled_state.setter
    def enabled_state(self, value: Optional[pulumi.Input[Union[str, 'RoutingRuleEnabledState']]]):
        pulumi.set(self, "enabled_state", value)

    @property
    @pulumi.getter(name="frontendEndpoints")
    def frontend_endpoints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SubResourceArgs']]]]:
        """
        Frontend endpoints associated with this rule
        """
        return pulumi.get(self, "frontend_endpoints")

    @frontend_endpoints.setter
    def frontend_endpoints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SubResourceArgs']]]]):
        pulumi.set(self, "frontend_endpoints", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Resource name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="patternsToMatch")
    def patterns_to_match(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The route patterns of the rule.
        """
        return pulumi.get(self, "patterns_to_match")

    @patterns_to_match.setter
    def patterns_to_match(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "patterns_to_match", value)

    @property
    @pulumi.getter(name="routeConfiguration")
    def route_configuration(self) -> Optional[pulumi.Input[Union['ForwardingConfigurationArgs', 'RedirectConfigurationArgs']]]:
        """
        A reference to the routing configuration.
        """
        return pulumi.get(self, "route_configuration")

    @route_configuration.setter
    def route_configuration(self, value: Optional[pulumi.Input[Union['ForwardingConfigurationArgs', 'RedirectConfigurationArgs']]]):
        pulumi.set(self, "route_configuration", value)

    @property
    @pulumi.getter(name="rulesEngine")
    def rules_engine(self) -> Optional[pulumi.Input['SubResourceArgs']]:
        """
        A reference to a specific Rules Engine Configuration to apply to this route.
        """
        return pulumi.get(self, "rules_engine")

    @rules_engine.setter
    def rules_engine(self, value: Optional[pulumi.Input['SubResourceArgs']]):
        pulumi.set(self, "rules_engine", value)

    @property
    @pulumi.getter(name="webApplicationFirewallPolicyLink")
    def web_application_firewall_policy_link(self) -> Optional[pulumi.Input['RoutingRuleUpdateParametersWebApplicationFirewallPolicyLinkArgs']]:
        """
        Defines the Web Application Firewall policy for each routing rule (if applicable)
        """
        return pulumi.get(self, "web_application_firewall_policy_link")

    @web_application_firewall_policy_link.setter
    def web_application_firewall_policy_link(self, value: Optional[pulumi.Input['RoutingRuleUpdateParametersWebApplicationFirewallPolicyLinkArgs']]):
        pulumi.set(self, "web_application_firewall_policy_link", value)


@pulumi.input_type
class RulesEngineActionArgs:
    def __init__(__self__, *,
                 request_header_actions: Optional[pulumi.Input[Sequence[pulumi.Input['HeaderActionArgs']]]] = None,
                 response_header_actions: Optional[pulumi.Input[Sequence[pulumi.Input['HeaderActionArgs']]]] = None,
                 route_configuration_override: Optional[pulumi.Input[Union['ForwardingConfigurationArgs', 'RedirectConfigurationArgs']]] = None):
        """
        One or more actions that will execute, modifying the request and/or response.
        :param pulumi.Input[Sequence[pulumi.Input['HeaderActionArgs']]] request_header_actions: A list of header actions to apply from the request from AFD to the origin.
        :param pulumi.Input[Sequence[pulumi.Input['HeaderActionArgs']]] response_header_actions: A list of header actions to apply from the response from AFD to the client.
        :param pulumi.Input[Union['ForwardingConfigurationArgs', 'RedirectConfigurationArgs']] route_configuration_override: Override the route configuration.
        """
        if request_header_actions is not None:
            pulumi.set(__self__, "request_header_actions", request_header_actions)
        if response_header_actions is not None:
            pulumi.set(__self__, "response_header_actions", response_header_actions)
        if route_configuration_override is not None:
            pulumi.set(__self__, "route_configuration_override", route_configuration_override)

    @property
    @pulumi.getter(name="requestHeaderActions")
    def request_header_actions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['HeaderActionArgs']]]]:
        """
        A list of header actions to apply from the request from AFD to the origin.
        """
        return pulumi.get(self, "request_header_actions")

    @request_header_actions.setter
    def request_header_actions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['HeaderActionArgs']]]]):
        pulumi.set(self, "request_header_actions", value)

    @property
    @pulumi.getter(name="responseHeaderActions")
    def response_header_actions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['HeaderActionArgs']]]]:
        """
        A list of header actions to apply from the response from AFD to the client.
        """
        return pulumi.get(self, "response_header_actions")

    @response_header_actions.setter
    def response_header_actions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['HeaderActionArgs']]]]):
        pulumi.set(self, "response_header_actions", value)

    @property
    @pulumi.getter(name="routeConfigurationOverride")
    def route_configuration_override(self) -> Optional[pulumi.Input[Union['ForwardingConfigurationArgs', 'RedirectConfigurationArgs']]]:
        """
        Override the route configuration.
        """
        return pulumi.get(self, "route_configuration_override")

    @route_configuration_override.setter
    def route_configuration_override(self, value: Optional[pulumi.Input[Union['ForwardingConfigurationArgs', 'RedirectConfigurationArgs']]]):
        pulumi.set(self, "route_configuration_override", value)


@pulumi.input_type
class RulesEngineMatchConditionArgs:
    def __init__(__self__, *,
                 rules_engine_match_value: pulumi.Input[Sequence[pulumi.Input[str]]],
                 rules_engine_match_variable: pulumi.Input[Union[str, 'RulesEngineMatchVariable']],
                 rules_engine_operator: pulumi.Input[Union[str, 'RulesEngineOperator']],
                 negate_condition: Optional[pulumi.Input[bool]] = None,
                 selector: Optional[pulumi.Input[str]] = None,
                 transforms: Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'Transform']]]]] = None):
        """
        Define a match condition
        :param pulumi.Input[Sequence[pulumi.Input[str]]] rules_engine_match_value: Match values to match against. The operator will apply to each value in here with OR semantics. If any of them match the variable with the given operator this match condition is considered a match.
        :param pulumi.Input[Union[str, 'RulesEngineMatchVariable']] rules_engine_match_variable: Match Variable
        :param pulumi.Input[Union[str, 'RulesEngineOperator']] rules_engine_operator: Describes operator to apply to the match condition.
        :param pulumi.Input[bool] negate_condition: Describes if this is negate condition or not
        :param pulumi.Input[str] selector: Name of selector in RequestHeader or RequestBody to be matched
        :param pulumi.Input[Sequence[pulumi.Input[Union[str, 'Transform']]]] transforms: List of transforms
        """
        pulumi.set(__self__, "rules_engine_match_value", rules_engine_match_value)
        pulumi.set(__self__, "rules_engine_match_variable", rules_engine_match_variable)
        pulumi.set(__self__, "rules_engine_operator", rules_engine_operator)
        if negate_condition is not None:
            pulumi.set(__self__, "negate_condition", negate_condition)
        if selector is not None:
            pulumi.set(__self__, "selector", selector)
        if transforms is not None:
            pulumi.set(__self__, "transforms", transforms)

    @property
    @pulumi.getter(name="rulesEngineMatchValue")
    def rules_engine_match_value(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        Match values to match against. The operator will apply to each value in here with OR semantics. If any of them match the variable with the given operator this match condition is considered a match.
        """
        return pulumi.get(self, "rules_engine_match_value")

    @rules_engine_match_value.setter
    def rules_engine_match_value(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "rules_engine_match_value", value)

    @property
    @pulumi.getter(name="rulesEngineMatchVariable")
    def rules_engine_match_variable(self) -> pulumi.Input[Union[str, 'RulesEngineMatchVariable']]:
        """
        Match Variable
        """
        return pulumi.get(self, "rules_engine_match_variable")

    @rules_engine_match_variable.setter
    def rules_engine_match_variable(self, value: pulumi.Input[Union[str, 'RulesEngineMatchVariable']]):
        pulumi.set(self, "rules_engine_match_variable", value)

    @property
    @pulumi.getter(name="rulesEngineOperator")
    def rules_engine_operator(self) -> pulumi.Input[Union[str, 'RulesEngineOperator']]:
        """
        Describes operator to apply to the match condition.
        """
        return pulumi.get(self, "rules_engine_operator")

    @rules_engine_operator.setter
    def rules_engine_operator(self, value: pulumi.Input[Union[str, 'RulesEngineOperator']]):
        pulumi.set(self, "rules_engine_operator", value)

    @property
    @pulumi.getter(name="negateCondition")
    def negate_condition(self) -> Optional[pulumi.Input[bool]]:
        """
        Describes if this is negate condition or not
        """
        return pulumi.get(self, "negate_condition")

    @negate_condition.setter
    def negate_condition(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "negate_condition", value)

    @property
    @pulumi.getter
    def selector(self) -> Optional[pulumi.Input[str]]:
        """
        Name of selector in RequestHeader or RequestBody to be matched
        """
        return pulumi.get(self, "selector")

    @selector.setter
    def selector(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "selector", value)

    @property
    @pulumi.getter
    def transforms(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'Transform']]]]]:
        """
        List of transforms
        """
        return pulumi.get(self, "transforms")

    @transforms.setter
    def transforms(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'Transform']]]]]):
        pulumi.set(self, "transforms", value)


@pulumi.input_type
class RulesEngineRuleArgs:
    def __init__(__self__, *,
                 action: pulumi.Input['RulesEngineActionArgs'],
                 name: pulumi.Input[str],
                 priority: pulumi.Input[int],
                 match_conditions: Optional[pulumi.Input[Sequence[pulumi.Input['RulesEngineMatchConditionArgs']]]] = None,
                 match_processing_behavior: Optional[pulumi.Input[Union[str, 'MatchProcessingBehavior']]] = None):
        """
        Contains a list of match conditions, and an action on how to modify the request/response. If multiple rules match, the actions from one rule that conflict with a previous rule overwrite for a singular action, or append in the case of headers manipulation.
        :param pulumi.Input['RulesEngineActionArgs'] action: Actions to perform on the request and response if all of the match conditions are met.
        :param pulumi.Input[str] name: A name to refer to this specific rule.
        :param pulumi.Input[int] priority: A priority assigned to this rule. 
        :param pulumi.Input[Sequence[pulumi.Input['RulesEngineMatchConditionArgs']]] match_conditions: A list of match conditions that must meet in order for the actions of this rule to run. Having no match conditions means the actions will always run.
        :param pulumi.Input[Union[str, 'MatchProcessingBehavior']] match_processing_behavior: If this rule is a match should the rules engine continue running the remaining rules or stop. If not present, defaults to Continue.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "priority", priority)
        if match_conditions is not None:
            pulumi.set(__self__, "match_conditions", match_conditions)
        if match_processing_behavior is not None:
            pulumi.set(__self__, "match_processing_behavior", match_processing_behavior)

    @property
    @pulumi.getter
    def action(self) -> pulumi.Input['RulesEngineActionArgs']:
        """
        Actions to perform on the request and response if all of the match conditions are met.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: pulumi.Input['RulesEngineActionArgs']):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        A name to refer to this specific rule.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def priority(self) -> pulumi.Input[int]:
        """
        A priority assigned to this rule. 
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: pulumi.Input[int]):
        pulumi.set(self, "priority", value)

    @property
    @pulumi.getter(name="matchConditions")
    def match_conditions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RulesEngineMatchConditionArgs']]]]:
        """
        A list of match conditions that must meet in order for the actions of this rule to run. Having no match conditions means the actions will always run.
        """
        return pulumi.get(self, "match_conditions")

    @match_conditions.setter
    def match_conditions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RulesEngineMatchConditionArgs']]]]):
        pulumi.set(self, "match_conditions", value)

    @property
    @pulumi.getter(name="matchProcessingBehavior")
    def match_processing_behavior(self) -> Optional[pulumi.Input[Union[str, 'MatchProcessingBehavior']]]:
        """
        If this rule is a match should the rules engine continue running the remaining rules or stop. If not present, defaults to Continue.
        """
        return pulumi.get(self, "match_processing_behavior")

    @match_processing_behavior.setter
    def match_processing_behavior(self, value: Optional[pulumi.Input[Union[str, 'MatchProcessingBehavior']]]):
        pulumi.set(self, "match_processing_behavior", value)


@pulumi.input_type
class SecurityRuleArgs:
    def __init__(__self__, *,
                 access: pulumi.Input[Union[str, 'SecurityRuleAccess']],
                 direction: pulumi.Input[Union[str, 'SecurityRuleDirection']],
                 protocol: pulumi.Input[Union[str, 'SecurityRuleProtocol']],
                 description: Optional[pulumi.Input[str]] = None,
                 destination_address_prefix: Optional[pulumi.Input[str]] = None,
                 destination_address_prefixes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 destination_application_security_groups: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationSecurityGroupArgs']]]] = None,
                 destination_port_range: Optional[pulumi.Input[str]] = None,
                 destination_port_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 priority: Optional[pulumi.Input[int]] = None,
                 source_address_prefix: Optional[pulumi.Input[str]] = None,
                 source_address_prefixes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 source_application_security_groups: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationSecurityGroupArgs']]]] = None,
                 source_port_range: Optional[pulumi.Input[str]] = None,
                 source_port_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Network security rule.
        :param pulumi.Input[Union[str, 'SecurityRuleAccess']] access: The network traffic is allowed or denied.
        :param pulumi.Input[Union[str, 'SecurityRuleDirection']] direction: The direction of the rule. The direction specifies if rule will be evaluated on incoming or outgoing traffic.
        :param pulumi.Input[Union[str, 'SecurityRuleProtocol']] protocol: Network protocol this rule applies to.
        :param pulumi.Input[str] description: A description for this rule. Restricted to 140 chars.
        :param pulumi.Input[str] destination_address_prefix: The destination address prefix. CIDR or destination IP range. Asterisk '*' can also be used to match all source IPs. Default tags such as 'VirtualNetwork', 'AzureLoadBalancer' and 'Internet' can also be used.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] destination_address_prefixes: The destination address prefixes. CIDR or destination IP ranges.
        :param pulumi.Input[Sequence[pulumi.Input['ApplicationSecurityGroupArgs']]] destination_application_security_groups: The application security group specified as destination.
        :param pulumi.Input[str] destination_port_range: The destination port or range. Integer or range between 0 and 65535. Asterisk '*' can also be used to match all ports.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] destination_port_ranges: The destination port ranges.
        :param pulumi.Input[str] id: Resource ID.
        :param pulumi.Input[str] name: The name of the resource that is unique within a resource group. This name can be used to access the resource.
        :param pulumi.Input[int] priority: The priority of the rule. The value can be between 100 and 4096. The priority number must be unique for each rule in the collection. The lower the priority number, the higher the priority of the rule.
        :param pulumi.Input[str] source_address_prefix: The CIDR or source IP range. Asterisk '*' can also be used to match all source IPs. Default tags such as 'VirtualNetwork', 'AzureLoadBalancer' and 'Internet' can also be used. If this is an ingress rule, specifies where network traffic originates from.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] source_address_prefixes: The CIDR or source IP ranges.
        :param pulumi.Input[Sequence[pulumi.Input['ApplicationSecurityGroupArgs']]] source_application_security_groups: The application security group specified as source.
        :param pulumi.Input[str] source_port_range: The source port or range. Integer or range between 0 and 65535. Asterisk '*' can also be used to match all ports.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] source_port_ranges: The source port ranges.
        """
        pulumi.set(__self__, "access", access)
        pulumi.set(__self__, "direction", direction)
        pulumi.set(__self__, "protocol", protocol)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if destination_address_prefix is not None:
            pulumi.set(__self__, "destination_address_prefix", destination_address_prefix)
        if destination_address_prefixes is not None:
            pulumi.set(__self__, "destination_address_prefixes", destination_address_prefixes)
        if destination_application_security_groups is not None:
            pulumi.set(__self__, "destination_application_security_groups", destination_application_security_groups)
        if destination_port_range is not None:
            pulumi.set(__self__, "destination_port_range", destination_port_range)
        if destination_port_ranges is not None:
            pulumi.set(__self__, "destination_port_ranges", destination_port_ranges)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if source_address_prefix is not None:
            pulumi.set(__self__, "source_address_prefix", source_address_prefix)
        if source_address_prefixes is not None:
            pulumi.set(__self__, "source_address_prefixes", source_address_prefixes)
        if source_application_security_groups is not None:
            pulumi.set(__self__, "source_application_security_groups", source_application_security_groups)
        if source_port_range is not None:
            pulumi.set(__self__, "source_port_range", source_port_range)
        if source_port_ranges is not None:
            pulumi.set(__self__, "source_port_ranges", source_port_ranges)

    @property
    @pulumi.getter
    def access(self) -> pulumi.Input[Union[str, 'SecurityRuleAccess']]:
        """
        The network traffic is allowed or denied.
        """
        return pulumi.get(self, "access")

    @access.setter
    def access(self, value: pulumi.Input[Union[str, 'SecurityRuleAccess']]):
        pulumi.set(self, "access", value)

    @property
    @pulumi.getter
    def direction(self) -> pulumi.Input[Union[str, 'SecurityRuleDirection']]:
        """
        The direction of the rule. The direction specifies if rule will be evaluated on incoming or outgoing traffic.
        """
        return pulumi.get(self, "direction")

    @direction.setter
    def direction(self, value: pulumi.Input[Union[str, 'SecurityRuleDirection']]):
        pulumi.set(self, "direction", value)

    @property
    @pulumi.getter
    def protocol(self) -> pulumi.Input[Union[str, 'SecurityRuleProtocol']]:
        """
        Network protocol this rule applies to.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: pulumi.Input[Union[str, 'SecurityRuleProtocol']]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        A description for this rule. Restricted to 140 chars.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="destinationAddressPrefix")
    def destination_address_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        The destination address prefix. CIDR or destination IP range. Asterisk '*' can also be used to match all source IPs. Default tags such as 'VirtualNetwork', 'AzureLoadBalancer' and 'Internet' can also be used.
        """
        return pulumi.get(self, "destination_address_prefix")

    @destination_address_prefix.setter
    def destination_address_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "destination_address_prefix", value)

    @property
    @pulumi.getter(name="destinationAddressPrefixes")
    def destination_address_prefixes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The destination address prefixes. CIDR or destination IP ranges.
        """
        return pulumi.get(self, "destination_address_prefixes")

    @destination_address_prefixes.setter
    def destination_address_prefixes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "destination_address_prefixes", value)

    @property
    @pulumi.getter(name="destinationApplicationSecurityGroups")
    def destination_application_security_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationSecurityGroupArgs']]]]:
        """
        The application security group specified as destination.
        """
        return pulumi.get(self, "destination_application_security_groups")

    @destination_application_security_groups.setter
    def destination_application_security_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationSecurityGroupArgs']]]]):
        pulumi.set(self, "destination_application_security_groups", value)

    @property
    @pulumi.getter(name="destinationPortRange")
    def destination_port_range(self) -> Optional[pulumi.Input[str]]:
        """
        The destination port or range. Integer or range between 0 and 65535. Asterisk '*' can also be used to match all ports.
        """
        return pulumi.get(self, "destination_port_range")

    @destination_port_range.setter
    def destination_port_range(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "destination_port_range", value)

    @property
    @pulumi.getter(name="destinationPortRanges")
    def destination_port_ranges(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The destination port ranges.
        """
        return pulumi.get(self, "destination_port_ranges")

    @destination_port_ranges.setter
    def destination_port_ranges(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "destination_port_ranges", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the resource that is unique within a resource group. This name can be used to access the resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[int]]:
        """
        The priority of the rule. The value can be between 100 and 4096. The priority number must be unique for each rule in the collection. The lower the priority number, the higher the priority of the rule.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "priority", value)

    @property
    @pulumi.getter(name="sourceAddressPrefix")
    def source_address_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        The CIDR or source IP range. Asterisk '*' can also be used to match all source IPs. Default tags such as 'VirtualNetwork', 'AzureLoadBalancer' and 'Internet' can also be used. If this is an ingress rule, specifies where network traffic originates from.
        """
        return pulumi.get(self, "source_address_prefix")

    @source_address_prefix.setter
    def source_address_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_address_prefix", value)

    @property
    @pulumi.getter(name="sourceAddressPrefixes")
    def source_address_prefixes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The CIDR or source IP ranges.
        """
        return pulumi.get(self, "source_address_prefixes")

    @source_address_prefixes.setter
    def source_address_prefixes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "source_address_prefixes", value)

    @property
    @pulumi.getter(name="sourceApplicationSecurityGroups")
    def source_application_security_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationSecurityGroupArgs']]]]:
        """
        The application security group specified as source.
        """
        return pulumi.get(self, "source_application_security_groups")

    @source_application_security_groups.setter
    def source_application_security_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationSecurityGroupArgs']]]]):
        pulumi.set(self, "source_application_security_groups", value)

    @property
    @pulumi.getter(name="sourcePortRange")
    def source_port_range(self) -> Optional[pulumi.Input[str]]:
        """
        The source port or range. Integer or range between 0 and 65535. Asterisk '*' can also be used to match all ports.
        """
        return pulumi.get(self, "source_port_range")

    @source_port_range.setter
    def source_port_range(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_port_range", value)

    @property
    @pulumi.getter(name="sourcePortRanges")
    def source_port_ranges(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The source port ranges.
        """
        return pulumi.get(self, "source_port_ranges")

    @source_port_ranges.setter
    def source_port_ranges(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "source_port_ranges", value)


@pulumi.input_type
class ServiceEndpointPolicyDefinitionArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 service: Optional[pulumi.Input[str]] = None,
                 service_resources: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Service Endpoint policy definitions.
        :param pulumi.Input[str] description: A description for this rule. Restricted to 140 chars.
        :param pulumi.Input[str] id: Resource ID.
        :param pulumi.Input[str] name: The name of the resource that is unique within a resource group. This name can be used to access the resource.
        :param pulumi.Input[str] service: Service endpoint name.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] service_resources: A list of service resources.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if service is not None:
            pulumi.set(__self__, "service", service)
        if service_resources is not None:
            pulumi.set(__self__, "service_resources", service_resources)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        A description for this rule. Restricted to 140 chars.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the resource that is unique within a resource group. This name can be used to access the resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def service(self) -> Optional[pulumi.Input[str]]:
        """
        Service endpoint name.
        """
        return pulumi.get(self, "service")

    @service.setter
    def service(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service", value)

    @property
    @pulumi.getter(name="serviceResources")
    def service_resources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of service resources.
        """
        return pulumi.get(self, "service_resources")

    @service_resources.setter
    def service_resources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "service_resources", value)


@pulumi.input_type
class ServiceEndpointPolicyArgs:
    def __init__(__self__, *,
                 id: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 service_endpoint_policy_definitions: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceEndpointPolicyDefinitionArgs']]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        Service End point policy resource.
        :param pulumi.Input[str] id: Resource ID.
        :param pulumi.Input[str] location: Resource location.
        :param pulumi.Input[Sequence[pulumi.Input['ServiceEndpointPolicyDefinitionArgs']]] service_endpoint_policy_definitions: A collection of service endpoint policy definitions of the service endpoint policy.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Resource tags.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if service_endpoint_policy_definitions is not None:
            pulumi.set(__self__, "service_endpoint_policy_definitions", service_endpoint_policy_definitions)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        Resource location.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="serviceEndpointPolicyDefinitions")
    def service_endpoint_policy_definitions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceEndpointPolicyDefinitionArgs']]]]:
        """
        A collection of service endpoint policy definitions of the service endpoint policy.
        """
        return pulumi.get(self, "service_endpoint_policy_definitions")

    @service_endpoint_policy_definitions.setter
    def service_endpoint_policy_definitions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceEndpointPolicyDefinitionArgs']]]]):
        pulumi.set(self, "service_endpoint_policy_definitions", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Resource tags.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class ServiceEndpointPropertiesFormatArgs:
    def __init__(__self__, *,
                 locations: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 service: Optional[pulumi.Input[str]] = None):
        """
        The service endpoint properties.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] locations: A list of locations.
        :param pulumi.Input[str] service: The type of the endpoint service.
        """
        if locations is not None:
            pulumi.set(__self__, "locations", locations)
        if service is not None:
            pulumi.set(__self__, "service", service)

    @property
    @pulumi.getter
    def locations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of locations.
        """
        return pulumi.get(self, "locations")

    @locations.setter
    def locations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "locations", value)

    @property
    @pulumi.getter
    def service(self) -> Optional[pulumi.Input[str]]:
        """
        The type of the endpoint service.
        """
        return pulumi.get(self, "service")

    @service.setter
    def service(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service", value)


@pulumi.input_type
class StaticRouteArgs:
    def __init__(__self__, *,
                 address_prefixes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 next_hop_ip_address: Optional[pulumi.Input[str]] = None):
        """
        List of all Static Routes.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] address_prefixes: List of all address prefixes.
        :param pulumi.Input[str] name: The name of the StaticRoute that is unique within a VnetRoute.
        :param pulumi.Input[str] next_hop_ip_address: The ip address of the next hop.
        """
        if address_prefixes is not None:
            pulumi.set(__self__, "address_prefixes", address_prefixes)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if next_hop_ip_address is not None:
            pulumi.set(__self__, "next_hop_ip_address", next_hop_ip_address)

    @property
    @pulumi.getter(name="addressPrefixes")
    def address_prefixes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of all address prefixes.
        """
        return pulumi.get(self, "address_prefixes")

    @address_prefixes.setter
    def address_prefixes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "address_prefixes", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the StaticRoute that is unique within a VnetRoute.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="nextHopIpAddress")
    def next_hop_ip_address(self) -> Optional[pulumi.Input[str]]:
        """
        The ip address of the next hop.
        """
        return pulumi.get(self, "next_hop_ip_address")

    @next_hop_ip_address.setter
    def next_hop_ip_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "next_hop_ip_address", value)


@pulumi.input_type
class SubResource:
    def __init__(__self__, *,
                 id: Optional[str] = None):
        """
        Reference to another subresource.
        :param str id: Resource ID.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[str]):
        pulumi.set(self, "id", value)


@pulumi.input_type
class SubResourceArgs:
    def __init__(__self__, *,
                 id: Optional[pulumi.Input[str]] = None):
        """
        Reference to another subresource.
        :param pulumi.Input[str] id: Resource ID.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)


@pulumi.input_type
class SubnetArgs:
    def __init__(__self__, *,
                 address_prefix: Optional[pulumi.Input[str]] = None,
                 address_prefixes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 delegations: Optional[pulumi.Input[Sequence[pulumi.Input['DelegationArgs']]]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 ip_allocations: Optional[pulumi.Input[Sequence[pulumi.Input['SubResourceArgs']]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 nat_gateway: Optional[pulumi.Input['SubResourceArgs']] = None,
                 network_security_group: Optional[pulumi.Input['NetworkSecurityGroupArgs']] = None,
                 private_endpoint_network_policies: Optional[pulumi.Input[str]] = None,
                 private_link_service_network_policies: Optional[pulumi.Input[str]] = None,
                 route_table: Optional[pulumi.Input['RouteTableArgs']] = None,
                 service_endpoint_policies: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceEndpointPolicyArgs']]]] = None,
                 service_endpoints: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceEndpointPropertiesFormatArgs']]]] = None):
        """
        Subnet in a virtual network resource.
        :param pulumi.Input[str] address_prefix: The address prefix for the subnet.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] address_prefixes: List of address prefixes for the subnet.
        :param pulumi.Input[Sequence[pulumi.Input['DelegationArgs']]] delegations: An array of references to the delegations on the subnet.
        :param pulumi.Input[str] id: Resource ID.
        :param pulumi.Input[Sequence[pulumi.Input['SubResourceArgs']]] ip_allocations: Array of IpAllocation which reference this subnet.
        :param pulumi.Input[str] name: The name of the resource that is unique within a resource group. This name can be used to access the resource.
        :param pulumi.Input['SubResourceArgs'] nat_gateway: Nat gateway associated with this subnet.
        :param pulumi.Input['NetworkSecurityGroupArgs'] network_security_group: The reference to the NetworkSecurityGroup resource.
        :param pulumi.Input[str] private_endpoint_network_policies: Enable or Disable apply network policies on private end point in the subnet.
        :param pulumi.Input[str] private_link_service_network_policies: Enable or Disable apply network policies on private link service in the subnet.
        :param pulumi.Input['RouteTableArgs'] route_table: The reference to the RouteTable resource.
        :param pulumi.Input[Sequence[pulumi.Input['ServiceEndpointPolicyArgs']]] service_endpoint_policies: An array of service endpoint policies.
        :param pulumi.Input[Sequence[pulumi.Input['ServiceEndpointPropertiesFormatArgs']]] service_endpoints: An array of service endpoints.
        """
        if address_prefix is not None:
            pulumi.set(__self__, "address_prefix", address_prefix)
        if address_prefixes is not None:
            pulumi.set(__self__, "address_prefixes", address_prefixes)
        if delegations is not None:
            pulumi.set(__self__, "delegations", delegations)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if ip_allocations is not None:
            pulumi.set(__self__, "ip_allocations", ip_allocations)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if nat_gateway is not None:
            pulumi.set(__self__, "nat_gateway", nat_gateway)
        if network_security_group is not None:
            pulumi.set(__self__, "network_security_group", network_security_group)
        if private_endpoint_network_policies is not None:
            pulumi.set(__self__, "private_endpoint_network_policies", private_endpoint_network_policies)
        if private_link_service_network_policies is not None:
            pulumi.set(__self__, "private_link_service_network_policies", private_link_service_network_policies)
        if route_table is not None:
            pulumi.set(__self__, "route_table", route_table)
        if service_endpoint_policies is not None:
            pulumi.set(__self__, "service_endpoint_policies", service_endpoint_policies)
        if service_endpoints is not None:
            pulumi.set(__self__, "service_endpoints", service_endpoints)

    @property
    @pulumi.getter(name="addressPrefix")
    def address_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        The address prefix for the subnet.
        """
        return pulumi.get(self, "address_prefix")

    @address_prefix.setter
    def address_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "address_prefix", value)

    @property
    @pulumi.getter(name="addressPrefixes")
    def address_prefixes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of address prefixes for the subnet.
        """
        return pulumi.get(self, "address_prefixes")

    @address_prefixes.setter
    def address_prefixes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "address_prefixes", value)

    @property
    @pulumi.getter
    def delegations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DelegationArgs']]]]:
        """
        An array of references to the delegations on the subnet.
        """
        return pulumi.get(self, "delegations")

    @delegations.setter
    def delegations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DelegationArgs']]]]):
        pulumi.set(self, "delegations", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="ipAllocations")
    def ip_allocations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SubResourceArgs']]]]:
        """
        Array of IpAllocation which reference this subnet.
        """
        return pulumi.get(self, "ip_allocations")

    @ip_allocations.setter
    def ip_allocations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SubResourceArgs']]]]):
        pulumi.set(self, "ip_allocations", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the resource that is unique within a resource group. This name can be used to access the resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="natGateway")
    def nat_gateway(self) -> Optional[pulumi.Input['SubResourceArgs']]:
        """
        Nat gateway associated with this subnet.
        """
        return pulumi.get(self, "nat_gateway")

    @nat_gateway.setter
    def nat_gateway(self, value: Optional[pulumi.Input['SubResourceArgs']]):
        pulumi.set(self, "nat_gateway", value)

    @property
    @pulumi.getter(name="networkSecurityGroup")
    def network_security_group(self) -> Optional[pulumi.Input['NetworkSecurityGroupArgs']]:
        """
        The reference to the NetworkSecurityGroup resource.
        """
        return pulumi.get(self, "network_security_group")

    @network_security_group.setter
    def network_security_group(self, value: Optional[pulumi.Input['NetworkSecurityGroupArgs']]):
        pulumi.set(self, "network_security_group", value)

    @property
    @pulumi.getter(name="privateEndpointNetworkPolicies")
    def private_endpoint_network_policies(self) -> Optional[pulumi.Input[str]]:
        """
        Enable or Disable apply network policies on private end point in the subnet.
        """
        return pulumi.get(self, "private_endpoint_network_policies")

    @private_endpoint_network_policies.setter
    def private_endpoint_network_policies(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_endpoint_network_policies", value)

    @property
    @pulumi.getter(name="privateLinkServiceNetworkPolicies")
    def private_link_service_network_policies(self) -> Optional[pulumi.Input[str]]:
        """
        Enable or Disable apply network policies on private link service in the subnet.
        """
        return pulumi.get(self, "private_link_service_network_policies")

    @private_link_service_network_policies.setter
    def private_link_service_network_policies(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_link_service_network_policies", value)

    @property
    @pulumi.getter(name="routeTable")
    def route_table(self) -> Optional[pulumi.Input['RouteTableArgs']]:
        """
        The reference to the RouteTable resource.
        """
        return pulumi.get(self, "route_table")

    @route_table.setter
    def route_table(self, value: Optional[pulumi.Input['RouteTableArgs']]):
        pulumi.set(self, "route_table", value)

    @property
    @pulumi.getter(name="serviceEndpointPolicies")
    def service_endpoint_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceEndpointPolicyArgs']]]]:
        """
        An array of service endpoint policies.
        """
        return pulumi.get(self, "service_endpoint_policies")

    @service_endpoint_policies.setter
    def service_endpoint_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceEndpointPolicyArgs']]]]):
        pulumi.set(self, "service_endpoint_policies", value)

    @property
    @pulumi.getter(name="serviceEndpoints")
    def service_endpoints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceEndpointPropertiesFormatArgs']]]]:
        """
        An array of service endpoints.
        """
        return pulumi.get(self, "service_endpoints")

    @service_endpoints.setter
    def service_endpoints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceEndpointPropertiesFormatArgs']]]]):
        pulumi.set(self, "service_endpoints", value)


@pulumi.input_type
class TrafficAnalyticsConfigurationPropertiesArgs:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 traffic_analytics_interval: Optional[pulumi.Input[int]] = None,
                 workspace_id: Optional[pulumi.Input[str]] = None,
                 workspace_region: Optional[pulumi.Input[str]] = None,
                 workspace_resource_id: Optional[pulumi.Input[str]] = None):
        """
        Parameters that define the configuration of traffic analytics.
        :param pulumi.Input[bool] enabled: Flag to enable/disable traffic analytics.
        :param pulumi.Input[int] traffic_analytics_interval: The interval in minutes which would decide how frequently TA service should do flow analytics.
        :param pulumi.Input[str] workspace_id: The resource guid of the attached workspace.
        :param pulumi.Input[str] workspace_region: The location of the attached workspace.
        :param pulumi.Input[str] workspace_resource_id: Resource Id of the attached workspace.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if traffic_analytics_interval is not None:
            pulumi.set(__self__, "traffic_analytics_interval", traffic_analytics_interval)
        if workspace_id is not None:
            pulumi.set(__self__, "workspace_id", workspace_id)
        if workspace_region is not None:
            pulumi.set(__self__, "workspace_region", workspace_region)
        if workspace_resource_id is not None:
            pulumi.set(__self__, "workspace_resource_id", workspace_resource_id)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag to enable/disable traffic analytics.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="trafficAnalyticsInterval")
    def traffic_analytics_interval(self) -> Optional[pulumi.Input[int]]:
        """
        The interval in minutes which would decide how frequently TA service should do flow analytics.
        """
        return pulumi.get(self, "traffic_analytics_interval")

    @traffic_analytics_interval.setter
    def traffic_analytics_interval(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "traffic_analytics_interval", value)

    @property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> Optional[pulumi.Input[str]]:
        """
        The resource guid of the attached workspace.
        """
        return pulumi.get(self, "workspace_id")

    @workspace_id.setter
    def workspace_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "workspace_id", value)

    @property
    @pulumi.getter(name="workspaceRegion")
    def workspace_region(self) -> Optional[pulumi.Input[str]]:
        """
        The location of the attached workspace.
        """
        return pulumi.get(self, "workspace_region")

    @workspace_region.setter
    def workspace_region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "workspace_region", value)

    @property
    @pulumi.getter(name="workspaceResourceId")
    def workspace_resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        Resource Id of the attached workspace.
        """
        return pulumi.get(self, "workspace_resource_id")

    @workspace_resource_id.setter
    def workspace_resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "workspace_resource_id", value)


@pulumi.input_type
class TrafficAnalyticsPropertiesArgs:
    def __init__(__self__, *,
                 network_watcher_flow_analytics_configuration: Optional[pulumi.Input['TrafficAnalyticsConfigurationPropertiesArgs']] = None):
        """
        Parameters that define the configuration of traffic analytics.
        :param pulumi.Input['TrafficAnalyticsConfigurationPropertiesArgs'] network_watcher_flow_analytics_configuration: Parameters that define the configuration of traffic analytics.
        """
        if network_watcher_flow_analytics_configuration is not None:
            pulumi.set(__self__, "network_watcher_flow_analytics_configuration", network_watcher_flow_analytics_configuration)

    @property
    @pulumi.getter(name="networkWatcherFlowAnalyticsConfiguration")
    def network_watcher_flow_analytics_configuration(self) -> Optional[pulumi.Input['TrafficAnalyticsConfigurationPropertiesArgs']]:
        """
        Parameters that define the configuration of traffic analytics.
        """
        return pulumi.get(self, "network_watcher_flow_analytics_configuration")

    @network_watcher_flow_analytics_configuration.setter
    def network_watcher_flow_analytics_configuration(self, value: Optional[pulumi.Input['TrafficAnalyticsConfigurationPropertiesArgs']]):
        pulumi.set(self, "network_watcher_flow_analytics_configuration", value)


@pulumi.input_type
class TrafficSelectorPolicyArgs:
    def __init__(__self__, *,
                 local_address_ranges: pulumi.Input[Sequence[pulumi.Input[str]]],
                 remote_address_ranges: pulumi.Input[Sequence[pulumi.Input[str]]]):
        """
        An traffic selector policy for a virtual network gateway connection.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] local_address_ranges: A collection of local address spaces in CIDR format.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] remote_address_ranges: A collection of remote address spaces in CIDR format.
        """
        pulumi.set(__self__, "local_address_ranges", local_address_ranges)
        pulumi.set(__self__, "remote_address_ranges", remote_address_ranges)

    @property
    @pulumi.getter(name="localAddressRanges")
    def local_address_ranges(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        A collection of local address spaces in CIDR format.
        """
        return pulumi.get(self, "local_address_ranges")

    @local_address_ranges.setter
    def local_address_ranges(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "local_address_ranges", value)

    @property
    @pulumi.getter(name="remoteAddressRanges")
    def remote_address_ranges(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        A collection of remote address spaces in CIDR format.
        """
        return pulumi.get(self, "remote_address_ranges")

    @remote_address_ranges.setter
    def remote_address_ranges(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "remote_address_ranges", value)


@pulumi.input_type
class VM:
    def __init__(__self__, *,
                 id: Optional[str] = None,
                 location: Optional[str] = None,
                 tags: Optional[Mapping[str, str]] = None):
        """
        Describes a Virtual Machine.
        :param str id: Resource ID.
        :param str location: Resource location.
        :param Mapping[str, str] tags: Resource tags.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[str]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[str]:
        """
        Resource location.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[str]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        Resource tags.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[Mapping[str, str]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class VirtualApplianceSkuPropertiesArgs:
    def __init__(__self__, *,
                 bundled_scale_unit: Optional[pulumi.Input[str]] = None,
                 market_place_version: Optional[pulumi.Input[str]] = None,
                 vendor: Optional[pulumi.Input[str]] = None):
        """
        Network Virtual Appliance Sku Properties.
        :param pulumi.Input[str] bundled_scale_unit: Virtual Appliance Scale Unit.
        :param pulumi.Input[str] market_place_version: Virtual Appliance Version.
        :param pulumi.Input[str] vendor: Virtual Appliance Vendor.
        """
        if bundled_scale_unit is not None:
            pulumi.set(__self__, "bundled_scale_unit", bundled_scale_unit)
        if market_place_version is not None:
            pulumi.set(__self__, "market_place_version", market_place_version)
        if vendor is not None:
            pulumi.set(__self__, "vendor", vendor)

    @property
    @pulumi.getter(name="bundledScaleUnit")
    def bundled_scale_unit(self) -> Optional[pulumi.Input[str]]:
        """
        Virtual Appliance Scale Unit.
        """
        return pulumi.get(self, "bundled_scale_unit")

    @bundled_scale_unit.setter
    def bundled_scale_unit(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bundled_scale_unit", value)

    @property
    @pulumi.getter(name="marketPlaceVersion")
    def market_place_version(self) -> Optional[pulumi.Input[str]]:
        """
        Virtual Appliance Version.
        """
        return pulumi.get(self, "market_place_version")

    @market_place_version.setter
    def market_place_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "market_place_version", value)

    @property
    @pulumi.getter
    def vendor(self) -> Optional[pulumi.Input[str]]:
        """
        Virtual Appliance Vendor.
        """
        return pulumi.get(self, "vendor")

    @vendor.setter
    def vendor(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vendor", value)


@pulumi.input_type
class VirtualHubIdArgs:
    def __init__(__self__, *,
                 id: Optional[pulumi.Input[str]] = None):
        """
        Virtual Hub identifier.
        :param pulumi.Input[str] id: The resource URI for the Virtual Hub where the ExpressRoute gateway is or will be deployed. The Virtual Hub resource and the ExpressRoute gateway resource reside in the same subscription.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        The resource URI for the Virtual Hub where the ExpressRoute gateway is or will be deployed. The Virtual Hub resource and the ExpressRoute gateway resource reside in the same subscription.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)


@pulumi.input_type
class VirtualHubRouteTableV2Args:
    def __init__(__self__, *,
                 attached_connections: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 routes: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualHubRouteV2Args']]]] = None):
        """
        VirtualHubRouteTableV2 Resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] attached_connections: List of all connections attached to this route table v2.
        :param pulumi.Input[str] id: Resource ID.
        :param pulumi.Input[str] name: The name of the resource that is unique within a resource group. This name can be used to access the resource.
        :param pulumi.Input[Sequence[pulumi.Input['VirtualHubRouteV2Args']]] routes: List of all routes.
        """
        if attached_connections is not None:
            pulumi.set(__self__, "attached_connections", attached_connections)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if routes is not None:
            pulumi.set(__self__, "routes", routes)

    @property
    @pulumi.getter(name="attachedConnections")
    def attached_connections(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of all connections attached to this route table v2.
        """
        return pulumi.get(self, "attached_connections")

    @attached_connections.setter
    def attached_connections(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "attached_connections", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the resource that is unique within a resource group. This name can be used to access the resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def routes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VirtualHubRouteV2Args']]]]:
        """
        List of all routes.
        """
        return pulumi.get(self, "routes")

    @routes.setter
    def routes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualHubRouteV2Args']]]]):
        pulumi.set(self, "routes", value)


@pulumi.input_type
class VirtualHubRouteTableArgs:
    def __init__(__self__, *,
                 routes: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualHubRouteArgs']]]] = None):
        """
        VirtualHub route table.
        :param pulumi.Input[Sequence[pulumi.Input['VirtualHubRouteArgs']]] routes: List of all routes.
        """
        if routes is not None:
            pulumi.set(__self__, "routes", routes)

    @property
    @pulumi.getter
    def routes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VirtualHubRouteArgs']]]]:
        """
        List of all routes.
        """
        return pulumi.get(self, "routes")

    @routes.setter
    def routes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualHubRouteArgs']]]]):
        pulumi.set(self, "routes", value)


@pulumi.input_type
class VirtualHubRouteV2Args:
    def __init__(__self__, *,
                 destination_type: Optional[pulumi.Input[str]] = None,
                 destinations: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 next_hop_type: Optional[pulumi.Input[str]] = None,
                 next_hops: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        VirtualHubRouteTableV2 route.
        :param pulumi.Input[str] destination_type: The type of destinations.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] destinations: List of all destinations.
        :param pulumi.Input[str] next_hop_type: The type of next hops.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] next_hops: NextHops ip address.
        """
        if destination_type is not None:
            pulumi.set(__self__, "destination_type", destination_type)
        if destinations is not None:
            pulumi.set(__self__, "destinations", destinations)
        if next_hop_type is not None:
            pulumi.set(__self__, "next_hop_type", next_hop_type)
        if next_hops is not None:
            pulumi.set(__self__, "next_hops", next_hops)

    @property
    @pulumi.getter(name="destinationType")
    def destination_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of destinations.
        """
        return pulumi.get(self, "destination_type")

    @destination_type.setter
    def destination_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "destination_type", value)

    @property
    @pulumi.getter
    def destinations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of all destinations.
        """
        return pulumi.get(self, "destinations")

    @destinations.setter
    def destinations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "destinations", value)

    @property
    @pulumi.getter(name="nextHopType")
    def next_hop_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of next hops.
        """
        return pulumi.get(self, "next_hop_type")

    @next_hop_type.setter
    def next_hop_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "next_hop_type", value)

    @property
    @pulumi.getter(name="nextHops")
    def next_hops(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        NextHops ip address.
        """
        return pulumi.get(self, "next_hops")

    @next_hops.setter
    def next_hops(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "next_hops", value)


@pulumi.input_type
class VirtualHubRouteArgs:
    def __init__(__self__, *,
                 address_prefixes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 next_hop_ip_address: Optional[pulumi.Input[str]] = None):
        """
        VirtualHub route.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] address_prefixes: List of all addressPrefixes.
        :param pulumi.Input[str] next_hop_ip_address: NextHop ip address.
        """
        if address_prefixes is not None:
            pulumi.set(__self__, "address_prefixes", address_prefixes)
        if next_hop_ip_address is not None:
            pulumi.set(__self__, "next_hop_ip_address", next_hop_ip_address)

    @property
    @pulumi.getter(name="addressPrefixes")
    def address_prefixes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of all addressPrefixes.
        """
        return pulumi.get(self, "address_prefixes")

    @address_prefixes.setter
    def address_prefixes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "address_prefixes", value)

    @property
    @pulumi.getter(name="nextHopIpAddress")
    def next_hop_ip_address(self) -> Optional[pulumi.Input[str]]:
        """
        NextHop ip address.
        """
        return pulumi.get(self, "next_hop_ip_address")

    @next_hop_ip_address.setter
    def next_hop_ip_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "next_hop_ip_address", value)


@pulumi.input_type
class VirtualNetworkBgpCommunitiesArgs:
    def __init__(__self__, *,
                 virtual_network_community: pulumi.Input[str]):
        """
        Bgp Communities sent over ExpressRoute with each route corresponding to a prefix in this VNET.
        :param pulumi.Input[str] virtual_network_community: The BGP community associated with the virtual network.
        """
        pulumi.set(__self__, "virtual_network_community", virtual_network_community)

    @property
    @pulumi.getter(name="virtualNetworkCommunity")
    def virtual_network_community(self) -> pulumi.Input[str]:
        """
        The BGP community associated with the virtual network.
        """
        return pulumi.get(self, "virtual_network_community")

    @virtual_network_community.setter
    def virtual_network_community(self, value: pulumi.Input[str]):
        pulumi.set(self, "virtual_network_community", value)


@pulumi.input_type
class VirtualNetworkGatewayIPConfigurationArgs:
    def __init__(__self__, *,
                 id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 private_ip_allocation_method: Optional[pulumi.Input[Union[str, 'IPAllocationMethod']]] = None,
                 public_ip_address: Optional[pulumi.Input['SubResourceArgs']] = None,
                 subnet: Optional[pulumi.Input['SubResourceArgs']] = None):
        """
        IP configuration for virtual network gateway.
        :param pulumi.Input[str] id: Resource ID.
        :param pulumi.Input[str] name: The name of the resource that is unique within a resource group. This name can be used to access the resource.
        :param pulumi.Input[Union[str, 'IPAllocationMethod']] private_ip_allocation_method: The private IP address allocation method.
        :param pulumi.Input['SubResourceArgs'] public_ip_address: The reference to the public IP resource.
        :param pulumi.Input['SubResourceArgs'] subnet: The reference to the subnet resource.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if private_ip_allocation_method is not None:
            pulumi.set(__self__, "private_ip_allocation_method", private_ip_allocation_method)
        if public_ip_address is not None:
            pulumi.set(__self__, "public_ip_address", public_ip_address)
        if subnet is not None:
            pulumi.set(__self__, "subnet", subnet)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the resource that is unique within a resource group. This name can be used to access the resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="privateIPAllocationMethod")
    def private_ip_allocation_method(self) -> Optional[pulumi.Input[Union[str, 'IPAllocationMethod']]]:
        """
        The private IP address allocation method.
        """
        return pulumi.get(self, "private_ip_allocation_method")

    @private_ip_allocation_method.setter
    def private_ip_allocation_method(self, value: Optional[pulumi.Input[Union[str, 'IPAllocationMethod']]]):
        pulumi.set(self, "private_ip_allocation_method", value)

    @property
    @pulumi.getter(name="publicIPAddress")
    def public_ip_address(self) -> Optional[pulumi.Input['SubResourceArgs']]:
        """
        The reference to the public IP resource.
        """
        return pulumi.get(self, "public_ip_address")

    @public_ip_address.setter
    def public_ip_address(self, value: Optional[pulumi.Input['SubResourceArgs']]):
        pulumi.set(self, "public_ip_address", value)

    @property
    @pulumi.getter
    def subnet(self) -> Optional[pulumi.Input['SubResourceArgs']]:
        """
        The reference to the subnet resource.
        """
        return pulumi.get(self, "subnet")

    @subnet.setter
    def subnet(self, value: Optional[pulumi.Input['SubResourceArgs']]):
        pulumi.set(self, "subnet", value)


@pulumi.input_type
class VirtualNetworkGatewaySkuArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[Union[str, 'VirtualNetworkGatewaySkuName']]] = None,
                 tier: Optional[pulumi.Input[Union[str, 'VirtualNetworkGatewaySkuTier']]] = None):
        """
        VirtualNetworkGatewaySku details.
        :param pulumi.Input[Union[str, 'VirtualNetworkGatewaySkuName']] name: Gateway SKU name.
        :param pulumi.Input[Union[str, 'VirtualNetworkGatewaySkuTier']] tier: Gateway SKU tier.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tier is not None:
            pulumi.set(__self__, "tier", tier)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[Union[str, 'VirtualNetworkGatewaySkuName']]]:
        """
        Gateway SKU name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[Union[str, 'VirtualNetworkGatewaySkuName']]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def tier(self) -> Optional[pulumi.Input[Union[str, 'VirtualNetworkGatewaySkuTier']]]:
        """
        Gateway SKU tier.
        """
        return pulumi.get(self, "tier")

    @tier.setter
    def tier(self, value: Optional[pulumi.Input[Union[str, 'VirtualNetworkGatewaySkuTier']]]):
        pulumi.set(self, "tier", value)


@pulumi.input_type
class VirtualNetworkGatewayArgs:
    def __init__(__self__, *,
                 active_active: Optional[pulumi.Input[bool]] = None,
                 bgp_settings: Optional[pulumi.Input['BgpSettingsArgs']] = None,
                 custom_routes: Optional[pulumi.Input['AddressSpaceArgs']] = None,
                 enable_bgp: Optional[pulumi.Input[bool]] = None,
                 enable_dns_forwarding: Optional[pulumi.Input[bool]] = None,
                 enable_private_ip_address: Optional[pulumi.Input[bool]] = None,
                 gateway_default_site: Optional[pulumi.Input['SubResourceArgs']] = None,
                 gateway_type: Optional[pulumi.Input[Union[str, 'VirtualNetworkGatewayType']]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 ip_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualNetworkGatewayIPConfigurationArgs']]]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 sku: Optional[pulumi.Input['VirtualNetworkGatewaySkuArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 vpn_client_configuration: Optional[pulumi.Input['VpnClientConfigurationArgs']] = None,
                 vpn_gateway_generation: Optional[pulumi.Input[Union[str, 'VpnGatewayGeneration']]] = None,
                 vpn_type: Optional[pulumi.Input[Union[str, 'VpnType']]] = None):
        """
        A common class for general resource information.
        :param pulumi.Input[bool] active_active: ActiveActive flag.
        :param pulumi.Input['BgpSettingsArgs'] bgp_settings: Virtual network gateway's BGP speaker settings.
        :param pulumi.Input['AddressSpaceArgs'] custom_routes: The reference to the address space resource which represents the custom routes address space specified by the customer for virtual network gateway and VpnClient.
        :param pulumi.Input[bool] enable_bgp: Whether BGP is enabled for this virtual network gateway or not.
        :param pulumi.Input[bool] enable_dns_forwarding: Whether dns forwarding is enabled or not.
        :param pulumi.Input[bool] enable_private_ip_address: Whether private IP needs to be enabled on this gateway for connections or not.
        :param pulumi.Input['SubResourceArgs'] gateway_default_site: The reference to the LocalNetworkGateway resource which represents local network site having default routes. Assign Null value in case of removing existing default site setting.
        :param pulumi.Input[Union[str, 'VirtualNetworkGatewayType']] gateway_type: The type of this virtual network gateway.
        :param pulumi.Input[str] id: Resource ID.
        :param pulumi.Input[Sequence[pulumi.Input['VirtualNetworkGatewayIPConfigurationArgs']]] ip_configurations: IP configurations for virtual network gateway.
        :param pulumi.Input[str] location: Resource location.
        :param pulumi.Input['VirtualNetworkGatewaySkuArgs'] sku: The reference to the VirtualNetworkGatewaySku resource which represents the SKU selected for Virtual network gateway.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Resource tags.
        :param pulumi.Input['VpnClientConfigurationArgs'] vpn_client_configuration: The reference to the VpnClientConfiguration resource which represents the P2S VpnClient configurations.
        :param pulumi.Input[Union[str, 'VpnGatewayGeneration']] vpn_gateway_generation: The generation for this VirtualNetworkGateway. Must be None if gatewayType is not VPN.
        :param pulumi.Input[Union[str, 'VpnType']] vpn_type: The type of this virtual network gateway.
        """
        if active_active is not None:
            pulumi.set(__self__, "active_active", active_active)
        if bgp_settings is not None:
            pulumi.set(__self__, "bgp_settings", bgp_settings)
        if custom_routes is not None:
            pulumi.set(__self__, "custom_routes", custom_routes)
        if enable_bgp is not None:
            pulumi.set(__self__, "enable_bgp", enable_bgp)
        if enable_dns_forwarding is not None:
            pulumi.set(__self__, "enable_dns_forwarding", enable_dns_forwarding)
        if enable_private_ip_address is not None:
            pulumi.set(__self__, "enable_private_ip_address", enable_private_ip_address)
        if gateway_default_site is not None:
            pulumi.set(__self__, "gateway_default_site", gateway_default_site)
        if gateway_type is not None:
            pulumi.set(__self__, "gateway_type", gateway_type)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if ip_configurations is not None:
            pulumi.set(__self__, "ip_configurations", ip_configurations)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if sku is not None:
            pulumi.set(__self__, "sku", sku)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if vpn_client_configuration is not None:
            pulumi.set(__self__, "vpn_client_configuration", vpn_client_configuration)
        if vpn_gateway_generation is not None:
            pulumi.set(__self__, "vpn_gateway_generation", vpn_gateway_generation)
        if vpn_type is not None:
            pulumi.set(__self__, "vpn_type", vpn_type)

    @property
    @pulumi.getter(name="activeActive")
    def active_active(self) -> Optional[pulumi.Input[bool]]:
        """
        ActiveActive flag.
        """
        return pulumi.get(self, "active_active")

    @active_active.setter
    def active_active(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "active_active", value)

    @property
    @pulumi.getter(name="bgpSettings")
    def bgp_settings(self) -> Optional[pulumi.Input['BgpSettingsArgs']]:
        """
        Virtual network gateway's BGP speaker settings.
        """
        return pulumi.get(self, "bgp_settings")

    @bgp_settings.setter
    def bgp_settings(self, value: Optional[pulumi.Input['BgpSettingsArgs']]):
        pulumi.set(self, "bgp_settings", value)

    @property
    @pulumi.getter(name="customRoutes")
    def custom_routes(self) -> Optional[pulumi.Input['AddressSpaceArgs']]:
        """
        The reference to the address space resource which represents the custom routes address space specified by the customer for virtual network gateway and VpnClient.
        """
        return pulumi.get(self, "custom_routes")

    @custom_routes.setter
    def custom_routes(self, value: Optional[pulumi.Input['AddressSpaceArgs']]):
        pulumi.set(self, "custom_routes", value)

    @property
    @pulumi.getter(name="enableBgp")
    def enable_bgp(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether BGP is enabled for this virtual network gateway or not.
        """
        return pulumi.get(self, "enable_bgp")

    @enable_bgp.setter
    def enable_bgp(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_bgp", value)

    @property
    @pulumi.getter(name="enableDnsForwarding")
    def enable_dns_forwarding(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether dns forwarding is enabled or not.
        """
        return pulumi.get(self, "enable_dns_forwarding")

    @enable_dns_forwarding.setter
    def enable_dns_forwarding(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_dns_forwarding", value)

    @property
    @pulumi.getter(name="enablePrivateIpAddress")
    def enable_private_ip_address(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether private IP needs to be enabled on this gateway for connections or not.
        """
        return pulumi.get(self, "enable_private_ip_address")

    @enable_private_ip_address.setter
    def enable_private_ip_address(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_private_ip_address", value)

    @property
    @pulumi.getter(name="gatewayDefaultSite")
    def gateway_default_site(self) -> Optional[pulumi.Input['SubResourceArgs']]:
        """
        The reference to the LocalNetworkGateway resource which represents local network site having default routes. Assign Null value in case of removing existing default site setting.
        """
        return pulumi.get(self, "gateway_default_site")

    @gateway_default_site.setter
    def gateway_default_site(self, value: Optional[pulumi.Input['SubResourceArgs']]):
        pulumi.set(self, "gateway_default_site", value)

    @property
    @pulumi.getter(name="gatewayType")
    def gateway_type(self) -> Optional[pulumi.Input[Union[str, 'VirtualNetworkGatewayType']]]:
        """
        The type of this virtual network gateway.
        """
        return pulumi.get(self, "gateway_type")

    @gateway_type.setter
    def gateway_type(self, value: Optional[pulumi.Input[Union[str, 'VirtualNetworkGatewayType']]]):
        pulumi.set(self, "gateway_type", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="ipConfigurations")
    def ip_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VirtualNetworkGatewayIPConfigurationArgs']]]]:
        """
        IP configurations for virtual network gateway.
        """
        return pulumi.get(self, "ip_configurations")

    @ip_configurations.setter
    def ip_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualNetworkGatewayIPConfigurationArgs']]]]):
        pulumi.set(self, "ip_configurations", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        Resource location.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def sku(self) -> Optional[pulumi.Input['VirtualNetworkGatewaySkuArgs']]:
        """
        The reference to the VirtualNetworkGatewaySku resource which represents the SKU selected for Virtual network gateway.
        """
        return pulumi.get(self, "sku")

    @sku.setter
    def sku(self, value: Optional[pulumi.Input['VirtualNetworkGatewaySkuArgs']]):
        pulumi.set(self, "sku", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Resource tags.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="vpnClientConfiguration")
    def vpn_client_configuration(self) -> Optional[pulumi.Input['VpnClientConfigurationArgs']]:
        """
        The reference to the VpnClientConfiguration resource which represents the P2S VpnClient configurations.
        """
        return pulumi.get(self, "vpn_client_configuration")

    @vpn_client_configuration.setter
    def vpn_client_configuration(self, value: Optional[pulumi.Input['VpnClientConfigurationArgs']]):
        pulumi.set(self, "vpn_client_configuration", value)

    @property
    @pulumi.getter(name="vpnGatewayGeneration")
    def vpn_gateway_generation(self) -> Optional[pulumi.Input[Union[str, 'VpnGatewayGeneration']]]:
        """
        The generation for this VirtualNetworkGateway. Must be None if gatewayType is not VPN.
        """
        return pulumi.get(self, "vpn_gateway_generation")

    @vpn_gateway_generation.setter
    def vpn_gateway_generation(self, value: Optional[pulumi.Input[Union[str, 'VpnGatewayGeneration']]]):
        pulumi.set(self, "vpn_gateway_generation", value)

    @property
    @pulumi.getter(name="vpnType")
    def vpn_type(self) -> Optional[pulumi.Input[Union[str, 'VpnType']]]:
        """
        The type of this virtual network gateway.
        """
        return pulumi.get(self, "vpn_type")

    @vpn_type.setter
    def vpn_type(self, value: Optional[pulumi.Input[Union[str, 'VpnType']]]):
        pulumi.set(self, "vpn_type", value)


@pulumi.input_type
class VirtualNetworkPeeringArgs:
    def __init__(__self__, *,
                 allow_forwarded_traffic: Optional[pulumi.Input[bool]] = None,
                 allow_gateway_transit: Optional[pulumi.Input[bool]] = None,
                 allow_virtual_network_access: Optional[pulumi.Input[bool]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 peering_state: Optional[pulumi.Input[Union[str, 'VirtualNetworkPeeringState']]] = None,
                 remote_address_space: Optional[pulumi.Input['AddressSpaceArgs']] = None,
                 remote_virtual_network: Optional[pulumi.Input['SubResourceArgs']] = None,
                 use_remote_gateways: Optional[pulumi.Input[bool]] = None):
        """
        Peerings in a virtual network resource.
        :param pulumi.Input[bool] allow_forwarded_traffic: Whether the forwarded traffic from the VMs in the local virtual network will be allowed/disallowed in remote virtual network.
        :param pulumi.Input[bool] allow_gateway_transit: If gateway links can be used in remote virtual networking to link to this virtual network.
        :param pulumi.Input[bool] allow_virtual_network_access: Whether the VMs in the local virtual network space would be able to access the VMs in remote virtual network space.
        :param pulumi.Input[str] id: Resource ID.
        :param pulumi.Input[str] name: The name of the resource that is unique within a resource group. This name can be used to access the resource.
        :param pulumi.Input[Union[str, 'VirtualNetworkPeeringState']] peering_state: The status of the virtual network peering.
        :param pulumi.Input['AddressSpaceArgs'] remote_address_space: The reference to the remote virtual network address space.
        :param pulumi.Input['SubResourceArgs'] remote_virtual_network: The reference to the remote virtual network. The remote virtual network can be in the same or different region (preview). See here to register for the preview and learn more (https://docs.microsoft.com/en-us/azure/virtual-network/virtual-network-create-peering).
        :param pulumi.Input[bool] use_remote_gateways: If remote gateways can be used on this virtual network. If the flag is set to true, and allowGatewayTransit on remote peering is also true, virtual network will use gateways of remote virtual network for transit. Only one peering can have this flag set to true. This flag cannot be set if virtual network already has a gateway.
        """
        if allow_forwarded_traffic is not None:
            pulumi.set(__self__, "allow_forwarded_traffic", allow_forwarded_traffic)
        if allow_gateway_transit is not None:
            pulumi.set(__self__, "allow_gateway_transit", allow_gateway_transit)
        if allow_virtual_network_access is not None:
            pulumi.set(__self__, "allow_virtual_network_access", allow_virtual_network_access)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if peering_state is not None:
            pulumi.set(__self__, "peering_state", peering_state)
        if remote_address_space is not None:
            pulumi.set(__self__, "remote_address_space", remote_address_space)
        if remote_virtual_network is not None:
            pulumi.set(__self__, "remote_virtual_network", remote_virtual_network)
        if use_remote_gateways is not None:
            pulumi.set(__self__, "use_remote_gateways", use_remote_gateways)

    @property
    @pulumi.getter(name="allowForwardedTraffic")
    def allow_forwarded_traffic(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the forwarded traffic from the VMs in the local virtual network will be allowed/disallowed in remote virtual network.
        """
        return pulumi.get(self, "allow_forwarded_traffic")

    @allow_forwarded_traffic.setter
    def allow_forwarded_traffic(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_forwarded_traffic", value)

    @property
    @pulumi.getter(name="allowGatewayTransit")
    def allow_gateway_transit(self) -> Optional[pulumi.Input[bool]]:
        """
        If gateway links can be used in remote virtual networking to link to this virtual network.
        """
        return pulumi.get(self, "allow_gateway_transit")

    @allow_gateway_transit.setter
    def allow_gateway_transit(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_gateway_transit", value)

    @property
    @pulumi.getter(name="allowVirtualNetworkAccess")
    def allow_virtual_network_access(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the VMs in the local virtual network space would be able to access the VMs in remote virtual network space.
        """
        return pulumi.get(self, "allow_virtual_network_access")

    @allow_virtual_network_access.setter
    def allow_virtual_network_access(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_virtual_network_access", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the resource that is unique within a resource group. This name can be used to access the resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="peeringState")
    def peering_state(self) -> Optional[pulumi.Input[Union[str, 'VirtualNetworkPeeringState']]]:
        """
        The status of the virtual network peering.
        """
        return pulumi.get(self, "peering_state")

    @peering_state.setter
    def peering_state(self, value: Optional[pulumi.Input[Union[str, 'VirtualNetworkPeeringState']]]):
        pulumi.set(self, "peering_state", value)

    @property
    @pulumi.getter(name="remoteAddressSpace")
    def remote_address_space(self) -> Optional[pulumi.Input['AddressSpaceArgs']]:
        """
        The reference to the remote virtual network address space.
        """
        return pulumi.get(self, "remote_address_space")

    @remote_address_space.setter
    def remote_address_space(self, value: Optional[pulumi.Input['AddressSpaceArgs']]):
        pulumi.set(self, "remote_address_space", value)

    @property
    @pulumi.getter(name="remoteVirtualNetwork")
    def remote_virtual_network(self) -> Optional[pulumi.Input['SubResourceArgs']]:
        """
        The reference to the remote virtual network. The remote virtual network can be in the same or different region (preview). See here to register for the preview and learn more (https://docs.microsoft.com/en-us/azure/virtual-network/virtual-network-create-peering).
        """
        return pulumi.get(self, "remote_virtual_network")

    @remote_virtual_network.setter
    def remote_virtual_network(self, value: Optional[pulumi.Input['SubResourceArgs']]):
        pulumi.set(self, "remote_virtual_network", value)

    @property
    @pulumi.getter(name="useRemoteGateways")
    def use_remote_gateways(self) -> Optional[pulumi.Input[bool]]:
        """
        If remote gateways can be used on this virtual network. If the flag is set to true, and allowGatewayTransit on remote peering is also true, virtual network will use gateways of remote virtual network for transit. Only one peering can have this flag set to true. This flag cannot be set if virtual network already has a gateway.
        """
        return pulumi.get(self, "use_remote_gateways")

    @use_remote_gateways.setter
    def use_remote_gateways(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "use_remote_gateways", value)


@pulumi.input_type
class VirtualNetworkTapArgs:
    def __init__(__self__, *,
                 destination_load_balancer_front_end_ip_configuration: Optional[pulumi.Input['FrontendIPConfigurationArgs']] = None,
                 destination_network_interface_ip_configuration: Optional[pulumi.Input['NetworkInterfaceIPConfigurationArgs']] = None,
                 destination_port: Optional[pulumi.Input[int]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        Virtual Network Tap resource.
        :param pulumi.Input['FrontendIPConfigurationArgs'] destination_load_balancer_front_end_ip_configuration: The reference to the private IP address on the internal Load Balancer that will receive the tap.
        :param pulumi.Input['NetworkInterfaceIPConfigurationArgs'] destination_network_interface_ip_configuration: The reference to the private IP Address of the collector nic that will receive the tap.
        :param pulumi.Input[int] destination_port: The VXLAN destination port that will receive the tapped traffic.
        :param pulumi.Input[str] id: Resource ID.
        :param pulumi.Input[str] location: Resource location.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Resource tags.
        """
        if destination_load_balancer_front_end_ip_configuration is not None:
            pulumi.set(__self__, "destination_load_balancer_front_end_ip_configuration", destination_load_balancer_front_end_ip_configuration)
        if destination_network_interface_ip_configuration is not None:
            pulumi.set(__self__, "destination_network_interface_ip_configuration", destination_network_interface_ip_configuration)
        if destination_port is not None:
            pulumi.set(__self__, "destination_port", destination_port)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="destinationLoadBalancerFrontEndIPConfiguration")
    def destination_load_balancer_front_end_ip_configuration(self) -> Optional[pulumi.Input['FrontendIPConfigurationArgs']]:
        """
        The reference to the private IP address on the internal Load Balancer that will receive the tap.
        """
        return pulumi.get(self, "destination_load_balancer_front_end_ip_configuration")

    @destination_load_balancer_front_end_ip_configuration.setter
    def destination_load_balancer_front_end_ip_configuration(self, value: Optional[pulumi.Input['FrontendIPConfigurationArgs']]):
        pulumi.set(self, "destination_load_balancer_front_end_ip_configuration", value)

    @property
    @pulumi.getter(name="destinationNetworkInterfaceIPConfiguration")
    def destination_network_interface_ip_configuration(self) -> Optional[pulumi.Input['NetworkInterfaceIPConfigurationArgs']]:
        """
        The reference to the private IP Address of the collector nic that will receive the tap.
        """
        return pulumi.get(self, "destination_network_interface_ip_configuration")

    @destination_network_interface_ip_configuration.setter
    def destination_network_interface_ip_configuration(self, value: Optional[pulumi.Input['NetworkInterfaceIPConfigurationArgs']]):
        pulumi.set(self, "destination_network_interface_ip_configuration", value)

    @property
    @pulumi.getter(name="destinationPort")
    def destination_port(self) -> Optional[pulumi.Input[int]]:
        """
        The VXLAN destination port that will receive the tapped traffic.
        """
        return pulumi.get(self, "destination_port")

    @destination_port.setter
    def destination_port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "destination_port", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        Resource location.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Resource tags.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class VnetRouteArgs:
    def __init__(__self__, *,
                 static_routes: Optional[pulumi.Input[Sequence[pulumi.Input['StaticRouteArgs']]]] = None):
        """
        List of routes that control routing from VirtualHub into a virtual network connection.
        :param pulumi.Input[Sequence[pulumi.Input['StaticRouteArgs']]] static_routes: List of all Static Routes.
        """
        if static_routes is not None:
            pulumi.set(__self__, "static_routes", static_routes)

    @property
    @pulumi.getter(name="staticRoutes")
    def static_routes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['StaticRouteArgs']]]]:
        """
        List of all Static Routes.
        """
        return pulumi.get(self, "static_routes")

    @static_routes.setter
    def static_routes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['StaticRouteArgs']]]]):
        pulumi.set(self, "static_routes", value)


@pulumi.input_type
class VpnClientConfigurationArgs:
    def __init__(__self__, *,
                 aad_audience: Optional[pulumi.Input[str]] = None,
                 aad_issuer: Optional[pulumi.Input[str]] = None,
                 aad_tenant: Optional[pulumi.Input[str]] = None,
                 radius_server_address: Optional[pulumi.Input[str]] = None,
                 radius_server_secret: Optional[pulumi.Input[str]] = None,
                 radius_servers: Optional[pulumi.Input[Sequence[pulumi.Input['RadiusServerArgs']]]] = None,
                 vpn_client_address_pool: Optional[pulumi.Input['AddressSpaceArgs']] = None,
                 vpn_client_ipsec_policies: Optional[pulumi.Input[Sequence[pulumi.Input['IpsecPolicyArgs']]]] = None,
                 vpn_client_protocols: Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'VpnClientProtocol']]]]] = None,
                 vpn_client_revoked_certificates: Optional[pulumi.Input[Sequence[pulumi.Input['VpnClientRevokedCertificateArgs']]]] = None,
                 vpn_client_root_certificates: Optional[pulumi.Input[Sequence[pulumi.Input['VpnClientRootCertificateArgs']]]] = None):
        """
        VpnClientConfiguration for P2S client.
        :param pulumi.Input[str] aad_audience: The AADAudience property of the VirtualNetworkGateway resource for vpn client connection used for AAD authentication.
        :param pulumi.Input[str] aad_issuer: The AADIssuer property of the VirtualNetworkGateway resource for vpn client connection used for AAD authentication.
        :param pulumi.Input[str] aad_tenant: The AADTenant property of the VirtualNetworkGateway resource for vpn client connection used for AAD authentication.
        :param pulumi.Input[str] radius_server_address: The radius server address property of the VirtualNetworkGateway resource for vpn client connection.
        :param pulumi.Input[str] radius_server_secret: The radius secret property of the VirtualNetworkGateway resource for vpn client connection.
        :param pulumi.Input[Sequence[pulumi.Input['RadiusServerArgs']]] radius_servers: The radiusServers property for multiple radius server configuration.
        :param pulumi.Input['AddressSpaceArgs'] vpn_client_address_pool: The reference to the address space resource which represents Address space for P2S VpnClient.
        :param pulumi.Input[Sequence[pulumi.Input['IpsecPolicyArgs']]] vpn_client_ipsec_policies: VpnClientIpsecPolicies for virtual network gateway P2S client.
        :param pulumi.Input[Sequence[pulumi.Input[Union[str, 'VpnClientProtocol']]]] vpn_client_protocols: VpnClientProtocols for Virtual network gateway.
        :param pulumi.Input[Sequence[pulumi.Input['VpnClientRevokedCertificateArgs']]] vpn_client_revoked_certificates: VpnClientRevokedCertificate for Virtual network gateway.
        :param pulumi.Input[Sequence[pulumi.Input['VpnClientRootCertificateArgs']]] vpn_client_root_certificates: VpnClientRootCertificate for virtual network gateway.
        """
        if aad_audience is not None:
            pulumi.set(__self__, "aad_audience", aad_audience)
        if aad_issuer is not None:
            pulumi.set(__self__, "aad_issuer", aad_issuer)
        if aad_tenant is not None:
            pulumi.set(__self__, "aad_tenant", aad_tenant)
        if radius_server_address is not None:
            pulumi.set(__self__, "radius_server_address", radius_server_address)
        if radius_server_secret is not None:
            pulumi.set(__self__, "radius_server_secret", radius_server_secret)
        if radius_servers is not None:
            pulumi.set(__self__, "radius_servers", radius_servers)
        if vpn_client_address_pool is not None:
            pulumi.set(__self__, "vpn_client_address_pool", vpn_client_address_pool)
        if vpn_client_ipsec_policies is not None:
            pulumi.set(__self__, "vpn_client_ipsec_policies", vpn_client_ipsec_policies)
        if vpn_client_protocols is not None:
            pulumi.set(__self__, "vpn_client_protocols", vpn_client_protocols)
        if vpn_client_revoked_certificates is not None:
            pulumi.set(__self__, "vpn_client_revoked_certificates", vpn_client_revoked_certificates)
        if vpn_client_root_certificates is not None:
            pulumi.set(__self__, "vpn_client_root_certificates", vpn_client_root_certificates)

    @property
    @pulumi.getter(name="aadAudience")
    def aad_audience(self) -> Optional[pulumi.Input[str]]:
        """
        The AADAudience property of the VirtualNetworkGateway resource for vpn client connection used for AAD authentication.
        """
        return pulumi.get(self, "aad_audience")

    @aad_audience.setter
    def aad_audience(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "aad_audience", value)

    @property
    @pulumi.getter(name="aadIssuer")
    def aad_issuer(self) -> Optional[pulumi.Input[str]]:
        """
        The AADIssuer property of the VirtualNetworkGateway resource for vpn client connection used for AAD authentication.
        """
        return pulumi.get(self, "aad_issuer")

    @aad_issuer.setter
    def aad_issuer(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "aad_issuer", value)

    @property
    @pulumi.getter(name="aadTenant")
    def aad_tenant(self) -> Optional[pulumi.Input[str]]:
        """
        The AADTenant property of the VirtualNetworkGateway resource for vpn client connection used for AAD authentication.
        """
        return pulumi.get(self, "aad_tenant")

    @aad_tenant.setter
    def aad_tenant(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "aad_tenant", value)

    @property
    @pulumi.getter(name="radiusServerAddress")
    def radius_server_address(self) -> Optional[pulumi.Input[str]]:
        """
        The radius server address property of the VirtualNetworkGateway resource for vpn client connection.
        """
        return pulumi.get(self, "radius_server_address")

    @radius_server_address.setter
    def radius_server_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "radius_server_address", value)

    @property
    @pulumi.getter(name="radiusServerSecret")
    def radius_server_secret(self) -> Optional[pulumi.Input[str]]:
        """
        The radius secret property of the VirtualNetworkGateway resource for vpn client connection.
        """
        return pulumi.get(self, "radius_server_secret")

    @radius_server_secret.setter
    def radius_server_secret(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "radius_server_secret", value)

    @property
    @pulumi.getter(name="radiusServers")
    def radius_servers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RadiusServerArgs']]]]:
        """
        The radiusServers property for multiple radius server configuration.
        """
        return pulumi.get(self, "radius_servers")

    @radius_servers.setter
    def radius_servers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RadiusServerArgs']]]]):
        pulumi.set(self, "radius_servers", value)

    @property
    @pulumi.getter(name="vpnClientAddressPool")
    def vpn_client_address_pool(self) -> Optional[pulumi.Input['AddressSpaceArgs']]:
        """
        The reference to the address space resource which represents Address space for P2S VpnClient.
        """
        return pulumi.get(self, "vpn_client_address_pool")

    @vpn_client_address_pool.setter
    def vpn_client_address_pool(self, value: Optional[pulumi.Input['AddressSpaceArgs']]):
        pulumi.set(self, "vpn_client_address_pool", value)

    @property
    @pulumi.getter(name="vpnClientIpsecPolicies")
    def vpn_client_ipsec_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IpsecPolicyArgs']]]]:
        """
        VpnClientIpsecPolicies for virtual network gateway P2S client.
        """
        return pulumi.get(self, "vpn_client_ipsec_policies")

    @vpn_client_ipsec_policies.setter
    def vpn_client_ipsec_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IpsecPolicyArgs']]]]):
        pulumi.set(self, "vpn_client_ipsec_policies", value)

    @property
    @pulumi.getter(name="vpnClientProtocols")
    def vpn_client_protocols(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'VpnClientProtocol']]]]]:
        """
        VpnClientProtocols for Virtual network gateway.
        """
        return pulumi.get(self, "vpn_client_protocols")

    @vpn_client_protocols.setter
    def vpn_client_protocols(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'VpnClientProtocol']]]]]):
        pulumi.set(self, "vpn_client_protocols", value)

    @property
    @pulumi.getter(name="vpnClientRevokedCertificates")
    def vpn_client_revoked_certificates(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VpnClientRevokedCertificateArgs']]]]:
        """
        VpnClientRevokedCertificate for Virtual network gateway.
        """
        return pulumi.get(self, "vpn_client_revoked_certificates")

    @vpn_client_revoked_certificates.setter
    def vpn_client_revoked_certificates(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VpnClientRevokedCertificateArgs']]]]):
        pulumi.set(self, "vpn_client_revoked_certificates", value)

    @property
    @pulumi.getter(name="vpnClientRootCertificates")
    def vpn_client_root_certificates(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VpnClientRootCertificateArgs']]]]:
        """
        VpnClientRootCertificate for virtual network gateway.
        """
        return pulumi.get(self, "vpn_client_root_certificates")

    @vpn_client_root_certificates.setter
    def vpn_client_root_certificates(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VpnClientRootCertificateArgs']]]]):
        pulumi.set(self, "vpn_client_root_certificates", value)


@pulumi.input_type
class VpnClientRevokedCertificateArgs:
    def __init__(__self__, *,
                 id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 thumbprint: Optional[pulumi.Input[str]] = None):
        """
        VPN client revoked certificate of virtual network gateway.
        :param pulumi.Input[str] id: Resource ID.
        :param pulumi.Input[str] name: The name of the resource that is unique within a resource group. This name can be used to access the resource.
        :param pulumi.Input[str] thumbprint: The revoked VPN client certificate thumbprint.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if thumbprint is not None:
            pulumi.set(__self__, "thumbprint", thumbprint)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the resource that is unique within a resource group. This name can be used to access the resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def thumbprint(self) -> Optional[pulumi.Input[str]]:
        """
        The revoked VPN client certificate thumbprint.
        """
        return pulumi.get(self, "thumbprint")

    @thumbprint.setter
    def thumbprint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "thumbprint", value)


@pulumi.input_type
class VpnClientRootCertificateArgs:
    def __init__(__self__, *,
                 public_cert_data: pulumi.Input[str],
                 id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        VPN client root certificate of virtual network gateway.
        :param pulumi.Input[str] public_cert_data: The certificate public data.
        :param pulumi.Input[str] id: Resource ID.
        :param pulumi.Input[str] name: The name of the resource that is unique within a resource group. This name can be used to access the resource.
        """
        pulumi.set(__self__, "public_cert_data", public_cert_data)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="publicCertData")
    def public_cert_data(self) -> pulumi.Input[str]:
        """
        The certificate public data.
        """
        return pulumi.get(self, "public_cert_data")

    @public_cert_data.setter
    def public_cert_data(self, value: pulumi.Input[str]):
        pulumi.set(self, "public_cert_data", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the resource that is unique within a resource group. This name can be used to access the resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class VpnConnectionArgs:
    def __init__(__self__, *,
                 connection_bandwidth: Optional[pulumi.Input[int]] = None,
                 dpd_timeout_seconds: Optional[pulumi.Input[int]] = None,
                 enable_bgp: Optional[pulumi.Input[bool]] = None,
                 enable_internet_security: Optional[pulumi.Input[bool]] = None,
                 enable_rate_limiting: Optional[pulumi.Input[bool]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 ipsec_policies: Optional[pulumi.Input[Sequence[pulumi.Input['IpsecPolicyArgs']]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 remote_vpn_site: Optional[pulumi.Input['SubResourceArgs']] = None,
                 routing_configuration: Optional[pulumi.Input['RoutingConfigurationArgs']] = None,
                 routing_weight: Optional[pulumi.Input[int]] = None,
                 shared_key: Optional[pulumi.Input[str]] = None,
                 use_local_azure_ip_address: Optional[pulumi.Input[bool]] = None,
                 use_policy_based_traffic_selectors: Optional[pulumi.Input[bool]] = None,
                 vpn_connection_protocol_type: Optional[pulumi.Input[Union[str, 'VirtualNetworkGatewayConnectionProtocol']]] = None,
                 vpn_link_connections: Optional[pulumi.Input[Sequence[pulumi.Input['VpnSiteLinkConnectionArgs']]]] = None):
        """
        VpnConnection Resource.
        :param pulumi.Input[int] connection_bandwidth: Expected bandwidth in MBPS.
        :param pulumi.Input[int] dpd_timeout_seconds: The dead peer detection timeout for a vpn connection in seconds.
        :param pulumi.Input[bool] enable_bgp: EnableBgp flag.
        :param pulumi.Input[bool] enable_internet_security: Enable internet security.
        :param pulumi.Input[bool] enable_rate_limiting: EnableBgp flag.
        :param pulumi.Input[str] id: Resource ID.
        :param pulumi.Input[Sequence[pulumi.Input['IpsecPolicyArgs']]] ipsec_policies: The IPSec Policies to be considered by this connection.
        :param pulumi.Input[str] name: The name of the resource that is unique within a resource group. This name can be used to access the resource.
        :param pulumi.Input['SubResourceArgs'] remote_vpn_site: Id of the connected vpn site.
        :param pulumi.Input['RoutingConfigurationArgs'] routing_configuration: The Routing Configuration indicating the associated and propagated route tables on this connection.
        :param pulumi.Input[int] routing_weight: Routing weight for vpn connection.
        :param pulumi.Input[str] shared_key: SharedKey for the vpn connection.
        :param pulumi.Input[bool] use_local_azure_ip_address: Use local azure ip to initiate connection.
        :param pulumi.Input[bool] use_policy_based_traffic_selectors: Enable policy-based traffic selectors.
        :param pulumi.Input[Union[str, 'VirtualNetworkGatewayConnectionProtocol']] vpn_connection_protocol_type: Connection protocol used for this connection.
        :param pulumi.Input[Sequence[pulumi.Input['VpnSiteLinkConnectionArgs']]] vpn_link_connections: List of all vpn site link connections to the gateway.
        """
        if connection_bandwidth is not None:
            pulumi.set(__self__, "connection_bandwidth", connection_bandwidth)
        if dpd_timeout_seconds is not None:
            pulumi.set(__self__, "dpd_timeout_seconds", dpd_timeout_seconds)
        if enable_bgp is not None:
            pulumi.set(__self__, "enable_bgp", enable_bgp)
        if enable_internet_security is not None:
            pulumi.set(__self__, "enable_internet_security", enable_internet_security)
        if enable_rate_limiting is not None:
            pulumi.set(__self__, "enable_rate_limiting", enable_rate_limiting)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if ipsec_policies is not None:
            pulumi.set(__self__, "ipsec_policies", ipsec_policies)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if remote_vpn_site is not None:
            pulumi.set(__self__, "remote_vpn_site", remote_vpn_site)
        if routing_configuration is not None:
            pulumi.set(__self__, "routing_configuration", routing_configuration)
        if routing_weight is not None:
            pulumi.set(__self__, "routing_weight", routing_weight)
        if shared_key is not None:
            pulumi.set(__self__, "shared_key", shared_key)
        if use_local_azure_ip_address is not None:
            pulumi.set(__self__, "use_local_azure_ip_address", use_local_azure_ip_address)
        if use_policy_based_traffic_selectors is not None:
            pulumi.set(__self__, "use_policy_based_traffic_selectors", use_policy_based_traffic_selectors)
        if vpn_connection_protocol_type is not None:
            pulumi.set(__self__, "vpn_connection_protocol_type", vpn_connection_protocol_type)
        if vpn_link_connections is not None:
            pulumi.set(__self__, "vpn_link_connections", vpn_link_connections)

    @property
    @pulumi.getter(name="connectionBandwidth")
    def connection_bandwidth(self) -> Optional[pulumi.Input[int]]:
        """
        Expected bandwidth in MBPS.
        """
        return pulumi.get(self, "connection_bandwidth")

    @connection_bandwidth.setter
    def connection_bandwidth(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "connection_bandwidth", value)

    @property
    @pulumi.getter(name="dpdTimeoutSeconds")
    def dpd_timeout_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        The dead peer detection timeout for a vpn connection in seconds.
        """
        return pulumi.get(self, "dpd_timeout_seconds")

    @dpd_timeout_seconds.setter
    def dpd_timeout_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "dpd_timeout_seconds", value)

    @property
    @pulumi.getter(name="enableBgp")
    def enable_bgp(self) -> Optional[pulumi.Input[bool]]:
        """
        EnableBgp flag.
        """
        return pulumi.get(self, "enable_bgp")

    @enable_bgp.setter
    def enable_bgp(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_bgp", value)

    @property
    @pulumi.getter(name="enableInternetSecurity")
    def enable_internet_security(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable internet security.
        """
        return pulumi.get(self, "enable_internet_security")

    @enable_internet_security.setter
    def enable_internet_security(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_internet_security", value)

    @property
    @pulumi.getter(name="enableRateLimiting")
    def enable_rate_limiting(self) -> Optional[pulumi.Input[bool]]:
        """
        EnableBgp flag.
        """
        return pulumi.get(self, "enable_rate_limiting")

    @enable_rate_limiting.setter
    def enable_rate_limiting(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_rate_limiting", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="ipsecPolicies")
    def ipsec_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IpsecPolicyArgs']]]]:
        """
        The IPSec Policies to be considered by this connection.
        """
        return pulumi.get(self, "ipsec_policies")

    @ipsec_policies.setter
    def ipsec_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IpsecPolicyArgs']]]]):
        pulumi.set(self, "ipsec_policies", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the resource that is unique within a resource group. This name can be used to access the resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="remoteVpnSite")
    def remote_vpn_site(self) -> Optional[pulumi.Input['SubResourceArgs']]:
        """
        Id of the connected vpn site.
        """
        return pulumi.get(self, "remote_vpn_site")

    @remote_vpn_site.setter
    def remote_vpn_site(self, value: Optional[pulumi.Input['SubResourceArgs']]):
        pulumi.set(self, "remote_vpn_site", value)

    @property
    @pulumi.getter(name="routingConfiguration")
    def routing_configuration(self) -> Optional[pulumi.Input['RoutingConfigurationArgs']]:
        """
        The Routing Configuration indicating the associated and propagated route tables on this connection.
        """
        return pulumi.get(self, "routing_configuration")

    @routing_configuration.setter
    def routing_configuration(self, value: Optional[pulumi.Input['RoutingConfigurationArgs']]):
        pulumi.set(self, "routing_configuration", value)

    @property
    @pulumi.getter(name="routingWeight")
    def routing_weight(self) -> Optional[pulumi.Input[int]]:
        """
        Routing weight for vpn connection.
        """
        return pulumi.get(self, "routing_weight")

    @routing_weight.setter
    def routing_weight(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "routing_weight", value)

    @property
    @pulumi.getter(name="sharedKey")
    def shared_key(self) -> Optional[pulumi.Input[str]]:
        """
        SharedKey for the vpn connection.
        """
        return pulumi.get(self, "shared_key")

    @shared_key.setter
    def shared_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "shared_key", value)

    @property
    @pulumi.getter(name="useLocalAzureIpAddress")
    def use_local_azure_ip_address(self) -> Optional[pulumi.Input[bool]]:
        """
        Use local azure ip to initiate connection.
        """
        return pulumi.get(self, "use_local_azure_ip_address")

    @use_local_azure_ip_address.setter
    def use_local_azure_ip_address(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "use_local_azure_ip_address", value)

    @property
    @pulumi.getter(name="usePolicyBasedTrafficSelectors")
    def use_policy_based_traffic_selectors(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable policy-based traffic selectors.
        """
        return pulumi.get(self, "use_policy_based_traffic_selectors")

    @use_policy_based_traffic_selectors.setter
    def use_policy_based_traffic_selectors(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "use_policy_based_traffic_selectors", value)

    @property
    @pulumi.getter(name="vpnConnectionProtocolType")
    def vpn_connection_protocol_type(self) -> Optional[pulumi.Input[Union[str, 'VirtualNetworkGatewayConnectionProtocol']]]:
        """
        Connection protocol used for this connection.
        """
        return pulumi.get(self, "vpn_connection_protocol_type")

    @vpn_connection_protocol_type.setter
    def vpn_connection_protocol_type(self, value: Optional[pulumi.Input[Union[str, 'VirtualNetworkGatewayConnectionProtocol']]]):
        pulumi.set(self, "vpn_connection_protocol_type", value)

    @property
    @pulumi.getter(name="vpnLinkConnections")
    def vpn_link_connections(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VpnSiteLinkConnectionArgs']]]]:
        """
        List of all vpn site link connections to the gateway.
        """
        return pulumi.get(self, "vpn_link_connections")

    @vpn_link_connections.setter
    def vpn_link_connections(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VpnSiteLinkConnectionArgs']]]]):
        pulumi.set(self, "vpn_link_connections", value)


@pulumi.input_type
class VpnLinkBgpSettingsArgs:
    def __init__(__self__, *,
                 asn: Optional[pulumi.Input[float]] = None,
                 bgp_peering_address: Optional[pulumi.Input[str]] = None):
        """
        BGP settings details for a link.
        :param pulumi.Input[float] asn: The BGP speaker's ASN.
        :param pulumi.Input[str] bgp_peering_address: The BGP peering address and BGP identifier of this BGP speaker.
        """
        if asn is not None:
            pulumi.set(__self__, "asn", asn)
        if bgp_peering_address is not None:
            pulumi.set(__self__, "bgp_peering_address", bgp_peering_address)

    @property
    @pulumi.getter
    def asn(self) -> Optional[pulumi.Input[float]]:
        """
        The BGP speaker's ASN.
        """
        return pulumi.get(self, "asn")

    @asn.setter
    def asn(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "asn", value)

    @property
    @pulumi.getter(name="bgpPeeringAddress")
    def bgp_peering_address(self) -> Optional[pulumi.Input[str]]:
        """
        The BGP peering address and BGP identifier of this BGP speaker.
        """
        return pulumi.get(self, "bgp_peering_address")

    @bgp_peering_address.setter
    def bgp_peering_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bgp_peering_address", value)


@pulumi.input_type
class VpnLinkProviderPropertiesArgs:
    def __init__(__self__, *,
                 link_provider_name: Optional[pulumi.Input[str]] = None,
                 link_speed_in_mbps: Optional[pulumi.Input[int]] = None):
        """
        List of properties of a link provider.
        :param pulumi.Input[str] link_provider_name: Name of the link provider.
        :param pulumi.Input[int] link_speed_in_mbps: Link speed.
        """
        if link_provider_name is not None:
            pulumi.set(__self__, "link_provider_name", link_provider_name)
        if link_speed_in_mbps is not None:
            pulumi.set(__self__, "link_speed_in_mbps", link_speed_in_mbps)

    @property
    @pulumi.getter(name="linkProviderName")
    def link_provider_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the link provider.
        """
        return pulumi.get(self, "link_provider_name")

    @link_provider_name.setter
    def link_provider_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "link_provider_name", value)

    @property
    @pulumi.getter(name="linkSpeedInMbps")
    def link_speed_in_mbps(self) -> Optional[pulumi.Input[int]]:
        """
        Link speed.
        """
        return pulumi.get(self, "link_speed_in_mbps")

    @link_speed_in_mbps.setter
    def link_speed_in_mbps(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "link_speed_in_mbps", value)


@pulumi.input_type
class VpnServerConfigRadiusClientRootCertificateArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 thumbprint: Optional[pulumi.Input[str]] = None):
        """
        Properties of the Radius client root certificate of VpnServerConfiguration.
        :param pulumi.Input[str] name: The certificate name.
        :param pulumi.Input[str] thumbprint: The Radius client root certificate thumbprint.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if thumbprint is not None:
            pulumi.set(__self__, "thumbprint", thumbprint)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The certificate name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def thumbprint(self) -> Optional[pulumi.Input[str]]:
        """
        The Radius client root certificate thumbprint.
        """
        return pulumi.get(self, "thumbprint")

    @thumbprint.setter
    def thumbprint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "thumbprint", value)


@pulumi.input_type
class VpnServerConfigRadiusServerRootCertificateArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 public_cert_data: Optional[pulumi.Input[str]] = None):
        """
        Properties of Radius Server root certificate of VpnServerConfiguration.
        :param pulumi.Input[str] name: The certificate name.
        :param pulumi.Input[str] public_cert_data: The certificate public data.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if public_cert_data is not None:
            pulumi.set(__self__, "public_cert_data", public_cert_data)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The certificate name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="publicCertData")
    def public_cert_data(self) -> Optional[pulumi.Input[str]]:
        """
        The certificate public data.
        """
        return pulumi.get(self, "public_cert_data")

    @public_cert_data.setter
    def public_cert_data(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "public_cert_data", value)


@pulumi.input_type
class VpnServerConfigVpnClientRevokedCertificateArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 thumbprint: Optional[pulumi.Input[str]] = None):
        """
        Properties of the revoked VPN client certificate of VpnServerConfiguration.
        :param pulumi.Input[str] name: The certificate name.
        :param pulumi.Input[str] thumbprint: The revoked VPN client certificate thumbprint.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if thumbprint is not None:
            pulumi.set(__self__, "thumbprint", thumbprint)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The certificate name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def thumbprint(self) -> Optional[pulumi.Input[str]]:
        """
        The revoked VPN client certificate thumbprint.
        """
        return pulumi.get(self, "thumbprint")

    @thumbprint.setter
    def thumbprint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "thumbprint", value)


@pulumi.input_type
class VpnServerConfigVpnClientRootCertificateArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 public_cert_data: Optional[pulumi.Input[str]] = None):
        """
        Properties of VPN client root certificate of VpnServerConfiguration.
        :param pulumi.Input[str] name: The certificate name.
        :param pulumi.Input[str] public_cert_data: The certificate public data.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if public_cert_data is not None:
            pulumi.set(__self__, "public_cert_data", public_cert_data)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The certificate name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="publicCertData")
    def public_cert_data(self) -> Optional[pulumi.Input[str]]:
        """
        The certificate public data.
        """
        return pulumi.get(self, "public_cert_data")

    @public_cert_data.setter
    def public_cert_data(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "public_cert_data", value)


@pulumi.input_type
class VpnSiteLinkConnectionArgs:
    def __init__(__self__, *,
                 connection_bandwidth: Optional[pulumi.Input[int]] = None,
                 enable_bgp: Optional[pulumi.Input[bool]] = None,
                 enable_rate_limiting: Optional[pulumi.Input[bool]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 ipsec_policies: Optional[pulumi.Input[Sequence[pulumi.Input['IpsecPolicyArgs']]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 routing_weight: Optional[pulumi.Input[int]] = None,
                 shared_key: Optional[pulumi.Input[str]] = None,
                 use_local_azure_ip_address: Optional[pulumi.Input[bool]] = None,
                 use_policy_based_traffic_selectors: Optional[pulumi.Input[bool]] = None,
                 vpn_connection_protocol_type: Optional[pulumi.Input[Union[str, 'VirtualNetworkGatewayConnectionProtocol']]] = None,
                 vpn_site_link: Optional[pulumi.Input['SubResourceArgs']] = None):
        """
        VpnSiteLinkConnection Resource.
        :param pulumi.Input[int] connection_bandwidth: Expected bandwidth in MBPS.
        :param pulumi.Input[bool] enable_bgp: EnableBgp flag.
        :param pulumi.Input[bool] enable_rate_limiting: EnableBgp flag.
        :param pulumi.Input[str] id: Resource ID.
        :param pulumi.Input[Sequence[pulumi.Input['IpsecPolicyArgs']]] ipsec_policies: The IPSec Policies to be considered by this connection.
        :param pulumi.Input[str] name: The name of the resource that is unique within a resource group. This name can be used to access the resource.
        :param pulumi.Input[int] routing_weight: Routing weight for vpn connection.
        :param pulumi.Input[str] shared_key: SharedKey for the vpn connection.
        :param pulumi.Input[bool] use_local_azure_ip_address: Use local azure ip to initiate connection.
        :param pulumi.Input[bool] use_policy_based_traffic_selectors: Enable policy-based traffic selectors.
        :param pulumi.Input[Union[str, 'VirtualNetworkGatewayConnectionProtocol']] vpn_connection_protocol_type: Connection protocol used for this connection.
        :param pulumi.Input['SubResourceArgs'] vpn_site_link: Id of the connected vpn site link.
        """
        if connection_bandwidth is not None:
            pulumi.set(__self__, "connection_bandwidth", connection_bandwidth)
        if enable_bgp is not None:
            pulumi.set(__self__, "enable_bgp", enable_bgp)
        if enable_rate_limiting is not None:
            pulumi.set(__self__, "enable_rate_limiting", enable_rate_limiting)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if ipsec_policies is not None:
            pulumi.set(__self__, "ipsec_policies", ipsec_policies)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if routing_weight is not None:
            pulumi.set(__self__, "routing_weight", routing_weight)
        if shared_key is not None:
            pulumi.set(__self__, "shared_key", shared_key)
        if use_local_azure_ip_address is not None:
            pulumi.set(__self__, "use_local_azure_ip_address", use_local_azure_ip_address)
        if use_policy_based_traffic_selectors is not None:
            pulumi.set(__self__, "use_policy_based_traffic_selectors", use_policy_based_traffic_selectors)
        if vpn_connection_protocol_type is not None:
            pulumi.set(__self__, "vpn_connection_protocol_type", vpn_connection_protocol_type)
        if vpn_site_link is not None:
            pulumi.set(__self__, "vpn_site_link", vpn_site_link)

    @property
    @pulumi.getter(name="connectionBandwidth")
    def connection_bandwidth(self) -> Optional[pulumi.Input[int]]:
        """
        Expected bandwidth in MBPS.
        """
        return pulumi.get(self, "connection_bandwidth")

    @connection_bandwidth.setter
    def connection_bandwidth(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "connection_bandwidth", value)

    @property
    @pulumi.getter(name="enableBgp")
    def enable_bgp(self) -> Optional[pulumi.Input[bool]]:
        """
        EnableBgp flag.
        """
        return pulumi.get(self, "enable_bgp")

    @enable_bgp.setter
    def enable_bgp(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_bgp", value)

    @property
    @pulumi.getter(name="enableRateLimiting")
    def enable_rate_limiting(self) -> Optional[pulumi.Input[bool]]:
        """
        EnableBgp flag.
        """
        return pulumi.get(self, "enable_rate_limiting")

    @enable_rate_limiting.setter
    def enable_rate_limiting(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_rate_limiting", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="ipsecPolicies")
    def ipsec_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IpsecPolicyArgs']]]]:
        """
        The IPSec Policies to be considered by this connection.
        """
        return pulumi.get(self, "ipsec_policies")

    @ipsec_policies.setter
    def ipsec_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IpsecPolicyArgs']]]]):
        pulumi.set(self, "ipsec_policies", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the resource that is unique within a resource group. This name can be used to access the resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="routingWeight")
    def routing_weight(self) -> Optional[pulumi.Input[int]]:
        """
        Routing weight for vpn connection.
        """
        return pulumi.get(self, "routing_weight")

    @routing_weight.setter
    def routing_weight(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "routing_weight", value)

    @property
    @pulumi.getter(name="sharedKey")
    def shared_key(self) -> Optional[pulumi.Input[str]]:
        """
        SharedKey for the vpn connection.
        """
        return pulumi.get(self, "shared_key")

    @shared_key.setter
    def shared_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "shared_key", value)

    @property
    @pulumi.getter(name="useLocalAzureIpAddress")
    def use_local_azure_ip_address(self) -> Optional[pulumi.Input[bool]]:
        """
        Use local azure ip to initiate connection.
        """
        return pulumi.get(self, "use_local_azure_ip_address")

    @use_local_azure_ip_address.setter
    def use_local_azure_ip_address(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "use_local_azure_ip_address", value)

    @property
    @pulumi.getter(name="usePolicyBasedTrafficSelectors")
    def use_policy_based_traffic_selectors(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable policy-based traffic selectors.
        """
        return pulumi.get(self, "use_policy_based_traffic_selectors")

    @use_policy_based_traffic_selectors.setter
    def use_policy_based_traffic_selectors(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "use_policy_based_traffic_selectors", value)

    @property
    @pulumi.getter(name="vpnConnectionProtocolType")
    def vpn_connection_protocol_type(self) -> Optional[pulumi.Input[Union[str, 'VirtualNetworkGatewayConnectionProtocol']]]:
        """
        Connection protocol used for this connection.
        """
        return pulumi.get(self, "vpn_connection_protocol_type")

    @vpn_connection_protocol_type.setter
    def vpn_connection_protocol_type(self, value: Optional[pulumi.Input[Union[str, 'VirtualNetworkGatewayConnectionProtocol']]]):
        pulumi.set(self, "vpn_connection_protocol_type", value)

    @property
    @pulumi.getter(name="vpnSiteLink")
    def vpn_site_link(self) -> Optional[pulumi.Input['SubResourceArgs']]:
        """
        Id of the connected vpn site link.
        """
        return pulumi.get(self, "vpn_site_link")

    @vpn_site_link.setter
    def vpn_site_link(self, value: Optional[pulumi.Input['SubResourceArgs']]):
        pulumi.set(self, "vpn_site_link", value)


@pulumi.input_type
class VpnSiteLinkArgs:
    def __init__(__self__, *,
                 bgp_properties: Optional[pulumi.Input['VpnLinkBgpSettingsArgs']] = None,
                 fqdn: Optional[pulumi.Input[str]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 ip_address: Optional[pulumi.Input[str]] = None,
                 link_properties: Optional[pulumi.Input['VpnLinkProviderPropertiesArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        VpnSiteLink Resource.
        :param pulumi.Input['VpnLinkBgpSettingsArgs'] bgp_properties: The set of bgp properties.
        :param pulumi.Input[str] fqdn: FQDN of vpn-site-link.
        :param pulumi.Input[str] id: Resource ID.
        :param pulumi.Input[str] ip_address: The ip-address for the vpn-site-link.
        :param pulumi.Input['VpnLinkProviderPropertiesArgs'] link_properties: The link provider properties.
        :param pulumi.Input[str] name: The name of the resource that is unique within a resource group. This name can be used to access the resource.
        """
        if bgp_properties is not None:
            pulumi.set(__self__, "bgp_properties", bgp_properties)
        if fqdn is not None:
            pulumi.set(__self__, "fqdn", fqdn)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if link_properties is not None:
            pulumi.set(__self__, "link_properties", link_properties)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="bgpProperties")
    def bgp_properties(self) -> Optional[pulumi.Input['VpnLinkBgpSettingsArgs']]:
        """
        The set of bgp properties.
        """
        return pulumi.get(self, "bgp_properties")

    @bgp_properties.setter
    def bgp_properties(self, value: Optional[pulumi.Input['VpnLinkBgpSettingsArgs']]):
        pulumi.set(self, "bgp_properties", value)

    @property
    @pulumi.getter
    def fqdn(self) -> Optional[pulumi.Input[str]]:
        """
        FQDN of vpn-site-link.
        """
        return pulumi.get(self, "fqdn")

    @fqdn.setter
    def fqdn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fqdn", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[pulumi.Input[str]]:
        """
        The ip-address for the vpn-site-link.
        """
        return pulumi.get(self, "ip_address")

    @ip_address.setter
    def ip_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip_address", value)

    @property
    @pulumi.getter(name="linkProperties")
    def link_properties(self) -> Optional[pulumi.Input['VpnLinkProviderPropertiesArgs']]:
        """
        The link provider properties.
        """
        return pulumi.get(self, "link_properties")

    @link_properties.setter
    def link_properties(self, value: Optional[pulumi.Input['VpnLinkProviderPropertiesArgs']]):
        pulumi.set(self, "link_properties", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the resource that is unique within a resource group. This name can be used to access the resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class WebApplicationFirewallCustomRuleArgs:
    def __init__(__self__, *,
                 action: pulumi.Input[Union[str, 'WebApplicationFirewallAction']],
                 match_conditions: pulumi.Input[Sequence[pulumi.Input['MatchConditionArgs']]],
                 priority: pulumi.Input[int],
                 rule_type: pulumi.Input[Union[str, 'WebApplicationFirewallRuleType']],
                 name: Optional[pulumi.Input[str]] = None):
        """
        Defines contents of a web application rule.
        :param pulumi.Input[Union[str, 'WebApplicationFirewallAction']] action: Type of Actions.
        :param pulumi.Input[Sequence[pulumi.Input['MatchConditionArgs']]] match_conditions: List of match conditions.
        :param pulumi.Input[int] priority: Priority of the rule. Rules with a lower value will be evaluated before rules with a higher value.
        :param pulumi.Input[Union[str, 'WebApplicationFirewallRuleType']] rule_type: The rule type.
        :param pulumi.Input[str] name: The name of the resource that is unique within a policy. This name can be used to access the resource.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "match_conditions", match_conditions)
        pulumi.set(__self__, "priority", priority)
        pulumi.set(__self__, "rule_type", rule_type)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def action(self) -> pulumi.Input[Union[str, 'WebApplicationFirewallAction']]:
        """
        Type of Actions.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: pulumi.Input[Union[str, 'WebApplicationFirewallAction']]):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter(name="matchConditions")
    def match_conditions(self) -> pulumi.Input[Sequence[pulumi.Input['MatchConditionArgs']]]:
        """
        List of match conditions.
        """
        return pulumi.get(self, "match_conditions")

    @match_conditions.setter
    def match_conditions(self, value: pulumi.Input[Sequence[pulumi.Input['MatchConditionArgs']]]):
        pulumi.set(self, "match_conditions", value)

    @property
    @pulumi.getter
    def priority(self) -> pulumi.Input[int]:
        """
        Priority of the rule. Rules with a lower value will be evaluated before rules with a higher value.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: pulumi.Input[int]):
        pulumi.set(self, "priority", value)

    @property
    @pulumi.getter(name="ruleType")
    def rule_type(self) -> pulumi.Input[Union[str, 'WebApplicationFirewallRuleType']]:
        """
        The rule type.
        """
        return pulumi.get(self, "rule_type")

    @rule_type.setter
    def rule_type(self, value: pulumi.Input[Union[str, 'WebApplicationFirewallRuleType']]):
        pulumi.set(self, "rule_type", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the resource that is unique within a policy. This name can be used to access the resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


