# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = ['ArtifactArgs', 'Artifact']

@pulumi.input_type
class ArtifactArgs:
    def __init__(__self__, *,
                 blueprint_name: pulumi.Input[str],
                 kind: pulumi.Input[Union[str, 'ArtifactKind']],
                 management_group_name: pulumi.Input[str],
                 artifact_name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Artifact resource.
        :param pulumi.Input[str] blueprint_name: name of the blueprint.
        :param pulumi.Input[Union[str, 'ArtifactKind']] kind: Specifies the kind of Blueprint artifact.
        :param pulumi.Input[str] management_group_name: ManagementGroup where blueprint stores.
        :param pulumi.Input[str] artifact_name: name of the artifact.
        """
        pulumi.set(__self__, "blueprint_name", blueprint_name)
        pulumi.set(__self__, "kind", kind)
        pulumi.set(__self__, "management_group_name", management_group_name)
        if artifact_name is not None:
            pulumi.set(__self__, "artifact_name", artifact_name)

    @property
    @pulumi.getter(name="blueprintName")
    def blueprint_name(self) -> pulumi.Input[str]:
        """
        name of the blueprint.
        """
        return pulumi.get(self, "blueprint_name")

    @blueprint_name.setter
    def blueprint_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "blueprint_name", value)

    @property
    @pulumi.getter
    def kind(self) -> pulumi.Input[Union[str, 'ArtifactKind']]:
        """
        Specifies the kind of Blueprint artifact.
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: pulumi.Input[Union[str, 'ArtifactKind']]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter(name="managementGroupName")
    def management_group_name(self) -> pulumi.Input[str]:
        """
        ManagementGroup where blueprint stores.
        """
        return pulumi.get(self, "management_group_name")

    @management_group_name.setter
    def management_group_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "management_group_name", value)

    @property
    @pulumi.getter(name="artifactName")
    def artifact_name(self) -> Optional[pulumi.Input[str]]:
        """
        name of the artifact.
        """
        return pulumi.get(self, "artifact_name")

    @artifact_name.setter
    def artifact_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "artifact_name", value)


warnings.warn("""Version 2017-11-11-preview will be removed in v2 of the provider.""", DeprecationWarning)


class Artifact(pulumi.CustomResource):
    warnings.warn("""Version 2017-11-11-preview will be removed in v2 of the provider.""", DeprecationWarning)

    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 artifact_name: Optional[pulumi.Input[str]] = None,
                 blueprint_name: Optional[pulumi.Input[str]] = None,
                 kind: Optional[pulumi.Input[Union[str, 'ArtifactKind']]] = None,
                 management_group_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Represents a Blueprint artifact.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] artifact_name: name of the artifact.
        :param pulumi.Input[str] blueprint_name: name of the blueprint.
        :param pulumi.Input[Union[str, 'ArtifactKind']] kind: Specifies the kind of Blueprint artifact.
        :param pulumi.Input[str] management_group_name: ManagementGroup where blueprint stores.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ArtifactArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Represents a Blueprint artifact.

        :param str resource_name: The name of the resource.
        :param ArtifactArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ArtifactArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 artifact_name: Optional[pulumi.Input[str]] = None,
                 blueprint_name: Optional[pulumi.Input[str]] = None,
                 kind: Optional[pulumi.Input[Union[str, 'ArtifactKind']]] = None,
                 management_group_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        pulumi.log.warn("""Artifact is deprecated: Version 2017-11-11-preview will be removed in v2 of the provider.""")
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ArtifactArgs.__new__(ArtifactArgs)

            __props__.__dict__["artifact_name"] = artifact_name
            if blueprint_name is None and not opts.urn:
                raise TypeError("Missing required property 'blueprint_name'")
            __props__.__dict__["blueprint_name"] = blueprint_name
            if kind is None and not opts.urn:
                raise TypeError("Missing required property 'kind'")
            __props__.__dict__["kind"] = kind
            if management_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'management_group_name'")
            __props__.__dict__["management_group_name"] = management_group_name
            __props__.__dict__["name"] = None
            __props__.__dict__["type"] = None
        super(Artifact, __self__).__init__(
            'azure-native:blueprint/v20171111preview:Artifact',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Artifact':
        """
        Get an existing Artifact resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = ArtifactArgs.__new__(ArtifactArgs)

        __props__.__dict__["kind"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["type"] = None
        return Artifact(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def kind(self) -> pulumi.Output[str]:
        """
        Specifies the kind of Blueprint artifact.
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of this resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        Type of this resource.
        """
        return pulumi.get(self, "type")

