# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetPolicyFragmentResult',
    'AwaitableGetPolicyFragmentResult',
    'get_policy_fragment',
    'get_policy_fragment_output',
]

@pulumi.output_type
class GetPolicyFragmentResult:
    """
    Policy fragment contract details.
    """
    def __init__(__self__, description=None, format=None, id=None, name=None, type=None, value=None):
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if format and not isinstance(format, str):
            raise TypeError("Expected argument 'format' to be a str")
        pulumi.set(__self__, "format", format)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)
        if value and not isinstance(value, str):
            raise TypeError("Expected argument 'value' to be a str")
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Policy fragment description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def format(self) -> Optional[str]:
        """
        Format of the policy fragment content.
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        Contents of the policy fragment.
        """
        return pulumi.get(self, "value")


class AwaitableGetPolicyFragmentResult(GetPolicyFragmentResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPolicyFragmentResult(
            description=self.description,
            format=self.format,
            id=self.id,
            name=self.name,
            type=self.type,
            value=self.value)


def get_policy_fragment(format: Optional[str] = None,
                        id: Optional[str] = None,
                        resource_group_name: Optional[str] = None,
                        service_name: Optional[str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPolicyFragmentResult:
    """
    Policy fragment contract details.
    API Version: 2021-12-01-preview.


    :param str format: Policy fragment content format.
    :param str id: A resource identifier.
    :param str resource_group_name: The name of the resource group.
    :param str service_name: The name of the API Management service.
    """
    __args__ = dict()
    __args__['format'] = format
    __args__['id'] = id
    __args__['resourceGroupName'] = resource_group_name
    __args__['serviceName'] = service_name
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('azure-native:apimanagement:getPolicyFragment', __args__, opts=opts, typ=GetPolicyFragmentResult).value

    return AwaitableGetPolicyFragmentResult(
        description=__ret__.description,
        format=__ret__.format,
        id=__ret__.id,
        name=__ret__.name,
        type=__ret__.type,
        value=__ret__.value)


@_utilities.lift_output_func(get_policy_fragment)
def get_policy_fragment_output(format: Optional[pulumi.Input[Optional[str]]] = None,
                               id: Optional[pulumi.Input[str]] = None,
                               resource_group_name: Optional[pulumi.Input[str]] = None,
                               service_name: Optional[pulumi.Input[str]] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetPolicyFragmentResult]:
    """
    Policy fragment contract details.
    API Version: 2021-12-01-preview.


    :param str format: Policy fragment content format.
    :param str id: A resource identifier.
    :param str resource_group_name: The name of the resource group.
    :param str service_name: The name of the API Management service.
    """
    ...
