# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'AdditionalFeaturesServerConfigurationsResponse',
    'AgConfigurationResponse',
    'AgReplicaResponse',
    'AssessmentSettingsResponse',
    'AutoBackupSettingsResponse',
    'AutoPatchingSettingsResponse',
    'KeyVaultCredentialSettingsResponse',
    'LoadBalancerConfigurationResponse',
    'MultiSubnetIpConfigurationResponse',
    'PrivateIPAddressResponse',
    'ResourceIdentityResponse',
    'SQLInstanceSettingsResponse',
    'SQLStorageSettingsResponse',
    'SQLTempDbSettingsResponse',
    'ScheduleResponse',
    'ServerConfigurationsManagementSettingsResponse',
    'SqlConnectivityUpdateSettingsResponse',
    'SqlStorageUpdateSettingsResponse',
    'SqlWorkloadTypeUpdateSettingsResponse',
    'StorageConfigurationSettingsResponse',
    'SystemDataResponse',
    'WsfcDomainCredentialsResponse',
    'WsfcDomainProfileResponse',
]

@pulumi.output_type
class AdditionalFeaturesServerConfigurationsResponse(dict):
    """
    Additional SQL Server feature settings.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isRServicesEnabled":
            suggest = "is_r_services_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AdditionalFeaturesServerConfigurationsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AdditionalFeaturesServerConfigurationsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AdditionalFeaturesServerConfigurationsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 is_r_services_enabled: Optional[bool] = None):
        """
        Additional SQL Server feature settings.
        :param bool is_r_services_enabled: Enable or disable R services (SQL 2016 onwards).
        """
        if is_r_services_enabled is not None:
            pulumi.set(__self__, "is_r_services_enabled", is_r_services_enabled)

    @property
    @pulumi.getter(name="isRServicesEnabled")
    def is_r_services_enabled(self) -> Optional[bool]:
        """
        Enable or disable R services (SQL 2016 onwards).
        """
        return pulumi.get(self, "is_r_services_enabled")


@pulumi.output_type
class AgConfigurationResponse(dict):
    """
    Availability group configuration.
    """
    def __init__(__self__, *,
                 replicas: Optional[Sequence['outputs.AgReplicaResponse']] = None):
        """
        Availability group configuration.
        :param Sequence['AgReplicaResponse'] replicas: Replica configurations.
        """
        if replicas is not None:
            pulumi.set(__self__, "replicas", replicas)

    @property
    @pulumi.getter
    def replicas(self) -> Optional[Sequence['outputs.AgReplicaResponse']]:
        """
        Replica configurations.
        """
        return pulumi.get(self, "replicas")


@pulumi.output_type
class AgReplicaResponse(dict):
    """
    Availability group replica configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "readableSecondary":
            suggest = "readable_secondary"
        elif key == "sqlVirtualMachineInstanceId":
            suggest = "sql_virtual_machine_instance_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AgReplicaResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AgReplicaResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AgReplicaResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 commit: Optional[str] = None,
                 failover: Optional[str] = None,
                 readable_secondary: Optional[str] = None,
                 role: Optional[str] = None,
                 sql_virtual_machine_instance_id: Optional[str] = None):
        """
        Availability group replica configuration.
        :param str commit: Replica commit mode in availability group.
        :param str failover: Replica failover mode in availability group.
        :param str readable_secondary: Replica readable secondary mode in availability group.
        :param str role: Replica Role in availability group.
        :param str sql_virtual_machine_instance_id: Sql VirtualMachine Instance Id.
        """
        if commit is not None:
            pulumi.set(__self__, "commit", commit)
        if failover is not None:
            pulumi.set(__self__, "failover", failover)
        if readable_secondary is not None:
            pulumi.set(__self__, "readable_secondary", readable_secondary)
        if role is not None:
            pulumi.set(__self__, "role", role)
        if sql_virtual_machine_instance_id is not None:
            pulumi.set(__self__, "sql_virtual_machine_instance_id", sql_virtual_machine_instance_id)

    @property
    @pulumi.getter
    def commit(self) -> Optional[str]:
        """
        Replica commit mode in availability group.
        """
        return pulumi.get(self, "commit")

    @property
    @pulumi.getter
    def failover(self) -> Optional[str]:
        """
        Replica failover mode in availability group.
        """
        return pulumi.get(self, "failover")

    @property
    @pulumi.getter(name="readableSecondary")
    def readable_secondary(self) -> Optional[str]:
        """
        Replica readable secondary mode in availability group.
        """
        return pulumi.get(self, "readable_secondary")

    @property
    @pulumi.getter
    def role(self) -> Optional[str]:
        """
        Replica Role in availability group.
        """
        return pulumi.get(self, "role")

    @property
    @pulumi.getter(name="sqlVirtualMachineInstanceId")
    def sql_virtual_machine_instance_id(self) -> Optional[str]:
        """
        Sql VirtualMachine Instance Id.
        """
        return pulumi.get(self, "sql_virtual_machine_instance_id")


@pulumi.output_type
class AssessmentSettingsResponse(dict):
    """
    Configure assessment for databases in your SQL virtual machine.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "runImmediately":
            suggest = "run_immediately"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AssessmentSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AssessmentSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AssessmentSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enable: Optional[bool] = None,
                 run_immediately: Optional[bool] = None,
                 schedule: Optional['outputs.ScheduleResponse'] = None):
        """
        Configure assessment for databases in your SQL virtual machine.
        :param bool enable: Enable or disable assessment feature on SQL virtual machine.
        :param bool run_immediately: Run assessment immediately on SQL virtual machine.
        :param 'ScheduleResponse' schedule: Schedule for Assessment.
        """
        if enable is not None:
            pulumi.set(__self__, "enable", enable)
        if run_immediately is not None:
            pulumi.set(__self__, "run_immediately", run_immediately)
        if schedule is not None:
            pulumi.set(__self__, "schedule", schedule)

    @property
    @pulumi.getter
    def enable(self) -> Optional[bool]:
        """
        Enable or disable assessment feature on SQL virtual machine.
        """
        return pulumi.get(self, "enable")

    @property
    @pulumi.getter(name="runImmediately")
    def run_immediately(self) -> Optional[bool]:
        """
        Run assessment immediately on SQL virtual machine.
        """
        return pulumi.get(self, "run_immediately")

    @property
    @pulumi.getter
    def schedule(self) -> Optional['outputs.ScheduleResponse']:
        """
        Schedule for Assessment.
        """
        return pulumi.get(self, "schedule")


@pulumi.output_type
class AutoBackupSettingsResponse(dict):
    """
    Configure backups for databases in your SQL virtual machine.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backupScheduleType":
            suggest = "backup_schedule_type"
        elif key == "backupSystemDbs":
            suggest = "backup_system_dbs"
        elif key == "daysOfWeek":
            suggest = "days_of_week"
        elif key == "enableEncryption":
            suggest = "enable_encryption"
        elif key == "fullBackupFrequency":
            suggest = "full_backup_frequency"
        elif key == "fullBackupStartTime":
            suggest = "full_backup_start_time"
        elif key == "fullBackupWindowHours":
            suggest = "full_backup_window_hours"
        elif key == "logBackupFrequency":
            suggest = "log_backup_frequency"
        elif key == "retentionPeriod":
            suggest = "retention_period"
        elif key == "storageAccountUrl":
            suggest = "storage_account_url"
        elif key == "storageContainerName":
            suggest = "storage_container_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AutoBackupSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AutoBackupSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AutoBackupSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backup_schedule_type: Optional[str] = None,
                 backup_system_dbs: Optional[bool] = None,
                 days_of_week: Optional[Sequence[str]] = None,
                 enable: Optional[bool] = None,
                 enable_encryption: Optional[bool] = None,
                 full_backup_frequency: Optional[str] = None,
                 full_backup_start_time: Optional[int] = None,
                 full_backup_window_hours: Optional[int] = None,
                 log_backup_frequency: Optional[int] = None,
                 retention_period: Optional[int] = None,
                 storage_account_url: Optional[str] = None,
                 storage_container_name: Optional[str] = None):
        """
        Configure backups for databases in your SQL virtual machine.
        :param str backup_schedule_type: Backup schedule type.
        :param bool backup_system_dbs: Include or exclude system databases from auto backup.
        :param Sequence[str] days_of_week: Days of the week for the backups when FullBackupFrequency is set to Weekly.
        :param bool enable: Enable or disable autobackup on SQL virtual machine.
        :param bool enable_encryption: Enable or disable encryption for backup on SQL virtual machine.
        :param str full_backup_frequency: Frequency of full backups. In both cases, full backups begin during the next scheduled time window.
        :param int full_backup_start_time: Start time of a given day during which full backups can take place. 0-23 hours.
        :param int full_backup_window_hours: Duration of the time window of a given day during which full backups can take place. 1-23 hours.
        :param int log_backup_frequency: Frequency of log backups. 5-60 minutes.
        :param int retention_period: Retention period of backup: 1-90 days.
        :param str storage_account_url: Storage account url where backup will be taken to.
        :param str storage_container_name: Storage container name where backup will be taken to.
        """
        if backup_schedule_type is not None:
            pulumi.set(__self__, "backup_schedule_type", backup_schedule_type)
        if backup_system_dbs is not None:
            pulumi.set(__self__, "backup_system_dbs", backup_system_dbs)
        if days_of_week is not None:
            pulumi.set(__self__, "days_of_week", days_of_week)
        if enable is not None:
            pulumi.set(__self__, "enable", enable)
        if enable_encryption is not None:
            pulumi.set(__self__, "enable_encryption", enable_encryption)
        if full_backup_frequency is not None:
            pulumi.set(__self__, "full_backup_frequency", full_backup_frequency)
        if full_backup_start_time is not None:
            pulumi.set(__self__, "full_backup_start_time", full_backup_start_time)
        if full_backup_window_hours is not None:
            pulumi.set(__self__, "full_backup_window_hours", full_backup_window_hours)
        if log_backup_frequency is not None:
            pulumi.set(__self__, "log_backup_frequency", log_backup_frequency)
        if retention_period is not None:
            pulumi.set(__self__, "retention_period", retention_period)
        if storage_account_url is not None:
            pulumi.set(__self__, "storage_account_url", storage_account_url)
        if storage_container_name is not None:
            pulumi.set(__self__, "storage_container_name", storage_container_name)

    @property
    @pulumi.getter(name="backupScheduleType")
    def backup_schedule_type(self) -> Optional[str]:
        """
        Backup schedule type.
        """
        return pulumi.get(self, "backup_schedule_type")

    @property
    @pulumi.getter(name="backupSystemDbs")
    def backup_system_dbs(self) -> Optional[bool]:
        """
        Include or exclude system databases from auto backup.
        """
        return pulumi.get(self, "backup_system_dbs")

    @property
    @pulumi.getter(name="daysOfWeek")
    def days_of_week(self) -> Optional[Sequence[str]]:
        """
        Days of the week for the backups when FullBackupFrequency is set to Weekly.
        """
        return pulumi.get(self, "days_of_week")

    @property
    @pulumi.getter
    def enable(self) -> Optional[bool]:
        """
        Enable or disable autobackup on SQL virtual machine.
        """
        return pulumi.get(self, "enable")

    @property
    @pulumi.getter(name="enableEncryption")
    def enable_encryption(self) -> Optional[bool]:
        """
        Enable or disable encryption for backup on SQL virtual machine.
        """
        return pulumi.get(self, "enable_encryption")

    @property
    @pulumi.getter(name="fullBackupFrequency")
    def full_backup_frequency(self) -> Optional[str]:
        """
        Frequency of full backups. In both cases, full backups begin during the next scheduled time window.
        """
        return pulumi.get(self, "full_backup_frequency")

    @property
    @pulumi.getter(name="fullBackupStartTime")
    def full_backup_start_time(self) -> Optional[int]:
        """
        Start time of a given day during which full backups can take place. 0-23 hours.
        """
        return pulumi.get(self, "full_backup_start_time")

    @property
    @pulumi.getter(name="fullBackupWindowHours")
    def full_backup_window_hours(self) -> Optional[int]:
        """
        Duration of the time window of a given day during which full backups can take place. 1-23 hours.
        """
        return pulumi.get(self, "full_backup_window_hours")

    @property
    @pulumi.getter(name="logBackupFrequency")
    def log_backup_frequency(self) -> Optional[int]:
        """
        Frequency of log backups. 5-60 minutes.
        """
        return pulumi.get(self, "log_backup_frequency")

    @property
    @pulumi.getter(name="retentionPeriod")
    def retention_period(self) -> Optional[int]:
        """
        Retention period of backup: 1-90 days.
        """
        return pulumi.get(self, "retention_period")

    @property
    @pulumi.getter(name="storageAccountUrl")
    def storage_account_url(self) -> Optional[str]:
        """
        Storage account url where backup will be taken to.
        """
        return pulumi.get(self, "storage_account_url")

    @property
    @pulumi.getter(name="storageContainerName")
    def storage_container_name(self) -> Optional[str]:
        """
        Storage container name where backup will be taken to.
        """
        return pulumi.get(self, "storage_container_name")


@pulumi.output_type
class AutoPatchingSettingsResponse(dict):
    """
    Set a patching window during which Windows and SQL patches will be applied.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dayOfWeek":
            suggest = "day_of_week"
        elif key == "maintenanceWindowDuration":
            suggest = "maintenance_window_duration"
        elif key == "maintenanceWindowStartingHour":
            suggest = "maintenance_window_starting_hour"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AutoPatchingSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AutoPatchingSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AutoPatchingSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 day_of_week: Optional[str] = None,
                 enable: Optional[bool] = None,
                 maintenance_window_duration: Optional[int] = None,
                 maintenance_window_starting_hour: Optional[int] = None):
        """
        Set a patching window during which Windows and SQL patches will be applied.
        :param str day_of_week: Day of week to apply the patch on.
        :param bool enable: Enable or disable autopatching on SQL virtual machine.
        :param int maintenance_window_duration: Duration of patching.
        :param int maintenance_window_starting_hour: Hour of the day when patching is initiated. Local VM time.
        """
        if day_of_week is not None:
            pulumi.set(__self__, "day_of_week", day_of_week)
        if enable is not None:
            pulumi.set(__self__, "enable", enable)
        if maintenance_window_duration is not None:
            pulumi.set(__self__, "maintenance_window_duration", maintenance_window_duration)
        if maintenance_window_starting_hour is not None:
            pulumi.set(__self__, "maintenance_window_starting_hour", maintenance_window_starting_hour)

    @property
    @pulumi.getter(name="dayOfWeek")
    def day_of_week(self) -> Optional[str]:
        """
        Day of week to apply the patch on.
        """
        return pulumi.get(self, "day_of_week")

    @property
    @pulumi.getter
    def enable(self) -> Optional[bool]:
        """
        Enable or disable autopatching on SQL virtual machine.
        """
        return pulumi.get(self, "enable")

    @property
    @pulumi.getter(name="maintenanceWindowDuration")
    def maintenance_window_duration(self) -> Optional[int]:
        """
        Duration of patching.
        """
        return pulumi.get(self, "maintenance_window_duration")

    @property
    @pulumi.getter(name="maintenanceWindowStartingHour")
    def maintenance_window_starting_hour(self) -> Optional[int]:
        """
        Hour of the day when patching is initiated. Local VM time.
        """
        return pulumi.get(self, "maintenance_window_starting_hour")


@pulumi.output_type
class KeyVaultCredentialSettingsResponse(dict):
    """
    Configure your SQL virtual machine to be able to connect to the Azure Key Vault service.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "azureKeyVaultUrl":
            suggest = "azure_key_vault_url"
        elif key == "credentialName":
            suggest = "credential_name"
        elif key == "servicePrincipalName":
            suggest = "service_principal_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KeyVaultCredentialSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KeyVaultCredentialSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KeyVaultCredentialSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 azure_key_vault_url: Optional[str] = None,
                 credential_name: Optional[str] = None,
                 enable: Optional[bool] = None,
                 service_principal_name: Optional[str] = None):
        """
        Configure your SQL virtual machine to be able to connect to the Azure Key Vault service.
        :param str azure_key_vault_url: Azure Key Vault url.
        :param str credential_name: Credential name.
        :param bool enable: Enable or disable key vault credential setting.
        :param str service_principal_name: Service principal name to access key vault.
        """
        if azure_key_vault_url is not None:
            pulumi.set(__self__, "azure_key_vault_url", azure_key_vault_url)
        if credential_name is not None:
            pulumi.set(__self__, "credential_name", credential_name)
        if enable is not None:
            pulumi.set(__self__, "enable", enable)
        if service_principal_name is not None:
            pulumi.set(__self__, "service_principal_name", service_principal_name)

    @property
    @pulumi.getter(name="azureKeyVaultUrl")
    def azure_key_vault_url(self) -> Optional[str]:
        """
        Azure Key Vault url.
        """
        return pulumi.get(self, "azure_key_vault_url")

    @property
    @pulumi.getter(name="credentialName")
    def credential_name(self) -> Optional[str]:
        """
        Credential name.
        """
        return pulumi.get(self, "credential_name")

    @property
    @pulumi.getter
    def enable(self) -> Optional[bool]:
        """
        Enable or disable key vault credential setting.
        """
        return pulumi.get(self, "enable")

    @property
    @pulumi.getter(name="servicePrincipalName")
    def service_principal_name(self) -> Optional[str]:
        """
        Service principal name to access key vault.
        """
        return pulumi.get(self, "service_principal_name")


@pulumi.output_type
class LoadBalancerConfigurationResponse(dict):
    """
    A load balancer configuration for an availability group listener.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "loadBalancerResourceId":
            suggest = "load_balancer_resource_id"
        elif key == "privateIpAddress":
            suggest = "private_ip_address"
        elif key == "probePort":
            suggest = "probe_port"
        elif key == "publicIpAddressResourceId":
            suggest = "public_ip_address_resource_id"
        elif key == "sqlVirtualMachineInstances":
            suggest = "sql_virtual_machine_instances"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LoadBalancerConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LoadBalancerConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LoadBalancerConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 load_balancer_resource_id: Optional[str] = None,
                 private_ip_address: Optional['outputs.PrivateIPAddressResponse'] = None,
                 probe_port: Optional[int] = None,
                 public_ip_address_resource_id: Optional[str] = None,
                 sql_virtual_machine_instances: Optional[Sequence[str]] = None):
        """
        A load balancer configuration for an availability group listener.
        :param str load_balancer_resource_id: Resource id of the load balancer.
        :param 'PrivateIPAddressResponse' private_ip_address: Private IP address.
        :param int probe_port: Probe port.
        :param str public_ip_address_resource_id: Resource id of the public IP.
        :param Sequence[str] sql_virtual_machine_instances: List of the SQL virtual machine instance resource id's that are enrolled into the availability group listener.
        """
        if load_balancer_resource_id is not None:
            pulumi.set(__self__, "load_balancer_resource_id", load_balancer_resource_id)
        if private_ip_address is not None:
            pulumi.set(__self__, "private_ip_address", private_ip_address)
        if probe_port is not None:
            pulumi.set(__self__, "probe_port", probe_port)
        if public_ip_address_resource_id is not None:
            pulumi.set(__self__, "public_ip_address_resource_id", public_ip_address_resource_id)
        if sql_virtual_machine_instances is not None:
            pulumi.set(__self__, "sql_virtual_machine_instances", sql_virtual_machine_instances)

    @property
    @pulumi.getter(name="loadBalancerResourceId")
    def load_balancer_resource_id(self) -> Optional[str]:
        """
        Resource id of the load balancer.
        """
        return pulumi.get(self, "load_balancer_resource_id")

    @property
    @pulumi.getter(name="privateIpAddress")
    def private_ip_address(self) -> Optional['outputs.PrivateIPAddressResponse']:
        """
        Private IP address.
        """
        return pulumi.get(self, "private_ip_address")

    @property
    @pulumi.getter(name="probePort")
    def probe_port(self) -> Optional[int]:
        """
        Probe port.
        """
        return pulumi.get(self, "probe_port")

    @property
    @pulumi.getter(name="publicIpAddressResourceId")
    def public_ip_address_resource_id(self) -> Optional[str]:
        """
        Resource id of the public IP.
        """
        return pulumi.get(self, "public_ip_address_resource_id")

    @property
    @pulumi.getter(name="sqlVirtualMachineInstances")
    def sql_virtual_machine_instances(self) -> Optional[Sequence[str]]:
        """
        List of the SQL virtual machine instance resource id's that are enrolled into the availability group listener.
        """
        return pulumi.get(self, "sql_virtual_machine_instances")


@pulumi.output_type
class MultiSubnetIpConfigurationResponse(dict):
    """
    Multi subnet ip configuration for an availability group listener.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "privateIpAddress":
            suggest = "private_ip_address"
        elif key == "sqlVirtualMachineInstance":
            suggest = "sql_virtual_machine_instance"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MultiSubnetIpConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MultiSubnetIpConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MultiSubnetIpConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 private_ip_address: 'outputs.PrivateIPAddressResponse',
                 sql_virtual_machine_instance: str):
        """
        Multi subnet ip configuration for an availability group listener.
        :param 'PrivateIPAddressResponse' private_ip_address: Private IP address.
        :param str sql_virtual_machine_instance: SQL virtual machine instance resource id that are enrolled into the availability group listener.
        """
        pulumi.set(__self__, "private_ip_address", private_ip_address)
        pulumi.set(__self__, "sql_virtual_machine_instance", sql_virtual_machine_instance)

    @property
    @pulumi.getter(name="privateIpAddress")
    def private_ip_address(self) -> 'outputs.PrivateIPAddressResponse':
        """
        Private IP address.
        """
        return pulumi.get(self, "private_ip_address")

    @property
    @pulumi.getter(name="sqlVirtualMachineInstance")
    def sql_virtual_machine_instance(self) -> str:
        """
        SQL virtual machine instance resource id that are enrolled into the availability group listener.
        """
        return pulumi.get(self, "sql_virtual_machine_instance")


@pulumi.output_type
class PrivateIPAddressResponse(dict):
    """
    A private IP address bound to the availability group listener.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipAddress":
            suggest = "ip_address"
        elif key == "subnetResourceId":
            suggest = "subnet_resource_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PrivateIPAddressResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PrivateIPAddressResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PrivateIPAddressResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ip_address: Optional[str] = None,
                 subnet_resource_id: Optional[str] = None):
        """
        A private IP address bound to the availability group listener.
        :param str ip_address: Private IP address bound to the availability group listener.
        :param str subnet_resource_id: Subnet used to include private IP.
        """
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if subnet_resource_id is not None:
            pulumi.set(__self__, "subnet_resource_id", subnet_resource_id)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[str]:
        """
        Private IP address bound to the availability group listener.
        """
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter(name="subnetResourceId")
    def subnet_resource_id(self) -> Optional[str]:
        """
        Subnet used to include private IP.
        """
        return pulumi.get(self, "subnet_resource_id")


@pulumi.output_type
class ResourceIdentityResponse(dict):
    """
    Azure Active Directory identity configuration for a resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "principalId":
            suggest = "principal_id"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourceIdentityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourceIdentityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourceIdentityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 principal_id: str,
                 tenant_id: str,
                 type: Optional[str] = None):
        """
        Azure Active Directory identity configuration for a resource.
        :param str principal_id: The Azure Active Directory principal id.
        :param str tenant_id: The Azure Active Directory tenant id.
        :param str type: The identity type. Set this to 'SystemAssigned' in order to automatically create and assign an Azure Active Directory principal for the resource.
        """
        pulumi.set(__self__, "principal_id", principal_id)
        pulumi.set(__self__, "tenant_id", tenant_id)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> str:
        """
        The Azure Active Directory principal id.
        """
        return pulumi.get(self, "principal_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> str:
        """
        The Azure Active Directory tenant id.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The identity type. Set this to 'SystemAssigned' in order to automatically create and assign an Azure Active Directory principal for the resource.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class SQLInstanceSettingsResponse(dict):
    """
    Set the server/instance-level settings for SQL Server.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isIfiEnabled":
            suggest = "is_ifi_enabled"
        elif key == "isLpimEnabled":
            suggest = "is_lpim_enabled"
        elif key == "isOptimizeForAdHocWorkloadsEnabled":
            suggest = "is_optimize_for_ad_hoc_workloads_enabled"
        elif key == "maxDop":
            suggest = "max_dop"
        elif key == "maxServerMemoryMB":
            suggest = "max_server_memory_mb"
        elif key == "minServerMemoryMB":
            suggest = "min_server_memory_mb"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SQLInstanceSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SQLInstanceSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SQLInstanceSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 collation: Optional[str] = None,
                 is_ifi_enabled: Optional[bool] = None,
                 is_lpim_enabled: Optional[bool] = None,
                 is_optimize_for_ad_hoc_workloads_enabled: Optional[bool] = None,
                 max_dop: Optional[int] = None,
                 max_server_memory_mb: Optional[int] = None,
                 min_server_memory_mb: Optional[int] = None):
        """
        Set the server/instance-level settings for SQL Server.
        :param str collation: SQL Server Collation.
        :param bool is_ifi_enabled: SQL Server IFI.
        :param bool is_lpim_enabled: SQL Server LPIM.
        :param bool is_optimize_for_ad_hoc_workloads_enabled: SQL Server Optimize for Adhoc workloads.
        :param int max_dop: SQL Server MAXDOP.
        :param int max_server_memory_mb: SQL Server maximum memory.
        :param int min_server_memory_mb: SQL Server minimum memory.
        """
        if collation is not None:
            pulumi.set(__self__, "collation", collation)
        if is_ifi_enabled is not None:
            pulumi.set(__self__, "is_ifi_enabled", is_ifi_enabled)
        if is_lpim_enabled is not None:
            pulumi.set(__self__, "is_lpim_enabled", is_lpim_enabled)
        if is_optimize_for_ad_hoc_workloads_enabled is not None:
            pulumi.set(__self__, "is_optimize_for_ad_hoc_workloads_enabled", is_optimize_for_ad_hoc_workloads_enabled)
        if max_dop is not None:
            pulumi.set(__self__, "max_dop", max_dop)
        if max_server_memory_mb is not None:
            pulumi.set(__self__, "max_server_memory_mb", max_server_memory_mb)
        if min_server_memory_mb is not None:
            pulumi.set(__self__, "min_server_memory_mb", min_server_memory_mb)

    @property
    @pulumi.getter
    def collation(self) -> Optional[str]:
        """
        SQL Server Collation.
        """
        return pulumi.get(self, "collation")

    @property
    @pulumi.getter(name="isIfiEnabled")
    def is_ifi_enabled(self) -> Optional[bool]:
        """
        SQL Server IFI.
        """
        return pulumi.get(self, "is_ifi_enabled")

    @property
    @pulumi.getter(name="isLpimEnabled")
    def is_lpim_enabled(self) -> Optional[bool]:
        """
        SQL Server LPIM.
        """
        return pulumi.get(self, "is_lpim_enabled")

    @property
    @pulumi.getter(name="isOptimizeForAdHocWorkloadsEnabled")
    def is_optimize_for_ad_hoc_workloads_enabled(self) -> Optional[bool]:
        """
        SQL Server Optimize for Adhoc workloads.
        """
        return pulumi.get(self, "is_optimize_for_ad_hoc_workloads_enabled")

    @property
    @pulumi.getter(name="maxDop")
    def max_dop(self) -> Optional[int]:
        """
        SQL Server MAXDOP.
        """
        return pulumi.get(self, "max_dop")

    @property
    @pulumi.getter(name="maxServerMemoryMB")
    def max_server_memory_mb(self) -> Optional[int]:
        """
        SQL Server maximum memory.
        """
        return pulumi.get(self, "max_server_memory_mb")

    @property
    @pulumi.getter(name="minServerMemoryMB")
    def min_server_memory_mb(self) -> Optional[int]:
        """
        SQL Server minimum memory.
        """
        return pulumi.get(self, "min_server_memory_mb")


@pulumi.output_type
class SQLStorageSettingsResponse(dict):
    """
    Set disk storage settings for SQL Server.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultFilePath":
            suggest = "default_file_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SQLStorageSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SQLStorageSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SQLStorageSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_file_path: Optional[str] = None,
                 luns: Optional[Sequence[int]] = None):
        """
        Set disk storage settings for SQL Server.
        :param str default_file_path: SQL Server default file path
        :param Sequence[int] luns: Logical Unit Numbers for the disks.
        """
        if default_file_path is not None:
            pulumi.set(__self__, "default_file_path", default_file_path)
        if luns is not None:
            pulumi.set(__self__, "luns", luns)

    @property
    @pulumi.getter(name="defaultFilePath")
    def default_file_path(self) -> Optional[str]:
        """
        SQL Server default file path
        """
        return pulumi.get(self, "default_file_path")

    @property
    @pulumi.getter
    def luns(self) -> Optional[Sequence[int]]:
        """
        Logical Unit Numbers for the disks.
        """
        return pulumi.get(self, "luns")


@pulumi.output_type
class SQLTempDbSettingsResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataFileCount":
            suggest = "data_file_count"
        elif key == "dataFileSize":
            suggest = "data_file_size"
        elif key == "dataGrowth":
            suggest = "data_growth"
        elif key == "defaultFilePath":
            suggest = "default_file_path"
        elif key == "logFileSize":
            suggest = "log_file_size"
        elif key == "logGrowth":
            suggest = "log_growth"
        elif key == "persistFolder":
            suggest = "persist_folder"
        elif key == "persistFolderPath":
            suggest = "persist_folder_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SQLTempDbSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SQLTempDbSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SQLTempDbSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data_file_count: Optional[int] = None,
                 data_file_size: Optional[int] = None,
                 data_growth: Optional[int] = None,
                 default_file_path: Optional[str] = None,
                 log_file_size: Optional[int] = None,
                 log_growth: Optional[int] = None,
                 luns: Optional[Sequence[int]] = None,
                 persist_folder: Optional[bool] = None,
                 persist_folder_path: Optional[str] = None):
        """
        :param int data_file_count: SQL Server tempdb data file count
        :param int data_file_size: SQL Server tempdb data file size
        :param int data_growth: SQL Server tempdb data file autoGrowth size
        :param str default_file_path: SQL Server default file path
        :param int log_file_size: SQL Server tempdb log file size
        :param int log_growth: SQL Server tempdb log file autoGrowth size
        :param Sequence[int] luns: Logical Unit Numbers for the disks.
        :param bool persist_folder: SQL Server tempdb persist folder choice
        :param str persist_folder_path: SQL Server tempdb persist folder location
        """
        if data_file_count is not None:
            pulumi.set(__self__, "data_file_count", data_file_count)
        if data_file_size is not None:
            pulumi.set(__self__, "data_file_size", data_file_size)
        if data_growth is not None:
            pulumi.set(__self__, "data_growth", data_growth)
        if default_file_path is not None:
            pulumi.set(__self__, "default_file_path", default_file_path)
        if log_file_size is not None:
            pulumi.set(__self__, "log_file_size", log_file_size)
        if log_growth is not None:
            pulumi.set(__self__, "log_growth", log_growth)
        if luns is not None:
            pulumi.set(__self__, "luns", luns)
        if persist_folder is not None:
            pulumi.set(__self__, "persist_folder", persist_folder)
        if persist_folder_path is not None:
            pulumi.set(__self__, "persist_folder_path", persist_folder_path)

    @property
    @pulumi.getter(name="dataFileCount")
    def data_file_count(self) -> Optional[int]:
        """
        SQL Server tempdb data file count
        """
        return pulumi.get(self, "data_file_count")

    @property
    @pulumi.getter(name="dataFileSize")
    def data_file_size(self) -> Optional[int]:
        """
        SQL Server tempdb data file size
        """
        return pulumi.get(self, "data_file_size")

    @property
    @pulumi.getter(name="dataGrowth")
    def data_growth(self) -> Optional[int]:
        """
        SQL Server tempdb data file autoGrowth size
        """
        return pulumi.get(self, "data_growth")

    @property
    @pulumi.getter(name="defaultFilePath")
    def default_file_path(self) -> Optional[str]:
        """
        SQL Server default file path
        """
        return pulumi.get(self, "default_file_path")

    @property
    @pulumi.getter(name="logFileSize")
    def log_file_size(self) -> Optional[int]:
        """
        SQL Server tempdb log file size
        """
        return pulumi.get(self, "log_file_size")

    @property
    @pulumi.getter(name="logGrowth")
    def log_growth(self) -> Optional[int]:
        """
        SQL Server tempdb log file autoGrowth size
        """
        return pulumi.get(self, "log_growth")

    @property
    @pulumi.getter
    def luns(self) -> Optional[Sequence[int]]:
        """
        Logical Unit Numbers for the disks.
        """
        return pulumi.get(self, "luns")

    @property
    @pulumi.getter(name="persistFolder")
    def persist_folder(self) -> Optional[bool]:
        """
        SQL Server tempdb persist folder choice
        """
        return pulumi.get(self, "persist_folder")

    @property
    @pulumi.getter(name="persistFolderPath")
    def persist_folder_path(self) -> Optional[str]:
        """
        SQL Server tempdb persist folder location
        """
        return pulumi.get(self, "persist_folder_path")


@pulumi.output_type
class ScheduleResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dayOfWeek":
            suggest = "day_of_week"
        elif key == "monthlyOccurrence":
            suggest = "monthly_occurrence"
        elif key == "startTime":
            suggest = "start_time"
        elif key == "weeklyInterval":
            suggest = "weekly_interval"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScheduleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScheduleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScheduleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 day_of_week: Optional[str] = None,
                 enable: Optional[bool] = None,
                 monthly_occurrence: Optional[int] = None,
                 start_time: Optional[str] = None,
                 weekly_interval: Optional[int] = None):
        """
        :param str day_of_week: Day of the week to run assessment.
        :param bool enable: Enable or disable assessment schedule on SQL virtual machine.
        :param int monthly_occurrence: Occurrence of the DayOfWeek day within a month to schedule assessment. Takes values: 1,2,3,4 and -1. Use -1 for last DayOfWeek day of the month
        :param str start_time: Time of the day in HH:mm format. Eg. 17:30
        :param int weekly_interval: Number of weeks to schedule between 2 assessment runs. Takes value from 1-6
        """
        if day_of_week is not None:
            pulumi.set(__self__, "day_of_week", day_of_week)
        if enable is not None:
            pulumi.set(__self__, "enable", enable)
        if monthly_occurrence is not None:
            pulumi.set(__self__, "monthly_occurrence", monthly_occurrence)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)
        if weekly_interval is not None:
            pulumi.set(__self__, "weekly_interval", weekly_interval)

    @property
    @pulumi.getter(name="dayOfWeek")
    def day_of_week(self) -> Optional[str]:
        """
        Day of the week to run assessment.
        """
        return pulumi.get(self, "day_of_week")

    @property
    @pulumi.getter
    def enable(self) -> Optional[bool]:
        """
        Enable or disable assessment schedule on SQL virtual machine.
        """
        return pulumi.get(self, "enable")

    @property
    @pulumi.getter(name="monthlyOccurrence")
    def monthly_occurrence(self) -> Optional[int]:
        """
        Occurrence of the DayOfWeek day within a month to schedule assessment. Takes values: 1,2,3,4 and -1. Use -1 for last DayOfWeek day of the month
        """
        return pulumi.get(self, "monthly_occurrence")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[str]:
        """
        Time of the day in HH:mm format. Eg. 17:30
        """
        return pulumi.get(self, "start_time")

    @property
    @pulumi.getter(name="weeklyInterval")
    def weekly_interval(self) -> Optional[int]:
        """
        Number of weeks to schedule between 2 assessment runs. Takes value from 1-6
        """
        return pulumi.get(self, "weekly_interval")


@pulumi.output_type
class ServerConfigurationsManagementSettingsResponse(dict):
    """
    Set the connectivity, storage and workload settings.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "additionalFeaturesServerConfigurations":
            suggest = "additional_features_server_configurations"
        elif key == "sqlConnectivityUpdateSettings":
            suggest = "sql_connectivity_update_settings"
        elif key == "sqlInstanceSettings":
            suggest = "sql_instance_settings"
        elif key == "sqlStorageUpdateSettings":
            suggest = "sql_storage_update_settings"
        elif key == "sqlWorkloadTypeUpdateSettings":
            suggest = "sql_workload_type_update_settings"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServerConfigurationsManagementSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServerConfigurationsManagementSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServerConfigurationsManagementSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 additional_features_server_configurations: Optional['outputs.AdditionalFeaturesServerConfigurationsResponse'] = None,
                 sql_connectivity_update_settings: Optional['outputs.SqlConnectivityUpdateSettingsResponse'] = None,
                 sql_instance_settings: Optional['outputs.SQLInstanceSettingsResponse'] = None,
                 sql_storage_update_settings: Optional['outputs.SqlStorageUpdateSettingsResponse'] = None,
                 sql_workload_type_update_settings: Optional['outputs.SqlWorkloadTypeUpdateSettingsResponse'] = None):
        """
        Set the connectivity, storage and workload settings.
        :param 'AdditionalFeaturesServerConfigurationsResponse' additional_features_server_configurations: Additional SQL feature settings.
        :param 'SqlConnectivityUpdateSettingsResponse' sql_connectivity_update_settings: SQL connectivity type settings.
        :param 'SQLInstanceSettingsResponse' sql_instance_settings: SQL Instance settings.
        :param 'SqlStorageUpdateSettingsResponse' sql_storage_update_settings: SQL storage update settings.
        :param 'SqlWorkloadTypeUpdateSettingsResponse' sql_workload_type_update_settings: SQL workload type settings.
        """
        if additional_features_server_configurations is not None:
            pulumi.set(__self__, "additional_features_server_configurations", additional_features_server_configurations)
        if sql_connectivity_update_settings is not None:
            pulumi.set(__self__, "sql_connectivity_update_settings", sql_connectivity_update_settings)
        if sql_instance_settings is not None:
            pulumi.set(__self__, "sql_instance_settings", sql_instance_settings)
        if sql_storage_update_settings is not None:
            pulumi.set(__self__, "sql_storage_update_settings", sql_storage_update_settings)
        if sql_workload_type_update_settings is not None:
            pulumi.set(__self__, "sql_workload_type_update_settings", sql_workload_type_update_settings)

    @property
    @pulumi.getter(name="additionalFeaturesServerConfigurations")
    def additional_features_server_configurations(self) -> Optional['outputs.AdditionalFeaturesServerConfigurationsResponse']:
        """
        Additional SQL feature settings.
        """
        return pulumi.get(self, "additional_features_server_configurations")

    @property
    @pulumi.getter(name="sqlConnectivityUpdateSettings")
    def sql_connectivity_update_settings(self) -> Optional['outputs.SqlConnectivityUpdateSettingsResponse']:
        """
        SQL connectivity type settings.
        """
        return pulumi.get(self, "sql_connectivity_update_settings")

    @property
    @pulumi.getter(name="sqlInstanceSettings")
    def sql_instance_settings(self) -> Optional['outputs.SQLInstanceSettingsResponse']:
        """
        SQL Instance settings.
        """
        return pulumi.get(self, "sql_instance_settings")

    @property
    @pulumi.getter(name="sqlStorageUpdateSettings")
    def sql_storage_update_settings(self) -> Optional['outputs.SqlStorageUpdateSettingsResponse']:
        """
        SQL storage update settings.
        """
        return pulumi.get(self, "sql_storage_update_settings")

    @property
    @pulumi.getter(name="sqlWorkloadTypeUpdateSettings")
    def sql_workload_type_update_settings(self) -> Optional['outputs.SqlWorkloadTypeUpdateSettingsResponse']:
        """
        SQL workload type settings.
        """
        return pulumi.get(self, "sql_workload_type_update_settings")


@pulumi.output_type
class SqlConnectivityUpdateSettingsResponse(dict):
    """
    Set the access level and network port settings for SQL Server.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "connectivityType":
            suggest = "connectivity_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SqlConnectivityUpdateSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SqlConnectivityUpdateSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SqlConnectivityUpdateSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 connectivity_type: Optional[str] = None,
                 port: Optional[int] = None):
        """
        Set the access level and network port settings for SQL Server.
        :param str connectivity_type: SQL Server connectivity option.
        :param int port: SQL Server port.
        """
        if connectivity_type is not None:
            pulumi.set(__self__, "connectivity_type", connectivity_type)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter(name="connectivityType")
    def connectivity_type(self) -> Optional[str]:
        """
        SQL Server connectivity option.
        """
        return pulumi.get(self, "connectivity_type")

    @property
    @pulumi.getter
    def port(self) -> Optional[int]:
        """
        SQL Server port.
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class SqlStorageUpdateSettingsResponse(dict):
    """
    Set disk storage settings for SQL Server.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "diskConfigurationType":
            suggest = "disk_configuration_type"
        elif key == "diskCount":
            suggest = "disk_count"
        elif key == "startingDeviceId":
            suggest = "starting_device_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SqlStorageUpdateSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SqlStorageUpdateSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SqlStorageUpdateSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 disk_configuration_type: Optional[str] = None,
                 disk_count: Optional[int] = None,
                 starting_device_id: Optional[int] = None):
        """
        Set disk storage settings for SQL Server.
        :param str disk_configuration_type: Disk configuration to apply to SQL Server.
        :param int disk_count: Virtual machine disk count.
        :param int starting_device_id: Device id of the first disk to be updated.
        """
        if disk_configuration_type is not None:
            pulumi.set(__self__, "disk_configuration_type", disk_configuration_type)
        if disk_count is not None:
            pulumi.set(__self__, "disk_count", disk_count)
        if starting_device_id is not None:
            pulumi.set(__self__, "starting_device_id", starting_device_id)

    @property
    @pulumi.getter(name="diskConfigurationType")
    def disk_configuration_type(self) -> Optional[str]:
        """
        Disk configuration to apply to SQL Server.
        """
        return pulumi.get(self, "disk_configuration_type")

    @property
    @pulumi.getter(name="diskCount")
    def disk_count(self) -> Optional[int]:
        """
        Virtual machine disk count.
        """
        return pulumi.get(self, "disk_count")

    @property
    @pulumi.getter(name="startingDeviceId")
    def starting_device_id(self) -> Optional[int]:
        """
        Device id of the first disk to be updated.
        """
        return pulumi.get(self, "starting_device_id")


@pulumi.output_type
class SqlWorkloadTypeUpdateSettingsResponse(dict):
    """
    Set workload type to optimize storage for SQL Server.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sqlWorkloadType":
            suggest = "sql_workload_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SqlWorkloadTypeUpdateSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SqlWorkloadTypeUpdateSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SqlWorkloadTypeUpdateSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 sql_workload_type: Optional[str] = None):
        """
        Set workload type to optimize storage for SQL Server.
        :param str sql_workload_type: SQL Server workload type.
        """
        if sql_workload_type is not None:
            pulumi.set(__self__, "sql_workload_type", sql_workload_type)

    @property
    @pulumi.getter(name="sqlWorkloadType")
    def sql_workload_type(self) -> Optional[str]:
        """
        SQL Server workload type.
        """
        return pulumi.get(self, "sql_workload_type")


@pulumi.output_type
class StorageConfigurationSettingsResponse(dict):
    """
    Storage Configurations for SQL Data, Log and TempDb.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "diskConfigurationType":
            suggest = "disk_configuration_type"
        elif key == "sqlDataSettings":
            suggest = "sql_data_settings"
        elif key == "sqlLogSettings":
            suggest = "sql_log_settings"
        elif key == "sqlSystemDbOnDataDisk":
            suggest = "sql_system_db_on_data_disk"
        elif key == "sqlTempDbSettings":
            suggest = "sql_temp_db_settings"
        elif key == "storageWorkloadType":
            suggest = "storage_workload_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StorageConfigurationSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StorageConfigurationSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StorageConfigurationSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 disk_configuration_type: Optional[str] = None,
                 sql_data_settings: Optional['outputs.SQLStorageSettingsResponse'] = None,
                 sql_log_settings: Optional['outputs.SQLStorageSettingsResponse'] = None,
                 sql_system_db_on_data_disk: Optional[bool] = None,
                 sql_temp_db_settings: Optional['outputs.SQLTempDbSettingsResponse'] = None,
                 storage_workload_type: Optional[str] = None):
        """
        Storage Configurations for SQL Data, Log and TempDb.
        :param str disk_configuration_type: Disk configuration to apply to SQL Server.
        :param 'SQLStorageSettingsResponse' sql_data_settings: SQL Server Data Storage Settings.
        :param 'SQLStorageSettingsResponse' sql_log_settings: SQL Server Log Storage Settings.
        :param bool sql_system_db_on_data_disk: SQL Server SystemDb Storage on DataPool if true.
        :param 'SQLTempDbSettingsResponse' sql_temp_db_settings: SQL Server TempDb Storage Settings.
        :param str storage_workload_type: Storage workload type.
        """
        if disk_configuration_type is not None:
            pulumi.set(__self__, "disk_configuration_type", disk_configuration_type)
        if sql_data_settings is not None:
            pulumi.set(__self__, "sql_data_settings", sql_data_settings)
        if sql_log_settings is not None:
            pulumi.set(__self__, "sql_log_settings", sql_log_settings)
        if sql_system_db_on_data_disk is not None:
            pulumi.set(__self__, "sql_system_db_on_data_disk", sql_system_db_on_data_disk)
        if sql_temp_db_settings is not None:
            pulumi.set(__self__, "sql_temp_db_settings", sql_temp_db_settings)
        if storage_workload_type is not None:
            pulumi.set(__self__, "storage_workload_type", storage_workload_type)

    @property
    @pulumi.getter(name="diskConfigurationType")
    def disk_configuration_type(self) -> Optional[str]:
        """
        Disk configuration to apply to SQL Server.
        """
        return pulumi.get(self, "disk_configuration_type")

    @property
    @pulumi.getter(name="sqlDataSettings")
    def sql_data_settings(self) -> Optional['outputs.SQLStorageSettingsResponse']:
        """
        SQL Server Data Storage Settings.
        """
        return pulumi.get(self, "sql_data_settings")

    @property
    @pulumi.getter(name="sqlLogSettings")
    def sql_log_settings(self) -> Optional['outputs.SQLStorageSettingsResponse']:
        """
        SQL Server Log Storage Settings.
        """
        return pulumi.get(self, "sql_log_settings")

    @property
    @pulumi.getter(name="sqlSystemDbOnDataDisk")
    def sql_system_db_on_data_disk(self) -> Optional[bool]:
        """
        SQL Server SystemDb Storage on DataPool if true.
        """
        return pulumi.get(self, "sql_system_db_on_data_disk")

    @property
    @pulumi.getter(name="sqlTempDbSettings")
    def sql_temp_db_settings(self) -> Optional['outputs.SQLTempDbSettingsResponse']:
        """
        SQL Server TempDb Storage Settings.
        """
        return pulumi.get(self, "sql_temp_db_settings")

    @property
    @pulumi.getter(name="storageWorkloadType")
    def storage_workload_type(self) -> Optional[str]:
        """
        Storage workload type.
        """
        return pulumi.get(self, "storage_workload_type")


@pulumi.output_type
class SystemDataResponse(dict):
    """
    Metadata pertaining to creation and last modification of the resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createdAt":
            suggest = "created_at"
        elif key == "createdBy":
            suggest = "created_by"
        elif key == "createdByType":
            suggest = "created_by_type"
        elif key == "lastModifiedAt":
            suggest = "last_modified_at"
        elif key == "lastModifiedBy":
            suggest = "last_modified_by"
        elif key == "lastModifiedByType":
            suggest = "last_modified_by_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SystemDataResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SystemDataResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SystemDataResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 created_at: Optional[str] = None,
                 created_by: Optional[str] = None,
                 created_by_type: Optional[str] = None,
                 last_modified_at: Optional[str] = None,
                 last_modified_by: Optional[str] = None,
                 last_modified_by_type: Optional[str] = None):
        """
        Metadata pertaining to creation and last modification of the resource.
        :param str created_at: The timestamp of resource creation (UTC).
        :param str created_by: The identity that created the resource.
        :param str created_by_type: The type of identity that created the resource.
        :param str last_modified_at: The timestamp of resource last modification (UTC)
        :param str last_modified_by: The identity that last modified the resource.
        :param str last_modified_by_type: The type of identity that last modified the resource.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if created_by_type is not None:
            pulumi.set(__self__, "created_by_type", created_by_type)
        if last_modified_at is not None:
            pulumi.set(__self__, "last_modified_at", last_modified_at)
        if last_modified_by is not None:
            pulumi.set(__self__, "last_modified_by", last_modified_by)
        if last_modified_by_type is not None:
            pulumi.set(__self__, "last_modified_by_type", last_modified_by_type)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[str]:
        """
        The timestamp of resource creation (UTC).
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[str]:
        """
        The identity that created the resource.
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter(name="createdByType")
    def created_by_type(self) -> Optional[str]:
        """
        The type of identity that created the resource.
        """
        return pulumi.get(self, "created_by_type")

    @property
    @pulumi.getter(name="lastModifiedAt")
    def last_modified_at(self) -> Optional[str]:
        """
        The timestamp of resource last modification (UTC)
        """
        return pulumi.get(self, "last_modified_at")

    @property
    @pulumi.getter(name="lastModifiedBy")
    def last_modified_by(self) -> Optional[str]:
        """
        The identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by")

    @property
    @pulumi.getter(name="lastModifiedByType")
    def last_modified_by_type(self) -> Optional[str]:
        """
        The type of identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by_type")


@pulumi.output_type
class WsfcDomainCredentialsResponse(dict):
    """
    Domain credentials for setting up Windows Server Failover Cluster for SQL availability group.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clusterBootstrapAccountPassword":
            suggest = "cluster_bootstrap_account_password"
        elif key == "clusterOperatorAccountPassword":
            suggest = "cluster_operator_account_password"
        elif key == "sqlServiceAccountPassword":
            suggest = "sql_service_account_password"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WsfcDomainCredentialsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WsfcDomainCredentialsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WsfcDomainCredentialsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cluster_bootstrap_account_password: Optional[str] = None,
                 cluster_operator_account_password: Optional[str] = None,
                 sql_service_account_password: Optional[str] = None):
        """
        Domain credentials for setting up Windows Server Failover Cluster for SQL availability group.
        :param str cluster_bootstrap_account_password: Cluster bootstrap account password.
        :param str cluster_operator_account_password: Cluster operator account password.
        :param str sql_service_account_password: SQL service account password.
        """
        if cluster_bootstrap_account_password is not None:
            pulumi.set(__self__, "cluster_bootstrap_account_password", cluster_bootstrap_account_password)
        if cluster_operator_account_password is not None:
            pulumi.set(__self__, "cluster_operator_account_password", cluster_operator_account_password)
        if sql_service_account_password is not None:
            pulumi.set(__self__, "sql_service_account_password", sql_service_account_password)

    @property
    @pulumi.getter(name="clusterBootstrapAccountPassword")
    def cluster_bootstrap_account_password(self) -> Optional[str]:
        """
        Cluster bootstrap account password.
        """
        return pulumi.get(self, "cluster_bootstrap_account_password")

    @property
    @pulumi.getter(name="clusterOperatorAccountPassword")
    def cluster_operator_account_password(self) -> Optional[str]:
        """
        Cluster operator account password.
        """
        return pulumi.get(self, "cluster_operator_account_password")

    @property
    @pulumi.getter(name="sqlServiceAccountPassword")
    def sql_service_account_password(self) -> Optional[str]:
        """
        SQL service account password.
        """
        return pulumi.get(self, "sql_service_account_password")


@pulumi.output_type
class WsfcDomainProfileResponse(dict):
    """
    Active Directory account details to operate Windows Server Failover Cluster.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clusterBootstrapAccount":
            suggest = "cluster_bootstrap_account"
        elif key == "clusterOperatorAccount":
            suggest = "cluster_operator_account"
        elif key == "clusterSubnetType":
            suggest = "cluster_subnet_type"
        elif key == "domainFqdn":
            suggest = "domain_fqdn"
        elif key == "fileShareWitnessPath":
            suggest = "file_share_witness_path"
        elif key == "ouPath":
            suggest = "ou_path"
        elif key == "sqlServiceAccount":
            suggest = "sql_service_account"
        elif key == "storageAccountUrl":
            suggest = "storage_account_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WsfcDomainProfileResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WsfcDomainProfileResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WsfcDomainProfileResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cluster_bootstrap_account: Optional[str] = None,
                 cluster_operator_account: Optional[str] = None,
                 cluster_subnet_type: Optional[str] = None,
                 domain_fqdn: Optional[str] = None,
                 file_share_witness_path: Optional[str] = None,
                 ou_path: Optional[str] = None,
                 sql_service_account: Optional[str] = None,
                 storage_account_url: Optional[str] = None):
        """
        Active Directory account details to operate Windows Server Failover Cluster.
        :param str cluster_bootstrap_account: Account name used for creating cluster (at minimum needs permissions to 'Create Computer Objects' in domain).
        :param str cluster_operator_account: Account name used for operating cluster i.e. will be part of administrators group on all the participating virtual machines in the cluster.
        :param str cluster_subnet_type: Cluster subnet type.
        :param str domain_fqdn: Fully qualified name of the domain.
        :param str file_share_witness_path: Optional path for fileshare witness.
        :param str ou_path: Organizational Unit path in which the nodes and cluster will be present.
        :param str sql_service_account: Account name under which SQL service will run on all participating SQL virtual machines in the cluster.
        :param str storage_account_url: Fully qualified ARM resource id of the witness storage account.
        """
        if cluster_bootstrap_account is not None:
            pulumi.set(__self__, "cluster_bootstrap_account", cluster_bootstrap_account)
        if cluster_operator_account is not None:
            pulumi.set(__self__, "cluster_operator_account", cluster_operator_account)
        if cluster_subnet_type is not None:
            pulumi.set(__self__, "cluster_subnet_type", cluster_subnet_type)
        if domain_fqdn is not None:
            pulumi.set(__self__, "domain_fqdn", domain_fqdn)
        if file_share_witness_path is not None:
            pulumi.set(__self__, "file_share_witness_path", file_share_witness_path)
        if ou_path is not None:
            pulumi.set(__self__, "ou_path", ou_path)
        if sql_service_account is not None:
            pulumi.set(__self__, "sql_service_account", sql_service_account)
        if storage_account_url is not None:
            pulumi.set(__self__, "storage_account_url", storage_account_url)

    @property
    @pulumi.getter(name="clusterBootstrapAccount")
    def cluster_bootstrap_account(self) -> Optional[str]:
        """
        Account name used for creating cluster (at minimum needs permissions to 'Create Computer Objects' in domain).
        """
        return pulumi.get(self, "cluster_bootstrap_account")

    @property
    @pulumi.getter(name="clusterOperatorAccount")
    def cluster_operator_account(self) -> Optional[str]:
        """
        Account name used for operating cluster i.e. will be part of administrators group on all the participating virtual machines in the cluster.
        """
        return pulumi.get(self, "cluster_operator_account")

    @property
    @pulumi.getter(name="clusterSubnetType")
    def cluster_subnet_type(self) -> Optional[str]:
        """
        Cluster subnet type.
        """
        return pulumi.get(self, "cluster_subnet_type")

    @property
    @pulumi.getter(name="domainFqdn")
    def domain_fqdn(self) -> Optional[str]:
        """
        Fully qualified name of the domain.
        """
        return pulumi.get(self, "domain_fqdn")

    @property
    @pulumi.getter(name="fileShareWitnessPath")
    def file_share_witness_path(self) -> Optional[str]:
        """
        Optional path for fileshare witness.
        """
        return pulumi.get(self, "file_share_witness_path")

    @property
    @pulumi.getter(name="ouPath")
    def ou_path(self) -> Optional[str]:
        """
        Organizational Unit path in which the nodes and cluster will be present.
        """
        return pulumi.get(self, "ou_path")

    @property
    @pulumi.getter(name="sqlServiceAccount")
    def sql_service_account(self) -> Optional[str]:
        """
        Account name under which SQL service will run on all participating SQL virtual machines in the cluster.
        """
        return pulumi.get(self, "sql_service_account")

    @property
    @pulumi.getter(name="storageAccountUrl")
    def storage_account_url(self) -> Optional[str]:
        """
        Fully qualified ARM resource id of the witness storage account.
        """
        return pulumi.get(self, "storage_account_url")


