# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'AppResourcePropertiesArgs',
    'BindingResourcePropertiesArgs',
    'BuildResultUserSourceInfoArgs',
    'BuilderPropertiesArgs',
    'BuildpackBindingLaunchPropertiesArgs',
    'BuildpackBindingPropertiesArgs',
    'BuildpackPropertiesArgs',
    'BuildpacksGroupPropertiesArgs',
    'ClusterResourcePropertiesArgs',
    'ConfigurationServiceGitPropertyArgs',
    'ConfigurationServiceGitRepositoryArgs',
    'ConfigurationServicePropertiesArgs',
    'ConfigurationServiceSettingsArgs',
    'ContentCertificatePropertiesArgs',
    'CustomDomainPropertiesArgs',
    'DeploymentResourcePropertiesArgs',
    'DeploymentSettingsArgs',
    'JarUploadedUserSourceInfoArgs',
    'KeyVaultCertificatePropertiesArgs',
    'LoadedCertificateArgs',
    'ManagedIdentityPropertiesArgs',
    'NetCoreZipUploadedUserSourceInfoArgs',
    'NetworkProfileArgs',
    'PersistentDiskArgs',
    'ResourceRequestsArgs',
    'SkuArgs',
    'SourceUploadedUserSourceInfoArgs',
    'StackPropertiesArgs',
    'TemporaryDiskArgs',
    'UploadedUserSourceInfoArgs',
]

@pulumi.input_type
class AppResourcePropertiesArgs:
    def __init__(__self__, *,
                 addon_configs: Optional[pulumi.Input[Mapping[str, pulumi.Input[Mapping[str, Any]]]]] = None,
                 enable_end_to_end_tls: Optional[pulumi.Input[bool]] = None,
                 fqdn: Optional[pulumi.Input[str]] = None,
                 https_only: Optional[pulumi.Input[bool]] = None,
                 loaded_certificates: Optional[pulumi.Input[Sequence[pulumi.Input['LoadedCertificateArgs']]]] = None,
                 persistent_disk: Optional[pulumi.Input['PersistentDiskArgs']] = None,
                 public: Optional[pulumi.Input[bool]] = None,
                 temporary_disk: Optional[pulumi.Input['TemporaryDiskArgs']] = None):
        """
        App resource properties payload
        :param pulumi.Input[Mapping[str, pulumi.Input[Mapping[str, Any]]]] addon_configs: Collection of addons
        :param pulumi.Input[bool] enable_end_to_end_tls: Indicate if end to end TLS is enabled.
        :param pulumi.Input[str] fqdn: Fully qualified dns Name.
        :param pulumi.Input[bool] https_only: Indicate if only https is allowed.
        :param pulumi.Input[Sequence[pulumi.Input['LoadedCertificateArgs']]] loaded_certificates: Collection of loaded certificates
        :param pulumi.Input['PersistentDiskArgs'] persistent_disk: Persistent disk settings
        :param pulumi.Input[bool] public: Indicates whether the App exposes public endpoint
        :param pulumi.Input['TemporaryDiskArgs'] temporary_disk: Temporary disk settings
        """
        if addon_configs is not None:
            pulumi.set(__self__, "addon_configs", addon_configs)
        if enable_end_to_end_tls is None:
            enable_end_to_end_tls = False
        if enable_end_to_end_tls is not None:
            pulumi.set(__self__, "enable_end_to_end_tls", enable_end_to_end_tls)
        if fqdn is not None:
            pulumi.set(__self__, "fqdn", fqdn)
        if https_only is None:
            https_only = False
        if https_only is not None:
            pulumi.set(__self__, "https_only", https_only)
        if loaded_certificates is not None:
            pulumi.set(__self__, "loaded_certificates", loaded_certificates)
        if persistent_disk is not None:
            pulumi.set(__self__, "persistent_disk", persistent_disk)
        if public is not None:
            pulumi.set(__self__, "public", public)
        if temporary_disk is not None:
            pulumi.set(__self__, "temporary_disk", temporary_disk)

    @property
    @pulumi.getter(name="addonConfigs")
    def addon_configs(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[Mapping[str, Any]]]]]:
        """
        Collection of addons
        """
        return pulumi.get(self, "addon_configs")

    @addon_configs.setter
    def addon_configs(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[Mapping[str, Any]]]]]):
        pulumi.set(self, "addon_configs", value)

    @property
    @pulumi.getter(name="enableEndToEndTLS")
    def enable_end_to_end_tls(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicate if end to end TLS is enabled.
        """
        return pulumi.get(self, "enable_end_to_end_tls")

    @enable_end_to_end_tls.setter
    def enable_end_to_end_tls(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_end_to_end_tls", value)

    @property
    @pulumi.getter
    def fqdn(self) -> Optional[pulumi.Input[str]]:
        """
        Fully qualified dns Name.
        """
        return pulumi.get(self, "fqdn")

    @fqdn.setter
    def fqdn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fqdn", value)

    @property
    @pulumi.getter(name="httpsOnly")
    def https_only(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicate if only https is allowed.
        """
        return pulumi.get(self, "https_only")

    @https_only.setter
    def https_only(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "https_only", value)

    @property
    @pulumi.getter(name="loadedCertificates")
    def loaded_certificates(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LoadedCertificateArgs']]]]:
        """
        Collection of loaded certificates
        """
        return pulumi.get(self, "loaded_certificates")

    @loaded_certificates.setter
    def loaded_certificates(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LoadedCertificateArgs']]]]):
        pulumi.set(self, "loaded_certificates", value)

    @property
    @pulumi.getter(name="persistentDisk")
    def persistent_disk(self) -> Optional[pulumi.Input['PersistentDiskArgs']]:
        """
        Persistent disk settings
        """
        return pulumi.get(self, "persistent_disk")

    @persistent_disk.setter
    def persistent_disk(self, value: Optional[pulumi.Input['PersistentDiskArgs']]):
        pulumi.set(self, "persistent_disk", value)

    @property
    @pulumi.getter
    def public(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether the App exposes public endpoint
        """
        return pulumi.get(self, "public")

    @public.setter
    def public(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "public", value)

    @property
    @pulumi.getter(name="temporaryDisk")
    def temporary_disk(self) -> Optional[pulumi.Input['TemporaryDiskArgs']]:
        """
        Temporary disk settings
        """
        return pulumi.get(self, "temporary_disk")

    @temporary_disk.setter
    def temporary_disk(self, value: Optional[pulumi.Input['TemporaryDiskArgs']]):
        pulumi.set(self, "temporary_disk", value)


@pulumi.input_type
class BindingResourcePropertiesArgs:
    def __init__(__self__, *,
                 binding_parameters: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 key: Optional[pulumi.Input[str]] = None,
                 resource_id: Optional[pulumi.Input[str]] = None):
        """
        Binding resource properties payload
        :param pulumi.Input[Mapping[str, Any]] binding_parameters: Binding parameters of the Binding resource
        :param pulumi.Input[str] key: The key of the bound resource
        :param pulumi.Input[str] resource_id: The Azure resource id of the bound resource
        """
        if binding_parameters is not None:
            pulumi.set(__self__, "binding_parameters", binding_parameters)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)

    @property
    @pulumi.getter(name="bindingParameters")
    def binding_parameters(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Binding parameters of the Binding resource
        """
        return pulumi.get(self, "binding_parameters")

    @binding_parameters.setter
    def binding_parameters(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "binding_parameters", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[str]]:
        """
        The key of the bound resource
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        The Azure resource id of the bound resource
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_id", value)


@pulumi.input_type
class BuildResultUserSourceInfoArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 build_result_id: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[str]] = None):
        """
        Reference to a build result
        :param pulumi.Input[str] type: Type of the source uploaded
               Expected value is 'BuildResult'.
        :param pulumi.Input[str] build_result_id: Resource id of an existing succeeded build result under the same Spring instance.
        :param pulumi.Input[str] version: Version of the source
        """
        pulumi.set(__self__, "type", 'BuildResult')
        if build_result_id is not None:
            pulumi.set(__self__, "build_result_id", build_result_id)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of the source uploaded
        Expected value is 'BuildResult'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="buildResultId")
    def build_result_id(self) -> Optional[pulumi.Input[str]]:
        """
        Resource id of an existing succeeded build result under the same Spring instance.
        """
        return pulumi.get(self, "build_result_id")

    @build_result_id.setter
    def build_result_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "build_result_id", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        Version of the source
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class BuilderPropertiesArgs:
    def __init__(__self__, *,
                 buildpack_groups: Optional[pulumi.Input[Sequence[pulumi.Input['BuildpacksGroupPropertiesArgs']]]] = None,
                 stack: Optional[pulumi.Input['StackPropertiesArgs']] = None):
        """
        KPack Builder properties payload
        :param pulumi.Input[Sequence[pulumi.Input['BuildpacksGroupPropertiesArgs']]] buildpack_groups: Builder buildpack groups.
        :param pulumi.Input['StackPropertiesArgs'] stack: Builder cluster stack property.
        """
        if buildpack_groups is not None:
            pulumi.set(__self__, "buildpack_groups", buildpack_groups)
        if stack is not None:
            pulumi.set(__self__, "stack", stack)

    @property
    @pulumi.getter(name="buildpackGroups")
    def buildpack_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BuildpacksGroupPropertiesArgs']]]]:
        """
        Builder buildpack groups.
        """
        return pulumi.get(self, "buildpack_groups")

    @buildpack_groups.setter
    def buildpack_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BuildpacksGroupPropertiesArgs']]]]):
        pulumi.set(self, "buildpack_groups", value)

    @property
    @pulumi.getter
    def stack(self) -> Optional[pulumi.Input['StackPropertiesArgs']]:
        """
        Builder cluster stack property.
        """
        return pulumi.get(self, "stack")

    @stack.setter
    def stack(self, value: Optional[pulumi.Input['StackPropertiesArgs']]):
        pulumi.set(self, "stack", value)


@pulumi.input_type
class BuildpackBindingLaunchPropertiesArgs:
    def __init__(__self__, *,
                 properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 secrets: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        Buildpack Binding Launch Properties
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] properties: Non-sensitive properties for launchProperties
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] secrets: Sensitive properties for launchProperties
        """
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if secrets is not None:
            pulumi.set(__self__, "secrets", secrets)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Non-sensitive properties for launchProperties
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "properties", value)

    @property
    @pulumi.getter
    def secrets(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Sensitive properties for launchProperties
        """
        return pulumi.get(self, "secrets")

    @secrets.setter
    def secrets(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "secrets", value)


@pulumi.input_type
class BuildpackBindingPropertiesArgs:
    def __init__(__self__, *,
                 binding_type: Optional[pulumi.Input[Union[str, 'BindingType']]] = None,
                 launch_properties: Optional[pulumi.Input['BuildpackBindingLaunchPropertiesArgs']] = None):
        """
        Properties of a buildpack binding
        :param pulumi.Input[Union[str, 'BindingType']] binding_type: Buildpack Binding Type
        :param pulumi.Input['BuildpackBindingLaunchPropertiesArgs'] launch_properties: The object describes the buildpack binding launch properties
        """
        if binding_type is not None:
            pulumi.set(__self__, "binding_type", binding_type)
        if launch_properties is not None:
            pulumi.set(__self__, "launch_properties", launch_properties)

    @property
    @pulumi.getter(name="bindingType")
    def binding_type(self) -> Optional[pulumi.Input[Union[str, 'BindingType']]]:
        """
        Buildpack Binding Type
        """
        return pulumi.get(self, "binding_type")

    @binding_type.setter
    def binding_type(self, value: Optional[pulumi.Input[Union[str, 'BindingType']]]):
        pulumi.set(self, "binding_type", value)

    @property
    @pulumi.getter(name="launchProperties")
    def launch_properties(self) -> Optional[pulumi.Input['BuildpackBindingLaunchPropertiesArgs']]:
        """
        The object describes the buildpack binding launch properties
        """
        return pulumi.get(self, "launch_properties")

    @launch_properties.setter
    def launch_properties(self, value: Optional[pulumi.Input['BuildpackBindingLaunchPropertiesArgs']]):
        pulumi.set(self, "launch_properties", value)


@pulumi.input_type
class BuildpackPropertiesArgs:
    def __init__(__self__, *,
                 id: Optional[pulumi.Input[str]] = None):
        """
        Buildpack properties payload
        :param pulumi.Input[str] id: Id of the buildpack
        """
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Id of the buildpack
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)


@pulumi.input_type
class BuildpacksGroupPropertiesArgs:
    def __init__(__self__, *,
                 buildpacks: Optional[pulumi.Input[Sequence[pulumi.Input['BuildpackPropertiesArgs']]]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        Buildpack group properties of the Builder
        :param pulumi.Input[Sequence[pulumi.Input['BuildpackPropertiesArgs']]] buildpacks: Buildpacks in the buildpack group
        :param pulumi.Input[str] name: Buildpack group name
        """
        if buildpacks is not None:
            pulumi.set(__self__, "buildpacks", buildpacks)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def buildpacks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BuildpackPropertiesArgs']]]]:
        """
        Buildpacks in the buildpack group
        """
        return pulumi.get(self, "buildpacks")

    @buildpacks.setter
    def buildpacks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BuildpackPropertiesArgs']]]]):
        pulumi.set(self, "buildpacks", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Buildpack group name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class ClusterResourcePropertiesArgs:
    def __init__(__self__, *,
                 network_profile: Optional[pulumi.Input['NetworkProfileArgs']] = None,
                 zone_redundant: Optional[pulumi.Input[bool]] = None):
        """
        Service properties payload
        :param pulumi.Input['NetworkProfileArgs'] network_profile: Network profile of the Service
        """
        if network_profile is not None:
            pulumi.set(__self__, "network_profile", network_profile)
        if zone_redundant is None:
            zone_redundant = False
        if zone_redundant is not None:
            pulumi.set(__self__, "zone_redundant", zone_redundant)

    @property
    @pulumi.getter(name="networkProfile")
    def network_profile(self) -> Optional[pulumi.Input['NetworkProfileArgs']]:
        """
        Network profile of the Service
        """
        return pulumi.get(self, "network_profile")

    @network_profile.setter
    def network_profile(self, value: Optional[pulumi.Input['NetworkProfileArgs']]):
        pulumi.set(self, "network_profile", value)

    @property
    @pulumi.getter(name="zoneRedundant")
    def zone_redundant(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "zone_redundant")

    @zone_redundant.setter
    def zone_redundant(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "zone_redundant", value)


@pulumi.input_type
class ConfigurationServiceGitPropertyArgs:
    def __init__(__self__, *,
                 repositories: Optional[pulumi.Input[Sequence[pulumi.Input['ConfigurationServiceGitRepositoryArgs']]]] = None):
        """
        Property of git environment.
        :param pulumi.Input[Sequence[pulumi.Input['ConfigurationServiceGitRepositoryArgs']]] repositories: Repositories of Application Configuration Service git property.
        """
        if repositories is not None:
            pulumi.set(__self__, "repositories", repositories)

    @property
    @pulumi.getter
    def repositories(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ConfigurationServiceGitRepositoryArgs']]]]:
        """
        Repositories of Application Configuration Service git property.
        """
        return pulumi.get(self, "repositories")

    @repositories.setter
    def repositories(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ConfigurationServiceGitRepositoryArgs']]]]):
        pulumi.set(self, "repositories", value)


@pulumi.input_type
class ConfigurationServiceGitRepositoryArgs:
    def __init__(__self__, *,
                 label: pulumi.Input[str],
                 name: pulumi.Input[str],
                 patterns: pulumi.Input[Sequence[pulumi.Input[str]]],
                 uri: pulumi.Input[str],
                 host_key: Optional[pulumi.Input[str]] = None,
                 host_key_algorithm: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 private_key: Optional[pulumi.Input[str]] = None,
                 search_paths: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 strict_host_key_checking: Optional[pulumi.Input[bool]] = None,
                 username: Optional[pulumi.Input[str]] = None):
        """
        Git repository property payload for Application Configuration Service
        :param pulumi.Input[str] label: Label of the repository
        :param pulumi.Input[str] name: Name of the repository
        :param pulumi.Input[Sequence[pulumi.Input[str]]] patterns: Collection of patterns of the repository
        :param pulumi.Input[str] uri: URI of the repository
        :param pulumi.Input[str] host_key: Public sshKey of git repository.
        :param pulumi.Input[str] host_key_algorithm: SshKey algorithm of git repository.
        :param pulumi.Input[str] password: Password of git repository basic auth.
        :param pulumi.Input[str] private_key: Private sshKey algorithm of git repository.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] search_paths: Searching path of the repository
        :param pulumi.Input[bool] strict_host_key_checking: Strict host key checking or not.
        :param pulumi.Input[str] username: Username of git repository basic auth.
        """
        pulumi.set(__self__, "label", label)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "patterns", patterns)
        pulumi.set(__self__, "uri", uri)
        if host_key is not None:
            pulumi.set(__self__, "host_key", host_key)
        if host_key_algorithm is not None:
            pulumi.set(__self__, "host_key_algorithm", host_key_algorithm)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if private_key is not None:
            pulumi.set(__self__, "private_key", private_key)
        if search_paths is not None:
            pulumi.set(__self__, "search_paths", search_paths)
        if strict_host_key_checking is not None:
            pulumi.set(__self__, "strict_host_key_checking", strict_host_key_checking)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def label(self) -> pulumi.Input[str]:
        """
        Label of the repository
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: pulumi.Input[str]):
        pulumi.set(self, "label", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Name of the repository
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def patterns(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        Collection of patterns of the repository
        """
        return pulumi.get(self, "patterns")

    @patterns.setter
    def patterns(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "patterns", value)

    @property
    @pulumi.getter
    def uri(self) -> pulumi.Input[str]:
        """
        URI of the repository
        """
        return pulumi.get(self, "uri")

    @uri.setter
    def uri(self, value: pulumi.Input[str]):
        pulumi.set(self, "uri", value)

    @property
    @pulumi.getter(name="hostKey")
    def host_key(self) -> Optional[pulumi.Input[str]]:
        """
        Public sshKey of git repository.
        """
        return pulumi.get(self, "host_key")

    @host_key.setter
    def host_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host_key", value)

    @property
    @pulumi.getter(name="hostKeyAlgorithm")
    def host_key_algorithm(self) -> Optional[pulumi.Input[str]]:
        """
        SshKey algorithm of git repository.
        """
        return pulumi.get(self, "host_key_algorithm")

    @host_key_algorithm.setter
    def host_key_algorithm(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host_key_algorithm", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        Password of git repository basic auth.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> Optional[pulumi.Input[str]]:
        """
        Private sshKey algorithm of git repository.
        """
        return pulumi.get(self, "private_key")

    @private_key.setter
    def private_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_key", value)

    @property
    @pulumi.getter(name="searchPaths")
    def search_paths(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Searching path of the repository
        """
        return pulumi.get(self, "search_paths")

    @search_paths.setter
    def search_paths(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "search_paths", value)

    @property
    @pulumi.getter(name="strictHostKeyChecking")
    def strict_host_key_checking(self) -> Optional[pulumi.Input[bool]]:
        """
        Strict host key checking or not.
        """
        return pulumi.get(self, "strict_host_key_checking")

    @strict_host_key_checking.setter
    def strict_host_key_checking(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "strict_host_key_checking", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[str]]:
        """
        Username of git repository basic auth.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "username", value)


@pulumi.input_type
class ConfigurationServicePropertiesArgs:
    def __init__(__self__, *,
                 settings: Optional[pulumi.Input['ConfigurationServiceSettingsArgs']] = None):
        """
        Application Configuration Service properties payload
        :param pulumi.Input['ConfigurationServiceSettingsArgs'] settings: The settings of Application Configuration Service.
        """
        if settings is not None:
            pulumi.set(__self__, "settings", settings)

    @property
    @pulumi.getter
    def settings(self) -> Optional[pulumi.Input['ConfigurationServiceSettingsArgs']]:
        """
        The settings of Application Configuration Service.
        """
        return pulumi.get(self, "settings")

    @settings.setter
    def settings(self, value: Optional[pulumi.Input['ConfigurationServiceSettingsArgs']]):
        pulumi.set(self, "settings", value)


@pulumi.input_type
class ConfigurationServiceSettingsArgs:
    def __init__(__self__, *,
                 git_property: Optional[pulumi.Input['ConfigurationServiceGitPropertyArgs']] = None):
        """
        The settings of Application Configuration Service.
        :param pulumi.Input['ConfigurationServiceGitPropertyArgs'] git_property: Property of git environment.
        """
        if git_property is not None:
            pulumi.set(__self__, "git_property", git_property)

    @property
    @pulumi.getter(name="gitProperty")
    def git_property(self) -> Optional[pulumi.Input['ConfigurationServiceGitPropertyArgs']]:
        """
        Property of git environment.
        """
        return pulumi.get(self, "git_property")

    @git_property.setter
    def git_property(self, value: Optional[pulumi.Input['ConfigurationServiceGitPropertyArgs']]):
        pulumi.set(self, "git_property", value)


@pulumi.input_type
class ContentCertificatePropertiesArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 content: Optional[pulumi.Input[str]] = None):
        """
        Properties of certificate imported from key vault.
        :param pulumi.Input[str] type: The type of the certificate source.
               Expected value is 'ContentCertificate'.
        :param pulumi.Input[str] content: The content of uploaded certificate.
        """
        pulumi.set(__self__, "type", 'ContentCertificate')
        if content is not None:
            pulumi.set(__self__, "content", content)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The type of the certificate source.
        Expected value is 'ContentCertificate'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def content(self) -> Optional[pulumi.Input[str]]:
        """
        The content of uploaded certificate.
        """
        return pulumi.get(self, "content")

    @content.setter
    def content(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "content", value)


@pulumi.input_type
class CustomDomainPropertiesArgs:
    def __init__(__self__, *,
                 cert_name: Optional[pulumi.Input[str]] = None,
                 thumbprint: Optional[pulumi.Input[str]] = None):
        """
        Custom domain of app resource payload.
        :param pulumi.Input[str] cert_name: The bound certificate name of domain.
        :param pulumi.Input[str] thumbprint: The thumbprint of bound certificate.
        """
        if cert_name is not None:
            pulumi.set(__self__, "cert_name", cert_name)
        if thumbprint is not None:
            pulumi.set(__self__, "thumbprint", thumbprint)

    @property
    @pulumi.getter(name="certName")
    def cert_name(self) -> Optional[pulumi.Input[str]]:
        """
        The bound certificate name of domain.
        """
        return pulumi.get(self, "cert_name")

    @cert_name.setter
    def cert_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cert_name", value)

    @property
    @pulumi.getter
    def thumbprint(self) -> Optional[pulumi.Input[str]]:
        """
        The thumbprint of bound certificate.
        """
        return pulumi.get(self, "thumbprint")

    @thumbprint.setter
    def thumbprint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "thumbprint", value)


@pulumi.input_type
class DeploymentResourcePropertiesArgs:
    def __init__(__self__, *,
                 active: Optional[pulumi.Input[bool]] = None,
                 deployment_settings: Optional[pulumi.Input['DeploymentSettingsArgs']] = None,
                 source: Optional[pulumi.Input[Union['BuildResultUserSourceInfoArgs', 'JarUploadedUserSourceInfoArgs', 'NetCoreZipUploadedUserSourceInfoArgs', 'SourceUploadedUserSourceInfoArgs', 'UploadedUserSourceInfoArgs']]] = None):
        """
        Deployment resource properties payload
        :param pulumi.Input[bool] active: Indicates whether the Deployment is active
        :param pulumi.Input['DeploymentSettingsArgs'] deployment_settings: Deployment settings of the Deployment
        :param pulumi.Input[Union['BuildResultUserSourceInfoArgs', 'JarUploadedUserSourceInfoArgs', 'NetCoreZipUploadedUserSourceInfoArgs', 'SourceUploadedUserSourceInfoArgs', 'UploadedUserSourceInfoArgs']] source: Uploaded source information of the deployment.
        """
        if active is not None:
            pulumi.set(__self__, "active", active)
        if deployment_settings is not None:
            pulumi.set(__self__, "deployment_settings", deployment_settings)
        if source is not None:
            pulumi.set(__self__, "source", source)

    @property
    @pulumi.getter
    def active(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether the Deployment is active
        """
        return pulumi.get(self, "active")

    @active.setter
    def active(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "active", value)

    @property
    @pulumi.getter(name="deploymentSettings")
    def deployment_settings(self) -> Optional[pulumi.Input['DeploymentSettingsArgs']]:
        """
        Deployment settings of the Deployment
        """
        return pulumi.get(self, "deployment_settings")

    @deployment_settings.setter
    def deployment_settings(self, value: Optional[pulumi.Input['DeploymentSettingsArgs']]):
        pulumi.set(self, "deployment_settings", value)

    @property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input[Union['BuildResultUserSourceInfoArgs', 'JarUploadedUserSourceInfoArgs', 'NetCoreZipUploadedUserSourceInfoArgs', 'SourceUploadedUserSourceInfoArgs', 'UploadedUserSourceInfoArgs']]]:
        """
        Uploaded source information of the deployment.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input[Union['BuildResultUserSourceInfoArgs', 'JarUploadedUserSourceInfoArgs', 'NetCoreZipUploadedUserSourceInfoArgs', 'SourceUploadedUserSourceInfoArgs', 'UploadedUserSourceInfoArgs']]]):
        pulumi.set(self, "source", value)


@pulumi.input_type
class DeploymentSettingsArgs:
    def __init__(__self__, *,
                 addon_configs: Optional[pulumi.Input[Mapping[str, pulumi.Input[Mapping[str, Any]]]]] = None,
                 environment_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 resource_requests: Optional[pulumi.Input['ResourceRequestsArgs']] = None):
        """
        Deployment settings payload
        :param pulumi.Input[Mapping[str, pulumi.Input[Mapping[str, Any]]]] addon_configs: Collection of addons
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] environment_variables: Collection of environment variables
        :param pulumi.Input['ResourceRequestsArgs'] resource_requests: The requested resource quantity for required CPU and Memory. It is recommended that using this field to represent the required CPU and Memory, the old field cpu and memoryInGB will be deprecated later.
        """
        if addon_configs is not None:
            pulumi.set(__self__, "addon_configs", addon_configs)
        if environment_variables is not None:
            pulumi.set(__self__, "environment_variables", environment_variables)
        if resource_requests is not None:
            pulumi.set(__self__, "resource_requests", resource_requests)

    @property
    @pulumi.getter(name="addonConfigs")
    def addon_configs(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[Mapping[str, Any]]]]]:
        """
        Collection of addons
        """
        return pulumi.get(self, "addon_configs")

    @addon_configs.setter
    def addon_configs(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[Mapping[str, Any]]]]]):
        pulumi.set(self, "addon_configs", value)

    @property
    @pulumi.getter(name="environmentVariables")
    def environment_variables(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Collection of environment variables
        """
        return pulumi.get(self, "environment_variables")

    @environment_variables.setter
    def environment_variables(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "environment_variables", value)

    @property
    @pulumi.getter(name="resourceRequests")
    def resource_requests(self) -> Optional[pulumi.Input['ResourceRequestsArgs']]:
        """
        The requested resource quantity for required CPU and Memory. It is recommended that using this field to represent the required CPU and Memory, the old field cpu and memoryInGB will be deprecated later.
        """
        return pulumi.get(self, "resource_requests")

    @resource_requests.setter
    def resource_requests(self, value: Optional[pulumi.Input['ResourceRequestsArgs']]):
        pulumi.set(self, "resource_requests", value)


@pulumi.input_type
class JarUploadedUserSourceInfoArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 jvm_options: Optional[pulumi.Input[str]] = None,
                 relative_path: Optional[pulumi.Input[str]] = None,
                 runtime_version: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[str]] = None):
        """
        Uploaded Jar binary for a deployment
        :param pulumi.Input[str] type: Type of the source uploaded
               Expected value is 'Jar'.
        :param pulumi.Input[str] jvm_options: JVM parameter
        :param pulumi.Input[str] relative_path: Relative path of the storage which stores the source
        :param pulumi.Input[str] runtime_version: Runtime version of the Jar file
        :param pulumi.Input[str] version: Version of the source
        """
        pulumi.set(__self__, "type", 'Jar')
        if jvm_options is not None:
            pulumi.set(__self__, "jvm_options", jvm_options)
        if relative_path is not None:
            pulumi.set(__self__, "relative_path", relative_path)
        if runtime_version is not None:
            pulumi.set(__self__, "runtime_version", runtime_version)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of the source uploaded
        Expected value is 'Jar'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="jvmOptions")
    def jvm_options(self) -> Optional[pulumi.Input[str]]:
        """
        JVM parameter
        """
        return pulumi.get(self, "jvm_options")

    @jvm_options.setter
    def jvm_options(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "jvm_options", value)

    @property
    @pulumi.getter(name="relativePath")
    def relative_path(self) -> Optional[pulumi.Input[str]]:
        """
        Relative path of the storage which stores the source
        """
        return pulumi.get(self, "relative_path")

    @relative_path.setter
    def relative_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "relative_path", value)

    @property
    @pulumi.getter(name="runtimeVersion")
    def runtime_version(self) -> Optional[pulumi.Input[str]]:
        """
        Runtime version of the Jar file
        """
        return pulumi.get(self, "runtime_version")

    @runtime_version.setter
    def runtime_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "runtime_version", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        Version of the source
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class KeyVaultCertificatePropertiesArgs:
    def __init__(__self__, *,
                 key_vault_cert_name: pulumi.Input[str],
                 type: pulumi.Input[str],
                 vault_uri: pulumi.Input[str],
                 cert_version: Optional[pulumi.Input[str]] = None,
                 exclude_private_key: Optional[pulumi.Input[bool]] = None):
        """
        Properties of certificate imported from key vault.
        :param pulumi.Input[str] key_vault_cert_name: The certificate name of key vault.
        :param pulumi.Input[str] type: The type of the certificate source.
               Expected value is 'KeyVaultCertificate'.
        :param pulumi.Input[str] vault_uri: The vault uri of user key vault.
        :param pulumi.Input[str] cert_version: The certificate version of key vault.
        :param pulumi.Input[bool] exclude_private_key: Optional. If set to true, it will not import private key from key vault.
        """
        pulumi.set(__self__, "key_vault_cert_name", key_vault_cert_name)
        pulumi.set(__self__, "type", 'KeyVaultCertificate')
        pulumi.set(__self__, "vault_uri", vault_uri)
        if cert_version is not None:
            pulumi.set(__self__, "cert_version", cert_version)
        if exclude_private_key is None:
            exclude_private_key = False
        if exclude_private_key is not None:
            pulumi.set(__self__, "exclude_private_key", exclude_private_key)

    @property
    @pulumi.getter(name="keyVaultCertName")
    def key_vault_cert_name(self) -> pulumi.Input[str]:
        """
        The certificate name of key vault.
        """
        return pulumi.get(self, "key_vault_cert_name")

    @key_vault_cert_name.setter
    def key_vault_cert_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "key_vault_cert_name", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The type of the certificate source.
        Expected value is 'KeyVaultCertificate'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="vaultUri")
    def vault_uri(self) -> pulumi.Input[str]:
        """
        The vault uri of user key vault.
        """
        return pulumi.get(self, "vault_uri")

    @vault_uri.setter
    def vault_uri(self, value: pulumi.Input[str]):
        pulumi.set(self, "vault_uri", value)

    @property
    @pulumi.getter(name="certVersion")
    def cert_version(self) -> Optional[pulumi.Input[str]]:
        """
        The certificate version of key vault.
        """
        return pulumi.get(self, "cert_version")

    @cert_version.setter
    def cert_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cert_version", value)

    @property
    @pulumi.getter(name="excludePrivateKey")
    def exclude_private_key(self) -> Optional[pulumi.Input[bool]]:
        """
        Optional. If set to true, it will not import private key from key vault.
        """
        return pulumi.get(self, "exclude_private_key")

    @exclude_private_key.setter
    def exclude_private_key(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "exclude_private_key", value)


@pulumi.input_type
class LoadedCertificateArgs:
    def __init__(__self__, *,
                 resource_id: pulumi.Input[str],
                 load_trust_store: Optional[pulumi.Input[bool]] = None):
        """
        Loaded certificate payload
        :param pulumi.Input[str] resource_id: Resource Id of loaded certificate
        :param pulumi.Input[bool] load_trust_store: Indicate whether the certificate will be loaded into default trust store, only work for Java runtime.
        """
        pulumi.set(__self__, "resource_id", resource_id)
        if load_trust_store is None:
            load_trust_store = False
        if load_trust_store is not None:
            pulumi.set(__self__, "load_trust_store", load_trust_store)

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> pulumi.Input[str]:
        """
        Resource Id of loaded certificate
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "resource_id", value)

    @property
    @pulumi.getter(name="loadTrustStore")
    def load_trust_store(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicate whether the certificate will be loaded into default trust store, only work for Java runtime.
        """
        return pulumi.get(self, "load_trust_store")

    @load_trust_store.setter
    def load_trust_store(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "load_trust_store", value)


@pulumi.input_type
class ManagedIdentityPropertiesArgs:
    def __init__(__self__, *,
                 principal_id: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[Union[str, 'ManagedIdentityType']]] = None):
        """
        Managed identity properties retrieved from ARM request headers.
        :param pulumi.Input[str] principal_id: Principal Id of system-assigned managed identity.
        :param pulumi.Input[str] tenant_id: Tenant Id of system-assigned managed identity.
        :param pulumi.Input[Union[str, 'ManagedIdentityType']] type: Type of the managed identity
        """
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[pulumi.Input[str]]:
        """
        Principal Id of system-assigned managed identity.
        """
        return pulumi.get(self, "principal_id")

    @principal_id.setter
    def principal_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "principal_id", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        Tenant Id of system-assigned managed identity.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[Union[str, 'ManagedIdentityType']]]:
        """
        Type of the managed identity
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[Union[str, 'ManagedIdentityType']]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class NetCoreZipUploadedUserSourceInfoArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 net_core_main_entry_path: Optional[pulumi.Input[str]] = None,
                 relative_path: Optional[pulumi.Input[str]] = None,
                 runtime_version: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[str]] = None):
        """
        Uploaded Jar binary for a deployment
        :param pulumi.Input[str] type: Type of the source uploaded
               Expected value is 'NetCoreZip'.
        :param pulumi.Input[str] net_core_main_entry_path: The path to the .NET executable relative to zip root
        :param pulumi.Input[str] relative_path: Relative path of the storage which stores the source
        :param pulumi.Input[str] runtime_version: Runtime version of the .Net file
        :param pulumi.Input[str] version: Version of the source
        """
        pulumi.set(__self__, "type", 'NetCoreZip')
        if net_core_main_entry_path is not None:
            pulumi.set(__self__, "net_core_main_entry_path", net_core_main_entry_path)
        if relative_path is not None:
            pulumi.set(__self__, "relative_path", relative_path)
        if runtime_version is not None:
            pulumi.set(__self__, "runtime_version", runtime_version)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of the source uploaded
        Expected value is 'NetCoreZip'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="netCoreMainEntryPath")
    def net_core_main_entry_path(self) -> Optional[pulumi.Input[str]]:
        """
        The path to the .NET executable relative to zip root
        """
        return pulumi.get(self, "net_core_main_entry_path")

    @net_core_main_entry_path.setter
    def net_core_main_entry_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "net_core_main_entry_path", value)

    @property
    @pulumi.getter(name="relativePath")
    def relative_path(self) -> Optional[pulumi.Input[str]]:
        """
        Relative path of the storage which stores the source
        """
        return pulumi.get(self, "relative_path")

    @relative_path.setter
    def relative_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "relative_path", value)

    @property
    @pulumi.getter(name="runtimeVersion")
    def runtime_version(self) -> Optional[pulumi.Input[str]]:
        """
        Runtime version of the .Net file
        """
        return pulumi.get(self, "runtime_version")

    @runtime_version.setter
    def runtime_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "runtime_version", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        Version of the source
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class NetworkProfileArgs:
    def __init__(__self__, *,
                 app_network_resource_group: Optional[pulumi.Input[str]] = None,
                 app_subnet_id: Optional[pulumi.Input[str]] = None,
                 service_cidr: Optional[pulumi.Input[str]] = None,
                 service_runtime_network_resource_group: Optional[pulumi.Input[str]] = None,
                 service_runtime_subnet_id: Optional[pulumi.Input[str]] = None):
        """
        Service network profile payload
        :param pulumi.Input[str] app_network_resource_group: Name of the resource group containing network resources for customer apps in Azure Spring Apps
        :param pulumi.Input[str] app_subnet_id: Fully qualified resource Id of the subnet to host customer apps in Azure Spring Apps
        :param pulumi.Input[str] service_cidr: Azure Spring Apps service reserved CIDR
        :param pulumi.Input[str] service_runtime_network_resource_group: Name of the resource group containing network resources of Azure Spring Apps Service Runtime
        :param pulumi.Input[str] service_runtime_subnet_id: Fully qualified resource Id of the subnet to host Azure Spring Apps Service Runtime
        """
        if app_network_resource_group is not None:
            pulumi.set(__self__, "app_network_resource_group", app_network_resource_group)
        if app_subnet_id is not None:
            pulumi.set(__self__, "app_subnet_id", app_subnet_id)
        if service_cidr is not None:
            pulumi.set(__self__, "service_cidr", service_cidr)
        if service_runtime_network_resource_group is not None:
            pulumi.set(__self__, "service_runtime_network_resource_group", service_runtime_network_resource_group)
        if service_runtime_subnet_id is not None:
            pulumi.set(__self__, "service_runtime_subnet_id", service_runtime_subnet_id)

    @property
    @pulumi.getter(name="appNetworkResourceGroup")
    def app_network_resource_group(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the resource group containing network resources for customer apps in Azure Spring Apps
        """
        return pulumi.get(self, "app_network_resource_group")

    @app_network_resource_group.setter
    def app_network_resource_group(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "app_network_resource_group", value)

    @property
    @pulumi.getter(name="appSubnetId")
    def app_subnet_id(self) -> Optional[pulumi.Input[str]]:
        """
        Fully qualified resource Id of the subnet to host customer apps in Azure Spring Apps
        """
        return pulumi.get(self, "app_subnet_id")

    @app_subnet_id.setter
    def app_subnet_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "app_subnet_id", value)

    @property
    @pulumi.getter(name="serviceCidr")
    def service_cidr(self) -> Optional[pulumi.Input[str]]:
        """
        Azure Spring Apps service reserved CIDR
        """
        return pulumi.get(self, "service_cidr")

    @service_cidr.setter
    def service_cidr(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_cidr", value)

    @property
    @pulumi.getter(name="serviceRuntimeNetworkResourceGroup")
    def service_runtime_network_resource_group(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the resource group containing network resources of Azure Spring Apps Service Runtime
        """
        return pulumi.get(self, "service_runtime_network_resource_group")

    @service_runtime_network_resource_group.setter
    def service_runtime_network_resource_group(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_runtime_network_resource_group", value)

    @property
    @pulumi.getter(name="serviceRuntimeSubnetId")
    def service_runtime_subnet_id(self) -> Optional[pulumi.Input[str]]:
        """
        Fully qualified resource Id of the subnet to host Azure Spring Apps Service Runtime
        """
        return pulumi.get(self, "service_runtime_subnet_id")

    @service_runtime_subnet_id.setter
    def service_runtime_subnet_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_runtime_subnet_id", value)


@pulumi.input_type
class PersistentDiskArgs:
    def __init__(__self__, *,
                 mount_path: Optional[pulumi.Input[str]] = None,
                 size_in_gb: Optional[pulumi.Input[int]] = None):
        """
        Persistent disk payload
        :param pulumi.Input[str] mount_path: Mount path of the persistent disk
        :param pulumi.Input[int] size_in_gb: Size of the persistent disk in GB
        """
        if mount_path is not None:
            pulumi.set(__self__, "mount_path", mount_path)
        if size_in_gb is not None:
            pulumi.set(__self__, "size_in_gb", size_in_gb)

    @property
    @pulumi.getter(name="mountPath")
    def mount_path(self) -> Optional[pulumi.Input[str]]:
        """
        Mount path of the persistent disk
        """
        return pulumi.get(self, "mount_path")

    @mount_path.setter
    def mount_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mount_path", value)

    @property
    @pulumi.getter(name="sizeInGB")
    def size_in_gb(self) -> Optional[pulumi.Input[int]]:
        """
        Size of the persistent disk in GB
        """
        return pulumi.get(self, "size_in_gb")

    @size_in_gb.setter
    def size_in_gb(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "size_in_gb", value)


@pulumi.input_type
class ResourceRequestsArgs:
    def __init__(__self__, *,
                 cpu: Optional[pulumi.Input[str]] = None,
                 memory: Optional[pulumi.Input[str]] = None):
        """
        Deployment resource request payload
        :param pulumi.Input[str] cpu: Required CPU. 1 core can be represented by 1 or 1000m. This should be 500m or 1 for Basic tier, and {500m, 1, 2, 3, 4} for Standard tier.
        :param pulumi.Input[str] memory: Required memory. 1 GB can be represented by 1Gi or 1024Mi. This should be {512Mi, 1Gi, 2Gi} for Basic tier, and {512Mi, 1Gi, 2Gi, ..., 8Gi} for Standard tier.
        """
        if cpu is not None:
            pulumi.set(__self__, "cpu", cpu)
        if memory is not None:
            pulumi.set(__self__, "memory", memory)

    @property
    @pulumi.getter
    def cpu(self) -> Optional[pulumi.Input[str]]:
        """
        Required CPU. 1 core can be represented by 1 or 1000m. This should be 500m or 1 for Basic tier, and {500m, 1, 2, 3, 4} for Standard tier.
        """
        return pulumi.get(self, "cpu")

    @cpu.setter
    def cpu(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cpu", value)

    @property
    @pulumi.getter
    def memory(self) -> Optional[pulumi.Input[str]]:
        """
        Required memory. 1 GB can be represented by 1Gi or 1024Mi. This should be {512Mi, 1Gi, 2Gi} for Basic tier, and {512Mi, 1Gi, 2Gi, ..., 8Gi} for Standard tier.
        """
        return pulumi.get(self, "memory")

    @memory.setter
    def memory(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "memory", value)


@pulumi.input_type
class SkuArgs:
    def __init__(__self__, *,
                 capacity: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 tier: Optional[pulumi.Input[str]] = None):
        """
        Sku of Azure Spring Apps
        :param pulumi.Input[int] capacity: Current capacity of the target resource
        :param pulumi.Input[str] name: Name of the Sku
        :param pulumi.Input[str] tier: Tier of the Sku
        """
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)
        if name is None:
            name = 'S0'
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tier is None:
            tier = 'Standard'
        if tier is not None:
            pulumi.set(__self__, "tier", tier)

    @property
    @pulumi.getter
    def capacity(self) -> Optional[pulumi.Input[int]]:
        """
        Current capacity of the target resource
        """
        return pulumi.get(self, "capacity")

    @capacity.setter
    def capacity(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "capacity", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the Sku
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def tier(self) -> Optional[pulumi.Input[str]]:
        """
        Tier of the Sku
        """
        return pulumi.get(self, "tier")

    @tier.setter
    def tier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tier", value)


@pulumi.input_type
class SourceUploadedUserSourceInfoArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 artifact_selector: Optional[pulumi.Input[str]] = None,
                 relative_path: Optional[pulumi.Input[str]] = None,
                 runtime_version: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[str]] = None):
        """
        Uploaded Java source code binary for a deployment
        :param pulumi.Input[str] type: Type of the source uploaded
               Expected value is 'Source'.
        :param pulumi.Input[str] artifact_selector: Selector for the artifact to be used for the deployment for multi-module projects. This should be
               the relative path to the target module/project.
        :param pulumi.Input[str] relative_path: Relative path of the storage which stores the source
        :param pulumi.Input[str] runtime_version: Runtime version of the source file
        :param pulumi.Input[str] version: Version of the source
        """
        pulumi.set(__self__, "type", 'Source')
        if artifact_selector is not None:
            pulumi.set(__self__, "artifact_selector", artifact_selector)
        if relative_path is not None:
            pulumi.set(__self__, "relative_path", relative_path)
        if runtime_version is not None:
            pulumi.set(__self__, "runtime_version", runtime_version)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of the source uploaded
        Expected value is 'Source'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="artifactSelector")
    def artifact_selector(self) -> Optional[pulumi.Input[str]]:
        """
        Selector for the artifact to be used for the deployment for multi-module projects. This should be
        the relative path to the target module/project.
        """
        return pulumi.get(self, "artifact_selector")

    @artifact_selector.setter
    def artifact_selector(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "artifact_selector", value)

    @property
    @pulumi.getter(name="relativePath")
    def relative_path(self) -> Optional[pulumi.Input[str]]:
        """
        Relative path of the storage which stores the source
        """
        return pulumi.get(self, "relative_path")

    @relative_path.setter
    def relative_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "relative_path", value)

    @property
    @pulumi.getter(name="runtimeVersion")
    def runtime_version(self) -> Optional[pulumi.Input[str]]:
        """
        Runtime version of the source file
        """
        return pulumi.get(self, "runtime_version")

    @runtime_version.setter
    def runtime_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "runtime_version", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        Version of the source
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class StackPropertiesArgs:
    def __init__(__self__, *,
                 id: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[str]] = None):
        """
        KPack ClusterStack properties payload
        :param pulumi.Input[str] id: Id of the ClusterStack.
        :param pulumi.Input[str] version: Version of the ClusterStack
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Id of the ClusterStack.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        Version of the ClusterStack
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class TemporaryDiskArgs:
    def __init__(__self__, *,
                 mount_path: Optional[pulumi.Input[str]] = None,
                 size_in_gb: Optional[pulumi.Input[int]] = None):
        """
        Temporary disk payload
        :param pulumi.Input[str] mount_path: Mount path of the temporary disk
        :param pulumi.Input[int] size_in_gb: Size of the temporary disk in GB
        """
        if mount_path is None:
            mount_path = '/tmp'
        if mount_path is not None:
            pulumi.set(__self__, "mount_path", mount_path)
        if size_in_gb is not None:
            pulumi.set(__self__, "size_in_gb", size_in_gb)

    @property
    @pulumi.getter(name="mountPath")
    def mount_path(self) -> Optional[pulumi.Input[str]]:
        """
        Mount path of the temporary disk
        """
        return pulumi.get(self, "mount_path")

    @mount_path.setter
    def mount_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mount_path", value)

    @property
    @pulumi.getter(name="sizeInGB")
    def size_in_gb(self) -> Optional[pulumi.Input[int]]:
        """
        Size of the temporary disk in GB
        """
        return pulumi.get(self, "size_in_gb")

    @size_in_gb.setter
    def size_in_gb(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "size_in_gb", value)


@pulumi.input_type
class UploadedUserSourceInfoArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 relative_path: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[str]] = None):
        """
        Source with uploaded location
        :param pulumi.Input[str] type: Type of the source uploaded
               Expected value is 'UploadedUserSourceInfo'.
        :param pulumi.Input[str] relative_path: Relative path of the storage which stores the source
        :param pulumi.Input[str] version: Version of the source
        """
        pulumi.set(__self__, "type", 'UploadedUserSourceInfo')
        if relative_path is not None:
            pulumi.set(__self__, "relative_path", relative_path)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of the source uploaded
        Expected value is 'UploadedUserSourceInfo'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="relativePath")
    def relative_path(self) -> Optional[pulumi.Input[str]]:
        """
        Relative path of the storage which stores the source
        """
        return pulumi.get(self, "relative_path")

    @relative_path.setter
    def relative_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "relative_path", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        Version of the source
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)


