# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'ComplianceStatusResponse',
    'ConfigurationIdentityResponse',
    'ErrorDefinitionResponse',
    'ExtensionStatusResponse',
    'HelmOperatorPropertiesResponse',
    'ScopeClusterResponse',
    'ScopeNamespaceResponse',
    'ScopeResponse',
    'SystemDataResponse',
]

@pulumi.output_type
class ComplianceStatusResponse(dict):
    """
    Compliance Status details
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "complianceState":
            suggest = "compliance_state"
        elif key == "lastConfigApplied":
            suggest = "last_config_applied"
        elif key == "messageLevel":
            suggest = "message_level"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ComplianceStatusResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ComplianceStatusResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ComplianceStatusResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 compliance_state: str,
                 last_config_applied: Optional[str] = None,
                 message: Optional[str] = None,
                 message_level: Optional[str] = None):
        """
        Compliance Status details
        :param str compliance_state: The compliance state of the configuration.
        :param str last_config_applied: Datetime the configuration was last applied.
        :param str message: Message from when the configuration was applied.
        :param str message_level: Level of the message.
        """
        pulumi.set(__self__, "compliance_state", compliance_state)
        if last_config_applied is not None:
            pulumi.set(__self__, "last_config_applied", last_config_applied)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if message_level is not None:
            pulumi.set(__self__, "message_level", message_level)

    @property
    @pulumi.getter(name="complianceState")
    def compliance_state(self) -> str:
        """
        The compliance state of the configuration.
        """
        return pulumi.get(self, "compliance_state")

    @property
    @pulumi.getter(name="lastConfigApplied")
    def last_config_applied(self) -> Optional[str]:
        """
        Datetime the configuration was last applied.
        """
        return pulumi.get(self, "last_config_applied")

    @property
    @pulumi.getter
    def message(self) -> Optional[str]:
        """
        Message from when the configuration was applied.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter(name="messageLevel")
    def message_level(self) -> Optional[str]:
        """
        Level of the message.
        """
        return pulumi.get(self, "message_level")


@pulumi.output_type
class ConfigurationIdentityResponse(dict):
    """
    Identity for the managed cluster.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "principalId":
            suggest = "principal_id"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConfigurationIdentityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConfigurationIdentityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConfigurationIdentityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 principal_id: str,
                 tenant_id: str,
                 type: Optional[str] = None):
        """
        Identity for the managed cluster.
        :param str principal_id: The principal id of the system assigned identity which is used by the configuration.
        :param str tenant_id: The tenant id of the system assigned identity which is used by the configuration.
        :param str type: The type of identity used for the configuration. Type 'SystemAssigned' will use an implicitly created identity. Type 'None' will not use Managed Identity for the configuration.
        """
        pulumi.set(__self__, "principal_id", principal_id)
        pulumi.set(__self__, "tenant_id", tenant_id)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> str:
        """
        The principal id of the system assigned identity which is used by the configuration.
        """
        return pulumi.get(self, "principal_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> str:
        """
        The tenant id of the system assigned identity which is used by the configuration.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The type of identity used for the configuration. Type 'SystemAssigned' will use an implicitly created identity. Type 'None' will not use Managed Identity for the configuration.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ErrorDefinitionResponse(dict):
    """
    Error definition.
    """
    def __init__(__self__, *,
                 code: str,
                 message: str):
        """
        Error definition.
        :param str code: Service specific error code which serves as the substatus for the HTTP error code.
        :param str message: Description of the error.
        """
        pulumi.set(__self__, "code", code)
        pulumi.set(__self__, "message", message)

    @property
    @pulumi.getter
    def code(self) -> str:
        """
        Service specific error code which serves as the substatus for the HTTP error code.
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter
    def message(self) -> str:
        """
        Description of the error.
        """
        return pulumi.get(self, "message")


@pulumi.output_type
class ExtensionStatusResponse(dict):
    """
    Status from this instance of the extension.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "displayStatus":
            suggest = "display_status"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ExtensionStatusResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ExtensionStatusResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ExtensionStatusResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 code: Optional[str] = None,
                 display_status: Optional[str] = None,
                 level: Optional[str] = None,
                 message: Optional[str] = None,
                 time: Optional[str] = None):
        """
        Status from this instance of the extension.
        :param str code: Status code provided by the Extension
        :param str display_status: Short description of status of this instance of the extension.
        :param str level: Level of the status.
        :param str message: Detailed message of the status from the Extension instance.
        :param str time: DateLiteral (per ISO8601) noting the time of installation status.
        """
        if code is not None:
            pulumi.set(__self__, "code", code)
        if display_status is not None:
            pulumi.set(__self__, "display_status", display_status)
        if level is None:
            level = 'Information'
        if level is not None:
            pulumi.set(__self__, "level", level)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if time is not None:
            pulumi.set(__self__, "time", time)

    @property
    @pulumi.getter
    def code(self) -> Optional[str]:
        """
        Status code provided by the Extension
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter(name="displayStatus")
    def display_status(self) -> Optional[str]:
        """
        Short description of status of this instance of the extension.
        """
        return pulumi.get(self, "display_status")

    @property
    @pulumi.getter
    def level(self) -> Optional[str]:
        """
        Level of the status.
        """
        return pulumi.get(self, "level")

    @property
    @pulumi.getter
    def message(self) -> Optional[str]:
        """
        Detailed message of the status from the Extension instance.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def time(self) -> Optional[str]:
        """
        DateLiteral (per ISO8601) noting the time of installation status.
        """
        return pulumi.get(self, "time")


@pulumi.output_type
class HelmOperatorPropertiesResponse(dict):
    """
    Properties for Helm operator.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "chartValues":
            suggest = "chart_values"
        elif key == "chartVersion":
            suggest = "chart_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HelmOperatorPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HelmOperatorPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HelmOperatorPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 chart_values: Optional[str] = None,
                 chart_version: Optional[str] = None):
        """
        Properties for Helm operator.
        :param str chart_values: Values override for the operator Helm chart.
        :param str chart_version: Version of the operator Helm chart.
        """
        if chart_values is not None:
            pulumi.set(__self__, "chart_values", chart_values)
        if chart_version is not None:
            pulumi.set(__self__, "chart_version", chart_version)

    @property
    @pulumi.getter(name="chartValues")
    def chart_values(self) -> Optional[str]:
        """
        Values override for the operator Helm chart.
        """
        return pulumi.get(self, "chart_values")

    @property
    @pulumi.getter(name="chartVersion")
    def chart_version(self) -> Optional[str]:
        """
        Version of the operator Helm chart.
        """
        return pulumi.get(self, "chart_version")


@pulumi.output_type
class ScopeClusterResponse(dict):
    """
    Specifies that the scope of the extensionInstance is Cluster
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "releaseNamespace":
            suggest = "release_namespace"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScopeClusterResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScopeClusterResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScopeClusterResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 release_namespace: Optional[str] = None):
        """
        Specifies that the scope of the extensionInstance is Cluster
        :param str release_namespace: Namespace where the extension Release must be placed, for a Cluster scoped extensionInstance.  If this namespace does not exist, it will be created
        """
        if release_namespace is not None:
            pulumi.set(__self__, "release_namespace", release_namespace)

    @property
    @pulumi.getter(name="releaseNamespace")
    def release_namespace(self) -> Optional[str]:
        """
        Namespace where the extension Release must be placed, for a Cluster scoped extensionInstance.  If this namespace does not exist, it will be created
        """
        return pulumi.get(self, "release_namespace")


@pulumi.output_type
class ScopeNamespaceResponse(dict):
    """
    Specifies that the scope of the extensionInstance is Namespace
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "targetNamespace":
            suggest = "target_namespace"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScopeNamespaceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScopeNamespaceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScopeNamespaceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 target_namespace: Optional[str] = None):
        """
        Specifies that the scope of the extensionInstance is Namespace
        :param str target_namespace: Namespace where the extensionInstance will be created for an Namespace scoped extensionInstance.  If this namespace does not exist, it will be created
        """
        if target_namespace is not None:
            pulumi.set(__self__, "target_namespace", target_namespace)

    @property
    @pulumi.getter(name="targetNamespace")
    def target_namespace(self) -> Optional[str]:
        """
        Namespace where the extensionInstance will be created for an Namespace scoped extensionInstance.  If this namespace does not exist, it will be created
        """
        return pulumi.get(self, "target_namespace")


@pulumi.output_type
class ScopeResponse(dict):
    """
    Scope of the extensionInstance. It can be either Cluster or Namespace; but not both.
    """
    def __init__(__self__, *,
                 cluster: Optional['outputs.ScopeClusterResponse'] = None,
                 namespace: Optional['outputs.ScopeNamespaceResponse'] = None):
        """
        Scope of the extensionInstance. It can be either Cluster or Namespace; but not both.
        :param 'ScopeClusterResponse' cluster: Specifies that the scope of the extensionInstance is Cluster
        :param 'ScopeNamespaceResponse' namespace: Specifies that the scope of the extensionInstance is Namespace
        """
        if cluster is not None:
            pulumi.set(__self__, "cluster", cluster)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)

    @property
    @pulumi.getter
    def cluster(self) -> Optional['outputs.ScopeClusterResponse']:
        """
        Specifies that the scope of the extensionInstance is Cluster
        """
        return pulumi.get(self, "cluster")

    @property
    @pulumi.getter
    def namespace(self) -> Optional['outputs.ScopeNamespaceResponse']:
        """
        Specifies that the scope of the extensionInstance is Namespace
        """
        return pulumi.get(self, "namespace")


@pulumi.output_type
class SystemDataResponse(dict):
    """
    Top level metadata https://github.com/Azure/azure-resource-manager-rpc/blob/master/v1.0/common-api-contracts.md#system-metadata-for-all-azure-resources
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createdAt":
            suggest = "created_at"
        elif key == "createdBy":
            suggest = "created_by"
        elif key == "createdByType":
            suggest = "created_by_type"
        elif key == "lastModifiedAt":
            suggest = "last_modified_at"
        elif key == "lastModifiedBy":
            suggest = "last_modified_by"
        elif key == "lastModifiedByType":
            suggest = "last_modified_by_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SystemDataResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SystemDataResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SystemDataResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 created_at: str,
                 created_by: str,
                 created_by_type: str,
                 last_modified_at: str,
                 last_modified_by: str,
                 last_modified_by_type: str):
        """
        Top level metadata https://github.com/Azure/azure-resource-manager-rpc/blob/master/v1.0/common-api-contracts.md#system-metadata-for-all-azure-resources
        :param str created_at: The timestamp of resource creation (UTC)
        :param str created_by: A string identifier for the identity that created the resource
        :param str created_by_type: The type of identity that created the resource: user, application, managedIdentity, key
        :param str last_modified_at: The timestamp of resource last modification (UTC)
        :param str last_modified_by: A string identifier for the identity that last modified the resource
        :param str last_modified_by_type: The type of identity that last modified the resource: user, application, managedIdentity, key
        """
        pulumi.set(__self__, "created_at", created_at)
        pulumi.set(__self__, "created_by", created_by)
        pulumi.set(__self__, "created_by_type", created_by_type)
        pulumi.set(__self__, "last_modified_at", last_modified_at)
        pulumi.set(__self__, "last_modified_by", last_modified_by)
        pulumi.set(__self__, "last_modified_by_type", last_modified_by_type)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> str:
        """
        The timestamp of resource creation (UTC)
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> str:
        """
        A string identifier for the identity that created the resource
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter(name="createdByType")
    def created_by_type(self) -> str:
        """
        The type of identity that created the resource: user, application, managedIdentity, key
        """
        return pulumi.get(self, "created_by_type")

    @property
    @pulumi.getter(name="lastModifiedAt")
    def last_modified_at(self) -> str:
        """
        The timestamp of resource last modification (UTC)
        """
        return pulumi.get(self, "last_modified_at")

    @property
    @pulumi.getter(name="lastModifiedBy")
    def last_modified_by(self) -> str:
        """
        A string identifier for the identity that last modified the resource
        """
        return pulumi.get(self, "last_modified_by")

    @property
    @pulumi.getter(name="lastModifiedByType")
    def last_modified_by_type(self) -> str:
        """
        The type of identity that last modified the resource: user, application, managedIdentity, key
        """
        return pulumi.get(self, "last_modified_by_type")


