# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['ServiceArgs', 'Service']

@pulumi.input_type
class ServiceArgs:
    def __init__(__self__, *,
                 resource_group_name: pulumi.Input[str],
                 service_topology_name: pulumi.Input[str],
                 target_location: pulumi.Input[str],
                 target_subscription_id: pulumi.Input[str],
                 location: Optional[pulumi.Input[str]] = None,
                 service_name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a Service resource.
        :param pulumi.Input[str] resource_group_name: The name of the resource group. The name is case insensitive.
        :param pulumi.Input[str] service_topology_name: The name of the service topology .
        :param pulumi.Input[str] target_location: The Azure location to which the resources in the service belong to or should be deployed to.
        :param pulumi.Input[str] target_subscription_id: The subscription to which the resources in the service belong to or should be deployed to.
        :param pulumi.Input[str] location: The geo-location where the resource lives
        :param pulumi.Input[str] service_name: The name of the service resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Resource tags.
        """
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "service_topology_name", service_topology_name)
        pulumi.set(__self__, "target_location", target_location)
        pulumi.set(__self__, "target_subscription_id", target_subscription_id)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if service_name is not None:
            pulumi.set(__self__, "service_name", service_name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[str]:
        """
        The name of the resource group. The name is case insensitive.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter(name="serviceTopologyName")
    def service_topology_name(self) -> pulumi.Input[str]:
        """
        The name of the service topology .
        """
        return pulumi.get(self, "service_topology_name")

    @service_topology_name.setter
    def service_topology_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "service_topology_name", value)

    @property
    @pulumi.getter(name="targetLocation")
    def target_location(self) -> pulumi.Input[str]:
        """
        The Azure location to which the resources in the service belong to or should be deployed to.
        """
        return pulumi.get(self, "target_location")

    @target_location.setter
    def target_location(self, value: pulumi.Input[str]):
        pulumi.set(self, "target_location", value)

    @property
    @pulumi.getter(name="targetSubscriptionId")
    def target_subscription_id(self) -> pulumi.Input[str]:
        """
        The subscription to which the resources in the service belong to or should be deployed to.
        """
        return pulumi.get(self, "target_subscription_id")

    @target_subscription_id.setter
    def target_subscription_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "target_subscription_id", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        The geo-location where the resource lives
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the service resource.
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Resource tags.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


class Service(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 resource_group_name: Optional[pulumi.Input[str]] = None,
                 service_name: Optional[pulumi.Input[str]] = None,
                 service_topology_name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 target_location: Optional[pulumi.Input[str]] = None,
                 target_subscription_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        The resource representation of a service in a service topology.
        API Version: 2019-11-01-preview.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] location: The geo-location where the resource lives
        :param pulumi.Input[str] resource_group_name: The name of the resource group. The name is case insensitive.
        :param pulumi.Input[str] service_name: The name of the service resource.
        :param pulumi.Input[str] service_topology_name: The name of the service topology .
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Resource tags.
        :param pulumi.Input[str] target_location: The Azure location to which the resources in the service belong to or should be deployed to.
        :param pulumi.Input[str] target_subscription_id: The subscription to which the resources in the service belong to or should be deployed to.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ServiceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The resource representation of a service in a service topology.
        API Version: 2019-11-01-preview.

        :param str resource_name: The name of the resource.
        :param ServiceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ServiceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 resource_group_name: Optional[pulumi.Input[str]] = None,
                 service_name: Optional[pulumi.Input[str]] = None,
                 service_topology_name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 target_location: Optional[pulumi.Input[str]] = None,
                 target_subscription_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ServiceArgs.__new__(ServiceArgs)

            __props__.__dict__["location"] = location
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["service_name"] = service_name
            if service_topology_name is None and not opts.urn:
                raise TypeError("Missing required property 'service_topology_name'")
            __props__.__dict__["service_topology_name"] = service_topology_name
            __props__.__dict__["tags"] = tags
            if target_location is None and not opts.urn:
                raise TypeError("Missing required property 'target_location'")
            __props__.__dict__["target_location"] = target_location
            if target_subscription_id is None and not opts.urn:
                raise TypeError("Missing required property 'target_subscription_id'")
            __props__.__dict__["target_subscription_id"] = target_subscription_id
            __props__.__dict__["name"] = None
            __props__.__dict__["type"] = None
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="azure-native:deploymentmanager/v20180901preview:Service"), pulumi.Alias(type_="azure-native:deploymentmanager/v20191101preview:Service")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        super(Service, __self__).__init__(
            'azure-native:deploymentmanager:Service',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Service':
        """
        Get an existing Service resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = ServiceArgs.__new__(ServiceArgs)

        __props__.__dict__["location"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["tags"] = None
        __props__.__dict__["target_location"] = None
        __props__.__dict__["target_subscription_id"] = None
        __props__.__dict__["type"] = None
        return Service(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[str]:
        """
        The geo-location where the resource lives
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Resource tags.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="targetLocation")
    def target_location(self) -> pulumi.Output[str]:
        """
        The Azure location to which the resources in the service belong to or should be deployed to.
        """
        return pulumi.get(self, "target_location")

    @property
    @pulumi.getter(name="targetSubscriptionId")
    def target_subscription_id(self) -> pulumi.Output[str]:
        """
        The subscription to which the resources in the service belong to or should be deployed to.
        """
        return pulumi.get(self, "target_subscription_id")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
        """
        return pulumi.get(self, "type")

