# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetCertificateResult',
    'AwaitableGetCertificateResult',
    'get_certificate',
    'get_certificate_output',
]

warnings.warn("""Version v20150801 will be removed in the next major version of the provider. Upgrade to version v20150801preview or later.""", DeprecationWarning)

@pulumi.output_type
class GetCertificateResult:
    """
    App certificate
    """
    def __init__(__self__, cer_blob=None, expiration_date=None, friendly_name=None, host_names=None, hosting_environment_profile=None, id=None, issue_date=None, issuer=None, kind=None, location=None, name=None, password=None, pfx_blob=None, public_key_hash=None, self_link=None, site_name=None, subject_name=None, tags=None, thumbprint=None, type=None, valid=None):
        if cer_blob and not isinstance(cer_blob, str):
            raise TypeError("Expected argument 'cer_blob' to be a str")
        pulumi.set(__self__, "cer_blob", cer_blob)
        if expiration_date and not isinstance(expiration_date, str):
            raise TypeError("Expected argument 'expiration_date' to be a str")
        pulumi.set(__self__, "expiration_date", expiration_date)
        if friendly_name and not isinstance(friendly_name, str):
            raise TypeError("Expected argument 'friendly_name' to be a str")
        pulumi.set(__self__, "friendly_name", friendly_name)
        if host_names and not isinstance(host_names, list):
            raise TypeError("Expected argument 'host_names' to be a list")
        pulumi.set(__self__, "host_names", host_names)
        if hosting_environment_profile and not isinstance(hosting_environment_profile, dict):
            raise TypeError("Expected argument 'hosting_environment_profile' to be a dict")
        pulumi.set(__self__, "hosting_environment_profile", hosting_environment_profile)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if issue_date and not isinstance(issue_date, str):
            raise TypeError("Expected argument 'issue_date' to be a str")
        pulumi.set(__self__, "issue_date", issue_date)
        if issuer and not isinstance(issuer, str):
            raise TypeError("Expected argument 'issuer' to be a str")
        pulumi.set(__self__, "issuer", issuer)
        if kind and not isinstance(kind, str):
            raise TypeError("Expected argument 'kind' to be a str")
        pulumi.set(__self__, "kind", kind)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if password and not isinstance(password, str):
            raise TypeError("Expected argument 'password' to be a str")
        pulumi.set(__self__, "password", password)
        if pfx_blob and not isinstance(pfx_blob, str):
            raise TypeError("Expected argument 'pfx_blob' to be a str")
        pulumi.set(__self__, "pfx_blob", pfx_blob)
        if public_key_hash and not isinstance(public_key_hash, str):
            raise TypeError("Expected argument 'public_key_hash' to be a str")
        pulumi.set(__self__, "public_key_hash", public_key_hash)
        if self_link and not isinstance(self_link, str):
            raise TypeError("Expected argument 'self_link' to be a str")
        pulumi.set(__self__, "self_link", self_link)
        if site_name and not isinstance(site_name, str):
            raise TypeError("Expected argument 'site_name' to be a str")
        pulumi.set(__self__, "site_name", site_name)
        if subject_name and not isinstance(subject_name, str):
            raise TypeError("Expected argument 'subject_name' to be a str")
        pulumi.set(__self__, "subject_name", subject_name)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if thumbprint and not isinstance(thumbprint, str):
            raise TypeError("Expected argument 'thumbprint' to be a str")
        pulumi.set(__self__, "thumbprint", thumbprint)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)
        if valid and not isinstance(valid, bool):
            raise TypeError("Expected argument 'valid' to be a bool")
        pulumi.set(__self__, "valid", valid)

    @property
    @pulumi.getter(name="cerBlob")
    def cer_blob(self) -> Optional[str]:
        """
        Raw bytes of .cer file
        """
        return pulumi.get(self, "cer_blob")

    @property
    @pulumi.getter(name="expirationDate")
    def expiration_date(self) -> Optional[str]:
        """
        Certificate expiration date
        """
        return pulumi.get(self, "expiration_date")

    @property
    @pulumi.getter(name="friendlyName")
    def friendly_name(self) -> Optional[str]:
        """
        Friendly name of the certificate
        """
        return pulumi.get(self, "friendly_name")

    @property
    @pulumi.getter(name="hostNames")
    def host_names(self) -> Optional[Sequence[str]]:
        """
        Host names the certificate applies to
        """
        return pulumi.get(self, "host_names")

    @property
    @pulumi.getter(name="hostingEnvironmentProfile")
    def hosting_environment_profile(self) -> Optional['outputs.HostingEnvironmentProfileResponse']:
        """
        Specification for the hosting environment (App Service Environment) to use for the certificate
        """
        return pulumi.get(self, "hosting_environment_profile")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource Id
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="issueDate")
    def issue_date(self) -> Optional[str]:
        """
        Certificate issue Date
        """
        return pulumi.get(self, "issue_date")

    @property
    @pulumi.getter
    def issuer(self) -> Optional[str]:
        """
        Certificate issuer
        """
        return pulumi.get(self, "issuer")

    @property
    @pulumi.getter
    def kind(self) -> Optional[str]:
        """
        Kind of resource
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def location(self) -> str:
        """
        Resource Location
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Resource Name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def password(self) -> Optional[str]:
        """
        Certificate password
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="pfxBlob")
    def pfx_blob(self) -> Optional[str]:
        """
        Pfx blob
        """
        return pulumi.get(self, "pfx_blob")

    @property
    @pulumi.getter(name="publicKeyHash")
    def public_key_hash(self) -> Optional[str]:
        """
        Public key hash
        """
        return pulumi.get(self, "public_key_hash")

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> Optional[str]:
        """
        Self link
        """
        return pulumi.get(self, "self_link")

    @property
    @pulumi.getter(name="siteName")
    def site_name(self) -> Optional[str]:
        """
        App name
        """
        return pulumi.get(self, "site_name")

    @property
    @pulumi.getter(name="subjectName")
    def subject_name(self) -> Optional[str]:
        """
        Subject name of the certificate
        """
        return pulumi.get(self, "subject_name")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        Resource tags
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def thumbprint(self) -> Optional[str]:
        """
        Certificate thumbprint
        """
        return pulumi.get(self, "thumbprint")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        Resource type
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def valid(self) -> Optional[bool]:
        """
        Is the certificate valid?
        """
        return pulumi.get(self, "valid")


class AwaitableGetCertificateResult(GetCertificateResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCertificateResult(
            cer_blob=self.cer_blob,
            expiration_date=self.expiration_date,
            friendly_name=self.friendly_name,
            host_names=self.host_names,
            hosting_environment_profile=self.hosting_environment_profile,
            id=self.id,
            issue_date=self.issue_date,
            issuer=self.issuer,
            kind=self.kind,
            location=self.location,
            name=self.name,
            password=self.password,
            pfx_blob=self.pfx_blob,
            public_key_hash=self.public_key_hash,
            self_link=self.self_link,
            site_name=self.site_name,
            subject_name=self.subject_name,
            tags=self.tags,
            thumbprint=self.thumbprint,
            type=self.type,
            valid=self.valid)


def get_certificate(name: Optional[str] = None,
                    resource_group_name: Optional[str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCertificateResult:
    """
    App certificate


    :param str name: Name of the certificate.
    :param str resource_group_name: Name of the resource group
    """
    pulumi.log.warn("""get_certificate is deprecated: Version v20150801 will be removed in the next major version of the provider. Upgrade to version v20150801preview or later.""")
    __args__ = dict()
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('azure-native:web/v20150801:getCertificate', __args__, opts=opts, typ=GetCertificateResult).value

    return AwaitableGetCertificateResult(
        cer_blob=__ret__.cer_blob,
        expiration_date=__ret__.expiration_date,
        friendly_name=__ret__.friendly_name,
        host_names=__ret__.host_names,
        hosting_environment_profile=__ret__.hosting_environment_profile,
        id=__ret__.id,
        issue_date=__ret__.issue_date,
        issuer=__ret__.issuer,
        kind=__ret__.kind,
        location=__ret__.location,
        name=__ret__.name,
        password=__ret__.password,
        pfx_blob=__ret__.pfx_blob,
        public_key_hash=__ret__.public_key_hash,
        self_link=__ret__.self_link,
        site_name=__ret__.site_name,
        subject_name=__ret__.subject_name,
        tags=__ret__.tags,
        thumbprint=__ret__.thumbprint,
        type=__ret__.type,
        valid=__ret__.valid)


@_utilities.lift_output_func(get_certificate)
def get_certificate_output(name: Optional[pulumi.Input[str]] = None,
                           resource_group_name: Optional[pulumi.Input[str]] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetCertificateResult]:
    """
    App certificate


    :param str name: Name of the certificate.
    :param str resource_group_name: Name of the resource group
    """
    pulumi.log.warn("""get_certificate is deprecated: Version v20150801 will be removed in the next major version of the provider. Upgrade to version v20150801preview or later.""")
    ...
