# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'ClusterSkuArgs',
    'PrivateEndpointPropertiesArgs',
    'PrivateLinkServiceConnectionArgs',
]

@pulumi.input_type
class ClusterSkuArgs:
    def __init__(__self__, *,
                 capacity: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[Union[str, 'ClusterSkuName']]] = None):
        """
        The SKU of the cluster. This determines the size/capacity of the cluster. Required on PUT (CreateOrUpdate) requests.
        :param pulumi.Input[int] capacity: Denotes the number of streaming units the cluster can support. Valid values for this property are multiples of 36 with a minimum value of 36 and maximum value of 216. Required on PUT (CreateOrUpdate) requests.
        :param pulumi.Input[Union[str, 'ClusterSkuName']] name: Specifies the SKU name of the cluster. Required on PUT (CreateOrUpdate) requests.
        """
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def capacity(self) -> Optional[pulumi.Input[int]]:
        """
        Denotes the number of streaming units the cluster can support. Valid values for this property are multiples of 36 with a minimum value of 36 and maximum value of 216. Required on PUT (CreateOrUpdate) requests.
        """
        return pulumi.get(self, "capacity")

    @capacity.setter
    def capacity(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "capacity", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[Union[str, 'ClusterSkuName']]]:
        """
        Specifies the SKU name of the cluster. Required on PUT (CreateOrUpdate) requests.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[Union[str, 'ClusterSkuName']]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class PrivateEndpointPropertiesArgs:
    def __init__(__self__, *,
                 manual_private_link_service_connections: Optional[pulumi.Input[Sequence[pulumi.Input['PrivateLinkServiceConnectionArgs']]]] = None):
        """
        The properties associated with a private endpoint.
        :param pulumi.Input[Sequence[pulumi.Input['PrivateLinkServiceConnectionArgs']]] manual_private_link_service_connections: A list of connections to the remote resource. Immutable after it is set.
        """
        if manual_private_link_service_connections is not None:
            pulumi.set(__self__, "manual_private_link_service_connections", manual_private_link_service_connections)

    @property
    @pulumi.getter(name="manualPrivateLinkServiceConnections")
    def manual_private_link_service_connections(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PrivateLinkServiceConnectionArgs']]]]:
        """
        A list of connections to the remote resource. Immutable after it is set.
        """
        return pulumi.get(self, "manual_private_link_service_connections")

    @manual_private_link_service_connections.setter
    def manual_private_link_service_connections(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PrivateLinkServiceConnectionArgs']]]]):
        pulumi.set(self, "manual_private_link_service_connections", value)


@pulumi.input_type
class PrivateLinkServiceConnectionArgs:
    def __init__(__self__, *,
                 group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 private_link_service_id: Optional[pulumi.Input[str]] = None):
        """
        A grouping of information about the connection to the remote resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] group_ids: The ID(s) of the group(s) obtained from the remote resource that this private endpoint should connect to. Required on PUT (CreateOrUpdate) requests.
        :param pulumi.Input[str] private_link_service_id: The resource id of the private link service. Required on PUT (CreateOrUpdate) requests.
        """
        if group_ids is not None:
            pulumi.set(__self__, "group_ids", group_ids)
        if private_link_service_id is not None:
            pulumi.set(__self__, "private_link_service_id", private_link_service_id)

    @property
    @pulumi.getter(name="groupIds")
    def group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The ID(s) of the group(s) obtained from the remote resource that this private endpoint should connect to. Required on PUT (CreateOrUpdate) requests.
        """
        return pulumi.get(self, "group_ids")

    @group_ids.setter
    def group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "group_ids", value)

    @property
    @pulumi.getter(name="privateLinkServiceId")
    def private_link_service_id(self) -> Optional[pulumi.Input[str]]:
        """
        The resource id of the private link service. Required on PUT (CreateOrUpdate) requests.
        """
        return pulumi.get(self, "private_link_service_id")

    @private_link_service_id.setter
    def private_link_service_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_link_service_id", value)


