# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetVolumeResult',
    'AwaitableGetVolumeResult',
    'get_volume',
    'get_volume_output',
]

@pulumi.output_type
class GetVolumeResult:
    """
    Response for Volume request.
    """
    def __init__(__self__, creation_data=None, id=None, location=None, name=None, size_gi_b=None, storage_target=None, system_data=None, tags=None, type=None, volume_id=None):
        if creation_data and not isinstance(creation_data, dict):
            raise TypeError("Expected argument 'creation_data' to be a dict")
        pulumi.set(__self__, "creation_data", creation_data)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if size_gi_b and not isinstance(size_gi_b, float):
            raise TypeError("Expected argument 'size_gi_b' to be a float")
        pulumi.set(__self__, "size_gi_b", size_gi_b)
        if storage_target and not isinstance(storage_target, dict):
            raise TypeError("Expected argument 'storage_target' to be a dict")
        pulumi.set(__self__, "storage_target", storage_target)
        if system_data and not isinstance(system_data, dict):
            raise TypeError("Expected argument 'system_data' to be a dict")
        pulumi.set(__self__, "system_data", system_data)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)
        if volume_id and not isinstance(volume_id, str):
            raise TypeError("Expected argument 'volume_id' to be a str")
        pulumi.set(__self__, "volume_id", volume_id)

    @property
    @pulumi.getter(name="creationData")
    def creation_data(self) -> Optional['outputs.SourceCreationDataResponse']:
        """
        State of the operation on the resource.
        """
        return pulumi.get(self, "creation_data")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Azure resource identifier.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def location(self) -> Optional[str]:
        """
        The geo-location where the resource lives.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Azure resource name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="sizeGiB")
    def size_gi_b(self) -> Optional[float]:
        """
        Volume size.
        """
        return pulumi.get(self, "size_gi_b")

    @property
    @pulumi.getter(name="storageTarget")
    def storage_target(self) -> 'outputs.IscsiTargetInfoResponse':
        """
        Storage target information
        """
        return pulumi.get(self, "storage_target")

    @property
    @pulumi.getter(name="systemData")
    def system_data(self) -> 'outputs.SystemDataResponse':
        """
        Resource metadata required by ARM RPC
        """
        return pulumi.get(self, "system_data")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        Azure resource tags.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Azure resource type.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="volumeId")
    def volume_id(self) -> str:
        """
        Unique Id of the volume in GUID format
        """
        return pulumi.get(self, "volume_id")


class AwaitableGetVolumeResult(GetVolumeResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetVolumeResult(
            creation_data=self.creation_data,
            id=self.id,
            location=self.location,
            name=self.name,
            size_gi_b=self.size_gi_b,
            storage_target=self.storage_target,
            system_data=self.system_data,
            tags=self.tags,
            type=self.type,
            volume_id=self.volume_id)


def get_volume(elastic_san_name: Optional[str] = None,
               resource_group_name: Optional[str] = None,
               volume_group_name: Optional[str] = None,
               volume_name: Optional[str] = None,
               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetVolumeResult:
    """
    Response for Volume request.
    API Version: 2021-11-20-preview.


    :param str elastic_san_name: The name of the ElasticSan.
    :param str resource_group_name: The name of the resource group. The name is case insensitive.
    :param str volume_group_name: The name of the VolumeGroup.
    :param str volume_name: The name of the Volume.
    """
    __args__ = dict()
    __args__['elasticSanName'] = elastic_san_name
    __args__['resourceGroupName'] = resource_group_name
    __args__['volumeGroupName'] = volume_group_name
    __args__['volumeName'] = volume_name
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('azure-native:elasticsan:getVolume', __args__, opts=opts, typ=GetVolumeResult).value

    return AwaitableGetVolumeResult(
        creation_data=__ret__.creation_data,
        id=__ret__.id,
        location=__ret__.location,
        name=__ret__.name,
        size_gi_b=__ret__.size_gi_b,
        storage_target=__ret__.storage_target,
        system_data=__ret__.system_data,
        tags=__ret__.tags,
        type=__ret__.type,
        volume_id=__ret__.volume_id)


@_utilities.lift_output_func(get_volume)
def get_volume_output(elastic_san_name: Optional[pulumi.Input[str]] = None,
                      resource_group_name: Optional[pulumi.Input[str]] = None,
                      volume_group_name: Optional[pulumi.Input[str]] = None,
                      volume_name: Optional[pulumi.Input[str]] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetVolumeResult]:
    """
    Response for Volume request.
    API Version: 2021-11-20-preview.


    :param str elastic_san_name: The name of the ElasticSan.
    :param str resource_group_name: The name of the resource group. The name is case insensitive.
    :param str volume_group_name: The name of the VolumeGroup.
    :param str volume_name: The name of the Volume.
    """
    ...
