# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'ApiPortalCustomDomainPropertiesArgs',
    'ApiPortalPropertiesArgs',
    'AppResourcePropertiesArgs',
    'AppVNetAddonsArgs',
    'AzureFileVolumeArgs',
    'BindingResourcePropertiesArgs',
    'BuildResultUserSourceInfoArgs',
    'BuilderPropertiesArgs',
    'BuildpackBindingLaunchPropertiesArgs',
    'BuildpackBindingPropertiesArgs',
    'BuildpackPropertiesArgs',
    'BuildpacksGroupPropertiesArgs',
    'ClusterResourcePropertiesArgs',
    'ConfigurationServiceGitPropertyArgs',
    'ConfigurationServiceGitRepositoryArgs',
    'ConfigurationServicePropertiesArgs',
    'ConfigurationServiceSettingsArgs',
    'ContainerProbeSettingsArgs',
    'ContentCertificatePropertiesArgs',
    'CustomContainerUserSourceInfoArgs',
    'CustomContainerArgs',
    'CustomDomainPropertiesArgs',
    'CustomPersistentDiskResourceArgs',
    'DeploymentResourcePropertiesArgs',
    'DeploymentSettingsArgs',
    'ExecActionArgs',
    'GatewayApiMetadataPropertiesArgs',
    'GatewayApiRouteArgs',
    'GatewayCorsPropertiesArgs',
    'GatewayCustomDomainPropertiesArgs',
    'GatewayPropertiesArgs',
    'GatewayResourceRequestsArgs',
    'GatewayRouteConfigOpenApiPropertiesArgs',
    'GatewayRouteConfigPropertiesArgs',
    'HTTPGetActionArgs',
    'ImageRegistryCredentialArgs',
    'IngressConfigArgs',
    'JarUploadedUserSourceInfoArgs',
    'KeyVaultCertificatePropertiesArgs',
    'LoadedCertificateArgs',
    'ManagedIdentityPropertiesArgs',
    'MarketplaceResourceArgs',
    'NetCoreZipUploadedUserSourceInfoArgs',
    'NetworkProfileArgs',
    'PersistentDiskArgs',
    'ProbeArgs',
    'ResourceRequestsArgs',
    'ServiceVNetAddonsArgs',
    'SkuArgs',
    'SourceUploadedUserSourceInfoArgs',
    'SsoPropertiesArgs',
    'StackPropertiesArgs',
    'StorageAccountArgs',
    'TCPSocketActionArgs',
    'TemporaryDiskArgs',
    'UploadedUserSourceInfoArgs',
]

@pulumi.input_type
class ApiPortalCustomDomainPropertiesArgs:
    def __init__(__self__, *,
                 thumbprint: Optional[pulumi.Input[str]] = None):
        """
        The properties of custom domain for API portal
        :param pulumi.Input[str] thumbprint: The thumbprint of bound certificate.
        """
        if thumbprint is not None:
            pulumi.set(__self__, "thumbprint", thumbprint)

    @property
    @pulumi.getter
    def thumbprint(self) -> Optional[pulumi.Input[str]]:
        """
        The thumbprint of bound certificate.
        """
        return pulumi.get(self, "thumbprint")

    @thumbprint.setter
    def thumbprint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "thumbprint", value)


@pulumi.input_type
class ApiPortalPropertiesArgs:
    def __init__(__self__, *,
                 gateway_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 https_only: Optional[pulumi.Input[bool]] = None,
                 public: Optional[pulumi.Input[bool]] = None,
                 source_urls: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 sso_properties: Optional[pulumi.Input['SsoPropertiesArgs']] = None):
        """
        API portal properties payload
        :param pulumi.Input[Sequence[pulumi.Input[str]]] gateway_ids: The array of resource Ids of gateway to integrate with API portal.
        :param pulumi.Input[bool] https_only: Indicate if only https is allowed.
        :param pulumi.Input[bool] public: Indicates whether the API portal exposes endpoint.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] source_urls: Collection of OpenAPI source URL locations.
        :param pulumi.Input['SsoPropertiesArgs'] sso_properties: Single sign-on related configuration
        """
        if gateway_ids is not None:
            pulumi.set(__self__, "gateway_ids", gateway_ids)
        if https_only is None:
            https_only = False
        if https_only is not None:
            pulumi.set(__self__, "https_only", https_only)
        if public is None:
            public = False
        if public is not None:
            pulumi.set(__self__, "public", public)
        if source_urls is not None:
            pulumi.set(__self__, "source_urls", source_urls)
        if sso_properties is not None:
            pulumi.set(__self__, "sso_properties", sso_properties)

    @property
    @pulumi.getter(name="gatewayIds")
    def gateway_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The array of resource Ids of gateway to integrate with API portal.
        """
        return pulumi.get(self, "gateway_ids")

    @gateway_ids.setter
    def gateway_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "gateway_ids", value)

    @property
    @pulumi.getter(name="httpsOnly")
    def https_only(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicate if only https is allowed.
        """
        return pulumi.get(self, "https_only")

    @https_only.setter
    def https_only(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "https_only", value)

    @property
    @pulumi.getter
    def public(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether the API portal exposes endpoint.
        """
        return pulumi.get(self, "public")

    @public.setter
    def public(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "public", value)

    @property
    @pulumi.getter(name="sourceUrls")
    def source_urls(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Collection of OpenAPI source URL locations.
        """
        return pulumi.get(self, "source_urls")

    @source_urls.setter
    def source_urls(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "source_urls", value)

    @property
    @pulumi.getter(name="ssoProperties")
    def sso_properties(self) -> Optional[pulumi.Input['SsoPropertiesArgs']]:
        """
        Single sign-on related configuration
        """
        return pulumi.get(self, "sso_properties")

    @sso_properties.setter
    def sso_properties(self, value: Optional[pulumi.Input['SsoPropertiesArgs']]):
        pulumi.set(self, "sso_properties", value)


@pulumi.input_type
class AppResourcePropertiesArgs:
    def __init__(__self__, *,
                 addon_configs: Optional[pulumi.Input[Mapping[str, pulumi.Input[Mapping[str, Any]]]]] = None,
                 custom_persistent_disks: Optional[pulumi.Input[Sequence[pulumi.Input['CustomPersistentDiskResourceArgs']]]] = None,
                 enable_end_to_end_tls: Optional[pulumi.Input[bool]] = None,
                 fqdn: Optional[pulumi.Input[str]] = None,
                 https_only: Optional[pulumi.Input[bool]] = None,
                 loaded_certificates: Optional[pulumi.Input[Sequence[pulumi.Input['LoadedCertificateArgs']]]] = None,
                 persistent_disk: Optional[pulumi.Input['PersistentDiskArgs']] = None,
                 public: Optional[pulumi.Input[bool]] = None,
                 temporary_disk: Optional[pulumi.Input['TemporaryDiskArgs']] = None,
                 vnet_addons: Optional[pulumi.Input['AppVNetAddonsArgs']] = None):
        """
        App resource properties payload
        :param pulumi.Input[Mapping[str, pulumi.Input[Mapping[str, Any]]]] addon_configs: Collection of addons
        :param pulumi.Input[Sequence[pulumi.Input['CustomPersistentDiskResourceArgs']]] custom_persistent_disks: List of custom persistent disks
        :param pulumi.Input[bool] enable_end_to_end_tls: Indicate if end to end TLS is enabled.
        :param pulumi.Input[str] fqdn: Fully qualified dns Name.
        :param pulumi.Input[bool] https_only: Indicate if only https is allowed.
        :param pulumi.Input[Sequence[pulumi.Input['LoadedCertificateArgs']]] loaded_certificates: Collection of loaded certificates
        :param pulumi.Input['PersistentDiskArgs'] persistent_disk: Persistent disk settings
        :param pulumi.Input[bool] public: Indicates whether the App exposes public endpoint
        :param pulumi.Input['TemporaryDiskArgs'] temporary_disk: Temporary disk settings
        :param pulumi.Input['AppVNetAddonsArgs'] vnet_addons: Additional App settings in vnet injection instance
        """
        if addon_configs is not None:
            pulumi.set(__self__, "addon_configs", addon_configs)
        if custom_persistent_disks is not None:
            pulumi.set(__self__, "custom_persistent_disks", custom_persistent_disks)
        if enable_end_to_end_tls is None:
            enable_end_to_end_tls = False
        if enable_end_to_end_tls is not None:
            pulumi.set(__self__, "enable_end_to_end_tls", enable_end_to_end_tls)
        if fqdn is not None:
            pulumi.set(__self__, "fqdn", fqdn)
        if https_only is None:
            https_only = False
        if https_only is not None:
            pulumi.set(__self__, "https_only", https_only)
        if loaded_certificates is not None:
            pulumi.set(__self__, "loaded_certificates", loaded_certificates)
        if persistent_disk is not None:
            pulumi.set(__self__, "persistent_disk", persistent_disk)
        if public is not None:
            pulumi.set(__self__, "public", public)
        if temporary_disk is not None:
            pulumi.set(__self__, "temporary_disk", temporary_disk)
        if vnet_addons is not None:
            pulumi.set(__self__, "vnet_addons", vnet_addons)

    @property
    @pulumi.getter(name="addonConfigs")
    def addon_configs(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[Mapping[str, Any]]]]]:
        """
        Collection of addons
        """
        return pulumi.get(self, "addon_configs")

    @addon_configs.setter
    def addon_configs(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[Mapping[str, Any]]]]]):
        pulumi.set(self, "addon_configs", value)

    @property
    @pulumi.getter(name="customPersistentDisks")
    def custom_persistent_disks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CustomPersistentDiskResourceArgs']]]]:
        """
        List of custom persistent disks
        """
        return pulumi.get(self, "custom_persistent_disks")

    @custom_persistent_disks.setter
    def custom_persistent_disks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CustomPersistentDiskResourceArgs']]]]):
        pulumi.set(self, "custom_persistent_disks", value)

    @property
    @pulumi.getter(name="enableEndToEndTLS")
    def enable_end_to_end_tls(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicate if end to end TLS is enabled.
        """
        return pulumi.get(self, "enable_end_to_end_tls")

    @enable_end_to_end_tls.setter
    def enable_end_to_end_tls(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_end_to_end_tls", value)

    @property
    @pulumi.getter
    def fqdn(self) -> Optional[pulumi.Input[str]]:
        """
        Fully qualified dns Name.
        """
        return pulumi.get(self, "fqdn")

    @fqdn.setter
    def fqdn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fqdn", value)

    @property
    @pulumi.getter(name="httpsOnly")
    def https_only(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicate if only https is allowed.
        """
        return pulumi.get(self, "https_only")

    @https_only.setter
    def https_only(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "https_only", value)

    @property
    @pulumi.getter(name="loadedCertificates")
    def loaded_certificates(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LoadedCertificateArgs']]]]:
        """
        Collection of loaded certificates
        """
        return pulumi.get(self, "loaded_certificates")

    @loaded_certificates.setter
    def loaded_certificates(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LoadedCertificateArgs']]]]):
        pulumi.set(self, "loaded_certificates", value)

    @property
    @pulumi.getter(name="persistentDisk")
    def persistent_disk(self) -> Optional[pulumi.Input['PersistentDiskArgs']]:
        """
        Persistent disk settings
        """
        return pulumi.get(self, "persistent_disk")

    @persistent_disk.setter
    def persistent_disk(self, value: Optional[pulumi.Input['PersistentDiskArgs']]):
        pulumi.set(self, "persistent_disk", value)

    @property
    @pulumi.getter
    def public(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether the App exposes public endpoint
        """
        return pulumi.get(self, "public")

    @public.setter
    def public(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "public", value)

    @property
    @pulumi.getter(name="temporaryDisk")
    def temporary_disk(self) -> Optional[pulumi.Input['TemporaryDiskArgs']]:
        """
        Temporary disk settings
        """
        return pulumi.get(self, "temporary_disk")

    @temporary_disk.setter
    def temporary_disk(self, value: Optional[pulumi.Input['TemporaryDiskArgs']]):
        pulumi.set(self, "temporary_disk", value)

    @property
    @pulumi.getter(name="vnetAddons")
    def vnet_addons(self) -> Optional[pulumi.Input['AppVNetAddonsArgs']]:
        """
        Additional App settings in vnet injection instance
        """
        return pulumi.get(self, "vnet_addons")

    @vnet_addons.setter
    def vnet_addons(self, value: Optional[pulumi.Input['AppVNetAddonsArgs']]):
        pulumi.set(self, "vnet_addons", value)


@pulumi.input_type
class AppVNetAddonsArgs:
    def __init__(__self__, *,
                 public_endpoint: Optional[pulumi.Input[bool]] = None):
        """
        Additional App settings in vnet injection instance
        :param pulumi.Input[bool] public_endpoint: Indicates whether the App in vnet injection instance exposes endpoint which could be accessed from internet.
        """
        if public_endpoint is None:
            public_endpoint = False
        if public_endpoint is not None:
            pulumi.set(__self__, "public_endpoint", public_endpoint)

    @property
    @pulumi.getter(name="publicEndpoint")
    def public_endpoint(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether the App in vnet injection instance exposes endpoint which could be accessed from internet.
        """
        return pulumi.get(self, "public_endpoint")

    @public_endpoint.setter
    def public_endpoint(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "public_endpoint", value)


@pulumi.input_type
class AzureFileVolumeArgs:
    def __init__(__self__, *,
                 mount_path: pulumi.Input[str],
                 share_name: pulumi.Input[str],
                 type: pulumi.Input[str],
                 mount_options: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 read_only: Optional[pulumi.Input[bool]] = None):
        """
        The properties of the Azure File volume. Azure File shares are mounted as volumes.
        :param pulumi.Input[str] mount_path: The mount path of the persistent disk.
        :param pulumi.Input[str] share_name: The share name of the Azure File share.
        :param pulumi.Input[str] type: The type of the underlying resource to mount as a persistent disk.
               Expected value is 'AzureFileVolume'.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] mount_options: These are the mount options for a persistent disk.
        :param pulumi.Input[bool] read_only: Indicates whether the persistent disk is a readOnly one.
        """
        pulumi.set(__self__, "mount_path", mount_path)
        pulumi.set(__self__, "share_name", share_name)
        pulumi.set(__self__, "type", 'AzureFileVolume')
        if mount_options is not None:
            pulumi.set(__self__, "mount_options", mount_options)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)

    @property
    @pulumi.getter(name="mountPath")
    def mount_path(self) -> pulumi.Input[str]:
        """
        The mount path of the persistent disk.
        """
        return pulumi.get(self, "mount_path")

    @mount_path.setter
    def mount_path(self, value: pulumi.Input[str]):
        pulumi.set(self, "mount_path", value)

    @property
    @pulumi.getter(name="shareName")
    def share_name(self) -> pulumi.Input[str]:
        """
        The share name of the Azure File share.
        """
        return pulumi.get(self, "share_name")

    @share_name.setter
    def share_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "share_name", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The type of the underlying resource to mount as a persistent disk.
        Expected value is 'AzureFileVolume'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="mountOptions")
    def mount_options(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        These are the mount options for a persistent disk.
        """
        return pulumi.get(self, "mount_options")

    @mount_options.setter
    def mount_options(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "mount_options", value)

    @property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether the persistent disk is a readOnly one.
        """
        return pulumi.get(self, "read_only")

    @read_only.setter
    def read_only(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "read_only", value)


@pulumi.input_type
class BindingResourcePropertiesArgs:
    def __init__(__self__, *,
                 binding_parameters: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 key: Optional[pulumi.Input[str]] = None,
                 resource_id: Optional[pulumi.Input[str]] = None):
        """
        Binding resource properties payload
        :param pulumi.Input[Mapping[str, Any]] binding_parameters: Binding parameters of the Binding resource
        :param pulumi.Input[str] key: The key of the bound resource
        :param pulumi.Input[str] resource_id: The Azure resource id of the bound resource
        """
        if binding_parameters is not None:
            pulumi.set(__self__, "binding_parameters", binding_parameters)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)

    @property
    @pulumi.getter(name="bindingParameters")
    def binding_parameters(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Binding parameters of the Binding resource
        """
        return pulumi.get(self, "binding_parameters")

    @binding_parameters.setter
    def binding_parameters(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "binding_parameters", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[str]]:
        """
        The key of the bound resource
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        The Azure resource id of the bound resource
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_id", value)


@pulumi.input_type
class BuildResultUserSourceInfoArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 build_result_id: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[str]] = None):
        """
        Reference to a build result
        :param pulumi.Input[str] type: Type of the source uploaded
               Expected value is 'BuildResult'.
        :param pulumi.Input[str] build_result_id: Resource id of an existing succeeded build result under the same Spring instance.
        :param pulumi.Input[str] version: Version of the source
        """
        pulumi.set(__self__, "type", 'BuildResult')
        if build_result_id is not None:
            pulumi.set(__self__, "build_result_id", build_result_id)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of the source uploaded
        Expected value is 'BuildResult'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="buildResultId")
    def build_result_id(self) -> Optional[pulumi.Input[str]]:
        """
        Resource id of an existing succeeded build result under the same Spring instance.
        """
        return pulumi.get(self, "build_result_id")

    @build_result_id.setter
    def build_result_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "build_result_id", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        Version of the source
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class BuilderPropertiesArgs:
    def __init__(__self__, *,
                 buildpack_groups: Optional[pulumi.Input[Sequence[pulumi.Input['BuildpacksGroupPropertiesArgs']]]] = None,
                 stack: Optional[pulumi.Input['StackPropertiesArgs']] = None):
        """
        KPack Builder properties payload
        :param pulumi.Input[Sequence[pulumi.Input['BuildpacksGroupPropertiesArgs']]] buildpack_groups: Builder buildpack groups.
        :param pulumi.Input['StackPropertiesArgs'] stack: Builder cluster stack property.
        """
        if buildpack_groups is not None:
            pulumi.set(__self__, "buildpack_groups", buildpack_groups)
        if stack is not None:
            pulumi.set(__self__, "stack", stack)

    @property
    @pulumi.getter(name="buildpackGroups")
    def buildpack_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BuildpacksGroupPropertiesArgs']]]]:
        """
        Builder buildpack groups.
        """
        return pulumi.get(self, "buildpack_groups")

    @buildpack_groups.setter
    def buildpack_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BuildpacksGroupPropertiesArgs']]]]):
        pulumi.set(self, "buildpack_groups", value)

    @property
    @pulumi.getter
    def stack(self) -> Optional[pulumi.Input['StackPropertiesArgs']]:
        """
        Builder cluster stack property.
        """
        return pulumi.get(self, "stack")

    @stack.setter
    def stack(self, value: Optional[pulumi.Input['StackPropertiesArgs']]):
        pulumi.set(self, "stack", value)


@pulumi.input_type
class BuildpackBindingLaunchPropertiesArgs:
    def __init__(__self__, *,
                 properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 secrets: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        Buildpack Binding Launch Properties
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] properties: Non-sensitive properties for launchProperties
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] secrets: Sensitive properties for launchProperties
        """
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if secrets is not None:
            pulumi.set(__self__, "secrets", secrets)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Non-sensitive properties for launchProperties
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "properties", value)

    @property
    @pulumi.getter
    def secrets(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Sensitive properties for launchProperties
        """
        return pulumi.get(self, "secrets")

    @secrets.setter
    def secrets(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "secrets", value)


@pulumi.input_type
class BuildpackBindingPropertiesArgs:
    def __init__(__self__, *,
                 binding_type: Optional[pulumi.Input[Union[str, 'BindingType']]] = None,
                 launch_properties: Optional[pulumi.Input['BuildpackBindingLaunchPropertiesArgs']] = None):
        """
        Properties of a buildpack binding
        :param pulumi.Input[Union[str, 'BindingType']] binding_type: Buildpack Binding Type
        :param pulumi.Input['BuildpackBindingLaunchPropertiesArgs'] launch_properties: The object describes the buildpack binding launch properties
        """
        if binding_type is not None:
            pulumi.set(__self__, "binding_type", binding_type)
        if launch_properties is not None:
            pulumi.set(__self__, "launch_properties", launch_properties)

    @property
    @pulumi.getter(name="bindingType")
    def binding_type(self) -> Optional[pulumi.Input[Union[str, 'BindingType']]]:
        """
        Buildpack Binding Type
        """
        return pulumi.get(self, "binding_type")

    @binding_type.setter
    def binding_type(self, value: Optional[pulumi.Input[Union[str, 'BindingType']]]):
        pulumi.set(self, "binding_type", value)

    @property
    @pulumi.getter(name="launchProperties")
    def launch_properties(self) -> Optional[pulumi.Input['BuildpackBindingLaunchPropertiesArgs']]:
        """
        The object describes the buildpack binding launch properties
        """
        return pulumi.get(self, "launch_properties")

    @launch_properties.setter
    def launch_properties(self, value: Optional[pulumi.Input['BuildpackBindingLaunchPropertiesArgs']]):
        pulumi.set(self, "launch_properties", value)


@pulumi.input_type
class BuildpackPropertiesArgs:
    def __init__(__self__, *,
                 id: Optional[pulumi.Input[str]] = None):
        """
        Buildpack properties payload
        :param pulumi.Input[str] id: Id of the buildpack
        """
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Id of the buildpack
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)


@pulumi.input_type
class BuildpacksGroupPropertiesArgs:
    def __init__(__self__, *,
                 buildpacks: Optional[pulumi.Input[Sequence[pulumi.Input['BuildpackPropertiesArgs']]]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        Buildpack group properties of the Builder
        :param pulumi.Input[Sequence[pulumi.Input['BuildpackPropertiesArgs']]] buildpacks: Buildpacks in the buildpack group
        :param pulumi.Input[str] name: Buildpack group name
        """
        if buildpacks is not None:
            pulumi.set(__self__, "buildpacks", buildpacks)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def buildpacks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BuildpackPropertiesArgs']]]]:
        """
        Buildpacks in the buildpack group
        """
        return pulumi.get(self, "buildpacks")

    @buildpacks.setter
    def buildpacks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BuildpackPropertiesArgs']]]]):
        pulumi.set(self, "buildpacks", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Buildpack group name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class ClusterResourcePropertiesArgs:
    def __init__(__self__, *,
                 marketplace_resource: Optional[pulumi.Input['MarketplaceResourceArgs']] = None,
                 network_profile: Optional[pulumi.Input['NetworkProfileArgs']] = None,
                 vnet_addons: Optional[pulumi.Input['ServiceVNetAddonsArgs']] = None,
                 zone_redundant: Optional[pulumi.Input[bool]] = None):
        """
        Service properties payload
        :param pulumi.Input['MarketplaceResourceArgs'] marketplace_resource: Purchasing 3rd party product of the Service resource.
        :param pulumi.Input['NetworkProfileArgs'] network_profile: Network profile of the Service
        :param pulumi.Input['ServiceVNetAddonsArgs'] vnet_addons: Additional Service settings in vnet injection instance
        """
        if marketplace_resource is not None:
            pulumi.set(__self__, "marketplace_resource", marketplace_resource)
        if network_profile is not None:
            pulumi.set(__self__, "network_profile", network_profile)
        if vnet_addons is not None:
            pulumi.set(__self__, "vnet_addons", vnet_addons)
        if zone_redundant is None:
            zone_redundant = False
        if zone_redundant is not None:
            pulumi.set(__self__, "zone_redundant", zone_redundant)

    @property
    @pulumi.getter(name="marketplaceResource")
    def marketplace_resource(self) -> Optional[pulumi.Input['MarketplaceResourceArgs']]:
        """
        Purchasing 3rd party product of the Service resource.
        """
        return pulumi.get(self, "marketplace_resource")

    @marketplace_resource.setter
    def marketplace_resource(self, value: Optional[pulumi.Input['MarketplaceResourceArgs']]):
        pulumi.set(self, "marketplace_resource", value)

    @property
    @pulumi.getter(name="networkProfile")
    def network_profile(self) -> Optional[pulumi.Input['NetworkProfileArgs']]:
        """
        Network profile of the Service
        """
        return pulumi.get(self, "network_profile")

    @network_profile.setter
    def network_profile(self, value: Optional[pulumi.Input['NetworkProfileArgs']]):
        pulumi.set(self, "network_profile", value)

    @property
    @pulumi.getter(name="vnetAddons")
    def vnet_addons(self) -> Optional[pulumi.Input['ServiceVNetAddonsArgs']]:
        """
        Additional Service settings in vnet injection instance
        """
        return pulumi.get(self, "vnet_addons")

    @vnet_addons.setter
    def vnet_addons(self, value: Optional[pulumi.Input['ServiceVNetAddonsArgs']]):
        pulumi.set(self, "vnet_addons", value)

    @property
    @pulumi.getter(name="zoneRedundant")
    def zone_redundant(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "zone_redundant")

    @zone_redundant.setter
    def zone_redundant(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "zone_redundant", value)


@pulumi.input_type
class ConfigurationServiceGitPropertyArgs:
    def __init__(__self__, *,
                 repositories: Optional[pulumi.Input[Sequence[pulumi.Input['ConfigurationServiceGitRepositoryArgs']]]] = None):
        """
        Property of git environment.
        :param pulumi.Input[Sequence[pulumi.Input['ConfigurationServiceGitRepositoryArgs']]] repositories: Repositories of Application Configuration Service git property.
        """
        if repositories is not None:
            pulumi.set(__self__, "repositories", repositories)

    @property
    @pulumi.getter
    def repositories(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ConfigurationServiceGitRepositoryArgs']]]]:
        """
        Repositories of Application Configuration Service git property.
        """
        return pulumi.get(self, "repositories")

    @repositories.setter
    def repositories(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ConfigurationServiceGitRepositoryArgs']]]]):
        pulumi.set(self, "repositories", value)


@pulumi.input_type
class ConfigurationServiceGitRepositoryArgs:
    def __init__(__self__, *,
                 label: pulumi.Input[str],
                 name: pulumi.Input[str],
                 patterns: pulumi.Input[Sequence[pulumi.Input[str]]],
                 uri: pulumi.Input[str],
                 host_key: Optional[pulumi.Input[str]] = None,
                 host_key_algorithm: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 private_key: Optional[pulumi.Input[str]] = None,
                 search_paths: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 strict_host_key_checking: Optional[pulumi.Input[bool]] = None,
                 username: Optional[pulumi.Input[str]] = None):
        """
        Git repository property payload for Application Configuration Service
        :param pulumi.Input[str] label: Label of the repository
        :param pulumi.Input[str] name: Name of the repository
        :param pulumi.Input[Sequence[pulumi.Input[str]]] patterns: Collection of patterns of the repository
        :param pulumi.Input[str] uri: URI of the repository
        :param pulumi.Input[str] host_key: Public sshKey of git repository.
        :param pulumi.Input[str] host_key_algorithm: SshKey algorithm of git repository.
        :param pulumi.Input[str] password: Password of git repository basic auth.
        :param pulumi.Input[str] private_key: Private sshKey algorithm of git repository.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] search_paths: Searching path of the repository
        :param pulumi.Input[bool] strict_host_key_checking: Strict host key checking or not.
        :param pulumi.Input[str] username: Username of git repository basic auth.
        """
        pulumi.set(__self__, "label", label)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "patterns", patterns)
        pulumi.set(__self__, "uri", uri)
        if host_key is not None:
            pulumi.set(__self__, "host_key", host_key)
        if host_key_algorithm is not None:
            pulumi.set(__self__, "host_key_algorithm", host_key_algorithm)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if private_key is not None:
            pulumi.set(__self__, "private_key", private_key)
        if search_paths is not None:
            pulumi.set(__self__, "search_paths", search_paths)
        if strict_host_key_checking is not None:
            pulumi.set(__self__, "strict_host_key_checking", strict_host_key_checking)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def label(self) -> pulumi.Input[str]:
        """
        Label of the repository
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: pulumi.Input[str]):
        pulumi.set(self, "label", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Name of the repository
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def patterns(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        Collection of patterns of the repository
        """
        return pulumi.get(self, "patterns")

    @patterns.setter
    def patterns(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "patterns", value)

    @property
    @pulumi.getter
    def uri(self) -> pulumi.Input[str]:
        """
        URI of the repository
        """
        return pulumi.get(self, "uri")

    @uri.setter
    def uri(self, value: pulumi.Input[str]):
        pulumi.set(self, "uri", value)

    @property
    @pulumi.getter(name="hostKey")
    def host_key(self) -> Optional[pulumi.Input[str]]:
        """
        Public sshKey of git repository.
        """
        return pulumi.get(self, "host_key")

    @host_key.setter
    def host_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host_key", value)

    @property
    @pulumi.getter(name="hostKeyAlgorithm")
    def host_key_algorithm(self) -> Optional[pulumi.Input[str]]:
        """
        SshKey algorithm of git repository.
        """
        return pulumi.get(self, "host_key_algorithm")

    @host_key_algorithm.setter
    def host_key_algorithm(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host_key_algorithm", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        Password of git repository basic auth.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> Optional[pulumi.Input[str]]:
        """
        Private sshKey algorithm of git repository.
        """
        return pulumi.get(self, "private_key")

    @private_key.setter
    def private_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_key", value)

    @property
    @pulumi.getter(name="searchPaths")
    def search_paths(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Searching path of the repository
        """
        return pulumi.get(self, "search_paths")

    @search_paths.setter
    def search_paths(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "search_paths", value)

    @property
    @pulumi.getter(name="strictHostKeyChecking")
    def strict_host_key_checking(self) -> Optional[pulumi.Input[bool]]:
        """
        Strict host key checking or not.
        """
        return pulumi.get(self, "strict_host_key_checking")

    @strict_host_key_checking.setter
    def strict_host_key_checking(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "strict_host_key_checking", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[str]]:
        """
        Username of git repository basic auth.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "username", value)


@pulumi.input_type
class ConfigurationServicePropertiesArgs:
    def __init__(__self__, *,
                 settings: Optional[pulumi.Input['ConfigurationServiceSettingsArgs']] = None):
        """
        Application Configuration Service properties payload
        :param pulumi.Input['ConfigurationServiceSettingsArgs'] settings: The settings of Application Configuration Service.
        """
        if settings is not None:
            pulumi.set(__self__, "settings", settings)

    @property
    @pulumi.getter
    def settings(self) -> Optional[pulumi.Input['ConfigurationServiceSettingsArgs']]:
        """
        The settings of Application Configuration Service.
        """
        return pulumi.get(self, "settings")

    @settings.setter
    def settings(self, value: Optional[pulumi.Input['ConfigurationServiceSettingsArgs']]):
        pulumi.set(self, "settings", value)


@pulumi.input_type
class ConfigurationServiceSettingsArgs:
    def __init__(__self__, *,
                 git_property: Optional[pulumi.Input['ConfigurationServiceGitPropertyArgs']] = None):
        """
        The settings of Application Configuration Service.
        :param pulumi.Input['ConfigurationServiceGitPropertyArgs'] git_property: Property of git environment.
        """
        if git_property is not None:
            pulumi.set(__self__, "git_property", git_property)

    @property
    @pulumi.getter(name="gitProperty")
    def git_property(self) -> Optional[pulumi.Input['ConfigurationServiceGitPropertyArgs']]:
        """
        Property of git environment.
        """
        return pulumi.get(self, "git_property")

    @git_property.setter
    def git_property(self, value: Optional[pulumi.Input['ConfigurationServiceGitPropertyArgs']]):
        pulumi.set(self, "git_property", value)


@pulumi.input_type
class ContainerProbeSettingsArgs:
    def __init__(__self__, *,
                 disable_probe: Optional[pulumi.Input[bool]] = None):
        """
        Container liveness and readiness probe settings
        :param pulumi.Input[bool] disable_probe: Indicates whether disable the liveness and readiness probe
        """
        if disable_probe is not None:
            pulumi.set(__self__, "disable_probe", disable_probe)

    @property
    @pulumi.getter(name="disableProbe")
    def disable_probe(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether disable the liveness and readiness probe
        """
        return pulumi.get(self, "disable_probe")

    @disable_probe.setter
    def disable_probe(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable_probe", value)


@pulumi.input_type
class ContentCertificatePropertiesArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 content: Optional[pulumi.Input[str]] = None):
        """
        Properties of certificate imported from key vault.
        :param pulumi.Input[str] type: The type of the certificate source.
               Expected value is 'ContentCertificate'.
        :param pulumi.Input[str] content: The content of uploaded certificate.
        """
        pulumi.set(__self__, "type", 'ContentCertificate')
        if content is not None:
            pulumi.set(__self__, "content", content)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The type of the certificate source.
        Expected value is 'ContentCertificate'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def content(self) -> Optional[pulumi.Input[str]]:
        """
        The content of uploaded certificate.
        """
        return pulumi.get(self, "content")

    @content.setter
    def content(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "content", value)


@pulumi.input_type
class CustomContainerUserSourceInfoArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 custom_container: Optional[pulumi.Input['CustomContainerArgs']] = None,
                 version: Optional[pulumi.Input[str]] = None):
        """
        Custom container user source info
        :param pulumi.Input[str] type: Type of the source uploaded
               Expected value is 'Container'.
        :param pulumi.Input['CustomContainerArgs'] custom_container: Custom container payload
        :param pulumi.Input[str] version: Version of the source
        """
        pulumi.set(__self__, "type", 'Container')
        if custom_container is not None:
            pulumi.set(__self__, "custom_container", custom_container)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of the source uploaded
        Expected value is 'Container'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="customContainer")
    def custom_container(self) -> Optional[pulumi.Input['CustomContainerArgs']]:
        """
        Custom container payload
        """
        return pulumi.get(self, "custom_container")

    @custom_container.setter
    def custom_container(self, value: Optional[pulumi.Input['CustomContainerArgs']]):
        pulumi.set(self, "custom_container", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        Version of the source
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class CustomContainerArgs:
    def __init__(__self__, *,
                 args: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 command: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 container_image: Optional[pulumi.Input[str]] = None,
                 image_registry_credential: Optional[pulumi.Input['ImageRegistryCredentialArgs']] = None,
                 language_framework: Optional[pulumi.Input[str]] = None,
                 server: Optional[pulumi.Input[str]] = None):
        """
        Custom container payload
        :param pulumi.Input[Sequence[pulumi.Input[str]]] args: Arguments to the entrypoint. The docker image's CMD is used if this is not provided.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] command: Entrypoint array. Not executed within a shell. The docker image's ENTRYPOINT is used if this is not provided.
        :param pulumi.Input[str] container_image: Container image of the custom container. This should be in the form of <repository>:<tag> without the server name of the registry
        :param pulumi.Input['ImageRegistryCredentialArgs'] image_registry_credential: Credential of the image registry
        :param pulumi.Input[str] language_framework: Language framework of the container image uploaded
        :param pulumi.Input[str] server: The name of the registry that contains the container image
        """
        if args is not None:
            pulumi.set(__self__, "args", args)
        if command is not None:
            pulumi.set(__self__, "command", command)
        if container_image is not None:
            pulumi.set(__self__, "container_image", container_image)
        if image_registry_credential is not None:
            pulumi.set(__self__, "image_registry_credential", image_registry_credential)
        if language_framework is not None:
            pulumi.set(__self__, "language_framework", language_framework)
        if server is not None:
            pulumi.set(__self__, "server", server)

    @property
    @pulumi.getter
    def args(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Arguments to the entrypoint. The docker image's CMD is used if this is not provided.
        """
        return pulumi.get(self, "args")

    @args.setter
    def args(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "args", value)

    @property
    @pulumi.getter
    def command(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Entrypoint array. Not executed within a shell. The docker image's ENTRYPOINT is used if this is not provided.
        """
        return pulumi.get(self, "command")

    @command.setter
    def command(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "command", value)

    @property
    @pulumi.getter(name="containerImage")
    def container_image(self) -> Optional[pulumi.Input[str]]:
        """
        Container image of the custom container. This should be in the form of <repository>:<tag> without the server name of the registry
        """
        return pulumi.get(self, "container_image")

    @container_image.setter
    def container_image(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "container_image", value)

    @property
    @pulumi.getter(name="imageRegistryCredential")
    def image_registry_credential(self) -> Optional[pulumi.Input['ImageRegistryCredentialArgs']]:
        """
        Credential of the image registry
        """
        return pulumi.get(self, "image_registry_credential")

    @image_registry_credential.setter
    def image_registry_credential(self, value: Optional[pulumi.Input['ImageRegistryCredentialArgs']]):
        pulumi.set(self, "image_registry_credential", value)

    @property
    @pulumi.getter(name="languageFramework")
    def language_framework(self) -> Optional[pulumi.Input[str]]:
        """
        Language framework of the container image uploaded
        """
        return pulumi.get(self, "language_framework")

    @language_framework.setter
    def language_framework(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "language_framework", value)

    @property
    @pulumi.getter
    def server(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the registry that contains the container image
        """
        return pulumi.get(self, "server")

    @server.setter
    def server(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "server", value)


@pulumi.input_type
class CustomDomainPropertiesArgs:
    def __init__(__self__, *,
                 cert_name: Optional[pulumi.Input[str]] = None,
                 thumbprint: Optional[pulumi.Input[str]] = None):
        """
        Custom domain of app resource payload.
        :param pulumi.Input[str] cert_name: The bound certificate name of domain.
        :param pulumi.Input[str] thumbprint: The thumbprint of bound certificate.
        """
        if cert_name is not None:
            pulumi.set(__self__, "cert_name", cert_name)
        if thumbprint is not None:
            pulumi.set(__self__, "thumbprint", thumbprint)

    @property
    @pulumi.getter(name="certName")
    def cert_name(self) -> Optional[pulumi.Input[str]]:
        """
        The bound certificate name of domain.
        """
        return pulumi.get(self, "cert_name")

    @cert_name.setter
    def cert_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cert_name", value)

    @property
    @pulumi.getter
    def thumbprint(self) -> Optional[pulumi.Input[str]]:
        """
        The thumbprint of bound certificate.
        """
        return pulumi.get(self, "thumbprint")

    @thumbprint.setter
    def thumbprint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "thumbprint", value)


@pulumi.input_type
class CustomPersistentDiskResourceArgs:
    def __init__(__self__, *,
                 storage_id: pulumi.Input[str],
                 custom_persistent_disk_properties: Optional[pulumi.Input['AzureFileVolumeArgs']] = None):
        """
        Custom persistent disk resource payload.
        :param pulumi.Input[str] storage_id: The resource id of Azure Spring Apps Storage resource.
        :param pulumi.Input['AzureFileVolumeArgs'] custom_persistent_disk_properties: Properties of the custom persistent disk resource payload.
        """
        pulumi.set(__self__, "storage_id", storage_id)
        if custom_persistent_disk_properties is not None:
            pulumi.set(__self__, "custom_persistent_disk_properties", custom_persistent_disk_properties)

    @property
    @pulumi.getter(name="storageId")
    def storage_id(self) -> pulumi.Input[str]:
        """
        The resource id of Azure Spring Apps Storage resource.
        """
        return pulumi.get(self, "storage_id")

    @storage_id.setter
    def storage_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "storage_id", value)

    @property
    @pulumi.getter(name="customPersistentDiskProperties")
    def custom_persistent_disk_properties(self) -> Optional[pulumi.Input['AzureFileVolumeArgs']]:
        """
        Properties of the custom persistent disk resource payload.
        """
        return pulumi.get(self, "custom_persistent_disk_properties")

    @custom_persistent_disk_properties.setter
    def custom_persistent_disk_properties(self, value: Optional[pulumi.Input['AzureFileVolumeArgs']]):
        pulumi.set(self, "custom_persistent_disk_properties", value)


@pulumi.input_type
class DeploymentResourcePropertiesArgs:
    def __init__(__self__, *,
                 active: Optional[pulumi.Input[bool]] = None,
                 deployment_settings: Optional[pulumi.Input['DeploymentSettingsArgs']] = None,
                 source: Optional[pulumi.Input[Union['BuildResultUserSourceInfoArgs', 'CustomContainerUserSourceInfoArgs', 'JarUploadedUserSourceInfoArgs', 'NetCoreZipUploadedUserSourceInfoArgs', 'SourceUploadedUserSourceInfoArgs', 'UploadedUserSourceInfoArgs']]] = None):
        """
        Deployment resource properties payload
        :param pulumi.Input[bool] active: Indicates whether the Deployment is active
        :param pulumi.Input['DeploymentSettingsArgs'] deployment_settings: Deployment settings of the Deployment
        :param pulumi.Input[Union['BuildResultUserSourceInfoArgs', 'CustomContainerUserSourceInfoArgs', 'JarUploadedUserSourceInfoArgs', 'NetCoreZipUploadedUserSourceInfoArgs', 'SourceUploadedUserSourceInfoArgs', 'UploadedUserSourceInfoArgs']] source: Uploaded source information of the deployment.
        """
        if active is not None:
            pulumi.set(__self__, "active", active)
        if deployment_settings is not None:
            pulumi.set(__self__, "deployment_settings", deployment_settings)
        if source is not None:
            pulumi.set(__self__, "source", source)

    @property
    @pulumi.getter
    def active(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether the Deployment is active
        """
        return pulumi.get(self, "active")

    @active.setter
    def active(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "active", value)

    @property
    @pulumi.getter(name="deploymentSettings")
    def deployment_settings(self) -> Optional[pulumi.Input['DeploymentSettingsArgs']]:
        """
        Deployment settings of the Deployment
        """
        return pulumi.get(self, "deployment_settings")

    @deployment_settings.setter
    def deployment_settings(self, value: Optional[pulumi.Input['DeploymentSettingsArgs']]):
        pulumi.set(self, "deployment_settings", value)

    @property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input[Union['BuildResultUserSourceInfoArgs', 'CustomContainerUserSourceInfoArgs', 'JarUploadedUserSourceInfoArgs', 'NetCoreZipUploadedUserSourceInfoArgs', 'SourceUploadedUserSourceInfoArgs', 'UploadedUserSourceInfoArgs']]]:
        """
        Uploaded source information of the deployment.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input[Union['BuildResultUserSourceInfoArgs', 'CustomContainerUserSourceInfoArgs', 'JarUploadedUserSourceInfoArgs', 'NetCoreZipUploadedUserSourceInfoArgs', 'SourceUploadedUserSourceInfoArgs', 'UploadedUserSourceInfoArgs']]]):
        pulumi.set(self, "source", value)


@pulumi.input_type
class DeploymentSettingsArgs:
    def __init__(__self__, *,
                 addon_configs: Optional[pulumi.Input[Mapping[str, pulumi.Input[Mapping[str, Any]]]]] = None,
                 container_probe_settings: Optional[pulumi.Input['ContainerProbeSettingsArgs']] = None,
                 environment_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 liveness_probe: Optional[pulumi.Input['ProbeArgs']] = None,
                 readiness_probe: Optional[pulumi.Input['ProbeArgs']] = None,
                 resource_requests: Optional[pulumi.Input['ResourceRequestsArgs']] = None,
                 startup_probe: Optional[pulumi.Input['ProbeArgs']] = None,
                 termination_grace_period_seconds: Optional[pulumi.Input[int]] = None):
        """
        Deployment settings payload
        :param pulumi.Input[Mapping[str, pulumi.Input[Mapping[str, Any]]]] addon_configs: Collection of addons
        :param pulumi.Input['ContainerProbeSettingsArgs'] container_probe_settings: Container liveness and readiness probe settings
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] environment_variables: Collection of environment variables
        :param pulumi.Input['ProbeArgs'] liveness_probe: Periodic probe of App Instance liveness. App Instance will be restarted if the probe fails. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        :param pulumi.Input['ProbeArgs'] readiness_probe: Periodic probe of App Instance service readiness. App Instance will be removed from service endpoints if the probe fails. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        :param pulumi.Input['ResourceRequestsArgs'] resource_requests: The requested resource quantity for required CPU and Memory. It is recommended that using this field to represent the required CPU and Memory, the old field cpu and memoryInGB will be deprecated later.
        :param pulumi.Input['ProbeArgs'] startup_probe: StartupProbe indicates that the App Instance has successfully initialized. If specified, no other probes are executed until this completes successfully. If this probe fails, the Pod will be restarted, just as if the livenessProbe failed. This can be used to provide different probe parameters at the beginning of a App Instance's lifecycle, when it might take a long time to load data or warm a cache, than during steady-state operation. This cannot be updated. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        :param pulumi.Input[int] termination_grace_period_seconds: Optional duration in seconds the App Instance needs to terminate gracefully. May be decreased in delete request. Value must be non-negative integer. The value zero indicates stop immediately via the kill signal (no opportunity to shut down). If this value is nil, the default grace period will be used instead. The grace period is the duration in seconds after the processes running in the App Instance are sent a termination signal and the time when the processes are forcibly halted with a kill signal. Set this value longer than the expected cleanup time for your process. Defaults to 90 seconds.
        """
        if addon_configs is not None:
            pulumi.set(__self__, "addon_configs", addon_configs)
        if container_probe_settings is not None:
            pulumi.set(__self__, "container_probe_settings", container_probe_settings)
        if environment_variables is not None:
            pulumi.set(__self__, "environment_variables", environment_variables)
        if liveness_probe is not None:
            pulumi.set(__self__, "liveness_probe", liveness_probe)
        if readiness_probe is not None:
            pulumi.set(__self__, "readiness_probe", readiness_probe)
        if resource_requests is not None:
            pulumi.set(__self__, "resource_requests", resource_requests)
        if startup_probe is not None:
            pulumi.set(__self__, "startup_probe", startup_probe)
        if termination_grace_period_seconds is None:
            termination_grace_period_seconds = 90
        if termination_grace_period_seconds is not None:
            pulumi.set(__self__, "termination_grace_period_seconds", termination_grace_period_seconds)

    @property
    @pulumi.getter(name="addonConfigs")
    def addon_configs(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[Mapping[str, Any]]]]]:
        """
        Collection of addons
        """
        return pulumi.get(self, "addon_configs")

    @addon_configs.setter
    def addon_configs(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[Mapping[str, Any]]]]]):
        pulumi.set(self, "addon_configs", value)

    @property
    @pulumi.getter(name="containerProbeSettings")
    def container_probe_settings(self) -> Optional[pulumi.Input['ContainerProbeSettingsArgs']]:
        """
        Container liveness and readiness probe settings
        """
        return pulumi.get(self, "container_probe_settings")

    @container_probe_settings.setter
    def container_probe_settings(self, value: Optional[pulumi.Input['ContainerProbeSettingsArgs']]):
        pulumi.set(self, "container_probe_settings", value)

    @property
    @pulumi.getter(name="environmentVariables")
    def environment_variables(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Collection of environment variables
        """
        return pulumi.get(self, "environment_variables")

    @environment_variables.setter
    def environment_variables(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "environment_variables", value)

    @property
    @pulumi.getter(name="livenessProbe")
    def liveness_probe(self) -> Optional[pulumi.Input['ProbeArgs']]:
        """
        Periodic probe of App Instance liveness. App Instance will be restarted if the probe fails. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        """
        return pulumi.get(self, "liveness_probe")

    @liveness_probe.setter
    def liveness_probe(self, value: Optional[pulumi.Input['ProbeArgs']]):
        pulumi.set(self, "liveness_probe", value)

    @property
    @pulumi.getter(name="readinessProbe")
    def readiness_probe(self) -> Optional[pulumi.Input['ProbeArgs']]:
        """
        Periodic probe of App Instance service readiness. App Instance will be removed from service endpoints if the probe fails. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        """
        return pulumi.get(self, "readiness_probe")

    @readiness_probe.setter
    def readiness_probe(self, value: Optional[pulumi.Input['ProbeArgs']]):
        pulumi.set(self, "readiness_probe", value)

    @property
    @pulumi.getter(name="resourceRequests")
    def resource_requests(self) -> Optional[pulumi.Input['ResourceRequestsArgs']]:
        """
        The requested resource quantity for required CPU and Memory. It is recommended that using this field to represent the required CPU and Memory, the old field cpu and memoryInGB will be deprecated later.
        """
        return pulumi.get(self, "resource_requests")

    @resource_requests.setter
    def resource_requests(self, value: Optional[pulumi.Input['ResourceRequestsArgs']]):
        pulumi.set(self, "resource_requests", value)

    @property
    @pulumi.getter(name="startupProbe")
    def startup_probe(self) -> Optional[pulumi.Input['ProbeArgs']]:
        """
        StartupProbe indicates that the App Instance has successfully initialized. If specified, no other probes are executed until this completes successfully. If this probe fails, the Pod will be restarted, just as if the livenessProbe failed. This can be used to provide different probe parameters at the beginning of a App Instance's lifecycle, when it might take a long time to load data or warm a cache, than during steady-state operation. This cannot be updated. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        """
        return pulumi.get(self, "startup_probe")

    @startup_probe.setter
    def startup_probe(self, value: Optional[pulumi.Input['ProbeArgs']]):
        pulumi.set(self, "startup_probe", value)

    @property
    @pulumi.getter(name="terminationGracePeriodSeconds")
    def termination_grace_period_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        Optional duration in seconds the App Instance needs to terminate gracefully. May be decreased in delete request. Value must be non-negative integer. The value zero indicates stop immediately via the kill signal (no opportunity to shut down). If this value is nil, the default grace period will be used instead. The grace period is the duration in seconds after the processes running in the App Instance are sent a termination signal and the time when the processes are forcibly halted with a kill signal. Set this value longer than the expected cleanup time for your process. Defaults to 90 seconds.
        """
        return pulumi.get(self, "termination_grace_period_seconds")

    @termination_grace_period_seconds.setter
    def termination_grace_period_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "termination_grace_period_seconds", value)


@pulumi.input_type
class ExecActionArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 command: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        ExecAction describes a "run in container" action.
        :param pulumi.Input[str] type: The type of the action to take to perform the health check.
               Expected value is 'ExecAction'.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] command: Command is the command line to execute inside the container, the working directory for the command is root ('/') in the container's filesystem. The command is not run inside a shell, so traditional shell instructions ('|', etc) won't work. To use a shell, you need to explicitly call out to that shell. Exit status of 0 is treated as live/healthy and non-zero is unhealthy.
        """
        pulumi.set(__self__, "type", 'ExecAction')
        if command is not None:
            pulumi.set(__self__, "command", command)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The type of the action to take to perform the health check.
        Expected value is 'ExecAction'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def command(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Command is the command line to execute inside the container, the working directory for the command is root ('/') in the container's filesystem. The command is not run inside a shell, so traditional shell instructions ('|', etc) won't work. To use a shell, you need to explicitly call out to that shell. Exit status of 0 is treated as live/healthy and non-zero is unhealthy.
        """
        return pulumi.get(self, "command")

    @command.setter
    def command(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "command", value)


@pulumi.input_type
class GatewayApiMetadataPropertiesArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 documentation: Optional[pulumi.Input[str]] = None,
                 server_url: Optional[pulumi.Input[str]] = None,
                 title: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[str]] = None):
        """
        API metadata property for Spring Cloud Gateway
        :param pulumi.Input[str] description: Detailed description of the APIs available on the Gateway instance (default: `Generated OpenAPI 3 document that describes the API routes configured.`)
        :param pulumi.Input[str] documentation: Location of additional documentation for the APIs available on the Gateway instance
        :param pulumi.Input[str] server_url: Base URL that API consumers will use to access APIs on the Gateway instance.
        :param pulumi.Input[str] title: Title describing the context of the APIs available on the Gateway instance (default: `Spring Cloud Gateway for K8S`)
        :param pulumi.Input[str] version: Version of APIs available on this Gateway instance (default: `unspecified`).
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if documentation is not None:
            pulumi.set(__self__, "documentation", documentation)
        if server_url is not None:
            pulumi.set(__self__, "server_url", server_url)
        if title is not None:
            pulumi.set(__self__, "title", title)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Detailed description of the APIs available on the Gateway instance (default: `Generated OpenAPI 3 document that describes the API routes configured.`)
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def documentation(self) -> Optional[pulumi.Input[str]]:
        """
        Location of additional documentation for the APIs available on the Gateway instance
        """
        return pulumi.get(self, "documentation")

    @documentation.setter
    def documentation(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "documentation", value)

    @property
    @pulumi.getter(name="serverUrl")
    def server_url(self) -> Optional[pulumi.Input[str]]:
        """
        Base URL that API consumers will use to access APIs on the Gateway instance.
        """
        return pulumi.get(self, "server_url")

    @server_url.setter
    def server_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "server_url", value)

    @property
    @pulumi.getter
    def title(self) -> Optional[pulumi.Input[str]]:
        """
        Title describing the context of the APIs available on the Gateway instance (default: `Spring Cloud Gateway for K8S`)
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "title", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        Version of APIs available on this Gateway instance (default: `unspecified`).
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class GatewayApiRouteArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 filters: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 order: Optional[pulumi.Input[int]] = None,
                 predicates: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 sso_enabled: Optional[pulumi.Input[bool]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 title: Optional[pulumi.Input[str]] = None,
                 token_relay: Optional[pulumi.Input[bool]] = None,
                 uri: Optional[pulumi.Input[str]] = None):
        """
        API route config of the Spring Cloud Gateway
        :param pulumi.Input[str] description: A description, will be applied to methods in the generated OpenAPI documentation.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] filters: To modify the request before sending it to the target endpoint, or the received response.
        :param pulumi.Input[int] order: Route processing order.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] predicates: A number of conditions to evaluate a route for each request. Each predicate may be evaluated against request headers and parameter values. All of the predicates associated with a route must evaluate to true for the route to be matched to the request.
        :param pulumi.Input[bool] sso_enabled: Enable sso validation.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: Classification tags, will be applied to methods in the generated OpenAPI documentation.
        :param pulumi.Input[str] title: A title, will be applied to methods in the generated OpenAPI documentation.
        :param pulumi.Input[bool] token_relay: Pass currently-authenticated user's identity token to application service, default is 'false'
        :param pulumi.Input[str] uri: Full uri, will override `appName`.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if filters is not None:
            pulumi.set(__self__, "filters", filters)
        if order is not None:
            pulumi.set(__self__, "order", order)
        if predicates is not None:
            pulumi.set(__self__, "predicates", predicates)
        if sso_enabled is not None:
            pulumi.set(__self__, "sso_enabled", sso_enabled)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if title is not None:
            pulumi.set(__self__, "title", title)
        if token_relay is not None:
            pulumi.set(__self__, "token_relay", token_relay)
        if uri is not None:
            pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        A description, will be applied to methods in the generated OpenAPI documentation.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def filters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        To modify the request before sending it to the target endpoint, or the received response.
        """
        return pulumi.get(self, "filters")

    @filters.setter
    def filters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "filters", value)

    @property
    @pulumi.getter
    def order(self) -> Optional[pulumi.Input[int]]:
        """
        Route processing order.
        """
        return pulumi.get(self, "order")

    @order.setter
    def order(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "order", value)

    @property
    @pulumi.getter
    def predicates(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A number of conditions to evaluate a route for each request. Each predicate may be evaluated against request headers and parameter values. All of the predicates associated with a route must evaluate to true for the route to be matched to the request.
        """
        return pulumi.get(self, "predicates")

    @predicates.setter
    def predicates(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "predicates", value)

    @property
    @pulumi.getter(name="ssoEnabled")
    def sso_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable sso validation.
        """
        return pulumi.get(self, "sso_enabled")

    @sso_enabled.setter
    def sso_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "sso_enabled", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Classification tags, will be applied to methods in the generated OpenAPI documentation.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def title(self) -> Optional[pulumi.Input[str]]:
        """
        A title, will be applied to methods in the generated OpenAPI documentation.
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "title", value)

    @property
    @pulumi.getter(name="tokenRelay")
    def token_relay(self) -> Optional[pulumi.Input[bool]]:
        """
        Pass currently-authenticated user's identity token to application service, default is 'false'
        """
        return pulumi.get(self, "token_relay")

    @token_relay.setter
    def token_relay(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "token_relay", value)

    @property
    @pulumi.getter
    def uri(self) -> Optional[pulumi.Input[str]]:
        """
        Full uri, will override `appName`.
        """
        return pulumi.get(self, "uri")

    @uri.setter
    def uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "uri", value)


@pulumi.input_type
class GatewayCorsPropertiesArgs:
    def __init__(__self__, *,
                 allow_credentials: Optional[pulumi.Input[bool]] = None,
                 allowed_headers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 allowed_methods: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 allowed_origins: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 exposed_headers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 max_age: Optional[pulumi.Input[int]] = None):
        """
        Cross-Origin Resource Sharing property
        :param pulumi.Input[bool] allow_credentials: Whether user credentials are supported on cross-site requests. Valid values: `true`, `false`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_headers: Allowed headers in cross-site requests. The special value `*` allows actual requests to send any header.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_methods: Allowed HTTP methods on cross-site requests. The special value `*` allows all methods. If not set, `GET` and `HEAD` are allowed by default.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_origins: Allowed origins to make cross-site requests. The special value `*` allows all domains.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] exposed_headers: HTTP response headers to expose for cross-site requests.
        :param pulumi.Input[int] max_age: How long, in seconds, the response from a pre-flight request can be cached by clients.
        """
        if allow_credentials is not None:
            pulumi.set(__self__, "allow_credentials", allow_credentials)
        if allowed_headers is not None:
            pulumi.set(__self__, "allowed_headers", allowed_headers)
        if allowed_methods is not None:
            pulumi.set(__self__, "allowed_methods", allowed_methods)
        if allowed_origins is not None:
            pulumi.set(__self__, "allowed_origins", allowed_origins)
        if exposed_headers is not None:
            pulumi.set(__self__, "exposed_headers", exposed_headers)
        if max_age is not None:
            pulumi.set(__self__, "max_age", max_age)

    @property
    @pulumi.getter(name="allowCredentials")
    def allow_credentials(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether user credentials are supported on cross-site requests. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "allow_credentials")

    @allow_credentials.setter
    def allow_credentials(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_credentials", value)

    @property
    @pulumi.getter(name="allowedHeaders")
    def allowed_headers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Allowed headers in cross-site requests. The special value `*` allows actual requests to send any header.
        """
        return pulumi.get(self, "allowed_headers")

    @allowed_headers.setter
    def allowed_headers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "allowed_headers", value)

    @property
    @pulumi.getter(name="allowedMethods")
    def allowed_methods(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Allowed HTTP methods on cross-site requests. The special value `*` allows all methods. If not set, `GET` and `HEAD` are allowed by default.
        """
        return pulumi.get(self, "allowed_methods")

    @allowed_methods.setter
    def allowed_methods(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "allowed_methods", value)

    @property
    @pulumi.getter(name="allowedOrigins")
    def allowed_origins(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Allowed origins to make cross-site requests. The special value `*` allows all domains.
        """
        return pulumi.get(self, "allowed_origins")

    @allowed_origins.setter
    def allowed_origins(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "allowed_origins", value)

    @property
    @pulumi.getter(name="exposedHeaders")
    def exposed_headers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        HTTP response headers to expose for cross-site requests.
        """
        return pulumi.get(self, "exposed_headers")

    @exposed_headers.setter
    def exposed_headers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "exposed_headers", value)

    @property
    @pulumi.getter(name="maxAge")
    def max_age(self) -> Optional[pulumi.Input[int]]:
        """
        How long, in seconds, the response from a pre-flight request can be cached by clients.
        """
        return pulumi.get(self, "max_age")

    @max_age.setter
    def max_age(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_age", value)


@pulumi.input_type
class GatewayCustomDomainPropertiesArgs:
    def __init__(__self__, *,
                 thumbprint: Optional[pulumi.Input[str]] = None):
        """
        The properties of custom domain for Spring Cloud Gateway
        :param pulumi.Input[str] thumbprint: The thumbprint of bound certificate.
        """
        if thumbprint is not None:
            pulumi.set(__self__, "thumbprint", thumbprint)

    @property
    @pulumi.getter
    def thumbprint(self) -> Optional[pulumi.Input[str]]:
        """
        The thumbprint of bound certificate.
        """
        return pulumi.get(self, "thumbprint")

    @thumbprint.setter
    def thumbprint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "thumbprint", value)


@pulumi.input_type
class GatewayPropertiesArgs:
    def __init__(__self__, *,
                 api_metadata_properties: Optional[pulumi.Input['GatewayApiMetadataPropertiesArgs']] = None,
                 cors_properties: Optional[pulumi.Input['GatewayCorsPropertiesArgs']] = None,
                 https_only: Optional[pulumi.Input[bool]] = None,
                 public: Optional[pulumi.Input[bool]] = None,
                 resource_requests: Optional[pulumi.Input['GatewayResourceRequestsArgs']] = None,
                 sso_properties: Optional[pulumi.Input['SsoPropertiesArgs']] = None):
        """
        Spring Cloud Gateway properties payload
        :param pulumi.Input['GatewayApiMetadataPropertiesArgs'] api_metadata_properties: API metadata property for Spring Cloud Gateway
        :param pulumi.Input['GatewayCorsPropertiesArgs'] cors_properties: Cross-Origin Resource Sharing property
        :param pulumi.Input[bool] https_only: Indicate if only https is allowed.
        :param pulumi.Input[bool] public: Indicates whether the Spring Cloud Gateway exposes endpoint.
        :param pulumi.Input['GatewayResourceRequestsArgs'] resource_requests: The requested resource quantity for required CPU and Memory.
        :param pulumi.Input['SsoPropertiesArgs'] sso_properties: Single sign-on related configuration
        """
        if api_metadata_properties is not None:
            pulumi.set(__self__, "api_metadata_properties", api_metadata_properties)
        if cors_properties is not None:
            pulumi.set(__self__, "cors_properties", cors_properties)
        if https_only is None:
            https_only = False
        if https_only is not None:
            pulumi.set(__self__, "https_only", https_only)
        if public is None:
            public = False
        if public is not None:
            pulumi.set(__self__, "public", public)
        if resource_requests is not None:
            pulumi.set(__self__, "resource_requests", resource_requests)
        if sso_properties is not None:
            pulumi.set(__self__, "sso_properties", sso_properties)

    @property
    @pulumi.getter(name="apiMetadataProperties")
    def api_metadata_properties(self) -> Optional[pulumi.Input['GatewayApiMetadataPropertiesArgs']]:
        """
        API metadata property for Spring Cloud Gateway
        """
        return pulumi.get(self, "api_metadata_properties")

    @api_metadata_properties.setter
    def api_metadata_properties(self, value: Optional[pulumi.Input['GatewayApiMetadataPropertiesArgs']]):
        pulumi.set(self, "api_metadata_properties", value)

    @property
    @pulumi.getter(name="corsProperties")
    def cors_properties(self) -> Optional[pulumi.Input['GatewayCorsPropertiesArgs']]:
        """
        Cross-Origin Resource Sharing property
        """
        return pulumi.get(self, "cors_properties")

    @cors_properties.setter
    def cors_properties(self, value: Optional[pulumi.Input['GatewayCorsPropertiesArgs']]):
        pulumi.set(self, "cors_properties", value)

    @property
    @pulumi.getter(name="httpsOnly")
    def https_only(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicate if only https is allowed.
        """
        return pulumi.get(self, "https_only")

    @https_only.setter
    def https_only(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "https_only", value)

    @property
    @pulumi.getter
    def public(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether the Spring Cloud Gateway exposes endpoint.
        """
        return pulumi.get(self, "public")

    @public.setter
    def public(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "public", value)

    @property
    @pulumi.getter(name="resourceRequests")
    def resource_requests(self) -> Optional[pulumi.Input['GatewayResourceRequestsArgs']]:
        """
        The requested resource quantity for required CPU and Memory.
        """
        return pulumi.get(self, "resource_requests")

    @resource_requests.setter
    def resource_requests(self, value: Optional[pulumi.Input['GatewayResourceRequestsArgs']]):
        pulumi.set(self, "resource_requests", value)

    @property
    @pulumi.getter(name="ssoProperties")
    def sso_properties(self) -> Optional[pulumi.Input['SsoPropertiesArgs']]:
        """
        Single sign-on related configuration
        """
        return pulumi.get(self, "sso_properties")

    @sso_properties.setter
    def sso_properties(self, value: Optional[pulumi.Input['SsoPropertiesArgs']]):
        pulumi.set(self, "sso_properties", value)


@pulumi.input_type
class GatewayResourceRequestsArgs:
    def __init__(__self__, *,
                 cpu: Optional[pulumi.Input[str]] = None,
                 memory: Optional[pulumi.Input[str]] = None):
        """
        Resource request payload of Spring Cloud Gateway.
        :param pulumi.Input[str] cpu: Cpu allocated to each Spring Cloud Gateway instance.
        :param pulumi.Input[str] memory: Memory allocated to each Spring Cloud Gateway instance.
        """
        if cpu is not None:
            pulumi.set(__self__, "cpu", cpu)
        if memory is not None:
            pulumi.set(__self__, "memory", memory)

    @property
    @pulumi.getter
    def cpu(self) -> Optional[pulumi.Input[str]]:
        """
        Cpu allocated to each Spring Cloud Gateway instance.
        """
        return pulumi.get(self, "cpu")

    @cpu.setter
    def cpu(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cpu", value)

    @property
    @pulumi.getter
    def memory(self) -> Optional[pulumi.Input[str]]:
        """
        Memory allocated to each Spring Cloud Gateway instance.
        """
        return pulumi.get(self, "memory")

    @memory.setter
    def memory(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "memory", value)


@pulumi.input_type
class GatewayRouteConfigOpenApiPropertiesArgs:
    def __init__(__self__, *,
                 uri: Optional[pulumi.Input[str]] = None):
        """
        OpenAPI properties of Spring Cloud Gateway route config.
        :param pulumi.Input[str] uri: The URI of OpenAPI specification.
        """
        if uri is not None:
            pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter
    def uri(self) -> Optional[pulumi.Input[str]]:
        """
        The URI of OpenAPI specification.
        """
        return pulumi.get(self, "uri")

    @uri.setter
    def uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "uri", value)


@pulumi.input_type
class GatewayRouteConfigPropertiesArgs:
    def __init__(__self__, *,
                 app_resource_id: Optional[pulumi.Input[str]] = None,
                 open_api: Optional[pulumi.Input['GatewayRouteConfigOpenApiPropertiesArgs']] = None,
                 routes: Optional[pulumi.Input[Sequence[pulumi.Input['GatewayApiRouteArgs']]]] = None):
        """
        API route config of the Spring Cloud Gateway
        :param pulumi.Input[str] app_resource_id: The resource Id of the Azure Spring Apps app, required unless route defines `uri`.
        :param pulumi.Input['GatewayRouteConfigOpenApiPropertiesArgs'] open_api: OpenAPI properties of Spring Cloud Gateway route config.
        :param pulumi.Input[Sequence[pulumi.Input['GatewayApiRouteArgs']]] routes: Array of API routes, each route contains properties such as `title`, `uri`, `ssoEnabled`, `predicates`, `filters`.
        """
        if app_resource_id is not None:
            pulumi.set(__self__, "app_resource_id", app_resource_id)
        if open_api is not None:
            pulumi.set(__self__, "open_api", open_api)
        if routes is not None:
            pulumi.set(__self__, "routes", routes)

    @property
    @pulumi.getter(name="appResourceId")
    def app_resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        The resource Id of the Azure Spring Apps app, required unless route defines `uri`.
        """
        return pulumi.get(self, "app_resource_id")

    @app_resource_id.setter
    def app_resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "app_resource_id", value)

    @property
    @pulumi.getter(name="openApi")
    def open_api(self) -> Optional[pulumi.Input['GatewayRouteConfigOpenApiPropertiesArgs']]:
        """
        OpenAPI properties of Spring Cloud Gateway route config.
        """
        return pulumi.get(self, "open_api")

    @open_api.setter
    def open_api(self, value: Optional[pulumi.Input['GatewayRouteConfigOpenApiPropertiesArgs']]):
        pulumi.set(self, "open_api", value)

    @property
    @pulumi.getter
    def routes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GatewayApiRouteArgs']]]]:
        """
        Array of API routes, each route contains properties such as `title`, `uri`, `ssoEnabled`, `predicates`, `filters`.
        """
        return pulumi.get(self, "routes")

    @routes.setter
    def routes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GatewayApiRouteArgs']]]]):
        pulumi.set(self, "routes", value)


@pulumi.input_type
class HTTPGetActionArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 path: Optional[pulumi.Input[str]] = None,
                 scheme: Optional[pulumi.Input[Union[str, 'HTTPSchemeType']]] = None):
        """
        HTTPGetAction describes an action based on HTTP Get requests.
        :param pulumi.Input[str] type: The type of the action to take to perform the health check.
               Expected value is 'HTTPGetAction'.
        :param pulumi.Input[str] path: Path to access on the HTTP server.
        :param pulumi.Input[Union[str, 'HTTPSchemeType']] scheme: Scheme to use for connecting to the host. Defaults to HTTP.
               
               Possible enum values:
                - `"HTTP"` means that the scheme used will be http://
                - `"HTTPS"` means that the scheme used will be https://
        """
        pulumi.set(__self__, "type", 'HTTPGetAction')
        if path is not None:
            pulumi.set(__self__, "path", path)
        if scheme is not None:
            pulumi.set(__self__, "scheme", scheme)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The type of the action to take to perform the health check.
        Expected value is 'HTTPGetAction'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        Path to access on the HTTP server.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter
    def scheme(self) -> Optional[pulumi.Input[Union[str, 'HTTPSchemeType']]]:
        """
        Scheme to use for connecting to the host. Defaults to HTTP.

        Possible enum values:
         - `"HTTP"` means that the scheme used will be http://
         - `"HTTPS"` means that the scheme used will be https://
        """
        return pulumi.get(self, "scheme")

    @scheme.setter
    def scheme(self, value: Optional[pulumi.Input[Union[str, 'HTTPSchemeType']]]):
        pulumi.set(self, "scheme", value)


@pulumi.input_type
class ImageRegistryCredentialArgs:
    def __init__(__self__, *,
                 password: Optional[pulumi.Input[str]] = None,
                 username: Optional[pulumi.Input[str]] = None):
        """
        Credential of the image registry
        :param pulumi.Input[str] password: The password of the image registry credential
        :param pulumi.Input[str] username: The username of the image registry credential
        """
        if password is not None:
            pulumi.set(__self__, "password", password)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        The password of the image registry credential
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[str]]:
        """
        The username of the image registry credential
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "username", value)


@pulumi.input_type
class IngressConfigArgs:
    def __init__(__self__, *,
                 read_timeout_in_seconds: Optional[pulumi.Input[int]] = None):
        """
        Ingress configuration payload for Azure Spring Apps resource.
        :param pulumi.Input[int] read_timeout_in_seconds: Ingress read time out in seconds.
        """
        if read_timeout_in_seconds is not None:
            pulumi.set(__self__, "read_timeout_in_seconds", read_timeout_in_seconds)

    @property
    @pulumi.getter(name="readTimeoutInSeconds")
    def read_timeout_in_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        Ingress read time out in seconds.
        """
        return pulumi.get(self, "read_timeout_in_seconds")

    @read_timeout_in_seconds.setter
    def read_timeout_in_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "read_timeout_in_seconds", value)


@pulumi.input_type
class JarUploadedUserSourceInfoArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 jvm_options: Optional[pulumi.Input[str]] = None,
                 relative_path: Optional[pulumi.Input[str]] = None,
                 runtime_version: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[str]] = None):
        """
        Uploaded Jar binary for a deployment
        :param pulumi.Input[str] type: Type of the source uploaded
               Expected value is 'Jar'.
        :param pulumi.Input[str] jvm_options: JVM parameter
        :param pulumi.Input[str] relative_path: Relative path of the storage which stores the source
        :param pulumi.Input[str] runtime_version: Runtime version of the Jar file
        :param pulumi.Input[str] version: Version of the source
        """
        pulumi.set(__self__, "type", 'Jar')
        if jvm_options is not None:
            pulumi.set(__self__, "jvm_options", jvm_options)
        if relative_path is not None:
            pulumi.set(__self__, "relative_path", relative_path)
        if runtime_version is not None:
            pulumi.set(__self__, "runtime_version", runtime_version)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of the source uploaded
        Expected value is 'Jar'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="jvmOptions")
    def jvm_options(self) -> Optional[pulumi.Input[str]]:
        """
        JVM parameter
        """
        return pulumi.get(self, "jvm_options")

    @jvm_options.setter
    def jvm_options(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "jvm_options", value)

    @property
    @pulumi.getter(name="relativePath")
    def relative_path(self) -> Optional[pulumi.Input[str]]:
        """
        Relative path of the storage which stores the source
        """
        return pulumi.get(self, "relative_path")

    @relative_path.setter
    def relative_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "relative_path", value)

    @property
    @pulumi.getter(name="runtimeVersion")
    def runtime_version(self) -> Optional[pulumi.Input[str]]:
        """
        Runtime version of the Jar file
        """
        return pulumi.get(self, "runtime_version")

    @runtime_version.setter
    def runtime_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "runtime_version", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        Version of the source
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class KeyVaultCertificatePropertiesArgs:
    def __init__(__self__, *,
                 key_vault_cert_name: pulumi.Input[str],
                 type: pulumi.Input[str],
                 vault_uri: pulumi.Input[str],
                 cert_version: Optional[pulumi.Input[str]] = None,
                 exclude_private_key: Optional[pulumi.Input[bool]] = None):
        """
        Properties of certificate imported from key vault.
        :param pulumi.Input[str] key_vault_cert_name: The certificate name of key vault.
        :param pulumi.Input[str] type: The type of the certificate source.
               Expected value is 'KeyVaultCertificate'.
        :param pulumi.Input[str] vault_uri: The vault uri of user key vault.
        :param pulumi.Input[str] cert_version: The certificate version of key vault.
        :param pulumi.Input[bool] exclude_private_key: Optional. If set to true, it will not import private key from key vault.
        """
        pulumi.set(__self__, "key_vault_cert_name", key_vault_cert_name)
        pulumi.set(__self__, "type", 'KeyVaultCertificate')
        pulumi.set(__self__, "vault_uri", vault_uri)
        if cert_version is not None:
            pulumi.set(__self__, "cert_version", cert_version)
        if exclude_private_key is None:
            exclude_private_key = False
        if exclude_private_key is not None:
            pulumi.set(__self__, "exclude_private_key", exclude_private_key)

    @property
    @pulumi.getter(name="keyVaultCertName")
    def key_vault_cert_name(self) -> pulumi.Input[str]:
        """
        The certificate name of key vault.
        """
        return pulumi.get(self, "key_vault_cert_name")

    @key_vault_cert_name.setter
    def key_vault_cert_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "key_vault_cert_name", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The type of the certificate source.
        Expected value is 'KeyVaultCertificate'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="vaultUri")
    def vault_uri(self) -> pulumi.Input[str]:
        """
        The vault uri of user key vault.
        """
        return pulumi.get(self, "vault_uri")

    @vault_uri.setter
    def vault_uri(self, value: pulumi.Input[str]):
        pulumi.set(self, "vault_uri", value)

    @property
    @pulumi.getter(name="certVersion")
    def cert_version(self) -> Optional[pulumi.Input[str]]:
        """
        The certificate version of key vault.
        """
        return pulumi.get(self, "cert_version")

    @cert_version.setter
    def cert_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cert_version", value)

    @property
    @pulumi.getter(name="excludePrivateKey")
    def exclude_private_key(self) -> Optional[pulumi.Input[bool]]:
        """
        Optional. If set to true, it will not import private key from key vault.
        """
        return pulumi.get(self, "exclude_private_key")

    @exclude_private_key.setter
    def exclude_private_key(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "exclude_private_key", value)


@pulumi.input_type
class LoadedCertificateArgs:
    def __init__(__self__, *,
                 resource_id: pulumi.Input[str],
                 load_trust_store: Optional[pulumi.Input[bool]] = None):
        """
        Loaded certificate payload
        :param pulumi.Input[str] resource_id: Resource Id of loaded certificate
        :param pulumi.Input[bool] load_trust_store: Indicate whether the certificate will be loaded into default trust store, only work for Java runtime.
        """
        pulumi.set(__self__, "resource_id", resource_id)
        if load_trust_store is None:
            load_trust_store = False
        if load_trust_store is not None:
            pulumi.set(__self__, "load_trust_store", load_trust_store)

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> pulumi.Input[str]:
        """
        Resource Id of loaded certificate
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "resource_id", value)

    @property
    @pulumi.getter(name="loadTrustStore")
    def load_trust_store(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicate whether the certificate will be loaded into default trust store, only work for Java runtime.
        """
        return pulumi.get(self, "load_trust_store")

    @load_trust_store.setter
    def load_trust_store(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "load_trust_store", value)


@pulumi.input_type
class ManagedIdentityPropertiesArgs:
    def __init__(__self__, *,
                 principal_id: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[Union[str, 'ManagedIdentityType']]] = None,
                 user_assigned_identities: Optional[pulumi.Input[Mapping[str, Any]]] = None):
        """
        Managed identity properties retrieved from ARM request headers.
        :param pulumi.Input[str] principal_id: Principal Id of system-assigned managed identity.
        :param pulumi.Input[str] tenant_id: Tenant Id of system-assigned managed identity.
        :param pulumi.Input[Union[str, 'ManagedIdentityType']] type: Type of the managed identity
        :param pulumi.Input[Mapping[str, Any]] user_assigned_identities: Properties of user-assigned managed identities
        """
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if user_assigned_identities is not None:
            pulumi.set(__self__, "user_assigned_identities", user_assigned_identities)

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[pulumi.Input[str]]:
        """
        Principal Id of system-assigned managed identity.
        """
        return pulumi.get(self, "principal_id")

    @principal_id.setter
    def principal_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "principal_id", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        Tenant Id of system-assigned managed identity.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[Union[str, 'ManagedIdentityType']]]:
        """
        Type of the managed identity
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[Union[str, 'ManagedIdentityType']]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="userAssignedIdentities")
    def user_assigned_identities(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Properties of user-assigned managed identities
        """
        return pulumi.get(self, "user_assigned_identities")

    @user_assigned_identities.setter
    def user_assigned_identities(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "user_assigned_identities", value)


@pulumi.input_type
class MarketplaceResourceArgs:
    def __init__(__self__, *,
                 plan: Optional[pulumi.Input[str]] = None,
                 product: Optional[pulumi.Input[str]] = None,
                 publisher: Optional[pulumi.Input[str]] = None):
        """
        Purchasing 3rd Party product for one Azure Spring Apps instance
        :param pulumi.Input[str] plan: The plan id of the 3rd Party Artifact that is being procured.
        :param pulumi.Input[str] product: The 3rd Party artifact that is being procured.
        :param pulumi.Input[str] publisher: The publisher id of the 3rd Party Artifact that is being bought.
        """
        if plan is not None:
            pulumi.set(__self__, "plan", plan)
        if product is not None:
            pulumi.set(__self__, "product", product)
        if publisher is not None:
            pulumi.set(__self__, "publisher", publisher)

    @property
    @pulumi.getter
    def plan(self) -> Optional[pulumi.Input[str]]:
        """
        The plan id of the 3rd Party Artifact that is being procured.
        """
        return pulumi.get(self, "plan")

    @plan.setter
    def plan(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "plan", value)

    @property
    @pulumi.getter
    def product(self) -> Optional[pulumi.Input[str]]:
        """
        The 3rd Party artifact that is being procured.
        """
        return pulumi.get(self, "product")

    @product.setter
    def product(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "product", value)

    @property
    @pulumi.getter
    def publisher(self) -> Optional[pulumi.Input[str]]:
        """
        The publisher id of the 3rd Party Artifact that is being bought.
        """
        return pulumi.get(self, "publisher")

    @publisher.setter
    def publisher(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "publisher", value)


@pulumi.input_type
class NetCoreZipUploadedUserSourceInfoArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 net_core_main_entry_path: Optional[pulumi.Input[str]] = None,
                 relative_path: Optional[pulumi.Input[str]] = None,
                 runtime_version: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[str]] = None):
        """
        Uploaded Jar binary for a deployment
        :param pulumi.Input[str] type: Type of the source uploaded
               Expected value is 'NetCoreZip'.
        :param pulumi.Input[str] net_core_main_entry_path: The path to the .NET executable relative to zip root
        :param pulumi.Input[str] relative_path: Relative path of the storage which stores the source
        :param pulumi.Input[str] runtime_version: Runtime version of the .Net file
        :param pulumi.Input[str] version: Version of the source
        """
        pulumi.set(__self__, "type", 'NetCoreZip')
        if net_core_main_entry_path is not None:
            pulumi.set(__self__, "net_core_main_entry_path", net_core_main_entry_path)
        if relative_path is not None:
            pulumi.set(__self__, "relative_path", relative_path)
        if runtime_version is not None:
            pulumi.set(__self__, "runtime_version", runtime_version)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of the source uploaded
        Expected value is 'NetCoreZip'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="netCoreMainEntryPath")
    def net_core_main_entry_path(self) -> Optional[pulumi.Input[str]]:
        """
        The path to the .NET executable relative to zip root
        """
        return pulumi.get(self, "net_core_main_entry_path")

    @net_core_main_entry_path.setter
    def net_core_main_entry_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "net_core_main_entry_path", value)

    @property
    @pulumi.getter(name="relativePath")
    def relative_path(self) -> Optional[pulumi.Input[str]]:
        """
        Relative path of the storage which stores the source
        """
        return pulumi.get(self, "relative_path")

    @relative_path.setter
    def relative_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "relative_path", value)

    @property
    @pulumi.getter(name="runtimeVersion")
    def runtime_version(self) -> Optional[pulumi.Input[str]]:
        """
        Runtime version of the .Net file
        """
        return pulumi.get(self, "runtime_version")

    @runtime_version.setter
    def runtime_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "runtime_version", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        Version of the source
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class NetworkProfileArgs:
    def __init__(__self__, *,
                 app_network_resource_group: Optional[pulumi.Input[str]] = None,
                 app_subnet_id: Optional[pulumi.Input[str]] = None,
                 ingress_config: Optional[pulumi.Input['IngressConfigArgs']] = None,
                 service_cidr: Optional[pulumi.Input[str]] = None,
                 service_runtime_network_resource_group: Optional[pulumi.Input[str]] = None,
                 service_runtime_subnet_id: Optional[pulumi.Input[str]] = None):
        """
        Service network profile payload
        :param pulumi.Input[str] app_network_resource_group: Name of the resource group containing network resources for customer apps in Azure Spring Apps
        :param pulumi.Input[str] app_subnet_id: Fully qualified resource Id of the subnet to host customer apps in Azure Spring Apps
        :param pulumi.Input['IngressConfigArgs'] ingress_config: Ingress configuration payload for Azure Spring Apps resource.
        :param pulumi.Input[str] service_cidr: Azure Spring Apps service reserved CIDR
        :param pulumi.Input[str] service_runtime_network_resource_group: Name of the resource group containing network resources of Azure Spring Apps Service Runtime
        :param pulumi.Input[str] service_runtime_subnet_id: Fully qualified resource Id of the subnet to host Azure Spring Apps Service Runtime
        """
        if app_network_resource_group is not None:
            pulumi.set(__self__, "app_network_resource_group", app_network_resource_group)
        if app_subnet_id is not None:
            pulumi.set(__self__, "app_subnet_id", app_subnet_id)
        if ingress_config is not None:
            pulumi.set(__self__, "ingress_config", ingress_config)
        if service_cidr is not None:
            pulumi.set(__self__, "service_cidr", service_cidr)
        if service_runtime_network_resource_group is not None:
            pulumi.set(__self__, "service_runtime_network_resource_group", service_runtime_network_resource_group)
        if service_runtime_subnet_id is not None:
            pulumi.set(__self__, "service_runtime_subnet_id", service_runtime_subnet_id)

    @property
    @pulumi.getter(name="appNetworkResourceGroup")
    def app_network_resource_group(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the resource group containing network resources for customer apps in Azure Spring Apps
        """
        return pulumi.get(self, "app_network_resource_group")

    @app_network_resource_group.setter
    def app_network_resource_group(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "app_network_resource_group", value)

    @property
    @pulumi.getter(name="appSubnetId")
    def app_subnet_id(self) -> Optional[pulumi.Input[str]]:
        """
        Fully qualified resource Id of the subnet to host customer apps in Azure Spring Apps
        """
        return pulumi.get(self, "app_subnet_id")

    @app_subnet_id.setter
    def app_subnet_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "app_subnet_id", value)

    @property
    @pulumi.getter(name="ingressConfig")
    def ingress_config(self) -> Optional[pulumi.Input['IngressConfigArgs']]:
        """
        Ingress configuration payload for Azure Spring Apps resource.
        """
        return pulumi.get(self, "ingress_config")

    @ingress_config.setter
    def ingress_config(self, value: Optional[pulumi.Input['IngressConfigArgs']]):
        pulumi.set(self, "ingress_config", value)

    @property
    @pulumi.getter(name="serviceCidr")
    def service_cidr(self) -> Optional[pulumi.Input[str]]:
        """
        Azure Spring Apps service reserved CIDR
        """
        return pulumi.get(self, "service_cidr")

    @service_cidr.setter
    def service_cidr(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_cidr", value)

    @property
    @pulumi.getter(name="serviceRuntimeNetworkResourceGroup")
    def service_runtime_network_resource_group(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the resource group containing network resources of Azure Spring Apps Service Runtime
        """
        return pulumi.get(self, "service_runtime_network_resource_group")

    @service_runtime_network_resource_group.setter
    def service_runtime_network_resource_group(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_runtime_network_resource_group", value)

    @property
    @pulumi.getter(name="serviceRuntimeSubnetId")
    def service_runtime_subnet_id(self) -> Optional[pulumi.Input[str]]:
        """
        Fully qualified resource Id of the subnet to host Azure Spring Apps Service Runtime
        """
        return pulumi.get(self, "service_runtime_subnet_id")

    @service_runtime_subnet_id.setter
    def service_runtime_subnet_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_runtime_subnet_id", value)


@pulumi.input_type
class PersistentDiskArgs:
    def __init__(__self__, *,
                 mount_path: Optional[pulumi.Input[str]] = None,
                 size_in_gb: Optional[pulumi.Input[int]] = None):
        """
        Persistent disk payload
        :param pulumi.Input[str] mount_path: Mount path of the persistent disk
        :param pulumi.Input[int] size_in_gb: Size of the persistent disk in GB
        """
        if mount_path is not None:
            pulumi.set(__self__, "mount_path", mount_path)
        if size_in_gb is not None:
            pulumi.set(__self__, "size_in_gb", size_in_gb)

    @property
    @pulumi.getter(name="mountPath")
    def mount_path(self) -> Optional[pulumi.Input[str]]:
        """
        Mount path of the persistent disk
        """
        return pulumi.get(self, "mount_path")

    @mount_path.setter
    def mount_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mount_path", value)

    @property
    @pulumi.getter(name="sizeInGB")
    def size_in_gb(self) -> Optional[pulumi.Input[int]]:
        """
        Size of the persistent disk in GB
        """
        return pulumi.get(self, "size_in_gb")

    @size_in_gb.setter
    def size_in_gb(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "size_in_gb", value)


@pulumi.input_type
class ProbeArgs:
    def __init__(__self__, *,
                 disable_probe: pulumi.Input[bool],
                 failure_threshold: Optional[pulumi.Input[int]] = None,
                 initial_delay_seconds: Optional[pulumi.Input[int]] = None,
                 period_seconds: Optional[pulumi.Input[int]] = None,
                 probe_action: Optional[pulumi.Input[Union['ExecActionArgs', 'HTTPGetActionArgs', 'TCPSocketActionArgs']]] = None,
                 success_threshold: Optional[pulumi.Input[int]] = None,
                 timeout_seconds: Optional[pulumi.Input[int]] = None):
        """
        Probe describes a health check to be performed against an App Instance to determine whether it is alive or ready to receive traffic.
        :param pulumi.Input[bool] disable_probe: Indicate whether the probe is disabled.
        :param pulumi.Input[int] failure_threshold: Minimum consecutive failures for the probe to be considered failed after having succeeded. Minimum value is 1.
        :param pulumi.Input[int] initial_delay_seconds: Number of seconds after the App Instance has started before probes are initiated. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        :param pulumi.Input[int] period_seconds: How often (in seconds) to perform the probe. Minimum value is 1.
        :param pulumi.Input[Union['ExecActionArgs', 'HTTPGetActionArgs', 'TCPSocketActionArgs']] probe_action: The action of the probe.
        :param pulumi.Input[int] success_threshold: Minimum consecutive successes for the probe to be considered successful after having failed. Must be 1 for liveness and startup. Minimum value is 1.
        :param pulumi.Input[int] timeout_seconds: Number of seconds after which the probe times out. Minimum value is 1.
        """
        if disable_probe is None:
            disable_probe = False
        pulumi.set(__self__, "disable_probe", disable_probe)
        if failure_threshold is not None:
            pulumi.set(__self__, "failure_threshold", failure_threshold)
        if initial_delay_seconds is not None:
            pulumi.set(__self__, "initial_delay_seconds", initial_delay_seconds)
        if period_seconds is not None:
            pulumi.set(__self__, "period_seconds", period_seconds)
        if probe_action is not None:
            pulumi.set(__self__, "probe_action", probe_action)
        if success_threshold is not None:
            pulumi.set(__self__, "success_threshold", success_threshold)
        if timeout_seconds is not None:
            pulumi.set(__self__, "timeout_seconds", timeout_seconds)

    @property
    @pulumi.getter(name="disableProbe")
    def disable_probe(self) -> pulumi.Input[bool]:
        """
        Indicate whether the probe is disabled.
        """
        return pulumi.get(self, "disable_probe")

    @disable_probe.setter
    def disable_probe(self, value: pulumi.Input[bool]):
        pulumi.set(self, "disable_probe", value)

    @property
    @pulumi.getter(name="failureThreshold")
    def failure_threshold(self) -> Optional[pulumi.Input[int]]:
        """
        Minimum consecutive failures for the probe to be considered failed after having succeeded. Minimum value is 1.
        """
        return pulumi.get(self, "failure_threshold")

    @failure_threshold.setter
    def failure_threshold(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "failure_threshold", value)

    @property
    @pulumi.getter(name="initialDelaySeconds")
    def initial_delay_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        Number of seconds after the App Instance has started before probes are initiated. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        """
        return pulumi.get(self, "initial_delay_seconds")

    @initial_delay_seconds.setter
    def initial_delay_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "initial_delay_seconds", value)

    @property
    @pulumi.getter(name="periodSeconds")
    def period_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        How often (in seconds) to perform the probe. Minimum value is 1.
        """
        return pulumi.get(self, "period_seconds")

    @period_seconds.setter
    def period_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "period_seconds", value)

    @property
    @pulumi.getter(name="probeAction")
    def probe_action(self) -> Optional[pulumi.Input[Union['ExecActionArgs', 'HTTPGetActionArgs', 'TCPSocketActionArgs']]]:
        """
        The action of the probe.
        """
        return pulumi.get(self, "probe_action")

    @probe_action.setter
    def probe_action(self, value: Optional[pulumi.Input[Union['ExecActionArgs', 'HTTPGetActionArgs', 'TCPSocketActionArgs']]]):
        pulumi.set(self, "probe_action", value)

    @property
    @pulumi.getter(name="successThreshold")
    def success_threshold(self) -> Optional[pulumi.Input[int]]:
        """
        Minimum consecutive successes for the probe to be considered successful after having failed. Must be 1 for liveness and startup. Minimum value is 1.
        """
        return pulumi.get(self, "success_threshold")

    @success_threshold.setter
    def success_threshold(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "success_threshold", value)

    @property
    @pulumi.getter(name="timeoutSeconds")
    def timeout_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        Number of seconds after which the probe times out. Minimum value is 1.
        """
        return pulumi.get(self, "timeout_seconds")

    @timeout_seconds.setter
    def timeout_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "timeout_seconds", value)


@pulumi.input_type
class ResourceRequestsArgs:
    def __init__(__self__, *,
                 cpu: Optional[pulumi.Input[str]] = None,
                 memory: Optional[pulumi.Input[str]] = None):
        """
        Deployment resource request payload
        :param pulumi.Input[str] cpu: Required CPU. 1 core can be represented by 1 or 1000m. This should be 500m or 1 for Basic tier, and {500m, 1, 2, 3, 4} for Standard tier.
        :param pulumi.Input[str] memory: Required memory. 1 GB can be represented by 1Gi or 1024Mi. This should be {512Mi, 1Gi, 2Gi} for Basic tier, and {512Mi, 1Gi, 2Gi, ..., 8Gi} for Standard tier.
        """
        if cpu is not None:
            pulumi.set(__self__, "cpu", cpu)
        if memory is not None:
            pulumi.set(__self__, "memory", memory)

    @property
    @pulumi.getter
    def cpu(self) -> Optional[pulumi.Input[str]]:
        """
        Required CPU. 1 core can be represented by 1 or 1000m. This should be 500m or 1 for Basic tier, and {500m, 1, 2, 3, 4} for Standard tier.
        """
        return pulumi.get(self, "cpu")

    @cpu.setter
    def cpu(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cpu", value)

    @property
    @pulumi.getter
    def memory(self) -> Optional[pulumi.Input[str]]:
        """
        Required memory. 1 GB can be represented by 1Gi or 1024Mi. This should be {512Mi, 1Gi, 2Gi} for Basic tier, and {512Mi, 1Gi, 2Gi, ..., 8Gi} for Standard tier.
        """
        return pulumi.get(self, "memory")

    @memory.setter
    def memory(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "memory", value)


@pulumi.input_type
class ServiceVNetAddonsArgs:
    def __init__(__self__, *,
                 log_stream_public_endpoint: Optional[pulumi.Input[bool]] = None):
        """
        Additional Service settings in vnet injection instance
        :param pulumi.Input[bool] log_stream_public_endpoint: Indicates whether the log stream in vnet injection instance could be accessed from internet.
        """
        if log_stream_public_endpoint is None:
            log_stream_public_endpoint = False
        if log_stream_public_endpoint is not None:
            pulumi.set(__self__, "log_stream_public_endpoint", log_stream_public_endpoint)

    @property
    @pulumi.getter(name="logStreamPublicEndpoint")
    def log_stream_public_endpoint(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether the log stream in vnet injection instance could be accessed from internet.
        """
        return pulumi.get(self, "log_stream_public_endpoint")

    @log_stream_public_endpoint.setter
    def log_stream_public_endpoint(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "log_stream_public_endpoint", value)


@pulumi.input_type
class SkuArgs:
    def __init__(__self__, *,
                 capacity: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 tier: Optional[pulumi.Input[str]] = None):
        """
        Sku of Azure Spring Apps
        :param pulumi.Input[int] capacity: Current capacity of the target resource
        :param pulumi.Input[str] name: Name of the Sku
        :param pulumi.Input[str] tier: Tier of the Sku
        """
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)
        if name is None:
            name = 'S0'
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tier is None:
            tier = 'Standard'
        if tier is not None:
            pulumi.set(__self__, "tier", tier)

    @property
    @pulumi.getter
    def capacity(self) -> Optional[pulumi.Input[int]]:
        """
        Current capacity of the target resource
        """
        return pulumi.get(self, "capacity")

    @capacity.setter
    def capacity(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "capacity", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the Sku
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def tier(self) -> Optional[pulumi.Input[str]]:
        """
        Tier of the Sku
        """
        return pulumi.get(self, "tier")

    @tier.setter
    def tier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tier", value)


@pulumi.input_type
class SourceUploadedUserSourceInfoArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 artifact_selector: Optional[pulumi.Input[str]] = None,
                 relative_path: Optional[pulumi.Input[str]] = None,
                 runtime_version: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[str]] = None):
        """
        Uploaded Java source code binary for a deployment
        :param pulumi.Input[str] type: Type of the source uploaded
               Expected value is 'Source'.
        :param pulumi.Input[str] artifact_selector: Selector for the artifact to be used for the deployment for multi-module projects. This should be
               the relative path to the target module/project.
        :param pulumi.Input[str] relative_path: Relative path of the storage which stores the source
        :param pulumi.Input[str] runtime_version: Runtime version of the source file
        :param pulumi.Input[str] version: Version of the source
        """
        pulumi.set(__self__, "type", 'Source')
        if artifact_selector is not None:
            pulumi.set(__self__, "artifact_selector", artifact_selector)
        if relative_path is not None:
            pulumi.set(__self__, "relative_path", relative_path)
        if runtime_version is not None:
            pulumi.set(__self__, "runtime_version", runtime_version)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of the source uploaded
        Expected value is 'Source'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="artifactSelector")
    def artifact_selector(self) -> Optional[pulumi.Input[str]]:
        """
        Selector for the artifact to be used for the deployment for multi-module projects. This should be
        the relative path to the target module/project.
        """
        return pulumi.get(self, "artifact_selector")

    @artifact_selector.setter
    def artifact_selector(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "artifact_selector", value)

    @property
    @pulumi.getter(name="relativePath")
    def relative_path(self) -> Optional[pulumi.Input[str]]:
        """
        Relative path of the storage which stores the source
        """
        return pulumi.get(self, "relative_path")

    @relative_path.setter
    def relative_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "relative_path", value)

    @property
    @pulumi.getter(name="runtimeVersion")
    def runtime_version(self) -> Optional[pulumi.Input[str]]:
        """
        Runtime version of the source file
        """
        return pulumi.get(self, "runtime_version")

    @runtime_version.setter
    def runtime_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "runtime_version", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        Version of the source
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class SsoPropertiesArgs:
    def __init__(__self__, *,
                 client_id: Optional[pulumi.Input[str]] = None,
                 client_secret: Optional[pulumi.Input[str]] = None,
                 issuer_uri: Optional[pulumi.Input[str]] = None,
                 scope: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Single sign-on related configuration
        :param pulumi.Input[str] client_id: The public identifier for the application
        :param pulumi.Input[str] client_secret: The secret known only to the application and the authorization server
        :param pulumi.Input[str] issuer_uri: The URI of Issuer Identifier
        :param pulumi.Input[Sequence[pulumi.Input[str]]] scope: It defines the specific actions applications can be allowed to do on a user's behalf
        """
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if client_secret is not None:
            pulumi.set(__self__, "client_secret", client_secret)
        if issuer_uri is not None:
            pulumi.set(__self__, "issuer_uri", issuer_uri)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[pulumi.Input[str]]:
        """
        The public identifier for the application
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_id", value)

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> Optional[pulumi.Input[str]]:
        """
        The secret known only to the application and the authorization server
        """
        return pulumi.get(self, "client_secret")

    @client_secret.setter
    def client_secret(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_secret", value)

    @property
    @pulumi.getter(name="issuerUri")
    def issuer_uri(self) -> Optional[pulumi.Input[str]]:
        """
        The URI of Issuer Identifier
        """
        return pulumi.get(self, "issuer_uri")

    @issuer_uri.setter
    def issuer_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "issuer_uri", value)

    @property
    @pulumi.getter
    def scope(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        It defines the specific actions applications can be allowed to do on a user's behalf
        """
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "scope", value)


@pulumi.input_type
class StackPropertiesArgs:
    def __init__(__self__, *,
                 id: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[str]] = None):
        """
        KPack ClusterStack properties payload
        :param pulumi.Input[str] id: Id of the ClusterStack.
        :param pulumi.Input[str] version: Version of the ClusterStack
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Id of the ClusterStack.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        Version of the ClusterStack
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class StorageAccountArgs:
    def __init__(__self__, *,
                 account_key: pulumi.Input[str],
                 account_name: pulumi.Input[str],
                 storage_type: pulumi.Input[str]):
        """
        storage resource of type Azure Storage Account.
        :param pulumi.Input[str] account_key: The account key of the Azure Storage Account.
        :param pulumi.Input[str] account_name: The account name of the Azure Storage Account.
        :param pulumi.Input[str] storage_type: The type of the storage.
               Expected value is 'StorageAccount'.
        """
        pulumi.set(__self__, "account_key", account_key)
        pulumi.set(__self__, "account_name", account_name)
        pulumi.set(__self__, "storage_type", 'StorageAccount')

    @property
    @pulumi.getter(name="accountKey")
    def account_key(self) -> pulumi.Input[str]:
        """
        The account key of the Azure Storage Account.
        """
        return pulumi.get(self, "account_key")

    @account_key.setter
    def account_key(self, value: pulumi.Input[str]):
        pulumi.set(self, "account_key", value)

    @property
    @pulumi.getter(name="accountName")
    def account_name(self) -> pulumi.Input[str]:
        """
        The account name of the Azure Storage Account.
        """
        return pulumi.get(self, "account_name")

    @account_name.setter
    def account_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "account_name", value)

    @property
    @pulumi.getter(name="storageType")
    def storage_type(self) -> pulumi.Input[str]:
        """
        The type of the storage.
        Expected value is 'StorageAccount'.
        """
        return pulumi.get(self, "storage_type")

    @storage_type.setter
    def storage_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "storage_type", value)


@pulumi.input_type
class TCPSocketActionArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str]):
        """
        TCPSocketAction describes an action based on opening a socket
        :param pulumi.Input[str] type: The type of the action to take to perform the health check.
               Expected value is 'TCPSocketAction'.
        """
        pulumi.set(__self__, "type", 'TCPSocketAction')

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The type of the action to take to perform the health check.
        Expected value is 'TCPSocketAction'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class TemporaryDiskArgs:
    def __init__(__self__, *,
                 mount_path: Optional[pulumi.Input[str]] = None,
                 size_in_gb: Optional[pulumi.Input[int]] = None):
        """
        Temporary disk payload
        :param pulumi.Input[str] mount_path: Mount path of the temporary disk
        :param pulumi.Input[int] size_in_gb: Size of the temporary disk in GB
        """
        if mount_path is None:
            mount_path = '/tmp'
        if mount_path is not None:
            pulumi.set(__self__, "mount_path", mount_path)
        if size_in_gb is not None:
            pulumi.set(__self__, "size_in_gb", size_in_gb)

    @property
    @pulumi.getter(name="mountPath")
    def mount_path(self) -> Optional[pulumi.Input[str]]:
        """
        Mount path of the temporary disk
        """
        return pulumi.get(self, "mount_path")

    @mount_path.setter
    def mount_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mount_path", value)

    @property
    @pulumi.getter(name="sizeInGB")
    def size_in_gb(self) -> Optional[pulumi.Input[int]]:
        """
        Size of the temporary disk in GB
        """
        return pulumi.get(self, "size_in_gb")

    @size_in_gb.setter
    def size_in_gb(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "size_in_gb", value)


@pulumi.input_type
class UploadedUserSourceInfoArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 relative_path: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[str]] = None):
        """
        Source with uploaded location
        :param pulumi.Input[str] type: Type of the source uploaded
               Expected value is 'UploadedUserSourceInfo'.
        :param pulumi.Input[str] relative_path: Relative path of the storage which stores the source
        :param pulumi.Input[str] version: Version of the source
        """
        pulumi.set(__self__, "type", 'UploadedUserSourceInfo')
        if relative_path is not None:
            pulumi.set(__self__, "relative_path", relative_path)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of the source uploaded
        Expected value is 'UploadedUserSourceInfo'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="relativePath")
    def relative_path(self) -> Optional[pulumi.Input[str]]:
        """
        Relative path of the storage which stores the source
        """
        return pulumi.get(self, "relative_path")

    @relative_path.setter
    def relative_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "relative_path", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        Version of the source
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)


