# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

from enum import Enum

__all__ = [
    'BlobAuditingPolicyState',
    'CatalogCollationType',
    'CreateMode',
    'JobScheduleType',
    'JobStepActionSource',
    'JobStepActionType',
    'JobStepOutputType',
    'JobTargetGroupMembershipType',
    'JobTargetType',
    'ManagedDatabaseCreateMode',
    'ManagedInstanceAdministratorType',
    'SampleName',
    'SecurityAlertPolicyState',
    'SensitivityLabelRank',
]


class BlobAuditingPolicyState(str, Enum):
    """
    Specifies the state of the policy. If state is Enabled, storageEndpoint or isAzureMonitorTargetEnabled are required.
    """
    ENABLED = "Enabled"
    DISABLED = "Disabled"


class CatalogCollationType(str, Enum):
    """
    Collation of the metadata catalog.
    """
    DATABAS_E_DEFAULT = "DATABASE_DEFAULT"
    SQ_L_LATIN1_GENERAL_CP1_C_I_AS = "SQL_Latin1_General_CP1_CI_AS"


class CreateMode(str, Enum):
    """
    Specifies the mode of database creation.
    
    Default: regular database creation.
    
    Copy: creates a database as a copy of an existing database. sourceDatabaseId must be specified as the resource ID of the source database.
    
    Secondary: creates a database as a secondary replica of an existing database. sourceDatabaseId must be specified as the resource ID of the existing primary database.
    
    PointInTimeRestore: Creates a database by restoring a point in time backup of an existing database. sourceDatabaseId must be specified as the resource ID of the existing database, and restorePointInTime must be specified.
    
    Recovery: Creates a database by restoring a geo-replicated backup. sourceDatabaseId must be specified as the recoverable database resource ID to restore.
    
    Restore: Creates a database by restoring a backup of a deleted database. sourceDatabaseId must be specified. If sourceDatabaseId is the database's original resource ID, then sourceDatabaseDeletionDate must be specified. Otherwise sourceDatabaseId must be the restorable dropped database resource ID and sourceDatabaseDeletionDate is ignored. restorePointInTime may also be specified to restore from an earlier point in time.
    
    RestoreLongTermRetentionBackup: Creates a database by restoring from a long term retention vault. recoveryServicesRecoveryPointResourceId must be specified as the recovery point resource ID.
    
    Copy, Secondary, and RestoreLongTermRetentionBackup are not supported for DataWarehouse edition.
    """
    DEFAULT = "Default"
    COPY = "Copy"
    SECONDARY = "Secondary"
    ONLINE_SECONDARY = "OnlineSecondary"
    POINT_IN_TIME_RESTORE = "PointInTimeRestore"
    RESTORE = "Restore"
    RECOVERY = "Recovery"
    RESTORE_EXTERNAL_BACKUP = "RestoreExternalBackup"
    RESTORE_EXTERNAL_BACKUP_SECONDARY = "RestoreExternalBackupSecondary"
    RESTORE_LONG_TERM_RETENTION_BACKUP = "RestoreLongTermRetentionBackup"


class JobScheduleType(str, Enum):
    """
    Schedule interval type
    """
    ONCE = "Once"
    RECURRING = "Recurring"


class JobStepActionSource(str, Enum):
    """
    The source of the action to execute.
    """
    INLINE = "Inline"


class JobStepActionType(str, Enum):
    """
    Type of action being executed by the job step.
    """
    T_SQL = "TSql"


class JobStepOutputType(str, Enum):
    """
    The output destination type.
    """
    SQL_DATABASE = "SqlDatabase"


class JobTargetGroupMembershipType(str, Enum):
    """
    Whether the target is included or excluded from the group.
    """
    INCLUDE = "Include"
    EXCLUDE = "Exclude"


class JobTargetType(str, Enum):
    """
    The target type.
    """
    TARGET_GROUP = "TargetGroup"
    SQL_DATABASE = "SqlDatabase"
    SQL_ELASTIC_POOL = "SqlElasticPool"
    SQL_SHARD_MAP = "SqlShardMap"
    SQL_SERVER = "SqlServer"


class ManagedDatabaseCreateMode(str, Enum):
    """
    Managed database create mode. PointInTimeRestore: Create a database by restoring a point in time backup of an existing database. SourceDatabaseName, SourceManagedInstanceName and PointInTime must be specified. RestoreExternalBackup: Create a database by restoring from external backup files. Collation, StorageContainerUri and StorageContainerSasToken must be specified. Recovery: Creates a database by restoring a geo-replicated backup. RecoverableDatabaseId must be specified as the recoverable database resource ID to restore.
    """
    DEFAULT = "Default"
    RESTORE_EXTERNAL_BACKUP = "RestoreExternalBackup"
    POINT_IN_TIME_RESTORE = "PointInTimeRestore"
    RECOVERY = "Recovery"
    RESTORE_LONG_TERM_RETENTION_BACKUP = "RestoreLongTermRetentionBackup"


class ManagedInstanceAdministratorType(str, Enum):
    """
    Type of the managed instance administrator.
    """
    ACTIVE_DIRECTORY = "ActiveDirectory"


class SampleName(str, Enum):
    """
    The name of the sample schema to apply when creating this database.
    """
    ADVENTURE_WORKS_LT = "AdventureWorksLT"
    WIDE_WORLD_IMPORTERS_STD = "WideWorldImportersStd"
    WIDE_WORLD_IMPORTERS_FULL = "WideWorldImportersFull"


class SecurityAlertPolicyState(str, Enum):
    """
    Specifies the state of the policy, whether it is enabled or disabled or a policy has not been applied yet on the specific database.
    """
    NEW = "New"
    ENABLED = "Enabled"
    DISABLED = "Disabled"


class SensitivityLabelRank(str, Enum):
    NONE = "None"
    LOW = "Low"
    MEDIUM = "Medium"
    HIGH = "High"
    CRITICAL = "Critical"
