# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'CaptureDescriptionResponse',
    'ClusterSkuResponse',
    'ConnectionStateResponse',
    'DestinationResponse',
    'NWRuleSetIpRulesResponse',
    'NWRuleSetVirtualNetworkRulesResponse',
    'PrivateEndpointResponse',
    'SkuResponse',
    'SubnetResponse',
    'SystemDataResponse',
    'ThrottlingPolicyResponse',
]

@pulumi.output_type
class CaptureDescriptionResponse(dict):
    """
    Properties to configure capture description for eventhub
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "intervalInSeconds":
            suggest = "interval_in_seconds"
        elif key == "sizeLimitInBytes":
            suggest = "size_limit_in_bytes"
        elif key == "skipEmptyArchives":
            suggest = "skip_empty_archives"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CaptureDescriptionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CaptureDescriptionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CaptureDescriptionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 destination: Optional['outputs.DestinationResponse'] = None,
                 enabled: Optional[bool] = None,
                 encoding: Optional[str] = None,
                 interval_in_seconds: Optional[int] = None,
                 size_limit_in_bytes: Optional[int] = None,
                 skip_empty_archives: Optional[bool] = None):
        """
        Properties to configure capture description for eventhub
        :param 'DestinationResponse' destination: Properties of Destination where capture will be stored. (Storage Account, Blob Names)
        :param bool enabled: A value that indicates whether capture description is enabled. 
        :param str encoding: Enumerates the possible values for the encoding format of capture description. Note: 'AvroDeflate' will be deprecated in New API Version
        :param int interval_in_seconds: The time window allows you to set the frequency with which the capture to Azure Blobs will happen, value should between 60 to 900 seconds
        :param int size_limit_in_bytes: The size window defines the amount of data built up in your Event Hub before an capture operation, value should be between 10485760 to 524288000 bytes
        :param bool skip_empty_archives: A value that indicates whether to Skip Empty Archives
        """
        if destination is not None:
            pulumi.set(__self__, "destination", destination)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if encoding is not None:
            pulumi.set(__self__, "encoding", encoding)
        if interval_in_seconds is not None:
            pulumi.set(__self__, "interval_in_seconds", interval_in_seconds)
        if size_limit_in_bytes is not None:
            pulumi.set(__self__, "size_limit_in_bytes", size_limit_in_bytes)
        if skip_empty_archives is not None:
            pulumi.set(__self__, "skip_empty_archives", skip_empty_archives)

    @property
    @pulumi.getter
    def destination(self) -> Optional['outputs.DestinationResponse']:
        """
        Properties of Destination where capture will be stored. (Storage Account, Blob Names)
        """
        return pulumi.get(self, "destination")

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        """
        A value that indicates whether capture description is enabled. 
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def encoding(self) -> Optional[str]:
        """
        Enumerates the possible values for the encoding format of capture description. Note: 'AvroDeflate' will be deprecated in New API Version
        """
        return pulumi.get(self, "encoding")

    @property
    @pulumi.getter(name="intervalInSeconds")
    def interval_in_seconds(self) -> Optional[int]:
        """
        The time window allows you to set the frequency with which the capture to Azure Blobs will happen, value should between 60 to 900 seconds
        """
        return pulumi.get(self, "interval_in_seconds")

    @property
    @pulumi.getter(name="sizeLimitInBytes")
    def size_limit_in_bytes(self) -> Optional[int]:
        """
        The size window defines the amount of data built up in your Event Hub before an capture operation, value should be between 10485760 to 524288000 bytes
        """
        return pulumi.get(self, "size_limit_in_bytes")

    @property
    @pulumi.getter(name="skipEmptyArchives")
    def skip_empty_archives(self) -> Optional[bool]:
        """
        A value that indicates whether to Skip Empty Archives
        """
        return pulumi.get(self, "skip_empty_archives")


@pulumi.output_type
class ClusterSkuResponse(dict):
    """
    SKU parameters particular to a cluster instance.
    """
    def __init__(__self__, *,
                 name: str,
                 capacity: Optional[int] = None):
        """
        SKU parameters particular to a cluster instance.
        :param str name: Name of this SKU.
        :param int capacity: The quantity of Event Hubs Cluster Capacity Units contained in this cluster.
        """
        pulumi.set(__self__, "name", name)
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of this SKU.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def capacity(self) -> Optional[int]:
        """
        The quantity of Event Hubs Cluster Capacity Units contained in this cluster.
        """
        return pulumi.get(self, "capacity")


@pulumi.output_type
class ConnectionStateResponse(dict):
    """
    ConnectionState information.
    """
    def __init__(__self__, *,
                 description: Optional[str] = None,
                 status: Optional[str] = None):
        """
        ConnectionState information.
        :param str description: Description of the connection state.
        :param str status: Status of the connection.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Description of the connection state.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        Status of the connection.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class DestinationResponse(dict):
    """
    Capture storage details for capture description
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "archiveNameFormat":
            suggest = "archive_name_format"
        elif key == "blobContainer":
            suggest = "blob_container"
        elif key == "storageAccountResourceId":
            suggest = "storage_account_resource_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DestinationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DestinationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DestinationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 archive_name_format: Optional[str] = None,
                 blob_container: Optional[str] = None,
                 name: Optional[str] = None,
                 storage_account_resource_id: Optional[str] = None):
        """
        Capture storage details for capture description
        :param str archive_name_format: Blob naming convention for archive, e.g. {Namespace}/{EventHub}/{PartitionId}/{Year}/{Month}/{Day}/{Hour}/{Minute}/{Second}. Here all the parameters (Namespace,EventHub .. etc) are mandatory irrespective of order
        :param str blob_container: Blob container Name
        :param str name: Name for capture destination
        :param str storage_account_resource_id: Resource id of the storage account to be used to create the blobs
        """
        if archive_name_format is not None:
            pulumi.set(__self__, "archive_name_format", archive_name_format)
        if blob_container is not None:
            pulumi.set(__self__, "blob_container", blob_container)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if storage_account_resource_id is not None:
            pulumi.set(__self__, "storage_account_resource_id", storage_account_resource_id)

    @property
    @pulumi.getter(name="archiveNameFormat")
    def archive_name_format(self) -> Optional[str]:
        """
        Blob naming convention for archive, e.g. {Namespace}/{EventHub}/{PartitionId}/{Year}/{Month}/{Day}/{Hour}/{Minute}/{Second}. Here all the parameters (Namespace,EventHub .. etc) are mandatory irrespective of order
        """
        return pulumi.get(self, "archive_name_format")

    @property
    @pulumi.getter(name="blobContainer")
    def blob_container(self) -> Optional[str]:
        """
        Blob container Name
        """
        return pulumi.get(self, "blob_container")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name for capture destination
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="storageAccountResourceId")
    def storage_account_resource_id(self) -> Optional[str]:
        """
        Resource id of the storage account to be used to create the blobs
        """
        return pulumi.get(self, "storage_account_resource_id")


@pulumi.output_type
class NWRuleSetIpRulesResponse(dict):
    """
    Description of NetWorkRuleSet - IpRules resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipMask":
            suggest = "ip_mask"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NWRuleSetIpRulesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NWRuleSetIpRulesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NWRuleSetIpRulesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 action: Optional[str] = None,
                 ip_mask: Optional[str] = None):
        """
        Description of NetWorkRuleSet - IpRules resource.
        :param str action: The IP Filter Action
        :param str ip_mask: IP Mask
        """
        if action is None:
            action = 'Allow'
        if action is not None:
            pulumi.set(__self__, "action", action)
        if ip_mask is not None:
            pulumi.set(__self__, "ip_mask", ip_mask)

    @property
    @pulumi.getter
    def action(self) -> Optional[str]:
        """
        The IP Filter Action
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter(name="ipMask")
    def ip_mask(self) -> Optional[str]:
        """
        IP Mask
        """
        return pulumi.get(self, "ip_mask")


@pulumi.output_type
class NWRuleSetVirtualNetworkRulesResponse(dict):
    """
    Description of VirtualNetworkRules - NetworkRules resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ignoreMissingVnetServiceEndpoint":
            suggest = "ignore_missing_vnet_service_endpoint"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NWRuleSetVirtualNetworkRulesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NWRuleSetVirtualNetworkRulesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NWRuleSetVirtualNetworkRulesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ignore_missing_vnet_service_endpoint: Optional[bool] = None,
                 subnet: Optional['outputs.SubnetResponse'] = None):
        """
        Description of VirtualNetworkRules - NetworkRules resource.
        :param bool ignore_missing_vnet_service_endpoint: Value that indicates whether to ignore missing VNet Service Endpoint
        :param 'SubnetResponse' subnet: Subnet properties
        """
        if ignore_missing_vnet_service_endpoint is not None:
            pulumi.set(__self__, "ignore_missing_vnet_service_endpoint", ignore_missing_vnet_service_endpoint)
        if subnet is not None:
            pulumi.set(__self__, "subnet", subnet)

    @property
    @pulumi.getter(name="ignoreMissingVnetServiceEndpoint")
    def ignore_missing_vnet_service_endpoint(self) -> Optional[bool]:
        """
        Value that indicates whether to ignore missing VNet Service Endpoint
        """
        return pulumi.get(self, "ignore_missing_vnet_service_endpoint")

    @property
    @pulumi.getter
    def subnet(self) -> Optional['outputs.SubnetResponse']:
        """
        Subnet properties
        """
        return pulumi.get(self, "subnet")


@pulumi.output_type
class PrivateEndpointResponse(dict):
    """
    PrivateEndpoint information.
    """
    def __init__(__self__, *,
                 id: Optional[str] = None):
        """
        PrivateEndpoint information.
        :param str id: The ARM identifier for Private Endpoint.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The ARM identifier for Private Endpoint.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class SkuResponse(dict):
    """
    SKU parameters supplied to the create namespace operation
    """
    def __init__(__self__, *,
                 name: str,
                 capacity: Optional[int] = None,
                 tier: Optional[str] = None):
        """
        SKU parameters supplied to the create namespace operation
        :param str name: Name of this SKU.
        :param int capacity: The Event Hubs throughput units, value should be 0 to 20 throughput units.
        :param str tier: The billing tier of this particular SKU.
        """
        pulumi.set(__self__, "name", name)
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)
        if tier is not None:
            pulumi.set(__self__, "tier", tier)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of this SKU.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def capacity(self) -> Optional[int]:
        """
        The Event Hubs throughput units, value should be 0 to 20 throughput units.
        """
        return pulumi.get(self, "capacity")

    @property
    @pulumi.getter
    def tier(self) -> Optional[str]:
        """
        The billing tier of this particular SKU.
        """
        return pulumi.get(self, "tier")


@pulumi.output_type
class SubnetResponse(dict):
    """
    Properties supplied for Subnet
    """
    def __init__(__self__, *,
                 id: str):
        """
        Properties supplied for Subnet
        :param str id: Resource ID of Virtual Network Subnet
        """
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Resource ID of Virtual Network Subnet
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class SystemDataResponse(dict):
    """
    Metadata pertaining to creation and last modification of the resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createdAt":
            suggest = "created_at"
        elif key == "createdBy":
            suggest = "created_by"
        elif key == "createdByType":
            suggest = "created_by_type"
        elif key == "lastModifiedAt":
            suggest = "last_modified_at"
        elif key == "lastModifiedBy":
            suggest = "last_modified_by"
        elif key == "lastModifiedByType":
            suggest = "last_modified_by_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SystemDataResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SystemDataResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SystemDataResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 created_at: Optional[str] = None,
                 created_by: Optional[str] = None,
                 created_by_type: Optional[str] = None,
                 last_modified_at: Optional[str] = None,
                 last_modified_by: Optional[str] = None,
                 last_modified_by_type: Optional[str] = None):
        """
        Metadata pertaining to creation and last modification of the resource.
        :param str created_at: The timestamp of resource creation (UTC).
        :param str created_by: The identity that created the resource.
        :param str created_by_type: The type of identity that created the resource.
        :param str last_modified_at: The type of identity that last modified the resource.
        :param str last_modified_by: The identity that last modified the resource.
        :param str last_modified_by_type: The type of identity that last modified the resource.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if created_by_type is not None:
            pulumi.set(__self__, "created_by_type", created_by_type)
        if last_modified_at is not None:
            pulumi.set(__self__, "last_modified_at", last_modified_at)
        if last_modified_by is not None:
            pulumi.set(__self__, "last_modified_by", last_modified_by)
        if last_modified_by_type is not None:
            pulumi.set(__self__, "last_modified_by_type", last_modified_by_type)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[str]:
        """
        The timestamp of resource creation (UTC).
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[str]:
        """
        The identity that created the resource.
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter(name="createdByType")
    def created_by_type(self) -> Optional[str]:
        """
        The type of identity that created the resource.
        """
        return pulumi.get(self, "created_by_type")

    @property
    @pulumi.getter(name="lastModifiedAt")
    def last_modified_at(self) -> Optional[str]:
        """
        The type of identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_at")

    @property
    @pulumi.getter(name="lastModifiedBy")
    def last_modified_by(self) -> Optional[str]:
        """
        The identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by")

    @property
    @pulumi.getter(name="lastModifiedByType")
    def last_modified_by_type(self) -> Optional[str]:
        """
        The type of identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by_type")


@pulumi.output_type
class ThrottlingPolicyResponse(dict):
    """
    Properties of the throttling policy
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "metricId":
            suggest = "metric_id"
        elif key == "rateLimitThreshold":
            suggest = "rate_limit_threshold"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ThrottlingPolicyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ThrottlingPolicyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ThrottlingPolicyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 metric_id: str,
                 name: str,
                 rate_limit_threshold: float,
                 type: str):
        """
        Properties of the throttling policy
        :param str metric_id: Metric Id on which the throttle limit should be set, MetricId can be discovered by hovering over Metric in the Metrics section of Event Hub Namespace inside Azure Portal
        :param str name: The Name of this policy
        :param float rate_limit_threshold: The Threshold limit above which the application group will be throttled.Rate limit is always per second.
        :param str type: Application Group Policy types
               Expected value is 'ThrottlingPolicy'.
        """
        pulumi.set(__self__, "metric_id", metric_id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "rate_limit_threshold", rate_limit_threshold)
        pulumi.set(__self__, "type", 'ThrottlingPolicy')

    @property
    @pulumi.getter(name="metricId")
    def metric_id(self) -> str:
        """
        Metric Id on which the throttle limit should be set, MetricId can be discovered by hovering over Metric in the Metrics section of Event Hub Namespace inside Azure Portal
        """
        return pulumi.get(self, "metric_id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The Name of this policy
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="rateLimitThreshold")
    def rate_limit_threshold(self) -> float:
        """
        The Threshold limit above which the application group will be throttled.Rate limit is always per second.
        """
        return pulumi.get(self, "rate_limit_threshold")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Application Group Policy types
        Expected value is 'ThrottlingPolicy'.
        """
        return pulumi.get(self, "type")


