# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'BackendPoolResponse',
    'BackendPoolsSettingsResponse',
    'BackendResponse',
    'CacheConfigurationResponse',
    'CustomHttpsConfigurationResponse',
    'ForwardingConfigurationResponse',
    'FrontendEndpointResponse',
    'FrontendEndpointUpdateParametersResponseWebApplicationFirewallPolicyLink',
    'HealthProbeSettingsModelResponse',
    'KeyVaultCertificateSourceParametersResponseVault',
    'LoadBalancingSettingsModelResponse',
    'RedirectConfigurationResponse',
    'RoutingRuleResponse',
    'SubResourceResponse',
]

@pulumi.output_type
class BackendPoolResponse(dict):
    """
    A backend pool is a collection of backends that can be routed to.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceState":
            suggest = "resource_state"
        elif key == "healthProbeSettings":
            suggest = "health_probe_settings"
        elif key == "loadBalancingSettings":
            suggest = "load_balancing_settings"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BackendPoolResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BackendPoolResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BackendPoolResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 resource_state: str,
                 type: str,
                 backends: Optional[Sequence['outputs.BackendResponse']] = None,
                 health_probe_settings: Optional['outputs.SubResourceResponse'] = None,
                 id: Optional[str] = None,
                 load_balancing_settings: Optional['outputs.SubResourceResponse'] = None,
                 name: Optional[str] = None):
        """
        A backend pool is a collection of backends that can be routed to.
        :param str resource_state: Resource status.
        :param str type: Resource type.
        :param Sequence['BackendResponse'] backends: The set of backends for this pool
        :param 'SubResourceResponse' health_probe_settings: L7 health probe settings for a backend pool
        :param str id: Resource ID.
        :param 'SubResourceResponse' load_balancing_settings: Load balancing settings for a backend pool
        :param str name: Resource name.
        """
        pulumi.set(__self__, "resource_state", resource_state)
        pulumi.set(__self__, "type", type)
        if backends is not None:
            pulumi.set(__self__, "backends", backends)
        if health_probe_settings is not None:
            pulumi.set(__self__, "health_probe_settings", health_probe_settings)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if load_balancing_settings is not None:
            pulumi.set(__self__, "load_balancing_settings", load_balancing_settings)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="resourceState")
    def resource_state(self) -> str:
        """
        Resource status.
        """
        return pulumi.get(self, "resource_state")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Resource type.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def backends(self) -> Optional[Sequence['outputs.BackendResponse']]:
        """
        The set of backends for this pool
        """
        return pulumi.get(self, "backends")

    @property
    @pulumi.getter(name="healthProbeSettings")
    def health_probe_settings(self) -> Optional['outputs.SubResourceResponse']:
        """
        L7 health probe settings for a backend pool
        """
        return pulumi.get(self, "health_probe_settings")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="loadBalancingSettings")
    def load_balancing_settings(self) -> Optional['outputs.SubResourceResponse']:
        """
        Load balancing settings for a backend pool
        """
        return pulumi.get(self, "load_balancing_settings")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Resource name.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class BackendPoolsSettingsResponse(dict):
    """
    Settings that apply to all backend pools.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "enforceCertificateNameCheck":
            suggest = "enforce_certificate_name_check"
        elif key == "sendRecvTimeoutSeconds":
            suggest = "send_recv_timeout_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BackendPoolsSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BackendPoolsSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BackendPoolsSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enforce_certificate_name_check: Optional[str] = None,
                 send_recv_timeout_seconds: Optional[int] = None):
        """
        Settings that apply to all backend pools.
        :param str enforce_certificate_name_check: Whether to enforce certificate name check on HTTPS requests to all backend pools. No effect on non-HTTPS requests.
        :param int send_recv_timeout_seconds: Send and receive timeout on forwarding request to the backend. When timeout is reached, the request fails and returns.
        """
        if enforce_certificate_name_check is None:
            enforce_certificate_name_check = 'Enabled'
        if enforce_certificate_name_check is not None:
            pulumi.set(__self__, "enforce_certificate_name_check", enforce_certificate_name_check)
        if send_recv_timeout_seconds is not None:
            pulumi.set(__self__, "send_recv_timeout_seconds", send_recv_timeout_seconds)

    @property
    @pulumi.getter(name="enforceCertificateNameCheck")
    def enforce_certificate_name_check(self) -> Optional[str]:
        """
        Whether to enforce certificate name check on HTTPS requests to all backend pools. No effect on non-HTTPS requests.
        """
        return pulumi.get(self, "enforce_certificate_name_check")

    @property
    @pulumi.getter(name="sendRecvTimeoutSeconds")
    def send_recv_timeout_seconds(self) -> Optional[int]:
        """
        Send and receive timeout on forwarding request to the backend. When timeout is reached, the request fails and returns.
        """
        return pulumi.get(self, "send_recv_timeout_seconds")


@pulumi.output_type
class BackendResponse(dict):
    """
    Backend address of a frontDoor load balancer.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backendHostHeader":
            suggest = "backend_host_header"
        elif key == "enabledState":
            suggest = "enabled_state"
        elif key == "httpPort":
            suggest = "http_port"
        elif key == "httpsPort":
            suggest = "https_port"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BackendResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BackendResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BackendResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address: Optional[str] = None,
                 backend_host_header: Optional[str] = None,
                 enabled_state: Optional[str] = None,
                 http_port: Optional[int] = None,
                 https_port: Optional[int] = None,
                 priority: Optional[int] = None,
                 weight: Optional[int] = None):
        """
        Backend address of a frontDoor load balancer.
        :param str address: Location of the backend (IP address or FQDN)
        :param str backend_host_header: The value to use as the host header sent to the backend. If blank or unspecified, this defaults to the incoming host.
        :param str enabled_state: Whether to enable use of this backend. Permitted values are 'Enabled' or 'Disabled'
        :param int http_port: The HTTP TCP port number. Must be between 1 and 65535.
        :param int https_port: The HTTPS TCP port number. Must be between 1 and 65535.
        :param int priority: Priority to use for load balancing. Higher priorities will not be used for load balancing if any lower priority backend is healthy.
        :param int weight: Weight of this endpoint for load balancing purposes.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if backend_host_header is not None:
            pulumi.set(__self__, "backend_host_header", backend_host_header)
        if enabled_state is not None:
            pulumi.set(__self__, "enabled_state", enabled_state)
        if http_port is not None:
            pulumi.set(__self__, "http_port", http_port)
        if https_port is not None:
            pulumi.set(__self__, "https_port", https_port)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if weight is not None:
            pulumi.set(__self__, "weight", weight)

    @property
    @pulumi.getter
    def address(self) -> Optional[str]:
        """
        Location of the backend (IP address or FQDN)
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter(name="backendHostHeader")
    def backend_host_header(self) -> Optional[str]:
        """
        The value to use as the host header sent to the backend. If blank or unspecified, this defaults to the incoming host.
        """
        return pulumi.get(self, "backend_host_header")

    @property
    @pulumi.getter(name="enabledState")
    def enabled_state(self) -> Optional[str]:
        """
        Whether to enable use of this backend. Permitted values are 'Enabled' or 'Disabled'
        """
        return pulumi.get(self, "enabled_state")

    @property
    @pulumi.getter(name="httpPort")
    def http_port(self) -> Optional[int]:
        """
        The HTTP TCP port number. Must be between 1 and 65535.
        """
        return pulumi.get(self, "http_port")

    @property
    @pulumi.getter(name="httpsPort")
    def https_port(self) -> Optional[int]:
        """
        The HTTPS TCP port number. Must be between 1 and 65535.
        """
        return pulumi.get(self, "https_port")

    @property
    @pulumi.getter
    def priority(self) -> Optional[int]:
        """
        Priority to use for load balancing. Higher priorities will not be used for load balancing if any lower priority backend is healthy.
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter
    def weight(self) -> Optional[int]:
        """
        Weight of this endpoint for load balancing purposes.
        """
        return pulumi.get(self, "weight")


@pulumi.output_type
class CacheConfigurationResponse(dict):
    """
    Caching settings for a caching-type route. To disable caching, do not provide a cacheConfiguration object.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dynamicCompression":
            suggest = "dynamic_compression"
        elif key == "queryParameterStripDirective":
            suggest = "query_parameter_strip_directive"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CacheConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CacheConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CacheConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dynamic_compression: Optional[str] = None,
                 query_parameter_strip_directive: Optional[str] = None):
        """
        Caching settings for a caching-type route. To disable caching, do not provide a cacheConfiguration object.
        :param str dynamic_compression: Whether to use dynamic compression for cached content
        :param str query_parameter_strip_directive: Treatment of URL query terms when forming the cache key.
        """
        if dynamic_compression is not None:
            pulumi.set(__self__, "dynamic_compression", dynamic_compression)
        if query_parameter_strip_directive is not None:
            pulumi.set(__self__, "query_parameter_strip_directive", query_parameter_strip_directive)

    @property
    @pulumi.getter(name="dynamicCompression")
    def dynamic_compression(self) -> Optional[str]:
        """
        Whether to use dynamic compression for cached content
        """
        return pulumi.get(self, "dynamic_compression")

    @property
    @pulumi.getter(name="queryParameterStripDirective")
    def query_parameter_strip_directive(self) -> Optional[str]:
        """
        Treatment of URL query terms when forming the cache key.
        """
        return pulumi.get(self, "query_parameter_strip_directive")


@pulumi.output_type
class CustomHttpsConfigurationResponse(dict):
    """
    Https settings for a domain
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "certificateSource":
            suggest = "certificate_source"
        elif key == "minimumTlsVersion":
            suggest = "minimum_tls_version"
        elif key == "protocolType":
            suggest = "protocol_type"
        elif key == "certificateType":
            suggest = "certificate_type"
        elif key == "secretName":
            suggest = "secret_name"
        elif key == "secretVersion":
            suggest = "secret_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CustomHttpsConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CustomHttpsConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CustomHttpsConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 certificate_source: str,
                 minimum_tls_version: str,
                 protocol_type: str,
                 certificate_type: Optional[str] = None,
                 secret_name: Optional[str] = None,
                 secret_version: Optional[str] = None,
                 vault: Optional['outputs.KeyVaultCertificateSourceParametersResponseVault'] = None):
        """
        Https settings for a domain
        :param str certificate_source: Defines the source of the SSL certificate
        :param str minimum_tls_version: The minimum TLS version required from the clients to establish an SSL handshake with Front Door.
        :param str protocol_type: Defines the TLS extension protocol that is used for secure delivery
        :param str certificate_type: Defines the type of the certificate used for secure connections to a frontendEndpoint
        :param str secret_name: The name of the Key Vault secret representing the full certificate PFX
        :param str secret_version: The version of the Key Vault secret representing the full certificate PFX
        :param 'KeyVaultCertificateSourceParametersResponseVault' vault: The Key Vault containing the SSL certificate
        """
        pulumi.set(__self__, "certificate_source", certificate_source)
        pulumi.set(__self__, "minimum_tls_version", minimum_tls_version)
        pulumi.set(__self__, "protocol_type", protocol_type)
        if certificate_type is not None:
            pulumi.set(__self__, "certificate_type", certificate_type)
        if secret_name is not None:
            pulumi.set(__self__, "secret_name", secret_name)
        if secret_version is not None:
            pulumi.set(__self__, "secret_version", secret_version)
        if vault is not None:
            pulumi.set(__self__, "vault", vault)

    @property
    @pulumi.getter(name="certificateSource")
    def certificate_source(self) -> str:
        """
        Defines the source of the SSL certificate
        """
        return pulumi.get(self, "certificate_source")

    @property
    @pulumi.getter(name="minimumTlsVersion")
    def minimum_tls_version(self) -> str:
        """
        The minimum TLS version required from the clients to establish an SSL handshake with Front Door.
        """
        return pulumi.get(self, "minimum_tls_version")

    @property
    @pulumi.getter(name="protocolType")
    def protocol_type(self) -> str:
        """
        Defines the TLS extension protocol that is used for secure delivery
        """
        return pulumi.get(self, "protocol_type")

    @property
    @pulumi.getter(name="certificateType")
    def certificate_type(self) -> Optional[str]:
        """
        Defines the type of the certificate used for secure connections to a frontendEndpoint
        """
        return pulumi.get(self, "certificate_type")

    @property
    @pulumi.getter(name="secretName")
    def secret_name(self) -> Optional[str]:
        """
        The name of the Key Vault secret representing the full certificate PFX
        """
        return pulumi.get(self, "secret_name")

    @property
    @pulumi.getter(name="secretVersion")
    def secret_version(self) -> Optional[str]:
        """
        The version of the Key Vault secret representing the full certificate PFX
        """
        return pulumi.get(self, "secret_version")

    @property
    @pulumi.getter
    def vault(self) -> Optional['outputs.KeyVaultCertificateSourceParametersResponseVault']:
        """
        The Key Vault containing the SSL certificate
        """
        return pulumi.get(self, "vault")


@pulumi.output_type
class ForwardingConfigurationResponse(dict):
    """
    Describes Forwarding Route.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "odataType":
            suggest = "odata_type"
        elif key == "backendPool":
            suggest = "backend_pool"
        elif key == "cacheConfiguration":
            suggest = "cache_configuration"
        elif key == "customForwardingPath":
            suggest = "custom_forwarding_path"
        elif key == "forwardingProtocol":
            suggest = "forwarding_protocol"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ForwardingConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ForwardingConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ForwardingConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 odata_type: str,
                 backend_pool: Optional['outputs.SubResourceResponse'] = None,
                 cache_configuration: Optional['outputs.CacheConfigurationResponse'] = None,
                 custom_forwarding_path: Optional[str] = None,
                 forwarding_protocol: Optional[str] = None):
        """
        Describes Forwarding Route.
        :param str odata_type: 
               Expected value is '#Microsoft.Azure.FrontDoor.Models.FrontdoorForwardingConfiguration'.
        :param 'SubResourceResponse' backend_pool: A reference to the BackendPool which this rule routes to.
        :param 'CacheConfigurationResponse' cache_configuration: The caching configuration associated with this rule.
        :param str custom_forwarding_path: A custom path used to rewrite resource paths matched by this rule. Leave empty to use incoming path.
        :param str forwarding_protocol: Protocol this rule will use when forwarding traffic to backends.
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Azure.FrontDoor.Models.FrontdoorForwardingConfiguration')
        if backend_pool is not None:
            pulumi.set(__self__, "backend_pool", backend_pool)
        if cache_configuration is not None:
            pulumi.set(__self__, "cache_configuration", cache_configuration)
        if custom_forwarding_path is not None:
            pulumi.set(__self__, "custom_forwarding_path", custom_forwarding_path)
        if forwarding_protocol is not None:
            pulumi.set(__self__, "forwarding_protocol", forwarding_protocol)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        """

        Expected value is '#Microsoft.Azure.FrontDoor.Models.FrontdoorForwardingConfiguration'.
        """
        return pulumi.get(self, "odata_type")

    @property
    @pulumi.getter(name="backendPool")
    def backend_pool(self) -> Optional['outputs.SubResourceResponse']:
        """
        A reference to the BackendPool which this rule routes to.
        """
        return pulumi.get(self, "backend_pool")

    @property
    @pulumi.getter(name="cacheConfiguration")
    def cache_configuration(self) -> Optional['outputs.CacheConfigurationResponse']:
        """
        The caching configuration associated with this rule.
        """
        return pulumi.get(self, "cache_configuration")

    @property
    @pulumi.getter(name="customForwardingPath")
    def custom_forwarding_path(self) -> Optional[str]:
        """
        A custom path used to rewrite resource paths matched by this rule. Leave empty to use incoming path.
        """
        return pulumi.get(self, "custom_forwarding_path")

    @property
    @pulumi.getter(name="forwardingProtocol")
    def forwarding_protocol(self) -> Optional[str]:
        """
        Protocol this rule will use when forwarding traffic to backends.
        """
        return pulumi.get(self, "forwarding_protocol")


@pulumi.output_type
class FrontendEndpointResponse(dict):
    """
    A frontend endpoint used for routing.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "customHttpsConfiguration":
            suggest = "custom_https_configuration"
        elif key == "customHttpsProvisioningState":
            suggest = "custom_https_provisioning_state"
        elif key == "customHttpsProvisioningSubstate":
            suggest = "custom_https_provisioning_substate"
        elif key == "resourceState":
            suggest = "resource_state"
        elif key == "hostName":
            suggest = "host_name"
        elif key == "sessionAffinityEnabledState":
            suggest = "session_affinity_enabled_state"
        elif key == "sessionAffinityTtlSeconds":
            suggest = "session_affinity_ttl_seconds"
        elif key == "webApplicationFirewallPolicyLink":
            suggest = "web_application_firewall_policy_link"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FrontendEndpointResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FrontendEndpointResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FrontendEndpointResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 custom_https_configuration: 'outputs.CustomHttpsConfigurationResponse',
                 custom_https_provisioning_state: str,
                 custom_https_provisioning_substate: str,
                 resource_state: str,
                 type: str,
                 host_name: Optional[str] = None,
                 id: Optional[str] = None,
                 name: Optional[str] = None,
                 session_affinity_enabled_state: Optional[str] = None,
                 session_affinity_ttl_seconds: Optional[int] = None,
                 web_application_firewall_policy_link: Optional['outputs.FrontendEndpointUpdateParametersResponseWebApplicationFirewallPolicyLink'] = None):
        """
        A frontend endpoint used for routing.
        :param 'CustomHttpsConfigurationResponse' custom_https_configuration: The configuration specifying how to enable HTTPS
        :param str custom_https_provisioning_state: Provisioning status of Custom Https of the frontendEndpoint.
        :param str custom_https_provisioning_substate: Provisioning substate shows the progress of custom HTTPS enabling/disabling process step by step.
        :param str resource_state: Resource status.
        :param str type: Resource type.
        :param str host_name: The host name of the frontendEndpoint. Must be a domain name.
        :param str id: Resource ID.
        :param str name: Resource name.
        :param str session_affinity_enabled_state: Whether to allow session affinity on this host. Valid options are 'Enabled' or 'Disabled'
        :param int session_affinity_ttl_seconds: UNUSED. This field will be ignored. The TTL to use in seconds for session affinity, if applicable.
        :param 'FrontendEndpointUpdateParametersResponseWebApplicationFirewallPolicyLink' web_application_firewall_policy_link: Defines the Web Application Firewall policy for each host (if applicable)
        """
        pulumi.set(__self__, "custom_https_configuration", custom_https_configuration)
        pulumi.set(__self__, "custom_https_provisioning_state", custom_https_provisioning_state)
        pulumi.set(__self__, "custom_https_provisioning_substate", custom_https_provisioning_substate)
        pulumi.set(__self__, "resource_state", resource_state)
        pulumi.set(__self__, "type", type)
        if host_name is not None:
            pulumi.set(__self__, "host_name", host_name)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if session_affinity_enabled_state is not None:
            pulumi.set(__self__, "session_affinity_enabled_state", session_affinity_enabled_state)
        if session_affinity_ttl_seconds is not None:
            pulumi.set(__self__, "session_affinity_ttl_seconds", session_affinity_ttl_seconds)
        if web_application_firewall_policy_link is not None:
            pulumi.set(__self__, "web_application_firewall_policy_link", web_application_firewall_policy_link)

    @property
    @pulumi.getter(name="customHttpsConfiguration")
    def custom_https_configuration(self) -> 'outputs.CustomHttpsConfigurationResponse':
        """
        The configuration specifying how to enable HTTPS
        """
        return pulumi.get(self, "custom_https_configuration")

    @property
    @pulumi.getter(name="customHttpsProvisioningState")
    def custom_https_provisioning_state(self) -> str:
        """
        Provisioning status of Custom Https of the frontendEndpoint.
        """
        return pulumi.get(self, "custom_https_provisioning_state")

    @property
    @pulumi.getter(name="customHttpsProvisioningSubstate")
    def custom_https_provisioning_substate(self) -> str:
        """
        Provisioning substate shows the progress of custom HTTPS enabling/disabling process step by step.
        """
        return pulumi.get(self, "custom_https_provisioning_substate")

    @property
    @pulumi.getter(name="resourceState")
    def resource_state(self) -> str:
        """
        Resource status.
        """
        return pulumi.get(self, "resource_state")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Resource type.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="hostName")
    def host_name(self) -> Optional[str]:
        """
        The host name of the frontendEndpoint. Must be a domain name.
        """
        return pulumi.get(self, "host_name")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Resource name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="sessionAffinityEnabledState")
    def session_affinity_enabled_state(self) -> Optional[str]:
        """
        Whether to allow session affinity on this host. Valid options are 'Enabled' or 'Disabled'
        """
        return pulumi.get(self, "session_affinity_enabled_state")

    @property
    @pulumi.getter(name="sessionAffinityTtlSeconds")
    def session_affinity_ttl_seconds(self) -> Optional[int]:
        """
        UNUSED. This field will be ignored. The TTL to use in seconds for session affinity, if applicable.
        """
        return pulumi.get(self, "session_affinity_ttl_seconds")

    @property
    @pulumi.getter(name="webApplicationFirewallPolicyLink")
    def web_application_firewall_policy_link(self) -> Optional['outputs.FrontendEndpointUpdateParametersResponseWebApplicationFirewallPolicyLink']:
        """
        Defines the Web Application Firewall policy for each host (if applicable)
        """
        return pulumi.get(self, "web_application_firewall_policy_link")


@pulumi.output_type
class FrontendEndpointUpdateParametersResponseWebApplicationFirewallPolicyLink(dict):
    """
    Defines the Web Application Firewall policy for each host (if applicable)
    """
    def __init__(__self__, *,
                 id: Optional[str] = None):
        """
        Defines the Web Application Firewall policy for each host (if applicable)
        :param str id: Resource ID.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class HealthProbeSettingsModelResponse(dict):
    """
    Load balancing settings for a backend pool
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceState":
            suggest = "resource_state"
        elif key == "enabledState":
            suggest = "enabled_state"
        elif key == "healthProbeMethod":
            suggest = "health_probe_method"
        elif key == "intervalInSeconds":
            suggest = "interval_in_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HealthProbeSettingsModelResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HealthProbeSettingsModelResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HealthProbeSettingsModelResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 resource_state: str,
                 type: str,
                 enabled_state: Optional[str] = None,
                 health_probe_method: Optional[str] = None,
                 id: Optional[str] = None,
                 interval_in_seconds: Optional[int] = None,
                 name: Optional[str] = None,
                 path: Optional[str] = None,
                 protocol: Optional[str] = None):
        """
        Load balancing settings for a backend pool
        :param str resource_state: Resource status.
        :param str type: Resource type.
        :param str enabled_state: Whether to enable health probes to be made against backends defined under backendPools. Health probes can only be disabled if there is a single enabled backend in single enabled backend pool.
        :param str health_probe_method: Configures which HTTP method to use to probe the backends defined under backendPools.
        :param str id: Resource ID.
        :param int interval_in_seconds: The number of seconds between health probes.
        :param str name: Resource name.
        :param str path: The path to use for the health probe. Default is /
        :param str protocol: Protocol scheme to use for this probe
        """
        pulumi.set(__self__, "resource_state", resource_state)
        pulumi.set(__self__, "type", type)
        if enabled_state is not None:
            pulumi.set(__self__, "enabled_state", enabled_state)
        if health_probe_method is None:
            health_probe_method = 'HEAD'
        if health_probe_method is not None:
            pulumi.set(__self__, "health_probe_method", health_probe_method)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if interval_in_seconds is not None:
            pulumi.set(__self__, "interval_in_seconds", interval_in_seconds)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)

    @property
    @pulumi.getter(name="resourceState")
    def resource_state(self) -> str:
        """
        Resource status.
        """
        return pulumi.get(self, "resource_state")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Resource type.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="enabledState")
    def enabled_state(self) -> Optional[str]:
        """
        Whether to enable health probes to be made against backends defined under backendPools. Health probes can only be disabled if there is a single enabled backend in single enabled backend pool.
        """
        return pulumi.get(self, "enabled_state")

    @property
    @pulumi.getter(name="healthProbeMethod")
    def health_probe_method(self) -> Optional[str]:
        """
        Configures which HTTP method to use to probe the backends defined under backendPools.
        """
        return pulumi.get(self, "health_probe_method")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="intervalInSeconds")
    def interval_in_seconds(self) -> Optional[int]:
        """
        The number of seconds between health probes.
        """
        return pulumi.get(self, "interval_in_seconds")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Resource name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        The path to use for the health probe. Default is /
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def protocol(self) -> Optional[str]:
        """
        Protocol scheme to use for this probe
        """
        return pulumi.get(self, "protocol")


@pulumi.output_type
class KeyVaultCertificateSourceParametersResponseVault(dict):
    """
    The Key Vault containing the SSL certificate
    """
    def __init__(__self__, *,
                 id: Optional[str] = None):
        """
        The Key Vault containing the SSL certificate
        :param str id: Resource ID.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class LoadBalancingSettingsModelResponse(dict):
    """
    Load balancing settings for a backend pool
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceState":
            suggest = "resource_state"
        elif key == "additionalLatencyMilliseconds":
            suggest = "additional_latency_milliseconds"
        elif key == "sampleSize":
            suggest = "sample_size"
        elif key == "successfulSamplesRequired":
            suggest = "successful_samples_required"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LoadBalancingSettingsModelResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LoadBalancingSettingsModelResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LoadBalancingSettingsModelResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 resource_state: str,
                 type: str,
                 additional_latency_milliseconds: Optional[int] = None,
                 id: Optional[str] = None,
                 name: Optional[str] = None,
                 sample_size: Optional[int] = None,
                 successful_samples_required: Optional[int] = None):
        """
        Load balancing settings for a backend pool
        :param str resource_state: Resource status.
        :param str type: Resource type.
        :param int additional_latency_milliseconds: The additional latency in milliseconds for probes to fall into the lowest latency bucket
        :param str id: Resource ID.
        :param str name: Resource name.
        :param int sample_size: The number of samples to consider for load balancing decisions
        :param int successful_samples_required: The number of samples within the sample period that must succeed
        """
        pulumi.set(__self__, "resource_state", resource_state)
        pulumi.set(__self__, "type", type)
        if additional_latency_milliseconds is not None:
            pulumi.set(__self__, "additional_latency_milliseconds", additional_latency_milliseconds)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if sample_size is not None:
            pulumi.set(__self__, "sample_size", sample_size)
        if successful_samples_required is not None:
            pulumi.set(__self__, "successful_samples_required", successful_samples_required)

    @property
    @pulumi.getter(name="resourceState")
    def resource_state(self) -> str:
        """
        Resource status.
        """
        return pulumi.get(self, "resource_state")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Resource type.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="additionalLatencyMilliseconds")
    def additional_latency_milliseconds(self) -> Optional[int]:
        """
        The additional latency in milliseconds for probes to fall into the lowest latency bucket
        """
        return pulumi.get(self, "additional_latency_milliseconds")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Resource name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="sampleSize")
    def sample_size(self) -> Optional[int]:
        """
        The number of samples to consider for load balancing decisions
        """
        return pulumi.get(self, "sample_size")

    @property
    @pulumi.getter(name="successfulSamplesRequired")
    def successful_samples_required(self) -> Optional[int]:
        """
        The number of samples within the sample period that must succeed
        """
        return pulumi.get(self, "successful_samples_required")


@pulumi.output_type
class RedirectConfigurationResponse(dict):
    """
    Describes Redirect Route.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "odataType":
            suggest = "odata_type"
        elif key == "customFragment":
            suggest = "custom_fragment"
        elif key == "customHost":
            suggest = "custom_host"
        elif key == "customPath":
            suggest = "custom_path"
        elif key == "customQueryString":
            suggest = "custom_query_string"
        elif key == "redirectProtocol":
            suggest = "redirect_protocol"
        elif key == "redirectType":
            suggest = "redirect_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RedirectConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RedirectConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RedirectConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 odata_type: str,
                 custom_fragment: Optional[str] = None,
                 custom_host: Optional[str] = None,
                 custom_path: Optional[str] = None,
                 custom_query_string: Optional[str] = None,
                 redirect_protocol: Optional[str] = None,
                 redirect_type: Optional[str] = None):
        """
        Describes Redirect Route.
        :param str odata_type: 
               Expected value is '#Microsoft.Azure.FrontDoor.Models.FrontdoorRedirectConfiguration'.
        :param str custom_fragment: Fragment to add to the redirect URL. Fragment is the part of the URL that comes after #. Do not include the #.
        :param str custom_host: Host to redirect. Leave empty to use the incoming host as the destination host.
        :param str custom_path: The full path to redirect. Path cannot be empty and must start with /. Leave empty to use the incoming path as destination path.
        :param str custom_query_string: The set of query strings to be placed in the redirect URL. Setting this value would replace any existing query string; leave empty to preserve the incoming query string. Query string must be in <key>=<value> format. The first ? and & will be added automatically so do not include them in the front, but do separate multiple query strings with &.
        :param str redirect_protocol: The protocol of the destination to where the traffic is redirected
        :param str redirect_type: The redirect type the rule will use when redirecting traffic.
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Azure.FrontDoor.Models.FrontdoorRedirectConfiguration')
        if custom_fragment is not None:
            pulumi.set(__self__, "custom_fragment", custom_fragment)
        if custom_host is not None:
            pulumi.set(__self__, "custom_host", custom_host)
        if custom_path is not None:
            pulumi.set(__self__, "custom_path", custom_path)
        if custom_query_string is not None:
            pulumi.set(__self__, "custom_query_string", custom_query_string)
        if redirect_protocol is not None:
            pulumi.set(__self__, "redirect_protocol", redirect_protocol)
        if redirect_type is not None:
            pulumi.set(__self__, "redirect_type", redirect_type)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        """

        Expected value is '#Microsoft.Azure.FrontDoor.Models.FrontdoorRedirectConfiguration'.
        """
        return pulumi.get(self, "odata_type")

    @property
    @pulumi.getter(name="customFragment")
    def custom_fragment(self) -> Optional[str]:
        """
        Fragment to add to the redirect URL. Fragment is the part of the URL that comes after #. Do not include the #.
        """
        return pulumi.get(self, "custom_fragment")

    @property
    @pulumi.getter(name="customHost")
    def custom_host(self) -> Optional[str]:
        """
        Host to redirect. Leave empty to use the incoming host as the destination host.
        """
        return pulumi.get(self, "custom_host")

    @property
    @pulumi.getter(name="customPath")
    def custom_path(self) -> Optional[str]:
        """
        The full path to redirect. Path cannot be empty and must start with /. Leave empty to use the incoming path as destination path.
        """
        return pulumi.get(self, "custom_path")

    @property
    @pulumi.getter(name="customQueryString")
    def custom_query_string(self) -> Optional[str]:
        """
        The set of query strings to be placed in the redirect URL. Setting this value would replace any existing query string; leave empty to preserve the incoming query string. Query string must be in <key>=<value> format. The first ? and & will be added automatically so do not include them in the front, but do separate multiple query strings with &.
        """
        return pulumi.get(self, "custom_query_string")

    @property
    @pulumi.getter(name="redirectProtocol")
    def redirect_protocol(self) -> Optional[str]:
        """
        The protocol of the destination to where the traffic is redirected
        """
        return pulumi.get(self, "redirect_protocol")

    @property
    @pulumi.getter(name="redirectType")
    def redirect_type(self) -> Optional[str]:
        """
        The redirect type the rule will use when redirecting traffic.
        """
        return pulumi.get(self, "redirect_type")


@pulumi.output_type
class RoutingRuleResponse(dict):
    """
    A routing rule represents a specification for traffic to treat and where to send it, along with health probe information.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceState":
            suggest = "resource_state"
        elif key == "acceptedProtocols":
            suggest = "accepted_protocols"
        elif key == "enabledState":
            suggest = "enabled_state"
        elif key == "frontendEndpoints":
            suggest = "frontend_endpoints"
        elif key == "patternsToMatch":
            suggest = "patterns_to_match"
        elif key == "routeConfiguration":
            suggest = "route_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RoutingRuleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RoutingRuleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RoutingRuleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 resource_state: str,
                 type: str,
                 accepted_protocols: Optional[Sequence[str]] = None,
                 enabled_state: Optional[str] = None,
                 frontend_endpoints: Optional[Sequence['outputs.SubResourceResponse']] = None,
                 id: Optional[str] = None,
                 name: Optional[str] = None,
                 patterns_to_match: Optional[Sequence[str]] = None,
                 route_configuration: Optional[Any] = None):
        """
        A routing rule represents a specification for traffic to treat and where to send it, along with health probe information.
        :param str resource_state: Resource status.
        :param str type: Resource type.
        :param Sequence[str] accepted_protocols: Protocol schemes to match for this rule
        :param str enabled_state: Whether to enable use of this rule. Permitted values are 'Enabled' or 'Disabled'
        :param Sequence['SubResourceResponse'] frontend_endpoints: Frontend endpoints associated with this rule
        :param str id: Resource ID.
        :param str name: Resource name.
        :param Sequence[str] patterns_to_match: The route patterns of the rule.
        :param Union['ForwardingConfigurationResponse', 'RedirectConfigurationResponse'] route_configuration: A reference to the routing configuration.
        """
        pulumi.set(__self__, "resource_state", resource_state)
        pulumi.set(__self__, "type", type)
        if accepted_protocols is not None:
            pulumi.set(__self__, "accepted_protocols", accepted_protocols)
        if enabled_state is not None:
            pulumi.set(__self__, "enabled_state", enabled_state)
        if frontend_endpoints is not None:
            pulumi.set(__self__, "frontend_endpoints", frontend_endpoints)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if patterns_to_match is not None:
            pulumi.set(__self__, "patterns_to_match", patterns_to_match)
        if route_configuration is not None:
            pulumi.set(__self__, "route_configuration", route_configuration)

    @property
    @pulumi.getter(name="resourceState")
    def resource_state(self) -> str:
        """
        Resource status.
        """
        return pulumi.get(self, "resource_state")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Resource type.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="acceptedProtocols")
    def accepted_protocols(self) -> Optional[Sequence[str]]:
        """
        Protocol schemes to match for this rule
        """
        return pulumi.get(self, "accepted_protocols")

    @property
    @pulumi.getter(name="enabledState")
    def enabled_state(self) -> Optional[str]:
        """
        Whether to enable use of this rule. Permitted values are 'Enabled' or 'Disabled'
        """
        return pulumi.get(self, "enabled_state")

    @property
    @pulumi.getter(name="frontendEndpoints")
    def frontend_endpoints(self) -> Optional[Sequence['outputs.SubResourceResponse']]:
        """
        Frontend endpoints associated with this rule
        """
        return pulumi.get(self, "frontend_endpoints")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Resource name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="patternsToMatch")
    def patterns_to_match(self) -> Optional[Sequence[str]]:
        """
        The route patterns of the rule.
        """
        return pulumi.get(self, "patterns_to_match")

    @property
    @pulumi.getter(name="routeConfiguration")
    def route_configuration(self) -> Optional[Any]:
        """
        A reference to the routing configuration.
        """
        return pulumi.get(self, "route_configuration")


@pulumi.output_type
class SubResourceResponse(dict):
    """
    Reference to another subresource.
    """
    def __init__(__self__, *,
                 id: Optional[str] = None):
        """
        Reference to another subresource.
        :param str id: Resource ID.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")


