# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetSimResult',
    'AwaitableGetSimResult',
    'get_sim',
    'get_sim_output',
]

@pulumi.output_type
class GetSimResult:
    """
    Sim resource.
    """
    def __init__(__self__, configuration_state=None, created_at=None, created_by=None, created_by_type=None, device_type=None, id=None, integrated_circuit_card_identifier=None, international_mobile_subscriber_identity=None, last_modified_at=None, last_modified_by=None, last_modified_by_type=None, location=None, mobile_network=None, name=None, provisioning_state=None, sim_policy=None, static_ip_configuration=None, tags=None, type=None):
        if configuration_state and not isinstance(configuration_state, str):
            raise TypeError("Expected argument 'configuration_state' to be a str")
        pulumi.set(__self__, "configuration_state", configuration_state)
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if created_by and not isinstance(created_by, str):
            raise TypeError("Expected argument 'created_by' to be a str")
        pulumi.set(__self__, "created_by", created_by)
        if created_by_type and not isinstance(created_by_type, str):
            raise TypeError("Expected argument 'created_by_type' to be a str")
        pulumi.set(__self__, "created_by_type", created_by_type)
        if device_type and not isinstance(device_type, str):
            raise TypeError("Expected argument 'device_type' to be a str")
        pulumi.set(__self__, "device_type", device_type)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if integrated_circuit_card_identifier and not isinstance(integrated_circuit_card_identifier, str):
            raise TypeError("Expected argument 'integrated_circuit_card_identifier' to be a str")
        pulumi.set(__self__, "integrated_circuit_card_identifier", integrated_circuit_card_identifier)
        if international_mobile_subscriber_identity and not isinstance(international_mobile_subscriber_identity, str):
            raise TypeError("Expected argument 'international_mobile_subscriber_identity' to be a str")
        pulumi.set(__self__, "international_mobile_subscriber_identity", international_mobile_subscriber_identity)
        if last_modified_at and not isinstance(last_modified_at, str):
            raise TypeError("Expected argument 'last_modified_at' to be a str")
        pulumi.set(__self__, "last_modified_at", last_modified_at)
        if last_modified_by and not isinstance(last_modified_by, str):
            raise TypeError("Expected argument 'last_modified_by' to be a str")
        pulumi.set(__self__, "last_modified_by", last_modified_by)
        if last_modified_by_type and not isinstance(last_modified_by_type, str):
            raise TypeError("Expected argument 'last_modified_by_type' to be a str")
        pulumi.set(__self__, "last_modified_by_type", last_modified_by_type)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if mobile_network and not isinstance(mobile_network, dict):
            raise TypeError("Expected argument 'mobile_network' to be a dict")
        pulumi.set(__self__, "mobile_network", mobile_network)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if provisioning_state and not isinstance(provisioning_state, str):
            raise TypeError("Expected argument 'provisioning_state' to be a str")
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if sim_policy and not isinstance(sim_policy, dict):
            raise TypeError("Expected argument 'sim_policy' to be a dict")
        pulumi.set(__self__, "sim_policy", sim_policy)
        if static_ip_configuration and not isinstance(static_ip_configuration, list):
            raise TypeError("Expected argument 'static_ip_configuration' to be a list")
        pulumi.set(__self__, "static_ip_configuration", static_ip_configuration)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="configurationState")
    def configuration_state(self) -> str:
        """
        The configuration state of the sim resource - complete or incomplete.
        """
        return pulumi.get(self, "configuration_state")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[str]:
        """
        The timestamp of resource creation (UTC).
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[str]:
        """
        The identity that created the resource.
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter(name="createdByType")
    def created_by_type(self) -> Optional[str]:
        """
        The type of identity that created the resource.
        """
        return pulumi.get(self, "created_by_type")

    @property
    @pulumi.getter(name="deviceType")
    def device_type(self) -> Optional[str]:
        """
        An optional free-form text field that can be used to record the device type this sim is associated with, for example 'Video camera'. The Azure portal allows Sims to be grouped and filtered based on this value.
        """
        return pulumi.get(self, "device_type")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="integratedCircuitCardIdentifier")
    def integrated_circuit_card_identifier(self) -> Optional[str]:
        """
        The Integrated Circuit Card ID (ICC Id) for the sim.
        """
        return pulumi.get(self, "integrated_circuit_card_identifier")

    @property
    @pulumi.getter(name="internationalMobileSubscriberIdentity")
    def international_mobile_subscriber_identity(self) -> str:
        """
        The International Mobile Subscriber Identity (IMSI) for the sim.
        """
        return pulumi.get(self, "international_mobile_subscriber_identity")

    @property
    @pulumi.getter(name="lastModifiedAt")
    def last_modified_at(self) -> Optional[str]:
        """
        The timestamp of resource last modification (UTC)
        """
        return pulumi.get(self, "last_modified_at")

    @property
    @pulumi.getter(name="lastModifiedBy")
    def last_modified_by(self) -> Optional[str]:
        """
        The identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by")

    @property
    @pulumi.getter(name="lastModifiedByType")
    def last_modified_by_type(self) -> Optional[str]:
        """
        The type of identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by_type")

    @property
    @pulumi.getter
    def location(self) -> str:
        """
        The geo-location where the resource lives
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="mobileNetwork")
    def mobile_network(self) -> Optional['outputs.MobileNetworkResourceIdResponse']:
        """
        Mobile network that this sim belongs to
        """
        return pulumi.get(self, "mobile_network")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state of the sim resource.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="simPolicy")
    def sim_policy(self) -> Optional['outputs.SimPolicyResourceIdResponse']:
        """
        The simPolicy used by this sim.
        """
        return pulumi.get(self, "sim_policy")

    @property
    @pulumi.getter(name="staticIpConfiguration")
    def static_ip_configuration(self) -> Optional[Sequence['outputs.SimStaticIpPropertiesResponse']]:
        """
        A list of static IP addresses assigned to this sim. Each address is assigned at a defined network scope, made up of {attached data network, slice}.
        """
        return pulumi.get(self, "static_ip_configuration")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        Resource tags.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
        """
        return pulumi.get(self, "type")


class AwaitableGetSimResult(GetSimResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSimResult(
            configuration_state=self.configuration_state,
            created_at=self.created_at,
            created_by=self.created_by,
            created_by_type=self.created_by_type,
            device_type=self.device_type,
            id=self.id,
            integrated_circuit_card_identifier=self.integrated_circuit_card_identifier,
            international_mobile_subscriber_identity=self.international_mobile_subscriber_identity,
            last_modified_at=self.last_modified_at,
            last_modified_by=self.last_modified_by,
            last_modified_by_type=self.last_modified_by_type,
            location=self.location,
            mobile_network=self.mobile_network,
            name=self.name,
            provisioning_state=self.provisioning_state,
            sim_policy=self.sim_policy,
            static_ip_configuration=self.static_ip_configuration,
            tags=self.tags,
            type=self.type)


def get_sim(resource_group_name: Optional[str] = None,
            sim_name: Optional[str] = None,
            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSimResult:
    """
    Sim resource.
    API Version: 2022-01-01-preview.


    :param str resource_group_name: The name of the resource group. The name is case insensitive.
    :param str sim_name: The name of the SIM.
    """
    __args__ = dict()
    __args__['resourceGroupName'] = resource_group_name
    __args__['simName'] = sim_name
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('azure-native:mobilenetwork:getSim', __args__, opts=opts, typ=GetSimResult).value

    return AwaitableGetSimResult(
        configuration_state=__ret__.configuration_state,
        created_at=__ret__.created_at,
        created_by=__ret__.created_by,
        created_by_type=__ret__.created_by_type,
        device_type=__ret__.device_type,
        id=__ret__.id,
        integrated_circuit_card_identifier=__ret__.integrated_circuit_card_identifier,
        international_mobile_subscriber_identity=__ret__.international_mobile_subscriber_identity,
        last_modified_at=__ret__.last_modified_at,
        last_modified_by=__ret__.last_modified_by,
        last_modified_by_type=__ret__.last_modified_by_type,
        location=__ret__.location,
        mobile_network=__ret__.mobile_network,
        name=__ret__.name,
        provisioning_state=__ret__.provisioning_state,
        sim_policy=__ret__.sim_policy,
        static_ip_configuration=__ret__.static_ip_configuration,
        tags=__ret__.tags,
        type=__ret__.type)


@_utilities.lift_output_func(get_sim)
def get_sim_output(resource_group_name: Optional[pulumi.Input[str]] = None,
                   sim_name: Optional[pulumi.Input[str]] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetSimResult]:
    """
    Sim resource.
    API Version: 2022-01-01-preview.


    :param str resource_group_name: The name of the resource group. The name is case insensitive.
    :param str sim_name: The name of the SIM.
    """
    ...
