# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetApplicationGroupResult',
    'AwaitableGetApplicationGroupResult',
    'get_application_group',
    'get_application_group_output',
]

@pulumi.output_type
class GetApplicationGroupResult:
    """
    The Application Group object
    """
    def __init__(__self__, client_app_group_identifier=None, id=None, is_enabled=None, location=None, name=None, policies=None, system_data=None, type=None):
        if client_app_group_identifier and not isinstance(client_app_group_identifier, str):
            raise TypeError("Expected argument 'client_app_group_identifier' to be a str")
        pulumi.set(__self__, "client_app_group_identifier", client_app_group_identifier)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_enabled and not isinstance(is_enabled, bool):
            raise TypeError("Expected argument 'is_enabled' to be a bool")
        pulumi.set(__self__, "is_enabled", is_enabled)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if policies and not isinstance(policies, list):
            raise TypeError("Expected argument 'policies' to be a list")
        pulumi.set(__self__, "policies", policies)
        if system_data and not isinstance(system_data, dict):
            raise TypeError("Expected argument 'system_data' to be a dict")
        pulumi.set(__self__, "system_data", system_data)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="clientAppGroupIdentifier")
    def client_app_group_identifier(self) -> str:
        """
        The Unique identifier for application group.Supports SAS(SASKeyName=KeyName) or AAD(AADAppID=Guid)
        """
        return pulumi.get(self, "client_app_group_identifier")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> Optional[bool]:
        """
        Determines if Application Group is allowed to create connection with namespace or not. Once the isEnabled is set to false, all the existing connections of application group gets dropped and no new connections will be allowed
        """
        return pulumi.get(self, "is_enabled")

    @property
    @pulumi.getter
    def location(self) -> str:
        """
        The geo-location where the resource lives
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def policies(self) -> Optional[Sequence['outputs.ThrottlingPolicyResponse']]:
        """
        List of group policies that define the behavior of application group. The policies can support resource governance scenarios such as limiting ingress or egress traffic.
        """
        return pulumi.get(self, "policies")

    @property
    @pulumi.getter(name="systemData")
    def system_data(self) -> 'outputs.SystemDataResponse':
        """
        The system meta data relating to this resource.
        """
        return pulumi.get(self, "system_data")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the resource. E.g. "Microsoft.EventHub/Namespaces" or "Microsoft.EventHub/Namespaces/EventHubs"
        """
        return pulumi.get(self, "type")


class AwaitableGetApplicationGroupResult(GetApplicationGroupResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetApplicationGroupResult(
            client_app_group_identifier=self.client_app_group_identifier,
            id=self.id,
            is_enabled=self.is_enabled,
            location=self.location,
            name=self.name,
            policies=self.policies,
            system_data=self.system_data,
            type=self.type)


def get_application_group(application_group_name: Optional[str] = None,
                          namespace_name: Optional[str] = None,
                          resource_group_name: Optional[str] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetApplicationGroupResult:
    """
    The Application Group object


    :param str application_group_name: The Application Group name 
    :param str namespace_name: The Namespace name
    :param str resource_group_name: Name of the resource group within the azure subscription.
    """
    __args__ = dict()
    __args__['applicationGroupName'] = application_group_name
    __args__['namespaceName'] = namespace_name
    __args__['resourceGroupName'] = resource_group_name
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('azure-native:eventhub/v20220101preview:getApplicationGroup', __args__, opts=opts, typ=GetApplicationGroupResult).value

    return AwaitableGetApplicationGroupResult(
        client_app_group_identifier=__ret__.client_app_group_identifier,
        id=__ret__.id,
        is_enabled=__ret__.is_enabled,
        location=__ret__.location,
        name=__ret__.name,
        policies=__ret__.policies,
        system_data=__ret__.system_data,
        type=__ret__.type)


@_utilities.lift_output_func(get_application_group)
def get_application_group_output(application_group_name: Optional[pulumi.Input[str]] = None,
                                 namespace_name: Optional[pulumi.Input[str]] = None,
                                 resource_group_name: Optional[pulumi.Input[str]] = None,
                                 opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetApplicationGroupResult]:
    """
    The Application Group object


    :param str application_group_name: The Application Group name 
    :param str namespace_name: The Namespace name
    :param str resource_group_name: Name of the resource group within the azure subscription.
    """
    ...
