# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'AdditionalLocationResponse',
    'ApiManagementServiceIdentityResponse',
    'ApiManagementServiceSkuPropertiesResponse',
    'ApiVersionConstraintResponse',
    'ApiVersionSetContractDetailsResponse',
    'AuthenticationSettingsContractResponse',
    'BackendAuthorizationHeaderCredentialsResponse',
    'BackendCredentialsContractResponse',
    'BackendPropertiesResponse',
    'BackendProxyContractResponse',
    'BackendServiceFabricClusterPropertiesResponse',
    'BackendTlsPropertiesResponse',
    'BodyDiagnosticSettingsResponse',
    'CertificateConfigurationResponse',
    'CertificateInformationResponse',
    'DataMaskingEntityResponse',
    'DataMaskingResponse',
    'EmailTemplateParametersContractPropertiesResponse',
    'GroupContractPropertiesResponse',
    'HostnameConfigurationResponse',
    'HttpMessageDiagnosticResponse',
    'KeyVaultContractPropertiesResponse',
    'KeyVaultLastAccessStatusContractPropertiesResponse',
    'OAuth2AuthenticationSettingsContractResponse',
    'OpenIdAuthenticationSettingsContractResponse',
    'ParameterContractResponse',
    'PipelineDiagnosticSettingsResponse',
    'PrivateEndpointResponse',
    'PrivateLinkServiceConnectionStateResponse',
    'RepresentationContractResponse',
    'RequestContractResponse',
    'ResourceCollectionResponseValue',
    'ResourceLocationDataContractResponse',
    'ResponseContractResponse',
    'SamplingSettingsResponse',
    'SubscriptionKeyParameterNamesContractResponse',
    'TokenBodyParameterContractResponse',
    'UserIdentityContractResponse',
    'UserIdentityPropertiesResponse',
    'VirtualNetworkConfigurationResponse',
    'X509CertificateNameResponse',
]

@pulumi.output_type
class AdditionalLocationResponse(dict):
    """
    Description of an additional API Management resource location.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "gatewayRegionalUrl":
            suggest = "gateway_regional_url"
        elif key == "privateIPAddresses":
            suggest = "private_ip_addresses"
        elif key == "publicIPAddresses":
            suggest = "public_ip_addresses"
        elif key == "disableGateway":
            suggest = "disable_gateway"
        elif key == "virtualNetworkConfiguration":
            suggest = "virtual_network_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AdditionalLocationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AdditionalLocationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AdditionalLocationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 gateway_regional_url: str,
                 location: str,
                 private_ip_addresses: Sequence[str],
                 public_ip_addresses: Sequence[str],
                 sku: 'outputs.ApiManagementServiceSkuPropertiesResponse',
                 disable_gateway: Optional[bool] = None,
                 virtual_network_configuration: Optional['outputs.VirtualNetworkConfigurationResponse'] = None,
                 zones: Optional[Sequence[str]] = None):
        """
        Description of an additional API Management resource location.
        :param str gateway_regional_url: Gateway URL of the API Management service in the Region.
        :param str location: The location name of the additional region among Azure Data center regions.
        :param Sequence[str] private_ip_addresses: Private Static Load Balanced IP addresses of the API Management service which is deployed in an Internal Virtual Network in a particular additional location. Available only for Basic, Standard, Premium and Isolated SKU.
        :param Sequence[str] public_ip_addresses: Public Static Load Balanced IP addresses of the API Management service in the additional location. Available only for Basic, Standard, Premium and Isolated SKU.
        :param 'ApiManagementServiceSkuPropertiesResponse' sku: SKU properties of the API Management service.
        :param bool disable_gateway: Property only valid for an Api Management service deployed in multiple locations. This can be used to disable the gateway in this additional location.
        :param 'VirtualNetworkConfigurationResponse' virtual_network_configuration: Virtual network configuration for the location.
        :param Sequence[str] zones: A list of availability zones denoting where the resource needs to come from.
        """
        pulumi.set(__self__, "gateway_regional_url", gateway_regional_url)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "private_ip_addresses", private_ip_addresses)
        pulumi.set(__self__, "public_ip_addresses", public_ip_addresses)
        pulumi.set(__self__, "sku", sku)
        if disable_gateway is None:
            disable_gateway = False
        if disable_gateway is not None:
            pulumi.set(__self__, "disable_gateway", disable_gateway)
        if virtual_network_configuration is not None:
            pulumi.set(__self__, "virtual_network_configuration", virtual_network_configuration)
        if zones is not None:
            pulumi.set(__self__, "zones", zones)

    @property
    @pulumi.getter(name="gatewayRegionalUrl")
    def gateway_regional_url(self) -> str:
        """
        Gateway URL of the API Management service in the Region.
        """
        return pulumi.get(self, "gateway_regional_url")

    @property
    @pulumi.getter
    def location(self) -> str:
        """
        The location name of the additional region among Azure Data center regions.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="privateIPAddresses")
    def private_ip_addresses(self) -> Sequence[str]:
        """
        Private Static Load Balanced IP addresses of the API Management service which is deployed in an Internal Virtual Network in a particular additional location. Available only for Basic, Standard, Premium and Isolated SKU.
        """
        return pulumi.get(self, "private_ip_addresses")

    @property
    @pulumi.getter(name="publicIPAddresses")
    def public_ip_addresses(self) -> Sequence[str]:
        """
        Public Static Load Balanced IP addresses of the API Management service in the additional location. Available only for Basic, Standard, Premium and Isolated SKU.
        """
        return pulumi.get(self, "public_ip_addresses")

    @property
    @pulumi.getter
    def sku(self) -> 'outputs.ApiManagementServiceSkuPropertiesResponse':
        """
        SKU properties of the API Management service.
        """
        return pulumi.get(self, "sku")

    @property
    @pulumi.getter(name="disableGateway")
    def disable_gateway(self) -> Optional[bool]:
        """
        Property only valid for an Api Management service deployed in multiple locations. This can be used to disable the gateway in this additional location.
        """
        return pulumi.get(self, "disable_gateway")

    @property
    @pulumi.getter(name="virtualNetworkConfiguration")
    def virtual_network_configuration(self) -> Optional['outputs.VirtualNetworkConfigurationResponse']:
        """
        Virtual network configuration for the location.
        """
        return pulumi.get(self, "virtual_network_configuration")

    @property
    @pulumi.getter
    def zones(self) -> Optional[Sequence[str]]:
        """
        A list of availability zones denoting where the resource needs to come from.
        """
        return pulumi.get(self, "zones")


@pulumi.output_type
class ApiManagementServiceIdentityResponse(dict):
    """
    Identity properties of the Api Management service resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "principalId":
            suggest = "principal_id"
        elif key == "tenantId":
            suggest = "tenant_id"
        elif key == "userAssignedIdentities":
            suggest = "user_assigned_identities"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApiManagementServiceIdentityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApiManagementServiceIdentityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApiManagementServiceIdentityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 principal_id: str,
                 tenant_id: str,
                 type: str,
                 user_assigned_identities: Optional[Mapping[str, 'outputs.UserIdentityPropertiesResponse']] = None):
        """
        Identity properties of the Api Management service resource.
        :param str principal_id: The principal id of the identity.
        :param str tenant_id: The client tenant id of the identity.
        :param str type: The type of identity used for the resource. The type 'SystemAssigned, UserAssigned' includes both an implicitly created identity and a set of user assigned identities. The type 'None' will remove any identities from the service.
        :param Mapping[str, 'UserIdentityPropertiesResponse'] user_assigned_identities: The list of user identities associated with the resource. The user identity 
               dictionary key references will be ARM resource ids in the form: 
               '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/
                   providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
        """
        pulumi.set(__self__, "principal_id", principal_id)
        pulumi.set(__self__, "tenant_id", tenant_id)
        pulumi.set(__self__, "type", type)
        if user_assigned_identities is not None:
            pulumi.set(__self__, "user_assigned_identities", user_assigned_identities)

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> str:
        """
        The principal id of the identity.
        """
        return pulumi.get(self, "principal_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> str:
        """
        The client tenant id of the identity.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of identity used for the resource. The type 'SystemAssigned, UserAssigned' includes both an implicitly created identity and a set of user assigned identities. The type 'None' will remove any identities from the service.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="userAssignedIdentities")
    def user_assigned_identities(self) -> Optional[Mapping[str, 'outputs.UserIdentityPropertiesResponse']]:
        """
        The list of user identities associated with the resource. The user identity 
        dictionary key references will be ARM resource ids in the form: 
        '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/
            providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
        """
        return pulumi.get(self, "user_assigned_identities")


@pulumi.output_type
class ApiManagementServiceSkuPropertiesResponse(dict):
    """
    API Management service resource SKU properties.
    """
    def __init__(__self__, *,
                 capacity: int,
                 name: str):
        """
        API Management service resource SKU properties.
        :param int capacity: Capacity of the SKU (number of deployed units of the SKU). For Consumption SKU capacity must be specified as 0.
        :param str name: Name of the Sku.
        """
        pulumi.set(__self__, "capacity", capacity)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def capacity(self) -> int:
        """
        Capacity of the SKU (number of deployed units of the SKU). For Consumption SKU capacity must be specified as 0.
        """
        return pulumi.get(self, "capacity")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the Sku.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class ApiVersionConstraintResponse(dict):
    """
    Control Plane Apis version constraint for the API Management service.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "minApiVersion":
            suggest = "min_api_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApiVersionConstraintResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApiVersionConstraintResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApiVersionConstraintResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 min_api_version: Optional[str] = None):
        """
        Control Plane Apis version constraint for the API Management service.
        :param str min_api_version: Limit control plane API calls to API Management service with version equal to or newer than this value.
        """
        if min_api_version is not None:
            pulumi.set(__self__, "min_api_version", min_api_version)

    @property
    @pulumi.getter(name="minApiVersion")
    def min_api_version(self) -> Optional[str]:
        """
        Limit control plane API calls to API Management service with version equal to or newer than this value.
        """
        return pulumi.get(self, "min_api_version")


@pulumi.output_type
class ApiVersionSetContractDetailsResponse(dict):
    """
    An API Version Set contains the common configuration for a set of API Versions relating 
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "versionHeaderName":
            suggest = "version_header_name"
        elif key == "versionQueryName":
            suggest = "version_query_name"
        elif key == "versioningScheme":
            suggest = "versioning_scheme"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApiVersionSetContractDetailsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApiVersionSetContractDetailsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApiVersionSetContractDetailsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 description: Optional[str] = None,
                 id: Optional[str] = None,
                 name: Optional[str] = None,
                 version_header_name: Optional[str] = None,
                 version_query_name: Optional[str] = None,
                 versioning_scheme: Optional[str] = None):
        """
        An API Version Set contains the common configuration for a set of API Versions relating 
        :param str description: Description of API Version Set.
        :param str id: Identifier for existing API Version Set. Omit this value to create a new Version Set.
        :param str name: The display Name of the API Version Set.
        :param str version_header_name: Name of HTTP header parameter that indicates the API Version if versioningScheme is set to `header`.
        :param str version_query_name: Name of query parameter that indicates the API Version if versioningScheme is set to `query`.
        :param str versioning_scheme: An value that determines where the API Version identifier will be located in a HTTP request.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if version_header_name is not None:
            pulumi.set(__self__, "version_header_name", version_header_name)
        if version_query_name is not None:
            pulumi.set(__self__, "version_query_name", version_query_name)
        if versioning_scheme is not None:
            pulumi.set(__self__, "versioning_scheme", versioning_scheme)

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Description of API Version Set.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Identifier for existing API Version Set. Omit this value to create a new Version Set.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The display Name of the API Version Set.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="versionHeaderName")
    def version_header_name(self) -> Optional[str]:
        """
        Name of HTTP header parameter that indicates the API Version if versioningScheme is set to `header`.
        """
        return pulumi.get(self, "version_header_name")

    @property
    @pulumi.getter(name="versionQueryName")
    def version_query_name(self) -> Optional[str]:
        """
        Name of query parameter that indicates the API Version if versioningScheme is set to `query`.
        """
        return pulumi.get(self, "version_query_name")

    @property
    @pulumi.getter(name="versioningScheme")
    def versioning_scheme(self) -> Optional[str]:
        """
        An value that determines where the API Version identifier will be located in a HTTP request.
        """
        return pulumi.get(self, "versioning_scheme")


@pulumi.output_type
class AuthenticationSettingsContractResponse(dict):
    """
    API Authentication Settings.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "oAuth2":
            suggest = "o_auth2"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AuthenticationSettingsContractResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AuthenticationSettingsContractResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AuthenticationSettingsContractResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 o_auth2: Optional['outputs.OAuth2AuthenticationSettingsContractResponse'] = None,
                 openid: Optional['outputs.OpenIdAuthenticationSettingsContractResponse'] = None):
        """
        API Authentication Settings.
        :param 'OAuth2AuthenticationSettingsContractResponse' o_auth2: OAuth2 Authentication settings
        :param 'OpenIdAuthenticationSettingsContractResponse' openid: OpenID Connect Authentication Settings
        """
        if o_auth2 is not None:
            pulumi.set(__self__, "o_auth2", o_auth2)
        if openid is not None:
            pulumi.set(__self__, "openid", openid)

    @property
    @pulumi.getter(name="oAuth2")
    def o_auth2(self) -> Optional['outputs.OAuth2AuthenticationSettingsContractResponse']:
        """
        OAuth2 Authentication settings
        """
        return pulumi.get(self, "o_auth2")

    @property
    @pulumi.getter
    def openid(self) -> Optional['outputs.OpenIdAuthenticationSettingsContractResponse']:
        """
        OpenID Connect Authentication Settings
        """
        return pulumi.get(self, "openid")


@pulumi.output_type
class BackendAuthorizationHeaderCredentialsResponse(dict):
    """
    Authorization header information.
    """
    def __init__(__self__, *,
                 parameter: str,
                 scheme: str):
        """
        Authorization header information.
        :param str parameter: Authentication Parameter value.
        :param str scheme: Authentication Scheme name.
        """
        pulumi.set(__self__, "parameter", parameter)
        pulumi.set(__self__, "scheme", scheme)

    @property
    @pulumi.getter
    def parameter(self) -> str:
        """
        Authentication Parameter value.
        """
        return pulumi.get(self, "parameter")

    @property
    @pulumi.getter
    def scheme(self) -> str:
        """
        Authentication Scheme name.
        """
        return pulumi.get(self, "scheme")


@pulumi.output_type
class BackendCredentialsContractResponse(dict):
    """
    Details of the Credentials used to connect to Backend.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "certificateIds":
            suggest = "certificate_ids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BackendCredentialsContractResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BackendCredentialsContractResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BackendCredentialsContractResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 authorization: Optional['outputs.BackendAuthorizationHeaderCredentialsResponse'] = None,
                 certificate: Optional[Sequence[str]] = None,
                 certificate_ids: Optional[Sequence[str]] = None,
                 header: Optional[Mapping[str, Sequence[str]]] = None,
                 query: Optional[Mapping[str, Sequence[str]]] = None):
        """
        Details of the Credentials used to connect to Backend.
        :param 'BackendAuthorizationHeaderCredentialsResponse' authorization: Authorization header authentication
        :param Sequence[str] certificate: List of Client Certificate Thumbprints. Will be ignored if certificatesIds are provided.
        :param Sequence[str] certificate_ids: List of Client Certificate Ids.
        :param Mapping[str, Sequence[str]] header: Header Parameter description.
        :param Mapping[str, Sequence[str]] query: Query Parameter description.
        """
        if authorization is not None:
            pulumi.set(__self__, "authorization", authorization)
        if certificate is not None:
            pulumi.set(__self__, "certificate", certificate)
        if certificate_ids is not None:
            pulumi.set(__self__, "certificate_ids", certificate_ids)
        if header is not None:
            pulumi.set(__self__, "header", header)
        if query is not None:
            pulumi.set(__self__, "query", query)

    @property
    @pulumi.getter
    def authorization(self) -> Optional['outputs.BackendAuthorizationHeaderCredentialsResponse']:
        """
        Authorization header authentication
        """
        return pulumi.get(self, "authorization")

    @property
    @pulumi.getter
    def certificate(self) -> Optional[Sequence[str]]:
        """
        List of Client Certificate Thumbprints. Will be ignored if certificatesIds are provided.
        """
        return pulumi.get(self, "certificate")

    @property
    @pulumi.getter(name="certificateIds")
    def certificate_ids(self) -> Optional[Sequence[str]]:
        """
        List of Client Certificate Ids.
        """
        return pulumi.get(self, "certificate_ids")

    @property
    @pulumi.getter
    def header(self) -> Optional[Mapping[str, Sequence[str]]]:
        """
        Header Parameter description.
        """
        return pulumi.get(self, "header")

    @property
    @pulumi.getter
    def query(self) -> Optional[Mapping[str, Sequence[str]]]:
        """
        Query Parameter description.
        """
        return pulumi.get(self, "query")


@pulumi.output_type
class BackendPropertiesResponse(dict):
    """
    Properties specific to the Backend Type.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "serviceFabricCluster":
            suggest = "service_fabric_cluster"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BackendPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BackendPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BackendPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 service_fabric_cluster: Optional['outputs.BackendServiceFabricClusterPropertiesResponse'] = None):
        """
        Properties specific to the Backend Type.
        :param 'BackendServiceFabricClusterPropertiesResponse' service_fabric_cluster: Backend Service Fabric Cluster Properties
        """
        if service_fabric_cluster is not None:
            pulumi.set(__self__, "service_fabric_cluster", service_fabric_cluster)

    @property
    @pulumi.getter(name="serviceFabricCluster")
    def service_fabric_cluster(self) -> Optional['outputs.BackendServiceFabricClusterPropertiesResponse']:
        """
        Backend Service Fabric Cluster Properties
        """
        return pulumi.get(self, "service_fabric_cluster")


@pulumi.output_type
class BackendProxyContractResponse(dict):
    """
    Details of the Backend WebProxy Server to use in the Request to Backend.
    """
    def __init__(__self__, *,
                 url: str,
                 password: Optional[str] = None,
                 username: Optional[str] = None):
        """
        Details of the Backend WebProxy Server to use in the Request to Backend.
        :param str url: WebProxy Server AbsoluteUri property which includes the entire URI stored in the Uri instance, including all fragments and query strings.
        :param str password: Password to connect to the WebProxy Server
        :param str username: Username to connect to the WebProxy server
        """
        pulumi.set(__self__, "url", url)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def url(self) -> str:
        """
        WebProxy Server AbsoluteUri property which includes the entire URI stored in the Uri instance, including all fragments and query strings.
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter
    def password(self) -> Optional[str]:
        """
        Password to connect to the WebProxy Server
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def username(self) -> Optional[str]:
        """
        Username to connect to the WebProxy server
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class BackendServiceFabricClusterPropertiesResponse(dict):
    """
    Properties of the Service Fabric Type Backend.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "managementEndpoints":
            suggest = "management_endpoints"
        elif key == "clientCertificateId":
            suggest = "client_certificate_id"
        elif key == "clientCertificatethumbprint":
            suggest = "client_certificatethumbprint"
        elif key == "maxPartitionResolutionRetries":
            suggest = "max_partition_resolution_retries"
        elif key == "serverCertificateThumbprints":
            suggest = "server_certificate_thumbprints"
        elif key == "serverX509Names":
            suggest = "server_x509_names"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BackendServiceFabricClusterPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BackendServiceFabricClusterPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BackendServiceFabricClusterPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 management_endpoints: Sequence[str],
                 client_certificate_id: Optional[str] = None,
                 client_certificatethumbprint: Optional[str] = None,
                 max_partition_resolution_retries: Optional[int] = None,
                 server_certificate_thumbprints: Optional[Sequence[str]] = None,
                 server_x509_names: Optional[Sequence['outputs.X509CertificateNameResponse']] = None):
        """
        Properties of the Service Fabric Type Backend.
        :param Sequence[str] management_endpoints: The cluster management endpoint.
        :param str client_certificate_id: The client certificate id for the management endpoint.
        :param str client_certificatethumbprint: The client certificate thumbprint for the management endpoint. Will be ignored if certificatesIds are provided
        :param int max_partition_resolution_retries: Maximum number of retries while attempting resolve the partition.
        :param Sequence[str] server_certificate_thumbprints: Thumbprints of certificates cluster management service uses for tls communication
        :param Sequence['X509CertificateNameResponse'] server_x509_names: Server X509 Certificate Names Collection
        """
        pulumi.set(__self__, "management_endpoints", management_endpoints)
        if client_certificate_id is not None:
            pulumi.set(__self__, "client_certificate_id", client_certificate_id)
        if client_certificatethumbprint is not None:
            pulumi.set(__self__, "client_certificatethumbprint", client_certificatethumbprint)
        if max_partition_resolution_retries is not None:
            pulumi.set(__self__, "max_partition_resolution_retries", max_partition_resolution_retries)
        if server_certificate_thumbprints is not None:
            pulumi.set(__self__, "server_certificate_thumbprints", server_certificate_thumbprints)
        if server_x509_names is not None:
            pulumi.set(__self__, "server_x509_names", server_x509_names)

    @property
    @pulumi.getter(name="managementEndpoints")
    def management_endpoints(self) -> Sequence[str]:
        """
        The cluster management endpoint.
        """
        return pulumi.get(self, "management_endpoints")

    @property
    @pulumi.getter(name="clientCertificateId")
    def client_certificate_id(self) -> Optional[str]:
        """
        The client certificate id for the management endpoint.
        """
        return pulumi.get(self, "client_certificate_id")

    @property
    @pulumi.getter(name="clientCertificatethumbprint")
    def client_certificatethumbprint(self) -> Optional[str]:
        """
        The client certificate thumbprint for the management endpoint. Will be ignored if certificatesIds are provided
        """
        return pulumi.get(self, "client_certificatethumbprint")

    @property
    @pulumi.getter(name="maxPartitionResolutionRetries")
    def max_partition_resolution_retries(self) -> Optional[int]:
        """
        Maximum number of retries while attempting resolve the partition.
        """
        return pulumi.get(self, "max_partition_resolution_retries")

    @property
    @pulumi.getter(name="serverCertificateThumbprints")
    def server_certificate_thumbprints(self) -> Optional[Sequence[str]]:
        """
        Thumbprints of certificates cluster management service uses for tls communication
        """
        return pulumi.get(self, "server_certificate_thumbprints")

    @property
    @pulumi.getter(name="serverX509Names")
    def server_x509_names(self) -> Optional[Sequence['outputs.X509CertificateNameResponse']]:
        """
        Server X509 Certificate Names Collection
        """
        return pulumi.get(self, "server_x509_names")


@pulumi.output_type
class BackendTlsPropertiesResponse(dict):
    """
    Properties controlling TLS Certificate Validation.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "validateCertificateChain":
            suggest = "validate_certificate_chain"
        elif key == "validateCertificateName":
            suggest = "validate_certificate_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BackendTlsPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BackendTlsPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BackendTlsPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 validate_certificate_chain: Optional[bool] = None,
                 validate_certificate_name: Optional[bool] = None):
        """
        Properties controlling TLS Certificate Validation.
        :param bool validate_certificate_chain: Flag indicating whether SSL certificate chain validation should be done when using self-signed certificates for this backend host.
        :param bool validate_certificate_name: Flag indicating whether SSL certificate name validation should be done when using self-signed certificates for this backend host.
        """
        if validate_certificate_chain is None:
            validate_certificate_chain = True
        if validate_certificate_chain is not None:
            pulumi.set(__self__, "validate_certificate_chain", validate_certificate_chain)
        if validate_certificate_name is None:
            validate_certificate_name = True
        if validate_certificate_name is not None:
            pulumi.set(__self__, "validate_certificate_name", validate_certificate_name)

    @property
    @pulumi.getter(name="validateCertificateChain")
    def validate_certificate_chain(self) -> Optional[bool]:
        """
        Flag indicating whether SSL certificate chain validation should be done when using self-signed certificates for this backend host.
        """
        return pulumi.get(self, "validate_certificate_chain")

    @property
    @pulumi.getter(name="validateCertificateName")
    def validate_certificate_name(self) -> Optional[bool]:
        """
        Flag indicating whether SSL certificate name validation should be done when using self-signed certificates for this backend host.
        """
        return pulumi.get(self, "validate_certificate_name")


@pulumi.output_type
class BodyDiagnosticSettingsResponse(dict):
    """
    Body logging settings.
    """
    def __init__(__self__, *,
                 bytes: Optional[int] = None):
        """
        Body logging settings.
        :param int bytes: Number of request body bytes to log.
        """
        if bytes is not None:
            pulumi.set(__self__, "bytes", bytes)

    @property
    @pulumi.getter
    def bytes(self) -> Optional[int]:
        """
        Number of request body bytes to log.
        """
        return pulumi.get(self, "bytes")


@pulumi.output_type
class CertificateConfigurationResponse(dict):
    """
    Certificate configuration which consist of non-trusted intermediates and root certificates.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "storeName":
            suggest = "store_name"
        elif key == "certificatePassword":
            suggest = "certificate_password"
        elif key == "encodedCertificate":
            suggest = "encoded_certificate"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 store_name: str,
                 certificate: Optional['outputs.CertificateInformationResponse'] = None,
                 certificate_password: Optional[str] = None,
                 encoded_certificate: Optional[str] = None):
        """
        Certificate configuration which consist of non-trusted intermediates and root certificates.
        :param str store_name: The System.Security.Cryptography.x509certificates.StoreName certificate store location. Only Root and CertificateAuthority are valid locations.
        :param 'CertificateInformationResponse' certificate: Certificate information.
        :param str certificate_password: Certificate Password.
        :param str encoded_certificate: Base64 Encoded certificate.
        """
        pulumi.set(__self__, "store_name", store_name)
        if certificate is not None:
            pulumi.set(__self__, "certificate", certificate)
        if certificate_password is not None:
            pulumi.set(__self__, "certificate_password", certificate_password)
        if encoded_certificate is not None:
            pulumi.set(__self__, "encoded_certificate", encoded_certificate)

    @property
    @pulumi.getter(name="storeName")
    def store_name(self) -> str:
        """
        The System.Security.Cryptography.x509certificates.StoreName certificate store location. Only Root and CertificateAuthority are valid locations.
        """
        return pulumi.get(self, "store_name")

    @property
    @pulumi.getter
    def certificate(self) -> Optional['outputs.CertificateInformationResponse']:
        """
        Certificate information.
        """
        return pulumi.get(self, "certificate")

    @property
    @pulumi.getter(name="certificatePassword")
    def certificate_password(self) -> Optional[str]:
        """
        Certificate Password.
        """
        return pulumi.get(self, "certificate_password")

    @property
    @pulumi.getter(name="encodedCertificate")
    def encoded_certificate(self) -> Optional[str]:
        """
        Base64 Encoded certificate.
        """
        return pulumi.get(self, "encoded_certificate")


@pulumi.output_type
class CertificateInformationResponse(dict):
    """
    SSL certificate information.
    """
    def __init__(__self__, *,
                 expiry: str,
                 subject: str,
                 thumbprint: str):
        """
        SSL certificate information.
        :param str expiry: Expiration date of the certificate. The date conforms to the following format: `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
        :param str subject: Subject of the certificate.
        :param str thumbprint: Thumbprint of the certificate.
        """
        pulumi.set(__self__, "expiry", expiry)
        pulumi.set(__self__, "subject", subject)
        pulumi.set(__self__, "thumbprint", thumbprint)

    @property
    @pulumi.getter
    def expiry(self) -> str:
        """
        Expiration date of the certificate. The date conforms to the following format: `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
        """
        return pulumi.get(self, "expiry")

    @property
    @pulumi.getter
    def subject(self) -> str:
        """
        Subject of the certificate.
        """
        return pulumi.get(self, "subject")

    @property
    @pulumi.getter
    def thumbprint(self) -> str:
        """
        Thumbprint of the certificate.
        """
        return pulumi.get(self, "thumbprint")


@pulumi.output_type
class DataMaskingEntityResponse(dict):
    def __init__(__self__, *,
                 mode: Optional[str] = None,
                 value: Optional[str] = None):
        """
        :param str mode: Data masking mode.
        :param str value: The name of an entity to mask (e.g. a name of a header or a query parameter).
        """
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def mode(self) -> Optional[str]:
        """
        Data masking mode.
        """
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        The name of an entity to mask (e.g. a name of a header or a query parameter).
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class DataMaskingResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "queryParams":
            suggest = "query_params"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataMaskingResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataMaskingResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataMaskingResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 headers: Optional[Sequence['outputs.DataMaskingEntityResponse']] = None,
                 query_params: Optional[Sequence['outputs.DataMaskingEntityResponse']] = None):
        """
        :param Sequence['DataMaskingEntityResponse'] headers: Masking settings for headers
        :param Sequence['DataMaskingEntityResponse'] query_params: Masking settings for Url query parameters
        """
        if headers is not None:
            pulumi.set(__self__, "headers", headers)
        if query_params is not None:
            pulumi.set(__self__, "query_params", query_params)

    @property
    @pulumi.getter
    def headers(self) -> Optional[Sequence['outputs.DataMaskingEntityResponse']]:
        """
        Masking settings for headers
        """
        return pulumi.get(self, "headers")

    @property
    @pulumi.getter(name="queryParams")
    def query_params(self) -> Optional[Sequence['outputs.DataMaskingEntityResponse']]:
        """
        Masking settings for Url query parameters
        """
        return pulumi.get(self, "query_params")


@pulumi.output_type
class EmailTemplateParametersContractPropertiesResponse(dict):
    """
    Email Template Parameter contract.
    """
    def __init__(__self__, *,
                 description: Optional[str] = None,
                 name: Optional[str] = None,
                 title: Optional[str] = None):
        """
        Email Template Parameter contract.
        :param str description: Template parameter description.
        :param str name: Template parameter name.
        :param str title: Template parameter title.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if title is not None:
            pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Template parameter description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Template parameter name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def title(self) -> Optional[str]:
        """
        Template parameter title.
        """
        return pulumi.get(self, "title")


@pulumi.output_type
class GroupContractPropertiesResponse(dict):
    """
    Group contract Properties.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "builtIn":
            suggest = "built_in"
        elif key == "displayName":
            suggest = "display_name"
        elif key == "externalId":
            suggest = "external_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GroupContractPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GroupContractPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GroupContractPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 built_in: bool,
                 display_name: str,
                 description: Optional[str] = None,
                 external_id: Optional[str] = None,
                 type: Optional[str] = None):
        """
        Group contract Properties.
        :param bool built_in: true if the group is one of the three system groups (Administrators, Developers, or Guests); otherwise false.
        :param str display_name: Group name.
        :param str description: Group description. Can contain HTML formatting tags.
        :param str external_id: For external groups, this property contains the id of the group from the external identity provider, e.g. for Azure Active Directory `aad://<tenant>.onmicrosoft.com/groups/<group object id>`; otherwise the value is null.
        :param str type: Group type.
        """
        pulumi.set(__self__, "built_in", built_in)
        pulumi.set(__self__, "display_name", display_name)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if external_id is not None:
            pulumi.set(__self__, "external_id", external_id)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="builtIn")
    def built_in(self) -> bool:
        """
        true if the group is one of the three system groups (Administrators, Developers, or Guests); otherwise false.
        """
        return pulumi.get(self, "built_in")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        Group name.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Group description. Can contain HTML formatting tags.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="externalId")
    def external_id(self) -> Optional[str]:
        """
        For external groups, this property contains the id of the group from the external identity provider, e.g. for Azure Active Directory `aad://<tenant>.onmicrosoft.com/groups/<group object id>`; otherwise the value is null.
        """
        return pulumi.get(self, "external_id")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        Group type.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class HostnameConfigurationResponse(dict):
    """
    Custom hostname configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "hostName":
            suggest = "host_name"
        elif key == "certificatePassword":
            suggest = "certificate_password"
        elif key == "defaultSslBinding":
            suggest = "default_ssl_binding"
        elif key == "encodedCertificate":
            suggest = "encoded_certificate"
        elif key == "identityClientId":
            suggest = "identity_client_id"
        elif key == "keyVaultId":
            suggest = "key_vault_id"
        elif key == "negotiateClientCertificate":
            suggest = "negotiate_client_certificate"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HostnameConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HostnameConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HostnameConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 host_name: str,
                 type: str,
                 certificate: Optional['outputs.CertificateInformationResponse'] = None,
                 certificate_password: Optional[str] = None,
                 default_ssl_binding: Optional[bool] = None,
                 encoded_certificate: Optional[str] = None,
                 identity_client_id: Optional[str] = None,
                 key_vault_id: Optional[str] = None,
                 negotiate_client_certificate: Optional[bool] = None):
        """
        Custom hostname configuration.
        :param str host_name: Hostname to configure on the Api Management service.
        :param str type: Hostname type.
        :param 'CertificateInformationResponse' certificate: Certificate information.
        :param str certificate_password: Certificate Password.
        :param bool default_ssl_binding: Specify true to setup the certificate associated with this Hostname as the Default SSL Certificate. If a client does not send the SNI header, then this will be the certificate that will be challenged. The property is useful if a service has multiple custom hostname enabled and it needs to decide on the default ssl certificate. The setting only applied to Proxy Hostname Type.
        :param str encoded_certificate: Base64 Encoded certificate.
        :param str identity_client_id: System or User Assigned Managed identity clientId as generated by Azure AD, which has GET access to the keyVault containing the SSL certificate.
        :param str key_vault_id: Url to the KeyVault Secret containing the Ssl Certificate. If absolute Url containing version is provided, auto-update of ssl certificate will not work. This requires Api Management service to be configured with aka.ms/apimmsi. The secret should be of type *application/x-pkcs12*
        :param bool negotiate_client_certificate: Specify true to always negotiate client certificate on the hostname. Default Value is false.
        """
        pulumi.set(__self__, "host_name", host_name)
        pulumi.set(__self__, "type", type)
        if certificate is not None:
            pulumi.set(__self__, "certificate", certificate)
        if certificate_password is not None:
            pulumi.set(__self__, "certificate_password", certificate_password)
        if default_ssl_binding is None:
            default_ssl_binding = False
        if default_ssl_binding is not None:
            pulumi.set(__self__, "default_ssl_binding", default_ssl_binding)
        if encoded_certificate is not None:
            pulumi.set(__self__, "encoded_certificate", encoded_certificate)
        if identity_client_id is not None:
            pulumi.set(__self__, "identity_client_id", identity_client_id)
        if key_vault_id is not None:
            pulumi.set(__self__, "key_vault_id", key_vault_id)
        if negotiate_client_certificate is None:
            negotiate_client_certificate = False
        if negotiate_client_certificate is not None:
            pulumi.set(__self__, "negotiate_client_certificate", negotiate_client_certificate)

    @property
    @pulumi.getter(name="hostName")
    def host_name(self) -> str:
        """
        Hostname to configure on the Api Management service.
        """
        return pulumi.get(self, "host_name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Hostname type.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def certificate(self) -> Optional['outputs.CertificateInformationResponse']:
        """
        Certificate information.
        """
        return pulumi.get(self, "certificate")

    @property
    @pulumi.getter(name="certificatePassword")
    def certificate_password(self) -> Optional[str]:
        """
        Certificate Password.
        """
        return pulumi.get(self, "certificate_password")

    @property
    @pulumi.getter(name="defaultSslBinding")
    def default_ssl_binding(self) -> Optional[bool]:
        """
        Specify true to setup the certificate associated with this Hostname as the Default SSL Certificate. If a client does not send the SNI header, then this will be the certificate that will be challenged. The property is useful if a service has multiple custom hostname enabled and it needs to decide on the default ssl certificate. The setting only applied to Proxy Hostname Type.
        """
        return pulumi.get(self, "default_ssl_binding")

    @property
    @pulumi.getter(name="encodedCertificate")
    def encoded_certificate(self) -> Optional[str]:
        """
        Base64 Encoded certificate.
        """
        return pulumi.get(self, "encoded_certificate")

    @property
    @pulumi.getter(name="identityClientId")
    def identity_client_id(self) -> Optional[str]:
        """
        System or User Assigned Managed identity clientId as generated by Azure AD, which has GET access to the keyVault containing the SSL certificate.
        """
        return pulumi.get(self, "identity_client_id")

    @property
    @pulumi.getter(name="keyVaultId")
    def key_vault_id(self) -> Optional[str]:
        """
        Url to the KeyVault Secret containing the Ssl Certificate. If absolute Url containing version is provided, auto-update of ssl certificate will not work. This requires Api Management service to be configured with aka.ms/apimmsi. The secret should be of type *application/x-pkcs12*
        """
        return pulumi.get(self, "key_vault_id")

    @property
    @pulumi.getter(name="negotiateClientCertificate")
    def negotiate_client_certificate(self) -> Optional[bool]:
        """
        Specify true to always negotiate client certificate on the hostname. Default Value is false.
        """
        return pulumi.get(self, "negotiate_client_certificate")


@pulumi.output_type
class HttpMessageDiagnosticResponse(dict):
    """
    Http message diagnostic settings.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataMasking":
            suggest = "data_masking"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HttpMessageDiagnosticResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HttpMessageDiagnosticResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HttpMessageDiagnosticResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 body: Optional['outputs.BodyDiagnosticSettingsResponse'] = None,
                 data_masking: Optional['outputs.DataMaskingResponse'] = None,
                 headers: Optional[Sequence[str]] = None):
        """
        Http message diagnostic settings.
        :param 'BodyDiagnosticSettingsResponse' body: Body logging settings.
        :param 'DataMaskingResponse' data_masking: Data masking settings.
        :param Sequence[str] headers: Array of HTTP Headers to log.
        """
        if body is not None:
            pulumi.set(__self__, "body", body)
        if data_masking is not None:
            pulumi.set(__self__, "data_masking", data_masking)
        if headers is not None:
            pulumi.set(__self__, "headers", headers)

    @property
    @pulumi.getter
    def body(self) -> Optional['outputs.BodyDiagnosticSettingsResponse']:
        """
        Body logging settings.
        """
        return pulumi.get(self, "body")

    @property
    @pulumi.getter(name="dataMasking")
    def data_masking(self) -> Optional['outputs.DataMaskingResponse']:
        """
        Data masking settings.
        """
        return pulumi.get(self, "data_masking")

    @property
    @pulumi.getter
    def headers(self) -> Optional[Sequence[str]]:
        """
        Array of HTTP Headers to log.
        """
        return pulumi.get(self, "headers")


@pulumi.output_type
class KeyVaultContractPropertiesResponse(dict):
    """
    KeyVault contract details.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "identityClientId":
            suggest = "identity_client_id"
        elif key == "lastStatus":
            suggest = "last_status"
        elif key == "secretIdentifier":
            suggest = "secret_identifier"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KeyVaultContractPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KeyVaultContractPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KeyVaultContractPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 identity_client_id: Optional[str] = None,
                 last_status: Optional['outputs.KeyVaultLastAccessStatusContractPropertiesResponse'] = None,
                 secret_identifier: Optional[str] = None):
        """
        KeyVault contract details.
        :param str identity_client_id: Null for SystemAssignedIdentity or Client Id for UserAssignedIdentity , which will be used to access key vault secret.
        :param 'KeyVaultLastAccessStatusContractPropertiesResponse' last_status: Last time sync and refresh status of secret from key vault.
        :param str secret_identifier: Key vault secret identifier for fetching secret. Providing a versioned secret will prevent auto-refresh. This requires Api Management service to be configured with aka.ms/apimmsi
        """
        if identity_client_id is not None:
            pulumi.set(__self__, "identity_client_id", identity_client_id)
        if last_status is not None:
            pulumi.set(__self__, "last_status", last_status)
        if secret_identifier is not None:
            pulumi.set(__self__, "secret_identifier", secret_identifier)

    @property
    @pulumi.getter(name="identityClientId")
    def identity_client_id(self) -> Optional[str]:
        """
        Null for SystemAssignedIdentity or Client Id for UserAssignedIdentity , which will be used to access key vault secret.
        """
        return pulumi.get(self, "identity_client_id")

    @property
    @pulumi.getter(name="lastStatus")
    def last_status(self) -> Optional['outputs.KeyVaultLastAccessStatusContractPropertiesResponse']:
        """
        Last time sync and refresh status of secret from key vault.
        """
        return pulumi.get(self, "last_status")

    @property
    @pulumi.getter(name="secretIdentifier")
    def secret_identifier(self) -> Optional[str]:
        """
        Key vault secret identifier for fetching secret. Providing a versioned secret will prevent auto-refresh. This requires Api Management service to be configured with aka.ms/apimmsi
        """
        return pulumi.get(self, "secret_identifier")


@pulumi.output_type
class KeyVaultLastAccessStatusContractPropertiesResponse(dict):
    """
    Issue contract Update Properties.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "timeStampUtc":
            suggest = "time_stamp_utc"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KeyVaultLastAccessStatusContractPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KeyVaultLastAccessStatusContractPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KeyVaultLastAccessStatusContractPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 code: Optional[str] = None,
                 message: Optional[str] = None,
                 time_stamp_utc: Optional[str] = None):
        """
        Issue contract Update Properties.
        :param str code: Last status code for sync and refresh of secret from key vault.
        :param str message: Details of the error else empty.
        :param str time_stamp_utc: Last time secret was accessed. The date conforms to the following format: `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
        """
        if code is not None:
            pulumi.set(__self__, "code", code)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if time_stamp_utc is not None:
            pulumi.set(__self__, "time_stamp_utc", time_stamp_utc)

    @property
    @pulumi.getter
    def code(self) -> Optional[str]:
        """
        Last status code for sync and refresh of secret from key vault.
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter
    def message(self) -> Optional[str]:
        """
        Details of the error else empty.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter(name="timeStampUtc")
    def time_stamp_utc(self) -> Optional[str]:
        """
        Last time secret was accessed. The date conforms to the following format: `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
        """
        return pulumi.get(self, "time_stamp_utc")


@pulumi.output_type
class OAuth2AuthenticationSettingsContractResponse(dict):
    """
    API OAuth2 Authentication settings details.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authorizationServerId":
            suggest = "authorization_server_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OAuth2AuthenticationSettingsContractResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OAuth2AuthenticationSettingsContractResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OAuth2AuthenticationSettingsContractResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 authorization_server_id: Optional[str] = None,
                 scope: Optional[str] = None):
        """
        API OAuth2 Authentication settings details.
        :param str authorization_server_id: OAuth authorization server identifier.
        :param str scope: operations scope.
        """
        if authorization_server_id is not None:
            pulumi.set(__self__, "authorization_server_id", authorization_server_id)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)

    @property
    @pulumi.getter(name="authorizationServerId")
    def authorization_server_id(self) -> Optional[str]:
        """
        OAuth authorization server identifier.
        """
        return pulumi.get(self, "authorization_server_id")

    @property
    @pulumi.getter
    def scope(self) -> Optional[str]:
        """
        operations scope.
        """
        return pulumi.get(self, "scope")


@pulumi.output_type
class OpenIdAuthenticationSettingsContractResponse(dict):
    """
    API OAuth2 Authentication settings details.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bearerTokenSendingMethods":
            suggest = "bearer_token_sending_methods"
        elif key == "openidProviderId":
            suggest = "openid_provider_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OpenIdAuthenticationSettingsContractResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OpenIdAuthenticationSettingsContractResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OpenIdAuthenticationSettingsContractResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bearer_token_sending_methods: Optional[Sequence[str]] = None,
                 openid_provider_id: Optional[str] = None):
        """
        API OAuth2 Authentication settings details.
        :param Sequence[str] bearer_token_sending_methods: How to send token to the server.
        :param str openid_provider_id: OAuth authorization server identifier.
        """
        if bearer_token_sending_methods is not None:
            pulumi.set(__self__, "bearer_token_sending_methods", bearer_token_sending_methods)
        if openid_provider_id is not None:
            pulumi.set(__self__, "openid_provider_id", openid_provider_id)

    @property
    @pulumi.getter(name="bearerTokenSendingMethods")
    def bearer_token_sending_methods(self) -> Optional[Sequence[str]]:
        """
        How to send token to the server.
        """
        return pulumi.get(self, "bearer_token_sending_methods")

    @property
    @pulumi.getter(name="openidProviderId")
    def openid_provider_id(self) -> Optional[str]:
        """
        OAuth authorization server identifier.
        """
        return pulumi.get(self, "openid_provider_id")


@pulumi.output_type
class ParameterContractResponse(dict):
    """
    Operation parameters details.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultValue":
            suggest = "default_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ParameterContractResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ParameterContractResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ParameterContractResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 type: str,
                 default_value: Optional[str] = None,
                 description: Optional[str] = None,
                 required: Optional[bool] = None,
                 values: Optional[Sequence[str]] = None):
        """
        Operation parameters details.
        :param str name: Parameter name.
        :param str type: Parameter type.
        :param str default_value: Default parameter value.
        :param str description: Parameter description.
        :param bool required: Specifies whether parameter is required or not.
        :param Sequence[str] values: Parameter values.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)
        if default_value is not None:
            pulumi.set(__self__, "default_value", default_value)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if required is not None:
            pulumi.set(__self__, "required", required)
        if values is not None:
            pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Parameter name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Parameter type.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="defaultValue")
    def default_value(self) -> Optional[str]:
        """
        Default parameter value.
        """
        return pulumi.get(self, "default_value")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Parameter description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def required(self) -> Optional[bool]:
        """
        Specifies whether parameter is required or not.
        """
        return pulumi.get(self, "required")

    @property
    @pulumi.getter
    def values(self) -> Optional[Sequence[str]]:
        """
        Parameter values.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class PipelineDiagnosticSettingsResponse(dict):
    """
    Diagnostic settings for incoming/outgoing HTTP messages to the Gateway.
    """
    def __init__(__self__, *,
                 request: Optional['outputs.HttpMessageDiagnosticResponse'] = None,
                 response: Optional['outputs.HttpMessageDiagnosticResponse'] = None):
        """
        Diagnostic settings for incoming/outgoing HTTP messages to the Gateway.
        :param 'HttpMessageDiagnosticResponse' request: Diagnostic settings for request.
        :param 'HttpMessageDiagnosticResponse' response: Diagnostic settings for response.
        """
        if request is not None:
            pulumi.set(__self__, "request", request)
        if response is not None:
            pulumi.set(__self__, "response", response)

    @property
    @pulumi.getter
    def request(self) -> Optional['outputs.HttpMessageDiagnosticResponse']:
        """
        Diagnostic settings for request.
        """
        return pulumi.get(self, "request")

    @property
    @pulumi.getter
    def response(self) -> Optional['outputs.HttpMessageDiagnosticResponse']:
        """
        Diagnostic settings for response.
        """
        return pulumi.get(self, "response")


@pulumi.output_type
class PrivateEndpointResponse(dict):
    """
    The Private Endpoint resource.
    """
    def __init__(__self__, *,
                 id: str):
        """
        The Private Endpoint resource.
        :param str id: The ARM identifier for Private Endpoint
        """
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ARM identifier for Private Endpoint
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class PrivateLinkServiceConnectionStateResponse(dict):
    """
    A collection of information about the state of the connection between service consumer and provider.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "actionsRequired":
            suggest = "actions_required"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PrivateLinkServiceConnectionStateResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PrivateLinkServiceConnectionStateResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PrivateLinkServiceConnectionStateResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 actions_required: Optional[str] = None,
                 description: Optional[str] = None,
                 status: Optional[str] = None):
        """
        A collection of information about the state of the connection between service consumer and provider.
        :param str actions_required: A message indicating if changes on the service provider require any updates on the consumer.
        :param str description: The reason for approval/rejection of the connection.
        :param str status: Indicates whether the connection has been Approved/Rejected/Removed by the owner of the service.
        """
        if actions_required is not None:
            pulumi.set(__self__, "actions_required", actions_required)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="actionsRequired")
    def actions_required(self) -> Optional[str]:
        """
        A message indicating if changes on the service provider require any updates on the consumer.
        """
        return pulumi.get(self, "actions_required")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The reason for approval/rejection of the connection.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        Indicates whether the connection has been Approved/Rejected/Removed by the owner of the service.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class RepresentationContractResponse(dict):
    """
    Operation request/response representation details.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "contentType":
            suggest = "content_type"
        elif key == "formParameters":
            suggest = "form_parameters"
        elif key == "schemaId":
            suggest = "schema_id"
        elif key == "typeName":
            suggest = "type_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RepresentationContractResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RepresentationContractResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RepresentationContractResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 content_type: str,
                 form_parameters: Optional[Sequence['outputs.ParameterContractResponse']] = None,
                 sample: Optional[str] = None,
                 schema_id: Optional[str] = None,
                 type_name: Optional[str] = None):
        """
        Operation request/response representation details.
        :param str content_type: Specifies a registered or custom content type for this representation, e.g. application/xml.
        :param Sequence['ParameterContractResponse'] form_parameters: Collection of form parameters. Required if 'contentType' value is either 'application/x-www-form-urlencoded' or 'multipart/form-data'..
        :param str sample: An example of the representation.
        :param str schema_id: Schema identifier. Applicable only if 'contentType' value is neither 'application/x-www-form-urlencoded' nor 'multipart/form-data'.
        :param str type_name: Type name defined by the schema. Applicable only if 'contentType' value is neither 'application/x-www-form-urlencoded' nor 'multipart/form-data'.
        """
        pulumi.set(__self__, "content_type", content_type)
        if form_parameters is not None:
            pulumi.set(__self__, "form_parameters", form_parameters)
        if sample is not None:
            pulumi.set(__self__, "sample", sample)
        if schema_id is not None:
            pulumi.set(__self__, "schema_id", schema_id)
        if type_name is not None:
            pulumi.set(__self__, "type_name", type_name)

    @property
    @pulumi.getter(name="contentType")
    def content_type(self) -> str:
        """
        Specifies a registered or custom content type for this representation, e.g. application/xml.
        """
        return pulumi.get(self, "content_type")

    @property
    @pulumi.getter(name="formParameters")
    def form_parameters(self) -> Optional[Sequence['outputs.ParameterContractResponse']]:
        """
        Collection of form parameters. Required if 'contentType' value is either 'application/x-www-form-urlencoded' or 'multipart/form-data'..
        """
        return pulumi.get(self, "form_parameters")

    @property
    @pulumi.getter
    def sample(self) -> Optional[str]:
        """
        An example of the representation.
        """
        return pulumi.get(self, "sample")

    @property
    @pulumi.getter(name="schemaId")
    def schema_id(self) -> Optional[str]:
        """
        Schema identifier. Applicable only if 'contentType' value is neither 'application/x-www-form-urlencoded' nor 'multipart/form-data'.
        """
        return pulumi.get(self, "schema_id")

    @property
    @pulumi.getter(name="typeName")
    def type_name(self) -> Optional[str]:
        """
        Type name defined by the schema. Applicable only if 'contentType' value is neither 'application/x-www-form-urlencoded' nor 'multipart/form-data'.
        """
        return pulumi.get(self, "type_name")


@pulumi.output_type
class RequestContractResponse(dict):
    """
    Operation request details.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "queryParameters":
            suggest = "query_parameters"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RequestContractResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RequestContractResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RequestContractResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 description: Optional[str] = None,
                 headers: Optional[Sequence['outputs.ParameterContractResponse']] = None,
                 query_parameters: Optional[Sequence['outputs.ParameterContractResponse']] = None,
                 representations: Optional[Sequence['outputs.RepresentationContractResponse']] = None):
        """
        Operation request details.
        :param str description: Operation request description.
        :param Sequence['ParameterContractResponse'] headers: Collection of operation request headers.
        :param Sequence['ParameterContractResponse'] query_parameters: Collection of operation request query parameters.
        :param Sequence['RepresentationContractResponse'] representations: Collection of operation request representations.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if headers is not None:
            pulumi.set(__self__, "headers", headers)
        if query_parameters is not None:
            pulumi.set(__self__, "query_parameters", query_parameters)
        if representations is not None:
            pulumi.set(__self__, "representations", representations)

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Operation request description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def headers(self) -> Optional[Sequence['outputs.ParameterContractResponse']]:
        """
        Collection of operation request headers.
        """
        return pulumi.get(self, "headers")

    @property
    @pulumi.getter(name="queryParameters")
    def query_parameters(self) -> Optional[Sequence['outputs.ParameterContractResponse']]:
        """
        Collection of operation request query parameters.
        """
        return pulumi.get(self, "query_parameters")

    @property
    @pulumi.getter
    def representations(self) -> Optional[Sequence['outputs.RepresentationContractResponse']]:
        """
        Collection of operation request representations.
        """
        return pulumi.get(self, "representations")


@pulumi.output_type
class ResourceCollectionResponseValue(dict):
    def __init__(__self__, *,
                 id: str,
                 name: str,
                 type: str):
        """
        :param str id: Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
        :param str name: The name of the resource
        :param str type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ResourceLocationDataContractResponse(dict):
    """
    Resource location data properties.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "countryOrRegion":
            suggest = "country_or_region"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourceLocationDataContractResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourceLocationDataContractResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourceLocationDataContractResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 city: Optional[str] = None,
                 country_or_region: Optional[str] = None,
                 district: Optional[str] = None):
        """
        Resource location data properties.
        :param str name: A canonical name for the geographic or physical location.
        :param str city: The city or locality where the resource is located.
        :param str country_or_region: The country or region where the resource is located.
        :param str district: The district, state, or province where the resource is located.
        """
        pulumi.set(__self__, "name", name)
        if city is not None:
            pulumi.set(__self__, "city", city)
        if country_or_region is not None:
            pulumi.set(__self__, "country_or_region", country_or_region)
        if district is not None:
            pulumi.set(__self__, "district", district)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A canonical name for the geographic or physical location.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def city(self) -> Optional[str]:
        """
        The city or locality where the resource is located.
        """
        return pulumi.get(self, "city")

    @property
    @pulumi.getter(name="countryOrRegion")
    def country_or_region(self) -> Optional[str]:
        """
        The country or region where the resource is located.
        """
        return pulumi.get(self, "country_or_region")

    @property
    @pulumi.getter
    def district(self) -> Optional[str]:
        """
        The district, state, or province where the resource is located.
        """
        return pulumi.get(self, "district")


@pulumi.output_type
class ResponseContractResponse(dict):
    """
    Operation response details.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "statusCode":
            suggest = "status_code"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResponseContractResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResponseContractResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResponseContractResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 status_code: int,
                 description: Optional[str] = None,
                 headers: Optional[Sequence['outputs.ParameterContractResponse']] = None,
                 representations: Optional[Sequence['outputs.RepresentationContractResponse']] = None):
        """
        Operation response details.
        :param int status_code: Operation response HTTP status code.
        :param str description: Operation response description.
        :param Sequence['ParameterContractResponse'] headers: Collection of operation response headers.
        :param Sequence['RepresentationContractResponse'] representations: Collection of operation response representations.
        """
        pulumi.set(__self__, "status_code", status_code)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if headers is not None:
            pulumi.set(__self__, "headers", headers)
        if representations is not None:
            pulumi.set(__self__, "representations", representations)

    @property
    @pulumi.getter(name="statusCode")
    def status_code(self) -> int:
        """
        Operation response HTTP status code.
        """
        return pulumi.get(self, "status_code")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Operation response description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def headers(self) -> Optional[Sequence['outputs.ParameterContractResponse']]:
        """
        Collection of operation response headers.
        """
        return pulumi.get(self, "headers")

    @property
    @pulumi.getter
    def representations(self) -> Optional[Sequence['outputs.RepresentationContractResponse']]:
        """
        Collection of operation response representations.
        """
        return pulumi.get(self, "representations")


@pulumi.output_type
class SamplingSettingsResponse(dict):
    """
    Sampling settings for Diagnostic.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "samplingType":
            suggest = "sampling_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SamplingSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SamplingSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SamplingSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 percentage: Optional[float] = None,
                 sampling_type: Optional[str] = None):
        """
        Sampling settings for Diagnostic.
        :param float percentage: Rate of sampling for fixed-rate sampling.
        :param str sampling_type: Sampling type.
        """
        if percentage is not None:
            pulumi.set(__self__, "percentage", percentage)
        if sampling_type is not None:
            pulumi.set(__self__, "sampling_type", sampling_type)

    @property
    @pulumi.getter
    def percentage(self) -> Optional[float]:
        """
        Rate of sampling for fixed-rate sampling.
        """
        return pulumi.get(self, "percentage")

    @property
    @pulumi.getter(name="samplingType")
    def sampling_type(self) -> Optional[str]:
        """
        Sampling type.
        """
        return pulumi.get(self, "sampling_type")


@pulumi.output_type
class SubscriptionKeyParameterNamesContractResponse(dict):
    """
    Subscription key parameter names details.
    """
    def __init__(__self__, *,
                 header: Optional[str] = None,
                 query: Optional[str] = None):
        """
        Subscription key parameter names details.
        :param str header: Subscription key header name.
        :param str query: Subscription key query string parameter name.
        """
        if header is not None:
            pulumi.set(__self__, "header", header)
        if query is not None:
            pulumi.set(__self__, "query", query)

    @property
    @pulumi.getter
    def header(self) -> Optional[str]:
        """
        Subscription key header name.
        """
        return pulumi.get(self, "header")

    @property
    @pulumi.getter
    def query(self) -> Optional[str]:
        """
        Subscription key query string parameter name.
        """
        return pulumi.get(self, "query")


@pulumi.output_type
class TokenBodyParameterContractResponse(dict):
    """
    OAuth acquire token request body parameter (www-url-form-encoded).
    """
    def __init__(__self__, *,
                 name: str,
                 value: str):
        """
        OAuth acquire token request body parameter (www-url-form-encoded).
        :param str name: body parameter name.
        :param str value: body parameter value.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        body parameter name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        body parameter value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class UserIdentityContractResponse(dict):
    """
    User identity details.
    """
    def __init__(__self__, *,
                 id: Optional[str] = None,
                 provider: Optional[str] = None):
        """
        User identity details.
        :param str id: Identifier value within provider.
        :param str provider: Identity provider name.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if provider is not None:
            pulumi.set(__self__, "provider", provider)

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Identifier value within provider.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def provider(self) -> Optional[str]:
        """
        Identity provider name.
        """
        return pulumi.get(self, "provider")


@pulumi.output_type
class UserIdentityPropertiesResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientId":
            suggest = "client_id"
        elif key == "principalId":
            suggest = "principal_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserIdentityPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserIdentityPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserIdentityPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_id: Optional[str] = None,
                 principal_id: Optional[str] = None):
        """
        :param str client_id: The client id of user assigned identity.
        :param str principal_id: The principal id of user assigned identity.
        """
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[str]:
        """
        The client id of user assigned identity.
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[str]:
        """
        The principal id of user assigned identity.
        """
        return pulumi.get(self, "principal_id")


@pulumi.output_type
class VirtualNetworkConfigurationResponse(dict):
    """
    Configuration of a virtual network to which API Management service is deployed.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "subnetResourceId":
            suggest = "subnet_resource_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualNetworkConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualNetworkConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualNetworkConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 subnetname: str,
                 vnetid: str,
                 subnet_resource_id: Optional[str] = None):
        """
        Configuration of a virtual network to which API Management service is deployed.
        :param str subnetname: The name of the subnet.
        :param str vnetid: The virtual network ID. This is typically a GUID. Expect a null GUID by default.
        :param str subnet_resource_id: The full resource ID of a subnet in a virtual network to deploy the API Management service in.
        """
        pulumi.set(__self__, "subnetname", subnetname)
        pulumi.set(__self__, "vnetid", vnetid)
        if subnet_resource_id is not None:
            pulumi.set(__self__, "subnet_resource_id", subnet_resource_id)

    @property
    @pulumi.getter
    def subnetname(self) -> str:
        """
        The name of the subnet.
        """
        return pulumi.get(self, "subnetname")

    @property
    @pulumi.getter
    def vnetid(self) -> str:
        """
        The virtual network ID. This is typically a GUID. Expect a null GUID by default.
        """
        return pulumi.get(self, "vnetid")

    @property
    @pulumi.getter(name="subnetResourceId")
    def subnet_resource_id(self) -> Optional[str]:
        """
        The full resource ID of a subnet in a virtual network to deploy the API Management service in.
        """
        return pulumi.get(self, "subnet_resource_id")


@pulumi.output_type
class X509CertificateNameResponse(dict):
    """
    Properties of server X509Names.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "issuerCertificateThumbprint":
            suggest = "issuer_certificate_thumbprint"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in X509CertificateNameResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        X509CertificateNameResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        X509CertificateNameResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 issuer_certificate_thumbprint: Optional[str] = None,
                 name: Optional[str] = None):
        """
        Properties of server X509Names.
        :param str issuer_certificate_thumbprint: Thumbprint for the Issuer of the Certificate.
        :param str name: Common Name of the Certificate.
        """
        if issuer_certificate_thumbprint is not None:
            pulumi.set(__self__, "issuer_certificate_thumbprint", issuer_certificate_thumbprint)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="issuerCertificateThumbprint")
    def issuer_certificate_thumbprint(self) -> Optional[str]:
        """
        Thumbprint for the Issuer of the Certificate.
        """
        return pulumi.get(self, "issuer_certificate_thumbprint")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Common Name of the Certificate.
        """
        return pulumi.get(self, "name")


