# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'ServerEndpointCloudTieringStatusResponse',
    'ServerEndpointFilesNotSyncingErrorResponse',
    'ServerEndpointRecallErrorResponse',
    'ServerEndpointRecallStatusResponse',
    'ServerEndpointSyncActivityStatusResponse',
    'ServerEndpointSyncSessionStatusResponse',
    'ServerEndpointSyncStatusResponse',
]

@pulumi.output_type
class ServerEndpointCloudTieringStatusResponse(dict):
    """
    Server endpoint cloud tiering status object.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lastCloudTieringResult":
            suggest = "last_cloud_tiering_result"
        elif key == "lastSuccessTimestamp":
            suggest = "last_success_timestamp"
        elif key == "lastUpdatedTimestamp":
            suggest = "last_updated_timestamp"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServerEndpointCloudTieringStatusResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServerEndpointCloudTieringStatusResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServerEndpointCloudTieringStatusResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 health: str,
                 last_cloud_tiering_result: int,
                 last_success_timestamp: str,
                 last_updated_timestamp: str):
        """
        Server endpoint cloud tiering status object.
        :param str health: Cloud tiering health state.
        :param int last_cloud_tiering_result: Last cloud tiering result (HResult)
        :param str last_success_timestamp: Last cloud tiering success timestamp
        :param str last_updated_timestamp: Last updated timestamp
        """
        pulumi.set(__self__, "health", health)
        pulumi.set(__self__, "last_cloud_tiering_result", last_cloud_tiering_result)
        pulumi.set(__self__, "last_success_timestamp", last_success_timestamp)
        pulumi.set(__self__, "last_updated_timestamp", last_updated_timestamp)

    @property
    @pulumi.getter
    def health(self) -> str:
        """
        Cloud tiering health state.
        """
        return pulumi.get(self, "health")

    @property
    @pulumi.getter(name="lastCloudTieringResult")
    def last_cloud_tiering_result(self) -> int:
        """
        Last cloud tiering result (HResult)
        """
        return pulumi.get(self, "last_cloud_tiering_result")

    @property
    @pulumi.getter(name="lastSuccessTimestamp")
    def last_success_timestamp(self) -> str:
        """
        Last cloud tiering success timestamp
        """
        return pulumi.get(self, "last_success_timestamp")

    @property
    @pulumi.getter(name="lastUpdatedTimestamp")
    def last_updated_timestamp(self) -> str:
        """
        Last updated timestamp
        """
        return pulumi.get(self, "last_updated_timestamp")


@pulumi.output_type
class ServerEndpointFilesNotSyncingErrorResponse(dict):
    """
    Files not syncing error object
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "errorCode":
            suggest = "error_code"
        elif key == "persistentCount":
            suggest = "persistent_count"
        elif key == "transientCount":
            suggest = "transient_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServerEndpointFilesNotSyncingErrorResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServerEndpointFilesNotSyncingErrorResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServerEndpointFilesNotSyncingErrorResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 error_code: int,
                 persistent_count: float,
                 transient_count: float):
        """
        Files not syncing error object
        :param int error_code: Error code (HResult)
        :param float persistent_count: Count of persistent files not syncing with the specified error code
        :param float transient_count: Count of transient files not syncing with the specified error code
        """
        pulumi.set(__self__, "error_code", error_code)
        pulumi.set(__self__, "persistent_count", persistent_count)
        pulumi.set(__self__, "transient_count", transient_count)

    @property
    @pulumi.getter(name="errorCode")
    def error_code(self) -> int:
        """
        Error code (HResult)
        """
        return pulumi.get(self, "error_code")

    @property
    @pulumi.getter(name="persistentCount")
    def persistent_count(self) -> float:
        """
        Count of persistent files not syncing with the specified error code
        """
        return pulumi.get(self, "persistent_count")

    @property
    @pulumi.getter(name="transientCount")
    def transient_count(self) -> float:
        """
        Count of transient files not syncing with the specified error code
        """
        return pulumi.get(self, "transient_count")


@pulumi.output_type
class ServerEndpointRecallErrorResponse(dict):
    """
    Server endpoint recall error object
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "errorCode":
            suggest = "error_code"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServerEndpointRecallErrorResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServerEndpointRecallErrorResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServerEndpointRecallErrorResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 count: float,
                 error_code: int):
        """
        Server endpoint recall error object
        :param float count: Count of occurences of the error
        :param int error_code: Error code (HResult)
        """
        pulumi.set(__self__, "count", count)
        pulumi.set(__self__, "error_code", error_code)

    @property
    @pulumi.getter
    def count(self) -> float:
        """
        Count of occurences of the error
        """
        return pulumi.get(self, "count")

    @property
    @pulumi.getter(name="errorCode")
    def error_code(self) -> int:
        """
        Error code (HResult)
        """
        return pulumi.get(self, "error_code")


@pulumi.output_type
class ServerEndpointRecallStatusResponse(dict):
    """
    Server endpoint recall status object.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lastUpdatedTimestamp":
            suggest = "last_updated_timestamp"
        elif key == "recallErrors":
            suggest = "recall_errors"
        elif key == "totalRecallErrorsCount":
            suggest = "total_recall_errors_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServerEndpointRecallStatusResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServerEndpointRecallStatusResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServerEndpointRecallStatusResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 last_updated_timestamp: str,
                 recall_errors: Sequence['outputs.ServerEndpointRecallErrorResponse'],
                 total_recall_errors_count: float):
        """
        Server endpoint recall status object.
        :param str last_updated_timestamp: Last updated timestamp
        :param Sequence['ServerEndpointRecallErrorResponse'] recall_errors: Array of recall errors
        :param float total_recall_errors_count: Total count of recall errors.
        """
        pulumi.set(__self__, "last_updated_timestamp", last_updated_timestamp)
        pulumi.set(__self__, "recall_errors", recall_errors)
        pulumi.set(__self__, "total_recall_errors_count", total_recall_errors_count)

    @property
    @pulumi.getter(name="lastUpdatedTimestamp")
    def last_updated_timestamp(self) -> str:
        """
        Last updated timestamp
        """
        return pulumi.get(self, "last_updated_timestamp")

    @property
    @pulumi.getter(name="recallErrors")
    def recall_errors(self) -> Sequence['outputs.ServerEndpointRecallErrorResponse']:
        """
        Array of recall errors
        """
        return pulumi.get(self, "recall_errors")

    @property
    @pulumi.getter(name="totalRecallErrorsCount")
    def total_recall_errors_count(self) -> float:
        """
        Total count of recall errors.
        """
        return pulumi.get(self, "total_recall_errors_count")


@pulumi.output_type
class ServerEndpointSyncActivityStatusResponse(dict):
    """
    Sync Session status object.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "appliedBytes":
            suggest = "applied_bytes"
        elif key == "appliedItemCount":
            suggest = "applied_item_count"
        elif key == "perItemErrorCount":
            suggest = "per_item_error_count"
        elif key == "totalBytes":
            suggest = "total_bytes"
        elif key == "totalItemCount":
            suggest = "total_item_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServerEndpointSyncActivityStatusResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServerEndpointSyncActivityStatusResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServerEndpointSyncActivityStatusResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 applied_bytes: float,
                 applied_item_count: float,
                 per_item_error_count: float,
                 timestamp: str,
                 total_bytes: float,
                 total_item_count: float):
        """
        Sync Session status object.
        :param float applied_bytes: Applied bytes
        :param float applied_item_count: Applied item count.
        :param float per_item_error_count: Per item error count
        :param str timestamp: Timestamp when properties were updated
        :param float total_bytes: Total bytes (if available)
        :param float total_item_count: Total item count (if available)
        """
        pulumi.set(__self__, "applied_bytes", applied_bytes)
        pulumi.set(__self__, "applied_item_count", applied_item_count)
        pulumi.set(__self__, "per_item_error_count", per_item_error_count)
        pulumi.set(__self__, "timestamp", timestamp)
        pulumi.set(__self__, "total_bytes", total_bytes)
        pulumi.set(__self__, "total_item_count", total_item_count)

    @property
    @pulumi.getter(name="appliedBytes")
    def applied_bytes(self) -> float:
        """
        Applied bytes
        """
        return pulumi.get(self, "applied_bytes")

    @property
    @pulumi.getter(name="appliedItemCount")
    def applied_item_count(self) -> float:
        """
        Applied item count.
        """
        return pulumi.get(self, "applied_item_count")

    @property
    @pulumi.getter(name="perItemErrorCount")
    def per_item_error_count(self) -> float:
        """
        Per item error count
        """
        return pulumi.get(self, "per_item_error_count")

    @property
    @pulumi.getter
    def timestamp(self) -> str:
        """
        Timestamp when properties were updated
        """
        return pulumi.get(self, "timestamp")

    @property
    @pulumi.getter(name="totalBytes")
    def total_bytes(self) -> float:
        """
        Total bytes (if available)
        """
        return pulumi.get(self, "total_bytes")

    @property
    @pulumi.getter(name="totalItemCount")
    def total_item_count(self) -> float:
        """
        Total item count (if available)
        """
        return pulumi.get(self, "total_item_count")


@pulumi.output_type
class ServerEndpointSyncSessionStatusResponse(dict):
    """
    Sync Session status object.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "filesNotSyncingErrors":
            suggest = "files_not_syncing_errors"
        elif key == "lastSyncPerItemErrorCount":
            suggest = "last_sync_per_item_error_count"
        elif key == "lastSyncResult":
            suggest = "last_sync_result"
        elif key == "lastSyncSuccessTimestamp":
            suggest = "last_sync_success_timestamp"
        elif key == "lastSyncTimestamp":
            suggest = "last_sync_timestamp"
        elif key == "persistentFilesNotSyncingCount":
            suggest = "persistent_files_not_syncing_count"
        elif key == "transientFilesNotSyncingCount":
            suggest = "transient_files_not_syncing_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServerEndpointSyncSessionStatusResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServerEndpointSyncSessionStatusResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServerEndpointSyncSessionStatusResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 files_not_syncing_errors: Sequence['outputs.ServerEndpointFilesNotSyncingErrorResponse'],
                 last_sync_per_item_error_count: float,
                 last_sync_result: int,
                 last_sync_success_timestamp: str,
                 last_sync_timestamp: str,
                 persistent_files_not_syncing_count: float,
                 transient_files_not_syncing_count: float):
        """
        Sync Session status object.
        :param Sequence['ServerEndpointFilesNotSyncingErrorResponse'] files_not_syncing_errors: Array of per-item errors coming from the last sync session.
        :param float last_sync_per_item_error_count: Last sync per item error count.
        :param int last_sync_result: Last sync result (HResult)
        :param str last_sync_success_timestamp: Last sync success timestamp
        :param str last_sync_timestamp: Last sync timestamp
        :param float persistent_files_not_syncing_count: Count of persistent files not syncing.
        :param float transient_files_not_syncing_count: Count of transient files not syncing.
        """
        pulumi.set(__self__, "files_not_syncing_errors", files_not_syncing_errors)
        pulumi.set(__self__, "last_sync_per_item_error_count", last_sync_per_item_error_count)
        pulumi.set(__self__, "last_sync_result", last_sync_result)
        pulumi.set(__self__, "last_sync_success_timestamp", last_sync_success_timestamp)
        pulumi.set(__self__, "last_sync_timestamp", last_sync_timestamp)
        pulumi.set(__self__, "persistent_files_not_syncing_count", persistent_files_not_syncing_count)
        pulumi.set(__self__, "transient_files_not_syncing_count", transient_files_not_syncing_count)

    @property
    @pulumi.getter(name="filesNotSyncingErrors")
    def files_not_syncing_errors(self) -> Sequence['outputs.ServerEndpointFilesNotSyncingErrorResponse']:
        """
        Array of per-item errors coming from the last sync session.
        """
        return pulumi.get(self, "files_not_syncing_errors")

    @property
    @pulumi.getter(name="lastSyncPerItemErrorCount")
    def last_sync_per_item_error_count(self) -> float:
        """
        Last sync per item error count.
        """
        return pulumi.get(self, "last_sync_per_item_error_count")

    @property
    @pulumi.getter(name="lastSyncResult")
    def last_sync_result(self) -> int:
        """
        Last sync result (HResult)
        """
        return pulumi.get(self, "last_sync_result")

    @property
    @pulumi.getter(name="lastSyncSuccessTimestamp")
    def last_sync_success_timestamp(self) -> str:
        """
        Last sync success timestamp
        """
        return pulumi.get(self, "last_sync_success_timestamp")

    @property
    @pulumi.getter(name="lastSyncTimestamp")
    def last_sync_timestamp(self) -> str:
        """
        Last sync timestamp
        """
        return pulumi.get(self, "last_sync_timestamp")

    @property
    @pulumi.getter(name="persistentFilesNotSyncingCount")
    def persistent_files_not_syncing_count(self) -> float:
        """
        Count of persistent files not syncing.
        """
        return pulumi.get(self, "persistent_files_not_syncing_count")

    @property
    @pulumi.getter(name="transientFilesNotSyncingCount")
    def transient_files_not_syncing_count(self) -> float:
        """
        Count of transient files not syncing.
        """
        return pulumi.get(self, "transient_files_not_syncing_count")


@pulumi.output_type
class ServerEndpointSyncStatusResponse(dict):
    """
    Server Endpoint sync status
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "combinedHealth":
            suggest = "combined_health"
        elif key == "downloadActivity":
            suggest = "download_activity"
        elif key == "downloadHealth":
            suggest = "download_health"
        elif key == "downloadStatus":
            suggest = "download_status"
        elif key == "lastUpdatedTimestamp":
            suggest = "last_updated_timestamp"
        elif key == "offlineDataTransferStatus":
            suggest = "offline_data_transfer_status"
        elif key == "syncActivity":
            suggest = "sync_activity"
        elif key == "totalPersistentFilesNotSyncingCount":
            suggest = "total_persistent_files_not_syncing_count"
        elif key == "uploadActivity":
            suggest = "upload_activity"
        elif key == "uploadHealth":
            suggest = "upload_health"
        elif key == "uploadStatus":
            suggest = "upload_status"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServerEndpointSyncStatusResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServerEndpointSyncStatusResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServerEndpointSyncStatusResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 combined_health: str,
                 download_activity: 'outputs.ServerEndpointSyncActivityStatusResponse',
                 download_health: str,
                 download_status: 'outputs.ServerEndpointSyncSessionStatusResponse',
                 last_updated_timestamp: str,
                 offline_data_transfer_status: str,
                 sync_activity: str,
                 total_persistent_files_not_syncing_count: float,
                 upload_activity: 'outputs.ServerEndpointSyncActivityStatusResponse',
                 upload_health: str,
                 upload_status: 'outputs.ServerEndpointSyncSessionStatusResponse'):
        """
        Server Endpoint sync status
        :param str combined_health: Combined Health Status.
        :param 'ServerEndpointSyncActivityStatusResponse' download_activity: Download sync activity
        :param str download_health: Download Health Status.
        :param 'ServerEndpointSyncSessionStatusResponse' download_status: Download Status
        :param str last_updated_timestamp: Last Updated Timestamp
        :param str offline_data_transfer_status: Offline Data Transfer State
        :param str sync_activity: Sync activity
        :param float total_persistent_files_not_syncing_count: Total count of persistent files not syncing (combined upload + download).
        :param 'ServerEndpointSyncActivityStatusResponse' upload_activity: Upload sync activity
        :param str upload_health: Upload Health Status.
        :param 'ServerEndpointSyncSessionStatusResponse' upload_status: Upload Status
        """
        pulumi.set(__self__, "combined_health", combined_health)
        pulumi.set(__self__, "download_activity", download_activity)
        pulumi.set(__self__, "download_health", download_health)
        pulumi.set(__self__, "download_status", download_status)
        pulumi.set(__self__, "last_updated_timestamp", last_updated_timestamp)
        pulumi.set(__self__, "offline_data_transfer_status", offline_data_transfer_status)
        pulumi.set(__self__, "sync_activity", sync_activity)
        pulumi.set(__self__, "total_persistent_files_not_syncing_count", total_persistent_files_not_syncing_count)
        pulumi.set(__self__, "upload_activity", upload_activity)
        pulumi.set(__self__, "upload_health", upload_health)
        pulumi.set(__self__, "upload_status", upload_status)

    @property
    @pulumi.getter(name="combinedHealth")
    def combined_health(self) -> str:
        """
        Combined Health Status.
        """
        return pulumi.get(self, "combined_health")

    @property
    @pulumi.getter(name="downloadActivity")
    def download_activity(self) -> 'outputs.ServerEndpointSyncActivityStatusResponse':
        """
        Download sync activity
        """
        return pulumi.get(self, "download_activity")

    @property
    @pulumi.getter(name="downloadHealth")
    def download_health(self) -> str:
        """
        Download Health Status.
        """
        return pulumi.get(self, "download_health")

    @property
    @pulumi.getter(name="downloadStatus")
    def download_status(self) -> 'outputs.ServerEndpointSyncSessionStatusResponse':
        """
        Download Status
        """
        return pulumi.get(self, "download_status")

    @property
    @pulumi.getter(name="lastUpdatedTimestamp")
    def last_updated_timestamp(self) -> str:
        """
        Last Updated Timestamp
        """
        return pulumi.get(self, "last_updated_timestamp")

    @property
    @pulumi.getter(name="offlineDataTransferStatus")
    def offline_data_transfer_status(self) -> str:
        """
        Offline Data Transfer State
        """
        return pulumi.get(self, "offline_data_transfer_status")

    @property
    @pulumi.getter(name="syncActivity")
    def sync_activity(self) -> str:
        """
        Sync activity
        """
        return pulumi.get(self, "sync_activity")

    @property
    @pulumi.getter(name="totalPersistentFilesNotSyncingCount")
    def total_persistent_files_not_syncing_count(self) -> float:
        """
        Total count of persistent files not syncing (combined upload + download).
        """
        return pulumi.get(self, "total_persistent_files_not_syncing_count")

    @property
    @pulumi.getter(name="uploadActivity")
    def upload_activity(self) -> 'outputs.ServerEndpointSyncActivityStatusResponse':
        """
        Upload sync activity
        """
        return pulumi.get(self, "upload_activity")

    @property
    @pulumi.getter(name="uploadHealth")
    def upload_health(self) -> str:
        """
        Upload Health Status.
        """
        return pulumi.get(self, "upload_health")

    @property
    @pulumi.getter(name="uploadStatus")
    def upload_status(self) -> 'outputs.ServerEndpointSyncSessionStatusResponse':
        """
        Upload Status
        """
        return pulumi.get(self, "upload_status")


