# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'ActiveDirectoryConnectorDNSDetailsResponse',
    'ActiveDirectoryConnectorDomainDetailsResponse',
    'ActiveDirectoryConnectorPropertiesResponse',
    'ActiveDirectoryConnectorSpecResponse',
    'ActiveDirectoryConnectorStatusResponse',
    'ActiveDirectoryDomainControllerResponse',
    'ActiveDirectoryDomainControllersResponse',
    'BasicLoginInformationResponse',
    'DataControllerPropertiesResponse',
    'ExtendedLocationResponse',
    'LogAnalyticsWorkspaceConfigResponse',
    'OnPremisePropertyResponse',
    'PostgresInstancePropertiesResponse',
    'PostgresInstanceSkuResponse',
    'SqlManagedInstancePropertiesResponse',
    'SqlManagedInstanceSkuResponse',
    'SqlServerInstancePropertiesResponse',
    'SystemDataResponse',
    'UploadServicePrincipalResponse',
    'UploadWatermarkResponse',
]

@pulumi.output_type
class ActiveDirectoryConnectorDNSDetailsResponse(dict):
    """
    DNS server details
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "nameserverIPAddresses":
            suggest = "nameserver_ip_addresses"
        elif key == "domainName":
            suggest = "domain_name"
        elif key == "preferK8sDnsForPtrLookups":
            suggest = "prefer_k8s_dns_for_ptr_lookups"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ActiveDirectoryConnectorDNSDetailsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ActiveDirectoryConnectorDNSDetailsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ActiveDirectoryConnectorDNSDetailsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 nameserver_ip_addresses: Sequence[str],
                 domain_name: Optional[str] = None,
                 prefer_k8s_dns_for_ptr_lookups: Optional[bool] = None,
                 replicas: Optional[float] = None):
        """
        DNS server details
        :param Sequence[str] nameserver_ip_addresses: List of Active Directory DNS server IP addresses.
        :param str domain_name: DNS domain name for which DNS lookups should be forwarded to the Active Directory DNS servers.
        :param bool prefer_k8s_dns_for_ptr_lookups: Flag indicating whether to prefer Kubernetes DNS server response over AD DNS server response for IP address lookups.
        :param float replicas: Replica count for DNS proxy service. Default value is 1.
        """
        pulumi.set(__self__, "nameserver_ip_addresses", nameserver_ip_addresses)
        if domain_name is not None:
            pulumi.set(__self__, "domain_name", domain_name)
        if prefer_k8s_dns_for_ptr_lookups is None:
            prefer_k8s_dns_for_ptr_lookups = True
        if prefer_k8s_dns_for_ptr_lookups is not None:
            pulumi.set(__self__, "prefer_k8s_dns_for_ptr_lookups", prefer_k8s_dns_for_ptr_lookups)
        if replicas is None:
            replicas = 1
        if replicas is not None:
            pulumi.set(__self__, "replicas", replicas)

    @property
    @pulumi.getter(name="nameserverIPAddresses")
    def nameserver_ip_addresses(self) -> Sequence[str]:
        """
        List of Active Directory DNS server IP addresses.
        """
        return pulumi.get(self, "nameserver_ip_addresses")

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> Optional[str]:
        """
        DNS domain name for which DNS lookups should be forwarded to the Active Directory DNS servers.
        """
        return pulumi.get(self, "domain_name")

    @property
    @pulumi.getter(name="preferK8sDnsForPtrLookups")
    def prefer_k8s_dns_for_ptr_lookups(self) -> Optional[bool]:
        """
        Flag indicating whether to prefer Kubernetes DNS server response over AD DNS server response for IP address lookups.
        """
        return pulumi.get(self, "prefer_k8s_dns_for_ptr_lookups")

    @property
    @pulumi.getter
    def replicas(self) -> Optional[float]:
        """
        Replica count for DNS proxy service. Default value is 1.
        """
        return pulumi.get(self, "replicas")


@pulumi.output_type
class ActiveDirectoryConnectorDomainDetailsResponse(dict):
    """
    Active Directory domain details
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "domainControllers":
            suggest = "domain_controllers"
        elif key == "netbiosDomainName":
            suggest = "netbios_domain_name"
        elif key == "ouDistinguishedName":
            suggest = "ou_distinguished_name"
        elif key == "serviceAccountProvisioning":
            suggest = "service_account_provisioning"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ActiveDirectoryConnectorDomainDetailsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ActiveDirectoryConnectorDomainDetailsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ActiveDirectoryConnectorDomainDetailsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 domain_controllers: 'outputs.ActiveDirectoryDomainControllersResponse',
                 realm: str,
                 netbios_domain_name: Optional[str] = None,
                 ou_distinguished_name: Optional[str] = None,
                 service_account_provisioning: Optional[str] = None):
        """
        Active Directory domain details
        :param 'ActiveDirectoryDomainControllersResponse' domain_controllers: null
        :param str realm: Name (uppercase) of the Active Directory domain that this AD connector will be associated with.
        :param str netbios_domain_name: NETBIOS name of the Active Directory domain.
        :param str ou_distinguished_name: The distinguished name of the Active Directory Organizational Unit.
        :param str service_account_provisioning: The service account provisioning mode for this Active Directory connector.
        """
        pulumi.set(__self__, "domain_controllers", domain_controllers)
        pulumi.set(__self__, "realm", realm)
        if netbios_domain_name is not None:
            pulumi.set(__self__, "netbios_domain_name", netbios_domain_name)
        if ou_distinguished_name is not None:
            pulumi.set(__self__, "ou_distinguished_name", ou_distinguished_name)
        if service_account_provisioning is None:
            service_account_provisioning = 'manual'
        if service_account_provisioning is not None:
            pulumi.set(__self__, "service_account_provisioning", service_account_provisioning)

    @property
    @pulumi.getter(name="domainControllers")
    def domain_controllers(self) -> 'outputs.ActiveDirectoryDomainControllersResponse':
        """
        null
        """
        return pulumi.get(self, "domain_controllers")

    @property
    @pulumi.getter
    def realm(self) -> str:
        """
        Name (uppercase) of the Active Directory domain that this AD connector will be associated with.
        """
        return pulumi.get(self, "realm")

    @property
    @pulumi.getter(name="netbiosDomainName")
    def netbios_domain_name(self) -> Optional[str]:
        """
        NETBIOS name of the Active Directory domain.
        """
        return pulumi.get(self, "netbios_domain_name")

    @property
    @pulumi.getter(name="ouDistinguishedName")
    def ou_distinguished_name(self) -> Optional[str]:
        """
        The distinguished name of the Active Directory Organizational Unit.
        """
        return pulumi.get(self, "ou_distinguished_name")

    @property
    @pulumi.getter(name="serviceAccountProvisioning")
    def service_account_provisioning(self) -> Optional[str]:
        """
        The service account provisioning mode for this Active Directory connector.
        """
        return pulumi.get(self, "service_account_provisioning")


@pulumi.output_type
class ActiveDirectoryConnectorPropertiesResponse(dict):
    """
    The properties of an Active Directory connector resource
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "domainServiceAccountLoginInformation":
            suggest = "domain_service_account_login_information"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ActiveDirectoryConnectorPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ActiveDirectoryConnectorPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ActiveDirectoryConnectorPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 provisioning_state: str,
                 spec: 'outputs.ActiveDirectoryConnectorSpecResponse',
                 domain_service_account_login_information: Optional['outputs.BasicLoginInformationResponse'] = None,
                 status: Optional['outputs.ActiveDirectoryConnectorStatusResponse'] = None):
        """
        The properties of an Active Directory connector resource
        :param str provisioning_state: The provisioning state of the Active Directory connector resource.
        :param 'ActiveDirectoryConnectorSpecResponse' spec: null
        :param 'BasicLoginInformationResponse' domain_service_account_login_information: Username and password for domain service account authentication.
        :param 'ActiveDirectoryConnectorStatusResponse' status: null
        """
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        pulumi.set(__self__, "spec", spec)
        if domain_service_account_login_information is not None:
            pulumi.set(__self__, "domain_service_account_login_information", domain_service_account_login_information)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state of the Active Directory connector resource.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def spec(self) -> 'outputs.ActiveDirectoryConnectorSpecResponse':
        """
        null
        """
        return pulumi.get(self, "spec")

    @property
    @pulumi.getter(name="domainServiceAccountLoginInformation")
    def domain_service_account_login_information(self) -> Optional['outputs.BasicLoginInformationResponse']:
        """
        Username and password for domain service account authentication.
        """
        return pulumi.get(self, "domain_service_account_login_information")

    @property
    @pulumi.getter
    def status(self) -> Optional['outputs.ActiveDirectoryConnectorStatusResponse']:
        """
        null
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class ActiveDirectoryConnectorSpecResponse(dict):
    """
    The specifications of the AD Kubernetes resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "activeDirectory":
            suggest = "active_directory"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ActiveDirectoryConnectorSpecResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ActiveDirectoryConnectorSpecResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ActiveDirectoryConnectorSpecResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 active_directory: 'outputs.ActiveDirectoryConnectorDomainDetailsResponse',
                 dns: 'outputs.ActiveDirectoryConnectorDNSDetailsResponse'):
        """
        The specifications of the AD Kubernetes resource.
        :param 'ActiveDirectoryConnectorDomainDetailsResponse' active_directory: null
        :param 'ActiveDirectoryConnectorDNSDetailsResponse' dns: null
        """
        pulumi.set(__self__, "active_directory", active_directory)
        pulumi.set(__self__, "dns", dns)

    @property
    @pulumi.getter(name="activeDirectory")
    def active_directory(self) -> 'outputs.ActiveDirectoryConnectorDomainDetailsResponse':
        """
        null
        """
        return pulumi.get(self, "active_directory")

    @property
    @pulumi.getter
    def dns(self) -> 'outputs.ActiveDirectoryConnectorDNSDetailsResponse':
        """
        null
        """
        return pulumi.get(self, "dns")


@pulumi.output_type
class ActiveDirectoryConnectorStatusResponse(dict):
    """
    The status of the Kubernetes custom resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lastUpdateTime":
            suggest = "last_update_time"
        elif key == "observedGeneration":
            suggest = "observed_generation"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ActiveDirectoryConnectorStatusResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ActiveDirectoryConnectorStatusResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ActiveDirectoryConnectorStatusResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 last_update_time: Optional[str] = None,
                 observed_generation: Optional[float] = None,
                 state: Optional[str] = None):
        """
        The status of the Kubernetes custom resource.
        :param str last_update_time: The time that the custom resource was last updated.
        :param float observed_generation: The version of the replicaSet associated with the AD connector custom resource.
        :param str state: The state of the AD connector custom resource.
        """
        if last_update_time is not None:
            pulumi.set(__self__, "last_update_time", last_update_time)
        if observed_generation is not None:
            pulumi.set(__self__, "observed_generation", observed_generation)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="lastUpdateTime")
    def last_update_time(self) -> Optional[str]:
        """
        The time that the custom resource was last updated.
        """
        return pulumi.get(self, "last_update_time")

    @property
    @pulumi.getter(name="observedGeneration")
    def observed_generation(self) -> Optional[float]:
        """
        The version of the replicaSet associated with the AD connector custom resource.
        """
        return pulumi.get(self, "observed_generation")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The state of the AD connector custom resource.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class ActiveDirectoryDomainControllerResponse(dict):
    """
    Information about a domain controller in the AD domain.
    """
    def __init__(__self__, *,
                 hostname: str):
        """
        Information about a domain controller in the AD domain.
        :param str hostname: Fully-qualified domain name of a domain controller in the AD domain.
        """
        pulumi.set(__self__, "hostname", hostname)

    @property
    @pulumi.getter
    def hostname(self) -> str:
        """
        Fully-qualified domain name of a domain controller in the AD domain.
        """
        return pulumi.get(self, "hostname")


@pulumi.output_type
class ActiveDirectoryDomainControllersResponse(dict):
    """
    Details about the Active Directory domain controllers associated with this AD connector instance
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "primaryDomainController":
            suggest = "primary_domain_controller"
        elif key == "secondaryDomainControllers":
            suggest = "secondary_domain_controllers"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ActiveDirectoryDomainControllersResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ActiveDirectoryDomainControllersResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ActiveDirectoryDomainControllersResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 primary_domain_controller: Optional['outputs.ActiveDirectoryDomainControllerResponse'] = None,
                 secondary_domain_controllers: Optional[Sequence['outputs.ActiveDirectoryDomainControllerResponse']] = None):
        """
        Details about the Active Directory domain controllers associated with this AD connector instance
        :param 'ActiveDirectoryDomainControllerResponse' primary_domain_controller: Information about the Primary Domain Controller (PDC) in the AD domain.
        :param Sequence['ActiveDirectoryDomainControllerResponse'] secondary_domain_controllers: null
        """
        if primary_domain_controller is not None:
            pulumi.set(__self__, "primary_domain_controller", primary_domain_controller)
        if secondary_domain_controllers is not None:
            pulumi.set(__self__, "secondary_domain_controllers", secondary_domain_controllers)

    @property
    @pulumi.getter(name="primaryDomainController")
    def primary_domain_controller(self) -> Optional['outputs.ActiveDirectoryDomainControllerResponse']:
        """
        Information about the Primary Domain Controller (PDC) in the AD domain.
        """
        return pulumi.get(self, "primary_domain_controller")

    @property
    @pulumi.getter(name="secondaryDomainControllers")
    def secondary_domain_controllers(self) -> Optional[Sequence['outputs.ActiveDirectoryDomainControllerResponse']]:
        """
        null
        """
        return pulumi.get(self, "secondary_domain_controllers")


@pulumi.output_type
class BasicLoginInformationResponse(dict):
    """
    Username and password for basic login authentication.
    """
    def __init__(__self__, *,
                 username: Optional[str] = None):
        """
        Username and password for basic login authentication.
        :param str username: Login username.
        """
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def username(self) -> Optional[str]:
        """
        Login username.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class DataControllerPropertiesResponse(dict):
    """
    The data controller properties.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "basicLoginInformation":
            suggest = "basic_login_information"
        elif key == "k8sRaw":
            suggest = "k8s_raw"
        elif key == "lastUploadedDate":
            suggest = "last_uploaded_date"
        elif key == "logAnalyticsWorkspaceConfig":
            suggest = "log_analytics_workspace_config"
        elif key == "onPremiseProperty":
            suggest = "on_premise_property"
        elif key == "uploadServicePrincipal":
            suggest = "upload_service_principal"
        elif key == "uploadWatermark":
            suggest = "upload_watermark"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataControllerPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataControllerPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataControllerPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 provisioning_state: str,
                 basic_login_information: Optional['outputs.BasicLoginInformationResponse'] = None,
                 k8s_raw: Optional[Any] = None,
                 last_uploaded_date: Optional[str] = None,
                 log_analytics_workspace_config: Optional['outputs.LogAnalyticsWorkspaceConfigResponse'] = None,
                 on_premise_property: Optional['outputs.OnPremisePropertyResponse'] = None,
                 upload_service_principal: Optional['outputs.UploadServicePrincipalResponse'] = None,
                 upload_watermark: Optional['outputs.UploadWatermarkResponse'] = None):
        """
        The data controller properties.
        :param 'BasicLoginInformationResponse' basic_login_information: Username and password for basic login authentication.
        :param Any k8s_raw: The raw kubernetes information
        :param str last_uploaded_date: Last uploaded date from Kubernetes cluster. Defaults to current date time
        :param 'LogAnalyticsWorkspaceConfigResponse' log_analytics_workspace_config: Log analytics workspace id and primary key
        :param 'OnPremisePropertyResponse' on_premise_property: Properties from the Kubernetes data controller
        :param 'UploadServicePrincipalResponse' upload_service_principal: Service principal for uploading billing, metrics and logs.
        :param 'UploadWatermarkResponse' upload_watermark: Properties on upload watermark.  Mostly timestamp for each upload data type
        """
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if basic_login_information is not None:
            pulumi.set(__self__, "basic_login_information", basic_login_information)
        if k8s_raw is not None:
            pulumi.set(__self__, "k8s_raw", k8s_raw)
        if last_uploaded_date is not None:
            pulumi.set(__self__, "last_uploaded_date", last_uploaded_date)
        if log_analytics_workspace_config is not None:
            pulumi.set(__self__, "log_analytics_workspace_config", log_analytics_workspace_config)
        if on_premise_property is not None:
            pulumi.set(__self__, "on_premise_property", on_premise_property)
        if upload_service_principal is not None:
            pulumi.set(__self__, "upload_service_principal", upload_service_principal)
        if upload_watermark is not None:
            pulumi.set(__self__, "upload_watermark", upload_watermark)

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="basicLoginInformation")
    def basic_login_information(self) -> Optional['outputs.BasicLoginInformationResponse']:
        """
        Username and password for basic login authentication.
        """
        return pulumi.get(self, "basic_login_information")

    @property
    @pulumi.getter(name="k8sRaw")
    def k8s_raw(self) -> Optional[Any]:
        """
        The raw kubernetes information
        """
        return pulumi.get(self, "k8s_raw")

    @property
    @pulumi.getter(name="lastUploadedDate")
    def last_uploaded_date(self) -> Optional[str]:
        """
        Last uploaded date from Kubernetes cluster. Defaults to current date time
        """
        return pulumi.get(self, "last_uploaded_date")

    @property
    @pulumi.getter(name="logAnalyticsWorkspaceConfig")
    def log_analytics_workspace_config(self) -> Optional['outputs.LogAnalyticsWorkspaceConfigResponse']:
        """
        Log analytics workspace id and primary key
        """
        return pulumi.get(self, "log_analytics_workspace_config")

    @property
    @pulumi.getter(name="onPremiseProperty")
    def on_premise_property(self) -> Optional['outputs.OnPremisePropertyResponse']:
        """
        Properties from the Kubernetes data controller
        """
        return pulumi.get(self, "on_premise_property")

    @property
    @pulumi.getter(name="uploadServicePrincipal")
    def upload_service_principal(self) -> Optional['outputs.UploadServicePrincipalResponse']:
        """
        Service principal for uploading billing, metrics and logs.
        """
        return pulumi.get(self, "upload_service_principal")

    @property
    @pulumi.getter(name="uploadWatermark")
    def upload_watermark(self) -> Optional['outputs.UploadWatermarkResponse']:
        """
        Properties on upload watermark.  Mostly timestamp for each upload data type
        """
        return pulumi.get(self, "upload_watermark")


@pulumi.output_type
class ExtendedLocationResponse(dict):
    """
    The complex type of the extended location.
    """
    def __init__(__self__, *,
                 name: Optional[str] = None,
                 type: Optional[str] = None):
        """
        The complex type of the extended location.
        :param str name: The name of the extended location.
        :param str type: The type of the extended location.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the extended location.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The type of the extended location.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class LogAnalyticsWorkspaceConfigResponse(dict):
    """
    Log analytics workspace id and primary key
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "workspaceId":
            suggest = "workspace_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LogAnalyticsWorkspaceConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LogAnalyticsWorkspaceConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LogAnalyticsWorkspaceConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 workspace_id: Optional[str] = None):
        """
        Log analytics workspace id and primary key
        :param str workspace_id: Azure Log Analytics workspace ID
        """
        if workspace_id is not None:
            pulumi.set(__self__, "workspace_id", workspace_id)

    @property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> Optional[str]:
        """
        Azure Log Analytics workspace ID
        """
        return pulumi.get(self, "workspace_id")


@pulumi.output_type
class OnPremisePropertyResponse(dict):
    """
    Properties from the Kubernetes data controller
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "publicSigningKey":
            suggest = "public_signing_key"
        elif key == "signingCertificateThumbprint":
            suggest = "signing_certificate_thumbprint"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OnPremisePropertyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OnPremisePropertyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OnPremisePropertyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: str,
                 public_signing_key: str,
                 signing_certificate_thumbprint: Optional[str] = None):
        """
        Properties from the Kubernetes data controller
        :param str id: A globally unique ID identifying the associated Kubernetes cluster
        :param str public_signing_key: Certificate that contains the Kubernetes cluster public key used to verify signing
        :param str signing_certificate_thumbprint: Unique thumbprint returned to customer to verify the certificate being uploaded
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "public_signing_key", public_signing_key)
        if signing_certificate_thumbprint is not None:
            pulumi.set(__self__, "signing_certificate_thumbprint", signing_certificate_thumbprint)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        A globally unique ID identifying the associated Kubernetes cluster
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="publicSigningKey")
    def public_signing_key(self) -> str:
        """
        Certificate that contains the Kubernetes cluster public key used to verify signing
        """
        return pulumi.get(self, "public_signing_key")

    @property
    @pulumi.getter(name="signingCertificateThumbprint")
    def signing_certificate_thumbprint(self) -> Optional[str]:
        """
        Unique thumbprint returned to customer to verify the certificate being uploaded
        """
        return pulumi.get(self, "signing_certificate_thumbprint")


@pulumi.output_type
class PostgresInstancePropertiesResponse(dict):
    """
    Postgres Instance properties.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "basicLoginInformation":
            suggest = "basic_login_information"
        elif key == "dataControllerId":
            suggest = "data_controller_id"
        elif key == "k8sRaw":
            suggest = "k8s_raw"
        elif key == "lastUploadedDate":
            suggest = "last_uploaded_date"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PostgresInstancePropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PostgresInstancePropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PostgresInstancePropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 provisioning_state: str,
                 admin: Optional[str] = None,
                 basic_login_information: Optional['outputs.BasicLoginInformationResponse'] = None,
                 data_controller_id: Optional[str] = None,
                 k8s_raw: Optional[Any] = None,
                 last_uploaded_date: Optional[str] = None):
        """
        Postgres Instance properties.
        :param str admin: The instance admin
        :param 'BasicLoginInformationResponse' basic_login_information: Username and password for basic authentication.
        :param str data_controller_id: The data controller id
        :param Any k8s_raw: The raw kubernetes information
        :param str last_uploaded_date: Last uploaded date from Kubernetes cluster. Defaults to current date time
        """
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if admin is not None:
            pulumi.set(__self__, "admin", admin)
        if basic_login_information is not None:
            pulumi.set(__self__, "basic_login_information", basic_login_information)
        if data_controller_id is not None:
            pulumi.set(__self__, "data_controller_id", data_controller_id)
        if k8s_raw is not None:
            pulumi.set(__self__, "k8s_raw", k8s_raw)
        if last_uploaded_date is not None:
            pulumi.set(__self__, "last_uploaded_date", last_uploaded_date)

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def admin(self) -> Optional[str]:
        """
        The instance admin
        """
        return pulumi.get(self, "admin")

    @property
    @pulumi.getter(name="basicLoginInformation")
    def basic_login_information(self) -> Optional['outputs.BasicLoginInformationResponse']:
        """
        Username and password for basic authentication.
        """
        return pulumi.get(self, "basic_login_information")

    @property
    @pulumi.getter(name="dataControllerId")
    def data_controller_id(self) -> Optional[str]:
        """
        The data controller id
        """
        return pulumi.get(self, "data_controller_id")

    @property
    @pulumi.getter(name="k8sRaw")
    def k8s_raw(self) -> Optional[Any]:
        """
        The raw kubernetes information
        """
        return pulumi.get(self, "k8s_raw")

    @property
    @pulumi.getter(name="lastUploadedDate")
    def last_uploaded_date(self) -> Optional[str]:
        """
        Last uploaded date from Kubernetes cluster. Defaults to current date time
        """
        return pulumi.get(self, "last_uploaded_date")


@pulumi.output_type
class PostgresInstanceSkuResponse(dict):
    """
    The resource model definition representing SKU for Azure Database for PostgresSQL - Azure Arc
    """
    def __init__(__self__, *,
                 name: str,
                 capacity: Optional[int] = None,
                 dev: Optional[bool] = None,
                 family: Optional[str] = None,
                 size: Optional[str] = None,
                 tier: Optional[str] = None):
        """
        The resource model definition representing SKU for Azure Database for PostgresSQL - Azure Arc
        :param str name: The name of the SKU.  It is typically a letter+number code
        :param int capacity: If the SKU supports scale out/in then the capacity integer should be included. If scale out/in is not possible for the resource this may be omitted.
        :param bool dev: Whether dev/test is enabled. When the dev field is set to true, the resource is used for dev/test purpose. 
        :param str family: If the service has different generations of hardware, for the same SKU, then that can be captured here.
        :param str size: The SKU size. When the name field is the combination of tier and some other value, this would be the standalone code. 
        :param str tier: This field is required to be implemented by the Resource Provider if the service has more than one tier.
        """
        pulumi.set(__self__, "name", name)
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)
        if dev is None:
            dev = True
        if dev is not None:
            pulumi.set(__self__, "dev", dev)
        if family is not None:
            pulumi.set(__self__, "family", family)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if tier is None:
            tier = 'Hyperscale'
        if tier is not None:
            pulumi.set(__self__, "tier", tier)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the SKU.  It is typically a letter+number code
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def capacity(self) -> Optional[int]:
        """
        If the SKU supports scale out/in then the capacity integer should be included. If scale out/in is not possible for the resource this may be omitted.
        """
        return pulumi.get(self, "capacity")

    @property
    @pulumi.getter
    def dev(self) -> Optional[bool]:
        """
        Whether dev/test is enabled. When the dev field is set to true, the resource is used for dev/test purpose. 
        """
        return pulumi.get(self, "dev")

    @property
    @pulumi.getter
    def family(self) -> Optional[str]:
        """
        If the service has different generations of hardware, for the same SKU, then that can be captured here.
        """
        return pulumi.get(self, "family")

    @property
    @pulumi.getter
    def size(self) -> Optional[str]:
        """
        The SKU size. When the name field is the combination of tier and some other value, this would be the standalone code. 
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter
    def tier(self) -> Optional[str]:
        """
        This field is required to be implemented by the Resource Provider if the service has more than one tier.
        """
        return pulumi.get(self, "tier")


@pulumi.output_type
class SqlManagedInstancePropertiesResponse(dict):
    """
    Properties of sqlManagedInstance.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "basicLoginInformation":
            suggest = "basic_login_information"
        elif key == "dataControllerId":
            suggest = "data_controller_id"
        elif key == "endTime":
            suggest = "end_time"
        elif key == "k8sRaw":
            suggest = "k8s_raw"
        elif key == "lastUploadedDate":
            suggest = "last_uploaded_date"
        elif key == "startTime":
            suggest = "start_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SqlManagedInstancePropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SqlManagedInstancePropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SqlManagedInstancePropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 provisioning_state: str,
                 admin: Optional[str] = None,
                 basic_login_information: Optional['outputs.BasicLoginInformationResponse'] = None,
                 data_controller_id: Optional[str] = None,
                 end_time: Optional[str] = None,
                 k8s_raw: Optional[Any] = None,
                 last_uploaded_date: Optional[str] = None,
                 start_time: Optional[str] = None):
        """
        Properties of sqlManagedInstance.
        :param str admin: The instance admin user
        :param 'BasicLoginInformationResponse' basic_login_information: Username and password for basic authentication.
        :param str data_controller_id: null
        :param str end_time: The instance end time
        :param Any k8s_raw: The raw kubernetes information
        :param str last_uploaded_date: Last uploaded date from Kubernetes cluster. Defaults to current date time
        :param str start_time: The instance start time
        """
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if admin is not None:
            pulumi.set(__self__, "admin", admin)
        if basic_login_information is not None:
            pulumi.set(__self__, "basic_login_information", basic_login_information)
        if data_controller_id is not None:
            pulumi.set(__self__, "data_controller_id", data_controller_id)
        if end_time is not None:
            pulumi.set(__self__, "end_time", end_time)
        if k8s_raw is not None:
            pulumi.set(__self__, "k8s_raw", k8s_raw)
        if last_uploaded_date is not None:
            pulumi.set(__self__, "last_uploaded_date", last_uploaded_date)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def admin(self) -> Optional[str]:
        """
        The instance admin user
        """
        return pulumi.get(self, "admin")

    @property
    @pulumi.getter(name="basicLoginInformation")
    def basic_login_information(self) -> Optional['outputs.BasicLoginInformationResponse']:
        """
        Username and password for basic authentication.
        """
        return pulumi.get(self, "basic_login_information")

    @property
    @pulumi.getter(name="dataControllerId")
    def data_controller_id(self) -> Optional[str]:
        """
        null
        """
        return pulumi.get(self, "data_controller_id")

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> Optional[str]:
        """
        The instance end time
        """
        return pulumi.get(self, "end_time")

    @property
    @pulumi.getter(name="k8sRaw")
    def k8s_raw(self) -> Optional[Any]:
        """
        The raw kubernetes information
        """
        return pulumi.get(self, "k8s_raw")

    @property
    @pulumi.getter(name="lastUploadedDate")
    def last_uploaded_date(self) -> Optional[str]:
        """
        Last uploaded date from Kubernetes cluster. Defaults to current date time
        """
        return pulumi.get(self, "last_uploaded_date")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[str]:
        """
        The instance start time
        """
        return pulumi.get(self, "start_time")


@pulumi.output_type
class SqlManagedInstanceSkuResponse(dict):
    """
    The resource model definition representing SKU for Azure Managed Instance - Azure Arc
    """
    def __init__(__self__, *,
                 name: str,
                 capacity: Optional[int] = None,
                 dev: Optional[bool] = None,
                 family: Optional[str] = None,
                 size: Optional[str] = None,
                 tier: Optional[str] = None):
        """
        The resource model definition representing SKU for Azure Managed Instance - Azure Arc
        :param str name: The name of the SKU.  It is typically a letter+number code
        :param int capacity: If the SKU supports scale out/in then the capacity integer should be included. If scale out/in is not possible for the resource this may be omitted.
        :param bool dev: Whether dev/test is enabled. When the dev field is set to true, the resource is used for dev/test purpose. 
        :param str family: If the service has different generations of hardware, for the same SKU, then that can be captured here.
        :param str size: The SKU size. When the name field is the combination of tier and some other value, this would be the standalone code. 
        :param str tier: This field is required to be implemented by the Resource Provider if the service has more than one tier.
        """
        pulumi.set(__self__, "name", name)
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)
        if dev is None:
            dev = True
        if dev is not None:
            pulumi.set(__self__, "dev", dev)
        if family is not None:
            pulumi.set(__self__, "family", family)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if tier is None:
            tier = 'GeneralPurpose'
        if tier is not None:
            pulumi.set(__self__, "tier", tier)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the SKU.  It is typically a letter+number code
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def capacity(self) -> Optional[int]:
        """
        If the SKU supports scale out/in then the capacity integer should be included. If scale out/in is not possible for the resource this may be omitted.
        """
        return pulumi.get(self, "capacity")

    @property
    @pulumi.getter
    def dev(self) -> Optional[bool]:
        """
        Whether dev/test is enabled. When the dev field is set to true, the resource is used for dev/test purpose. 
        """
        return pulumi.get(self, "dev")

    @property
    @pulumi.getter
    def family(self) -> Optional[str]:
        """
        If the service has different generations of hardware, for the same SKU, then that can be captured here.
        """
        return pulumi.get(self, "family")

    @property
    @pulumi.getter
    def size(self) -> Optional[str]:
        """
        The SKU size. When the name field is the combination of tier and some other value, this would be the standalone code. 
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter
    def tier(self) -> Optional[str]:
        """
        This field is required to be implemented by the Resource Provider if the service has more than one tier.
        """
        return pulumi.get(self, "tier")


@pulumi.output_type
class SqlServerInstancePropertiesResponse(dict):
    """
    Properties of SqlServerInstance.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "containerResourceId":
            suggest = "container_resource_id"
        elif key == "createTime":
            suggest = "create_time"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "currentVersion":
            suggest = "current_version"
        elif key == "instanceName":
            suggest = "instance_name"
        elif key == "licenseType":
            suggest = "license_type"
        elif key == "patchLevel":
            suggest = "patch_level"
        elif key == "productId":
            suggest = "product_id"
        elif key == "tcpDynamicPorts":
            suggest = "tcp_dynamic_ports"
        elif key == "tcpStaticPorts":
            suggest = "tcp_static_ports"
        elif key == "vCore":
            suggest = "v_core"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SqlServerInstancePropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SqlServerInstancePropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SqlServerInstancePropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 container_resource_id: str,
                 create_time: str,
                 provisioning_state: str,
                 status: str,
                 collation: Optional[str] = None,
                 current_version: Optional[str] = None,
                 edition: Optional[str] = None,
                 instance_name: Optional[str] = None,
                 license_type: Optional[str] = None,
                 patch_level: Optional[str] = None,
                 product_id: Optional[str] = None,
                 tcp_dynamic_ports: Optional[str] = None,
                 tcp_static_ports: Optional[str] = None,
                 v_core: Optional[str] = None,
                 version: Optional[str] = None):
        """
        Properties of SqlServerInstance.
        :param str container_resource_id: ARM Resource id of the container resource (Azure Arc for Servers).
        :param str create_time: The time when the resource was created.
        :param str status: The cloud connectivity status.
        :param str collation: SQL Server collation.
        :param str current_version: SQL Server current version.
        :param str edition: SQL Server edition.
        :param str instance_name: SQL Server instance name.
        :param str license_type: SQL Server license type.
        :param str patch_level: SQL Server update level.
        :param str product_id: SQL Server product ID.
        :param str tcp_dynamic_ports: Dynamic TCP ports used by SQL Server.
        :param str tcp_static_ports: Static TCP ports used by SQL Server.
        :param str v_core: The number of logical processors used by the SQL Server instance.
        :param str version: SQL Server version.
        """
        pulumi.set(__self__, "container_resource_id", container_resource_id)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        pulumi.set(__self__, "status", status)
        if collation is not None:
            pulumi.set(__self__, "collation", collation)
        if current_version is not None:
            pulumi.set(__self__, "current_version", current_version)
        if edition is not None:
            pulumi.set(__self__, "edition", edition)
        if instance_name is not None:
            pulumi.set(__self__, "instance_name", instance_name)
        if license_type is not None:
            pulumi.set(__self__, "license_type", license_type)
        if patch_level is not None:
            pulumi.set(__self__, "patch_level", patch_level)
        if product_id is not None:
            pulumi.set(__self__, "product_id", product_id)
        if tcp_dynamic_ports is not None:
            pulumi.set(__self__, "tcp_dynamic_ports", tcp_dynamic_ports)
        if tcp_static_ports is not None:
            pulumi.set(__self__, "tcp_static_ports", tcp_static_ports)
        if v_core is not None:
            pulumi.set(__self__, "v_core", v_core)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="containerResourceId")
    def container_resource_id(self) -> str:
        """
        ARM Resource id of the container resource (Azure Arc for Servers).
        """
        return pulumi.get(self, "container_resource_id")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        The time when the resource was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The cloud connectivity status.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def collation(self) -> Optional[str]:
        """
        SQL Server collation.
        """
        return pulumi.get(self, "collation")

    @property
    @pulumi.getter(name="currentVersion")
    def current_version(self) -> Optional[str]:
        """
        SQL Server current version.
        """
        return pulumi.get(self, "current_version")

    @property
    @pulumi.getter
    def edition(self) -> Optional[str]:
        """
        SQL Server edition.
        """
        return pulumi.get(self, "edition")

    @property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> Optional[str]:
        """
        SQL Server instance name.
        """
        return pulumi.get(self, "instance_name")

    @property
    @pulumi.getter(name="licenseType")
    def license_type(self) -> Optional[str]:
        """
        SQL Server license type.
        """
        return pulumi.get(self, "license_type")

    @property
    @pulumi.getter(name="patchLevel")
    def patch_level(self) -> Optional[str]:
        """
        SQL Server update level.
        """
        return pulumi.get(self, "patch_level")

    @property
    @pulumi.getter(name="productId")
    def product_id(self) -> Optional[str]:
        """
        SQL Server product ID.
        """
        return pulumi.get(self, "product_id")

    @property
    @pulumi.getter(name="tcpDynamicPorts")
    def tcp_dynamic_ports(self) -> Optional[str]:
        """
        Dynamic TCP ports used by SQL Server.
        """
        return pulumi.get(self, "tcp_dynamic_ports")

    @property
    @pulumi.getter(name="tcpStaticPorts")
    def tcp_static_ports(self) -> Optional[str]:
        """
        Static TCP ports used by SQL Server.
        """
        return pulumi.get(self, "tcp_static_ports")

    @property
    @pulumi.getter(name="vCore")
    def v_core(self) -> Optional[str]:
        """
        The number of logical processors used by the SQL Server instance.
        """
        return pulumi.get(self, "v_core")

    @property
    @pulumi.getter
    def version(self) -> Optional[str]:
        """
        SQL Server version.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class SystemDataResponse(dict):
    """
    Read only system data
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createdAt":
            suggest = "created_at"
        elif key == "createdBy":
            suggest = "created_by"
        elif key == "createdByType":
            suggest = "created_by_type"
        elif key == "lastModifiedAt":
            suggest = "last_modified_at"
        elif key == "lastModifiedBy":
            suggest = "last_modified_by"
        elif key == "lastModifiedByType":
            suggest = "last_modified_by_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SystemDataResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SystemDataResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SystemDataResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 created_at: Optional[str] = None,
                 created_by: Optional[str] = None,
                 created_by_type: Optional[str] = None,
                 last_modified_at: Optional[str] = None,
                 last_modified_by: Optional[str] = None,
                 last_modified_by_type: Optional[str] = None):
        """
        Read only system data
        :param str created_at: The timestamp of resource creation (UTC)
        :param str created_by: An identifier for the identity that created the resource
        :param str created_by_type: The type of identity that created the resource
        :param str last_modified_at: The timestamp of resource last modification (UTC)
        :param str last_modified_by: An identifier for the identity that last modified the resource
        :param str last_modified_by_type: The type of identity that last modified the resource
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if created_by_type is not None:
            pulumi.set(__self__, "created_by_type", created_by_type)
        if last_modified_at is not None:
            pulumi.set(__self__, "last_modified_at", last_modified_at)
        if last_modified_by is not None:
            pulumi.set(__self__, "last_modified_by", last_modified_by)
        if last_modified_by_type is not None:
            pulumi.set(__self__, "last_modified_by_type", last_modified_by_type)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[str]:
        """
        The timestamp of resource creation (UTC)
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[str]:
        """
        An identifier for the identity that created the resource
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter(name="createdByType")
    def created_by_type(self) -> Optional[str]:
        """
        The type of identity that created the resource
        """
        return pulumi.get(self, "created_by_type")

    @property
    @pulumi.getter(name="lastModifiedAt")
    def last_modified_at(self) -> Optional[str]:
        """
        The timestamp of resource last modification (UTC)
        """
        return pulumi.get(self, "last_modified_at")

    @property
    @pulumi.getter(name="lastModifiedBy")
    def last_modified_by(self) -> Optional[str]:
        """
        An identifier for the identity that last modified the resource
        """
        return pulumi.get(self, "last_modified_by")

    @property
    @pulumi.getter(name="lastModifiedByType")
    def last_modified_by_type(self) -> Optional[str]:
        """
        The type of identity that last modified the resource
        """
        return pulumi.get(self, "last_modified_by_type")


@pulumi.output_type
class UploadServicePrincipalResponse(dict):
    """
    Service principal for uploading billing, metrics and logs.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientId":
            suggest = "client_id"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UploadServicePrincipalResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UploadServicePrincipalResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UploadServicePrincipalResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 authority: Optional[str] = None,
                 client_id: Optional[str] = None,
                 tenant_id: Optional[str] = None):
        """
        Service principal for uploading billing, metrics and logs.
        :param str authority: Authority for the service principal. Example: https://login.microsoftonline.com/
        :param str client_id: Client ID of the service principal for uploading data.
        :param str tenant_id: Tenant ID of the service principal.
        """
        if authority is not None:
            pulumi.set(__self__, "authority", authority)
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter
    def authority(self) -> Optional[str]:
        """
        Authority for the service principal. Example: https://login.microsoftonline.com/
        """
        return pulumi.get(self, "authority")

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[str]:
        """
        Client ID of the service principal for uploading data.
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[str]:
        """
        Tenant ID of the service principal.
        """
        return pulumi.get(self, "tenant_id")


@pulumi.output_type
class UploadWatermarkResponse(dict):
    """
    Properties on upload watermark.  Mostly timestamp for each upload data type
    """
    def __init__(__self__, *,
                 logs: Optional[str] = None,
                 metrics: Optional[str] = None,
                 usages: Optional[str] = None):
        """
        Properties on upload watermark.  Mostly timestamp for each upload data type
        :param str logs: Last uploaded date for logs from kubernetes cluster. Defaults to current date time
        :param str metrics: Last uploaded date for metrics from kubernetes cluster. Defaults to current date time
        :param str usages: Last uploaded date for usages from kubernetes cluster. Defaults to current date time
        """
        if logs is not None:
            pulumi.set(__self__, "logs", logs)
        if metrics is not None:
            pulumi.set(__self__, "metrics", metrics)
        if usages is not None:
            pulumi.set(__self__, "usages", usages)

    @property
    @pulumi.getter
    def logs(self) -> Optional[str]:
        """
        Last uploaded date for logs from kubernetes cluster. Defaults to current date time
        """
        return pulumi.get(self, "logs")

    @property
    @pulumi.getter
    def metrics(self) -> Optional[str]:
        """
        Last uploaded date for metrics from kubernetes cluster. Defaults to current date time
        """
        return pulumi.get(self, "metrics")

    @property
    @pulumi.getter
    def usages(self) -> Optional[str]:
        """
        Last uploaded date for usages from kubernetes cluster. Defaults to current date time
        """
        return pulumi.get(self, "usages")


