# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'AutomationRunbookReceiverArgs',
    'AzureAppPushReceiverArgs',
    'AzureFunctionReceiverArgs',
    'DynamicMetricCriteriaArgs',
    'DynamicThresholdFailingPeriodsArgs',
    'EmailReceiverArgs',
    'ItsmReceiverArgs',
    'LogicAppReceiverArgs',
    'MetricAlertActionArgs',
    'MetricAlertMultipleResourceMultipleMetricCriteriaArgs',
    'MetricAlertSingleResourceMultipleMetricCriteriaArgs',
    'MetricCriteriaArgs',
    'MetricDimensionArgs',
    'SmsReceiverArgs',
    'VoiceReceiverArgs',
    'WebhookReceiverArgs',
    'WebtestLocationAvailabilityCriteriaArgs',
]

@pulumi.input_type
class AutomationRunbookReceiverArgs:
    def __init__(__self__, *,
                 automation_account_id: pulumi.Input[str],
                 is_global_runbook: pulumi.Input[bool],
                 runbook_name: pulumi.Input[str],
                 webhook_resource_id: pulumi.Input[str],
                 name: Optional[pulumi.Input[str]] = None,
                 service_uri: Optional[pulumi.Input[str]] = None):
        """
        The Azure Automation Runbook notification receiver.
        :param pulumi.Input[str] automation_account_id: The Azure automation account Id which holds this runbook and authenticate to Azure resource.
        :param pulumi.Input[bool] is_global_runbook: Indicates whether this instance is global runbook.
        :param pulumi.Input[str] runbook_name: The name for this runbook.
        :param pulumi.Input[str] webhook_resource_id: The resource id for webhook linked to this runbook.
        :param pulumi.Input[str] name: Indicates name of the webhook.
        :param pulumi.Input[str] service_uri: The URI where webhooks should be sent.
        """
        pulumi.set(__self__, "automation_account_id", automation_account_id)
        pulumi.set(__self__, "is_global_runbook", is_global_runbook)
        pulumi.set(__self__, "runbook_name", runbook_name)
        pulumi.set(__self__, "webhook_resource_id", webhook_resource_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if service_uri is not None:
            pulumi.set(__self__, "service_uri", service_uri)

    @property
    @pulumi.getter(name="automationAccountId")
    def automation_account_id(self) -> pulumi.Input[str]:
        """
        The Azure automation account Id which holds this runbook and authenticate to Azure resource.
        """
        return pulumi.get(self, "automation_account_id")

    @automation_account_id.setter
    def automation_account_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "automation_account_id", value)

    @property
    @pulumi.getter(name="isGlobalRunbook")
    def is_global_runbook(self) -> pulumi.Input[bool]:
        """
        Indicates whether this instance is global runbook.
        """
        return pulumi.get(self, "is_global_runbook")

    @is_global_runbook.setter
    def is_global_runbook(self, value: pulumi.Input[bool]):
        pulumi.set(self, "is_global_runbook", value)

    @property
    @pulumi.getter(name="runbookName")
    def runbook_name(self) -> pulumi.Input[str]:
        """
        The name for this runbook.
        """
        return pulumi.get(self, "runbook_name")

    @runbook_name.setter
    def runbook_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "runbook_name", value)

    @property
    @pulumi.getter(name="webhookResourceId")
    def webhook_resource_id(self) -> pulumi.Input[str]:
        """
        The resource id for webhook linked to this runbook.
        """
        return pulumi.get(self, "webhook_resource_id")

    @webhook_resource_id.setter
    def webhook_resource_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "webhook_resource_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates name of the webhook.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="serviceUri")
    def service_uri(self) -> Optional[pulumi.Input[str]]:
        """
        The URI where webhooks should be sent.
        """
        return pulumi.get(self, "service_uri")

    @service_uri.setter
    def service_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_uri", value)


@pulumi.input_type
class AzureAppPushReceiverArgs:
    def __init__(__self__, *,
                 email_address: pulumi.Input[str],
                 name: pulumi.Input[str]):
        """
        The Azure mobile App push notification receiver.
        :param pulumi.Input[str] email_address: The email address registered for the Azure mobile app.
        :param pulumi.Input[str] name: The name of the Azure mobile app push receiver. Names must be unique across all receivers within an action group.
        """
        pulumi.set(__self__, "email_address", email_address)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="emailAddress")
    def email_address(self) -> pulumi.Input[str]:
        """
        The email address registered for the Azure mobile app.
        """
        return pulumi.get(self, "email_address")

    @email_address.setter
    def email_address(self, value: pulumi.Input[str]):
        pulumi.set(self, "email_address", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the Azure mobile app push receiver. Names must be unique across all receivers within an action group.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class AzureFunctionReceiverArgs:
    def __init__(__self__, *,
                 function_app_resource_id: pulumi.Input[str],
                 function_name: pulumi.Input[str],
                 http_trigger_url: pulumi.Input[str],
                 name: pulumi.Input[str]):
        """
        An azure function receiver.
        :param pulumi.Input[str] function_app_resource_id: The azure resource id of the function app.
        :param pulumi.Input[str] function_name: The function name in the function app.
        :param pulumi.Input[str] http_trigger_url: The http trigger url where http request sent to.
        :param pulumi.Input[str] name: The name of the azure function receiver. Names must be unique across all receivers within an action group.
        """
        pulumi.set(__self__, "function_app_resource_id", function_app_resource_id)
        pulumi.set(__self__, "function_name", function_name)
        pulumi.set(__self__, "http_trigger_url", http_trigger_url)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="functionAppResourceId")
    def function_app_resource_id(self) -> pulumi.Input[str]:
        """
        The azure resource id of the function app.
        """
        return pulumi.get(self, "function_app_resource_id")

    @function_app_resource_id.setter
    def function_app_resource_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "function_app_resource_id", value)

    @property
    @pulumi.getter(name="functionName")
    def function_name(self) -> pulumi.Input[str]:
        """
        The function name in the function app.
        """
        return pulumi.get(self, "function_name")

    @function_name.setter
    def function_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "function_name", value)

    @property
    @pulumi.getter(name="httpTriggerUrl")
    def http_trigger_url(self) -> pulumi.Input[str]:
        """
        The http trigger url where http request sent to.
        """
        return pulumi.get(self, "http_trigger_url")

    @http_trigger_url.setter
    def http_trigger_url(self, value: pulumi.Input[str]):
        pulumi.set(self, "http_trigger_url", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the azure function receiver. Names must be unique across all receivers within an action group.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class DynamicMetricCriteriaArgs:
    def __init__(__self__, *,
                 alert_sensitivity: pulumi.Input[Union[str, 'DynamicThresholdSensitivity']],
                 criterion_type: pulumi.Input[str],
                 failing_periods: pulumi.Input['DynamicThresholdFailingPeriodsArgs'],
                 metric_name: pulumi.Input[str],
                 name: pulumi.Input[str],
                 operator: pulumi.Input[Union[str, 'DynamicThresholdOperator']],
                 time_aggregation: pulumi.Input[Union[str, 'AggregationTypeEnum']],
                 dimensions: Optional[pulumi.Input[Sequence[pulumi.Input['MetricDimensionArgs']]]] = None,
                 ignore_data_before: Optional[pulumi.Input[str]] = None,
                 metric_namespace: Optional[pulumi.Input[str]] = None,
                 skip_metric_validation: Optional[pulumi.Input[bool]] = None):
        """
        Criterion for dynamic threshold.
        :param pulumi.Input[Union[str, 'DynamicThresholdSensitivity']] alert_sensitivity: The extent of deviation required to trigger an alert. This will affect how tight the threshold is to the metric series pattern.
        :param pulumi.Input[str] criterion_type: Specifies the type of threshold criteria
               Expected value is 'DynamicThresholdCriterion'.
        :param pulumi.Input['DynamicThresholdFailingPeriodsArgs'] failing_periods: The minimum number of violations required within the selected lookback time window required to raise an alert.
        :param pulumi.Input[str] metric_name: Name of the metric.
        :param pulumi.Input[str] name: Name of the criteria.
        :param pulumi.Input[Union[str, 'DynamicThresholdOperator']] operator: The operator used to compare the metric value against the threshold.
        :param pulumi.Input[Union[str, 'AggregationTypeEnum']] time_aggregation: the criteria time aggregation types.
        :param pulumi.Input[Sequence[pulumi.Input['MetricDimensionArgs']]] dimensions: List of dimension conditions.
        :param pulumi.Input[str] ignore_data_before: Use this option to set the date from which to start learning the metric historical data and calculate the dynamic thresholds (in ISO8601 format)
        :param pulumi.Input[str] metric_namespace: Namespace of the metric.
        :param pulumi.Input[bool] skip_metric_validation: Allows creating an alert rule on a custom metric that isn't yet emitted, by causing the metric validation to be skipped.
        """
        pulumi.set(__self__, "alert_sensitivity", alert_sensitivity)
        pulumi.set(__self__, "criterion_type", 'DynamicThresholdCriterion')
        pulumi.set(__self__, "failing_periods", failing_periods)
        pulumi.set(__self__, "metric_name", metric_name)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "operator", operator)
        pulumi.set(__self__, "time_aggregation", time_aggregation)
        if dimensions is not None:
            pulumi.set(__self__, "dimensions", dimensions)
        if ignore_data_before is not None:
            pulumi.set(__self__, "ignore_data_before", ignore_data_before)
        if metric_namespace is not None:
            pulumi.set(__self__, "metric_namespace", metric_namespace)
        if skip_metric_validation is not None:
            pulumi.set(__self__, "skip_metric_validation", skip_metric_validation)

    @property
    @pulumi.getter(name="alertSensitivity")
    def alert_sensitivity(self) -> pulumi.Input[Union[str, 'DynamicThresholdSensitivity']]:
        """
        The extent of deviation required to trigger an alert. This will affect how tight the threshold is to the metric series pattern.
        """
        return pulumi.get(self, "alert_sensitivity")

    @alert_sensitivity.setter
    def alert_sensitivity(self, value: pulumi.Input[Union[str, 'DynamicThresholdSensitivity']]):
        pulumi.set(self, "alert_sensitivity", value)

    @property
    @pulumi.getter(name="criterionType")
    def criterion_type(self) -> pulumi.Input[str]:
        """
        Specifies the type of threshold criteria
        Expected value is 'DynamicThresholdCriterion'.
        """
        return pulumi.get(self, "criterion_type")

    @criterion_type.setter
    def criterion_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "criterion_type", value)

    @property
    @pulumi.getter(name="failingPeriods")
    def failing_periods(self) -> pulumi.Input['DynamicThresholdFailingPeriodsArgs']:
        """
        The minimum number of violations required within the selected lookback time window required to raise an alert.
        """
        return pulumi.get(self, "failing_periods")

    @failing_periods.setter
    def failing_periods(self, value: pulumi.Input['DynamicThresholdFailingPeriodsArgs']):
        pulumi.set(self, "failing_periods", value)

    @property
    @pulumi.getter(name="metricName")
    def metric_name(self) -> pulumi.Input[str]:
        """
        Name of the metric.
        """
        return pulumi.get(self, "metric_name")

    @metric_name.setter
    def metric_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "metric_name", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Name of the criteria.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def operator(self) -> pulumi.Input[Union[str, 'DynamicThresholdOperator']]:
        """
        The operator used to compare the metric value against the threshold.
        """
        return pulumi.get(self, "operator")

    @operator.setter
    def operator(self, value: pulumi.Input[Union[str, 'DynamicThresholdOperator']]):
        pulumi.set(self, "operator", value)

    @property
    @pulumi.getter(name="timeAggregation")
    def time_aggregation(self) -> pulumi.Input[Union[str, 'AggregationTypeEnum']]:
        """
        the criteria time aggregation types.
        """
        return pulumi.get(self, "time_aggregation")

    @time_aggregation.setter
    def time_aggregation(self, value: pulumi.Input[Union[str, 'AggregationTypeEnum']]):
        pulumi.set(self, "time_aggregation", value)

    @property
    @pulumi.getter
    def dimensions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MetricDimensionArgs']]]]:
        """
        List of dimension conditions.
        """
        return pulumi.get(self, "dimensions")

    @dimensions.setter
    def dimensions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MetricDimensionArgs']]]]):
        pulumi.set(self, "dimensions", value)

    @property
    @pulumi.getter(name="ignoreDataBefore")
    def ignore_data_before(self) -> Optional[pulumi.Input[str]]:
        """
        Use this option to set the date from which to start learning the metric historical data and calculate the dynamic thresholds (in ISO8601 format)
        """
        return pulumi.get(self, "ignore_data_before")

    @ignore_data_before.setter
    def ignore_data_before(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ignore_data_before", value)

    @property
    @pulumi.getter(name="metricNamespace")
    def metric_namespace(self) -> Optional[pulumi.Input[str]]:
        """
        Namespace of the metric.
        """
        return pulumi.get(self, "metric_namespace")

    @metric_namespace.setter
    def metric_namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "metric_namespace", value)

    @property
    @pulumi.getter(name="skipMetricValidation")
    def skip_metric_validation(self) -> Optional[pulumi.Input[bool]]:
        """
        Allows creating an alert rule on a custom metric that isn't yet emitted, by causing the metric validation to be skipped.
        """
        return pulumi.get(self, "skip_metric_validation")

    @skip_metric_validation.setter
    def skip_metric_validation(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "skip_metric_validation", value)


@pulumi.input_type
class DynamicThresholdFailingPeriodsArgs:
    def __init__(__self__, *,
                 min_failing_periods_to_alert: pulumi.Input[float],
                 number_of_evaluation_periods: pulumi.Input[float]):
        """
        The minimum number of violations required within the selected lookback time window required to raise an alert.
        :param pulumi.Input[float] min_failing_periods_to_alert: The number of violations to trigger an alert. Should be smaller or equal to numberOfEvaluationPeriods.
        :param pulumi.Input[float] number_of_evaluation_periods: The number of aggregated lookback points. The lookback time window is calculated based on the aggregation granularity (windowSize) and the selected number of aggregated points.
        """
        pulumi.set(__self__, "min_failing_periods_to_alert", min_failing_periods_to_alert)
        pulumi.set(__self__, "number_of_evaluation_periods", number_of_evaluation_periods)

    @property
    @pulumi.getter(name="minFailingPeriodsToAlert")
    def min_failing_periods_to_alert(self) -> pulumi.Input[float]:
        """
        The number of violations to trigger an alert. Should be smaller or equal to numberOfEvaluationPeriods.
        """
        return pulumi.get(self, "min_failing_periods_to_alert")

    @min_failing_periods_to_alert.setter
    def min_failing_periods_to_alert(self, value: pulumi.Input[float]):
        pulumi.set(self, "min_failing_periods_to_alert", value)

    @property
    @pulumi.getter(name="numberOfEvaluationPeriods")
    def number_of_evaluation_periods(self) -> pulumi.Input[float]:
        """
        The number of aggregated lookback points. The lookback time window is calculated based on the aggregation granularity (windowSize) and the selected number of aggregated points.
        """
        return pulumi.get(self, "number_of_evaluation_periods")

    @number_of_evaluation_periods.setter
    def number_of_evaluation_periods(self, value: pulumi.Input[float]):
        pulumi.set(self, "number_of_evaluation_periods", value)


@pulumi.input_type
class EmailReceiverArgs:
    def __init__(__self__, *,
                 email_address: pulumi.Input[str],
                 name: pulumi.Input[str]):
        """
        An email receiver.
        :param pulumi.Input[str] email_address: The email address of this receiver.
        :param pulumi.Input[str] name: The name of the email receiver. Names must be unique across all receivers within an action group.
        """
        pulumi.set(__self__, "email_address", email_address)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="emailAddress")
    def email_address(self) -> pulumi.Input[str]:
        """
        The email address of this receiver.
        """
        return pulumi.get(self, "email_address")

    @email_address.setter
    def email_address(self, value: pulumi.Input[str]):
        pulumi.set(self, "email_address", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the email receiver. Names must be unique across all receivers within an action group.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class ItsmReceiverArgs:
    def __init__(__self__, *,
                 connection_id: pulumi.Input[str],
                 name: pulumi.Input[str],
                 region: pulumi.Input[str],
                 ticket_configuration: pulumi.Input[str],
                 workspace_id: pulumi.Input[str]):
        """
        An Itsm receiver.
        :param pulumi.Input[str] connection_id: Unique identification of ITSM connection among multiple defined in above workspace.
        :param pulumi.Input[str] name: The name of the Itsm receiver. Names must be unique across all receivers within an action group.
        :param pulumi.Input[str] region: Region in which workspace resides. Supported values:'centralindia','japaneast','southeastasia','australiasoutheast','uksouth','westcentralus','canadacentral','eastus','westeurope'
        :param pulumi.Input[str] ticket_configuration: JSON blob for the configurations of the ITSM action. CreateMultipleWorkItems option will be part of this blob as well.
        :param pulumi.Input[str] workspace_id: OMS LA instance identifier.
        """
        pulumi.set(__self__, "connection_id", connection_id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "region", region)
        pulumi.set(__self__, "ticket_configuration", ticket_configuration)
        pulumi.set(__self__, "workspace_id", workspace_id)

    @property
    @pulumi.getter(name="connectionId")
    def connection_id(self) -> pulumi.Input[str]:
        """
        Unique identification of ITSM connection among multiple defined in above workspace.
        """
        return pulumi.get(self, "connection_id")

    @connection_id.setter
    def connection_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "connection_id", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the Itsm receiver. Names must be unique across all receivers within an action group.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def region(self) -> pulumi.Input[str]:
        """
        Region in which workspace resides. Supported values:'centralindia','japaneast','southeastasia','australiasoutheast','uksouth','westcentralus','canadacentral','eastus','westeurope'
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: pulumi.Input[str]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="ticketConfiguration")
    def ticket_configuration(self) -> pulumi.Input[str]:
        """
        JSON blob for the configurations of the ITSM action. CreateMultipleWorkItems option will be part of this blob as well.
        """
        return pulumi.get(self, "ticket_configuration")

    @ticket_configuration.setter
    def ticket_configuration(self, value: pulumi.Input[str]):
        pulumi.set(self, "ticket_configuration", value)

    @property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> pulumi.Input[str]:
        """
        OMS LA instance identifier.
        """
        return pulumi.get(self, "workspace_id")

    @workspace_id.setter
    def workspace_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "workspace_id", value)


@pulumi.input_type
class LogicAppReceiverArgs:
    def __init__(__self__, *,
                 callback_url: pulumi.Input[str],
                 name: pulumi.Input[str],
                 resource_id: pulumi.Input[str]):
        """
        A logic app receiver.
        :param pulumi.Input[str] callback_url: The callback url where http request sent to.
        :param pulumi.Input[str] name: The name of the logic app receiver. Names must be unique across all receivers within an action group.
        :param pulumi.Input[str] resource_id: The azure resource id of the logic app receiver.
        """
        pulumi.set(__self__, "callback_url", callback_url)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "resource_id", resource_id)

    @property
    @pulumi.getter(name="callbackUrl")
    def callback_url(self) -> pulumi.Input[str]:
        """
        The callback url where http request sent to.
        """
        return pulumi.get(self, "callback_url")

    @callback_url.setter
    def callback_url(self, value: pulumi.Input[str]):
        pulumi.set(self, "callback_url", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the logic app receiver. Names must be unique across all receivers within an action group.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> pulumi.Input[str]:
        """
        The azure resource id of the logic app receiver.
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "resource_id", value)


@pulumi.input_type
class MetricAlertActionArgs:
    def __init__(__self__, *,
                 action_group_id: Optional[pulumi.Input[str]] = None,
                 web_hook_properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        An alert action.
        :param pulumi.Input[str] action_group_id: the id of the action group to use.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] web_hook_properties: This field allows specifying custom properties, which would be appended to the alert payload sent as input to the webhook.
        """
        if action_group_id is not None:
            pulumi.set(__self__, "action_group_id", action_group_id)
        if web_hook_properties is not None:
            pulumi.set(__self__, "web_hook_properties", web_hook_properties)

    @property
    @pulumi.getter(name="actionGroupId")
    def action_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        the id of the action group to use.
        """
        return pulumi.get(self, "action_group_id")

    @action_group_id.setter
    def action_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "action_group_id", value)

    @property
    @pulumi.getter(name="webHookProperties")
    def web_hook_properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        This field allows specifying custom properties, which would be appended to the alert payload sent as input to the webhook.
        """
        return pulumi.get(self, "web_hook_properties")

    @web_hook_properties.setter
    def web_hook_properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "web_hook_properties", value)


@pulumi.input_type
class MetricAlertMultipleResourceMultipleMetricCriteriaArgs:
    def __init__(__self__, *,
                 odata_type: pulumi.Input[str],
                 all_of: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DynamicMetricCriteriaArgs', 'MetricCriteriaArgs']]]]] = None):
        """
        Specifies the metric alert criteria for multiple resource that has multiple metric criteria.
        :param pulumi.Input[str] odata_type: specifies the type of the alert criteria.
               Expected value is 'Microsoft.Azure.Monitor.MultipleResourceMultipleMetricCriteria'.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DynamicMetricCriteriaArgs', 'MetricCriteriaArgs']]]] all_of: the list of multiple metric criteria for this 'all of' operation. 
        """
        pulumi.set(__self__, "odata_type", 'Microsoft.Azure.Monitor.MultipleResourceMultipleMetricCriteria')
        if all_of is not None:
            pulumi.set(__self__, "all_of", all_of)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> pulumi.Input[str]:
        """
        specifies the type of the alert criteria.
        Expected value is 'Microsoft.Azure.Monitor.MultipleResourceMultipleMetricCriteria'.
        """
        return pulumi.get(self, "odata_type")

    @odata_type.setter
    def odata_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "odata_type", value)

    @property
    @pulumi.getter(name="allOf")
    def all_of(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Union['DynamicMetricCriteriaArgs', 'MetricCriteriaArgs']]]]]:
        """
        the list of multiple metric criteria for this 'all of' operation. 
        """
        return pulumi.get(self, "all_of")

    @all_of.setter
    def all_of(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DynamicMetricCriteriaArgs', 'MetricCriteriaArgs']]]]]):
        pulumi.set(self, "all_of", value)


@pulumi.input_type
class MetricAlertSingleResourceMultipleMetricCriteriaArgs:
    def __init__(__self__, *,
                 odata_type: pulumi.Input[str],
                 all_of: Optional[pulumi.Input[Sequence[pulumi.Input['MetricCriteriaArgs']]]] = None):
        """
        Specifies the metric alert criteria for a single resource that has multiple metric criteria.
        :param pulumi.Input[str] odata_type: specifies the type of the alert criteria.
               Expected value is 'Microsoft.Azure.Monitor.SingleResourceMultipleMetricCriteria'.
        :param pulumi.Input[Sequence[pulumi.Input['MetricCriteriaArgs']]] all_of: The list of metric criteria for this 'all of' operation. 
        """
        pulumi.set(__self__, "odata_type", 'Microsoft.Azure.Monitor.SingleResourceMultipleMetricCriteria')
        if all_of is not None:
            pulumi.set(__self__, "all_of", all_of)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> pulumi.Input[str]:
        """
        specifies the type of the alert criteria.
        Expected value is 'Microsoft.Azure.Monitor.SingleResourceMultipleMetricCriteria'.
        """
        return pulumi.get(self, "odata_type")

    @odata_type.setter
    def odata_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "odata_type", value)

    @property
    @pulumi.getter(name="allOf")
    def all_of(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MetricCriteriaArgs']]]]:
        """
        The list of metric criteria for this 'all of' operation. 
        """
        return pulumi.get(self, "all_of")

    @all_of.setter
    def all_of(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MetricCriteriaArgs']]]]):
        pulumi.set(self, "all_of", value)


@pulumi.input_type
class MetricCriteriaArgs:
    def __init__(__self__, *,
                 criterion_type: pulumi.Input[str],
                 metric_name: pulumi.Input[str],
                 name: pulumi.Input[str],
                 operator: pulumi.Input[Union[str, 'Operator']],
                 threshold: pulumi.Input[float],
                 time_aggregation: pulumi.Input[Union[str, 'AggregationTypeEnum']],
                 dimensions: Optional[pulumi.Input[Sequence[pulumi.Input['MetricDimensionArgs']]]] = None,
                 metric_namespace: Optional[pulumi.Input[str]] = None,
                 skip_metric_validation: Optional[pulumi.Input[bool]] = None):
        """
        Criterion to filter metrics.
        :param pulumi.Input[str] criterion_type: Specifies the type of threshold criteria
               Expected value is 'StaticThresholdCriterion'.
        :param pulumi.Input[str] metric_name: Name of the metric.
        :param pulumi.Input[str] name: Name of the criteria.
        :param pulumi.Input[Union[str, 'Operator']] operator: the criteria operator.
        :param pulumi.Input[float] threshold: the criteria threshold value that activates the alert.
        :param pulumi.Input[Union[str, 'AggregationTypeEnum']] time_aggregation: the criteria time aggregation types.
        :param pulumi.Input[Sequence[pulumi.Input['MetricDimensionArgs']]] dimensions: List of dimension conditions.
        :param pulumi.Input[str] metric_namespace: Namespace of the metric.
        :param pulumi.Input[bool] skip_metric_validation: Allows creating an alert rule on a custom metric that isn't yet emitted, by causing the metric validation to be skipped.
        """
        pulumi.set(__self__, "criterion_type", 'StaticThresholdCriterion')
        pulumi.set(__self__, "metric_name", metric_name)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "operator", operator)
        pulumi.set(__self__, "threshold", threshold)
        pulumi.set(__self__, "time_aggregation", time_aggregation)
        if dimensions is not None:
            pulumi.set(__self__, "dimensions", dimensions)
        if metric_namespace is not None:
            pulumi.set(__self__, "metric_namespace", metric_namespace)
        if skip_metric_validation is not None:
            pulumi.set(__self__, "skip_metric_validation", skip_metric_validation)

    @property
    @pulumi.getter(name="criterionType")
    def criterion_type(self) -> pulumi.Input[str]:
        """
        Specifies the type of threshold criteria
        Expected value is 'StaticThresholdCriterion'.
        """
        return pulumi.get(self, "criterion_type")

    @criterion_type.setter
    def criterion_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "criterion_type", value)

    @property
    @pulumi.getter(name="metricName")
    def metric_name(self) -> pulumi.Input[str]:
        """
        Name of the metric.
        """
        return pulumi.get(self, "metric_name")

    @metric_name.setter
    def metric_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "metric_name", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Name of the criteria.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def operator(self) -> pulumi.Input[Union[str, 'Operator']]:
        """
        the criteria operator.
        """
        return pulumi.get(self, "operator")

    @operator.setter
    def operator(self, value: pulumi.Input[Union[str, 'Operator']]):
        pulumi.set(self, "operator", value)

    @property
    @pulumi.getter
    def threshold(self) -> pulumi.Input[float]:
        """
        the criteria threshold value that activates the alert.
        """
        return pulumi.get(self, "threshold")

    @threshold.setter
    def threshold(self, value: pulumi.Input[float]):
        pulumi.set(self, "threshold", value)

    @property
    @pulumi.getter(name="timeAggregation")
    def time_aggregation(self) -> pulumi.Input[Union[str, 'AggregationTypeEnum']]:
        """
        the criteria time aggregation types.
        """
        return pulumi.get(self, "time_aggregation")

    @time_aggregation.setter
    def time_aggregation(self, value: pulumi.Input[Union[str, 'AggregationTypeEnum']]):
        pulumi.set(self, "time_aggregation", value)

    @property
    @pulumi.getter
    def dimensions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MetricDimensionArgs']]]]:
        """
        List of dimension conditions.
        """
        return pulumi.get(self, "dimensions")

    @dimensions.setter
    def dimensions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MetricDimensionArgs']]]]):
        pulumi.set(self, "dimensions", value)

    @property
    @pulumi.getter(name="metricNamespace")
    def metric_namespace(self) -> Optional[pulumi.Input[str]]:
        """
        Namespace of the metric.
        """
        return pulumi.get(self, "metric_namespace")

    @metric_namespace.setter
    def metric_namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "metric_namespace", value)

    @property
    @pulumi.getter(name="skipMetricValidation")
    def skip_metric_validation(self) -> Optional[pulumi.Input[bool]]:
        """
        Allows creating an alert rule on a custom metric that isn't yet emitted, by causing the metric validation to be skipped.
        """
        return pulumi.get(self, "skip_metric_validation")

    @skip_metric_validation.setter
    def skip_metric_validation(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "skip_metric_validation", value)


@pulumi.input_type
class MetricDimensionArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 operator: pulumi.Input[str],
                 values: pulumi.Input[Sequence[pulumi.Input[str]]]):
        """
        Specifies a metric dimension.
        :param pulumi.Input[str] name: Name of the dimension.
        :param pulumi.Input[str] operator: the dimension operator. Only 'Include' and 'Exclude' are supported
        :param pulumi.Input[Sequence[pulumi.Input[str]]] values: list of dimension values.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "operator", operator)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Name of the dimension.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def operator(self) -> pulumi.Input[str]:
        """
        the dimension operator. Only 'Include' and 'Exclude' are supported
        """
        return pulumi.get(self, "operator")

    @operator.setter
    def operator(self, value: pulumi.Input[str]):
        pulumi.set(self, "operator", value)

    @property
    @pulumi.getter
    def values(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        list of dimension values.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "values", value)


@pulumi.input_type
class SmsReceiverArgs:
    def __init__(__self__, *,
                 country_code: pulumi.Input[str],
                 name: pulumi.Input[str],
                 phone_number: pulumi.Input[str]):
        """
        An SMS receiver.
        :param pulumi.Input[str] country_code: The country code of the SMS receiver.
        :param pulumi.Input[str] name: The name of the SMS receiver. Names must be unique across all receivers within an action group.
        :param pulumi.Input[str] phone_number: The phone number of the SMS receiver.
        """
        pulumi.set(__self__, "country_code", country_code)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "phone_number", phone_number)

    @property
    @pulumi.getter(name="countryCode")
    def country_code(self) -> pulumi.Input[str]:
        """
        The country code of the SMS receiver.
        """
        return pulumi.get(self, "country_code")

    @country_code.setter
    def country_code(self, value: pulumi.Input[str]):
        pulumi.set(self, "country_code", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the SMS receiver. Names must be unique across all receivers within an action group.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="phoneNumber")
    def phone_number(self) -> pulumi.Input[str]:
        """
        The phone number of the SMS receiver.
        """
        return pulumi.get(self, "phone_number")

    @phone_number.setter
    def phone_number(self, value: pulumi.Input[str]):
        pulumi.set(self, "phone_number", value)


@pulumi.input_type
class VoiceReceiverArgs:
    def __init__(__self__, *,
                 country_code: pulumi.Input[str],
                 name: pulumi.Input[str],
                 phone_number: pulumi.Input[str]):
        """
        A voice receiver.
        :param pulumi.Input[str] country_code: The country code of the voice receiver.
        :param pulumi.Input[str] name: The name of the voice receiver. Names must be unique across all receivers within an action group.
        :param pulumi.Input[str] phone_number: The phone number of the voice receiver.
        """
        pulumi.set(__self__, "country_code", country_code)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "phone_number", phone_number)

    @property
    @pulumi.getter(name="countryCode")
    def country_code(self) -> pulumi.Input[str]:
        """
        The country code of the voice receiver.
        """
        return pulumi.get(self, "country_code")

    @country_code.setter
    def country_code(self, value: pulumi.Input[str]):
        pulumi.set(self, "country_code", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the voice receiver. Names must be unique across all receivers within an action group.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="phoneNumber")
    def phone_number(self) -> pulumi.Input[str]:
        """
        The phone number of the voice receiver.
        """
        return pulumi.get(self, "phone_number")

    @phone_number.setter
    def phone_number(self, value: pulumi.Input[str]):
        pulumi.set(self, "phone_number", value)


@pulumi.input_type
class WebhookReceiverArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 service_uri: pulumi.Input[str]):
        """
        A webhook receiver.
        :param pulumi.Input[str] name: The name of the webhook receiver. Names must be unique across all receivers within an action group.
        :param pulumi.Input[str] service_uri: The URI where webhooks should be sent.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "service_uri", service_uri)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the webhook receiver. Names must be unique across all receivers within an action group.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="serviceUri")
    def service_uri(self) -> pulumi.Input[str]:
        """
        The URI where webhooks should be sent.
        """
        return pulumi.get(self, "service_uri")

    @service_uri.setter
    def service_uri(self, value: pulumi.Input[str]):
        pulumi.set(self, "service_uri", value)


@pulumi.input_type
class WebtestLocationAvailabilityCriteriaArgs:
    def __init__(__self__, *,
                 component_id: pulumi.Input[str],
                 failed_location_count: pulumi.Input[float],
                 odata_type: pulumi.Input[str],
                 web_test_id: pulumi.Input[str]):
        """
        Specifies the metric alert rule criteria for a web test resource.
        :param pulumi.Input[str] component_id: The Application Insights resource Id.
        :param pulumi.Input[float] failed_location_count: The number of failed locations.
        :param pulumi.Input[str] odata_type: specifies the type of the alert criteria.
               Expected value is 'Microsoft.Azure.Monitor.WebtestLocationAvailabilityCriteria'.
        :param pulumi.Input[str] web_test_id: The Application Insights web test Id.
        """
        pulumi.set(__self__, "component_id", component_id)
        pulumi.set(__self__, "failed_location_count", failed_location_count)
        pulumi.set(__self__, "odata_type", 'Microsoft.Azure.Monitor.WebtestLocationAvailabilityCriteria')
        pulumi.set(__self__, "web_test_id", web_test_id)

    @property
    @pulumi.getter(name="componentId")
    def component_id(self) -> pulumi.Input[str]:
        """
        The Application Insights resource Id.
        """
        return pulumi.get(self, "component_id")

    @component_id.setter
    def component_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "component_id", value)

    @property
    @pulumi.getter(name="failedLocationCount")
    def failed_location_count(self) -> pulumi.Input[float]:
        """
        The number of failed locations.
        """
        return pulumi.get(self, "failed_location_count")

    @failed_location_count.setter
    def failed_location_count(self, value: pulumi.Input[float]):
        pulumi.set(self, "failed_location_count", value)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> pulumi.Input[str]:
        """
        specifies the type of the alert criteria.
        Expected value is 'Microsoft.Azure.Monitor.WebtestLocationAvailabilityCriteria'.
        """
        return pulumi.get(self, "odata_type")

    @odata_type.setter
    def odata_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "odata_type", value)

    @property
    @pulumi.getter(name="webTestId")
    def web_test_id(self) -> pulumi.Input[str]:
        """
        The Application Insights web test Id.
        """
        return pulumi.get(self, "web_test_id")

    @web_test_id.setter
    def web_test_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "web_test_id", value)


