# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetGetLabResult',
    'AwaitableGetGetLabResult',
    'get_get_lab',
    'get_get_lab_output',
]

@pulumi.output_type
class GetGetLabResult:
    """
    Lab details.
    """
    def __init__(__self__, budget_per_student=None, currency=None, description=None, display_name=None, effective_date=None, expiration_date=None, id=None, invitation_code=None, max_student_count=None, name=None, status=None, system_data=None, type=None, value=None):
        if budget_per_student and not isinstance(budget_per_student, dict):
            raise TypeError("Expected argument 'budget_per_student' to be a dict")
        pulumi.set(__self__, "budget_per_student", budget_per_student)
        if currency and not isinstance(currency, str):
            raise TypeError("Expected argument 'currency' to be a str")
        pulumi.set(__self__, "currency", currency)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if effective_date and not isinstance(effective_date, str):
            raise TypeError("Expected argument 'effective_date' to be a str")
        pulumi.set(__self__, "effective_date", effective_date)
        if expiration_date and not isinstance(expiration_date, str):
            raise TypeError("Expected argument 'expiration_date' to be a str")
        pulumi.set(__self__, "expiration_date", expiration_date)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if invitation_code and not isinstance(invitation_code, str):
            raise TypeError("Expected argument 'invitation_code' to be a str")
        pulumi.set(__self__, "invitation_code", invitation_code)
        if max_student_count and not isinstance(max_student_count, float):
            raise TypeError("Expected argument 'max_student_count' to be a float")
        pulumi.set(__self__, "max_student_count", max_student_count)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if system_data and not isinstance(system_data, dict):
            raise TypeError("Expected argument 'system_data' to be a dict")
        pulumi.set(__self__, "system_data", system_data)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)
        if value and not isinstance(value, float):
            raise TypeError("Expected argument 'value' to be a float")
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter(name="budgetPerStudent")
    def budget_per_student(self) -> 'outputs.AmountResponse':
        """
        Default monetary cap for each student in this lab
        """
        return pulumi.get(self, "budget_per_student")

    @property
    @pulumi.getter
    def currency(self) -> Optional[str]:
        """
        The type of currency being used for the value.
        """
        return pulumi.get(self, "currency")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Detail description of this lab
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        Lab Display Name
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="effectiveDate")
    def effective_date(self) -> str:
        """
        Lab creation date
        """
        return pulumi.get(self, "effective_date")

    @property
    @pulumi.getter(name="expirationDate")
    def expiration_date(self) -> str:
        """
        Default expiration date for each student in this lab
        """
        return pulumi.get(self, "expiration_date")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="invitationCode")
    def invitation_code(self) -> str:
        """
        invitation code for redeemable lab
        """
        return pulumi.get(self, "invitation_code")

    @property
    @pulumi.getter(name="maxStudentCount")
    def max_student_count(self) -> float:
        """
        the total number of students that can be accepted to the lab.
        """
        return pulumi.get(self, "max_student_count")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of this lab
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="systemData")
    def system_data(self) -> 'outputs.SystemDataResponse':
        """
        Azure Resource Manager metadata containing createdBy and modifiedBy information.
        """
        return pulumi.get(self, "system_data")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def value(self) -> Optional[float]:
        """
        Amount value.
        """
        return pulumi.get(self, "value")


class AwaitableGetGetLabResult(GetGetLabResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetGetLabResult(
            budget_per_student=self.budget_per_student,
            currency=self.currency,
            description=self.description,
            display_name=self.display_name,
            effective_date=self.effective_date,
            expiration_date=self.expiration_date,
            id=self.id,
            invitation_code=self.invitation_code,
            max_student_count=self.max_student_count,
            name=self.name,
            status=self.status,
            system_data=self.system_data,
            type=self.type,
            value=self.value)


def get_get_lab(billing_account_name: Optional[str] = None,
                billing_profile_name: Optional[str] = None,
                include_budget: Optional[bool] = None,
                invoice_section_name: Optional[str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetGetLabResult:
    """
    Lab details.
    API Version: 2021-12-01-preview.


    :param str billing_account_name: Billing account name.
    :param str billing_profile_name: Billing profile name.
    :param bool include_budget: May be used to include budget information.
    :param str invoice_section_name: Invoice section name.
    """
    __args__ = dict()
    __args__['billingAccountName'] = billing_account_name
    __args__['billingProfileName'] = billing_profile_name
    __args__['includeBudget'] = include_budget
    __args__['invoiceSectionName'] = invoice_section_name
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('azure-native:education:getGetLab', __args__, opts=opts, typ=GetGetLabResult).value

    return AwaitableGetGetLabResult(
        budget_per_student=__ret__.budget_per_student,
        currency=__ret__.currency,
        description=__ret__.description,
        display_name=__ret__.display_name,
        effective_date=__ret__.effective_date,
        expiration_date=__ret__.expiration_date,
        id=__ret__.id,
        invitation_code=__ret__.invitation_code,
        max_student_count=__ret__.max_student_count,
        name=__ret__.name,
        status=__ret__.status,
        system_data=__ret__.system_data,
        type=__ret__.type,
        value=__ret__.value)


@_utilities.lift_output_func(get_get_lab)
def get_get_lab_output(billing_account_name: Optional[pulumi.Input[str]] = None,
                       billing_profile_name: Optional[pulumi.Input[str]] = None,
                       include_budget: Optional[pulumi.Input[Optional[bool]]] = None,
                       invoice_section_name: Optional[pulumi.Input[str]] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetGetLabResult]:
    """
    Lab details.
    API Version: 2021-12-01-preview.


    :param str billing_account_name: Billing account name.
    :param str billing_profile_name: Billing profile name.
    :param bool include_budget: May be used to include budget information.
    :param str invoice_section_name: Invoice section name.
    """
    ...
