# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'ListEndpointManagedProxyDetailsResult',
    'AwaitableListEndpointManagedProxyDetailsResult',
    'list_endpoint_managed_proxy_details',
    'list_endpoint_managed_proxy_details_output',
]

@pulumi.output_type
class ListEndpointManagedProxyDetailsResult:
    """
    Managed Proxy
    """
    def __init__(__self__, expires_on=None, proxy=None):
        if expires_on and not isinstance(expires_on, float):
            raise TypeError("Expected argument 'expires_on' to be a float")
        pulumi.set(__self__, "expires_on", expires_on)
        if proxy and not isinstance(proxy, str):
            raise TypeError("Expected argument 'proxy' to be a str")
        pulumi.set(__self__, "proxy", proxy)

    @property
    @pulumi.getter(name="expiresOn")
    def expires_on(self) -> float:
        """
        The expiration time of short lived proxy name in unix epoch.
        """
        return pulumi.get(self, "expires_on")

    @property
    @pulumi.getter
    def proxy(self) -> str:
        """
        The short lived proxy name.
        """
        return pulumi.get(self, "proxy")


class AwaitableListEndpointManagedProxyDetailsResult(ListEndpointManagedProxyDetailsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return ListEndpointManagedProxyDetailsResult(
            expires_on=self.expires_on,
            proxy=self.proxy)


def list_endpoint_managed_proxy_details(endpoint_name: Optional[str] = None,
                                        hostname: Optional[str] = None,
                                        resource_uri: Optional[str] = None,
                                        service: Optional[str] = None,
                                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableListEndpointManagedProxyDetailsResult:
    """
    Managed Proxy
    API Version: 2022-05-01-preview.


    :param str endpoint_name: The endpoint name.
    :param str hostname: The target host name.
    :param str resource_uri: The fully qualified Azure Resource manager identifier of the resource to be connected.
    :param str service: The name of the service.
    """
    __args__ = dict()
    __args__['endpointName'] = endpoint_name
    __args__['hostname'] = hostname
    __args__['resourceUri'] = resource_uri
    __args__['service'] = service
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('azure-native:hybridconnectivity:listEndpointManagedProxyDetails', __args__, opts=opts, typ=ListEndpointManagedProxyDetailsResult).value

    return AwaitableListEndpointManagedProxyDetailsResult(
        expires_on=__ret__.expires_on,
        proxy=__ret__.proxy)


@_utilities.lift_output_func(list_endpoint_managed_proxy_details)
def list_endpoint_managed_proxy_details_output(endpoint_name: Optional[pulumi.Input[str]] = None,
                                               hostname: Optional[pulumi.Input[Optional[str]]] = None,
                                               resource_uri: Optional[pulumi.Input[str]] = None,
                                               service: Optional[pulumi.Input[str]] = None,
                                               opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[ListEndpointManagedProxyDetailsResult]:
    """
    Managed Proxy
    API Version: 2022-05-01-preview.


    :param str endpoint_name: The endpoint name.
    :param str hostname: The target host name.
    :param str resource_uri: The fully qualified Azure Resource manager identifier of the resource to be connected.
    :param str service: The name of the service.
    """
    ...
