# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'AzureActiveDirectoryAppResponse',
    'BackupFileInfoResponse',
    'BackupSetInfoResponse',
    'BlobShareResponse',
    'ConnectToSourcePostgreSqlSyncTaskInputResponse',
    'ConnectToSourcePostgreSqlSyncTaskOutputResponse',
    'ConnectToSourcePostgreSqlSyncTaskPropertiesResponse',
    'ConnectToSourceSqlServerSyncTaskPropertiesResponse',
    'ConnectToSourceSqlServerTaskInputResponse',
    'ConnectToSourceSqlServerTaskOutputAgentJobLevelResponse',
    'ConnectToSourceSqlServerTaskOutputDatabaseLevelResponse',
    'ConnectToSourceSqlServerTaskOutputLoginLevelResponse',
    'ConnectToSourceSqlServerTaskOutputTaskLevelResponse',
    'ConnectToSourceSqlServerTaskPropertiesResponse',
    'ConnectToTargetAzureDbForMySqlTaskInputResponse',
    'ConnectToTargetAzureDbForMySqlTaskOutputResponse',
    'ConnectToTargetAzureDbForMySqlTaskPropertiesResponse',
    'ConnectToTargetAzureDbForPostgreSqlSyncTaskInputResponse',
    'ConnectToTargetAzureDbForPostgreSqlSyncTaskOutputResponse',
    'ConnectToTargetAzureDbForPostgreSqlSyncTaskPropertiesResponse',
    'ConnectToTargetSqlDbTaskInputResponse',
    'ConnectToTargetSqlDbTaskOutputResponse',
    'ConnectToTargetSqlDbTaskPropertiesResponse',
    'ConnectToTargetSqlMISyncTaskInputResponse',
    'ConnectToTargetSqlMISyncTaskOutputResponse',
    'ConnectToTargetSqlMISyncTaskPropertiesResponse',
    'ConnectToTargetSqlMITaskInputResponse',
    'ConnectToTargetSqlMITaskOutputResponse',
    'ConnectToTargetSqlMITaskPropertiesResponse',
    'ConnectToTargetSqlSqlDbSyncTaskInputResponse',
    'ConnectToTargetSqlSqlDbSyncTaskPropertiesResponse',
    'CopyProgressDetailsResponse',
    'DataIntegrityValidationResultResponse',
    'DataItemMigrationSummaryResultResponse',
    'DatabaseBackupInfoResponse',
    'DatabaseFileInfoResponse',
    'DatabaseInfoResponse',
    'DatabaseMigrationPropertiesSqlDbResponse',
    'DatabaseSummaryResultResponse',
    'DatabaseTableResponse',
    'ErrorInfoResponse',
    'ExecutionStatisticsResponse',
    'FileShareResponse',
    'GetTdeCertificatesSqlTaskInputResponse',
    'GetTdeCertificatesSqlTaskOutputResponse',
    'GetTdeCertificatesSqlTaskPropertiesResponse',
    'GetUserTablesSqlSyncTaskInputResponse',
    'GetUserTablesSqlSyncTaskOutputResponse',
    'GetUserTablesSqlSyncTaskPropertiesResponse',
    'GetUserTablesSqlTaskInputResponse',
    'GetUserTablesSqlTaskOutputResponse',
    'GetUserTablesSqlTaskPropertiesResponse',
    'MiSqlConnectionInfoResponse',
    'MigrateMISyncCompleteCommandInputResponse',
    'MigrateMISyncCompleteCommandOutputResponse',
    'MigrateMISyncCompleteCommandPropertiesResponse',
    'MigrateMySqlAzureDbForMySqlSyncDatabaseInputResponse',
    'MigrateMySqlAzureDbForMySqlSyncTaskInputResponse',
    'MigrateMySqlAzureDbForMySqlSyncTaskOutputDatabaseErrorResponse',
    'MigrateMySqlAzureDbForMySqlSyncTaskOutputDatabaseLevelResponse',
    'MigrateMySqlAzureDbForMySqlSyncTaskOutputErrorResponse',
    'MigrateMySqlAzureDbForMySqlSyncTaskOutputMigrationLevelResponse',
    'MigrateMySqlAzureDbForMySqlSyncTaskOutputTableLevelResponse',
    'MigrateMySqlAzureDbForMySqlSyncTaskPropertiesResponse',
    'MigratePostgreSqlAzureDbForPostgreSqlSyncDatabaseInputResponse',
    'MigratePostgreSqlAzureDbForPostgreSqlSyncTaskInputResponse',
    'MigratePostgreSqlAzureDbForPostgreSqlSyncTaskOutputDatabaseErrorResponse',
    'MigratePostgreSqlAzureDbForPostgreSqlSyncTaskOutputDatabaseLevelResponse',
    'MigratePostgreSqlAzureDbForPostgreSqlSyncTaskOutputErrorResponse',
    'MigratePostgreSqlAzureDbForPostgreSqlSyncTaskOutputMigrationLevelResponse',
    'MigratePostgreSqlAzureDbForPostgreSqlSyncTaskOutputTableLevelResponse',
    'MigratePostgreSqlAzureDbForPostgreSqlSyncTaskPropertiesResponse',
    'MigrateSqlServerSqlDbDatabaseInputResponse',
    'MigrateSqlServerSqlDbSyncDatabaseInputResponse',
    'MigrateSqlServerSqlDbSyncTaskInputResponse',
    'MigrateSqlServerSqlDbSyncTaskOutputDatabaseErrorResponse',
    'MigrateSqlServerSqlDbSyncTaskOutputDatabaseLevelResponse',
    'MigrateSqlServerSqlDbSyncTaskOutputErrorResponse',
    'MigrateSqlServerSqlDbSyncTaskOutputMigrationLevelResponse',
    'MigrateSqlServerSqlDbSyncTaskOutputTableLevelResponse',
    'MigrateSqlServerSqlDbSyncTaskPropertiesResponse',
    'MigrateSqlServerSqlDbTaskInputResponse',
    'MigrateSqlServerSqlDbTaskOutputDatabaseLevelResponse',
    'MigrateSqlServerSqlDbTaskOutputDatabaseLevelValidationResultResponse',
    'MigrateSqlServerSqlDbTaskOutputErrorResponse',
    'MigrateSqlServerSqlDbTaskOutputMigrationLevelResponse',
    'MigrateSqlServerSqlDbTaskOutputTableLevelResponse',
    'MigrateSqlServerSqlDbTaskOutputValidationResultResponse',
    'MigrateSqlServerSqlDbTaskPropertiesResponse',
    'MigrateSqlServerSqlMIDatabaseInputResponse',
    'MigrateSqlServerSqlMISyncTaskInputResponse',
    'MigrateSqlServerSqlMISyncTaskOutputDatabaseLevelResponse',
    'MigrateSqlServerSqlMISyncTaskOutputErrorResponse',
    'MigrateSqlServerSqlMISyncTaskOutputMigrationLevelResponse',
    'MigrateSqlServerSqlMISyncTaskPropertiesResponse',
    'MigrateSqlServerSqlMITaskInputResponse',
    'MigrateSqlServerSqlMITaskOutputAgentJobLevelResponse',
    'MigrateSqlServerSqlMITaskOutputDatabaseLevelResponse',
    'MigrateSqlServerSqlMITaskOutputErrorResponse',
    'MigrateSqlServerSqlMITaskOutputLoginLevelResponse',
    'MigrateSqlServerSqlMITaskOutputMigrationLevelResponse',
    'MigrateSqlServerSqlMITaskPropertiesResponse',
    'MigrateSyncCompleteCommandInputResponse',
    'MigrateSyncCompleteCommandOutputResponse',
    'MigrateSyncCompleteCommandPropertiesResponse',
    'MigrationEligibilityInfoResponse',
    'MigrationReportResultResponse',
    'MigrationValidationDatabaseSummaryResultResponse',
    'MigrationValidationOptionsResponse',
    'MySqlConnectionInfoResponse',
    'NodeMonitoringDataResponse',
    'ODataErrorResponse',
    'OrphanedUserInfoResponse',
    'PostgreSqlConnectionInfoResponse',
    'ProjectFilePropertiesResponse',
    'QueryAnalysisValidationResultResponse',
    'QueryExecutionResultResponse',
    'ReportableExceptionResponse',
    'SchemaComparisonValidationResultResponse',
    'SchemaComparisonValidationResultTypeResponse',
    'SelectedCertificateInputResponse',
    'ServiceSkuResponse',
    'SqlConnectionInfoResponse',
    'SqlConnectionInformationResponse',
    'SqlDbMigrationStatusDetailsResponse',
    'SqlDbOfflineConfigurationResponse',
    'StartMigrationScenarioServerRoleResultResponse',
    'SyncMigrationDatabaseErrorEventResponse',
    'SystemDataResponse',
    'ValidateMigrationInputSqlServerSqlDbSyncTaskPropertiesResponse',
    'ValidateMigrationInputSqlServerSqlMISyncTaskInputResponse',
    'ValidateMigrationInputSqlServerSqlMISyncTaskOutputResponse',
    'ValidateMigrationInputSqlServerSqlMISyncTaskPropertiesResponse',
    'ValidateMigrationInputSqlServerSqlMITaskInputResponse',
    'ValidateMigrationInputSqlServerSqlMITaskOutputResponse',
    'ValidateMigrationInputSqlServerSqlMITaskPropertiesResponse',
    'ValidateSyncMigrationInputSqlServerTaskInputResponse',
    'ValidateSyncMigrationInputSqlServerTaskOutputResponse',
    'ValidationErrorResponse',
    'WaitStatisticsResponse',
]

@pulumi.output_type
class AzureActiveDirectoryAppResponse(dict):
    """
    Azure Active Directory Application
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "appKey":
            suggest = "app_key"
        elif key == "applicationId":
            suggest = "application_id"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureActiveDirectoryAppResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureActiveDirectoryAppResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureActiveDirectoryAppResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 app_key: str,
                 application_id: str,
                 tenant_id: str):
        """
        Azure Active Directory Application
        :param str app_key: Key used to authenticate to the Azure Active Directory Application
        :param str application_id: Application ID of the Azure Active Directory Application
        :param str tenant_id: Tenant id of the customer
        """
        pulumi.set(__self__, "app_key", app_key)
        pulumi.set(__self__, "application_id", application_id)
        pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter(name="appKey")
    def app_key(self) -> str:
        """
        Key used to authenticate to the Azure Active Directory Application
        """
        return pulumi.get(self, "app_key")

    @property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> str:
        """
        Application ID of the Azure Active Directory Application
        """
        return pulumi.get(self, "application_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> str:
        """
        Tenant id of the customer
        """
        return pulumi.get(self, "tenant_id")


@pulumi.output_type
class BackupFileInfoResponse(dict):
    """
    Information of the backup file
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "familySequenceNumber":
            suggest = "family_sequence_number"
        elif key == "fileLocation":
            suggest = "file_location"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BackupFileInfoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BackupFileInfoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BackupFileInfoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 family_sequence_number: Optional[int] = None,
                 file_location: Optional[str] = None,
                 status: Optional[str] = None):
        """
        Information of the backup file
        :param int family_sequence_number: Sequence number of the backup file in the backup set
        :param str file_location: Location of the backup file in shared folder
        :param str status: Status of the backup file during migration
        """
        if family_sequence_number is not None:
            pulumi.set(__self__, "family_sequence_number", family_sequence_number)
        if file_location is not None:
            pulumi.set(__self__, "file_location", file_location)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="familySequenceNumber")
    def family_sequence_number(self) -> Optional[int]:
        """
        Sequence number of the backup file in the backup set
        """
        return pulumi.get(self, "family_sequence_number")

    @property
    @pulumi.getter(name="fileLocation")
    def file_location(self) -> Optional[str]:
        """
        Location of the backup file in shared folder
        """
        return pulumi.get(self, "file_location")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        Status of the backup file during migration
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class BackupSetInfoResponse(dict):
    """
    Information of backup set
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backupFinishedDate":
            suggest = "backup_finished_date"
        elif key == "backupSetId":
            suggest = "backup_set_id"
        elif key == "backupStartDate":
            suggest = "backup_start_date"
        elif key == "backupType":
            suggest = "backup_type"
        elif key == "databaseName":
            suggest = "database_name"
        elif key == "firstLsn":
            suggest = "first_lsn"
        elif key == "isBackupRestored":
            suggest = "is_backup_restored"
        elif key == "lastLsn":
            suggest = "last_lsn"
        elif key == "lastModifiedTime":
            suggest = "last_modified_time"
        elif key == "listOfBackupFiles":
            suggest = "list_of_backup_files"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BackupSetInfoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BackupSetInfoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BackupSetInfoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backup_finished_date: Optional[str] = None,
                 backup_set_id: Optional[str] = None,
                 backup_start_date: Optional[str] = None,
                 backup_type: Optional[str] = None,
                 database_name: Optional[str] = None,
                 first_lsn: Optional[str] = None,
                 is_backup_restored: Optional[bool] = None,
                 last_lsn: Optional[str] = None,
                 last_modified_time: Optional[str] = None,
                 list_of_backup_files: Optional[Sequence['outputs.BackupFileInfoResponse']] = None):
        """
        Information of backup set
        :param str backup_finished_date: Date and time that the backup operation finished
        :param str backup_set_id: Id for the set of backup files
        :param str backup_start_date: Date and time that the backup operation began
        :param str backup_type: Enum of the different backup types
        :param str database_name: Name of the database to which the backup set belongs
        :param str first_lsn: First log sequence number of the backup file
        :param bool is_backup_restored: Whether the backup set is restored or not
        :param str last_lsn: Last log sequence number of the backup file
        :param str last_modified_time: Last modified time of the backup file in share location
        :param Sequence['BackupFileInfoResponse'] list_of_backup_files: List of files in the backup set
        """
        if backup_finished_date is not None:
            pulumi.set(__self__, "backup_finished_date", backup_finished_date)
        if backup_set_id is not None:
            pulumi.set(__self__, "backup_set_id", backup_set_id)
        if backup_start_date is not None:
            pulumi.set(__self__, "backup_start_date", backup_start_date)
        if backup_type is not None:
            pulumi.set(__self__, "backup_type", backup_type)
        if database_name is not None:
            pulumi.set(__self__, "database_name", database_name)
        if first_lsn is not None:
            pulumi.set(__self__, "first_lsn", first_lsn)
        if is_backup_restored is not None:
            pulumi.set(__self__, "is_backup_restored", is_backup_restored)
        if last_lsn is not None:
            pulumi.set(__self__, "last_lsn", last_lsn)
        if last_modified_time is not None:
            pulumi.set(__self__, "last_modified_time", last_modified_time)
        if list_of_backup_files is not None:
            pulumi.set(__self__, "list_of_backup_files", list_of_backup_files)

    @property
    @pulumi.getter(name="backupFinishedDate")
    def backup_finished_date(self) -> Optional[str]:
        """
        Date and time that the backup operation finished
        """
        return pulumi.get(self, "backup_finished_date")

    @property
    @pulumi.getter(name="backupSetId")
    def backup_set_id(self) -> Optional[str]:
        """
        Id for the set of backup files
        """
        return pulumi.get(self, "backup_set_id")

    @property
    @pulumi.getter(name="backupStartDate")
    def backup_start_date(self) -> Optional[str]:
        """
        Date and time that the backup operation began
        """
        return pulumi.get(self, "backup_start_date")

    @property
    @pulumi.getter(name="backupType")
    def backup_type(self) -> Optional[str]:
        """
        Enum of the different backup types
        """
        return pulumi.get(self, "backup_type")

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> Optional[str]:
        """
        Name of the database to which the backup set belongs
        """
        return pulumi.get(self, "database_name")

    @property
    @pulumi.getter(name="firstLsn")
    def first_lsn(self) -> Optional[str]:
        """
        First log sequence number of the backup file
        """
        return pulumi.get(self, "first_lsn")

    @property
    @pulumi.getter(name="isBackupRestored")
    def is_backup_restored(self) -> Optional[bool]:
        """
        Whether the backup set is restored or not
        """
        return pulumi.get(self, "is_backup_restored")

    @property
    @pulumi.getter(name="lastLsn")
    def last_lsn(self) -> Optional[str]:
        """
        Last log sequence number of the backup file
        """
        return pulumi.get(self, "last_lsn")

    @property
    @pulumi.getter(name="lastModifiedTime")
    def last_modified_time(self) -> Optional[str]:
        """
        Last modified time of the backup file in share location
        """
        return pulumi.get(self, "last_modified_time")

    @property
    @pulumi.getter(name="listOfBackupFiles")
    def list_of_backup_files(self) -> Optional[Sequence['outputs.BackupFileInfoResponse']]:
        """
        List of files in the backup set
        """
        return pulumi.get(self, "list_of_backup_files")


@pulumi.output_type
class BlobShareResponse(dict):
    """
    Blob container storage information.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sasUri":
            suggest = "sas_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BlobShareResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BlobShareResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BlobShareResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 sas_uri: str):
        """
        Blob container storage information.
        :param str sas_uri: SAS URI of Azure Storage Account Container.
        """
        pulumi.set(__self__, "sas_uri", sas_uri)

    @property
    @pulumi.getter(name="sasUri")
    def sas_uri(self) -> str:
        """
        SAS URI of Azure Storage Account Container.
        """
        return pulumi.get(self, "sas_uri")


@pulumi.output_type
class ConnectToSourcePostgreSqlSyncTaskInputResponse(dict):
    """
    Input for the task that validates connection to PostgreSQL and source server requirements
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceConnectionInfo":
            suggest = "source_connection_info"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectToSourcePostgreSqlSyncTaskInputResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectToSourcePostgreSqlSyncTaskInputResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectToSourcePostgreSqlSyncTaskInputResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 source_connection_info: 'outputs.PostgreSqlConnectionInfoResponse'):
        """
        Input for the task that validates connection to PostgreSQL and source server requirements
        :param 'PostgreSqlConnectionInfoResponse' source_connection_info: Connection information for source PostgreSQL server
        """
        pulumi.set(__self__, "source_connection_info", source_connection_info)

    @property
    @pulumi.getter(name="sourceConnectionInfo")
    def source_connection_info(self) -> 'outputs.PostgreSqlConnectionInfoResponse':
        """
        Connection information for source PostgreSQL server
        """
        return pulumi.get(self, "source_connection_info")


@pulumi.output_type
class ConnectToSourcePostgreSqlSyncTaskOutputResponse(dict):
    """
    Output for the task that validates connection to PostgreSQL and source server requirements
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceServerBrandVersion":
            suggest = "source_server_brand_version"
        elif key == "sourceServerVersion":
            suggest = "source_server_version"
        elif key == "validationErrors":
            suggest = "validation_errors"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectToSourcePostgreSqlSyncTaskOutputResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectToSourcePostgreSqlSyncTaskOutputResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectToSourcePostgreSqlSyncTaskOutputResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 databases: Sequence[str],
                 id: str,
                 source_server_brand_version: str,
                 source_server_version: str,
                 validation_errors: Sequence['outputs.ReportableExceptionResponse']):
        """
        Output for the task that validates connection to PostgreSQL and source server requirements
        :param Sequence[str] databases: List of databases on source server
        :param str id: Result identifier
        :param str source_server_brand_version: Source server brand version
        :param str source_server_version: Version of the source server
        :param Sequence['ReportableExceptionResponse'] validation_errors: Validation errors associated with the task
        """
        pulumi.set(__self__, "databases", databases)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "source_server_brand_version", source_server_brand_version)
        pulumi.set(__self__, "source_server_version", source_server_version)
        pulumi.set(__self__, "validation_errors", validation_errors)

    @property
    @pulumi.getter
    def databases(self) -> Sequence[str]:
        """
        List of databases on source server
        """
        return pulumi.get(self, "databases")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Result identifier
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="sourceServerBrandVersion")
    def source_server_brand_version(self) -> str:
        """
        Source server brand version
        """
        return pulumi.get(self, "source_server_brand_version")

    @property
    @pulumi.getter(name="sourceServerVersion")
    def source_server_version(self) -> str:
        """
        Version of the source server
        """
        return pulumi.get(self, "source_server_version")

    @property
    @pulumi.getter(name="validationErrors")
    def validation_errors(self) -> Sequence['outputs.ReportableExceptionResponse']:
        """
        Validation errors associated with the task
        """
        return pulumi.get(self, "validation_errors")


@pulumi.output_type
class ConnectToSourcePostgreSqlSyncTaskPropertiesResponse(dict):
    """
    Properties for the task that validates connection to PostgreSQL server and source server requirements for online migration
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "taskType":
            suggest = "task_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectToSourcePostgreSqlSyncTaskPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectToSourcePostgreSqlSyncTaskPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectToSourcePostgreSqlSyncTaskPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 commands: Sequence[Any],
                 errors: Sequence['outputs.ODataErrorResponse'],
                 output: Sequence['outputs.ConnectToSourcePostgreSqlSyncTaskOutputResponse'],
                 state: str,
                 task_type: str,
                 input: Optional['outputs.ConnectToSourcePostgreSqlSyncTaskInputResponse'] = None):
        """
        Properties for the task that validates connection to PostgreSQL server and source server requirements for online migration
        :param Sequence[Union['MigrateMISyncCompleteCommandPropertiesResponse', 'MigrateSyncCompleteCommandPropertiesResponse']] commands: Array of command properties.
        :param Sequence['ODataErrorResponse'] errors: Array of errors. This is ignored if submitted.
        :param Sequence['ConnectToSourcePostgreSqlSyncTaskOutputResponse'] output: Task output. This is ignored if submitted.
        :param str state: The state of the task. This is ignored if submitted.
        :param str task_type: Task type.
               Expected value is 'ConnectToSource.PostgreSql.Sync'.
        :param 'ConnectToSourcePostgreSqlSyncTaskInputResponse' input: Task input
        """
        pulumi.set(__self__, "commands", commands)
        pulumi.set(__self__, "errors", errors)
        pulumi.set(__self__, "output", output)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "task_type", 'ConnectToSource.PostgreSql.Sync')
        if input is not None:
            pulumi.set(__self__, "input", input)

    @property
    @pulumi.getter
    def commands(self) -> Sequence[Any]:
        """
        Array of command properties.
        """
        return pulumi.get(self, "commands")

    @property
    @pulumi.getter
    def errors(self) -> Sequence['outputs.ODataErrorResponse']:
        """
        Array of errors. This is ignored if submitted.
        """
        return pulumi.get(self, "errors")

    @property
    @pulumi.getter
    def output(self) -> Sequence['outputs.ConnectToSourcePostgreSqlSyncTaskOutputResponse']:
        """
        Task output. This is ignored if submitted.
        """
        return pulumi.get(self, "output")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The state of the task. This is ignored if submitted.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="taskType")
    def task_type(self) -> str:
        """
        Task type.
        Expected value is 'ConnectToSource.PostgreSql.Sync'.
        """
        return pulumi.get(self, "task_type")

    @property
    @pulumi.getter
    def input(self) -> Optional['outputs.ConnectToSourcePostgreSqlSyncTaskInputResponse']:
        """
        Task input
        """
        return pulumi.get(self, "input")


@pulumi.output_type
class ConnectToSourceSqlServerSyncTaskPropertiesResponse(dict):
    """
    Properties for the task that validates connection to SQL Server and source server requirements for online migration
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "taskType":
            suggest = "task_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectToSourceSqlServerSyncTaskPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectToSourceSqlServerSyncTaskPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectToSourceSqlServerSyncTaskPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 commands: Sequence[Any],
                 errors: Sequence['outputs.ODataErrorResponse'],
                 output: Sequence[Any],
                 state: str,
                 task_type: str,
                 input: Optional['outputs.ConnectToSourceSqlServerTaskInputResponse'] = None):
        """
        Properties for the task that validates connection to SQL Server and source server requirements for online migration
        :param Sequence[Union['MigrateMISyncCompleteCommandPropertiesResponse', 'MigrateSyncCompleteCommandPropertiesResponse']] commands: Array of command properties.
        :param Sequence['ODataErrorResponse'] errors: Array of errors. This is ignored if submitted.
        :param Sequence[Union['ConnectToSourceSqlServerTaskOutputAgentJobLevelResponse', 'ConnectToSourceSqlServerTaskOutputDatabaseLevelResponse', 'ConnectToSourceSqlServerTaskOutputLoginLevelResponse', 'ConnectToSourceSqlServerTaskOutputTaskLevelResponse']] output: Task output. This is ignored if submitted.
        :param str state: The state of the task. This is ignored if submitted.
        :param str task_type: Task type.
               Expected value is 'ConnectToSource.SqlServer.Sync'.
        :param 'ConnectToSourceSqlServerTaskInputResponse' input: Task input
        """
        pulumi.set(__self__, "commands", commands)
        pulumi.set(__self__, "errors", errors)
        pulumi.set(__self__, "output", output)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "task_type", 'ConnectToSource.SqlServer.Sync')
        if input is not None:
            pulumi.set(__self__, "input", input)

    @property
    @pulumi.getter
    def commands(self) -> Sequence[Any]:
        """
        Array of command properties.
        """
        return pulumi.get(self, "commands")

    @property
    @pulumi.getter
    def errors(self) -> Sequence['outputs.ODataErrorResponse']:
        """
        Array of errors. This is ignored if submitted.
        """
        return pulumi.get(self, "errors")

    @property
    @pulumi.getter
    def output(self) -> Sequence[Any]:
        """
        Task output. This is ignored if submitted.
        """
        return pulumi.get(self, "output")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The state of the task. This is ignored if submitted.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="taskType")
    def task_type(self) -> str:
        """
        Task type.
        Expected value is 'ConnectToSource.SqlServer.Sync'.
        """
        return pulumi.get(self, "task_type")

    @property
    @pulumi.getter
    def input(self) -> Optional['outputs.ConnectToSourceSqlServerTaskInputResponse']:
        """
        Task input
        """
        return pulumi.get(self, "input")


@pulumi.output_type
class ConnectToSourceSqlServerTaskInputResponse(dict):
    """
    Input for the task that validates connection to SQL Server and also validates source server requirements
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceConnectionInfo":
            suggest = "source_connection_info"
        elif key == "checkPermissionsGroup":
            suggest = "check_permissions_group"
        elif key == "collectAgentJobs":
            suggest = "collect_agent_jobs"
        elif key == "collectLogins":
            suggest = "collect_logins"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectToSourceSqlServerTaskInputResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectToSourceSqlServerTaskInputResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectToSourceSqlServerTaskInputResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 source_connection_info: 'outputs.SqlConnectionInfoResponse',
                 check_permissions_group: Optional[str] = None,
                 collect_agent_jobs: Optional[bool] = None,
                 collect_logins: Optional[bool] = None):
        """
        Input for the task that validates connection to SQL Server and also validates source server requirements
        :param 'SqlConnectionInfoResponse' source_connection_info: Connection information for Source SQL Server
        :param str check_permissions_group: Permission group for validations
        :param bool collect_agent_jobs: Flag for whether to collect agent jobs from source server.
        :param bool collect_logins: Flag for whether to collect logins from source server.
        """
        pulumi.set(__self__, "source_connection_info", source_connection_info)
        if check_permissions_group is not None:
            pulumi.set(__self__, "check_permissions_group", check_permissions_group)
        if collect_agent_jobs is None:
            collect_agent_jobs = False
        if collect_agent_jobs is not None:
            pulumi.set(__self__, "collect_agent_jobs", collect_agent_jobs)
        if collect_logins is None:
            collect_logins = False
        if collect_logins is not None:
            pulumi.set(__self__, "collect_logins", collect_logins)

    @property
    @pulumi.getter(name="sourceConnectionInfo")
    def source_connection_info(self) -> 'outputs.SqlConnectionInfoResponse':
        """
        Connection information for Source SQL Server
        """
        return pulumi.get(self, "source_connection_info")

    @property
    @pulumi.getter(name="checkPermissionsGroup")
    def check_permissions_group(self) -> Optional[str]:
        """
        Permission group for validations
        """
        return pulumi.get(self, "check_permissions_group")

    @property
    @pulumi.getter(name="collectAgentJobs")
    def collect_agent_jobs(self) -> Optional[bool]:
        """
        Flag for whether to collect agent jobs from source server.
        """
        return pulumi.get(self, "collect_agent_jobs")

    @property
    @pulumi.getter(name="collectLogins")
    def collect_logins(self) -> Optional[bool]:
        """
        Flag for whether to collect logins from source server.
        """
        return pulumi.get(self, "collect_logins")


@pulumi.output_type
class ConnectToSourceSqlServerTaskOutputAgentJobLevelResponse(dict):
    """
    AgentJob level output for the task that validates connection to SQL Server and also validates source server requirements
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isEnabled":
            suggest = "is_enabled"
        elif key == "jobCategory":
            suggest = "job_category"
        elif key == "jobOwner":
            suggest = "job_owner"
        elif key == "lastExecutedOn":
            suggest = "last_executed_on"
        elif key == "migrationEligibility":
            suggest = "migration_eligibility"
        elif key == "resultType":
            suggest = "result_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectToSourceSqlServerTaskOutputAgentJobLevelResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectToSourceSqlServerTaskOutputAgentJobLevelResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectToSourceSqlServerTaskOutputAgentJobLevelResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: str,
                 is_enabled: bool,
                 job_category: str,
                 job_owner: str,
                 last_executed_on: str,
                 migration_eligibility: 'outputs.MigrationEligibilityInfoResponse',
                 name: str,
                 result_type: str):
        """
        AgentJob level output for the task that validates connection to SQL Server and also validates source server requirements
        :param str id: Result identifier
        :param bool is_enabled: The state of the original AgentJob.
        :param str job_category: The type of AgentJob.
        :param str job_owner: The owner of the AgentJob
        :param str last_executed_on: UTC Date and time when the AgentJob was last executed.
        :param 'MigrationEligibilityInfoResponse' migration_eligibility: Information about eligibility of agent job for migration.
        :param str name: AgentJob name
        :param str result_type: Type of result - database level or task level
               Expected value is 'AgentJobLevelOutput'.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "is_enabled", is_enabled)
        pulumi.set(__self__, "job_category", job_category)
        pulumi.set(__self__, "job_owner", job_owner)
        pulumi.set(__self__, "last_executed_on", last_executed_on)
        pulumi.set(__self__, "migration_eligibility", migration_eligibility)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "result_type", 'AgentJobLevelOutput')

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Result identifier
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> bool:
        """
        The state of the original AgentJob.
        """
        return pulumi.get(self, "is_enabled")

    @property
    @pulumi.getter(name="jobCategory")
    def job_category(self) -> str:
        """
        The type of AgentJob.
        """
        return pulumi.get(self, "job_category")

    @property
    @pulumi.getter(name="jobOwner")
    def job_owner(self) -> str:
        """
        The owner of the AgentJob
        """
        return pulumi.get(self, "job_owner")

    @property
    @pulumi.getter(name="lastExecutedOn")
    def last_executed_on(self) -> str:
        """
        UTC Date and time when the AgentJob was last executed.
        """
        return pulumi.get(self, "last_executed_on")

    @property
    @pulumi.getter(name="migrationEligibility")
    def migration_eligibility(self) -> 'outputs.MigrationEligibilityInfoResponse':
        """
        Information about eligibility of agent job for migration.
        """
        return pulumi.get(self, "migration_eligibility")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        AgentJob name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="resultType")
    def result_type(self) -> str:
        """
        Type of result - database level or task level
        Expected value is 'AgentJobLevelOutput'.
        """
        return pulumi.get(self, "result_type")


@pulumi.output_type
class ConnectToSourceSqlServerTaskOutputDatabaseLevelResponse(dict):
    """
    Database level output for the task that validates connection to SQL Server and also validates source server requirements
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "compatibilityLevel":
            suggest = "compatibility_level"
        elif key == "databaseFiles":
            suggest = "database_files"
        elif key == "databaseState":
            suggest = "database_state"
        elif key == "resultType":
            suggest = "result_type"
        elif key == "sizeMB":
            suggest = "size_mb"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectToSourceSqlServerTaskOutputDatabaseLevelResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectToSourceSqlServerTaskOutputDatabaseLevelResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectToSourceSqlServerTaskOutputDatabaseLevelResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 compatibility_level: str,
                 database_files: Sequence['outputs.DatabaseFileInfoResponse'],
                 database_state: str,
                 id: str,
                 name: str,
                 result_type: str,
                 size_mb: float):
        """
        Database level output for the task that validates connection to SQL Server and also validates source server requirements
        :param str compatibility_level: SQL Server compatibility level of database
        :param Sequence['DatabaseFileInfoResponse'] database_files: The list of database files
        :param str database_state: State of the database
        :param str id: Result identifier
        :param str name: Database name
        :param str result_type: Type of result - database level or task level
               Expected value is 'DatabaseLevelOutput'.
        :param float size_mb: Size of the file in megabytes
        """
        pulumi.set(__self__, "compatibility_level", compatibility_level)
        pulumi.set(__self__, "database_files", database_files)
        pulumi.set(__self__, "database_state", database_state)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "result_type", 'DatabaseLevelOutput')
        pulumi.set(__self__, "size_mb", size_mb)

    @property
    @pulumi.getter(name="compatibilityLevel")
    def compatibility_level(self) -> str:
        """
        SQL Server compatibility level of database
        """
        return pulumi.get(self, "compatibility_level")

    @property
    @pulumi.getter(name="databaseFiles")
    def database_files(self) -> Sequence['outputs.DatabaseFileInfoResponse']:
        """
        The list of database files
        """
        return pulumi.get(self, "database_files")

    @property
    @pulumi.getter(name="databaseState")
    def database_state(self) -> str:
        """
        State of the database
        """
        return pulumi.get(self, "database_state")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Result identifier
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Database name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="resultType")
    def result_type(self) -> str:
        """
        Type of result - database level or task level
        Expected value is 'DatabaseLevelOutput'.
        """
        return pulumi.get(self, "result_type")

    @property
    @pulumi.getter(name="sizeMB")
    def size_mb(self) -> float:
        """
        Size of the file in megabytes
        """
        return pulumi.get(self, "size_mb")


@pulumi.output_type
class ConnectToSourceSqlServerTaskOutputLoginLevelResponse(dict):
    """
    Login level output for the task that validates connection to SQL Server and also validates source server requirements
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultDatabase":
            suggest = "default_database"
        elif key == "isEnabled":
            suggest = "is_enabled"
        elif key == "loginType":
            suggest = "login_type"
        elif key == "migrationEligibility":
            suggest = "migration_eligibility"
        elif key == "resultType":
            suggest = "result_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectToSourceSqlServerTaskOutputLoginLevelResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectToSourceSqlServerTaskOutputLoginLevelResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectToSourceSqlServerTaskOutputLoginLevelResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_database: str,
                 id: str,
                 is_enabled: bool,
                 login_type: str,
                 migration_eligibility: 'outputs.MigrationEligibilityInfoResponse',
                 name: str,
                 result_type: str):
        """
        Login level output for the task that validates connection to SQL Server and also validates source server requirements
        :param str default_database: The default database for the login.
        :param str id: Result identifier
        :param bool is_enabled: The state of the login.
        :param str login_type: The type of login.
        :param 'MigrationEligibilityInfoResponse' migration_eligibility: Information about eligibility of login for migration.
        :param str name: Login name.
        :param str result_type: Type of result - database level or task level
               Expected value is 'LoginLevelOutput'.
        """
        pulumi.set(__self__, "default_database", default_database)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "is_enabled", is_enabled)
        pulumi.set(__self__, "login_type", login_type)
        pulumi.set(__self__, "migration_eligibility", migration_eligibility)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "result_type", 'LoginLevelOutput')

    @property
    @pulumi.getter(name="defaultDatabase")
    def default_database(self) -> str:
        """
        The default database for the login.
        """
        return pulumi.get(self, "default_database")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Result identifier
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> bool:
        """
        The state of the login.
        """
        return pulumi.get(self, "is_enabled")

    @property
    @pulumi.getter(name="loginType")
    def login_type(self) -> str:
        """
        The type of login.
        """
        return pulumi.get(self, "login_type")

    @property
    @pulumi.getter(name="migrationEligibility")
    def migration_eligibility(self) -> 'outputs.MigrationEligibilityInfoResponse':
        """
        Information about eligibility of login for migration.
        """
        return pulumi.get(self, "migration_eligibility")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Login name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="resultType")
    def result_type(self) -> str:
        """
        Type of result - database level or task level
        Expected value is 'LoginLevelOutput'.
        """
        return pulumi.get(self, "result_type")


@pulumi.output_type
class ConnectToSourceSqlServerTaskOutputTaskLevelResponse(dict):
    """
    Task level output for the task that validates connection to SQL Server and also validates source server requirements
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "agentJobs":
            suggest = "agent_jobs"
        elif key == "resultType":
            suggest = "result_type"
        elif key == "sourceServerBrandVersion":
            suggest = "source_server_brand_version"
        elif key == "sourceServerVersion":
            suggest = "source_server_version"
        elif key == "validationErrors":
            suggest = "validation_errors"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectToSourceSqlServerTaskOutputTaskLevelResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectToSourceSqlServerTaskOutputTaskLevelResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectToSourceSqlServerTaskOutputTaskLevelResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 agent_jobs: Mapping[str, str],
                 databases: Mapping[str, str],
                 id: str,
                 logins: Mapping[str, str],
                 result_type: str,
                 source_server_brand_version: str,
                 source_server_version: str,
                 validation_errors: Sequence['outputs.ReportableExceptionResponse']):
        """
        Task level output for the task that validates connection to SQL Server and also validates source server requirements
        :param Mapping[str, str] agent_jobs: Source agent jobs as a map from agent job name to id.
        :param Mapping[str, str] databases: Source databases as a map from database name to database id
        :param str id: Result identifier
        :param Mapping[str, str] logins: Source logins as a map from login name to login id.
        :param str result_type: Type of result - database level or task level
               Expected value is 'TaskLevelOutput'.
        :param str source_server_brand_version: Source server brand version
        :param str source_server_version: Source server version
        :param Sequence['ReportableExceptionResponse'] validation_errors: Validation errors
        """
        pulumi.set(__self__, "agent_jobs", agent_jobs)
        pulumi.set(__self__, "databases", databases)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "logins", logins)
        pulumi.set(__self__, "result_type", 'TaskLevelOutput')
        pulumi.set(__self__, "source_server_brand_version", source_server_brand_version)
        pulumi.set(__self__, "source_server_version", source_server_version)
        pulumi.set(__self__, "validation_errors", validation_errors)

    @property
    @pulumi.getter(name="agentJobs")
    def agent_jobs(self) -> Mapping[str, str]:
        """
        Source agent jobs as a map from agent job name to id.
        """
        return pulumi.get(self, "agent_jobs")

    @property
    @pulumi.getter
    def databases(self) -> Mapping[str, str]:
        """
        Source databases as a map from database name to database id
        """
        return pulumi.get(self, "databases")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Result identifier
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def logins(self) -> Mapping[str, str]:
        """
        Source logins as a map from login name to login id.
        """
        return pulumi.get(self, "logins")

    @property
    @pulumi.getter(name="resultType")
    def result_type(self) -> str:
        """
        Type of result - database level or task level
        Expected value is 'TaskLevelOutput'.
        """
        return pulumi.get(self, "result_type")

    @property
    @pulumi.getter(name="sourceServerBrandVersion")
    def source_server_brand_version(self) -> str:
        """
        Source server brand version
        """
        return pulumi.get(self, "source_server_brand_version")

    @property
    @pulumi.getter(name="sourceServerVersion")
    def source_server_version(self) -> str:
        """
        Source server version
        """
        return pulumi.get(self, "source_server_version")

    @property
    @pulumi.getter(name="validationErrors")
    def validation_errors(self) -> Sequence['outputs.ReportableExceptionResponse']:
        """
        Validation errors
        """
        return pulumi.get(self, "validation_errors")


@pulumi.output_type
class ConnectToSourceSqlServerTaskPropertiesResponse(dict):
    """
    Properties for the task that validates connection to SQL Server and also validates source server requirements
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "taskType":
            suggest = "task_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectToSourceSqlServerTaskPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectToSourceSqlServerTaskPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectToSourceSqlServerTaskPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 commands: Sequence[Any],
                 errors: Sequence['outputs.ODataErrorResponse'],
                 output: Sequence[Any],
                 state: str,
                 task_type: str,
                 input: Optional['outputs.ConnectToSourceSqlServerTaskInputResponse'] = None):
        """
        Properties for the task that validates connection to SQL Server and also validates source server requirements
        :param Sequence[Union['MigrateMISyncCompleteCommandPropertiesResponse', 'MigrateSyncCompleteCommandPropertiesResponse']] commands: Array of command properties.
        :param Sequence['ODataErrorResponse'] errors: Array of errors. This is ignored if submitted.
        :param Sequence[Union['ConnectToSourceSqlServerTaskOutputAgentJobLevelResponse', 'ConnectToSourceSqlServerTaskOutputDatabaseLevelResponse', 'ConnectToSourceSqlServerTaskOutputLoginLevelResponse', 'ConnectToSourceSqlServerTaskOutputTaskLevelResponse']] output: Task output. This is ignored if submitted.
        :param str state: The state of the task. This is ignored if submitted.
        :param str task_type: Task type.
               Expected value is 'ConnectToSource.SqlServer'.
        :param 'ConnectToSourceSqlServerTaskInputResponse' input: Task input
        """
        pulumi.set(__self__, "commands", commands)
        pulumi.set(__self__, "errors", errors)
        pulumi.set(__self__, "output", output)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "task_type", 'ConnectToSource.SqlServer')
        if input is not None:
            pulumi.set(__self__, "input", input)

    @property
    @pulumi.getter
    def commands(self) -> Sequence[Any]:
        """
        Array of command properties.
        """
        return pulumi.get(self, "commands")

    @property
    @pulumi.getter
    def errors(self) -> Sequence['outputs.ODataErrorResponse']:
        """
        Array of errors. This is ignored if submitted.
        """
        return pulumi.get(self, "errors")

    @property
    @pulumi.getter
    def output(self) -> Sequence[Any]:
        """
        Task output. This is ignored if submitted.
        """
        return pulumi.get(self, "output")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The state of the task. This is ignored if submitted.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="taskType")
    def task_type(self) -> str:
        """
        Task type.
        Expected value is 'ConnectToSource.SqlServer'.
        """
        return pulumi.get(self, "task_type")

    @property
    @pulumi.getter
    def input(self) -> Optional['outputs.ConnectToSourceSqlServerTaskInputResponse']:
        """
        Task input
        """
        return pulumi.get(self, "input")


@pulumi.output_type
class ConnectToTargetAzureDbForMySqlTaskInputResponse(dict):
    """
    Input for the task that validates connection to Azure Database for MySQL and target server requirements
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceConnectionInfo":
            suggest = "source_connection_info"
        elif key == "targetConnectionInfo":
            suggest = "target_connection_info"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectToTargetAzureDbForMySqlTaskInputResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectToTargetAzureDbForMySqlTaskInputResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectToTargetAzureDbForMySqlTaskInputResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 source_connection_info: 'outputs.MySqlConnectionInfoResponse',
                 target_connection_info: 'outputs.MySqlConnectionInfoResponse'):
        """
        Input for the task that validates connection to Azure Database for MySQL and target server requirements
        :param 'MySqlConnectionInfoResponse' source_connection_info: Connection information for source MySQL server
        :param 'MySqlConnectionInfoResponse' target_connection_info: Connection information for target Azure Database for MySQL server
        """
        pulumi.set(__self__, "source_connection_info", source_connection_info)
        pulumi.set(__self__, "target_connection_info", target_connection_info)

    @property
    @pulumi.getter(name="sourceConnectionInfo")
    def source_connection_info(self) -> 'outputs.MySqlConnectionInfoResponse':
        """
        Connection information for source MySQL server
        """
        return pulumi.get(self, "source_connection_info")

    @property
    @pulumi.getter(name="targetConnectionInfo")
    def target_connection_info(self) -> 'outputs.MySqlConnectionInfoResponse':
        """
        Connection information for target Azure Database for MySQL server
        """
        return pulumi.get(self, "target_connection_info")


@pulumi.output_type
class ConnectToTargetAzureDbForMySqlTaskOutputResponse(dict):
    """
    Output for the task that validates connection to Azure Database for MySQL and target server requirements
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "serverVersion":
            suggest = "server_version"
        elif key == "targetServerBrandVersion":
            suggest = "target_server_brand_version"
        elif key == "validationErrors":
            suggest = "validation_errors"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectToTargetAzureDbForMySqlTaskOutputResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectToTargetAzureDbForMySqlTaskOutputResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectToTargetAzureDbForMySqlTaskOutputResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 databases: Sequence[str],
                 id: str,
                 server_version: str,
                 target_server_brand_version: str,
                 validation_errors: Sequence['outputs.ReportableExceptionResponse']):
        """
        Output for the task that validates connection to Azure Database for MySQL and target server requirements
        :param Sequence[str] databases: List of databases on target server
        :param str id: Result identifier
        :param str server_version: Version of the target server
        :param str target_server_brand_version: Target server brand version
        :param Sequence['ReportableExceptionResponse'] validation_errors: Validation errors associated with the task
        """
        pulumi.set(__self__, "databases", databases)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "server_version", server_version)
        pulumi.set(__self__, "target_server_brand_version", target_server_brand_version)
        pulumi.set(__self__, "validation_errors", validation_errors)

    @property
    @pulumi.getter
    def databases(self) -> Sequence[str]:
        """
        List of databases on target server
        """
        return pulumi.get(self, "databases")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Result identifier
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="serverVersion")
    def server_version(self) -> str:
        """
        Version of the target server
        """
        return pulumi.get(self, "server_version")

    @property
    @pulumi.getter(name="targetServerBrandVersion")
    def target_server_brand_version(self) -> str:
        """
        Target server brand version
        """
        return pulumi.get(self, "target_server_brand_version")

    @property
    @pulumi.getter(name="validationErrors")
    def validation_errors(self) -> Sequence['outputs.ReportableExceptionResponse']:
        """
        Validation errors associated with the task
        """
        return pulumi.get(self, "validation_errors")


@pulumi.output_type
class ConnectToTargetAzureDbForMySqlTaskPropertiesResponse(dict):
    """
    Properties for the task that validates connection to Azure Database for MySQL and target server requirements
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "taskType":
            suggest = "task_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectToTargetAzureDbForMySqlTaskPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectToTargetAzureDbForMySqlTaskPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectToTargetAzureDbForMySqlTaskPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 commands: Sequence[Any],
                 errors: Sequence['outputs.ODataErrorResponse'],
                 output: Sequence['outputs.ConnectToTargetAzureDbForMySqlTaskOutputResponse'],
                 state: str,
                 task_type: str,
                 input: Optional['outputs.ConnectToTargetAzureDbForMySqlTaskInputResponse'] = None):
        """
        Properties for the task that validates connection to Azure Database for MySQL and target server requirements
        :param Sequence[Union['MigrateMISyncCompleteCommandPropertiesResponse', 'MigrateSyncCompleteCommandPropertiesResponse']] commands: Array of command properties.
        :param Sequence['ODataErrorResponse'] errors: Array of errors. This is ignored if submitted.
        :param Sequence['ConnectToTargetAzureDbForMySqlTaskOutputResponse'] output: Task output. This is ignored if submitted.
        :param str state: The state of the task. This is ignored if submitted.
        :param str task_type: Task type.
               Expected value is 'ConnectToTarget.AzureDbForMySql'.
        :param 'ConnectToTargetAzureDbForMySqlTaskInputResponse' input: Task input
        """
        pulumi.set(__self__, "commands", commands)
        pulumi.set(__self__, "errors", errors)
        pulumi.set(__self__, "output", output)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "task_type", 'ConnectToTarget.AzureDbForMySql')
        if input is not None:
            pulumi.set(__self__, "input", input)

    @property
    @pulumi.getter
    def commands(self) -> Sequence[Any]:
        """
        Array of command properties.
        """
        return pulumi.get(self, "commands")

    @property
    @pulumi.getter
    def errors(self) -> Sequence['outputs.ODataErrorResponse']:
        """
        Array of errors. This is ignored if submitted.
        """
        return pulumi.get(self, "errors")

    @property
    @pulumi.getter
    def output(self) -> Sequence['outputs.ConnectToTargetAzureDbForMySqlTaskOutputResponse']:
        """
        Task output. This is ignored if submitted.
        """
        return pulumi.get(self, "output")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The state of the task. This is ignored if submitted.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="taskType")
    def task_type(self) -> str:
        """
        Task type.
        Expected value is 'ConnectToTarget.AzureDbForMySql'.
        """
        return pulumi.get(self, "task_type")

    @property
    @pulumi.getter
    def input(self) -> Optional['outputs.ConnectToTargetAzureDbForMySqlTaskInputResponse']:
        """
        Task input
        """
        return pulumi.get(self, "input")


@pulumi.output_type
class ConnectToTargetAzureDbForPostgreSqlSyncTaskInputResponse(dict):
    """
    Input for the task that validates connection to Azure Database for PostgreSQL and target server requirements
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceConnectionInfo":
            suggest = "source_connection_info"
        elif key == "targetConnectionInfo":
            suggest = "target_connection_info"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectToTargetAzureDbForPostgreSqlSyncTaskInputResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectToTargetAzureDbForPostgreSqlSyncTaskInputResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectToTargetAzureDbForPostgreSqlSyncTaskInputResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 source_connection_info: 'outputs.PostgreSqlConnectionInfoResponse',
                 target_connection_info: 'outputs.PostgreSqlConnectionInfoResponse'):
        """
        Input for the task that validates connection to Azure Database for PostgreSQL and target server requirements
        :param 'PostgreSqlConnectionInfoResponse' source_connection_info: Connection information for source PostgreSQL server
        :param 'PostgreSqlConnectionInfoResponse' target_connection_info: Connection information for target Azure Database for PostgreSQL server
        """
        pulumi.set(__self__, "source_connection_info", source_connection_info)
        pulumi.set(__self__, "target_connection_info", target_connection_info)

    @property
    @pulumi.getter(name="sourceConnectionInfo")
    def source_connection_info(self) -> 'outputs.PostgreSqlConnectionInfoResponse':
        """
        Connection information for source PostgreSQL server
        """
        return pulumi.get(self, "source_connection_info")

    @property
    @pulumi.getter(name="targetConnectionInfo")
    def target_connection_info(self) -> 'outputs.PostgreSqlConnectionInfoResponse':
        """
        Connection information for target Azure Database for PostgreSQL server
        """
        return pulumi.get(self, "target_connection_info")


@pulumi.output_type
class ConnectToTargetAzureDbForPostgreSqlSyncTaskOutputResponse(dict):
    """
    Output for the task that validates connection to Azure Database for PostgreSQL and target server requirements
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "targetServerBrandVersion":
            suggest = "target_server_brand_version"
        elif key == "targetServerVersion":
            suggest = "target_server_version"
        elif key == "validationErrors":
            suggest = "validation_errors"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectToTargetAzureDbForPostgreSqlSyncTaskOutputResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectToTargetAzureDbForPostgreSqlSyncTaskOutputResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectToTargetAzureDbForPostgreSqlSyncTaskOutputResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 databases: Sequence[str],
                 id: str,
                 target_server_brand_version: str,
                 target_server_version: str,
                 validation_errors: Sequence['outputs.ReportableExceptionResponse']):
        """
        Output for the task that validates connection to Azure Database for PostgreSQL and target server requirements
        :param Sequence[str] databases: List of databases on target server
        :param str id: Result identifier
        :param str target_server_brand_version: Target server brand version
        :param str target_server_version: Version of the target server
        :param Sequence['ReportableExceptionResponse'] validation_errors: Validation errors associated with the task
        """
        pulumi.set(__self__, "databases", databases)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "target_server_brand_version", target_server_brand_version)
        pulumi.set(__self__, "target_server_version", target_server_version)
        pulumi.set(__self__, "validation_errors", validation_errors)

    @property
    @pulumi.getter
    def databases(self) -> Sequence[str]:
        """
        List of databases on target server
        """
        return pulumi.get(self, "databases")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Result identifier
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="targetServerBrandVersion")
    def target_server_brand_version(self) -> str:
        """
        Target server brand version
        """
        return pulumi.get(self, "target_server_brand_version")

    @property
    @pulumi.getter(name="targetServerVersion")
    def target_server_version(self) -> str:
        """
        Version of the target server
        """
        return pulumi.get(self, "target_server_version")

    @property
    @pulumi.getter(name="validationErrors")
    def validation_errors(self) -> Sequence['outputs.ReportableExceptionResponse']:
        """
        Validation errors associated with the task
        """
        return pulumi.get(self, "validation_errors")


@pulumi.output_type
class ConnectToTargetAzureDbForPostgreSqlSyncTaskPropertiesResponse(dict):
    """
    Properties for the task that validates connection to Azure Database For PostgreSQL server and target server requirements for online migration
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "taskType":
            suggest = "task_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectToTargetAzureDbForPostgreSqlSyncTaskPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectToTargetAzureDbForPostgreSqlSyncTaskPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectToTargetAzureDbForPostgreSqlSyncTaskPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 commands: Sequence[Any],
                 errors: Sequence['outputs.ODataErrorResponse'],
                 output: Sequence['outputs.ConnectToTargetAzureDbForPostgreSqlSyncTaskOutputResponse'],
                 state: str,
                 task_type: str,
                 input: Optional['outputs.ConnectToTargetAzureDbForPostgreSqlSyncTaskInputResponse'] = None):
        """
        Properties for the task that validates connection to Azure Database For PostgreSQL server and target server requirements for online migration
        :param Sequence[Union['MigrateMISyncCompleteCommandPropertiesResponse', 'MigrateSyncCompleteCommandPropertiesResponse']] commands: Array of command properties.
        :param Sequence['ODataErrorResponse'] errors: Array of errors. This is ignored if submitted.
        :param Sequence['ConnectToTargetAzureDbForPostgreSqlSyncTaskOutputResponse'] output: Task output. This is ignored if submitted.
        :param str state: The state of the task. This is ignored if submitted.
        :param str task_type: Task type.
               Expected value is 'ConnectToTarget.AzureDbForPostgreSql.Sync'.
        :param 'ConnectToTargetAzureDbForPostgreSqlSyncTaskInputResponse' input: Task input
        """
        pulumi.set(__self__, "commands", commands)
        pulumi.set(__self__, "errors", errors)
        pulumi.set(__self__, "output", output)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "task_type", 'ConnectToTarget.AzureDbForPostgreSql.Sync')
        if input is not None:
            pulumi.set(__self__, "input", input)

    @property
    @pulumi.getter
    def commands(self) -> Sequence[Any]:
        """
        Array of command properties.
        """
        return pulumi.get(self, "commands")

    @property
    @pulumi.getter
    def errors(self) -> Sequence['outputs.ODataErrorResponse']:
        """
        Array of errors. This is ignored if submitted.
        """
        return pulumi.get(self, "errors")

    @property
    @pulumi.getter
    def output(self) -> Sequence['outputs.ConnectToTargetAzureDbForPostgreSqlSyncTaskOutputResponse']:
        """
        Task output. This is ignored if submitted.
        """
        return pulumi.get(self, "output")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The state of the task. This is ignored if submitted.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="taskType")
    def task_type(self) -> str:
        """
        Task type.
        Expected value is 'ConnectToTarget.AzureDbForPostgreSql.Sync'.
        """
        return pulumi.get(self, "task_type")

    @property
    @pulumi.getter
    def input(self) -> Optional['outputs.ConnectToTargetAzureDbForPostgreSqlSyncTaskInputResponse']:
        """
        Task input
        """
        return pulumi.get(self, "input")


@pulumi.output_type
class ConnectToTargetSqlDbTaskInputResponse(dict):
    """
    Input for the task that validates connection to SQL DB and target server requirements
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "targetConnectionInfo":
            suggest = "target_connection_info"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectToTargetSqlDbTaskInputResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectToTargetSqlDbTaskInputResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectToTargetSqlDbTaskInputResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 target_connection_info: 'outputs.SqlConnectionInfoResponse'):
        """
        Input for the task that validates connection to SQL DB and target server requirements
        :param 'SqlConnectionInfoResponse' target_connection_info: Connection information for target SQL DB
        """
        pulumi.set(__self__, "target_connection_info", target_connection_info)

    @property
    @pulumi.getter(name="targetConnectionInfo")
    def target_connection_info(self) -> 'outputs.SqlConnectionInfoResponse':
        """
        Connection information for target SQL DB
        """
        return pulumi.get(self, "target_connection_info")


@pulumi.output_type
class ConnectToTargetSqlDbTaskOutputResponse(dict):
    """
    Output for the task that validates connection to SQL DB and target server requirements
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "targetServerBrandVersion":
            suggest = "target_server_brand_version"
        elif key == "targetServerVersion":
            suggest = "target_server_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectToTargetSqlDbTaskOutputResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectToTargetSqlDbTaskOutputResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectToTargetSqlDbTaskOutputResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 databases: Mapping[str, str],
                 id: str,
                 target_server_brand_version: str,
                 target_server_version: str):
        """
        Output for the task that validates connection to SQL DB and target server requirements
        :param Mapping[str, str] databases: Source databases as a map from database name to database id
        :param str id: Result identifier
        :param str target_server_brand_version: Target server brand version
        :param str target_server_version: Version of the target server
        """
        pulumi.set(__self__, "databases", databases)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "target_server_brand_version", target_server_brand_version)
        pulumi.set(__self__, "target_server_version", target_server_version)

    @property
    @pulumi.getter
    def databases(self) -> Mapping[str, str]:
        """
        Source databases as a map from database name to database id
        """
        return pulumi.get(self, "databases")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Result identifier
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="targetServerBrandVersion")
    def target_server_brand_version(self) -> str:
        """
        Target server brand version
        """
        return pulumi.get(self, "target_server_brand_version")

    @property
    @pulumi.getter(name="targetServerVersion")
    def target_server_version(self) -> str:
        """
        Version of the target server
        """
        return pulumi.get(self, "target_server_version")


@pulumi.output_type
class ConnectToTargetSqlDbTaskPropertiesResponse(dict):
    """
    Properties for the task that validates connection to SQL DB and target server requirements
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "taskType":
            suggest = "task_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectToTargetSqlDbTaskPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectToTargetSqlDbTaskPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectToTargetSqlDbTaskPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 commands: Sequence[Any],
                 errors: Sequence['outputs.ODataErrorResponse'],
                 output: Sequence['outputs.ConnectToTargetSqlDbTaskOutputResponse'],
                 state: str,
                 task_type: str,
                 input: Optional['outputs.ConnectToTargetSqlDbTaskInputResponse'] = None):
        """
        Properties for the task that validates connection to SQL DB and target server requirements
        :param Sequence[Union['MigrateMISyncCompleteCommandPropertiesResponse', 'MigrateSyncCompleteCommandPropertiesResponse']] commands: Array of command properties.
        :param Sequence['ODataErrorResponse'] errors: Array of errors. This is ignored if submitted.
        :param Sequence['ConnectToTargetSqlDbTaskOutputResponse'] output: Task output. This is ignored if submitted.
        :param str state: The state of the task. This is ignored if submitted.
        :param str task_type: Task type.
               Expected value is 'ConnectToTarget.SqlDb'.
        :param 'ConnectToTargetSqlDbTaskInputResponse' input: Task input
        """
        pulumi.set(__self__, "commands", commands)
        pulumi.set(__self__, "errors", errors)
        pulumi.set(__self__, "output", output)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "task_type", 'ConnectToTarget.SqlDb')
        if input is not None:
            pulumi.set(__self__, "input", input)

    @property
    @pulumi.getter
    def commands(self) -> Sequence[Any]:
        """
        Array of command properties.
        """
        return pulumi.get(self, "commands")

    @property
    @pulumi.getter
    def errors(self) -> Sequence['outputs.ODataErrorResponse']:
        """
        Array of errors. This is ignored if submitted.
        """
        return pulumi.get(self, "errors")

    @property
    @pulumi.getter
    def output(self) -> Sequence['outputs.ConnectToTargetSqlDbTaskOutputResponse']:
        """
        Task output. This is ignored if submitted.
        """
        return pulumi.get(self, "output")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The state of the task. This is ignored if submitted.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="taskType")
    def task_type(self) -> str:
        """
        Task type.
        Expected value is 'ConnectToTarget.SqlDb'.
        """
        return pulumi.get(self, "task_type")

    @property
    @pulumi.getter
    def input(self) -> Optional['outputs.ConnectToTargetSqlDbTaskInputResponse']:
        """
        Task input
        """
        return pulumi.get(self, "input")


@pulumi.output_type
class ConnectToTargetSqlMISyncTaskInputResponse(dict):
    """
    Input for the task that validates connection to Azure SQL Database Managed Instance online scenario.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "azureApp":
            suggest = "azure_app"
        elif key == "targetConnectionInfo":
            suggest = "target_connection_info"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectToTargetSqlMISyncTaskInputResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectToTargetSqlMISyncTaskInputResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectToTargetSqlMISyncTaskInputResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 azure_app: 'outputs.AzureActiveDirectoryAppResponse',
                 target_connection_info: 'outputs.MiSqlConnectionInfoResponse'):
        """
        Input for the task that validates connection to Azure SQL Database Managed Instance online scenario.
        :param 'AzureActiveDirectoryAppResponse' azure_app: Azure Active Directory Application the DMS instance will use to connect to the target instance of Azure SQL Database Managed Instance and the Azure Storage Account
        :param 'MiSqlConnectionInfoResponse' target_connection_info: Connection information for Azure SQL Database Managed Instance
        """
        pulumi.set(__self__, "azure_app", azure_app)
        pulumi.set(__self__, "target_connection_info", target_connection_info)

    @property
    @pulumi.getter(name="azureApp")
    def azure_app(self) -> 'outputs.AzureActiveDirectoryAppResponse':
        """
        Azure Active Directory Application the DMS instance will use to connect to the target instance of Azure SQL Database Managed Instance and the Azure Storage Account
        """
        return pulumi.get(self, "azure_app")

    @property
    @pulumi.getter(name="targetConnectionInfo")
    def target_connection_info(self) -> 'outputs.MiSqlConnectionInfoResponse':
        """
        Connection information for Azure SQL Database Managed Instance
        """
        return pulumi.get(self, "target_connection_info")


@pulumi.output_type
class ConnectToTargetSqlMISyncTaskOutputResponse(dict):
    """
    Output for the task that validates connection to Azure SQL Database Managed Instance.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "targetServerBrandVersion":
            suggest = "target_server_brand_version"
        elif key == "targetServerVersion":
            suggest = "target_server_version"
        elif key == "validationErrors":
            suggest = "validation_errors"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectToTargetSqlMISyncTaskOutputResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectToTargetSqlMISyncTaskOutputResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectToTargetSqlMISyncTaskOutputResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 target_server_brand_version: str,
                 target_server_version: str,
                 validation_errors: Sequence['outputs.ReportableExceptionResponse']):
        """
        Output for the task that validates connection to Azure SQL Database Managed Instance.
        :param str target_server_brand_version: Target server brand version
        :param str target_server_version: Target server version
        :param Sequence['ReportableExceptionResponse'] validation_errors: Validation errors
        """
        pulumi.set(__self__, "target_server_brand_version", target_server_brand_version)
        pulumi.set(__self__, "target_server_version", target_server_version)
        pulumi.set(__self__, "validation_errors", validation_errors)

    @property
    @pulumi.getter(name="targetServerBrandVersion")
    def target_server_brand_version(self) -> str:
        """
        Target server brand version
        """
        return pulumi.get(self, "target_server_brand_version")

    @property
    @pulumi.getter(name="targetServerVersion")
    def target_server_version(self) -> str:
        """
        Target server version
        """
        return pulumi.get(self, "target_server_version")

    @property
    @pulumi.getter(name="validationErrors")
    def validation_errors(self) -> Sequence['outputs.ReportableExceptionResponse']:
        """
        Validation errors
        """
        return pulumi.get(self, "validation_errors")


@pulumi.output_type
class ConnectToTargetSqlMISyncTaskPropertiesResponse(dict):
    """
    Properties for the task that validates connection to Azure SQL Database Managed Instance
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "taskType":
            suggest = "task_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectToTargetSqlMISyncTaskPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectToTargetSqlMISyncTaskPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectToTargetSqlMISyncTaskPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 commands: Sequence[Any],
                 errors: Sequence['outputs.ODataErrorResponse'],
                 output: Sequence['outputs.ConnectToTargetSqlMISyncTaskOutputResponse'],
                 state: str,
                 task_type: str,
                 input: Optional['outputs.ConnectToTargetSqlMISyncTaskInputResponse'] = None):
        """
        Properties for the task that validates connection to Azure SQL Database Managed Instance
        :param Sequence[Union['MigrateMISyncCompleteCommandPropertiesResponse', 'MigrateSyncCompleteCommandPropertiesResponse']] commands: Array of command properties.
        :param Sequence['ODataErrorResponse'] errors: Array of errors. This is ignored if submitted.
        :param Sequence['ConnectToTargetSqlMISyncTaskOutputResponse'] output: Task output. This is ignored if submitted.
        :param str state: The state of the task. This is ignored if submitted.
        :param str task_type: Task type.
               Expected value is 'ConnectToTarget.AzureSqlDbMI.Sync.LRS'.
        :param 'ConnectToTargetSqlMISyncTaskInputResponse' input: Task input
        """
        pulumi.set(__self__, "commands", commands)
        pulumi.set(__self__, "errors", errors)
        pulumi.set(__self__, "output", output)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "task_type", 'ConnectToTarget.AzureSqlDbMI.Sync.LRS')
        if input is not None:
            pulumi.set(__self__, "input", input)

    @property
    @pulumi.getter
    def commands(self) -> Sequence[Any]:
        """
        Array of command properties.
        """
        return pulumi.get(self, "commands")

    @property
    @pulumi.getter
    def errors(self) -> Sequence['outputs.ODataErrorResponse']:
        """
        Array of errors. This is ignored if submitted.
        """
        return pulumi.get(self, "errors")

    @property
    @pulumi.getter
    def output(self) -> Sequence['outputs.ConnectToTargetSqlMISyncTaskOutputResponse']:
        """
        Task output. This is ignored if submitted.
        """
        return pulumi.get(self, "output")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The state of the task. This is ignored if submitted.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="taskType")
    def task_type(self) -> str:
        """
        Task type.
        Expected value is 'ConnectToTarget.AzureSqlDbMI.Sync.LRS'.
        """
        return pulumi.get(self, "task_type")

    @property
    @pulumi.getter
    def input(self) -> Optional['outputs.ConnectToTargetSqlMISyncTaskInputResponse']:
        """
        Task input
        """
        return pulumi.get(self, "input")


@pulumi.output_type
class ConnectToTargetSqlMITaskInputResponse(dict):
    """
    Input for the task that validates connection to Azure SQL Database Managed Instance.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "targetConnectionInfo":
            suggest = "target_connection_info"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectToTargetSqlMITaskInputResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectToTargetSqlMITaskInputResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectToTargetSqlMITaskInputResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 target_connection_info: 'outputs.SqlConnectionInfoResponse'):
        """
        Input for the task that validates connection to Azure SQL Database Managed Instance.
        :param 'SqlConnectionInfoResponse' target_connection_info: Connection information for target SQL Server
        """
        pulumi.set(__self__, "target_connection_info", target_connection_info)

    @property
    @pulumi.getter(name="targetConnectionInfo")
    def target_connection_info(self) -> 'outputs.SqlConnectionInfoResponse':
        """
        Connection information for target SQL Server
        """
        return pulumi.get(self, "target_connection_info")


@pulumi.output_type
class ConnectToTargetSqlMITaskOutputResponse(dict):
    """
    Output for the task that validates connection to Azure SQL Database Managed Instance.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "agentJobs":
            suggest = "agent_jobs"
        elif key == "targetServerBrandVersion":
            suggest = "target_server_brand_version"
        elif key == "targetServerVersion":
            suggest = "target_server_version"
        elif key == "validationErrors":
            suggest = "validation_errors"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectToTargetSqlMITaskOutputResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectToTargetSqlMITaskOutputResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectToTargetSqlMITaskOutputResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 agent_jobs: Sequence[str],
                 id: str,
                 logins: Sequence[str],
                 target_server_brand_version: str,
                 target_server_version: str,
                 validation_errors: Sequence['outputs.ReportableExceptionResponse']):
        """
        Output for the task that validates connection to Azure SQL Database Managed Instance.
        :param Sequence[str] agent_jobs: List of agent jobs on the target server.
        :param str id: Result identifier
        :param Sequence[str] logins: List of logins on the target server.
        :param str target_server_brand_version: Target server brand version
        :param str target_server_version: Target server version
        :param Sequence['ReportableExceptionResponse'] validation_errors: Validation errors
        """
        pulumi.set(__self__, "agent_jobs", agent_jobs)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "logins", logins)
        pulumi.set(__self__, "target_server_brand_version", target_server_brand_version)
        pulumi.set(__self__, "target_server_version", target_server_version)
        pulumi.set(__self__, "validation_errors", validation_errors)

    @property
    @pulumi.getter(name="agentJobs")
    def agent_jobs(self) -> Sequence[str]:
        """
        List of agent jobs on the target server.
        """
        return pulumi.get(self, "agent_jobs")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Result identifier
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def logins(self) -> Sequence[str]:
        """
        List of logins on the target server.
        """
        return pulumi.get(self, "logins")

    @property
    @pulumi.getter(name="targetServerBrandVersion")
    def target_server_brand_version(self) -> str:
        """
        Target server brand version
        """
        return pulumi.get(self, "target_server_brand_version")

    @property
    @pulumi.getter(name="targetServerVersion")
    def target_server_version(self) -> str:
        """
        Target server version
        """
        return pulumi.get(self, "target_server_version")

    @property
    @pulumi.getter(name="validationErrors")
    def validation_errors(self) -> Sequence['outputs.ReportableExceptionResponse']:
        """
        Validation errors
        """
        return pulumi.get(self, "validation_errors")


@pulumi.output_type
class ConnectToTargetSqlMITaskPropertiesResponse(dict):
    """
    Properties for the task that validates connection to Azure SQL Database Managed Instance
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "taskType":
            suggest = "task_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectToTargetSqlMITaskPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectToTargetSqlMITaskPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectToTargetSqlMITaskPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 commands: Sequence[Any],
                 errors: Sequence['outputs.ODataErrorResponse'],
                 output: Sequence['outputs.ConnectToTargetSqlMITaskOutputResponse'],
                 state: str,
                 task_type: str,
                 input: Optional['outputs.ConnectToTargetSqlMITaskInputResponse'] = None):
        """
        Properties for the task that validates connection to Azure SQL Database Managed Instance
        :param Sequence[Union['MigrateMISyncCompleteCommandPropertiesResponse', 'MigrateSyncCompleteCommandPropertiesResponse']] commands: Array of command properties.
        :param Sequence['ODataErrorResponse'] errors: Array of errors. This is ignored if submitted.
        :param Sequence['ConnectToTargetSqlMITaskOutputResponse'] output: Task output. This is ignored if submitted.
        :param str state: The state of the task. This is ignored if submitted.
        :param str task_type: Task type.
               Expected value is 'ConnectToTarget.AzureSqlDbMI'.
        :param 'ConnectToTargetSqlMITaskInputResponse' input: Task input
        """
        pulumi.set(__self__, "commands", commands)
        pulumi.set(__self__, "errors", errors)
        pulumi.set(__self__, "output", output)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "task_type", 'ConnectToTarget.AzureSqlDbMI')
        if input is not None:
            pulumi.set(__self__, "input", input)

    @property
    @pulumi.getter
    def commands(self) -> Sequence[Any]:
        """
        Array of command properties.
        """
        return pulumi.get(self, "commands")

    @property
    @pulumi.getter
    def errors(self) -> Sequence['outputs.ODataErrorResponse']:
        """
        Array of errors. This is ignored if submitted.
        """
        return pulumi.get(self, "errors")

    @property
    @pulumi.getter
    def output(self) -> Sequence['outputs.ConnectToTargetSqlMITaskOutputResponse']:
        """
        Task output. This is ignored if submitted.
        """
        return pulumi.get(self, "output")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The state of the task. This is ignored if submitted.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="taskType")
    def task_type(self) -> str:
        """
        Task type.
        Expected value is 'ConnectToTarget.AzureSqlDbMI'.
        """
        return pulumi.get(self, "task_type")

    @property
    @pulumi.getter
    def input(self) -> Optional['outputs.ConnectToTargetSqlMITaskInputResponse']:
        """
        Task input
        """
        return pulumi.get(self, "input")


@pulumi.output_type
class ConnectToTargetSqlSqlDbSyncTaskInputResponse(dict):
    """
    Input for the task that validates connection to Azure SQL DB and target server requirements
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceConnectionInfo":
            suggest = "source_connection_info"
        elif key == "targetConnectionInfo":
            suggest = "target_connection_info"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectToTargetSqlSqlDbSyncTaskInputResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectToTargetSqlSqlDbSyncTaskInputResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectToTargetSqlSqlDbSyncTaskInputResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 source_connection_info: 'outputs.SqlConnectionInfoResponse',
                 target_connection_info: 'outputs.SqlConnectionInfoResponse'):
        """
        Input for the task that validates connection to Azure SQL DB and target server requirements
        :param 'SqlConnectionInfoResponse' source_connection_info: Connection information for source SQL Server
        :param 'SqlConnectionInfoResponse' target_connection_info: Connection information for target SQL DB
        """
        pulumi.set(__self__, "source_connection_info", source_connection_info)
        pulumi.set(__self__, "target_connection_info", target_connection_info)

    @property
    @pulumi.getter(name="sourceConnectionInfo")
    def source_connection_info(self) -> 'outputs.SqlConnectionInfoResponse':
        """
        Connection information for source SQL Server
        """
        return pulumi.get(self, "source_connection_info")

    @property
    @pulumi.getter(name="targetConnectionInfo")
    def target_connection_info(self) -> 'outputs.SqlConnectionInfoResponse':
        """
        Connection information for target SQL DB
        """
        return pulumi.get(self, "target_connection_info")


@pulumi.output_type
class ConnectToTargetSqlSqlDbSyncTaskPropertiesResponse(dict):
    """
    Properties for the task that validates connection to SQL DB and target server requirements for online migration
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "taskType":
            suggest = "task_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectToTargetSqlSqlDbSyncTaskPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectToTargetSqlSqlDbSyncTaskPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectToTargetSqlSqlDbSyncTaskPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 commands: Sequence[Any],
                 errors: Sequence['outputs.ODataErrorResponse'],
                 output: Sequence['outputs.ConnectToTargetSqlDbTaskOutputResponse'],
                 state: str,
                 task_type: str,
                 input: Optional['outputs.ConnectToTargetSqlSqlDbSyncTaskInputResponse'] = None):
        """
        Properties for the task that validates connection to SQL DB and target server requirements for online migration
        :param Sequence[Union['MigrateMISyncCompleteCommandPropertiesResponse', 'MigrateSyncCompleteCommandPropertiesResponse']] commands: Array of command properties.
        :param Sequence['ODataErrorResponse'] errors: Array of errors. This is ignored if submitted.
        :param Sequence['ConnectToTargetSqlDbTaskOutputResponse'] output: Task output. This is ignored if submitted.
        :param str state: The state of the task. This is ignored if submitted.
        :param str task_type: Task type.
               Expected value is 'ConnectToTarget.SqlDb.Sync'.
        :param 'ConnectToTargetSqlSqlDbSyncTaskInputResponse' input: Task input
        """
        pulumi.set(__self__, "commands", commands)
        pulumi.set(__self__, "errors", errors)
        pulumi.set(__self__, "output", output)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "task_type", 'ConnectToTarget.SqlDb.Sync')
        if input is not None:
            pulumi.set(__self__, "input", input)

    @property
    @pulumi.getter
    def commands(self) -> Sequence[Any]:
        """
        Array of command properties.
        """
        return pulumi.get(self, "commands")

    @property
    @pulumi.getter
    def errors(self) -> Sequence['outputs.ODataErrorResponse']:
        """
        Array of errors. This is ignored if submitted.
        """
        return pulumi.get(self, "errors")

    @property
    @pulumi.getter
    def output(self) -> Sequence['outputs.ConnectToTargetSqlDbTaskOutputResponse']:
        """
        Task output. This is ignored if submitted.
        """
        return pulumi.get(self, "output")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The state of the task. This is ignored if submitted.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="taskType")
    def task_type(self) -> str:
        """
        Task type.
        Expected value is 'ConnectToTarget.SqlDb.Sync'.
        """
        return pulumi.get(self, "task_type")

    @property
    @pulumi.getter
    def input(self) -> Optional['outputs.ConnectToTargetSqlSqlDbSyncTaskInputResponse']:
        """
        Task input
        """
        return pulumi.get(self, "input")


@pulumi.output_type
class CopyProgressDetailsResponse(dict):
    """
    Details on progress of ADF copy activity
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "copyDuration":
            suggest = "copy_duration"
        elif key == "copyStart":
            suggest = "copy_start"
        elif key == "copyThroughput":
            suggest = "copy_throughput"
        elif key == "dataRead":
            suggest = "data_read"
        elif key == "dataWritten":
            suggest = "data_written"
        elif key == "parallelCopyType":
            suggest = "parallel_copy_type"
        elif key == "rowsCopied":
            suggest = "rows_copied"
        elif key == "rowsRead":
            suggest = "rows_read"
        elif key == "tableName":
            suggest = "table_name"
        elif key == "usedParallelCopies":
            suggest = "used_parallel_copies"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CopyProgressDetailsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CopyProgressDetailsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CopyProgressDetailsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 copy_duration: int,
                 copy_start: str,
                 copy_throughput: float,
                 data_read: float,
                 data_written: float,
                 parallel_copy_type: str,
                 rows_copied: float,
                 rows_read: float,
                 status: str,
                 table_name: str,
                 used_parallel_copies: int):
        """
        Details on progress of ADF copy activity
        :param int copy_duration: Copy Duration in seconds
        :param str copy_start: Copy Start
        :param float copy_throughput: Copy throughput in KBps
        :param float data_read: Bytes read
        :param float data_written: Bytes written
        :param str parallel_copy_type: Type of parallel copy (Dynamic range, Physical partition, none).
        :param float rows_copied: Rows Copied
        :param float rows_read: Rows read
        :param str status: Status of the Copy activity (InProgress, Succeeded, Failed, Canceled).
        :param str table_name: Table Name
        :param int used_parallel_copies: The degree of parallelization.
        """
        pulumi.set(__self__, "copy_duration", copy_duration)
        pulumi.set(__self__, "copy_start", copy_start)
        pulumi.set(__self__, "copy_throughput", copy_throughput)
        pulumi.set(__self__, "data_read", data_read)
        pulumi.set(__self__, "data_written", data_written)
        pulumi.set(__self__, "parallel_copy_type", parallel_copy_type)
        pulumi.set(__self__, "rows_copied", rows_copied)
        pulumi.set(__self__, "rows_read", rows_read)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "table_name", table_name)
        pulumi.set(__self__, "used_parallel_copies", used_parallel_copies)

    @property
    @pulumi.getter(name="copyDuration")
    def copy_duration(self) -> int:
        """
        Copy Duration in seconds
        """
        return pulumi.get(self, "copy_duration")

    @property
    @pulumi.getter(name="copyStart")
    def copy_start(self) -> str:
        """
        Copy Start
        """
        return pulumi.get(self, "copy_start")

    @property
    @pulumi.getter(name="copyThroughput")
    def copy_throughput(self) -> float:
        """
        Copy throughput in KBps
        """
        return pulumi.get(self, "copy_throughput")

    @property
    @pulumi.getter(name="dataRead")
    def data_read(self) -> float:
        """
        Bytes read
        """
        return pulumi.get(self, "data_read")

    @property
    @pulumi.getter(name="dataWritten")
    def data_written(self) -> float:
        """
        Bytes written
        """
        return pulumi.get(self, "data_written")

    @property
    @pulumi.getter(name="parallelCopyType")
    def parallel_copy_type(self) -> str:
        """
        Type of parallel copy (Dynamic range, Physical partition, none).
        """
        return pulumi.get(self, "parallel_copy_type")

    @property
    @pulumi.getter(name="rowsCopied")
    def rows_copied(self) -> float:
        """
        Rows Copied
        """
        return pulumi.get(self, "rows_copied")

    @property
    @pulumi.getter(name="rowsRead")
    def rows_read(self) -> float:
        """
        Rows read
        """
        return pulumi.get(self, "rows_read")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Status of the Copy activity (InProgress, Succeeded, Failed, Canceled).
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="tableName")
    def table_name(self) -> str:
        """
        Table Name
        """
        return pulumi.get(self, "table_name")

    @property
    @pulumi.getter(name="usedParallelCopies")
    def used_parallel_copies(self) -> int:
        """
        The degree of parallelization.
        """
        return pulumi.get(self, "used_parallel_copies")


@pulumi.output_type
class DataIntegrityValidationResultResponse(dict):
    """
    Results for checksum based Data Integrity validation results
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "failedObjects":
            suggest = "failed_objects"
        elif key == "validationErrors":
            suggest = "validation_errors"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataIntegrityValidationResultResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataIntegrityValidationResultResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataIntegrityValidationResultResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 failed_objects: Mapping[str, str],
                 validation_errors: 'outputs.ValidationErrorResponse'):
        """
        Results for checksum based Data Integrity validation results
        :param Mapping[str, str] failed_objects: List of failed table names of source and target pair
        :param 'ValidationErrorResponse' validation_errors: List of errors that happened while performing data integrity validation
        """
        pulumi.set(__self__, "failed_objects", failed_objects)
        pulumi.set(__self__, "validation_errors", validation_errors)

    @property
    @pulumi.getter(name="failedObjects")
    def failed_objects(self) -> Mapping[str, str]:
        """
        List of failed table names of source and target pair
        """
        return pulumi.get(self, "failed_objects")

    @property
    @pulumi.getter(name="validationErrors")
    def validation_errors(self) -> 'outputs.ValidationErrorResponse':
        """
        List of errors that happened while performing data integrity validation
        """
        return pulumi.get(self, "validation_errors")


@pulumi.output_type
class DataItemMigrationSummaryResultResponse(dict):
    """
    Basic summary of a data item migration
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endedOn":
            suggest = "ended_on"
        elif key == "errorPrefix":
            suggest = "error_prefix"
        elif key == "itemsCompletedCount":
            suggest = "items_completed_count"
        elif key == "itemsCount":
            suggest = "items_count"
        elif key == "resultPrefix":
            suggest = "result_prefix"
        elif key == "startedOn":
            suggest = "started_on"
        elif key == "statusMessage":
            suggest = "status_message"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataItemMigrationSummaryResultResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataItemMigrationSummaryResultResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataItemMigrationSummaryResultResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ended_on: str,
                 error_prefix: str,
                 items_completed_count: float,
                 items_count: float,
                 name: str,
                 result_prefix: str,
                 started_on: str,
                 state: str,
                 status_message: str):
        """
        Basic summary of a data item migration
        :param str ended_on: Migration end time
        :param str error_prefix: Wildcard string prefix to use for querying all errors of the item
        :param float items_completed_count: Number of successfully completed items
        :param float items_count: Number of items
        :param str name: Name of the item
        :param str result_prefix: Wildcard string prefix to use for querying all sub-tem results of the item
        :param str started_on: Migration start time
        :param str state: Current state of migration
        :param str status_message: Status message
        """
        pulumi.set(__self__, "ended_on", ended_on)
        pulumi.set(__self__, "error_prefix", error_prefix)
        pulumi.set(__self__, "items_completed_count", items_completed_count)
        pulumi.set(__self__, "items_count", items_count)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "result_prefix", result_prefix)
        pulumi.set(__self__, "started_on", started_on)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "status_message", status_message)

    @property
    @pulumi.getter(name="endedOn")
    def ended_on(self) -> str:
        """
        Migration end time
        """
        return pulumi.get(self, "ended_on")

    @property
    @pulumi.getter(name="errorPrefix")
    def error_prefix(self) -> str:
        """
        Wildcard string prefix to use for querying all errors of the item
        """
        return pulumi.get(self, "error_prefix")

    @property
    @pulumi.getter(name="itemsCompletedCount")
    def items_completed_count(self) -> float:
        """
        Number of successfully completed items
        """
        return pulumi.get(self, "items_completed_count")

    @property
    @pulumi.getter(name="itemsCount")
    def items_count(self) -> float:
        """
        Number of items
        """
        return pulumi.get(self, "items_count")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the item
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="resultPrefix")
    def result_prefix(self) -> str:
        """
        Wildcard string prefix to use for querying all sub-tem results of the item
        """
        return pulumi.get(self, "result_prefix")

    @property
    @pulumi.getter(name="startedOn")
    def started_on(self) -> str:
        """
        Migration start time
        """
        return pulumi.get(self, "started_on")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        Current state of migration
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="statusMessage")
    def status_message(self) -> str:
        """
        Status message
        """
        return pulumi.get(self, "status_message")


@pulumi.output_type
class DatabaseBackupInfoResponse(dict):
    """
    Information about backup files when existing backup mode is used.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backupFiles":
            suggest = "backup_files"
        elif key == "backupFinishDate":
            suggest = "backup_finish_date"
        elif key == "backupType":
            suggest = "backup_type"
        elif key == "databaseName":
            suggest = "database_name"
        elif key == "familyCount":
            suggest = "family_count"
        elif key == "isCompressed":
            suggest = "is_compressed"
        elif key == "isDamaged":
            suggest = "is_damaged"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabaseBackupInfoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabaseBackupInfoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabaseBackupInfoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backup_files: Sequence[str],
                 backup_finish_date: str,
                 backup_type: str,
                 database_name: str,
                 family_count: int,
                 is_compressed: bool,
                 is_damaged: bool,
                 position: int):
        """
        Information about backup files when existing backup mode is used.
        :param Sequence[str] backup_files: The list of backup files for the current database.
        :param str backup_finish_date: Date and time when the backup operation finished.
        :param str backup_type: Backup Type.
        :param str database_name: Database name.
        :param int family_count: Number of files in the backup set.
        :param bool is_compressed: Whether the backup set is compressed
        :param bool is_damaged: Database was damaged when backed up, but the backup operation was requested to continue despite errors.
        :param int position: Position of current database backup in the file.
        """
        pulumi.set(__self__, "backup_files", backup_files)
        pulumi.set(__self__, "backup_finish_date", backup_finish_date)
        pulumi.set(__self__, "backup_type", backup_type)
        pulumi.set(__self__, "database_name", database_name)
        pulumi.set(__self__, "family_count", family_count)
        pulumi.set(__self__, "is_compressed", is_compressed)
        pulumi.set(__self__, "is_damaged", is_damaged)
        pulumi.set(__self__, "position", position)

    @property
    @pulumi.getter(name="backupFiles")
    def backup_files(self) -> Sequence[str]:
        """
        The list of backup files for the current database.
        """
        return pulumi.get(self, "backup_files")

    @property
    @pulumi.getter(name="backupFinishDate")
    def backup_finish_date(self) -> str:
        """
        Date and time when the backup operation finished.
        """
        return pulumi.get(self, "backup_finish_date")

    @property
    @pulumi.getter(name="backupType")
    def backup_type(self) -> str:
        """
        Backup Type.
        """
        return pulumi.get(self, "backup_type")

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> str:
        """
        Database name.
        """
        return pulumi.get(self, "database_name")

    @property
    @pulumi.getter(name="familyCount")
    def family_count(self) -> int:
        """
        Number of files in the backup set.
        """
        return pulumi.get(self, "family_count")

    @property
    @pulumi.getter(name="isCompressed")
    def is_compressed(self) -> bool:
        """
        Whether the backup set is compressed
        """
        return pulumi.get(self, "is_compressed")

    @property
    @pulumi.getter(name="isDamaged")
    def is_damaged(self) -> bool:
        """
        Database was damaged when backed up, but the backup operation was requested to continue despite errors.
        """
        return pulumi.get(self, "is_damaged")

    @property
    @pulumi.getter
    def position(self) -> int:
        """
        Position of current database backup in the file.
        """
        return pulumi.get(self, "position")


@pulumi.output_type
class DatabaseFileInfoResponse(dict):
    """
    Database file specific information
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "databaseName":
            suggest = "database_name"
        elif key == "fileType":
            suggest = "file_type"
        elif key == "logicalName":
            suggest = "logical_name"
        elif key == "physicalFullName":
            suggest = "physical_full_name"
        elif key == "restoreFullName":
            suggest = "restore_full_name"
        elif key == "sizeMB":
            suggest = "size_mb"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabaseFileInfoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabaseFileInfoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabaseFileInfoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 database_name: Optional[str] = None,
                 file_type: Optional[str] = None,
                 id: Optional[str] = None,
                 logical_name: Optional[str] = None,
                 physical_full_name: Optional[str] = None,
                 restore_full_name: Optional[str] = None,
                 size_mb: Optional[float] = None):
        """
        Database file specific information
        :param str database_name: Name of the database
        :param str file_type: Database file type
        :param str id: Unique identifier for database file
        :param str logical_name: Logical name of the file
        :param str physical_full_name: Operating-system full path of the file
        :param str restore_full_name: Suggested full path of the file for restoring
        :param float size_mb: Size of the file in megabytes
        """
        if database_name is not None:
            pulumi.set(__self__, "database_name", database_name)
        if file_type is not None:
            pulumi.set(__self__, "file_type", file_type)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if logical_name is not None:
            pulumi.set(__self__, "logical_name", logical_name)
        if physical_full_name is not None:
            pulumi.set(__self__, "physical_full_name", physical_full_name)
        if restore_full_name is not None:
            pulumi.set(__self__, "restore_full_name", restore_full_name)
        if size_mb is not None:
            pulumi.set(__self__, "size_mb", size_mb)

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> Optional[str]:
        """
        Name of the database
        """
        return pulumi.get(self, "database_name")

    @property
    @pulumi.getter(name="fileType")
    def file_type(self) -> Optional[str]:
        """
        Database file type
        """
        return pulumi.get(self, "file_type")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Unique identifier for database file
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="logicalName")
    def logical_name(self) -> Optional[str]:
        """
        Logical name of the file
        """
        return pulumi.get(self, "logical_name")

    @property
    @pulumi.getter(name="physicalFullName")
    def physical_full_name(self) -> Optional[str]:
        """
        Operating-system full path of the file
        """
        return pulumi.get(self, "physical_full_name")

    @property
    @pulumi.getter(name="restoreFullName")
    def restore_full_name(self) -> Optional[str]:
        """
        Suggested full path of the file for restoring
        """
        return pulumi.get(self, "restore_full_name")

    @property
    @pulumi.getter(name="sizeMB")
    def size_mb(self) -> Optional[float]:
        """
        Size of the file in megabytes
        """
        return pulumi.get(self, "size_mb")


@pulumi.output_type
class DatabaseInfoResponse(dict):
    """
    Project Database Details
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceDatabaseName":
            suggest = "source_database_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabaseInfoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabaseInfoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabaseInfoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 source_database_name: str):
        """
        Project Database Details
        :param str source_database_name: Name of the database
        """
        pulumi.set(__self__, "source_database_name", source_database_name)

    @property
    @pulumi.getter(name="sourceDatabaseName")
    def source_database_name(self) -> str:
        """
        Name of the database
        """
        return pulumi.get(self, "source_database_name")


@pulumi.output_type
class DatabaseMigrationPropertiesSqlDbResponse(dict):
    """
    Database Migration Resource properties for SQL database.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endedOn":
            suggest = "ended_on"
        elif key == "migrationFailureError":
            suggest = "migration_failure_error"
        elif key == "migrationStatus":
            suggest = "migration_status"
        elif key == "migrationStatusDetails":
            suggest = "migration_status_details"
        elif key == "offlineConfiguration":
            suggest = "offline_configuration"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "sourceServerName":
            suggest = "source_server_name"
        elif key == "startedOn":
            suggest = "started_on"
        elif key == "migrationOperationId":
            suggest = "migration_operation_id"
        elif key == "migrationService":
            suggest = "migration_service"
        elif key == "provisioningError":
            suggest = "provisioning_error"
        elif key == "sourceDatabaseName":
            suggest = "source_database_name"
        elif key == "sourceSqlConnection":
            suggest = "source_sql_connection"
        elif key == "tableList":
            suggest = "table_list"
        elif key == "targetDatabaseCollation":
            suggest = "target_database_collation"
        elif key == "targetSqlConnection":
            suggest = "target_sql_connection"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabaseMigrationPropertiesSqlDbResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabaseMigrationPropertiesSqlDbResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabaseMigrationPropertiesSqlDbResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ended_on: str,
                 kind: str,
                 migration_failure_error: 'outputs.ErrorInfoResponse',
                 migration_status: str,
                 migration_status_details: 'outputs.SqlDbMigrationStatusDetailsResponse',
                 offline_configuration: 'outputs.SqlDbOfflineConfigurationResponse',
                 provisioning_state: str,
                 source_server_name: str,
                 started_on: str,
                 migration_operation_id: Optional[str] = None,
                 migration_service: Optional[str] = None,
                 provisioning_error: Optional[str] = None,
                 scope: Optional[str] = None,
                 source_database_name: Optional[str] = None,
                 source_sql_connection: Optional['outputs.SqlConnectionInformationResponse'] = None,
                 table_list: Optional[Sequence[str]] = None,
                 target_database_collation: Optional[str] = None,
                 target_sql_connection: Optional['outputs.SqlConnectionInformationResponse'] = None):
        """
        Database Migration Resource properties for SQL database.
        :param str ended_on: Database migration end time.
        :param str kind: 
               Expected value is 'SqlDb'.
        :param 'ErrorInfoResponse' migration_failure_error: Error details in case of migration failure.
        :param str migration_status: Migration status.
        :param 'SqlDbMigrationStatusDetailsResponse' migration_status_details: Detailed migration status. Not included by default.
        :param 'SqlDbOfflineConfigurationResponse' offline_configuration: Offline configuration.
        :param str provisioning_state: Provisioning State of migration. ProvisioningState as Succeeded implies that validations have been performed and migration has started.
        :param str source_server_name: Name of the source sql server.
        :param str started_on: Database migration start time.
        :param str migration_operation_id: ID tracking current migration operation.
        :param str migration_service: Resource Id of the Migration Service.
        :param str provisioning_error: Error message for migration provisioning failure, if any.
        :param str scope: Resource Id of the target resource (SQL VM or SQL Managed Instance).
        :param str source_database_name: Name of the source database.
        :param 'SqlConnectionInformationResponse' source_sql_connection: Source SQL Server connection details.
        :param Sequence[str] table_list: List of tables to copy.
        :param str target_database_collation: Database collation to be used for the target database.
        :param 'SqlConnectionInformationResponse' target_sql_connection: Target SQL DB connection details.
        """
        pulumi.set(__self__, "ended_on", ended_on)
        pulumi.set(__self__, "kind", 'SqlDb')
        pulumi.set(__self__, "migration_failure_error", migration_failure_error)
        pulumi.set(__self__, "migration_status", migration_status)
        pulumi.set(__self__, "migration_status_details", migration_status_details)
        pulumi.set(__self__, "offline_configuration", offline_configuration)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        pulumi.set(__self__, "source_server_name", source_server_name)
        pulumi.set(__self__, "started_on", started_on)
        if migration_operation_id is not None:
            pulumi.set(__self__, "migration_operation_id", migration_operation_id)
        if migration_service is not None:
            pulumi.set(__self__, "migration_service", migration_service)
        if provisioning_error is not None:
            pulumi.set(__self__, "provisioning_error", provisioning_error)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)
        if source_database_name is not None:
            pulumi.set(__self__, "source_database_name", source_database_name)
        if source_sql_connection is not None:
            pulumi.set(__self__, "source_sql_connection", source_sql_connection)
        if table_list is not None:
            pulumi.set(__self__, "table_list", table_list)
        if target_database_collation is not None:
            pulumi.set(__self__, "target_database_collation", target_database_collation)
        if target_sql_connection is not None:
            pulumi.set(__self__, "target_sql_connection", target_sql_connection)

    @property
    @pulumi.getter(name="endedOn")
    def ended_on(self) -> str:
        """
        Database migration end time.
        """
        return pulumi.get(self, "ended_on")

    @property
    @pulumi.getter
    def kind(self) -> str:
        """

        Expected value is 'SqlDb'.
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter(name="migrationFailureError")
    def migration_failure_error(self) -> 'outputs.ErrorInfoResponse':
        """
        Error details in case of migration failure.
        """
        return pulumi.get(self, "migration_failure_error")

    @property
    @pulumi.getter(name="migrationStatus")
    def migration_status(self) -> str:
        """
        Migration status.
        """
        return pulumi.get(self, "migration_status")

    @property
    @pulumi.getter(name="migrationStatusDetails")
    def migration_status_details(self) -> 'outputs.SqlDbMigrationStatusDetailsResponse':
        """
        Detailed migration status. Not included by default.
        """
        return pulumi.get(self, "migration_status_details")

    @property
    @pulumi.getter(name="offlineConfiguration")
    def offline_configuration(self) -> 'outputs.SqlDbOfflineConfigurationResponse':
        """
        Offline configuration.
        """
        return pulumi.get(self, "offline_configuration")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        Provisioning State of migration. ProvisioningState as Succeeded implies that validations have been performed and migration has started.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="sourceServerName")
    def source_server_name(self) -> str:
        """
        Name of the source sql server.
        """
        return pulumi.get(self, "source_server_name")

    @property
    @pulumi.getter(name="startedOn")
    def started_on(self) -> str:
        """
        Database migration start time.
        """
        return pulumi.get(self, "started_on")

    @property
    @pulumi.getter(name="migrationOperationId")
    def migration_operation_id(self) -> Optional[str]:
        """
        ID tracking current migration operation.
        """
        return pulumi.get(self, "migration_operation_id")

    @property
    @pulumi.getter(name="migrationService")
    def migration_service(self) -> Optional[str]:
        """
        Resource Id of the Migration Service.
        """
        return pulumi.get(self, "migration_service")

    @property
    @pulumi.getter(name="provisioningError")
    def provisioning_error(self) -> Optional[str]:
        """
        Error message for migration provisioning failure, if any.
        """
        return pulumi.get(self, "provisioning_error")

    @property
    @pulumi.getter
    def scope(self) -> Optional[str]:
        """
        Resource Id of the target resource (SQL VM or SQL Managed Instance).
        """
        return pulumi.get(self, "scope")

    @property
    @pulumi.getter(name="sourceDatabaseName")
    def source_database_name(self) -> Optional[str]:
        """
        Name of the source database.
        """
        return pulumi.get(self, "source_database_name")

    @property
    @pulumi.getter(name="sourceSqlConnection")
    def source_sql_connection(self) -> Optional['outputs.SqlConnectionInformationResponse']:
        """
        Source SQL Server connection details.
        """
        return pulumi.get(self, "source_sql_connection")

    @property
    @pulumi.getter(name="tableList")
    def table_list(self) -> Optional[Sequence[str]]:
        """
        List of tables to copy.
        """
        return pulumi.get(self, "table_list")

    @property
    @pulumi.getter(name="targetDatabaseCollation")
    def target_database_collation(self) -> Optional[str]:
        """
        Database collation to be used for the target database.
        """
        return pulumi.get(self, "target_database_collation")

    @property
    @pulumi.getter(name="targetSqlConnection")
    def target_sql_connection(self) -> Optional['outputs.SqlConnectionInformationResponse']:
        """
        Target SQL DB connection details.
        """
        return pulumi.get(self, "target_sql_connection")


@pulumi.output_type
class DatabaseSummaryResultResponse(dict):
    """
    Summary of database results in the migration
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endedOn":
            suggest = "ended_on"
        elif key == "errorPrefix":
            suggest = "error_prefix"
        elif key == "itemsCompletedCount":
            suggest = "items_completed_count"
        elif key == "itemsCount":
            suggest = "items_count"
        elif key == "resultPrefix":
            suggest = "result_prefix"
        elif key == "sizeMB":
            suggest = "size_mb"
        elif key == "startedOn":
            suggest = "started_on"
        elif key == "statusMessage":
            suggest = "status_message"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabaseSummaryResultResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabaseSummaryResultResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabaseSummaryResultResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ended_on: str,
                 error_prefix: str,
                 items_completed_count: float,
                 items_count: float,
                 name: str,
                 result_prefix: str,
                 size_mb: float,
                 started_on: str,
                 state: str,
                 status_message: str):
        """
        Summary of database results in the migration
        :param str ended_on: Migration end time
        :param str error_prefix: Wildcard string prefix to use for querying all errors of the item
        :param float items_completed_count: Number of successfully completed items
        :param float items_count: Number of items
        :param str name: Name of the item
        :param str result_prefix: Wildcard string prefix to use for querying all sub-tem results of the item
        :param float size_mb: Size of the database in megabytes
        :param str started_on: Migration start time
        :param str state: Current state of migration
        :param str status_message: Status message
        """
        pulumi.set(__self__, "ended_on", ended_on)
        pulumi.set(__self__, "error_prefix", error_prefix)
        pulumi.set(__self__, "items_completed_count", items_completed_count)
        pulumi.set(__self__, "items_count", items_count)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "result_prefix", result_prefix)
        pulumi.set(__self__, "size_mb", size_mb)
        pulumi.set(__self__, "started_on", started_on)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "status_message", status_message)

    @property
    @pulumi.getter(name="endedOn")
    def ended_on(self) -> str:
        """
        Migration end time
        """
        return pulumi.get(self, "ended_on")

    @property
    @pulumi.getter(name="errorPrefix")
    def error_prefix(self) -> str:
        """
        Wildcard string prefix to use for querying all errors of the item
        """
        return pulumi.get(self, "error_prefix")

    @property
    @pulumi.getter(name="itemsCompletedCount")
    def items_completed_count(self) -> float:
        """
        Number of successfully completed items
        """
        return pulumi.get(self, "items_completed_count")

    @property
    @pulumi.getter(name="itemsCount")
    def items_count(self) -> float:
        """
        Number of items
        """
        return pulumi.get(self, "items_count")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the item
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="resultPrefix")
    def result_prefix(self) -> str:
        """
        Wildcard string prefix to use for querying all sub-tem results of the item
        """
        return pulumi.get(self, "result_prefix")

    @property
    @pulumi.getter(name="sizeMB")
    def size_mb(self) -> float:
        """
        Size of the database in megabytes
        """
        return pulumi.get(self, "size_mb")

    @property
    @pulumi.getter(name="startedOn")
    def started_on(self) -> str:
        """
        Migration start time
        """
        return pulumi.get(self, "started_on")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        Current state of migration
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="statusMessage")
    def status_message(self) -> str:
        """
        Status message
        """
        return pulumi.get(self, "status_message")


@pulumi.output_type
class DatabaseTableResponse(dict):
    """
    Table properties
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "hasRows":
            suggest = "has_rows"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabaseTableResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabaseTableResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabaseTableResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 has_rows: bool,
                 name: str):
        """
        Table properties
        :param bool has_rows: Indicates whether table is empty or not
        :param str name: Schema-qualified name of the table
        """
        pulumi.set(__self__, "has_rows", has_rows)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="hasRows")
    def has_rows(self) -> bool:
        """
        Indicates whether table is empty or not
        """
        return pulumi.get(self, "has_rows")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Schema-qualified name of the table
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class ErrorInfoResponse(dict):
    """
    Error details
    """
    def __init__(__self__, *,
                 code: str,
                 message: str):
        """
        Error details
        :param str code: Error code.
        :param str message: Error message.
        """
        pulumi.set(__self__, "code", code)
        pulumi.set(__self__, "message", message)

    @property
    @pulumi.getter
    def code(self) -> str:
        """
        Error code.
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter
    def message(self) -> str:
        """
        Error message.
        """
        return pulumi.get(self, "message")


@pulumi.output_type
class ExecutionStatisticsResponse(dict):
    """
    Description about the errors happen while performing migration validation
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cpuTimeMs":
            suggest = "cpu_time_ms"
        elif key == "elapsedTimeMs":
            suggest = "elapsed_time_ms"
        elif key == "executionCount":
            suggest = "execution_count"
        elif key == "hasErrors":
            suggest = "has_errors"
        elif key == "sqlErrors":
            suggest = "sql_errors"
        elif key == "waitStats":
            suggest = "wait_stats"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ExecutionStatisticsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ExecutionStatisticsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ExecutionStatisticsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cpu_time_ms: float,
                 elapsed_time_ms: float,
                 execution_count: float,
                 has_errors: bool,
                 sql_errors: Sequence[str],
                 wait_stats: Optional[Mapping[str, 'outputs.WaitStatisticsResponse']] = None):
        """
        Description about the errors happen while performing migration validation
        :param float cpu_time_ms: CPU Time in millisecond(s) for the query execution
        :param float elapsed_time_ms: Time taken in millisecond(s) for executing the query
        :param float execution_count: No. of query executions
        :param bool has_errors: Indicates whether the query resulted in an error
        :param Sequence[str] sql_errors: List of sql Errors
        :param Mapping[str, 'WaitStatisticsResponse'] wait_stats: Dictionary of sql query execution wait types and the respective statistics
        """
        pulumi.set(__self__, "cpu_time_ms", cpu_time_ms)
        pulumi.set(__self__, "elapsed_time_ms", elapsed_time_ms)
        pulumi.set(__self__, "execution_count", execution_count)
        pulumi.set(__self__, "has_errors", has_errors)
        pulumi.set(__self__, "sql_errors", sql_errors)
        if wait_stats is not None:
            pulumi.set(__self__, "wait_stats", wait_stats)

    @property
    @pulumi.getter(name="cpuTimeMs")
    def cpu_time_ms(self) -> float:
        """
        CPU Time in millisecond(s) for the query execution
        """
        return pulumi.get(self, "cpu_time_ms")

    @property
    @pulumi.getter(name="elapsedTimeMs")
    def elapsed_time_ms(self) -> float:
        """
        Time taken in millisecond(s) for executing the query
        """
        return pulumi.get(self, "elapsed_time_ms")

    @property
    @pulumi.getter(name="executionCount")
    def execution_count(self) -> float:
        """
        No. of query executions
        """
        return pulumi.get(self, "execution_count")

    @property
    @pulumi.getter(name="hasErrors")
    def has_errors(self) -> bool:
        """
        Indicates whether the query resulted in an error
        """
        return pulumi.get(self, "has_errors")

    @property
    @pulumi.getter(name="sqlErrors")
    def sql_errors(self) -> Sequence[str]:
        """
        List of sql Errors
        """
        return pulumi.get(self, "sql_errors")

    @property
    @pulumi.getter(name="waitStats")
    def wait_stats(self) -> Optional[Mapping[str, 'outputs.WaitStatisticsResponse']]:
        """
        Dictionary of sql query execution wait types and the respective statistics
        """
        return pulumi.get(self, "wait_stats")


@pulumi.output_type
class FileShareResponse(dict):
    """
    File share information with Path, Username, and Password.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "userName":
            suggest = "user_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FileShareResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FileShareResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FileShareResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 path: str,
                 password: Optional[str] = None,
                 user_name: Optional[str] = None):
        """
        File share information with Path, Username, and Password.
        :param str path: The folder path for this share.
        :param str password: Password credential used to connect to the share location.
        :param str user_name: User name credential to connect to the share location
        """
        pulumi.set(__self__, "path", path)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if user_name is not None:
            pulumi.set(__self__, "user_name", user_name)

    @property
    @pulumi.getter
    def path(self) -> str:
        """
        The folder path for this share.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def password(self) -> Optional[str]:
        """
        Password credential used to connect to the share location.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> Optional[str]:
        """
        User name credential to connect to the share location
        """
        return pulumi.get(self, "user_name")


@pulumi.output_type
class GetTdeCertificatesSqlTaskInputResponse(dict):
    """
    Input for the task that gets TDE certificates in Base64 encoded format.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backupFileShare":
            suggest = "backup_file_share"
        elif key == "connectionInfo":
            suggest = "connection_info"
        elif key == "selectedCertificates":
            suggest = "selected_certificates"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GetTdeCertificatesSqlTaskInputResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GetTdeCertificatesSqlTaskInputResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GetTdeCertificatesSqlTaskInputResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backup_file_share: 'outputs.FileShareResponse',
                 connection_info: 'outputs.SqlConnectionInfoResponse',
                 selected_certificates: Sequence['outputs.SelectedCertificateInputResponse']):
        """
        Input for the task that gets TDE certificates in Base64 encoded format.
        :param 'FileShareResponse' backup_file_share: Backup file share information for file share to be used for temporarily storing files.
        :param 'SqlConnectionInfoResponse' connection_info: Connection information for SQL Server
        :param Sequence['SelectedCertificateInputResponse'] selected_certificates: List containing certificate names and corresponding password to use for encrypting the exported certificate.
        """
        pulumi.set(__self__, "backup_file_share", backup_file_share)
        pulumi.set(__self__, "connection_info", connection_info)
        pulumi.set(__self__, "selected_certificates", selected_certificates)

    @property
    @pulumi.getter(name="backupFileShare")
    def backup_file_share(self) -> 'outputs.FileShareResponse':
        """
        Backup file share information for file share to be used for temporarily storing files.
        """
        return pulumi.get(self, "backup_file_share")

    @property
    @pulumi.getter(name="connectionInfo")
    def connection_info(self) -> 'outputs.SqlConnectionInfoResponse':
        """
        Connection information for SQL Server
        """
        return pulumi.get(self, "connection_info")

    @property
    @pulumi.getter(name="selectedCertificates")
    def selected_certificates(self) -> Sequence['outputs.SelectedCertificateInputResponse']:
        """
        List containing certificate names and corresponding password to use for encrypting the exported certificate.
        """
        return pulumi.get(self, "selected_certificates")


@pulumi.output_type
class GetTdeCertificatesSqlTaskOutputResponse(dict):
    """
    Output of the task that gets TDE certificates in Base64 encoded format.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "base64EncodedCertificates":
            suggest = "base64_encoded_certificates"
        elif key == "validationErrors":
            suggest = "validation_errors"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GetTdeCertificatesSqlTaskOutputResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GetTdeCertificatesSqlTaskOutputResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GetTdeCertificatesSqlTaskOutputResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 base64_encoded_certificates: Mapping[str, Sequence[str]],
                 validation_errors: Sequence['outputs.ReportableExceptionResponse']):
        """
        Output of the task that gets TDE certificates in Base64 encoded format.
        :param Mapping[str, Sequence[str]] base64_encoded_certificates: Mapping from certificate name to base 64 encoded format.
        :param Sequence['ReportableExceptionResponse'] validation_errors: Validation errors
        """
        pulumi.set(__self__, "base64_encoded_certificates", base64_encoded_certificates)
        pulumi.set(__self__, "validation_errors", validation_errors)

    @property
    @pulumi.getter(name="base64EncodedCertificates")
    def base64_encoded_certificates(self) -> Mapping[str, Sequence[str]]:
        """
        Mapping from certificate name to base 64 encoded format.
        """
        return pulumi.get(self, "base64_encoded_certificates")

    @property
    @pulumi.getter(name="validationErrors")
    def validation_errors(self) -> Sequence['outputs.ReportableExceptionResponse']:
        """
        Validation errors
        """
        return pulumi.get(self, "validation_errors")


@pulumi.output_type
class GetTdeCertificatesSqlTaskPropertiesResponse(dict):
    """
    Properties for the task that gets TDE certificates in Base64 encoded format.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "taskType":
            suggest = "task_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GetTdeCertificatesSqlTaskPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GetTdeCertificatesSqlTaskPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GetTdeCertificatesSqlTaskPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 commands: Sequence[Any],
                 errors: Sequence['outputs.ODataErrorResponse'],
                 output: Sequence['outputs.GetTdeCertificatesSqlTaskOutputResponse'],
                 state: str,
                 task_type: str,
                 input: Optional['outputs.GetTdeCertificatesSqlTaskInputResponse'] = None):
        """
        Properties for the task that gets TDE certificates in Base64 encoded format.
        :param Sequence[Union['MigrateMISyncCompleteCommandPropertiesResponse', 'MigrateSyncCompleteCommandPropertiesResponse']] commands: Array of command properties.
        :param Sequence['ODataErrorResponse'] errors: Array of errors. This is ignored if submitted.
        :param Sequence['GetTdeCertificatesSqlTaskOutputResponse'] output: Task output. This is ignored if submitted.
        :param str state: The state of the task. This is ignored if submitted.
        :param str task_type: Task type.
               Expected value is 'GetTDECertificates.Sql'.
        :param 'GetTdeCertificatesSqlTaskInputResponse' input: Task input
        """
        pulumi.set(__self__, "commands", commands)
        pulumi.set(__self__, "errors", errors)
        pulumi.set(__self__, "output", output)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "task_type", 'GetTDECertificates.Sql')
        if input is not None:
            pulumi.set(__self__, "input", input)

    @property
    @pulumi.getter
    def commands(self) -> Sequence[Any]:
        """
        Array of command properties.
        """
        return pulumi.get(self, "commands")

    @property
    @pulumi.getter
    def errors(self) -> Sequence['outputs.ODataErrorResponse']:
        """
        Array of errors. This is ignored if submitted.
        """
        return pulumi.get(self, "errors")

    @property
    @pulumi.getter
    def output(self) -> Sequence['outputs.GetTdeCertificatesSqlTaskOutputResponse']:
        """
        Task output. This is ignored if submitted.
        """
        return pulumi.get(self, "output")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The state of the task. This is ignored if submitted.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="taskType")
    def task_type(self) -> str:
        """
        Task type.
        Expected value is 'GetTDECertificates.Sql'.
        """
        return pulumi.get(self, "task_type")

    @property
    @pulumi.getter
    def input(self) -> Optional['outputs.GetTdeCertificatesSqlTaskInputResponse']:
        """
        Task input
        """
        return pulumi.get(self, "input")


@pulumi.output_type
class GetUserTablesSqlSyncTaskInputResponse(dict):
    """
    Input for the task that collects user tables for the given list of databases
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "selectedSourceDatabases":
            suggest = "selected_source_databases"
        elif key == "selectedTargetDatabases":
            suggest = "selected_target_databases"
        elif key == "sourceConnectionInfo":
            suggest = "source_connection_info"
        elif key == "targetConnectionInfo":
            suggest = "target_connection_info"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GetUserTablesSqlSyncTaskInputResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GetUserTablesSqlSyncTaskInputResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GetUserTablesSqlSyncTaskInputResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 selected_source_databases: Sequence[str],
                 selected_target_databases: Sequence[str],
                 source_connection_info: 'outputs.SqlConnectionInfoResponse',
                 target_connection_info: 'outputs.SqlConnectionInfoResponse'):
        """
        Input for the task that collects user tables for the given list of databases
        :param Sequence[str] selected_source_databases: List of source database names to collect tables for
        :param Sequence[str] selected_target_databases: List of target database names to collect tables for
        :param 'SqlConnectionInfoResponse' source_connection_info: Connection information for SQL Server
        :param 'SqlConnectionInfoResponse' target_connection_info: Connection information for SQL DB
        """
        pulumi.set(__self__, "selected_source_databases", selected_source_databases)
        pulumi.set(__self__, "selected_target_databases", selected_target_databases)
        pulumi.set(__self__, "source_connection_info", source_connection_info)
        pulumi.set(__self__, "target_connection_info", target_connection_info)

    @property
    @pulumi.getter(name="selectedSourceDatabases")
    def selected_source_databases(self) -> Sequence[str]:
        """
        List of source database names to collect tables for
        """
        return pulumi.get(self, "selected_source_databases")

    @property
    @pulumi.getter(name="selectedTargetDatabases")
    def selected_target_databases(self) -> Sequence[str]:
        """
        List of target database names to collect tables for
        """
        return pulumi.get(self, "selected_target_databases")

    @property
    @pulumi.getter(name="sourceConnectionInfo")
    def source_connection_info(self) -> 'outputs.SqlConnectionInfoResponse':
        """
        Connection information for SQL Server
        """
        return pulumi.get(self, "source_connection_info")

    @property
    @pulumi.getter(name="targetConnectionInfo")
    def target_connection_info(self) -> 'outputs.SqlConnectionInfoResponse':
        """
        Connection information for SQL DB
        """
        return pulumi.get(self, "target_connection_info")


@pulumi.output_type
class GetUserTablesSqlSyncTaskOutputResponse(dict):
    """
    Output of the task that collects user tables for the given list of databases
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "databasesToSourceTables":
            suggest = "databases_to_source_tables"
        elif key == "databasesToTargetTables":
            suggest = "databases_to_target_tables"
        elif key == "tableValidationErrors":
            suggest = "table_validation_errors"
        elif key == "validationErrors":
            suggest = "validation_errors"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GetUserTablesSqlSyncTaskOutputResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GetUserTablesSqlSyncTaskOutputResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GetUserTablesSqlSyncTaskOutputResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 databases_to_source_tables: Mapping[str, Sequence['outputs.DatabaseTableResponse']],
                 databases_to_target_tables: Mapping[str, Sequence['outputs.DatabaseTableResponse']],
                 table_validation_errors: Mapping[str, Sequence[str]],
                 validation_errors: Sequence['outputs.ReportableExceptionResponse']):
        """
        Output of the task that collects user tables for the given list of databases
        :param Mapping[str, Sequence['DatabaseTableResponse']] databases_to_source_tables: Mapping from database name to list of source tables
        :param Mapping[str, Sequence['DatabaseTableResponse']] databases_to_target_tables: Mapping from database name to list of target tables
        :param Mapping[str, Sequence[str]] table_validation_errors: Mapping from database name to list of validation errors
        :param Sequence['ReportableExceptionResponse'] validation_errors: Validation errors
        """
        pulumi.set(__self__, "databases_to_source_tables", databases_to_source_tables)
        pulumi.set(__self__, "databases_to_target_tables", databases_to_target_tables)
        pulumi.set(__self__, "table_validation_errors", table_validation_errors)
        pulumi.set(__self__, "validation_errors", validation_errors)

    @property
    @pulumi.getter(name="databasesToSourceTables")
    def databases_to_source_tables(self) -> Mapping[str, Sequence['outputs.DatabaseTableResponse']]:
        """
        Mapping from database name to list of source tables
        """
        return pulumi.get(self, "databases_to_source_tables")

    @property
    @pulumi.getter(name="databasesToTargetTables")
    def databases_to_target_tables(self) -> Mapping[str, Sequence['outputs.DatabaseTableResponse']]:
        """
        Mapping from database name to list of target tables
        """
        return pulumi.get(self, "databases_to_target_tables")

    @property
    @pulumi.getter(name="tableValidationErrors")
    def table_validation_errors(self) -> Mapping[str, Sequence[str]]:
        """
        Mapping from database name to list of validation errors
        """
        return pulumi.get(self, "table_validation_errors")

    @property
    @pulumi.getter(name="validationErrors")
    def validation_errors(self) -> Sequence['outputs.ReportableExceptionResponse']:
        """
        Validation errors
        """
        return pulumi.get(self, "validation_errors")


@pulumi.output_type
class GetUserTablesSqlSyncTaskPropertiesResponse(dict):
    """
    Properties for the task that collects user tables for the given list of databases
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "taskType":
            suggest = "task_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GetUserTablesSqlSyncTaskPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GetUserTablesSqlSyncTaskPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GetUserTablesSqlSyncTaskPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 commands: Sequence[Any],
                 errors: Sequence['outputs.ODataErrorResponse'],
                 output: Sequence['outputs.GetUserTablesSqlSyncTaskOutputResponse'],
                 state: str,
                 task_type: str,
                 input: Optional['outputs.GetUserTablesSqlSyncTaskInputResponse'] = None):
        """
        Properties for the task that collects user tables for the given list of databases
        :param Sequence[Union['MigrateMISyncCompleteCommandPropertiesResponse', 'MigrateSyncCompleteCommandPropertiesResponse']] commands: Array of command properties.
        :param Sequence['ODataErrorResponse'] errors: Array of errors. This is ignored if submitted.
        :param Sequence['GetUserTablesSqlSyncTaskOutputResponse'] output: Task output. This is ignored if submitted.
        :param str state: The state of the task. This is ignored if submitted.
        :param str task_type: Task type.
               Expected value is 'GetUserTables.AzureSqlDb.Sync'.
        :param 'GetUserTablesSqlSyncTaskInputResponse' input: Task input
        """
        pulumi.set(__self__, "commands", commands)
        pulumi.set(__self__, "errors", errors)
        pulumi.set(__self__, "output", output)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "task_type", 'GetUserTables.AzureSqlDb.Sync')
        if input is not None:
            pulumi.set(__self__, "input", input)

    @property
    @pulumi.getter
    def commands(self) -> Sequence[Any]:
        """
        Array of command properties.
        """
        return pulumi.get(self, "commands")

    @property
    @pulumi.getter
    def errors(self) -> Sequence['outputs.ODataErrorResponse']:
        """
        Array of errors. This is ignored if submitted.
        """
        return pulumi.get(self, "errors")

    @property
    @pulumi.getter
    def output(self) -> Sequence['outputs.GetUserTablesSqlSyncTaskOutputResponse']:
        """
        Task output. This is ignored if submitted.
        """
        return pulumi.get(self, "output")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The state of the task. This is ignored if submitted.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="taskType")
    def task_type(self) -> str:
        """
        Task type.
        Expected value is 'GetUserTables.AzureSqlDb.Sync'.
        """
        return pulumi.get(self, "task_type")

    @property
    @pulumi.getter
    def input(self) -> Optional['outputs.GetUserTablesSqlSyncTaskInputResponse']:
        """
        Task input
        """
        return pulumi.get(self, "input")


@pulumi.output_type
class GetUserTablesSqlTaskInputResponse(dict):
    """
    Input for the task that collects user tables for the given list of databases
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "connectionInfo":
            suggest = "connection_info"
        elif key == "selectedDatabases":
            suggest = "selected_databases"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GetUserTablesSqlTaskInputResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GetUserTablesSqlTaskInputResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GetUserTablesSqlTaskInputResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 connection_info: 'outputs.SqlConnectionInfoResponse',
                 selected_databases: Sequence[str]):
        """
        Input for the task that collects user tables for the given list of databases
        :param 'SqlConnectionInfoResponse' connection_info: Connection information for SQL Server
        :param Sequence[str] selected_databases: List of database names to collect tables for
        """
        pulumi.set(__self__, "connection_info", connection_info)
        pulumi.set(__self__, "selected_databases", selected_databases)

    @property
    @pulumi.getter(name="connectionInfo")
    def connection_info(self) -> 'outputs.SqlConnectionInfoResponse':
        """
        Connection information for SQL Server
        """
        return pulumi.get(self, "connection_info")

    @property
    @pulumi.getter(name="selectedDatabases")
    def selected_databases(self) -> Sequence[str]:
        """
        List of database names to collect tables for
        """
        return pulumi.get(self, "selected_databases")


@pulumi.output_type
class GetUserTablesSqlTaskOutputResponse(dict):
    """
    Output of the task that collects user tables for the given list of databases
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "databasesToTables":
            suggest = "databases_to_tables"
        elif key == "validationErrors":
            suggest = "validation_errors"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GetUserTablesSqlTaskOutputResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GetUserTablesSqlTaskOutputResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GetUserTablesSqlTaskOutputResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 databases_to_tables: Mapping[str, Sequence['outputs.DatabaseTableResponse']],
                 id: str,
                 validation_errors: Sequence['outputs.ReportableExceptionResponse']):
        """
        Output of the task that collects user tables for the given list of databases
        :param Mapping[str, Sequence['DatabaseTableResponse']] databases_to_tables: Mapping from database name to list of tables
        :param str id: Result identifier
        :param Sequence['ReportableExceptionResponse'] validation_errors: Validation errors
        """
        pulumi.set(__self__, "databases_to_tables", databases_to_tables)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "validation_errors", validation_errors)

    @property
    @pulumi.getter(name="databasesToTables")
    def databases_to_tables(self) -> Mapping[str, Sequence['outputs.DatabaseTableResponse']]:
        """
        Mapping from database name to list of tables
        """
        return pulumi.get(self, "databases_to_tables")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Result identifier
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="validationErrors")
    def validation_errors(self) -> Sequence['outputs.ReportableExceptionResponse']:
        """
        Validation errors
        """
        return pulumi.get(self, "validation_errors")


@pulumi.output_type
class GetUserTablesSqlTaskPropertiesResponse(dict):
    """
    Properties for the task that collects user tables for the given list of databases
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "taskType":
            suggest = "task_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GetUserTablesSqlTaskPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GetUserTablesSqlTaskPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GetUserTablesSqlTaskPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 commands: Sequence[Any],
                 errors: Sequence['outputs.ODataErrorResponse'],
                 output: Sequence['outputs.GetUserTablesSqlTaskOutputResponse'],
                 state: str,
                 task_type: str,
                 input: Optional['outputs.GetUserTablesSqlTaskInputResponse'] = None):
        """
        Properties for the task that collects user tables for the given list of databases
        :param Sequence[Union['MigrateMISyncCompleteCommandPropertiesResponse', 'MigrateSyncCompleteCommandPropertiesResponse']] commands: Array of command properties.
        :param Sequence['ODataErrorResponse'] errors: Array of errors. This is ignored if submitted.
        :param Sequence['GetUserTablesSqlTaskOutputResponse'] output: Task output. This is ignored if submitted.
        :param str state: The state of the task. This is ignored if submitted.
        :param str task_type: Task type.
               Expected value is 'GetUserTables.Sql'.
        :param 'GetUserTablesSqlTaskInputResponse' input: Task input
        """
        pulumi.set(__self__, "commands", commands)
        pulumi.set(__self__, "errors", errors)
        pulumi.set(__self__, "output", output)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "task_type", 'GetUserTables.Sql')
        if input is not None:
            pulumi.set(__self__, "input", input)

    @property
    @pulumi.getter
    def commands(self) -> Sequence[Any]:
        """
        Array of command properties.
        """
        return pulumi.get(self, "commands")

    @property
    @pulumi.getter
    def errors(self) -> Sequence['outputs.ODataErrorResponse']:
        """
        Array of errors. This is ignored if submitted.
        """
        return pulumi.get(self, "errors")

    @property
    @pulumi.getter
    def output(self) -> Sequence['outputs.GetUserTablesSqlTaskOutputResponse']:
        """
        Task output. This is ignored if submitted.
        """
        return pulumi.get(self, "output")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The state of the task. This is ignored if submitted.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="taskType")
    def task_type(self) -> str:
        """
        Task type.
        Expected value is 'GetUserTables.Sql'.
        """
        return pulumi.get(self, "task_type")

    @property
    @pulumi.getter
    def input(self) -> Optional['outputs.GetUserTablesSqlTaskInputResponse']:
        """
        Task input
        """
        return pulumi.get(self, "input")


@pulumi.output_type
class MiSqlConnectionInfoResponse(dict):
    """
    Properties required to create a connection to Azure SQL database Managed instance
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "managedInstanceResourceId":
            suggest = "managed_instance_resource_id"
        elif key == "userName":
            suggest = "user_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MiSqlConnectionInfoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MiSqlConnectionInfoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MiSqlConnectionInfoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 managed_instance_resource_id: str,
                 type: str,
                 password: Optional[str] = None,
                 user_name: Optional[str] = None):
        """
        Properties required to create a connection to Azure SQL database Managed instance
        :param str managed_instance_resource_id: Resource id for Azure SQL database Managed instance
        :param str type: Type of connection info
               Expected value is 'MiSqlConnectionInfo'.
        :param str password: Password credential.
        :param str user_name: User name
        """
        pulumi.set(__self__, "managed_instance_resource_id", managed_instance_resource_id)
        pulumi.set(__self__, "type", 'MiSqlConnectionInfo')
        if password is not None:
            pulumi.set(__self__, "password", password)
        if user_name is not None:
            pulumi.set(__self__, "user_name", user_name)

    @property
    @pulumi.getter(name="managedInstanceResourceId")
    def managed_instance_resource_id(self) -> str:
        """
        Resource id for Azure SQL database Managed instance
        """
        return pulumi.get(self, "managed_instance_resource_id")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of connection info
        Expected value is 'MiSqlConnectionInfo'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def password(self) -> Optional[str]:
        """
        Password credential.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> Optional[str]:
        """
        User name
        """
        return pulumi.get(self, "user_name")


@pulumi.output_type
class MigrateMISyncCompleteCommandInputResponse(dict):
    """
    Input for command that completes online migration for an Azure SQL Database Managed Instance.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceDatabaseName":
            suggest = "source_database_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MigrateMISyncCompleteCommandInputResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MigrateMISyncCompleteCommandInputResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MigrateMISyncCompleteCommandInputResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 source_database_name: str):
        """
        Input for command that completes online migration for an Azure SQL Database Managed Instance.
        :param str source_database_name: Name of managed instance database
        """
        pulumi.set(__self__, "source_database_name", source_database_name)

    @property
    @pulumi.getter(name="sourceDatabaseName")
    def source_database_name(self) -> str:
        """
        Name of managed instance database
        """
        return pulumi.get(self, "source_database_name")


@pulumi.output_type
class MigrateMISyncCompleteCommandOutputResponse(dict):
    """
    Output for command that completes online migration for an Azure SQL Database Managed Instance.
    """
    def __init__(__self__, *,
                 errors: Optional[Sequence['outputs.ReportableExceptionResponse']] = None):
        """
        Output for command that completes online migration for an Azure SQL Database Managed Instance.
        :param Sequence['ReportableExceptionResponse'] errors: List of errors that happened during the command execution
        """
        if errors is not None:
            pulumi.set(__self__, "errors", errors)

    @property
    @pulumi.getter
    def errors(self) -> Optional[Sequence['outputs.ReportableExceptionResponse']]:
        """
        List of errors that happened during the command execution
        """
        return pulumi.get(self, "errors")


@pulumi.output_type
class MigrateMISyncCompleteCommandPropertiesResponse(dict):
    """
    Properties for the command that completes online migration for an Azure SQL Database Managed Instance.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "commandType":
            suggest = "command_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MigrateMISyncCompleteCommandPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MigrateMISyncCompleteCommandPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MigrateMISyncCompleteCommandPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 command_type: str,
                 errors: Sequence['outputs.ODataErrorResponse'],
                 output: 'outputs.MigrateMISyncCompleteCommandOutputResponse',
                 state: str,
                 input: Optional['outputs.MigrateMISyncCompleteCommandInputResponse'] = None):
        """
        Properties for the command that completes online migration for an Azure SQL Database Managed Instance.
        :param str command_type: Command type.
               Expected value is 'Migrate.SqlServer.AzureDbSqlMi.Complete'.
        :param Sequence['ODataErrorResponse'] errors: Array of errors. This is ignored if submitted.
        :param 'MigrateMISyncCompleteCommandOutputResponse' output: Command output. This is ignored if submitted.
        :param str state: The state of the command. This is ignored if submitted.
        :param 'MigrateMISyncCompleteCommandInputResponse' input: Command input
        """
        pulumi.set(__self__, "command_type", 'Migrate.SqlServer.AzureDbSqlMi.Complete')
        pulumi.set(__self__, "errors", errors)
        pulumi.set(__self__, "output", output)
        pulumi.set(__self__, "state", state)
        if input is not None:
            pulumi.set(__self__, "input", input)

    @property
    @pulumi.getter(name="commandType")
    def command_type(self) -> str:
        """
        Command type.
        Expected value is 'Migrate.SqlServer.AzureDbSqlMi.Complete'.
        """
        return pulumi.get(self, "command_type")

    @property
    @pulumi.getter
    def errors(self) -> Sequence['outputs.ODataErrorResponse']:
        """
        Array of errors. This is ignored if submitted.
        """
        return pulumi.get(self, "errors")

    @property
    @pulumi.getter
    def output(self) -> 'outputs.MigrateMISyncCompleteCommandOutputResponse':
        """
        Command output. This is ignored if submitted.
        """
        return pulumi.get(self, "output")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The state of the command. This is ignored if submitted.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def input(self) -> Optional['outputs.MigrateMISyncCompleteCommandInputResponse']:
        """
        Command input
        """
        return pulumi.get(self, "input")


@pulumi.output_type
class MigrateMySqlAzureDbForMySqlSyncDatabaseInputResponse(dict):
    """
    Database specific information for MySQL to Azure Database for MySQL migration task inputs
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "migrationSetting":
            suggest = "migration_setting"
        elif key == "sourceSetting":
            suggest = "source_setting"
        elif key == "targetDatabaseName":
            suggest = "target_database_name"
        elif key == "targetSetting":
            suggest = "target_setting"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MigrateMySqlAzureDbForMySqlSyncDatabaseInputResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MigrateMySqlAzureDbForMySqlSyncDatabaseInputResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MigrateMySqlAzureDbForMySqlSyncDatabaseInputResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 migration_setting: Optional[Mapping[str, str]] = None,
                 name: Optional[str] = None,
                 source_setting: Optional[Mapping[str, str]] = None,
                 target_database_name: Optional[str] = None,
                 target_setting: Optional[Mapping[str, str]] = None):
        """
        Database specific information for MySQL to Azure Database for MySQL migration task inputs
        :param Mapping[str, str] migration_setting: Migration settings which tune the migration behavior
        :param str name: Name of the database
        :param Mapping[str, str] source_setting: Source settings to tune source endpoint migration behavior
        :param str target_database_name: Name of target database. Note: Target database will be truncated before starting migration.
        :param Mapping[str, str] target_setting: Target settings to tune target endpoint migration behavior
        """
        if migration_setting is not None:
            pulumi.set(__self__, "migration_setting", migration_setting)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if source_setting is not None:
            pulumi.set(__self__, "source_setting", source_setting)
        if target_database_name is not None:
            pulumi.set(__self__, "target_database_name", target_database_name)
        if target_setting is not None:
            pulumi.set(__self__, "target_setting", target_setting)

    @property
    @pulumi.getter(name="migrationSetting")
    def migration_setting(self) -> Optional[Mapping[str, str]]:
        """
        Migration settings which tune the migration behavior
        """
        return pulumi.get(self, "migration_setting")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the database
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="sourceSetting")
    def source_setting(self) -> Optional[Mapping[str, str]]:
        """
        Source settings to tune source endpoint migration behavior
        """
        return pulumi.get(self, "source_setting")

    @property
    @pulumi.getter(name="targetDatabaseName")
    def target_database_name(self) -> Optional[str]:
        """
        Name of target database. Note: Target database will be truncated before starting migration.
        """
        return pulumi.get(self, "target_database_name")

    @property
    @pulumi.getter(name="targetSetting")
    def target_setting(self) -> Optional[Mapping[str, str]]:
        """
        Target settings to tune target endpoint migration behavior
        """
        return pulumi.get(self, "target_setting")


@pulumi.output_type
class MigrateMySqlAzureDbForMySqlSyncTaskInputResponse(dict):
    """
    Input for the task that migrates MySQL databases to Azure Database for MySQL for online migrations
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "selectedDatabases":
            suggest = "selected_databases"
        elif key == "sourceConnectionInfo":
            suggest = "source_connection_info"
        elif key == "targetConnectionInfo":
            suggest = "target_connection_info"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MigrateMySqlAzureDbForMySqlSyncTaskInputResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MigrateMySqlAzureDbForMySqlSyncTaskInputResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MigrateMySqlAzureDbForMySqlSyncTaskInputResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 selected_databases: Sequence['outputs.MigrateMySqlAzureDbForMySqlSyncDatabaseInputResponse'],
                 source_connection_info: 'outputs.MySqlConnectionInfoResponse',
                 target_connection_info: 'outputs.MySqlConnectionInfoResponse'):
        """
        Input for the task that migrates MySQL databases to Azure Database for MySQL for online migrations
        :param Sequence['MigrateMySqlAzureDbForMySqlSyncDatabaseInputResponse'] selected_databases: Databases to migrate
        :param 'MySqlConnectionInfoResponse' source_connection_info: Connection information for source MySQL
        :param 'MySqlConnectionInfoResponse' target_connection_info: Connection information for target Azure Database for MySQL
        """
        pulumi.set(__self__, "selected_databases", selected_databases)
        pulumi.set(__self__, "source_connection_info", source_connection_info)
        pulumi.set(__self__, "target_connection_info", target_connection_info)

    @property
    @pulumi.getter(name="selectedDatabases")
    def selected_databases(self) -> Sequence['outputs.MigrateMySqlAzureDbForMySqlSyncDatabaseInputResponse']:
        """
        Databases to migrate
        """
        return pulumi.get(self, "selected_databases")

    @property
    @pulumi.getter(name="sourceConnectionInfo")
    def source_connection_info(self) -> 'outputs.MySqlConnectionInfoResponse':
        """
        Connection information for source MySQL
        """
        return pulumi.get(self, "source_connection_info")

    @property
    @pulumi.getter(name="targetConnectionInfo")
    def target_connection_info(self) -> 'outputs.MySqlConnectionInfoResponse':
        """
        Connection information for target Azure Database for MySQL
        """
        return pulumi.get(self, "target_connection_info")


@pulumi.output_type
class MigrateMySqlAzureDbForMySqlSyncTaskOutputDatabaseErrorResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resultType":
            suggest = "result_type"
        elif key == "errorMessage":
            suggest = "error_message"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MigrateMySqlAzureDbForMySqlSyncTaskOutputDatabaseErrorResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MigrateMySqlAzureDbForMySqlSyncTaskOutputDatabaseErrorResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MigrateMySqlAzureDbForMySqlSyncTaskOutputDatabaseErrorResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: str,
                 result_type: str,
                 error_message: Optional[str] = None,
                 events: Optional[Sequence['outputs.SyncMigrationDatabaseErrorEventResponse']] = None):
        """
        :param str id: Result identifier
        :param str result_type: Result type
               Expected value is 'DatabaseLevelErrorOutput'.
        :param str error_message: Error message
        :param Sequence['SyncMigrationDatabaseErrorEventResponse'] events: List of error events.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "result_type", 'DatabaseLevelErrorOutput')
        if error_message is not None:
            pulumi.set(__self__, "error_message", error_message)
        if events is not None:
            pulumi.set(__self__, "events", events)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Result identifier
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="resultType")
    def result_type(self) -> str:
        """
        Result type
        Expected value is 'DatabaseLevelErrorOutput'.
        """
        return pulumi.get(self, "result_type")

    @property
    @pulumi.getter(name="errorMessage")
    def error_message(self) -> Optional[str]:
        """
        Error message
        """
        return pulumi.get(self, "error_message")

    @property
    @pulumi.getter
    def events(self) -> Optional[Sequence['outputs.SyncMigrationDatabaseErrorEventResponse']]:
        """
        List of error events.
        """
        return pulumi.get(self, "events")


@pulumi.output_type
class MigrateMySqlAzureDbForMySqlSyncTaskOutputDatabaseLevelResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "appliedChanges":
            suggest = "applied_changes"
        elif key == "cdcDeleteCounter":
            suggest = "cdc_delete_counter"
        elif key == "cdcInsertCounter":
            suggest = "cdc_insert_counter"
        elif key == "cdcUpdateCounter":
            suggest = "cdc_update_counter"
        elif key == "databaseName":
            suggest = "database_name"
        elif key == "endedOn":
            suggest = "ended_on"
        elif key == "fullLoadCompletedTables":
            suggest = "full_load_completed_tables"
        elif key == "fullLoadErroredTables":
            suggest = "full_load_errored_tables"
        elif key == "fullLoadLoadingTables":
            suggest = "full_load_loading_tables"
        elif key == "fullLoadQueuedTables":
            suggest = "full_load_queued_tables"
        elif key == "incomingChanges":
            suggest = "incoming_changes"
        elif key == "initializationCompleted":
            suggest = "initialization_completed"
        elif key == "migrationState":
            suggest = "migration_state"
        elif key == "resultType":
            suggest = "result_type"
        elif key == "startedOn":
            suggest = "started_on"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MigrateMySqlAzureDbForMySqlSyncTaskOutputDatabaseLevelResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MigrateMySqlAzureDbForMySqlSyncTaskOutputDatabaseLevelResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MigrateMySqlAzureDbForMySqlSyncTaskOutputDatabaseLevelResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 applied_changes: float,
                 cdc_delete_counter: float,
                 cdc_insert_counter: float,
                 cdc_update_counter: float,
                 database_name: str,
                 ended_on: str,
                 full_load_completed_tables: float,
                 full_load_errored_tables: float,
                 full_load_loading_tables: float,
                 full_load_queued_tables: float,
                 id: str,
                 incoming_changes: float,
                 initialization_completed: bool,
                 latency: float,
                 migration_state: str,
                 result_type: str,
                 started_on: str):
        """
        :param float applied_changes: Number of applied changes
        :param float cdc_delete_counter: Number of cdc deletes
        :param float cdc_insert_counter: Number of cdc inserts
        :param float cdc_update_counter: Number of cdc updates
        :param str database_name: Name of the database
        :param str ended_on: Migration end time
        :param float full_load_completed_tables: Number of tables completed in full load
        :param float full_load_errored_tables: Number of tables errored in full load
        :param float full_load_loading_tables: Number of tables loading in full load
        :param float full_load_queued_tables: Number of tables queued in full load
        :param str id: Result identifier
        :param float incoming_changes: Number of incoming changes
        :param bool initialization_completed: Indicates if initial load (full load) has been completed
        :param float latency: CDC apply latency
        :param str migration_state: Migration state that this database is in
        :param str result_type: Result type
               Expected value is 'DatabaseLevelOutput'.
        :param str started_on: Migration start time
        """
        pulumi.set(__self__, "applied_changes", applied_changes)
        pulumi.set(__self__, "cdc_delete_counter", cdc_delete_counter)
        pulumi.set(__self__, "cdc_insert_counter", cdc_insert_counter)
        pulumi.set(__self__, "cdc_update_counter", cdc_update_counter)
        pulumi.set(__self__, "database_name", database_name)
        pulumi.set(__self__, "ended_on", ended_on)
        pulumi.set(__self__, "full_load_completed_tables", full_load_completed_tables)
        pulumi.set(__self__, "full_load_errored_tables", full_load_errored_tables)
        pulumi.set(__self__, "full_load_loading_tables", full_load_loading_tables)
        pulumi.set(__self__, "full_load_queued_tables", full_load_queued_tables)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "incoming_changes", incoming_changes)
        pulumi.set(__self__, "initialization_completed", initialization_completed)
        pulumi.set(__self__, "latency", latency)
        pulumi.set(__self__, "migration_state", migration_state)
        pulumi.set(__self__, "result_type", 'DatabaseLevelOutput')
        pulumi.set(__self__, "started_on", started_on)

    @property
    @pulumi.getter(name="appliedChanges")
    def applied_changes(self) -> float:
        """
        Number of applied changes
        """
        return pulumi.get(self, "applied_changes")

    @property
    @pulumi.getter(name="cdcDeleteCounter")
    def cdc_delete_counter(self) -> float:
        """
        Number of cdc deletes
        """
        return pulumi.get(self, "cdc_delete_counter")

    @property
    @pulumi.getter(name="cdcInsertCounter")
    def cdc_insert_counter(self) -> float:
        """
        Number of cdc inserts
        """
        return pulumi.get(self, "cdc_insert_counter")

    @property
    @pulumi.getter(name="cdcUpdateCounter")
    def cdc_update_counter(self) -> float:
        """
        Number of cdc updates
        """
        return pulumi.get(self, "cdc_update_counter")

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> str:
        """
        Name of the database
        """
        return pulumi.get(self, "database_name")

    @property
    @pulumi.getter(name="endedOn")
    def ended_on(self) -> str:
        """
        Migration end time
        """
        return pulumi.get(self, "ended_on")

    @property
    @pulumi.getter(name="fullLoadCompletedTables")
    def full_load_completed_tables(self) -> float:
        """
        Number of tables completed in full load
        """
        return pulumi.get(self, "full_load_completed_tables")

    @property
    @pulumi.getter(name="fullLoadErroredTables")
    def full_load_errored_tables(self) -> float:
        """
        Number of tables errored in full load
        """
        return pulumi.get(self, "full_load_errored_tables")

    @property
    @pulumi.getter(name="fullLoadLoadingTables")
    def full_load_loading_tables(self) -> float:
        """
        Number of tables loading in full load
        """
        return pulumi.get(self, "full_load_loading_tables")

    @property
    @pulumi.getter(name="fullLoadQueuedTables")
    def full_load_queued_tables(self) -> float:
        """
        Number of tables queued in full load
        """
        return pulumi.get(self, "full_load_queued_tables")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Result identifier
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="incomingChanges")
    def incoming_changes(self) -> float:
        """
        Number of incoming changes
        """
        return pulumi.get(self, "incoming_changes")

    @property
    @pulumi.getter(name="initializationCompleted")
    def initialization_completed(self) -> bool:
        """
        Indicates if initial load (full load) has been completed
        """
        return pulumi.get(self, "initialization_completed")

    @property
    @pulumi.getter
    def latency(self) -> float:
        """
        CDC apply latency
        """
        return pulumi.get(self, "latency")

    @property
    @pulumi.getter(name="migrationState")
    def migration_state(self) -> str:
        """
        Migration state that this database is in
        """
        return pulumi.get(self, "migration_state")

    @property
    @pulumi.getter(name="resultType")
    def result_type(self) -> str:
        """
        Result type
        Expected value is 'DatabaseLevelOutput'.
        """
        return pulumi.get(self, "result_type")

    @property
    @pulumi.getter(name="startedOn")
    def started_on(self) -> str:
        """
        Migration start time
        """
        return pulumi.get(self, "started_on")


@pulumi.output_type
class MigrateMySqlAzureDbForMySqlSyncTaskOutputErrorResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resultType":
            suggest = "result_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MigrateMySqlAzureDbForMySqlSyncTaskOutputErrorResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MigrateMySqlAzureDbForMySqlSyncTaskOutputErrorResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MigrateMySqlAzureDbForMySqlSyncTaskOutputErrorResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 error: 'outputs.ReportableExceptionResponse',
                 id: str,
                 result_type: str):
        """
        :param 'ReportableExceptionResponse' error: Migration error
        :param str id: Result identifier
        :param str result_type: Result type
               Expected value is 'ErrorOutput'.
        """
        pulumi.set(__self__, "error", error)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "result_type", 'ErrorOutput')

    @property
    @pulumi.getter
    def error(self) -> 'outputs.ReportableExceptionResponse':
        """
        Migration error
        """
        return pulumi.get(self, "error")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Result identifier
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="resultType")
    def result_type(self) -> str:
        """
        Result type
        Expected value is 'ErrorOutput'.
        """
        return pulumi.get(self, "result_type")


@pulumi.output_type
class MigrateMySqlAzureDbForMySqlSyncTaskOutputMigrationLevelResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endedOn":
            suggest = "ended_on"
        elif key == "resultType":
            suggest = "result_type"
        elif key == "sourceServer":
            suggest = "source_server"
        elif key == "sourceServerVersion":
            suggest = "source_server_version"
        elif key == "startedOn":
            suggest = "started_on"
        elif key == "targetServer":
            suggest = "target_server"
        elif key == "targetServerVersion":
            suggest = "target_server_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MigrateMySqlAzureDbForMySqlSyncTaskOutputMigrationLevelResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MigrateMySqlAzureDbForMySqlSyncTaskOutputMigrationLevelResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MigrateMySqlAzureDbForMySqlSyncTaskOutputMigrationLevelResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ended_on: str,
                 id: str,
                 result_type: str,
                 source_server: str,
                 source_server_version: str,
                 started_on: str,
                 target_server: str,
                 target_server_version: str):
        """
        :param str ended_on: Migration end time
        :param str id: Result identifier
        :param str result_type: Result type
               Expected value is 'MigrationLevelOutput'.
        :param str source_server: Source server name
        :param str source_server_version: Source server version
        :param str started_on: Migration start time
        :param str target_server: Target server name
        :param str target_server_version: Target server version
        """
        pulumi.set(__self__, "ended_on", ended_on)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "result_type", 'MigrationLevelOutput')
        pulumi.set(__self__, "source_server", source_server)
        pulumi.set(__self__, "source_server_version", source_server_version)
        pulumi.set(__self__, "started_on", started_on)
        pulumi.set(__self__, "target_server", target_server)
        pulumi.set(__self__, "target_server_version", target_server_version)

    @property
    @pulumi.getter(name="endedOn")
    def ended_on(self) -> str:
        """
        Migration end time
        """
        return pulumi.get(self, "ended_on")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Result identifier
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="resultType")
    def result_type(self) -> str:
        """
        Result type
        Expected value is 'MigrationLevelOutput'.
        """
        return pulumi.get(self, "result_type")

    @property
    @pulumi.getter(name="sourceServer")
    def source_server(self) -> str:
        """
        Source server name
        """
        return pulumi.get(self, "source_server")

    @property
    @pulumi.getter(name="sourceServerVersion")
    def source_server_version(self) -> str:
        """
        Source server version
        """
        return pulumi.get(self, "source_server_version")

    @property
    @pulumi.getter(name="startedOn")
    def started_on(self) -> str:
        """
        Migration start time
        """
        return pulumi.get(self, "started_on")

    @property
    @pulumi.getter(name="targetServer")
    def target_server(self) -> str:
        """
        Target server name
        """
        return pulumi.get(self, "target_server")

    @property
    @pulumi.getter(name="targetServerVersion")
    def target_server_version(self) -> str:
        """
        Target server version
        """
        return pulumi.get(self, "target_server_version")


@pulumi.output_type
class MigrateMySqlAzureDbForMySqlSyncTaskOutputTableLevelResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cdcDeleteCounter":
            suggest = "cdc_delete_counter"
        elif key == "cdcInsertCounter":
            suggest = "cdc_insert_counter"
        elif key == "cdcUpdateCounter":
            suggest = "cdc_update_counter"
        elif key == "dataErrorsCounter":
            suggest = "data_errors_counter"
        elif key == "databaseName":
            suggest = "database_name"
        elif key == "fullLoadEndedOn":
            suggest = "full_load_ended_on"
        elif key == "fullLoadEstFinishTime":
            suggest = "full_load_est_finish_time"
        elif key == "fullLoadStartedOn":
            suggest = "full_load_started_on"
        elif key == "fullLoadTotalRows":
            suggest = "full_load_total_rows"
        elif key == "lastModifiedTime":
            suggest = "last_modified_time"
        elif key == "resultType":
            suggest = "result_type"
        elif key == "tableName":
            suggest = "table_name"
        elif key == "totalChangesApplied":
            suggest = "total_changes_applied"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MigrateMySqlAzureDbForMySqlSyncTaskOutputTableLevelResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MigrateMySqlAzureDbForMySqlSyncTaskOutputTableLevelResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MigrateMySqlAzureDbForMySqlSyncTaskOutputTableLevelResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cdc_delete_counter: str,
                 cdc_insert_counter: str,
                 cdc_update_counter: str,
                 data_errors_counter: float,
                 database_name: str,
                 full_load_ended_on: str,
                 full_load_est_finish_time: str,
                 full_load_started_on: str,
                 full_load_total_rows: float,
                 id: str,
                 last_modified_time: str,
                 result_type: str,
                 state: str,
                 table_name: str,
                 total_changes_applied: float):
        """
        :param str cdc_delete_counter: Number of applied deletes
        :param str cdc_insert_counter: Number of applied inserts
        :param str cdc_update_counter: Number of applied updates
        :param float data_errors_counter: Number of data errors occurred
        :param str database_name: Name of the database
        :param str full_load_ended_on: Full load end time
        :param str full_load_est_finish_time: Estimate to finish full load
        :param str full_load_started_on: Full load start time
        :param float full_load_total_rows: Number of rows applied in full load
        :param str id: Result identifier
        :param str last_modified_time: Last modified time on target
        :param str result_type: Result type
               Expected value is 'TableLevelOutput'.
        :param str state: Current state of the table migration
        :param str table_name: Name of the table
        :param float total_changes_applied: Total number of applied changes
        """
        pulumi.set(__self__, "cdc_delete_counter", cdc_delete_counter)
        pulumi.set(__self__, "cdc_insert_counter", cdc_insert_counter)
        pulumi.set(__self__, "cdc_update_counter", cdc_update_counter)
        pulumi.set(__self__, "data_errors_counter", data_errors_counter)
        pulumi.set(__self__, "database_name", database_name)
        pulumi.set(__self__, "full_load_ended_on", full_load_ended_on)
        pulumi.set(__self__, "full_load_est_finish_time", full_load_est_finish_time)
        pulumi.set(__self__, "full_load_started_on", full_load_started_on)
        pulumi.set(__self__, "full_load_total_rows", full_load_total_rows)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "last_modified_time", last_modified_time)
        pulumi.set(__self__, "result_type", 'TableLevelOutput')
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "table_name", table_name)
        pulumi.set(__self__, "total_changes_applied", total_changes_applied)

    @property
    @pulumi.getter(name="cdcDeleteCounter")
    def cdc_delete_counter(self) -> str:
        """
        Number of applied deletes
        """
        return pulumi.get(self, "cdc_delete_counter")

    @property
    @pulumi.getter(name="cdcInsertCounter")
    def cdc_insert_counter(self) -> str:
        """
        Number of applied inserts
        """
        return pulumi.get(self, "cdc_insert_counter")

    @property
    @pulumi.getter(name="cdcUpdateCounter")
    def cdc_update_counter(self) -> str:
        """
        Number of applied updates
        """
        return pulumi.get(self, "cdc_update_counter")

    @property
    @pulumi.getter(name="dataErrorsCounter")
    def data_errors_counter(self) -> float:
        """
        Number of data errors occurred
        """
        return pulumi.get(self, "data_errors_counter")

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> str:
        """
        Name of the database
        """
        return pulumi.get(self, "database_name")

    @property
    @pulumi.getter(name="fullLoadEndedOn")
    def full_load_ended_on(self) -> str:
        """
        Full load end time
        """
        return pulumi.get(self, "full_load_ended_on")

    @property
    @pulumi.getter(name="fullLoadEstFinishTime")
    def full_load_est_finish_time(self) -> str:
        """
        Estimate to finish full load
        """
        return pulumi.get(self, "full_load_est_finish_time")

    @property
    @pulumi.getter(name="fullLoadStartedOn")
    def full_load_started_on(self) -> str:
        """
        Full load start time
        """
        return pulumi.get(self, "full_load_started_on")

    @property
    @pulumi.getter(name="fullLoadTotalRows")
    def full_load_total_rows(self) -> float:
        """
        Number of rows applied in full load
        """
        return pulumi.get(self, "full_load_total_rows")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Result identifier
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lastModifiedTime")
    def last_modified_time(self) -> str:
        """
        Last modified time on target
        """
        return pulumi.get(self, "last_modified_time")

    @property
    @pulumi.getter(name="resultType")
    def result_type(self) -> str:
        """
        Result type
        Expected value is 'TableLevelOutput'.
        """
        return pulumi.get(self, "result_type")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        Current state of the table migration
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="tableName")
    def table_name(self) -> str:
        """
        Name of the table
        """
        return pulumi.get(self, "table_name")

    @property
    @pulumi.getter(name="totalChangesApplied")
    def total_changes_applied(self) -> float:
        """
        Total number of applied changes
        """
        return pulumi.get(self, "total_changes_applied")


@pulumi.output_type
class MigrateMySqlAzureDbForMySqlSyncTaskPropertiesResponse(dict):
    """
    Properties for the task that migrates MySQL databases to Azure Database for MySQL for online migrations
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "taskType":
            suggest = "task_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MigrateMySqlAzureDbForMySqlSyncTaskPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MigrateMySqlAzureDbForMySqlSyncTaskPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MigrateMySqlAzureDbForMySqlSyncTaskPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 commands: Sequence[Any],
                 errors: Sequence['outputs.ODataErrorResponse'],
                 output: Sequence[Any],
                 state: str,
                 task_type: str,
                 input: Optional['outputs.MigrateMySqlAzureDbForMySqlSyncTaskInputResponse'] = None):
        """
        Properties for the task that migrates MySQL databases to Azure Database for MySQL for online migrations
        :param Sequence[Union['MigrateMISyncCompleteCommandPropertiesResponse', 'MigrateSyncCompleteCommandPropertiesResponse']] commands: Array of command properties.
        :param Sequence['ODataErrorResponse'] errors: Array of errors. This is ignored if submitted.
        :param Sequence[Union['MigrateMySqlAzureDbForMySqlSyncTaskOutputDatabaseErrorResponse', 'MigrateMySqlAzureDbForMySqlSyncTaskOutputDatabaseLevelResponse', 'MigrateMySqlAzureDbForMySqlSyncTaskOutputErrorResponse', 'MigrateMySqlAzureDbForMySqlSyncTaskOutputMigrationLevelResponse', 'MigrateMySqlAzureDbForMySqlSyncTaskOutputTableLevelResponse']] output: Task output. This is ignored if submitted.
        :param str state: The state of the task. This is ignored if submitted.
        :param str task_type: Task type.
               Expected value is 'Migrate.MySql.AzureDbForMySql.Sync'.
        :param 'MigrateMySqlAzureDbForMySqlSyncTaskInputResponse' input: Task input
        """
        pulumi.set(__self__, "commands", commands)
        pulumi.set(__self__, "errors", errors)
        pulumi.set(__self__, "output", output)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "task_type", 'Migrate.MySql.AzureDbForMySql.Sync')
        if input is not None:
            pulumi.set(__self__, "input", input)

    @property
    @pulumi.getter
    def commands(self) -> Sequence[Any]:
        """
        Array of command properties.
        """
        return pulumi.get(self, "commands")

    @property
    @pulumi.getter
    def errors(self) -> Sequence['outputs.ODataErrorResponse']:
        """
        Array of errors. This is ignored if submitted.
        """
        return pulumi.get(self, "errors")

    @property
    @pulumi.getter
    def output(self) -> Sequence[Any]:
        """
        Task output. This is ignored if submitted.
        """
        return pulumi.get(self, "output")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The state of the task. This is ignored if submitted.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="taskType")
    def task_type(self) -> str:
        """
        Task type.
        Expected value is 'Migrate.MySql.AzureDbForMySql.Sync'.
        """
        return pulumi.get(self, "task_type")

    @property
    @pulumi.getter
    def input(self) -> Optional['outputs.MigrateMySqlAzureDbForMySqlSyncTaskInputResponse']:
        """
        Task input
        """
        return pulumi.get(self, "input")


@pulumi.output_type
class MigratePostgreSqlAzureDbForPostgreSqlSyncDatabaseInputResponse(dict):
    """
    Database specific information for PostgreSQL to Azure Database for PostgreSQL migration task inputs
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "migrationSetting":
            suggest = "migration_setting"
        elif key == "sourceSetting":
            suggest = "source_setting"
        elif key == "targetDatabaseName":
            suggest = "target_database_name"
        elif key == "targetSetting":
            suggest = "target_setting"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MigratePostgreSqlAzureDbForPostgreSqlSyncDatabaseInputResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MigratePostgreSqlAzureDbForPostgreSqlSyncDatabaseInputResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MigratePostgreSqlAzureDbForPostgreSqlSyncDatabaseInputResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 migration_setting: Optional[Mapping[str, str]] = None,
                 name: Optional[str] = None,
                 source_setting: Optional[Mapping[str, str]] = None,
                 target_database_name: Optional[str] = None,
                 target_setting: Optional[Mapping[str, str]] = None):
        """
        Database specific information for PostgreSQL to Azure Database for PostgreSQL migration task inputs
        :param Mapping[str, str] migration_setting: Migration settings which tune the migration behavior
        :param str name: Name of the database
        :param Mapping[str, str] source_setting: Source settings to tune source endpoint migration behavior
        :param str target_database_name: Name of target database. Note: Target database will be truncated before starting migration.
        :param Mapping[str, str] target_setting: Target settings to tune target endpoint migration behavior
        """
        if migration_setting is not None:
            pulumi.set(__self__, "migration_setting", migration_setting)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if source_setting is not None:
            pulumi.set(__self__, "source_setting", source_setting)
        if target_database_name is not None:
            pulumi.set(__self__, "target_database_name", target_database_name)
        if target_setting is not None:
            pulumi.set(__self__, "target_setting", target_setting)

    @property
    @pulumi.getter(name="migrationSetting")
    def migration_setting(self) -> Optional[Mapping[str, str]]:
        """
        Migration settings which tune the migration behavior
        """
        return pulumi.get(self, "migration_setting")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the database
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="sourceSetting")
    def source_setting(self) -> Optional[Mapping[str, str]]:
        """
        Source settings to tune source endpoint migration behavior
        """
        return pulumi.get(self, "source_setting")

    @property
    @pulumi.getter(name="targetDatabaseName")
    def target_database_name(self) -> Optional[str]:
        """
        Name of target database. Note: Target database will be truncated before starting migration.
        """
        return pulumi.get(self, "target_database_name")

    @property
    @pulumi.getter(name="targetSetting")
    def target_setting(self) -> Optional[Mapping[str, str]]:
        """
        Target settings to tune target endpoint migration behavior
        """
        return pulumi.get(self, "target_setting")


@pulumi.output_type
class MigratePostgreSqlAzureDbForPostgreSqlSyncTaskInputResponse(dict):
    """
    Input for the task that migrates PostgreSQL databases to Azure Database for PostgreSQL for online migrations
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "selectedDatabases":
            suggest = "selected_databases"
        elif key == "sourceConnectionInfo":
            suggest = "source_connection_info"
        elif key == "targetConnectionInfo":
            suggest = "target_connection_info"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MigratePostgreSqlAzureDbForPostgreSqlSyncTaskInputResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MigratePostgreSqlAzureDbForPostgreSqlSyncTaskInputResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MigratePostgreSqlAzureDbForPostgreSqlSyncTaskInputResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 selected_databases: Sequence['outputs.MigratePostgreSqlAzureDbForPostgreSqlSyncDatabaseInputResponse'],
                 source_connection_info: 'outputs.PostgreSqlConnectionInfoResponse',
                 target_connection_info: 'outputs.PostgreSqlConnectionInfoResponse'):
        """
        Input for the task that migrates PostgreSQL databases to Azure Database for PostgreSQL for online migrations
        :param Sequence['MigratePostgreSqlAzureDbForPostgreSqlSyncDatabaseInputResponse'] selected_databases: Databases to migrate
        :param 'PostgreSqlConnectionInfoResponse' source_connection_info: Connection information for source PostgreSQL
        :param 'PostgreSqlConnectionInfoResponse' target_connection_info: Connection information for target Azure Database for PostgreSQL
        """
        pulumi.set(__self__, "selected_databases", selected_databases)
        pulumi.set(__self__, "source_connection_info", source_connection_info)
        pulumi.set(__self__, "target_connection_info", target_connection_info)

    @property
    @pulumi.getter(name="selectedDatabases")
    def selected_databases(self) -> Sequence['outputs.MigratePostgreSqlAzureDbForPostgreSqlSyncDatabaseInputResponse']:
        """
        Databases to migrate
        """
        return pulumi.get(self, "selected_databases")

    @property
    @pulumi.getter(name="sourceConnectionInfo")
    def source_connection_info(self) -> 'outputs.PostgreSqlConnectionInfoResponse':
        """
        Connection information for source PostgreSQL
        """
        return pulumi.get(self, "source_connection_info")

    @property
    @pulumi.getter(name="targetConnectionInfo")
    def target_connection_info(self) -> 'outputs.PostgreSqlConnectionInfoResponse':
        """
        Connection information for target Azure Database for PostgreSQL
        """
        return pulumi.get(self, "target_connection_info")


@pulumi.output_type
class MigratePostgreSqlAzureDbForPostgreSqlSyncTaskOutputDatabaseErrorResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resultType":
            suggest = "result_type"
        elif key == "errorMessage":
            suggest = "error_message"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MigratePostgreSqlAzureDbForPostgreSqlSyncTaskOutputDatabaseErrorResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MigratePostgreSqlAzureDbForPostgreSqlSyncTaskOutputDatabaseErrorResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MigratePostgreSqlAzureDbForPostgreSqlSyncTaskOutputDatabaseErrorResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: str,
                 result_type: str,
                 error_message: Optional[str] = None,
                 events: Optional[Sequence['outputs.SyncMigrationDatabaseErrorEventResponse']] = None):
        """
        :param str id: Result identifier
        :param str result_type: Result type
               Expected value is 'DatabaseLevelErrorOutput'.
        :param str error_message: Error message
        :param Sequence['SyncMigrationDatabaseErrorEventResponse'] events: List of error events.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "result_type", 'DatabaseLevelErrorOutput')
        if error_message is not None:
            pulumi.set(__self__, "error_message", error_message)
        if events is not None:
            pulumi.set(__self__, "events", events)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Result identifier
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="resultType")
    def result_type(self) -> str:
        """
        Result type
        Expected value is 'DatabaseLevelErrorOutput'.
        """
        return pulumi.get(self, "result_type")

    @property
    @pulumi.getter(name="errorMessage")
    def error_message(self) -> Optional[str]:
        """
        Error message
        """
        return pulumi.get(self, "error_message")

    @property
    @pulumi.getter
    def events(self) -> Optional[Sequence['outputs.SyncMigrationDatabaseErrorEventResponse']]:
        """
        List of error events.
        """
        return pulumi.get(self, "events")


@pulumi.output_type
class MigratePostgreSqlAzureDbForPostgreSqlSyncTaskOutputDatabaseLevelResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "appliedChanges":
            suggest = "applied_changes"
        elif key == "cdcDeleteCounter":
            suggest = "cdc_delete_counter"
        elif key == "cdcInsertCounter":
            suggest = "cdc_insert_counter"
        elif key == "cdcUpdateCounter":
            suggest = "cdc_update_counter"
        elif key == "databaseName":
            suggest = "database_name"
        elif key == "endedOn":
            suggest = "ended_on"
        elif key == "fullLoadCompletedTables":
            suggest = "full_load_completed_tables"
        elif key == "fullLoadErroredTables":
            suggest = "full_load_errored_tables"
        elif key == "fullLoadLoadingTables":
            suggest = "full_load_loading_tables"
        elif key == "fullLoadQueuedTables":
            suggest = "full_load_queued_tables"
        elif key == "incomingChanges":
            suggest = "incoming_changes"
        elif key == "initializationCompleted":
            suggest = "initialization_completed"
        elif key == "migrationState":
            suggest = "migration_state"
        elif key == "resultType":
            suggest = "result_type"
        elif key == "startedOn":
            suggest = "started_on"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MigratePostgreSqlAzureDbForPostgreSqlSyncTaskOutputDatabaseLevelResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MigratePostgreSqlAzureDbForPostgreSqlSyncTaskOutputDatabaseLevelResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MigratePostgreSqlAzureDbForPostgreSqlSyncTaskOutputDatabaseLevelResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 applied_changes: float,
                 cdc_delete_counter: float,
                 cdc_insert_counter: float,
                 cdc_update_counter: float,
                 database_name: str,
                 ended_on: str,
                 full_load_completed_tables: float,
                 full_load_errored_tables: float,
                 full_load_loading_tables: float,
                 full_load_queued_tables: float,
                 id: str,
                 incoming_changes: float,
                 initialization_completed: bool,
                 latency: float,
                 migration_state: str,
                 result_type: str,
                 started_on: str):
        """
        :param float applied_changes: Number of applied changes
        :param float cdc_delete_counter: Number of cdc deletes
        :param float cdc_insert_counter: Number of cdc inserts
        :param float cdc_update_counter: Number of cdc updates
        :param str database_name: Name of the database
        :param str ended_on: Migration end time
        :param float full_load_completed_tables: Number of tables completed in full load
        :param float full_load_errored_tables: Number of tables errored in full load
        :param float full_load_loading_tables: Number of tables loading in full load
        :param float full_load_queued_tables: Number of tables queued in full load
        :param str id: Result identifier
        :param float incoming_changes: Number of incoming changes
        :param bool initialization_completed: Indicates if initial load (full load) has been completed
        :param float latency: CDC apply latency
        :param str migration_state: Migration state that this database is in
        :param str result_type: Result type
               Expected value is 'DatabaseLevelOutput'.
        :param str started_on: Migration start time
        """
        pulumi.set(__self__, "applied_changes", applied_changes)
        pulumi.set(__self__, "cdc_delete_counter", cdc_delete_counter)
        pulumi.set(__self__, "cdc_insert_counter", cdc_insert_counter)
        pulumi.set(__self__, "cdc_update_counter", cdc_update_counter)
        pulumi.set(__self__, "database_name", database_name)
        pulumi.set(__self__, "ended_on", ended_on)
        pulumi.set(__self__, "full_load_completed_tables", full_load_completed_tables)
        pulumi.set(__self__, "full_load_errored_tables", full_load_errored_tables)
        pulumi.set(__self__, "full_load_loading_tables", full_load_loading_tables)
        pulumi.set(__self__, "full_load_queued_tables", full_load_queued_tables)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "incoming_changes", incoming_changes)
        pulumi.set(__self__, "initialization_completed", initialization_completed)
        pulumi.set(__self__, "latency", latency)
        pulumi.set(__self__, "migration_state", migration_state)
        pulumi.set(__self__, "result_type", 'DatabaseLevelOutput')
        pulumi.set(__self__, "started_on", started_on)

    @property
    @pulumi.getter(name="appliedChanges")
    def applied_changes(self) -> float:
        """
        Number of applied changes
        """
        return pulumi.get(self, "applied_changes")

    @property
    @pulumi.getter(name="cdcDeleteCounter")
    def cdc_delete_counter(self) -> float:
        """
        Number of cdc deletes
        """
        return pulumi.get(self, "cdc_delete_counter")

    @property
    @pulumi.getter(name="cdcInsertCounter")
    def cdc_insert_counter(self) -> float:
        """
        Number of cdc inserts
        """
        return pulumi.get(self, "cdc_insert_counter")

    @property
    @pulumi.getter(name="cdcUpdateCounter")
    def cdc_update_counter(self) -> float:
        """
        Number of cdc updates
        """
        return pulumi.get(self, "cdc_update_counter")

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> str:
        """
        Name of the database
        """
        return pulumi.get(self, "database_name")

    @property
    @pulumi.getter(name="endedOn")
    def ended_on(self) -> str:
        """
        Migration end time
        """
        return pulumi.get(self, "ended_on")

    @property
    @pulumi.getter(name="fullLoadCompletedTables")
    def full_load_completed_tables(self) -> float:
        """
        Number of tables completed in full load
        """
        return pulumi.get(self, "full_load_completed_tables")

    @property
    @pulumi.getter(name="fullLoadErroredTables")
    def full_load_errored_tables(self) -> float:
        """
        Number of tables errored in full load
        """
        return pulumi.get(self, "full_load_errored_tables")

    @property
    @pulumi.getter(name="fullLoadLoadingTables")
    def full_load_loading_tables(self) -> float:
        """
        Number of tables loading in full load
        """
        return pulumi.get(self, "full_load_loading_tables")

    @property
    @pulumi.getter(name="fullLoadQueuedTables")
    def full_load_queued_tables(self) -> float:
        """
        Number of tables queued in full load
        """
        return pulumi.get(self, "full_load_queued_tables")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Result identifier
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="incomingChanges")
    def incoming_changes(self) -> float:
        """
        Number of incoming changes
        """
        return pulumi.get(self, "incoming_changes")

    @property
    @pulumi.getter(name="initializationCompleted")
    def initialization_completed(self) -> bool:
        """
        Indicates if initial load (full load) has been completed
        """
        return pulumi.get(self, "initialization_completed")

    @property
    @pulumi.getter
    def latency(self) -> float:
        """
        CDC apply latency
        """
        return pulumi.get(self, "latency")

    @property
    @pulumi.getter(name="migrationState")
    def migration_state(self) -> str:
        """
        Migration state that this database is in
        """
        return pulumi.get(self, "migration_state")

    @property
    @pulumi.getter(name="resultType")
    def result_type(self) -> str:
        """
        Result type
        Expected value is 'DatabaseLevelOutput'.
        """
        return pulumi.get(self, "result_type")

    @property
    @pulumi.getter(name="startedOn")
    def started_on(self) -> str:
        """
        Migration start time
        """
        return pulumi.get(self, "started_on")


@pulumi.output_type
class MigratePostgreSqlAzureDbForPostgreSqlSyncTaskOutputErrorResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resultType":
            suggest = "result_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MigratePostgreSqlAzureDbForPostgreSqlSyncTaskOutputErrorResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MigratePostgreSqlAzureDbForPostgreSqlSyncTaskOutputErrorResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MigratePostgreSqlAzureDbForPostgreSqlSyncTaskOutputErrorResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 error: 'outputs.ReportableExceptionResponse',
                 id: str,
                 result_type: str):
        """
        :param 'ReportableExceptionResponse' error: Migration error
        :param str id: Result identifier
        :param str result_type: Result type
               Expected value is 'ErrorOutput'.
        """
        pulumi.set(__self__, "error", error)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "result_type", 'ErrorOutput')

    @property
    @pulumi.getter
    def error(self) -> 'outputs.ReportableExceptionResponse':
        """
        Migration error
        """
        return pulumi.get(self, "error")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Result identifier
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="resultType")
    def result_type(self) -> str:
        """
        Result type
        Expected value is 'ErrorOutput'.
        """
        return pulumi.get(self, "result_type")


@pulumi.output_type
class MigratePostgreSqlAzureDbForPostgreSqlSyncTaskOutputMigrationLevelResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endedOn":
            suggest = "ended_on"
        elif key == "resultType":
            suggest = "result_type"
        elif key == "sourceServer":
            suggest = "source_server"
        elif key == "sourceServerVersion":
            suggest = "source_server_version"
        elif key == "startedOn":
            suggest = "started_on"
        elif key == "targetServer":
            suggest = "target_server"
        elif key == "targetServerVersion":
            suggest = "target_server_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MigratePostgreSqlAzureDbForPostgreSqlSyncTaskOutputMigrationLevelResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MigratePostgreSqlAzureDbForPostgreSqlSyncTaskOutputMigrationLevelResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MigratePostgreSqlAzureDbForPostgreSqlSyncTaskOutputMigrationLevelResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ended_on: str,
                 id: str,
                 result_type: str,
                 source_server: str,
                 source_server_version: str,
                 started_on: str,
                 target_server: str,
                 target_server_version: str):
        """
        :param str ended_on: Migration end time
        :param str id: Result identifier
        :param str result_type: Result type
               Expected value is 'MigrationLevelOutput'.
        :param str source_server: Source server name
        :param str source_server_version: Source server version
        :param str started_on: Migration start time
        :param str target_server: Target server name
        :param str target_server_version: Target server version
        """
        pulumi.set(__self__, "ended_on", ended_on)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "result_type", 'MigrationLevelOutput')
        pulumi.set(__self__, "source_server", source_server)
        pulumi.set(__self__, "source_server_version", source_server_version)
        pulumi.set(__self__, "started_on", started_on)
        pulumi.set(__self__, "target_server", target_server)
        pulumi.set(__self__, "target_server_version", target_server_version)

    @property
    @pulumi.getter(name="endedOn")
    def ended_on(self) -> str:
        """
        Migration end time
        """
        return pulumi.get(self, "ended_on")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Result identifier
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="resultType")
    def result_type(self) -> str:
        """
        Result type
        Expected value is 'MigrationLevelOutput'.
        """
        return pulumi.get(self, "result_type")

    @property
    @pulumi.getter(name="sourceServer")
    def source_server(self) -> str:
        """
        Source server name
        """
        return pulumi.get(self, "source_server")

    @property
    @pulumi.getter(name="sourceServerVersion")
    def source_server_version(self) -> str:
        """
        Source server version
        """
        return pulumi.get(self, "source_server_version")

    @property
    @pulumi.getter(name="startedOn")
    def started_on(self) -> str:
        """
        Migration start time
        """
        return pulumi.get(self, "started_on")

    @property
    @pulumi.getter(name="targetServer")
    def target_server(self) -> str:
        """
        Target server name
        """
        return pulumi.get(self, "target_server")

    @property
    @pulumi.getter(name="targetServerVersion")
    def target_server_version(self) -> str:
        """
        Target server version
        """
        return pulumi.get(self, "target_server_version")


@pulumi.output_type
class MigratePostgreSqlAzureDbForPostgreSqlSyncTaskOutputTableLevelResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cdcDeleteCounter":
            suggest = "cdc_delete_counter"
        elif key == "cdcInsertCounter":
            suggest = "cdc_insert_counter"
        elif key == "cdcUpdateCounter":
            suggest = "cdc_update_counter"
        elif key == "dataErrorsCounter":
            suggest = "data_errors_counter"
        elif key == "databaseName":
            suggest = "database_name"
        elif key == "fullLoadEndedOn":
            suggest = "full_load_ended_on"
        elif key == "fullLoadEstFinishTime":
            suggest = "full_load_est_finish_time"
        elif key == "fullLoadStartedOn":
            suggest = "full_load_started_on"
        elif key == "fullLoadTotalRows":
            suggest = "full_load_total_rows"
        elif key == "lastModifiedTime":
            suggest = "last_modified_time"
        elif key == "resultType":
            suggest = "result_type"
        elif key == "tableName":
            suggest = "table_name"
        elif key == "totalChangesApplied":
            suggest = "total_changes_applied"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MigratePostgreSqlAzureDbForPostgreSqlSyncTaskOutputTableLevelResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MigratePostgreSqlAzureDbForPostgreSqlSyncTaskOutputTableLevelResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MigratePostgreSqlAzureDbForPostgreSqlSyncTaskOutputTableLevelResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cdc_delete_counter: float,
                 cdc_insert_counter: float,
                 cdc_update_counter: float,
                 data_errors_counter: float,
                 database_name: str,
                 full_load_ended_on: str,
                 full_load_est_finish_time: str,
                 full_load_started_on: str,
                 full_load_total_rows: float,
                 id: str,
                 last_modified_time: str,
                 result_type: str,
                 state: str,
                 table_name: str,
                 total_changes_applied: float):
        """
        :param float cdc_delete_counter: Number of applied deletes
        :param float cdc_insert_counter: Number of applied inserts
        :param float cdc_update_counter: Number of applied updates
        :param float data_errors_counter: Number of data errors occurred
        :param str database_name: Name of the database
        :param str full_load_ended_on: Full load end time
        :param str full_load_est_finish_time: Estimate to finish full load
        :param str full_load_started_on: Full load start time
        :param float full_load_total_rows: Number of rows applied in full load
        :param str id: Result identifier
        :param str last_modified_time: Last modified time on target
        :param str result_type: Result type
               Expected value is 'TableLevelOutput'.
        :param str state: Current state of the table migration
        :param str table_name: Name of the table
        :param float total_changes_applied: Total number of applied changes
        """
        pulumi.set(__self__, "cdc_delete_counter", cdc_delete_counter)
        pulumi.set(__self__, "cdc_insert_counter", cdc_insert_counter)
        pulumi.set(__self__, "cdc_update_counter", cdc_update_counter)
        pulumi.set(__self__, "data_errors_counter", data_errors_counter)
        pulumi.set(__self__, "database_name", database_name)
        pulumi.set(__self__, "full_load_ended_on", full_load_ended_on)
        pulumi.set(__self__, "full_load_est_finish_time", full_load_est_finish_time)
        pulumi.set(__self__, "full_load_started_on", full_load_started_on)
        pulumi.set(__self__, "full_load_total_rows", full_load_total_rows)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "last_modified_time", last_modified_time)
        pulumi.set(__self__, "result_type", 'TableLevelOutput')
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "table_name", table_name)
        pulumi.set(__self__, "total_changes_applied", total_changes_applied)

    @property
    @pulumi.getter(name="cdcDeleteCounter")
    def cdc_delete_counter(self) -> float:
        """
        Number of applied deletes
        """
        return pulumi.get(self, "cdc_delete_counter")

    @property
    @pulumi.getter(name="cdcInsertCounter")
    def cdc_insert_counter(self) -> float:
        """
        Number of applied inserts
        """
        return pulumi.get(self, "cdc_insert_counter")

    @property
    @pulumi.getter(name="cdcUpdateCounter")
    def cdc_update_counter(self) -> float:
        """
        Number of applied updates
        """
        return pulumi.get(self, "cdc_update_counter")

    @property
    @pulumi.getter(name="dataErrorsCounter")
    def data_errors_counter(self) -> float:
        """
        Number of data errors occurred
        """
        return pulumi.get(self, "data_errors_counter")

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> str:
        """
        Name of the database
        """
        return pulumi.get(self, "database_name")

    @property
    @pulumi.getter(name="fullLoadEndedOn")
    def full_load_ended_on(self) -> str:
        """
        Full load end time
        """
        return pulumi.get(self, "full_load_ended_on")

    @property
    @pulumi.getter(name="fullLoadEstFinishTime")
    def full_load_est_finish_time(self) -> str:
        """
        Estimate to finish full load
        """
        return pulumi.get(self, "full_load_est_finish_time")

    @property
    @pulumi.getter(name="fullLoadStartedOn")
    def full_load_started_on(self) -> str:
        """
        Full load start time
        """
        return pulumi.get(self, "full_load_started_on")

    @property
    @pulumi.getter(name="fullLoadTotalRows")
    def full_load_total_rows(self) -> float:
        """
        Number of rows applied in full load
        """
        return pulumi.get(self, "full_load_total_rows")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Result identifier
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lastModifiedTime")
    def last_modified_time(self) -> str:
        """
        Last modified time on target
        """
        return pulumi.get(self, "last_modified_time")

    @property
    @pulumi.getter(name="resultType")
    def result_type(self) -> str:
        """
        Result type
        Expected value is 'TableLevelOutput'.
        """
        return pulumi.get(self, "result_type")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        Current state of the table migration
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="tableName")
    def table_name(self) -> str:
        """
        Name of the table
        """
        return pulumi.get(self, "table_name")

    @property
    @pulumi.getter(name="totalChangesApplied")
    def total_changes_applied(self) -> float:
        """
        Total number of applied changes
        """
        return pulumi.get(self, "total_changes_applied")


@pulumi.output_type
class MigratePostgreSqlAzureDbForPostgreSqlSyncTaskPropertiesResponse(dict):
    """
    Properties for the task that migrates PostgreSQL databases to Azure Database for PostgreSQL for online migrations
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "taskType":
            suggest = "task_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MigratePostgreSqlAzureDbForPostgreSqlSyncTaskPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MigratePostgreSqlAzureDbForPostgreSqlSyncTaskPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MigratePostgreSqlAzureDbForPostgreSqlSyncTaskPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 commands: Sequence[Any],
                 errors: Sequence['outputs.ODataErrorResponse'],
                 output: Sequence[Any],
                 state: str,
                 task_type: str,
                 input: Optional['outputs.MigratePostgreSqlAzureDbForPostgreSqlSyncTaskInputResponse'] = None):
        """
        Properties for the task that migrates PostgreSQL databases to Azure Database for PostgreSQL for online migrations
        :param Sequence[Union['MigrateMISyncCompleteCommandPropertiesResponse', 'MigrateSyncCompleteCommandPropertiesResponse']] commands: Array of command properties.
        :param Sequence['ODataErrorResponse'] errors: Array of errors. This is ignored if submitted.
        :param Sequence[Union['MigratePostgreSqlAzureDbForPostgreSqlSyncTaskOutputDatabaseErrorResponse', 'MigratePostgreSqlAzureDbForPostgreSqlSyncTaskOutputDatabaseLevelResponse', 'MigratePostgreSqlAzureDbForPostgreSqlSyncTaskOutputErrorResponse', 'MigratePostgreSqlAzureDbForPostgreSqlSyncTaskOutputMigrationLevelResponse', 'MigratePostgreSqlAzureDbForPostgreSqlSyncTaskOutputTableLevelResponse']] output: Task output. This is ignored if submitted.
        :param str state: The state of the task. This is ignored if submitted.
        :param str task_type: Task type.
               Expected value is 'Migrate.PostgreSql.AzureDbForPostgreSql.Sync'.
        :param 'MigratePostgreSqlAzureDbForPostgreSqlSyncTaskInputResponse' input: Task input
        """
        pulumi.set(__self__, "commands", commands)
        pulumi.set(__self__, "errors", errors)
        pulumi.set(__self__, "output", output)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "task_type", 'Migrate.PostgreSql.AzureDbForPostgreSql.Sync')
        if input is not None:
            pulumi.set(__self__, "input", input)

    @property
    @pulumi.getter
    def commands(self) -> Sequence[Any]:
        """
        Array of command properties.
        """
        return pulumi.get(self, "commands")

    @property
    @pulumi.getter
    def errors(self) -> Sequence['outputs.ODataErrorResponse']:
        """
        Array of errors. This is ignored if submitted.
        """
        return pulumi.get(self, "errors")

    @property
    @pulumi.getter
    def output(self) -> Sequence[Any]:
        """
        Task output. This is ignored if submitted.
        """
        return pulumi.get(self, "output")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The state of the task. This is ignored if submitted.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="taskType")
    def task_type(self) -> str:
        """
        Task type.
        Expected value is 'Migrate.PostgreSql.AzureDbForPostgreSql.Sync'.
        """
        return pulumi.get(self, "task_type")

    @property
    @pulumi.getter
    def input(self) -> Optional['outputs.MigratePostgreSqlAzureDbForPostgreSqlSyncTaskInputResponse']:
        """
        Task input
        """
        return pulumi.get(self, "input")


@pulumi.output_type
class MigrateSqlServerSqlDbDatabaseInputResponse(dict):
    """
    Database specific information for SQL to Azure SQL DB migration task inputs
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "makeSourceDbReadOnly":
            suggest = "make_source_db_read_only"
        elif key == "tableMap":
            suggest = "table_map"
        elif key == "targetDatabaseName":
            suggest = "target_database_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MigrateSqlServerSqlDbDatabaseInputResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MigrateSqlServerSqlDbDatabaseInputResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MigrateSqlServerSqlDbDatabaseInputResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 make_source_db_read_only: Optional[bool] = None,
                 name: Optional[str] = None,
                 table_map: Optional[Mapping[str, str]] = None,
                 target_database_name: Optional[str] = None):
        """
        Database specific information for SQL to Azure SQL DB migration task inputs
        :param bool make_source_db_read_only: Whether to set database read only before migration
        :param str name: Name of the database
        :param Mapping[str, str] table_map: Mapping of source to target tables
        :param str target_database_name: Name of target database. Note: Target database will be truncated before starting migration.
        """
        if make_source_db_read_only is not None:
            pulumi.set(__self__, "make_source_db_read_only", make_source_db_read_only)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if table_map is not None:
            pulumi.set(__self__, "table_map", table_map)
        if target_database_name is not None:
            pulumi.set(__self__, "target_database_name", target_database_name)

    @property
    @pulumi.getter(name="makeSourceDbReadOnly")
    def make_source_db_read_only(self) -> Optional[bool]:
        """
        Whether to set database read only before migration
        """
        return pulumi.get(self, "make_source_db_read_only")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the database
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="tableMap")
    def table_map(self) -> Optional[Mapping[str, str]]:
        """
        Mapping of source to target tables
        """
        return pulumi.get(self, "table_map")

    @property
    @pulumi.getter(name="targetDatabaseName")
    def target_database_name(self) -> Optional[str]:
        """
        Name of target database. Note: Target database will be truncated before starting migration.
        """
        return pulumi.get(self, "target_database_name")


@pulumi.output_type
class MigrateSqlServerSqlDbSyncDatabaseInputResponse(dict):
    """
    Database specific information for SQL to Azure SQL DB sync migration task inputs
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "migrationSetting":
            suggest = "migration_setting"
        elif key == "schemaName":
            suggest = "schema_name"
        elif key == "sourceSetting":
            suggest = "source_setting"
        elif key == "tableMap":
            suggest = "table_map"
        elif key == "targetDatabaseName":
            suggest = "target_database_name"
        elif key == "targetSetting":
            suggest = "target_setting"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MigrateSqlServerSqlDbSyncDatabaseInputResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MigrateSqlServerSqlDbSyncDatabaseInputResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MigrateSqlServerSqlDbSyncDatabaseInputResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: Optional[str] = None,
                 migration_setting: Optional[Mapping[str, str]] = None,
                 name: Optional[str] = None,
                 schema_name: Optional[str] = None,
                 source_setting: Optional[Mapping[str, str]] = None,
                 table_map: Optional[Mapping[str, str]] = None,
                 target_database_name: Optional[str] = None,
                 target_setting: Optional[Mapping[str, str]] = None):
        """
        Database specific information for SQL to Azure SQL DB sync migration task inputs
        :param str id: Unique identifier for database
        :param Mapping[str, str] migration_setting: Migration settings which tune the migration behavior
        :param str name: Name of database
        :param str schema_name: Schema name to be migrated
        :param Mapping[str, str] source_setting: Source settings to tune source endpoint migration behavior
        :param Mapping[str, str] table_map: Mapping of source to target tables
        :param str target_database_name: Target database name
        :param Mapping[str, str] target_setting: Target settings to tune target endpoint migration behavior
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if migration_setting is not None:
            pulumi.set(__self__, "migration_setting", migration_setting)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if schema_name is not None:
            pulumi.set(__self__, "schema_name", schema_name)
        if source_setting is not None:
            pulumi.set(__self__, "source_setting", source_setting)
        if table_map is not None:
            pulumi.set(__self__, "table_map", table_map)
        if target_database_name is not None:
            pulumi.set(__self__, "target_database_name", target_database_name)
        if target_setting is not None:
            pulumi.set(__self__, "target_setting", target_setting)

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Unique identifier for database
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="migrationSetting")
    def migration_setting(self) -> Optional[Mapping[str, str]]:
        """
        Migration settings which tune the migration behavior
        """
        return pulumi.get(self, "migration_setting")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of database
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="schemaName")
    def schema_name(self) -> Optional[str]:
        """
        Schema name to be migrated
        """
        return pulumi.get(self, "schema_name")

    @property
    @pulumi.getter(name="sourceSetting")
    def source_setting(self) -> Optional[Mapping[str, str]]:
        """
        Source settings to tune source endpoint migration behavior
        """
        return pulumi.get(self, "source_setting")

    @property
    @pulumi.getter(name="tableMap")
    def table_map(self) -> Optional[Mapping[str, str]]:
        """
        Mapping of source to target tables
        """
        return pulumi.get(self, "table_map")

    @property
    @pulumi.getter(name="targetDatabaseName")
    def target_database_name(self) -> Optional[str]:
        """
        Target database name
        """
        return pulumi.get(self, "target_database_name")

    @property
    @pulumi.getter(name="targetSetting")
    def target_setting(self) -> Optional[Mapping[str, str]]:
        """
        Target settings to tune target endpoint migration behavior
        """
        return pulumi.get(self, "target_setting")


@pulumi.output_type
class MigrateSqlServerSqlDbSyncTaskInputResponse(dict):
    """
    Input for the task that migrates on-prem SQL Server databases to Azure SQL Database for online migrations
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "selectedDatabases":
            suggest = "selected_databases"
        elif key == "sourceConnectionInfo":
            suggest = "source_connection_info"
        elif key == "targetConnectionInfo":
            suggest = "target_connection_info"
        elif key == "validationOptions":
            suggest = "validation_options"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MigrateSqlServerSqlDbSyncTaskInputResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MigrateSqlServerSqlDbSyncTaskInputResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MigrateSqlServerSqlDbSyncTaskInputResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 selected_databases: Sequence['outputs.MigrateSqlServerSqlDbSyncDatabaseInputResponse'],
                 source_connection_info: 'outputs.SqlConnectionInfoResponse',
                 target_connection_info: 'outputs.SqlConnectionInfoResponse',
                 validation_options: Optional['outputs.MigrationValidationOptionsResponse'] = None):
        """
        Input for the task that migrates on-prem SQL Server databases to Azure SQL Database for online migrations
        :param Sequence['MigrateSqlServerSqlDbSyncDatabaseInputResponse'] selected_databases: Databases to migrate
        :param 'SqlConnectionInfoResponse' source_connection_info: Information for connecting to source
        :param 'SqlConnectionInfoResponse' target_connection_info: Information for connecting to target
        :param 'MigrationValidationOptionsResponse' validation_options: Validation options
        """
        pulumi.set(__self__, "selected_databases", selected_databases)
        pulumi.set(__self__, "source_connection_info", source_connection_info)
        pulumi.set(__self__, "target_connection_info", target_connection_info)
        if validation_options is not None:
            pulumi.set(__self__, "validation_options", validation_options)

    @property
    @pulumi.getter(name="selectedDatabases")
    def selected_databases(self) -> Sequence['outputs.MigrateSqlServerSqlDbSyncDatabaseInputResponse']:
        """
        Databases to migrate
        """
        return pulumi.get(self, "selected_databases")

    @property
    @pulumi.getter(name="sourceConnectionInfo")
    def source_connection_info(self) -> 'outputs.SqlConnectionInfoResponse':
        """
        Information for connecting to source
        """
        return pulumi.get(self, "source_connection_info")

    @property
    @pulumi.getter(name="targetConnectionInfo")
    def target_connection_info(self) -> 'outputs.SqlConnectionInfoResponse':
        """
        Information for connecting to target
        """
        return pulumi.get(self, "target_connection_info")

    @property
    @pulumi.getter(name="validationOptions")
    def validation_options(self) -> Optional['outputs.MigrationValidationOptionsResponse']:
        """
        Validation options
        """
        return pulumi.get(self, "validation_options")


@pulumi.output_type
class MigrateSqlServerSqlDbSyncTaskOutputDatabaseErrorResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resultType":
            suggest = "result_type"
        elif key == "errorMessage":
            suggest = "error_message"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MigrateSqlServerSqlDbSyncTaskOutputDatabaseErrorResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MigrateSqlServerSqlDbSyncTaskOutputDatabaseErrorResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MigrateSqlServerSqlDbSyncTaskOutputDatabaseErrorResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: str,
                 result_type: str,
                 error_message: Optional[str] = None,
                 events: Optional[Sequence['outputs.SyncMigrationDatabaseErrorEventResponse']] = None):
        """
        :param str id: Result identifier
        :param str result_type: Result type
               Expected value is 'DatabaseLevelErrorOutput'.
        :param str error_message: Error message
        :param Sequence['SyncMigrationDatabaseErrorEventResponse'] events: List of error events.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "result_type", 'DatabaseLevelErrorOutput')
        if error_message is not None:
            pulumi.set(__self__, "error_message", error_message)
        if events is not None:
            pulumi.set(__self__, "events", events)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Result identifier
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="resultType")
    def result_type(self) -> str:
        """
        Result type
        Expected value is 'DatabaseLevelErrorOutput'.
        """
        return pulumi.get(self, "result_type")

    @property
    @pulumi.getter(name="errorMessage")
    def error_message(self) -> Optional[str]:
        """
        Error message
        """
        return pulumi.get(self, "error_message")

    @property
    @pulumi.getter
    def events(self) -> Optional[Sequence['outputs.SyncMigrationDatabaseErrorEventResponse']]:
        """
        List of error events.
        """
        return pulumi.get(self, "events")


@pulumi.output_type
class MigrateSqlServerSqlDbSyncTaskOutputDatabaseLevelResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "appliedChanges":
            suggest = "applied_changes"
        elif key == "cdcDeleteCounter":
            suggest = "cdc_delete_counter"
        elif key == "cdcInsertCounter":
            suggest = "cdc_insert_counter"
        elif key == "cdcUpdateCounter":
            suggest = "cdc_update_counter"
        elif key == "databaseName":
            suggest = "database_name"
        elif key == "endedOn":
            suggest = "ended_on"
        elif key == "fullLoadCompletedTables":
            suggest = "full_load_completed_tables"
        elif key == "fullLoadErroredTables":
            suggest = "full_load_errored_tables"
        elif key == "fullLoadLoadingTables":
            suggest = "full_load_loading_tables"
        elif key == "fullLoadQueuedTables":
            suggest = "full_load_queued_tables"
        elif key == "incomingChanges":
            suggest = "incoming_changes"
        elif key == "initializationCompleted":
            suggest = "initialization_completed"
        elif key == "migrationState":
            suggest = "migration_state"
        elif key == "resultType":
            suggest = "result_type"
        elif key == "startedOn":
            suggest = "started_on"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MigrateSqlServerSqlDbSyncTaskOutputDatabaseLevelResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MigrateSqlServerSqlDbSyncTaskOutputDatabaseLevelResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MigrateSqlServerSqlDbSyncTaskOutputDatabaseLevelResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 applied_changes: float,
                 cdc_delete_counter: float,
                 cdc_insert_counter: float,
                 cdc_update_counter: float,
                 database_name: str,
                 ended_on: str,
                 full_load_completed_tables: float,
                 full_load_errored_tables: float,
                 full_load_loading_tables: float,
                 full_load_queued_tables: float,
                 id: str,
                 incoming_changes: float,
                 initialization_completed: bool,
                 latency: float,
                 migration_state: str,
                 result_type: str,
                 started_on: str):
        """
        :param float applied_changes: Number of applied changes
        :param float cdc_delete_counter: Number of cdc deletes
        :param float cdc_insert_counter: Number of cdc inserts
        :param float cdc_update_counter: Number of cdc updates
        :param str database_name: Name of the database
        :param str ended_on: Migration end time
        :param float full_load_completed_tables: Number of tables completed in full load
        :param float full_load_errored_tables: Number of tables errored in full load
        :param float full_load_loading_tables: Number of tables loading in full load
        :param float full_load_queued_tables: Number of tables queued in full load
        :param str id: Result identifier
        :param float incoming_changes: Number of incoming changes
        :param bool initialization_completed: Indicates if initial load (full load) has been completed
        :param float latency: CDC apply latency
        :param str migration_state: Migration state that this database is in
        :param str result_type: Result type
               Expected value is 'DatabaseLevelOutput'.
        :param str started_on: Migration start time
        """
        pulumi.set(__self__, "applied_changes", applied_changes)
        pulumi.set(__self__, "cdc_delete_counter", cdc_delete_counter)
        pulumi.set(__self__, "cdc_insert_counter", cdc_insert_counter)
        pulumi.set(__self__, "cdc_update_counter", cdc_update_counter)
        pulumi.set(__self__, "database_name", database_name)
        pulumi.set(__self__, "ended_on", ended_on)
        pulumi.set(__self__, "full_load_completed_tables", full_load_completed_tables)
        pulumi.set(__self__, "full_load_errored_tables", full_load_errored_tables)
        pulumi.set(__self__, "full_load_loading_tables", full_load_loading_tables)
        pulumi.set(__self__, "full_load_queued_tables", full_load_queued_tables)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "incoming_changes", incoming_changes)
        pulumi.set(__self__, "initialization_completed", initialization_completed)
        pulumi.set(__self__, "latency", latency)
        pulumi.set(__self__, "migration_state", migration_state)
        pulumi.set(__self__, "result_type", 'DatabaseLevelOutput')
        pulumi.set(__self__, "started_on", started_on)

    @property
    @pulumi.getter(name="appliedChanges")
    def applied_changes(self) -> float:
        """
        Number of applied changes
        """
        return pulumi.get(self, "applied_changes")

    @property
    @pulumi.getter(name="cdcDeleteCounter")
    def cdc_delete_counter(self) -> float:
        """
        Number of cdc deletes
        """
        return pulumi.get(self, "cdc_delete_counter")

    @property
    @pulumi.getter(name="cdcInsertCounter")
    def cdc_insert_counter(self) -> float:
        """
        Number of cdc inserts
        """
        return pulumi.get(self, "cdc_insert_counter")

    @property
    @pulumi.getter(name="cdcUpdateCounter")
    def cdc_update_counter(self) -> float:
        """
        Number of cdc updates
        """
        return pulumi.get(self, "cdc_update_counter")

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> str:
        """
        Name of the database
        """
        return pulumi.get(self, "database_name")

    @property
    @pulumi.getter(name="endedOn")
    def ended_on(self) -> str:
        """
        Migration end time
        """
        return pulumi.get(self, "ended_on")

    @property
    @pulumi.getter(name="fullLoadCompletedTables")
    def full_load_completed_tables(self) -> float:
        """
        Number of tables completed in full load
        """
        return pulumi.get(self, "full_load_completed_tables")

    @property
    @pulumi.getter(name="fullLoadErroredTables")
    def full_load_errored_tables(self) -> float:
        """
        Number of tables errored in full load
        """
        return pulumi.get(self, "full_load_errored_tables")

    @property
    @pulumi.getter(name="fullLoadLoadingTables")
    def full_load_loading_tables(self) -> float:
        """
        Number of tables loading in full load
        """
        return pulumi.get(self, "full_load_loading_tables")

    @property
    @pulumi.getter(name="fullLoadQueuedTables")
    def full_load_queued_tables(self) -> float:
        """
        Number of tables queued in full load
        """
        return pulumi.get(self, "full_load_queued_tables")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Result identifier
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="incomingChanges")
    def incoming_changes(self) -> float:
        """
        Number of incoming changes
        """
        return pulumi.get(self, "incoming_changes")

    @property
    @pulumi.getter(name="initializationCompleted")
    def initialization_completed(self) -> bool:
        """
        Indicates if initial load (full load) has been completed
        """
        return pulumi.get(self, "initialization_completed")

    @property
    @pulumi.getter
    def latency(self) -> float:
        """
        CDC apply latency
        """
        return pulumi.get(self, "latency")

    @property
    @pulumi.getter(name="migrationState")
    def migration_state(self) -> str:
        """
        Migration state that this database is in
        """
        return pulumi.get(self, "migration_state")

    @property
    @pulumi.getter(name="resultType")
    def result_type(self) -> str:
        """
        Result type
        Expected value is 'DatabaseLevelOutput'.
        """
        return pulumi.get(self, "result_type")

    @property
    @pulumi.getter(name="startedOn")
    def started_on(self) -> str:
        """
        Migration start time
        """
        return pulumi.get(self, "started_on")


@pulumi.output_type
class MigrateSqlServerSqlDbSyncTaskOutputErrorResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resultType":
            suggest = "result_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MigrateSqlServerSqlDbSyncTaskOutputErrorResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MigrateSqlServerSqlDbSyncTaskOutputErrorResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MigrateSqlServerSqlDbSyncTaskOutputErrorResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 error: 'outputs.ReportableExceptionResponse',
                 id: str,
                 result_type: str):
        """
        :param 'ReportableExceptionResponse' error: Migration error
        :param str id: Result identifier
        :param str result_type: Result type
               Expected value is 'ErrorOutput'.
        """
        pulumi.set(__self__, "error", error)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "result_type", 'ErrorOutput')

    @property
    @pulumi.getter
    def error(self) -> 'outputs.ReportableExceptionResponse':
        """
        Migration error
        """
        return pulumi.get(self, "error")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Result identifier
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="resultType")
    def result_type(self) -> str:
        """
        Result type
        Expected value is 'ErrorOutput'.
        """
        return pulumi.get(self, "result_type")


@pulumi.output_type
class MigrateSqlServerSqlDbSyncTaskOutputMigrationLevelResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "databaseCount":
            suggest = "database_count"
        elif key == "endedOn":
            suggest = "ended_on"
        elif key == "resultType":
            suggest = "result_type"
        elif key == "sourceServer":
            suggest = "source_server"
        elif key == "sourceServerVersion":
            suggest = "source_server_version"
        elif key == "startedOn":
            suggest = "started_on"
        elif key == "targetServer":
            suggest = "target_server"
        elif key == "targetServerVersion":
            suggest = "target_server_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MigrateSqlServerSqlDbSyncTaskOutputMigrationLevelResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MigrateSqlServerSqlDbSyncTaskOutputMigrationLevelResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MigrateSqlServerSqlDbSyncTaskOutputMigrationLevelResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 database_count: int,
                 ended_on: str,
                 id: str,
                 result_type: str,
                 source_server: str,
                 source_server_version: str,
                 started_on: str,
                 target_server: str,
                 target_server_version: str):
        """
        :param int database_count: Count of databases
        :param str ended_on: Migration end time
        :param str id: Result identifier
        :param str result_type: Result type
               Expected value is 'MigrationLevelOutput'.
        :param str source_server: Source server name
        :param str source_server_version: Source server version
        :param str started_on: Migration start time
        :param str target_server: Target server name
        :param str target_server_version: Target server version
        """
        pulumi.set(__self__, "database_count", database_count)
        pulumi.set(__self__, "ended_on", ended_on)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "result_type", 'MigrationLevelOutput')
        pulumi.set(__self__, "source_server", source_server)
        pulumi.set(__self__, "source_server_version", source_server_version)
        pulumi.set(__self__, "started_on", started_on)
        pulumi.set(__self__, "target_server", target_server)
        pulumi.set(__self__, "target_server_version", target_server_version)

    @property
    @pulumi.getter(name="databaseCount")
    def database_count(self) -> int:
        """
        Count of databases
        """
        return pulumi.get(self, "database_count")

    @property
    @pulumi.getter(name="endedOn")
    def ended_on(self) -> str:
        """
        Migration end time
        """
        return pulumi.get(self, "ended_on")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Result identifier
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="resultType")
    def result_type(self) -> str:
        """
        Result type
        Expected value is 'MigrationLevelOutput'.
        """
        return pulumi.get(self, "result_type")

    @property
    @pulumi.getter(name="sourceServer")
    def source_server(self) -> str:
        """
        Source server name
        """
        return pulumi.get(self, "source_server")

    @property
    @pulumi.getter(name="sourceServerVersion")
    def source_server_version(self) -> str:
        """
        Source server version
        """
        return pulumi.get(self, "source_server_version")

    @property
    @pulumi.getter(name="startedOn")
    def started_on(self) -> str:
        """
        Migration start time
        """
        return pulumi.get(self, "started_on")

    @property
    @pulumi.getter(name="targetServer")
    def target_server(self) -> str:
        """
        Target server name
        """
        return pulumi.get(self, "target_server")

    @property
    @pulumi.getter(name="targetServerVersion")
    def target_server_version(self) -> str:
        """
        Target server version
        """
        return pulumi.get(self, "target_server_version")


@pulumi.output_type
class MigrateSqlServerSqlDbSyncTaskOutputTableLevelResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cdcDeleteCounter":
            suggest = "cdc_delete_counter"
        elif key == "cdcInsertCounter":
            suggest = "cdc_insert_counter"
        elif key == "cdcUpdateCounter":
            suggest = "cdc_update_counter"
        elif key == "dataErrorsCounter":
            suggest = "data_errors_counter"
        elif key == "databaseName":
            suggest = "database_name"
        elif key == "fullLoadEndedOn":
            suggest = "full_load_ended_on"
        elif key == "fullLoadEstFinishTime":
            suggest = "full_load_est_finish_time"
        elif key == "fullLoadStartedOn":
            suggest = "full_load_started_on"
        elif key == "fullLoadTotalRows":
            suggest = "full_load_total_rows"
        elif key == "lastModifiedTime":
            suggest = "last_modified_time"
        elif key == "resultType":
            suggest = "result_type"
        elif key == "tableName":
            suggest = "table_name"
        elif key == "totalChangesApplied":
            suggest = "total_changes_applied"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MigrateSqlServerSqlDbSyncTaskOutputTableLevelResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MigrateSqlServerSqlDbSyncTaskOutputTableLevelResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MigrateSqlServerSqlDbSyncTaskOutputTableLevelResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cdc_delete_counter: float,
                 cdc_insert_counter: float,
                 cdc_update_counter: float,
                 data_errors_counter: float,
                 database_name: str,
                 full_load_ended_on: str,
                 full_load_est_finish_time: str,
                 full_load_started_on: str,
                 full_load_total_rows: float,
                 id: str,
                 last_modified_time: str,
                 result_type: str,
                 state: str,
                 table_name: str,
                 total_changes_applied: float):
        """
        :param float cdc_delete_counter: Number of applied deletes
        :param float cdc_insert_counter: Number of applied inserts
        :param float cdc_update_counter: Number of applied updates
        :param float data_errors_counter: Number of data errors occurred
        :param str database_name: Name of the database
        :param str full_load_ended_on: Full load end time
        :param str full_load_est_finish_time: Estimate to finish full load
        :param str full_load_started_on: Full load start time
        :param float full_load_total_rows: Number of rows applied in full load
        :param str id: Result identifier
        :param str last_modified_time: Last modified time on target
        :param str result_type: Result type
               Expected value is 'TableLevelOutput'.
        :param str state: Current state of the table migration
        :param str table_name: Name of the table
        :param float total_changes_applied: Total number of applied changes
        """
        pulumi.set(__self__, "cdc_delete_counter", cdc_delete_counter)
        pulumi.set(__self__, "cdc_insert_counter", cdc_insert_counter)
        pulumi.set(__self__, "cdc_update_counter", cdc_update_counter)
        pulumi.set(__self__, "data_errors_counter", data_errors_counter)
        pulumi.set(__self__, "database_name", database_name)
        pulumi.set(__self__, "full_load_ended_on", full_load_ended_on)
        pulumi.set(__self__, "full_load_est_finish_time", full_load_est_finish_time)
        pulumi.set(__self__, "full_load_started_on", full_load_started_on)
        pulumi.set(__self__, "full_load_total_rows", full_load_total_rows)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "last_modified_time", last_modified_time)
        pulumi.set(__self__, "result_type", 'TableLevelOutput')
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "table_name", table_name)
        pulumi.set(__self__, "total_changes_applied", total_changes_applied)

    @property
    @pulumi.getter(name="cdcDeleteCounter")
    def cdc_delete_counter(self) -> float:
        """
        Number of applied deletes
        """
        return pulumi.get(self, "cdc_delete_counter")

    @property
    @pulumi.getter(name="cdcInsertCounter")
    def cdc_insert_counter(self) -> float:
        """
        Number of applied inserts
        """
        return pulumi.get(self, "cdc_insert_counter")

    @property
    @pulumi.getter(name="cdcUpdateCounter")
    def cdc_update_counter(self) -> float:
        """
        Number of applied updates
        """
        return pulumi.get(self, "cdc_update_counter")

    @property
    @pulumi.getter(name="dataErrorsCounter")
    def data_errors_counter(self) -> float:
        """
        Number of data errors occurred
        """
        return pulumi.get(self, "data_errors_counter")

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> str:
        """
        Name of the database
        """
        return pulumi.get(self, "database_name")

    @property
    @pulumi.getter(name="fullLoadEndedOn")
    def full_load_ended_on(self) -> str:
        """
        Full load end time
        """
        return pulumi.get(self, "full_load_ended_on")

    @property
    @pulumi.getter(name="fullLoadEstFinishTime")
    def full_load_est_finish_time(self) -> str:
        """
        Estimate to finish full load
        """
        return pulumi.get(self, "full_load_est_finish_time")

    @property
    @pulumi.getter(name="fullLoadStartedOn")
    def full_load_started_on(self) -> str:
        """
        Full load start time
        """
        return pulumi.get(self, "full_load_started_on")

    @property
    @pulumi.getter(name="fullLoadTotalRows")
    def full_load_total_rows(self) -> float:
        """
        Number of rows applied in full load
        """
        return pulumi.get(self, "full_load_total_rows")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Result identifier
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lastModifiedTime")
    def last_modified_time(self) -> str:
        """
        Last modified time on target
        """
        return pulumi.get(self, "last_modified_time")

    @property
    @pulumi.getter(name="resultType")
    def result_type(self) -> str:
        """
        Result type
        Expected value is 'TableLevelOutput'.
        """
        return pulumi.get(self, "result_type")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        Current state of the table migration
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="tableName")
    def table_name(self) -> str:
        """
        Name of the table
        """
        return pulumi.get(self, "table_name")

    @property
    @pulumi.getter(name="totalChangesApplied")
    def total_changes_applied(self) -> float:
        """
        Total number of applied changes
        """
        return pulumi.get(self, "total_changes_applied")


@pulumi.output_type
class MigrateSqlServerSqlDbSyncTaskPropertiesResponse(dict):
    """
    Properties for the task that migrates on-prem SQL Server databases to Azure SQL Database for online migrations
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "taskType":
            suggest = "task_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MigrateSqlServerSqlDbSyncTaskPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MigrateSqlServerSqlDbSyncTaskPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MigrateSqlServerSqlDbSyncTaskPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 commands: Sequence[Any],
                 errors: Sequence['outputs.ODataErrorResponse'],
                 output: Sequence[Any],
                 state: str,
                 task_type: str,
                 input: Optional['outputs.MigrateSqlServerSqlDbSyncTaskInputResponse'] = None):
        """
        Properties for the task that migrates on-prem SQL Server databases to Azure SQL Database for online migrations
        :param Sequence[Union['MigrateMISyncCompleteCommandPropertiesResponse', 'MigrateSyncCompleteCommandPropertiesResponse']] commands: Array of command properties.
        :param Sequence['ODataErrorResponse'] errors: Array of errors. This is ignored if submitted.
        :param Sequence[Union['MigrateSqlServerSqlDbSyncTaskOutputDatabaseErrorResponse', 'MigrateSqlServerSqlDbSyncTaskOutputDatabaseLevelResponse', 'MigrateSqlServerSqlDbSyncTaskOutputErrorResponse', 'MigrateSqlServerSqlDbSyncTaskOutputMigrationLevelResponse', 'MigrateSqlServerSqlDbSyncTaskOutputTableLevelResponse']] output: Task output. This is ignored if submitted.
        :param str state: The state of the task. This is ignored if submitted.
        :param str task_type: Task type.
               Expected value is 'Migrate.SqlServer.AzureSqlDb.Sync'.
        :param 'MigrateSqlServerSqlDbSyncTaskInputResponse' input: Task input
        """
        pulumi.set(__self__, "commands", commands)
        pulumi.set(__self__, "errors", errors)
        pulumi.set(__self__, "output", output)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "task_type", 'Migrate.SqlServer.AzureSqlDb.Sync')
        if input is not None:
            pulumi.set(__self__, "input", input)

    @property
    @pulumi.getter
    def commands(self) -> Sequence[Any]:
        """
        Array of command properties.
        """
        return pulumi.get(self, "commands")

    @property
    @pulumi.getter
    def errors(self) -> Sequence['outputs.ODataErrorResponse']:
        """
        Array of errors. This is ignored if submitted.
        """
        return pulumi.get(self, "errors")

    @property
    @pulumi.getter
    def output(self) -> Sequence[Any]:
        """
        Task output. This is ignored if submitted.
        """
        return pulumi.get(self, "output")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The state of the task. This is ignored if submitted.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="taskType")
    def task_type(self) -> str:
        """
        Task type.
        Expected value is 'Migrate.SqlServer.AzureSqlDb.Sync'.
        """
        return pulumi.get(self, "task_type")

    @property
    @pulumi.getter
    def input(self) -> Optional['outputs.MigrateSqlServerSqlDbSyncTaskInputResponse']:
        """
        Task input
        """
        return pulumi.get(self, "input")


@pulumi.output_type
class MigrateSqlServerSqlDbTaskInputResponse(dict):
    """
    Input for the task that migrates on-prem SQL Server databases to Azure SQL Database
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "selectedDatabases":
            suggest = "selected_databases"
        elif key == "sourceConnectionInfo":
            suggest = "source_connection_info"
        elif key == "targetConnectionInfo":
            suggest = "target_connection_info"
        elif key == "validationOptions":
            suggest = "validation_options"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MigrateSqlServerSqlDbTaskInputResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MigrateSqlServerSqlDbTaskInputResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MigrateSqlServerSqlDbTaskInputResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 selected_databases: Sequence['outputs.MigrateSqlServerSqlDbDatabaseInputResponse'],
                 source_connection_info: 'outputs.SqlConnectionInfoResponse',
                 target_connection_info: 'outputs.SqlConnectionInfoResponse',
                 validation_options: Optional['outputs.MigrationValidationOptionsResponse'] = None):
        """
        Input for the task that migrates on-prem SQL Server databases to Azure SQL Database
        :param Sequence['MigrateSqlServerSqlDbDatabaseInputResponse'] selected_databases: Databases to migrate
        :param 'SqlConnectionInfoResponse' source_connection_info: Information for connecting to source
        :param 'SqlConnectionInfoResponse' target_connection_info: Information for connecting to target
        :param 'MigrationValidationOptionsResponse' validation_options: Options for enabling various post migration validations. Available options, 
                1.) Data Integrity Check: Performs a checksum based comparison on source and target tables after the migration to ensure the correctness of the data. 
                2.) Schema Validation: Performs a thorough schema comparison between the source and target tables and provides a list of differences between the source and target database, 3.) Query Analysis: Executes a set of queries picked up automatically either from the Query Plan Cache or Query Store and execute them and compares the execution time between the source and target database.
        """
        pulumi.set(__self__, "selected_databases", selected_databases)
        pulumi.set(__self__, "source_connection_info", source_connection_info)
        pulumi.set(__self__, "target_connection_info", target_connection_info)
        if validation_options is not None:
            pulumi.set(__self__, "validation_options", validation_options)

    @property
    @pulumi.getter(name="selectedDatabases")
    def selected_databases(self) -> Sequence['outputs.MigrateSqlServerSqlDbDatabaseInputResponse']:
        """
        Databases to migrate
        """
        return pulumi.get(self, "selected_databases")

    @property
    @pulumi.getter(name="sourceConnectionInfo")
    def source_connection_info(self) -> 'outputs.SqlConnectionInfoResponse':
        """
        Information for connecting to source
        """
        return pulumi.get(self, "source_connection_info")

    @property
    @pulumi.getter(name="targetConnectionInfo")
    def target_connection_info(self) -> 'outputs.SqlConnectionInfoResponse':
        """
        Information for connecting to target
        """
        return pulumi.get(self, "target_connection_info")

    @property
    @pulumi.getter(name="validationOptions")
    def validation_options(self) -> Optional['outputs.MigrationValidationOptionsResponse']:
        """
        Options for enabling various post migration validations. Available options, 
         1.) Data Integrity Check: Performs a checksum based comparison on source and target tables after the migration to ensure the correctness of the data. 
         2.) Schema Validation: Performs a thorough schema comparison between the source and target tables and provides a list of differences between the source and target database, 3.) Query Analysis: Executes a set of queries picked up automatically either from the Query Plan Cache or Query Store and execute them and compares the execution time between the source and target database.
        """
        return pulumi.get(self, "validation_options")


@pulumi.output_type
class MigrateSqlServerSqlDbTaskOutputDatabaseLevelResponse(dict):
    """
    Database level result for Sql Server to Azure Sql DB migration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "databaseName":
            suggest = "database_name"
        elif key == "endedOn":
            suggest = "ended_on"
        elif key == "errorCount":
            suggest = "error_count"
        elif key == "errorPrefix":
            suggest = "error_prefix"
        elif key == "exceptionsAndWarnings":
            suggest = "exceptions_and_warnings"
        elif key == "numberOfObjects":
            suggest = "number_of_objects"
        elif key == "numberOfObjectsCompleted":
            suggest = "number_of_objects_completed"
        elif key == "objectSummary":
            suggest = "object_summary"
        elif key == "resultPrefix":
            suggest = "result_prefix"
        elif key == "resultType":
            suggest = "result_type"
        elif key == "startedOn":
            suggest = "started_on"
        elif key == "statusMessage":
            suggest = "status_message"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MigrateSqlServerSqlDbTaskOutputDatabaseLevelResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MigrateSqlServerSqlDbTaskOutputDatabaseLevelResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MigrateSqlServerSqlDbTaskOutputDatabaseLevelResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 database_name: str,
                 ended_on: str,
                 error_count: float,
                 error_prefix: str,
                 exceptions_and_warnings: Sequence['outputs.ReportableExceptionResponse'],
                 id: str,
                 message: str,
                 number_of_objects: float,
                 number_of_objects_completed: float,
                 object_summary: Mapping[str, 'outputs.DataItemMigrationSummaryResultResponse'],
                 result_prefix: str,
                 result_type: str,
                 stage: str,
                 started_on: str,
                 state: str,
                 status_message: str):
        """
        Database level result for Sql Server to Azure Sql DB migration.
        :param str database_name: Name of the item
        :param str ended_on: Migration end time
        :param float error_count: Number of database/object errors.
        :param str error_prefix: Wildcard string prefix to use for querying all errors of the item
        :param Sequence['ReportableExceptionResponse'] exceptions_and_warnings: Migration exceptions and warnings.
        :param str id: Result identifier
        :param str message: Migration progress message
        :param float number_of_objects: Number of objects
        :param float number_of_objects_completed: Number of successfully completed objects
        :param Mapping[str, 'DataItemMigrationSummaryResultResponse'] object_summary: Summary of object results in the migration
        :param str result_prefix: Wildcard string prefix to use for querying all sub-tem results of the item
        :param str result_type: Result type
               Expected value is 'DatabaseLevelOutput'.
        :param str stage: Migration stage that this database is in
        :param str started_on: Migration start time
        :param str state: Current state of migration
        :param str status_message: Status message
        """
        pulumi.set(__self__, "database_name", database_name)
        pulumi.set(__self__, "ended_on", ended_on)
        pulumi.set(__self__, "error_count", error_count)
        pulumi.set(__self__, "error_prefix", error_prefix)
        pulumi.set(__self__, "exceptions_and_warnings", exceptions_and_warnings)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "message", message)
        pulumi.set(__self__, "number_of_objects", number_of_objects)
        pulumi.set(__self__, "number_of_objects_completed", number_of_objects_completed)
        pulumi.set(__self__, "object_summary", object_summary)
        pulumi.set(__self__, "result_prefix", result_prefix)
        pulumi.set(__self__, "result_type", 'DatabaseLevelOutput')
        pulumi.set(__self__, "stage", stage)
        pulumi.set(__self__, "started_on", started_on)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "status_message", status_message)

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> str:
        """
        Name of the item
        """
        return pulumi.get(self, "database_name")

    @property
    @pulumi.getter(name="endedOn")
    def ended_on(self) -> str:
        """
        Migration end time
        """
        return pulumi.get(self, "ended_on")

    @property
    @pulumi.getter(name="errorCount")
    def error_count(self) -> float:
        """
        Number of database/object errors.
        """
        return pulumi.get(self, "error_count")

    @property
    @pulumi.getter(name="errorPrefix")
    def error_prefix(self) -> str:
        """
        Wildcard string prefix to use for querying all errors of the item
        """
        return pulumi.get(self, "error_prefix")

    @property
    @pulumi.getter(name="exceptionsAndWarnings")
    def exceptions_and_warnings(self) -> Sequence['outputs.ReportableExceptionResponse']:
        """
        Migration exceptions and warnings.
        """
        return pulumi.get(self, "exceptions_and_warnings")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Result identifier
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def message(self) -> str:
        """
        Migration progress message
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter(name="numberOfObjects")
    def number_of_objects(self) -> float:
        """
        Number of objects
        """
        return pulumi.get(self, "number_of_objects")

    @property
    @pulumi.getter(name="numberOfObjectsCompleted")
    def number_of_objects_completed(self) -> float:
        """
        Number of successfully completed objects
        """
        return pulumi.get(self, "number_of_objects_completed")

    @property
    @pulumi.getter(name="objectSummary")
    def object_summary(self) -> Mapping[str, 'outputs.DataItemMigrationSummaryResultResponse']:
        """
        Summary of object results in the migration
        """
        return pulumi.get(self, "object_summary")

    @property
    @pulumi.getter(name="resultPrefix")
    def result_prefix(self) -> str:
        """
        Wildcard string prefix to use for querying all sub-tem results of the item
        """
        return pulumi.get(self, "result_prefix")

    @property
    @pulumi.getter(name="resultType")
    def result_type(self) -> str:
        """
        Result type
        Expected value is 'DatabaseLevelOutput'.
        """
        return pulumi.get(self, "result_type")

    @property
    @pulumi.getter
    def stage(self) -> str:
        """
        Migration stage that this database is in
        """
        return pulumi.get(self, "stage")

    @property
    @pulumi.getter(name="startedOn")
    def started_on(self) -> str:
        """
        Migration start time
        """
        return pulumi.get(self, "started_on")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        Current state of migration
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="statusMessage")
    def status_message(self) -> str:
        """
        Status message
        """
        return pulumi.get(self, "status_message")


@pulumi.output_type
class MigrateSqlServerSqlDbTaskOutputDatabaseLevelValidationResultResponse(dict):
    """
    Database validation result for Sql Server to Azure Sql DB migration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataIntegrityValidationResult":
            suggest = "data_integrity_validation_result"
        elif key == "endedOn":
            suggest = "ended_on"
        elif key == "migrationId":
            suggest = "migration_id"
        elif key == "queryAnalysisValidationResult":
            suggest = "query_analysis_validation_result"
        elif key == "resultType":
            suggest = "result_type"
        elif key == "schemaValidationResult":
            suggest = "schema_validation_result"
        elif key == "sourceDatabaseName":
            suggest = "source_database_name"
        elif key == "startedOn":
            suggest = "started_on"
        elif key == "targetDatabaseName":
            suggest = "target_database_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MigrateSqlServerSqlDbTaskOutputDatabaseLevelValidationResultResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MigrateSqlServerSqlDbTaskOutputDatabaseLevelValidationResultResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MigrateSqlServerSqlDbTaskOutputDatabaseLevelValidationResultResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data_integrity_validation_result: 'outputs.DataIntegrityValidationResultResponse',
                 ended_on: str,
                 id: str,
                 migration_id: str,
                 query_analysis_validation_result: 'outputs.QueryAnalysisValidationResultResponse',
                 result_type: str,
                 schema_validation_result: 'outputs.SchemaComparisonValidationResultResponse',
                 source_database_name: str,
                 started_on: str,
                 status: str,
                 target_database_name: str):
        """
        Database validation result for Sql Server to Azure Sql DB migration.
        :param 'DataIntegrityValidationResultResponse' data_integrity_validation_result: Provides data integrity validation result between the source and target tables that are migrated.
        :param str ended_on: Validation end time
        :param str id: Result identifier
        :param str migration_id: Migration Identifier
        :param 'QueryAnalysisValidationResultResponse' query_analysis_validation_result: Results of some of the query execution result between source and target database
        :param str result_type: Result type
               Expected value is 'MigrationDatabaseLevelValidationOutput'.
        :param 'SchemaComparisonValidationResultResponse' schema_validation_result: Provides schema comparison result between source and target database
        :param str source_database_name: Name of the source database
        :param str started_on: Validation start time
        :param str status: Current status of validation at the database level
        :param str target_database_name: Name of the target database
        """
        pulumi.set(__self__, "data_integrity_validation_result", data_integrity_validation_result)
        pulumi.set(__self__, "ended_on", ended_on)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "migration_id", migration_id)
        pulumi.set(__self__, "query_analysis_validation_result", query_analysis_validation_result)
        pulumi.set(__self__, "result_type", 'MigrationDatabaseLevelValidationOutput')
        pulumi.set(__self__, "schema_validation_result", schema_validation_result)
        pulumi.set(__self__, "source_database_name", source_database_name)
        pulumi.set(__self__, "started_on", started_on)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "target_database_name", target_database_name)

    @property
    @pulumi.getter(name="dataIntegrityValidationResult")
    def data_integrity_validation_result(self) -> 'outputs.DataIntegrityValidationResultResponse':
        """
        Provides data integrity validation result between the source and target tables that are migrated.
        """
        return pulumi.get(self, "data_integrity_validation_result")

    @property
    @pulumi.getter(name="endedOn")
    def ended_on(self) -> str:
        """
        Validation end time
        """
        return pulumi.get(self, "ended_on")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Result identifier
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="migrationId")
    def migration_id(self) -> str:
        """
        Migration Identifier
        """
        return pulumi.get(self, "migration_id")

    @property
    @pulumi.getter(name="queryAnalysisValidationResult")
    def query_analysis_validation_result(self) -> 'outputs.QueryAnalysisValidationResultResponse':
        """
        Results of some of the query execution result between source and target database
        """
        return pulumi.get(self, "query_analysis_validation_result")

    @property
    @pulumi.getter(name="resultType")
    def result_type(self) -> str:
        """
        Result type
        Expected value is 'MigrationDatabaseLevelValidationOutput'.
        """
        return pulumi.get(self, "result_type")

    @property
    @pulumi.getter(name="schemaValidationResult")
    def schema_validation_result(self) -> 'outputs.SchemaComparisonValidationResultResponse':
        """
        Provides schema comparison result between source and target database
        """
        return pulumi.get(self, "schema_validation_result")

    @property
    @pulumi.getter(name="sourceDatabaseName")
    def source_database_name(self) -> str:
        """
        Name of the source database
        """
        return pulumi.get(self, "source_database_name")

    @property
    @pulumi.getter(name="startedOn")
    def started_on(self) -> str:
        """
        Validation start time
        """
        return pulumi.get(self, "started_on")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Current status of validation at the database level
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="targetDatabaseName")
    def target_database_name(self) -> str:
        """
        Name of the target database
        """
        return pulumi.get(self, "target_database_name")


@pulumi.output_type
class MigrateSqlServerSqlDbTaskOutputErrorResponse(dict):
    """
    Task errors for Sql Server to Azure Sql DB migration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resultType":
            suggest = "result_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MigrateSqlServerSqlDbTaskOutputErrorResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MigrateSqlServerSqlDbTaskOutputErrorResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MigrateSqlServerSqlDbTaskOutputErrorResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 error: 'outputs.ReportableExceptionResponse',
                 id: str,
                 result_type: str):
        """
        Task errors for Sql Server to Azure Sql DB migration.
        :param 'ReportableExceptionResponse' error: Migration error
        :param str id: Result identifier
        :param str result_type: Result type
               Expected value is 'ErrorOutput'.
        """
        pulumi.set(__self__, "error", error)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "result_type", 'ErrorOutput')

    @property
    @pulumi.getter
    def error(self) -> 'outputs.ReportableExceptionResponse':
        """
        Migration error
        """
        return pulumi.get(self, "error")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Result identifier
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="resultType")
    def result_type(self) -> str:
        """
        Result type
        Expected value is 'ErrorOutput'.
        """
        return pulumi.get(self, "result_type")


@pulumi.output_type
class MigrateSqlServerSqlDbTaskOutputMigrationLevelResponse(dict):
    """
    Migration level result for Sql server to Azure Sql DB migration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "databaseSummary":
            suggest = "database_summary"
        elif key == "durationInSeconds":
            suggest = "duration_in_seconds"
        elif key == "endedOn":
            suggest = "ended_on"
        elif key == "exceptionsAndWarnings":
            suggest = "exceptions_and_warnings"
        elif key == "migrationReport":
            suggest = "migration_report"
        elif key == "resultType":
            suggest = "result_type"
        elif key == "sourceServerBrandVersion":
            suggest = "source_server_brand_version"
        elif key == "sourceServerVersion":
            suggest = "source_server_version"
        elif key == "startedOn":
            suggest = "started_on"
        elif key == "statusMessage":
            suggest = "status_message"
        elif key == "targetServerBrandVersion":
            suggest = "target_server_brand_version"
        elif key == "targetServerVersion":
            suggest = "target_server_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MigrateSqlServerSqlDbTaskOutputMigrationLevelResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MigrateSqlServerSqlDbTaskOutputMigrationLevelResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MigrateSqlServerSqlDbTaskOutputMigrationLevelResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 database_summary: Mapping[str, 'outputs.DatabaseSummaryResultResponse'],
                 databases: Mapping[str, str],
                 duration_in_seconds: float,
                 ended_on: str,
                 exceptions_and_warnings: Sequence['outputs.ReportableExceptionResponse'],
                 id: str,
                 message: str,
                 migration_report: 'outputs.MigrationReportResultResponse',
                 result_type: str,
                 source_server_brand_version: str,
                 source_server_version: str,
                 started_on: str,
                 status: str,
                 status_message: str,
                 target_server_brand_version: str,
                 target_server_version: str):
        """
        Migration level result for Sql server to Azure Sql DB migration.
        :param Mapping[str, 'DatabaseSummaryResultResponse'] database_summary: Summary of database results in the migration
        :param Mapping[str, str] databases: Selected databases as a map from database name to database id
        :param float duration_in_seconds: Duration of task execution in seconds.
        :param str ended_on: Migration end time
        :param Sequence['ReportableExceptionResponse'] exceptions_and_warnings: Migration exceptions and warnings.
        :param str id: Result identifier
        :param str message: Migration progress message
        :param 'MigrationReportResultResponse' migration_report: Migration Report Result, provides unique url for downloading your migration report.
        :param str result_type: Result type
               Expected value is 'MigrationLevelOutput'.
        :param str source_server_brand_version: Source server brand version
        :param str source_server_version: Source server version
        :param str started_on: Migration start time
        :param str status: Current status of migration
        :param str status_message: Migration status message
        :param str target_server_brand_version: Target server brand version
        :param str target_server_version: Target server version
        """
        pulumi.set(__self__, "database_summary", database_summary)
        pulumi.set(__self__, "databases", databases)
        pulumi.set(__self__, "duration_in_seconds", duration_in_seconds)
        pulumi.set(__self__, "ended_on", ended_on)
        pulumi.set(__self__, "exceptions_and_warnings", exceptions_and_warnings)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "message", message)
        pulumi.set(__self__, "migration_report", migration_report)
        pulumi.set(__self__, "result_type", 'MigrationLevelOutput')
        pulumi.set(__self__, "source_server_brand_version", source_server_brand_version)
        pulumi.set(__self__, "source_server_version", source_server_version)
        pulumi.set(__self__, "started_on", started_on)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "status_message", status_message)
        pulumi.set(__self__, "target_server_brand_version", target_server_brand_version)
        pulumi.set(__self__, "target_server_version", target_server_version)

    @property
    @pulumi.getter(name="databaseSummary")
    def database_summary(self) -> Mapping[str, 'outputs.DatabaseSummaryResultResponse']:
        """
        Summary of database results in the migration
        """
        return pulumi.get(self, "database_summary")

    @property
    @pulumi.getter
    def databases(self) -> Mapping[str, str]:
        """
        Selected databases as a map from database name to database id
        """
        return pulumi.get(self, "databases")

    @property
    @pulumi.getter(name="durationInSeconds")
    def duration_in_seconds(self) -> float:
        """
        Duration of task execution in seconds.
        """
        return pulumi.get(self, "duration_in_seconds")

    @property
    @pulumi.getter(name="endedOn")
    def ended_on(self) -> str:
        """
        Migration end time
        """
        return pulumi.get(self, "ended_on")

    @property
    @pulumi.getter(name="exceptionsAndWarnings")
    def exceptions_and_warnings(self) -> Sequence['outputs.ReportableExceptionResponse']:
        """
        Migration exceptions and warnings.
        """
        return pulumi.get(self, "exceptions_and_warnings")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Result identifier
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def message(self) -> str:
        """
        Migration progress message
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter(name="migrationReport")
    def migration_report(self) -> 'outputs.MigrationReportResultResponse':
        """
        Migration Report Result, provides unique url for downloading your migration report.
        """
        return pulumi.get(self, "migration_report")

    @property
    @pulumi.getter(name="resultType")
    def result_type(self) -> str:
        """
        Result type
        Expected value is 'MigrationLevelOutput'.
        """
        return pulumi.get(self, "result_type")

    @property
    @pulumi.getter(name="sourceServerBrandVersion")
    def source_server_brand_version(self) -> str:
        """
        Source server brand version
        """
        return pulumi.get(self, "source_server_brand_version")

    @property
    @pulumi.getter(name="sourceServerVersion")
    def source_server_version(self) -> str:
        """
        Source server version
        """
        return pulumi.get(self, "source_server_version")

    @property
    @pulumi.getter(name="startedOn")
    def started_on(self) -> str:
        """
        Migration start time
        """
        return pulumi.get(self, "started_on")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Current status of migration
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="statusMessage")
    def status_message(self) -> str:
        """
        Migration status message
        """
        return pulumi.get(self, "status_message")

    @property
    @pulumi.getter(name="targetServerBrandVersion")
    def target_server_brand_version(self) -> str:
        """
        Target server brand version
        """
        return pulumi.get(self, "target_server_brand_version")

    @property
    @pulumi.getter(name="targetServerVersion")
    def target_server_version(self) -> str:
        """
        Target server version
        """
        return pulumi.get(self, "target_server_version")


@pulumi.output_type
class MigrateSqlServerSqlDbTaskOutputTableLevelResponse(dict):
    """
    Table level result for Sql Server to Azure Sql DB migration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endedOn":
            suggest = "ended_on"
        elif key == "errorPrefix":
            suggest = "error_prefix"
        elif key == "itemsCompletedCount":
            suggest = "items_completed_count"
        elif key == "itemsCount":
            suggest = "items_count"
        elif key == "objectName":
            suggest = "object_name"
        elif key == "resultPrefix":
            suggest = "result_prefix"
        elif key == "resultType":
            suggest = "result_type"
        elif key == "startedOn":
            suggest = "started_on"
        elif key == "statusMessage":
            suggest = "status_message"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MigrateSqlServerSqlDbTaskOutputTableLevelResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MigrateSqlServerSqlDbTaskOutputTableLevelResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MigrateSqlServerSqlDbTaskOutputTableLevelResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ended_on: str,
                 error_prefix: str,
                 id: str,
                 items_completed_count: float,
                 items_count: float,
                 object_name: str,
                 result_prefix: str,
                 result_type: str,
                 started_on: str,
                 state: str,
                 status_message: str):
        """
        Table level result for Sql Server to Azure Sql DB migration.
        :param str ended_on: Migration end time
        :param str error_prefix: Wildcard string prefix to use for querying all errors of the item
        :param str id: Result identifier
        :param float items_completed_count: Number of successfully completed items
        :param float items_count: Number of items
        :param str object_name: Name of the item
        :param str result_prefix: Wildcard string prefix to use for querying all sub-tem results of the item
        :param str result_type: Result type
               Expected value is 'TableLevelOutput'.
        :param str started_on: Migration start time
        :param str state: Current state of migration
        :param str status_message: Status message
        """
        pulumi.set(__self__, "ended_on", ended_on)
        pulumi.set(__self__, "error_prefix", error_prefix)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "items_completed_count", items_completed_count)
        pulumi.set(__self__, "items_count", items_count)
        pulumi.set(__self__, "object_name", object_name)
        pulumi.set(__self__, "result_prefix", result_prefix)
        pulumi.set(__self__, "result_type", 'TableLevelOutput')
        pulumi.set(__self__, "started_on", started_on)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "status_message", status_message)

    @property
    @pulumi.getter(name="endedOn")
    def ended_on(self) -> str:
        """
        Migration end time
        """
        return pulumi.get(self, "ended_on")

    @property
    @pulumi.getter(name="errorPrefix")
    def error_prefix(self) -> str:
        """
        Wildcard string prefix to use for querying all errors of the item
        """
        return pulumi.get(self, "error_prefix")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Result identifier
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="itemsCompletedCount")
    def items_completed_count(self) -> float:
        """
        Number of successfully completed items
        """
        return pulumi.get(self, "items_completed_count")

    @property
    @pulumi.getter(name="itemsCount")
    def items_count(self) -> float:
        """
        Number of items
        """
        return pulumi.get(self, "items_count")

    @property
    @pulumi.getter(name="objectName")
    def object_name(self) -> str:
        """
        Name of the item
        """
        return pulumi.get(self, "object_name")

    @property
    @pulumi.getter(name="resultPrefix")
    def result_prefix(self) -> str:
        """
        Wildcard string prefix to use for querying all sub-tem results of the item
        """
        return pulumi.get(self, "result_prefix")

    @property
    @pulumi.getter(name="resultType")
    def result_type(self) -> str:
        """
        Result type
        Expected value is 'TableLevelOutput'.
        """
        return pulumi.get(self, "result_type")

    @property
    @pulumi.getter(name="startedOn")
    def started_on(self) -> str:
        """
        Migration start time
        """
        return pulumi.get(self, "started_on")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        Current state of migration
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="statusMessage")
    def status_message(self) -> str:
        """
        Status message
        """
        return pulumi.get(self, "status_message")


@pulumi.output_type
class MigrateSqlServerSqlDbTaskOutputValidationResultResponse(dict):
    """
    Validation result for Sql Server to Azure Sql DB migration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "migrationId":
            suggest = "migration_id"
        elif key == "resultType":
            suggest = "result_type"
        elif key == "summaryResults":
            suggest = "summary_results"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MigrateSqlServerSqlDbTaskOutputValidationResultResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MigrateSqlServerSqlDbTaskOutputValidationResultResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MigrateSqlServerSqlDbTaskOutputValidationResultResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: str,
                 migration_id: str,
                 result_type: str,
                 status: str,
                 summary_results: Optional[Mapping[str, 'outputs.MigrationValidationDatabaseSummaryResultResponse']] = None):
        """
        Validation result for Sql Server to Azure Sql DB migration.
        :param str id: Result identifier
        :param str migration_id: Migration Identifier
        :param str result_type: Result type
               Expected value is 'MigrationValidationOutput'.
        :param str status: Current status of validation at the migration level. Status from the database validation result status will be aggregated here.
        :param Mapping[str, 'MigrationValidationDatabaseSummaryResultResponse'] summary_results: Validation summary results for each database
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "migration_id", migration_id)
        pulumi.set(__self__, "result_type", 'MigrationValidationOutput')
        pulumi.set(__self__, "status", status)
        if summary_results is not None:
            pulumi.set(__self__, "summary_results", summary_results)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Result identifier
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="migrationId")
    def migration_id(self) -> str:
        """
        Migration Identifier
        """
        return pulumi.get(self, "migration_id")

    @property
    @pulumi.getter(name="resultType")
    def result_type(self) -> str:
        """
        Result type
        Expected value is 'MigrationValidationOutput'.
        """
        return pulumi.get(self, "result_type")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Current status of validation at the migration level. Status from the database validation result status will be aggregated here.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="summaryResults")
    def summary_results(self) -> Optional[Mapping[str, 'outputs.MigrationValidationDatabaseSummaryResultResponse']]:
        """
        Validation summary results for each database
        """
        return pulumi.get(self, "summary_results")


@pulumi.output_type
class MigrateSqlServerSqlDbTaskPropertiesResponse(dict):
    """
    Properties for the task that migrates on-prem SQL Server databases to Azure SQL Database
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "taskType":
            suggest = "task_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MigrateSqlServerSqlDbTaskPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MigrateSqlServerSqlDbTaskPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MigrateSqlServerSqlDbTaskPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 commands: Sequence[Any],
                 errors: Sequence['outputs.ODataErrorResponse'],
                 output: Sequence[Any],
                 state: str,
                 task_type: str,
                 input: Optional['outputs.MigrateSqlServerSqlDbTaskInputResponse'] = None):
        """
        Properties for the task that migrates on-prem SQL Server databases to Azure SQL Database
        :param Sequence[Union['MigrateMISyncCompleteCommandPropertiesResponse', 'MigrateSyncCompleteCommandPropertiesResponse']] commands: Array of command properties.
        :param Sequence['ODataErrorResponse'] errors: Array of errors. This is ignored if submitted.
        :param Sequence[Union['MigrateSqlServerSqlDbTaskOutputDatabaseLevelResponse', 'MigrateSqlServerSqlDbTaskOutputDatabaseLevelValidationResultResponse', 'MigrateSqlServerSqlDbTaskOutputErrorResponse', 'MigrateSqlServerSqlDbTaskOutputMigrationLevelResponse', 'MigrateSqlServerSqlDbTaskOutputTableLevelResponse', 'MigrateSqlServerSqlDbTaskOutputValidationResultResponse']] output: Task output. This is ignored if submitted.
        :param str state: The state of the task. This is ignored if submitted.
        :param str task_type: Task type.
               Expected value is 'Migrate.SqlServer.SqlDb'.
        :param 'MigrateSqlServerSqlDbTaskInputResponse' input: Task input
        """
        pulumi.set(__self__, "commands", commands)
        pulumi.set(__self__, "errors", errors)
        pulumi.set(__self__, "output", output)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "task_type", 'Migrate.SqlServer.SqlDb')
        if input is not None:
            pulumi.set(__self__, "input", input)

    @property
    @pulumi.getter
    def commands(self) -> Sequence[Any]:
        """
        Array of command properties.
        """
        return pulumi.get(self, "commands")

    @property
    @pulumi.getter
    def errors(self) -> Sequence['outputs.ODataErrorResponse']:
        """
        Array of errors. This is ignored if submitted.
        """
        return pulumi.get(self, "errors")

    @property
    @pulumi.getter
    def output(self) -> Sequence[Any]:
        """
        Task output. This is ignored if submitted.
        """
        return pulumi.get(self, "output")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The state of the task. This is ignored if submitted.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="taskType")
    def task_type(self) -> str:
        """
        Task type.
        Expected value is 'Migrate.SqlServer.SqlDb'.
        """
        return pulumi.get(self, "task_type")

    @property
    @pulumi.getter
    def input(self) -> Optional['outputs.MigrateSqlServerSqlDbTaskInputResponse']:
        """
        Task input
        """
        return pulumi.get(self, "input")


@pulumi.output_type
class MigrateSqlServerSqlMIDatabaseInputResponse(dict):
    """
    Database specific information for SQL to Azure SQL DB Managed Instance migration task inputs
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "restoreDatabaseName":
            suggest = "restore_database_name"
        elif key == "backupFilePaths":
            suggest = "backup_file_paths"
        elif key == "backupFileShare":
            suggest = "backup_file_share"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MigrateSqlServerSqlMIDatabaseInputResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MigrateSqlServerSqlMIDatabaseInputResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MigrateSqlServerSqlMIDatabaseInputResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 restore_database_name: str,
                 backup_file_paths: Optional[Sequence[str]] = None,
                 backup_file_share: Optional['outputs.FileShareResponse'] = None):
        """
        Database specific information for SQL to Azure SQL DB Managed Instance migration task inputs
        :param str name: Name of the database
        :param str restore_database_name: Name of the database at destination
        :param Sequence[str] backup_file_paths: The list of backup files to be used in case of existing backups.
        :param 'FileShareResponse' backup_file_share: Backup file share information for backing up this database.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "restore_database_name", restore_database_name)
        if backup_file_paths is not None:
            pulumi.set(__self__, "backup_file_paths", backup_file_paths)
        if backup_file_share is not None:
            pulumi.set(__self__, "backup_file_share", backup_file_share)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the database
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="restoreDatabaseName")
    def restore_database_name(self) -> str:
        """
        Name of the database at destination
        """
        return pulumi.get(self, "restore_database_name")

    @property
    @pulumi.getter(name="backupFilePaths")
    def backup_file_paths(self) -> Optional[Sequence[str]]:
        """
        The list of backup files to be used in case of existing backups.
        """
        return pulumi.get(self, "backup_file_paths")

    @property
    @pulumi.getter(name="backupFileShare")
    def backup_file_share(self) -> Optional['outputs.FileShareResponse']:
        """
        Backup file share information for backing up this database.
        """
        return pulumi.get(self, "backup_file_share")


@pulumi.output_type
class MigrateSqlServerSqlMISyncTaskInputResponse(dict):
    """
    Input for task that migrates SQL Server databases to Azure SQL Database Managed Instance online scenario.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "azureApp":
            suggest = "azure_app"
        elif key == "selectedDatabases":
            suggest = "selected_databases"
        elif key == "sourceConnectionInfo":
            suggest = "source_connection_info"
        elif key == "storageResourceId":
            suggest = "storage_resource_id"
        elif key == "targetConnectionInfo":
            suggest = "target_connection_info"
        elif key == "backupFileShare":
            suggest = "backup_file_share"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MigrateSqlServerSqlMISyncTaskInputResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MigrateSqlServerSqlMISyncTaskInputResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MigrateSqlServerSqlMISyncTaskInputResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 azure_app: 'outputs.AzureActiveDirectoryAppResponse',
                 selected_databases: Sequence['outputs.MigrateSqlServerSqlMIDatabaseInputResponse'],
                 source_connection_info: 'outputs.SqlConnectionInfoResponse',
                 storage_resource_id: str,
                 target_connection_info: 'outputs.MiSqlConnectionInfoResponse',
                 backup_file_share: Optional['outputs.FileShareResponse'] = None):
        """
        Input for task that migrates SQL Server databases to Azure SQL Database Managed Instance online scenario.
        :param 'AzureActiveDirectoryAppResponse' azure_app: Azure Active Directory Application the DMS instance will use to connect to the target instance of Azure SQL Database Managed Instance and the Azure Storage Account
        :param Sequence['MigrateSqlServerSqlMIDatabaseInputResponse'] selected_databases: Databases to migrate
        :param 'SqlConnectionInfoResponse' source_connection_info: Connection information for source SQL Server
        :param str storage_resource_id: Fully qualified resourceId of storage
        :param 'MiSqlConnectionInfoResponse' target_connection_info: Connection information for Azure SQL Database Managed Instance
        :param 'FileShareResponse' backup_file_share: Backup file share information for all selected databases.
        """
        pulumi.set(__self__, "azure_app", azure_app)
        pulumi.set(__self__, "selected_databases", selected_databases)
        pulumi.set(__self__, "source_connection_info", source_connection_info)
        pulumi.set(__self__, "storage_resource_id", storage_resource_id)
        pulumi.set(__self__, "target_connection_info", target_connection_info)
        if backup_file_share is not None:
            pulumi.set(__self__, "backup_file_share", backup_file_share)

    @property
    @pulumi.getter(name="azureApp")
    def azure_app(self) -> 'outputs.AzureActiveDirectoryAppResponse':
        """
        Azure Active Directory Application the DMS instance will use to connect to the target instance of Azure SQL Database Managed Instance and the Azure Storage Account
        """
        return pulumi.get(self, "azure_app")

    @property
    @pulumi.getter(name="selectedDatabases")
    def selected_databases(self) -> Sequence['outputs.MigrateSqlServerSqlMIDatabaseInputResponse']:
        """
        Databases to migrate
        """
        return pulumi.get(self, "selected_databases")

    @property
    @pulumi.getter(name="sourceConnectionInfo")
    def source_connection_info(self) -> 'outputs.SqlConnectionInfoResponse':
        """
        Connection information for source SQL Server
        """
        return pulumi.get(self, "source_connection_info")

    @property
    @pulumi.getter(name="storageResourceId")
    def storage_resource_id(self) -> str:
        """
        Fully qualified resourceId of storage
        """
        return pulumi.get(self, "storage_resource_id")

    @property
    @pulumi.getter(name="targetConnectionInfo")
    def target_connection_info(self) -> 'outputs.MiSqlConnectionInfoResponse':
        """
        Connection information for Azure SQL Database Managed Instance
        """
        return pulumi.get(self, "target_connection_info")

    @property
    @pulumi.getter(name="backupFileShare")
    def backup_file_share(self) -> Optional['outputs.FileShareResponse']:
        """
        Backup file share information for all selected databases.
        """
        return pulumi.get(self, "backup_file_share")


@pulumi.output_type
class MigrateSqlServerSqlMISyncTaskOutputDatabaseLevelResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "activeBackupSets":
            suggest = "active_backup_sets"
        elif key == "containerName":
            suggest = "container_name"
        elif key == "endedOn":
            suggest = "ended_on"
        elif key == "errorPrefix":
            suggest = "error_prefix"
        elif key == "exceptionsAndWarnings":
            suggest = "exceptions_and_warnings"
        elif key == "fullBackupSetInfo":
            suggest = "full_backup_set_info"
        elif key == "isFullBackupRestored":
            suggest = "is_full_backup_restored"
        elif key == "lastRestoredBackupSetInfo":
            suggest = "last_restored_backup_set_info"
        elif key == "migrationState":
            suggest = "migration_state"
        elif key == "resultType":
            suggest = "result_type"
        elif key == "sourceDatabaseName":
            suggest = "source_database_name"
        elif key == "startedOn":
            suggest = "started_on"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MigrateSqlServerSqlMISyncTaskOutputDatabaseLevelResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MigrateSqlServerSqlMISyncTaskOutputDatabaseLevelResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MigrateSqlServerSqlMISyncTaskOutputDatabaseLevelResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 active_backup_sets: Sequence['outputs.BackupSetInfoResponse'],
                 container_name: str,
                 ended_on: str,
                 error_prefix: str,
                 exceptions_and_warnings: Sequence['outputs.ReportableExceptionResponse'],
                 full_backup_set_info: 'outputs.BackupSetInfoResponse',
                 id: str,
                 is_full_backup_restored: bool,
                 last_restored_backup_set_info: 'outputs.BackupSetInfoResponse',
                 migration_state: str,
                 result_type: str,
                 source_database_name: str,
                 started_on: str):
        """
        :param Sequence['BackupSetInfoResponse'] active_backup_sets: Backup sets that are currently active (Either being uploaded or getting restored)
        :param str container_name: Name of container created in the Azure Storage account where backups are copied to
        :param str ended_on: Database migration end time
        :param str error_prefix: prefix string to use for querying errors for this database
        :param Sequence['ReportableExceptionResponse'] exceptions_and_warnings: Migration exceptions and warnings
        :param 'BackupSetInfoResponse' full_backup_set_info: Details of full backup set
        :param str id: Result identifier
        :param bool is_full_backup_restored: Whether full backup has been applied to the target database or not
        :param 'BackupSetInfoResponse' last_restored_backup_set_info: Last applied backup set information
        :param str migration_state: Current state of database
        :param str result_type: Result type
               Expected value is 'DatabaseLevelOutput'.
        :param str source_database_name: Name of the database
        :param str started_on: Database migration start time
        """
        pulumi.set(__self__, "active_backup_sets", active_backup_sets)
        pulumi.set(__self__, "container_name", container_name)
        pulumi.set(__self__, "ended_on", ended_on)
        pulumi.set(__self__, "error_prefix", error_prefix)
        pulumi.set(__self__, "exceptions_and_warnings", exceptions_and_warnings)
        pulumi.set(__self__, "full_backup_set_info", full_backup_set_info)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "is_full_backup_restored", is_full_backup_restored)
        pulumi.set(__self__, "last_restored_backup_set_info", last_restored_backup_set_info)
        pulumi.set(__self__, "migration_state", migration_state)
        pulumi.set(__self__, "result_type", 'DatabaseLevelOutput')
        pulumi.set(__self__, "source_database_name", source_database_name)
        pulumi.set(__self__, "started_on", started_on)

    @property
    @pulumi.getter(name="activeBackupSets")
    def active_backup_sets(self) -> Sequence['outputs.BackupSetInfoResponse']:
        """
        Backup sets that are currently active (Either being uploaded or getting restored)
        """
        return pulumi.get(self, "active_backup_sets")

    @property
    @pulumi.getter(name="containerName")
    def container_name(self) -> str:
        """
        Name of container created in the Azure Storage account where backups are copied to
        """
        return pulumi.get(self, "container_name")

    @property
    @pulumi.getter(name="endedOn")
    def ended_on(self) -> str:
        """
        Database migration end time
        """
        return pulumi.get(self, "ended_on")

    @property
    @pulumi.getter(name="errorPrefix")
    def error_prefix(self) -> str:
        """
        prefix string to use for querying errors for this database
        """
        return pulumi.get(self, "error_prefix")

    @property
    @pulumi.getter(name="exceptionsAndWarnings")
    def exceptions_and_warnings(self) -> Sequence['outputs.ReportableExceptionResponse']:
        """
        Migration exceptions and warnings
        """
        return pulumi.get(self, "exceptions_and_warnings")

    @property
    @pulumi.getter(name="fullBackupSetInfo")
    def full_backup_set_info(self) -> 'outputs.BackupSetInfoResponse':
        """
        Details of full backup set
        """
        return pulumi.get(self, "full_backup_set_info")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Result identifier
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isFullBackupRestored")
    def is_full_backup_restored(self) -> bool:
        """
        Whether full backup has been applied to the target database or not
        """
        return pulumi.get(self, "is_full_backup_restored")

    @property
    @pulumi.getter(name="lastRestoredBackupSetInfo")
    def last_restored_backup_set_info(self) -> 'outputs.BackupSetInfoResponse':
        """
        Last applied backup set information
        """
        return pulumi.get(self, "last_restored_backup_set_info")

    @property
    @pulumi.getter(name="migrationState")
    def migration_state(self) -> str:
        """
        Current state of database
        """
        return pulumi.get(self, "migration_state")

    @property
    @pulumi.getter(name="resultType")
    def result_type(self) -> str:
        """
        Result type
        Expected value is 'DatabaseLevelOutput'.
        """
        return pulumi.get(self, "result_type")

    @property
    @pulumi.getter(name="sourceDatabaseName")
    def source_database_name(self) -> str:
        """
        Name of the database
        """
        return pulumi.get(self, "source_database_name")

    @property
    @pulumi.getter(name="startedOn")
    def started_on(self) -> str:
        """
        Database migration start time
        """
        return pulumi.get(self, "started_on")


@pulumi.output_type
class MigrateSqlServerSqlMISyncTaskOutputErrorResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resultType":
            suggest = "result_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MigrateSqlServerSqlMISyncTaskOutputErrorResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MigrateSqlServerSqlMISyncTaskOutputErrorResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MigrateSqlServerSqlMISyncTaskOutputErrorResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 error: 'outputs.ReportableExceptionResponse',
                 id: str,
                 result_type: str):
        """
        :param 'ReportableExceptionResponse' error: Migration error
        :param str id: Result identifier
        :param str result_type: Result type
               Expected value is 'ErrorOutput'.
        """
        pulumi.set(__self__, "error", error)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "result_type", 'ErrorOutput')

    @property
    @pulumi.getter
    def error(self) -> 'outputs.ReportableExceptionResponse':
        """
        Migration error
        """
        return pulumi.get(self, "error")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Result identifier
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="resultType")
    def result_type(self) -> str:
        """
        Result type
        Expected value is 'ErrorOutput'.
        """
        return pulumi.get(self, "result_type")


@pulumi.output_type
class MigrateSqlServerSqlMISyncTaskOutputMigrationLevelResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "databaseCount":
            suggest = "database_count"
        elif key == "databaseErrorCount":
            suggest = "database_error_count"
        elif key == "endedOn":
            suggest = "ended_on"
        elif key == "resultType":
            suggest = "result_type"
        elif key == "sourceServerBrandVersion":
            suggest = "source_server_brand_version"
        elif key == "sourceServerName":
            suggest = "source_server_name"
        elif key == "sourceServerVersion":
            suggest = "source_server_version"
        elif key == "startedOn":
            suggest = "started_on"
        elif key == "targetServerBrandVersion":
            suggest = "target_server_brand_version"
        elif key == "targetServerName":
            suggest = "target_server_name"
        elif key == "targetServerVersion":
            suggest = "target_server_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MigrateSqlServerSqlMISyncTaskOutputMigrationLevelResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MigrateSqlServerSqlMISyncTaskOutputMigrationLevelResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MigrateSqlServerSqlMISyncTaskOutputMigrationLevelResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 database_count: int,
                 database_error_count: int,
                 ended_on: str,
                 id: str,
                 result_type: str,
                 source_server_brand_version: str,
                 source_server_name: str,
                 source_server_version: str,
                 started_on: str,
                 state: str,
                 target_server_brand_version: str,
                 target_server_name: str,
                 target_server_version: str):
        """
        :param int database_count: Count of databases
        :param int database_error_count: Number of database level errors
        :param str ended_on: Migration end time
        :param str id: Result identifier
        :param str result_type: Result type
               Expected value is 'MigrationLevelOutput'.
        :param str source_server_brand_version: Source server brand version
        :param str source_server_name: Source server name
        :param str source_server_version: Source server version
        :param str started_on: Migration start time
        :param str state: Current state of migration
        :param str target_server_brand_version: Target server brand version
        :param str target_server_name: Target server name
        :param str target_server_version: Target server version
        """
        pulumi.set(__self__, "database_count", database_count)
        pulumi.set(__self__, "database_error_count", database_error_count)
        pulumi.set(__self__, "ended_on", ended_on)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "result_type", 'MigrationLevelOutput')
        pulumi.set(__self__, "source_server_brand_version", source_server_brand_version)
        pulumi.set(__self__, "source_server_name", source_server_name)
        pulumi.set(__self__, "source_server_version", source_server_version)
        pulumi.set(__self__, "started_on", started_on)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "target_server_brand_version", target_server_brand_version)
        pulumi.set(__self__, "target_server_name", target_server_name)
        pulumi.set(__self__, "target_server_version", target_server_version)

    @property
    @pulumi.getter(name="databaseCount")
    def database_count(self) -> int:
        """
        Count of databases
        """
        return pulumi.get(self, "database_count")

    @property
    @pulumi.getter(name="databaseErrorCount")
    def database_error_count(self) -> int:
        """
        Number of database level errors
        """
        return pulumi.get(self, "database_error_count")

    @property
    @pulumi.getter(name="endedOn")
    def ended_on(self) -> str:
        """
        Migration end time
        """
        return pulumi.get(self, "ended_on")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Result identifier
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="resultType")
    def result_type(self) -> str:
        """
        Result type
        Expected value is 'MigrationLevelOutput'.
        """
        return pulumi.get(self, "result_type")

    @property
    @pulumi.getter(name="sourceServerBrandVersion")
    def source_server_brand_version(self) -> str:
        """
        Source server brand version
        """
        return pulumi.get(self, "source_server_brand_version")

    @property
    @pulumi.getter(name="sourceServerName")
    def source_server_name(self) -> str:
        """
        Source server name
        """
        return pulumi.get(self, "source_server_name")

    @property
    @pulumi.getter(name="sourceServerVersion")
    def source_server_version(self) -> str:
        """
        Source server version
        """
        return pulumi.get(self, "source_server_version")

    @property
    @pulumi.getter(name="startedOn")
    def started_on(self) -> str:
        """
        Migration start time
        """
        return pulumi.get(self, "started_on")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        Current state of migration
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="targetServerBrandVersion")
    def target_server_brand_version(self) -> str:
        """
        Target server brand version
        """
        return pulumi.get(self, "target_server_brand_version")

    @property
    @pulumi.getter(name="targetServerName")
    def target_server_name(self) -> str:
        """
        Target server name
        """
        return pulumi.get(self, "target_server_name")

    @property
    @pulumi.getter(name="targetServerVersion")
    def target_server_version(self) -> str:
        """
        Target server version
        """
        return pulumi.get(self, "target_server_version")


@pulumi.output_type
class MigrateSqlServerSqlMISyncTaskPropertiesResponse(dict):
    """
    Properties for task that migrates SQL Server databases to Azure SQL Database Managed Instance sync scenario
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "taskType":
            suggest = "task_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MigrateSqlServerSqlMISyncTaskPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MigrateSqlServerSqlMISyncTaskPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MigrateSqlServerSqlMISyncTaskPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 commands: Sequence[Any],
                 errors: Sequence['outputs.ODataErrorResponse'],
                 output: Sequence[Any],
                 state: str,
                 task_type: str,
                 input: Optional['outputs.MigrateSqlServerSqlMISyncTaskInputResponse'] = None):
        """
        Properties for task that migrates SQL Server databases to Azure SQL Database Managed Instance sync scenario
        :param Sequence[Union['MigrateMISyncCompleteCommandPropertiesResponse', 'MigrateSyncCompleteCommandPropertiesResponse']] commands: Array of command properties.
        :param Sequence['ODataErrorResponse'] errors: Array of errors. This is ignored if submitted.
        :param Sequence[Union['MigrateSqlServerSqlMISyncTaskOutputDatabaseLevelResponse', 'MigrateSqlServerSqlMISyncTaskOutputErrorResponse', 'MigrateSqlServerSqlMISyncTaskOutputMigrationLevelResponse']] output: Task output. This is ignored if submitted.
        :param str state: The state of the task. This is ignored if submitted.
        :param str task_type: Task type.
               Expected value is 'Migrate.SqlServer.AzureSqlDbMI.Sync.LRS'.
        :param 'MigrateSqlServerSqlMISyncTaskInputResponse' input: Task input
        """
        pulumi.set(__self__, "commands", commands)
        pulumi.set(__self__, "errors", errors)
        pulumi.set(__self__, "output", output)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "task_type", 'Migrate.SqlServer.AzureSqlDbMI.Sync.LRS')
        if input is not None:
            pulumi.set(__self__, "input", input)

    @property
    @pulumi.getter
    def commands(self) -> Sequence[Any]:
        """
        Array of command properties.
        """
        return pulumi.get(self, "commands")

    @property
    @pulumi.getter
    def errors(self) -> Sequence['outputs.ODataErrorResponse']:
        """
        Array of errors. This is ignored if submitted.
        """
        return pulumi.get(self, "errors")

    @property
    @pulumi.getter
    def output(self) -> Sequence[Any]:
        """
        Task output. This is ignored if submitted.
        """
        return pulumi.get(self, "output")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The state of the task. This is ignored if submitted.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="taskType")
    def task_type(self) -> str:
        """
        Task type.
        Expected value is 'Migrate.SqlServer.AzureSqlDbMI.Sync.LRS'.
        """
        return pulumi.get(self, "task_type")

    @property
    @pulumi.getter
    def input(self) -> Optional['outputs.MigrateSqlServerSqlMISyncTaskInputResponse']:
        """
        Task input
        """
        return pulumi.get(self, "input")


@pulumi.output_type
class MigrateSqlServerSqlMITaskInputResponse(dict):
    """
    Input for task that migrates SQL Server databases to Azure SQL Database Managed Instance.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backupBlobShare":
            suggest = "backup_blob_share"
        elif key == "selectedDatabases":
            suggest = "selected_databases"
        elif key == "sourceConnectionInfo":
            suggest = "source_connection_info"
        elif key == "targetConnectionInfo":
            suggest = "target_connection_info"
        elif key == "backupFileShare":
            suggest = "backup_file_share"
        elif key == "backupMode":
            suggest = "backup_mode"
        elif key == "selectedAgentJobs":
            suggest = "selected_agent_jobs"
        elif key == "selectedLogins":
            suggest = "selected_logins"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MigrateSqlServerSqlMITaskInputResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MigrateSqlServerSqlMITaskInputResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MigrateSqlServerSqlMITaskInputResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backup_blob_share: 'outputs.BlobShareResponse',
                 selected_databases: Sequence['outputs.MigrateSqlServerSqlMIDatabaseInputResponse'],
                 source_connection_info: 'outputs.SqlConnectionInfoResponse',
                 target_connection_info: 'outputs.SqlConnectionInfoResponse',
                 backup_file_share: Optional['outputs.FileShareResponse'] = None,
                 backup_mode: Optional[str] = None,
                 selected_agent_jobs: Optional[Sequence[str]] = None,
                 selected_logins: Optional[Sequence[str]] = None):
        """
        Input for task that migrates SQL Server databases to Azure SQL Database Managed Instance.
        :param 'BlobShareResponse' backup_blob_share: SAS URI of Azure Storage Account Container to be used for storing backup files.
        :param Sequence['MigrateSqlServerSqlMIDatabaseInputResponse'] selected_databases: Databases to migrate
        :param 'SqlConnectionInfoResponse' source_connection_info: Information for connecting to source
        :param 'SqlConnectionInfoResponse' target_connection_info: Information for connecting to target
        :param 'FileShareResponse' backup_file_share: Backup file share information for all selected databases.
        :param str backup_mode: Backup Mode to specify whether to use existing backup or create new backup. If using existing backups, backup file paths are required to be provided in selectedDatabases.
        :param Sequence[str] selected_agent_jobs: Agent Jobs to migrate.
        :param Sequence[str] selected_logins: Logins to migrate.
        """
        pulumi.set(__self__, "backup_blob_share", backup_blob_share)
        pulumi.set(__self__, "selected_databases", selected_databases)
        pulumi.set(__self__, "source_connection_info", source_connection_info)
        pulumi.set(__self__, "target_connection_info", target_connection_info)
        if backup_file_share is not None:
            pulumi.set(__self__, "backup_file_share", backup_file_share)
        if backup_mode is not None:
            pulumi.set(__self__, "backup_mode", backup_mode)
        if selected_agent_jobs is not None:
            pulumi.set(__self__, "selected_agent_jobs", selected_agent_jobs)
        if selected_logins is not None:
            pulumi.set(__self__, "selected_logins", selected_logins)

    @property
    @pulumi.getter(name="backupBlobShare")
    def backup_blob_share(self) -> 'outputs.BlobShareResponse':
        """
        SAS URI of Azure Storage Account Container to be used for storing backup files.
        """
        return pulumi.get(self, "backup_blob_share")

    @property
    @pulumi.getter(name="selectedDatabases")
    def selected_databases(self) -> Sequence['outputs.MigrateSqlServerSqlMIDatabaseInputResponse']:
        """
        Databases to migrate
        """
        return pulumi.get(self, "selected_databases")

    @property
    @pulumi.getter(name="sourceConnectionInfo")
    def source_connection_info(self) -> 'outputs.SqlConnectionInfoResponse':
        """
        Information for connecting to source
        """
        return pulumi.get(self, "source_connection_info")

    @property
    @pulumi.getter(name="targetConnectionInfo")
    def target_connection_info(self) -> 'outputs.SqlConnectionInfoResponse':
        """
        Information for connecting to target
        """
        return pulumi.get(self, "target_connection_info")

    @property
    @pulumi.getter(name="backupFileShare")
    def backup_file_share(self) -> Optional['outputs.FileShareResponse']:
        """
        Backup file share information for all selected databases.
        """
        return pulumi.get(self, "backup_file_share")

    @property
    @pulumi.getter(name="backupMode")
    def backup_mode(self) -> Optional[str]:
        """
        Backup Mode to specify whether to use existing backup or create new backup. If using existing backups, backup file paths are required to be provided in selectedDatabases.
        """
        return pulumi.get(self, "backup_mode")

    @property
    @pulumi.getter(name="selectedAgentJobs")
    def selected_agent_jobs(self) -> Optional[Sequence[str]]:
        """
        Agent Jobs to migrate.
        """
        return pulumi.get(self, "selected_agent_jobs")

    @property
    @pulumi.getter(name="selectedLogins")
    def selected_logins(self) -> Optional[Sequence[str]]:
        """
        Logins to migrate.
        """
        return pulumi.get(self, "selected_logins")


@pulumi.output_type
class MigrateSqlServerSqlMITaskOutputAgentJobLevelResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endedOn":
            suggest = "ended_on"
        elif key == "exceptionsAndWarnings":
            suggest = "exceptions_and_warnings"
        elif key == "isEnabled":
            suggest = "is_enabled"
        elif key == "resultType":
            suggest = "result_type"
        elif key == "startedOn":
            suggest = "started_on"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MigrateSqlServerSqlMITaskOutputAgentJobLevelResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MigrateSqlServerSqlMITaskOutputAgentJobLevelResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MigrateSqlServerSqlMITaskOutputAgentJobLevelResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ended_on: str,
                 exceptions_and_warnings: Sequence['outputs.ReportableExceptionResponse'],
                 id: str,
                 is_enabled: bool,
                 message: str,
                 name: str,
                 result_type: str,
                 started_on: str,
                 state: str):
        """
        :param str ended_on: Migration end time
        :param Sequence['ReportableExceptionResponse'] exceptions_and_warnings: Migration errors and warnings per job
        :param str id: Result identifier
        :param bool is_enabled: The state of the original Agent Job.
        :param str message: Migration progress message
        :param str name: Agent Job name.
        :param str result_type: Result type
               Expected value is 'AgentJobLevelOutput'.
        :param str started_on: Migration start time
        :param str state: Current state of migration
        """
        pulumi.set(__self__, "ended_on", ended_on)
        pulumi.set(__self__, "exceptions_and_warnings", exceptions_and_warnings)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "is_enabled", is_enabled)
        pulumi.set(__self__, "message", message)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "result_type", 'AgentJobLevelOutput')
        pulumi.set(__self__, "started_on", started_on)
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="endedOn")
    def ended_on(self) -> str:
        """
        Migration end time
        """
        return pulumi.get(self, "ended_on")

    @property
    @pulumi.getter(name="exceptionsAndWarnings")
    def exceptions_and_warnings(self) -> Sequence['outputs.ReportableExceptionResponse']:
        """
        Migration errors and warnings per job
        """
        return pulumi.get(self, "exceptions_and_warnings")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Result identifier
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> bool:
        """
        The state of the original Agent Job.
        """
        return pulumi.get(self, "is_enabled")

    @property
    @pulumi.getter
    def message(self) -> str:
        """
        Migration progress message
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Agent Job name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="resultType")
    def result_type(self) -> str:
        """
        Result type
        Expected value is 'AgentJobLevelOutput'.
        """
        return pulumi.get(self, "result_type")

    @property
    @pulumi.getter(name="startedOn")
    def started_on(self) -> str:
        """
        Migration start time
        """
        return pulumi.get(self, "started_on")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        Current state of migration
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class MigrateSqlServerSqlMITaskOutputDatabaseLevelResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "databaseName":
            suggest = "database_name"
        elif key == "endedOn":
            suggest = "ended_on"
        elif key == "exceptionsAndWarnings":
            suggest = "exceptions_and_warnings"
        elif key == "resultType":
            suggest = "result_type"
        elif key == "sizeMB":
            suggest = "size_mb"
        elif key == "startedOn":
            suggest = "started_on"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MigrateSqlServerSqlMITaskOutputDatabaseLevelResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MigrateSqlServerSqlMITaskOutputDatabaseLevelResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MigrateSqlServerSqlMITaskOutputDatabaseLevelResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 database_name: str,
                 ended_on: str,
                 exceptions_and_warnings: Sequence['outputs.ReportableExceptionResponse'],
                 id: str,
                 message: str,
                 result_type: str,
                 size_mb: float,
                 stage: str,
                 started_on: str,
                 state: str):
        """
        :param str database_name: Name of the database
        :param str ended_on: Migration end time
        :param Sequence['ReportableExceptionResponse'] exceptions_and_warnings: Migration exceptions and warnings
        :param str id: Result identifier
        :param str message: Migration progress message
        :param str result_type: Result type
               Expected value is 'DatabaseLevelOutput'.
        :param float size_mb: Size of the database in megabytes
        :param str stage: Current stage of migration
        :param str started_on: Migration start time
        :param str state: Current state of migration
        """
        pulumi.set(__self__, "database_name", database_name)
        pulumi.set(__self__, "ended_on", ended_on)
        pulumi.set(__self__, "exceptions_and_warnings", exceptions_and_warnings)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "message", message)
        pulumi.set(__self__, "result_type", 'DatabaseLevelOutput')
        pulumi.set(__self__, "size_mb", size_mb)
        pulumi.set(__self__, "stage", stage)
        pulumi.set(__self__, "started_on", started_on)
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> str:
        """
        Name of the database
        """
        return pulumi.get(self, "database_name")

    @property
    @pulumi.getter(name="endedOn")
    def ended_on(self) -> str:
        """
        Migration end time
        """
        return pulumi.get(self, "ended_on")

    @property
    @pulumi.getter(name="exceptionsAndWarnings")
    def exceptions_and_warnings(self) -> Sequence['outputs.ReportableExceptionResponse']:
        """
        Migration exceptions and warnings
        """
        return pulumi.get(self, "exceptions_and_warnings")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Result identifier
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def message(self) -> str:
        """
        Migration progress message
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter(name="resultType")
    def result_type(self) -> str:
        """
        Result type
        Expected value is 'DatabaseLevelOutput'.
        """
        return pulumi.get(self, "result_type")

    @property
    @pulumi.getter(name="sizeMB")
    def size_mb(self) -> float:
        """
        Size of the database in megabytes
        """
        return pulumi.get(self, "size_mb")

    @property
    @pulumi.getter
    def stage(self) -> str:
        """
        Current stage of migration
        """
        return pulumi.get(self, "stage")

    @property
    @pulumi.getter(name="startedOn")
    def started_on(self) -> str:
        """
        Migration start time
        """
        return pulumi.get(self, "started_on")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        Current state of migration
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class MigrateSqlServerSqlMITaskOutputErrorResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resultType":
            suggest = "result_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MigrateSqlServerSqlMITaskOutputErrorResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MigrateSqlServerSqlMITaskOutputErrorResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MigrateSqlServerSqlMITaskOutputErrorResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 error: 'outputs.ReportableExceptionResponse',
                 id: str,
                 result_type: str):
        """
        :param 'ReportableExceptionResponse' error: Migration error
        :param str id: Result identifier
        :param str result_type: Result type
               Expected value is 'ErrorOutput'.
        """
        pulumi.set(__self__, "error", error)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "result_type", 'ErrorOutput')

    @property
    @pulumi.getter
    def error(self) -> 'outputs.ReportableExceptionResponse':
        """
        Migration error
        """
        return pulumi.get(self, "error")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Result identifier
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="resultType")
    def result_type(self) -> str:
        """
        Result type
        Expected value is 'ErrorOutput'.
        """
        return pulumi.get(self, "result_type")


@pulumi.output_type
class MigrateSqlServerSqlMITaskOutputLoginLevelResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endedOn":
            suggest = "ended_on"
        elif key == "exceptionsAndWarnings":
            suggest = "exceptions_and_warnings"
        elif key == "loginName":
            suggest = "login_name"
        elif key == "resultType":
            suggest = "result_type"
        elif key == "startedOn":
            suggest = "started_on"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MigrateSqlServerSqlMITaskOutputLoginLevelResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MigrateSqlServerSqlMITaskOutputLoginLevelResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MigrateSqlServerSqlMITaskOutputLoginLevelResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ended_on: str,
                 exceptions_and_warnings: Sequence['outputs.ReportableExceptionResponse'],
                 id: str,
                 login_name: str,
                 message: str,
                 result_type: str,
                 stage: str,
                 started_on: str,
                 state: str):
        """
        :param str ended_on: Login migration end time
        :param Sequence['ReportableExceptionResponse'] exceptions_and_warnings: Login migration errors and warnings per login
        :param str id: Result identifier
        :param str login_name: Login name.
        :param str message: Login migration progress message
        :param str result_type: Result type
               Expected value is 'LoginLevelOutput'.
        :param str stage: Current stage of login
        :param str started_on: Login migration start time
        :param str state: Current state of login
        """
        pulumi.set(__self__, "ended_on", ended_on)
        pulumi.set(__self__, "exceptions_and_warnings", exceptions_and_warnings)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "login_name", login_name)
        pulumi.set(__self__, "message", message)
        pulumi.set(__self__, "result_type", 'LoginLevelOutput')
        pulumi.set(__self__, "stage", stage)
        pulumi.set(__self__, "started_on", started_on)
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="endedOn")
    def ended_on(self) -> str:
        """
        Login migration end time
        """
        return pulumi.get(self, "ended_on")

    @property
    @pulumi.getter(name="exceptionsAndWarnings")
    def exceptions_and_warnings(self) -> Sequence['outputs.ReportableExceptionResponse']:
        """
        Login migration errors and warnings per login
        """
        return pulumi.get(self, "exceptions_and_warnings")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Result identifier
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="loginName")
    def login_name(self) -> str:
        """
        Login name.
        """
        return pulumi.get(self, "login_name")

    @property
    @pulumi.getter
    def message(self) -> str:
        """
        Login migration progress message
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter(name="resultType")
    def result_type(self) -> str:
        """
        Result type
        Expected value is 'LoginLevelOutput'.
        """
        return pulumi.get(self, "result_type")

    @property
    @pulumi.getter
    def stage(self) -> str:
        """
        Current stage of login
        """
        return pulumi.get(self, "stage")

    @property
    @pulumi.getter(name="startedOn")
    def started_on(self) -> str:
        """
        Login migration start time
        """
        return pulumi.get(self, "started_on")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        Current state of login
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class MigrateSqlServerSqlMITaskOutputMigrationLevelResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "agentJobs":
            suggest = "agent_jobs"
        elif key == "endedOn":
            suggest = "ended_on"
        elif key == "exceptionsAndWarnings":
            suggest = "exceptions_and_warnings"
        elif key == "orphanedUsersInfo":
            suggest = "orphaned_users_info"
        elif key == "resultType":
            suggest = "result_type"
        elif key == "serverRoleResults":
            suggest = "server_role_results"
        elif key == "sourceServerBrandVersion":
            suggest = "source_server_brand_version"
        elif key == "sourceServerVersion":
            suggest = "source_server_version"
        elif key == "startedOn":
            suggest = "started_on"
        elif key == "targetServerBrandVersion":
            suggest = "target_server_brand_version"
        elif key == "targetServerVersion":
            suggest = "target_server_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MigrateSqlServerSqlMITaskOutputMigrationLevelResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MigrateSqlServerSqlMITaskOutputMigrationLevelResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MigrateSqlServerSqlMITaskOutputMigrationLevelResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 agent_jobs: Mapping[str, str],
                 databases: Mapping[str, str],
                 ended_on: str,
                 exceptions_and_warnings: Sequence['outputs.ReportableExceptionResponse'],
                 id: str,
                 logins: Mapping[str, str],
                 message: str,
                 orphaned_users_info: Sequence['outputs.OrphanedUserInfoResponse'],
                 result_type: str,
                 server_role_results: Mapping[str, 'outputs.StartMigrationScenarioServerRoleResultResponse'],
                 source_server_brand_version: str,
                 source_server_version: str,
                 started_on: str,
                 state: str,
                 status: str,
                 target_server_brand_version: str,
                 target_server_version: str):
        """
        :param Mapping[str, str] agent_jobs: Selected agent jobs as a map from name to id
        :param Mapping[str, str] databases: Selected databases as a map from database name to database id
        :param str ended_on: Migration end time
        :param Sequence['ReportableExceptionResponse'] exceptions_and_warnings: Migration exceptions and warnings.
        :param str id: Result identifier
        :param Mapping[str, str] logins: Selected logins as a map from name to id
        :param str message: Migration progress message
        :param Sequence['OrphanedUserInfoResponse'] orphaned_users_info: List of orphaned users.
        :param str result_type: Result type
               Expected value is 'MigrationLevelOutput'.
        :param Mapping[str, 'StartMigrationScenarioServerRoleResultResponse'] server_role_results: Map of server role migration results.
        :param str source_server_brand_version: Source server brand version
        :param str source_server_version: Source server version
        :param str started_on: Migration start time
        :param str state: Current state of migration
        :param str status: Current status of migration
        :param str target_server_brand_version: Target server brand version
        :param str target_server_version: Target server version
        """
        pulumi.set(__self__, "agent_jobs", agent_jobs)
        pulumi.set(__self__, "databases", databases)
        pulumi.set(__self__, "ended_on", ended_on)
        pulumi.set(__self__, "exceptions_and_warnings", exceptions_and_warnings)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "logins", logins)
        pulumi.set(__self__, "message", message)
        pulumi.set(__self__, "orphaned_users_info", orphaned_users_info)
        pulumi.set(__self__, "result_type", 'MigrationLevelOutput')
        pulumi.set(__self__, "server_role_results", server_role_results)
        pulumi.set(__self__, "source_server_brand_version", source_server_brand_version)
        pulumi.set(__self__, "source_server_version", source_server_version)
        pulumi.set(__self__, "started_on", started_on)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "target_server_brand_version", target_server_brand_version)
        pulumi.set(__self__, "target_server_version", target_server_version)

    @property
    @pulumi.getter(name="agentJobs")
    def agent_jobs(self) -> Mapping[str, str]:
        """
        Selected agent jobs as a map from name to id
        """
        return pulumi.get(self, "agent_jobs")

    @property
    @pulumi.getter
    def databases(self) -> Mapping[str, str]:
        """
        Selected databases as a map from database name to database id
        """
        return pulumi.get(self, "databases")

    @property
    @pulumi.getter(name="endedOn")
    def ended_on(self) -> str:
        """
        Migration end time
        """
        return pulumi.get(self, "ended_on")

    @property
    @pulumi.getter(name="exceptionsAndWarnings")
    def exceptions_and_warnings(self) -> Sequence['outputs.ReportableExceptionResponse']:
        """
        Migration exceptions and warnings.
        """
        return pulumi.get(self, "exceptions_and_warnings")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Result identifier
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def logins(self) -> Mapping[str, str]:
        """
        Selected logins as a map from name to id
        """
        return pulumi.get(self, "logins")

    @property
    @pulumi.getter
    def message(self) -> str:
        """
        Migration progress message
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter(name="orphanedUsersInfo")
    def orphaned_users_info(self) -> Sequence['outputs.OrphanedUserInfoResponse']:
        """
        List of orphaned users.
        """
        return pulumi.get(self, "orphaned_users_info")

    @property
    @pulumi.getter(name="resultType")
    def result_type(self) -> str:
        """
        Result type
        Expected value is 'MigrationLevelOutput'.
        """
        return pulumi.get(self, "result_type")

    @property
    @pulumi.getter(name="serverRoleResults")
    def server_role_results(self) -> Mapping[str, 'outputs.StartMigrationScenarioServerRoleResultResponse']:
        """
        Map of server role migration results.
        """
        return pulumi.get(self, "server_role_results")

    @property
    @pulumi.getter(name="sourceServerBrandVersion")
    def source_server_brand_version(self) -> str:
        """
        Source server brand version
        """
        return pulumi.get(self, "source_server_brand_version")

    @property
    @pulumi.getter(name="sourceServerVersion")
    def source_server_version(self) -> str:
        """
        Source server version
        """
        return pulumi.get(self, "source_server_version")

    @property
    @pulumi.getter(name="startedOn")
    def started_on(self) -> str:
        """
        Migration start time
        """
        return pulumi.get(self, "started_on")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        Current state of migration
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Current status of migration
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="targetServerBrandVersion")
    def target_server_brand_version(self) -> str:
        """
        Target server brand version
        """
        return pulumi.get(self, "target_server_brand_version")

    @property
    @pulumi.getter(name="targetServerVersion")
    def target_server_version(self) -> str:
        """
        Target server version
        """
        return pulumi.get(self, "target_server_version")


@pulumi.output_type
class MigrateSqlServerSqlMITaskPropertiesResponse(dict):
    """
    Properties for task that migrates SQL Server databases to Azure SQL Database Managed Instance
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "taskType":
            suggest = "task_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MigrateSqlServerSqlMITaskPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MigrateSqlServerSqlMITaskPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MigrateSqlServerSqlMITaskPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 commands: Sequence[Any],
                 errors: Sequence['outputs.ODataErrorResponse'],
                 output: Sequence[Any],
                 state: str,
                 task_type: str,
                 input: Optional['outputs.MigrateSqlServerSqlMITaskInputResponse'] = None):
        """
        Properties for task that migrates SQL Server databases to Azure SQL Database Managed Instance
        :param Sequence[Union['MigrateMISyncCompleteCommandPropertiesResponse', 'MigrateSyncCompleteCommandPropertiesResponse']] commands: Array of command properties.
        :param Sequence['ODataErrorResponse'] errors: Array of errors. This is ignored if submitted.
        :param Sequence[Union['MigrateSqlServerSqlMITaskOutputAgentJobLevelResponse', 'MigrateSqlServerSqlMITaskOutputDatabaseLevelResponse', 'MigrateSqlServerSqlMITaskOutputErrorResponse', 'MigrateSqlServerSqlMITaskOutputLoginLevelResponse', 'MigrateSqlServerSqlMITaskOutputMigrationLevelResponse']] output: Task output. This is ignored if submitted.
        :param str state: The state of the task. This is ignored if submitted.
        :param str task_type: Task type.
               Expected value is 'Migrate.SqlServer.AzureSqlDbMI'.
        :param 'MigrateSqlServerSqlMITaskInputResponse' input: Task input
        """
        pulumi.set(__self__, "commands", commands)
        pulumi.set(__self__, "errors", errors)
        pulumi.set(__self__, "output", output)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "task_type", 'Migrate.SqlServer.AzureSqlDbMI')
        if input is not None:
            pulumi.set(__self__, "input", input)

    @property
    @pulumi.getter
    def commands(self) -> Sequence[Any]:
        """
        Array of command properties.
        """
        return pulumi.get(self, "commands")

    @property
    @pulumi.getter
    def errors(self) -> Sequence['outputs.ODataErrorResponse']:
        """
        Array of errors. This is ignored if submitted.
        """
        return pulumi.get(self, "errors")

    @property
    @pulumi.getter
    def output(self) -> Sequence[Any]:
        """
        Task output. This is ignored if submitted.
        """
        return pulumi.get(self, "output")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The state of the task. This is ignored if submitted.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="taskType")
    def task_type(self) -> str:
        """
        Task type.
        Expected value is 'Migrate.SqlServer.AzureSqlDbMI'.
        """
        return pulumi.get(self, "task_type")

    @property
    @pulumi.getter
    def input(self) -> Optional['outputs.MigrateSqlServerSqlMITaskInputResponse']:
        """
        Task input
        """
        return pulumi.get(self, "input")


@pulumi.output_type
class MigrateSyncCompleteCommandInputResponse(dict):
    """
    Input for command that completes sync migration for a database.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "databaseName":
            suggest = "database_name"
        elif key == "commitTimeStamp":
            suggest = "commit_time_stamp"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MigrateSyncCompleteCommandInputResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MigrateSyncCompleteCommandInputResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MigrateSyncCompleteCommandInputResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 database_name: str,
                 commit_time_stamp: Optional[str] = None):
        """
        Input for command that completes sync migration for a database.
        :param str database_name: Name of database
        :param str commit_time_stamp: Time stamp to complete
        """
        pulumi.set(__self__, "database_name", database_name)
        if commit_time_stamp is not None:
            pulumi.set(__self__, "commit_time_stamp", commit_time_stamp)

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> str:
        """
        Name of database
        """
        return pulumi.get(self, "database_name")

    @property
    @pulumi.getter(name="commitTimeStamp")
    def commit_time_stamp(self) -> Optional[str]:
        """
        Time stamp to complete
        """
        return pulumi.get(self, "commit_time_stamp")


@pulumi.output_type
class MigrateSyncCompleteCommandOutputResponse(dict):
    """
    Output for command that completes sync migration for a database.
    """
    def __init__(__self__, *,
                 errors: Sequence['outputs.ReportableExceptionResponse'],
                 id: str):
        """
        Output for command that completes sync migration for a database.
        :param Sequence['ReportableExceptionResponse'] errors: List of errors that happened during the command execution
        :param str id: Result identifier
        """
        pulumi.set(__self__, "errors", errors)
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def errors(self) -> Sequence['outputs.ReportableExceptionResponse']:
        """
        List of errors that happened during the command execution
        """
        return pulumi.get(self, "errors")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Result identifier
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class MigrateSyncCompleteCommandPropertiesResponse(dict):
    """
    Properties for the command that completes sync migration for a database.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "commandType":
            suggest = "command_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MigrateSyncCompleteCommandPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MigrateSyncCompleteCommandPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MigrateSyncCompleteCommandPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 command_type: str,
                 errors: Sequence['outputs.ODataErrorResponse'],
                 output: 'outputs.MigrateSyncCompleteCommandOutputResponse',
                 state: str,
                 input: Optional['outputs.MigrateSyncCompleteCommandInputResponse'] = None):
        """
        Properties for the command that completes sync migration for a database.
        :param str command_type: Command type.
               Expected value is 'Migrate.Sync.Complete.Database'.
        :param Sequence['ODataErrorResponse'] errors: Array of errors. This is ignored if submitted.
        :param 'MigrateSyncCompleteCommandOutputResponse' output: Command output. This is ignored if submitted.
        :param str state: The state of the command. This is ignored if submitted.
        :param 'MigrateSyncCompleteCommandInputResponse' input: Command input
        """
        pulumi.set(__self__, "command_type", 'Migrate.Sync.Complete.Database')
        pulumi.set(__self__, "errors", errors)
        pulumi.set(__self__, "output", output)
        pulumi.set(__self__, "state", state)
        if input is not None:
            pulumi.set(__self__, "input", input)

    @property
    @pulumi.getter(name="commandType")
    def command_type(self) -> str:
        """
        Command type.
        Expected value is 'Migrate.Sync.Complete.Database'.
        """
        return pulumi.get(self, "command_type")

    @property
    @pulumi.getter
    def errors(self) -> Sequence['outputs.ODataErrorResponse']:
        """
        Array of errors. This is ignored if submitted.
        """
        return pulumi.get(self, "errors")

    @property
    @pulumi.getter
    def output(self) -> 'outputs.MigrateSyncCompleteCommandOutputResponse':
        """
        Command output. This is ignored if submitted.
        """
        return pulumi.get(self, "output")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The state of the command. This is ignored if submitted.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def input(self) -> Optional['outputs.MigrateSyncCompleteCommandInputResponse']:
        """
        Command input
        """
        return pulumi.get(self, "input")


@pulumi.output_type
class MigrationEligibilityInfoResponse(dict):
    """
    Information about migration eligibility of a server object
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isEligibleForMigration":
            suggest = "is_eligible_for_migration"
        elif key == "validationMessages":
            suggest = "validation_messages"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MigrationEligibilityInfoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MigrationEligibilityInfoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MigrationEligibilityInfoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 is_eligible_for_migration: bool,
                 validation_messages: Sequence[str]):
        """
        Information about migration eligibility of a server object
        :param bool is_eligible_for_migration: Whether object is eligible for migration or not.
        :param Sequence[str] validation_messages: Information about eligibility failure for the server object.
        """
        pulumi.set(__self__, "is_eligible_for_migration", is_eligible_for_migration)
        pulumi.set(__self__, "validation_messages", validation_messages)

    @property
    @pulumi.getter(name="isEligibleForMigration")
    def is_eligible_for_migration(self) -> bool:
        """
        Whether object is eligible for migration or not.
        """
        return pulumi.get(self, "is_eligible_for_migration")

    @property
    @pulumi.getter(name="validationMessages")
    def validation_messages(self) -> Sequence[str]:
        """
        Information about eligibility failure for the server object.
        """
        return pulumi.get(self, "validation_messages")


@pulumi.output_type
class MigrationReportResultResponse(dict):
    """
    Migration validation report result, contains the url for downloading the generated report.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "reportUrl":
            suggest = "report_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MigrationReportResultResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MigrationReportResultResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MigrationReportResultResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: str,
                 report_url: str):
        """
        Migration validation report result, contains the url for downloading the generated report.
        :param str id: Migration validation result identifier
        :param str report_url: The url of the report.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "report_url", report_url)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Migration validation result identifier
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="reportUrl")
    def report_url(self) -> str:
        """
        The url of the report.
        """
        return pulumi.get(self, "report_url")


@pulumi.output_type
class MigrationValidationDatabaseSummaryResultResponse(dict):
    """
    Migration Validation Database level summary result
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endedOn":
            suggest = "ended_on"
        elif key == "migrationId":
            suggest = "migration_id"
        elif key == "sourceDatabaseName":
            suggest = "source_database_name"
        elif key == "startedOn":
            suggest = "started_on"
        elif key == "targetDatabaseName":
            suggest = "target_database_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MigrationValidationDatabaseSummaryResultResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MigrationValidationDatabaseSummaryResultResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MigrationValidationDatabaseSummaryResultResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ended_on: str,
                 id: str,
                 migration_id: str,
                 source_database_name: str,
                 started_on: str,
                 status: str,
                 target_database_name: str):
        """
        Migration Validation Database level summary result
        :param str ended_on: Validation end time
        :param str id: Result identifier
        :param str migration_id: Migration Identifier
        :param str source_database_name: Name of the source database
        :param str started_on: Validation start time
        :param str status: Current status of validation at the database level
        :param str target_database_name: Name of the target database
        """
        pulumi.set(__self__, "ended_on", ended_on)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "migration_id", migration_id)
        pulumi.set(__self__, "source_database_name", source_database_name)
        pulumi.set(__self__, "started_on", started_on)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "target_database_name", target_database_name)

    @property
    @pulumi.getter(name="endedOn")
    def ended_on(self) -> str:
        """
        Validation end time
        """
        return pulumi.get(self, "ended_on")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Result identifier
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="migrationId")
    def migration_id(self) -> str:
        """
        Migration Identifier
        """
        return pulumi.get(self, "migration_id")

    @property
    @pulumi.getter(name="sourceDatabaseName")
    def source_database_name(self) -> str:
        """
        Name of the source database
        """
        return pulumi.get(self, "source_database_name")

    @property
    @pulumi.getter(name="startedOn")
    def started_on(self) -> str:
        """
        Validation start time
        """
        return pulumi.get(self, "started_on")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Current status of validation at the database level
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="targetDatabaseName")
    def target_database_name(self) -> str:
        """
        Name of the target database
        """
        return pulumi.get(self, "target_database_name")


@pulumi.output_type
class MigrationValidationOptionsResponse(dict):
    """
    Types of validations to run after the migration
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "enableDataIntegrityValidation":
            suggest = "enable_data_integrity_validation"
        elif key == "enableQueryAnalysisValidation":
            suggest = "enable_query_analysis_validation"
        elif key == "enableSchemaValidation":
            suggest = "enable_schema_validation"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MigrationValidationOptionsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MigrationValidationOptionsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MigrationValidationOptionsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enable_data_integrity_validation: Optional[bool] = None,
                 enable_query_analysis_validation: Optional[bool] = None,
                 enable_schema_validation: Optional[bool] = None):
        """
        Types of validations to run after the migration
        :param bool enable_data_integrity_validation: Allows to perform a checksum based data integrity validation between source and target for the selected database / tables .
        :param bool enable_query_analysis_validation: Allows to perform a quick and intelligent query analysis by retrieving queries from the source database and executes them in the target. The result will have execution statistics for executions in source and target databases for the extracted queries.
        :param bool enable_schema_validation: Allows to compare the schema information between source and target.
        """
        if enable_data_integrity_validation is not None:
            pulumi.set(__self__, "enable_data_integrity_validation", enable_data_integrity_validation)
        if enable_query_analysis_validation is not None:
            pulumi.set(__self__, "enable_query_analysis_validation", enable_query_analysis_validation)
        if enable_schema_validation is not None:
            pulumi.set(__self__, "enable_schema_validation", enable_schema_validation)

    @property
    @pulumi.getter(name="enableDataIntegrityValidation")
    def enable_data_integrity_validation(self) -> Optional[bool]:
        """
        Allows to perform a checksum based data integrity validation between source and target for the selected database / tables .
        """
        return pulumi.get(self, "enable_data_integrity_validation")

    @property
    @pulumi.getter(name="enableQueryAnalysisValidation")
    def enable_query_analysis_validation(self) -> Optional[bool]:
        """
        Allows to perform a quick and intelligent query analysis by retrieving queries from the source database and executes them in the target. The result will have execution statistics for executions in source and target databases for the extracted queries.
        """
        return pulumi.get(self, "enable_query_analysis_validation")

    @property
    @pulumi.getter(name="enableSchemaValidation")
    def enable_schema_validation(self) -> Optional[bool]:
        """
        Allows to compare the schema information between source and target.
        """
        return pulumi.get(self, "enable_schema_validation")


@pulumi.output_type
class MySqlConnectionInfoResponse(dict):
    """
    Information for connecting to MySQL server
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "serverName":
            suggest = "server_name"
        elif key == "userName":
            suggest = "user_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MySqlConnectionInfoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MySqlConnectionInfoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MySqlConnectionInfoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 port: int,
                 server_name: str,
                 type: str,
                 password: Optional[str] = None,
                 user_name: Optional[str] = None):
        """
        Information for connecting to MySQL server
        :param int port: Port for Server
        :param str server_name: Name of the server
        :param str type: Type of connection info
               Expected value is 'MySqlConnectionInfo'.
        :param str password: Password credential.
        :param str user_name: User name
        """
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "server_name", server_name)
        pulumi.set(__self__, "type", 'MySqlConnectionInfo')
        if password is not None:
            pulumi.set(__self__, "password", password)
        if user_name is not None:
            pulumi.set(__self__, "user_name", user_name)

    @property
    @pulumi.getter
    def port(self) -> int:
        """
        Port for Server
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="serverName")
    def server_name(self) -> str:
        """
        Name of the server
        """
        return pulumi.get(self, "server_name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of connection info
        Expected value is 'MySqlConnectionInfo'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def password(self) -> Optional[str]:
        """
        Password credential.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> Optional[str]:
        """
        User name
        """
        return pulumi.get(self, "user_name")


@pulumi.output_type
class NodeMonitoringDataResponse(dict):
    def __init__(__self__, *,
                 additional_properties: Mapping[str, Any],
                 available_memory_in_mb: int,
                 concurrent_jobs_limit: int,
                 concurrent_jobs_running: int,
                 cpu_utilization: int,
                 max_concurrent_jobs: int,
                 node_name: str,
                 received_bytes: float,
                 sent_bytes: float):
        """
        :param Mapping[str, Any] additional_properties:  Unmatched properties from the message are deserialized in this collection.
        :param int available_memory_in_mb: Available memory (MB) on the integration runtime node.
        :param int concurrent_jobs_limit: Maximum concurrent jobs on the integration runtime node.
        :param int concurrent_jobs_running: The number of jobs currently running on the integration runtime node.
        :param int cpu_utilization: CPU percentage on the integration runtime node.
        :param int max_concurrent_jobs: The maximum concurrent jobs in this integration runtime.
        :param str node_name: Name of the integration runtime node.
        :param float received_bytes: Received bytes on the integration runtime node.
        :param float sent_bytes: Sent bytes on the integration runtime node.
        """
        pulumi.set(__self__, "additional_properties", additional_properties)
        pulumi.set(__self__, "available_memory_in_mb", available_memory_in_mb)
        pulumi.set(__self__, "concurrent_jobs_limit", concurrent_jobs_limit)
        pulumi.set(__self__, "concurrent_jobs_running", concurrent_jobs_running)
        pulumi.set(__self__, "cpu_utilization", cpu_utilization)
        pulumi.set(__self__, "max_concurrent_jobs", max_concurrent_jobs)
        pulumi.set(__self__, "node_name", node_name)
        pulumi.set(__self__, "received_bytes", received_bytes)
        pulumi.set(__self__, "sent_bytes", sent_bytes)

    @property
    @pulumi.getter(name="additionalProperties")
    def additional_properties(self) -> Mapping[str, Any]:
        """
         Unmatched properties from the message are deserialized in this collection.
        """
        return pulumi.get(self, "additional_properties")

    @property
    @pulumi.getter(name="availableMemoryInMB")
    def available_memory_in_mb(self) -> int:
        """
        Available memory (MB) on the integration runtime node.
        """
        return pulumi.get(self, "available_memory_in_mb")

    @property
    @pulumi.getter(name="concurrentJobsLimit")
    def concurrent_jobs_limit(self) -> int:
        """
        Maximum concurrent jobs on the integration runtime node.
        """
        return pulumi.get(self, "concurrent_jobs_limit")

    @property
    @pulumi.getter(name="concurrentJobsRunning")
    def concurrent_jobs_running(self) -> int:
        """
        The number of jobs currently running on the integration runtime node.
        """
        return pulumi.get(self, "concurrent_jobs_running")

    @property
    @pulumi.getter(name="cpuUtilization")
    def cpu_utilization(self) -> int:
        """
        CPU percentage on the integration runtime node.
        """
        return pulumi.get(self, "cpu_utilization")

    @property
    @pulumi.getter(name="maxConcurrentJobs")
    def max_concurrent_jobs(self) -> int:
        """
        The maximum concurrent jobs in this integration runtime.
        """
        return pulumi.get(self, "max_concurrent_jobs")

    @property
    @pulumi.getter(name="nodeName")
    def node_name(self) -> str:
        """
        Name of the integration runtime node.
        """
        return pulumi.get(self, "node_name")

    @property
    @pulumi.getter(name="receivedBytes")
    def received_bytes(self) -> float:
        """
        Received bytes on the integration runtime node.
        """
        return pulumi.get(self, "received_bytes")

    @property
    @pulumi.getter(name="sentBytes")
    def sent_bytes(self) -> float:
        """
        Sent bytes on the integration runtime node.
        """
        return pulumi.get(self, "sent_bytes")


@pulumi.output_type
class ODataErrorResponse(dict):
    """
    Error information in OData format.
    """
    def __init__(__self__, *,
                 code: str,
                 details: Sequence['outputs.ODataErrorResponse'],
                 message: str):
        """
        Error information in OData format.
        :param str code: The machine-readable description of the error, such as 'InvalidRequest' or 'InternalServerError'
        :param Sequence['ODataErrorResponse'] details: Inner errors that caused this error
        :param str message: The human-readable description of the error
        """
        pulumi.set(__self__, "code", code)
        pulumi.set(__self__, "details", details)
        pulumi.set(__self__, "message", message)

    @property
    @pulumi.getter
    def code(self) -> str:
        """
        The machine-readable description of the error, such as 'InvalidRequest' or 'InternalServerError'
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter
    def details(self) -> Sequence['outputs.ODataErrorResponse']:
        """
        Inner errors that caused this error
        """
        return pulumi.get(self, "details")

    @property
    @pulumi.getter
    def message(self) -> str:
        """
        The human-readable description of the error
        """
        return pulumi.get(self, "message")


@pulumi.output_type
class OrphanedUserInfoResponse(dict):
    """
    Information of orphaned users on the SQL server database.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "databaseName":
            suggest = "database_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OrphanedUserInfoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OrphanedUserInfoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OrphanedUserInfoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 database_name: Optional[str] = None,
                 name: Optional[str] = None):
        """
        Information of orphaned users on the SQL server database.
        :param str database_name: Parent database of the user
        :param str name: Name of the orphaned user
        """
        if database_name is not None:
            pulumi.set(__self__, "database_name", database_name)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> Optional[str]:
        """
        Parent database of the user
        """
        return pulumi.get(self, "database_name")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the orphaned user
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class PostgreSqlConnectionInfoResponse(dict):
    """
    Information for connecting to PostgreSQL server
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "serverName":
            suggest = "server_name"
        elif key == "databaseName":
            suggest = "database_name"
        elif key == "userName":
            suggest = "user_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PostgreSqlConnectionInfoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PostgreSqlConnectionInfoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PostgreSqlConnectionInfoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 port: int,
                 server_name: str,
                 type: str,
                 database_name: Optional[str] = None,
                 password: Optional[str] = None,
                 user_name: Optional[str] = None):
        """
        Information for connecting to PostgreSQL server
        :param int port: Port for Server
        :param str server_name: Name of the server
        :param str type: Type of connection info
               Expected value is 'PostgreSqlConnectionInfo'.
        :param str database_name: Name of the database
        :param str password: Password credential.
        :param str user_name: User name
        """
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "server_name", server_name)
        pulumi.set(__self__, "type", 'PostgreSqlConnectionInfo')
        if database_name is not None:
            pulumi.set(__self__, "database_name", database_name)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if user_name is not None:
            pulumi.set(__self__, "user_name", user_name)

    @property
    @pulumi.getter
    def port(self) -> int:
        """
        Port for Server
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="serverName")
    def server_name(self) -> str:
        """
        Name of the server
        """
        return pulumi.get(self, "server_name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of connection info
        Expected value is 'PostgreSqlConnectionInfo'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> Optional[str]:
        """
        Name of the database
        """
        return pulumi.get(self, "database_name")

    @property
    @pulumi.getter
    def password(self) -> Optional[str]:
        """
        Password credential.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> Optional[str]:
        """
        User name
        """
        return pulumi.get(self, "user_name")


@pulumi.output_type
class ProjectFilePropertiesResponse(dict):
    """
    Base class for file properties.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lastModified":
            suggest = "last_modified"
        elif key == "filePath":
            suggest = "file_path"
        elif key == "mediaType":
            suggest = "media_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProjectFilePropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProjectFilePropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProjectFilePropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 last_modified: str,
                 size: float,
                 extension: Optional[str] = None,
                 file_path: Optional[str] = None,
                 media_type: Optional[str] = None):
        """
        Base class for file properties.
        :param str last_modified: Modification DateTime.
        :param float size: File size.
        :param str extension: Optional File extension. If submitted it should not have a leading period and must match the extension from filePath.
        :param str file_path: Relative path of this file resource. This property can be set when creating or updating the file resource.
        :param str media_type: File content type. This property can be modified to reflect the file content type.
        """
        pulumi.set(__self__, "last_modified", last_modified)
        pulumi.set(__self__, "size", size)
        if extension is not None:
            pulumi.set(__self__, "extension", extension)
        if file_path is not None:
            pulumi.set(__self__, "file_path", file_path)
        if media_type is not None:
            pulumi.set(__self__, "media_type", media_type)

    @property
    @pulumi.getter(name="lastModified")
    def last_modified(self) -> str:
        """
        Modification DateTime.
        """
        return pulumi.get(self, "last_modified")

    @property
    @pulumi.getter
    def size(self) -> float:
        """
        File size.
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter
    def extension(self) -> Optional[str]:
        """
        Optional File extension. If submitted it should not have a leading period and must match the extension from filePath.
        """
        return pulumi.get(self, "extension")

    @property
    @pulumi.getter(name="filePath")
    def file_path(self) -> Optional[str]:
        """
        Relative path of this file resource. This property can be set when creating or updating the file resource.
        """
        return pulumi.get(self, "file_path")

    @property
    @pulumi.getter(name="mediaType")
    def media_type(self) -> Optional[str]:
        """
        File content type. This property can be modified to reflect the file content type.
        """
        return pulumi.get(self, "media_type")


@pulumi.output_type
class QueryAnalysisValidationResultResponse(dict):
    """
    Results for query analysis comparison between the source and target
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "queryResults":
            suggest = "query_results"
        elif key == "validationErrors":
            suggest = "validation_errors"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in QueryAnalysisValidationResultResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        QueryAnalysisValidationResultResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        QueryAnalysisValidationResultResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 query_results: 'outputs.QueryExecutionResultResponse',
                 validation_errors: 'outputs.ValidationErrorResponse'):
        """
        Results for query analysis comparison between the source and target
        :param 'QueryExecutionResultResponse' query_results: List of queries executed and it's execution results in source and target
        :param 'ValidationErrorResponse' validation_errors: Errors that are part of the execution
        """
        pulumi.set(__self__, "query_results", query_results)
        pulumi.set(__self__, "validation_errors", validation_errors)

    @property
    @pulumi.getter(name="queryResults")
    def query_results(self) -> 'outputs.QueryExecutionResultResponse':
        """
        List of queries executed and it's execution results in source and target
        """
        return pulumi.get(self, "query_results")

    @property
    @pulumi.getter(name="validationErrors")
    def validation_errors(self) -> 'outputs.ValidationErrorResponse':
        """
        Errors that are part of the execution
        """
        return pulumi.get(self, "validation_errors")


@pulumi.output_type
class QueryExecutionResultResponse(dict):
    """
    Describes query analysis results for execution in source and target
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "queryText":
            suggest = "query_text"
        elif key == "sourceResult":
            suggest = "source_result"
        elif key == "statementsInBatch":
            suggest = "statements_in_batch"
        elif key == "targetResult":
            suggest = "target_result"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in QueryExecutionResultResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        QueryExecutionResultResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        QueryExecutionResultResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 query_text: str,
                 source_result: 'outputs.ExecutionStatisticsResponse',
                 statements_in_batch: float,
                 target_result: 'outputs.ExecutionStatisticsResponse'):
        """
        Describes query analysis results for execution in source and target
        :param str query_text: Query text retrieved from the source server
        :param 'ExecutionStatisticsResponse' source_result: Query analysis result from the source
        :param float statements_in_batch: Total no. of statements in the batch
        :param 'ExecutionStatisticsResponse' target_result: Query analysis result from the target
        """
        pulumi.set(__self__, "query_text", query_text)
        pulumi.set(__self__, "source_result", source_result)
        pulumi.set(__self__, "statements_in_batch", statements_in_batch)
        pulumi.set(__self__, "target_result", target_result)

    @property
    @pulumi.getter(name="queryText")
    def query_text(self) -> str:
        """
        Query text retrieved from the source server
        """
        return pulumi.get(self, "query_text")

    @property
    @pulumi.getter(name="sourceResult")
    def source_result(self) -> 'outputs.ExecutionStatisticsResponse':
        """
        Query analysis result from the source
        """
        return pulumi.get(self, "source_result")

    @property
    @pulumi.getter(name="statementsInBatch")
    def statements_in_batch(self) -> float:
        """
        Total no. of statements in the batch
        """
        return pulumi.get(self, "statements_in_batch")

    @property
    @pulumi.getter(name="targetResult")
    def target_result(self) -> 'outputs.ExecutionStatisticsResponse':
        """
        Query analysis result from the target
        """
        return pulumi.get(self, "target_result")


@pulumi.output_type
class ReportableExceptionResponse(dict):
    """
    Exception object for all custom exceptions
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "filePath":
            suggest = "file_path"
        elif key == "hResult":
            suggest = "h_result"
        elif key == "lineNumber":
            suggest = "line_number"
        elif key == "stackTrace":
            suggest = "stack_trace"
        elif key == "actionableMessage":
            suggest = "actionable_message"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ReportableExceptionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ReportableExceptionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ReportableExceptionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 file_path: str,
                 h_result: int,
                 line_number: str,
                 message: str,
                 stack_trace: str,
                 actionable_message: Optional[str] = None):
        """
        Exception object for all custom exceptions
        :param str file_path: The path to the file where exception occurred
        :param int h_result: Coded numerical value that is assigned to a specific exception
        :param str line_number: The line number where exception occurred
        :param str message: Error message
        :param str stack_trace: Stack trace
        :param str actionable_message: Actionable steps for this exception
        """
        pulumi.set(__self__, "file_path", file_path)
        pulumi.set(__self__, "h_result", h_result)
        pulumi.set(__self__, "line_number", line_number)
        pulumi.set(__self__, "message", message)
        pulumi.set(__self__, "stack_trace", stack_trace)
        if actionable_message is not None:
            pulumi.set(__self__, "actionable_message", actionable_message)

    @property
    @pulumi.getter(name="filePath")
    def file_path(self) -> str:
        """
        The path to the file where exception occurred
        """
        return pulumi.get(self, "file_path")

    @property
    @pulumi.getter(name="hResult")
    def h_result(self) -> int:
        """
        Coded numerical value that is assigned to a specific exception
        """
        return pulumi.get(self, "h_result")

    @property
    @pulumi.getter(name="lineNumber")
    def line_number(self) -> str:
        """
        The line number where exception occurred
        """
        return pulumi.get(self, "line_number")

    @property
    @pulumi.getter
    def message(self) -> str:
        """
        Error message
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter(name="stackTrace")
    def stack_trace(self) -> str:
        """
        Stack trace
        """
        return pulumi.get(self, "stack_trace")

    @property
    @pulumi.getter(name="actionableMessage")
    def actionable_message(self) -> Optional[str]:
        """
        Actionable steps for this exception
        """
        return pulumi.get(self, "actionable_message")


@pulumi.output_type
class SchemaComparisonValidationResultResponse(dict):
    """
    Results for schema comparison between the source and target
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "schemaDifferences":
            suggest = "schema_differences"
        elif key == "validationErrors":
            suggest = "validation_errors"
        elif key == "sourceDatabaseObjectCount":
            suggest = "source_database_object_count"
        elif key == "targetDatabaseObjectCount":
            suggest = "target_database_object_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SchemaComparisonValidationResultResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SchemaComparisonValidationResultResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SchemaComparisonValidationResultResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 schema_differences: 'outputs.SchemaComparisonValidationResultTypeResponse',
                 validation_errors: 'outputs.ValidationErrorResponse',
                 source_database_object_count: Optional[Mapping[str, float]] = None,
                 target_database_object_count: Optional[Mapping[str, float]] = None):
        """
        Results for schema comparison between the source and target
        :param 'SchemaComparisonValidationResultTypeResponse' schema_differences: List of schema differences between the source and target databases
        :param 'ValidationErrorResponse' validation_errors: List of errors that happened while performing schema compare validation
        :param Mapping[str, float] source_database_object_count: Count of source database objects
        :param Mapping[str, float] target_database_object_count: Count of target database objects
        """
        pulumi.set(__self__, "schema_differences", schema_differences)
        pulumi.set(__self__, "validation_errors", validation_errors)
        if source_database_object_count is not None:
            pulumi.set(__self__, "source_database_object_count", source_database_object_count)
        if target_database_object_count is not None:
            pulumi.set(__self__, "target_database_object_count", target_database_object_count)

    @property
    @pulumi.getter(name="schemaDifferences")
    def schema_differences(self) -> 'outputs.SchemaComparisonValidationResultTypeResponse':
        """
        List of schema differences between the source and target databases
        """
        return pulumi.get(self, "schema_differences")

    @property
    @pulumi.getter(name="validationErrors")
    def validation_errors(self) -> 'outputs.ValidationErrorResponse':
        """
        List of errors that happened while performing schema compare validation
        """
        return pulumi.get(self, "validation_errors")

    @property
    @pulumi.getter(name="sourceDatabaseObjectCount")
    def source_database_object_count(self) -> Optional[Mapping[str, float]]:
        """
        Count of source database objects
        """
        return pulumi.get(self, "source_database_object_count")

    @property
    @pulumi.getter(name="targetDatabaseObjectCount")
    def target_database_object_count(self) -> Optional[Mapping[str, float]]:
        """
        Count of target database objects
        """
        return pulumi.get(self, "target_database_object_count")


@pulumi.output_type
class SchemaComparisonValidationResultTypeResponse(dict):
    """
    Description about the errors happen while performing migration validation
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "objectName":
            suggest = "object_name"
        elif key == "objectType":
            suggest = "object_type"
        elif key == "updateAction":
            suggest = "update_action"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SchemaComparisonValidationResultTypeResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SchemaComparisonValidationResultTypeResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SchemaComparisonValidationResultTypeResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 object_name: str,
                 object_type: str,
                 update_action: str):
        """
        Description about the errors happen while performing migration validation
        :param str object_name: Name of the object that has the difference
        :param str object_type: Type of the object that has the difference. e.g (Table/View/StoredProcedure)
        :param str update_action: Update action type with respect to target
        """
        pulumi.set(__self__, "object_name", object_name)
        pulumi.set(__self__, "object_type", object_type)
        pulumi.set(__self__, "update_action", update_action)

    @property
    @pulumi.getter(name="objectName")
    def object_name(self) -> str:
        """
        Name of the object that has the difference
        """
        return pulumi.get(self, "object_name")

    @property
    @pulumi.getter(name="objectType")
    def object_type(self) -> str:
        """
        Type of the object that has the difference. e.g (Table/View/StoredProcedure)
        """
        return pulumi.get(self, "object_type")

    @property
    @pulumi.getter(name="updateAction")
    def update_action(self) -> str:
        """
        Update action type with respect to target
        """
        return pulumi.get(self, "update_action")


@pulumi.output_type
class SelectedCertificateInputResponse(dict):
    """
    Info for certificate to be exported for TDE enabled databases.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "certificateName":
            suggest = "certificate_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SelectedCertificateInputResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SelectedCertificateInputResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SelectedCertificateInputResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 certificate_name: str,
                 password: str):
        """
        Info for certificate to be exported for TDE enabled databases.
        :param str certificate_name: Name of certificate to be exported.
        :param str password: Password to use for encrypting the exported certificate.
        """
        pulumi.set(__self__, "certificate_name", certificate_name)
        pulumi.set(__self__, "password", password)

    @property
    @pulumi.getter(name="certificateName")
    def certificate_name(self) -> str:
        """
        Name of certificate to be exported.
        """
        return pulumi.get(self, "certificate_name")

    @property
    @pulumi.getter
    def password(self) -> str:
        """
        Password to use for encrypting the exported certificate.
        """
        return pulumi.get(self, "password")


@pulumi.output_type
class ServiceSkuResponse(dict):
    """
    An Azure SKU instance
    """
    def __init__(__self__, *,
                 capacity: Optional[int] = None,
                 family: Optional[str] = None,
                 name: Optional[str] = None,
                 size: Optional[str] = None,
                 tier: Optional[str] = None):
        """
        An Azure SKU instance
        :param int capacity: The capacity of the SKU, if it supports scaling
        :param str family: The SKU family, used when the service has multiple performance classes within a tier, such as 'A', 'D', etc. for virtual machines
        :param str name: The unique name of the SKU, such as 'P3'
        :param str size: The size of the SKU, used when the name alone does not denote a service size or when a SKU has multiple performance classes within a family, e.g. 'A1' for virtual machines
        :param str tier: The tier of the SKU, such as 'Free', 'Basic', 'Standard', or 'Premium'
        """
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)
        if family is not None:
            pulumi.set(__self__, "family", family)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if tier is not None:
            pulumi.set(__self__, "tier", tier)

    @property
    @pulumi.getter
    def capacity(self) -> Optional[int]:
        """
        The capacity of the SKU, if it supports scaling
        """
        return pulumi.get(self, "capacity")

    @property
    @pulumi.getter
    def family(self) -> Optional[str]:
        """
        The SKU family, used when the service has multiple performance classes within a tier, such as 'A', 'D', etc. for virtual machines
        """
        return pulumi.get(self, "family")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The unique name of the SKU, such as 'P3'
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def size(self) -> Optional[str]:
        """
        The size of the SKU, used when the name alone does not denote a service size or when a SKU has multiple performance classes within a family, e.g. 'A1' for virtual machines
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter
    def tier(self) -> Optional[str]:
        """
        The tier of the SKU, such as 'Free', 'Basic', 'Standard', or 'Premium'
        """
        return pulumi.get(self, "tier")


@pulumi.output_type
class SqlConnectionInfoResponse(dict):
    """
    Information for connecting to SQL database server
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataSource":
            suggest = "data_source"
        elif key == "additionalSettings":
            suggest = "additional_settings"
        elif key == "encryptConnection":
            suggest = "encrypt_connection"
        elif key == "trustServerCertificate":
            suggest = "trust_server_certificate"
        elif key == "userName":
            suggest = "user_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SqlConnectionInfoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SqlConnectionInfoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SqlConnectionInfoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data_source: str,
                 type: str,
                 additional_settings: Optional[str] = None,
                 authentication: Optional[str] = None,
                 encrypt_connection: Optional[bool] = None,
                 password: Optional[str] = None,
                 platform: Optional[str] = None,
                 trust_server_certificate: Optional[bool] = None,
                 user_name: Optional[str] = None):
        """
        Information for connecting to SQL database server
        :param str data_source: Data source in the format Protocol:MachineName\SQLServerInstanceName,PortNumber
        :param str type: Type of connection info
               Expected value is 'SqlConnectionInfo'.
        :param str additional_settings: Additional connection settings
        :param str authentication: Authentication type to use for connection
        :param bool encrypt_connection: Whether to encrypt the connection
        :param str password: Password credential.
        :param str platform: Server platform type for connection
        :param bool trust_server_certificate: Whether to trust the server certificate
        :param str user_name: User name
        """
        pulumi.set(__self__, "data_source", data_source)
        pulumi.set(__self__, "type", 'SqlConnectionInfo')
        if additional_settings is not None:
            pulumi.set(__self__, "additional_settings", additional_settings)
        if authentication is not None:
            pulumi.set(__self__, "authentication", authentication)
        if encrypt_connection is None:
            encrypt_connection = True
        if encrypt_connection is not None:
            pulumi.set(__self__, "encrypt_connection", encrypt_connection)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if platform is not None:
            pulumi.set(__self__, "platform", platform)
        if trust_server_certificate is None:
            trust_server_certificate = False
        if trust_server_certificate is not None:
            pulumi.set(__self__, "trust_server_certificate", trust_server_certificate)
        if user_name is not None:
            pulumi.set(__self__, "user_name", user_name)

    @property
    @pulumi.getter(name="dataSource")
    def data_source(self) -> str:
        """
        Data source in the format Protocol:MachineName\SQLServerInstanceName,PortNumber
        """
        return pulumi.get(self, "data_source")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of connection info
        Expected value is 'SqlConnectionInfo'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="additionalSettings")
    def additional_settings(self) -> Optional[str]:
        """
        Additional connection settings
        """
        return pulumi.get(self, "additional_settings")

    @property
    @pulumi.getter
    def authentication(self) -> Optional[str]:
        """
        Authentication type to use for connection
        """
        return pulumi.get(self, "authentication")

    @property
    @pulumi.getter(name="encryptConnection")
    def encrypt_connection(self) -> Optional[bool]:
        """
        Whether to encrypt the connection
        """
        return pulumi.get(self, "encrypt_connection")

    @property
    @pulumi.getter
    def password(self) -> Optional[str]:
        """
        Password credential.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def platform(self) -> Optional[str]:
        """
        Server platform type for connection
        """
        return pulumi.get(self, "platform")

    @property
    @pulumi.getter(name="trustServerCertificate")
    def trust_server_certificate(self) -> Optional[bool]:
        """
        Whether to trust the server certificate
        """
        return pulumi.get(self, "trust_server_certificate")

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> Optional[str]:
        """
        User name
        """
        return pulumi.get(self, "user_name")


@pulumi.output_type
class SqlConnectionInformationResponse(dict):
    """
    Source SQL Connection
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataSource":
            suggest = "data_source"
        elif key == "encryptConnection":
            suggest = "encrypt_connection"
        elif key == "trustServerCertificate":
            suggest = "trust_server_certificate"
        elif key == "userName":
            suggest = "user_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SqlConnectionInformationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SqlConnectionInformationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SqlConnectionInformationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 authentication: Optional[str] = None,
                 data_source: Optional[str] = None,
                 encrypt_connection: Optional[bool] = None,
                 password: Optional[str] = None,
                 trust_server_certificate: Optional[bool] = None,
                 user_name: Optional[str] = None):
        """
        Source SQL Connection
        :param str authentication: Authentication type.
        :param str data_source: Data source.
        :param bool encrypt_connection: Whether to encrypt connection or not.
        :param str password: Password to connect to source SQL.
        :param bool trust_server_certificate: Whether to trust server certificate or not.
        :param str user_name: User name to connect to source SQL.
        """
        if authentication is not None:
            pulumi.set(__self__, "authentication", authentication)
        if data_source is not None:
            pulumi.set(__self__, "data_source", data_source)
        if encrypt_connection is not None:
            pulumi.set(__self__, "encrypt_connection", encrypt_connection)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if trust_server_certificate is not None:
            pulumi.set(__self__, "trust_server_certificate", trust_server_certificate)
        if user_name is not None:
            pulumi.set(__self__, "user_name", user_name)

    @property
    @pulumi.getter
    def authentication(self) -> Optional[str]:
        """
        Authentication type.
        """
        return pulumi.get(self, "authentication")

    @property
    @pulumi.getter(name="dataSource")
    def data_source(self) -> Optional[str]:
        """
        Data source.
        """
        return pulumi.get(self, "data_source")

    @property
    @pulumi.getter(name="encryptConnection")
    def encrypt_connection(self) -> Optional[bool]:
        """
        Whether to encrypt connection or not.
        """
        return pulumi.get(self, "encrypt_connection")

    @property
    @pulumi.getter
    def password(self) -> Optional[str]:
        """
        Password to connect to source SQL.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="trustServerCertificate")
    def trust_server_certificate(self) -> Optional[bool]:
        """
        Whether to trust server certificate or not.
        """
        return pulumi.get(self, "trust_server_certificate")

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> Optional[str]:
        """
        User name to connect to source SQL.
        """
        return pulumi.get(self, "user_name")


@pulumi.output_type
class SqlDbMigrationStatusDetailsResponse(dict):
    """
    Detailed status of current Sql Db migration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "listOfCopyProgressDetails":
            suggest = "list_of_copy_progress_details"
        elif key == "migrationState":
            suggest = "migration_state"
        elif key == "sqlDataCopyErrors":
            suggest = "sql_data_copy_errors"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SqlDbMigrationStatusDetailsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SqlDbMigrationStatusDetailsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SqlDbMigrationStatusDetailsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 list_of_copy_progress_details: Sequence['outputs.CopyProgressDetailsResponse'],
                 migration_state: str,
                 sql_data_copy_errors: Sequence[str]):
        """
        Detailed status of current Sql Db migration.
        :param Sequence['CopyProgressDetailsResponse'] list_of_copy_progress_details: Details on progress of ADF copy activities.
        :param str migration_state: Current State of Migration.
        :param Sequence[str] sql_data_copy_errors: Sql Data Copy errors, if any.
        """
        pulumi.set(__self__, "list_of_copy_progress_details", list_of_copy_progress_details)
        pulumi.set(__self__, "migration_state", migration_state)
        pulumi.set(__self__, "sql_data_copy_errors", sql_data_copy_errors)

    @property
    @pulumi.getter(name="listOfCopyProgressDetails")
    def list_of_copy_progress_details(self) -> Sequence['outputs.CopyProgressDetailsResponse']:
        """
        Details on progress of ADF copy activities.
        """
        return pulumi.get(self, "list_of_copy_progress_details")

    @property
    @pulumi.getter(name="migrationState")
    def migration_state(self) -> str:
        """
        Current State of Migration.
        """
        return pulumi.get(self, "migration_state")

    @property
    @pulumi.getter(name="sqlDataCopyErrors")
    def sql_data_copy_errors(self) -> Sequence[str]:
        """
        Sql Data Copy errors, if any.
        """
        return pulumi.get(self, "sql_data_copy_errors")


@pulumi.output_type
class SqlDbOfflineConfigurationResponse(dict):
    """
    Offline configuration
    """
    def __init__(__self__, *,
                 offline: bool):
        """
        Offline configuration
        :param bool offline: Offline migration
        """
        pulumi.set(__self__, "offline", offline)

    @property
    @pulumi.getter
    def offline(self) -> bool:
        """
        Offline migration
        """
        return pulumi.get(self, "offline")


@pulumi.output_type
class StartMigrationScenarioServerRoleResultResponse(dict):
    """
    Server role migration result
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "exceptionsAndWarnings":
            suggest = "exceptions_and_warnings"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StartMigrationScenarioServerRoleResultResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StartMigrationScenarioServerRoleResultResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StartMigrationScenarioServerRoleResultResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 exceptions_and_warnings: Sequence['outputs.ReportableExceptionResponse'],
                 name: str,
                 state: str):
        """
        Server role migration result
        :param Sequence['ReportableExceptionResponse'] exceptions_and_warnings: Migration exceptions and warnings.
        :param str name: Name of server role.
        :param str state: Current state of migration
        """
        pulumi.set(__self__, "exceptions_and_warnings", exceptions_and_warnings)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="exceptionsAndWarnings")
    def exceptions_and_warnings(self) -> Sequence['outputs.ReportableExceptionResponse']:
        """
        Migration exceptions and warnings.
        """
        return pulumi.get(self, "exceptions_and_warnings")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of server role.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        Current state of migration
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class SyncMigrationDatabaseErrorEventResponse(dict):
    """
    Database migration errors for online migration
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "eventText":
            suggest = "event_text"
        elif key == "eventTypeString":
            suggest = "event_type_string"
        elif key == "timestampString":
            suggest = "timestamp_string"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SyncMigrationDatabaseErrorEventResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SyncMigrationDatabaseErrorEventResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SyncMigrationDatabaseErrorEventResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 event_text: str,
                 event_type_string: str,
                 timestamp_string: str):
        """
        Database migration errors for online migration
        :param str event_text: Event text.
        :param str event_type_string: Event type.
        :param str timestamp_string: String value of timestamp.
        """
        pulumi.set(__self__, "event_text", event_text)
        pulumi.set(__self__, "event_type_string", event_type_string)
        pulumi.set(__self__, "timestamp_string", timestamp_string)

    @property
    @pulumi.getter(name="eventText")
    def event_text(self) -> str:
        """
        Event text.
        """
        return pulumi.get(self, "event_text")

    @property
    @pulumi.getter(name="eventTypeString")
    def event_type_string(self) -> str:
        """
        Event type.
        """
        return pulumi.get(self, "event_type_string")

    @property
    @pulumi.getter(name="timestampString")
    def timestamp_string(self) -> str:
        """
        String value of timestamp.
        """
        return pulumi.get(self, "timestamp_string")


@pulumi.output_type
class SystemDataResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createdAt":
            suggest = "created_at"
        elif key == "createdBy":
            suggest = "created_by"
        elif key == "createdByType":
            suggest = "created_by_type"
        elif key == "lastModifiedAt":
            suggest = "last_modified_at"
        elif key == "lastModifiedBy":
            suggest = "last_modified_by"
        elif key == "lastModifiedByType":
            suggest = "last_modified_by_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SystemDataResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SystemDataResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SystemDataResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 created_at: Optional[str] = None,
                 created_by: Optional[str] = None,
                 created_by_type: Optional[str] = None,
                 last_modified_at: Optional[str] = None,
                 last_modified_by: Optional[str] = None,
                 last_modified_by_type: Optional[str] = None):
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if created_by_type is not None:
            pulumi.set(__self__, "created_by_type", created_by_type)
        if last_modified_at is not None:
            pulumi.set(__self__, "last_modified_at", last_modified_at)
        if last_modified_by is not None:
            pulumi.set(__self__, "last_modified_by", last_modified_by)
        if last_modified_by_type is not None:
            pulumi.set(__self__, "last_modified_by_type", last_modified_by_type)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[str]:
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[str]:
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter(name="createdByType")
    def created_by_type(self) -> Optional[str]:
        return pulumi.get(self, "created_by_type")

    @property
    @pulumi.getter(name="lastModifiedAt")
    def last_modified_at(self) -> Optional[str]:
        return pulumi.get(self, "last_modified_at")

    @property
    @pulumi.getter(name="lastModifiedBy")
    def last_modified_by(self) -> Optional[str]:
        return pulumi.get(self, "last_modified_by")

    @property
    @pulumi.getter(name="lastModifiedByType")
    def last_modified_by_type(self) -> Optional[str]:
        return pulumi.get(self, "last_modified_by_type")


@pulumi.output_type
class ValidateMigrationInputSqlServerSqlDbSyncTaskPropertiesResponse(dict):
    """
    Properties for task that validates migration input for SQL to Azure SQL DB sync migrations
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "taskType":
            suggest = "task_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ValidateMigrationInputSqlServerSqlDbSyncTaskPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ValidateMigrationInputSqlServerSqlDbSyncTaskPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ValidateMigrationInputSqlServerSqlDbSyncTaskPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 commands: Sequence[Any],
                 errors: Sequence['outputs.ODataErrorResponse'],
                 output: Sequence['outputs.ValidateSyncMigrationInputSqlServerTaskOutputResponse'],
                 state: str,
                 task_type: str,
                 input: Optional['outputs.ValidateSyncMigrationInputSqlServerTaskInputResponse'] = None):
        """
        Properties for task that validates migration input for SQL to Azure SQL DB sync migrations
        :param Sequence[Union['MigrateMISyncCompleteCommandPropertiesResponse', 'MigrateSyncCompleteCommandPropertiesResponse']] commands: Array of command properties.
        :param Sequence['ODataErrorResponse'] errors: Array of errors. This is ignored if submitted.
        :param Sequence['ValidateSyncMigrationInputSqlServerTaskOutputResponse'] output: Task output. This is ignored if submitted.
        :param str state: The state of the task. This is ignored if submitted.
        :param str task_type: Task type.
               Expected value is 'ValidateMigrationInput.SqlServer.SqlDb.Sync'.
        :param 'ValidateSyncMigrationInputSqlServerTaskInputResponse' input: Task input
        """
        pulumi.set(__self__, "commands", commands)
        pulumi.set(__self__, "errors", errors)
        pulumi.set(__self__, "output", output)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "task_type", 'ValidateMigrationInput.SqlServer.SqlDb.Sync')
        if input is not None:
            pulumi.set(__self__, "input", input)

    @property
    @pulumi.getter
    def commands(self) -> Sequence[Any]:
        """
        Array of command properties.
        """
        return pulumi.get(self, "commands")

    @property
    @pulumi.getter
    def errors(self) -> Sequence['outputs.ODataErrorResponse']:
        """
        Array of errors. This is ignored if submitted.
        """
        return pulumi.get(self, "errors")

    @property
    @pulumi.getter
    def output(self) -> Sequence['outputs.ValidateSyncMigrationInputSqlServerTaskOutputResponse']:
        """
        Task output. This is ignored if submitted.
        """
        return pulumi.get(self, "output")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The state of the task. This is ignored if submitted.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="taskType")
    def task_type(self) -> str:
        """
        Task type.
        Expected value is 'ValidateMigrationInput.SqlServer.SqlDb.Sync'.
        """
        return pulumi.get(self, "task_type")

    @property
    @pulumi.getter
    def input(self) -> Optional['outputs.ValidateSyncMigrationInputSqlServerTaskInputResponse']:
        """
        Task input
        """
        return pulumi.get(self, "input")


@pulumi.output_type
class ValidateMigrationInputSqlServerSqlMISyncTaskInputResponse(dict):
    """
    Input for task that migrates SQL Server databases to Azure SQL Database Managed Instance online scenario.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "azureApp":
            suggest = "azure_app"
        elif key == "selectedDatabases":
            suggest = "selected_databases"
        elif key == "sourceConnectionInfo":
            suggest = "source_connection_info"
        elif key == "storageResourceId":
            suggest = "storage_resource_id"
        elif key == "targetConnectionInfo":
            suggest = "target_connection_info"
        elif key == "backupFileShare":
            suggest = "backup_file_share"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ValidateMigrationInputSqlServerSqlMISyncTaskInputResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ValidateMigrationInputSqlServerSqlMISyncTaskInputResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ValidateMigrationInputSqlServerSqlMISyncTaskInputResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 azure_app: 'outputs.AzureActiveDirectoryAppResponse',
                 selected_databases: Sequence['outputs.MigrateSqlServerSqlMIDatabaseInputResponse'],
                 source_connection_info: 'outputs.SqlConnectionInfoResponse',
                 storage_resource_id: str,
                 target_connection_info: 'outputs.MiSqlConnectionInfoResponse',
                 backup_file_share: Optional['outputs.FileShareResponse'] = None):
        """
        Input for task that migrates SQL Server databases to Azure SQL Database Managed Instance online scenario.
        :param 'AzureActiveDirectoryAppResponse' azure_app: Azure Active Directory Application the DMS instance will use to connect to the target instance of Azure SQL Database Managed Instance and the Azure Storage Account
        :param Sequence['MigrateSqlServerSqlMIDatabaseInputResponse'] selected_databases: Databases to migrate
        :param 'SqlConnectionInfoResponse' source_connection_info: Connection information for source SQL Server
        :param str storage_resource_id: Fully qualified resourceId of storage
        :param 'MiSqlConnectionInfoResponse' target_connection_info: Connection information for Azure SQL Database Managed Instance
        :param 'FileShareResponse' backup_file_share: Backup file share information for all selected databases.
        """
        pulumi.set(__self__, "azure_app", azure_app)
        pulumi.set(__self__, "selected_databases", selected_databases)
        pulumi.set(__self__, "source_connection_info", source_connection_info)
        pulumi.set(__self__, "storage_resource_id", storage_resource_id)
        pulumi.set(__self__, "target_connection_info", target_connection_info)
        if backup_file_share is not None:
            pulumi.set(__self__, "backup_file_share", backup_file_share)

    @property
    @pulumi.getter(name="azureApp")
    def azure_app(self) -> 'outputs.AzureActiveDirectoryAppResponse':
        """
        Azure Active Directory Application the DMS instance will use to connect to the target instance of Azure SQL Database Managed Instance and the Azure Storage Account
        """
        return pulumi.get(self, "azure_app")

    @property
    @pulumi.getter(name="selectedDatabases")
    def selected_databases(self) -> Sequence['outputs.MigrateSqlServerSqlMIDatabaseInputResponse']:
        """
        Databases to migrate
        """
        return pulumi.get(self, "selected_databases")

    @property
    @pulumi.getter(name="sourceConnectionInfo")
    def source_connection_info(self) -> 'outputs.SqlConnectionInfoResponse':
        """
        Connection information for source SQL Server
        """
        return pulumi.get(self, "source_connection_info")

    @property
    @pulumi.getter(name="storageResourceId")
    def storage_resource_id(self) -> str:
        """
        Fully qualified resourceId of storage
        """
        return pulumi.get(self, "storage_resource_id")

    @property
    @pulumi.getter(name="targetConnectionInfo")
    def target_connection_info(self) -> 'outputs.MiSqlConnectionInfoResponse':
        """
        Connection information for Azure SQL Database Managed Instance
        """
        return pulumi.get(self, "target_connection_info")

    @property
    @pulumi.getter(name="backupFileShare")
    def backup_file_share(self) -> Optional['outputs.FileShareResponse']:
        """
        Backup file share information for all selected databases.
        """
        return pulumi.get(self, "backup_file_share")


@pulumi.output_type
class ValidateMigrationInputSqlServerSqlMISyncTaskOutputResponse(dict):
    """
    Output for task that validates migration input for Azure SQL Database Managed Instance online migration
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "validationErrors":
            suggest = "validation_errors"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ValidateMigrationInputSqlServerSqlMISyncTaskOutputResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ValidateMigrationInputSqlServerSqlMISyncTaskOutputResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ValidateMigrationInputSqlServerSqlMISyncTaskOutputResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: str,
                 name: str,
                 validation_errors: Sequence['outputs.ReportableExceptionResponse']):
        """
        Output for task that validates migration input for Azure SQL Database Managed Instance online migration
        :param str id: Database identifier
        :param str name: Name of database
        :param Sequence['ReportableExceptionResponse'] validation_errors: Errors associated with a selected database object
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "validation_errors", validation_errors)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Database identifier
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of database
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="validationErrors")
    def validation_errors(self) -> Sequence['outputs.ReportableExceptionResponse']:
        """
        Errors associated with a selected database object
        """
        return pulumi.get(self, "validation_errors")


@pulumi.output_type
class ValidateMigrationInputSqlServerSqlMISyncTaskPropertiesResponse(dict):
    """
    Properties for task that validates migration input for SQL to Azure SQL Database Managed Instance sync scenario
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "taskType":
            suggest = "task_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ValidateMigrationInputSqlServerSqlMISyncTaskPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ValidateMigrationInputSqlServerSqlMISyncTaskPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ValidateMigrationInputSqlServerSqlMISyncTaskPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 commands: Sequence[Any],
                 errors: Sequence['outputs.ODataErrorResponse'],
                 output: Sequence['outputs.ValidateMigrationInputSqlServerSqlMISyncTaskOutputResponse'],
                 state: str,
                 task_type: str,
                 input: Optional['outputs.ValidateMigrationInputSqlServerSqlMISyncTaskInputResponse'] = None):
        """
        Properties for task that validates migration input for SQL to Azure SQL Database Managed Instance sync scenario
        :param Sequence[Union['MigrateMISyncCompleteCommandPropertiesResponse', 'MigrateSyncCompleteCommandPropertiesResponse']] commands: Array of command properties.
        :param Sequence['ODataErrorResponse'] errors: Array of errors. This is ignored if submitted.
        :param Sequence['ValidateMigrationInputSqlServerSqlMISyncTaskOutputResponse'] output: Task output. This is ignored if submitted.
        :param str state: The state of the task. This is ignored if submitted.
        :param str task_type: Task type.
               Expected value is 'ValidateMigrationInput.SqlServer.AzureSqlDbMI.Sync.LRS'.
        :param 'ValidateMigrationInputSqlServerSqlMISyncTaskInputResponse' input: Task input
        """
        pulumi.set(__self__, "commands", commands)
        pulumi.set(__self__, "errors", errors)
        pulumi.set(__self__, "output", output)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "task_type", 'ValidateMigrationInput.SqlServer.AzureSqlDbMI.Sync.LRS')
        if input is not None:
            pulumi.set(__self__, "input", input)

    @property
    @pulumi.getter
    def commands(self) -> Sequence[Any]:
        """
        Array of command properties.
        """
        return pulumi.get(self, "commands")

    @property
    @pulumi.getter
    def errors(self) -> Sequence['outputs.ODataErrorResponse']:
        """
        Array of errors. This is ignored if submitted.
        """
        return pulumi.get(self, "errors")

    @property
    @pulumi.getter
    def output(self) -> Sequence['outputs.ValidateMigrationInputSqlServerSqlMISyncTaskOutputResponse']:
        """
        Task output. This is ignored if submitted.
        """
        return pulumi.get(self, "output")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The state of the task. This is ignored if submitted.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="taskType")
    def task_type(self) -> str:
        """
        Task type.
        Expected value is 'ValidateMigrationInput.SqlServer.AzureSqlDbMI.Sync.LRS'.
        """
        return pulumi.get(self, "task_type")

    @property
    @pulumi.getter
    def input(self) -> Optional['outputs.ValidateMigrationInputSqlServerSqlMISyncTaskInputResponse']:
        """
        Task input
        """
        return pulumi.get(self, "input")


@pulumi.output_type
class ValidateMigrationInputSqlServerSqlMITaskInputResponse(dict):
    """
    Input for task that validates migration input for SQL to Azure SQL Managed Instance
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backupBlobShare":
            suggest = "backup_blob_share"
        elif key == "selectedDatabases":
            suggest = "selected_databases"
        elif key == "sourceConnectionInfo":
            suggest = "source_connection_info"
        elif key == "targetConnectionInfo":
            suggest = "target_connection_info"
        elif key == "backupFileShare":
            suggest = "backup_file_share"
        elif key == "backupMode":
            suggest = "backup_mode"
        elif key == "selectedLogins":
            suggest = "selected_logins"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ValidateMigrationInputSqlServerSqlMITaskInputResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ValidateMigrationInputSqlServerSqlMITaskInputResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ValidateMigrationInputSqlServerSqlMITaskInputResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backup_blob_share: 'outputs.BlobShareResponse',
                 selected_databases: Sequence['outputs.MigrateSqlServerSqlMIDatabaseInputResponse'],
                 source_connection_info: 'outputs.SqlConnectionInfoResponse',
                 target_connection_info: 'outputs.SqlConnectionInfoResponse',
                 backup_file_share: Optional['outputs.FileShareResponse'] = None,
                 backup_mode: Optional[str] = None,
                 selected_logins: Optional[Sequence[str]] = None):
        """
        Input for task that validates migration input for SQL to Azure SQL Managed Instance
        :param 'BlobShareResponse' backup_blob_share: SAS URI of Azure Storage Account Container to be used for storing backup files.
        :param Sequence['MigrateSqlServerSqlMIDatabaseInputResponse'] selected_databases: Databases to migrate
        :param 'SqlConnectionInfoResponse' source_connection_info: Information for connecting to source
        :param 'SqlConnectionInfoResponse' target_connection_info: Information for connecting to target
        :param 'FileShareResponse' backup_file_share: Backup file share information for all selected databases.
        :param str backup_mode: Backup Mode to specify whether to use existing backup or create new backup.
        :param Sequence[str] selected_logins: Logins to migrate
        """
        pulumi.set(__self__, "backup_blob_share", backup_blob_share)
        pulumi.set(__self__, "selected_databases", selected_databases)
        pulumi.set(__self__, "source_connection_info", source_connection_info)
        pulumi.set(__self__, "target_connection_info", target_connection_info)
        if backup_file_share is not None:
            pulumi.set(__self__, "backup_file_share", backup_file_share)
        if backup_mode is not None:
            pulumi.set(__self__, "backup_mode", backup_mode)
        if selected_logins is not None:
            pulumi.set(__self__, "selected_logins", selected_logins)

    @property
    @pulumi.getter(name="backupBlobShare")
    def backup_blob_share(self) -> 'outputs.BlobShareResponse':
        """
        SAS URI of Azure Storage Account Container to be used for storing backup files.
        """
        return pulumi.get(self, "backup_blob_share")

    @property
    @pulumi.getter(name="selectedDatabases")
    def selected_databases(self) -> Sequence['outputs.MigrateSqlServerSqlMIDatabaseInputResponse']:
        """
        Databases to migrate
        """
        return pulumi.get(self, "selected_databases")

    @property
    @pulumi.getter(name="sourceConnectionInfo")
    def source_connection_info(self) -> 'outputs.SqlConnectionInfoResponse':
        """
        Information for connecting to source
        """
        return pulumi.get(self, "source_connection_info")

    @property
    @pulumi.getter(name="targetConnectionInfo")
    def target_connection_info(self) -> 'outputs.SqlConnectionInfoResponse':
        """
        Information for connecting to target
        """
        return pulumi.get(self, "target_connection_info")

    @property
    @pulumi.getter(name="backupFileShare")
    def backup_file_share(self) -> Optional['outputs.FileShareResponse']:
        """
        Backup file share information for all selected databases.
        """
        return pulumi.get(self, "backup_file_share")

    @property
    @pulumi.getter(name="backupMode")
    def backup_mode(self) -> Optional[str]:
        """
        Backup Mode to specify whether to use existing backup or create new backup.
        """
        return pulumi.get(self, "backup_mode")

    @property
    @pulumi.getter(name="selectedLogins")
    def selected_logins(self) -> Optional[Sequence[str]]:
        """
        Logins to migrate
        """
        return pulumi.get(self, "selected_logins")


@pulumi.output_type
class ValidateMigrationInputSqlServerSqlMITaskOutputResponse(dict):
    """
    Output for task that validates migration input for SQL to Azure SQL Managed Instance migrations
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backupFolderErrors":
            suggest = "backup_folder_errors"
        elif key == "backupShareCredentialsErrors":
            suggest = "backup_share_credentials_errors"
        elif key == "backupStorageAccountErrors":
            suggest = "backup_storage_account_errors"
        elif key == "existingBackupErrors":
            suggest = "existing_backup_errors"
        elif key == "restoreDatabaseNameErrors":
            suggest = "restore_database_name_errors"
        elif key == "databaseBackupInfo":
            suggest = "database_backup_info"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ValidateMigrationInputSqlServerSqlMITaskOutputResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ValidateMigrationInputSqlServerSqlMITaskOutputResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ValidateMigrationInputSqlServerSqlMITaskOutputResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backup_folder_errors: Sequence['outputs.ReportableExceptionResponse'],
                 backup_share_credentials_errors: Sequence['outputs.ReportableExceptionResponse'],
                 backup_storage_account_errors: Sequence['outputs.ReportableExceptionResponse'],
                 existing_backup_errors: Sequence['outputs.ReportableExceptionResponse'],
                 id: str,
                 name: str,
                 restore_database_name_errors: Sequence['outputs.ReportableExceptionResponse'],
                 database_backup_info: Optional['outputs.DatabaseBackupInfoResponse'] = None):
        """
        Output for task that validates migration input for SQL to Azure SQL Managed Instance migrations
        :param Sequence['ReportableExceptionResponse'] backup_folder_errors: Errors associated with the BackupFolder path
        :param Sequence['ReportableExceptionResponse'] backup_share_credentials_errors: Errors associated with backup share user name and password credentials
        :param Sequence['ReportableExceptionResponse'] backup_storage_account_errors: Errors associated with the storage account provided.
        :param Sequence['ReportableExceptionResponse'] existing_backup_errors: Errors associated with existing backup files.
        :param str id: Result identifier
        :param str name: Name of database
        :param Sequence['ReportableExceptionResponse'] restore_database_name_errors: Errors associated with the RestoreDatabaseName
        :param 'DatabaseBackupInfoResponse' database_backup_info: Information about backup files when existing backup mode is used.
        """
        pulumi.set(__self__, "backup_folder_errors", backup_folder_errors)
        pulumi.set(__self__, "backup_share_credentials_errors", backup_share_credentials_errors)
        pulumi.set(__self__, "backup_storage_account_errors", backup_storage_account_errors)
        pulumi.set(__self__, "existing_backup_errors", existing_backup_errors)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "restore_database_name_errors", restore_database_name_errors)
        if database_backup_info is not None:
            pulumi.set(__self__, "database_backup_info", database_backup_info)

    @property
    @pulumi.getter(name="backupFolderErrors")
    def backup_folder_errors(self) -> Sequence['outputs.ReportableExceptionResponse']:
        """
        Errors associated with the BackupFolder path
        """
        return pulumi.get(self, "backup_folder_errors")

    @property
    @pulumi.getter(name="backupShareCredentialsErrors")
    def backup_share_credentials_errors(self) -> Sequence['outputs.ReportableExceptionResponse']:
        """
        Errors associated with backup share user name and password credentials
        """
        return pulumi.get(self, "backup_share_credentials_errors")

    @property
    @pulumi.getter(name="backupStorageAccountErrors")
    def backup_storage_account_errors(self) -> Sequence['outputs.ReportableExceptionResponse']:
        """
        Errors associated with the storage account provided.
        """
        return pulumi.get(self, "backup_storage_account_errors")

    @property
    @pulumi.getter(name="existingBackupErrors")
    def existing_backup_errors(self) -> Sequence['outputs.ReportableExceptionResponse']:
        """
        Errors associated with existing backup files.
        """
        return pulumi.get(self, "existing_backup_errors")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Result identifier
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of database
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="restoreDatabaseNameErrors")
    def restore_database_name_errors(self) -> Sequence['outputs.ReportableExceptionResponse']:
        """
        Errors associated with the RestoreDatabaseName
        """
        return pulumi.get(self, "restore_database_name_errors")

    @property
    @pulumi.getter(name="databaseBackupInfo")
    def database_backup_info(self) -> Optional['outputs.DatabaseBackupInfoResponse']:
        """
        Information about backup files when existing backup mode is used.
        """
        return pulumi.get(self, "database_backup_info")


@pulumi.output_type
class ValidateMigrationInputSqlServerSqlMITaskPropertiesResponse(dict):
    """
    Properties for task that validates migration input for SQL to Azure SQL Database Managed Instance
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "taskType":
            suggest = "task_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ValidateMigrationInputSqlServerSqlMITaskPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ValidateMigrationInputSqlServerSqlMITaskPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ValidateMigrationInputSqlServerSqlMITaskPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 commands: Sequence[Any],
                 errors: Sequence['outputs.ODataErrorResponse'],
                 output: Sequence['outputs.ValidateMigrationInputSqlServerSqlMITaskOutputResponse'],
                 state: str,
                 task_type: str,
                 input: Optional['outputs.ValidateMigrationInputSqlServerSqlMITaskInputResponse'] = None):
        """
        Properties for task that validates migration input for SQL to Azure SQL Database Managed Instance
        :param Sequence[Union['MigrateMISyncCompleteCommandPropertiesResponse', 'MigrateSyncCompleteCommandPropertiesResponse']] commands: Array of command properties.
        :param Sequence['ODataErrorResponse'] errors: Array of errors. This is ignored if submitted.
        :param Sequence['ValidateMigrationInputSqlServerSqlMITaskOutputResponse'] output: Task output. This is ignored if submitted.
        :param str state: The state of the task. This is ignored if submitted.
        :param str task_type: Task type.
               Expected value is 'ValidateMigrationInput.SqlServer.AzureSqlDbMI'.
        :param 'ValidateMigrationInputSqlServerSqlMITaskInputResponse' input: Task input
        """
        pulumi.set(__self__, "commands", commands)
        pulumi.set(__self__, "errors", errors)
        pulumi.set(__self__, "output", output)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "task_type", 'ValidateMigrationInput.SqlServer.AzureSqlDbMI')
        if input is not None:
            pulumi.set(__self__, "input", input)

    @property
    @pulumi.getter
    def commands(self) -> Sequence[Any]:
        """
        Array of command properties.
        """
        return pulumi.get(self, "commands")

    @property
    @pulumi.getter
    def errors(self) -> Sequence['outputs.ODataErrorResponse']:
        """
        Array of errors. This is ignored if submitted.
        """
        return pulumi.get(self, "errors")

    @property
    @pulumi.getter
    def output(self) -> Sequence['outputs.ValidateMigrationInputSqlServerSqlMITaskOutputResponse']:
        """
        Task output. This is ignored if submitted.
        """
        return pulumi.get(self, "output")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The state of the task. This is ignored if submitted.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="taskType")
    def task_type(self) -> str:
        """
        Task type.
        Expected value is 'ValidateMigrationInput.SqlServer.AzureSqlDbMI'.
        """
        return pulumi.get(self, "task_type")

    @property
    @pulumi.getter
    def input(self) -> Optional['outputs.ValidateMigrationInputSqlServerSqlMITaskInputResponse']:
        """
        Task input
        """
        return pulumi.get(self, "input")


@pulumi.output_type
class ValidateSyncMigrationInputSqlServerTaskInputResponse(dict):
    """
    Input for task that validates migration input for SQL sync migrations
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "selectedDatabases":
            suggest = "selected_databases"
        elif key == "sourceConnectionInfo":
            suggest = "source_connection_info"
        elif key == "targetConnectionInfo":
            suggest = "target_connection_info"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ValidateSyncMigrationInputSqlServerTaskInputResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ValidateSyncMigrationInputSqlServerTaskInputResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ValidateSyncMigrationInputSqlServerTaskInputResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 selected_databases: Sequence['outputs.MigrateSqlServerSqlDbSyncDatabaseInputResponse'],
                 source_connection_info: 'outputs.SqlConnectionInfoResponse',
                 target_connection_info: 'outputs.SqlConnectionInfoResponse'):
        """
        Input for task that validates migration input for SQL sync migrations
        :param Sequence['MigrateSqlServerSqlDbSyncDatabaseInputResponse'] selected_databases: Databases to migrate
        :param 'SqlConnectionInfoResponse' source_connection_info: Information for connecting to source SQL server
        :param 'SqlConnectionInfoResponse' target_connection_info: Information for connecting to target
        """
        pulumi.set(__self__, "selected_databases", selected_databases)
        pulumi.set(__self__, "source_connection_info", source_connection_info)
        pulumi.set(__self__, "target_connection_info", target_connection_info)

    @property
    @pulumi.getter(name="selectedDatabases")
    def selected_databases(self) -> Sequence['outputs.MigrateSqlServerSqlDbSyncDatabaseInputResponse']:
        """
        Databases to migrate
        """
        return pulumi.get(self, "selected_databases")

    @property
    @pulumi.getter(name="sourceConnectionInfo")
    def source_connection_info(self) -> 'outputs.SqlConnectionInfoResponse':
        """
        Information for connecting to source SQL server
        """
        return pulumi.get(self, "source_connection_info")

    @property
    @pulumi.getter(name="targetConnectionInfo")
    def target_connection_info(self) -> 'outputs.SqlConnectionInfoResponse':
        """
        Information for connecting to target
        """
        return pulumi.get(self, "target_connection_info")


@pulumi.output_type
class ValidateSyncMigrationInputSqlServerTaskOutputResponse(dict):
    """
    Output for task that validates migration input for SQL sync migrations
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "validationErrors":
            suggest = "validation_errors"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ValidateSyncMigrationInputSqlServerTaskOutputResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ValidateSyncMigrationInputSqlServerTaskOutputResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ValidateSyncMigrationInputSqlServerTaskOutputResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: str,
                 name: str,
                 validation_errors: Sequence['outputs.ReportableExceptionResponse']):
        """
        Output for task that validates migration input for SQL sync migrations
        :param str id: Database identifier
        :param str name: Name of database
        :param Sequence['ReportableExceptionResponse'] validation_errors: Errors associated with a selected database object
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "validation_errors", validation_errors)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Database identifier
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of database
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="validationErrors")
    def validation_errors(self) -> Sequence['outputs.ReportableExceptionResponse']:
        """
        Errors associated with a selected database object
        """
        return pulumi.get(self, "validation_errors")


@pulumi.output_type
class ValidationErrorResponse(dict):
    """
    Description about the errors happen while performing migration validation
    """
    def __init__(__self__, *,
                 severity: str,
                 text: str):
        """
        Description about the errors happen while performing migration validation
        :param str severity: Severity of the error
        :param str text: Error Text
        """
        pulumi.set(__self__, "severity", severity)
        pulumi.set(__self__, "text", text)

    @property
    @pulumi.getter
    def severity(self) -> str:
        """
        Severity of the error
        """
        return pulumi.get(self, "severity")

    @property
    @pulumi.getter
    def text(self) -> str:
        """
        Error Text
        """
        return pulumi.get(self, "text")


@pulumi.output_type
class WaitStatisticsResponse(dict):
    """
    Wait statistics gathered during query batch execution
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "waitCount":
            suggest = "wait_count"
        elif key == "waitTimeMs":
            suggest = "wait_time_ms"
        elif key == "waitType":
            suggest = "wait_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WaitStatisticsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WaitStatisticsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WaitStatisticsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 wait_count: float,
                 wait_time_ms: float,
                 wait_type: str):
        """
        Wait statistics gathered during query batch execution
        :param float wait_count: Total no. of waits
        :param float wait_time_ms: Total wait time in millisecond(s)
        :param str wait_type: Type of the Wait
        """
        pulumi.set(__self__, "wait_count", wait_count)
        if wait_time_ms is None:
            wait_time_ms = 0
        pulumi.set(__self__, "wait_time_ms", wait_time_ms)
        pulumi.set(__self__, "wait_type", wait_type)

    @property
    @pulumi.getter(name="waitCount")
    def wait_count(self) -> float:
        """
        Total no. of waits
        """
        return pulumi.get(self, "wait_count")

    @property
    @pulumi.getter(name="waitTimeMs")
    def wait_time_ms(self) -> float:
        """
        Total wait time in millisecond(s)
        """
        return pulumi.get(self, "wait_time_ms")

    @property
    @pulumi.getter(name="waitType")
    def wait_type(self) -> str:
        """
        Type of the Wait
        """
        return pulumi.get(self, "wait_type")


