# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'AvailableContactsResponse',
    'ContactProfileLinkChannelResponse',
    'ContactProfileLinkResponse',
    'EndPointResponse',
    'ResourceReferenceResponse',
    'SpacecraftLinkResponse',
    'SystemDataResponse',
]

@pulumi.output_type
class AvailableContactsResponse(dict):
    """
    Customer retrieves list of Available Contacts for a spacecraft resource. Later, one of the available contact can be selected to create a contact.
    """
    def __init__(__self__, *,
                 end_azimuth_degrees: float,
                 end_elevation_degrees: float,
                 ground_station_name: str,
                 maximum_elevation_degrees: float,
                 rx_end_time: str,
                 rx_start_time: str,
                 start_azimuth_degrees: float,
                 start_elevation_degrees: float,
                 tx_end_time: str,
                 tx_start_time: str,
                 spacecraft: Optional['outputs.ResourceReferenceResponse'] = None):
        """
        Customer retrieves list of Available Contacts for a spacecraft resource. Later, one of the available contact can be selected to create a contact.
        :param float end_azimuth_degrees: Azimuth of the antenna at the end of the contact in decimal degrees.
        :param float end_elevation_degrees: Spacecraft elevation above the horizon at contact end.
        :param str ground_station_name: Name of Azure Ground Station.
        :param float maximum_elevation_degrees: Maximum elevation of the antenna during the contact in decimal degrees.
        :param str rx_end_time: Time to lost receiving a signal.
        :param str rx_start_time: Earliest time to receive a signal.
        :param float start_azimuth_degrees: Azimuth of the antenna at the start of the contact in decimal degrees.
        :param float start_elevation_degrees: Spacecraft elevation above the horizon at contact start.
        :param str tx_end_time: Time at which antenna transmit will be disabled.
        :param str tx_start_time: Time at which antenna transmit will be enabled.
        :param 'ResourceReferenceResponse' spacecraft: The reference to the spacecraft resource.
        """
        pulumi.set(__self__, "end_azimuth_degrees", end_azimuth_degrees)
        pulumi.set(__self__, "end_elevation_degrees", end_elevation_degrees)
        pulumi.set(__self__, "ground_station_name", ground_station_name)
        pulumi.set(__self__, "maximum_elevation_degrees", maximum_elevation_degrees)
        pulumi.set(__self__, "rx_end_time", rx_end_time)
        pulumi.set(__self__, "rx_start_time", rx_start_time)
        pulumi.set(__self__, "start_azimuth_degrees", start_azimuth_degrees)
        pulumi.set(__self__, "start_elevation_degrees", start_elevation_degrees)
        pulumi.set(__self__, "tx_end_time", tx_end_time)
        pulumi.set(__self__, "tx_start_time", tx_start_time)
        if spacecraft is not None:
            pulumi.set(__self__, "spacecraft", spacecraft)

    @property
    @pulumi.getter(name="endAzimuthDegrees")
    def end_azimuth_degrees(self) -> float:
        """
        Azimuth of the antenna at the end of the contact in decimal degrees.
        """
        return pulumi.get(self, "end_azimuth_degrees")

    @property
    @pulumi.getter(name="endElevationDegrees")
    def end_elevation_degrees(self) -> float:
        """
        Spacecraft elevation above the horizon at contact end.
        """
        return pulumi.get(self, "end_elevation_degrees")

    @property
    @pulumi.getter(name="groundStationName")
    def ground_station_name(self) -> str:
        """
        Name of Azure Ground Station.
        """
        return pulumi.get(self, "ground_station_name")

    @property
    @pulumi.getter(name="maximumElevationDegrees")
    def maximum_elevation_degrees(self) -> float:
        """
        Maximum elevation of the antenna during the contact in decimal degrees.
        """
        return pulumi.get(self, "maximum_elevation_degrees")

    @property
    @pulumi.getter(name="rxEndTime")
    def rx_end_time(self) -> str:
        """
        Time to lost receiving a signal.
        """
        return pulumi.get(self, "rx_end_time")

    @property
    @pulumi.getter(name="rxStartTime")
    def rx_start_time(self) -> str:
        """
        Earliest time to receive a signal.
        """
        return pulumi.get(self, "rx_start_time")

    @property
    @pulumi.getter(name="startAzimuthDegrees")
    def start_azimuth_degrees(self) -> float:
        """
        Azimuth of the antenna at the start of the contact in decimal degrees.
        """
        return pulumi.get(self, "start_azimuth_degrees")

    @property
    @pulumi.getter(name="startElevationDegrees")
    def start_elevation_degrees(self) -> float:
        """
        Spacecraft elevation above the horizon at contact start.
        """
        return pulumi.get(self, "start_elevation_degrees")

    @property
    @pulumi.getter(name="txEndTime")
    def tx_end_time(self) -> str:
        """
        Time at which antenna transmit will be disabled.
        """
        return pulumi.get(self, "tx_end_time")

    @property
    @pulumi.getter(name="txStartTime")
    def tx_start_time(self) -> str:
        """
        Time at which antenna transmit will be enabled.
        """
        return pulumi.get(self, "tx_start_time")

    @property
    @pulumi.getter
    def spacecraft(self) -> Optional['outputs.ResourceReferenceResponse']:
        """
        The reference to the spacecraft resource.
        """
        return pulumi.get(self, "spacecraft")


@pulumi.output_type
class ContactProfileLinkChannelResponse(dict):
    """
    Contact Profile Link Channel
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bandwidthMHz":
            suggest = "bandwidth_m_hz"
        elif key == "centerFrequencyMHz":
            suggest = "center_frequency_m_hz"
        elif key == "endPoint":
            suggest = "end_point"
        elif key == "decodingConfiguration":
            suggest = "decoding_configuration"
        elif key == "demodulationConfiguration":
            suggest = "demodulation_configuration"
        elif key == "encodingConfiguration":
            suggest = "encoding_configuration"
        elif key == "modulationConfiguration":
            suggest = "modulation_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContactProfileLinkChannelResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContactProfileLinkChannelResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContactProfileLinkChannelResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bandwidth_m_hz: float,
                 center_frequency_m_hz: float,
                 end_point: 'outputs.EndPointResponse',
                 decoding_configuration: Optional[str] = None,
                 demodulation_configuration: Optional[str] = None,
                 encoding_configuration: Optional[str] = None,
                 modulation_configuration: Optional[str] = None):
        """
        Contact Profile Link Channel
        :param float bandwidth_m_hz: Bandwidth in MHz
        :param float center_frequency_m_hz: Center Frequency in MHz
        :param 'EndPointResponse' end_point: Customer End point to store/retrieve data during a contact.
        :param str decoding_configuration: Configuration for decoding
        :param str demodulation_configuration: Configuration for demodulation
        :param str encoding_configuration: Configuration for encoding
        :param str modulation_configuration: Configuration for modulation
        """
        pulumi.set(__self__, "bandwidth_m_hz", bandwidth_m_hz)
        pulumi.set(__self__, "center_frequency_m_hz", center_frequency_m_hz)
        pulumi.set(__self__, "end_point", end_point)
        if decoding_configuration is not None:
            pulumi.set(__self__, "decoding_configuration", decoding_configuration)
        if demodulation_configuration is not None:
            pulumi.set(__self__, "demodulation_configuration", demodulation_configuration)
        if encoding_configuration is not None:
            pulumi.set(__self__, "encoding_configuration", encoding_configuration)
        if modulation_configuration is not None:
            pulumi.set(__self__, "modulation_configuration", modulation_configuration)

    @property
    @pulumi.getter(name="bandwidthMHz")
    def bandwidth_m_hz(self) -> float:
        """
        Bandwidth in MHz
        """
        return pulumi.get(self, "bandwidth_m_hz")

    @property
    @pulumi.getter(name="centerFrequencyMHz")
    def center_frequency_m_hz(self) -> float:
        """
        Center Frequency in MHz
        """
        return pulumi.get(self, "center_frequency_m_hz")

    @property
    @pulumi.getter(name="endPoint")
    def end_point(self) -> 'outputs.EndPointResponse':
        """
        Customer End point to store/retrieve data during a contact.
        """
        return pulumi.get(self, "end_point")

    @property
    @pulumi.getter(name="decodingConfiguration")
    def decoding_configuration(self) -> Optional[str]:
        """
        Configuration for decoding
        """
        return pulumi.get(self, "decoding_configuration")

    @property
    @pulumi.getter(name="demodulationConfiguration")
    def demodulation_configuration(self) -> Optional[str]:
        """
        Configuration for demodulation
        """
        return pulumi.get(self, "demodulation_configuration")

    @property
    @pulumi.getter(name="encodingConfiguration")
    def encoding_configuration(self) -> Optional[str]:
        """
        Configuration for encoding
        """
        return pulumi.get(self, "encoding_configuration")

    @property
    @pulumi.getter(name="modulationConfiguration")
    def modulation_configuration(self) -> Optional[str]:
        """
        Configuration for modulation
        """
        return pulumi.get(self, "modulation_configuration")


@pulumi.output_type
class ContactProfileLinkResponse(dict):
    """
    Contact Profile link
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "eirpdBW":
            suggest = "eirpd_bw"
        elif key == "gainOverTemperature":
            suggest = "gain_over_temperature"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContactProfileLinkResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContactProfileLinkResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContactProfileLinkResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 channels: Sequence['outputs.ContactProfileLinkChannelResponse'],
                 direction: str,
                 polarization: str,
                 eirpd_bw: Optional[float] = None,
                 gain_over_temperature: Optional[float] = None):
        """
        Contact Profile link
        :param Sequence['ContactProfileLinkChannelResponse'] channels: Contact Profile Link Channel
        :param str direction: Direction (uplink or downlink)
        :param str polarization: polarization. eg (RHCP, LHCP)
        :param float eirpd_bw: Effective Isotropic Radiated Power (EIRP) in dBW.
        :param float gain_over_temperature: Gain To Noise Temperature in db/K.
        """
        pulumi.set(__self__, "channels", channels)
        pulumi.set(__self__, "direction", direction)
        pulumi.set(__self__, "polarization", polarization)
        if eirpd_bw is not None:
            pulumi.set(__self__, "eirpd_bw", eirpd_bw)
        if gain_over_temperature is not None:
            pulumi.set(__self__, "gain_over_temperature", gain_over_temperature)

    @property
    @pulumi.getter
    def channels(self) -> Sequence['outputs.ContactProfileLinkChannelResponse']:
        """
        Contact Profile Link Channel
        """
        return pulumi.get(self, "channels")

    @property
    @pulumi.getter
    def direction(self) -> str:
        """
        Direction (uplink or downlink)
        """
        return pulumi.get(self, "direction")

    @property
    @pulumi.getter
    def polarization(self) -> str:
        """
        polarization. eg (RHCP, LHCP)
        """
        return pulumi.get(self, "polarization")

    @property
    @pulumi.getter(name="eirpdBW")
    def eirpd_bw(self) -> Optional[float]:
        """
        Effective Isotropic Radiated Power (EIRP) in dBW.
        """
        return pulumi.get(self, "eirpd_bw")

    @property
    @pulumi.getter(name="gainOverTemperature")
    def gain_over_temperature(self) -> Optional[float]:
        """
        Gain To Noise Temperature in db/K.
        """
        return pulumi.get(self, "gain_over_temperature")


@pulumi.output_type
class EndPointResponse(dict):
    """
    Customer End point to store/retrieve data during a contact.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endPointName":
            suggest = "end_point_name"
        elif key == "ipAddress":
            suggest = "ip_address"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EndPointResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EndPointResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EndPointResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 end_point_name: str,
                 ip_address: str,
                 port: str,
                 protocol: str):
        """
        Customer End point to store/retrieve data during a contact.
        :param str end_point_name: Name of an end point.
        :param str ip_address: IP Address.
        :param str port: TCP port to listen on to receive data.
        :param str protocol: Protocol either UDP or TCP.
        """
        pulumi.set(__self__, "end_point_name", end_point_name)
        pulumi.set(__self__, "ip_address", ip_address)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "protocol", protocol)

    @property
    @pulumi.getter(name="endPointName")
    def end_point_name(self) -> str:
        """
        Name of an end point.
        """
        return pulumi.get(self, "end_point_name")

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> str:
        """
        IP Address.
        """
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter
    def port(self) -> str:
        """
        TCP port to listen on to receive data.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def protocol(self) -> str:
        """
        Protocol either UDP or TCP.
        """
        return pulumi.get(self, "protocol")


@pulumi.output_type
class ResourceReferenceResponse(dict):
    """
    Resource Reference
    """
    def __init__(__self__, *,
                 id: Optional[str] = None):
        """
        Resource Reference
        :param str id: Resource ID.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class SpacecraftLinkResponse(dict):
    """
    Spacecraft Link
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bandwidthMHz":
            suggest = "bandwidth_m_hz"
        elif key == "centerFrequencyMHz":
            suggest = "center_frequency_m_hz"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SpacecraftLinkResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SpacecraftLinkResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SpacecraftLinkResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bandwidth_m_hz: float,
                 center_frequency_m_hz: float,
                 direction: str,
                 polarization: str):
        """
        Spacecraft Link
        :param float bandwidth_m_hz: Bandwidth in MHz
        :param float center_frequency_m_hz: Center Frequency in MHz
        :param str direction: Direction (uplink or downlink)
        :param str polarization: polarization. eg (RHCP, LHCP)
        """
        pulumi.set(__self__, "bandwidth_m_hz", bandwidth_m_hz)
        pulumi.set(__self__, "center_frequency_m_hz", center_frequency_m_hz)
        pulumi.set(__self__, "direction", direction)
        pulumi.set(__self__, "polarization", polarization)

    @property
    @pulumi.getter(name="bandwidthMHz")
    def bandwidth_m_hz(self) -> float:
        """
        Bandwidth in MHz
        """
        return pulumi.get(self, "bandwidth_m_hz")

    @property
    @pulumi.getter(name="centerFrequencyMHz")
    def center_frequency_m_hz(self) -> float:
        """
        Center Frequency in MHz
        """
        return pulumi.get(self, "center_frequency_m_hz")

    @property
    @pulumi.getter
    def direction(self) -> str:
        """
        Direction (uplink or downlink)
        """
        return pulumi.get(self, "direction")

    @property
    @pulumi.getter
    def polarization(self) -> str:
        """
        polarization. eg (RHCP, LHCP)
        """
        return pulumi.get(self, "polarization")


@pulumi.output_type
class SystemDataResponse(dict):
    """
    Metadata pertaining to creation and last modification of the resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createdAt":
            suggest = "created_at"
        elif key == "createdBy":
            suggest = "created_by"
        elif key == "createdByType":
            suggest = "created_by_type"
        elif key == "lastModifiedAt":
            suggest = "last_modified_at"
        elif key == "lastModifiedBy":
            suggest = "last_modified_by"
        elif key == "lastModifiedByType":
            suggest = "last_modified_by_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SystemDataResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SystemDataResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SystemDataResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 created_at: Optional[str] = None,
                 created_by: Optional[str] = None,
                 created_by_type: Optional[str] = None,
                 last_modified_at: Optional[str] = None,
                 last_modified_by: Optional[str] = None,
                 last_modified_by_type: Optional[str] = None):
        """
        Metadata pertaining to creation and last modification of the resource.
        :param str created_at: The timestamp of resource creation (UTC).
        :param str created_by: The identity that created the resource.
        :param str created_by_type: The type of identity that created the resource.
        :param str last_modified_at: The timestamp of resource last modification (UTC)
        :param str last_modified_by: The identity that last modified the resource.
        :param str last_modified_by_type: The type of identity that last modified the resource.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if created_by_type is not None:
            pulumi.set(__self__, "created_by_type", created_by_type)
        if last_modified_at is not None:
            pulumi.set(__self__, "last_modified_at", last_modified_at)
        if last_modified_by is not None:
            pulumi.set(__self__, "last_modified_by", last_modified_by)
        if last_modified_by_type is not None:
            pulumi.set(__self__, "last_modified_by_type", last_modified_by_type)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[str]:
        """
        The timestamp of resource creation (UTC).
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[str]:
        """
        The identity that created the resource.
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter(name="createdByType")
    def created_by_type(self) -> Optional[str]:
        """
        The type of identity that created the resource.
        """
        return pulumi.get(self, "created_by_type")

    @property
    @pulumi.getter(name="lastModifiedAt")
    def last_modified_at(self) -> Optional[str]:
        """
        The timestamp of resource last modification (UTC)
        """
        return pulumi.get(self, "last_modified_at")

    @property
    @pulumi.getter(name="lastModifiedBy")
    def last_modified_by(self) -> Optional[str]:
        """
        The identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by")

    @property
    @pulumi.getter(name="lastModifiedByType")
    def last_modified_by_type(self) -> Optional[str]:
        """
        The type of identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by_type")


