# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'ProviderArgs',
    'QuantumWorkspaceIdentityArgs',
]

@pulumi.input_type
class ProviderArgs:
    def __init__(__self__, *,
                 application_name: Optional[pulumi.Input[str]] = None,
                 instance_uri: Optional[pulumi.Input[str]] = None,
                 provider_id: Optional[pulumi.Input[str]] = None,
                 provider_sku: Optional[pulumi.Input[str]] = None,
                 provisioning_state: Optional[pulumi.Input[Union[str, 'Status']]] = None,
                 resource_usage_id: Optional[pulumi.Input[str]] = None):
        """
        Information about a Provider. A Provider is an entity that offers Targets to run Azure Quantum Jobs.
        :param pulumi.Input[str] application_name: The provider's marketplace application display name.
        :param pulumi.Input[str] instance_uri: A Uri identifying the specific instance of this provider.
        :param pulumi.Input[str] provider_id: Unique id of this provider.
        :param pulumi.Input[str] provider_sku: The sku associated with pricing information for this provider.
        :param pulumi.Input[Union[str, 'Status']] provisioning_state: Provisioning status field
        :param pulumi.Input[str] resource_usage_id: Id to track resource usage for the provider.
        """
        if application_name is not None:
            pulumi.set(__self__, "application_name", application_name)
        if instance_uri is not None:
            pulumi.set(__self__, "instance_uri", instance_uri)
        if provider_id is not None:
            pulumi.set(__self__, "provider_id", provider_id)
        if provider_sku is not None:
            pulumi.set(__self__, "provider_sku", provider_sku)
        if provisioning_state is not None:
            pulumi.set(__self__, "provisioning_state", provisioning_state)
        if resource_usage_id is not None:
            pulumi.set(__self__, "resource_usage_id", resource_usage_id)

    @property
    @pulumi.getter(name="applicationName")
    def application_name(self) -> Optional[pulumi.Input[str]]:
        """
        The provider's marketplace application display name.
        """
        return pulumi.get(self, "application_name")

    @application_name.setter
    def application_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "application_name", value)

    @property
    @pulumi.getter(name="instanceUri")
    def instance_uri(self) -> Optional[pulumi.Input[str]]:
        """
        A Uri identifying the specific instance of this provider.
        """
        return pulumi.get(self, "instance_uri")

    @instance_uri.setter
    def instance_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_uri", value)

    @property
    @pulumi.getter(name="providerId")
    def provider_id(self) -> Optional[pulumi.Input[str]]:
        """
        Unique id of this provider.
        """
        return pulumi.get(self, "provider_id")

    @provider_id.setter
    def provider_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "provider_id", value)

    @property
    @pulumi.getter(name="providerSku")
    def provider_sku(self) -> Optional[pulumi.Input[str]]:
        """
        The sku associated with pricing information for this provider.
        """
        return pulumi.get(self, "provider_sku")

    @provider_sku.setter
    def provider_sku(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "provider_sku", value)

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> Optional[pulumi.Input[Union[str, 'Status']]]:
        """
        Provisioning status field
        """
        return pulumi.get(self, "provisioning_state")

    @provisioning_state.setter
    def provisioning_state(self, value: Optional[pulumi.Input[Union[str, 'Status']]]):
        pulumi.set(self, "provisioning_state", value)

    @property
    @pulumi.getter(name="resourceUsageId")
    def resource_usage_id(self) -> Optional[pulumi.Input[str]]:
        """
        Id to track resource usage for the provider.
        """
        return pulumi.get(self, "resource_usage_id")

    @resource_usage_id.setter
    def resource_usage_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_usage_id", value)


@pulumi.input_type
class QuantumWorkspaceIdentityArgs:
    def __init__(__self__, *,
                 type: Optional[pulumi.Input[Union[str, 'ResourceIdentityType']]] = None):
        """
        Managed Identity information.
        :param pulumi.Input[Union[str, 'ResourceIdentityType']] type: The identity type.
        """
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[Union[str, 'ResourceIdentityType']]]:
        """
        The identity type.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[Union[str, 'ResourceIdentityType']]]):
        pulumi.set(self, "type", value)


