# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'IscsiTargetInfoResponse',
    'NetworkRuleSetResponse',
    'SkuResponse',
    'SourceCreationDataResponse',
    'SystemDataResponse',
    'VirtualNetworkRuleResponse',
]

@pulumi.output_type
class IscsiTargetInfoResponse(dict):
    """
    Iscsi target information
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "targetIqn":
            suggest = "target_iqn"
        elif key == "targetPortalHostname":
            suggest = "target_portal_hostname"
        elif key == "targetPortalPort":
            suggest = "target_portal_port"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IscsiTargetInfoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IscsiTargetInfoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IscsiTargetInfoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 provisioning_state: str,
                 target_iqn: str,
                 target_portal_hostname: str,
                 target_portal_port: int,
                 status: Optional[str] = None):
        """
        Iscsi target information
        :param str provisioning_state: State of the operation on the resource.
        :param str target_iqn: iSCSI Target IQN (iSCSI Qualified Name); example: "iqn.2005-03.org.iscsi:server".
        :param str target_portal_hostname: iSCSI Target Portal Host Name
        :param int target_portal_port: iSCSI Target Portal Port
        :param str status: Operational status of the iSCSI Target.
        """
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        pulumi.set(__self__, "target_iqn", target_iqn)
        pulumi.set(__self__, "target_portal_hostname", target_portal_hostname)
        pulumi.set(__self__, "target_portal_port", target_portal_port)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        State of the operation on the resource.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="targetIqn")
    def target_iqn(self) -> str:
        """
        iSCSI Target IQN (iSCSI Qualified Name); example: "iqn.2005-03.org.iscsi:server".
        """
        return pulumi.get(self, "target_iqn")

    @property
    @pulumi.getter(name="targetPortalHostname")
    def target_portal_hostname(self) -> str:
        """
        iSCSI Target Portal Host Name
        """
        return pulumi.get(self, "target_portal_hostname")

    @property
    @pulumi.getter(name="targetPortalPort")
    def target_portal_port(self) -> int:
        """
        iSCSI Target Portal Port
        """
        return pulumi.get(self, "target_portal_port")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        Operational status of the iSCSI Target.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class NetworkRuleSetResponse(dict):
    """
    A set of rules governing the network accessibility.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "virtualNetworkRules":
            suggest = "virtual_network_rules"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkRuleSetResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkRuleSetResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkRuleSetResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 virtual_network_rules: Optional[Sequence['outputs.VirtualNetworkRuleResponse']] = None):
        """
        A set of rules governing the network accessibility.
        :param Sequence['VirtualNetworkRuleResponse'] virtual_network_rules: The list of virtual network rules.
        """
        if virtual_network_rules is not None:
            pulumi.set(__self__, "virtual_network_rules", virtual_network_rules)

    @property
    @pulumi.getter(name="virtualNetworkRules")
    def virtual_network_rules(self) -> Optional[Sequence['outputs.VirtualNetworkRuleResponse']]:
        """
        The list of virtual network rules.
        """
        return pulumi.get(self, "virtual_network_rules")


@pulumi.output_type
class SkuResponse(dict):
    """
    The SKU name. Required for account creation; optional for update.
    """
    def __init__(__self__, *,
                 name: Optional[str] = None,
                 tier: Optional[str] = None):
        """
        The SKU name. Required for account creation; optional for update.
        :param str name: The sku name.
        :param str tier: The sku tier.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tier is not None:
            pulumi.set(__self__, "tier", tier)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The sku name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def tier(self) -> Optional[str]:
        """
        The sku tier.
        """
        return pulumi.get(self, "tier")


@pulumi.output_type
class SourceCreationDataResponse(dict):
    """
    Data used when creating a disk.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createSource":
            suggest = "create_source"
        elif key == "sourceUri":
            suggest = "source_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SourceCreationDataResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SourceCreationDataResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SourceCreationDataResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 create_source: str,
                 source_uri: Optional[str] = None):
        """
        Data used when creating a disk.
        :param str create_source: This enumerates the possible sources of a volume creation.
        :param str source_uri: If createOption is Copy, this is the ARM id of the source snapshot or disk. If createOption is Restore, this is the ARM-like id of the source disk restore point.
        """
        pulumi.set(__self__, "create_source", create_source)
        if source_uri is not None:
            pulumi.set(__self__, "source_uri", source_uri)

    @property
    @pulumi.getter(name="createSource")
    def create_source(self) -> str:
        """
        This enumerates the possible sources of a volume creation.
        """
        return pulumi.get(self, "create_source")

    @property
    @pulumi.getter(name="sourceUri")
    def source_uri(self) -> Optional[str]:
        """
        If createOption is Copy, this is the ARM id of the source snapshot or disk. If createOption is Restore, this is the ARM-like id of the source disk restore point.
        """
        return pulumi.get(self, "source_uri")


@pulumi.output_type
class SystemDataResponse(dict):
    """
    Metadata pertaining to creation and last modification of the resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createdAt":
            suggest = "created_at"
        elif key == "createdBy":
            suggest = "created_by"
        elif key == "createdByType":
            suggest = "created_by_type"
        elif key == "lastModifiedAt":
            suggest = "last_modified_at"
        elif key == "lastModifiedBy":
            suggest = "last_modified_by"
        elif key == "lastModifiedByType":
            suggest = "last_modified_by_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SystemDataResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SystemDataResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SystemDataResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 created_at: Optional[str] = None,
                 created_by: Optional[str] = None,
                 created_by_type: Optional[str] = None,
                 last_modified_at: Optional[str] = None,
                 last_modified_by: Optional[str] = None,
                 last_modified_by_type: Optional[str] = None):
        """
        Metadata pertaining to creation and last modification of the resource.
        :param str created_at: The timestamp of resource creation (UTC).
        :param str created_by: The identity that created the resource.
        :param str created_by_type: The type of identity that created the resource.
        :param str last_modified_at: The timestamp of resource last modification (UTC)
        :param str last_modified_by: The identity that last modified the resource.
        :param str last_modified_by_type: The type of identity that last modified the resource.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if created_by_type is not None:
            pulumi.set(__self__, "created_by_type", created_by_type)
        if last_modified_at is not None:
            pulumi.set(__self__, "last_modified_at", last_modified_at)
        if last_modified_by is not None:
            pulumi.set(__self__, "last_modified_by", last_modified_by)
        if last_modified_by_type is not None:
            pulumi.set(__self__, "last_modified_by_type", last_modified_by_type)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[str]:
        """
        The timestamp of resource creation (UTC).
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[str]:
        """
        The identity that created the resource.
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter(name="createdByType")
    def created_by_type(self) -> Optional[str]:
        """
        The type of identity that created the resource.
        """
        return pulumi.get(self, "created_by_type")

    @property
    @pulumi.getter(name="lastModifiedAt")
    def last_modified_at(self) -> Optional[str]:
        """
        The timestamp of resource last modification (UTC)
        """
        return pulumi.get(self, "last_modified_at")

    @property
    @pulumi.getter(name="lastModifiedBy")
    def last_modified_by(self) -> Optional[str]:
        """
        The identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by")

    @property
    @pulumi.getter(name="lastModifiedByType")
    def last_modified_by_type(self) -> Optional[str]:
        """
        The type of identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by_type")


@pulumi.output_type
class VirtualNetworkRuleResponse(dict):
    """
    Virtual Network rule.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "virtualNetworkResourceId":
            suggest = "virtual_network_resource_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualNetworkRuleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualNetworkRuleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualNetworkRuleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 state: str,
                 virtual_network_resource_id: str,
                 action: Optional[str] = None):
        """
        Virtual Network rule.
        :param str state: Gets the state of virtual network rule.
        :param str virtual_network_resource_id: Resource ID of a subnet, for example: /subscriptions/{subscriptionId}/resourceGroups/{groupName}/providers/Microsoft.Network/virtualNetworks/{vnetName}/subnets/{subnetName}.
        :param str action: The action of virtual network rule.
        """
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "virtual_network_resource_id", virtual_network_resource_id)
        if action is None:
            action = 'Allow'
        if action is not None:
            pulumi.set(__self__, "action", action)

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        Gets the state of virtual network rule.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="virtualNetworkResourceId")
    def virtual_network_resource_id(self) -> str:
        """
        Resource ID of a subnet, for example: /subscriptions/{subscriptionId}/resourceGroups/{groupName}/providers/Microsoft.Network/virtualNetworks/{vnetName}/subnets/{subnetName}.
        """
        return pulumi.get(self, "virtual_network_resource_id")

    @property
    @pulumi.getter
    def action(self) -> Optional[str]:
        """
        The action of virtual network rule.
        """
        return pulumi.get(self, "action")


