# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'AddressResponse',
    'AsymmetricEncryptedSecretResponse',
    'AuthenticationResponse',
    'AzureContainerInfoResponse',
    'ClientAccessRightResponse',
    'CniConfigResponse',
    'ComputeResourceResponse',
    'ComputeVersionInformationResponse',
    'ContactDetailsResponse',
    'DataResidencyResponse',
    'EdgeProfileResponse',
    'EdgeProfileSubscriptionResponse',
    'EtcdInfoResponse',
    'FileSourceInfoResponse',
    'ImageRepositoryCredentialResponse',
    'IoTDeviceInfoResponse',
    'IoTEdgeAgentInfoResponse',
    'KubernetesClusterInfoResponse',
    'KubernetesIPConfigurationResponse',
    'KubernetesRoleComputeResponse',
    'KubernetesRoleNetworkResponse',
    'KubernetesRoleResourcesResponse',
    'KubernetesRoleStorageClassInfoResponse',
    'KubernetesRoleStorageResponse',
    'LoadBalancerConfigResponse',
    'MetricConfigurationResponse',
    'MetricCounterResponse',
    'MetricCounterSetResponse',
    'MetricDimensionResponse',
    'MountPointMapResponse',
    'NodeInfoResponse',
    'OrderStatusResponse',
    'PeriodicTimerSourceInfoResponse',
    'RefreshDetailsResponse',
    'ResourceIdentityResponse',
    'ResourceMoveDetailsResponse',
    'RoleSinkInfoResponse',
    'SecretResponse',
    'ShareAccessRightResponse',
    'SkuResponse',
    'SubscriptionRegisteredFeaturesResponse',
    'SymmetricKeyResponse',
    'SystemDataResponse',
    'TrackingInfoResponse',
    'UserAccessRightResponse',
]

@pulumi.output_type
class AddressResponse(dict):
    """
    The shipping address of the customer.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "addressLine1":
            suggest = "address_line1"
        elif key == "addressLine2":
            suggest = "address_line2"
        elif key == "addressLine3":
            suggest = "address_line3"
        elif key == "postalCode":
            suggest = "postal_code"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AddressResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AddressResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AddressResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 country: str,
                 address_line1: Optional[str] = None,
                 address_line2: Optional[str] = None,
                 address_line3: Optional[str] = None,
                 city: Optional[str] = None,
                 postal_code: Optional[str] = None,
                 state: Optional[str] = None):
        """
        The shipping address of the customer.
        :param str country: The country name.
        :param str address_line1: The address line1.
        :param str address_line2: The address line2.
        :param str address_line3: The address line3.
        :param str city: The city name.
        :param str postal_code: The postal code.
        :param str state: The state name.
        """
        pulumi.set(__self__, "country", country)
        if address_line1 is not None:
            pulumi.set(__self__, "address_line1", address_line1)
        if address_line2 is not None:
            pulumi.set(__self__, "address_line2", address_line2)
        if address_line3 is not None:
            pulumi.set(__self__, "address_line3", address_line3)
        if city is not None:
            pulumi.set(__self__, "city", city)
        if postal_code is not None:
            pulumi.set(__self__, "postal_code", postal_code)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def country(self) -> str:
        """
        The country name.
        """
        return pulumi.get(self, "country")

    @property
    @pulumi.getter(name="addressLine1")
    def address_line1(self) -> Optional[str]:
        """
        The address line1.
        """
        return pulumi.get(self, "address_line1")

    @property
    @pulumi.getter(name="addressLine2")
    def address_line2(self) -> Optional[str]:
        """
        The address line2.
        """
        return pulumi.get(self, "address_line2")

    @property
    @pulumi.getter(name="addressLine3")
    def address_line3(self) -> Optional[str]:
        """
        The address line3.
        """
        return pulumi.get(self, "address_line3")

    @property
    @pulumi.getter
    def city(self) -> Optional[str]:
        """
        The city name.
        """
        return pulumi.get(self, "city")

    @property
    @pulumi.getter(name="postalCode")
    def postal_code(self) -> Optional[str]:
        """
        The postal code.
        """
        return pulumi.get(self, "postal_code")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The state name.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class AsymmetricEncryptedSecretResponse(dict):
    """
    Represent the secrets intended for encryption with asymmetric key pair.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "encryptionAlgorithm":
            suggest = "encryption_algorithm"
        elif key == "encryptionCertThumbprint":
            suggest = "encryption_cert_thumbprint"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AsymmetricEncryptedSecretResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AsymmetricEncryptedSecretResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AsymmetricEncryptedSecretResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 encryption_algorithm: str,
                 value: str,
                 encryption_cert_thumbprint: Optional[str] = None):
        """
        Represent the secrets intended for encryption with asymmetric key pair.
        :param str encryption_algorithm: The algorithm used to encrypt "Value".
        :param str value: The value of the secret.
        :param str encryption_cert_thumbprint: Thumbprint certificate used to encrypt \"Value\". If the value is unencrypted, it will be null.
        """
        pulumi.set(__self__, "encryption_algorithm", encryption_algorithm)
        pulumi.set(__self__, "value", value)
        if encryption_cert_thumbprint is not None:
            pulumi.set(__self__, "encryption_cert_thumbprint", encryption_cert_thumbprint)

    @property
    @pulumi.getter(name="encryptionAlgorithm")
    def encryption_algorithm(self) -> str:
        """
        The algorithm used to encrypt "Value".
        """
        return pulumi.get(self, "encryption_algorithm")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The value of the secret.
        """
        return pulumi.get(self, "value")

    @property
    @pulumi.getter(name="encryptionCertThumbprint")
    def encryption_cert_thumbprint(self) -> Optional[str]:
        """
        Thumbprint certificate used to encrypt \"Value\". If the value is unencrypted, it will be null.
        """
        return pulumi.get(self, "encryption_cert_thumbprint")


@pulumi.output_type
class AuthenticationResponse(dict):
    """
    Authentication mechanism for IoT devices.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "symmetricKey":
            suggest = "symmetric_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AuthenticationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AuthenticationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AuthenticationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 symmetric_key: Optional['outputs.SymmetricKeyResponse'] = None):
        """
        Authentication mechanism for IoT devices.
        :param 'SymmetricKeyResponse' symmetric_key: Symmetric key for authentication.
        """
        if symmetric_key is not None:
            pulumi.set(__self__, "symmetric_key", symmetric_key)

    @property
    @pulumi.getter(name="symmetricKey")
    def symmetric_key(self) -> Optional['outputs.SymmetricKeyResponse']:
        """
        Symmetric key for authentication.
        """
        return pulumi.get(self, "symmetric_key")


@pulumi.output_type
class AzureContainerInfoResponse(dict):
    """
    Azure container mapping of the endpoint.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "containerName":
            suggest = "container_name"
        elif key == "dataFormat":
            suggest = "data_format"
        elif key == "storageAccountCredentialId":
            suggest = "storage_account_credential_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureContainerInfoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureContainerInfoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureContainerInfoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 container_name: str,
                 data_format: str,
                 storage_account_credential_id: str):
        """
        Azure container mapping of the endpoint.
        :param str container_name: Container name (Based on the data format specified, this represents the name of Azure Files/Page blob/Block blob).
        :param str data_format: Storage format used for the file represented by the share.
        :param str storage_account_credential_id: ID of the storage account credential used to access storage.
        """
        pulumi.set(__self__, "container_name", container_name)
        pulumi.set(__self__, "data_format", data_format)
        pulumi.set(__self__, "storage_account_credential_id", storage_account_credential_id)

    @property
    @pulumi.getter(name="containerName")
    def container_name(self) -> str:
        """
        Container name (Based on the data format specified, this represents the name of Azure Files/Page blob/Block blob).
        """
        return pulumi.get(self, "container_name")

    @property
    @pulumi.getter(name="dataFormat")
    def data_format(self) -> str:
        """
        Storage format used for the file represented by the share.
        """
        return pulumi.get(self, "data_format")

    @property
    @pulumi.getter(name="storageAccountCredentialId")
    def storage_account_credential_id(self) -> str:
        """
        ID of the storage account credential used to access storage.
        """
        return pulumi.get(self, "storage_account_credential_id")


@pulumi.output_type
class ClientAccessRightResponse(dict):
    """
    The mapping between a particular client IP and the type of access client has on the NFS share.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessPermission":
            suggest = "access_permission"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClientAccessRightResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClientAccessRightResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClientAccessRightResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_permission: str,
                 client: str):
        """
        The mapping between a particular client IP and the type of access client has on the NFS share.
        :param str access_permission: Type of access to be allowed for the client.
        :param str client: IP of the client.
        """
        pulumi.set(__self__, "access_permission", access_permission)
        pulumi.set(__self__, "client", client)

    @property
    @pulumi.getter(name="accessPermission")
    def access_permission(self) -> str:
        """
        Type of access to be allowed for the client.
        """
        return pulumi.get(self, "access_permission")

    @property
    @pulumi.getter
    def client(self) -> str:
        """
        IP of the client.
        """
        return pulumi.get(self, "client")


@pulumi.output_type
class CniConfigResponse(dict):
    """
    Cni configuration
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "componentType":
            suggest = "component_type"
        elif key == "podSubnet":
            suggest = "pod_subnet"
        elif key == "serviceSubnet":
            suggest = "service_subnet"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CniConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CniConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CniConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 component_type: str,
                 pod_subnet: str,
                 service_subnet: str,
                 type: str,
                 version: str):
        """
        Cni configuration
        :param str component_type: ComponentType of the Kubernetes node.
        :param str pod_subnet: Pod Subnet
        :param str service_subnet: Service subnet
        :param str type: Cni type
        :param str version: Cni version
        """
        pulumi.set(__self__, "component_type", component_type)
        pulumi.set(__self__, "pod_subnet", pod_subnet)
        pulumi.set(__self__, "service_subnet", service_subnet)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="componentType")
    def component_type(self) -> str:
        """
        ComponentType of the Kubernetes node.
        """
        return pulumi.get(self, "component_type")

    @property
    @pulumi.getter(name="podSubnet")
    def pod_subnet(self) -> str:
        """
        Pod Subnet
        """
        return pulumi.get(self, "pod_subnet")

    @property
    @pulumi.getter(name="serviceSubnet")
    def service_subnet(self) -> str:
        """
        Service subnet
        """
        return pulumi.get(self, "service_subnet")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Cni type
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        Cni version
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class ComputeResourceResponse(dict):
    """
    Compute infrastructure Resource
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "memoryInGB":
            suggest = "memory_in_gb"
        elif key == "processorCount":
            suggest = "processor_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ComputeResourceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ComputeResourceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ComputeResourceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 memory_in_gb: float,
                 processor_count: int):
        """
        Compute infrastructure Resource
        :param float memory_in_gb: Memory in GB
        :param int processor_count: Processor count
        """
        pulumi.set(__self__, "memory_in_gb", memory_in_gb)
        pulumi.set(__self__, "processor_count", processor_count)

    @property
    @pulumi.getter(name="memoryInGB")
    def memory_in_gb(self) -> float:
        """
        Memory in GB
        """
        return pulumi.get(self, "memory_in_gb")

    @property
    @pulumi.getter(name="processorCount")
    def processor_count(self) -> int:
        """
        Processor count
        """
        return pulumi.get(self, "processor_count")


@pulumi.output_type
class ComputeVersionInformationResponse(dict):
    """
    This contains the compute information
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "azureArcVersion":
            suggest = "azure_arc_version"
        elif key == "iotEdgeVersion":
            suggest = "iot_edge_version"
        elif key == "kubernetesVersion":
            suggest = "kubernetes_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ComputeVersionInformationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ComputeVersionInformationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ComputeVersionInformationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 azure_arc_version: Optional[str] = None,
                 iot_edge_version: Optional[str] = None,
                 kubernetes_version: Optional[str] = None):
        """
        This contains the compute information
        :param str azure_arc_version: Azure Arc Version
        :param str iot_edge_version: IOTEdge Version
        :param str kubernetes_version: Kubernetes Version
        """
        if azure_arc_version is not None:
            pulumi.set(__self__, "azure_arc_version", azure_arc_version)
        if iot_edge_version is not None:
            pulumi.set(__self__, "iot_edge_version", iot_edge_version)
        if kubernetes_version is not None:
            pulumi.set(__self__, "kubernetes_version", kubernetes_version)

    @property
    @pulumi.getter(name="azureArcVersion")
    def azure_arc_version(self) -> Optional[str]:
        """
        Azure Arc Version
        """
        return pulumi.get(self, "azure_arc_version")

    @property
    @pulumi.getter(name="iotEdgeVersion")
    def iot_edge_version(self) -> Optional[str]:
        """
        IOTEdge Version
        """
        return pulumi.get(self, "iot_edge_version")

    @property
    @pulumi.getter(name="kubernetesVersion")
    def kubernetes_version(self) -> Optional[str]:
        """
        Kubernetes Version
        """
        return pulumi.get(self, "kubernetes_version")


@pulumi.output_type
class ContactDetailsResponse(dict):
    """
    Contains all the contact details of the customer.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "companyName":
            suggest = "company_name"
        elif key == "contactPerson":
            suggest = "contact_person"
        elif key == "emailList":
            suggest = "email_list"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContactDetailsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContactDetailsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContactDetailsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 company_name: str,
                 contact_person: str,
                 email_list: Sequence[str],
                 phone: str):
        """
        Contains all the contact details of the customer.
        :param str company_name: The name of the company.
        :param str contact_person: The contact person name.
        :param Sequence[str] email_list: The email list.
        :param str phone: The phone number.
        """
        pulumi.set(__self__, "company_name", company_name)
        pulumi.set(__self__, "contact_person", contact_person)
        pulumi.set(__self__, "email_list", email_list)
        pulumi.set(__self__, "phone", phone)

    @property
    @pulumi.getter(name="companyName")
    def company_name(self) -> str:
        """
        The name of the company.
        """
        return pulumi.get(self, "company_name")

    @property
    @pulumi.getter(name="contactPerson")
    def contact_person(self) -> str:
        """
        The contact person name.
        """
        return pulumi.get(self, "contact_person")

    @property
    @pulumi.getter(name="emailList")
    def email_list(self) -> Sequence[str]:
        """
        The email list.
        """
        return pulumi.get(self, "email_list")

    @property
    @pulumi.getter
    def phone(self) -> str:
        """
        The phone number.
        """
        return pulumi.get(self, "phone")


@pulumi.output_type
class DataResidencyResponse(dict):
    """
    Wraps data-residency related information for edge-resource and this should be used with ARM layer.
    """
    def __init__(__self__, *,
                 type: Optional[str] = None):
        """
        Wraps data-residency related information for edge-resource and this should be used with ARM layer.
        :param str type: DataResidencyType enum
        """
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        DataResidencyType enum
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class EdgeProfileResponse(dict):
    """
    Details about Edge Profile for the resource
    """
    def __init__(__self__, *,
                 subscription: Optional['outputs.EdgeProfileSubscriptionResponse'] = None):
        """
        Details about Edge Profile for the resource
        :param 'EdgeProfileSubscriptionResponse' subscription: Edge Profile Subscription
        """
        if subscription is not None:
            pulumi.set(__self__, "subscription", subscription)

    @property
    @pulumi.getter
    def subscription(self) -> Optional['outputs.EdgeProfileSubscriptionResponse']:
        """
        Edge Profile Subscription
        """
        return pulumi.get(self, "subscription")


@pulumi.output_type
class EdgeProfileSubscriptionResponse(dict):
    """
    Subscription details for the Edge Profile
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "locationPlacementId":
            suggest = "location_placement_id"
        elif key == "quotaId":
            suggest = "quota_id"
        elif key == "registeredFeatures":
            suggest = "registered_features"
        elif key == "registrationDate":
            suggest = "registration_date"
        elif key == "registrationId":
            suggest = "registration_id"
        elif key == "serializedDetails":
            suggest = "serialized_details"
        elif key == "subscriptionId":
            suggest = "subscription_id"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EdgeProfileSubscriptionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EdgeProfileSubscriptionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EdgeProfileSubscriptionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: Optional[str] = None,
                 location_placement_id: Optional[str] = None,
                 quota_id: Optional[str] = None,
                 registered_features: Optional[Sequence['outputs.SubscriptionRegisteredFeaturesResponse']] = None,
                 registration_date: Optional[str] = None,
                 registration_id: Optional[str] = None,
                 serialized_details: Optional[str] = None,
                 state: Optional[str] = None,
                 subscription_id: Optional[str] = None,
                 tenant_id: Optional[str] = None):
        """
        Subscription details for the Edge Profile
        :param str id: ARM ID of the subscription
        :param str registration_id: Edge Subscription Registration ID
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if location_placement_id is not None:
            pulumi.set(__self__, "location_placement_id", location_placement_id)
        if quota_id is not None:
            pulumi.set(__self__, "quota_id", quota_id)
        if registered_features is not None:
            pulumi.set(__self__, "registered_features", registered_features)
        if registration_date is not None:
            pulumi.set(__self__, "registration_date", registration_date)
        if registration_id is not None:
            pulumi.set(__self__, "registration_id", registration_id)
        if serialized_details is not None:
            pulumi.set(__self__, "serialized_details", serialized_details)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if subscription_id is not None:
            pulumi.set(__self__, "subscription_id", subscription_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        ARM ID of the subscription
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="locationPlacementId")
    def location_placement_id(self) -> Optional[str]:
        return pulumi.get(self, "location_placement_id")

    @property
    @pulumi.getter(name="quotaId")
    def quota_id(self) -> Optional[str]:
        return pulumi.get(self, "quota_id")

    @property
    @pulumi.getter(name="registeredFeatures")
    def registered_features(self) -> Optional[Sequence['outputs.SubscriptionRegisteredFeaturesResponse']]:
        return pulumi.get(self, "registered_features")

    @property
    @pulumi.getter(name="registrationDate")
    def registration_date(self) -> Optional[str]:
        return pulumi.get(self, "registration_date")

    @property
    @pulumi.getter(name="registrationId")
    def registration_id(self) -> Optional[str]:
        """
        Edge Subscription Registration ID
        """
        return pulumi.get(self, "registration_id")

    @property
    @pulumi.getter(name="serializedDetails")
    def serialized_details(self) -> Optional[str]:
        return pulumi.get(self, "serialized_details")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> Optional[str]:
        return pulumi.get(self, "subscription_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[str]:
        return pulumi.get(self, "tenant_id")


@pulumi.output_type
class EtcdInfoResponse(dict):
    """
    Etcd configuration
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "componentType":
            suggest = "component_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EtcdInfoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EtcdInfoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EtcdInfoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 component_type: str,
                 type: str,
                 version: str):
        """
        Etcd configuration
        :param str component_type: ComponentType of the Kubernetes node.
        :param str type: Etcd type
        :param str version: Etcd version
        """
        pulumi.set(__self__, "component_type", component_type)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="componentType")
    def component_type(self) -> str:
        """
        ComponentType of the Kubernetes node.
        """
        return pulumi.get(self, "component_type")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Etcd type
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        Etcd version
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class FileSourceInfoResponse(dict):
    """
    File source details.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "shareId":
            suggest = "share_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FileSourceInfoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FileSourceInfoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FileSourceInfoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 share_id: str):
        """
        File source details.
        :param str share_id: File share ID.
        """
        pulumi.set(__self__, "share_id", share_id)

    @property
    @pulumi.getter(name="shareId")
    def share_id(self) -> str:
        """
        File share ID.
        """
        return pulumi.get(self, "share_id")


@pulumi.output_type
class ImageRepositoryCredentialResponse(dict):
    """
    Image repository credential.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "imageRepositoryUrl":
            suggest = "image_repository_url"
        elif key == "userName":
            suggest = "user_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ImageRepositoryCredentialResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ImageRepositoryCredentialResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ImageRepositoryCredentialResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 image_repository_url: str,
                 user_name: str,
                 password: Optional['outputs.AsymmetricEncryptedSecretResponse'] = None):
        """
        Image repository credential.
        :param str image_repository_url: Image repository url (e.g.: mcr.microsoft.com).
        :param str user_name: Repository user name.
        :param 'AsymmetricEncryptedSecretResponse' password: Repository user password.
        """
        pulumi.set(__self__, "image_repository_url", image_repository_url)
        pulumi.set(__self__, "user_name", user_name)
        if password is not None:
            pulumi.set(__self__, "password", password)

    @property
    @pulumi.getter(name="imageRepositoryUrl")
    def image_repository_url(self) -> str:
        """
        Image repository url (e.g.: mcr.microsoft.com).
        """
        return pulumi.get(self, "image_repository_url")

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> str:
        """
        Repository user name.
        """
        return pulumi.get(self, "user_name")

    @property
    @pulumi.getter
    def password(self) -> Optional['outputs.AsymmetricEncryptedSecretResponse']:
        """
        Repository user password.
        """
        return pulumi.get(self, "password")


@pulumi.output_type
class IoTDeviceInfoResponse(dict):
    """
    Metadata of IoT device/IoT Edge device to be configured.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deviceId":
            suggest = "device_id"
        elif key == "ioTHostHub":
            suggest = "io_t_host_hub"
        elif key == "ioTHostHubId":
            suggest = "io_t_host_hub_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IoTDeviceInfoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IoTDeviceInfoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IoTDeviceInfoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 device_id: str,
                 io_t_host_hub: str,
                 authentication: Optional['outputs.AuthenticationResponse'] = None,
                 io_t_host_hub_id: Optional[str] = None):
        """
        Metadata of IoT device/IoT Edge device to be configured.
        :param str device_id: ID of the IoT device/edge device.
        :param str io_t_host_hub: Host name for the IoT hub associated to the device.
        :param 'AuthenticationResponse' authentication: Encrypted IoT device/IoT edge device connection string.
        :param str io_t_host_hub_id: Id for the IoT hub associated to the device.
        """
        pulumi.set(__self__, "device_id", device_id)
        pulumi.set(__self__, "io_t_host_hub", io_t_host_hub)
        if authentication is not None:
            pulumi.set(__self__, "authentication", authentication)
        if io_t_host_hub_id is not None:
            pulumi.set(__self__, "io_t_host_hub_id", io_t_host_hub_id)

    @property
    @pulumi.getter(name="deviceId")
    def device_id(self) -> str:
        """
        ID of the IoT device/edge device.
        """
        return pulumi.get(self, "device_id")

    @property
    @pulumi.getter(name="ioTHostHub")
    def io_t_host_hub(self) -> str:
        """
        Host name for the IoT hub associated to the device.
        """
        return pulumi.get(self, "io_t_host_hub")

    @property
    @pulumi.getter
    def authentication(self) -> Optional['outputs.AuthenticationResponse']:
        """
        Encrypted IoT device/IoT edge device connection string.
        """
        return pulumi.get(self, "authentication")

    @property
    @pulumi.getter(name="ioTHostHubId")
    def io_t_host_hub_id(self) -> Optional[str]:
        """
        Id for the IoT hub associated to the device.
        """
        return pulumi.get(self, "io_t_host_hub_id")


@pulumi.output_type
class IoTEdgeAgentInfoResponse(dict):
    """
    IoT edge agent details is optional, this will be used for download system Agent module while bootstrapping IoT Role if specified.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "imageName":
            suggest = "image_name"
        elif key == "imageRepository":
            suggest = "image_repository"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IoTEdgeAgentInfoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IoTEdgeAgentInfoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IoTEdgeAgentInfoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 image_name: str,
                 tag: str,
                 image_repository: Optional['outputs.ImageRepositoryCredentialResponse'] = None):
        """
        IoT edge agent details is optional, this will be used for download system Agent module while bootstrapping IoT Role if specified.
        :param str image_name: Name of the IoT edge agent image.
        :param str tag: Image Tag.
        :param 'ImageRepositoryCredentialResponse' image_repository: Image repository details.
        """
        pulumi.set(__self__, "image_name", image_name)
        pulumi.set(__self__, "tag", tag)
        if image_repository is not None:
            pulumi.set(__self__, "image_repository", image_repository)

    @property
    @pulumi.getter(name="imageName")
    def image_name(self) -> str:
        """
        Name of the IoT edge agent image.
        """
        return pulumi.get(self, "image_name")

    @property
    @pulumi.getter
    def tag(self) -> str:
        """
        Image Tag.
        """
        return pulumi.get(self, "tag")

    @property
    @pulumi.getter(name="imageRepository")
    def image_repository(self) -> Optional['outputs.ImageRepositoryCredentialResponse']:
        """
        Image repository details.
        """
        return pulumi.get(self, "image_repository")


@pulumi.output_type
class KubernetesClusterInfoResponse(dict):
    """
    Kubernetes cluster configuration
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "componentType":
            suggest = "component_type"
        elif key == "etcdInfo":
            suggest = "etcd_info"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KubernetesClusterInfoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KubernetesClusterInfoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KubernetesClusterInfoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 component_type: str,
                 etcd_info: 'outputs.EtcdInfoResponse',
                 nodes: Sequence['outputs.NodeInfoResponse'],
                 version: str):
        """
        Kubernetes cluster configuration
        :param str component_type: ComponentType of the Kubernetes node.
        :param 'EtcdInfoResponse' etcd_info: Etcd configuration
        :param Sequence['NodeInfoResponse'] nodes: Kubernetes cluster nodes
        :param str version: Kubernetes cluster version
        """
        pulumi.set(__self__, "component_type", component_type)
        pulumi.set(__self__, "etcd_info", etcd_info)
        pulumi.set(__self__, "nodes", nodes)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="componentType")
    def component_type(self) -> str:
        """
        ComponentType of the Kubernetes node.
        """
        return pulumi.get(self, "component_type")

    @property
    @pulumi.getter(name="etcdInfo")
    def etcd_info(self) -> 'outputs.EtcdInfoResponse':
        """
        Etcd configuration
        """
        return pulumi.get(self, "etcd_info")

    @property
    @pulumi.getter
    def nodes(self) -> Sequence['outputs.NodeInfoResponse']:
        """
        Kubernetes cluster nodes
        """
        return pulumi.get(self, "nodes")

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        Kubernetes cluster version
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class KubernetesIPConfigurationResponse(dict):
    """
    Kubernetes node IP configuration
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipAddress":
            suggest = "ip_address"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KubernetesIPConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KubernetesIPConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KubernetesIPConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 port: str,
                 ip_address: Optional[str] = None):
        """
        Kubernetes node IP configuration
        :param str port: Port of the Kubernetes node.
        :param str ip_address: IP address of the Kubernetes node.
        """
        pulumi.set(__self__, "port", port)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)

    @property
    @pulumi.getter
    def port(self) -> str:
        """
        Port of the Kubernetes node.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[str]:
        """
        IP address of the Kubernetes node.
        """
        return pulumi.get(self, "ip_address")


@pulumi.output_type
class KubernetesRoleComputeResponse(dict):
    """
    Kubernetes role compute resource
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "hugePage1G":
            suggest = "huge_page1_g"
        elif key == "hugePage2M":
            suggest = "huge_page2_m"
        elif key == "memoryInBytes":
            suggest = "memory_in_bytes"
        elif key == "processorCount":
            suggest = "processor_count"
        elif key == "vmProfile":
            suggest = "vm_profile"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KubernetesRoleComputeResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KubernetesRoleComputeResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KubernetesRoleComputeResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 huge_page1_g: int,
                 huge_page2_m: int,
                 memory_in_bytes: float,
                 processor_count: int,
                 vm_profile: str):
        """
        Kubernetes role compute resource
        :param int huge_page1_g: Count of huge pages
        :param int huge_page2_m: Count of huge pages
        :param float memory_in_bytes: Memory in bytes
        :param int processor_count: Processor count
        :param str vm_profile: VM profile
        """
        pulumi.set(__self__, "huge_page1_g", huge_page1_g)
        pulumi.set(__self__, "huge_page2_m", huge_page2_m)
        pulumi.set(__self__, "memory_in_bytes", memory_in_bytes)
        pulumi.set(__self__, "processor_count", processor_count)
        pulumi.set(__self__, "vm_profile", vm_profile)

    @property
    @pulumi.getter(name="hugePage1G")
    def huge_page1_g(self) -> int:
        """
        Count of huge pages
        """
        return pulumi.get(self, "huge_page1_g")

    @property
    @pulumi.getter(name="hugePage2M")
    def huge_page2_m(self) -> int:
        """
        Count of huge pages
        """
        return pulumi.get(self, "huge_page2_m")

    @property
    @pulumi.getter(name="memoryInBytes")
    def memory_in_bytes(self) -> float:
        """
        Memory in bytes
        """
        return pulumi.get(self, "memory_in_bytes")

    @property
    @pulumi.getter(name="processorCount")
    def processor_count(self) -> int:
        """
        Processor count
        """
        return pulumi.get(self, "processor_count")

    @property
    @pulumi.getter(name="vmProfile")
    def vm_profile(self) -> str:
        """
        VM profile
        """
        return pulumi.get(self, "vm_profile")


@pulumi.output_type
class KubernetesRoleNetworkResponse(dict):
    """
    Kubernetes role network resource
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cniConfig":
            suggest = "cni_config"
        elif key == "loadBalancerConfig":
            suggest = "load_balancer_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KubernetesRoleNetworkResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KubernetesRoleNetworkResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KubernetesRoleNetworkResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cni_config: 'outputs.CniConfigResponse',
                 load_balancer_config: 'outputs.LoadBalancerConfigResponse'):
        """
        Kubernetes role network resource
        :param 'CniConfigResponse' cni_config: Cni configuration
        :param 'LoadBalancerConfigResponse' load_balancer_config: Load balancer configuration
        """
        pulumi.set(__self__, "cni_config", cni_config)
        pulumi.set(__self__, "load_balancer_config", load_balancer_config)

    @property
    @pulumi.getter(name="cniConfig")
    def cni_config(self) -> 'outputs.CniConfigResponse':
        """
        Cni configuration
        """
        return pulumi.get(self, "cni_config")

    @property
    @pulumi.getter(name="loadBalancerConfig")
    def load_balancer_config(self) -> 'outputs.LoadBalancerConfigResponse':
        """
        Load balancer configuration
        """
        return pulumi.get(self, "load_balancer_config")


@pulumi.output_type
class KubernetesRoleResourcesResponse(dict):
    """
    Kubernetes role resources
    """
    def __init__(__self__, *,
                 compute: 'outputs.KubernetesRoleComputeResponse',
                 network: 'outputs.KubernetesRoleNetworkResponse',
                 storage: Optional['outputs.KubernetesRoleStorageResponse'] = None):
        """
        Kubernetes role resources
        :param 'KubernetesRoleComputeResponse' compute: Kubernetes role compute resource
        :param 'KubernetesRoleNetworkResponse' network: Kubernetes role network resource
        :param 'KubernetesRoleStorageResponse' storage: Kubernetes role storage resource
        """
        pulumi.set(__self__, "compute", compute)
        pulumi.set(__self__, "network", network)
        if storage is not None:
            pulumi.set(__self__, "storage", storage)

    @property
    @pulumi.getter
    def compute(self) -> 'outputs.KubernetesRoleComputeResponse':
        """
        Kubernetes role compute resource
        """
        return pulumi.get(self, "compute")

    @property
    @pulumi.getter
    def network(self) -> 'outputs.KubernetesRoleNetworkResponse':
        """
        Kubernetes role network resource
        """
        return pulumi.get(self, "network")

    @property
    @pulumi.getter
    def storage(self) -> Optional['outputs.KubernetesRoleStorageResponse']:
        """
        Kubernetes role storage resource
        """
        return pulumi.get(self, "storage")


@pulumi.output_type
class KubernetesRoleStorageClassInfoResponse(dict):
    """
    Kubernetes storage class info.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "posixCompliant":
            suggest = "posix_compliant"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KubernetesRoleStorageClassInfoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KubernetesRoleStorageClassInfoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KubernetesRoleStorageClassInfoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 posix_compliant: str,
                 type: str):
        """
        Kubernetes storage class info.
        :param str name: Storage class name.
        :param str posix_compliant: If provisioned storage is posix compliant.
        :param str type: Storage class type.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "posix_compliant", posix_compliant)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Storage class name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="posixCompliant")
    def posix_compliant(self) -> str:
        """
        If provisioned storage is posix compliant.
        """
        return pulumi.get(self, "posix_compliant")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Storage class type.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class KubernetesRoleStorageResponse(dict):
    """
    Kubernetes role storage resource
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "storageClasses":
            suggest = "storage_classes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KubernetesRoleStorageResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KubernetesRoleStorageResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KubernetesRoleStorageResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 storage_classes: Sequence['outputs.KubernetesRoleStorageClassInfoResponse'],
                 endpoints: Optional[Sequence['outputs.MountPointMapResponse']] = None):
        """
        Kubernetes role storage resource
        :param Sequence['KubernetesRoleStorageClassInfoResponse'] storage_classes: Kubernetes storage class info.
        :param Sequence['MountPointMapResponse'] endpoints: Mount points of shares in role(s).
        """
        pulumi.set(__self__, "storage_classes", storage_classes)
        if endpoints is not None:
            pulumi.set(__self__, "endpoints", endpoints)

    @property
    @pulumi.getter(name="storageClasses")
    def storage_classes(self) -> Sequence['outputs.KubernetesRoleStorageClassInfoResponse']:
        """
        Kubernetes storage class info.
        """
        return pulumi.get(self, "storage_classes")

    @property
    @pulumi.getter
    def endpoints(self) -> Optional[Sequence['outputs.MountPointMapResponse']]:
        """
        Mount points of shares in role(s).
        """
        return pulumi.get(self, "endpoints")


@pulumi.output_type
class LoadBalancerConfigResponse(dict):
    """
    Load balancer configuration
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "componentType":
            suggest = "component_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LoadBalancerConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LoadBalancerConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LoadBalancerConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 component_type: str,
                 type: str,
                 version: str):
        """
        Load balancer configuration
        :param str component_type: ComponentType of the Kubernetes node.
        :param str type: Load balancer type
        :param str version: Load balancer version
        """
        pulumi.set(__self__, "component_type", component_type)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="componentType")
    def component_type(self) -> str:
        """
        ComponentType of the Kubernetes node.
        """
        return pulumi.get(self, "component_type")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Load balancer type
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        Load balancer version
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class MetricConfigurationResponse(dict):
    """
    Metric configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "counterSets":
            suggest = "counter_sets"
        elif key == "resourceId":
            suggest = "resource_id"
        elif key == "mdmAccount":
            suggest = "mdm_account"
        elif key == "metricNameSpace":
            suggest = "metric_name_space"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MetricConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MetricConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MetricConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 counter_sets: Sequence['outputs.MetricCounterSetResponse'],
                 resource_id: str,
                 mdm_account: Optional[str] = None,
                 metric_name_space: Optional[str] = None):
        """
        Metric configuration.
        :param Sequence['MetricCounterSetResponse'] counter_sets: Host name for the IoT hub associated to the device.
        :param str resource_id: The Resource ID on which the metrics should be pushed.
        :param str mdm_account: The MDM account to which the counters should be pushed.
        :param str metric_name_space: The MDM namespace to which the counters should be pushed. This is required if MDMAccount is specified
        """
        pulumi.set(__self__, "counter_sets", counter_sets)
        pulumi.set(__self__, "resource_id", resource_id)
        if mdm_account is not None:
            pulumi.set(__self__, "mdm_account", mdm_account)
        if metric_name_space is not None:
            pulumi.set(__self__, "metric_name_space", metric_name_space)

    @property
    @pulumi.getter(name="counterSets")
    def counter_sets(self) -> Sequence['outputs.MetricCounterSetResponse']:
        """
        Host name for the IoT hub associated to the device.
        """
        return pulumi.get(self, "counter_sets")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> str:
        """
        The Resource ID on which the metrics should be pushed.
        """
        return pulumi.get(self, "resource_id")

    @property
    @pulumi.getter(name="mdmAccount")
    def mdm_account(self) -> Optional[str]:
        """
        The MDM account to which the counters should be pushed.
        """
        return pulumi.get(self, "mdm_account")

    @property
    @pulumi.getter(name="metricNameSpace")
    def metric_name_space(self) -> Optional[str]:
        """
        The MDM namespace to which the counters should be pushed. This is required if MDMAccount is specified
        """
        return pulumi.get(self, "metric_name_space")


@pulumi.output_type
class MetricCounterResponse(dict):
    """
    The metric counter
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "additionalDimensions":
            suggest = "additional_dimensions"
        elif key == "dimensionFilter":
            suggest = "dimension_filter"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MetricCounterResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MetricCounterResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MetricCounterResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 additional_dimensions: Optional[Sequence['outputs.MetricDimensionResponse']] = None,
                 dimension_filter: Optional[Sequence['outputs.MetricDimensionResponse']] = None,
                 instance: Optional[str] = None):
        """
        The metric counter
        :param str name: The counter name.
        :param Sequence['MetricDimensionResponse'] additional_dimensions: The additional dimensions to be added to metric.
        :param Sequence['MetricDimensionResponse'] dimension_filter: The dimension filter.
        :param str instance: The instance from which counter should be collected.
        """
        pulumi.set(__self__, "name", name)
        if additional_dimensions is not None:
            pulumi.set(__self__, "additional_dimensions", additional_dimensions)
        if dimension_filter is not None:
            pulumi.set(__self__, "dimension_filter", dimension_filter)
        if instance is not None:
            pulumi.set(__self__, "instance", instance)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The counter name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="additionalDimensions")
    def additional_dimensions(self) -> Optional[Sequence['outputs.MetricDimensionResponse']]:
        """
        The additional dimensions to be added to metric.
        """
        return pulumi.get(self, "additional_dimensions")

    @property
    @pulumi.getter(name="dimensionFilter")
    def dimension_filter(self) -> Optional[Sequence['outputs.MetricDimensionResponse']]:
        """
        The dimension filter.
        """
        return pulumi.get(self, "dimension_filter")

    @property
    @pulumi.getter
    def instance(self) -> Optional[str]:
        """
        The instance from which counter should be collected.
        """
        return pulumi.get(self, "instance")


@pulumi.output_type
class MetricCounterSetResponse(dict):
    """
    The metric counter set
    """
    def __init__(__self__, *,
                 counters: Sequence['outputs.MetricCounterResponse']):
        """
        The metric counter set
        :param Sequence['MetricCounterResponse'] counters: The counters that should be collected in this set.
        """
        pulumi.set(__self__, "counters", counters)

    @property
    @pulumi.getter
    def counters(self) -> Sequence['outputs.MetricCounterResponse']:
        """
        The counters that should be collected in this set.
        """
        return pulumi.get(self, "counters")


@pulumi.output_type
class MetricDimensionResponse(dict):
    """
    The metric dimension
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceName":
            suggest = "source_name"
        elif key == "sourceType":
            suggest = "source_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MetricDimensionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MetricDimensionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MetricDimensionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 source_name: str,
                 source_type: str):
        """
        The metric dimension
        :param str source_name: The dimension value.
        :param str source_type: The dimension type.
        """
        pulumi.set(__self__, "source_name", source_name)
        pulumi.set(__self__, "source_type", source_type)

    @property
    @pulumi.getter(name="sourceName")
    def source_name(self) -> str:
        """
        The dimension value.
        """
        return pulumi.get(self, "source_name")

    @property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> str:
        """
        The dimension type.
        """
        return pulumi.get(self, "source_type")


@pulumi.output_type
class MountPointMapResponse(dict):
    """
    The share mount point.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "mountPoint":
            suggest = "mount_point"
        elif key == "mountType":
            suggest = "mount_type"
        elif key == "roleId":
            suggest = "role_id"
        elif key == "roleType":
            suggest = "role_type"
        elif key == "shareId":
            suggest = "share_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MountPointMapResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MountPointMapResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MountPointMapResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 mount_point: str,
                 mount_type: str,
                 role_id: str,
                 role_type: str,
                 share_id: str):
        """
        The share mount point.
        :param str mount_point: Mount point for the share.
        :param str mount_type: Mounting type.
        :param str role_id: ID of the role to which share is mounted.
        :param str role_type: Role type.
        :param str share_id: ID of the share mounted to the role VM.
        """
        pulumi.set(__self__, "mount_point", mount_point)
        pulumi.set(__self__, "mount_type", mount_type)
        pulumi.set(__self__, "role_id", role_id)
        pulumi.set(__self__, "role_type", role_type)
        pulumi.set(__self__, "share_id", share_id)

    @property
    @pulumi.getter(name="mountPoint")
    def mount_point(self) -> str:
        """
        Mount point for the share.
        """
        return pulumi.get(self, "mount_point")

    @property
    @pulumi.getter(name="mountType")
    def mount_type(self) -> str:
        """
        Mounting type.
        """
        return pulumi.get(self, "mount_type")

    @property
    @pulumi.getter(name="roleId")
    def role_id(self) -> str:
        """
        ID of the role to which share is mounted.
        """
        return pulumi.get(self, "role_id")

    @property
    @pulumi.getter(name="roleType")
    def role_type(self) -> str:
        """
        Role type.
        """
        return pulumi.get(self, "role_type")

    @property
    @pulumi.getter(name="shareId")
    def share_id(self) -> str:
        """
        ID of the share mounted to the role VM.
        """
        return pulumi.get(self, "share_id")


@pulumi.output_type
class NodeInfoResponse(dict):
    """
    Kubernetes node info
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "componentType":
            suggest = "component_type"
        elif key == "ipConfiguration":
            suggest = "ip_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NodeInfoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NodeInfoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NodeInfoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 component_type: str,
                 name: str,
                 type: str,
                 ip_configuration: Optional[Sequence['outputs.KubernetesIPConfigurationResponse']] = None):
        """
        Kubernetes node info
        :param str component_type: ComponentType of the Kubernetes node.
        :param str name: Node name.
        :param str type: Node type - Master/Worker
        :param Sequence['KubernetesIPConfigurationResponse'] ip_configuration: IP Configuration of the Kubernetes node.
        """
        pulumi.set(__self__, "component_type", component_type)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)
        if ip_configuration is not None:
            pulumi.set(__self__, "ip_configuration", ip_configuration)

    @property
    @pulumi.getter(name="componentType")
    def component_type(self) -> str:
        """
        ComponentType of the Kubernetes node.
        """
        return pulumi.get(self, "component_type")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Node name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Node type - Master/Worker
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="ipConfiguration")
    def ip_configuration(self) -> Optional[Sequence['outputs.KubernetesIPConfigurationResponse']]:
        """
        IP Configuration of the Kubernetes node.
        """
        return pulumi.get(self, "ip_configuration")


@pulumi.output_type
class OrderStatusResponse(dict):
    """
    Represents a single status change.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "additionalOrderDetails":
            suggest = "additional_order_details"
        elif key == "trackingInformation":
            suggest = "tracking_information"
        elif key == "updateDateTime":
            suggest = "update_date_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OrderStatusResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OrderStatusResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OrderStatusResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 additional_order_details: Mapping[str, str],
                 status: str,
                 tracking_information: 'outputs.TrackingInfoResponse',
                 update_date_time: str,
                 comments: Optional[str] = None):
        """
        Represents a single status change.
        :param Mapping[str, str] additional_order_details: Dictionary to hold generic information which is not stored
               by the already existing properties
        :param str status: Status of the order as per the allowed status types.
        :param 'TrackingInfoResponse' tracking_information: Tracking information related to the state in the ordering flow
        :param str update_date_time: Time of status update.
        :param str comments: Comments related to this status change.
        """
        pulumi.set(__self__, "additional_order_details", additional_order_details)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "tracking_information", tracking_information)
        pulumi.set(__self__, "update_date_time", update_date_time)
        if comments is not None:
            pulumi.set(__self__, "comments", comments)

    @property
    @pulumi.getter(name="additionalOrderDetails")
    def additional_order_details(self) -> Mapping[str, str]:
        """
        Dictionary to hold generic information which is not stored
        by the already existing properties
        """
        return pulumi.get(self, "additional_order_details")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Status of the order as per the allowed status types.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="trackingInformation")
    def tracking_information(self) -> 'outputs.TrackingInfoResponse':
        """
        Tracking information related to the state in the ordering flow
        """
        return pulumi.get(self, "tracking_information")

    @property
    @pulumi.getter(name="updateDateTime")
    def update_date_time(self) -> str:
        """
        Time of status update.
        """
        return pulumi.get(self, "update_date_time")

    @property
    @pulumi.getter
    def comments(self) -> Optional[str]:
        """
        Comments related to this status change.
        """
        return pulumi.get(self, "comments")


@pulumi.output_type
class PeriodicTimerSourceInfoResponse(dict):
    """
    Periodic timer event source.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "startTime":
            suggest = "start_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PeriodicTimerSourceInfoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PeriodicTimerSourceInfoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PeriodicTimerSourceInfoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 schedule: str,
                 start_time: str,
                 topic: Optional[str] = None):
        """
        Periodic timer event source.
        :param str schedule: Periodic frequency at which timer event needs to be raised. Supports daily, hourly, minutes, and seconds.
        :param str start_time: The time of the day that results in a valid trigger. Schedule is computed with reference to the time specified upto seconds. If timezone is not specified the time will considered to be in device timezone. The value will always be returned as UTC time.
        :param str topic: Topic where periodic events are published to IoT device.
        """
        pulumi.set(__self__, "schedule", schedule)
        pulumi.set(__self__, "start_time", start_time)
        if topic is not None:
            pulumi.set(__self__, "topic", topic)

    @property
    @pulumi.getter
    def schedule(self) -> str:
        """
        Periodic frequency at which timer event needs to be raised. Supports daily, hourly, minutes, and seconds.
        """
        return pulumi.get(self, "schedule")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> str:
        """
        The time of the day that results in a valid trigger. Schedule is computed with reference to the time specified upto seconds. If timezone is not specified the time will considered to be in device timezone. The value will always be returned as UTC time.
        """
        return pulumi.get(self, "start_time")

    @property
    @pulumi.getter
    def topic(self) -> Optional[str]:
        """
        Topic where periodic events are published to IoT device.
        """
        return pulumi.get(self, "topic")


@pulumi.output_type
class RefreshDetailsResponse(dict):
    """
    Fields for tracking refresh job on the share or container.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "errorManifestFile":
            suggest = "error_manifest_file"
        elif key == "inProgressRefreshJobId":
            suggest = "in_progress_refresh_job_id"
        elif key == "lastCompletedRefreshJobTimeInUTC":
            suggest = "last_completed_refresh_job_time_in_utc"
        elif key == "lastJob":
            suggest = "last_job"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RefreshDetailsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RefreshDetailsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RefreshDetailsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 error_manifest_file: Optional[str] = None,
                 in_progress_refresh_job_id: Optional[str] = None,
                 last_completed_refresh_job_time_in_utc: Optional[str] = None,
                 last_job: Optional[str] = None):
        """
        Fields for tracking refresh job on the share or container.
        :param str error_manifest_file: Indicates the relative path of the error xml for the last refresh job on this particular share or container, if any. This could be a failed job or a successful job.
        :param str in_progress_refresh_job_id: If a refresh job is currently in progress on this share or container, this field indicates the ARM resource ID of that job. The field is empty if no job is in progress.
        :param str last_completed_refresh_job_time_in_utc: Indicates the completed time for the last refresh job on this particular share or container, if any.This could be a failed job or a successful job.
        :param str last_job: Indicates the id of the last refresh job on this particular share or container,if any. This could be a failed job or a successful job.
        """
        if error_manifest_file is not None:
            pulumi.set(__self__, "error_manifest_file", error_manifest_file)
        if in_progress_refresh_job_id is not None:
            pulumi.set(__self__, "in_progress_refresh_job_id", in_progress_refresh_job_id)
        if last_completed_refresh_job_time_in_utc is not None:
            pulumi.set(__self__, "last_completed_refresh_job_time_in_utc", last_completed_refresh_job_time_in_utc)
        if last_job is not None:
            pulumi.set(__self__, "last_job", last_job)

    @property
    @pulumi.getter(name="errorManifestFile")
    def error_manifest_file(self) -> Optional[str]:
        """
        Indicates the relative path of the error xml for the last refresh job on this particular share or container, if any. This could be a failed job or a successful job.
        """
        return pulumi.get(self, "error_manifest_file")

    @property
    @pulumi.getter(name="inProgressRefreshJobId")
    def in_progress_refresh_job_id(self) -> Optional[str]:
        """
        If a refresh job is currently in progress on this share or container, this field indicates the ARM resource ID of that job. The field is empty if no job is in progress.
        """
        return pulumi.get(self, "in_progress_refresh_job_id")

    @property
    @pulumi.getter(name="lastCompletedRefreshJobTimeInUTC")
    def last_completed_refresh_job_time_in_utc(self) -> Optional[str]:
        """
        Indicates the completed time for the last refresh job on this particular share or container, if any.This could be a failed job or a successful job.
        """
        return pulumi.get(self, "last_completed_refresh_job_time_in_utc")

    @property
    @pulumi.getter(name="lastJob")
    def last_job(self) -> Optional[str]:
        """
        Indicates the id of the last refresh job on this particular share or container,if any. This could be a failed job or a successful job.
        """
        return pulumi.get(self, "last_job")


@pulumi.output_type
class ResourceIdentityResponse(dict):
    """
    Msi identity details of the resource
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "principalId":
            suggest = "principal_id"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourceIdentityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourceIdentityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourceIdentityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 principal_id: str,
                 tenant_id: str,
                 type: Optional[str] = None):
        """
        Msi identity details of the resource
        :param str principal_id: Service Principal Id backing the Msi
        :param str tenant_id: Home Tenant Id
        :param str type: Identity type
        """
        pulumi.set(__self__, "principal_id", principal_id)
        pulumi.set(__self__, "tenant_id", tenant_id)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> str:
        """
        Service Principal Id backing the Msi
        """
        return pulumi.get(self, "principal_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> str:
        """
        Home Tenant Id
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        Identity type
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ResourceMoveDetailsResponse(dict):
    """
    Fields for tracking resource move
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "operationInProgress":
            suggest = "operation_in_progress"
        elif key == "operationInProgressLockTimeoutInUTC":
            suggest = "operation_in_progress_lock_timeout_in_utc"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourceMoveDetailsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourceMoveDetailsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourceMoveDetailsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 operation_in_progress: Optional[str] = None,
                 operation_in_progress_lock_timeout_in_utc: Optional[str] = None):
        """
        Fields for tracking resource move
        :param str operation_in_progress: Denotes whether move operation is in progress
        :param str operation_in_progress_lock_timeout_in_utc: Denotes the timeout of the operation to finish
        """
        if operation_in_progress is not None:
            pulumi.set(__self__, "operation_in_progress", operation_in_progress)
        if operation_in_progress_lock_timeout_in_utc is not None:
            pulumi.set(__self__, "operation_in_progress_lock_timeout_in_utc", operation_in_progress_lock_timeout_in_utc)

    @property
    @pulumi.getter(name="operationInProgress")
    def operation_in_progress(self) -> Optional[str]:
        """
        Denotes whether move operation is in progress
        """
        return pulumi.get(self, "operation_in_progress")

    @property
    @pulumi.getter(name="operationInProgressLockTimeoutInUTC")
    def operation_in_progress_lock_timeout_in_utc(self) -> Optional[str]:
        """
        Denotes the timeout of the operation to finish
        """
        return pulumi.get(self, "operation_in_progress_lock_timeout_in_utc")


@pulumi.output_type
class RoleSinkInfoResponse(dict):
    """
    Compute role against which events will be raised.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "roleId":
            suggest = "role_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RoleSinkInfoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RoleSinkInfoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RoleSinkInfoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 role_id: str):
        """
        Compute role against which events will be raised.
        :param str role_id: Compute role ID.
        """
        pulumi.set(__self__, "role_id", role_id)

    @property
    @pulumi.getter(name="roleId")
    def role_id(self) -> str:
        """
        Compute role ID.
        """
        return pulumi.get(self, "role_id")


@pulumi.output_type
class SecretResponse(dict):
    """
    Holds device secret either as a KeyVault reference or as an encrypted value.
    """
    def __init__(__self__, *,
                 encrypted_secret: Optional['outputs.AsymmetricEncryptedSecretResponse'] = None,
                 key_vault_id: Optional[str] = None):
        """
        Holds device secret either as a KeyVault reference or as an encrypted value.
        :param 'AsymmetricEncryptedSecretResponse' encrypted_secret: Encrypted (using device public key) secret value.
        :param str key_vault_id: Id of the Key-Vault where secret is stored (ex: secrets/AuthClientSecret/82ef4346187a4033a10d629cde07d740).
        """
        if encrypted_secret is not None:
            pulumi.set(__self__, "encrypted_secret", encrypted_secret)
        if key_vault_id is not None:
            pulumi.set(__self__, "key_vault_id", key_vault_id)

    @property
    @pulumi.getter(name="encryptedSecret")
    def encrypted_secret(self) -> Optional['outputs.AsymmetricEncryptedSecretResponse']:
        """
        Encrypted (using device public key) secret value.
        """
        return pulumi.get(self, "encrypted_secret")

    @property
    @pulumi.getter(name="keyVaultId")
    def key_vault_id(self) -> Optional[str]:
        """
        Id of the Key-Vault where secret is stored (ex: secrets/AuthClientSecret/82ef4346187a4033a10d629cde07d740).
        """
        return pulumi.get(self, "key_vault_id")


@pulumi.output_type
class ShareAccessRightResponse(dict):
    """
    Specifies the mapping between this particular user and the type of access he has on shares on this device.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessType":
            suggest = "access_type"
        elif key == "shareId":
            suggest = "share_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ShareAccessRightResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ShareAccessRightResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ShareAccessRightResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_type: str,
                 share_id: str):
        """
        Specifies the mapping between this particular user and the type of access he has on shares on this device.
        :param str access_type: Type of access to be allowed on the share for this user.
        :param str share_id: The share ID.
        """
        pulumi.set(__self__, "access_type", access_type)
        pulumi.set(__self__, "share_id", share_id)

    @property
    @pulumi.getter(name="accessType")
    def access_type(self) -> str:
        """
        Type of access to be allowed on the share for this user.
        """
        return pulumi.get(self, "access_type")

    @property
    @pulumi.getter(name="shareId")
    def share_id(self) -> str:
        """
        The share ID.
        """
        return pulumi.get(self, "share_id")


@pulumi.output_type
class SkuResponse(dict):
    """
    The SKU type.
    """
    def __init__(__self__, *,
                 name: Optional[str] = None,
                 tier: Optional[str] = None):
        """
        The SKU type.
        :param str name: SKU name.
        :param str tier: The SKU tier. This is based on the SKU name.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tier is not None:
            pulumi.set(__self__, "tier", tier)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        SKU name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def tier(self) -> Optional[str]:
        """
        The SKU tier. This is based on the SKU name.
        """
        return pulumi.get(self, "tier")


@pulumi.output_type
class SubscriptionRegisteredFeaturesResponse(dict):
    def __init__(__self__, *,
                 name: Optional[str] = None,
                 state: Optional[str] = None):
        if name is not None:
            pulumi.set(__self__, "name", name)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        return pulumi.get(self, "state")


@pulumi.output_type
class SymmetricKeyResponse(dict):
    """
    Symmetric key for authentication.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "connectionString":
            suggest = "connection_string"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SymmetricKeyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SymmetricKeyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SymmetricKeyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 connection_string: Optional['outputs.AsymmetricEncryptedSecretResponse'] = None):
        """
        Symmetric key for authentication.
        :param 'AsymmetricEncryptedSecretResponse' connection_string: Connection string based on the symmetric key.
        """
        if connection_string is not None:
            pulumi.set(__self__, "connection_string", connection_string)

    @property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> Optional['outputs.AsymmetricEncryptedSecretResponse']:
        """
        Connection string based on the symmetric key.
        """
        return pulumi.get(self, "connection_string")


@pulumi.output_type
class SystemDataResponse(dict):
    """
    Metadata pertaining to creation and last modification of the resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createdAt":
            suggest = "created_at"
        elif key == "createdBy":
            suggest = "created_by"
        elif key == "createdByType":
            suggest = "created_by_type"
        elif key == "lastModifiedAt":
            suggest = "last_modified_at"
        elif key == "lastModifiedBy":
            suggest = "last_modified_by"
        elif key == "lastModifiedByType":
            suggest = "last_modified_by_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SystemDataResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SystemDataResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SystemDataResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 created_at: Optional[str] = None,
                 created_by: Optional[str] = None,
                 created_by_type: Optional[str] = None,
                 last_modified_at: Optional[str] = None,
                 last_modified_by: Optional[str] = None,
                 last_modified_by_type: Optional[str] = None):
        """
        Metadata pertaining to creation and last modification of the resource.
        :param str created_at: The timestamp of resource creation (UTC).
        :param str created_by: The identity that created the resource.
        :param str created_by_type: The type of identity that created the resource.
        :param str last_modified_at: The timestamp of resource last modification (UTC)
        :param str last_modified_by: The identity that last modified the resource.
        :param str last_modified_by_type: The type of identity that last modified the resource.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if created_by_type is not None:
            pulumi.set(__self__, "created_by_type", created_by_type)
        if last_modified_at is not None:
            pulumi.set(__self__, "last_modified_at", last_modified_at)
        if last_modified_by is not None:
            pulumi.set(__self__, "last_modified_by", last_modified_by)
        if last_modified_by_type is not None:
            pulumi.set(__self__, "last_modified_by_type", last_modified_by_type)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[str]:
        """
        The timestamp of resource creation (UTC).
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[str]:
        """
        The identity that created the resource.
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter(name="createdByType")
    def created_by_type(self) -> Optional[str]:
        """
        The type of identity that created the resource.
        """
        return pulumi.get(self, "created_by_type")

    @property
    @pulumi.getter(name="lastModifiedAt")
    def last_modified_at(self) -> Optional[str]:
        """
        The timestamp of resource last modification (UTC)
        """
        return pulumi.get(self, "last_modified_at")

    @property
    @pulumi.getter(name="lastModifiedBy")
    def last_modified_by(self) -> Optional[str]:
        """
        The identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by")

    @property
    @pulumi.getter(name="lastModifiedByType")
    def last_modified_by_type(self) -> Optional[str]:
        """
        The type of identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by_type")


@pulumi.output_type
class TrackingInfoResponse(dict):
    """
    Tracking courier information.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "carrierName":
            suggest = "carrier_name"
        elif key == "serialNumber":
            suggest = "serial_number"
        elif key == "trackingId":
            suggest = "tracking_id"
        elif key == "trackingUrl":
            suggest = "tracking_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TrackingInfoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TrackingInfoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TrackingInfoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 carrier_name: Optional[str] = None,
                 serial_number: Optional[str] = None,
                 tracking_id: Optional[str] = None,
                 tracking_url: Optional[str] = None):
        """
        Tracking courier information.
        :param str carrier_name: Name of the carrier used in the delivery.
        :param str serial_number: Serial number of the device being tracked.
        :param str tracking_id: Tracking ID of the shipment.
        :param str tracking_url: Tracking URL of the shipment.
        """
        if carrier_name is not None:
            pulumi.set(__self__, "carrier_name", carrier_name)
        if serial_number is not None:
            pulumi.set(__self__, "serial_number", serial_number)
        if tracking_id is not None:
            pulumi.set(__self__, "tracking_id", tracking_id)
        if tracking_url is not None:
            pulumi.set(__self__, "tracking_url", tracking_url)

    @property
    @pulumi.getter(name="carrierName")
    def carrier_name(self) -> Optional[str]:
        """
        Name of the carrier used in the delivery.
        """
        return pulumi.get(self, "carrier_name")

    @property
    @pulumi.getter(name="serialNumber")
    def serial_number(self) -> Optional[str]:
        """
        Serial number of the device being tracked.
        """
        return pulumi.get(self, "serial_number")

    @property
    @pulumi.getter(name="trackingId")
    def tracking_id(self) -> Optional[str]:
        """
        Tracking ID of the shipment.
        """
        return pulumi.get(self, "tracking_id")

    @property
    @pulumi.getter(name="trackingUrl")
    def tracking_url(self) -> Optional[str]:
        """
        Tracking URL of the shipment.
        """
        return pulumi.get(self, "tracking_url")


@pulumi.output_type
class UserAccessRightResponse(dict):
    """
    The mapping between a particular user and the access type on the SMB share.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessType":
            suggest = "access_type"
        elif key == "userId":
            suggest = "user_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserAccessRightResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserAccessRightResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserAccessRightResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_type: str,
                 user_id: str):
        """
        The mapping between a particular user and the access type on the SMB share.
        :param str access_type: Type of access to be allowed for the user.
        :param str user_id: User ID (already existing in the device).
        """
        pulumi.set(__self__, "access_type", access_type)
        pulumi.set(__self__, "user_id", user_id)

    @property
    @pulumi.getter(name="accessType")
    def access_type(self) -> str:
        """
        Type of access to be allowed for the user.
        """
        return pulumi.get(self, "access_type")

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> str:
        """
        User ID (already existing in the device).
        """
        return pulumi.get(self, "user_id")


