# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'BotPropertiesArgs',
    'ConnectionSettingParameterArgs',
    'ConnectionSettingPropertiesArgs',
    'DirectLineChannelPropertiesArgs',
    'DirectLineChannelArgs',
    'DirectLineSiteArgs',
    'EmailChannelPropertiesArgs',
    'EmailChannelArgs',
    'FacebookChannelPropertiesArgs',
    'FacebookChannelArgs',
    'FacebookPageArgs',
    'KikChannelPropertiesArgs',
    'KikChannelArgs',
    'MsTeamsChannelPropertiesArgs',
    'MsTeamsChannelArgs',
    'SkuArgs',
    'SkypeChannelPropertiesArgs',
    'SkypeChannelArgs',
    'SlackChannelPropertiesArgs',
    'SlackChannelArgs',
    'SmsChannelPropertiesArgs',
    'SmsChannelArgs',
    'TelegramChannelPropertiesArgs',
    'TelegramChannelArgs',
    'WebChatChannelPropertiesArgs',
    'WebChatChannelArgs',
    'WebChatSiteArgs',
]

@pulumi.input_type
class BotPropertiesArgs:
    def __init__(__self__, *,
                 display_name: pulumi.Input[str],
                 endpoint: pulumi.Input[str],
                 msa_app_id: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 developer_app_insight_key: Optional[pulumi.Input[str]] = None,
                 developer_app_insights_api_key: Optional[pulumi.Input[str]] = None,
                 developer_app_insights_application_id: Optional[pulumi.Input[str]] = None,
                 icon_url: Optional[pulumi.Input[str]] = None,
                 luis_app_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 luis_key: Optional[pulumi.Input[str]] = None):
        """
        The parameters to provide for the Bot.
        :param pulumi.Input[str] display_name: The Name of the bot
        :param pulumi.Input[str] endpoint: The bot's endpoint
        :param pulumi.Input[str] msa_app_id: Microsoft App Id for the bot
        :param pulumi.Input[str] description: The description of the bot
        :param pulumi.Input[str] developer_app_insight_key: The Application Insights key
        :param pulumi.Input[str] developer_app_insights_api_key: The Application Insights Api Key
        :param pulumi.Input[str] developer_app_insights_application_id: The Application Insights App Id
        :param pulumi.Input[str] icon_url: The Icon Url of the bot
        :param pulumi.Input[Sequence[pulumi.Input[str]]] luis_app_ids: Collection of LUIS App Ids
        :param pulumi.Input[str] luis_key: The LUIS Key
        """
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "endpoint", endpoint)
        pulumi.set(__self__, "msa_app_id", msa_app_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if developer_app_insight_key is not None:
            pulumi.set(__self__, "developer_app_insight_key", developer_app_insight_key)
        if developer_app_insights_api_key is not None:
            pulumi.set(__self__, "developer_app_insights_api_key", developer_app_insights_api_key)
        if developer_app_insights_application_id is not None:
            pulumi.set(__self__, "developer_app_insights_application_id", developer_app_insights_application_id)
        if icon_url is not None:
            pulumi.set(__self__, "icon_url", icon_url)
        if luis_app_ids is not None:
            pulumi.set(__self__, "luis_app_ids", luis_app_ids)
        if luis_key is not None:
            pulumi.set(__self__, "luis_key", luis_key)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[str]:
        """
        The Name of the bot
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def endpoint(self) -> pulumi.Input[str]:
        """
        The bot's endpoint
        """
        return pulumi.get(self, "endpoint")

    @endpoint.setter
    def endpoint(self, value: pulumi.Input[str]):
        pulumi.set(self, "endpoint", value)

    @property
    @pulumi.getter(name="msaAppId")
    def msa_app_id(self) -> pulumi.Input[str]:
        """
        Microsoft App Id for the bot
        """
        return pulumi.get(self, "msa_app_id")

    @msa_app_id.setter
    def msa_app_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "msa_app_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the bot
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="developerAppInsightKey")
    def developer_app_insight_key(self) -> Optional[pulumi.Input[str]]:
        """
        The Application Insights key
        """
        return pulumi.get(self, "developer_app_insight_key")

    @developer_app_insight_key.setter
    def developer_app_insight_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "developer_app_insight_key", value)

    @property
    @pulumi.getter(name="developerAppInsightsApiKey")
    def developer_app_insights_api_key(self) -> Optional[pulumi.Input[str]]:
        """
        The Application Insights Api Key
        """
        return pulumi.get(self, "developer_app_insights_api_key")

    @developer_app_insights_api_key.setter
    def developer_app_insights_api_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "developer_app_insights_api_key", value)

    @property
    @pulumi.getter(name="developerAppInsightsApplicationId")
    def developer_app_insights_application_id(self) -> Optional[pulumi.Input[str]]:
        """
        The Application Insights App Id
        """
        return pulumi.get(self, "developer_app_insights_application_id")

    @developer_app_insights_application_id.setter
    def developer_app_insights_application_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "developer_app_insights_application_id", value)

    @property
    @pulumi.getter(name="iconUrl")
    def icon_url(self) -> Optional[pulumi.Input[str]]:
        """
        The Icon Url of the bot
        """
        return pulumi.get(self, "icon_url")

    @icon_url.setter
    def icon_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "icon_url", value)

    @property
    @pulumi.getter(name="luisAppIds")
    def luis_app_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Collection of LUIS App Ids
        """
        return pulumi.get(self, "luis_app_ids")

    @luis_app_ids.setter
    def luis_app_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "luis_app_ids", value)

    @property
    @pulumi.getter(name="luisKey")
    def luis_key(self) -> Optional[pulumi.Input[str]]:
        """
        The LUIS Key
        """
        return pulumi.get(self, "luis_key")

    @luis_key.setter
    def luis_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "luis_key", value)


@pulumi.input_type
class ConnectionSettingParameterArgs:
    def __init__(__self__, *,
                 key: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None):
        """
        Extra Parameter in a Connection Setting Properties to indicate service provider specific properties
        :param pulumi.Input[str] key: Key for the Connection Setting Parameter.
        :param pulumi.Input[str] value: Value associated with the Connection Setting Parameter.
        """
        if key is not None:
            pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[str]]:
        """
        Key for the Connection Setting Parameter.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        Value associated with the Connection Setting Parameter.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class ConnectionSettingPropertiesArgs:
    def __init__(__self__, *,
                 client_id: Optional[pulumi.Input[str]] = None,
                 client_secret: Optional[pulumi.Input[str]] = None,
                 parameters: Optional[pulumi.Input[Sequence[pulumi.Input['ConnectionSettingParameterArgs']]]] = None,
                 scopes: Optional[pulumi.Input[str]] = None,
                 service_provider_display_name: Optional[pulumi.Input[str]] = None,
                 service_provider_id: Optional[pulumi.Input[str]] = None):
        """
        Properties for a Connection Setting Item
        :param pulumi.Input[str] client_id: Client Id associated with the Connection Setting.
        :param pulumi.Input[str] client_secret: Client Secret associated with the Connection Setting
        :param pulumi.Input[Sequence[pulumi.Input['ConnectionSettingParameterArgs']]] parameters: Service Provider Parameters associated with the Connection Setting
        :param pulumi.Input[str] scopes: Scopes associated with the Connection Setting
        :param pulumi.Input[str] service_provider_display_name: Service Provider Display Name associated with the Connection Setting
        :param pulumi.Input[str] service_provider_id: Service Provider Id associated with the Connection Setting
        """
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if client_secret is not None:
            pulumi.set(__self__, "client_secret", client_secret)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if scopes is not None:
            pulumi.set(__self__, "scopes", scopes)
        if service_provider_display_name is not None:
            pulumi.set(__self__, "service_provider_display_name", service_provider_display_name)
        if service_provider_id is not None:
            pulumi.set(__self__, "service_provider_id", service_provider_id)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[pulumi.Input[str]]:
        """
        Client Id associated with the Connection Setting.
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_id", value)

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> Optional[pulumi.Input[str]]:
        """
        Client Secret associated with the Connection Setting
        """
        return pulumi.get(self, "client_secret")

    @client_secret.setter
    def client_secret(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_secret", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ConnectionSettingParameterArgs']]]]:
        """
        Service Provider Parameters associated with the Connection Setting
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ConnectionSettingParameterArgs']]]]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter
    def scopes(self) -> Optional[pulumi.Input[str]]:
        """
        Scopes associated with the Connection Setting
        """
        return pulumi.get(self, "scopes")

    @scopes.setter
    def scopes(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scopes", value)

    @property
    @pulumi.getter(name="serviceProviderDisplayName")
    def service_provider_display_name(self) -> Optional[pulumi.Input[str]]:
        """
        Service Provider Display Name associated with the Connection Setting
        """
        return pulumi.get(self, "service_provider_display_name")

    @service_provider_display_name.setter
    def service_provider_display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_provider_display_name", value)

    @property
    @pulumi.getter(name="serviceProviderId")
    def service_provider_id(self) -> Optional[pulumi.Input[str]]:
        """
        Service Provider Id associated with the Connection Setting
        """
        return pulumi.get(self, "service_provider_id")

    @service_provider_id.setter
    def service_provider_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_provider_id", value)


@pulumi.input_type
class DirectLineChannelPropertiesArgs:
    def __init__(__self__, *,
                 sites: Optional[pulumi.Input[Sequence[pulumi.Input['DirectLineSiteArgs']]]] = None):
        """
        The parameters to provide for the Direct Line channel.
        :param pulumi.Input[Sequence[pulumi.Input['DirectLineSiteArgs']]] sites: The list of Direct Line sites
        """
        if sites is not None:
            pulumi.set(__self__, "sites", sites)

    @property
    @pulumi.getter
    def sites(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DirectLineSiteArgs']]]]:
        """
        The list of Direct Line sites
        """
        return pulumi.get(self, "sites")

    @sites.setter
    def sites(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DirectLineSiteArgs']]]]):
        pulumi.set(self, "sites", value)


@pulumi.input_type
class DirectLineChannelArgs:
    def __init__(__self__, *,
                 channel_name: pulumi.Input[str],
                 properties: Optional[pulumi.Input['DirectLineChannelPropertiesArgs']] = None):
        """
        Direct Line channel definition
        :param pulumi.Input[str] channel_name: The channel name
               Expected value is 'DirectLineChannel'.
        :param pulumi.Input['DirectLineChannelPropertiesArgs'] properties: The set of properties specific to Direct Line channel resource
        """
        pulumi.set(__self__, "channel_name", 'DirectLineChannel')
        if properties is not None:
            pulumi.set(__self__, "properties", properties)

    @property
    @pulumi.getter(name="channelName")
    def channel_name(self) -> pulumi.Input[str]:
        """
        The channel name
        Expected value is 'DirectLineChannel'.
        """
        return pulumi.get(self, "channel_name")

    @channel_name.setter
    def channel_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "channel_name", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input['DirectLineChannelPropertiesArgs']]:
        """
        The set of properties specific to Direct Line channel resource
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input['DirectLineChannelPropertiesArgs']]):
        pulumi.set(self, "properties", value)


@pulumi.input_type
class DirectLineSiteArgs:
    def __init__(__self__, *,
                 is_enabled: pulumi.Input[bool],
                 is_v1_enabled: pulumi.Input[bool],
                 is_v3_enabled: pulumi.Input[bool],
                 site_name: pulumi.Input[str]):
        """
        A site for the Direct Line channel
        :param pulumi.Input[bool] is_enabled: Whether this site is enabled for DirectLine channel
        :param pulumi.Input[bool] is_v1_enabled: Whether this site is enabled for Bot Framework V1 protocol
        :param pulumi.Input[bool] is_v3_enabled: Whether this site is enabled for Bot Framework V1 protocol
        :param pulumi.Input[str] site_name: Site name
        """
        pulumi.set(__self__, "is_enabled", is_enabled)
        pulumi.set(__self__, "is_v1_enabled", is_v1_enabled)
        pulumi.set(__self__, "is_v3_enabled", is_v3_enabled)
        pulumi.set(__self__, "site_name", site_name)

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> pulumi.Input[bool]:
        """
        Whether this site is enabled for DirectLine channel
        """
        return pulumi.get(self, "is_enabled")

    @is_enabled.setter
    def is_enabled(self, value: pulumi.Input[bool]):
        pulumi.set(self, "is_enabled", value)

    @property
    @pulumi.getter(name="isV1Enabled")
    def is_v1_enabled(self) -> pulumi.Input[bool]:
        """
        Whether this site is enabled for Bot Framework V1 protocol
        """
        return pulumi.get(self, "is_v1_enabled")

    @is_v1_enabled.setter
    def is_v1_enabled(self, value: pulumi.Input[bool]):
        pulumi.set(self, "is_v1_enabled", value)

    @property
    @pulumi.getter(name="isV3Enabled")
    def is_v3_enabled(self) -> pulumi.Input[bool]:
        """
        Whether this site is enabled for Bot Framework V1 protocol
        """
        return pulumi.get(self, "is_v3_enabled")

    @is_v3_enabled.setter
    def is_v3_enabled(self, value: pulumi.Input[bool]):
        pulumi.set(self, "is_v3_enabled", value)

    @property
    @pulumi.getter(name="siteName")
    def site_name(self) -> pulumi.Input[str]:
        """
        Site name
        """
        return pulumi.get(self, "site_name")

    @site_name.setter
    def site_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "site_name", value)


@pulumi.input_type
class EmailChannelPropertiesArgs:
    def __init__(__self__, *,
                 email_address: pulumi.Input[str],
                 is_enabled: pulumi.Input[bool],
                 password: pulumi.Input[str]):
        """
        The parameters to provide for the Email channel.
        :param pulumi.Input[str] email_address: The email address
        :param pulumi.Input[bool] is_enabled: Whether this channel is enabled for the bot
        :param pulumi.Input[str] password: The password for the email address. Value only returned through POST to the action Channel List API, otherwise empty.
        """
        pulumi.set(__self__, "email_address", email_address)
        pulumi.set(__self__, "is_enabled", is_enabled)
        pulumi.set(__self__, "password", password)

    @property
    @pulumi.getter(name="emailAddress")
    def email_address(self) -> pulumi.Input[str]:
        """
        The email address
        """
        return pulumi.get(self, "email_address")

    @email_address.setter
    def email_address(self, value: pulumi.Input[str]):
        pulumi.set(self, "email_address", value)

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> pulumi.Input[bool]:
        """
        Whether this channel is enabled for the bot
        """
        return pulumi.get(self, "is_enabled")

    @is_enabled.setter
    def is_enabled(self, value: pulumi.Input[bool]):
        pulumi.set(self, "is_enabled", value)

    @property
    @pulumi.getter
    def password(self) -> pulumi.Input[str]:
        """
        The password for the email address. Value only returned through POST to the action Channel List API, otherwise empty.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: pulumi.Input[str]):
        pulumi.set(self, "password", value)


@pulumi.input_type
class EmailChannelArgs:
    def __init__(__self__, *,
                 channel_name: pulumi.Input[str],
                 properties: Optional[pulumi.Input['EmailChannelPropertiesArgs']] = None):
        """
        Email channel definition
        :param pulumi.Input[str] channel_name: The channel name
               Expected value is 'EmailChannel'.
        :param pulumi.Input['EmailChannelPropertiesArgs'] properties: The set of properties specific to email channel resource
        """
        pulumi.set(__self__, "channel_name", 'EmailChannel')
        if properties is not None:
            pulumi.set(__self__, "properties", properties)

    @property
    @pulumi.getter(name="channelName")
    def channel_name(self) -> pulumi.Input[str]:
        """
        The channel name
        Expected value is 'EmailChannel'.
        """
        return pulumi.get(self, "channel_name")

    @channel_name.setter
    def channel_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "channel_name", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input['EmailChannelPropertiesArgs']]:
        """
        The set of properties specific to email channel resource
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input['EmailChannelPropertiesArgs']]):
        pulumi.set(self, "properties", value)


@pulumi.input_type
class FacebookChannelPropertiesArgs:
    def __init__(__self__, *,
                 app_id: pulumi.Input[str],
                 app_secret: pulumi.Input[str],
                 is_enabled: pulumi.Input[bool],
                 pages: Optional[pulumi.Input[Sequence[pulumi.Input['FacebookPageArgs']]]] = None):
        """
        The parameters to provide for the Facebook channel.
        :param pulumi.Input[str] app_id: Facebook application id
        :param pulumi.Input[str] app_secret: Facebook application secret. Value only returned through POST to the action Channel List API, otherwise empty.
        :param pulumi.Input[bool] is_enabled: Whether this channel is enabled for the bot
        :param pulumi.Input[Sequence[pulumi.Input['FacebookPageArgs']]] pages: The list of Facebook pages
        """
        pulumi.set(__self__, "app_id", app_id)
        pulumi.set(__self__, "app_secret", app_secret)
        pulumi.set(__self__, "is_enabled", is_enabled)
        if pages is not None:
            pulumi.set(__self__, "pages", pages)

    @property
    @pulumi.getter(name="appId")
    def app_id(self) -> pulumi.Input[str]:
        """
        Facebook application id
        """
        return pulumi.get(self, "app_id")

    @app_id.setter
    def app_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "app_id", value)

    @property
    @pulumi.getter(name="appSecret")
    def app_secret(self) -> pulumi.Input[str]:
        """
        Facebook application secret. Value only returned through POST to the action Channel List API, otherwise empty.
        """
        return pulumi.get(self, "app_secret")

    @app_secret.setter
    def app_secret(self, value: pulumi.Input[str]):
        pulumi.set(self, "app_secret", value)

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> pulumi.Input[bool]:
        """
        Whether this channel is enabled for the bot
        """
        return pulumi.get(self, "is_enabled")

    @is_enabled.setter
    def is_enabled(self, value: pulumi.Input[bool]):
        pulumi.set(self, "is_enabled", value)

    @property
    @pulumi.getter
    def pages(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FacebookPageArgs']]]]:
        """
        The list of Facebook pages
        """
        return pulumi.get(self, "pages")

    @pages.setter
    def pages(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FacebookPageArgs']]]]):
        pulumi.set(self, "pages", value)


@pulumi.input_type
class FacebookChannelArgs:
    def __init__(__self__, *,
                 channel_name: pulumi.Input[str],
                 properties: Optional[pulumi.Input['FacebookChannelPropertiesArgs']] = None):
        """
        Facebook channel definition
        :param pulumi.Input[str] channel_name: The channel name
               Expected value is 'FacebookChannel'.
        :param pulumi.Input['FacebookChannelPropertiesArgs'] properties: The set of properties specific to bot facebook channel
        """
        pulumi.set(__self__, "channel_name", 'FacebookChannel')
        if properties is not None:
            pulumi.set(__self__, "properties", properties)

    @property
    @pulumi.getter(name="channelName")
    def channel_name(self) -> pulumi.Input[str]:
        """
        The channel name
        Expected value is 'FacebookChannel'.
        """
        return pulumi.get(self, "channel_name")

    @channel_name.setter
    def channel_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "channel_name", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input['FacebookChannelPropertiesArgs']]:
        """
        The set of properties specific to bot facebook channel
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input['FacebookChannelPropertiesArgs']]):
        pulumi.set(self, "properties", value)


@pulumi.input_type
class FacebookPageArgs:
    def __init__(__self__, *,
                 access_token: pulumi.Input[str],
                 id: pulumi.Input[str]):
        """
        A Facebook page for Facebook channel registration
        :param pulumi.Input[str] access_token: Facebook application access token. Value only returned through POST to the action Channel List API, otherwise empty.
        :param pulumi.Input[str] id: Page id
        """
        pulumi.set(__self__, "access_token", access_token)
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter(name="accessToken")
    def access_token(self) -> pulumi.Input[str]:
        """
        Facebook application access token. Value only returned through POST to the action Channel List API, otherwise empty.
        """
        return pulumi.get(self, "access_token")

    @access_token.setter
    def access_token(self, value: pulumi.Input[str]):
        pulumi.set(self, "access_token", value)

    @property
    @pulumi.getter
    def id(self) -> pulumi.Input[str]:
        """
        Page id
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: pulumi.Input[str]):
        pulumi.set(self, "id", value)


@pulumi.input_type
class KikChannelPropertiesArgs:
    def __init__(__self__, *,
                 api_key: pulumi.Input[str],
                 is_enabled: pulumi.Input[bool],
                 user_name: pulumi.Input[str],
                 is_validated: Optional[pulumi.Input[bool]] = None):
        """
        The parameters to provide for the Kik channel.
        :param pulumi.Input[str] api_key: Kik API key. Value only returned through POST to the action Channel List API, otherwise empty.
        :param pulumi.Input[bool] is_enabled: Whether this channel is enabled for the bot
        :param pulumi.Input[str] user_name: The Kik user name
        :param pulumi.Input[bool] is_validated: Whether this channel is validated for the bot
        """
        pulumi.set(__self__, "api_key", api_key)
        pulumi.set(__self__, "is_enabled", is_enabled)
        pulumi.set(__self__, "user_name", user_name)
        if is_validated is not None:
            pulumi.set(__self__, "is_validated", is_validated)

    @property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> pulumi.Input[str]:
        """
        Kik API key. Value only returned through POST to the action Channel List API, otherwise empty.
        """
        return pulumi.get(self, "api_key")

    @api_key.setter
    def api_key(self, value: pulumi.Input[str]):
        pulumi.set(self, "api_key", value)

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> pulumi.Input[bool]:
        """
        Whether this channel is enabled for the bot
        """
        return pulumi.get(self, "is_enabled")

    @is_enabled.setter
    def is_enabled(self, value: pulumi.Input[bool]):
        pulumi.set(self, "is_enabled", value)

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> pulumi.Input[str]:
        """
        The Kik user name
        """
        return pulumi.get(self, "user_name")

    @user_name.setter
    def user_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "user_name", value)

    @property
    @pulumi.getter(name="isValidated")
    def is_validated(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether this channel is validated for the bot
        """
        return pulumi.get(self, "is_validated")

    @is_validated.setter
    def is_validated(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_validated", value)


@pulumi.input_type
class KikChannelArgs:
    def __init__(__self__, *,
                 channel_name: pulumi.Input[str],
                 properties: Optional[pulumi.Input['KikChannelPropertiesArgs']] = None):
        """
        Kik channel definition
        :param pulumi.Input[str] channel_name: The channel name
               Expected value is 'KikChannel'.
        :param pulumi.Input['KikChannelPropertiesArgs'] properties: The set of properties specific to Kik channel resource
        """
        pulumi.set(__self__, "channel_name", 'KikChannel')
        if properties is not None:
            pulumi.set(__self__, "properties", properties)

    @property
    @pulumi.getter(name="channelName")
    def channel_name(self) -> pulumi.Input[str]:
        """
        The channel name
        Expected value is 'KikChannel'.
        """
        return pulumi.get(self, "channel_name")

    @channel_name.setter
    def channel_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "channel_name", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input['KikChannelPropertiesArgs']]:
        """
        The set of properties specific to Kik channel resource
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input['KikChannelPropertiesArgs']]):
        pulumi.set(self, "properties", value)


@pulumi.input_type
class MsTeamsChannelPropertiesArgs:
    def __init__(__self__, *,
                 is_enabled: pulumi.Input[bool],
                 call_mode: Optional[pulumi.Input[str]] = None,
                 enable_calling: Optional[pulumi.Input[bool]] = None,
                 enable_media_cards: Optional[pulumi.Input[bool]] = None,
                 enable_messaging: Optional[pulumi.Input[bool]] = None,
                 enable_video: Optional[pulumi.Input[bool]] = None):
        """
        The parameters to provide for the Microsoft Teams channel.
        :param pulumi.Input[bool] is_enabled: Whether this channel is enabled for the bot
        :param pulumi.Input[str] call_mode: Enable messaging for Microsoft Teams channel
        :param pulumi.Input[bool] enable_calling: Enable calling for Microsoft Teams channel
        :param pulumi.Input[bool] enable_media_cards: Enable media cards for Microsoft Teams channel
        :param pulumi.Input[bool] enable_messaging: Enable messaging for Microsoft Teams channel
        :param pulumi.Input[bool] enable_video: Enable video for Microsoft Teams channel
        """
        pulumi.set(__self__, "is_enabled", is_enabled)
        if call_mode is not None:
            pulumi.set(__self__, "call_mode", call_mode)
        if enable_calling is not None:
            pulumi.set(__self__, "enable_calling", enable_calling)
        if enable_media_cards is not None:
            pulumi.set(__self__, "enable_media_cards", enable_media_cards)
        if enable_messaging is not None:
            pulumi.set(__self__, "enable_messaging", enable_messaging)
        if enable_video is not None:
            pulumi.set(__self__, "enable_video", enable_video)

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> pulumi.Input[bool]:
        """
        Whether this channel is enabled for the bot
        """
        return pulumi.get(self, "is_enabled")

    @is_enabled.setter
    def is_enabled(self, value: pulumi.Input[bool]):
        pulumi.set(self, "is_enabled", value)

    @property
    @pulumi.getter(name="callMode")
    def call_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Enable messaging for Microsoft Teams channel
        """
        return pulumi.get(self, "call_mode")

    @call_mode.setter
    def call_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "call_mode", value)

    @property
    @pulumi.getter(name="enableCalling")
    def enable_calling(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable calling for Microsoft Teams channel
        """
        return pulumi.get(self, "enable_calling")

    @enable_calling.setter
    def enable_calling(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_calling", value)

    @property
    @pulumi.getter(name="enableMediaCards")
    def enable_media_cards(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable media cards for Microsoft Teams channel
        """
        return pulumi.get(self, "enable_media_cards")

    @enable_media_cards.setter
    def enable_media_cards(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_media_cards", value)

    @property
    @pulumi.getter(name="enableMessaging")
    def enable_messaging(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable messaging for Microsoft Teams channel
        """
        return pulumi.get(self, "enable_messaging")

    @enable_messaging.setter
    def enable_messaging(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_messaging", value)

    @property
    @pulumi.getter(name="enableVideo")
    def enable_video(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable video for Microsoft Teams channel
        """
        return pulumi.get(self, "enable_video")

    @enable_video.setter
    def enable_video(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_video", value)


@pulumi.input_type
class MsTeamsChannelArgs:
    def __init__(__self__, *,
                 channel_name: pulumi.Input[str],
                 properties: Optional[pulumi.Input['MsTeamsChannelPropertiesArgs']] = None):
        """
        Microsoft Teams channel definition
        :param pulumi.Input[str] channel_name: The channel name
               Expected value is 'MsTeamsChannel'.
        :param pulumi.Input['MsTeamsChannelPropertiesArgs'] properties: The set of properties specific to Microsoft Teams channel resource
        """
        pulumi.set(__self__, "channel_name", 'MsTeamsChannel')
        if properties is not None:
            pulumi.set(__self__, "properties", properties)

    @property
    @pulumi.getter(name="channelName")
    def channel_name(self) -> pulumi.Input[str]:
        """
        The channel name
        Expected value is 'MsTeamsChannel'.
        """
        return pulumi.get(self, "channel_name")

    @channel_name.setter
    def channel_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "channel_name", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input['MsTeamsChannelPropertiesArgs']]:
        """
        The set of properties specific to Microsoft Teams channel resource
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input['MsTeamsChannelPropertiesArgs']]):
        pulumi.set(self, "properties", value)


@pulumi.input_type
class SkuArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[Union[str, 'SkuName']]):
        """
        The SKU of the cognitive services account.
        :param pulumi.Input[Union[str, 'SkuName']] name: The sku name
        """
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[Union[str, 'SkuName']]:
        """
        The sku name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[Union[str, 'SkuName']]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class SkypeChannelPropertiesArgs:
    def __init__(__self__, *,
                 is_enabled: pulumi.Input[bool],
                 calling_web_hook: Optional[pulumi.Input[str]] = None,
                 enable_calling: Optional[pulumi.Input[bool]] = None,
                 enable_groups: Optional[pulumi.Input[bool]] = None,
                 enable_media_cards: Optional[pulumi.Input[bool]] = None,
                 enable_messaging: Optional[pulumi.Input[bool]] = None,
                 enable_screen_sharing: Optional[pulumi.Input[bool]] = None,
                 enable_video: Optional[pulumi.Input[bool]] = None,
                 groups_mode: Optional[pulumi.Input[str]] = None):
        """
        The parameters to provide for the Microsoft Teams channel.
        :param pulumi.Input[bool] is_enabled: Whether this channel is enabled for the bot
        :param pulumi.Input[str] calling_web_hook: Calling web hook for Skype channel
        :param pulumi.Input[bool] enable_calling: Enable calling for Skype channel
        :param pulumi.Input[bool] enable_groups: Enable groups for Skype channel
        :param pulumi.Input[bool] enable_media_cards: Enable media cards for Skype channel
        :param pulumi.Input[bool] enable_messaging: Enable messaging for Skype channel
        :param pulumi.Input[bool] enable_screen_sharing: Enable screen sharing for Skype channel
        :param pulumi.Input[bool] enable_video: Enable video for Skype channel
        :param pulumi.Input[str] groups_mode: Group mode for Skype channel
        """
        pulumi.set(__self__, "is_enabled", is_enabled)
        if calling_web_hook is not None:
            pulumi.set(__self__, "calling_web_hook", calling_web_hook)
        if enable_calling is not None:
            pulumi.set(__self__, "enable_calling", enable_calling)
        if enable_groups is not None:
            pulumi.set(__self__, "enable_groups", enable_groups)
        if enable_media_cards is not None:
            pulumi.set(__self__, "enable_media_cards", enable_media_cards)
        if enable_messaging is not None:
            pulumi.set(__self__, "enable_messaging", enable_messaging)
        if enable_screen_sharing is not None:
            pulumi.set(__self__, "enable_screen_sharing", enable_screen_sharing)
        if enable_video is not None:
            pulumi.set(__self__, "enable_video", enable_video)
        if groups_mode is not None:
            pulumi.set(__self__, "groups_mode", groups_mode)

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> pulumi.Input[bool]:
        """
        Whether this channel is enabled for the bot
        """
        return pulumi.get(self, "is_enabled")

    @is_enabled.setter
    def is_enabled(self, value: pulumi.Input[bool]):
        pulumi.set(self, "is_enabled", value)

    @property
    @pulumi.getter(name="callingWebHook")
    def calling_web_hook(self) -> Optional[pulumi.Input[str]]:
        """
        Calling web hook for Skype channel
        """
        return pulumi.get(self, "calling_web_hook")

    @calling_web_hook.setter
    def calling_web_hook(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "calling_web_hook", value)

    @property
    @pulumi.getter(name="enableCalling")
    def enable_calling(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable calling for Skype channel
        """
        return pulumi.get(self, "enable_calling")

    @enable_calling.setter
    def enable_calling(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_calling", value)

    @property
    @pulumi.getter(name="enableGroups")
    def enable_groups(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable groups for Skype channel
        """
        return pulumi.get(self, "enable_groups")

    @enable_groups.setter
    def enable_groups(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_groups", value)

    @property
    @pulumi.getter(name="enableMediaCards")
    def enable_media_cards(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable media cards for Skype channel
        """
        return pulumi.get(self, "enable_media_cards")

    @enable_media_cards.setter
    def enable_media_cards(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_media_cards", value)

    @property
    @pulumi.getter(name="enableMessaging")
    def enable_messaging(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable messaging for Skype channel
        """
        return pulumi.get(self, "enable_messaging")

    @enable_messaging.setter
    def enable_messaging(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_messaging", value)

    @property
    @pulumi.getter(name="enableScreenSharing")
    def enable_screen_sharing(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable screen sharing for Skype channel
        """
        return pulumi.get(self, "enable_screen_sharing")

    @enable_screen_sharing.setter
    def enable_screen_sharing(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_screen_sharing", value)

    @property
    @pulumi.getter(name="enableVideo")
    def enable_video(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable video for Skype channel
        """
        return pulumi.get(self, "enable_video")

    @enable_video.setter
    def enable_video(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_video", value)

    @property
    @pulumi.getter(name="groupsMode")
    def groups_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Group mode for Skype channel
        """
        return pulumi.get(self, "groups_mode")

    @groups_mode.setter
    def groups_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "groups_mode", value)


@pulumi.input_type
class SkypeChannelArgs:
    def __init__(__self__, *,
                 channel_name: pulumi.Input[str],
                 properties: Optional[pulumi.Input['SkypeChannelPropertiesArgs']] = None):
        """
        Skype channel definition
        :param pulumi.Input[str] channel_name: The channel name
               Expected value is 'SkypeChannel'.
        :param pulumi.Input['SkypeChannelPropertiesArgs'] properties: The set of properties specific to Skype channel resource
        """
        pulumi.set(__self__, "channel_name", 'SkypeChannel')
        if properties is not None:
            pulumi.set(__self__, "properties", properties)

    @property
    @pulumi.getter(name="channelName")
    def channel_name(self) -> pulumi.Input[str]:
        """
        The channel name
        Expected value is 'SkypeChannel'.
        """
        return pulumi.get(self, "channel_name")

    @channel_name.setter
    def channel_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "channel_name", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input['SkypeChannelPropertiesArgs']]:
        """
        The set of properties specific to Skype channel resource
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input['SkypeChannelPropertiesArgs']]):
        pulumi.set(self, "properties", value)


@pulumi.input_type
class SlackChannelPropertiesArgs:
    def __init__(__self__, *,
                 client_id: pulumi.Input[str],
                 client_secret: pulumi.Input[str],
                 is_enabled: pulumi.Input[bool],
                 verification_token: pulumi.Input[str],
                 landing_page_url: Optional[pulumi.Input[str]] = None):
        """
        The parameters to provide for the Slack channel.
        :param pulumi.Input[str] client_id: The Slack client id
        :param pulumi.Input[str] client_secret: The Slack client secret. Value only returned through POST to the action Channel List API, otherwise empty.
        :param pulumi.Input[bool] is_enabled: Whether this channel is enabled for the bot
        :param pulumi.Input[str] verification_token: The Slack verification token. Value only returned through POST to the action Channel List API, otherwise empty.
        :param pulumi.Input[str] landing_page_url: The Slack landing page Url
        """
        pulumi.set(__self__, "client_id", client_id)
        pulumi.set(__self__, "client_secret", client_secret)
        pulumi.set(__self__, "is_enabled", is_enabled)
        pulumi.set(__self__, "verification_token", verification_token)
        if landing_page_url is not None:
            pulumi.set(__self__, "landing_page_url", landing_page_url)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> pulumi.Input[str]:
        """
        The Slack client id
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "client_id", value)

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> pulumi.Input[str]:
        """
        The Slack client secret. Value only returned through POST to the action Channel List API, otherwise empty.
        """
        return pulumi.get(self, "client_secret")

    @client_secret.setter
    def client_secret(self, value: pulumi.Input[str]):
        pulumi.set(self, "client_secret", value)

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> pulumi.Input[bool]:
        """
        Whether this channel is enabled for the bot
        """
        return pulumi.get(self, "is_enabled")

    @is_enabled.setter
    def is_enabled(self, value: pulumi.Input[bool]):
        pulumi.set(self, "is_enabled", value)

    @property
    @pulumi.getter(name="verificationToken")
    def verification_token(self) -> pulumi.Input[str]:
        """
        The Slack verification token. Value only returned through POST to the action Channel List API, otherwise empty.
        """
        return pulumi.get(self, "verification_token")

    @verification_token.setter
    def verification_token(self, value: pulumi.Input[str]):
        pulumi.set(self, "verification_token", value)

    @property
    @pulumi.getter(name="landingPageUrl")
    def landing_page_url(self) -> Optional[pulumi.Input[str]]:
        """
        The Slack landing page Url
        """
        return pulumi.get(self, "landing_page_url")

    @landing_page_url.setter
    def landing_page_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "landing_page_url", value)


@pulumi.input_type
class SlackChannelArgs:
    def __init__(__self__, *,
                 channel_name: pulumi.Input[str],
                 properties: Optional[pulumi.Input['SlackChannelPropertiesArgs']] = None):
        """
        Slack channel definition
        :param pulumi.Input[str] channel_name: The channel name
               Expected value is 'SlackChannel'.
        :param pulumi.Input['SlackChannelPropertiesArgs'] properties: The set of properties specific to Slack channel resource
        """
        pulumi.set(__self__, "channel_name", 'SlackChannel')
        if properties is not None:
            pulumi.set(__self__, "properties", properties)

    @property
    @pulumi.getter(name="channelName")
    def channel_name(self) -> pulumi.Input[str]:
        """
        The channel name
        Expected value is 'SlackChannel'.
        """
        return pulumi.get(self, "channel_name")

    @channel_name.setter
    def channel_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "channel_name", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input['SlackChannelPropertiesArgs']]:
        """
        The set of properties specific to Slack channel resource
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input['SlackChannelPropertiesArgs']]):
        pulumi.set(self, "properties", value)


@pulumi.input_type
class SmsChannelPropertiesArgs:
    def __init__(__self__, *,
                 account_sid: pulumi.Input[str],
                 auth_token: pulumi.Input[str],
                 is_enabled: pulumi.Input[bool],
                 phone: pulumi.Input[str],
                 is_validated: Optional[pulumi.Input[bool]] = None):
        """
        The parameters to provide for the Sms channel.
        :param pulumi.Input[str] account_sid: The Sms account SID. Value only returned through POST to the action Channel List API, otherwise empty.
        :param pulumi.Input[str] auth_token: The Sms auth token. Value only returned through POST to the action Channel List API, otherwise empty.
        :param pulumi.Input[bool] is_enabled: Whether this channel is enabled for the bot
        :param pulumi.Input[str] phone: The Sms phone
        :param pulumi.Input[bool] is_validated: Whether this channel is validated for the bot
        """
        pulumi.set(__self__, "account_sid", account_sid)
        pulumi.set(__self__, "auth_token", auth_token)
        pulumi.set(__self__, "is_enabled", is_enabled)
        pulumi.set(__self__, "phone", phone)
        if is_validated is not None:
            pulumi.set(__self__, "is_validated", is_validated)

    @property
    @pulumi.getter(name="accountSID")
    def account_sid(self) -> pulumi.Input[str]:
        """
        The Sms account SID. Value only returned through POST to the action Channel List API, otherwise empty.
        """
        return pulumi.get(self, "account_sid")

    @account_sid.setter
    def account_sid(self, value: pulumi.Input[str]):
        pulumi.set(self, "account_sid", value)

    @property
    @pulumi.getter(name="authToken")
    def auth_token(self) -> pulumi.Input[str]:
        """
        The Sms auth token. Value only returned through POST to the action Channel List API, otherwise empty.
        """
        return pulumi.get(self, "auth_token")

    @auth_token.setter
    def auth_token(self, value: pulumi.Input[str]):
        pulumi.set(self, "auth_token", value)

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> pulumi.Input[bool]:
        """
        Whether this channel is enabled for the bot
        """
        return pulumi.get(self, "is_enabled")

    @is_enabled.setter
    def is_enabled(self, value: pulumi.Input[bool]):
        pulumi.set(self, "is_enabled", value)

    @property
    @pulumi.getter
    def phone(self) -> pulumi.Input[str]:
        """
        The Sms phone
        """
        return pulumi.get(self, "phone")

    @phone.setter
    def phone(self, value: pulumi.Input[str]):
        pulumi.set(self, "phone", value)

    @property
    @pulumi.getter(name="isValidated")
    def is_validated(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether this channel is validated for the bot
        """
        return pulumi.get(self, "is_validated")

    @is_validated.setter
    def is_validated(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_validated", value)


@pulumi.input_type
class SmsChannelArgs:
    def __init__(__self__, *,
                 channel_name: pulumi.Input[str],
                 properties: Optional[pulumi.Input['SmsChannelPropertiesArgs']] = None):
        """
        Sms channel definition
        :param pulumi.Input[str] channel_name: The channel name
               Expected value is 'SmsChannel'.
        :param pulumi.Input['SmsChannelPropertiesArgs'] properties: The set of properties specific to Sms channel resource
        """
        pulumi.set(__self__, "channel_name", 'SmsChannel')
        if properties is not None:
            pulumi.set(__self__, "properties", properties)

    @property
    @pulumi.getter(name="channelName")
    def channel_name(self) -> pulumi.Input[str]:
        """
        The channel name
        Expected value is 'SmsChannel'.
        """
        return pulumi.get(self, "channel_name")

    @channel_name.setter
    def channel_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "channel_name", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input['SmsChannelPropertiesArgs']]:
        """
        The set of properties specific to Sms channel resource
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input['SmsChannelPropertiesArgs']]):
        pulumi.set(self, "properties", value)


@pulumi.input_type
class TelegramChannelPropertiesArgs:
    def __init__(__self__, *,
                 access_token: pulumi.Input[str],
                 is_enabled: pulumi.Input[bool],
                 is_validated: Optional[pulumi.Input[bool]] = None):
        """
        The parameters to provide for the Telegram channel.
        :param pulumi.Input[str] access_token: The Telegram access token. Value only returned through POST to the action Channel List API, otherwise empty.
        :param pulumi.Input[bool] is_enabled: Whether this channel is enabled for the bot
        :param pulumi.Input[bool] is_validated: Whether this channel is validated for the bot
        """
        pulumi.set(__self__, "access_token", access_token)
        pulumi.set(__self__, "is_enabled", is_enabled)
        if is_validated is not None:
            pulumi.set(__self__, "is_validated", is_validated)

    @property
    @pulumi.getter(name="accessToken")
    def access_token(self) -> pulumi.Input[str]:
        """
        The Telegram access token. Value only returned through POST to the action Channel List API, otherwise empty.
        """
        return pulumi.get(self, "access_token")

    @access_token.setter
    def access_token(self, value: pulumi.Input[str]):
        pulumi.set(self, "access_token", value)

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> pulumi.Input[bool]:
        """
        Whether this channel is enabled for the bot
        """
        return pulumi.get(self, "is_enabled")

    @is_enabled.setter
    def is_enabled(self, value: pulumi.Input[bool]):
        pulumi.set(self, "is_enabled", value)

    @property
    @pulumi.getter(name="isValidated")
    def is_validated(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether this channel is validated for the bot
        """
        return pulumi.get(self, "is_validated")

    @is_validated.setter
    def is_validated(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_validated", value)


@pulumi.input_type
class TelegramChannelArgs:
    def __init__(__self__, *,
                 channel_name: pulumi.Input[str],
                 properties: Optional[pulumi.Input['TelegramChannelPropertiesArgs']] = None):
        """
        Telegram channel definition
        :param pulumi.Input[str] channel_name: The channel name
               Expected value is 'TelegramChannel'.
        :param pulumi.Input['TelegramChannelPropertiesArgs'] properties: The set of properties specific to Telegram channel resource
        """
        pulumi.set(__self__, "channel_name", 'TelegramChannel')
        if properties is not None:
            pulumi.set(__self__, "properties", properties)

    @property
    @pulumi.getter(name="channelName")
    def channel_name(self) -> pulumi.Input[str]:
        """
        The channel name
        Expected value is 'TelegramChannel'.
        """
        return pulumi.get(self, "channel_name")

    @channel_name.setter
    def channel_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "channel_name", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input['TelegramChannelPropertiesArgs']]:
        """
        The set of properties specific to Telegram channel resource
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input['TelegramChannelPropertiesArgs']]):
        pulumi.set(self, "properties", value)


@pulumi.input_type
class WebChatChannelPropertiesArgs:
    def __init__(__self__, *,
                 sites: Optional[pulumi.Input[Sequence[pulumi.Input['WebChatSiteArgs']]]] = None):
        """
        The parameters to provide for the Web Chat channel.
        :param pulumi.Input[Sequence[pulumi.Input['WebChatSiteArgs']]] sites: The list of Web Chat sites
        """
        if sites is not None:
            pulumi.set(__self__, "sites", sites)

    @property
    @pulumi.getter
    def sites(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WebChatSiteArgs']]]]:
        """
        The list of Web Chat sites
        """
        return pulumi.get(self, "sites")

    @sites.setter
    def sites(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WebChatSiteArgs']]]]):
        pulumi.set(self, "sites", value)


@pulumi.input_type
class WebChatChannelArgs:
    def __init__(__self__, *,
                 channel_name: pulumi.Input[str],
                 properties: Optional[pulumi.Input['WebChatChannelPropertiesArgs']] = None):
        """
        Web Chat channel definition
        :param pulumi.Input[str] channel_name: The channel name
               Expected value is 'WebChatChannel'.
        :param pulumi.Input['WebChatChannelPropertiesArgs'] properties: The set of properties specific to Web Chat channel resource
        """
        pulumi.set(__self__, "channel_name", 'WebChatChannel')
        if properties is not None:
            pulumi.set(__self__, "properties", properties)

    @property
    @pulumi.getter(name="channelName")
    def channel_name(self) -> pulumi.Input[str]:
        """
        The channel name
        Expected value is 'WebChatChannel'.
        """
        return pulumi.get(self, "channel_name")

    @channel_name.setter
    def channel_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "channel_name", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input['WebChatChannelPropertiesArgs']]:
        """
        The set of properties specific to Web Chat channel resource
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input['WebChatChannelPropertiesArgs']]):
        pulumi.set(self, "properties", value)


@pulumi.input_type
class WebChatSiteArgs:
    def __init__(__self__, *,
                 enable_preview: pulumi.Input[bool],
                 is_enabled: pulumi.Input[bool],
                 site_name: pulumi.Input[str]):
        """
        A site for the Webchat channel
        :param pulumi.Input[bool] enable_preview: Whether this site is enabled for preview versions of Webchat
        :param pulumi.Input[bool] is_enabled: Whether this site is enabled for DirectLine channel
        :param pulumi.Input[str] site_name: Site name
        """
        pulumi.set(__self__, "enable_preview", enable_preview)
        pulumi.set(__self__, "is_enabled", is_enabled)
        pulumi.set(__self__, "site_name", site_name)

    @property
    @pulumi.getter(name="enablePreview")
    def enable_preview(self) -> pulumi.Input[bool]:
        """
        Whether this site is enabled for preview versions of Webchat
        """
        return pulumi.get(self, "enable_preview")

    @enable_preview.setter
    def enable_preview(self, value: pulumi.Input[bool]):
        pulumi.set(self, "enable_preview", value)

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> pulumi.Input[bool]:
        """
        Whether this site is enabled for DirectLine channel
        """
        return pulumi.get(self, "is_enabled")

    @is_enabled.setter
    def is_enabled(self, value: pulumi.Input[bool]):
        pulumi.set(self, "is_enabled", value)

    @property
    @pulumi.getter(name="siteName")
    def site_name(self) -> pulumi.Input[str]:
        """
        Site name
        """
        return pulumi.get(self, "site_name")

    @site_name.setter
    def site_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "site_name", value)


