# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'CorsRuleResponse',
    'CorsRulesResponse',
    'CustomDomainResponse',
    'DeleteRetentionPolicyResponse',
    'EncryptionResponse',
    'EncryptionServiceResponse',
    'EncryptionServicesResponse',
    'EndpointsResponse',
    'GeoReplicationStatsResponse',
    'IPRuleResponse',
    'IdentityResponse',
    'ImmutabilityPolicyPropertiesResponse',
    'KeyVaultPropertiesResponse',
    'LegalHoldPropertiesResponse',
    'NetworkRuleSetResponse',
    'RestrictionResponse',
    'SKUCapabilityResponse',
    'SkuResponse',
    'StorageAccountKeyResponse',
    'TagPropertyResponse',
    'UpdateHistoryPropertyResponse',
    'VirtualNetworkRuleResponse',
]

@pulumi.output_type
class CorsRuleResponse(dict):
    """
    Specifies a CORS rule for the Blob service.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedHeaders":
            suggest = "allowed_headers"
        elif key == "allowedMethods":
            suggest = "allowed_methods"
        elif key == "allowedOrigins":
            suggest = "allowed_origins"
        elif key == "exposedHeaders":
            suggest = "exposed_headers"
        elif key == "maxAgeInSeconds":
            suggest = "max_age_in_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CorsRuleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CorsRuleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CorsRuleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allowed_headers: Sequence[str],
                 allowed_methods: Sequence[str],
                 allowed_origins: Sequence[str],
                 exposed_headers: Sequence[str],
                 max_age_in_seconds: int):
        """
        Specifies a CORS rule for the Blob service.
        :param Sequence[str] allowed_headers: Required if CorsRule element is present. A list of headers allowed to be part of the cross-origin request.
        :param Sequence[str] allowed_methods: Required if CorsRule element is present. A list of HTTP methods that are allowed to be executed by the origin.
        :param Sequence[str] allowed_origins: Required if CorsRule element is present. A list of origin domains that will be allowed via CORS, or "*" to allow all domains
        :param Sequence[str] exposed_headers: Required if CorsRule element is present. A list of response headers to expose to CORS clients.
        :param int max_age_in_seconds: Required if CorsRule element is present. The number of seconds that the client/browser should cache a preflight response.
        """
        pulumi.set(__self__, "allowed_headers", allowed_headers)
        pulumi.set(__self__, "allowed_methods", allowed_methods)
        pulumi.set(__self__, "allowed_origins", allowed_origins)
        pulumi.set(__self__, "exposed_headers", exposed_headers)
        pulumi.set(__self__, "max_age_in_seconds", max_age_in_seconds)

    @property
    @pulumi.getter(name="allowedHeaders")
    def allowed_headers(self) -> Sequence[str]:
        """
        Required if CorsRule element is present. A list of headers allowed to be part of the cross-origin request.
        """
        return pulumi.get(self, "allowed_headers")

    @property
    @pulumi.getter(name="allowedMethods")
    def allowed_methods(self) -> Sequence[str]:
        """
        Required if CorsRule element is present. A list of HTTP methods that are allowed to be executed by the origin.
        """
        return pulumi.get(self, "allowed_methods")

    @property
    @pulumi.getter(name="allowedOrigins")
    def allowed_origins(self) -> Sequence[str]:
        """
        Required if CorsRule element is present. A list of origin domains that will be allowed via CORS, or "*" to allow all domains
        """
        return pulumi.get(self, "allowed_origins")

    @property
    @pulumi.getter(name="exposedHeaders")
    def exposed_headers(self) -> Sequence[str]:
        """
        Required if CorsRule element is present. A list of response headers to expose to CORS clients.
        """
        return pulumi.get(self, "exposed_headers")

    @property
    @pulumi.getter(name="maxAgeInSeconds")
    def max_age_in_seconds(self) -> int:
        """
        Required if CorsRule element is present. The number of seconds that the client/browser should cache a preflight response.
        """
        return pulumi.get(self, "max_age_in_seconds")


@pulumi.output_type
class CorsRulesResponse(dict):
    """
    Sets the CORS rules. You can include up to five CorsRule elements in the request. 
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "corsRules":
            suggest = "cors_rules"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CorsRulesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CorsRulesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CorsRulesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cors_rules: Optional[Sequence['outputs.CorsRuleResponse']] = None):
        """
        Sets the CORS rules. You can include up to five CorsRule elements in the request. 
        :param Sequence['CorsRuleResponse'] cors_rules: The List of CORS rules. You can include up to five CorsRule elements in the request. 
        """
        if cors_rules is not None:
            pulumi.set(__self__, "cors_rules", cors_rules)

    @property
    @pulumi.getter(name="corsRules")
    def cors_rules(self) -> Optional[Sequence['outputs.CorsRuleResponse']]:
        """
        The List of CORS rules. You can include up to five CorsRule elements in the request. 
        """
        return pulumi.get(self, "cors_rules")


@pulumi.output_type
class CustomDomainResponse(dict):
    """
    The custom domain assigned to this storage account. This can be set via Update.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "useSubDomainName":
            suggest = "use_sub_domain_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CustomDomainResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CustomDomainResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CustomDomainResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 use_sub_domain_name: Optional[bool] = None):
        """
        The custom domain assigned to this storage account. This can be set via Update.
        :param str name: Gets or sets the custom domain name assigned to the storage account. Name is the CNAME source.
        :param bool use_sub_domain_name: Indicates whether indirect CName validation is enabled. Default value is false. This should only be set on updates.
        """
        pulumi.set(__self__, "name", name)
        if use_sub_domain_name is not None:
            pulumi.set(__self__, "use_sub_domain_name", use_sub_domain_name)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Gets or sets the custom domain name assigned to the storage account. Name is the CNAME source.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="useSubDomainName")
    def use_sub_domain_name(self) -> Optional[bool]:
        """
        Indicates whether indirect CName validation is enabled. Default value is false. This should only be set on updates.
        """
        return pulumi.get(self, "use_sub_domain_name")


@pulumi.output_type
class DeleteRetentionPolicyResponse(dict):
    """
    The blob service properties for soft delete.
    """
    def __init__(__self__, *,
                 days: Optional[int] = None,
                 enabled: Optional[bool] = None):
        """
        The blob service properties for soft delete.
        :param int days: Indicates the number of days that the deleted blob should be retained. The minimum specified value can be 1 and the maximum value can be 365.
        :param bool enabled: Indicates whether DeleteRetentionPolicy is enabled for the Blob service.
        """
        if days is not None:
            pulumi.set(__self__, "days", days)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def days(self) -> Optional[int]:
        """
        Indicates the number of days that the deleted blob should be retained. The minimum specified value can be 1 and the maximum value can be 365.
        """
        return pulumi.get(self, "days")

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        """
        Indicates whether DeleteRetentionPolicy is enabled for the Blob service.
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class EncryptionResponse(dict):
    """
    The encryption settings on the storage account.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keySource":
            suggest = "key_source"
        elif key == "keyVaultProperties":
            suggest = "key_vault_properties"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EncryptionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EncryptionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EncryptionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key_source: str,
                 key_vault_properties: Optional['outputs.KeyVaultPropertiesResponse'] = None,
                 services: Optional['outputs.EncryptionServicesResponse'] = None):
        """
        The encryption settings on the storage account.
        :param str key_source: The encryption keySource (provider). Possible values (case-insensitive):  Microsoft.Storage, Microsoft.Keyvault
        :param 'KeyVaultPropertiesResponse' key_vault_properties: Properties provided by key vault.
        :param 'EncryptionServicesResponse' services: List of services which support encryption.
        """
        if key_source is None:
            key_source = 'Microsoft.Storage'
        pulumi.set(__self__, "key_source", key_source)
        if key_vault_properties is not None:
            pulumi.set(__self__, "key_vault_properties", key_vault_properties)
        if services is not None:
            pulumi.set(__self__, "services", services)

    @property
    @pulumi.getter(name="keySource")
    def key_source(self) -> str:
        """
        The encryption keySource (provider). Possible values (case-insensitive):  Microsoft.Storage, Microsoft.Keyvault
        """
        return pulumi.get(self, "key_source")

    @property
    @pulumi.getter(name="keyVaultProperties")
    def key_vault_properties(self) -> Optional['outputs.KeyVaultPropertiesResponse']:
        """
        Properties provided by key vault.
        """
        return pulumi.get(self, "key_vault_properties")

    @property
    @pulumi.getter
    def services(self) -> Optional['outputs.EncryptionServicesResponse']:
        """
        List of services which support encryption.
        """
        return pulumi.get(self, "services")


@pulumi.output_type
class EncryptionServiceResponse(dict):
    """
    A service that allows server-side encryption to be used.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lastEnabledTime":
            suggest = "last_enabled_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EncryptionServiceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EncryptionServiceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EncryptionServiceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 last_enabled_time: str,
                 enabled: Optional[bool] = None):
        """
        A service that allows server-side encryption to be used.
        :param str last_enabled_time: Gets a rough estimate of the date/time when the encryption was last enabled by the user. Only returned when encryption is enabled. There might be some unencrypted blobs which were written after this time, as it is just a rough estimate.
        :param bool enabled: A boolean indicating whether or not the service encrypts the data as it is stored.
        """
        pulumi.set(__self__, "last_enabled_time", last_enabled_time)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter(name="lastEnabledTime")
    def last_enabled_time(self) -> str:
        """
        Gets a rough estimate of the date/time when the encryption was last enabled by the user. Only returned when encryption is enabled. There might be some unencrypted blobs which were written after this time, as it is just a rough estimate.
        """
        return pulumi.get(self, "last_enabled_time")

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        """
        A boolean indicating whether or not the service encrypts the data as it is stored.
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class EncryptionServicesResponse(dict):
    """
    A list of services that support encryption.
    """
    def __init__(__self__, *,
                 queue: 'outputs.EncryptionServiceResponse',
                 table: 'outputs.EncryptionServiceResponse',
                 blob: Optional['outputs.EncryptionServiceResponse'] = None,
                 file: Optional['outputs.EncryptionServiceResponse'] = None):
        """
        A list of services that support encryption.
        :param 'EncryptionServiceResponse' queue: The encryption function of the queue storage service.
        :param 'EncryptionServiceResponse' table: The encryption function of the table storage service.
        :param 'EncryptionServiceResponse' blob: The encryption function of the blob storage service.
        :param 'EncryptionServiceResponse' file: The encryption function of the file storage service.
        """
        pulumi.set(__self__, "queue", queue)
        pulumi.set(__self__, "table", table)
        if blob is not None:
            pulumi.set(__self__, "blob", blob)
        if file is not None:
            pulumi.set(__self__, "file", file)

    @property
    @pulumi.getter
    def queue(self) -> 'outputs.EncryptionServiceResponse':
        """
        The encryption function of the queue storage service.
        """
        return pulumi.get(self, "queue")

    @property
    @pulumi.getter
    def table(self) -> 'outputs.EncryptionServiceResponse':
        """
        The encryption function of the table storage service.
        """
        return pulumi.get(self, "table")

    @property
    @pulumi.getter
    def blob(self) -> Optional['outputs.EncryptionServiceResponse']:
        """
        The encryption function of the blob storage service.
        """
        return pulumi.get(self, "blob")

    @property
    @pulumi.getter
    def file(self) -> Optional['outputs.EncryptionServiceResponse']:
        """
        The encryption function of the file storage service.
        """
        return pulumi.get(self, "file")


@pulumi.output_type
class EndpointsResponse(dict):
    """
    The URIs that are used to perform a retrieval of a public blob, queue, table, web or dfs object.
    """
    def __init__(__self__, *,
                 blob: str,
                 dfs: str,
                 file: str,
                 queue: str,
                 table: str,
                 web: str):
        """
        The URIs that are used to perform a retrieval of a public blob, queue, table, web or dfs object.
        :param str blob: Gets the blob endpoint.
        :param str dfs: Gets the dfs endpoint.
        :param str file: Gets the file endpoint.
        :param str queue: Gets the queue endpoint.
        :param str table: Gets the table endpoint.
        :param str web: Gets the web endpoint.
        """
        pulumi.set(__self__, "blob", blob)
        pulumi.set(__self__, "dfs", dfs)
        pulumi.set(__self__, "file", file)
        pulumi.set(__self__, "queue", queue)
        pulumi.set(__self__, "table", table)
        pulumi.set(__self__, "web", web)

    @property
    @pulumi.getter
    def blob(self) -> str:
        """
        Gets the blob endpoint.
        """
        return pulumi.get(self, "blob")

    @property
    @pulumi.getter
    def dfs(self) -> str:
        """
        Gets the dfs endpoint.
        """
        return pulumi.get(self, "dfs")

    @property
    @pulumi.getter
    def file(self) -> str:
        """
        Gets the file endpoint.
        """
        return pulumi.get(self, "file")

    @property
    @pulumi.getter
    def queue(self) -> str:
        """
        Gets the queue endpoint.
        """
        return pulumi.get(self, "queue")

    @property
    @pulumi.getter
    def table(self) -> str:
        """
        Gets the table endpoint.
        """
        return pulumi.get(self, "table")

    @property
    @pulumi.getter
    def web(self) -> str:
        """
        Gets the web endpoint.
        """
        return pulumi.get(self, "web")


@pulumi.output_type
class GeoReplicationStatsResponse(dict):
    """
    Statistics related to replication for storage account's Blob, Table, Queue and File services. It is only available when geo-redundant replication is enabled for the storage account.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "canFailover":
            suggest = "can_failover"
        elif key == "lastSyncTime":
            suggest = "last_sync_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GeoReplicationStatsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GeoReplicationStatsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GeoReplicationStatsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 can_failover: bool,
                 last_sync_time: str,
                 status: str):
        """
        Statistics related to replication for storage account's Blob, Table, Queue and File services. It is only available when geo-redundant replication is enabled for the storage account.
        :param bool can_failover: A boolean flag which indicates whether or not account failover is supported for the account.
        :param str last_sync_time: All primary writes preceding this UTC date/time value are guaranteed to be available for read operations. Primary writes following this point in time may or may not be available for reads. Element may be default value if value of LastSyncTime is not available, this can happen if secondary is offline or we are in bootstrap.
        :param str status: The status of the secondary location. Possible values are: - Live: Indicates that the secondary location is active and operational. - Bootstrap: Indicates initial synchronization from the primary location to the secondary location is in progress.This typically occurs when replication is first enabled. - Unavailable: Indicates that the secondary location is temporarily unavailable.
        """
        pulumi.set(__self__, "can_failover", can_failover)
        pulumi.set(__self__, "last_sync_time", last_sync_time)
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="canFailover")
    def can_failover(self) -> bool:
        """
        A boolean flag which indicates whether or not account failover is supported for the account.
        """
        return pulumi.get(self, "can_failover")

    @property
    @pulumi.getter(name="lastSyncTime")
    def last_sync_time(self) -> str:
        """
        All primary writes preceding this UTC date/time value are guaranteed to be available for read operations. Primary writes following this point in time may or may not be available for reads. Element may be default value if value of LastSyncTime is not available, this can happen if secondary is offline or we are in bootstrap.
        """
        return pulumi.get(self, "last_sync_time")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of the secondary location. Possible values are: - Live: Indicates that the secondary location is active and operational. - Bootstrap: Indicates initial synchronization from the primary location to the secondary location is in progress.This typically occurs when replication is first enabled. - Unavailable: Indicates that the secondary location is temporarily unavailable.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class IPRuleResponse(dict):
    """
    IP rule with specific IP or IP range in CIDR format.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "iPAddressOrRange":
            suggest = "i_p_address_or_range"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IPRuleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IPRuleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IPRuleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 i_p_address_or_range: str,
                 action: Optional[str] = None):
        """
        IP rule with specific IP or IP range in CIDR format.
        :param str i_p_address_or_range: Specifies the IP or IP range in CIDR format. Only IPV4 address is allowed.
        :param str action: The action of IP ACL rule.
        """
        pulumi.set(__self__, "i_p_address_or_range", i_p_address_or_range)
        if action is None:
            action = 'Allow'
        if action is not None:
            pulumi.set(__self__, "action", action)

    @property
    @pulumi.getter(name="iPAddressOrRange")
    def i_p_address_or_range(self) -> str:
        """
        Specifies the IP or IP range in CIDR format. Only IPV4 address is allowed.
        """
        return pulumi.get(self, "i_p_address_or_range")

    @property
    @pulumi.getter
    def action(self) -> Optional[str]:
        """
        The action of IP ACL rule.
        """
        return pulumi.get(self, "action")


@pulumi.output_type
class IdentityResponse(dict):
    """
    Identity for the resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "principalId":
            suggest = "principal_id"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IdentityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IdentityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IdentityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 principal_id: str,
                 tenant_id: str,
                 type: str):
        """
        Identity for the resource.
        :param str principal_id: The principal ID of resource identity.
        :param str tenant_id: The tenant ID of resource.
        :param str type: The identity type.
        """
        pulumi.set(__self__, "principal_id", principal_id)
        pulumi.set(__self__, "tenant_id", tenant_id)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> str:
        """
        The principal ID of resource identity.
        """
        return pulumi.get(self, "principal_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> str:
        """
        The tenant ID of resource.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The identity type.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ImmutabilityPolicyPropertiesResponse(dict):
    """
    The properties of an ImmutabilityPolicy of a blob container.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "immutabilityPeriodSinceCreationInDays":
            suggest = "immutability_period_since_creation_in_days"
        elif key == "updateHistory":
            suggest = "update_history"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ImmutabilityPolicyPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ImmutabilityPolicyPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ImmutabilityPolicyPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 etag: str,
                 immutability_period_since_creation_in_days: int,
                 state: str,
                 update_history: Sequence['outputs.UpdateHistoryPropertyResponse']):
        """
        The properties of an ImmutabilityPolicy of a blob container.
        :param str etag: ImmutabilityPolicy Etag.
        :param int immutability_period_since_creation_in_days: The immutability period for the blobs in the container since the policy creation, in days.
        :param str state: The ImmutabilityPolicy state of a blob container, possible values include: Locked and Unlocked.
        :param Sequence['UpdateHistoryPropertyResponse'] update_history: The ImmutabilityPolicy update history of the blob container.
        """
        pulumi.set(__self__, "etag", etag)
        pulumi.set(__self__, "immutability_period_since_creation_in_days", immutability_period_since_creation_in_days)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "update_history", update_history)

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        ImmutabilityPolicy Etag.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="immutabilityPeriodSinceCreationInDays")
    def immutability_period_since_creation_in_days(self) -> int:
        """
        The immutability period for the blobs in the container since the policy creation, in days.
        """
        return pulumi.get(self, "immutability_period_since_creation_in_days")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The ImmutabilityPolicy state of a blob container, possible values include: Locked and Unlocked.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="updateHistory")
    def update_history(self) -> Sequence['outputs.UpdateHistoryPropertyResponse']:
        """
        The ImmutabilityPolicy update history of the blob container.
        """
        return pulumi.get(self, "update_history")


@pulumi.output_type
class KeyVaultPropertiesResponse(dict):
    """
    Properties of key vault.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keyName":
            suggest = "key_name"
        elif key == "keyVaultUri":
            suggest = "key_vault_uri"
        elif key == "keyVersion":
            suggest = "key_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KeyVaultPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KeyVaultPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KeyVaultPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key_name: Optional[str] = None,
                 key_vault_uri: Optional[str] = None,
                 key_version: Optional[str] = None):
        """
        Properties of key vault.
        :param str key_name: The name of KeyVault key.
        :param str key_vault_uri: The Uri of KeyVault.
        :param str key_version: The version of KeyVault key.
        """
        if key_name is not None:
            pulumi.set(__self__, "key_name", key_name)
        if key_vault_uri is not None:
            pulumi.set(__self__, "key_vault_uri", key_vault_uri)
        if key_version is not None:
            pulumi.set(__self__, "key_version", key_version)

    @property
    @pulumi.getter(name="keyName")
    def key_name(self) -> Optional[str]:
        """
        The name of KeyVault key.
        """
        return pulumi.get(self, "key_name")

    @property
    @pulumi.getter(name="keyVaultUri")
    def key_vault_uri(self) -> Optional[str]:
        """
        The Uri of KeyVault.
        """
        return pulumi.get(self, "key_vault_uri")

    @property
    @pulumi.getter(name="keyVersion")
    def key_version(self) -> Optional[str]:
        """
        The version of KeyVault key.
        """
        return pulumi.get(self, "key_version")


@pulumi.output_type
class LegalHoldPropertiesResponse(dict):
    """
    The LegalHold property of a blob container.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "hasLegalHold":
            suggest = "has_legal_hold"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LegalHoldPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LegalHoldPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LegalHoldPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 has_legal_hold: bool,
                 tags: Optional[Sequence['outputs.TagPropertyResponse']] = None):
        """
        The LegalHold property of a blob container.
        :param bool has_legal_hold: The hasLegalHold public property is set to true by SRP if there are at least one existing tag. The hasLegalHold public property is set to false by SRP if all existing legal hold tags are cleared out. There can be a maximum of 1000 blob containers with hasLegalHold=true for a given account.
        :param Sequence['TagPropertyResponse'] tags: The list of LegalHold tags of a blob container.
        """
        pulumi.set(__self__, "has_legal_hold", has_legal_hold)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="hasLegalHold")
    def has_legal_hold(self) -> bool:
        """
        The hasLegalHold public property is set to true by SRP if there are at least one existing tag. The hasLegalHold public property is set to false by SRP if all existing legal hold tags are cleared out. There can be a maximum of 1000 blob containers with hasLegalHold=true for a given account.
        """
        return pulumi.get(self, "has_legal_hold")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['outputs.TagPropertyResponse']]:
        """
        The list of LegalHold tags of a blob container.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class NetworkRuleSetResponse(dict):
    """
    Network rule set
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultAction":
            suggest = "default_action"
        elif key == "ipRules":
            suggest = "ip_rules"
        elif key == "virtualNetworkRules":
            suggest = "virtual_network_rules"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkRuleSetResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkRuleSetResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkRuleSetResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_action: str,
                 bypass: Optional[str] = None,
                 ip_rules: Optional[Sequence['outputs.IPRuleResponse']] = None,
                 virtual_network_rules: Optional[Sequence['outputs.VirtualNetworkRuleResponse']] = None):
        """
        Network rule set
        :param str default_action: Specifies the default action of allow or deny when no other rules match.
        :param str bypass: Specifies whether traffic is bypassed for Logging/Metrics/AzureServices. Possible values are any combination of Logging|Metrics|AzureServices (For example, "Logging, Metrics"), or None to bypass none of those traffics.
        :param Sequence['IPRuleResponse'] ip_rules: Sets the IP ACL rules
        :param Sequence['VirtualNetworkRuleResponse'] virtual_network_rules: Sets the virtual network rules
        """
        if default_action is None:
            default_action = 'Allow'
        pulumi.set(__self__, "default_action", default_action)
        if bypass is None:
            bypass = 'AzureServices'
        if bypass is not None:
            pulumi.set(__self__, "bypass", bypass)
        if ip_rules is not None:
            pulumi.set(__self__, "ip_rules", ip_rules)
        if virtual_network_rules is not None:
            pulumi.set(__self__, "virtual_network_rules", virtual_network_rules)

    @property
    @pulumi.getter(name="defaultAction")
    def default_action(self) -> str:
        """
        Specifies the default action of allow or deny when no other rules match.
        """
        return pulumi.get(self, "default_action")

    @property
    @pulumi.getter
    def bypass(self) -> Optional[str]:
        """
        Specifies whether traffic is bypassed for Logging/Metrics/AzureServices. Possible values are any combination of Logging|Metrics|AzureServices (For example, "Logging, Metrics"), or None to bypass none of those traffics.
        """
        return pulumi.get(self, "bypass")

    @property
    @pulumi.getter(name="ipRules")
    def ip_rules(self) -> Optional[Sequence['outputs.IPRuleResponse']]:
        """
        Sets the IP ACL rules
        """
        return pulumi.get(self, "ip_rules")

    @property
    @pulumi.getter(name="virtualNetworkRules")
    def virtual_network_rules(self) -> Optional[Sequence['outputs.VirtualNetworkRuleResponse']]:
        """
        Sets the virtual network rules
        """
        return pulumi.get(self, "virtual_network_rules")


@pulumi.output_type
class RestrictionResponse(dict):
    """
    The restriction because of which SKU cannot be used.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "reasonCode":
            suggest = "reason_code"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RestrictionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RestrictionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RestrictionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 values: Sequence[str],
                 reason_code: Optional[str] = None):
        """
        The restriction because of which SKU cannot be used.
        :param str type: The type of restrictions. As of now only possible value for this is location.
        :param Sequence[str] values: The value of restrictions. If the restriction type is set to location. This would be different locations where the SKU is restricted.
        :param str reason_code: The reason for the restriction. As of now this can be "QuotaId" or "NotAvailableForSubscription". Quota Id is set when the SKU has requiredQuotas parameter as the subscription does not belong to that quota. The "NotAvailableForSubscription" is related to capacity at DC.
        """
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "values", values)
        if reason_code is not None:
            pulumi.set(__self__, "reason_code", reason_code)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of restrictions. As of now only possible value for this is location.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        The value of restrictions. If the restriction type is set to location. This would be different locations where the SKU is restricted.
        """
        return pulumi.get(self, "values")

    @property
    @pulumi.getter(name="reasonCode")
    def reason_code(self) -> Optional[str]:
        """
        The reason for the restriction. As of now this can be "QuotaId" or "NotAvailableForSubscription". Quota Id is set when the SKU has requiredQuotas parameter as the subscription does not belong to that quota. The "NotAvailableForSubscription" is related to capacity at DC.
        """
        return pulumi.get(self, "reason_code")


@pulumi.output_type
class SKUCapabilityResponse(dict):
    """
    The capability information in the specified SKU, including file encryption, network ACLs, change notification, etc.
    """
    def __init__(__self__, *,
                 name: str,
                 value: str):
        """
        The capability information in the specified SKU, including file encryption, network ACLs, change notification, etc.
        :param str name: The name of capability, The capability information in the specified SKU, including file encryption, network ACLs, change notification, etc.
        :param str value: A string value to indicate states of given capability. Possibly 'true' or 'false'.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of capability, The capability information in the specified SKU, including file encryption, network ACLs, change notification, etc.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        A string value to indicate states of given capability. Possibly 'true' or 'false'.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class SkuResponse(dict):
    """
    The SKU of the storage account.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceType":
            suggest = "resource_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SkuResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SkuResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SkuResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 capabilities: Sequence['outputs.SKUCapabilityResponse'],
                 kind: str,
                 locations: Sequence[str],
                 name: str,
                 resource_type: str,
                 tier: str,
                 restrictions: Optional[Sequence['outputs.RestrictionResponse']] = None):
        """
        The SKU of the storage account.
        :param Sequence['SKUCapabilityResponse'] capabilities: The capability information in the specified SKU, including file encryption, network ACLs, change notification, etc.
        :param str kind: Indicates the type of storage account.
        :param Sequence[str] locations: The set of locations that the SKU is available. This will be supported and registered Azure Geo Regions (e.g. West US, East US, Southeast Asia, etc.).
        :param str name: Gets or sets the SKU name. Required for account creation; optional for update. Note that in older versions, SKU name was called accountType.
        :param str resource_type: The type of the resource, usually it is 'storageAccounts'.
        :param str tier: Gets the SKU tier. This is based on the SKU name.
        :param Sequence['RestrictionResponse'] restrictions: The restrictions because of which SKU cannot be used. This is empty if there are no restrictions.
        """
        pulumi.set(__self__, "capabilities", capabilities)
        pulumi.set(__self__, "kind", kind)
        pulumi.set(__self__, "locations", locations)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "resource_type", resource_type)
        pulumi.set(__self__, "tier", tier)
        if restrictions is not None:
            pulumi.set(__self__, "restrictions", restrictions)

    @property
    @pulumi.getter
    def capabilities(self) -> Sequence['outputs.SKUCapabilityResponse']:
        """
        The capability information in the specified SKU, including file encryption, network ACLs, change notification, etc.
        """
        return pulumi.get(self, "capabilities")

    @property
    @pulumi.getter
    def kind(self) -> str:
        """
        Indicates the type of storage account.
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def locations(self) -> Sequence[str]:
        """
        The set of locations that the SKU is available. This will be supported and registered Azure Geo Regions (e.g. West US, East US, Southeast Asia, etc.).
        """
        return pulumi.get(self, "locations")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Gets or sets the SKU name. Required for account creation; optional for update. Note that in older versions, SKU name was called accountType.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> str:
        """
        The type of the resource, usually it is 'storageAccounts'.
        """
        return pulumi.get(self, "resource_type")

    @property
    @pulumi.getter
    def tier(self) -> str:
        """
        Gets the SKU tier. This is based on the SKU name.
        """
        return pulumi.get(self, "tier")

    @property
    @pulumi.getter
    def restrictions(self) -> Optional[Sequence['outputs.RestrictionResponse']]:
        """
        The restrictions because of which SKU cannot be used. This is empty if there are no restrictions.
        """
        return pulumi.get(self, "restrictions")


@pulumi.output_type
class StorageAccountKeyResponse(dict):
    """
    An access key for the storage account.
    """
    def __init__(__self__, *,
                 key_name: str,
                 permissions: str,
                 value: str):
        """
        An access key for the storage account.
        :param str key_name: Name of the key.
        :param str permissions: Permissions for the key -- read-only or full permissions.
        :param str value: Base 64-encoded value of the key.
        """
        pulumi.set(__self__, "key_name", key_name)
        pulumi.set(__self__, "permissions", permissions)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter(name="keyName")
    def key_name(self) -> str:
        """
        Name of the key.
        """
        return pulumi.get(self, "key_name")

    @property
    @pulumi.getter
    def permissions(self) -> str:
        """
        Permissions for the key -- read-only or full permissions.
        """
        return pulumi.get(self, "permissions")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        Base 64-encoded value of the key.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class TagPropertyResponse(dict):
    """
    A tag of the LegalHold of a blob container.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "objectIdentifier":
            suggest = "object_identifier"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TagPropertyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TagPropertyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TagPropertyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 object_identifier: str,
                 tag: str,
                 tenant_id: str,
                 timestamp: str,
                 upn: str):
        """
        A tag of the LegalHold of a blob container.
        :param str object_identifier: Returns the Object ID of the user who added the tag.
        :param str tag: The tag value.
        :param str tenant_id: Returns the Tenant ID that issued the token for the user who added the tag.
        :param str timestamp: Returns the date and time the tag was added.
        :param str upn: Returns the User Principal Name of the user who added the tag.
        """
        pulumi.set(__self__, "object_identifier", object_identifier)
        pulumi.set(__self__, "tag", tag)
        pulumi.set(__self__, "tenant_id", tenant_id)
        pulumi.set(__self__, "timestamp", timestamp)
        pulumi.set(__self__, "upn", upn)

    @property
    @pulumi.getter(name="objectIdentifier")
    def object_identifier(self) -> str:
        """
        Returns the Object ID of the user who added the tag.
        """
        return pulumi.get(self, "object_identifier")

    @property
    @pulumi.getter
    def tag(self) -> str:
        """
        The tag value.
        """
        return pulumi.get(self, "tag")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> str:
        """
        Returns the Tenant ID that issued the token for the user who added the tag.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter
    def timestamp(self) -> str:
        """
        Returns the date and time the tag was added.
        """
        return pulumi.get(self, "timestamp")

    @property
    @pulumi.getter
    def upn(self) -> str:
        """
        Returns the User Principal Name of the user who added the tag.
        """
        return pulumi.get(self, "upn")


@pulumi.output_type
class UpdateHistoryPropertyResponse(dict):
    """
    An update history of the ImmutabilityPolicy of a blob container.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "immutabilityPeriodSinceCreationInDays":
            suggest = "immutability_period_since_creation_in_days"
        elif key == "objectIdentifier":
            suggest = "object_identifier"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UpdateHistoryPropertyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UpdateHistoryPropertyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UpdateHistoryPropertyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 immutability_period_since_creation_in_days: int,
                 object_identifier: str,
                 tenant_id: str,
                 timestamp: str,
                 update: str,
                 upn: str):
        """
        An update history of the ImmutabilityPolicy of a blob container.
        :param int immutability_period_since_creation_in_days: The immutability period for the blobs in the container since the policy creation, in days.
        :param str object_identifier: Returns the Object ID of the user who updated the ImmutabilityPolicy.
        :param str tenant_id: Returns the Tenant ID that issued the token for the user who updated the ImmutabilityPolicy.
        :param str timestamp: Returns the date and time the ImmutabilityPolicy was updated.
        :param str update: The ImmutabilityPolicy update type of a blob container, possible values include: put, lock and extend.
        :param str upn: Returns the User Principal Name of the user who updated the ImmutabilityPolicy.
        """
        pulumi.set(__self__, "immutability_period_since_creation_in_days", immutability_period_since_creation_in_days)
        pulumi.set(__self__, "object_identifier", object_identifier)
        pulumi.set(__self__, "tenant_id", tenant_id)
        pulumi.set(__self__, "timestamp", timestamp)
        pulumi.set(__self__, "update", update)
        pulumi.set(__self__, "upn", upn)

    @property
    @pulumi.getter(name="immutabilityPeriodSinceCreationInDays")
    def immutability_period_since_creation_in_days(self) -> int:
        """
        The immutability period for the blobs in the container since the policy creation, in days.
        """
        return pulumi.get(self, "immutability_period_since_creation_in_days")

    @property
    @pulumi.getter(name="objectIdentifier")
    def object_identifier(self) -> str:
        """
        Returns the Object ID of the user who updated the ImmutabilityPolicy.
        """
        return pulumi.get(self, "object_identifier")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> str:
        """
        Returns the Tenant ID that issued the token for the user who updated the ImmutabilityPolicy.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter
    def timestamp(self) -> str:
        """
        Returns the date and time the ImmutabilityPolicy was updated.
        """
        return pulumi.get(self, "timestamp")

    @property
    @pulumi.getter
    def update(self) -> str:
        """
        The ImmutabilityPolicy update type of a blob container, possible values include: put, lock and extend.
        """
        return pulumi.get(self, "update")

    @property
    @pulumi.getter
    def upn(self) -> str:
        """
        Returns the User Principal Name of the user who updated the ImmutabilityPolicy.
        """
        return pulumi.get(self, "upn")


@pulumi.output_type
class VirtualNetworkRuleResponse(dict):
    """
    Virtual Network rule.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "virtualNetworkResourceId":
            suggest = "virtual_network_resource_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualNetworkRuleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualNetworkRuleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualNetworkRuleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 virtual_network_resource_id: str,
                 action: Optional[str] = None,
                 state: Optional[str] = None):
        """
        Virtual Network rule.
        :param str virtual_network_resource_id: Resource ID of a subnet, for example: /subscriptions/{subscriptionId}/resourceGroups/{groupName}/providers/Microsoft.Network/virtualNetworks/{vnetName}/subnets/{subnetName}.
        :param str action: The action of virtual network rule.
        :param str state: Gets the state of virtual network rule.
        """
        pulumi.set(__self__, "virtual_network_resource_id", virtual_network_resource_id)
        if action is None:
            action = 'Allow'
        if action is not None:
            pulumi.set(__self__, "action", action)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="virtualNetworkResourceId")
    def virtual_network_resource_id(self) -> str:
        """
        Resource ID of a subnet, for example: /subscriptions/{subscriptionId}/resourceGroups/{groupName}/providers/Microsoft.Network/virtualNetworks/{vnetName}/subnets/{subnetName}.
        """
        return pulumi.get(self, "virtual_network_resource_id")

    @property
    @pulumi.getter
    def action(self) -> Optional[str]:
        """
        The action of virtual network rule.
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        Gets the state of virtual network rule.
        """
        return pulumi.get(self, "state")


