# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *
from ._inputs import *

__all__ = ['MoveResourceArgs', 'MoveResource']

@pulumi.input_type
class MoveResourceArgs:
    def __init__(__self__, *,
                 move_collection_name: pulumi.Input[str],
                 resource_group_name: pulumi.Input[str],
                 move_resource_name: Optional[pulumi.Input[str]] = None,
                 properties: Optional[pulumi.Input['MoveResourcePropertiesArgs']] = None):
        """
        The set of arguments for constructing a MoveResource resource.
        :param pulumi.Input[str] move_collection_name: The Move Collection Name.
        :param pulumi.Input[str] resource_group_name: The Resource Group Name.
        :param pulumi.Input[str] move_resource_name: The Move Resource Name.
        :param pulumi.Input['MoveResourcePropertiesArgs'] properties: Defines the move resource properties.
        """
        pulumi.set(__self__, "move_collection_name", move_collection_name)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if move_resource_name is not None:
            pulumi.set(__self__, "move_resource_name", move_resource_name)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)

    @property
    @pulumi.getter(name="moveCollectionName")
    def move_collection_name(self) -> pulumi.Input[str]:
        """
        The Move Collection Name.
        """
        return pulumi.get(self, "move_collection_name")

    @move_collection_name.setter
    def move_collection_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "move_collection_name", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[str]:
        """
        The Resource Group Name.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter(name="moveResourceName")
    def move_resource_name(self) -> Optional[pulumi.Input[str]]:
        """
        The Move Resource Name.
        """
        return pulumi.get(self, "move_resource_name")

    @move_resource_name.setter
    def move_resource_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "move_resource_name", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input['MoveResourcePropertiesArgs']]:
        """
        Defines the move resource properties.
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input['MoveResourcePropertiesArgs']]):
        pulumi.set(self, "properties", value)


class MoveResource(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 move_collection_name: Optional[pulumi.Input[str]] = None,
                 move_resource_name: Optional[pulumi.Input[str]] = None,
                 properties: Optional[pulumi.Input[pulumi.InputType['MoveResourcePropertiesArgs']]] = None,
                 resource_group_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Defines the move resource.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] move_collection_name: The Move Collection Name.
        :param pulumi.Input[str] move_resource_name: The Move Resource Name.
        :param pulumi.Input[pulumi.InputType['MoveResourcePropertiesArgs']] properties: Defines the move resource properties.
        :param pulumi.Input[str] resource_group_name: The Resource Group Name.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MoveResourceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Defines the move resource.

        :param str resource_name: The name of the resource.
        :param MoveResourceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MoveResourceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 move_collection_name: Optional[pulumi.Input[str]] = None,
                 move_resource_name: Optional[pulumi.Input[str]] = None,
                 properties: Optional[pulumi.Input[pulumi.InputType['MoveResourcePropertiesArgs']]] = None,
                 resource_group_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MoveResourceArgs.__new__(MoveResourceArgs)

            if move_collection_name is None and not opts.urn:
                raise TypeError("Missing required property 'move_collection_name'")
            __props__.__dict__["move_collection_name"] = move_collection_name
            __props__.__dict__["move_resource_name"] = move_resource_name
            __props__.__dict__["properties"] = properties
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["name"] = None
            __props__.__dict__["system_data"] = None
            __props__.__dict__["type"] = None
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="azure-native:migrate:MoveResource"), pulumi.Alias(type_="azure-native:migrate/v20191001preview:MoveResource"), pulumi.Alias(type_="azure-native:migrate/v20210101:MoveResource")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        super(MoveResource, __self__).__init__(
            'azure-native:migrate/v20210801:MoveResource',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'MoveResource':
        """
        Get an existing MoveResource resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = MoveResourceArgs.__new__(MoveResourceArgs)

        __props__.__dict__["name"] = None
        __props__.__dict__["properties"] = None
        __props__.__dict__["system_data"] = None
        __props__.__dict__["type"] = None
        return MoveResource(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def properties(self) -> pulumi.Output['outputs.MoveResourcePropertiesResponse']:
        """
        Defines the move resource properties.
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter(name="systemData")
    def system_data(self) -> pulumi.Output['outputs.SystemDataResponse']:
        """
        Metadata pertaining to creation and last modification of the resource.
        """
        return pulumi.get(self, "system_data")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        The type of the resource.
        """
        return pulumi.get(self, "type")

