# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'AdditionalCapabilitiesResponse',
    'AdditionalUnattendContentResponse',
    'ApiEntityReferenceResponse',
    'ApiErrorBaseResponse',
    'ApiErrorResponse',
    'AutomaticOSUpgradePolicyResponse',
    'AutomaticRepairsPolicyResponse',
    'AvailablePatchSummaryResponse',
    'BillingProfileResponse',
    'BootDiagnosticsInstanceViewResponse',
    'BootDiagnosticsResponse',
    'DataDiskResponse',
    'DedicatedHostAllocatableVMResponse',
    'DedicatedHostAvailableCapacityResponse',
    'DedicatedHostGroupInstanceViewResponse',
    'DedicatedHostInstanceViewResponse',
    'DedicatedHostInstanceViewWithNameResponse',
    'DiagnosticsProfileResponse',
    'DiffDiskSettingsResponse',
    'DiskEncryptionSetParametersResponse',
    'DiskEncryptionSettingsResponse',
    'DiskInstanceViewResponse',
    'HardwareProfileResponse',
    'ImageDataDiskResponse',
    'ImageOSDiskResponse',
    'ImageReferenceResponse',
    'ImageStorageProfileResponse',
    'InnerErrorResponse',
    'InstanceViewStatusResponse',
    'KeyVaultKeyReferenceResponse',
    'KeyVaultSecretReferenceResponse',
    'LastPatchInstallationSummaryResponse',
    'LinuxConfigurationResponse',
    'LogAnalyticsOutputResponse',
    'MaintenanceRedeployStatusResponse',
    'ManagedDiskParametersResponse',
    'NetworkInterfaceReferenceResponse',
    'NetworkProfileResponse',
    'OSDiskResponse',
    'OSProfileResponse',
    'PatchSettingsResponse',
    'PlanResponse',
    'RollingUpgradePolicyResponse',
    'RunCommandInputParameterResponse',
    'ScaleInPolicyResponse',
    'ScheduledEventsProfileResponse',
    'SecurityProfileResponse',
    'SkuResponse',
    'SshConfigurationResponse',
    'SshPublicKeyResponse',
    'StorageProfileResponse',
    'SubResourceReadOnlyResponse',
    'SubResourceResponse',
    'SubResourceWithColocationStatusResponse',
    'TerminateNotificationProfileResponse',
    'UpgradePolicyResponse',
    'VaultCertificateResponse',
    'VaultSecretGroupResponse',
    'VirtualHardDiskResponse',
    'VirtualMachineAgentInstanceViewResponse',
    'VirtualMachineExtensionHandlerInstanceViewResponse',
    'VirtualMachineExtensionInstanceViewResponse',
    'VirtualMachineExtensionResponse',
    'VirtualMachineHealthStatusResponse',
    'VirtualMachineIdentityResponse',
    'VirtualMachineIdentityResponseUserAssignedIdentities',
    'VirtualMachineInstanceViewResponse',
    'VirtualMachinePatchStatusResponse',
    'VirtualMachineRunCommandInstanceViewResponse',
    'VirtualMachineRunCommandScriptSourceResponse',
    'VirtualMachineScaleSetDataDiskResponse',
    'VirtualMachineScaleSetExtensionProfileResponse',
    'VirtualMachineScaleSetExtensionResponse',
    'VirtualMachineScaleSetIPConfigurationResponse',
    'VirtualMachineScaleSetIdentityResponse',
    'VirtualMachineScaleSetIdentityResponseUserAssignedIdentities',
    'VirtualMachineScaleSetIpTagResponse',
    'VirtualMachineScaleSetManagedDiskParametersResponse',
    'VirtualMachineScaleSetNetworkConfigurationDnsSettingsResponse',
    'VirtualMachineScaleSetNetworkConfigurationResponse',
    'VirtualMachineScaleSetNetworkProfileResponse',
    'VirtualMachineScaleSetOSDiskResponse',
    'VirtualMachineScaleSetOSProfileResponse',
    'VirtualMachineScaleSetPublicIPAddressConfigurationDnsSettingsResponse',
    'VirtualMachineScaleSetPublicIPAddressConfigurationResponse',
    'VirtualMachineScaleSetStorageProfileResponse',
    'VirtualMachineScaleSetVMInstanceViewResponse',
    'VirtualMachineScaleSetVMNetworkProfileConfigurationResponse',
    'VirtualMachineScaleSetVMProfileResponse',
    'VirtualMachineScaleSetVMProtectionPolicyResponse',
    'WinRMConfigurationResponse',
    'WinRMListenerResponse',
    'WindowsConfigurationResponse',
]

@pulumi.output_type
class AdditionalCapabilitiesResponse(dict):
    """
    Enables or disables a capability on the virtual machine or virtual machine scale set.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ultraSSDEnabled":
            suggest = "ultra_ssd_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AdditionalCapabilitiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AdditionalCapabilitiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AdditionalCapabilitiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ultra_ssd_enabled: Optional[bool] = None):
        """
        Enables or disables a capability on the virtual machine or virtual machine scale set.
        :param bool ultra_ssd_enabled: The flag that enables or disables a capability to have one or more managed data disks with UltraSSD_LRS storage account type on the VM or VMSS. Managed disks with storage account type UltraSSD_LRS can be added to a virtual machine or virtual machine scale set only if this property is enabled.
        """
        if ultra_ssd_enabled is not None:
            pulumi.set(__self__, "ultra_ssd_enabled", ultra_ssd_enabled)

    @property
    @pulumi.getter(name="ultraSSDEnabled")
    def ultra_ssd_enabled(self) -> Optional[bool]:
        """
        The flag that enables or disables a capability to have one or more managed data disks with UltraSSD_LRS storage account type on the VM or VMSS. Managed disks with storage account type UltraSSD_LRS can be added to a virtual machine or virtual machine scale set only if this property is enabled.
        """
        return pulumi.get(self, "ultra_ssd_enabled")


@pulumi.output_type
class AdditionalUnattendContentResponse(dict):
    """
    Specifies additional XML formatted information that can be included in the Unattend.xml file, which is used by Windows Setup. Contents are defined by setting name, component name, and the pass in which the content is applied.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "componentName":
            suggest = "component_name"
        elif key == "passName":
            suggest = "pass_name"
        elif key == "settingName":
            suggest = "setting_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AdditionalUnattendContentResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AdditionalUnattendContentResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AdditionalUnattendContentResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 component_name: Optional[str] = None,
                 content: Optional[str] = None,
                 pass_name: Optional[str] = None,
                 setting_name: Optional[str] = None):
        """
        Specifies additional XML formatted information that can be included in the Unattend.xml file, which is used by Windows Setup. Contents are defined by setting name, component name, and the pass in which the content is applied.
        :param str component_name: The component name. Currently, the only allowable value is Microsoft-Windows-Shell-Setup.
        :param str content: Specifies the XML formatted content that is added to the unattend.xml file for the specified path and component. The XML must be less than 4KB and must include the root element for the setting or feature that is being inserted.
        :param str pass_name: The pass name. Currently, the only allowable value is OobeSystem.
        :param str setting_name: Specifies the name of the setting to which the content applies. Possible values are: FirstLogonCommands and AutoLogon.
        """
        if component_name is not None:
            pulumi.set(__self__, "component_name", component_name)
        if content is not None:
            pulumi.set(__self__, "content", content)
        if pass_name is not None:
            pulumi.set(__self__, "pass_name", pass_name)
        if setting_name is not None:
            pulumi.set(__self__, "setting_name", setting_name)

    @property
    @pulumi.getter(name="componentName")
    def component_name(self) -> Optional[str]:
        """
        The component name. Currently, the only allowable value is Microsoft-Windows-Shell-Setup.
        """
        return pulumi.get(self, "component_name")

    @property
    @pulumi.getter
    def content(self) -> Optional[str]:
        """
        Specifies the XML formatted content that is added to the unattend.xml file for the specified path and component. The XML must be less than 4KB and must include the root element for the setting or feature that is being inserted.
        """
        return pulumi.get(self, "content")

    @property
    @pulumi.getter(name="passName")
    def pass_name(self) -> Optional[str]:
        """
        The pass name. Currently, the only allowable value is OobeSystem.
        """
        return pulumi.get(self, "pass_name")

    @property
    @pulumi.getter(name="settingName")
    def setting_name(self) -> Optional[str]:
        """
        Specifies the name of the setting to which the content applies. Possible values are: FirstLogonCommands and AutoLogon.
        """
        return pulumi.get(self, "setting_name")


@pulumi.output_type
class ApiEntityReferenceResponse(dict):
    """
    The API entity reference.
    """
    def __init__(__self__, *,
                 id: Optional[str] = None):
        """
        The API entity reference.
        :param str id: The ARM resource id in the form of /subscriptions/{SubscriptionId}/resourceGroups/{ResourceGroupName}/...
        """
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The ARM resource id in the form of /subscriptions/{SubscriptionId}/resourceGroups/{ResourceGroupName}/...
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class ApiErrorBaseResponse(dict):
    """
    Api error base.
    """
    def __init__(__self__, *,
                 code: Optional[str] = None,
                 message: Optional[str] = None,
                 target: Optional[str] = None):
        """
        Api error base.
        :param str code: The error code.
        :param str message: The error message.
        :param str target: The target of the particular error.
        """
        if code is not None:
            pulumi.set(__self__, "code", code)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if target is not None:
            pulumi.set(__self__, "target", target)

    @property
    @pulumi.getter
    def code(self) -> Optional[str]:
        """
        The error code.
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter
    def message(self) -> Optional[str]:
        """
        The error message.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def target(self) -> Optional[str]:
        """
        The target of the particular error.
        """
        return pulumi.get(self, "target")


@pulumi.output_type
class ApiErrorResponse(dict):
    """
    Api error.
    """
    def __init__(__self__, *,
                 code: Optional[str] = None,
                 details: Optional[Sequence['outputs.ApiErrorBaseResponse']] = None,
                 innererror: Optional['outputs.InnerErrorResponse'] = None,
                 message: Optional[str] = None,
                 target: Optional[str] = None):
        """
        Api error.
        :param str code: The error code.
        :param Sequence['ApiErrorBaseResponse'] details: The Api error details
        :param 'InnerErrorResponse' innererror: The Api inner error
        :param str message: The error message.
        :param str target: The target of the particular error.
        """
        if code is not None:
            pulumi.set(__self__, "code", code)
        if details is not None:
            pulumi.set(__self__, "details", details)
        if innererror is not None:
            pulumi.set(__self__, "innererror", innererror)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if target is not None:
            pulumi.set(__self__, "target", target)

    @property
    @pulumi.getter
    def code(self) -> Optional[str]:
        """
        The error code.
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter
    def details(self) -> Optional[Sequence['outputs.ApiErrorBaseResponse']]:
        """
        The Api error details
        """
        return pulumi.get(self, "details")

    @property
    @pulumi.getter
    def innererror(self) -> Optional['outputs.InnerErrorResponse']:
        """
        The Api inner error
        """
        return pulumi.get(self, "innererror")

    @property
    @pulumi.getter
    def message(self) -> Optional[str]:
        """
        The error message.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def target(self) -> Optional[str]:
        """
        The target of the particular error.
        """
        return pulumi.get(self, "target")


@pulumi.output_type
class AutomaticOSUpgradePolicyResponse(dict):
    """
    The configuration parameters used for performing automatic OS upgrade.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "disableAutomaticRollback":
            suggest = "disable_automatic_rollback"
        elif key == "enableAutomaticOSUpgrade":
            suggest = "enable_automatic_os_upgrade"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AutomaticOSUpgradePolicyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AutomaticOSUpgradePolicyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AutomaticOSUpgradePolicyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 disable_automatic_rollback: Optional[bool] = None,
                 enable_automatic_os_upgrade: Optional[bool] = None):
        """
        The configuration parameters used for performing automatic OS upgrade.
        :param bool disable_automatic_rollback: Whether OS image rollback feature should be disabled. Default value is false.
        :param bool enable_automatic_os_upgrade: Indicates whether OS upgrades should automatically be applied to scale set instances in a rolling fashion when a newer version of the OS image becomes available. Default value is false. <br><br> If this is set to true for Windows based scale sets, [enableAutomaticUpdates](https://docs.microsoft.com/dotnet/api/microsoft.azure.management.compute.models.windowsconfiguration.enableautomaticupdates?view=azure-dotnet) is automatically set to false and cannot be set to true.
        """
        if disable_automatic_rollback is not None:
            pulumi.set(__self__, "disable_automatic_rollback", disable_automatic_rollback)
        if enable_automatic_os_upgrade is not None:
            pulumi.set(__self__, "enable_automatic_os_upgrade", enable_automatic_os_upgrade)

    @property
    @pulumi.getter(name="disableAutomaticRollback")
    def disable_automatic_rollback(self) -> Optional[bool]:
        """
        Whether OS image rollback feature should be disabled. Default value is false.
        """
        return pulumi.get(self, "disable_automatic_rollback")

    @property
    @pulumi.getter(name="enableAutomaticOSUpgrade")
    def enable_automatic_os_upgrade(self) -> Optional[bool]:
        """
        Indicates whether OS upgrades should automatically be applied to scale set instances in a rolling fashion when a newer version of the OS image becomes available. Default value is false. <br><br> If this is set to true for Windows based scale sets, [enableAutomaticUpdates](https://docs.microsoft.com/dotnet/api/microsoft.azure.management.compute.models.windowsconfiguration.enableautomaticupdates?view=azure-dotnet) is automatically set to false and cannot be set to true.
        """
        return pulumi.get(self, "enable_automatic_os_upgrade")


@pulumi.output_type
class AutomaticRepairsPolicyResponse(dict):
    """
    Specifies the configuration parameters for automatic repairs on the virtual machine scale set.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "gracePeriod":
            suggest = "grace_period"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AutomaticRepairsPolicyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AutomaticRepairsPolicyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AutomaticRepairsPolicyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: Optional[bool] = None,
                 grace_period: Optional[str] = None):
        """
        Specifies the configuration parameters for automatic repairs on the virtual machine scale set.
        :param bool enabled: Specifies whether automatic repairs should be enabled on the virtual machine scale set. The default value is false.
        :param str grace_period: The amount of time for which automatic repairs are suspended due to a state change on VM. The grace time starts after the state change has completed. This helps avoid premature or accidental repairs. The time duration should be specified in ISO 8601 format. The minimum allowed grace period is 30 minutes (PT30M), which is also the default value. The maximum allowed grace period is 90 minutes (PT90M).
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if grace_period is not None:
            pulumi.set(__self__, "grace_period", grace_period)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        """
        Specifies whether automatic repairs should be enabled on the virtual machine scale set. The default value is false.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="gracePeriod")
    def grace_period(self) -> Optional[str]:
        """
        The amount of time for which automatic repairs are suspended due to a state change on VM. The grace time starts after the state change has completed. This helps avoid premature or accidental repairs. The time duration should be specified in ISO 8601 format. The minimum allowed grace period is 30 minutes (PT30M), which is also the default value. The maximum allowed grace period is 90 minutes (PT90M).
        """
        return pulumi.get(self, "grace_period")


@pulumi.output_type
class AvailablePatchSummaryResponse(dict):
    """
    Describes the properties of an virtual machine instance view for available patch summary.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "assessmentActivityId":
            suggest = "assessment_activity_id"
        elif key == "criticalAndSecurityPatchCount":
            suggest = "critical_and_security_patch_count"
        elif key == "lastModifiedTime":
            suggest = "last_modified_time"
        elif key == "otherPatchCount":
            suggest = "other_patch_count"
        elif key == "rebootPending":
            suggest = "reboot_pending"
        elif key == "startTime":
            suggest = "start_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AvailablePatchSummaryResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AvailablePatchSummaryResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AvailablePatchSummaryResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 assessment_activity_id: str,
                 critical_and_security_patch_count: int,
                 error: 'outputs.ApiErrorResponse',
                 last_modified_time: str,
                 other_patch_count: int,
                 reboot_pending: bool,
                 start_time: str,
                 status: str):
        """
        Describes the properties of an virtual machine instance view for available patch summary.
        :param str assessment_activity_id: The activity ID of the operation that produced this result. It is used to correlate across CRP and extension logs.
        :param int critical_and_security_patch_count: The number of critical or security patches that have been detected as available and not yet installed.
        :param 'ApiErrorResponse' error: The errors that were encountered during execution of the operation. The details array contains the list of them.
        :param str last_modified_time: The UTC timestamp when the operation began.
        :param int other_patch_count: The number of all available patches excluding critical and security.
        :param bool reboot_pending: The overall reboot status of the VM. It will be true when partially installed patches require a reboot to complete installation but the reboot has not yet occurred.
        :param str start_time: The UTC timestamp when the operation began.
        :param str status: The overall success or failure status of the operation. It remains "InProgress" until the operation completes. At that point it will become "Failed", "Succeeded", or "CompletedWithWarnings."
        """
        pulumi.set(__self__, "assessment_activity_id", assessment_activity_id)
        pulumi.set(__self__, "critical_and_security_patch_count", critical_and_security_patch_count)
        pulumi.set(__self__, "error", error)
        pulumi.set(__self__, "last_modified_time", last_modified_time)
        pulumi.set(__self__, "other_patch_count", other_patch_count)
        pulumi.set(__self__, "reboot_pending", reboot_pending)
        pulumi.set(__self__, "start_time", start_time)
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="assessmentActivityId")
    def assessment_activity_id(self) -> str:
        """
        The activity ID of the operation that produced this result. It is used to correlate across CRP and extension logs.
        """
        return pulumi.get(self, "assessment_activity_id")

    @property
    @pulumi.getter(name="criticalAndSecurityPatchCount")
    def critical_and_security_patch_count(self) -> int:
        """
        The number of critical or security patches that have been detected as available and not yet installed.
        """
        return pulumi.get(self, "critical_and_security_patch_count")

    @property
    @pulumi.getter
    def error(self) -> 'outputs.ApiErrorResponse':
        """
        The errors that were encountered during execution of the operation. The details array contains the list of them.
        """
        return pulumi.get(self, "error")

    @property
    @pulumi.getter(name="lastModifiedTime")
    def last_modified_time(self) -> str:
        """
        The UTC timestamp when the operation began.
        """
        return pulumi.get(self, "last_modified_time")

    @property
    @pulumi.getter(name="otherPatchCount")
    def other_patch_count(self) -> int:
        """
        The number of all available patches excluding critical and security.
        """
        return pulumi.get(self, "other_patch_count")

    @property
    @pulumi.getter(name="rebootPending")
    def reboot_pending(self) -> bool:
        """
        The overall reboot status of the VM. It will be true when partially installed patches require a reboot to complete installation but the reboot has not yet occurred.
        """
        return pulumi.get(self, "reboot_pending")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> str:
        """
        The UTC timestamp when the operation began.
        """
        return pulumi.get(self, "start_time")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The overall success or failure status of the operation. It remains "InProgress" until the operation completes. At that point it will become "Failed", "Succeeded", or "CompletedWithWarnings."
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class BillingProfileResponse(dict):
    """
    Specifies the billing related details of a Azure Spot VM or VMSS. <br><br>Minimum api-version: 2019-03-01.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxPrice":
            suggest = "max_price"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BillingProfileResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BillingProfileResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BillingProfileResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_price: Optional[float] = None):
        """
        Specifies the billing related details of a Azure Spot VM or VMSS. <br><br>Minimum api-version: 2019-03-01.
        :param float max_price: Specifies the maximum price you are willing to pay for a Azure Spot VM/VMSS. This price is in US Dollars. <br><br> This price will be compared with the current Azure Spot price for the VM size. Also, the prices are compared at the time of create/update of Azure Spot VM/VMSS and the operation will only succeed if  the maxPrice is greater than the current Azure Spot price. <br><br> The maxPrice will also be used for evicting a Azure Spot VM/VMSS if the current Azure Spot price goes beyond the maxPrice after creation of VM/VMSS. <br><br> Possible values are: <br><br> - Any decimal value greater than zero. Example: 0.01538 <br><br> -1 – indicates default price to be up-to on-demand. <br><br> You can set the maxPrice to -1 to indicate that the Azure Spot VM/VMSS should not be evicted for price reasons. Also, the default max price is -1 if it is not provided by you. <br><br>Minimum api-version: 2019-03-01.
        """
        if max_price is not None:
            pulumi.set(__self__, "max_price", max_price)

    @property
    @pulumi.getter(name="maxPrice")
    def max_price(self) -> Optional[float]:
        """
        Specifies the maximum price you are willing to pay for a Azure Spot VM/VMSS. This price is in US Dollars. <br><br> This price will be compared with the current Azure Spot price for the VM size. Also, the prices are compared at the time of create/update of Azure Spot VM/VMSS and the operation will only succeed if  the maxPrice is greater than the current Azure Spot price. <br><br> The maxPrice will also be used for evicting a Azure Spot VM/VMSS if the current Azure Spot price goes beyond the maxPrice after creation of VM/VMSS. <br><br> Possible values are: <br><br> - Any decimal value greater than zero. Example: 0.01538 <br><br> -1 – indicates default price to be up-to on-demand. <br><br> You can set the maxPrice to -1 to indicate that the Azure Spot VM/VMSS should not be evicted for price reasons. Also, the default max price is -1 if it is not provided by you. <br><br>Minimum api-version: 2019-03-01.
        """
        return pulumi.get(self, "max_price")


@pulumi.output_type
class BootDiagnosticsInstanceViewResponse(dict):
    """
    The instance view of a virtual machine boot diagnostics.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "consoleScreenshotBlobUri":
            suggest = "console_screenshot_blob_uri"
        elif key == "serialConsoleLogBlobUri":
            suggest = "serial_console_log_blob_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BootDiagnosticsInstanceViewResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BootDiagnosticsInstanceViewResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BootDiagnosticsInstanceViewResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 console_screenshot_blob_uri: str,
                 serial_console_log_blob_uri: str,
                 status: 'outputs.InstanceViewStatusResponse'):
        """
        The instance view of a virtual machine boot diagnostics.
        :param str console_screenshot_blob_uri: The console screenshot blob URI. <br><br>NOTE: This will **not** be set if boot diagnostics is currently enabled with managed storage.
        :param str serial_console_log_blob_uri: The serial console log blob Uri. <br><br>NOTE: This will **not** be set if boot diagnostics is currently enabled with managed storage.
        :param 'InstanceViewStatusResponse' status: The boot diagnostics status information for the VM. <br><br> NOTE: It will be set only if there are errors encountered in enabling boot diagnostics.
        """
        pulumi.set(__self__, "console_screenshot_blob_uri", console_screenshot_blob_uri)
        pulumi.set(__self__, "serial_console_log_blob_uri", serial_console_log_blob_uri)
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="consoleScreenshotBlobUri")
    def console_screenshot_blob_uri(self) -> str:
        """
        The console screenshot blob URI. <br><br>NOTE: This will **not** be set if boot diagnostics is currently enabled with managed storage.
        """
        return pulumi.get(self, "console_screenshot_blob_uri")

    @property
    @pulumi.getter(name="serialConsoleLogBlobUri")
    def serial_console_log_blob_uri(self) -> str:
        """
        The serial console log blob Uri. <br><br>NOTE: This will **not** be set if boot diagnostics is currently enabled with managed storage.
        """
        return pulumi.get(self, "serial_console_log_blob_uri")

    @property
    @pulumi.getter
    def status(self) -> 'outputs.InstanceViewStatusResponse':
        """
        The boot diagnostics status information for the VM. <br><br> NOTE: It will be set only if there are errors encountered in enabling boot diagnostics.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class BootDiagnosticsResponse(dict):
    """
    Boot Diagnostics is a debugging feature which allows you to view Console Output and Screenshot to diagnose VM status. <br><br> You can easily view the output of your console log. <br><br> Azure also enables you to see a screenshot of the VM from the hypervisor.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "storageUri":
            suggest = "storage_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BootDiagnosticsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BootDiagnosticsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BootDiagnosticsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: Optional[bool] = None,
                 storage_uri: Optional[str] = None):
        """
        Boot Diagnostics is a debugging feature which allows you to view Console Output and Screenshot to diagnose VM status. <br><br> You can easily view the output of your console log. <br><br> Azure also enables you to see a screenshot of the VM from the hypervisor.
        :param bool enabled: Whether boot diagnostics should be enabled on the Virtual Machine.
        :param str storage_uri: Uri of the storage account to use for placing the console output and screenshot. <br><br>If storageUri is not specified while enabling boot diagnostics, managed storage will be used.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if storage_uri is not None:
            pulumi.set(__self__, "storage_uri", storage_uri)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        """
        Whether boot diagnostics should be enabled on the Virtual Machine.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="storageUri")
    def storage_uri(self) -> Optional[str]:
        """
        Uri of the storage account to use for placing the console output and screenshot. <br><br>If storageUri is not specified while enabling boot diagnostics, managed storage will be used.
        """
        return pulumi.get(self, "storage_uri")


@pulumi.output_type
class DataDiskResponse(dict):
    """
    Describes a data disk.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createOption":
            suggest = "create_option"
        elif key == "diskIOPSReadWrite":
            suggest = "disk_iops_read_write"
        elif key == "diskMBpsReadWrite":
            suggest = "disk_m_bps_read_write"
        elif key == "diskSizeGB":
            suggest = "disk_size_gb"
        elif key == "managedDisk":
            suggest = "managed_disk"
        elif key == "toBeDetached":
            suggest = "to_be_detached"
        elif key == "writeAcceleratorEnabled":
            suggest = "write_accelerator_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataDiskResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataDiskResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataDiskResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 create_option: str,
                 disk_iops_read_write: float,
                 disk_m_bps_read_write: float,
                 lun: int,
                 caching: Optional[str] = None,
                 disk_size_gb: Optional[int] = None,
                 image: Optional['outputs.VirtualHardDiskResponse'] = None,
                 managed_disk: Optional['outputs.ManagedDiskParametersResponse'] = None,
                 name: Optional[str] = None,
                 to_be_detached: Optional[bool] = None,
                 vhd: Optional['outputs.VirtualHardDiskResponse'] = None,
                 write_accelerator_enabled: Optional[bool] = None):
        """
        Describes a data disk.
        :param str create_option: Specifies how the virtual machine should be created.<br><br> Possible values are:<br><br> **Attach** \u2013 This value is used when you are using a specialized disk to create the virtual machine.<br><br> **FromImage** \u2013 This value is used when you are using an image to create the virtual machine. If you are using a platform image, you also use the imageReference element described above. If you are using a marketplace image, you  also use the plan element previously described.
        :param float disk_iops_read_write: Specifies the Read-Write IOPS for the managed disk when StorageAccountType is UltraSSD_LRS. Returned only for VirtualMachine ScaleSet VM disks. Can be updated only via updates to the VirtualMachine Scale Set.
        :param float disk_m_bps_read_write: Specifies the bandwidth in MB per second for the managed disk when StorageAccountType is UltraSSD_LRS. Returned only for VirtualMachine ScaleSet VM disks. Can be updated only via updates to the VirtualMachine Scale Set.
        :param int lun: Specifies the logical unit number of the data disk. This value is used to identify data disks within the VM and therefore must be unique for each data disk attached to a VM.
        :param str caching: Specifies the caching requirements. <br><br> Possible values are: <br><br> **None** <br><br> **ReadOnly** <br><br> **ReadWrite** <br><br> Default: **None for Standard storage. ReadOnly for Premium storage**
        :param int disk_size_gb: Specifies the size of an empty data disk in gigabytes. This element can be used to overwrite the size of the disk in a virtual machine image. <br><br> This value cannot be larger than 1023 GB
        :param 'VirtualHardDiskResponse' image: The source user image virtual hard disk. The virtual hard disk will be copied before being attached to the virtual machine. If SourceImage is provided, the destination virtual hard drive must not exist.
        :param 'ManagedDiskParametersResponse' managed_disk: The managed disk parameters.
        :param str name: The disk name.
        :param bool to_be_detached: Specifies whether the data disk is in process of detachment from the VirtualMachine/VirtualMachineScaleset
        :param 'VirtualHardDiskResponse' vhd: The virtual hard disk.
        :param bool write_accelerator_enabled: Specifies whether writeAccelerator should be enabled or disabled on the disk.
        """
        pulumi.set(__self__, "create_option", create_option)
        pulumi.set(__self__, "disk_iops_read_write", disk_iops_read_write)
        pulumi.set(__self__, "disk_m_bps_read_write", disk_m_bps_read_write)
        pulumi.set(__self__, "lun", lun)
        if caching is not None:
            pulumi.set(__self__, "caching", caching)
        if disk_size_gb is not None:
            pulumi.set(__self__, "disk_size_gb", disk_size_gb)
        if image is not None:
            pulumi.set(__self__, "image", image)
        if managed_disk is not None:
            pulumi.set(__self__, "managed_disk", managed_disk)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if to_be_detached is not None:
            pulumi.set(__self__, "to_be_detached", to_be_detached)
        if vhd is not None:
            pulumi.set(__self__, "vhd", vhd)
        if write_accelerator_enabled is not None:
            pulumi.set(__self__, "write_accelerator_enabled", write_accelerator_enabled)

    @property
    @pulumi.getter(name="createOption")
    def create_option(self) -> str:
        """
        Specifies how the virtual machine should be created.<br><br> Possible values are:<br><br> **Attach** \u2013 This value is used when you are using a specialized disk to create the virtual machine.<br><br> **FromImage** \u2013 This value is used when you are using an image to create the virtual machine. If you are using a platform image, you also use the imageReference element described above. If you are using a marketplace image, you  also use the plan element previously described.
        """
        return pulumi.get(self, "create_option")

    @property
    @pulumi.getter(name="diskIOPSReadWrite")
    def disk_iops_read_write(self) -> float:
        """
        Specifies the Read-Write IOPS for the managed disk when StorageAccountType is UltraSSD_LRS. Returned only for VirtualMachine ScaleSet VM disks. Can be updated only via updates to the VirtualMachine Scale Set.
        """
        return pulumi.get(self, "disk_iops_read_write")

    @property
    @pulumi.getter(name="diskMBpsReadWrite")
    def disk_m_bps_read_write(self) -> float:
        """
        Specifies the bandwidth in MB per second for the managed disk when StorageAccountType is UltraSSD_LRS. Returned only for VirtualMachine ScaleSet VM disks. Can be updated only via updates to the VirtualMachine Scale Set.
        """
        return pulumi.get(self, "disk_m_bps_read_write")

    @property
    @pulumi.getter
    def lun(self) -> int:
        """
        Specifies the logical unit number of the data disk. This value is used to identify data disks within the VM and therefore must be unique for each data disk attached to a VM.
        """
        return pulumi.get(self, "lun")

    @property
    @pulumi.getter
    def caching(self) -> Optional[str]:
        """
        Specifies the caching requirements. <br><br> Possible values are: <br><br> **None** <br><br> **ReadOnly** <br><br> **ReadWrite** <br><br> Default: **None for Standard storage. ReadOnly for Premium storage**
        """
        return pulumi.get(self, "caching")

    @property
    @pulumi.getter(name="diskSizeGB")
    def disk_size_gb(self) -> Optional[int]:
        """
        Specifies the size of an empty data disk in gigabytes. This element can be used to overwrite the size of the disk in a virtual machine image. <br><br> This value cannot be larger than 1023 GB
        """
        return pulumi.get(self, "disk_size_gb")

    @property
    @pulumi.getter
    def image(self) -> Optional['outputs.VirtualHardDiskResponse']:
        """
        The source user image virtual hard disk. The virtual hard disk will be copied before being attached to the virtual machine. If SourceImage is provided, the destination virtual hard drive must not exist.
        """
        return pulumi.get(self, "image")

    @property
    @pulumi.getter(name="managedDisk")
    def managed_disk(self) -> Optional['outputs.ManagedDiskParametersResponse']:
        """
        The managed disk parameters.
        """
        return pulumi.get(self, "managed_disk")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The disk name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="toBeDetached")
    def to_be_detached(self) -> Optional[bool]:
        """
        Specifies whether the data disk is in process of detachment from the VirtualMachine/VirtualMachineScaleset
        """
        return pulumi.get(self, "to_be_detached")

    @property
    @pulumi.getter
    def vhd(self) -> Optional['outputs.VirtualHardDiskResponse']:
        """
        The virtual hard disk.
        """
        return pulumi.get(self, "vhd")

    @property
    @pulumi.getter(name="writeAcceleratorEnabled")
    def write_accelerator_enabled(self) -> Optional[bool]:
        """
        Specifies whether writeAccelerator should be enabled or disabled on the disk.
        """
        return pulumi.get(self, "write_accelerator_enabled")


@pulumi.output_type
class DedicatedHostAllocatableVMResponse(dict):
    """
    Represents the dedicated host unutilized capacity in terms of a specific VM size.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "vmSize":
            suggest = "vm_size"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DedicatedHostAllocatableVMResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DedicatedHostAllocatableVMResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DedicatedHostAllocatableVMResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 count: Optional[float] = None,
                 vm_size: Optional[str] = None):
        """
        Represents the dedicated host unutilized capacity in terms of a specific VM size.
        :param float count: Maximum number of VMs of size vmSize that can fit in the dedicated host's remaining capacity.
        :param str vm_size: VM size in terms of which the unutilized capacity is represented.
        """
        if count is not None:
            pulumi.set(__self__, "count", count)
        if vm_size is not None:
            pulumi.set(__self__, "vm_size", vm_size)

    @property
    @pulumi.getter
    def count(self) -> Optional[float]:
        """
        Maximum number of VMs of size vmSize that can fit in the dedicated host's remaining capacity.
        """
        return pulumi.get(self, "count")

    @property
    @pulumi.getter(name="vmSize")
    def vm_size(self) -> Optional[str]:
        """
        VM size in terms of which the unutilized capacity is represented.
        """
        return pulumi.get(self, "vm_size")


@pulumi.output_type
class DedicatedHostAvailableCapacityResponse(dict):
    """
    Dedicated host unutilized capacity.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allocatableVMs":
            suggest = "allocatable_vms"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DedicatedHostAvailableCapacityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DedicatedHostAvailableCapacityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DedicatedHostAvailableCapacityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allocatable_vms: Optional[Sequence['outputs.DedicatedHostAllocatableVMResponse']] = None):
        """
        Dedicated host unutilized capacity.
        :param Sequence['DedicatedHostAllocatableVMResponse'] allocatable_vms: The unutilized capacity of the dedicated host represented in terms of each VM size that is allowed to be deployed to the dedicated host.
        """
        if allocatable_vms is not None:
            pulumi.set(__self__, "allocatable_vms", allocatable_vms)

    @property
    @pulumi.getter(name="allocatableVMs")
    def allocatable_vms(self) -> Optional[Sequence['outputs.DedicatedHostAllocatableVMResponse']]:
        """
        The unutilized capacity of the dedicated host represented in terms of each VM size that is allowed to be deployed to the dedicated host.
        """
        return pulumi.get(self, "allocatable_vms")


@pulumi.output_type
class DedicatedHostGroupInstanceViewResponse(dict):
    def __init__(__self__, *,
                 hosts: Optional[Sequence['outputs.DedicatedHostInstanceViewWithNameResponse']] = None):
        """
        :param Sequence['DedicatedHostInstanceViewWithNameResponse'] hosts: List of instance view of the dedicated hosts under the dedicated host group.
        """
        if hosts is not None:
            pulumi.set(__self__, "hosts", hosts)

    @property
    @pulumi.getter
    def hosts(self) -> Optional[Sequence['outputs.DedicatedHostInstanceViewWithNameResponse']]:
        """
        List of instance view of the dedicated hosts under the dedicated host group.
        """
        return pulumi.get(self, "hosts")


@pulumi.output_type
class DedicatedHostInstanceViewResponse(dict):
    """
    The instance view of a dedicated host.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "assetId":
            suggest = "asset_id"
        elif key == "availableCapacity":
            suggest = "available_capacity"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DedicatedHostInstanceViewResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DedicatedHostInstanceViewResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DedicatedHostInstanceViewResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 asset_id: str,
                 available_capacity: Optional['outputs.DedicatedHostAvailableCapacityResponse'] = None,
                 statuses: Optional[Sequence['outputs.InstanceViewStatusResponse']] = None):
        """
        The instance view of a dedicated host.
        :param str asset_id: Specifies the unique id of the dedicated physical machine on which the dedicated host resides.
        :param 'DedicatedHostAvailableCapacityResponse' available_capacity: Unutilized capacity of the dedicated host.
        :param Sequence['InstanceViewStatusResponse'] statuses: The resource status information.
        """
        pulumi.set(__self__, "asset_id", asset_id)
        if available_capacity is not None:
            pulumi.set(__self__, "available_capacity", available_capacity)
        if statuses is not None:
            pulumi.set(__self__, "statuses", statuses)

    @property
    @pulumi.getter(name="assetId")
    def asset_id(self) -> str:
        """
        Specifies the unique id of the dedicated physical machine on which the dedicated host resides.
        """
        return pulumi.get(self, "asset_id")

    @property
    @pulumi.getter(name="availableCapacity")
    def available_capacity(self) -> Optional['outputs.DedicatedHostAvailableCapacityResponse']:
        """
        Unutilized capacity of the dedicated host.
        """
        return pulumi.get(self, "available_capacity")

    @property
    @pulumi.getter
    def statuses(self) -> Optional[Sequence['outputs.InstanceViewStatusResponse']]:
        """
        The resource status information.
        """
        return pulumi.get(self, "statuses")


@pulumi.output_type
class DedicatedHostInstanceViewWithNameResponse(dict):
    """
    The instance view of a dedicated host that includes the name of the dedicated host. It is used for the response to the instance view of a dedicated host group.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "assetId":
            suggest = "asset_id"
        elif key == "availableCapacity":
            suggest = "available_capacity"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DedicatedHostInstanceViewWithNameResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DedicatedHostInstanceViewWithNameResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DedicatedHostInstanceViewWithNameResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 asset_id: str,
                 name: str,
                 available_capacity: Optional['outputs.DedicatedHostAvailableCapacityResponse'] = None,
                 statuses: Optional[Sequence['outputs.InstanceViewStatusResponse']] = None):
        """
        The instance view of a dedicated host that includes the name of the dedicated host. It is used for the response to the instance view of a dedicated host group.
        :param str asset_id: Specifies the unique id of the dedicated physical machine on which the dedicated host resides.
        :param str name: The name of the dedicated host.
        :param 'DedicatedHostAvailableCapacityResponse' available_capacity: Unutilized capacity of the dedicated host.
        :param Sequence['InstanceViewStatusResponse'] statuses: The resource status information.
        """
        pulumi.set(__self__, "asset_id", asset_id)
        pulumi.set(__self__, "name", name)
        if available_capacity is not None:
            pulumi.set(__self__, "available_capacity", available_capacity)
        if statuses is not None:
            pulumi.set(__self__, "statuses", statuses)

    @property
    @pulumi.getter(name="assetId")
    def asset_id(self) -> str:
        """
        Specifies the unique id of the dedicated physical machine on which the dedicated host resides.
        """
        return pulumi.get(self, "asset_id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the dedicated host.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="availableCapacity")
    def available_capacity(self) -> Optional['outputs.DedicatedHostAvailableCapacityResponse']:
        """
        Unutilized capacity of the dedicated host.
        """
        return pulumi.get(self, "available_capacity")

    @property
    @pulumi.getter
    def statuses(self) -> Optional[Sequence['outputs.InstanceViewStatusResponse']]:
        """
        The resource status information.
        """
        return pulumi.get(self, "statuses")


@pulumi.output_type
class DiagnosticsProfileResponse(dict):
    """
    Specifies the boot diagnostic settings state. <br><br>Minimum api-version: 2015-06-15.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bootDiagnostics":
            suggest = "boot_diagnostics"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DiagnosticsProfileResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DiagnosticsProfileResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DiagnosticsProfileResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 boot_diagnostics: Optional['outputs.BootDiagnosticsResponse'] = None):
        """
        Specifies the boot diagnostic settings state. <br><br>Minimum api-version: 2015-06-15.
        :param 'BootDiagnosticsResponse' boot_diagnostics: Boot Diagnostics is a debugging feature which allows you to view Console Output and Screenshot to diagnose VM status. <br><br> You can easily view the output of your console log. <br><br> Azure also enables you to see a screenshot of the VM from the hypervisor.
        """
        if boot_diagnostics is not None:
            pulumi.set(__self__, "boot_diagnostics", boot_diagnostics)

    @property
    @pulumi.getter(name="bootDiagnostics")
    def boot_diagnostics(self) -> Optional['outputs.BootDiagnosticsResponse']:
        """
        Boot Diagnostics is a debugging feature which allows you to view Console Output and Screenshot to diagnose VM status. <br><br> You can easily view the output of your console log. <br><br> Azure also enables you to see a screenshot of the VM from the hypervisor.
        """
        return pulumi.get(self, "boot_diagnostics")


@pulumi.output_type
class DiffDiskSettingsResponse(dict):
    """
    Describes the parameters of ephemeral disk settings that can be specified for operating system disk. <br><br> NOTE: The ephemeral disk settings can only be specified for managed disk.
    """
    def __init__(__self__, *,
                 option: Optional[str] = None,
                 placement: Optional[str] = None):
        """
        Describes the parameters of ephemeral disk settings that can be specified for operating system disk. <br><br> NOTE: The ephemeral disk settings can only be specified for managed disk.
        :param str option: Specifies the ephemeral disk settings for operating system disk.
        :param str placement: Specifies the ephemeral disk placement for operating system disk.<br><br> Possible values are: <br><br> **CacheDisk** <br><br> **ResourceDisk** <br><br> Default: **CacheDisk** if one is configured for the VM size otherwise **ResourceDisk** is used.<br><br> Refer to VM size documentation for Windows VM at https://docs.microsoft.com/en-us/azure/virtual-machines/windows/sizes and Linux VM at https://docs.microsoft.com/en-us/azure/virtual-machines/linux/sizes to check which VM sizes exposes a cache disk.
        """
        if option is not None:
            pulumi.set(__self__, "option", option)
        if placement is not None:
            pulumi.set(__self__, "placement", placement)

    @property
    @pulumi.getter
    def option(self) -> Optional[str]:
        """
        Specifies the ephemeral disk settings for operating system disk.
        """
        return pulumi.get(self, "option")

    @property
    @pulumi.getter
    def placement(self) -> Optional[str]:
        """
        Specifies the ephemeral disk placement for operating system disk.<br><br> Possible values are: <br><br> **CacheDisk** <br><br> **ResourceDisk** <br><br> Default: **CacheDisk** if one is configured for the VM size otherwise **ResourceDisk** is used.<br><br> Refer to VM size documentation for Windows VM at https://docs.microsoft.com/en-us/azure/virtual-machines/windows/sizes and Linux VM at https://docs.microsoft.com/en-us/azure/virtual-machines/linux/sizes to check which VM sizes exposes a cache disk.
        """
        return pulumi.get(self, "placement")


@pulumi.output_type
class DiskEncryptionSetParametersResponse(dict):
    """
    Describes the parameter of customer managed disk encryption set resource id that can be specified for disk. <br><br> NOTE: The disk encryption set resource id can only be specified for managed disk. Please refer https://aka.ms/mdssewithcmkoverview for more details.
    """
    def __init__(__self__, *,
                 id: Optional[str] = None):
        """
        Describes the parameter of customer managed disk encryption set resource id that can be specified for disk. <br><br> NOTE: The disk encryption set resource id can only be specified for managed disk. Please refer https://aka.ms/mdssewithcmkoverview for more details.
        :param str id: Resource Id
        """
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource Id
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class DiskEncryptionSettingsResponse(dict):
    """
    Describes a Encryption Settings for a Disk
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "diskEncryptionKey":
            suggest = "disk_encryption_key"
        elif key == "keyEncryptionKey":
            suggest = "key_encryption_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DiskEncryptionSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DiskEncryptionSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DiskEncryptionSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 disk_encryption_key: Optional['outputs.KeyVaultSecretReferenceResponse'] = None,
                 enabled: Optional[bool] = None,
                 key_encryption_key: Optional['outputs.KeyVaultKeyReferenceResponse'] = None):
        """
        Describes a Encryption Settings for a Disk
        :param 'KeyVaultSecretReferenceResponse' disk_encryption_key: Specifies the location of the disk encryption key, which is a Key Vault Secret.
        :param bool enabled: Specifies whether disk encryption should be enabled on the virtual machine.
        :param 'KeyVaultKeyReferenceResponse' key_encryption_key: Specifies the location of the key encryption key in Key Vault.
        """
        if disk_encryption_key is not None:
            pulumi.set(__self__, "disk_encryption_key", disk_encryption_key)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if key_encryption_key is not None:
            pulumi.set(__self__, "key_encryption_key", key_encryption_key)

    @property
    @pulumi.getter(name="diskEncryptionKey")
    def disk_encryption_key(self) -> Optional['outputs.KeyVaultSecretReferenceResponse']:
        """
        Specifies the location of the disk encryption key, which is a Key Vault Secret.
        """
        return pulumi.get(self, "disk_encryption_key")

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        """
        Specifies whether disk encryption should be enabled on the virtual machine.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="keyEncryptionKey")
    def key_encryption_key(self) -> Optional['outputs.KeyVaultKeyReferenceResponse']:
        """
        Specifies the location of the key encryption key in Key Vault.
        """
        return pulumi.get(self, "key_encryption_key")


@pulumi.output_type
class DiskInstanceViewResponse(dict):
    """
    The instance view of the disk.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "encryptionSettings":
            suggest = "encryption_settings"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DiskInstanceViewResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DiskInstanceViewResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DiskInstanceViewResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 encryption_settings: Optional[Sequence['outputs.DiskEncryptionSettingsResponse']] = None,
                 name: Optional[str] = None,
                 statuses: Optional[Sequence['outputs.InstanceViewStatusResponse']] = None):
        """
        The instance view of the disk.
        :param Sequence['DiskEncryptionSettingsResponse'] encryption_settings: Specifies the encryption settings for the OS Disk. <br><br> Minimum api-version: 2015-06-15
        :param str name: The disk name.
        :param Sequence['InstanceViewStatusResponse'] statuses: The resource status information.
        """
        if encryption_settings is not None:
            pulumi.set(__self__, "encryption_settings", encryption_settings)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if statuses is not None:
            pulumi.set(__self__, "statuses", statuses)

    @property
    @pulumi.getter(name="encryptionSettings")
    def encryption_settings(self) -> Optional[Sequence['outputs.DiskEncryptionSettingsResponse']]:
        """
        Specifies the encryption settings for the OS Disk. <br><br> Minimum api-version: 2015-06-15
        """
        return pulumi.get(self, "encryption_settings")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The disk name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def statuses(self) -> Optional[Sequence['outputs.InstanceViewStatusResponse']]:
        """
        The resource status information.
        """
        return pulumi.get(self, "statuses")


@pulumi.output_type
class HardwareProfileResponse(dict):
    """
    Specifies the hardware settings for the virtual machine.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "vmSize":
            suggest = "vm_size"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HardwareProfileResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HardwareProfileResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HardwareProfileResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 vm_size: Optional[str] = None):
        """
        Specifies the hardware settings for the virtual machine.
        :param str vm_size: Specifies the size of the virtual machine. For more information about virtual machine sizes, see [Sizes for virtual machines](https://docs.microsoft.com/en-us/azure/virtual-machines/sizes). <br><br> The available VM sizes depend on region and availability set. For a list of available sizes use these APIs:  <br><br> [List all available virtual machine sizes in an availability set](https://docs.microsoft.com/rest/api/compute/availabilitysets/listavailablesizes) <br><br> [List all available virtual machine sizes in a region]( https://docs.microsoft.com/en-us/rest/api/compute/resourceskus/list) <br><br> [List all available virtual machine sizes for resizing](https://docs.microsoft.com/rest/api/compute/virtualmachines/listavailablesizes). <br><br> This list of sizes is no longer updated and the **VirtualMachineSizeTypes** string constants will be removed from the subsequent REST API specification. Use [List all available virtual machine sizes in a region]( https://docs.microsoft.com/en-us/rest/api/compute/resourceskus/list) to get the latest sizes.
        """
        if vm_size is not None:
            pulumi.set(__self__, "vm_size", vm_size)

    @property
    @pulumi.getter(name="vmSize")
    def vm_size(self) -> Optional[str]:
        """
        Specifies the size of the virtual machine. For more information about virtual machine sizes, see [Sizes for virtual machines](https://docs.microsoft.com/en-us/azure/virtual-machines/sizes). <br><br> The available VM sizes depend on region and availability set. For a list of available sizes use these APIs:  <br><br> [List all available virtual machine sizes in an availability set](https://docs.microsoft.com/rest/api/compute/availabilitysets/listavailablesizes) <br><br> [List all available virtual machine sizes in a region]( https://docs.microsoft.com/en-us/rest/api/compute/resourceskus/list) <br><br> [List all available virtual machine sizes for resizing](https://docs.microsoft.com/rest/api/compute/virtualmachines/listavailablesizes). <br><br> This list of sizes is no longer updated and the **VirtualMachineSizeTypes** string constants will be removed from the subsequent REST API specification. Use [List all available virtual machine sizes in a region]( https://docs.microsoft.com/en-us/rest/api/compute/resourceskus/list) to get the latest sizes.
        """
        return pulumi.get(self, "vm_size")


@pulumi.output_type
class ImageDataDiskResponse(dict):
    """
    Describes a data disk.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "blobUri":
            suggest = "blob_uri"
        elif key == "diskEncryptionSet":
            suggest = "disk_encryption_set"
        elif key == "diskSizeGB":
            suggest = "disk_size_gb"
        elif key == "managedDisk":
            suggest = "managed_disk"
        elif key == "storageAccountType":
            suggest = "storage_account_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ImageDataDiskResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ImageDataDiskResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ImageDataDiskResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 lun: int,
                 blob_uri: Optional[str] = None,
                 caching: Optional[str] = None,
                 disk_encryption_set: Optional['outputs.DiskEncryptionSetParametersResponse'] = None,
                 disk_size_gb: Optional[int] = None,
                 managed_disk: Optional['outputs.SubResourceResponse'] = None,
                 snapshot: Optional['outputs.SubResourceResponse'] = None,
                 storage_account_type: Optional[str] = None):
        """
        Describes a data disk.
        :param int lun: Specifies the logical unit number of the data disk. This value is used to identify data disks within the VM and therefore must be unique for each data disk attached to a VM.
        :param str blob_uri: The Virtual Hard Disk.
        :param str caching: Specifies the caching requirements. <br><br> Possible values are: <br><br> **None** <br><br> **ReadOnly** <br><br> **ReadWrite** <br><br> Default: **None for Standard storage. ReadOnly for Premium storage**
        :param 'DiskEncryptionSetParametersResponse' disk_encryption_set: Specifies the customer managed disk encryption set resource id for the managed image disk.
        :param int disk_size_gb: Specifies the size of empty data disks in gigabytes. This element can be used to overwrite the name of the disk in a virtual machine image. <br><br> This value cannot be larger than 1023 GB
        :param 'SubResourceResponse' managed_disk: The managedDisk.
        :param 'SubResourceResponse' snapshot: The snapshot.
        :param str storage_account_type: Specifies the storage account type for the managed disk. NOTE: UltraSSD_LRS can only be used with data disks, it cannot be used with OS Disk.
        """
        pulumi.set(__self__, "lun", lun)
        if blob_uri is not None:
            pulumi.set(__self__, "blob_uri", blob_uri)
        if caching is not None:
            pulumi.set(__self__, "caching", caching)
        if disk_encryption_set is not None:
            pulumi.set(__self__, "disk_encryption_set", disk_encryption_set)
        if disk_size_gb is not None:
            pulumi.set(__self__, "disk_size_gb", disk_size_gb)
        if managed_disk is not None:
            pulumi.set(__self__, "managed_disk", managed_disk)
        if snapshot is not None:
            pulumi.set(__self__, "snapshot", snapshot)
        if storage_account_type is not None:
            pulumi.set(__self__, "storage_account_type", storage_account_type)

    @property
    @pulumi.getter
    def lun(self) -> int:
        """
        Specifies the logical unit number of the data disk. This value is used to identify data disks within the VM and therefore must be unique for each data disk attached to a VM.
        """
        return pulumi.get(self, "lun")

    @property
    @pulumi.getter(name="blobUri")
    def blob_uri(self) -> Optional[str]:
        """
        The Virtual Hard Disk.
        """
        return pulumi.get(self, "blob_uri")

    @property
    @pulumi.getter
    def caching(self) -> Optional[str]:
        """
        Specifies the caching requirements. <br><br> Possible values are: <br><br> **None** <br><br> **ReadOnly** <br><br> **ReadWrite** <br><br> Default: **None for Standard storage. ReadOnly for Premium storage**
        """
        return pulumi.get(self, "caching")

    @property
    @pulumi.getter(name="diskEncryptionSet")
    def disk_encryption_set(self) -> Optional['outputs.DiskEncryptionSetParametersResponse']:
        """
        Specifies the customer managed disk encryption set resource id for the managed image disk.
        """
        return pulumi.get(self, "disk_encryption_set")

    @property
    @pulumi.getter(name="diskSizeGB")
    def disk_size_gb(self) -> Optional[int]:
        """
        Specifies the size of empty data disks in gigabytes. This element can be used to overwrite the name of the disk in a virtual machine image. <br><br> This value cannot be larger than 1023 GB
        """
        return pulumi.get(self, "disk_size_gb")

    @property
    @pulumi.getter(name="managedDisk")
    def managed_disk(self) -> Optional['outputs.SubResourceResponse']:
        """
        The managedDisk.
        """
        return pulumi.get(self, "managed_disk")

    @property
    @pulumi.getter
    def snapshot(self) -> Optional['outputs.SubResourceResponse']:
        """
        The snapshot.
        """
        return pulumi.get(self, "snapshot")

    @property
    @pulumi.getter(name="storageAccountType")
    def storage_account_type(self) -> Optional[str]:
        """
        Specifies the storage account type for the managed disk. NOTE: UltraSSD_LRS can only be used with data disks, it cannot be used with OS Disk.
        """
        return pulumi.get(self, "storage_account_type")


@pulumi.output_type
class ImageOSDiskResponse(dict):
    """
    Describes an Operating System disk.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "osState":
            suggest = "os_state"
        elif key == "osType":
            suggest = "os_type"
        elif key == "blobUri":
            suggest = "blob_uri"
        elif key == "diskEncryptionSet":
            suggest = "disk_encryption_set"
        elif key == "diskSizeGB":
            suggest = "disk_size_gb"
        elif key == "managedDisk":
            suggest = "managed_disk"
        elif key == "storageAccountType":
            suggest = "storage_account_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ImageOSDiskResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ImageOSDiskResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ImageOSDiskResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 os_state: str,
                 os_type: str,
                 blob_uri: Optional[str] = None,
                 caching: Optional[str] = None,
                 disk_encryption_set: Optional['outputs.DiskEncryptionSetParametersResponse'] = None,
                 disk_size_gb: Optional[int] = None,
                 managed_disk: Optional['outputs.SubResourceResponse'] = None,
                 snapshot: Optional['outputs.SubResourceResponse'] = None,
                 storage_account_type: Optional[str] = None):
        """
        Describes an Operating System disk.
        :param str os_state: The OS State.
        :param str os_type: This property allows you to specify the type of the OS that is included in the disk if creating a VM from a custom image. <br><br> Possible values are: <br><br> **Windows** <br><br> **Linux**
        :param str blob_uri: The Virtual Hard Disk.
        :param str caching: Specifies the caching requirements. <br><br> Possible values are: <br><br> **None** <br><br> **ReadOnly** <br><br> **ReadWrite** <br><br> Default: **None for Standard storage. ReadOnly for Premium storage**
        :param 'DiskEncryptionSetParametersResponse' disk_encryption_set: Specifies the customer managed disk encryption set resource id for the managed image disk.
        :param int disk_size_gb: Specifies the size of empty data disks in gigabytes. This element can be used to overwrite the name of the disk in a virtual machine image. <br><br> This value cannot be larger than 1023 GB
        :param 'SubResourceResponse' managed_disk: The managedDisk.
        :param 'SubResourceResponse' snapshot: The snapshot.
        :param str storage_account_type: Specifies the storage account type for the managed disk. NOTE: UltraSSD_LRS can only be used with data disks, it cannot be used with OS Disk.
        """
        pulumi.set(__self__, "os_state", os_state)
        pulumi.set(__self__, "os_type", os_type)
        if blob_uri is not None:
            pulumi.set(__self__, "blob_uri", blob_uri)
        if caching is not None:
            pulumi.set(__self__, "caching", caching)
        if disk_encryption_set is not None:
            pulumi.set(__self__, "disk_encryption_set", disk_encryption_set)
        if disk_size_gb is not None:
            pulumi.set(__self__, "disk_size_gb", disk_size_gb)
        if managed_disk is not None:
            pulumi.set(__self__, "managed_disk", managed_disk)
        if snapshot is not None:
            pulumi.set(__self__, "snapshot", snapshot)
        if storage_account_type is not None:
            pulumi.set(__self__, "storage_account_type", storage_account_type)

    @property
    @pulumi.getter(name="osState")
    def os_state(self) -> str:
        """
        The OS State.
        """
        return pulumi.get(self, "os_state")

    @property
    @pulumi.getter(name="osType")
    def os_type(self) -> str:
        """
        This property allows you to specify the type of the OS that is included in the disk if creating a VM from a custom image. <br><br> Possible values are: <br><br> **Windows** <br><br> **Linux**
        """
        return pulumi.get(self, "os_type")

    @property
    @pulumi.getter(name="blobUri")
    def blob_uri(self) -> Optional[str]:
        """
        The Virtual Hard Disk.
        """
        return pulumi.get(self, "blob_uri")

    @property
    @pulumi.getter
    def caching(self) -> Optional[str]:
        """
        Specifies the caching requirements. <br><br> Possible values are: <br><br> **None** <br><br> **ReadOnly** <br><br> **ReadWrite** <br><br> Default: **None for Standard storage. ReadOnly for Premium storage**
        """
        return pulumi.get(self, "caching")

    @property
    @pulumi.getter(name="diskEncryptionSet")
    def disk_encryption_set(self) -> Optional['outputs.DiskEncryptionSetParametersResponse']:
        """
        Specifies the customer managed disk encryption set resource id for the managed image disk.
        """
        return pulumi.get(self, "disk_encryption_set")

    @property
    @pulumi.getter(name="diskSizeGB")
    def disk_size_gb(self) -> Optional[int]:
        """
        Specifies the size of empty data disks in gigabytes. This element can be used to overwrite the name of the disk in a virtual machine image. <br><br> This value cannot be larger than 1023 GB
        """
        return pulumi.get(self, "disk_size_gb")

    @property
    @pulumi.getter(name="managedDisk")
    def managed_disk(self) -> Optional['outputs.SubResourceResponse']:
        """
        The managedDisk.
        """
        return pulumi.get(self, "managed_disk")

    @property
    @pulumi.getter
    def snapshot(self) -> Optional['outputs.SubResourceResponse']:
        """
        The snapshot.
        """
        return pulumi.get(self, "snapshot")

    @property
    @pulumi.getter(name="storageAccountType")
    def storage_account_type(self) -> Optional[str]:
        """
        Specifies the storage account type for the managed disk. NOTE: UltraSSD_LRS can only be used with data disks, it cannot be used with OS Disk.
        """
        return pulumi.get(self, "storage_account_type")


@pulumi.output_type
class ImageReferenceResponse(dict):
    """
    Specifies information about the image to use. You can specify information about platform images, marketplace images, or virtual machine images. This element is required when you want to use a platform image, marketplace image, or virtual machine image, but is not used in other creation operations. NOTE: Image reference publisher and offer can only be set when you create the scale set.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "exactVersion":
            suggest = "exact_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ImageReferenceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ImageReferenceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ImageReferenceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 exact_version: str,
                 id: Optional[str] = None,
                 offer: Optional[str] = None,
                 publisher: Optional[str] = None,
                 sku: Optional[str] = None,
                 version: Optional[str] = None):
        """
        Specifies information about the image to use. You can specify information about platform images, marketplace images, or virtual machine images. This element is required when you want to use a platform image, marketplace image, or virtual machine image, but is not used in other creation operations. NOTE: Image reference publisher and offer can only be set when you create the scale set.
        :param str exact_version: Specifies in decimal numbers, the version of platform image or marketplace image used to create the virtual machine. This readonly field differs from 'version', only if the value specified in 'version' field is 'latest'.
        :param str id: Resource Id
        :param str offer: Specifies the offer of the platform image or marketplace image used to create the virtual machine.
        :param str publisher: The image publisher.
        :param str sku: The image SKU.
        :param str version: Specifies the version of the platform image or marketplace image used to create the virtual machine. The allowed formats are Major.Minor.Build or 'latest'. Major, Minor, and Build are decimal numbers. Specify 'latest' to use the latest version of an image available at deploy time. Even if you use 'latest', the VM image will not automatically update after deploy time even if a new version becomes available.
        """
        pulumi.set(__self__, "exact_version", exact_version)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if offer is not None:
            pulumi.set(__self__, "offer", offer)
        if publisher is not None:
            pulumi.set(__self__, "publisher", publisher)
        if sku is not None:
            pulumi.set(__self__, "sku", sku)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="exactVersion")
    def exact_version(self) -> str:
        """
        Specifies in decimal numbers, the version of platform image or marketplace image used to create the virtual machine. This readonly field differs from 'version', only if the value specified in 'version' field is 'latest'.
        """
        return pulumi.get(self, "exact_version")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource Id
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def offer(self) -> Optional[str]:
        """
        Specifies the offer of the platform image or marketplace image used to create the virtual machine.
        """
        return pulumi.get(self, "offer")

    @property
    @pulumi.getter
    def publisher(self) -> Optional[str]:
        """
        The image publisher.
        """
        return pulumi.get(self, "publisher")

    @property
    @pulumi.getter
    def sku(self) -> Optional[str]:
        """
        The image SKU.
        """
        return pulumi.get(self, "sku")

    @property
    @pulumi.getter
    def version(self) -> Optional[str]:
        """
        Specifies the version of the platform image or marketplace image used to create the virtual machine. The allowed formats are Major.Minor.Build or 'latest'. Major, Minor, and Build are decimal numbers. Specify 'latest' to use the latest version of an image available at deploy time. Even if you use 'latest', the VM image will not automatically update after deploy time even if a new version becomes available.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class ImageStorageProfileResponse(dict):
    """
    Describes a storage profile.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataDisks":
            suggest = "data_disks"
        elif key == "osDisk":
            suggest = "os_disk"
        elif key == "zoneResilient":
            suggest = "zone_resilient"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ImageStorageProfileResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ImageStorageProfileResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ImageStorageProfileResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data_disks: Optional[Sequence['outputs.ImageDataDiskResponse']] = None,
                 os_disk: Optional['outputs.ImageOSDiskResponse'] = None,
                 zone_resilient: Optional[bool] = None):
        """
        Describes a storage profile.
        :param Sequence['ImageDataDiskResponse'] data_disks: Specifies the parameters that are used to add a data disk to a virtual machine. <br><br> For more information about disks, see [About disks and VHDs for Azure virtual machines](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-about-disks-vhds?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json).
        :param 'ImageOSDiskResponse' os_disk: Specifies information about the operating system disk used by the virtual machine. <br><br> For more information about disks, see [About disks and VHDs for Azure virtual machines](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-about-disks-vhds?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json).
        :param bool zone_resilient: Specifies whether an image is zone resilient or not. Default is false. Zone resilient images can be created only in regions that provide Zone Redundant Storage (ZRS).
        """
        if data_disks is not None:
            pulumi.set(__self__, "data_disks", data_disks)
        if os_disk is not None:
            pulumi.set(__self__, "os_disk", os_disk)
        if zone_resilient is not None:
            pulumi.set(__self__, "zone_resilient", zone_resilient)

    @property
    @pulumi.getter(name="dataDisks")
    def data_disks(self) -> Optional[Sequence['outputs.ImageDataDiskResponse']]:
        """
        Specifies the parameters that are used to add a data disk to a virtual machine. <br><br> For more information about disks, see [About disks and VHDs for Azure virtual machines](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-about-disks-vhds?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json).
        """
        return pulumi.get(self, "data_disks")

    @property
    @pulumi.getter(name="osDisk")
    def os_disk(self) -> Optional['outputs.ImageOSDiskResponse']:
        """
        Specifies information about the operating system disk used by the virtual machine. <br><br> For more information about disks, see [About disks and VHDs for Azure virtual machines](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-about-disks-vhds?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json).
        """
        return pulumi.get(self, "os_disk")

    @property
    @pulumi.getter(name="zoneResilient")
    def zone_resilient(self) -> Optional[bool]:
        """
        Specifies whether an image is zone resilient or not. Default is false. Zone resilient images can be created only in regions that provide Zone Redundant Storage (ZRS).
        """
        return pulumi.get(self, "zone_resilient")


@pulumi.output_type
class InnerErrorResponse(dict):
    """
    Inner error details.
    """
    def __init__(__self__, *,
                 errordetail: Optional[str] = None,
                 exceptiontype: Optional[str] = None):
        """
        Inner error details.
        :param str errordetail: The internal error message or exception dump.
        :param str exceptiontype: The exception type.
        """
        if errordetail is not None:
            pulumi.set(__self__, "errordetail", errordetail)
        if exceptiontype is not None:
            pulumi.set(__self__, "exceptiontype", exceptiontype)

    @property
    @pulumi.getter
    def errordetail(self) -> Optional[str]:
        """
        The internal error message or exception dump.
        """
        return pulumi.get(self, "errordetail")

    @property
    @pulumi.getter
    def exceptiontype(self) -> Optional[str]:
        """
        The exception type.
        """
        return pulumi.get(self, "exceptiontype")


@pulumi.output_type
class InstanceViewStatusResponse(dict):
    """
    Instance view status.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "displayStatus":
            suggest = "display_status"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceViewStatusResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceViewStatusResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceViewStatusResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 code: Optional[str] = None,
                 display_status: Optional[str] = None,
                 level: Optional[str] = None,
                 message: Optional[str] = None,
                 time: Optional[str] = None):
        """
        Instance view status.
        :param str code: The status code.
        :param str display_status: The short localizable label for the status.
        :param str level: The level code.
        :param str message: The detailed status message, including for alerts and error messages.
        :param str time: The time of the status.
        """
        if code is not None:
            pulumi.set(__self__, "code", code)
        if display_status is not None:
            pulumi.set(__self__, "display_status", display_status)
        if level is not None:
            pulumi.set(__self__, "level", level)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if time is not None:
            pulumi.set(__self__, "time", time)

    @property
    @pulumi.getter
    def code(self) -> Optional[str]:
        """
        The status code.
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter(name="displayStatus")
    def display_status(self) -> Optional[str]:
        """
        The short localizable label for the status.
        """
        return pulumi.get(self, "display_status")

    @property
    @pulumi.getter
    def level(self) -> Optional[str]:
        """
        The level code.
        """
        return pulumi.get(self, "level")

    @property
    @pulumi.getter
    def message(self) -> Optional[str]:
        """
        The detailed status message, including for alerts and error messages.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def time(self) -> Optional[str]:
        """
        The time of the status.
        """
        return pulumi.get(self, "time")


@pulumi.output_type
class KeyVaultKeyReferenceResponse(dict):
    """
    Describes a reference to Key Vault Key
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keyUrl":
            suggest = "key_url"
        elif key == "sourceVault":
            suggest = "source_vault"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KeyVaultKeyReferenceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KeyVaultKeyReferenceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KeyVaultKeyReferenceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key_url: str,
                 source_vault: 'outputs.SubResourceResponse'):
        """
        Describes a reference to Key Vault Key
        :param str key_url: The URL referencing a key encryption key in Key Vault.
        :param 'SubResourceResponse' source_vault: The relative URL of the Key Vault containing the key.
        """
        pulumi.set(__self__, "key_url", key_url)
        pulumi.set(__self__, "source_vault", source_vault)

    @property
    @pulumi.getter(name="keyUrl")
    def key_url(self) -> str:
        """
        The URL referencing a key encryption key in Key Vault.
        """
        return pulumi.get(self, "key_url")

    @property
    @pulumi.getter(name="sourceVault")
    def source_vault(self) -> 'outputs.SubResourceResponse':
        """
        The relative URL of the Key Vault containing the key.
        """
        return pulumi.get(self, "source_vault")


@pulumi.output_type
class KeyVaultSecretReferenceResponse(dict):
    """
    Describes a reference to Key Vault Secret
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "secretUrl":
            suggest = "secret_url"
        elif key == "sourceVault":
            suggest = "source_vault"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KeyVaultSecretReferenceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KeyVaultSecretReferenceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KeyVaultSecretReferenceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 secret_url: str,
                 source_vault: 'outputs.SubResourceResponse'):
        """
        Describes a reference to Key Vault Secret
        :param str secret_url: The URL referencing a secret in a Key Vault.
        :param 'SubResourceResponse' source_vault: The relative URL of the Key Vault containing the secret.
        """
        pulumi.set(__self__, "secret_url", secret_url)
        pulumi.set(__self__, "source_vault", source_vault)

    @property
    @pulumi.getter(name="secretUrl")
    def secret_url(self) -> str:
        """
        The URL referencing a secret in a Key Vault.
        """
        return pulumi.get(self, "secret_url")

    @property
    @pulumi.getter(name="sourceVault")
    def source_vault(self) -> 'outputs.SubResourceResponse':
        """
        The relative URL of the Key Vault containing the secret.
        """
        return pulumi.get(self, "source_vault")


@pulumi.output_type
class LastPatchInstallationSummaryResponse(dict):
    """
    Describes the properties of the last installed patch summary.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "excludedPatchCount":
            suggest = "excluded_patch_count"
        elif key == "failedPatchCount":
            suggest = "failed_patch_count"
        elif key == "installationActivityId":
            suggest = "installation_activity_id"
        elif key == "installedPatchCount":
            suggest = "installed_patch_count"
        elif key == "lastModifiedTime":
            suggest = "last_modified_time"
        elif key == "maintenanceWindowExceeded":
            suggest = "maintenance_window_exceeded"
        elif key == "notSelectedPatchCount":
            suggest = "not_selected_patch_count"
        elif key == "pendingPatchCount":
            suggest = "pending_patch_count"
        elif key == "rebootStatus":
            suggest = "reboot_status"
        elif key == "startTime":
            suggest = "start_time"
        elif key == "startedBy":
            suggest = "started_by"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LastPatchInstallationSummaryResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LastPatchInstallationSummaryResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LastPatchInstallationSummaryResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 error: 'outputs.ApiErrorResponse',
                 excluded_patch_count: int,
                 failed_patch_count: int,
                 installation_activity_id: str,
                 installed_patch_count: int,
                 last_modified_time: str,
                 maintenance_window_exceeded: bool,
                 not_selected_patch_count: int,
                 pending_patch_count: int,
                 reboot_status: str,
                 start_time: str,
                 started_by: str,
                 status: str):
        """
        Describes the properties of the last installed patch summary.
        :param 'ApiErrorResponse' error: The errors that were encountered during execution of the operation. The details array contains the list of them.
        :param int excluded_patch_count: The number of all available patches but excluded explicitly by a customer-specified exclusion list match.
        :param int failed_patch_count: The count of patches that failed installation.
        :param str installation_activity_id: The activity ID of the operation that produced this result. It is used to correlate across CRP and extension logs.
        :param int installed_patch_count: The count of patches that successfully installed.
        :param str last_modified_time: The UTC timestamp when the operation began.
        :param bool maintenance_window_exceeded: Describes whether the operation ran out of time before it completed all its intended actions
        :param int not_selected_patch_count: The number of all available patches but not going to be installed because it didn't match a classification or inclusion list entry.
        :param int pending_patch_count: The number of all available patches expected to be installed over the course of the patch installation operation.
        :param str reboot_status: The reboot status of the machine after the patch operation. It will be in "NotNeeded" status if reboot is not needed after the patch operation. "Required" will be the status once the patch is applied and machine is required to reboot. "Started" will be the reboot status when the machine has started to reboot. "Failed" will be the status if the machine is failed to reboot. "Completed" will be the status once the machine is rebooted successfully
        :param str start_time: The UTC timestamp when the operation began.
        :param str started_by: The person or system account that started the operation
        :param str status: The overall success or failure status of the operation. It remains "InProgress" until the operation completes. At that point it will become "Failed", "Succeeded", or "CompletedWithWarnings."
        """
        pulumi.set(__self__, "error", error)
        pulumi.set(__self__, "excluded_patch_count", excluded_patch_count)
        pulumi.set(__self__, "failed_patch_count", failed_patch_count)
        pulumi.set(__self__, "installation_activity_id", installation_activity_id)
        pulumi.set(__self__, "installed_patch_count", installed_patch_count)
        pulumi.set(__self__, "last_modified_time", last_modified_time)
        pulumi.set(__self__, "maintenance_window_exceeded", maintenance_window_exceeded)
        pulumi.set(__self__, "not_selected_patch_count", not_selected_patch_count)
        pulumi.set(__self__, "pending_patch_count", pending_patch_count)
        pulumi.set(__self__, "reboot_status", reboot_status)
        pulumi.set(__self__, "start_time", start_time)
        pulumi.set(__self__, "started_by", started_by)
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def error(self) -> 'outputs.ApiErrorResponse':
        """
        The errors that were encountered during execution of the operation. The details array contains the list of them.
        """
        return pulumi.get(self, "error")

    @property
    @pulumi.getter(name="excludedPatchCount")
    def excluded_patch_count(self) -> int:
        """
        The number of all available patches but excluded explicitly by a customer-specified exclusion list match.
        """
        return pulumi.get(self, "excluded_patch_count")

    @property
    @pulumi.getter(name="failedPatchCount")
    def failed_patch_count(self) -> int:
        """
        The count of patches that failed installation.
        """
        return pulumi.get(self, "failed_patch_count")

    @property
    @pulumi.getter(name="installationActivityId")
    def installation_activity_id(self) -> str:
        """
        The activity ID of the operation that produced this result. It is used to correlate across CRP and extension logs.
        """
        return pulumi.get(self, "installation_activity_id")

    @property
    @pulumi.getter(name="installedPatchCount")
    def installed_patch_count(self) -> int:
        """
        The count of patches that successfully installed.
        """
        return pulumi.get(self, "installed_patch_count")

    @property
    @pulumi.getter(name="lastModifiedTime")
    def last_modified_time(self) -> str:
        """
        The UTC timestamp when the operation began.
        """
        return pulumi.get(self, "last_modified_time")

    @property
    @pulumi.getter(name="maintenanceWindowExceeded")
    def maintenance_window_exceeded(self) -> bool:
        """
        Describes whether the operation ran out of time before it completed all its intended actions
        """
        return pulumi.get(self, "maintenance_window_exceeded")

    @property
    @pulumi.getter(name="notSelectedPatchCount")
    def not_selected_patch_count(self) -> int:
        """
        The number of all available patches but not going to be installed because it didn't match a classification or inclusion list entry.
        """
        return pulumi.get(self, "not_selected_patch_count")

    @property
    @pulumi.getter(name="pendingPatchCount")
    def pending_patch_count(self) -> int:
        """
        The number of all available patches expected to be installed over the course of the patch installation operation.
        """
        return pulumi.get(self, "pending_patch_count")

    @property
    @pulumi.getter(name="rebootStatus")
    def reboot_status(self) -> str:
        """
        The reboot status of the machine after the patch operation. It will be in "NotNeeded" status if reboot is not needed after the patch operation. "Required" will be the status once the patch is applied and machine is required to reboot. "Started" will be the reboot status when the machine has started to reboot. "Failed" will be the status if the machine is failed to reboot. "Completed" will be the status once the machine is rebooted successfully
        """
        return pulumi.get(self, "reboot_status")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> str:
        """
        The UTC timestamp when the operation began.
        """
        return pulumi.get(self, "start_time")

    @property
    @pulumi.getter(name="startedBy")
    def started_by(self) -> str:
        """
        The person or system account that started the operation
        """
        return pulumi.get(self, "started_by")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The overall success or failure status of the operation. It remains "InProgress" until the operation completes. At that point it will become "Failed", "Succeeded", or "CompletedWithWarnings."
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class LinuxConfigurationResponse(dict):
    """
    Specifies the Linux operating system settings on the virtual machine. <br><br>For a list of supported Linux distributions, see [Linux on Azure-Endorsed Distributions](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-endorsed-distros?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json) <br><br> For running non-endorsed distributions, see [Information for Non-Endorsed Distributions](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-create-upload-generic?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json).
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "disablePasswordAuthentication":
            suggest = "disable_password_authentication"
        elif key == "provisionVMAgent":
            suggest = "provision_vm_agent"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LinuxConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LinuxConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LinuxConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 disable_password_authentication: Optional[bool] = None,
                 provision_vm_agent: Optional[bool] = None,
                 ssh: Optional['outputs.SshConfigurationResponse'] = None):
        """
        Specifies the Linux operating system settings on the virtual machine. <br><br>For a list of supported Linux distributions, see [Linux on Azure-Endorsed Distributions](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-endorsed-distros?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json) <br><br> For running non-endorsed distributions, see [Information for Non-Endorsed Distributions](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-create-upload-generic?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json).
        :param bool disable_password_authentication: Specifies whether password authentication should be disabled.
        :param bool provision_vm_agent: Indicates whether virtual machine agent should be provisioned on the virtual machine. <br><br> When this property is not specified in the request body, default behavior is to set it to true.  This will ensure that VM Agent is installed on the VM so that extensions can be added to the VM later.
        :param 'SshConfigurationResponse' ssh: Specifies the ssh key configuration for a Linux OS.
        """
        if disable_password_authentication is not None:
            pulumi.set(__self__, "disable_password_authentication", disable_password_authentication)
        if provision_vm_agent is not None:
            pulumi.set(__self__, "provision_vm_agent", provision_vm_agent)
        if ssh is not None:
            pulumi.set(__self__, "ssh", ssh)

    @property
    @pulumi.getter(name="disablePasswordAuthentication")
    def disable_password_authentication(self) -> Optional[bool]:
        """
        Specifies whether password authentication should be disabled.
        """
        return pulumi.get(self, "disable_password_authentication")

    @property
    @pulumi.getter(name="provisionVMAgent")
    def provision_vm_agent(self) -> Optional[bool]:
        """
        Indicates whether virtual machine agent should be provisioned on the virtual machine. <br><br> When this property is not specified in the request body, default behavior is to set it to true.  This will ensure that VM Agent is installed on the VM so that extensions can be added to the VM later.
        """
        return pulumi.get(self, "provision_vm_agent")

    @property
    @pulumi.getter
    def ssh(self) -> Optional['outputs.SshConfigurationResponse']:
        """
        Specifies the ssh key configuration for a Linux OS.
        """
        return pulumi.get(self, "ssh")


@pulumi.output_type
class LogAnalyticsOutputResponse(dict):
    """
    LogAnalytics output properties
    """
    def __init__(__self__, *,
                 output: str):
        """
        LogAnalytics output properties
        :param str output: Output file Uri path to blob container.
        """
        pulumi.set(__self__, "output", output)

    @property
    @pulumi.getter
    def output(self) -> str:
        """
        Output file Uri path to blob container.
        """
        return pulumi.get(self, "output")


@pulumi.output_type
class MaintenanceRedeployStatusResponse(dict):
    """
    Maintenance Operation Status.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isCustomerInitiatedMaintenanceAllowed":
            suggest = "is_customer_initiated_maintenance_allowed"
        elif key == "lastOperationMessage":
            suggest = "last_operation_message"
        elif key == "lastOperationResultCode":
            suggest = "last_operation_result_code"
        elif key == "maintenanceWindowEndTime":
            suggest = "maintenance_window_end_time"
        elif key == "maintenanceWindowStartTime":
            suggest = "maintenance_window_start_time"
        elif key == "preMaintenanceWindowEndTime":
            suggest = "pre_maintenance_window_end_time"
        elif key == "preMaintenanceWindowStartTime":
            suggest = "pre_maintenance_window_start_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MaintenanceRedeployStatusResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MaintenanceRedeployStatusResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MaintenanceRedeployStatusResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 is_customer_initiated_maintenance_allowed: Optional[bool] = None,
                 last_operation_message: Optional[str] = None,
                 last_operation_result_code: Optional[str] = None,
                 maintenance_window_end_time: Optional[str] = None,
                 maintenance_window_start_time: Optional[str] = None,
                 pre_maintenance_window_end_time: Optional[str] = None,
                 pre_maintenance_window_start_time: Optional[str] = None):
        """
        Maintenance Operation Status.
        :param bool is_customer_initiated_maintenance_allowed: True, if customer is allowed to perform Maintenance.
        :param str last_operation_message: Message returned for the last Maintenance Operation.
        :param str last_operation_result_code: The Last Maintenance Operation Result Code.
        :param str maintenance_window_end_time: End Time for the Maintenance Window.
        :param str maintenance_window_start_time: Start Time for the Maintenance Window.
        :param str pre_maintenance_window_end_time: End Time for the Pre Maintenance Window.
        :param str pre_maintenance_window_start_time: Start Time for the Pre Maintenance Window.
        """
        if is_customer_initiated_maintenance_allowed is not None:
            pulumi.set(__self__, "is_customer_initiated_maintenance_allowed", is_customer_initiated_maintenance_allowed)
        if last_operation_message is not None:
            pulumi.set(__self__, "last_operation_message", last_operation_message)
        if last_operation_result_code is not None:
            pulumi.set(__self__, "last_operation_result_code", last_operation_result_code)
        if maintenance_window_end_time is not None:
            pulumi.set(__self__, "maintenance_window_end_time", maintenance_window_end_time)
        if maintenance_window_start_time is not None:
            pulumi.set(__self__, "maintenance_window_start_time", maintenance_window_start_time)
        if pre_maintenance_window_end_time is not None:
            pulumi.set(__self__, "pre_maintenance_window_end_time", pre_maintenance_window_end_time)
        if pre_maintenance_window_start_time is not None:
            pulumi.set(__self__, "pre_maintenance_window_start_time", pre_maintenance_window_start_time)

    @property
    @pulumi.getter(name="isCustomerInitiatedMaintenanceAllowed")
    def is_customer_initiated_maintenance_allowed(self) -> Optional[bool]:
        """
        True, if customer is allowed to perform Maintenance.
        """
        return pulumi.get(self, "is_customer_initiated_maintenance_allowed")

    @property
    @pulumi.getter(name="lastOperationMessage")
    def last_operation_message(self) -> Optional[str]:
        """
        Message returned for the last Maintenance Operation.
        """
        return pulumi.get(self, "last_operation_message")

    @property
    @pulumi.getter(name="lastOperationResultCode")
    def last_operation_result_code(self) -> Optional[str]:
        """
        The Last Maintenance Operation Result Code.
        """
        return pulumi.get(self, "last_operation_result_code")

    @property
    @pulumi.getter(name="maintenanceWindowEndTime")
    def maintenance_window_end_time(self) -> Optional[str]:
        """
        End Time for the Maintenance Window.
        """
        return pulumi.get(self, "maintenance_window_end_time")

    @property
    @pulumi.getter(name="maintenanceWindowStartTime")
    def maintenance_window_start_time(self) -> Optional[str]:
        """
        Start Time for the Maintenance Window.
        """
        return pulumi.get(self, "maintenance_window_start_time")

    @property
    @pulumi.getter(name="preMaintenanceWindowEndTime")
    def pre_maintenance_window_end_time(self) -> Optional[str]:
        """
        End Time for the Pre Maintenance Window.
        """
        return pulumi.get(self, "pre_maintenance_window_end_time")

    @property
    @pulumi.getter(name="preMaintenanceWindowStartTime")
    def pre_maintenance_window_start_time(self) -> Optional[str]:
        """
        Start Time for the Pre Maintenance Window.
        """
        return pulumi.get(self, "pre_maintenance_window_start_time")


@pulumi.output_type
class ManagedDiskParametersResponse(dict):
    """
    The parameters of a managed disk.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "diskEncryptionSet":
            suggest = "disk_encryption_set"
        elif key == "storageAccountType":
            suggest = "storage_account_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagedDiskParametersResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagedDiskParametersResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagedDiskParametersResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 disk_encryption_set: Optional['outputs.DiskEncryptionSetParametersResponse'] = None,
                 id: Optional[str] = None,
                 storage_account_type: Optional[str] = None):
        """
        The parameters of a managed disk.
        :param 'DiskEncryptionSetParametersResponse' disk_encryption_set: Specifies the customer managed disk encryption set resource id for the managed disk.
        :param str id: Resource Id
        :param str storage_account_type: Specifies the storage account type for the managed disk. Managed OS disk storage account type can only be set when you create the scale set. NOTE: UltraSSD_LRS can only be used with data disks, it cannot be used with OS Disk.
        """
        if disk_encryption_set is not None:
            pulumi.set(__self__, "disk_encryption_set", disk_encryption_set)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if storage_account_type is not None:
            pulumi.set(__self__, "storage_account_type", storage_account_type)

    @property
    @pulumi.getter(name="diskEncryptionSet")
    def disk_encryption_set(self) -> Optional['outputs.DiskEncryptionSetParametersResponse']:
        """
        Specifies the customer managed disk encryption set resource id for the managed disk.
        """
        return pulumi.get(self, "disk_encryption_set")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource Id
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="storageAccountType")
    def storage_account_type(self) -> Optional[str]:
        """
        Specifies the storage account type for the managed disk. Managed OS disk storage account type can only be set when you create the scale set. NOTE: UltraSSD_LRS can only be used with data disks, it cannot be used with OS Disk.
        """
        return pulumi.get(self, "storage_account_type")


@pulumi.output_type
class NetworkInterfaceReferenceResponse(dict):
    """
    Describes a network interface reference.
    """
    def __init__(__self__, *,
                 id: Optional[str] = None,
                 primary: Optional[bool] = None):
        """
        Describes a network interface reference.
        :param str id: Resource Id
        :param bool primary: Specifies the primary network interface in case the virtual machine has more than 1 network interface.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if primary is not None:
            pulumi.set(__self__, "primary", primary)

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource Id
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def primary(self) -> Optional[bool]:
        """
        Specifies the primary network interface in case the virtual machine has more than 1 network interface.
        """
        return pulumi.get(self, "primary")


@pulumi.output_type
class NetworkProfileResponse(dict):
    """
    Specifies the network interfaces of the virtual machine.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "networkInterfaces":
            suggest = "network_interfaces"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkProfileResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkProfileResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkProfileResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 network_interfaces: Optional[Sequence['outputs.NetworkInterfaceReferenceResponse']] = None):
        """
        Specifies the network interfaces of the virtual machine.
        :param Sequence['NetworkInterfaceReferenceResponse'] network_interfaces: Specifies the list of resource Ids for the network interfaces associated with the virtual machine.
        """
        if network_interfaces is not None:
            pulumi.set(__self__, "network_interfaces", network_interfaces)

    @property
    @pulumi.getter(name="networkInterfaces")
    def network_interfaces(self) -> Optional[Sequence['outputs.NetworkInterfaceReferenceResponse']]:
        """
        Specifies the list of resource Ids for the network interfaces associated with the virtual machine.
        """
        return pulumi.get(self, "network_interfaces")


@pulumi.output_type
class OSDiskResponse(dict):
    """
    Specifies information about the operating system disk used by the virtual machine. <br><br> For more information about disks, see [About disks and VHDs for Azure virtual machines](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-about-disks-vhds?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json).
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createOption":
            suggest = "create_option"
        elif key == "diffDiskSettings":
            suggest = "diff_disk_settings"
        elif key == "diskSizeGB":
            suggest = "disk_size_gb"
        elif key == "encryptionSettings":
            suggest = "encryption_settings"
        elif key == "managedDisk":
            suggest = "managed_disk"
        elif key == "osType":
            suggest = "os_type"
        elif key == "writeAcceleratorEnabled":
            suggest = "write_accelerator_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OSDiskResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OSDiskResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OSDiskResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 create_option: str,
                 caching: Optional[str] = None,
                 diff_disk_settings: Optional['outputs.DiffDiskSettingsResponse'] = None,
                 disk_size_gb: Optional[int] = None,
                 encryption_settings: Optional['outputs.DiskEncryptionSettingsResponse'] = None,
                 image: Optional['outputs.VirtualHardDiskResponse'] = None,
                 managed_disk: Optional['outputs.ManagedDiskParametersResponse'] = None,
                 name: Optional[str] = None,
                 os_type: Optional[str] = None,
                 vhd: Optional['outputs.VirtualHardDiskResponse'] = None,
                 write_accelerator_enabled: Optional[bool] = None):
        """
        Specifies information about the operating system disk used by the virtual machine. <br><br> For more information about disks, see [About disks and VHDs for Azure virtual machines](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-about-disks-vhds?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json).
        :param str create_option: Specifies how the virtual machine should be created.<br><br> Possible values are:<br><br> **Attach** \u2013 This value is used when you are using a specialized disk to create the virtual machine.<br><br> **FromImage** \u2013 This value is used when you are using an image to create the virtual machine. If you are using a platform image, you also use the imageReference element described above. If you are using a marketplace image, you  also use the plan element previously described.
        :param str caching: Specifies the caching requirements. <br><br> Possible values are: <br><br> **None** <br><br> **ReadOnly** <br><br> **ReadWrite** <br><br> Default: **None** for Standard storage. **ReadOnly** for Premium storage.
        :param 'DiffDiskSettingsResponse' diff_disk_settings: Specifies the ephemeral Disk Settings for the operating system disk used by the virtual machine.
        :param int disk_size_gb: Specifies the size of an empty data disk in gigabytes. This element can be used to overwrite the size of the disk in a virtual machine image. <br><br> This value cannot be larger than 1023 GB
        :param 'DiskEncryptionSettingsResponse' encryption_settings: Specifies the encryption settings for the OS Disk. <br><br> Minimum api-version: 2015-06-15
        :param 'VirtualHardDiskResponse' image: The source user image virtual hard disk. The virtual hard disk will be copied before being attached to the virtual machine. If SourceImage is provided, the destination virtual hard drive must not exist.
        :param 'ManagedDiskParametersResponse' managed_disk: The managed disk parameters.
        :param str name: The disk name.
        :param str os_type: This property allows you to specify the type of the OS that is included in the disk if creating a VM from user-image or a specialized VHD. <br><br> Possible values are: <br><br> **Windows** <br><br> **Linux**
        :param 'VirtualHardDiskResponse' vhd: The virtual hard disk.
        :param bool write_accelerator_enabled: Specifies whether writeAccelerator should be enabled or disabled on the disk.
        """
        pulumi.set(__self__, "create_option", create_option)
        if caching is not None:
            pulumi.set(__self__, "caching", caching)
        if diff_disk_settings is not None:
            pulumi.set(__self__, "diff_disk_settings", diff_disk_settings)
        if disk_size_gb is not None:
            pulumi.set(__self__, "disk_size_gb", disk_size_gb)
        if encryption_settings is not None:
            pulumi.set(__self__, "encryption_settings", encryption_settings)
        if image is not None:
            pulumi.set(__self__, "image", image)
        if managed_disk is not None:
            pulumi.set(__self__, "managed_disk", managed_disk)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if os_type is not None:
            pulumi.set(__self__, "os_type", os_type)
        if vhd is not None:
            pulumi.set(__self__, "vhd", vhd)
        if write_accelerator_enabled is not None:
            pulumi.set(__self__, "write_accelerator_enabled", write_accelerator_enabled)

    @property
    @pulumi.getter(name="createOption")
    def create_option(self) -> str:
        """
        Specifies how the virtual machine should be created.<br><br> Possible values are:<br><br> **Attach** \u2013 This value is used when you are using a specialized disk to create the virtual machine.<br><br> **FromImage** \u2013 This value is used when you are using an image to create the virtual machine. If you are using a platform image, you also use the imageReference element described above. If you are using a marketplace image, you  also use the plan element previously described.
        """
        return pulumi.get(self, "create_option")

    @property
    @pulumi.getter
    def caching(self) -> Optional[str]:
        """
        Specifies the caching requirements. <br><br> Possible values are: <br><br> **None** <br><br> **ReadOnly** <br><br> **ReadWrite** <br><br> Default: **None** for Standard storage. **ReadOnly** for Premium storage.
        """
        return pulumi.get(self, "caching")

    @property
    @pulumi.getter(name="diffDiskSettings")
    def diff_disk_settings(self) -> Optional['outputs.DiffDiskSettingsResponse']:
        """
        Specifies the ephemeral Disk Settings for the operating system disk used by the virtual machine.
        """
        return pulumi.get(self, "diff_disk_settings")

    @property
    @pulumi.getter(name="diskSizeGB")
    def disk_size_gb(self) -> Optional[int]:
        """
        Specifies the size of an empty data disk in gigabytes. This element can be used to overwrite the size of the disk in a virtual machine image. <br><br> This value cannot be larger than 1023 GB
        """
        return pulumi.get(self, "disk_size_gb")

    @property
    @pulumi.getter(name="encryptionSettings")
    def encryption_settings(self) -> Optional['outputs.DiskEncryptionSettingsResponse']:
        """
        Specifies the encryption settings for the OS Disk. <br><br> Minimum api-version: 2015-06-15
        """
        return pulumi.get(self, "encryption_settings")

    @property
    @pulumi.getter
    def image(self) -> Optional['outputs.VirtualHardDiskResponse']:
        """
        The source user image virtual hard disk. The virtual hard disk will be copied before being attached to the virtual machine. If SourceImage is provided, the destination virtual hard drive must not exist.
        """
        return pulumi.get(self, "image")

    @property
    @pulumi.getter(name="managedDisk")
    def managed_disk(self) -> Optional['outputs.ManagedDiskParametersResponse']:
        """
        The managed disk parameters.
        """
        return pulumi.get(self, "managed_disk")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The disk name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="osType")
    def os_type(self) -> Optional[str]:
        """
        This property allows you to specify the type of the OS that is included in the disk if creating a VM from user-image or a specialized VHD. <br><br> Possible values are: <br><br> **Windows** <br><br> **Linux**
        """
        return pulumi.get(self, "os_type")

    @property
    @pulumi.getter
    def vhd(self) -> Optional['outputs.VirtualHardDiskResponse']:
        """
        The virtual hard disk.
        """
        return pulumi.get(self, "vhd")

    @property
    @pulumi.getter(name="writeAcceleratorEnabled")
    def write_accelerator_enabled(self) -> Optional[bool]:
        """
        Specifies whether writeAccelerator should be enabled or disabled on the disk.
        """
        return pulumi.get(self, "write_accelerator_enabled")


@pulumi.output_type
class OSProfileResponse(dict):
    """
    Specifies the operating system settings for the virtual machine. Some of the settings cannot be changed once VM is provisioned.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "adminPassword":
            suggest = "admin_password"
        elif key == "adminUsername":
            suggest = "admin_username"
        elif key == "allowExtensionOperations":
            suggest = "allow_extension_operations"
        elif key == "computerName":
            suggest = "computer_name"
        elif key == "customData":
            suggest = "custom_data"
        elif key == "linuxConfiguration":
            suggest = "linux_configuration"
        elif key == "requireGuestProvisionSignal":
            suggest = "require_guest_provision_signal"
        elif key == "windowsConfiguration":
            suggest = "windows_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OSProfileResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OSProfileResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OSProfileResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 admin_password: Optional[str] = None,
                 admin_username: Optional[str] = None,
                 allow_extension_operations: Optional[bool] = None,
                 computer_name: Optional[str] = None,
                 custom_data: Optional[str] = None,
                 linux_configuration: Optional['outputs.LinuxConfigurationResponse'] = None,
                 require_guest_provision_signal: Optional[bool] = None,
                 secrets: Optional[Sequence['outputs.VaultSecretGroupResponse']] = None,
                 windows_configuration: Optional['outputs.WindowsConfigurationResponse'] = None):
        """
        Specifies the operating system settings for the virtual machine. Some of the settings cannot be changed once VM is provisioned.
        :param str admin_password: Specifies the password of the administrator account. <br><br> **Minimum-length (Windows):** 8 characters <br><br> **Minimum-length (Linux):** 6 characters <br><br> **Max-length (Windows):** 123 characters <br><br> **Max-length (Linux):** 72 characters <br><br> **Complexity requirements:** 3 out of 4 conditions below need to be fulfilled <br> Has lower characters <br>Has upper characters <br> Has a digit <br> Has a special character (Regex match [\W_]) <br><br> **Disallowed values:** "abc@123", "P@$$w0rd", "P@ssw0rd", "P@ssword123", "Pa$$word", "pass@word1", "Password!", "Password1", "Password22", "iloveyou!" <br><br> For resetting the password, see [How to reset the Remote Desktop service or its login password in a Windows VM](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-reset-rdp?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json) <br><br> For resetting root password, see [Manage users, SSH, and check or repair disks on Azure Linux VMs using the VMAccess Extension](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-using-vmaccess-extension?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json#reset-root-password)
        :param str admin_username: Specifies the name of the administrator account. <br><br> This property cannot be updated after the VM is created. <br><br> **Windows-only restriction:** Cannot end in "." <br><br> **Disallowed values:** "administrator", "admin", "user", "user1", "test", "user2", "test1", "user3", "admin1", "1", "123", "a", "actuser", "adm", "admin2", "aspnet", "backup", "console", "david", "guest", "john", "owner", "root", "server", "sql", "support", "support_388945a0", "sys", "test2", "test3", "user4", "user5". <br><br> **Minimum-length (Linux):** 1  character <br><br> **Max-length (Linux):** 64 characters <br><br> **Max-length (Windows):** 20 characters  <br><br><li> For root access to the Linux VM, see [Using root privileges on Linux virtual machines in Azure](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-use-root-privileges?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json)<br><li> For a list of built-in system users on Linux that should not be used in this field, see [Selecting User Names for Linux on Azure](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-usernames?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json)
        :param bool allow_extension_operations: Specifies whether extension operations should be allowed on the virtual machine. <br><br>This may only be set to False when no extensions are present on the virtual machine.
        :param str computer_name: Specifies the host OS name of the virtual machine. <br><br> This name cannot be updated after the VM is created. <br><br> **Max-length (Windows):** 15 characters <br><br> **Max-length (Linux):** 64 characters. <br><br> For naming conventions and restrictions see [Azure infrastructure services implementation guidelines](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-infrastructure-subscription-accounts-guidelines?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json#1-naming-conventions).
        :param str custom_data: Specifies a base-64 encoded string of custom data. The base-64 encoded string is decoded to a binary array that is saved as a file on the Virtual Machine. The maximum length of the binary array is 65535 bytes. <br><br> **Note: Do not pass any secrets or passwords in customData property** <br><br> This property cannot be updated after the VM is created. <br><br> customData is passed to the VM to be saved as a file, for more information see [Custom Data on Azure VMs](https://azure.microsoft.com/en-us/blog/custom-data-and-cloud-init-on-windows-azure/) <br><br> For using cloud-init for your Linux VM, see [Using cloud-init to customize a Linux VM during creation](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-using-cloud-init?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json)
        :param 'LinuxConfigurationResponse' linux_configuration: Specifies the Linux operating system settings on the virtual machine. <br><br>For a list of supported Linux distributions, see [Linux on Azure-Endorsed Distributions](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-endorsed-distros?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json) <br><br> For running non-endorsed distributions, see [Information for Non-Endorsed Distributions](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-create-upload-generic?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json).
        :param bool require_guest_provision_signal: Specifies whether the guest provision signal is required to infer provision success of the virtual machine.  **Note: This property is for private testing only, and all customers must not set the property to false.**
        :param Sequence['VaultSecretGroupResponse'] secrets: Specifies set of certificates that should be installed onto the virtual machine.
        :param 'WindowsConfigurationResponse' windows_configuration: Specifies Windows operating system settings on the virtual machine.
        """
        if admin_password is not None:
            pulumi.set(__self__, "admin_password", admin_password)
        if admin_username is not None:
            pulumi.set(__self__, "admin_username", admin_username)
        if allow_extension_operations is not None:
            pulumi.set(__self__, "allow_extension_operations", allow_extension_operations)
        if computer_name is not None:
            pulumi.set(__self__, "computer_name", computer_name)
        if custom_data is not None:
            pulumi.set(__self__, "custom_data", custom_data)
        if linux_configuration is not None:
            pulumi.set(__self__, "linux_configuration", linux_configuration)
        if require_guest_provision_signal is not None:
            pulumi.set(__self__, "require_guest_provision_signal", require_guest_provision_signal)
        if secrets is not None:
            pulumi.set(__self__, "secrets", secrets)
        if windows_configuration is not None:
            pulumi.set(__self__, "windows_configuration", windows_configuration)

    @property
    @pulumi.getter(name="adminPassword")
    def admin_password(self) -> Optional[str]:
        """
        Specifies the password of the administrator account. <br><br> **Minimum-length (Windows):** 8 characters <br><br> **Minimum-length (Linux):** 6 characters <br><br> **Max-length (Windows):** 123 characters <br><br> **Max-length (Linux):** 72 characters <br><br> **Complexity requirements:** 3 out of 4 conditions below need to be fulfilled <br> Has lower characters <br>Has upper characters <br> Has a digit <br> Has a special character (Regex match [\W_]) <br><br> **Disallowed values:** "abc@123", "P@$$w0rd", "P@ssw0rd", "P@ssword123", "Pa$$word", "pass@word1", "Password!", "Password1", "Password22", "iloveyou!" <br><br> For resetting the password, see [How to reset the Remote Desktop service or its login password in a Windows VM](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-reset-rdp?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json) <br><br> For resetting root password, see [Manage users, SSH, and check or repair disks on Azure Linux VMs using the VMAccess Extension](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-using-vmaccess-extension?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json#reset-root-password)
        """
        return pulumi.get(self, "admin_password")

    @property
    @pulumi.getter(name="adminUsername")
    def admin_username(self) -> Optional[str]:
        """
        Specifies the name of the administrator account. <br><br> This property cannot be updated after the VM is created. <br><br> **Windows-only restriction:** Cannot end in "." <br><br> **Disallowed values:** "administrator", "admin", "user", "user1", "test", "user2", "test1", "user3", "admin1", "1", "123", "a", "actuser", "adm", "admin2", "aspnet", "backup", "console", "david", "guest", "john", "owner", "root", "server", "sql", "support", "support_388945a0", "sys", "test2", "test3", "user4", "user5". <br><br> **Minimum-length (Linux):** 1  character <br><br> **Max-length (Linux):** 64 characters <br><br> **Max-length (Windows):** 20 characters  <br><br><li> For root access to the Linux VM, see [Using root privileges on Linux virtual machines in Azure](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-use-root-privileges?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json)<br><li> For a list of built-in system users on Linux that should not be used in this field, see [Selecting User Names for Linux on Azure](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-usernames?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json)
        """
        return pulumi.get(self, "admin_username")

    @property
    @pulumi.getter(name="allowExtensionOperations")
    def allow_extension_operations(self) -> Optional[bool]:
        """
        Specifies whether extension operations should be allowed on the virtual machine. <br><br>This may only be set to False when no extensions are present on the virtual machine.
        """
        return pulumi.get(self, "allow_extension_operations")

    @property
    @pulumi.getter(name="computerName")
    def computer_name(self) -> Optional[str]:
        """
        Specifies the host OS name of the virtual machine. <br><br> This name cannot be updated after the VM is created. <br><br> **Max-length (Windows):** 15 characters <br><br> **Max-length (Linux):** 64 characters. <br><br> For naming conventions and restrictions see [Azure infrastructure services implementation guidelines](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-infrastructure-subscription-accounts-guidelines?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json#1-naming-conventions).
        """
        return pulumi.get(self, "computer_name")

    @property
    @pulumi.getter(name="customData")
    def custom_data(self) -> Optional[str]:
        """
        Specifies a base-64 encoded string of custom data. The base-64 encoded string is decoded to a binary array that is saved as a file on the Virtual Machine. The maximum length of the binary array is 65535 bytes. <br><br> **Note: Do not pass any secrets or passwords in customData property** <br><br> This property cannot be updated after the VM is created. <br><br> customData is passed to the VM to be saved as a file, for more information see [Custom Data on Azure VMs](https://azure.microsoft.com/en-us/blog/custom-data-and-cloud-init-on-windows-azure/) <br><br> For using cloud-init for your Linux VM, see [Using cloud-init to customize a Linux VM during creation](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-using-cloud-init?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json)
        """
        return pulumi.get(self, "custom_data")

    @property
    @pulumi.getter(name="linuxConfiguration")
    def linux_configuration(self) -> Optional['outputs.LinuxConfigurationResponse']:
        """
        Specifies the Linux operating system settings on the virtual machine. <br><br>For a list of supported Linux distributions, see [Linux on Azure-Endorsed Distributions](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-endorsed-distros?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json) <br><br> For running non-endorsed distributions, see [Information for Non-Endorsed Distributions](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-create-upload-generic?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json).
        """
        return pulumi.get(self, "linux_configuration")

    @property
    @pulumi.getter(name="requireGuestProvisionSignal")
    def require_guest_provision_signal(self) -> Optional[bool]:
        """
        Specifies whether the guest provision signal is required to infer provision success of the virtual machine.  **Note: This property is for private testing only, and all customers must not set the property to false.**
        """
        return pulumi.get(self, "require_guest_provision_signal")

    @property
    @pulumi.getter
    def secrets(self) -> Optional[Sequence['outputs.VaultSecretGroupResponse']]:
        """
        Specifies set of certificates that should be installed onto the virtual machine.
        """
        return pulumi.get(self, "secrets")

    @property
    @pulumi.getter(name="windowsConfiguration")
    def windows_configuration(self) -> Optional['outputs.WindowsConfigurationResponse']:
        """
        Specifies Windows operating system settings on the virtual machine.
        """
        return pulumi.get(self, "windows_configuration")


@pulumi.output_type
class PatchSettingsResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "patchMode":
            suggest = "patch_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PatchSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PatchSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PatchSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 patch_mode: Optional[str] = None):
        """
        :param str patch_mode: Specifies the mode of in-guest patching to IaaS virtual machine.<br /><br /> Possible values are:<br /><br /> **Manual** - You  control the application of patches to a virtual machine. You do this by applying patches manually inside the VM. In this mode, automatic updates are disabled; the property WindowsConfiguration.enableAutomaticUpdates must be false<br /><br /> **AutomaticByOS** - The virtual machine will automatically be updated by the OS. The property WindowsConfiguration.enableAutomaticUpdates must be true. <br /><br /> **AutomaticByPlatform** - the virtual machine will automatically updated by the platform. The properties provisionVMAgent and WindowsConfiguration.enableAutomaticUpdates must be true 
        """
        if patch_mode is not None:
            pulumi.set(__self__, "patch_mode", patch_mode)

    @property
    @pulumi.getter(name="patchMode")
    def patch_mode(self) -> Optional[str]:
        """
        Specifies the mode of in-guest patching to IaaS virtual machine.<br /><br /> Possible values are:<br /><br /> **Manual** - You  control the application of patches to a virtual machine. You do this by applying patches manually inside the VM. In this mode, automatic updates are disabled; the property WindowsConfiguration.enableAutomaticUpdates must be false<br /><br /> **AutomaticByOS** - The virtual machine will automatically be updated by the OS. The property WindowsConfiguration.enableAutomaticUpdates must be true. <br /><br /> **AutomaticByPlatform** - the virtual machine will automatically updated by the platform. The properties provisionVMAgent and WindowsConfiguration.enableAutomaticUpdates must be true 
        """
        return pulumi.get(self, "patch_mode")


@pulumi.output_type
class PlanResponse(dict):
    """
    Specifies information about the marketplace image used to create the virtual machine. This element is only used for marketplace images. Before you can use a marketplace image from an API, you must enable the image for programmatic use.  In the Azure portal, find the marketplace image that you want to use and then click **Want to deploy programmatically, Get Started ->**. Enter any required information and then click **Save**.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "promotionCode":
            suggest = "promotion_code"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PlanResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PlanResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PlanResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: Optional[str] = None,
                 product: Optional[str] = None,
                 promotion_code: Optional[str] = None,
                 publisher: Optional[str] = None):
        """
        Specifies information about the marketplace image used to create the virtual machine. This element is only used for marketplace images. Before you can use a marketplace image from an API, you must enable the image for programmatic use.  In the Azure portal, find the marketplace image that you want to use and then click **Want to deploy programmatically, Get Started ->**. Enter any required information and then click **Save**.
        :param str name: The plan ID.
        :param str product: Specifies the product of the image from the marketplace. This is the same value as Offer under the imageReference element.
        :param str promotion_code: The promotion code.
        :param str publisher: The publisher ID.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if product is not None:
            pulumi.set(__self__, "product", product)
        if promotion_code is not None:
            pulumi.set(__self__, "promotion_code", promotion_code)
        if publisher is not None:
            pulumi.set(__self__, "publisher", publisher)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The plan ID.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def product(self) -> Optional[str]:
        """
        Specifies the product of the image from the marketplace. This is the same value as Offer under the imageReference element.
        """
        return pulumi.get(self, "product")

    @property
    @pulumi.getter(name="promotionCode")
    def promotion_code(self) -> Optional[str]:
        """
        The promotion code.
        """
        return pulumi.get(self, "promotion_code")

    @property
    @pulumi.getter
    def publisher(self) -> Optional[str]:
        """
        The publisher ID.
        """
        return pulumi.get(self, "publisher")


@pulumi.output_type
class RollingUpgradePolicyResponse(dict):
    """
    The configuration parameters used while performing a rolling upgrade.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxBatchInstancePercent":
            suggest = "max_batch_instance_percent"
        elif key == "maxUnhealthyInstancePercent":
            suggest = "max_unhealthy_instance_percent"
        elif key == "maxUnhealthyUpgradedInstancePercent":
            suggest = "max_unhealthy_upgraded_instance_percent"
        elif key == "pauseTimeBetweenBatches":
            suggest = "pause_time_between_batches"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RollingUpgradePolicyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RollingUpgradePolicyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RollingUpgradePolicyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_batch_instance_percent: Optional[int] = None,
                 max_unhealthy_instance_percent: Optional[int] = None,
                 max_unhealthy_upgraded_instance_percent: Optional[int] = None,
                 pause_time_between_batches: Optional[str] = None):
        """
        The configuration parameters used while performing a rolling upgrade.
        :param int max_batch_instance_percent: The maximum percent of total virtual machine instances that will be upgraded simultaneously by the rolling upgrade in one batch. As this is a maximum, unhealthy instances in previous or future batches can cause the percentage of instances in a batch to decrease to ensure higher reliability. The default value for this parameter is 20%.
        :param int max_unhealthy_instance_percent: The maximum percentage of the total virtual machine instances in the scale set that can be simultaneously unhealthy, either as a result of being upgraded, or by being found in an unhealthy state by the virtual machine health checks before the rolling upgrade aborts. This constraint will be checked prior to starting any batch. The default value for this parameter is 20%.
        :param int max_unhealthy_upgraded_instance_percent: The maximum percentage of upgraded virtual machine instances that can be found to be in an unhealthy state. This check will happen after each batch is upgraded. If this percentage is ever exceeded, the rolling update aborts. The default value for this parameter is 20%.
        :param str pause_time_between_batches: The wait time between completing the update for all virtual machines in one batch and starting the next batch. The time duration should be specified in ISO 8601 format. The default value is 0 seconds (PT0S).
        """
        if max_batch_instance_percent is not None:
            pulumi.set(__self__, "max_batch_instance_percent", max_batch_instance_percent)
        if max_unhealthy_instance_percent is not None:
            pulumi.set(__self__, "max_unhealthy_instance_percent", max_unhealthy_instance_percent)
        if max_unhealthy_upgraded_instance_percent is not None:
            pulumi.set(__self__, "max_unhealthy_upgraded_instance_percent", max_unhealthy_upgraded_instance_percent)
        if pause_time_between_batches is not None:
            pulumi.set(__self__, "pause_time_between_batches", pause_time_between_batches)

    @property
    @pulumi.getter(name="maxBatchInstancePercent")
    def max_batch_instance_percent(self) -> Optional[int]:
        """
        The maximum percent of total virtual machine instances that will be upgraded simultaneously by the rolling upgrade in one batch. As this is a maximum, unhealthy instances in previous or future batches can cause the percentage of instances in a batch to decrease to ensure higher reliability. The default value for this parameter is 20%.
        """
        return pulumi.get(self, "max_batch_instance_percent")

    @property
    @pulumi.getter(name="maxUnhealthyInstancePercent")
    def max_unhealthy_instance_percent(self) -> Optional[int]:
        """
        The maximum percentage of the total virtual machine instances in the scale set that can be simultaneously unhealthy, either as a result of being upgraded, or by being found in an unhealthy state by the virtual machine health checks before the rolling upgrade aborts. This constraint will be checked prior to starting any batch. The default value for this parameter is 20%.
        """
        return pulumi.get(self, "max_unhealthy_instance_percent")

    @property
    @pulumi.getter(name="maxUnhealthyUpgradedInstancePercent")
    def max_unhealthy_upgraded_instance_percent(self) -> Optional[int]:
        """
        The maximum percentage of upgraded virtual machine instances that can be found to be in an unhealthy state. This check will happen after each batch is upgraded. If this percentage is ever exceeded, the rolling update aborts. The default value for this parameter is 20%.
        """
        return pulumi.get(self, "max_unhealthy_upgraded_instance_percent")

    @property
    @pulumi.getter(name="pauseTimeBetweenBatches")
    def pause_time_between_batches(self) -> Optional[str]:
        """
        The wait time between completing the update for all virtual machines in one batch and starting the next batch. The time duration should be specified in ISO 8601 format. The default value is 0 seconds (PT0S).
        """
        return pulumi.get(self, "pause_time_between_batches")


@pulumi.output_type
class RunCommandInputParameterResponse(dict):
    """
    Describes the properties of a run command parameter.
    """
    def __init__(__self__, *,
                 name: str,
                 value: str):
        """
        Describes the properties of a run command parameter.
        :param str name: The run command parameter name.
        :param str value: The run command parameter value.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The run command parameter name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The run command parameter value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ScaleInPolicyResponse(dict):
    """
    Describes a scale-in policy for a virtual machine scale set.
    """
    def __init__(__self__, *,
                 rules: Optional[Sequence[str]] = None):
        """
        Describes a scale-in policy for a virtual machine scale set.
        :param Sequence[str] rules: The rules to be followed when scaling-in a virtual machine scale set. <br><br> Possible values are: <br><br> **Default** When a virtual machine scale set is scaled in, the scale set will first be balanced across zones if it is a zonal scale set. Then, it will be balanced across Fault Domains as far as possible. Within each Fault Domain, the virtual machines chosen for removal will be the newest ones that are not protected from scale-in. <br><br> **OldestVM** When a virtual machine scale set is being scaled-in, the oldest virtual machines that are not protected from scale-in will be chosen for removal. For zonal virtual machine scale sets, the scale set will first be balanced across zones. Within each zone, the oldest virtual machines that are not protected will be chosen for removal. <br><br> **NewestVM** When a virtual machine scale set is being scaled-in, the newest virtual machines that are not protected from scale-in will be chosen for removal. For zonal virtual machine scale sets, the scale set will first be balanced across zones. Within each zone, the newest virtual machines that are not protected will be chosen for removal. <br><br>
        """
        if rules is not None:
            pulumi.set(__self__, "rules", rules)

    @property
    @pulumi.getter
    def rules(self) -> Optional[Sequence[str]]:
        """
        The rules to be followed when scaling-in a virtual machine scale set. <br><br> Possible values are: <br><br> **Default** When a virtual machine scale set is scaled in, the scale set will first be balanced across zones if it is a zonal scale set. Then, it will be balanced across Fault Domains as far as possible. Within each Fault Domain, the virtual machines chosen for removal will be the newest ones that are not protected from scale-in. <br><br> **OldestVM** When a virtual machine scale set is being scaled-in, the oldest virtual machines that are not protected from scale-in will be chosen for removal. For zonal virtual machine scale sets, the scale set will first be balanced across zones. Within each zone, the oldest virtual machines that are not protected will be chosen for removal. <br><br> **NewestVM** When a virtual machine scale set is being scaled-in, the newest virtual machines that are not protected from scale-in will be chosen for removal. For zonal virtual machine scale sets, the scale set will first be balanced across zones. Within each zone, the newest virtual machines that are not protected will be chosen for removal. <br><br>
        """
        return pulumi.get(self, "rules")


@pulumi.output_type
class ScheduledEventsProfileResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "terminateNotificationProfile":
            suggest = "terminate_notification_profile"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScheduledEventsProfileResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScheduledEventsProfileResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScheduledEventsProfileResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 terminate_notification_profile: Optional['outputs.TerminateNotificationProfileResponse'] = None):
        """
        :param 'TerminateNotificationProfileResponse' terminate_notification_profile: Specifies Terminate Scheduled Event related configurations.
        """
        if terminate_notification_profile is not None:
            pulumi.set(__self__, "terminate_notification_profile", terminate_notification_profile)

    @property
    @pulumi.getter(name="terminateNotificationProfile")
    def terminate_notification_profile(self) -> Optional['outputs.TerminateNotificationProfileResponse']:
        """
        Specifies Terminate Scheduled Event related configurations.
        """
        return pulumi.get(self, "terminate_notification_profile")


@pulumi.output_type
class SecurityProfileResponse(dict):
    """
    Specifies the Security profile settings for the virtual machine or virtual machine scale set.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "encryptionAtHost":
            suggest = "encryption_at_host"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecurityProfileResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecurityProfileResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecurityProfileResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 encryption_at_host: Optional[bool] = None):
        """
        Specifies the Security profile settings for the virtual machine or virtual machine scale set.
        :param bool encryption_at_host: This property can be used by user in the request to enable or disable the Host Encryption for the virtual machine or virtual machine scale set. This will enable the encryption for all the disks including Resource/Temp disk at host itself. <br><br> Default: The Encryption at host will be disabled unless this property is set to true for the resource.
        """
        if encryption_at_host is not None:
            pulumi.set(__self__, "encryption_at_host", encryption_at_host)

    @property
    @pulumi.getter(name="encryptionAtHost")
    def encryption_at_host(self) -> Optional[bool]:
        """
        This property can be used by user in the request to enable or disable the Host Encryption for the virtual machine or virtual machine scale set. This will enable the encryption for all the disks including Resource/Temp disk at host itself. <br><br> Default: The Encryption at host will be disabled unless this property is set to true for the resource.
        """
        return pulumi.get(self, "encryption_at_host")


@pulumi.output_type
class SkuResponse(dict):
    """
    Describes a virtual machine scale set sku. NOTE: If the new VM SKU is not supported on the hardware the scale set is currently on, you need to deallocate the VMs in the scale set before you modify the SKU name.
    """
    def __init__(__self__, *,
                 capacity: Optional[float] = None,
                 name: Optional[str] = None,
                 tier: Optional[str] = None):
        """
        Describes a virtual machine scale set sku. NOTE: If the new VM SKU is not supported on the hardware the scale set is currently on, you need to deallocate the VMs in the scale set before you modify the SKU name.
        :param float capacity: Specifies the number of virtual machines in the scale set.
        :param str name: The sku name.
        :param str tier: Specifies the tier of virtual machines in a scale set.<br /><br /> Possible Values:<br /><br /> **Standard**<br /><br /> **Basic**
        """
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tier is not None:
            pulumi.set(__self__, "tier", tier)

    @property
    @pulumi.getter
    def capacity(self) -> Optional[float]:
        """
        Specifies the number of virtual machines in the scale set.
        """
        return pulumi.get(self, "capacity")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The sku name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def tier(self) -> Optional[str]:
        """
        Specifies the tier of virtual machines in a scale set.<br /><br /> Possible Values:<br /><br /> **Standard**<br /><br /> **Basic**
        """
        return pulumi.get(self, "tier")


@pulumi.output_type
class SshConfigurationResponse(dict):
    """
    SSH configuration for Linux based VMs running on Azure
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "publicKeys":
            suggest = "public_keys"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SshConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SshConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SshConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 public_keys: Optional[Sequence['outputs.SshPublicKeyResponse']] = None):
        """
        SSH configuration for Linux based VMs running on Azure
        :param Sequence['SshPublicKeyResponse'] public_keys: The list of SSH public keys used to authenticate with linux based VMs.
        """
        if public_keys is not None:
            pulumi.set(__self__, "public_keys", public_keys)

    @property
    @pulumi.getter(name="publicKeys")
    def public_keys(self) -> Optional[Sequence['outputs.SshPublicKeyResponse']]:
        """
        The list of SSH public keys used to authenticate with linux based VMs.
        """
        return pulumi.get(self, "public_keys")


@pulumi.output_type
class SshPublicKeyResponse(dict):
    """
    Contains information about SSH certificate public key and the path on the Linux VM where the public key is placed.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keyData":
            suggest = "key_data"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SshPublicKeyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SshPublicKeyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SshPublicKeyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key_data: Optional[str] = None,
                 path: Optional[str] = None):
        """
        Contains information about SSH certificate public key and the path on the Linux VM where the public key is placed.
        :param str key_data: SSH public key certificate used to authenticate with the VM through ssh. The key needs to be at least 2048-bit and in ssh-rsa format. <br><br> For creating ssh keys, see [Create SSH keys on Linux and Mac for Linux VMs in Azure](https://docs.microsoft.com/en-us/azure/virtual-machines/linux/mac-create-ssh-keys?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json).
        :param str path: Specifies the full path on the created VM where ssh public key is stored. If the file already exists, the specified key is appended to the file. Example: /home/user/.ssh/authorized_keys
        """
        if key_data is not None:
            pulumi.set(__self__, "key_data", key_data)
        if path is not None:
            pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter(name="keyData")
    def key_data(self) -> Optional[str]:
        """
        SSH public key certificate used to authenticate with the VM through ssh. The key needs to be at least 2048-bit and in ssh-rsa format. <br><br> For creating ssh keys, see [Create SSH keys on Linux and Mac for Linux VMs in Azure](https://docs.microsoft.com/en-us/azure/virtual-machines/linux/mac-create-ssh-keys?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json).
        """
        return pulumi.get(self, "key_data")

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        Specifies the full path on the created VM where ssh public key is stored. If the file already exists, the specified key is appended to the file. Example: /home/user/.ssh/authorized_keys
        """
        return pulumi.get(self, "path")


@pulumi.output_type
class StorageProfileResponse(dict):
    """
    Specifies the storage settings for the virtual machine disks.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataDisks":
            suggest = "data_disks"
        elif key == "imageReference":
            suggest = "image_reference"
        elif key == "osDisk":
            suggest = "os_disk"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StorageProfileResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StorageProfileResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StorageProfileResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data_disks: Optional[Sequence['outputs.DataDiskResponse']] = None,
                 image_reference: Optional['outputs.ImageReferenceResponse'] = None,
                 os_disk: Optional['outputs.OSDiskResponse'] = None):
        """
        Specifies the storage settings for the virtual machine disks.
        :param Sequence['DataDiskResponse'] data_disks: Specifies the parameters that are used to add a data disk to a virtual machine. <br><br> For more information about disks, see [About disks and VHDs for Azure virtual machines](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-about-disks-vhds?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json).
        :param 'ImageReferenceResponse' image_reference: Specifies information about the image to use. You can specify information about platform images, marketplace images, or virtual machine images. This element is required when you want to use a platform image, marketplace image, or virtual machine image, but is not used in other creation operations.
        :param 'OSDiskResponse' os_disk: Specifies information about the operating system disk used by the virtual machine. <br><br> For more information about disks, see [About disks and VHDs for Azure virtual machines](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-about-disks-vhds?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json).
        """
        if data_disks is not None:
            pulumi.set(__self__, "data_disks", data_disks)
        if image_reference is not None:
            pulumi.set(__self__, "image_reference", image_reference)
        if os_disk is not None:
            pulumi.set(__self__, "os_disk", os_disk)

    @property
    @pulumi.getter(name="dataDisks")
    def data_disks(self) -> Optional[Sequence['outputs.DataDiskResponse']]:
        """
        Specifies the parameters that are used to add a data disk to a virtual machine. <br><br> For more information about disks, see [About disks and VHDs for Azure virtual machines](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-about-disks-vhds?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json).
        """
        return pulumi.get(self, "data_disks")

    @property
    @pulumi.getter(name="imageReference")
    def image_reference(self) -> Optional['outputs.ImageReferenceResponse']:
        """
        Specifies information about the image to use. You can specify information about platform images, marketplace images, or virtual machine images. This element is required when you want to use a platform image, marketplace image, or virtual machine image, but is not used in other creation operations.
        """
        return pulumi.get(self, "image_reference")

    @property
    @pulumi.getter(name="osDisk")
    def os_disk(self) -> Optional['outputs.OSDiskResponse']:
        """
        Specifies information about the operating system disk used by the virtual machine. <br><br> For more information about disks, see [About disks and VHDs for Azure virtual machines](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-about-disks-vhds?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json).
        """
        return pulumi.get(self, "os_disk")


@pulumi.output_type
class SubResourceReadOnlyResponse(dict):
    def __init__(__self__, *,
                 id: str):
        """
        :param str id: Resource Id
        """
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Resource Id
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class SubResourceResponse(dict):
    def __init__(__self__, *,
                 id: Optional[str] = None):
        """
        :param str id: Resource Id
        """
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource Id
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class SubResourceWithColocationStatusResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "colocationStatus":
            suggest = "colocation_status"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SubResourceWithColocationStatusResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SubResourceWithColocationStatusResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SubResourceWithColocationStatusResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 colocation_status: Optional['outputs.InstanceViewStatusResponse'] = None,
                 id: Optional[str] = None):
        """
        :param 'InstanceViewStatusResponse' colocation_status: Describes colocation status of a resource in the Proximity Placement Group.
        :param str id: Resource Id
        """
        if colocation_status is not None:
            pulumi.set(__self__, "colocation_status", colocation_status)
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter(name="colocationStatus")
    def colocation_status(self) -> Optional['outputs.InstanceViewStatusResponse']:
        """
        Describes colocation status of a resource in the Proximity Placement Group.
        """
        return pulumi.get(self, "colocation_status")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource Id
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class TerminateNotificationProfileResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "notBeforeTimeout":
            suggest = "not_before_timeout"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TerminateNotificationProfileResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TerminateNotificationProfileResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TerminateNotificationProfileResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enable: Optional[bool] = None,
                 not_before_timeout: Optional[str] = None):
        """
        :param bool enable: Specifies whether the Terminate Scheduled event is enabled or disabled.
        :param str not_before_timeout: Configurable length of time a Virtual Machine being deleted will have to potentially approve the Terminate Scheduled Event before the event is auto approved (timed out). The configuration must be specified in ISO 8601 format, the default value is 5 minutes (PT5M)
        """
        if enable is not None:
            pulumi.set(__self__, "enable", enable)
        if not_before_timeout is not None:
            pulumi.set(__self__, "not_before_timeout", not_before_timeout)

    @property
    @pulumi.getter
    def enable(self) -> Optional[bool]:
        """
        Specifies whether the Terminate Scheduled event is enabled or disabled.
        """
        return pulumi.get(self, "enable")

    @property
    @pulumi.getter(name="notBeforeTimeout")
    def not_before_timeout(self) -> Optional[str]:
        """
        Configurable length of time a Virtual Machine being deleted will have to potentially approve the Terminate Scheduled Event before the event is auto approved (timed out). The configuration must be specified in ISO 8601 format, the default value is 5 minutes (PT5M)
        """
        return pulumi.get(self, "not_before_timeout")


@pulumi.output_type
class UpgradePolicyResponse(dict):
    """
    Describes an upgrade policy - automatic, manual, or rolling.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "automaticOSUpgradePolicy":
            suggest = "automatic_os_upgrade_policy"
        elif key == "rollingUpgradePolicy":
            suggest = "rolling_upgrade_policy"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UpgradePolicyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UpgradePolicyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UpgradePolicyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 automatic_os_upgrade_policy: Optional['outputs.AutomaticOSUpgradePolicyResponse'] = None,
                 mode: Optional[str] = None,
                 rolling_upgrade_policy: Optional['outputs.RollingUpgradePolicyResponse'] = None):
        """
        Describes an upgrade policy - automatic, manual, or rolling.
        :param 'AutomaticOSUpgradePolicyResponse' automatic_os_upgrade_policy: Configuration parameters used for performing automatic OS Upgrade.
        :param str mode: Specifies the mode of an upgrade to virtual machines in the scale set.<br /><br /> Possible values are:<br /><br /> **Manual** - You  control the application of updates to virtual machines in the scale set. You do this by using the manualUpgrade action.<br /><br /> **Automatic** - All virtual machines in the scale set are  automatically updated at the same time.
        :param 'RollingUpgradePolicyResponse' rolling_upgrade_policy: The configuration parameters used while performing a rolling upgrade.
        """
        if automatic_os_upgrade_policy is not None:
            pulumi.set(__self__, "automatic_os_upgrade_policy", automatic_os_upgrade_policy)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if rolling_upgrade_policy is not None:
            pulumi.set(__self__, "rolling_upgrade_policy", rolling_upgrade_policy)

    @property
    @pulumi.getter(name="automaticOSUpgradePolicy")
    def automatic_os_upgrade_policy(self) -> Optional['outputs.AutomaticOSUpgradePolicyResponse']:
        """
        Configuration parameters used for performing automatic OS Upgrade.
        """
        return pulumi.get(self, "automatic_os_upgrade_policy")

    @property
    @pulumi.getter
    def mode(self) -> Optional[str]:
        """
        Specifies the mode of an upgrade to virtual machines in the scale set.<br /><br /> Possible values are:<br /><br /> **Manual** - You  control the application of updates to virtual machines in the scale set. You do this by using the manualUpgrade action.<br /><br /> **Automatic** - All virtual machines in the scale set are  automatically updated at the same time.
        """
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter(name="rollingUpgradePolicy")
    def rolling_upgrade_policy(self) -> Optional['outputs.RollingUpgradePolicyResponse']:
        """
        The configuration parameters used while performing a rolling upgrade.
        """
        return pulumi.get(self, "rolling_upgrade_policy")


@pulumi.output_type
class VaultCertificateResponse(dict):
    """
    Describes a single certificate reference in a Key Vault, and where the certificate should reside on the VM.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "certificateStore":
            suggest = "certificate_store"
        elif key == "certificateUrl":
            suggest = "certificate_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VaultCertificateResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VaultCertificateResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VaultCertificateResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 certificate_store: Optional[str] = None,
                 certificate_url: Optional[str] = None):
        """
        Describes a single certificate reference in a Key Vault, and where the certificate should reside on the VM.
        :param str certificate_store: For Windows VMs, specifies the certificate store on the Virtual Machine to which the certificate should be added. The specified certificate store is implicitly in the LocalMachine account. <br><br>For Linux VMs, the certificate file is placed under the /var/lib/waagent directory, with the file name &lt;UppercaseThumbprint&gt;.crt for the X509 certificate file and &lt;UppercaseThumbprint&gt;.prv for private key. Both of these files are .pem formatted.
        :param str certificate_url: This is the URL of a certificate that has been uploaded to Key Vault as a secret. For adding a secret to the Key Vault, see [Add a key or secret to the key vault](https://docs.microsoft.com/azure/key-vault/key-vault-get-started/#add). In this case, your certificate needs to be It is the Base64 encoding of the following JSON Object which is encoded in UTF-8: <br><br> {<br>  "data":"<Base64-encoded-certificate>",<br>  "dataType":"pfx",<br>  "password":"<pfx-file-password>"<br>}
        """
        if certificate_store is not None:
            pulumi.set(__self__, "certificate_store", certificate_store)
        if certificate_url is not None:
            pulumi.set(__self__, "certificate_url", certificate_url)

    @property
    @pulumi.getter(name="certificateStore")
    def certificate_store(self) -> Optional[str]:
        """
        For Windows VMs, specifies the certificate store on the Virtual Machine to which the certificate should be added. The specified certificate store is implicitly in the LocalMachine account. <br><br>For Linux VMs, the certificate file is placed under the /var/lib/waagent directory, with the file name &lt;UppercaseThumbprint&gt;.crt for the X509 certificate file and &lt;UppercaseThumbprint&gt;.prv for private key. Both of these files are .pem formatted.
        """
        return pulumi.get(self, "certificate_store")

    @property
    @pulumi.getter(name="certificateUrl")
    def certificate_url(self) -> Optional[str]:
        """
        This is the URL of a certificate that has been uploaded to Key Vault as a secret. For adding a secret to the Key Vault, see [Add a key or secret to the key vault](https://docs.microsoft.com/azure/key-vault/key-vault-get-started/#add). In this case, your certificate needs to be It is the Base64 encoding of the following JSON Object which is encoded in UTF-8: <br><br> {<br>  "data":"<Base64-encoded-certificate>",<br>  "dataType":"pfx",<br>  "password":"<pfx-file-password>"<br>}
        """
        return pulumi.get(self, "certificate_url")


@pulumi.output_type
class VaultSecretGroupResponse(dict):
    """
    Describes a set of certificates which are all in the same Key Vault.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceVault":
            suggest = "source_vault"
        elif key == "vaultCertificates":
            suggest = "vault_certificates"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VaultSecretGroupResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VaultSecretGroupResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VaultSecretGroupResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 source_vault: Optional['outputs.SubResourceResponse'] = None,
                 vault_certificates: Optional[Sequence['outputs.VaultCertificateResponse']] = None):
        """
        Describes a set of certificates which are all in the same Key Vault.
        :param 'SubResourceResponse' source_vault: The relative URL of the Key Vault containing all of the certificates in VaultCertificates.
        :param Sequence['VaultCertificateResponse'] vault_certificates: The list of key vault references in SourceVault which contain certificates.
        """
        if source_vault is not None:
            pulumi.set(__self__, "source_vault", source_vault)
        if vault_certificates is not None:
            pulumi.set(__self__, "vault_certificates", vault_certificates)

    @property
    @pulumi.getter(name="sourceVault")
    def source_vault(self) -> Optional['outputs.SubResourceResponse']:
        """
        The relative URL of the Key Vault containing all of the certificates in VaultCertificates.
        """
        return pulumi.get(self, "source_vault")

    @property
    @pulumi.getter(name="vaultCertificates")
    def vault_certificates(self) -> Optional[Sequence['outputs.VaultCertificateResponse']]:
        """
        The list of key vault references in SourceVault which contain certificates.
        """
        return pulumi.get(self, "vault_certificates")


@pulumi.output_type
class VirtualHardDiskResponse(dict):
    """
    Describes the uri of a disk.
    """
    def __init__(__self__, *,
                 uri: Optional[str] = None):
        """
        Describes the uri of a disk.
        :param str uri: Specifies the virtual hard disk's uri.
        """
        if uri is not None:
            pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter
    def uri(self) -> Optional[str]:
        """
        Specifies the virtual hard disk's uri.
        """
        return pulumi.get(self, "uri")


@pulumi.output_type
class VirtualMachineAgentInstanceViewResponse(dict):
    """
    The instance view of the VM Agent running on the virtual machine.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "extensionHandlers":
            suggest = "extension_handlers"
        elif key == "vmAgentVersion":
            suggest = "vm_agent_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualMachineAgentInstanceViewResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualMachineAgentInstanceViewResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualMachineAgentInstanceViewResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 extension_handlers: Optional[Sequence['outputs.VirtualMachineExtensionHandlerInstanceViewResponse']] = None,
                 statuses: Optional[Sequence['outputs.InstanceViewStatusResponse']] = None,
                 vm_agent_version: Optional[str] = None):
        """
        The instance view of the VM Agent running on the virtual machine.
        :param Sequence['VirtualMachineExtensionHandlerInstanceViewResponse'] extension_handlers: The virtual machine extension handler instance view.
        :param Sequence['InstanceViewStatusResponse'] statuses: The resource status information.
        :param str vm_agent_version: The VM Agent full version.
        """
        if extension_handlers is not None:
            pulumi.set(__self__, "extension_handlers", extension_handlers)
        if statuses is not None:
            pulumi.set(__self__, "statuses", statuses)
        if vm_agent_version is not None:
            pulumi.set(__self__, "vm_agent_version", vm_agent_version)

    @property
    @pulumi.getter(name="extensionHandlers")
    def extension_handlers(self) -> Optional[Sequence['outputs.VirtualMachineExtensionHandlerInstanceViewResponse']]:
        """
        The virtual machine extension handler instance view.
        """
        return pulumi.get(self, "extension_handlers")

    @property
    @pulumi.getter
    def statuses(self) -> Optional[Sequence['outputs.InstanceViewStatusResponse']]:
        """
        The resource status information.
        """
        return pulumi.get(self, "statuses")

    @property
    @pulumi.getter(name="vmAgentVersion")
    def vm_agent_version(self) -> Optional[str]:
        """
        The VM Agent full version.
        """
        return pulumi.get(self, "vm_agent_version")


@pulumi.output_type
class VirtualMachineExtensionHandlerInstanceViewResponse(dict):
    """
    The instance view of a virtual machine extension handler.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "typeHandlerVersion":
            suggest = "type_handler_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualMachineExtensionHandlerInstanceViewResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualMachineExtensionHandlerInstanceViewResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualMachineExtensionHandlerInstanceViewResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 status: Optional['outputs.InstanceViewStatusResponse'] = None,
                 type: Optional[str] = None,
                 type_handler_version: Optional[str] = None):
        """
        The instance view of a virtual machine extension handler.
        :param 'InstanceViewStatusResponse' status: The extension handler status.
        :param str type: Specifies the type of the extension; an example is "CustomScriptExtension".
        :param str type_handler_version: Specifies the version of the script handler.
        """
        if status is not None:
            pulumi.set(__self__, "status", status)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if type_handler_version is not None:
            pulumi.set(__self__, "type_handler_version", type_handler_version)

    @property
    @pulumi.getter
    def status(self) -> Optional['outputs.InstanceViewStatusResponse']:
        """
        The extension handler status.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        Specifies the type of the extension; an example is "CustomScriptExtension".
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="typeHandlerVersion")
    def type_handler_version(self) -> Optional[str]:
        """
        Specifies the version of the script handler.
        """
        return pulumi.get(self, "type_handler_version")


@pulumi.output_type
class VirtualMachineExtensionInstanceViewResponse(dict):
    """
    The instance view of a virtual machine extension.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "typeHandlerVersion":
            suggest = "type_handler_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualMachineExtensionInstanceViewResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualMachineExtensionInstanceViewResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualMachineExtensionInstanceViewResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: Optional[str] = None,
                 statuses: Optional[Sequence['outputs.InstanceViewStatusResponse']] = None,
                 substatuses: Optional[Sequence['outputs.InstanceViewStatusResponse']] = None,
                 type: Optional[str] = None,
                 type_handler_version: Optional[str] = None):
        """
        The instance view of a virtual machine extension.
        :param str name: The virtual machine extension name.
        :param Sequence['InstanceViewStatusResponse'] statuses: The resource status information.
        :param Sequence['InstanceViewStatusResponse'] substatuses: The resource status information.
        :param str type: Specifies the type of the extension; an example is "CustomScriptExtension".
        :param str type_handler_version: Specifies the version of the script handler.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if statuses is not None:
            pulumi.set(__self__, "statuses", statuses)
        if substatuses is not None:
            pulumi.set(__self__, "substatuses", substatuses)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if type_handler_version is not None:
            pulumi.set(__self__, "type_handler_version", type_handler_version)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The virtual machine extension name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def statuses(self) -> Optional[Sequence['outputs.InstanceViewStatusResponse']]:
        """
        The resource status information.
        """
        return pulumi.get(self, "statuses")

    @property
    @pulumi.getter
    def substatuses(self) -> Optional[Sequence['outputs.InstanceViewStatusResponse']]:
        """
        The resource status information.
        """
        return pulumi.get(self, "substatuses")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        Specifies the type of the extension; an example is "CustomScriptExtension".
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="typeHandlerVersion")
    def type_handler_version(self) -> Optional[str]:
        """
        Specifies the version of the script handler.
        """
        return pulumi.get(self, "type_handler_version")


@pulumi.output_type
class VirtualMachineExtensionResponse(dict):
    """
    Describes a Virtual Machine Extension.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "autoUpgradeMinorVersion":
            suggest = "auto_upgrade_minor_version"
        elif key == "enableAutomaticUpgrade":
            suggest = "enable_automatic_upgrade"
        elif key == "forceUpdateTag":
            suggest = "force_update_tag"
        elif key == "instanceView":
            suggest = "instance_view"
        elif key == "protectedSettings":
            suggest = "protected_settings"
        elif key == "typeHandlerVersion":
            suggest = "type_handler_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualMachineExtensionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualMachineExtensionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualMachineExtensionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: str,
                 location: str,
                 name: str,
                 provisioning_state: str,
                 type: str,
                 auto_upgrade_minor_version: Optional[bool] = None,
                 enable_automatic_upgrade: Optional[bool] = None,
                 force_update_tag: Optional[str] = None,
                 instance_view: Optional['outputs.VirtualMachineExtensionInstanceViewResponse'] = None,
                 protected_settings: Optional[Any] = None,
                 publisher: Optional[str] = None,
                 settings: Optional[Any] = None,
                 tags: Optional[Mapping[str, str]] = None,
                 type_handler_version: Optional[str] = None):
        """
        Describes a Virtual Machine Extension.
        :param str id: Resource Id
        :param str location: Resource location
        :param str name: Resource name
        :param str provisioning_state: The provisioning state, which only appears in the response.
        :param str type: Resource type
        :param bool auto_upgrade_minor_version: Indicates whether the extension should use a newer minor version if one is available at deployment time. Once deployed, however, the extension will not upgrade minor versions unless redeployed, even with this property set to true.
        :param bool enable_automatic_upgrade: Indicates whether the extension should be automatically upgraded by the platform if there is a newer version of the extension available.
        :param str force_update_tag: How the extension handler should be forced to update even if the extension configuration has not changed.
        :param 'VirtualMachineExtensionInstanceViewResponse' instance_view: The virtual machine extension instance view.
        :param Any protected_settings: The extension can contain either protectedSettings or protectedSettingsFromKeyVault or no protected settings at all.
        :param str publisher: The name of the extension handler publisher.
        :param Any settings: Json formatted public settings for the extension.
        :param Mapping[str, str] tags: Resource tags
        :param str type_handler_version: Specifies the version of the script handler.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        pulumi.set(__self__, "type", type)
        if auto_upgrade_minor_version is not None:
            pulumi.set(__self__, "auto_upgrade_minor_version", auto_upgrade_minor_version)
        if enable_automatic_upgrade is not None:
            pulumi.set(__self__, "enable_automatic_upgrade", enable_automatic_upgrade)
        if force_update_tag is not None:
            pulumi.set(__self__, "force_update_tag", force_update_tag)
        if instance_view is not None:
            pulumi.set(__self__, "instance_view", instance_view)
        if protected_settings is not None:
            pulumi.set(__self__, "protected_settings", protected_settings)
        if publisher is not None:
            pulumi.set(__self__, "publisher", publisher)
        if settings is not None:
            pulumi.set(__self__, "settings", settings)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if type_handler_version is not None:
            pulumi.set(__self__, "type_handler_version", type_handler_version)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Resource Id
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def location(self) -> str:
        """
        Resource location
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Resource name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state, which only appears in the response.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Resource type
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="autoUpgradeMinorVersion")
    def auto_upgrade_minor_version(self) -> Optional[bool]:
        """
        Indicates whether the extension should use a newer minor version if one is available at deployment time. Once deployed, however, the extension will not upgrade minor versions unless redeployed, even with this property set to true.
        """
        return pulumi.get(self, "auto_upgrade_minor_version")

    @property
    @pulumi.getter(name="enableAutomaticUpgrade")
    def enable_automatic_upgrade(self) -> Optional[bool]:
        """
        Indicates whether the extension should be automatically upgraded by the platform if there is a newer version of the extension available.
        """
        return pulumi.get(self, "enable_automatic_upgrade")

    @property
    @pulumi.getter(name="forceUpdateTag")
    def force_update_tag(self) -> Optional[str]:
        """
        How the extension handler should be forced to update even if the extension configuration has not changed.
        """
        return pulumi.get(self, "force_update_tag")

    @property
    @pulumi.getter(name="instanceView")
    def instance_view(self) -> Optional['outputs.VirtualMachineExtensionInstanceViewResponse']:
        """
        The virtual machine extension instance view.
        """
        return pulumi.get(self, "instance_view")

    @property
    @pulumi.getter(name="protectedSettings")
    def protected_settings(self) -> Optional[Any]:
        """
        The extension can contain either protectedSettings or protectedSettingsFromKeyVault or no protected settings at all.
        """
        return pulumi.get(self, "protected_settings")

    @property
    @pulumi.getter
    def publisher(self) -> Optional[str]:
        """
        The name of the extension handler publisher.
        """
        return pulumi.get(self, "publisher")

    @property
    @pulumi.getter
    def settings(self) -> Optional[Any]:
        """
        Json formatted public settings for the extension.
        """
        return pulumi.get(self, "settings")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        Resource tags
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="typeHandlerVersion")
    def type_handler_version(self) -> Optional[str]:
        """
        Specifies the version of the script handler.
        """
        return pulumi.get(self, "type_handler_version")


@pulumi.output_type
class VirtualMachineHealthStatusResponse(dict):
    """
    The health status of the VM.
    """
    def __init__(__self__, *,
                 status: 'outputs.InstanceViewStatusResponse'):
        """
        The health status of the VM.
        :param 'InstanceViewStatusResponse' status: The health status information for the VM.
        """
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def status(self) -> 'outputs.InstanceViewStatusResponse':
        """
        The health status information for the VM.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class VirtualMachineIdentityResponse(dict):
    """
    Identity for the virtual machine.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "principalId":
            suggest = "principal_id"
        elif key == "tenantId":
            suggest = "tenant_id"
        elif key == "userAssignedIdentities":
            suggest = "user_assigned_identities"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualMachineIdentityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualMachineIdentityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualMachineIdentityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 principal_id: str,
                 tenant_id: str,
                 type: Optional[str] = None,
                 user_assigned_identities: Optional[Mapping[str, 'outputs.VirtualMachineIdentityResponseUserAssignedIdentities']] = None):
        """
        Identity for the virtual machine.
        :param str principal_id: The principal id of virtual machine identity. This property will only be provided for a system assigned identity.
        :param str tenant_id: The tenant id associated with the virtual machine. This property will only be provided for a system assigned identity.
        :param str type: The type of identity used for the virtual machine. The type 'SystemAssigned, UserAssigned' includes both an implicitly created identity and a set of user assigned identities. The type 'None' will remove any identities from the virtual machine.
        :param Mapping[str, 'VirtualMachineIdentityResponseUserAssignedIdentities'] user_assigned_identities: The list of user identities associated with the Virtual Machine. The user identity dictionary key references will be ARM resource ids in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
        """
        pulumi.set(__self__, "principal_id", principal_id)
        pulumi.set(__self__, "tenant_id", tenant_id)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if user_assigned_identities is not None:
            pulumi.set(__self__, "user_assigned_identities", user_assigned_identities)

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> str:
        """
        The principal id of virtual machine identity. This property will only be provided for a system assigned identity.
        """
        return pulumi.get(self, "principal_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> str:
        """
        The tenant id associated with the virtual machine. This property will only be provided for a system assigned identity.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The type of identity used for the virtual machine. The type 'SystemAssigned, UserAssigned' includes both an implicitly created identity and a set of user assigned identities. The type 'None' will remove any identities from the virtual machine.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="userAssignedIdentities")
    def user_assigned_identities(self) -> Optional[Mapping[str, 'outputs.VirtualMachineIdentityResponseUserAssignedIdentities']]:
        """
        The list of user identities associated with the Virtual Machine. The user identity dictionary key references will be ARM resource ids in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
        """
        return pulumi.get(self, "user_assigned_identities")


@pulumi.output_type
class VirtualMachineIdentityResponseUserAssignedIdentities(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientId":
            suggest = "client_id"
        elif key == "principalId":
            suggest = "principal_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualMachineIdentityResponseUserAssignedIdentities. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualMachineIdentityResponseUserAssignedIdentities.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualMachineIdentityResponseUserAssignedIdentities.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_id: str,
                 principal_id: str):
        """
        :param str client_id: The client id of user assigned identity.
        :param str principal_id: The principal id of user assigned identity.
        """
        pulumi.set(__self__, "client_id", client_id)
        pulumi.set(__self__, "principal_id", principal_id)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> str:
        """
        The client id of user assigned identity.
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> str:
        """
        The principal id of user assigned identity.
        """
        return pulumi.get(self, "principal_id")


@pulumi.output_type
class VirtualMachineInstanceViewResponse(dict):
    """
    The instance view of a virtual machine.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "assignedHost":
            suggest = "assigned_host"
        elif key == "vmHealth":
            suggest = "vm_health"
        elif key == "bootDiagnostics":
            suggest = "boot_diagnostics"
        elif key == "computerName":
            suggest = "computer_name"
        elif key == "hyperVGeneration":
            suggest = "hyper_v_generation"
        elif key == "maintenanceRedeployStatus":
            suggest = "maintenance_redeploy_status"
        elif key == "osName":
            suggest = "os_name"
        elif key == "osVersion":
            suggest = "os_version"
        elif key == "patchStatus":
            suggest = "patch_status"
        elif key == "platformFaultDomain":
            suggest = "platform_fault_domain"
        elif key == "platformUpdateDomain":
            suggest = "platform_update_domain"
        elif key == "rdpThumbPrint":
            suggest = "rdp_thumb_print"
        elif key == "vmAgent":
            suggest = "vm_agent"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualMachineInstanceViewResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualMachineInstanceViewResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualMachineInstanceViewResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 assigned_host: str,
                 vm_health: 'outputs.VirtualMachineHealthStatusResponse',
                 boot_diagnostics: Optional['outputs.BootDiagnosticsInstanceViewResponse'] = None,
                 computer_name: Optional[str] = None,
                 disks: Optional[Sequence['outputs.DiskInstanceViewResponse']] = None,
                 extensions: Optional[Sequence['outputs.VirtualMachineExtensionInstanceViewResponse']] = None,
                 hyper_v_generation: Optional[str] = None,
                 maintenance_redeploy_status: Optional['outputs.MaintenanceRedeployStatusResponse'] = None,
                 os_name: Optional[str] = None,
                 os_version: Optional[str] = None,
                 patch_status: Optional['outputs.VirtualMachinePatchStatusResponse'] = None,
                 platform_fault_domain: Optional[int] = None,
                 platform_update_domain: Optional[int] = None,
                 rdp_thumb_print: Optional[str] = None,
                 statuses: Optional[Sequence['outputs.InstanceViewStatusResponse']] = None,
                 vm_agent: Optional['outputs.VirtualMachineAgentInstanceViewResponse'] = None):
        """
        The instance view of a virtual machine.
        :param str assigned_host: Resource id of the dedicated host, on which the virtual machine is allocated through automatic placement, when the virtual machine is associated with a dedicated host group that has automatic placement enabled. <br><br>Minimum api-version: 2020-06-01.
        :param 'VirtualMachineHealthStatusResponse' vm_health: The health status for the VM.
        :param 'BootDiagnosticsInstanceViewResponse' boot_diagnostics: Boot Diagnostics is a debugging feature which allows you to view Console Output and Screenshot to diagnose VM status. <br><br> You can easily view the output of your console log. <br><br> Azure also enables you to see a screenshot of the VM from the hypervisor.
        :param str computer_name: The computer name assigned to the virtual machine.
        :param Sequence['DiskInstanceViewResponse'] disks: The virtual machine disk information.
        :param Sequence['VirtualMachineExtensionInstanceViewResponse'] extensions: The extensions information.
        :param str hyper_v_generation: Specifies the HyperVGeneration Type associated with a resource
        :param 'MaintenanceRedeployStatusResponse' maintenance_redeploy_status: The Maintenance Operation status on the virtual machine.
        :param str os_name: The Operating System running on the virtual machine.
        :param str os_version: The version of Operating System running on the virtual machine.
        :param 'VirtualMachinePatchStatusResponse' patch_status: The status of virtual machine patch operations.
        :param int platform_fault_domain: Specifies the fault domain of the virtual machine.
        :param int platform_update_domain: Specifies the update domain of the virtual machine.
        :param str rdp_thumb_print: The Remote desktop certificate thumbprint.
        :param Sequence['InstanceViewStatusResponse'] statuses: The resource status information.
        :param 'VirtualMachineAgentInstanceViewResponse' vm_agent: The VM Agent running on the virtual machine.
        """
        pulumi.set(__self__, "assigned_host", assigned_host)
        pulumi.set(__self__, "vm_health", vm_health)
        if boot_diagnostics is not None:
            pulumi.set(__self__, "boot_diagnostics", boot_diagnostics)
        if computer_name is not None:
            pulumi.set(__self__, "computer_name", computer_name)
        if disks is not None:
            pulumi.set(__self__, "disks", disks)
        if extensions is not None:
            pulumi.set(__self__, "extensions", extensions)
        if hyper_v_generation is not None:
            pulumi.set(__self__, "hyper_v_generation", hyper_v_generation)
        if maintenance_redeploy_status is not None:
            pulumi.set(__self__, "maintenance_redeploy_status", maintenance_redeploy_status)
        if os_name is not None:
            pulumi.set(__self__, "os_name", os_name)
        if os_version is not None:
            pulumi.set(__self__, "os_version", os_version)
        if patch_status is not None:
            pulumi.set(__self__, "patch_status", patch_status)
        if platform_fault_domain is not None:
            pulumi.set(__self__, "platform_fault_domain", platform_fault_domain)
        if platform_update_domain is not None:
            pulumi.set(__self__, "platform_update_domain", platform_update_domain)
        if rdp_thumb_print is not None:
            pulumi.set(__self__, "rdp_thumb_print", rdp_thumb_print)
        if statuses is not None:
            pulumi.set(__self__, "statuses", statuses)
        if vm_agent is not None:
            pulumi.set(__self__, "vm_agent", vm_agent)

    @property
    @pulumi.getter(name="assignedHost")
    def assigned_host(self) -> str:
        """
        Resource id of the dedicated host, on which the virtual machine is allocated through automatic placement, when the virtual machine is associated with a dedicated host group that has automatic placement enabled. <br><br>Minimum api-version: 2020-06-01.
        """
        return pulumi.get(self, "assigned_host")

    @property
    @pulumi.getter(name="vmHealth")
    def vm_health(self) -> 'outputs.VirtualMachineHealthStatusResponse':
        """
        The health status for the VM.
        """
        return pulumi.get(self, "vm_health")

    @property
    @pulumi.getter(name="bootDiagnostics")
    def boot_diagnostics(self) -> Optional['outputs.BootDiagnosticsInstanceViewResponse']:
        """
        Boot Diagnostics is a debugging feature which allows you to view Console Output and Screenshot to diagnose VM status. <br><br> You can easily view the output of your console log. <br><br> Azure also enables you to see a screenshot of the VM from the hypervisor.
        """
        return pulumi.get(self, "boot_diagnostics")

    @property
    @pulumi.getter(name="computerName")
    def computer_name(self) -> Optional[str]:
        """
        The computer name assigned to the virtual machine.
        """
        return pulumi.get(self, "computer_name")

    @property
    @pulumi.getter
    def disks(self) -> Optional[Sequence['outputs.DiskInstanceViewResponse']]:
        """
        The virtual machine disk information.
        """
        return pulumi.get(self, "disks")

    @property
    @pulumi.getter
    def extensions(self) -> Optional[Sequence['outputs.VirtualMachineExtensionInstanceViewResponse']]:
        """
        The extensions information.
        """
        return pulumi.get(self, "extensions")

    @property
    @pulumi.getter(name="hyperVGeneration")
    def hyper_v_generation(self) -> Optional[str]:
        """
        Specifies the HyperVGeneration Type associated with a resource
        """
        return pulumi.get(self, "hyper_v_generation")

    @property
    @pulumi.getter(name="maintenanceRedeployStatus")
    def maintenance_redeploy_status(self) -> Optional['outputs.MaintenanceRedeployStatusResponse']:
        """
        The Maintenance Operation status on the virtual machine.
        """
        return pulumi.get(self, "maintenance_redeploy_status")

    @property
    @pulumi.getter(name="osName")
    def os_name(self) -> Optional[str]:
        """
        The Operating System running on the virtual machine.
        """
        return pulumi.get(self, "os_name")

    @property
    @pulumi.getter(name="osVersion")
    def os_version(self) -> Optional[str]:
        """
        The version of Operating System running on the virtual machine.
        """
        return pulumi.get(self, "os_version")

    @property
    @pulumi.getter(name="patchStatus")
    def patch_status(self) -> Optional['outputs.VirtualMachinePatchStatusResponse']:
        """
        The status of virtual machine patch operations.
        """
        return pulumi.get(self, "patch_status")

    @property
    @pulumi.getter(name="platformFaultDomain")
    def platform_fault_domain(self) -> Optional[int]:
        """
        Specifies the fault domain of the virtual machine.
        """
        return pulumi.get(self, "platform_fault_domain")

    @property
    @pulumi.getter(name="platformUpdateDomain")
    def platform_update_domain(self) -> Optional[int]:
        """
        Specifies the update domain of the virtual machine.
        """
        return pulumi.get(self, "platform_update_domain")

    @property
    @pulumi.getter(name="rdpThumbPrint")
    def rdp_thumb_print(self) -> Optional[str]:
        """
        The Remote desktop certificate thumbprint.
        """
        return pulumi.get(self, "rdp_thumb_print")

    @property
    @pulumi.getter
    def statuses(self) -> Optional[Sequence['outputs.InstanceViewStatusResponse']]:
        """
        The resource status information.
        """
        return pulumi.get(self, "statuses")

    @property
    @pulumi.getter(name="vmAgent")
    def vm_agent(self) -> Optional['outputs.VirtualMachineAgentInstanceViewResponse']:
        """
        The VM Agent running on the virtual machine.
        """
        return pulumi.get(self, "vm_agent")


@pulumi.output_type
class VirtualMachinePatchStatusResponse(dict):
    """
    The status of virtual machine patch operations.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "availablePatchSummary":
            suggest = "available_patch_summary"
        elif key == "lastPatchInstallationSummary":
            suggest = "last_patch_installation_summary"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualMachinePatchStatusResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualMachinePatchStatusResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualMachinePatchStatusResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 available_patch_summary: Optional['outputs.AvailablePatchSummaryResponse'] = None,
                 last_patch_installation_summary: Optional['outputs.LastPatchInstallationSummaryResponse'] = None):
        """
        The status of virtual machine patch operations.
        :param 'AvailablePatchSummaryResponse' available_patch_summary: The available patch summary of the latest assessment operation for the virtual machine.
        :param 'LastPatchInstallationSummaryResponse' last_patch_installation_summary: The installation summary of the latest installation operation for the virtual machine.
        """
        if available_patch_summary is not None:
            pulumi.set(__self__, "available_patch_summary", available_patch_summary)
        if last_patch_installation_summary is not None:
            pulumi.set(__self__, "last_patch_installation_summary", last_patch_installation_summary)

    @property
    @pulumi.getter(name="availablePatchSummary")
    def available_patch_summary(self) -> Optional['outputs.AvailablePatchSummaryResponse']:
        """
        The available patch summary of the latest assessment operation for the virtual machine.
        """
        return pulumi.get(self, "available_patch_summary")

    @property
    @pulumi.getter(name="lastPatchInstallationSummary")
    def last_patch_installation_summary(self) -> Optional['outputs.LastPatchInstallationSummaryResponse']:
        """
        The installation summary of the latest installation operation for the virtual machine.
        """
        return pulumi.get(self, "last_patch_installation_summary")


@pulumi.output_type
class VirtualMachineRunCommandInstanceViewResponse(dict):
    """
    The instance view of a virtual machine run command.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endTime":
            suggest = "end_time"
        elif key == "executionMessage":
            suggest = "execution_message"
        elif key == "executionState":
            suggest = "execution_state"
        elif key == "exitCode":
            suggest = "exit_code"
        elif key == "startTime":
            suggest = "start_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualMachineRunCommandInstanceViewResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualMachineRunCommandInstanceViewResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualMachineRunCommandInstanceViewResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 end_time: Optional[str] = None,
                 error: Optional[str] = None,
                 execution_message: Optional[str] = None,
                 execution_state: Optional[str] = None,
                 exit_code: Optional[int] = None,
                 output: Optional[str] = None,
                 start_time: Optional[str] = None,
                 statuses: Optional[Sequence['outputs.InstanceViewStatusResponse']] = None):
        """
        The instance view of a virtual machine run command.
        :param str end_time: Script end time.
        :param str error: Script error stream.
        :param str execution_message: Communicate script configuration errors or execution messages.
        :param str execution_state: Script execution status.
        :param int exit_code: Exit code returned from script execution.
        :param str output: Script output stream.
        :param str start_time: Script start time.
        :param Sequence['InstanceViewStatusResponse'] statuses: The resource status information.
        """
        if end_time is not None:
            pulumi.set(__self__, "end_time", end_time)
        if error is not None:
            pulumi.set(__self__, "error", error)
        if execution_message is not None:
            pulumi.set(__self__, "execution_message", execution_message)
        if execution_state is not None:
            pulumi.set(__self__, "execution_state", execution_state)
        if exit_code is not None:
            pulumi.set(__self__, "exit_code", exit_code)
        if output is not None:
            pulumi.set(__self__, "output", output)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)
        if statuses is not None:
            pulumi.set(__self__, "statuses", statuses)

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> Optional[str]:
        """
        Script end time.
        """
        return pulumi.get(self, "end_time")

    @property
    @pulumi.getter
    def error(self) -> Optional[str]:
        """
        Script error stream.
        """
        return pulumi.get(self, "error")

    @property
    @pulumi.getter(name="executionMessage")
    def execution_message(self) -> Optional[str]:
        """
        Communicate script configuration errors or execution messages.
        """
        return pulumi.get(self, "execution_message")

    @property
    @pulumi.getter(name="executionState")
    def execution_state(self) -> Optional[str]:
        """
        Script execution status.
        """
        return pulumi.get(self, "execution_state")

    @property
    @pulumi.getter(name="exitCode")
    def exit_code(self) -> Optional[int]:
        """
        Exit code returned from script execution.
        """
        return pulumi.get(self, "exit_code")

    @property
    @pulumi.getter
    def output(self) -> Optional[str]:
        """
        Script output stream.
        """
        return pulumi.get(self, "output")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[str]:
        """
        Script start time.
        """
        return pulumi.get(self, "start_time")

    @property
    @pulumi.getter
    def statuses(self) -> Optional[Sequence['outputs.InstanceViewStatusResponse']]:
        """
        The resource status information.
        """
        return pulumi.get(self, "statuses")


@pulumi.output_type
class VirtualMachineRunCommandScriptSourceResponse(dict):
    """
    Describes the script sources for run command.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "commandId":
            suggest = "command_id"
        elif key == "scriptUri":
            suggest = "script_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualMachineRunCommandScriptSourceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualMachineRunCommandScriptSourceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualMachineRunCommandScriptSourceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 command_id: Optional[str] = None,
                 script: Optional[str] = None,
                 script_uri: Optional[str] = None):
        """
        Describes the script sources for run command.
        :param str command_id: Specifies a commandId of predefined built-in script.
        :param str script: Specifies the script content to be executed on the VM.
        :param str script_uri: Specifies the script download location.
        """
        if command_id is not None:
            pulumi.set(__self__, "command_id", command_id)
        if script is not None:
            pulumi.set(__self__, "script", script)
        if script_uri is not None:
            pulumi.set(__self__, "script_uri", script_uri)

    @property
    @pulumi.getter(name="commandId")
    def command_id(self) -> Optional[str]:
        """
        Specifies a commandId of predefined built-in script.
        """
        return pulumi.get(self, "command_id")

    @property
    @pulumi.getter
    def script(self) -> Optional[str]:
        """
        Specifies the script content to be executed on the VM.
        """
        return pulumi.get(self, "script")

    @property
    @pulumi.getter(name="scriptUri")
    def script_uri(self) -> Optional[str]:
        """
        Specifies the script download location.
        """
        return pulumi.get(self, "script_uri")


@pulumi.output_type
class VirtualMachineScaleSetDataDiskResponse(dict):
    """
    Describes a virtual machine scale set data disk.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createOption":
            suggest = "create_option"
        elif key == "diskIOPSReadWrite":
            suggest = "disk_iops_read_write"
        elif key == "diskMBpsReadWrite":
            suggest = "disk_m_bps_read_write"
        elif key == "diskSizeGB":
            suggest = "disk_size_gb"
        elif key == "managedDisk":
            suggest = "managed_disk"
        elif key == "writeAcceleratorEnabled":
            suggest = "write_accelerator_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualMachineScaleSetDataDiskResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualMachineScaleSetDataDiskResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualMachineScaleSetDataDiskResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 create_option: str,
                 lun: int,
                 caching: Optional[str] = None,
                 disk_iops_read_write: Optional[float] = None,
                 disk_m_bps_read_write: Optional[float] = None,
                 disk_size_gb: Optional[int] = None,
                 managed_disk: Optional['outputs.VirtualMachineScaleSetManagedDiskParametersResponse'] = None,
                 name: Optional[str] = None,
                 write_accelerator_enabled: Optional[bool] = None):
        """
        Describes a virtual machine scale set data disk.
        :param str create_option: The create option.
        :param int lun: Specifies the logical unit number of the data disk. This value is used to identify data disks within the VM and therefore must be unique for each data disk attached to a VM.
        :param str caching: Specifies the caching requirements. <br><br> Possible values are: <br><br> **None** <br><br> **ReadOnly** <br><br> **ReadWrite** <br><br> Default: **None for Standard storage. ReadOnly for Premium storage**
        :param float disk_iops_read_write: Specifies the Read-Write IOPS for the managed disk. Should be used only when StorageAccountType is UltraSSD_LRS. If not specified, a default value would be assigned based on diskSizeGB.
        :param float disk_m_bps_read_write: Specifies the bandwidth in MB per second for the managed disk. Should be used only when StorageAccountType is UltraSSD_LRS. If not specified, a default value would be assigned based on diskSizeGB.
        :param int disk_size_gb: Specifies the size of an empty data disk in gigabytes. This element can be used to overwrite the size of the disk in a virtual machine image. <br><br> This value cannot be larger than 1023 GB
        :param 'VirtualMachineScaleSetManagedDiskParametersResponse' managed_disk: The managed disk parameters.
        :param str name: The disk name.
        :param bool write_accelerator_enabled: Specifies whether writeAccelerator should be enabled or disabled on the disk.
        """
        pulumi.set(__self__, "create_option", create_option)
        pulumi.set(__self__, "lun", lun)
        if caching is not None:
            pulumi.set(__self__, "caching", caching)
        if disk_iops_read_write is not None:
            pulumi.set(__self__, "disk_iops_read_write", disk_iops_read_write)
        if disk_m_bps_read_write is not None:
            pulumi.set(__self__, "disk_m_bps_read_write", disk_m_bps_read_write)
        if disk_size_gb is not None:
            pulumi.set(__self__, "disk_size_gb", disk_size_gb)
        if managed_disk is not None:
            pulumi.set(__self__, "managed_disk", managed_disk)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if write_accelerator_enabled is not None:
            pulumi.set(__self__, "write_accelerator_enabled", write_accelerator_enabled)

    @property
    @pulumi.getter(name="createOption")
    def create_option(self) -> str:
        """
        The create option.
        """
        return pulumi.get(self, "create_option")

    @property
    @pulumi.getter
    def lun(self) -> int:
        """
        Specifies the logical unit number of the data disk. This value is used to identify data disks within the VM and therefore must be unique for each data disk attached to a VM.
        """
        return pulumi.get(self, "lun")

    @property
    @pulumi.getter
    def caching(self) -> Optional[str]:
        """
        Specifies the caching requirements. <br><br> Possible values are: <br><br> **None** <br><br> **ReadOnly** <br><br> **ReadWrite** <br><br> Default: **None for Standard storage. ReadOnly for Premium storage**
        """
        return pulumi.get(self, "caching")

    @property
    @pulumi.getter(name="diskIOPSReadWrite")
    def disk_iops_read_write(self) -> Optional[float]:
        """
        Specifies the Read-Write IOPS for the managed disk. Should be used only when StorageAccountType is UltraSSD_LRS. If not specified, a default value would be assigned based on diskSizeGB.
        """
        return pulumi.get(self, "disk_iops_read_write")

    @property
    @pulumi.getter(name="diskMBpsReadWrite")
    def disk_m_bps_read_write(self) -> Optional[float]:
        """
        Specifies the bandwidth in MB per second for the managed disk. Should be used only when StorageAccountType is UltraSSD_LRS. If not specified, a default value would be assigned based on diskSizeGB.
        """
        return pulumi.get(self, "disk_m_bps_read_write")

    @property
    @pulumi.getter(name="diskSizeGB")
    def disk_size_gb(self) -> Optional[int]:
        """
        Specifies the size of an empty data disk in gigabytes. This element can be used to overwrite the size of the disk in a virtual machine image. <br><br> This value cannot be larger than 1023 GB
        """
        return pulumi.get(self, "disk_size_gb")

    @property
    @pulumi.getter(name="managedDisk")
    def managed_disk(self) -> Optional['outputs.VirtualMachineScaleSetManagedDiskParametersResponse']:
        """
        The managed disk parameters.
        """
        return pulumi.get(self, "managed_disk")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The disk name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="writeAcceleratorEnabled")
    def write_accelerator_enabled(self) -> Optional[bool]:
        """
        Specifies whether writeAccelerator should be enabled or disabled on the disk.
        """
        return pulumi.get(self, "write_accelerator_enabled")


@pulumi.output_type
class VirtualMachineScaleSetExtensionProfileResponse(dict):
    """
    Describes a virtual machine scale set extension profile.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "extensionsTimeBudget":
            suggest = "extensions_time_budget"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualMachineScaleSetExtensionProfileResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualMachineScaleSetExtensionProfileResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualMachineScaleSetExtensionProfileResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 extensions: Optional[Sequence['outputs.VirtualMachineScaleSetExtensionResponse']] = None,
                 extensions_time_budget: Optional[str] = None):
        """
        Describes a virtual machine scale set extension profile.
        :param Sequence['VirtualMachineScaleSetExtensionResponse'] extensions: The virtual machine scale set child extension resources.
        :param str extensions_time_budget: Specifies the time alloted for all extensions to start. The time duration should be between 15 minutes and 120 minutes (inclusive) and should be specified in ISO 8601 format. The default value is 90 minutes (PT1H30M). <br><br> Minimum api-version: 2020-06-01
        """
        if extensions is not None:
            pulumi.set(__self__, "extensions", extensions)
        if extensions_time_budget is not None:
            pulumi.set(__self__, "extensions_time_budget", extensions_time_budget)

    @property
    @pulumi.getter
    def extensions(self) -> Optional[Sequence['outputs.VirtualMachineScaleSetExtensionResponse']]:
        """
        The virtual machine scale set child extension resources.
        """
        return pulumi.get(self, "extensions")

    @property
    @pulumi.getter(name="extensionsTimeBudget")
    def extensions_time_budget(self) -> Optional[str]:
        """
        Specifies the time alloted for all extensions to start. The time duration should be between 15 minutes and 120 minutes (inclusive) and should be specified in ISO 8601 format. The default value is 90 minutes (PT1H30M). <br><br> Minimum api-version: 2020-06-01
        """
        return pulumi.get(self, "extensions_time_budget")


@pulumi.output_type
class VirtualMachineScaleSetExtensionResponse(dict):
    """
    Describes a Virtual Machine Scale Set Extension.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "autoUpgradeMinorVersion":
            suggest = "auto_upgrade_minor_version"
        elif key == "enableAutomaticUpgrade":
            suggest = "enable_automatic_upgrade"
        elif key == "forceUpdateTag":
            suggest = "force_update_tag"
        elif key == "protectedSettings":
            suggest = "protected_settings"
        elif key == "provisionAfterExtensions":
            suggest = "provision_after_extensions"
        elif key == "typeHandlerVersion":
            suggest = "type_handler_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualMachineScaleSetExtensionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualMachineScaleSetExtensionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualMachineScaleSetExtensionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: str,
                 provisioning_state: str,
                 type: str,
                 auto_upgrade_minor_version: Optional[bool] = None,
                 enable_automatic_upgrade: Optional[bool] = None,
                 force_update_tag: Optional[str] = None,
                 name: Optional[str] = None,
                 protected_settings: Optional[Any] = None,
                 provision_after_extensions: Optional[Sequence[str]] = None,
                 publisher: Optional[str] = None,
                 settings: Optional[Any] = None,
                 type_handler_version: Optional[str] = None):
        """
        Describes a Virtual Machine Scale Set Extension.
        :param str id: Resource Id
        :param str provisioning_state: The provisioning state, which only appears in the response.
        :param str type: Resource type
        :param bool auto_upgrade_minor_version: Indicates whether the extension should use a newer minor version if one is available at deployment time. Once deployed, however, the extension will not upgrade minor versions unless redeployed, even with this property set to true.
        :param bool enable_automatic_upgrade: Indicates whether the extension should be automatically upgraded by the platform if there is a newer version of the extension available.
        :param str force_update_tag: If a value is provided and is different from the previous value, the extension handler will be forced to update even if the extension configuration has not changed.
        :param str name: The name of the extension.
        :param Any protected_settings: The extension can contain either protectedSettings or protectedSettingsFromKeyVault or no protected settings at all.
        :param Sequence[str] provision_after_extensions: Collection of extension names after which this extension needs to be provisioned.
        :param str publisher: The name of the extension handler publisher.
        :param Any settings: Json formatted public settings for the extension.
        :param str type_handler_version: Specifies the version of the script handler.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        pulumi.set(__self__, "type", type)
        if auto_upgrade_minor_version is not None:
            pulumi.set(__self__, "auto_upgrade_minor_version", auto_upgrade_minor_version)
        if enable_automatic_upgrade is not None:
            pulumi.set(__self__, "enable_automatic_upgrade", enable_automatic_upgrade)
        if force_update_tag is not None:
            pulumi.set(__self__, "force_update_tag", force_update_tag)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if protected_settings is not None:
            pulumi.set(__self__, "protected_settings", protected_settings)
        if provision_after_extensions is not None:
            pulumi.set(__self__, "provision_after_extensions", provision_after_extensions)
        if publisher is not None:
            pulumi.set(__self__, "publisher", publisher)
        if settings is not None:
            pulumi.set(__self__, "settings", settings)
        if type_handler_version is not None:
            pulumi.set(__self__, "type_handler_version", type_handler_version)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Resource Id
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state, which only appears in the response.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Resource type
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="autoUpgradeMinorVersion")
    def auto_upgrade_minor_version(self) -> Optional[bool]:
        """
        Indicates whether the extension should use a newer minor version if one is available at deployment time. Once deployed, however, the extension will not upgrade minor versions unless redeployed, even with this property set to true.
        """
        return pulumi.get(self, "auto_upgrade_minor_version")

    @property
    @pulumi.getter(name="enableAutomaticUpgrade")
    def enable_automatic_upgrade(self) -> Optional[bool]:
        """
        Indicates whether the extension should be automatically upgraded by the platform if there is a newer version of the extension available.
        """
        return pulumi.get(self, "enable_automatic_upgrade")

    @property
    @pulumi.getter(name="forceUpdateTag")
    def force_update_tag(self) -> Optional[str]:
        """
        If a value is provided and is different from the previous value, the extension handler will be forced to update even if the extension configuration has not changed.
        """
        return pulumi.get(self, "force_update_tag")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the extension.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="protectedSettings")
    def protected_settings(self) -> Optional[Any]:
        """
        The extension can contain either protectedSettings or protectedSettingsFromKeyVault or no protected settings at all.
        """
        return pulumi.get(self, "protected_settings")

    @property
    @pulumi.getter(name="provisionAfterExtensions")
    def provision_after_extensions(self) -> Optional[Sequence[str]]:
        """
        Collection of extension names after which this extension needs to be provisioned.
        """
        return pulumi.get(self, "provision_after_extensions")

    @property
    @pulumi.getter
    def publisher(self) -> Optional[str]:
        """
        The name of the extension handler publisher.
        """
        return pulumi.get(self, "publisher")

    @property
    @pulumi.getter
    def settings(self) -> Optional[Any]:
        """
        Json formatted public settings for the extension.
        """
        return pulumi.get(self, "settings")

    @property
    @pulumi.getter(name="typeHandlerVersion")
    def type_handler_version(self) -> Optional[str]:
        """
        Specifies the version of the script handler.
        """
        return pulumi.get(self, "type_handler_version")


@pulumi.output_type
class VirtualMachineScaleSetIPConfigurationResponse(dict):
    """
    Describes a virtual machine scale set network profile's IP configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "applicationGatewayBackendAddressPools":
            suggest = "application_gateway_backend_address_pools"
        elif key == "applicationSecurityGroups":
            suggest = "application_security_groups"
        elif key == "loadBalancerBackendAddressPools":
            suggest = "load_balancer_backend_address_pools"
        elif key == "loadBalancerInboundNatPools":
            suggest = "load_balancer_inbound_nat_pools"
        elif key == "privateIPAddressVersion":
            suggest = "private_ip_address_version"
        elif key == "publicIPAddressConfiguration":
            suggest = "public_ip_address_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualMachineScaleSetIPConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualMachineScaleSetIPConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualMachineScaleSetIPConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 application_gateway_backend_address_pools: Optional[Sequence['outputs.SubResourceResponse']] = None,
                 application_security_groups: Optional[Sequence['outputs.SubResourceResponse']] = None,
                 id: Optional[str] = None,
                 load_balancer_backend_address_pools: Optional[Sequence['outputs.SubResourceResponse']] = None,
                 load_balancer_inbound_nat_pools: Optional[Sequence['outputs.SubResourceResponse']] = None,
                 primary: Optional[bool] = None,
                 private_ip_address_version: Optional[str] = None,
                 public_ip_address_configuration: Optional['outputs.VirtualMachineScaleSetPublicIPAddressConfigurationResponse'] = None,
                 subnet: Optional['outputs.ApiEntityReferenceResponse'] = None):
        """
        Describes a virtual machine scale set network profile's IP configuration.
        :param str name: The IP configuration name.
        :param Sequence['SubResourceResponse'] application_gateway_backend_address_pools: Specifies an array of references to backend address pools of application gateways. A scale set can reference backend address pools of multiple application gateways. Multiple scale sets cannot use the same application gateway.
        :param Sequence['SubResourceResponse'] application_security_groups: Specifies an array of references to application security group.
        :param str id: Resource Id
        :param Sequence['SubResourceResponse'] load_balancer_backend_address_pools: Specifies an array of references to backend address pools of load balancers. A scale set can reference backend address pools of one public and one internal load balancer. Multiple scale sets cannot use the same basic sku load balancer.
        :param Sequence['SubResourceResponse'] load_balancer_inbound_nat_pools: Specifies an array of references to inbound Nat pools of the load balancers. A scale set can reference inbound nat pools of one public and one internal load balancer. Multiple scale sets cannot use the same basic sku load balancer.
        :param bool primary: Specifies the primary network interface in case the virtual machine has more than 1 network interface.
        :param str private_ip_address_version: Available from Api-Version 2017-03-30 onwards, it represents whether the specific ipconfiguration is IPv4 or IPv6. Default is taken as IPv4.  Possible values are: 'IPv4' and 'IPv6'.
        :param 'VirtualMachineScaleSetPublicIPAddressConfigurationResponse' public_ip_address_configuration: The publicIPAddressConfiguration.
        :param 'ApiEntityReferenceResponse' subnet: Specifies the identifier of the subnet.
        """
        pulumi.set(__self__, "name", name)
        if application_gateway_backend_address_pools is not None:
            pulumi.set(__self__, "application_gateway_backend_address_pools", application_gateway_backend_address_pools)
        if application_security_groups is not None:
            pulumi.set(__self__, "application_security_groups", application_security_groups)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if load_balancer_backend_address_pools is not None:
            pulumi.set(__self__, "load_balancer_backend_address_pools", load_balancer_backend_address_pools)
        if load_balancer_inbound_nat_pools is not None:
            pulumi.set(__self__, "load_balancer_inbound_nat_pools", load_balancer_inbound_nat_pools)
        if primary is not None:
            pulumi.set(__self__, "primary", primary)
        if private_ip_address_version is not None:
            pulumi.set(__self__, "private_ip_address_version", private_ip_address_version)
        if public_ip_address_configuration is not None:
            pulumi.set(__self__, "public_ip_address_configuration", public_ip_address_configuration)
        if subnet is not None:
            pulumi.set(__self__, "subnet", subnet)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The IP configuration name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="applicationGatewayBackendAddressPools")
    def application_gateway_backend_address_pools(self) -> Optional[Sequence['outputs.SubResourceResponse']]:
        """
        Specifies an array of references to backend address pools of application gateways. A scale set can reference backend address pools of multiple application gateways. Multiple scale sets cannot use the same application gateway.
        """
        return pulumi.get(self, "application_gateway_backend_address_pools")

    @property
    @pulumi.getter(name="applicationSecurityGroups")
    def application_security_groups(self) -> Optional[Sequence['outputs.SubResourceResponse']]:
        """
        Specifies an array of references to application security group.
        """
        return pulumi.get(self, "application_security_groups")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource Id
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="loadBalancerBackendAddressPools")
    def load_balancer_backend_address_pools(self) -> Optional[Sequence['outputs.SubResourceResponse']]:
        """
        Specifies an array of references to backend address pools of load balancers. A scale set can reference backend address pools of one public and one internal load balancer. Multiple scale sets cannot use the same basic sku load balancer.
        """
        return pulumi.get(self, "load_balancer_backend_address_pools")

    @property
    @pulumi.getter(name="loadBalancerInboundNatPools")
    def load_balancer_inbound_nat_pools(self) -> Optional[Sequence['outputs.SubResourceResponse']]:
        """
        Specifies an array of references to inbound Nat pools of the load balancers. A scale set can reference inbound nat pools of one public and one internal load balancer. Multiple scale sets cannot use the same basic sku load balancer.
        """
        return pulumi.get(self, "load_balancer_inbound_nat_pools")

    @property
    @pulumi.getter
    def primary(self) -> Optional[bool]:
        """
        Specifies the primary network interface in case the virtual machine has more than 1 network interface.
        """
        return pulumi.get(self, "primary")

    @property
    @pulumi.getter(name="privateIPAddressVersion")
    def private_ip_address_version(self) -> Optional[str]:
        """
        Available from Api-Version 2017-03-30 onwards, it represents whether the specific ipconfiguration is IPv4 or IPv6. Default is taken as IPv4.  Possible values are: 'IPv4' and 'IPv6'.
        """
        return pulumi.get(self, "private_ip_address_version")

    @property
    @pulumi.getter(name="publicIPAddressConfiguration")
    def public_ip_address_configuration(self) -> Optional['outputs.VirtualMachineScaleSetPublicIPAddressConfigurationResponse']:
        """
        The publicIPAddressConfiguration.
        """
        return pulumi.get(self, "public_ip_address_configuration")

    @property
    @pulumi.getter
    def subnet(self) -> Optional['outputs.ApiEntityReferenceResponse']:
        """
        Specifies the identifier of the subnet.
        """
        return pulumi.get(self, "subnet")


@pulumi.output_type
class VirtualMachineScaleSetIdentityResponse(dict):
    """
    Identity for the virtual machine scale set.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "principalId":
            suggest = "principal_id"
        elif key == "tenantId":
            suggest = "tenant_id"
        elif key == "userAssignedIdentities":
            suggest = "user_assigned_identities"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualMachineScaleSetIdentityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualMachineScaleSetIdentityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualMachineScaleSetIdentityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 principal_id: str,
                 tenant_id: str,
                 type: Optional[str] = None,
                 user_assigned_identities: Optional[Mapping[str, 'outputs.VirtualMachineScaleSetIdentityResponseUserAssignedIdentities']] = None):
        """
        Identity for the virtual machine scale set.
        :param str principal_id: The principal id of virtual machine scale set identity. This property will only be provided for a system assigned identity.
        :param str tenant_id: The tenant id associated with the virtual machine scale set. This property will only be provided for a system assigned identity.
        :param str type: The type of identity used for the virtual machine scale set. The type 'SystemAssigned, UserAssigned' includes both an implicitly created identity and a set of user assigned identities. The type 'None' will remove any identities from the virtual machine scale set.
        :param Mapping[str, 'VirtualMachineScaleSetIdentityResponseUserAssignedIdentities'] user_assigned_identities: The list of user identities associated with the virtual machine scale set. The user identity dictionary key references will be ARM resource ids in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
        """
        pulumi.set(__self__, "principal_id", principal_id)
        pulumi.set(__self__, "tenant_id", tenant_id)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if user_assigned_identities is not None:
            pulumi.set(__self__, "user_assigned_identities", user_assigned_identities)

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> str:
        """
        The principal id of virtual machine scale set identity. This property will only be provided for a system assigned identity.
        """
        return pulumi.get(self, "principal_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> str:
        """
        The tenant id associated with the virtual machine scale set. This property will only be provided for a system assigned identity.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The type of identity used for the virtual machine scale set. The type 'SystemAssigned, UserAssigned' includes both an implicitly created identity and a set of user assigned identities. The type 'None' will remove any identities from the virtual machine scale set.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="userAssignedIdentities")
    def user_assigned_identities(self) -> Optional[Mapping[str, 'outputs.VirtualMachineScaleSetIdentityResponseUserAssignedIdentities']]:
        """
        The list of user identities associated with the virtual machine scale set. The user identity dictionary key references will be ARM resource ids in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
        """
        return pulumi.get(self, "user_assigned_identities")


@pulumi.output_type
class VirtualMachineScaleSetIdentityResponseUserAssignedIdentities(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientId":
            suggest = "client_id"
        elif key == "principalId":
            suggest = "principal_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualMachineScaleSetIdentityResponseUserAssignedIdentities. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualMachineScaleSetIdentityResponseUserAssignedIdentities.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualMachineScaleSetIdentityResponseUserAssignedIdentities.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_id: str,
                 principal_id: str):
        """
        :param str client_id: The client id of user assigned identity.
        :param str principal_id: The principal id of user assigned identity.
        """
        pulumi.set(__self__, "client_id", client_id)
        pulumi.set(__self__, "principal_id", principal_id)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> str:
        """
        The client id of user assigned identity.
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> str:
        """
        The principal id of user assigned identity.
        """
        return pulumi.get(self, "principal_id")


@pulumi.output_type
class VirtualMachineScaleSetIpTagResponse(dict):
    """
    Contains the IP tag associated with the public IP address.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipTagType":
            suggest = "ip_tag_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualMachineScaleSetIpTagResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualMachineScaleSetIpTagResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualMachineScaleSetIpTagResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ip_tag_type: Optional[str] = None,
                 tag: Optional[str] = None):
        """
        Contains the IP tag associated with the public IP address.
        :param str ip_tag_type: IP tag type. Example: FirstPartyUsage.
        :param str tag: IP tag associated with the public IP. Example: SQL, Storage etc.
        """
        if ip_tag_type is not None:
            pulumi.set(__self__, "ip_tag_type", ip_tag_type)
        if tag is not None:
            pulumi.set(__self__, "tag", tag)

    @property
    @pulumi.getter(name="ipTagType")
    def ip_tag_type(self) -> Optional[str]:
        """
        IP tag type. Example: FirstPartyUsage.
        """
        return pulumi.get(self, "ip_tag_type")

    @property
    @pulumi.getter
    def tag(self) -> Optional[str]:
        """
        IP tag associated with the public IP. Example: SQL, Storage etc.
        """
        return pulumi.get(self, "tag")


@pulumi.output_type
class VirtualMachineScaleSetManagedDiskParametersResponse(dict):
    """
    Describes the parameters of a ScaleSet managed disk.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "diskEncryptionSet":
            suggest = "disk_encryption_set"
        elif key == "storageAccountType":
            suggest = "storage_account_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualMachineScaleSetManagedDiskParametersResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualMachineScaleSetManagedDiskParametersResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualMachineScaleSetManagedDiskParametersResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 disk_encryption_set: Optional['outputs.DiskEncryptionSetParametersResponse'] = None,
                 storage_account_type: Optional[str] = None):
        """
        Describes the parameters of a ScaleSet managed disk.
        :param 'DiskEncryptionSetParametersResponse' disk_encryption_set: Specifies the customer managed disk encryption set resource id for the managed disk.
        :param str storage_account_type: Specifies the storage account type for the managed disk. NOTE: UltraSSD_LRS can only be used with data disks, it cannot be used with OS Disk.
        """
        if disk_encryption_set is not None:
            pulumi.set(__self__, "disk_encryption_set", disk_encryption_set)
        if storage_account_type is not None:
            pulumi.set(__self__, "storage_account_type", storage_account_type)

    @property
    @pulumi.getter(name="diskEncryptionSet")
    def disk_encryption_set(self) -> Optional['outputs.DiskEncryptionSetParametersResponse']:
        """
        Specifies the customer managed disk encryption set resource id for the managed disk.
        """
        return pulumi.get(self, "disk_encryption_set")

    @property
    @pulumi.getter(name="storageAccountType")
    def storage_account_type(self) -> Optional[str]:
        """
        Specifies the storage account type for the managed disk. NOTE: UltraSSD_LRS can only be used with data disks, it cannot be used with OS Disk.
        """
        return pulumi.get(self, "storage_account_type")


@pulumi.output_type
class VirtualMachineScaleSetNetworkConfigurationDnsSettingsResponse(dict):
    """
    Describes a virtual machines scale sets network configuration's DNS settings.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dnsServers":
            suggest = "dns_servers"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualMachineScaleSetNetworkConfigurationDnsSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualMachineScaleSetNetworkConfigurationDnsSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualMachineScaleSetNetworkConfigurationDnsSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dns_servers: Optional[Sequence[str]] = None):
        """
        Describes a virtual machines scale sets network configuration's DNS settings.
        :param Sequence[str] dns_servers: List of DNS servers IP addresses
        """
        if dns_servers is not None:
            pulumi.set(__self__, "dns_servers", dns_servers)

    @property
    @pulumi.getter(name="dnsServers")
    def dns_servers(self) -> Optional[Sequence[str]]:
        """
        List of DNS servers IP addresses
        """
        return pulumi.get(self, "dns_servers")


@pulumi.output_type
class VirtualMachineScaleSetNetworkConfigurationResponse(dict):
    """
    Describes a virtual machine scale set network profile's network configurations.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipConfigurations":
            suggest = "ip_configurations"
        elif key == "dnsSettings":
            suggest = "dns_settings"
        elif key == "enableAcceleratedNetworking":
            suggest = "enable_accelerated_networking"
        elif key == "enableFpga":
            suggest = "enable_fpga"
        elif key == "enableIPForwarding":
            suggest = "enable_ip_forwarding"
        elif key == "networkSecurityGroup":
            suggest = "network_security_group"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualMachineScaleSetNetworkConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualMachineScaleSetNetworkConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualMachineScaleSetNetworkConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ip_configurations: Sequence['outputs.VirtualMachineScaleSetIPConfigurationResponse'],
                 name: str,
                 dns_settings: Optional['outputs.VirtualMachineScaleSetNetworkConfigurationDnsSettingsResponse'] = None,
                 enable_accelerated_networking: Optional[bool] = None,
                 enable_fpga: Optional[bool] = None,
                 enable_ip_forwarding: Optional[bool] = None,
                 id: Optional[str] = None,
                 network_security_group: Optional['outputs.SubResourceResponse'] = None,
                 primary: Optional[bool] = None):
        """
        Describes a virtual machine scale set network profile's network configurations.
        :param Sequence['VirtualMachineScaleSetIPConfigurationResponse'] ip_configurations: Specifies the IP configurations of the network interface.
        :param str name: The network configuration name.
        :param 'VirtualMachineScaleSetNetworkConfigurationDnsSettingsResponse' dns_settings: The dns settings to be applied on the network interfaces.
        :param bool enable_accelerated_networking: Specifies whether the network interface is accelerated networking-enabled.
        :param bool enable_fpga: Specifies whether the network interface is FPGA networking-enabled.
        :param bool enable_ip_forwarding: Whether IP forwarding enabled on this NIC.
        :param str id: Resource Id
        :param 'SubResourceResponse' network_security_group: The network security group.
        :param bool primary: Specifies the primary network interface in case the virtual machine has more than 1 network interface.
        """
        pulumi.set(__self__, "ip_configurations", ip_configurations)
        pulumi.set(__self__, "name", name)
        if dns_settings is not None:
            pulumi.set(__self__, "dns_settings", dns_settings)
        if enable_accelerated_networking is not None:
            pulumi.set(__self__, "enable_accelerated_networking", enable_accelerated_networking)
        if enable_fpga is not None:
            pulumi.set(__self__, "enable_fpga", enable_fpga)
        if enable_ip_forwarding is not None:
            pulumi.set(__self__, "enable_ip_forwarding", enable_ip_forwarding)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if network_security_group is not None:
            pulumi.set(__self__, "network_security_group", network_security_group)
        if primary is not None:
            pulumi.set(__self__, "primary", primary)

    @property
    @pulumi.getter(name="ipConfigurations")
    def ip_configurations(self) -> Sequence['outputs.VirtualMachineScaleSetIPConfigurationResponse']:
        """
        Specifies the IP configurations of the network interface.
        """
        return pulumi.get(self, "ip_configurations")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The network configuration name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="dnsSettings")
    def dns_settings(self) -> Optional['outputs.VirtualMachineScaleSetNetworkConfigurationDnsSettingsResponse']:
        """
        The dns settings to be applied on the network interfaces.
        """
        return pulumi.get(self, "dns_settings")

    @property
    @pulumi.getter(name="enableAcceleratedNetworking")
    def enable_accelerated_networking(self) -> Optional[bool]:
        """
        Specifies whether the network interface is accelerated networking-enabled.
        """
        return pulumi.get(self, "enable_accelerated_networking")

    @property
    @pulumi.getter(name="enableFpga")
    def enable_fpga(self) -> Optional[bool]:
        """
        Specifies whether the network interface is FPGA networking-enabled.
        """
        return pulumi.get(self, "enable_fpga")

    @property
    @pulumi.getter(name="enableIPForwarding")
    def enable_ip_forwarding(self) -> Optional[bool]:
        """
        Whether IP forwarding enabled on this NIC.
        """
        return pulumi.get(self, "enable_ip_forwarding")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource Id
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="networkSecurityGroup")
    def network_security_group(self) -> Optional['outputs.SubResourceResponse']:
        """
        The network security group.
        """
        return pulumi.get(self, "network_security_group")

    @property
    @pulumi.getter
    def primary(self) -> Optional[bool]:
        """
        Specifies the primary network interface in case the virtual machine has more than 1 network interface.
        """
        return pulumi.get(self, "primary")


@pulumi.output_type
class VirtualMachineScaleSetNetworkProfileResponse(dict):
    """
    Describes a virtual machine scale set network profile.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "healthProbe":
            suggest = "health_probe"
        elif key == "networkInterfaceConfigurations":
            suggest = "network_interface_configurations"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualMachineScaleSetNetworkProfileResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualMachineScaleSetNetworkProfileResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualMachineScaleSetNetworkProfileResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 health_probe: Optional['outputs.ApiEntityReferenceResponse'] = None,
                 network_interface_configurations: Optional[Sequence['outputs.VirtualMachineScaleSetNetworkConfigurationResponse']] = None):
        """
        Describes a virtual machine scale set network profile.
        :param 'ApiEntityReferenceResponse' health_probe: A reference to a load balancer probe used to determine the health of an instance in the virtual machine scale set. The reference will be in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/loadBalancers/{loadBalancerName}/probes/{probeName}'.
        :param Sequence['VirtualMachineScaleSetNetworkConfigurationResponse'] network_interface_configurations: The list of network configurations.
        """
        if health_probe is not None:
            pulumi.set(__self__, "health_probe", health_probe)
        if network_interface_configurations is not None:
            pulumi.set(__self__, "network_interface_configurations", network_interface_configurations)

    @property
    @pulumi.getter(name="healthProbe")
    def health_probe(self) -> Optional['outputs.ApiEntityReferenceResponse']:
        """
        A reference to a load balancer probe used to determine the health of an instance in the virtual machine scale set. The reference will be in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/loadBalancers/{loadBalancerName}/probes/{probeName}'.
        """
        return pulumi.get(self, "health_probe")

    @property
    @pulumi.getter(name="networkInterfaceConfigurations")
    def network_interface_configurations(self) -> Optional[Sequence['outputs.VirtualMachineScaleSetNetworkConfigurationResponse']]:
        """
        The list of network configurations.
        """
        return pulumi.get(self, "network_interface_configurations")


@pulumi.output_type
class VirtualMachineScaleSetOSDiskResponse(dict):
    """
    Describes a virtual machine scale set operating system disk.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createOption":
            suggest = "create_option"
        elif key == "diffDiskSettings":
            suggest = "diff_disk_settings"
        elif key == "diskSizeGB":
            suggest = "disk_size_gb"
        elif key == "managedDisk":
            suggest = "managed_disk"
        elif key == "osType":
            suggest = "os_type"
        elif key == "vhdContainers":
            suggest = "vhd_containers"
        elif key == "writeAcceleratorEnabled":
            suggest = "write_accelerator_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualMachineScaleSetOSDiskResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualMachineScaleSetOSDiskResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualMachineScaleSetOSDiskResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 create_option: str,
                 caching: Optional[str] = None,
                 diff_disk_settings: Optional['outputs.DiffDiskSettingsResponse'] = None,
                 disk_size_gb: Optional[int] = None,
                 image: Optional['outputs.VirtualHardDiskResponse'] = None,
                 managed_disk: Optional['outputs.VirtualMachineScaleSetManagedDiskParametersResponse'] = None,
                 name: Optional[str] = None,
                 os_type: Optional[str] = None,
                 vhd_containers: Optional[Sequence[str]] = None,
                 write_accelerator_enabled: Optional[bool] = None):
        """
        Describes a virtual machine scale set operating system disk.
        :param str create_option: Specifies how the virtual machines in the scale set should be created.<br><br> The only allowed value is: **FromImage** \u2013 This value is used when you are using an image to create the virtual machine. If you are using a platform image, you also use the imageReference element described above. If you are using a marketplace image, you  also use the plan element previously described.
        :param str caching: Specifies the caching requirements. <br><br> Possible values are: <br><br> **None** <br><br> **ReadOnly** <br><br> **ReadWrite** <br><br> Default: **None for Standard storage. ReadOnly for Premium storage**
        :param 'DiffDiskSettingsResponse' diff_disk_settings: Specifies the ephemeral disk Settings for the operating system disk used by the virtual machine scale set.
        :param int disk_size_gb: Specifies the size of the operating system disk in gigabytes. This element can be used to overwrite the size of the disk in a virtual machine image. <br><br> This value cannot be larger than 1023 GB
        :param 'VirtualHardDiskResponse' image: Specifies information about the unmanaged user image to base the scale set on.
        :param 'VirtualMachineScaleSetManagedDiskParametersResponse' managed_disk: The managed disk parameters.
        :param str name: The disk name.
        :param str os_type: This property allows you to specify the type of the OS that is included in the disk if creating a VM from user-image or a specialized VHD. <br><br> Possible values are: <br><br> **Windows** <br><br> **Linux**
        :param Sequence[str] vhd_containers: Specifies the container urls that are used to store operating system disks for the scale set.
        :param bool write_accelerator_enabled: Specifies whether writeAccelerator should be enabled or disabled on the disk.
        """
        pulumi.set(__self__, "create_option", create_option)
        if caching is not None:
            pulumi.set(__self__, "caching", caching)
        if diff_disk_settings is not None:
            pulumi.set(__self__, "diff_disk_settings", diff_disk_settings)
        if disk_size_gb is not None:
            pulumi.set(__self__, "disk_size_gb", disk_size_gb)
        if image is not None:
            pulumi.set(__self__, "image", image)
        if managed_disk is not None:
            pulumi.set(__self__, "managed_disk", managed_disk)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if os_type is not None:
            pulumi.set(__self__, "os_type", os_type)
        if vhd_containers is not None:
            pulumi.set(__self__, "vhd_containers", vhd_containers)
        if write_accelerator_enabled is not None:
            pulumi.set(__self__, "write_accelerator_enabled", write_accelerator_enabled)

    @property
    @pulumi.getter(name="createOption")
    def create_option(self) -> str:
        """
        Specifies how the virtual machines in the scale set should be created.<br><br> The only allowed value is: **FromImage** \u2013 This value is used when you are using an image to create the virtual machine. If you are using a platform image, you also use the imageReference element described above. If you are using a marketplace image, you  also use the plan element previously described.
        """
        return pulumi.get(self, "create_option")

    @property
    @pulumi.getter
    def caching(self) -> Optional[str]:
        """
        Specifies the caching requirements. <br><br> Possible values are: <br><br> **None** <br><br> **ReadOnly** <br><br> **ReadWrite** <br><br> Default: **None for Standard storage. ReadOnly for Premium storage**
        """
        return pulumi.get(self, "caching")

    @property
    @pulumi.getter(name="diffDiskSettings")
    def diff_disk_settings(self) -> Optional['outputs.DiffDiskSettingsResponse']:
        """
        Specifies the ephemeral disk Settings for the operating system disk used by the virtual machine scale set.
        """
        return pulumi.get(self, "diff_disk_settings")

    @property
    @pulumi.getter(name="diskSizeGB")
    def disk_size_gb(self) -> Optional[int]:
        """
        Specifies the size of the operating system disk in gigabytes. This element can be used to overwrite the size of the disk in a virtual machine image. <br><br> This value cannot be larger than 1023 GB
        """
        return pulumi.get(self, "disk_size_gb")

    @property
    @pulumi.getter
    def image(self) -> Optional['outputs.VirtualHardDiskResponse']:
        """
        Specifies information about the unmanaged user image to base the scale set on.
        """
        return pulumi.get(self, "image")

    @property
    @pulumi.getter(name="managedDisk")
    def managed_disk(self) -> Optional['outputs.VirtualMachineScaleSetManagedDiskParametersResponse']:
        """
        The managed disk parameters.
        """
        return pulumi.get(self, "managed_disk")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The disk name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="osType")
    def os_type(self) -> Optional[str]:
        """
        This property allows you to specify the type of the OS that is included in the disk if creating a VM from user-image or a specialized VHD. <br><br> Possible values are: <br><br> **Windows** <br><br> **Linux**
        """
        return pulumi.get(self, "os_type")

    @property
    @pulumi.getter(name="vhdContainers")
    def vhd_containers(self) -> Optional[Sequence[str]]:
        """
        Specifies the container urls that are used to store operating system disks for the scale set.
        """
        return pulumi.get(self, "vhd_containers")

    @property
    @pulumi.getter(name="writeAcceleratorEnabled")
    def write_accelerator_enabled(self) -> Optional[bool]:
        """
        Specifies whether writeAccelerator should be enabled or disabled on the disk.
        """
        return pulumi.get(self, "write_accelerator_enabled")


@pulumi.output_type
class VirtualMachineScaleSetOSProfileResponse(dict):
    """
    Describes a virtual machine scale set OS profile.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "adminPassword":
            suggest = "admin_password"
        elif key == "adminUsername":
            suggest = "admin_username"
        elif key == "computerNamePrefix":
            suggest = "computer_name_prefix"
        elif key == "customData":
            suggest = "custom_data"
        elif key == "linuxConfiguration":
            suggest = "linux_configuration"
        elif key == "windowsConfiguration":
            suggest = "windows_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualMachineScaleSetOSProfileResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualMachineScaleSetOSProfileResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualMachineScaleSetOSProfileResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 admin_password: Optional[str] = None,
                 admin_username: Optional[str] = None,
                 computer_name_prefix: Optional[str] = None,
                 custom_data: Optional[str] = None,
                 linux_configuration: Optional['outputs.LinuxConfigurationResponse'] = None,
                 secrets: Optional[Sequence['outputs.VaultSecretGroupResponse']] = None,
                 windows_configuration: Optional['outputs.WindowsConfigurationResponse'] = None):
        """
        Describes a virtual machine scale set OS profile.
        :param str admin_password: Specifies the password of the administrator account. <br><br> **Minimum-length (Windows):** 8 characters <br><br> **Minimum-length (Linux):** 6 characters <br><br> **Max-length (Windows):** 123 characters <br><br> **Max-length (Linux):** 72 characters <br><br> **Complexity requirements:** 3 out of 4 conditions below need to be fulfilled <br> Has lower characters <br>Has upper characters <br> Has a digit <br> Has a special character (Regex match [\W_]) <br><br> **Disallowed values:** "abc@123", "P@$$w0rd", "P@ssw0rd", "P@ssword123", "Pa$$word", "pass@word1", "Password!", "Password1", "Password22", "iloveyou!" <br><br> For resetting the password, see [How to reset the Remote Desktop service or its login password in a Windows VM](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-reset-rdp?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json) <br><br> For resetting root password, see [Manage users, SSH, and check or repair disks on Azure Linux VMs using the VMAccess Extension](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-using-vmaccess-extension?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json#reset-root-password)
        :param str admin_username: Specifies the name of the administrator account. <br><br> **Windows-only restriction:** Cannot end in "." <br><br> **Disallowed values:** "administrator", "admin", "user", "user1", "test", "user2", "test1", "user3", "admin1", "1", "123", "a", "actuser", "adm", "admin2", "aspnet", "backup", "console", "david", "guest", "john", "owner", "root", "server", "sql", "support", "support_388945a0", "sys", "test2", "test3", "user4", "user5". <br><br> **Minimum-length (Linux):** 1  character <br><br> **Max-length (Linux):** 64 characters <br><br> **Max-length (Windows):** 20 characters  <br><br><li> For root access to the Linux VM, see [Using root privileges on Linux virtual machines in Azure](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-use-root-privileges?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json)<br><li> For a list of built-in system users on Linux that should not be used in this field, see [Selecting User Names for Linux on Azure](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-usernames?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json)
        :param str computer_name_prefix: Specifies the computer name prefix for all of the virtual machines in the scale set. Computer name prefixes must be 1 to 15 characters long.
        :param str custom_data: Specifies a base-64 encoded string of custom data. The base-64 encoded string is decoded to a binary array that is saved as a file on the Virtual Machine. The maximum length of the binary array is 65535 bytes. <br><br> For using cloud-init for your VM, see [Using cloud-init to customize a Linux VM during creation](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-using-cloud-init?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json)
        :param 'LinuxConfigurationResponse' linux_configuration: Specifies the Linux operating system settings on the virtual machine. <br><br>For a list of supported Linux distributions, see [Linux on Azure-Endorsed Distributions](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-endorsed-distros?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json) <br><br> For running non-endorsed distributions, see [Information for Non-Endorsed Distributions](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-create-upload-generic?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json).
        :param Sequence['VaultSecretGroupResponse'] secrets: Specifies set of certificates that should be installed onto the virtual machines in the scale set.
        :param 'WindowsConfigurationResponse' windows_configuration: Specifies Windows operating system settings on the virtual machine.
        """
        if admin_password is not None:
            pulumi.set(__self__, "admin_password", admin_password)
        if admin_username is not None:
            pulumi.set(__self__, "admin_username", admin_username)
        if computer_name_prefix is not None:
            pulumi.set(__self__, "computer_name_prefix", computer_name_prefix)
        if custom_data is not None:
            pulumi.set(__self__, "custom_data", custom_data)
        if linux_configuration is not None:
            pulumi.set(__self__, "linux_configuration", linux_configuration)
        if secrets is not None:
            pulumi.set(__self__, "secrets", secrets)
        if windows_configuration is not None:
            pulumi.set(__self__, "windows_configuration", windows_configuration)

    @property
    @pulumi.getter(name="adminPassword")
    def admin_password(self) -> Optional[str]:
        """
        Specifies the password of the administrator account. <br><br> **Minimum-length (Windows):** 8 characters <br><br> **Minimum-length (Linux):** 6 characters <br><br> **Max-length (Windows):** 123 characters <br><br> **Max-length (Linux):** 72 characters <br><br> **Complexity requirements:** 3 out of 4 conditions below need to be fulfilled <br> Has lower characters <br>Has upper characters <br> Has a digit <br> Has a special character (Regex match [\W_]) <br><br> **Disallowed values:** "abc@123", "P@$$w0rd", "P@ssw0rd", "P@ssword123", "Pa$$word", "pass@word1", "Password!", "Password1", "Password22", "iloveyou!" <br><br> For resetting the password, see [How to reset the Remote Desktop service or its login password in a Windows VM](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-reset-rdp?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json) <br><br> For resetting root password, see [Manage users, SSH, and check or repair disks on Azure Linux VMs using the VMAccess Extension](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-using-vmaccess-extension?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json#reset-root-password)
        """
        return pulumi.get(self, "admin_password")

    @property
    @pulumi.getter(name="adminUsername")
    def admin_username(self) -> Optional[str]:
        """
        Specifies the name of the administrator account. <br><br> **Windows-only restriction:** Cannot end in "." <br><br> **Disallowed values:** "administrator", "admin", "user", "user1", "test", "user2", "test1", "user3", "admin1", "1", "123", "a", "actuser", "adm", "admin2", "aspnet", "backup", "console", "david", "guest", "john", "owner", "root", "server", "sql", "support", "support_388945a0", "sys", "test2", "test3", "user4", "user5". <br><br> **Minimum-length (Linux):** 1  character <br><br> **Max-length (Linux):** 64 characters <br><br> **Max-length (Windows):** 20 characters  <br><br><li> For root access to the Linux VM, see [Using root privileges on Linux virtual machines in Azure](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-use-root-privileges?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json)<br><li> For a list of built-in system users on Linux that should not be used in this field, see [Selecting User Names for Linux on Azure](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-usernames?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json)
        """
        return pulumi.get(self, "admin_username")

    @property
    @pulumi.getter(name="computerNamePrefix")
    def computer_name_prefix(self) -> Optional[str]:
        """
        Specifies the computer name prefix for all of the virtual machines in the scale set. Computer name prefixes must be 1 to 15 characters long.
        """
        return pulumi.get(self, "computer_name_prefix")

    @property
    @pulumi.getter(name="customData")
    def custom_data(self) -> Optional[str]:
        """
        Specifies a base-64 encoded string of custom data. The base-64 encoded string is decoded to a binary array that is saved as a file on the Virtual Machine. The maximum length of the binary array is 65535 bytes. <br><br> For using cloud-init for your VM, see [Using cloud-init to customize a Linux VM during creation](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-using-cloud-init?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json)
        """
        return pulumi.get(self, "custom_data")

    @property
    @pulumi.getter(name="linuxConfiguration")
    def linux_configuration(self) -> Optional['outputs.LinuxConfigurationResponse']:
        """
        Specifies the Linux operating system settings on the virtual machine. <br><br>For a list of supported Linux distributions, see [Linux on Azure-Endorsed Distributions](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-endorsed-distros?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json) <br><br> For running non-endorsed distributions, see [Information for Non-Endorsed Distributions](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-create-upload-generic?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json).
        """
        return pulumi.get(self, "linux_configuration")

    @property
    @pulumi.getter
    def secrets(self) -> Optional[Sequence['outputs.VaultSecretGroupResponse']]:
        """
        Specifies set of certificates that should be installed onto the virtual machines in the scale set.
        """
        return pulumi.get(self, "secrets")

    @property
    @pulumi.getter(name="windowsConfiguration")
    def windows_configuration(self) -> Optional['outputs.WindowsConfigurationResponse']:
        """
        Specifies Windows operating system settings on the virtual machine.
        """
        return pulumi.get(self, "windows_configuration")


@pulumi.output_type
class VirtualMachineScaleSetPublicIPAddressConfigurationDnsSettingsResponse(dict):
    """
    Describes a virtual machines scale sets network configuration's DNS settings.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "domainNameLabel":
            suggest = "domain_name_label"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualMachineScaleSetPublicIPAddressConfigurationDnsSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualMachineScaleSetPublicIPAddressConfigurationDnsSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualMachineScaleSetPublicIPAddressConfigurationDnsSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 domain_name_label: str):
        """
        Describes a virtual machines scale sets network configuration's DNS settings.
        :param str domain_name_label: The Domain name label.The concatenation of the domain name label and vm index will be the domain name labels of the PublicIPAddress resources that will be created
        """
        pulumi.set(__self__, "domain_name_label", domain_name_label)

    @property
    @pulumi.getter(name="domainNameLabel")
    def domain_name_label(self) -> str:
        """
        The Domain name label.The concatenation of the domain name label and vm index will be the domain name labels of the PublicIPAddress resources that will be created
        """
        return pulumi.get(self, "domain_name_label")


@pulumi.output_type
class VirtualMachineScaleSetPublicIPAddressConfigurationResponse(dict):
    """
    Describes a virtual machines scale set IP Configuration's PublicIPAddress configuration
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dnsSettings":
            suggest = "dns_settings"
        elif key == "idleTimeoutInMinutes":
            suggest = "idle_timeout_in_minutes"
        elif key == "ipTags":
            suggest = "ip_tags"
        elif key == "publicIPAddressVersion":
            suggest = "public_ip_address_version"
        elif key == "publicIPPrefix":
            suggest = "public_ip_prefix"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualMachineScaleSetPublicIPAddressConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualMachineScaleSetPublicIPAddressConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualMachineScaleSetPublicIPAddressConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 dns_settings: Optional['outputs.VirtualMachineScaleSetPublicIPAddressConfigurationDnsSettingsResponse'] = None,
                 idle_timeout_in_minutes: Optional[int] = None,
                 ip_tags: Optional[Sequence['outputs.VirtualMachineScaleSetIpTagResponse']] = None,
                 public_ip_address_version: Optional[str] = None,
                 public_ip_prefix: Optional['outputs.SubResourceResponse'] = None):
        """
        Describes a virtual machines scale set IP Configuration's PublicIPAddress configuration
        :param str name: The publicIP address configuration name.
        :param 'VirtualMachineScaleSetPublicIPAddressConfigurationDnsSettingsResponse' dns_settings: The dns settings to be applied on the publicIP addresses .
        :param int idle_timeout_in_minutes: The idle timeout of the public IP address.
        :param Sequence['VirtualMachineScaleSetIpTagResponse'] ip_tags: The list of IP tags associated with the public IP address.
        :param str public_ip_address_version: Available from Api-Version 2019-07-01 onwards, it represents whether the specific ipconfiguration is IPv4 or IPv6. Default is taken as IPv4. Possible values are: 'IPv4' and 'IPv6'.
        :param 'SubResourceResponse' public_ip_prefix: The PublicIPPrefix from which to allocate publicIP addresses.
        """
        pulumi.set(__self__, "name", name)
        if dns_settings is not None:
            pulumi.set(__self__, "dns_settings", dns_settings)
        if idle_timeout_in_minutes is not None:
            pulumi.set(__self__, "idle_timeout_in_minutes", idle_timeout_in_minutes)
        if ip_tags is not None:
            pulumi.set(__self__, "ip_tags", ip_tags)
        if public_ip_address_version is not None:
            pulumi.set(__self__, "public_ip_address_version", public_ip_address_version)
        if public_ip_prefix is not None:
            pulumi.set(__self__, "public_ip_prefix", public_ip_prefix)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The publicIP address configuration name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="dnsSettings")
    def dns_settings(self) -> Optional['outputs.VirtualMachineScaleSetPublicIPAddressConfigurationDnsSettingsResponse']:
        """
        The dns settings to be applied on the publicIP addresses .
        """
        return pulumi.get(self, "dns_settings")

    @property
    @pulumi.getter(name="idleTimeoutInMinutes")
    def idle_timeout_in_minutes(self) -> Optional[int]:
        """
        The idle timeout of the public IP address.
        """
        return pulumi.get(self, "idle_timeout_in_minutes")

    @property
    @pulumi.getter(name="ipTags")
    def ip_tags(self) -> Optional[Sequence['outputs.VirtualMachineScaleSetIpTagResponse']]:
        """
        The list of IP tags associated with the public IP address.
        """
        return pulumi.get(self, "ip_tags")

    @property
    @pulumi.getter(name="publicIPAddressVersion")
    def public_ip_address_version(self) -> Optional[str]:
        """
        Available from Api-Version 2019-07-01 onwards, it represents whether the specific ipconfiguration is IPv4 or IPv6. Default is taken as IPv4. Possible values are: 'IPv4' and 'IPv6'.
        """
        return pulumi.get(self, "public_ip_address_version")

    @property
    @pulumi.getter(name="publicIPPrefix")
    def public_ip_prefix(self) -> Optional['outputs.SubResourceResponse']:
        """
        The PublicIPPrefix from which to allocate publicIP addresses.
        """
        return pulumi.get(self, "public_ip_prefix")


@pulumi.output_type
class VirtualMachineScaleSetStorageProfileResponse(dict):
    """
    Describes a virtual machine scale set storage profile.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataDisks":
            suggest = "data_disks"
        elif key == "imageReference":
            suggest = "image_reference"
        elif key == "osDisk":
            suggest = "os_disk"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualMachineScaleSetStorageProfileResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualMachineScaleSetStorageProfileResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualMachineScaleSetStorageProfileResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data_disks: Optional[Sequence['outputs.VirtualMachineScaleSetDataDiskResponse']] = None,
                 image_reference: Optional['outputs.ImageReferenceResponse'] = None,
                 os_disk: Optional['outputs.VirtualMachineScaleSetOSDiskResponse'] = None):
        """
        Describes a virtual machine scale set storage profile.
        :param Sequence['VirtualMachineScaleSetDataDiskResponse'] data_disks: Specifies the parameters that are used to add data disks to the virtual machines in the scale set. <br><br> For more information about disks, see [About disks and VHDs for Azure virtual machines](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-about-disks-vhds?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json).
        :param 'ImageReferenceResponse' image_reference: Specifies information about the image to use. You can specify information about platform images, marketplace images, or virtual machine images. This element is required when you want to use a platform image, marketplace image, or virtual machine image, but is not used in other creation operations.
        :param 'VirtualMachineScaleSetOSDiskResponse' os_disk: Specifies information about the operating system disk used by the virtual machines in the scale set. <br><br> For more information about disks, see [About disks and VHDs for Azure virtual machines](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-about-disks-vhds?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json).
        """
        if data_disks is not None:
            pulumi.set(__self__, "data_disks", data_disks)
        if image_reference is not None:
            pulumi.set(__self__, "image_reference", image_reference)
        if os_disk is not None:
            pulumi.set(__self__, "os_disk", os_disk)

    @property
    @pulumi.getter(name="dataDisks")
    def data_disks(self) -> Optional[Sequence['outputs.VirtualMachineScaleSetDataDiskResponse']]:
        """
        Specifies the parameters that are used to add data disks to the virtual machines in the scale set. <br><br> For more information about disks, see [About disks and VHDs for Azure virtual machines](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-about-disks-vhds?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json).
        """
        return pulumi.get(self, "data_disks")

    @property
    @pulumi.getter(name="imageReference")
    def image_reference(self) -> Optional['outputs.ImageReferenceResponse']:
        """
        Specifies information about the image to use. You can specify information about platform images, marketplace images, or virtual machine images. This element is required when you want to use a platform image, marketplace image, or virtual machine image, but is not used in other creation operations.
        """
        return pulumi.get(self, "image_reference")

    @property
    @pulumi.getter(name="osDisk")
    def os_disk(self) -> Optional['outputs.VirtualMachineScaleSetOSDiskResponse']:
        """
        Specifies information about the operating system disk used by the virtual machines in the scale set. <br><br> For more information about disks, see [About disks and VHDs for Azure virtual machines](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-about-disks-vhds?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json).
        """
        return pulumi.get(self, "os_disk")


@pulumi.output_type
class VirtualMachineScaleSetVMInstanceViewResponse(dict):
    """
    The instance view of a virtual machine scale set VM.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "assignedHost":
            suggest = "assigned_host"
        elif key == "vmHealth":
            suggest = "vm_health"
        elif key == "bootDiagnostics":
            suggest = "boot_diagnostics"
        elif key == "maintenanceRedeployStatus":
            suggest = "maintenance_redeploy_status"
        elif key == "placementGroupId":
            suggest = "placement_group_id"
        elif key == "platformFaultDomain":
            suggest = "platform_fault_domain"
        elif key == "platformUpdateDomain":
            suggest = "platform_update_domain"
        elif key == "rdpThumbPrint":
            suggest = "rdp_thumb_print"
        elif key == "vmAgent":
            suggest = "vm_agent"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualMachineScaleSetVMInstanceViewResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualMachineScaleSetVMInstanceViewResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualMachineScaleSetVMInstanceViewResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 assigned_host: str,
                 vm_health: 'outputs.VirtualMachineHealthStatusResponse',
                 boot_diagnostics: Optional['outputs.BootDiagnosticsInstanceViewResponse'] = None,
                 disks: Optional[Sequence['outputs.DiskInstanceViewResponse']] = None,
                 extensions: Optional[Sequence['outputs.VirtualMachineExtensionInstanceViewResponse']] = None,
                 maintenance_redeploy_status: Optional['outputs.MaintenanceRedeployStatusResponse'] = None,
                 placement_group_id: Optional[str] = None,
                 platform_fault_domain: Optional[int] = None,
                 platform_update_domain: Optional[int] = None,
                 rdp_thumb_print: Optional[str] = None,
                 statuses: Optional[Sequence['outputs.InstanceViewStatusResponse']] = None,
                 vm_agent: Optional['outputs.VirtualMachineAgentInstanceViewResponse'] = None):
        """
        The instance view of a virtual machine scale set VM.
        :param str assigned_host: Resource id of the dedicated host, on which the virtual machine is allocated through automatic placement, when the virtual machine is associated with a dedicated host group that has automatic placement enabled. <br><br>Minimum api-version: 2020-06-01.
        :param 'VirtualMachineHealthStatusResponse' vm_health: The health status for the VM.
        :param 'BootDiagnosticsInstanceViewResponse' boot_diagnostics: Boot Diagnostics is a debugging feature which allows you to view Console Output and Screenshot to diagnose VM status. <br><br> You can easily view the output of your console log. <br><br> Azure also enables you to see a screenshot of the VM from the hypervisor.
        :param Sequence['DiskInstanceViewResponse'] disks: The disks information.
        :param Sequence['VirtualMachineExtensionInstanceViewResponse'] extensions: The extensions information.
        :param 'MaintenanceRedeployStatusResponse' maintenance_redeploy_status: The Maintenance Operation status on the virtual machine.
        :param str placement_group_id: The placement group in which the VM is running. If the VM is deallocated it will not have a placementGroupId.
        :param int platform_fault_domain: The Fault Domain count.
        :param int platform_update_domain: The Update Domain count.
        :param str rdp_thumb_print: The Remote desktop certificate thumbprint.
        :param Sequence['InstanceViewStatusResponse'] statuses: The resource status information.
        :param 'VirtualMachineAgentInstanceViewResponse' vm_agent: The VM Agent running on the virtual machine.
        """
        pulumi.set(__self__, "assigned_host", assigned_host)
        pulumi.set(__self__, "vm_health", vm_health)
        if boot_diagnostics is not None:
            pulumi.set(__self__, "boot_diagnostics", boot_diagnostics)
        if disks is not None:
            pulumi.set(__self__, "disks", disks)
        if extensions is not None:
            pulumi.set(__self__, "extensions", extensions)
        if maintenance_redeploy_status is not None:
            pulumi.set(__self__, "maintenance_redeploy_status", maintenance_redeploy_status)
        if placement_group_id is not None:
            pulumi.set(__self__, "placement_group_id", placement_group_id)
        if platform_fault_domain is not None:
            pulumi.set(__self__, "platform_fault_domain", platform_fault_domain)
        if platform_update_domain is not None:
            pulumi.set(__self__, "platform_update_domain", platform_update_domain)
        if rdp_thumb_print is not None:
            pulumi.set(__self__, "rdp_thumb_print", rdp_thumb_print)
        if statuses is not None:
            pulumi.set(__self__, "statuses", statuses)
        if vm_agent is not None:
            pulumi.set(__self__, "vm_agent", vm_agent)

    @property
    @pulumi.getter(name="assignedHost")
    def assigned_host(self) -> str:
        """
        Resource id of the dedicated host, on which the virtual machine is allocated through automatic placement, when the virtual machine is associated with a dedicated host group that has automatic placement enabled. <br><br>Minimum api-version: 2020-06-01.
        """
        return pulumi.get(self, "assigned_host")

    @property
    @pulumi.getter(name="vmHealth")
    def vm_health(self) -> 'outputs.VirtualMachineHealthStatusResponse':
        """
        The health status for the VM.
        """
        return pulumi.get(self, "vm_health")

    @property
    @pulumi.getter(name="bootDiagnostics")
    def boot_diagnostics(self) -> Optional['outputs.BootDiagnosticsInstanceViewResponse']:
        """
        Boot Diagnostics is a debugging feature which allows you to view Console Output and Screenshot to diagnose VM status. <br><br> You can easily view the output of your console log. <br><br> Azure also enables you to see a screenshot of the VM from the hypervisor.
        """
        return pulumi.get(self, "boot_diagnostics")

    @property
    @pulumi.getter
    def disks(self) -> Optional[Sequence['outputs.DiskInstanceViewResponse']]:
        """
        The disks information.
        """
        return pulumi.get(self, "disks")

    @property
    @pulumi.getter
    def extensions(self) -> Optional[Sequence['outputs.VirtualMachineExtensionInstanceViewResponse']]:
        """
        The extensions information.
        """
        return pulumi.get(self, "extensions")

    @property
    @pulumi.getter(name="maintenanceRedeployStatus")
    def maintenance_redeploy_status(self) -> Optional['outputs.MaintenanceRedeployStatusResponse']:
        """
        The Maintenance Operation status on the virtual machine.
        """
        return pulumi.get(self, "maintenance_redeploy_status")

    @property
    @pulumi.getter(name="placementGroupId")
    def placement_group_id(self) -> Optional[str]:
        """
        The placement group in which the VM is running. If the VM is deallocated it will not have a placementGroupId.
        """
        return pulumi.get(self, "placement_group_id")

    @property
    @pulumi.getter(name="platformFaultDomain")
    def platform_fault_domain(self) -> Optional[int]:
        """
        The Fault Domain count.
        """
        return pulumi.get(self, "platform_fault_domain")

    @property
    @pulumi.getter(name="platformUpdateDomain")
    def platform_update_domain(self) -> Optional[int]:
        """
        The Update Domain count.
        """
        return pulumi.get(self, "platform_update_domain")

    @property
    @pulumi.getter(name="rdpThumbPrint")
    def rdp_thumb_print(self) -> Optional[str]:
        """
        The Remote desktop certificate thumbprint.
        """
        return pulumi.get(self, "rdp_thumb_print")

    @property
    @pulumi.getter
    def statuses(self) -> Optional[Sequence['outputs.InstanceViewStatusResponse']]:
        """
        The resource status information.
        """
        return pulumi.get(self, "statuses")

    @property
    @pulumi.getter(name="vmAgent")
    def vm_agent(self) -> Optional['outputs.VirtualMachineAgentInstanceViewResponse']:
        """
        The VM Agent running on the virtual machine.
        """
        return pulumi.get(self, "vm_agent")


@pulumi.output_type
class VirtualMachineScaleSetVMNetworkProfileConfigurationResponse(dict):
    """
    Describes a virtual machine scale set VM network profile.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "networkInterfaceConfigurations":
            suggest = "network_interface_configurations"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualMachineScaleSetVMNetworkProfileConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualMachineScaleSetVMNetworkProfileConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualMachineScaleSetVMNetworkProfileConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 network_interface_configurations: Optional[Sequence['outputs.VirtualMachineScaleSetNetworkConfigurationResponse']] = None):
        """
        Describes a virtual machine scale set VM network profile.
        :param Sequence['VirtualMachineScaleSetNetworkConfigurationResponse'] network_interface_configurations: The list of network configurations.
        """
        if network_interface_configurations is not None:
            pulumi.set(__self__, "network_interface_configurations", network_interface_configurations)

    @property
    @pulumi.getter(name="networkInterfaceConfigurations")
    def network_interface_configurations(self) -> Optional[Sequence['outputs.VirtualMachineScaleSetNetworkConfigurationResponse']]:
        """
        The list of network configurations.
        """
        return pulumi.get(self, "network_interface_configurations")


@pulumi.output_type
class VirtualMachineScaleSetVMProfileResponse(dict):
    """
    Describes a virtual machine scale set virtual machine profile.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "billingProfile":
            suggest = "billing_profile"
        elif key == "diagnosticsProfile":
            suggest = "diagnostics_profile"
        elif key == "evictionPolicy":
            suggest = "eviction_policy"
        elif key == "extensionProfile":
            suggest = "extension_profile"
        elif key == "licenseType":
            suggest = "license_type"
        elif key == "networkProfile":
            suggest = "network_profile"
        elif key == "osProfile":
            suggest = "os_profile"
        elif key == "scheduledEventsProfile":
            suggest = "scheduled_events_profile"
        elif key == "securityProfile":
            suggest = "security_profile"
        elif key == "storageProfile":
            suggest = "storage_profile"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualMachineScaleSetVMProfileResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualMachineScaleSetVMProfileResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualMachineScaleSetVMProfileResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 billing_profile: Optional['outputs.BillingProfileResponse'] = None,
                 diagnostics_profile: Optional['outputs.DiagnosticsProfileResponse'] = None,
                 eviction_policy: Optional[str] = None,
                 extension_profile: Optional['outputs.VirtualMachineScaleSetExtensionProfileResponse'] = None,
                 license_type: Optional[str] = None,
                 network_profile: Optional['outputs.VirtualMachineScaleSetNetworkProfileResponse'] = None,
                 os_profile: Optional['outputs.VirtualMachineScaleSetOSProfileResponse'] = None,
                 priority: Optional[str] = None,
                 scheduled_events_profile: Optional['outputs.ScheduledEventsProfileResponse'] = None,
                 security_profile: Optional['outputs.SecurityProfileResponse'] = None,
                 storage_profile: Optional['outputs.VirtualMachineScaleSetStorageProfileResponse'] = None):
        """
        Describes a virtual machine scale set virtual machine profile.
        :param 'BillingProfileResponse' billing_profile: Specifies the billing related details of a Azure Spot VMSS. <br><br>Minimum api-version: 2019-03-01.
        :param 'DiagnosticsProfileResponse' diagnostics_profile: Specifies the boot diagnostic settings state. <br><br>Minimum api-version: 2015-06-15.
        :param str eviction_policy: Specifies the eviction policy for the Azure Spot virtual machine and Azure Spot scale set. <br><br>For Azure Spot virtual machines, both 'Deallocate' and 'Delete' are supported and the minimum api-version is 2019-03-01. <br><br>For Azure Spot scale sets, both 'Deallocate' and 'Delete' are supported and the minimum api-version is 2017-10-30-preview.
        :param 'VirtualMachineScaleSetExtensionProfileResponse' extension_profile: Specifies a collection of settings for extensions installed on virtual machines in the scale set.
        :param str license_type: Specifies that the image or disk that is being used was licensed on-premises. <br><br> Possible values for Windows Server operating system are: <br><br> Windows_Client <br><br> Windows_Server <br><br> Possible values for Linux Server operating system are: <br><br> RHEL_BYOS (for RHEL) <br><br> SLES_BYOS (for SUSE) <br><br> For more information, see [Azure Hybrid Use Benefit for Windows Server](https://docs.microsoft.com/azure/virtual-machines/windows/hybrid-use-benefit-licensing) <br><br> [Azure Hybrid Use Benefit for Linux Server](https://docs.microsoft.com/azure/virtual-machines/linux/azure-hybrid-benefit-linux) <br><br> Minimum api-version: 2015-06-15
        :param 'VirtualMachineScaleSetNetworkProfileResponse' network_profile: Specifies properties of the network interfaces of the virtual machines in the scale set.
        :param 'VirtualMachineScaleSetOSProfileResponse' os_profile: Specifies the operating system settings for the virtual machines in the scale set.
        :param str priority: Specifies the priority for the virtual machines in the scale set. <br><br>Minimum api-version: 2017-10-30-preview
        :param 'ScheduledEventsProfileResponse' scheduled_events_profile: Specifies Scheduled Event related configurations.
        :param 'SecurityProfileResponse' security_profile: Specifies the Security related profile settings for the virtual machines in the scale set.
        :param 'VirtualMachineScaleSetStorageProfileResponse' storage_profile: Specifies the storage settings for the virtual machine disks.
        """
        if billing_profile is not None:
            pulumi.set(__self__, "billing_profile", billing_profile)
        if diagnostics_profile is not None:
            pulumi.set(__self__, "diagnostics_profile", diagnostics_profile)
        if eviction_policy is not None:
            pulumi.set(__self__, "eviction_policy", eviction_policy)
        if extension_profile is not None:
            pulumi.set(__self__, "extension_profile", extension_profile)
        if license_type is not None:
            pulumi.set(__self__, "license_type", license_type)
        if network_profile is not None:
            pulumi.set(__self__, "network_profile", network_profile)
        if os_profile is not None:
            pulumi.set(__self__, "os_profile", os_profile)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if scheduled_events_profile is not None:
            pulumi.set(__self__, "scheduled_events_profile", scheduled_events_profile)
        if security_profile is not None:
            pulumi.set(__self__, "security_profile", security_profile)
        if storage_profile is not None:
            pulumi.set(__self__, "storage_profile", storage_profile)

    @property
    @pulumi.getter(name="billingProfile")
    def billing_profile(self) -> Optional['outputs.BillingProfileResponse']:
        """
        Specifies the billing related details of a Azure Spot VMSS. <br><br>Minimum api-version: 2019-03-01.
        """
        return pulumi.get(self, "billing_profile")

    @property
    @pulumi.getter(name="diagnosticsProfile")
    def diagnostics_profile(self) -> Optional['outputs.DiagnosticsProfileResponse']:
        """
        Specifies the boot diagnostic settings state. <br><br>Minimum api-version: 2015-06-15.
        """
        return pulumi.get(self, "diagnostics_profile")

    @property
    @pulumi.getter(name="evictionPolicy")
    def eviction_policy(self) -> Optional[str]:
        """
        Specifies the eviction policy for the Azure Spot virtual machine and Azure Spot scale set. <br><br>For Azure Spot virtual machines, both 'Deallocate' and 'Delete' are supported and the minimum api-version is 2019-03-01. <br><br>For Azure Spot scale sets, both 'Deallocate' and 'Delete' are supported and the minimum api-version is 2017-10-30-preview.
        """
        return pulumi.get(self, "eviction_policy")

    @property
    @pulumi.getter(name="extensionProfile")
    def extension_profile(self) -> Optional['outputs.VirtualMachineScaleSetExtensionProfileResponse']:
        """
        Specifies a collection of settings for extensions installed on virtual machines in the scale set.
        """
        return pulumi.get(self, "extension_profile")

    @property
    @pulumi.getter(name="licenseType")
    def license_type(self) -> Optional[str]:
        """
        Specifies that the image or disk that is being used was licensed on-premises. <br><br> Possible values for Windows Server operating system are: <br><br> Windows_Client <br><br> Windows_Server <br><br> Possible values for Linux Server operating system are: <br><br> RHEL_BYOS (for RHEL) <br><br> SLES_BYOS (for SUSE) <br><br> For more information, see [Azure Hybrid Use Benefit for Windows Server](https://docs.microsoft.com/azure/virtual-machines/windows/hybrid-use-benefit-licensing) <br><br> [Azure Hybrid Use Benefit for Linux Server](https://docs.microsoft.com/azure/virtual-machines/linux/azure-hybrid-benefit-linux) <br><br> Minimum api-version: 2015-06-15
        """
        return pulumi.get(self, "license_type")

    @property
    @pulumi.getter(name="networkProfile")
    def network_profile(self) -> Optional['outputs.VirtualMachineScaleSetNetworkProfileResponse']:
        """
        Specifies properties of the network interfaces of the virtual machines in the scale set.
        """
        return pulumi.get(self, "network_profile")

    @property
    @pulumi.getter(name="osProfile")
    def os_profile(self) -> Optional['outputs.VirtualMachineScaleSetOSProfileResponse']:
        """
        Specifies the operating system settings for the virtual machines in the scale set.
        """
        return pulumi.get(self, "os_profile")

    @property
    @pulumi.getter
    def priority(self) -> Optional[str]:
        """
        Specifies the priority for the virtual machines in the scale set. <br><br>Minimum api-version: 2017-10-30-preview
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter(name="scheduledEventsProfile")
    def scheduled_events_profile(self) -> Optional['outputs.ScheduledEventsProfileResponse']:
        """
        Specifies Scheduled Event related configurations.
        """
        return pulumi.get(self, "scheduled_events_profile")

    @property
    @pulumi.getter(name="securityProfile")
    def security_profile(self) -> Optional['outputs.SecurityProfileResponse']:
        """
        Specifies the Security related profile settings for the virtual machines in the scale set.
        """
        return pulumi.get(self, "security_profile")

    @property
    @pulumi.getter(name="storageProfile")
    def storage_profile(self) -> Optional['outputs.VirtualMachineScaleSetStorageProfileResponse']:
        """
        Specifies the storage settings for the virtual machine disks.
        """
        return pulumi.get(self, "storage_profile")


@pulumi.output_type
class VirtualMachineScaleSetVMProtectionPolicyResponse(dict):
    """
    The protection policy of a virtual machine scale set VM.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "protectFromScaleIn":
            suggest = "protect_from_scale_in"
        elif key == "protectFromScaleSetActions":
            suggest = "protect_from_scale_set_actions"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualMachineScaleSetVMProtectionPolicyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualMachineScaleSetVMProtectionPolicyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualMachineScaleSetVMProtectionPolicyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 protect_from_scale_in: Optional[bool] = None,
                 protect_from_scale_set_actions: Optional[bool] = None):
        """
        The protection policy of a virtual machine scale set VM.
        :param bool protect_from_scale_in: Indicates that the virtual machine scale set VM shouldn't be considered for deletion during a scale-in operation.
        :param bool protect_from_scale_set_actions: Indicates that model updates or actions (including scale-in) initiated on the virtual machine scale set should not be applied to the virtual machine scale set VM.
        """
        if protect_from_scale_in is not None:
            pulumi.set(__self__, "protect_from_scale_in", protect_from_scale_in)
        if protect_from_scale_set_actions is not None:
            pulumi.set(__self__, "protect_from_scale_set_actions", protect_from_scale_set_actions)

    @property
    @pulumi.getter(name="protectFromScaleIn")
    def protect_from_scale_in(self) -> Optional[bool]:
        """
        Indicates that the virtual machine scale set VM shouldn't be considered for deletion during a scale-in operation.
        """
        return pulumi.get(self, "protect_from_scale_in")

    @property
    @pulumi.getter(name="protectFromScaleSetActions")
    def protect_from_scale_set_actions(self) -> Optional[bool]:
        """
        Indicates that model updates or actions (including scale-in) initiated on the virtual machine scale set should not be applied to the virtual machine scale set VM.
        """
        return pulumi.get(self, "protect_from_scale_set_actions")


@pulumi.output_type
class WinRMConfigurationResponse(dict):
    """
    Describes Windows Remote Management configuration of the VM
    """
    def __init__(__self__, *,
                 listeners: Optional[Sequence['outputs.WinRMListenerResponse']] = None):
        """
        Describes Windows Remote Management configuration of the VM
        :param Sequence['WinRMListenerResponse'] listeners: The list of Windows Remote Management listeners
        """
        if listeners is not None:
            pulumi.set(__self__, "listeners", listeners)

    @property
    @pulumi.getter
    def listeners(self) -> Optional[Sequence['outputs.WinRMListenerResponse']]:
        """
        The list of Windows Remote Management listeners
        """
        return pulumi.get(self, "listeners")


@pulumi.output_type
class WinRMListenerResponse(dict):
    """
    Describes Protocol and thumbprint of Windows Remote Management listener
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "certificateUrl":
            suggest = "certificate_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WinRMListenerResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WinRMListenerResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WinRMListenerResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 certificate_url: Optional[str] = None,
                 protocol: Optional[str] = None):
        """
        Describes Protocol and thumbprint of Windows Remote Management listener
        :param str certificate_url: This is the URL of a certificate that has been uploaded to Key Vault as a secret. For adding a secret to the Key Vault, see [Add a key or secret to the key vault](https://docs.microsoft.com/azure/key-vault/key-vault-get-started/#add). In this case, your certificate needs to be It is the Base64 encoding of the following JSON Object which is encoded in UTF-8: <br><br> {<br>  "data":"<Base64-encoded-certificate>",<br>  "dataType":"pfx",<br>  "password":"<pfx-file-password>"<br>}
        :param str protocol: Specifies the protocol of WinRM listener. <br><br> Possible values are: <br>**http** <br><br> **https**
        """
        if certificate_url is not None:
            pulumi.set(__self__, "certificate_url", certificate_url)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)

    @property
    @pulumi.getter(name="certificateUrl")
    def certificate_url(self) -> Optional[str]:
        """
        This is the URL of a certificate that has been uploaded to Key Vault as a secret. For adding a secret to the Key Vault, see [Add a key or secret to the key vault](https://docs.microsoft.com/azure/key-vault/key-vault-get-started/#add). In this case, your certificate needs to be It is the Base64 encoding of the following JSON Object which is encoded in UTF-8: <br><br> {<br>  "data":"<Base64-encoded-certificate>",<br>  "dataType":"pfx",<br>  "password":"<pfx-file-password>"<br>}
        """
        return pulumi.get(self, "certificate_url")

    @property
    @pulumi.getter
    def protocol(self) -> Optional[str]:
        """
        Specifies the protocol of WinRM listener. <br><br> Possible values are: <br>**http** <br><br> **https**
        """
        return pulumi.get(self, "protocol")


@pulumi.output_type
class WindowsConfigurationResponse(dict):
    """
    Specifies Windows operating system settings on the virtual machine.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "additionalUnattendContent":
            suggest = "additional_unattend_content"
        elif key == "enableAutomaticUpdates":
            suggest = "enable_automatic_updates"
        elif key == "patchSettings":
            suggest = "patch_settings"
        elif key == "provisionVMAgent":
            suggest = "provision_vm_agent"
        elif key == "timeZone":
            suggest = "time_zone"
        elif key == "winRM":
            suggest = "win_rm"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WindowsConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WindowsConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WindowsConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 additional_unattend_content: Optional[Sequence['outputs.AdditionalUnattendContentResponse']] = None,
                 enable_automatic_updates: Optional[bool] = None,
                 patch_settings: Optional['outputs.PatchSettingsResponse'] = None,
                 provision_vm_agent: Optional[bool] = None,
                 time_zone: Optional[str] = None,
                 win_rm: Optional['outputs.WinRMConfigurationResponse'] = None):
        """
        Specifies Windows operating system settings on the virtual machine.
        :param Sequence['AdditionalUnattendContentResponse'] additional_unattend_content: Specifies additional base-64 encoded XML formatted information that can be included in the Unattend.xml file, which is used by Windows Setup.
        :param bool enable_automatic_updates: Indicates whether Automatic Updates is enabled for the Windows virtual machine. Default value is true. <br><br> For virtual machine scale sets, this property can be updated and updates will take effect on OS reprovisioning.
        :param 'PatchSettingsResponse' patch_settings: Specifies settings related to in-guest patching (KBs).
        :param bool provision_vm_agent: Indicates whether virtual machine agent should be provisioned on the virtual machine. <br><br> When this property is not specified in the request body, default behavior is to set it to true.  This will ensure that VM Agent is installed on the VM so that extensions can be added to the VM later.
        :param str time_zone: Specifies the time zone of the virtual machine. e.g. "Pacific Standard Time". <br><br> Possible values can be [TimeZoneInfo.Id](https://docs.microsoft.com/en-us/dotnet/api/system.timezoneinfo.id?#System_TimeZoneInfo_Id) value from time zones returned by [TimeZoneInfo.GetSystemTimeZones](https://docs.microsoft.com/en-us/dotnet/api/system.timezoneinfo.getsystemtimezones).
        :param 'WinRMConfigurationResponse' win_rm: Specifies the Windows Remote Management listeners. This enables remote Windows PowerShell.
        """
        if additional_unattend_content is not None:
            pulumi.set(__self__, "additional_unattend_content", additional_unattend_content)
        if enable_automatic_updates is not None:
            pulumi.set(__self__, "enable_automatic_updates", enable_automatic_updates)
        if patch_settings is not None:
            pulumi.set(__self__, "patch_settings", patch_settings)
        if provision_vm_agent is not None:
            pulumi.set(__self__, "provision_vm_agent", provision_vm_agent)
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)
        if win_rm is not None:
            pulumi.set(__self__, "win_rm", win_rm)

    @property
    @pulumi.getter(name="additionalUnattendContent")
    def additional_unattend_content(self) -> Optional[Sequence['outputs.AdditionalUnattendContentResponse']]:
        """
        Specifies additional base-64 encoded XML formatted information that can be included in the Unattend.xml file, which is used by Windows Setup.
        """
        return pulumi.get(self, "additional_unattend_content")

    @property
    @pulumi.getter(name="enableAutomaticUpdates")
    def enable_automatic_updates(self) -> Optional[bool]:
        """
        Indicates whether Automatic Updates is enabled for the Windows virtual machine. Default value is true. <br><br> For virtual machine scale sets, this property can be updated and updates will take effect on OS reprovisioning.
        """
        return pulumi.get(self, "enable_automatic_updates")

    @property
    @pulumi.getter(name="patchSettings")
    def patch_settings(self) -> Optional['outputs.PatchSettingsResponse']:
        """
        Specifies settings related to in-guest patching (KBs).
        """
        return pulumi.get(self, "patch_settings")

    @property
    @pulumi.getter(name="provisionVMAgent")
    def provision_vm_agent(self) -> Optional[bool]:
        """
        Indicates whether virtual machine agent should be provisioned on the virtual machine. <br><br> When this property is not specified in the request body, default behavior is to set it to true.  This will ensure that VM Agent is installed on the VM so that extensions can be added to the VM later.
        """
        return pulumi.get(self, "provision_vm_agent")

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[str]:
        """
        Specifies the time zone of the virtual machine. e.g. "Pacific Standard Time". <br><br> Possible values can be [TimeZoneInfo.Id](https://docs.microsoft.com/en-us/dotnet/api/system.timezoneinfo.id?#System_TimeZoneInfo_Id) value from time zones returned by [TimeZoneInfo.GetSystemTimeZones](https://docs.microsoft.com/en-us/dotnet/api/system.timezoneinfo.getsystemtimezones).
        """
        return pulumi.get(self, "time_zone")

    @property
    @pulumi.getter(name="winRM")
    def win_rm(self) -> Optional['outputs.WinRMConfigurationResponse']:
        """
        Specifies the Windows Remote Management listeners. This enables remote Windows PowerShell.
        """
        return pulumi.get(self, "win_rm")


