# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetForwardingRuleResult',
    'AwaitableGetForwardingRuleResult',
    'get_forwarding_rule',
    'get_forwarding_rule_output',
]

@pulumi.output_type
class GetForwardingRuleResult:
    """
    Describes a forwarding rule within a DNS forwarding ruleset.
    """
    def __init__(__self__, domain_name=None, etag=None, forwarding_rule_state=None, id=None, metadata=None, name=None, provisioning_state=None, system_data=None, target_dns_servers=None, type=None):
        if domain_name and not isinstance(domain_name, str):
            raise TypeError("Expected argument 'domain_name' to be a str")
        pulumi.set(__self__, "domain_name", domain_name)
        if etag and not isinstance(etag, str):
            raise TypeError("Expected argument 'etag' to be a str")
        pulumi.set(__self__, "etag", etag)
        if forwarding_rule_state and not isinstance(forwarding_rule_state, str):
            raise TypeError("Expected argument 'forwarding_rule_state' to be a str")
        pulumi.set(__self__, "forwarding_rule_state", forwarding_rule_state)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if metadata and not isinstance(metadata, dict):
            raise TypeError("Expected argument 'metadata' to be a dict")
        pulumi.set(__self__, "metadata", metadata)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if provisioning_state and not isinstance(provisioning_state, str):
            raise TypeError("Expected argument 'provisioning_state' to be a str")
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if system_data and not isinstance(system_data, dict):
            raise TypeError("Expected argument 'system_data' to be a dict")
        pulumi.set(__self__, "system_data", system_data)
        if target_dns_servers and not isinstance(target_dns_servers, list):
            raise TypeError("Expected argument 'target_dns_servers' to be a list")
        pulumi.set(__self__, "target_dns_servers", target_dns_servers)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> str:
        """
        The domain name for the forwarding rule.
        """
        return pulumi.get(self, "domain_name")

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        ETag of the forwarding rule.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="forwardingRuleState")
    def forwarding_rule_state(self) -> Optional[str]:
        """
        The state of forwarding rule.
        """
        return pulumi.get(self, "forwarding_rule_state")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def metadata(self) -> Optional[Mapping[str, str]]:
        """
        Metadata attached to the forwarding rule.
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The current provisioning state of the forwarding rule. This is a read-only property and any attempt to set this value will be ignored.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="systemData")
    def system_data(self) -> 'outputs.SystemDataResponse':
        """
        Metadata pertaining to creation and last modification of the resource.
        """
        return pulumi.get(self, "system_data")

    @property
    @pulumi.getter(name="targetDnsServers")
    def target_dns_servers(self) -> Sequence['outputs.TargetDnsServerResponse']:
        """
        DNS servers to forward the DNS query to.
        """
        return pulumi.get(self, "target_dns_servers")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
        """
        return pulumi.get(self, "type")


class AwaitableGetForwardingRuleResult(GetForwardingRuleResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetForwardingRuleResult(
            domain_name=self.domain_name,
            etag=self.etag,
            forwarding_rule_state=self.forwarding_rule_state,
            id=self.id,
            metadata=self.metadata,
            name=self.name,
            provisioning_state=self.provisioning_state,
            system_data=self.system_data,
            target_dns_servers=self.target_dns_servers,
            type=self.type)


def get_forwarding_rule(dns_forwarding_ruleset_name: Optional[str] = None,
                        forwarding_rule_name: Optional[str] = None,
                        resource_group_name: Optional[str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetForwardingRuleResult:
    """
    Describes a forwarding rule within a DNS forwarding ruleset.
    API Version: 2020-04-01-preview.


    :param str dns_forwarding_ruleset_name: The name of the DNS forwarding ruleset.
    :param str forwarding_rule_name: The name of the forwarding rule.
    :param str resource_group_name: The name of the resource group. The name is case insensitive.
    """
    __args__ = dict()
    __args__['dnsForwardingRulesetName'] = dns_forwarding_ruleset_name
    __args__['forwardingRuleName'] = forwarding_rule_name
    __args__['resourceGroupName'] = resource_group_name
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('azure-native:network:getForwardingRule', __args__, opts=opts, typ=GetForwardingRuleResult).value

    return AwaitableGetForwardingRuleResult(
        domain_name=__ret__.domain_name,
        etag=__ret__.etag,
        forwarding_rule_state=__ret__.forwarding_rule_state,
        id=__ret__.id,
        metadata=__ret__.metadata,
        name=__ret__.name,
        provisioning_state=__ret__.provisioning_state,
        system_data=__ret__.system_data,
        target_dns_servers=__ret__.target_dns_servers,
        type=__ret__.type)


@_utilities.lift_output_func(get_forwarding_rule)
def get_forwarding_rule_output(dns_forwarding_ruleset_name: Optional[pulumi.Input[str]] = None,
                               forwarding_rule_name: Optional[pulumi.Input[str]] = None,
                               resource_group_name: Optional[pulumi.Input[str]] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetForwardingRuleResult]:
    """
    Describes a forwarding rule within a DNS forwarding ruleset.
    API Version: 2020-04-01-preview.


    :param str dns_forwarding_ruleset_name: The name of the DNS forwarding ruleset.
    :param str forwarding_rule_name: The name of the forwarding rule.
    :param str resource_group_name: The name of the resource group. The name is case insensitive.
    """
    ...
