# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'ArtifactDeploymentStatusPropertiesResponse',
    'ArtifactInstallPropertiesResponse',
    'ArtifactParameterPropertiesResponse',
    'CustomImagePropertiesCustomResponse',
    'CustomImagePropertiesFromVmResponse',
    'DayDetailsResponse',
    'FormulaPropertiesFromVmResponse',
    'GalleryImageReferenceResponse',
    'HourDetailsResponse',
    'LabVhdResponse',
    'LabVirtualMachineResponse',
    'LinuxOsInfoResponse',
    'SubnetOverrideResponse',
    'SubnetResponse',
    'WeekDetailsResponse',
    'WindowsOsInfoResponse',
]

@pulumi.output_type
class ArtifactDeploymentStatusPropertiesResponse(dict):
    """
    Properties of an artifact deployment.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "artifactsApplied":
            suggest = "artifacts_applied"
        elif key == "deploymentStatus":
            suggest = "deployment_status"
        elif key == "totalArtifacts":
            suggest = "total_artifacts"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ArtifactDeploymentStatusPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ArtifactDeploymentStatusPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ArtifactDeploymentStatusPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 artifacts_applied: Optional[int] = None,
                 deployment_status: Optional[str] = None,
                 total_artifacts: Optional[int] = None):
        """
        Properties of an artifact deployment.
        :param int artifacts_applied: The total count of the artifacts that were successfully applied.
        :param str deployment_status: The deployment status of the artifact.
        :param int total_artifacts: The total count of the artifacts that were tentatively applied.
        """
        if artifacts_applied is not None:
            pulumi.set(__self__, "artifacts_applied", artifacts_applied)
        if deployment_status is not None:
            pulumi.set(__self__, "deployment_status", deployment_status)
        if total_artifacts is not None:
            pulumi.set(__self__, "total_artifacts", total_artifacts)

    @property
    @pulumi.getter(name="artifactsApplied")
    def artifacts_applied(self) -> Optional[int]:
        """
        The total count of the artifacts that were successfully applied.
        """
        return pulumi.get(self, "artifacts_applied")

    @property
    @pulumi.getter(name="deploymentStatus")
    def deployment_status(self) -> Optional[str]:
        """
        The deployment status of the artifact.
        """
        return pulumi.get(self, "deployment_status")

    @property
    @pulumi.getter(name="totalArtifacts")
    def total_artifacts(self) -> Optional[int]:
        """
        The total count of the artifacts that were tentatively applied.
        """
        return pulumi.get(self, "total_artifacts")


@pulumi.output_type
class ArtifactInstallPropertiesResponse(dict):
    """
    Properties of an artifact.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "artifactId":
            suggest = "artifact_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ArtifactInstallPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ArtifactInstallPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ArtifactInstallPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 artifact_id: Optional[str] = None,
                 parameters: Optional[Sequence['outputs.ArtifactParameterPropertiesResponse']] = None):
        """
        Properties of an artifact.
        :param str artifact_id: The artifact's identifier.
        :param Sequence['ArtifactParameterPropertiesResponse'] parameters: The parameters of the artifact.
        """
        if artifact_id is not None:
            pulumi.set(__self__, "artifact_id", artifact_id)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter(name="artifactId")
    def artifact_id(self) -> Optional[str]:
        """
        The artifact's identifier.
        """
        return pulumi.get(self, "artifact_id")

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Sequence['outputs.ArtifactParameterPropertiesResponse']]:
        """
        The parameters of the artifact.
        """
        return pulumi.get(self, "parameters")


@pulumi.output_type
class ArtifactParameterPropertiesResponse(dict):
    """
    Properties of an artifact parameter.
    """
    def __init__(__self__, *,
                 name: Optional[str] = None,
                 value: Optional[str] = None):
        """
        Properties of an artifact parameter.
        :param str name: The name of the artifact parameter.
        :param str value: The value of the artifact parameter.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the artifact parameter.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        The value of the artifact parameter.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class CustomImagePropertiesCustomResponse(dict):
    """
    Properties for creating a custom image from a VHD.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "imageName":
            suggest = "image_name"
        elif key == "sysPrep":
            suggest = "sys_prep"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CustomImagePropertiesCustomResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CustomImagePropertiesCustomResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CustomImagePropertiesCustomResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 image_name: Optional[str] = None,
                 sys_prep: Optional[bool] = None):
        """
        Properties for creating a custom image from a VHD.
        :param str image_name: The image name.
        :param bool sys_prep: Indicates whether sysprep has been run on the VHD.
        """
        if image_name is not None:
            pulumi.set(__self__, "image_name", image_name)
        if sys_prep is not None:
            pulumi.set(__self__, "sys_prep", sys_prep)

    @property
    @pulumi.getter(name="imageName")
    def image_name(self) -> Optional[str]:
        """
        The image name.
        """
        return pulumi.get(self, "image_name")

    @property
    @pulumi.getter(name="sysPrep")
    def sys_prep(self) -> Optional[bool]:
        """
        Indicates whether sysprep has been run on the VHD.
        """
        return pulumi.get(self, "sys_prep")


@pulumi.output_type
class CustomImagePropertiesFromVmResponse(dict):
    """
    Properties for creating a custom image from a virtual machine.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "linuxOsInfo":
            suggest = "linux_os_info"
        elif key == "sourceVmId":
            suggest = "source_vm_id"
        elif key == "sysPrep":
            suggest = "sys_prep"
        elif key == "windowsOsInfo":
            suggest = "windows_os_info"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CustomImagePropertiesFromVmResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CustomImagePropertiesFromVmResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CustomImagePropertiesFromVmResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 linux_os_info: Optional['outputs.LinuxOsInfoResponse'] = None,
                 source_vm_id: Optional[str] = None,
                 sys_prep: Optional[bool] = None,
                 windows_os_info: Optional['outputs.WindowsOsInfoResponse'] = None):
        """
        Properties for creating a custom image from a virtual machine.
        :param 'LinuxOsInfoResponse' linux_os_info: The Linux OS information of the VM.
        :param str source_vm_id: The source vm identifier.
        :param bool sys_prep: Indicates whether sysprep has been run on the VHD.
        :param 'WindowsOsInfoResponse' windows_os_info: The Windows OS information of the VM.
        """
        if linux_os_info is not None:
            pulumi.set(__self__, "linux_os_info", linux_os_info)
        if source_vm_id is not None:
            pulumi.set(__self__, "source_vm_id", source_vm_id)
        if sys_prep is not None:
            pulumi.set(__self__, "sys_prep", sys_prep)
        if windows_os_info is not None:
            pulumi.set(__self__, "windows_os_info", windows_os_info)

    @property
    @pulumi.getter(name="linuxOsInfo")
    def linux_os_info(self) -> Optional['outputs.LinuxOsInfoResponse']:
        """
        The Linux OS information of the VM.
        """
        return pulumi.get(self, "linux_os_info")

    @property
    @pulumi.getter(name="sourceVmId")
    def source_vm_id(self) -> Optional[str]:
        """
        The source vm identifier.
        """
        return pulumi.get(self, "source_vm_id")

    @property
    @pulumi.getter(name="sysPrep")
    def sys_prep(self) -> Optional[bool]:
        """
        Indicates whether sysprep has been run on the VHD.
        """
        return pulumi.get(self, "sys_prep")

    @property
    @pulumi.getter(name="windowsOsInfo")
    def windows_os_info(self) -> Optional['outputs.WindowsOsInfoResponse']:
        """
        The Windows OS information of the VM.
        """
        return pulumi.get(self, "windows_os_info")


@pulumi.output_type
class DayDetailsResponse(dict):
    """
    Properties of a daily schedule.
    """
    def __init__(__self__, *,
                 time: Optional[str] = None):
        """
        Properties of a daily schedule.
        """
        if time is not None:
            pulumi.set(__self__, "time", time)

    @property
    @pulumi.getter
    def time(self) -> Optional[str]:
        return pulumi.get(self, "time")


@pulumi.output_type
class FormulaPropertiesFromVmResponse(dict):
    """
    Information about a VM from which a formula is to be created.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "labVmId":
            suggest = "lab_vm_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FormulaPropertiesFromVmResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FormulaPropertiesFromVmResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FormulaPropertiesFromVmResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 lab_vm_id: Optional[str] = None):
        """
        Information about a VM from which a formula is to be created.
        :param str lab_vm_id: The identifier of the VM from which a formula is to be created.
        """
        if lab_vm_id is not None:
            pulumi.set(__self__, "lab_vm_id", lab_vm_id)

    @property
    @pulumi.getter(name="labVmId")
    def lab_vm_id(self) -> Optional[str]:
        """
        The identifier of the VM from which a formula is to be created.
        """
        return pulumi.get(self, "lab_vm_id")


@pulumi.output_type
class GalleryImageReferenceResponse(dict):
    """
    The reference information for an Azure Marketplace image.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "osType":
            suggest = "os_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GalleryImageReferenceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GalleryImageReferenceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GalleryImageReferenceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 offer: Optional[str] = None,
                 os_type: Optional[str] = None,
                 publisher: Optional[str] = None,
                 sku: Optional[str] = None,
                 version: Optional[str] = None):
        """
        The reference information for an Azure Marketplace image.
        :param str offer: The offer of the gallery image.
        :param str os_type: The OS type of the gallery image.
        :param str publisher: The publisher of the gallery image.
        :param str sku: The SKU of the gallery image.
        :param str version: The version of the gallery image.
        """
        if offer is not None:
            pulumi.set(__self__, "offer", offer)
        if os_type is not None:
            pulumi.set(__self__, "os_type", os_type)
        if publisher is not None:
            pulumi.set(__self__, "publisher", publisher)
        if sku is not None:
            pulumi.set(__self__, "sku", sku)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def offer(self) -> Optional[str]:
        """
        The offer of the gallery image.
        """
        return pulumi.get(self, "offer")

    @property
    @pulumi.getter(name="osType")
    def os_type(self) -> Optional[str]:
        """
        The OS type of the gallery image.
        """
        return pulumi.get(self, "os_type")

    @property
    @pulumi.getter
    def publisher(self) -> Optional[str]:
        """
        The publisher of the gallery image.
        """
        return pulumi.get(self, "publisher")

    @property
    @pulumi.getter
    def sku(self) -> Optional[str]:
        """
        The SKU of the gallery image.
        """
        return pulumi.get(self, "sku")

    @property
    @pulumi.getter
    def version(self) -> Optional[str]:
        """
        The version of the gallery image.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class HourDetailsResponse(dict):
    """
    Properties of an hourly schedule.
    """
    def __init__(__self__, *,
                 minute: Optional[int] = None):
        """
        Properties of an hourly schedule.
        :param int minute: Minutes of the hour the schedule will run.
        """
        if minute is not None:
            pulumi.set(__self__, "minute", minute)

    @property
    @pulumi.getter
    def minute(self) -> Optional[int]:
        """
        Minutes of the hour the schedule will run.
        """
        return pulumi.get(self, "minute")


@pulumi.output_type
class LabVhdResponse(dict):
    """
    Properties of a VHD in the lab.
    """
    def __init__(__self__, *,
                 id: Optional[str] = None):
        """
        Properties of a VHD in the lab.
        :param str id: The absolute URI of the VHD.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The absolute URI of the VHD.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class LabVirtualMachineResponse(dict):
    """
    A virtual machine.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "artifactDeploymentStatus":
            suggest = "artifact_deployment_status"
        elif key == "computeId":
            suggest = "compute_id"
        elif key == "createdByUser":
            suggest = "created_by_user"
        elif key == "createdByUserId":
            suggest = "created_by_user_id"
        elif key == "customImageId":
            suggest = "custom_image_id"
        elif key == "disallowPublicIpAddress":
            suggest = "disallow_public_ip_address"
        elif key == "galleryImageReference":
            suggest = "gallery_image_reference"
        elif key == "isAuthenticationWithSshKey":
            suggest = "is_authentication_with_ssh_key"
        elif key == "labSubnetName":
            suggest = "lab_subnet_name"
        elif key == "labVirtualNetworkId":
            suggest = "lab_virtual_network_id"
        elif key == "osType":
            suggest = "os_type"
        elif key == "ownerObjectId":
            suggest = "owner_object_id"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "sshKey":
            suggest = "ssh_key"
        elif key == "userName":
            suggest = "user_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LabVirtualMachineResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LabVirtualMachineResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LabVirtualMachineResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 artifact_deployment_status: Optional['outputs.ArtifactDeploymentStatusPropertiesResponse'] = None,
                 artifacts: Optional[Sequence['outputs.ArtifactInstallPropertiesResponse']] = None,
                 compute_id: Optional[str] = None,
                 created_by_user: Optional[str] = None,
                 created_by_user_id: Optional[str] = None,
                 custom_image_id: Optional[str] = None,
                 disallow_public_ip_address: Optional[bool] = None,
                 fqdn: Optional[str] = None,
                 gallery_image_reference: Optional['outputs.GalleryImageReferenceResponse'] = None,
                 id: Optional[str] = None,
                 is_authentication_with_ssh_key: Optional[bool] = None,
                 lab_subnet_name: Optional[str] = None,
                 lab_virtual_network_id: Optional[str] = None,
                 location: Optional[str] = None,
                 name: Optional[str] = None,
                 notes: Optional[str] = None,
                 os_type: Optional[str] = None,
                 owner_object_id: Optional[str] = None,
                 password: Optional[str] = None,
                 provisioning_state: Optional[str] = None,
                 size: Optional[str] = None,
                 ssh_key: Optional[str] = None,
                 tags: Optional[Mapping[str, str]] = None,
                 type: Optional[str] = None,
                 user_name: Optional[str] = None):
        """
        A virtual machine.
        :param 'ArtifactDeploymentStatusPropertiesResponse' artifact_deployment_status: The artifact deployment status for the virtual machine.
        :param Sequence['ArtifactInstallPropertiesResponse'] artifacts: The artifacts to be installed on the virtual machine.
        :param str compute_id: The resource identifier (Microsoft.Compute) of the virtual machine.
        :param str created_by_user: The email address of creator of the virtual machine.
        :param str created_by_user_id: The object identifier of the creator of the virtual machine.
        :param str custom_image_id: The custom image identifier of the virtual machine.
        :param bool disallow_public_ip_address: Indicates whether the virtual machine is to be created without a public IP address.
        :param str fqdn: The fully-qualified domain name of the virtual machine.
        :param 'GalleryImageReferenceResponse' gallery_image_reference: The Microsoft Azure Marketplace image reference of the virtual machine.
        :param str id: The identifier of the resource.
        :param bool is_authentication_with_ssh_key: A value indicating whether this virtual machine uses an SSH key for authentication.
        :param str lab_subnet_name: The lab subnet name of the virtual machine.
        :param str lab_virtual_network_id: The lab virtual network identifier of the virtual machine.
        :param str location: The location of the resource.
        :param str name: The name of the resource.
        :param str notes: The notes of the virtual machine.
        :param str os_type: The OS type of the virtual machine.
        :param str owner_object_id: The object identifier of the owner of the virtual machine.
        :param str password: The password of the virtual machine administrator.
        :param str provisioning_state: The provisioning status of the resource.
        :param str size: The size of the virtual machine.
        :param str ssh_key: The SSH key of the virtual machine administrator.
        :param Mapping[str, str] tags: The tags of the resource.
        :param str type: The type of the resource.
        :param str user_name: The user name of the virtual machine.
        """
        if artifact_deployment_status is not None:
            pulumi.set(__self__, "artifact_deployment_status", artifact_deployment_status)
        if artifacts is not None:
            pulumi.set(__self__, "artifacts", artifacts)
        if compute_id is not None:
            pulumi.set(__self__, "compute_id", compute_id)
        if created_by_user is not None:
            pulumi.set(__self__, "created_by_user", created_by_user)
        if created_by_user_id is not None:
            pulumi.set(__self__, "created_by_user_id", created_by_user_id)
        if custom_image_id is not None:
            pulumi.set(__self__, "custom_image_id", custom_image_id)
        if disallow_public_ip_address is not None:
            pulumi.set(__self__, "disallow_public_ip_address", disallow_public_ip_address)
        if fqdn is not None:
            pulumi.set(__self__, "fqdn", fqdn)
        if gallery_image_reference is not None:
            pulumi.set(__self__, "gallery_image_reference", gallery_image_reference)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if is_authentication_with_ssh_key is not None:
            pulumi.set(__self__, "is_authentication_with_ssh_key", is_authentication_with_ssh_key)
        if lab_subnet_name is not None:
            pulumi.set(__self__, "lab_subnet_name", lab_subnet_name)
        if lab_virtual_network_id is not None:
            pulumi.set(__self__, "lab_virtual_network_id", lab_virtual_network_id)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if notes is not None:
            pulumi.set(__self__, "notes", notes)
        if os_type is not None:
            pulumi.set(__self__, "os_type", os_type)
        if owner_object_id is not None:
            pulumi.set(__self__, "owner_object_id", owner_object_id)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if provisioning_state is not None:
            pulumi.set(__self__, "provisioning_state", provisioning_state)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if ssh_key is not None:
            pulumi.set(__self__, "ssh_key", ssh_key)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if user_name is not None:
            pulumi.set(__self__, "user_name", user_name)

    @property
    @pulumi.getter(name="artifactDeploymentStatus")
    def artifact_deployment_status(self) -> Optional['outputs.ArtifactDeploymentStatusPropertiesResponse']:
        """
        The artifact deployment status for the virtual machine.
        """
        return pulumi.get(self, "artifact_deployment_status")

    @property
    @pulumi.getter
    def artifacts(self) -> Optional[Sequence['outputs.ArtifactInstallPropertiesResponse']]:
        """
        The artifacts to be installed on the virtual machine.
        """
        return pulumi.get(self, "artifacts")

    @property
    @pulumi.getter(name="computeId")
    def compute_id(self) -> Optional[str]:
        """
        The resource identifier (Microsoft.Compute) of the virtual machine.
        """
        return pulumi.get(self, "compute_id")

    @property
    @pulumi.getter(name="createdByUser")
    def created_by_user(self) -> Optional[str]:
        """
        The email address of creator of the virtual machine.
        """
        return pulumi.get(self, "created_by_user")

    @property
    @pulumi.getter(name="createdByUserId")
    def created_by_user_id(self) -> Optional[str]:
        """
        The object identifier of the creator of the virtual machine.
        """
        return pulumi.get(self, "created_by_user_id")

    @property
    @pulumi.getter(name="customImageId")
    def custom_image_id(self) -> Optional[str]:
        """
        The custom image identifier of the virtual machine.
        """
        return pulumi.get(self, "custom_image_id")

    @property
    @pulumi.getter(name="disallowPublicIpAddress")
    def disallow_public_ip_address(self) -> Optional[bool]:
        """
        Indicates whether the virtual machine is to be created without a public IP address.
        """
        return pulumi.get(self, "disallow_public_ip_address")

    @property
    @pulumi.getter
    def fqdn(self) -> Optional[str]:
        """
        The fully-qualified domain name of the virtual machine.
        """
        return pulumi.get(self, "fqdn")

    @property
    @pulumi.getter(name="galleryImageReference")
    def gallery_image_reference(self) -> Optional['outputs.GalleryImageReferenceResponse']:
        """
        The Microsoft Azure Marketplace image reference of the virtual machine.
        """
        return pulumi.get(self, "gallery_image_reference")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The identifier of the resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isAuthenticationWithSshKey")
    def is_authentication_with_ssh_key(self) -> Optional[bool]:
        """
        A value indicating whether this virtual machine uses an SSH key for authentication.
        """
        return pulumi.get(self, "is_authentication_with_ssh_key")

    @property
    @pulumi.getter(name="labSubnetName")
    def lab_subnet_name(self) -> Optional[str]:
        """
        The lab subnet name of the virtual machine.
        """
        return pulumi.get(self, "lab_subnet_name")

    @property
    @pulumi.getter(name="labVirtualNetworkId")
    def lab_virtual_network_id(self) -> Optional[str]:
        """
        The lab virtual network identifier of the virtual machine.
        """
        return pulumi.get(self, "lab_virtual_network_id")

    @property
    @pulumi.getter
    def location(self) -> Optional[str]:
        """
        The location of the resource.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def notes(self) -> Optional[str]:
        """
        The notes of the virtual machine.
        """
        return pulumi.get(self, "notes")

    @property
    @pulumi.getter(name="osType")
    def os_type(self) -> Optional[str]:
        """
        The OS type of the virtual machine.
        """
        return pulumi.get(self, "os_type")

    @property
    @pulumi.getter(name="ownerObjectId")
    def owner_object_id(self) -> Optional[str]:
        """
        The object identifier of the owner of the virtual machine.
        """
        return pulumi.get(self, "owner_object_id")

    @property
    @pulumi.getter
    def password(self) -> Optional[str]:
        """
        The password of the virtual machine administrator.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> Optional[str]:
        """
        The provisioning status of the resource.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def size(self) -> Optional[str]:
        """
        The size of the virtual machine.
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter(name="sshKey")
    def ssh_key(self) -> Optional[str]:
        """
        The SSH key of the virtual machine administrator.
        """
        return pulumi.get(self, "ssh_key")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        The tags of the resource.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The type of the resource.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> Optional[str]:
        """
        The user name of the virtual machine.
        """
        return pulumi.get(self, "user_name")


@pulumi.output_type
class LinuxOsInfoResponse(dict):
    """
    Information about a Linux OS.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "linuxOsState":
            suggest = "linux_os_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LinuxOsInfoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LinuxOsInfoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LinuxOsInfoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 linux_os_state: Optional[str] = None):
        """
        Information about a Linux OS.
        :param str linux_os_state: The state of the Linux OS.
        """
        if linux_os_state is not None:
            pulumi.set(__self__, "linux_os_state", linux_os_state)

    @property
    @pulumi.getter(name="linuxOsState")
    def linux_os_state(self) -> Optional[str]:
        """
        The state of the Linux OS.
        """
        return pulumi.get(self, "linux_os_state")


@pulumi.output_type
class SubnetOverrideResponse(dict):
    """
    Property overrides on a subnet of a virtual network.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "labSubnetName":
            suggest = "lab_subnet_name"
        elif key == "resourceId":
            suggest = "resource_id"
        elif key == "useInVmCreationPermission":
            suggest = "use_in_vm_creation_permission"
        elif key == "usePublicIpAddressPermission":
            suggest = "use_public_ip_address_permission"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SubnetOverrideResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SubnetOverrideResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SubnetOverrideResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 lab_subnet_name: Optional[str] = None,
                 resource_id: Optional[str] = None,
                 use_in_vm_creation_permission: Optional[str] = None,
                 use_public_ip_address_permission: Optional[str] = None):
        """
        Property overrides on a subnet of a virtual network.
        :param str lab_subnet_name: The name given to the subnet within the lab.
        :param str resource_id: The resource identifier of the subnet.
        :param str use_in_vm_creation_permission: Indicates whether this subnet can be used during virtual machine creation.
        :param str use_public_ip_address_permission: Indicates whether public IP addresses can be assigned to virtual machines on this subnet.
        """
        if lab_subnet_name is not None:
            pulumi.set(__self__, "lab_subnet_name", lab_subnet_name)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)
        if use_in_vm_creation_permission is not None:
            pulumi.set(__self__, "use_in_vm_creation_permission", use_in_vm_creation_permission)
        if use_public_ip_address_permission is not None:
            pulumi.set(__self__, "use_public_ip_address_permission", use_public_ip_address_permission)

    @property
    @pulumi.getter(name="labSubnetName")
    def lab_subnet_name(self) -> Optional[str]:
        """
        The name given to the subnet within the lab.
        """
        return pulumi.get(self, "lab_subnet_name")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[str]:
        """
        The resource identifier of the subnet.
        """
        return pulumi.get(self, "resource_id")

    @property
    @pulumi.getter(name="useInVmCreationPermission")
    def use_in_vm_creation_permission(self) -> Optional[str]:
        """
        Indicates whether this subnet can be used during virtual machine creation.
        """
        return pulumi.get(self, "use_in_vm_creation_permission")

    @property
    @pulumi.getter(name="usePublicIpAddressPermission")
    def use_public_ip_address_permission(self) -> Optional[str]:
        """
        Indicates whether public IP addresses can be assigned to virtual machines on this subnet.
        """
        return pulumi.get(self, "use_public_ip_address_permission")


@pulumi.output_type
class SubnetResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowPublicIp":
            suggest = "allow_public_ip"
        elif key == "labSubnetName":
            suggest = "lab_subnet_name"
        elif key == "resourceId":
            suggest = "resource_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SubnetResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SubnetResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SubnetResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allow_public_ip: Optional[str] = None,
                 lab_subnet_name: Optional[str] = None,
                 resource_id: Optional[str] = None):
        if allow_public_ip is not None:
            pulumi.set(__self__, "allow_public_ip", allow_public_ip)
        if lab_subnet_name is not None:
            pulumi.set(__self__, "lab_subnet_name", lab_subnet_name)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)

    @property
    @pulumi.getter(name="allowPublicIp")
    def allow_public_ip(self) -> Optional[str]:
        return pulumi.get(self, "allow_public_ip")

    @property
    @pulumi.getter(name="labSubnetName")
    def lab_subnet_name(self) -> Optional[str]:
        return pulumi.get(self, "lab_subnet_name")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[str]:
        return pulumi.get(self, "resource_id")


@pulumi.output_type
class WeekDetailsResponse(dict):
    """
    Properties of a weekly schedule.
    """
    def __init__(__self__, *,
                 time: Optional[str] = None,
                 weekdays: Optional[Sequence[str]] = None):
        """
        Properties of a weekly schedule.
        :param str time: The time of the day.
        :param Sequence[str] weekdays: The days of the week.
        """
        if time is not None:
            pulumi.set(__self__, "time", time)
        if weekdays is not None:
            pulumi.set(__self__, "weekdays", weekdays)

    @property
    @pulumi.getter
    def time(self) -> Optional[str]:
        """
        The time of the day.
        """
        return pulumi.get(self, "time")

    @property
    @pulumi.getter
    def weekdays(self) -> Optional[Sequence[str]]:
        """
        The days of the week.
        """
        return pulumi.get(self, "weekdays")


@pulumi.output_type
class WindowsOsInfoResponse(dict):
    """
    Information about a Windows OS.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "windowsOsState":
            suggest = "windows_os_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WindowsOsInfoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WindowsOsInfoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WindowsOsInfoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 windows_os_state: Optional[str] = None):
        """
        Information about a Windows OS.
        :param str windows_os_state: The state of the Windows OS.
        """
        if windows_os_state is not None:
            pulumi.set(__self__, "windows_os_state", windows_os_state)

    @property
    @pulumi.getter(name="windowsOsState")
    def windows_os_state(self) -> Optional[str]:
        """
        The state of the Windows OS.
        """
        return pulumi.get(self, "windows_os_state")


