# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = ['LabArgs', 'Lab']

@pulumi.input_type
class LabArgs:
    def __init__(__self__, *,
                 resource_group_name: pulumi.Input[str],
                 lab_storage_type: Optional[pulumi.Input[Union[str, 'StorageType']]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 premium_data_disks: Optional[pulumi.Input[Union[str, 'PremiumDataDisk']]] = None,
                 provisioning_state: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 unique_identifier: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Lab resource.
        :param pulumi.Input[str] resource_group_name: The name of the resource group.
        :param pulumi.Input[Union[str, 'StorageType']] lab_storage_type: Type of storage used by the lab. It can be either Premium or Standard. Default is Premium.
        :param pulumi.Input[str] location: The location of the resource.
        :param pulumi.Input[str] name: The name of the lab.
        :param pulumi.Input[Union[str, 'PremiumDataDisk']] premium_data_disks: The setting to enable usage of premium data disks.
               When its value is 'Enabled', creation of standard or premium data disks is allowed.
               When its value is 'Disabled', only creation of standard data disks is allowed.
        :param pulumi.Input[str] provisioning_state: The provisioning status of the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: The tags of the resource.
        :param pulumi.Input[str] unique_identifier: The unique immutable identifier of a resource (Guid).
        """
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if lab_storage_type is not None:
            pulumi.set(__self__, "lab_storage_type", lab_storage_type)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if premium_data_disks is not None:
            pulumi.set(__self__, "premium_data_disks", premium_data_disks)
        if provisioning_state is not None:
            pulumi.set(__self__, "provisioning_state", provisioning_state)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if unique_identifier is not None:
            pulumi.set(__self__, "unique_identifier", unique_identifier)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[str]:
        """
        The name of the resource group.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter(name="labStorageType")
    def lab_storage_type(self) -> Optional[pulumi.Input[Union[str, 'StorageType']]]:
        """
        Type of storage used by the lab. It can be either Premium or Standard. Default is Premium.
        """
        return pulumi.get(self, "lab_storage_type")

    @lab_storage_type.setter
    def lab_storage_type(self, value: Optional[pulumi.Input[Union[str, 'StorageType']]]):
        pulumi.set(self, "lab_storage_type", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        The location of the resource.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the lab.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="premiumDataDisks")
    def premium_data_disks(self) -> Optional[pulumi.Input[Union[str, 'PremiumDataDisk']]]:
        """
        The setting to enable usage of premium data disks.
        When its value is 'Enabled', creation of standard or premium data disks is allowed.
        When its value is 'Disabled', only creation of standard data disks is allowed.
        """
        return pulumi.get(self, "premium_data_disks")

    @premium_data_disks.setter
    def premium_data_disks(self, value: Optional[pulumi.Input[Union[str, 'PremiumDataDisk']]]):
        pulumi.set(self, "premium_data_disks", value)

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> Optional[pulumi.Input[str]]:
        """
        The provisioning status of the resource.
        """
        return pulumi.get(self, "provisioning_state")

    @provisioning_state.setter
    def provisioning_state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "provisioning_state", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The tags of the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="uniqueIdentifier")
    def unique_identifier(self) -> Optional[pulumi.Input[str]]:
        """
        The unique immutable identifier of a resource (Guid).
        """
        return pulumi.get(self, "unique_identifier")

    @unique_identifier.setter
    def unique_identifier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "unique_identifier", value)


warnings.warn("""Version v20160515 will be removed in the next major version of the provider. Upgrade to version v20180915 or later.""", DeprecationWarning)


class Lab(pulumi.CustomResource):
    warnings.warn("""Version v20160515 will be removed in the next major version of the provider. Upgrade to version v20180915 or later.""", DeprecationWarning)

    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 lab_storage_type: Optional[pulumi.Input[Union[str, 'StorageType']]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 premium_data_disks: Optional[pulumi.Input[Union[str, 'PremiumDataDisk']]] = None,
                 provisioning_state: Optional[pulumi.Input[str]] = None,
                 resource_group_name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 unique_identifier: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        A lab.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union[str, 'StorageType']] lab_storage_type: Type of storage used by the lab. It can be either Premium or Standard. Default is Premium.
        :param pulumi.Input[str] location: The location of the resource.
        :param pulumi.Input[str] name: The name of the lab.
        :param pulumi.Input[Union[str, 'PremiumDataDisk']] premium_data_disks: The setting to enable usage of premium data disks.
               When its value is 'Enabled', creation of standard or premium data disks is allowed.
               When its value is 'Disabled', only creation of standard data disks is allowed.
        :param pulumi.Input[str] provisioning_state: The provisioning status of the resource.
        :param pulumi.Input[str] resource_group_name: The name of the resource group.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: The tags of the resource.
        :param pulumi.Input[str] unique_identifier: The unique immutable identifier of a resource (Guid).
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LabArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A lab.

        :param str resource_name: The name of the resource.
        :param LabArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LabArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 lab_storage_type: Optional[pulumi.Input[Union[str, 'StorageType']]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 premium_data_disks: Optional[pulumi.Input[Union[str, 'PremiumDataDisk']]] = None,
                 provisioning_state: Optional[pulumi.Input[str]] = None,
                 resource_group_name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 unique_identifier: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        pulumi.log.warn("""Lab is deprecated: Version v20160515 will be removed in the next major version of the provider. Upgrade to version v20180915 or later.""")
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LabArgs.__new__(LabArgs)

            __props__.__dict__["lab_storage_type"] = lab_storage_type
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            __props__.__dict__["premium_data_disks"] = premium_data_disks
            __props__.__dict__["provisioning_state"] = provisioning_state
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["tags"] = tags
            __props__.__dict__["unique_identifier"] = unique_identifier
            __props__.__dict__["artifacts_storage_account"] = None
            __props__.__dict__["created_date"] = None
            __props__.__dict__["default_premium_storage_account"] = None
            __props__.__dict__["default_storage_account"] = None
            __props__.__dict__["premium_data_disk_storage_account"] = None
            __props__.__dict__["type"] = None
            __props__.__dict__["vault_name"] = None
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="azure-native:devtestlab:Lab"), pulumi.Alias(type_="azure-native:devtestlab/v20150521preview:Lab"), pulumi.Alias(type_="azure-native:devtestlab/v20180915:Lab")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        super(Lab, __self__).__init__(
            'azure-native:devtestlab/v20160515:Lab',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Lab':
        """
        Get an existing Lab resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = LabArgs.__new__(LabArgs)

        __props__.__dict__["artifacts_storage_account"] = None
        __props__.__dict__["created_date"] = None
        __props__.__dict__["default_premium_storage_account"] = None
        __props__.__dict__["default_storage_account"] = None
        __props__.__dict__["lab_storage_type"] = None
        __props__.__dict__["location"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["premium_data_disk_storage_account"] = None
        __props__.__dict__["premium_data_disks"] = None
        __props__.__dict__["provisioning_state"] = None
        __props__.__dict__["tags"] = None
        __props__.__dict__["type"] = None
        __props__.__dict__["unique_identifier"] = None
        __props__.__dict__["vault_name"] = None
        return Lab(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="artifactsStorageAccount")
    def artifacts_storage_account(self) -> pulumi.Output[str]:
        """
        The lab's artifact storage account.
        """
        return pulumi.get(self, "artifacts_storage_account")

    @property
    @pulumi.getter(name="createdDate")
    def created_date(self) -> pulumi.Output[str]:
        """
        The creation date of the lab.
        """
        return pulumi.get(self, "created_date")

    @property
    @pulumi.getter(name="defaultPremiumStorageAccount")
    def default_premium_storage_account(self) -> pulumi.Output[str]:
        """
        The lab's default premium storage account.
        """
        return pulumi.get(self, "default_premium_storage_account")

    @property
    @pulumi.getter(name="defaultStorageAccount")
    def default_storage_account(self) -> pulumi.Output[str]:
        """
        The lab's default storage account.
        """
        return pulumi.get(self, "default_storage_account")

    @property
    @pulumi.getter(name="labStorageType")
    def lab_storage_type(self) -> pulumi.Output[Optional[str]]:
        """
        Type of storage used by the lab. It can be either Premium or Standard. Default is Premium.
        """
        return pulumi.get(self, "lab_storage_type")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[Optional[str]]:
        """
        The location of the resource.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="premiumDataDiskStorageAccount")
    def premium_data_disk_storage_account(self) -> pulumi.Output[str]:
        """
        The lab's premium data disk storage account.
        """
        return pulumi.get(self, "premium_data_disk_storage_account")

    @property
    @pulumi.getter(name="premiumDataDisks")
    def premium_data_disks(self) -> pulumi.Output[Optional[str]]:
        """
        The setting to enable usage of premium data disks.
        When its value is 'Enabled', creation of standard or premium data disks is allowed.
        When its value is 'Disabled', only creation of standard data disks is allowed.
        """
        return pulumi.get(self, "premium_data_disks")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> pulumi.Output[Optional[str]]:
        """
        The provisioning status of the resource.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        The tags of the resource.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        The type of the resource.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="uniqueIdentifier")
    def unique_identifier(self) -> pulumi.Output[Optional[str]]:
        """
        The unique immutable identifier of a resource (Guid).
        """
        return pulumi.get(self, "unique_identifier")

    @property
    @pulumi.getter(name="vaultName")
    def vault_name(self) -> pulumi.Output[str]:
        """
        The lab's Key vault.
        """
        return pulumi.get(self, "vault_name")

