# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'AccessReviewHistoryInstanceResponse',
    'AccessReviewInstanceResponse',
    'AccessReviewReviewerResponse',
    'AccessReviewScopeResponse',
    'IdentityResponse',
    'ManagementLockOwnerResponse',
    'NonComplianceMessageResponse',
    'ParameterDefinitionsValueResponse',
    'ParameterDefinitionsValueResponseMetadata',
    'ParameterValuesValueResponse',
    'PermissionResponse',
    'PolicyAssignmentPropertiesResponse',
    'PolicyAssignmentPropertiesResponsePolicy',
    'PolicyAssignmentPropertiesResponseRoleDefinition',
    'PolicyAssignmentPropertiesResponseScope',
    'PolicyDefinitionGroupResponse',
    'PolicyDefinitionReferenceResponse',
    'PrincipalResponse',
    'PrivateLinkAssociationPropertiesExpandedResponse',
    'ResourceManagementPrivateLinkEndpointConnectionsResponse',
    'SystemDataResponse',
]

@pulumi.output_type
class AccessReviewHistoryInstanceResponse(dict):
    """
    Access Review History Definition Instance.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "downloadUri":
            suggest = "download_uri"
        elif key == "displayName":
            suggest = "display_name"
        elif key == "fulfilledDateTime":
            suggest = "fulfilled_date_time"
        elif key == "reviewHistoryPeriodEndDateTime":
            suggest = "review_history_period_end_date_time"
        elif key == "reviewHistoryPeriodStartDateTime":
            suggest = "review_history_period_start_date_time"
        elif key == "runDateTime":
            suggest = "run_date_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AccessReviewHistoryInstanceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AccessReviewHistoryInstanceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AccessReviewHistoryInstanceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 download_uri: str,
                 id: str,
                 name: str,
                 status: str,
                 type: str,
                 display_name: Optional[str] = None,
                 expiration: Optional[str] = None,
                 fulfilled_date_time: Optional[str] = None,
                 review_history_period_end_date_time: Optional[str] = None,
                 review_history_period_start_date_time: Optional[str] = None,
                 run_date_time: Optional[str] = None):
        """
        Access Review History Definition Instance.
        :param str download_uri: Uri which can be used to retrieve review history data. To generate this Uri, generateDownloadUri() must be called for a specific accessReviewHistoryDefinitionInstance. The link expires after a 24 hour period. Callers can see the expiration date time by looking at the 'se' parameter in the generated uri.
        :param str id: The access review history definition instance id.
        :param str name: The access review history definition instance unique id.
        :param str status: Status of the requested review history instance data. This is either requested, in-progress, done or error. The state transitions are as follows - Requested -> InProgress -> Done -> Expired
        :param str type: The resource type.
        :param str display_name: The display name for the parent history definition.
        :param str expiration: Date time when history data report expires and the associated data is deleted.
        :param str fulfilled_date_time: Date time when the history data report is scheduled to be generated.
        :param str review_history_period_end_date_time: Date time used when selecting review data, all reviews included in data end on or before this date. For use only with one-time/non-recurring reports.
        :param str review_history_period_start_date_time: Date time used when selecting review data, all reviews included in data start on or after this date. For use only with one-time/non-recurring reports.
        :param str run_date_time: Date time when the history data report is scheduled to be generated.
        """
        pulumi.set(__self__, "download_uri", download_uri)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "type", type)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if expiration is not None:
            pulumi.set(__self__, "expiration", expiration)
        if fulfilled_date_time is not None:
            pulumi.set(__self__, "fulfilled_date_time", fulfilled_date_time)
        if review_history_period_end_date_time is not None:
            pulumi.set(__self__, "review_history_period_end_date_time", review_history_period_end_date_time)
        if review_history_period_start_date_time is not None:
            pulumi.set(__self__, "review_history_period_start_date_time", review_history_period_start_date_time)
        if run_date_time is not None:
            pulumi.set(__self__, "run_date_time", run_date_time)

    @property
    @pulumi.getter(name="downloadUri")
    def download_uri(self) -> str:
        """
        Uri which can be used to retrieve review history data. To generate this Uri, generateDownloadUri() must be called for a specific accessReviewHistoryDefinitionInstance. The link expires after a 24 hour period. Callers can see the expiration date time by looking at the 'se' parameter in the generated uri.
        """
        return pulumi.get(self, "download_uri")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The access review history definition instance id.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The access review history definition instance unique id.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Status of the requested review history instance data. This is either requested, in-progress, done or error. The state transitions are as follows - Requested -> InProgress -> Done -> Expired
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The resource type.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        The display name for the parent history definition.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def expiration(self) -> Optional[str]:
        """
        Date time when history data report expires and the associated data is deleted.
        """
        return pulumi.get(self, "expiration")

    @property
    @pulumi.getter(name="fulfilledDateTime")
    def fulfilled_date_time(self) -> Optional[str]:
        """
        Date time when the history data report is scheduled to be generated.
        """
        return pulumi.get(self, "fulfilled_date_time")

    @property
    @pulumi.getter(name="reviewHistoryPeriodEndDateTime")
    def review_history_period_end_date_time(self) -> Optional[str]:
        """
        Date time used when selecting review data, all reviews included in data end on or before this date. For use only with one-time/non-recurring reports.
        """
        return pulumi.get(self, "review_history_period_end_date_time")

    @property
    @pulumi.getter(name="reviewHistoryPeriodStartDateTime")
    def review_history_period_start_date_time(self) -> Optional[str]:
        """
        Date time used when selecting review data, all reviews included in data start on or after this date. For use only with one-time/non-recurring reports.
        """
        return pulumi.get(self, "review_history_period_start_date_time")

    @property
    @pulumi.getter(name="runDateTime")
    def run_date_time(self) -> Optional[str]:
        """
        Date time when the history data report is scheduled to be generated.
        """
        return pulumi.get(self, "run_date_time")


@pulumi.output_type
class AccessReviewInstanceResponse(dict):
    """
    Access Review Instance.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endDateTime":
            suggest = "end_date_time"
        elif key == "startDateTime":
            suggest = "start_date_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AccessReviewInstanceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AccessReviewInstanceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AccessReviewInstanceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: str,
                 name: str,
                 status: str,
                 type: str,
                 end_date_time: Optional[str] = None,
                 start_date_time: Optional[str] = None):
        """
        Access Review Instance.
        :param str id: The access review instance id.
        :param str name: The access review instance name.
        :param str status: This read-only field specifies the status of an access review instance.
        :param str type: The resource type.
        :param str end_date_time: The DateTime when the review instance is scheduled to end.
        :param str start_date_time: The DateTime when the review instance is scheduled to be start.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "type", type)
        if end_date_time is not None:
            pulumi.set(__self__, "end_date_time", end_date_time)
        if start_date_time is not None:
            pulumi.set(__self__, "start_date_time", start_date_time)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The access review instance id.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The access review instance name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        This read-only field specifies the status of an access review instance.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The resource type.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="endDateTime")
    def end_date_time(self) -> Optional[str]:
        """
        The DateTime when the review instance is scheduled to end.
        """
        return pulumi.get(self, "end_date_time")

    @property
    @pulumi.getter(name="startDateTime")
    def start_date_time(self) -> Optional[str]:
        """
        The DateTime when the review instance is scheduled to be start.
        """
        return pulumi.get(self, "start_date_time")


@pulumi.output_type
class AccessReviewReviewerResponse(dict):
    """
    Descriptor for what needs to be reviewed
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "principalType":
            suggest = "principal_type"
        elif key == "principalId":
            suggest = "principal_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AccessReviewReviewerResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AccessReviewReviewerResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AccessReviewReviewerResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 principal_type: str,
                 principal_id: Optional[str] = None):
        """
        Descriptor for what needs to be reviewed
        :param str principal_type: The identity type : user/servicePrincipal
        :param str principal_id: The id of the reviewer(user/servicePrincipal)
        """
        pulumi.set(__self__, "principal_type", principal_type)
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)

    @property
    @pulumi.getter(name="principalType")
    def principal_type(self) -> str:
        """
        The identity type : user/servicePrincipal
        """
        return pulumi.get(self, "principal_type")

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[str]:
        """
        The id of the reviewer(user/servicePrincipal)
        """
        return pulumi.get(self, "principal_id")


@pulumi.output_type
class AccessReviewScopeResponse(dict):
    """
    Descriptor for what needs to be reviewed
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "assignmentState":
            suggest = "assignment_state"
        elif key == "principalType":
            suggest = "principal_type"
        elif key == "resourceId":
            suggest = "resource_id"
        elif key == "roleDefinitionId":
            suggest = "role_definition_id"
        elif key == "expandNestedMemberships":
            suggest = "expand_nested_memberships"
        elif key == "inactiveDuration":
            suggest = "inactive_duration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AccessReviewScopeResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AccessReviewScopeResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AccessReviewScopeResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 assignment_state: str,
                 principal_type: str,
                 resource_id: str,
                 role_definition_id: str,
                 expand_nested_memberships: Optional[bool] = None,
                 inactive_duration: Optional[str] = None):
        """
        Descriptor for what needs to be reviewed
        :param str assignment_state: The role assignment state eligible/active to review
        :param str principal_type: The identity type user/servicePrincipal to review
        :param str resource_id: ResourceId in which this review is getting created
        :param str role_definition_id: This is used to indicate the role being reviewed
        :param bool expand_nested_memberships: Flag to indicate whether to expand nested memberships or not.
        :param str inactive_duration: Duration users are inactive for. The value should be in ISO  8601 format (http://en.wikipedia.org/wiki/ISO_8601#Durations).This code can be used to convert TimeSpan to a valid interval string: XmlConvert.ToString(new TimeSpan(hours, minutes, seconds))
        """
        pulumi.set(__self__, "assignment_state", assignment_state)
        pulumi.set(__self__, "principal_type", principal_type)
        pulumi.set(__self__, "resource_id", resource_id)
        pulumi.set(__self__, "role_definition_id", role_definition_id)
        if expand_nested_memberships is not None:
            pulumi.set(__self__, "expand_nested_memberships", expand_nested_memberships)
        if inactive_duration is not None:
            pulumi.set(__self__, "inactive_duration", inactive_duration)

    @property
    @pulumi.getter(name="assignmentState")
    def assignment_state(self) -> str:
        """
        The role assignment state eligible/active to review
        """
        return pulumi.get(self, "assignment_state")

    @property
    @pulumi.getter(name="principalType")
    def principal_type(self) -> str:
        """
        The identity type user/servicePrincipal to review
        """
        return pulumi.get(self, "principal_type")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> str:
        """
        ResourceId in which this review is getting created
        """
        return pulumi.get(self, "resource_id")

    @property
    @pulumi.getter(name="roleDefinitionId")
    def role_definition_id(self) -> str:
        """
        This is used to indicate the role being reviewed
        """
        return pulumi.get(self, "role_definition_id")

    @property
    @pulumi.getter(name="expandNestedMemberships")
    def expand_nested_memberships(self) -> Optional[bool]:
        """
        Flag to indicate whether to expand nested memberships or not.
        """
        return pulumi.get(self, "expand_nested_memberships")

    @property
    @pulumi.getter(name="inactiveDuration")
    def inactive_duration(self) -> Optional[str]:
        """
        Duration users are inactive for. The value should be in ISO  8601 format (http://en.wikipedia.org/wiki/ISO_8601#Durations).This code can be used to convert TimeSpan to a valid interval string: XmlConvert.ToString(new TimeSpan(hours, minutes, seconds))
        """
        return pulumi.get(self, "inactive_duration")


@pulumi.output_type
class IdentityResponse(dict):
    """
    Identity for the resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "principalId":
            suggest = "principal_id"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IdentityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IdentityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IdentityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 principal_id: str,
                 tenant_id: str,
                 type: Optional[str] = None):
        """
        Identity for the resource.
        :param str principal_id: The principal ID of the resource identity.
        :param str tenant_id: The tenant ID of the resource identity.
        :param str type: The identity type. This is the only required field when adding a system assigned identity to a resource.
        """
        pulumi.set(__self__, "principal_id", principal_id)
        pulumi.set(__self__, "tenant_id", tenant_id)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> str:
        """
        The principal ID of the resource identity.
        """
        return pulumi.get(self, "principal_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> str:
        """
        The tenant ID of the resource identity.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The identity type. This is the only required field when adding a system assigned identity to a resource.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ManagementLockOwnerResponse(dict):
    """
    Lock owner properties.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "applicationId":
            suggest = "application_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagementLockOwnerResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagementLockOwnerResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagementLockOwnerResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 application_id: Optional[str] = None):
        """
        Lock owner properties.
        :param str application_id: The application ID of the lock owner.
        """
        if application_id is not None:
            pulumi.set(__self__, "application_id", application_id)

    @property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> Optional[str]:
        """
        The application ID of the lock owner.
        """
        return pulumi.get(self, "application_id")


@pulumi.output_type
class NonComplianceMessageResponse(dict):
    """
    A message that describes why a resource is non-compliant with the policy. This is shown in 'deny' error messages and on resource's non-compliant compliance results.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "policyDefinitionReferenceId":
            suggest = "policy_definition_reference_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NonComplianceMessageResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NonComplianceMessageResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NonComplianceMessageResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 message: str,
                 policy_definition_reference_id: Optional[str] = None):
        """
        A message that describes why a resource is non-compliant with the policy. This is shown in 'deny' error messages and on resource's non-compliant compliance results.
        :param str message: A message that describes why a resource is non-compliant with the policy. This is shown in 'deny' error messages and on resource's non-compliant compliance results.
        :param str policy_definition_reference_id: The policy definition reference ID within a policy set definition the message is intended for. This is only applicable if the policy assignment assigns a policy set definition. If this is not provided the message applies to all policies assigned by this policy assignment.
        """
        pulumi.set(__self__, "message", message)
        if policy_definition_reference_id is not None:
            pulumi.set(__self__, "policy_definition_reference_id", policy_definition_reference_id)

    @property
    @pulumi.getter
    def message(self) -> str:
        """
        A message that describes why a resource is non-compliant with the policy. This is shown in 'deny' error messages and on resource's non-compliant compliance results.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter(name="policyDefinitionReferenceId")
    def policy_definition_reference_id(self) -> Optional[str]:
        """
        The policy definition reference ID within a policy set definition the message is intended for. This is only applicable if the policy assignment assigns a policy set definition. If this is not provided the message applies to all policies assigned by this policy assignment.
        """
        return pulumi.get(self, "policy_definition_reference_id")


@pulumi.output_type
class ParameterDefinitionsValueResponse(dict):
    """
    The definition of a parameter that can be provided to the policy.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedValues":
            suggest = "allowed_values"
        elif key == "defaultValue":
            suggest = "default_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ParameterDefinitionsValueResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ParameterDefinitionsValueResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ParameterDefinitionsValueResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allowed_values: Optional[Sequence[Any]] = None,
                 default_value: Optional[Any] = None,
                 metadata: Optional['outputs.ParameterDefinitionsValueResponseMetadata'] = None,
                 type: Optional[str] = None):
        """
        The definition of a parameter that can be provided to the policy.
        :param Sequence[Any] allowed_values: The allowed values for the parameter.
        :param Any default_value: The default value for the parameter if no value is provided.
        :param 'ParameterDefinitionsValueResponseMetadata' metadata: General metadata for the parameter.
        :param str type: The data type of the parameter.
        """
        if allowed_values is not None:
            pulumi.set(__self__, "allowed_values", allowed_values)
        if default_value is not None:
            pulumi.set(__self__, "default_value", default_value)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="allowedValues")
    def allowed_values(self) -> Optional[Sequence[Any]]:
        """
        The allowed values for the parameter.
        """
        return pulumi.get(self, "allowed_values")

    @property
    @pulumi.getter(name="defaultValue")
    def default_value(self) -> Optional[Any]:
        """
        The default value for the parameter if no value is provided.
        """
        return pulumi.get(self, "default_value")

    @property
    @pulumi.getter
    def metadata(self) -> Optional['outputs.ParameterDefinitionsValueResponseMetadata']:
        """
        General metadata for the parameter.
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The data type of the parameter.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ParameterDefinitionsValueResponseMetadata(dict):
    """
    General metadata for the parameter.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "assignPermissions":
            suggest = "assign_permissions"
        elif key == "displayName":
            suggest = "display_name"
        elif key == "strongType":
            suggest = "strong_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ParameterDefinitionsValueResponseMetadata. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ParameterDefinitionsValueResponseMetadata.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ParameterDefinitionsValueResponseMetadata.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 assign_permissions: Optional[bool] = None,
                 description: Optional[str] = None,
                 display_name: Optional[str] = None,
                 strong_type: Optional[str] = None):
        """
        General metadata for the parameter.
        :param bool assign_permissions: Set to true to have Azure portal create role assignments on the resource ID or resource scope value of this parameter during policy assignment. This property is useful in case you wish to assign permissions outside the assignment scope.
        :param str description: The description of the parameter.
        :param str display_name: The display name for the parameter.
        :param str strong_type: Used when assigning the policy definition through the portal. Provides a context aware list of values for the user to choose from.
        """
        if assign_permissions is not None:
            pulumi.set(__self__, "assign_permissions", assign_permissions)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if strong_type is not None:
            pulumi.set(__self__, "strong_type", strong_type)

    @property
    @pulumi.getter(name="assignPermissions")
    def assign_permissions(self) -> Optional[bool]:
        """
        Set to true to have Azure portal create role assignments on the resource ID or resource scope value of this parameter during policy assignment. This property is useful in case you wish to assign permissions outside the assignment scope.
        """
        return pulumi.get(self, "assign_permissions")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The description of the parameter.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        The display name for the parameter.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="strongType")
    def strong_type(self) -> Optional[str]:
        """
        Used when assigning the policy definition through the portal. Provides a context aware list of values for the user to choose from.
        """
        return pulumi.get(self, "strong_type")


@pulumi.output_type
class ParameterValuesValueResponse(dict):
    """
    The value of a parameter.
    """
    def __init__(__self__, *,
                 value: Optional[Any] = None):
        """
        The value of a parameter.
        :param Any value: The value of the parameter.
        """
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[Any]:
        """
        The value of the parameter.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class PermissionResponse(dict):
    """
    Role definition permissions.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataActions":
            suggest = "data_actions"
        elif key == "notActions":
            suggest = "not_actions"
        elif key == "notDataActions":
            suggest = "not_data_actions"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PermissionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PermissionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PermissionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 actions: Optional[Sequence[str]] = None,
                 data_actions: Optional[Sequence[str]] = None,
                 not_actions: Optional[Sequence[str]] = None,
                 not_data_actions: Optional[Sequence[str]] = None):
        """
        Role definition permissions.
        :param Sequence[str] actions: Allowed actions.
        :param Sequence[str] data_actions: Allowed Data actions.
        :param Sequence[str] not_actions: Denied actions.
        :param Sequence[str] not_data_actions: Denied Data actions.
        """
        if actions is not None:
            pulumi.set(__self__, "actions", actions)
        if data_actions is not None:
            pulumi.set(__self__, "data_actions", data_actions)
        if not_actions is not None:
            pulumi.set(__self__, "not_actions", not_actions)
        if not_data_actions is not None:
            pulumi.set(__self__, "not_data_actions", not_data_actions)

    @property
    @pulumi.getter
    def actions(self) -> Optional[Sequence[str]]:
        """
        Allowed actions.
        """
        return pulumi.get(self, "actions")

    @property
    @pulumi.getter(name="dataActions")
    def data_actions(self) -> Optional[Sequence[str]]:
        """
        Allowed Data actions.
        """
        return pulumi.get(self, "data_actions")

    @property
    @pulumi.getter(name="notActions")
    def not_actions(self) -> Optional[Sequence[str]]:
        """
        Denied actions.
        """
        return pulumi.get(self, "not_actions")

    @property
    @pulumi.getter(name="notDataActions")
    def not_data_actions(self) -> Optional[Sequence[str]]:
        """
        Denied Data actions.
        """
        return pulumi.get(self, "not_data_actions")


@pulumi.output_type
class PolicyAssignmentPropertiesResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "roleDefinition":
            suggest = "role_definition"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PolicyAssignmentPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PolicyAssignmentPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PolicyAssignmentPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 policy: Optional['outputs.PolicyAssignmentPropertiesResponsePolicy'] = None,
                 role_definition: Optional['outputs.PolicyAssignmentPropertiesResponseRoleDefinition'] = None,
                 scope: Optional['outputs.PolicyAssignmentPropertiesResponseScope'] = None):
        """
        :param 'PolicyAssignmentPropertiesResponsePolicy' policy: Details of the policy
        :param 'PolicyAssignmentPropertiesResponseRoleDefinition' role_definition: Details of role definition
        :param 'PolicyAssignmentPropertiesResponseScope' scope: Details of the resource scope
        """
        if policy is not None:
            pulumi.set(__self__, "policy", policy)
        if role_definition is not None:
            pulumi.set(__self__, "role_definition", role_definition)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)

    @property
    @pulumi.getter
    def policy(self) -> Optional['outputs.PolicyAssignmentPropertiesResponsePolicy']:
        """
        Details of the policy
        """
        return pulumi.get(self, "policy")

    @property
    @pulumi.getter(name="roleDefinition")
    def role_definition(self) -> Optional['outputs.PolicyAssignmentPropertiesResponseRoleDefinition']:
        """
        Details of role definition
        """
        return pulumi.get(self, "role_definition")

    @property
    @pulumi.getter
    def scope(self) -> Optional['outputs.PolicyAssignmentPropertiesResponseScope']:
        """
        Details of the resource scope
        """
        return pulumi.get(self, "scope")


@pulumi.output_type
class PolicyAssignmentPropertiesResponsePolicy(dict):
    """
    Details of the policy
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lastModifiedBy":
            suggest = "last_modified_by"
        elif key == "lastModifiedDateTime":
            suggest = "last_modified_date_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PolicyAssignmentPropertiesResponsePolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PolicyAssignmentPropertiesResponsePolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PolicyAssignmentPropertiesResponsePolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 last_modified_by: 'outputs.PrincipalResponse',
                 id: Optional[str] = None,
                 last_modified_date_time: Optional[str] = None):
        """
        Details of the policy
        :param 'PrincipalResponse' last_modified_by: The name of the entity last modified it
        :param str id: Id of the policy
        :param str last_modified_date_time: The last modified date time.
        """
        pulumi.set(__self__, "last_modified_by", last_modified_by)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if last_modified_date_time is not None:
            pulumi.set(__self__, "last_modified_date_time", last_modified_date_time)

    @property
    @pulumi.getter(name="lastModifiedBy")
    def last_modified_by(self) -> 'outputs.PrincipalResponse':
        """
        The name of the entity last modified it
        """
        return pulumi.get(self, "last_modified_by")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Id of the policy
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lastModifiedDateTime")
    def last_modified_date_time(self) -> Optional[str]:
        """
        The last modified date time.
        """
        return pulumi.get(self, "last_modified_date_time")


@pulumi.output_type
class PolicyAssignmentPropertiesResponseRoleDefinition(dict):
    """
    Details of role definition
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "displayName":
            suggest = "display_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PolicyAssignmentPropertiesResponseRoleDefinition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PolicyAssignmentPropertiesResponseRoleDefinition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PolicyAssignmentPropertiesResponseRoleDefinition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 display_name: Optional[str] = None,
                 id: Optional[str] = None,
                 type: Optional[str] = None):
        """
        Details of role definition
        :param str display_name: Display name of the role definition
        :param str id: Id of the role definition
        :param str type: Type of the role definition
        """
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        Display name of the role definition
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Id of the role definition
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        Type of the role definition
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class PolicyAssignmentPropertiesResponseScope(dict):
    """
    Details of the resource scope
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "displayName":
            suggest = "display_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PolicyAssignmentPropertiesResponseScope. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PolicyAssignmentPropertiesResponseScope.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PolicyAssignmentPropertiesResponseScope.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 display_name: Optional[str] = None,
                 id: Optional[str] = None,
                 type: Optional[str] = None):
        """
        Details of the resource scope
        :param str display_name: Display name of the resource
        :param str id: Scope id of the resource
        :param str type: Type of the resource
        """
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        Display name of the resource
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Scope id of the resource
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        Type of the resource
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class PolicyDefinitionGroupResponse(dict):
    """
    The policy definition group.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "additionalMetadataId":
            suggest = "additional_metadata_id"
        elif key == "displayName":
            suggest = "display_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PolicyDefinitionGroupResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PolicyDefinitionGroupResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PolicyDefinitionGroupResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 additional_metadata_id: Optional[str] = None,
                 category: Optional[str] = None,
                 description: Optional[str] = None,
                 display_name: Optional[str] = None):
        """
        The policy definition group.
        :param str name: The name of the group.
        :param str additional_metadata_id: A resource ID of a resource that contains additional metadata about the group.
        :param str category: The group's category.
        :param str description: The group's description.
        :param str display_name: The group's display name.
        """
        pulumi.set(__self__, "name", name)
        if additional_metadata_id is not None:
            pulumi.set(__self__, "additional_metadata_id", additional_metadata_id)
        if category is not None:
            pulumi.set(__self__, "category", category)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the group.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="additionalMetadataId")
    def additional_metadata_id(self) -> Optional[str]:
        """
        A resource ID of a resource that contains additional metadata about the group.
        """
        return pulumi.get(self, "additional_metadata_id")

    @property
    @pulumi.getter
    def category(self) -> Optional[str]:
        """
        The group's category.
        """
        return pulumi.get(self, "category")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The group's description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        The group's display name.
        """
        return pulumi.get(self, "display_name")


@pulumi.output_type
class PolicyDefinitionReferenceResponse(dict):
    """
    The policy definition reference.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "policyDefinitionId":
            suggest = "policy_definition_id"
        elif key == "groupNames":
            suggest = "group_names"
        elif key == "policyDefinitionReferenceId":
            suggest = "policy_definition_reference_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PolicyDefinitionReferenceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PolicyDefinitionReferenceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PolicyDefinitionReferenceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 policy_definition_id: str,
                 group_names: Optional[Sequence[str]] = None,
                 parameters: Optional[Mapping[str, 'outputs.ParameterValuesValueResponse']] = None,
                 policy_definition_reference_id: Optional[str] = None):
        """
        The policy definition reference.
        :param str policy_definition_id: The ID of the policy definition or policy set definition.
        :param Sequence[str] group_names: The name of the groups that this policy definition reference belongs to.
        :param Mapping[str, 'ParameterValuesValueResponse'] parameters: The parameter values for the referenced policy rule. The keys are the parameter names.
        :param str policy_definition_reference_id: A unique id (within the policy set definition) for this policy definition reference.
        """
        pulumi.set(__self__, "policy_definition_id", policy_definition_id)
        if group_names is not None:
            pulumi.set(__self__, "group_names", group_names)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if policy_definition_reference_id is not None:
            pulumi.set(__self__, "policy_definition_reference_id", policy_definition_reference_id)

    @property
    @pulumi.getter(name="policyDefinitionId")
    def policy_definition_id(self) -> str:
        """
        The ID of the policy definition or policy set definition.
        """
        return pulumi.get(self, "policy_definition_id")

    @property
    @pulumi.getter(name="groupNames")
    def group_names(self) -> Optional[Sequence[str]]:
        """
        The name of the groups that this policy definition reference belongs to.
        """
        return pulumi.get(self, "group_names")

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Mapping[str, 'outputs.ParameterValuesValueResponse']]:
        """
        The parameter values for the referenced policy rule. The keys are the parameter names.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter(name="policyDefinitionReferenceId")
    def policy_definition_reference_id(self) -> Optional[str]:
        """
        A unique id (within the policy set definition) for this policy definition reference.
        """
        return pulumi.get(self, "policy_definition_reference_id")


@pulumi.output_type
class PrincipalResponse(dict):
    """
    The name of the entity last modified it
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "displayName":
            suggest = "display_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PrincipalResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PrincipalResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PrincipalResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 display_name: Optional[str] = None,
                 email: Optional[str] = None,
                 id: Optional[str] = None,
                 type: Optional[str] = None):
        """
        The name of the entity last modified it
        :param str display_name: The name of the principal made changes
        :param str email: Email of principal
        :param str id: The id of the principal made changes
        :param str type: Type of principal such as user , group etc
        """
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if email is not None:
            pulumi.set(__self__, "email", email)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        The name of the principal made changes
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def email(self) -> Optional[str]:
        """
        Email of principal
        """
        return pulumi.get(self, "email")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The id of the principal made changes
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        Type of principal such as user , group etc
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class PrivateLinkAssociationPropertiesExpandedResponse(dict):
    """
    Private Link Association Properties.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "privateLink":
            suggest = "private_link"
        elif key == "publicNetworkAccess":
            suggest = "public_network_access"
        elif key == "tenantID":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PrivateLinkAssociationPropertiesExpandedResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PrivateLinkAssociationPropertiesExpandedResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PrivateLinkAssociationPropertiesExpandedResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 private_link: Optional[str] = None,
                 public_network_access: Optional[str] = None,
                 scope: Optional[str] = None,
                 tenant_id: Optional[str] = None):
        """
        Private Link Association Properties.
        :param str private_link: The rmpl Resource ID.
        :param str scope: The scope of the private link association.
        :param str tenant_id: The TenantID.
        """
        if private_link is not None:
            pulumi.set(__self__, "private_link", private_link)
        if public_network_access is not None:
            pulumi.set(__self__, "public_network_access", public_network_access)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter(name="privateLink")
    def private_link(self) -> Optional[str]:
        """
        The rmpl Resource ID.
        """
        return pulumi.get(self, "private_link")

    @property
    @pulumi.getter(name="publicNetworkAccess")
    def public_network_access(self) -> Optional[str]:
        return pulumi.get(self, "public_network_access")

    @property
    @pulumi.getter
    def scope(self) -> Optional[str]:
        """
        The scope of the private link association.
        """
        return pulumi.get(self, "scope")

    @property
    @pulumi.getter(name="tenantID")
    def tenant_id(self) -> Optional[str]:
        """
        The TenantID.
        """
        return pulumi.get(self, "tenant_id")


@pulumi.output_type
class ResourceManagementPrivateLinkEndpointConnectionsResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "privateEndpointConnections":
            suggest = "private_endpoint_connections"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourceManagementPrivateLinkEndpointConnectionsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourceManagementPrivateLinkEndpointConnectionsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourceManagementPrivateLinkEndpointConnectionsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 private_endpoint_connections: Optional[Sequence[str]] = None):
        """
        :param Sequence[str] private_endpoint_connections: The private endpoint connections.
        """
        if private_endpoint_connections is not None:
            pulumi.set(__self__, "private_endpoint_connections", private_endpoint_connections)

    @property
    @pulumi.getter(name="privateEndpointConnections")
    def private_endpoint_connections(self) -> Optional[Sequence[str]]:
        """
        The private endpoint connections.
        """
        return pulumi.get(self, "private_endpoint_connections")


@pulumi.output_type
class SystemDataResponse(dict):
    """
    Metadata pertaining to creation and last modification of the resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createdAt":
            suggest = "created_at"
        elif key == "createdBy":
            suggest = "created_by"
        elif key == "createdByType":
            suggest = "created_by_type"
        elif key == "lastModifiedAt":
            suggest = "last_modified_at"
        elif key == "lastModifiedBy":
            suggest = "last_modified_by"
        elif key == "lastModifiedByType":
            suggest = "last_modified_by_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SystemDataResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SystemDataResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SystemDataResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 created_at: Optional[str] = None,
                 created_by: Optional[str] = None,
                 created_by_type: Optional[str] = None,
                 last_modified_at: Optional[str] = None,
                 last_modified_by: Optional[str] = None,
                 last_modified_by_type: Optional[str] = None):
        """
        Metadata pertaining to creation and last modification of the resource.
        :param str created_at: The timestamp of resource creation (UTC).
        :param str created_by: The identity that created the resource.
        :param str created_by_type: The type of identity that created the resource.
        :param str last_modified_at: The timestamp of resource last modification (UTC)
        :param str last_modified_by: The identity that last modified the resource.
        :param str last_modified_by_type: The type of identity that last modified the resource.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if created_by_type is not None:
            pulumi.set(__self__, "created_by_type", created_by_type)
        if last_modified_at is not None:
            pulumi.set(__self__, "last_modified_at", last_modified_at)
        if last_modified_by is not None:
            pulumi.set(__self__, "last_modified_by", last_modified_by)
        if last_modified_by_type is not None:
            pulumi.set(__self__, "last_modified_by_type", last_modified_by_type)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[str]:
        """
        The timestamp of resource creation (UTC).
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[str]:
        """
        The identity that created the resource.
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter(name="createdByType")
    def created_by_type(self) -> Optional[str]:
        """
        The type of identity that created the resource.
        """
        return pulumi.get(self, "created_by_type")

    @property
    @pulumi.getter(name="lastModifiedAt")
    def last_modified_at(self) -> Optional[str]:
        """
        The timestamp of resource last modification (UTC)
        """
        return pulumi.get(self, "last_modified_at")

    @property
    @pulumi.getter(name="lastModifiedBy")
    def last_modified_by(self) -> Optional[str]:
        """
        The identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by")

    @property
    @pulumi.getter(name="lastModifiedByType")
    def last_modified_by_type(self) -> Optional[str]:
        """
        The type of identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by_type")


