# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'ListDaprComponentSecretsResult',
    'AwaitableListDaprComponentSecretsResult',
    'list_dapr_component_secrets',
    'list_dapr_component_secrets_output',
]

@pulumi.output_type
class ListDaprComponentSecretsResult:
    """
    Dapr component Secrets Collection ARM resource.
    """
    def __init__(__self__, value=None):
        if value and not isinstance(value, list):
            raise TypeError("Expected argument 'value' to be a list")
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def value(self) -> Sequence['outputs.SecretResponse']:
        """
        Collection of secrets used by a Dapr component
        """
        return pulumi.get(self, "value")


class AwaitableListDaprComponentSecretsResult(ListDaprComponentSecretsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return ListDaprComponentSecretsResult(
            value=self.value)


def list_dapr_component_secrets(environment_name: Optional[str] = None,
                                name: Optional[str] = None,
                                resource_group_name: Optional[str] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableListDaprComponentSecretsResult:
    """
    Dapr component Secrets Collection ARM resource.


    :param str environment_name: Name of the Managed Environment.
    :param str name: Name of the Dapr Component.
    :param str resource_group_name: The name of the resource group. The name is case insensitive.
    """
    __args__ = dict()
    __args__['environmentName'] = environment_name
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('azure-native:app/v20220301:listDaprComponentSecrets', __args__, opts=opts, typ=ListDaprComponentSecretsResult).value

    return AwaitableListDaprComponentSecretsResult(
        value=__ret__.value)


@_utilities.lift_output_func(list_dapr_component_secrets)
def list_dapr_component_secrets_output(environment_name: Optional[pulumi.Input[str]] = None,
                                       name: Optional[pulumi.Input[str]] = None,
                                       resource_group_name: Optional[pulumi.Input[str]] = None,
                                       opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[ListDaprComponentSecretsResult]:
    """
    Dapr component Secrets Collection ARM resource.


    :param str environment_name: Name of the Managed Environment.
    :param str name: Name of the Dapr Component.
    :param str resource_group_name: The name of the resource group. The name is case insensitive.
    """
    ...
