# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._inputs import *

__all__ = ['BackupScheduleGroupArgs', 'BackupScheduleGroup']

@pulumi.input_type
class BackupScheduleGroupArgs:
    def __init__(__self__, *,
                 device_name: pulumi.Input[str],
                 manager_name: pulumi.Input[str],
                 resource_group_name: pulumi.Input[str],
                 start_time: pulumi.Input['TimeArgs'],
                 schedule_group_name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a BackupScheduleGroup resource.
        :param pulumi.Input[str] device_name: The name of the device.
        :param pulumi.Input[str] manager_name: The manager name
        :param pulumi.Input[str] resource_group_name: The resource group name
        :param pulumi.Input['TimeArgs'] start_time: The start time. When this field is specified we will generate Default GrandFather Father Son Backup Schedules.
        :param pulumi.Input[str] schedule_group_name: The name of the schedule group.
        """
        pulumi.set(__self__, "device_name", device_name)
        pulumi.set(__self__, "manager_name", manager_name)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "start_time", start_time)
        if schedule_group_name is not None:
            pulumi.set(__self__, "schedule_group_name", schedule_group_name)

    @property
    @pulumi.getter(name="deviceName")
    def device_name(self) -> pulumi.Input[str]:
        """
        The name of the device.
        """
        return pulumi.get(self, "device_name")

    @device_name.setter
    def device_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "device_name", value)

    @property
    @pulumi.getter(name="managerName")
    def manager_name(self) -> pulumi.Input[str]:
        """
        The manager name
        """
        return pulumi.get(self, "manager_name")

    @manager_name.setter
    def manager_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "manager_name", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[str]:
        """
        The resource group name
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> pulumi.Input['TimeArgs']:
        """
        The start time. When this field is specified we will generate Default GrandFather Father Son Backup Schedules.
        """
        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: pulumi.Input['TimeArgs']):
        pulumi.set(self, "start_time", value)

    @property
    @pulumi.getter(name="scheduleGroupName")
    def schedule_group_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the schedule group.
        """
        return pulumi.get(self, "schedule_group_name")

    @schedule_group_name.setter
    def schedule_group_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "schedule_group_name", value)


warnings.warn("""Version v20161001 will be removed in the next major version of the provider. Upgrade to version v20170601 or later.""", DeprecationWarning)


class BackupScheduleGroup(pulumi.CustomResource):
    warnings.warn("""Version v20161001 will be removed in the next major version of the provider. Upgrade to version v20170601 or later.""", DeprecationWarning)

    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 device_name: Optional[pulumi.Input[str]] = None,
                 manager_name: Optional[pulumi.Input[str]] = None,
                 resource_group_name: Optional[pulumi.Input[str]] = None,
                 schedule_group_name: Optional[pulumi.Input[str]] = None,
                 start_time: Optional[pulumi.Input[pulumi.InputType['TimeArgs']]] = None,
                 __props__=None):
        """
        The Backup Schedule Group

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] device_name: The name of the device.
        :param pulumi.Input[str] manager_name: The manager name
        :param pulumi.Input[str] resource_group_name: The resource group name
        :param pulumi.Input[str] schedule_group_name: The name of the schedule group.
        :param pulumi.Input[pulumi.InputType['TimeArgs']] start_time: The start time. When this field is specified we will generate Default GrandFather Father Son Backup Schedules.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: BackupScheduleGroupArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The Backup Schedule Group

        :param str resource_name: The name of the resource.
        :param BackupScheduleGroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BackupScheduleGroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 device_name: Optional[pulumi.Input[str]] = None,
                 manager_name: Optional[pulumi.Input[str]] = None,
                 resource_group_name: Optional[pulumi.Input[str]] = None,
                 schedule_group_name: Optional[pulumi.Input[str]] = None,
                 start_time: Optional[pulumi.Input[pulumi.InputType['TimeArgs']]] = None,
                 __props__=None):
        pulumi.log.warn("""BackupScheduleGroup is deprecated: Version v20161001 will be removed in the next major version of the provider. Upgrade to version v20170601 or later.""")
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BackupScheduleGroupArgs.__new__(BackupScheduleGroupArgs)

            if device_name is None and not opts.urn:
                raise TypeError("Missing required property 'device_name'")
            __props__.__dict__["device_name"] = device_name
            if manager_name is None and not opts.urn:
                raise TypeError("Missing required property 'manager_name'")
            __props__.__dict__["manager_name"] = manager_name
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["schedule_group_name"] = schedule_group_name
            if start_time is None and not opts.urn:
                raise TypeError("Missing required property 'start_time'")
            __props__.__dict__["start_time"] = start_time
            __props__.__dict__["name"] = None
            __props__.__dict__["type"] = None
        super(BackupScheduleGroup, __self__).__init__(
            'azure-native:storsimple/v20161001:BackupScheduleGroup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'BackupScheduleGroup':
        """
        Get an existing BackupScheduleGroup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = BackupScheduleGroupArgs.__new__(BackupScheduleGroupArgs)

        __props__.__dict__["name"] = None
        __props__.__dict__["start_time"] = None
        __props__.__dict__["type"] = None
        return BackupScheduleGroup(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> pulumi.Output['outputs.TimeResponse']:
        """
        The start time. When this field is specified we will generate Default GrandFather Father Son Backup Schedules.
        """
        return pulumi.get(self, "start_time")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        The type.
        """
        return pulumi.get(self, "type")

