# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'AclResponse',
    'DiskResponse',
    'IscsiLunResponse',
    'SystemMetadataResponse',
]

@pulumi.output_type
class AclResponse(dict):
    """
    Access Control List (ACL) for an iSCSI Target; defines LUN masking policy
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "initiatorIqn":
            suggest = "initiator_iqn"
        elif key == "mappedLuns":
            suggest = "mapped_luns"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AclResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AclResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AclResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 initiator_iqn: str,
                 mapped_luns: Sequence[str]):
        """
        Access Control List (ACL) for an iSCSI Target; defines LUN masking policy
        :param str initiator_iqn: iSCSI initiator IQN (iSCSI Qualified Name); example: "iqn.2005-03.org.iscsi:client".
        :param Sequence[str] mapped_luns: List of LUN names mapped to the ACL.
        """
        pulumi.set(__self__, "initiator_iqn", initiator_iqn)
        pulumi.set(__self__, "mapped_luns", mapped_luns)

    @property
    @pulumi.getter(name="initiatorIqn")
    def initiator_iqn(self) -> str:
        """
        iSCSI initiator IQN (iSCSI Qualified Name); example: "iqn.2005-03.org.iscsi:client".
        """
        return pulumi.get(self, "initiator_iqn")

    @property
    @pulumi.getter(name="mappedLuns")
    def mapped_luns(self) -> Sequence[str]:
        """
        List of LUN names mapped to the ACL.
        """
        return pulumi.get(self, "mapped_luns")


@pulumi.output_type
class DiskResponse(dict):
    """
    Azure Managed Disk to attach to the Disk Pool.
    """
    def __init__(__self__, *,
                 id: str):
        """
        Azure Managed Disk to attach to the Disk Pool.
        :param str id: Unique Azure Resource ID of the Managed Disk.
        """
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Unique Azure Resource ID of the Managed Disk.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class IscsiLunResponse(dict):
    """
    LUN to expose the Azure Managed Disk.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "managedDiskAzureResourceId":
            suggest = "managed_disk_azure_resource_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IscsiLunResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IscsiLunResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IscsiLunResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 lun: int,
                 managed_disk_azure_resource_id: str,
                 name: str):
        """
        LUN to expose the Azure Managed Disk.
        :param int lun: Specifies the Logical Unit Number of the iSCSI LUN.
        :param str managed_disk_azure_resource_id: Azure Resource ID of the Managed Disk.
        :param str name: User defined name for iSCSI LUN; example: "lun0"
        """
        pulumi.set(__self__, "lun", lun)
        pulumi.set(__self__, "managed_disk_azure_resource_id", managed_disk_azure_resource_id)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def lun(self) -> int:
        """
        Specifies the Logical Unit Number of the iSCSI LUN.
        """
        return pulumi.get(self, "lun")

    @property
    @pulumi.getter(name="managedDiskAzureResourceId")
    def managed_disk_azure_resource_id(self) -> str:
        """
        Azure Resource ID of the Managed Disk.
        """
        return pulumi.get(self, "managed_disk_azure_resource_id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        User defined name for iSCSI LUN; example: "lun0"
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class SystemMetadataResponse(dict):
    """
    Metadata pertaining to creation and last modification of the resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createdAt":
            suggest = "created_at"
        elif key == "createdBy":
            suggest = "created_by"
        elif key == "createdByType":
            suggest = "created_by_type"
        elif key == "lastModifiedAt":
            suggest = "last_modified_at"
        elif key == "lastModifiedBy":
            suggest = "last_modified_by"
        elif key == "lastModifiedByType":
            suggest = "last_modified_by_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SystemMetadataResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SystemMetadataResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SystemMetadataResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 created_at: Optional[str] = None,
                 created_by: Optional[str] = None,
                 created_by_type: Optional[str] = None,
                 last_modified_at: Optional[str] = None,
                 last_modified_by: Optional[str] = None,
                 last_modified_by_type: Optional[str] = None):
        """
        Metadata pertaining to creation and last modification of the resource.
        :param str created_at: The timestamp of resource creation (UTC).
        :param str created_by: The identity that created the resource.
        :param str created_by_type: The type of identity that created the resource.
        :param str last_modified_at: The type of identity that last modified the resource.
        :param str last_modified_by: The identity that last modified the resource.
        :param str last_modified_by_type: The type of identity that last modified the resource.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if created_by_type is not None:
            pulumi.set(__self__, "created_by_type", created_by_type)
        if last_modified_at is not None:
            pulumi.set(__self__, "last_modified_at", last_modified_at)
        if last_modified_by is not None:
            pulumi.set(__self__, "last_modified_by", last_modified_by)
        if last_modified_by_type is not None:
            pulumi.set(__self__, "last_modified_by_type", last_modified_by_type)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[str]:
        """
        The timestamp of resource creation (UTC).
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[str]:
        """
        The identity that created the resource.
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter(name="createdByType")
    def created_by_type(self) -> Optional[str]:
        """
        The type of identity that created the resource.
        """
        return pulumi.get(self, "created_by_type")

    @property
    @pulumi.getter(name="lastModifiedAt")
    def last_modified_at(self) -> Optional[str]:
        """
        The type of identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_at")

    @property
    @pulumi.getter(name="lastModifiedBy")
    def last_modified_by(self) -> Optional[str]:
        """
        The identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by")

    @property
    @pulumi.getter(name="lastModifiedByType")
    def last_modified_by_type(self) -> Optional[str]:
        """
        The type of identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by_type")


