# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'DatabaseIdentityResponse',
    'DatabaseUserIdentityResponse',
    'DatabaseVulnerabilityAssessmentRuleBaselineItemResponse',
    'DelegationResponse',
    'ElasticPoolPerDatabaseSettingsResponse',
    'FailoverGroupReadOnlyEndpointResponse',
    'FailoverGroupReadWriteEndpointResponse',
    'InstanceFailoverGroupReadOnlyEndpointResponse',
    'InstanceFailoverGroupReadWriteEndpointResponse',
    'JobScheduleResponse',
    'JobStepActionResponse',
    'JobStepExecutionOptionsResponse',
    'JobStepOutputResponse',
    'JobTargetResponse',
    'ManagedInstanceExternalAdministratorResponse',
    'ManagedInstancePairInfoResponse',
    'ManagedInstancePecPropertyResponse',
    'ManagedInstancePrivateEndpointConnectionPropertiesResponse',
    'ManagedInstancePrivateEndpointPropertyResponse',
    'ManagedInstancePrivateLinkServiceConnectionStatePropertyResponse',
    'PartnerInfoResponse',
    'PartnerRegionInfoResponse',
    'PrivateEndpointConnectionPropertiesResponse',
    'PrivateEndpointPropertyResponse',
    'PrivateLinkServiceConnectionStatePropertyResponse',
    'RecommendedActionErrorInfoResponse',
    'RecommendedActionImpactRecordResponse',
    'RecommendedActionImplementationInfoResponse',
    'RecommendedActionMetricInfoResponse',
    'RecommendedActionResponse',
    'RecommendedActionStateInfoResponse',
    'ResourceIdentityResponse',
    'ServerExternalAdministratorResponse',
    'ServerInfoResponse',
    'ServerPrivateEndpointConnectionResponse',
    'ServicePrincipalResponse',
    'SkuResponse',
    'SyncGroupSchemaResponse',
    'SyncGroupSchemaTableColumnResponse',
    'SyncGroupSchemaTableResponse',
    'SystemDataResponse',
    'UserIdentityResponse',
    'VulnerabilityAssessmentRecurringScansPropertiesResponse',
]

@pulumi.output_type
class DatabaseIdentityResponse(dict):
    """
    Azure Active Directory identity configuration for a resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "tenantId":
            suggest = "tenant_id"
        elif key == "delegatedResources":
            suggest = "delegated_resources"
        elif key == "userAssignedIdentities":
            suggest = "user_assigned_identities"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabaseIdentityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabaseIdentityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabaseIdentityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 tenant_id: str,
                 delegated_resources: Optional[Mapping[str, 'outputs.DelegationResponse']] = None,
                 type: Optional[str] = None,
                 user_assigned_identities: Optional[Mapping[str, 'outputs.DatabaseUserIdentityResponse']] = None):
        """
        Azure Active Directory identity configuration for a resource.
        :param str tenant_id: The Azure Active Directory tenant id.
        :param Mapping[str, 'DelegationResponse'] delegated_resources: Resources delegated to the database - Internal Use Only
        :param str type: The identity type
        :param Mapping[str, 'DatabaseUserIdentityResponse'] user_assigned_identities: The resource ids of the user assigned identities to use
        """
        pulumi.set(__self__, "tenant_id", tenant_id)
        if delegated_resources is not None:
            pulumi.set(__self__, "delegated_resources", delegated_resources)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if user_assigned_identities is not None:
            pulumi.set(__self__, "user_assigned_identities", user_assigned_identities)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> str:
        """
        The Azure Active Directory tenant id.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter(name="delegatedResources")
    def delegated_resources(self) -> Optional[Mapping[str, 'outputs.DelegationResponse']]:
        """
        Resources delegated to the database - Internal Use Only
        """
        return pulumi.get(self, "delegated_resources")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The identity type
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="userAssignedIdentities")
    def user_assigned_identities(self) -> Optional[Mapping[str, 'outputs.DatabaseUserIdentityResponse']]:
        """
        The resource ids of the user assigned identities to use
        """
        return pulumi.get(self, "user_assigned_identities")


@pulumi.output_type
class DatabaseUserIdentityResponse(dict):
    """
    Azure Active Directory identity configuration for a resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientId":
            suggest = "client_id"
        elif key == "principalId":
            suggest = "principal_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabaseUserIdentityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabaseUserIdentityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabaseUserIdentityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_id: str,
                 principal_id: str):
        """
        Azure Active Directory identity configuration for a resource.
        :param str client_id: The Azure Active Directory client id.
        :param str principal_id: The Azure Active Directory principal id.
        """
        pulumi.set(__self__, "client_id", client_id)
        pulumi.set(__self__, "principal_id", principal_id)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> str:
        """
        The Azure Active Directory client id.
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> str:
        """
        The Azure Active Directory principal id.
        """
        return pulumi.get(self, "principal_id")


@pulumi.output_type
class DatabaseVulnerabilityAssessmentRuleBaselineItemResponse(dict):
    """
    Properties for an Azure SQL Database Vulnerability Assessment rule baseline's result.
    """
    def __init__(__self__, *,
                 result: Sequence[str]):
        """
        Properties for an Azure SQL Database Vulnerability Assessment rule baseline's result.
        :param Sequence[str] result: The rule baseline result
        """
        pulumi.set(__self__, "result", result)

    @property
    @pulumi.getter
    def result(self) -> Sequence[str]:
        """
        The rule baseline result
        """
        return pulumi.get(self, "result")


@pulumi.output_type
class DelegationResponse(dict):
    """
    Delegated Resource Properties - Internal Use Only
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "tenantId":
            suggest = "tenant_id"
        elif key == "resourceId":
            suggest = "resource_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DelegationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DelegationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DelegationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 tenant_id: str,
                 resource_id: Optional[str] = None):
        """
        Delegated Resource Properties - Internal Use Only
        :param str tenant_id: AAD tenant guid of the source resource identity - Internal Use Only.
        :param str resource_id: The resource id of the source resource - Internal Use Only
        """
        pulumi.set(__self__, "tenant_id", tenant_id)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> str:
        """
        AAD tenant guid of the source resource identity - Internal Use Only.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[str]:
        """
        The resource id of the source resource - Internal Use Only
        """
        return pulumi.get(self, "resource_id")


@pulumi.output_type
class ElasticPoolPerDatabaseSettingsResponse(dict):
    """
    Per database settings of an elastic pool.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxCapacity":
            suggest = "max_capacity"
        elif key == "minCapacity":
            suggest = "min_capacity"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ElasticPoolPerDatabaseSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ElasticPoolPerDatabaseSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ElasticPoolPerDatabaseSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_capacity: Optional[float] = None,
                 min_capacity: Optional[float] = None):
        """
        Per database settings of an elastic pool.
        :param float max_capacity: The maximum capacity any one database can consume.
        :param float min_capacity: The minimum capacity all databases are guaranteed.
        """
        if max_capacity is not None:
            pulumi.set(__self__, "max_capacity", max_capacity)
        if min_capacity is not None:
            pulumi.set(__self__, "min_capacity", min_capacity)

    @property
    @pulumi.getter(name="maxCapacity")
    def max_capacity(self) -> Optional[float]:
        """
        The maximum capacity any one database can consume.
        """
        return pulumi.get(self, "max_capacity")

    @property
    @pulumi.getter(name="minCapacity")
    def min_capacity(self) -> Optional[float]:
        """
        The minimum capacity all databases are guaranteed.
        """
        return pulumi.get(self, "min_capacity")


@pulumi.output_type
class FailoverGroupReadOnlyEndpointResponse(dict):
    """
    Read-only endpoint of the failover group instance.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "failoverPolicy":
            suggest = "failover_policy"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FailoverGroupReadOnlyEndpointResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FailoverGroupReadOnlyEndpointResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FailoverGroupReadOnlyEndpointResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 failover_policy: Optional[str] = None):
        """
        Read-only endpoint of the failover group instance.
        :param str failover_policy: Failover policy of the read-only endpoint for the failover group.
        """
        if failover_policy is not None:
            pulumi.set(__self__, "failover_policy", failover_policy)

    @property
    @pulumi.getter(name="failoverPolicy")
    def failover_policy(self) -> Optional[str]:
        """
        Failover policy of the read-only endpoint for the failover group.
        """
        return pulumi.get(self, "failover_policy")


@pulumi.output_type
class FailoverGroupReadWriteEndpointResponse(dict):
    """
    Read-write endpoint of the failover group instance.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "failoverPolicy":
            suggest = "failover_policy"
        elif key == "failoverWithDataLossGracePeriodMinutes":
            suggest = "failover_with_data_loss_grace_period_minutes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FailoverGroupReadWriteEndpointResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FailoverGroupReadWriteEndpointResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FailoverGroupReadWriteEndpointResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 failover_policy: str,
                 failover_with_data_loss_grace_period_minutes: Optional[int] = None):
        """
        Read-write endpoint of the failover group instance.
        :param str failover_policy: Failover policy of the read-write endpoint for the failover group. If failoverPolicy is Automatic then failoverWithDataLossGracePeriodMinutes is required.
        :param int failover_with_data_loss_grace_period_minutes: Grace period before failover with data loss is attempted for the read-write endpoint. If failoverPolicy is Automatic then failoverWithDataLossGracePeriodMinutes is required.
        """
        pulumi.set(__self__, "failover_policy", failover_policy)
        if failover_with_data_loss_grace_period_minutes is not None:
            pulumi.set(__self__, "failover_with_data_loss_grace_period_minutes", failover_with_data_loss_grace_period_minutes)

    @property
    @pulumi.getter(name="failoverPolicy")
    def failover_policy(self) -> str:
        """
        Failover policy of the read-write endpoint for the failover group. If failoverPolicy is Automatic then failoverWithDataLossGracePeriodMinutes is required.
        """
        return pulumi.get(self, "failover_policy")

    @property
    @pulumi.getter(name="failoverWithDataLossGracePeriodMinutes")
    def failover_with_data_loss_grace_period_minutes(self) -> Optional[int]:
        """
        Grace period before failover with data loss is attempted for the read-write endpoint. If failoverPolicy is Automatic then failoverWithDataLossGracePeriodMinutes is required.
        """
        return pulumi.get(self, "failover_with_data_loss_grace_period_minutes")


@pulumi.output_type
class InstanceFailoverGroupReadOnlyEndpointResponse(dict):
    """
    Read-only endpoint of the failover group instance.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "failoverPolicy":
            suggest = "failover_policy"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceFailoverGroupReadOnlyEndpointResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceFailoverGroupReadOnlyEndpointResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceFailoverGroupReadOnlyEndpointResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 failover_policy: Optional[str] = None):
        """
        Read-only endpoint of the failover group instance.
        :param str failover_policy: Failover policy of the read-only endpoint for the failover group.
        """
        if failover_policy is not None:
            pulumi.set(__self__, "failover_policy", failover_policy)

    @property
    @pulumi.getter(name="failoverPolicy")
    def failover_policy(self) -> Optional[str]:
        """
        Failover policy of the read-only endpoint for the failover group.
        """
        return pulumi.get(self, "failover_policy")


@pulumi.output_type
class InstanceFailoverGroupReadWriteEndpointResponse(dict):
    """
    Read-write endpoint of the failover group instance.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "failoverPolicy":
            suggest = "failover_policy"
        elif key == "failoverWithDataLossGracePeriodMinutes":
            suggest = "failover_with_data_loss_grace_period_minutes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceFailoverGroupReadWriteEndpointResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceFailoverGroupReadWriteEndpointResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceFailoverGroupReadWriteEndpointResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 failover_policy: str,
                 failover_with_data_loss_grace_period_minutes: Optional[int] = None):
        """
        Read-write endpoint of the failover group instance.
        :param str failover_policy: Failover policy of the read-write endpoint for the failover group. If failoverPolicy is Automatic then failoverWithDataLossGracePeriodMinutes is required.
        :param int failover_with_data_loss_grace_period_minutes: Grace period before failover with data loss is attempted for the read-write endpoint. If failoverPolicy is Automatic then failoverWithDataLossGracePeriodMinutes is required.
        """
        pulumi.set(__self__, "failover_policy", failover_policy)
        if failover_with_data_loss_grace_period_minutes is not None:
            pulumi.set(__self__, "failover_with_data_loss_grace_period_minutes", failover_with_data_loss_grace_period_minutes)

    @property
    @pulumi.getter(name="failoverPolicy")
    def failover_policy(self) -> str:
        """
        Failover policy of the read-write endpoint for the failover group. If failoverPolicy is Automatic then failoverWithDataLossGracePeriodMinutes is required.
        """
        return pulumi.get(self, "failover_policy")

    @property
    @pulumi.getter(name="failoverWithDataLossGracePeriodMinutes")
    def failover_with_data_loss_grace_period_minutes(self) -> Optional[int]:
        """
        Grace period before failover with data loss is attempted for the read-write endpoint. If failoverPolicy is Automatic then failoverWithDataLossGracePeriodMinutes is required.
        """
        return pulumi.get(self, "failover_with_data_loss_grace_period_minutes")


@pulumi.output_type
class JobScheduleResponse(dict):
    """
    Scheduling properties of a job.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endTime":
            suggest = "end_time"
        elif key == "startTime":
            suggest = "start_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobScheduleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobScheduleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobScheduleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: Optional[bool] = None,
                 end_time: Optional[str] = None,
                 interval: Optional[str] = None,
                 start_time: Optional[str] = None,
                 type: Optional[str] = None):
        """
        Scheduling properties of a job.
        :param bool enabled: Whether or not the schedule is enabled.
        :param str end_time: Schedule end time.
        :param str interval: Value of the schedule's recurring interval, if the ScheduleType is recurring. ISO8601 duration format.
        :param str start_time: Schedule start time.
        :param str type: Schedule interval type
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if end_time is None:
            end_time = '9999-12-31T11:59:59+00:00'
        if end_time is not None:
            pulumi.set(__self__, "end_time", end_time)
        if interval is not None:
            pulumi.set(__self__, "interval", interval)
        if start_time is None:
            start_time = '0001-01-01T00:00:00+00:00'
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)
        if type is None:
            type = 'Once'
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        """
        Whether or not the schedule is enabled.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> Optional[str]:
        """
        Schedule end time.
        """
        return pulumi.get(self, "end_time")

    @property
    @pulumi.getter
    def interval(self) -> Optional[str]:
        """
        Value of the schedule's recurring interval, if the ScheduleType is recurring. ISO8601 duration format.
        """
        return pulumi.get(self, "interval")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[str]:
        """
        Schedule start time.
        """
        return pulumi.get(self, "start_time")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        Schedule interval type
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class JobStepActionResponse(dict):
    """
    The action to be executed by a job step.
    """
    def __init__(__self__, *,
                 value: str,
                 source: Optional[str] = None,
                 type: Optional[str] = None):
        """
        The action to be executed by a job step.
        :param str value: The action value, for example the text of the T-SQL script to execute.
        :param str source: The source of the action to execute.
        :param str type: Type of action being executed by the job step.
        """
        pulumi.set(__self__, "value", value)
        if source is None:
            source = 'Inline'
        if source is not None:
            pulumi.set(__self__, "source", source)
        if type is None:
            type = 'TSql'
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The action value, for example the text of the T-SQL script to execute.
        """
        return pulumi.get(self, "value")

    @property
    @pulumi.getter
    def source(self) -> Optional[str]:
        """
        The source of the action to execute.
        """
        return pulumi.get(self, "source")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        Type of action being executed by the job step.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class JobStepExecutionOptionsResponse(dict):
    """
    The execution options of a job step.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "initialRetryIntervalSeconds":
            suggest = "initial_retry_interval_seconds"
        elif key == "maximumRetryIntervalSeconds":
            suggest = "maximum_retry_interval_seconds"
        elif key == "retryAttempts":
            suggest = "retry_attempts"
        elif key == "retryIntervalBackoffMultiplier":
            suggest = "retry_interval_backoff_multiplier"
        elif key == "timeoutSeconds":
            suggest = "timeout_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobStepExecutionOptionsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobStepExecutionOptionsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobStepExecutionOptionsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 initial_retry_interval_seconds: Optional[int] = None,
                 maximum_retry_interval_seconds: Optional[int] = None,
                 retry_attempts: Optional[int] = None,
                 retry_interval_backoff_multiplier: Optional[float] = None,
                 timeout_seconds: Optional[int] = None):
        """
        The execution options of a job step.
        :param int initial_retry_interval_seconds: Initial delay between retries for job step execution.
        :param int maximum_retry_interval_seconds: The maximum amount of time to wait between retries for job step execution.
        :param int retry_attempts: Maximum number of times the job step will be reattempted if the first attempt fails.
        :param float retry_interval_backoff_multiplier: The backoff multiplier for the time between retries.
        :param int timeout_seconds: Execution timeout for the job step.
        """
        if initial_retry_interval_seconds is None:
            initial_retry_interval_seconds = 1
        if initial_retry_interval_seconds is not None:
            pulumi.set(__self__, "initial_retry_interval_seconds", initial_retry_interval_seconds)
        if maximum_retry_interval_seconds is None:
            maximum_retry_interval_seconds = 120
        if maximum_retry_interval_seconds is not None:
            pulumi.set(__self__, "maximum_retry_interval_seconds", maximum_retry_interval_seconds)
        if retry_attempts is None:
            retry_attempts = 10
        if retry_attempts is not None:
            pulumi.set(__self__, "retry_attempts", retry_attempts)
        if retry_interval_backoff_multiplier is None:
            retry_interval_backoff_multiplier = 2
        if retry_interval_backoff_multiplier is not None:
            pulumi.set(__self__, "retry_interval_backoff_multiplier", retry_interval_backoff_multiplier)
        if timeout_seconds is None:
            timeout_seconds = 43200
        if timeout_seconds is not None:
            pulumi.set(__self__, "timeout_seconds", timeout_seconds)

    @property
    @pulumi.getter(name="initialRetryIntervalSeconds")
    def initial_retry_interval_seconds(self) -> Optional[int]:
        """
        Initial delay between retries for job step execution.
        """
        return pulumi.get(self, "initial_retry_interval_seconds")

    @property
    @pulumi.getter(name="maximumRetryIntervalSeconds")
    def maximum_retry_interval_seconds(self) -> Optional[int]:
        """
        The maximum amount of time to wait between retries for job step execution.
        """
        return pulumi.get(self, "maximum_retry_interval_seconds")

    @property
    @pulumi.getter(name="retryAttempts")
    def retry_attempts(self) -> Optional[int]:
        """
        Maximum number of times the job step will be reattempted if the first attempt fails.
        """
        return pulumi.get(self, "retry_attempts")

    @property
    @pulumi.getter(name="retryIntervalBackoffMultiplier")
    def retry_interval_backoff_multiplier(self) -> Optional[float]:
        """
        The backoff multiplier for the time between retries.
        """
        return pulumi.get(self, "retry_interval_backoff_multiplier")

    @property
    @pulumi.getter(name="timeoutSeconds")
    def timeout_seconds(self) -> Optional[int]:
        """
        Execution timeout for the job step.
        """
        return pulumi.get(self, "timeout_seconds")


@pulumi.output_type
class JobStepOutputResponse(dict):
    """
    The output configuration of a job step.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "databaseName":
            suggest = "database_name"
        elif key == "serverName":
            suggest = "server_name"
        elif key == "tableName":
            suggest = "table_name"
        elif key == "resourceGroupName":
            suggest = "resource_group_name"
        elif key == "schemaName":
            suggest = "schema_name"
        elif key == "subscriptionId":
            suggest = "subscription_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobStepOutputResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobStepOutputResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobStepOutputResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 credential: str,
                 database_name: str,
                 server_name: str,
                 table_name: str,
                 resource_group_name: Optional[str] = None,
                 schema_name: Optional[str] = None,
                 subscription_id: Optional[str] = None,
                 type: Optional[str] = None):
        """
        The output configuration of a job step.
        :param str credential: The resource ID of the credential to use to connect to the output destination.
        :param str database_name: The output destination database.
        :param str server_name: The output destination server name.
        :param str table_name: The output destination table.
        :param str resource_group_name: The output destination resource group.
        :param str schema_name: The output destination schema.
        :param str subscription_id: The output destination subscription id.
        :param str type: The output destination type.
        """
        pulumi.set(__self__, "credential", credential)
        pulumi.set(__self__, "database_name", database_name)
        pulumi.set(__self__, "server_name", server_name)
        pulumi.set(__self__, "table_name", table_name)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if schema_name is None:
            schema_name = 'dbo'
        if schema_name is not None:
            pulumi.set(__self__, "schema_name", schema_name)
        if subscription_id is not None:
            pulumi.set(__self__, "subscription_id", subscription_id)
        if type is None:
            type = 'SqlDatabase'
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def credential(self) -> str:
        """
        The resource ID of the credential to use to connect to the output destination.
        """
        return pulumi.get(self, "credential")

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> str:
        """
        The output destination database.
        """
        return pulumi.get(self, "database_name")

    @property
    @pulumi.getter(name="serverName")
    def server_name(self) -> str:
        """
        The output destination server name.
        """
        return pulumi.get(self, "server_name")

    @property
    @pulumi.getter(name="tableName")
    def table_name(self) -> str:
        """
        The output destination table.
        """
        return pulumi.get(self, "table_name")

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[str]:
        """
        The output destination resource group.
        """
        return pulumi.get(self, "resource_group_name")

    @property
    @pulumi.getter(name="schemaName")
    def schema_name(self) -> Optional[str]:
        """
        The output destination schema.
        """
        return pulumi.get(self, "schema_name")

    @property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> Optional[str]:
        """
        The output destination subscription id.
        """
        return pulumi.get(self, "subscription_id")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The output destination type.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class JobTargetResponse(dict):
    """
    A job target, for example a specific database or a container of databases that is evaluated during job execution.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "databaseName":
            suggest = "database_name"
        elif key == "elasticPoolName":
            suggest = "elastic_pool_name"
        elif key == "membershipType":
            suggest = "membership_type"
        elif key == "refreshCredential":
            suggest = "refresh_credential"
        elif key == "serverName":
            suggest = "server_name"
        elif key == "shardMapName":
            suggest = "shard_map_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobTargetResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobTargetResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobTargetResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 database_name: Optional[str] = None,
                 elastic_pool_name: Optional[str] = None,
                 membership_type: Optional[str] = None,
                 refresh_credential: Optional[str] = None,
                 server_name: Optional[str] = None,
                 shard_map_name: Optional[str] = None):
        """
        A job target, for example a specific database or a container of databases that is evaluated during job execution.
        :param str type: The target type.
        :param str database_name: The target database name.
        :param str elastic_pool_name: The target elastic pool name.
        :param str membership_type: Whether the target is included or excluded from the group.
        :param str refresh_credential: The resource ID of the credential that is used during job execution to connect to the target and determine the list of databases inside the target.
        :param str server_name: The target server name.
        :param str shard_map_name: The target shard map.
        """
        pulumi.set(__self__, "type", type)
        if database_name is not None:
            pulumi.set(__self__, "database_name", database_name)
        if elastic_pool_name is not None:
            pulumi.set(__self__, "elastic_pool_name", elastic_pool_name)
        if membership_type is None:
            membership_type = 'Include'
        if membership_type is not None:
            pulumi.set(__self__, "membership_type", membership_type)
        if refresh_credential is not None:
            pulumi.set(__self__, "refresh_credential", refresh_credential)
        if server_name is not None:
            pulumi.set(__self__, "server_name", server_name)
        if shard_map_name is not None:
            pulumi.set(__self__, "shard_map_name", shard_map_name)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The target type.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> Optional[str]:
        """
        The target database name.
        """
        return pulumi.get(self, "database_name")

    @property
    @pulumi.getter(name="elasticPoolName")
    def elastic_pool_name(self) -> Optional[str]:
        """
        The target elastic pool name.
        """
        return pulumi.get(self, "elastic_pool_name")

    @property
    @pulumi.getter(name="membershipType")
    def membership_type(self) -> Optional[str]:
        """
        Whether the target is included or excluded from the group.
        """
        return pulumi.get(self, "membership_type")

    @property
    @pulumi.getter(name="refreshCredential")
    def refresh_credential(self) -> Optional[str]:
        """
        The resource ID of the credential that is used during job execution to connect to the target and determine the list of databases inside the target.
        """
        return pulumi.get(self, "refresh_credential")

    @property
    @pulumi.getter(name="serverName")
    def server_name(self) -> Optional[str]:
        """
        The target server name.
        """
        return pulumi.get(self, "server_name")

    @property
    @pulumi.getter(name="shardMapName")
    def shard_map_name(self) -> Optional[str]:
        """
        The target shard map.
        """
        return pulumi.get(self, "shard_map_name")


@pulumi.output_type
class ManagedInstanceExternalAdministratorResponse(dict):
    """
    Properties of a active directory administrator.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "administratorType":
            suggest = "administrator_type"
        elif key == "azureADOnlyAuthentication":
            suggest = "azure_ad_only_authentication"
        elif key == "principalType":
            suggest = "principal_type"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagedInstanceExternalAdministratorResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagedInstanceExternalAdministratorResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagedInstanceExternalAdministratorResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 administrator_type: Optional[str] = None,
                 azure_ad_only_authentication: Optional[bool] = None,
                 login: Optional[str] = None,
                 principal_type: Optional[str] = None,
                 sid: Optional[str] = None,
                 tenant_id: Optional[str] = None):
        """
        Properties of a active directory administrator.
        :param str administrator_type: Type of the sever administrator.
        :param bool azure_ad_only_authentication: Azure Active Directory only Authentication enabled.
        :param str login: Login name of the server administrator.
        :param str principal_type: Principal Type of the sever administrator.
        :param str sid: SID (object ID) of the server administrator.
        :param str tenant_id: Tenant ID of the administrator.
        """
        if administrator_type is not None:
            pulumi.set(__self__, "administrator_type", administrator_type)
        if azure_ad_only_authentication is not None:
            pulumi.set(__self__, "azure_ad_only_authentication", azure_ad_only_authentication)
        if login is not None:
            pulumi.set(__self__, "login", login)
        if principal_type is not None:
            pulumi.set(__self__, "principal_type", principal_type)
        if sid is not None:
            pulumi.set(__self__, "sid", sid)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter(name="administratorType")
    def administrator_type(self) -> Optional[str]:
        """
        Type of the sever administrator.
        """
        return pulumi.get(self, "administrator_type")

    @property
    @pulumi.getter(name="azureADOnlyAuthentication")
    def azure_ad_only_authentication(self) -> Optional[bool]:
        """
        Azure Active Directory only Authentication enabled.
        """
        return pulumi.get(self, "azure_ad_only_authentication")

    @property
    @pulumi.getter
    def login(self) -> Optional[str]:
        """
        Login name of the server administrator.
        """
        return pulumi.get(self, "login")

    @property
    @pulumi.getter(name="principalType")
    def principal_type(self) -> Optional[str]:
        """
        Principal Type of the sever administrator.
        """
        return pulumi.get(self, "principal_type")

    @property
    @pulumi.getter
    def sid(self) -> Optional[str]:
        """
        SID (object ID) of the server administrator.
        """
        return pulumi.get(self, "sid")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[str]:
        """
        Tenant ID of the administrator.
        """
        return pulumi.get(self, "tenant_id")


@pulumi.output_type
class ManagedInstancePairInfoResponse(dict):
    """
    Pairs of Managed Instances in the failover group.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "partnerManagedInstanceId":
            suggest = "partner_managed_instance_id"
        elif key == "primaryManagedInstanceId":
            suggest = "primary_managed_instance_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagedInstancePairInfoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagedInstancePairInfoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagedInstancePairInfoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 partner_managed_instance_id: Optional[str] = None,
                 primary_managed_instance_id: Optional[str] = None):
        """
        Pairs of Managed Instances in the failover group.
        :param str partner_managed_instance_id: Id of Partner Managed Instance in pair.
        :param str primary_managed_instance_id: Id of Primary Managed Instance in pair.
        """
        if partner_managed_instance_id is not None:
            pulumi.set(__self__, "partner_managed_instance_id", partner_managed_instance_id)
        if primary_managed_instance_id is not None:
            pulumi.set(__self__, "primary_managed_instance_id", primary_managed_instance_id)

    @property
    @pulumi.getter(name="partnerManagedInstanceId")
    def partner_managed_instance_id(self) -> Optional[str]:
        """
        Id of Partner Managed Instance in pair.
        """
        return pulumi.get(self, "partner_managed_instance_id")

    @property
    @pulumi.getter(name="primaryManagedInstanceId")
    def primary_managed_instance_id(self) -> Optional[str]:
        """
        Id of Primary Managed Instance in pair.
        """
        return pulumi.get(self, "primary_managed_instance_id")


@pulumi.output_type
class ManagedInstancePecPropertyResponse(dict):
    """
    A private endpoint connection under a managed instance
    """
    def __init__(__self__, *,
                 id: str,
                 properties: 'outputs.ManagedInstancePrivateEndpointConnectionPropertiesResponse'):
        """
        A private endpoint connection under a managed instance
        :param str id: Resource ID.
        :param 'ManagedInstancePrivateEndpointConnectionPropertiesResponse' properties: Private endpoint connection properties
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "properties", properties)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def properties(self) -> 'outputs.ManagedInstancePrivateEndpointConnectionPropertiesResponse':
        """
        Private endpoint connection properties
        """
        return pulumi.get(self, "properties")


@pulumi.output_type
class ManagedInstancePrivateEndpointConnectionPropertiesResponse(dict):
    """
    Properties of a private endpoint connection.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "privateEndpoint":
            suggest = "private_endpoint"
        elif key == "privateLinkServiceConnectionState":
            suggest = "private_link_service_connection_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagedInstancePrivateEndpointConnectionPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagedInstancePrivateEndpointConnectionPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagedInstancePrivateEndpointConnectionPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 provisioning_state: str,
                 private_endpoint: Optional['outputs.ManagedInstancePrivateEndpointPropertyResponse'] = None,
                 private_link_service_connection_state: Optional['outputs.ManagedInstancePrivateLinkServiceConnectionStatePropertyResponse'] = None):
        """
        Properties of a private endpoint connection.
        :param str provisioning_state: State of the Private Endpoint Connection.
        :param 'ManagedInstancePrivateEndpointPropertyResponse' private_endpoint: Private endpoint which the connection belongs to.
        :param 'ManagedInstancePrivateLinkServiceConnectionStatePropertyResponse' private_link_service_connection_state: Connection State of the Private Endpoint Connection.
        """
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if private_endpoint is not None:
            pulumi.set(__self__, "private_endpoint", private_endpoint)
        if private_link_service_connection_state is not None:
            pulumi.set(__self__, "private_link_service_connection_state", private_link_service_connection_state)

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        State of the Private Endpoint Connection.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="privateEndpoint")
    def private_endpoint(self) -> Optional['outputs.ManagedInstancePrivateEndpointPropertyResponse']:
        """
        Private endpoint which the connection belongs to.
        """
        return pulumi.get(self, "private_endpoint")

    @property
    @pulumi.getter(name="privateLinkServiceConnectionState")
    def private_link_service_connection_state(self) -> Optional['outputs.ManagedInstancePrivateLinkServiceConnectionStatePropertyResponse']:
        """
        Connection State of the Private Endpoint Connection.
        """
        return pulumi.get(self, "private_link_service_connection_state")


@pulumi.output_type
class ManagedInstancePrivateEndpointPropertyResponse(dict):
    def __init__(__self__, *,
                 id: Optional[str] = None):
        """
        :param str id: Resource id of the private endpoint.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource id of the private endpoint.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class ManagedInstancePrivateLinkServiceConnectionStatePropertyResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "actionsRequired":
            suggest = "actions_required"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagedInstancePrivateLinkServiceConnectionStatePropertyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagedInstancePrivateLinkServiceConnectionStatePropertyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagedInstancePrivateLinkServiceConnectionStatePropertyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 actions_required: str,
                 description: str,
                 status: str):
        """
        :param str actions_required: The private link service connection description.
        :param str description: The private link service connection description.
        :param str status: The private link service connection status.
        """
        pulumi.set(__self__, "actions_required", actions_required)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="actionsRequired")
    def actions_required(self) -> str:
        """
        The private link service connection description.
        """
        return pulumi.get(self, "actions_required")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The private link service connection description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The private link service connection status.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class PartnerInfoResponse(dict):
    """
    Partner server information for the failover group.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "replicationRole":
            suggest = "replication_role"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PartnerInfoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PartnerInfoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PartnerInfoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: str,
                 location: str,
                 replication_role: str):
        """
        Partner server information for the failover group.
        :param str id: Resource identifier of the partner server.
        :param str location: Geo location of the partner server.
        :param str replication_role: Replication role of the partner server.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "replication_role", replication_role)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Resource identifier of the partner server.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def location(self) -> str:
        """
        Geo location of the partner server.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="replicationRole")
    def replication_role(self) -> str:
        """
        Replication role of the partner server.
        """
        return pulumi.get(self, "replication_role")


@pulumi.output_type
class PartnerRegionInfoResponse(dict):
    """
    Partner region information for the failover group.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "replicationRole":
            suggest = "replication_role"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PartnerRegionInfoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PartnerRegionInfoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PartnerRegionInfoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 replication_role: str,
                 location: Optional[str] = None):
        """
        Partner region information for the failover group.
        :param str replication_role: Replication role of the partner managed instances.
        :param str location: Geo location of the partner managed instances.
        """
        pulumi.set(__self__, "replication_role", replication_role)
        if location is not None:
            pulumi.set(__self__, "location", location)

    @property
    @pulumi.getter(name="replicationRole")
    def replication_role(self) -> str:
        """
        Replication role of the partner managed instances.
        """
        return pulumi.get(self, "replication_role")

    @property
    @pulumi.getter
    def location(self) -> Optional[str]:
        """
        Geo location of the partner managed instances.
        """
        return pulumi.get(self, "location")


@pulumi.output_type
class PrivateEndpointConnectionPropertiesResponse(dict):
    """
    Properties of a private endpoint connection.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "groupIds":
            suggest = "group_ids"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "privateEndpoint":
            suggest = "private_endpoint"
        elif key == "privateLinkServiceConnectionState":
            suggest = "private_link_service_connection_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PrivateEndpointConnectionPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PrivateEndpointConnectionPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PrivateEndpointConnectionPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 group_ids: Sequence[str],
                 provisioning_state: str,
                 private_endpoint: Optional['outputs.PrivateEndpointPropertyResponse'] = None,
                 private_link_service_connection_state: Optional['outputs.PrivateLinkServiceConnectionStatePropertyResponse'] = None):
        """
        Properties of a private endpoint connection.
        :param Sequence[str] group_ids: Group IDs.
        :param str provisioning_state: State of the private endpoint connection.
        :param 'PrivateEndpointPropertyResponse' private_endpoint: Private endpoint which the connection belongs to.
        :param 'PrivateLinkServiceConnectionStatePropertyResponse' private_link_service_connection_state: Connection state of the private endpoint connection.
        """
        pulumi.set(__self__, "group_ids", group_ids)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if private_endpoint is not None:
            pulumi.set(__self__, "private_endpoint", private_endpoint)
        if private_link_service_connection_state is not None:
            pulumi.set(__self__, "private_link_service_connection_state", private_link_service_connection_state)

    @property
    @pulumi.getter(name="groupIds")
    def group_ids(self) -> Sequence[str]:
        """
        Group IDs.
        """
        return pulumi.get(self, "group_ids")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        State of the private endpoint connection.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="privateEndpoint")
    def private_endpoint(self) -> Optional['outputs.PrivateEndpointPropertyResponse']:
        """
        Private endpoint which the connection belongs to.
        """
        return pulumi.get(self, "private_endpoint")

    @property
    @pulumi.getter(name="privateLinkServiceConnectionState")
    def private_link_service_connection_state(self) -> Optional['outputs.PrivateLinkServiceConnectionStatePropertyResponse']:
        """
        Connection state of the private endpoint connection.
        """
        return pulumi.get(self, "private_link_service_connection_state")


@pulumi.output_type
class PrivateEndpointPropertyResponse(dict):
    def __init__(__self__, *,
                 id: Optional[str] = None):
        """
        :param str id: Resource id of the private endpoint.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource id of the private endpoint.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class PrivateLinkServiceConnectionStatePropertyResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "actionsRequired":
            suggest = "actions_required"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PrivateLinkServiceConnectionStatePropertyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PrivateLinkServiceConnectionStatePropertyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PrivateLinkServiceConnectionStatePropertyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 actions_required: str,
                 description: str,
                 status: str):
        """
        :param str actions_required: The actions required for private link service connection.
        :param str description: The private link service connection description.
        :param str status: The private link service connection status.
        """
        pulumi.set(__self__, "actions_required", actions_required)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="actionsRequired")
    def actions_required(self) -> str:
        """
        The actions required for private link service connection.
        """
        return pulumi.get(self, "actions_required")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The private link service connection description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The private link service connection status.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class RecommendedActionErrorInfoResponse(dict):
    """
    Contains error information for an Azure SQL Database, Server or Elastic Pool Recommended Action.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "errorCode":
            suggest = "error_code"
        elif key == "isRetryable":
            suggest = "is_retryable"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RecommendedActionErrorInfoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RecommendedActionErrorInfoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RecommendedActionErrorInfoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 error_code: str,
                 is_retryable: str):
        """
        Contains error information for an Azure SQL Database, Server or Elastic Pool Recommended Action.
        :param str error_code: Gets the reason why the recommended action was put to error state. e.g., DatabaseHasQdsOff, IndexAlreadyExists
        :param str is_retryable: Gets whether the error could be ignored and recommended action could be retried. Possible values are: Yes/No
        """
        pulumi.set(__self__, "error_code", error_code)
        pulumi.set(__self__, "is_retryable", is_retryable)

    @property
    @pulumi.getter(name="errorCode")
    def error_code(self) -> str:
        """
        Gets the reason why the recommended action was put to error state. e.g., DatabaseHasQdsOff, IndexAlreadyExists
        """
        return pulumi.get(self, "error_code")

    @property
    @pulumi.getter(name="isRetryable")
    def is_retryable(self) -> str:
        """
        Gets whether the error could be ignored and recommended action could be retried. Possible values are: Yes/No
        """
        return pulumi.get(self, "is_retryable")


@pulumi.output_type
class RecommendedActionImpactRecordResponse(dict):
    """
    Contains information of estimated or observed impact on various metrics for an Azure SQL Database, Server or Elastic Pool Recommended Action.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "absoluteValue":
            suggest = "absolute_value"
        elif key == "changeValueAbsolute":
            suggest = "change_value_absolute"
        elif key == "changeValueRelative":
            suggest = "change_value_relative"
        elif key == "dimensionName":
            suggest = "dimension_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RecommendedActionImpactRecordResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RecommendedActionImpactRecordResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RecommendedActionImpactRecordResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 absolute_value: float,
                 change_value_absolute: float,
                 change_value_relative: float,
                 dimension_name: str,
                 unit: str):
        """
        Contains information of estimated or observed impact on various metrics for an Azure SQL Database, Server or Elastic Pool Recommended Action.
        :param float absolute_value: Gets the absolute value of this dimension if applicable. e.g., Number of Queries affected
        :param float change_value_absolute: Gets the absolute change in the value of this dimension. e.g., Absolute Disk space change in Megabytes
        :param float change_value_relative: Gets the relative change in the value of this dimension. e.g., Relative Disk space change in Percentage
        :param str dimension_name: Gets the name of the impact dimension. e.g., CPUChange, DiskSpaceChange, NumberOfQueriesAffected.
        :param str unit: Gets the name of the impact dimension. e.g., CPUChange, DiskSpaceChange, NumberOfQueriesAffected.
        """
        pulumi.set(__self__, "absolute_value", absolute_value)
        pulumi.set(__self__, "change_value_absolute", change_value_absolute)
        pulumi.set(__self__, "change_value_relative", change_value_relative)
        pulumi.set(__self__, "dimension_name", dimension_name)
        pulumi.set(__self__, "unit", unit)

    @property
    @pulumi.getter(name="absoluteValue")
    def absolute_value(self) -> float:
        """
        Gets the absolute value of this dimension if applicable. e.g., Number of Queries affected
        """
        return pulumi.get(self, "absolute_value")

    @property
    @pulumi.getter(name="changeValueAbsolute")
    def change_value_absolute(self) -> float:
        """
        Gets the absolute change in the value of this dimension. e.g., Absolute Disk space change in Megabytes
        """
        return pulumi.get(self, "change_value_absolute")

    @property
    @pulumi.getter(name="changeValueRelative")
    def change_value_relative(self) -> float:
        """
        Gets the relative change in the value of this dimension. e.g., Relative Disk space change in Percentage
        """
        return pulumi.get(self, "change_value_relative")

    @property
    @pulumi.getter(name="dimensionName")
    def dimension_name(self) -> str:
        """
        Gets the name of the impact dimension. e.g., CPUChange, DiskSpaceChange, NumberOfQueriesAffected.
        """
        return pulumi.get(self, "dimension_name")

    @property
    @pulumi.getter
    def unit(self) -> str:
        """
        Gets the name of the impact dimension. e.g., CPUChange, DiskSpaceChange, NumberOfQueriesAffected.
        """
        return pulumi.get(self, "unit")


@pulumi.output_type
class RecommendedActionImplementationInfoResponse(dict):
    """
    Contains information for manual implementation for an Azure SQL Database, Server or Elastic Pool Recommended Action.
    """
    def __init__(__self__, *,
                 method: str,
                 script: str):
        """
        Contains information for manual implementation for an Azure SQL Database, Server or Elastic Pool Recommended Action.
        :param str method: Gets the method in which this recommended action can be manually implemented. e.g., TSql, AzurePowerShell.
        :param str script: Gets the manual implementation script. e.g., T-SQL script that could be executed on the database.
        """
        pulumi.set(__self__, "method", method)
        pulumi.set(__self__, "script", script)

    @property
    @pulumi.getter
    def method(self) -> str:
        """
        Gets the method in which this recommended action can be manually implemented. e.g., TSql, AzurePowerShell.
        """
        return pulumi.get(self, "method")

    @property
    @pulumi.getter
    def script(self) -> str:
        """
        Gets the manual implementation script. e.g., T-SQL script that could be executed on the database.
        """
        return pulumi.get(self, "script")


@pulumi.output_type
class RecommendedActionMetricInfoResponse(dict):
    """
    Contains time series of various impacted metrics for an Azure SQL Database, Server or Elastic Pool Recommended Action.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "metricName":
            suggest = "metric_name"
        elif key == "startTime":
            suggest = "start_time"
        elif key == "timeGrain":
            suggest = "time_grain"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RecommendedActionMetricInfoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RecommendedActionMetricInfoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RecommendedActionMetricInfoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 metric_name: str,
                 start_time: str,
                 time_grain: str,
                 unit: str,
                 value: float):
        """
        Contains time series of various impacted metrics for an Azure SQL Database, Server or Elastic Pool Recommended Action.
        :param str metric_name: Gets the name of the metric. e.g., CPU, Number of Queries.
        :param str start_time: Gets the start time of time interval given by this MetricInfo.
        :param str time_grain: Gets the duration of time interval for the value given by this MetricInfo. e.g., PT1H (1 hour)
        :param str unit: Gets the unit in which metric is measured. e.g., DTU, Frequency
        :param float value: Gets the value of the metric in the time interval given by this MetricInfo.
        """
        pulumi.set(__self__, "metric_name", metric_name)
        pulumi.set(__self__, "start_time", start_time)
        pulumi.set(__self__, "time_grain", time_grain)
        pulumi.set(__self__, "unit", unit)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter(name="metricName")
    def metric_name(self) -> str:
        """
        Gets the name of the metric. e.g., CPU, Number of Queries.
        """
        return pulumi.get(self, "metric_name")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> str:
        """
        Gets the start time of time interval given by this MetricInfo.
        """
        return pulumi.get(self, "start_time")

    @property
    @pulumi.getter(name="timeGrain")
    def time_grain(self) -> str:
        """
        Gets the duration of time interval for the value given by this MetricInfo. e.g., PT1H (1 hour)
        """
        return pulumi.get(self, "time_grain")

    @property
    @pulumi.getter
    def unit(self) -> str:
        """
        Gets the unit in which metric is measured. e.g., DTU, Frequency
        """
        return pulumi.get(self, "unit")

    @property
    @pulumi.getter
    def value(self) -> float:
        """
        Gets the value of the metric in the time interval given by this MetricInfo.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class RecommendedActionResponse(dict):
    """
    Database, Server or Elastic Pool Recommended Action.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "errorDetails":
            suggest = "error_details"
        elif key == "estimatedImpact":
            suggest = "estimated_impact"
        elif key == "executeActionDuration":
            suggest = "execute_action_duration"
        elif key == "executeActionInitiatedBy":
            suggest = "execute_action_initiated_by"
        elif key == "executeActionInitiatedTime":
            suggest = "execute_action_initiated_time"
        elif key == "executeActionStartTime":
            suggest = "execute_action_start_time"
        elif key == "implementationDetails":
            suggest = "implementation_details"
        elif key == "isArchivedAction":
            suggest = "is_archived_action"
        elif key == "isExecutableAction":
            suggest = "is_executable_action"
        elif key == "isRevertableAction":
            suggest = "is_revertable_action"
        elif key == "lastRefresh":
            suggest = "last_refresh"
        elif key == "linkedObjects":
            suggest = "linked_objects"
        elif key == "observedImpact":
            suggest = "observed_impact"
        elif key == "recommendationReason":
            suggest = "recommendation_reason"
        elif key == "revertActionDuration":
            suggest = "revert_action_duration"
        elif key == "revertActionInitiatedBy":
            suggest = "revert_action_initiated_by"
        elif key == "revertActionInitiatedTime":
            suggest = "revert_action_initiated_time"
        elif key == "revertActionStartTime":
            suggest = "revert_action_start_time"
        elif key == "timeSeries":
            suggest = "time_series"
        elif key == "validSince":
            suggest = "valid_since"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RecommendedActionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RecommendedActionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RecommendedActionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 details: Mapping[str, Any],
                 error_details: 'outputs.RecommendedActionErrorInfoResponse',
                 estimated_impact: Sequence['outputs.RecommendedActionImpactRecordResponse'],
                 execute_action_duration: str,
                 execute_action_initiated_by: str,
                 execute_action_initiated_time: str,
                 execute_action_start_time: str,
                 id: str,
                 implementation_details: 'outputs.RecommendedActionImplementationInfoResponse',
                 is_archived_action: bool,
                 is_executable_action: bool,
                 is_revertable_action: bool,
                 kind: str,
                 last_refresh: str,
                 linked_objects: Sequence[str],
                 location: str,
                 name: str,
                 observed_impact: Sequence['outputs.RecommendedActionImpactRecordResponse'],
                 recommendation_reason: str,
                 revert_action_duration: str,
                 revert_action_initiated_by: str,
                 revert_action_initiated_time: str,
                 revert_action_start_time: str,
                 score: int,
                 state: 'outputs.RecommendedActionStateInfoResponse',
                 time_series: Sequence['outputs.RecommendedActionMetricInfoResponse'],
                 type: str,
                 valid_since: str):
        """
        Database, Server or Elastic Pool Recommended Action.
        :param Mapping[str, Any] details: Gets additional details specific to this recommended action.
        :param 'RecommendedActionErrorInfoResponse' error_details: Gets the error details if and why this recommended action is put to error state.
        :param Sequence['RecommendedActionImpactRecordResponse'] estimated_impact: Gets the estimated impact info for this recommended action e.g., Estimated CPU gain, Estimated Disk Space change
        :param str execute_action_duration: Gets the time taken for applying this recommended action on user resource. e.g., time taken for index creation
        :param str execute_action_initiated_by: Gets if approval for applying this recommended action was given by user/system.
        :param str execute_action_initiated_time: Gets the time when this recommended action was approved for execution.
        :param str execute_action_start_time: Gets the time when system started applying this recommended action on the user resource. e.g., index creation start time
        :param str id: Resource ID.
        :param 'RecommendedActionImplementationInfoResponse' implementation_details: Gets the implementation details of this recommended action for user to apply it manually.
        :param bool is_archived_action: Gets if this recommended action was suggested some time ago but user chose to ignore this and system added a new recommended action again.
        :param bool is_executable_action: Gets if this recommended action is actionable by user
        :param bool is_revertable_action: Gets if changes applied by this recommended action can be reverted by user
        :param str kind: Resource kind.
        :param str last_refresh: Gets time when this recommended action was last refreshed.
        :param Sequence[str] linked_objects: Gets the linked objects, if any.
        :param str location: Resource location.
        :param str name: Resource name.
        :param Sequence['RecommendedActionImpactRecordResponse'] observed_impact: Gets the observed/actual impact info for this recommended action e.g., Actual CPU gain, Actual Disk Space change
        :param str recommendation_reason: Gets the reason for recommending this action. e.g., DuplicateIndex
        :param str revert_action_duration: Gets the time taken for reverting changes of this recommended action on user resource. e.g., time taken for dropping the created index.
        :param str revert_action_initiated_by: Gets if approval for reverting this recommended action was given by user/system.
        :param str revert_action_initiated_time: Gets the time when this recommended action was approved for revert.
        :param str revert_action_start_time: Gets the time when system started reverting changes of this recommended action on user resource. e.g., time when index drop is executed.
        :param int score: Gets the impact of this recommended action. Possible values are 1 - Low impact, 2 - Medium Impact and 3 - High Impact
        :param 'RecommendedActionStateInfoResponse' state: Gets the info of the current state the recommended action is in.
        :param Sequence['RecommendedActionMetricInfoResponse'] time_series: Gets the time series info of metrics for this recommended action e.g., CPU consumption time series
        :param str type: Resource type.
        :param str valid_since: Gets the time since when this recommended action is valid.
        """
        pulumi.set(__self__, "details", details)
        pulumi.set(__self__, "error_details", error_details)
        pulumi.set(__self__, "estimated_impact", estimated_impact)
        pulumi.set(__self__, "execute_action_duration", execute_action_duration)
        pulumi.set(__self__, "execute_action_initiated_by", execute_action_initiated_by)
        pulumi.set(__self__, "execute_action_initiated_time", execute_action_initiated_time)
        pulumi.set(__self__, "execute_action_start_time", execute_action_start_time)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "implementation_details", implementation_details)
        pulumi.set(__self__, "is_archived_action", is_archived_action)
        pulumi.set(__self__, "is_executable_action", is_executable_action)
        pulumi.set(__self__, "is_revertable_action", is_revertable_action)
        pulumi.set(__self__, "kind", kind)
        pulumi.set(__self__, "last_refresh", last_refresh)
        pulumi.set(__self__, "linked_objects", linked_objects)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "observed_impact", observed_impact)
        pulumi.set(__self__, "recommendation_reason", recommendation_reason)
        pulumi.set(__self__, "revert_action_duration", revert_action_duration)
        pulumi.set(__self__, "revert_action_initiated_by", revert_action_initiated_by)
        pulumi.set(__self__, "revert_action_initiated_time", revert_action_initiated_time)
        pulumi.set(__self__, "revert_action_start_time", revert_action_start_time)
        pulumi.set(__self__, "score", score)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "time_series", time_series)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "valid_since", valid_since)

    @property
    @pulumi.getter
    def details(self) -> Mapping[str, Any]:
        """
        Gets additional details specific to this recommended action.
        """
        return pulumi.get(self, "details")

    @property
    @pulumi.getter(name="errorDetails")
    def error_details(self) -> 'outputs.RecommendedActionErrorInfoResponse':
        """
        Gets the error details if and why this recommended action is put to error state.
        """
        return pulumi.get(self, "error_details")

    @property
    @pulumi.getter(name="estimatedImpact")
    def estimated_impact(self) -> Sequence['outputs.RecommendedActionImpactRecordResponse']:
        """
        Gets the estimated impact info for this recommended action e.g., Estimated CPU gain, Estimated Disk Space change
        """
        return pulumi.get(self, "estimated_impact")

    @property
    @pulumi.getter(name="executeActionDuration")
    def execute_action_duration(self) -> str:
        """
        Gets the time taken for applying this recommended action on user resource. e.g., time taken for index creation
        """
        return pulumi.get(self, "execute_action_duration")

    @property
    @pulumi.getter(name="executeActionInitiatedBy")
    def execute_action_initiated_by(self) -> str:
        """
        Gets if approval for applying this recommended action was given by user/system.
        """
        return pulumi.get(self, "execute_action_initiated_by")

    @property
    @pulumi.getter(name="executeActionInitiatedTime")
    def execute_action_initiated_time(self) -> str:
        """
        Gets the time when this recommended action was approved for execution.
        """
        return pulumi.get(self, "execute_action_initiated_time")

    @property
    @pulumi.getter(name="executeActionStartTime")
    def execute_action_start_time(self) -> str:
        """
        Gets the time when system started applying this recommended action on the user resource. e.g., index creation start time
        """
        return pulumi.get(self, "execute_action_start_time")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="implementationDetails")
    def implementation_details(self) -> 'outputs.RecommendedActionImplementationInfoResponse':
        """
        Gets the implementation details of this recommended action for user to apply it manually.
        """
        return pulumi.get(self, "implementation_details")

    @property
    @pulumi.getter(name="isArchivedAction")
    def is_archived_action(self) -> bool:
        """
        Gets if this recommended action was suggested some time ago but user chose to ignore this and system added a new recommended action again.
        """
        return pulumi.get(self, "is_archived_action")

    @property
    @pulumi.getter(name="isExecutableAction")
    def is_executable_action(self) -> bool:
        """
        Gets if this recommended action is actionable by user
        """
        return pulumi.get(self, "is_executable_action")

    @property
    @pulumi.getter(name="isRevertableAction")
    def is_revertable_action(self) -> bool:
        """
        Gets if changes applied by this recommended action can be reverted by user
        """
        return pulumi.get(self, "is_revertable_action")

    @property
    @pulumi.getter
    def kind(self) -> str:
        """
        Resource kind.
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter(name="lastRefresh")
    def last_refresh(self) -> str:
        """
        Gets time when this recommended action was last refreshed.
        """
        return pulumi.get(self, "last_refresh")

    @property
    @pulumi.getter(name="linkedObjects")
    def linked_objects(self) -> Sequence[str]:
        """
        Gets the linked objects, if any.
        """
        return pulumi.get(self, "linked_objects")

    @property
    @pulumi.getter
    def location(self) -> str:
        """
        Resource location.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Resource name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="observedImpact")
    def observed_impact(self) -> Sequence['outputs.RecommendedActionImpactRecordResponse']:
        """
        Gets the observed/actual impact info for this recommended action e.g., Actual CPU gain, Actual Disk Space change
        """
        return pulumi.get(self, "observed_impact")

    @property
    @pulumi.getter(name="recommendationReason")
    def recommendation_reason(self) -> str:
        """
        Gets the reason for recommending this action. e.g., DuplicateIndex
        """
        return pulumi.get(self, "recommendation_reason")

    @property
    @pulumi.getter(name="revertActionDuration")
    def revert_action_duration(self) -> str:
        """
        Gets the time taken for reverting changes of this recommended action on user resource. e.g., time taken for dropping the created index.
        """
        return pulumi.get(self, "revert_action_duration")

    @property
    @pulumi.getter(name="revertActionInitiatedBy")
    def revert_action_initiated_by(self) -> str:
        """
        Gets if approval for reverting this recommended action was given by user/system.
        """
        return pulumi.get(self, "revert_action_initiated_by")

    @property
    @pulumi.getter(name="revertActionInitiatedTime")
    def revert_action_initiated_time(self) -> str:
        """
        Gets the time when this recommended action was approved for revert.
        """
        return pulumi.get(self, "revert_action_initiated_time")

    @property
    @pulumi.getter(name="revertActionStartTime")
    def revert_action_start_time(self) -> str:
        """
        Gets the time when system started reverting changes of this recommended action on user resource. e.g., time when index drop is executed.
        """
        return pulumi.get(self, "revert_action_start_time")

    @property
    @pulumi.getter
    def score(self) -> int:
        """
        Gets the impact of this recommended action. Possible values are 1 - Low impact, 2 - Medium Impact and 3 - High Impact
        """
        return pulumi.get(self, "score")

    @property
    @pulumi.getter
    def state(self) -> 'outputs.RecommendedActionStateInfoResponse':
        """
        Gets the info of the current state the recommended action is in.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeSeries")
    def time_series(self) -> Sequence['outputs.RecommendedActionMetricInfoResponse']:
        """
        Gets the time series info of metrics for this recommended action e.g., CPU consumption time series
        """
        return pulumi.get(self, "time_series")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Resource type.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="validSince")
    def valid_since(self) -> str:
        """
        Gets the time since when this recommended action is valid.
        """
        return pulumi.get(self, "valid_since")


@pulumi.output_type
class RecommendedActionStateInfoResponse(dict):
    """
    Contains information of current state for an Azure SQL Database, Server or Elastic Pool Recommended Action.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "actionInitiatedBy":
            suggest = "action_initiated_by"
        elif key == "currentValue":
            suggest = "current_value"
        elif key == "lastModified":
            suggest = "last_modified"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RecommendedActionStateInfoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RecommendedActionStateInfoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RecommendedActionStateInfoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 action_initiated_by: str,
                 current_value: str,
                 last_modified: str):
        """
        Contains information of current state for an Azure SQL Database, Server or Elastic Pool Recommended Action.
        :param str action_initiated_by: Gets who initiated the execution of this recommended action. Possible Value are: User    -> When user explicity notified system to apply the recommended action. System  -> When auto-execute status of this advisor was set to 'Enabled', in which case the system applied it.
        :param str current_value: Current state the recommended action is in. Some commonly used states are: Active      -> recommended action is active and no action has been taken yet. Pending     -> recommended action is approved for and is awaiting execution. Executing   -> recommended action is being applied on the user database. Verifying   -> recommended action was applied and is being verified of its usefulness by the system. Success     -> recommended action was applied and improvement found during verification. Pending Revert  -> verification found little or no improvement so recommended action is queued for revert or user has manually reverted. Reverting   -> changes made while applying recommended action are being reverted on the user database. Reverted    -> successfully reverted the changes made by recommended action on user database. Ignored     -> user explicitly ignored/discarded the recommended action. 
        :param str last_modified: Gets the time when the state was last modified
        """
        pulumi.set(__self__, "action_initiated_by", action_initiated_by)
        pulumi.set(__self__, "current_value", current_value)
        pulumi.set(__self__, "last_modified", last_modified)

    @property
    @pulumi.getter(name="actionInitiatedBy")
    def action_initiated_by(self) -> str:
        """
        Gets who initiated the execution of this recommended action. Possible Value are: User    -> When user explicity notified system to apply the recommended action. System  -> When auto-execute status of this advisor was set to 'Enabled', in which case the system applied it.
        """
        return pulumi.get(self, "action_initiated_by")

    @property
    @pulumi.getter(name="currentValue")
    def current_value(self) -> str:
        """
        Current state the recommended action is in. Some commonly used states are: Active      -> recommended action is active and no action has been taken yet. Pending     -> recommended action is approved for and is awaiting execution. Executing   -> recommended action is being applied on the user database. Verifying   -> recommended action was applied and is being verified of its usefulness by the system. Success     -> recommended action was applied and improvement found during verification. Pending Revert  -> verification found little or no improvement so recommended action is queued for revert or user has manually reverted. Reverting   -> changes made while applying recommended action are being reverted on the user database. Reverted    -> successfully reverted the changes made by recommended action on user database. Ignored     -> user explicitly ignored/discarded the recommended action. 
        """
        return pulumi.get(self, "current_value")

    @property
    @pulumi.getter(name="lastModified")
    def last_modified(self) -> str:
        """
        Gets the time when the state was last modified
        """
        return pulumi.get(self, "last_modified")


@pulumi.output_type
class ResourceIdentityResponse(dict):
    """
    Azure Active Directory identity configuration for a resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "principalId":
            suggest = "principal_id"
        elif key == "tenantId":
            suggest = "tenant_id"
        elif key == "userAssignedIdentities":
            suggest = "user_assigned_identities"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourceIdentityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourceIdentityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourceIdentityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 principal_id: str,
                 tenant_id: str,
                 type: Optional[str] = None,
                 user_assigned_identities: Optional[Mapping[str, 'outputs.UserIdentityResponse']] = None):
        """
        Azure Active Directory identity configuration for a resource.
        :param str principal_id: The Azure Active Directory principal id.
        :param str tenant_id: The Azure Active Directory tenant id.
        :param str type: The identity type. Set this to 'SystemAssigned' in order to automatically create and assign an Azure Active Directory principal for the resource.
        :param Mapping[str, 'UserIdentityResponse'] user_assigned_identities: The resource ids of the user assigned identities to use
        """
        pulumi.set(__self__, "principal_id", principal_id)
        pulumi.set(__self__, "tenant_id", tenant_id)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if user_assigned_identities is not None:
            pulumi.set(__self__, "user_assigned_identities", user_assigned_identities)

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> str:
        """
        The Azure Active Directory principal id.
        """
        return pulumi.get(self, "principal_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> str:
        """
        The Azure Active Directory tenant id.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The identity type. Set this to 'SystemAssigned' in order to automatically create and assign an Azure Active Directory principal for the resource.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="userAssignedIdentities")
    def user_assigned_identities(self) -> Optional[Mapping[str, 'outputs.UserIdentityResponse']]:
        """
        The resource ids of the user assigned identities to use
        """
        return pulumi.get(self, "user_assigned_identities")


@pulumi.output_type
class ServerExternalAdministratorResponse(dict):
    """
    Properties of a active directory administrator.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "administratorType":
            suggest = "administrator_type"
        elif key == "azureADOnlyAuthentication":
            suggest = "azure_ad_only_authentication"
        elif key == "principalType":
            suggest = "principal_type"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServerExternalAdministratorResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServerExternalAdministratorResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServerExternalAdministratorResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 administrator_type: Optional[str] = None,
                 azure_ad_only_authentication: Optional[bool] = None,
                 login: Optional[str] = None,
                 principal_type: Optional[str] = None,
                 sid: Optional[str] = None,
                 tenant_id: Optional[str] = None):
        """
        Properties of a active directory administrator.
        :param str administrator_type: Type of the sever administrator.
        :param bool azure_ad_only_authentication: Azure Active Directory only Authentication enabled.
        :param str login: Login name of the server administrator.
        :param str principal_type: Principal Type of the sever administrator.
        :param str sid: SID (object ID) of the server administrator.
        :param str tenant_id: Tenant ID of the administrator.
        """
        if administrator_type is not None:
            pulumi.set(__self__, "administrator_type", administrator_type)
        if azure_ad_only_authentication is not None:
            pulumi.set(__self__, "azure_ad_only_authentication", azure_ad_only_authentication)
        if login is not None:
            pulumi.set(__self__, "login", login)
        if principal_type is not None:
            pulumi.set(__self__, "principal_type", principal_type)
        if sid is not None:
            pulumi.set(__self__, "sid", sid)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter(name="administratorType")
    def administrator_type(self) -> Optional[str]:
        """
        Type of the sever administrator.
        """
        return pulumi.get(self, "administrator_type")

    @property
    @pulumi.getter(name="azureADOnlyAuthentication")
    def azure_ad_only_authentication(self) -> Optional[bool]:
        """
        Azure Active Directory only Authentication enabled.
        """
        return pulumi.get(self, "azure_ad_only_authentication")

    @property
    @pulumi.getter
    def login(self) -> Optional[str]:
        """
        Login name of the server administrator.
        """
        return pulumi.get(self, "login")

    @property
    @pulumi.getter(name="principalType")
    def principal_type(self) -> Optional[str]:
        """
        Principal Type of the sever administrator.
        """
        return pulumi.get(self, "principal_type")

    @property
    @pulumi.getter
    def sid(self) -> Optional[str]:
        """
        SID (object ID) of the server administrator.
        """
        return pulumi.get(self, "sid")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[str]:
        """
        Tenant ID of the administrator.
        """
        return pulumi.get(self, "tenant_id")


@pulumi.output_type
class ServerInfoResponse(dict):
    """
    Server info for the server trust group.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "serverId":
            suggest = "server_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServerInfoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServerInfoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServerInfoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 server_id: str):
        """
        Server info for the server trust group.
        :param str server_id: Server Id.
        """
        pulumi.set(__self__, "server_id", server_id)

    @property
    @pulumi.getter(name="serverId")
    def server_id(self) -> str:
        """
        Server Id.
        """
        return pulumi.get(self, "server_id")


@pulumi.output_type
class ServerPrivateEndpointConnectionResponse(dict):
    """
    A private endpoint connection under a server
    """
    def __init__(__self__, *,
                 id: str,
                 properties: 'outputs.PrivateEndpointConnectionPropertiesResponse'):
        """
        A private endpoint connection under a server
        :param str id: Resource ID.
        :param 'PrivateEndpointConnectionPropertiesResponse' properties: Private endpoint connection properties
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "properties", properties)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def properties(self) -> 'outputs.PrivateEndpointConnectionPropertiesResponse':
        """
        Private endpoint connection properties
        """
        return pulumi.get(self, "properties")


@pulumi.output_type
class ServicePrincipalResponse(dict):
    """
    The managed instance's service principal configuration for a resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientId":
            suggest = "client_id"
        elif key == "principalId":
            suggest = "principal_id"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServicePrincipalResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServicePrincipalResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServicePrincipalResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_id: str,
                 principal_id: str,
                 tenant_id: str,
                 type: Optional[str] = None):
        """
        The managed instance's service principal configuration for a resource.
        :param str client_id: The Azure Active Directory application client id.
        :param str principal_id: The Azure Active Directory application object id.
        :param str tenant_id: The Azure Active Directory tenant id.
        :param str type: Service principal type.
        """
        pulumi.set(__self__, "client_id", client_id)
        pulumi.set(__self__, "principal_id", principal_id)
        pulumi.set(__self__, "tenant_id", tenant_id)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> str:
        """
        The Azure Active Directory application client id.
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> str:
        """
        The Azure Active Directory application object id.
        """
        return pulumi.get(self, "principal_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> str:
        """
        The Azure Active Directory tenant id.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        Service principal type.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class SkuResponse(dict):
    """
    An ARM Resource SKU.
    """
    def __init__(__self__, *,
                 name: str,
                 capacity: Optional[int] = None,
                 family: Optional[str] = None,
                 size: Optional[str] = None,
                 tier: Optional[str] = None):
        """
        An ARM Resource SKU.
        :param str name: The name of the SKU, typically, a letter + Number code, e.g. P3.
        :param int capacity: Capacity of the particular SKU.
        :param str family: If the service has different generations of hardware, for the same SKU, then that can be captured here.
        :param str size: Size of the particular SKU
        :param str tier: The tier or edition of the particular SKU, e.g. Basic, Premium.
        """
        pulumi.set(__self__, "name", name)
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)
        if family is not None:
            pulumi.set(__self__, "family", family)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if tier is not None:
            pulumi.set(__self__, "tier", tier)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the SKU, typically, a letter + Number code, e.g. P3.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def capacity(self) -> Optional[int]:
        """
        Capacity of the particular SKU.
        """
        return pulumi.get(self, "capacity")

    @property
    @pulumi.getter
    def family(self) -> Optional[str]:
        """
        If the service has different generations of hardware, for the same SKU, then that can be captured here.
        """
        return pulumi.get(self, "family")

    @property
    @pulumi.getter
    def size(self) -> Optional[str]:
        """
        Size of the particular SKU
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter
    def tier(self) -> Optional[str]:
        """
        The tier or edition of the particular SKU, e.g. Basic, Premium.
        """
        return pulumi.get(self, "tier")


@pulumi.output_type
class SyncGroupSchemaResponse(dict):
    """
    Properties of sync group schema.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "masterSyncMemberName":
            suggest = "master_sync_member_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SyncGroupSchemaResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SyncGroupSchemaResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SyncGroupSchemaResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 master_sync_member_name: Optional[str] = None,
                 tables: Optional[Sequence['outputs.SyncGroupSchemaTableResponse']] = None):
        """
        Properties of sync group schema.
        :param str master_sync_member_name: Name of master sync member where the schema is from.
        :param Sequence['SyncGroupSchemaTableResponse'] tables: List of tables in sync group schema.
        """
        if master_sync_member_name is not None:
            pulumi.set(__self__, "master_sync_member_name", master_sync_member_name)
        if tables is not None:
            pulumi.set(__self__, "tables", tables)

    @property
    @pulumi.getter(name="masterSyncMemberName")
    def master_sync_member_name(self) -> Optional[str]:
        """
        Name of master sync member where the schema is from.
        """
        return pulumi.get(self, "master_sync_member_name")

    @property
    @pulumi.getter
    def tables(self) -> Optional[Sequence['outputs.SyncGroupSchemaTableResponse']]:
        """
        List of tables in sync group schema.
        """
        return pulumi.get(self, "tables")


@pulumi.output_type
class SyncGroupSchemaTableColumnResponse(dict):
    """
    Properties of column in sync group table.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataSize":
            suggest = "data_size"
        elif key == "dataType":
            suggest = "data_type"
        elif key == "quotedName":
            suggest = "quoted_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SyncGroupSchemaTableColumnResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SyncGroupSchemaTableColumnResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SyncGroupSchemaTableColumnResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data_size: Optional[str] = None,
                 data_type: Optional[str] = None,
                 quoted_name: Optional[str] = None):
        """
        Properties of column in sync group table.
        :param str data_size: Data size of the column.
        :param str data_type: Data type of the column.
        :param str quoted_name: Quoted name of sync group table column.
        """
        if data_size is not None:
            pulumi.set(__self__, "data_size", data_size)
        if data_type is not None:
            pulumi.set(__self__, "data_type", data_type)
        if quoted_name is not None:
            pulumi.set(__self__, "quoted_name", quoted_name)

    @property
    @pulumi.getter(name="dataSize")
    def data_size(self) -> Optional[str]:
        """
        Data size of the column.
        """
        return pulumi.get(self, "data_size")

    @property
    @pulumi.getter(name="dataType")
    def data_type(self) -> Optional[str]:
        """
        Data type of the column.
        """
        return pulumi.get(self, "data_type")

    @property
    @pulumi.getter(name="quotedName")
    def quoted_name(self) -> Optional[str]:
        """
        Quoted name of sync group table column.
        """
        return pulumi.get(self, "quoted_name")


@pulumi.output_type
class SyncGroupSchemaTableResponse(dict):
    """
    Properties of table in sync group schema.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "quotedName":
            suggest = "quoted_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SyncGroupSchemaTableResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SyncGroupSchemaTableResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SyncGroupSchemaTableResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 columns: Optional[Sequence['outputs.SyncGroupSchemaTableColumnResponse']] = None,
                 quoted_name: Optional[str] = None):
        """
        Properties of table in sync group schema.
        :param Sequence['SyncGroupSchemaTableColumnResponse'] columns: List of columns in sync group schema.
        :param str quoted_name: Quoted name of sync group schema table.
        """
        if columns is not None:
            pulumi.set(__self__, "columns", columns)
        if quoted_name is not None:
            pulumi.set(__self__, "quoted_name", quoted_name)

    @property
    @pulumi.getter
    def columns(self) -> Optional[Sequence['outputs.SyncGroupSchemaTableColumnResponse']]:
        """
        List of columns in sync group schema.
        """
        return pulumi.get(self, "columns")

    @property
    @pulumi.getter(name="quotedName")
    def quoted_name(self) -> Optional[str]:
        """
        Quoted name of sync group schema table.
        """
        return pulumi.get(self, "quoted_name")


@pulumi.output_type
class SystemDataResponse(dict):
    """
    Metadata pertaining to creation and last modification of the resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createdAt":
            suggest = "created_at"
        elif key == "createdBy":
            suggest = "created_by"
        elif key == "createdByType":
            suggest = "created_by_type"
        elif key == "lastModifiedAt":
            suggest = "last_modified_at"
        elif key == "lastModifiedBy":
            suggest = "last_modified_by"
        elif key == "lastModifiedByType":
            suggest = "last_modified_by_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SystemDataResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SystemDataResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SystemDataResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 created_at: Optional[str] = None,
                 created_by: Optional[str] = None,
                 created_by_type: Optional[str] = None,
                 last_modified_at: Optional[str] = None,
                 last_modified_by: Optional[str] = None,
                 last_modified_by_type: Optional[str] = None):
        """
        Metadata pertaining to creation and last modification of the resource.
        :param str created_at: The timestamp of resource creation (UTC).
        :param str created_by: The identity that created the resource.
        :param str created_by_type: The type of identity that created the resource.
        :param str last_modified_at: The timestamp of resource last modification (UTC)
        :param str last_modified_by: The identity that last modified the resource.
        :param str last_modified_by_type: The type of identity that last modified the resource.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if created_by_type is not None:
            pulumi.set(__self__, "created_by_type", created_by_type)
        if last_modified_at is not None:
            pulumi.set(__self__, "last_modified_at", last_modified_at)
        if last_modified_by is not None:
            pulumi.set(__self__, "last_modified_by", last_modified_by)
        if last_modified_by_type is not None:
            pulumi.set(__self__, "last_modified_by_type", last_modified_by_type)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[str]:
        """
        The timestamp of resource creation (UTC).
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[str]:
        """
        The identity that created the resource.
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter(name="createdByType")
    def created_by_type(self) -> Optional[str]:
        """
        The type of identity that created the resource.
        """
        return pulumi.get(self, "created_by_type")

    @property
    @pulumi.getter(name="lastModifiedAt")
    def last_modified_at(self) -> Optional[str]:
        """
        The timestamp of resource last modification (UTC)
        """
        return pulumi.get(self, "last_modified_at")

    @property
    @pulumi.getter(name="lastModifiedBy")
    def last_modified_by(self) -> Optional[str]:
        """
        The identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by")

    @property
    @pulumi.getter(name="lastModifiedByType")
    def last_modified_by_type(self) -> Optional[str]:
        """
        The type of identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by_type")


@pulumi.output_type
class UserIdentityResponse(dict):
    """
    Azure Active Directory identity configuration for a resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientId":
            suggest = "client_id"
        elif key == "principalId":
            suggest = "principal_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserIdentityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserIdentityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserIdentityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_id: str,
                 principal_id: str):
        """
        Azure Active Directory identity configuration for a resource.
        :param str client_id: The Azure Active Directory client id.
        :param str principal_id: The Azure Active Directory principal id.
        """
        pulumi.set(__self__, "client_id", client_id)
        pulumi.set(__self__, "principal_id", principal_id)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> str:
        """
        The Azure Active Directory client id.
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> str:
        """
        The Azure Active Directory principal id.
        """
        return pulumi.get(self, "principal_id")


@pulumi.output_type
class VulnerabilityAssessmentRecurringScansPropertiesResponse(dict):
    """
    Properties of a Vulnerability Assessment recurring scans.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "emailSubscriptionAdmins":
            suggest = "email_subscription_admins"
        elif key == "isEnabled":
            suggest = "is_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VulnerabilityAssessmentRecurringScansPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VulnerabilityAssessmentRecurringScansPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VulnerabilityAssessmentRecurringScansPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 email_subscription_admins: Optional[bool] = None,
                 emails: Optional[Sequence[str]] = None,
                 is_enabled: Optional[bool] = None):
        """
        Properties of a Vulnerability Assessment recurring scans.
        :param bool email_subscription_admins: Specifies that the schedule scan notification will be is sent to the subscription administrators.
        :param Sequence[str] emails: Specifies an array of e-mail addresses to which the scan notification is sent.
        :param bool is_enabled: Recurring scans state.
        """
        if email_subscription_admins is None:
            email_subscription_admins = True
        if email_subscription_admins is not None:
            pulumi.set(__self__, "email_subscription_admins", email_subscription_admins)
        if emails is not None:
            pulumi.set(__self__, "emails", emails)
        if is_enabled is not None:
            pulumi.set(__self__, "is_enabled", is_enabled)

    @property
    @pulumi.getter(name="emailSubscriptionAdmins")
    def email_subscription_admins(self) -> Optional[bool]:
        """
        Specifies that the schedule scan notification will be is sent to the subscription administrators.
        """
        return pulumi.get(self, "email_subscription_admins")

    @property
    @pulumi.getter
    def emails(self) -> Optional[Sequence[str]]:
        """
        Specifies an array of e-mail addresses to which the scan notification is sent.
        """
        return pulumi.get(self, "emails")

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> Optional[bool]:
        """
        Recurring scans state.
        """
        return pulumi.get(self, "is_enabled")


