# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

from enum import Enum

__all__ = [
    'AdministratorType',
    'AutoExecuteStatus',
    'CreateMode',
    'DataMaskingState',
    'DatabaseEdition',
    'ElasticPoolEdition',
    'GeoBackupPolicyState',
    'ReadScale',
    'SampleName',
    'SecurityAlertPolicyEmailAccountAdmins',
    'SecurityAlertPolicyState',
    'SecurityAlertPolicyUseServerDefault',
    'ServerVersion',
    'ServiceObjectiveName',
    'TransparentDataEncryptionStatus',
]


class AdministratorType(str, Enum):
    """
    The type of administrator.
    """
    ACTIVE_DIRECTORY = "ActiveDirectory"


class AutoExecuteStatus(str, Enum):
    """
    Gets the auto-execute status (whether to let the system execute the recommendations) of this advisor. Possible values are 'Enabled' and 'Disabled'
    """
    ENABLED = "Enabled"
    DISABLED = "Disabled"
    DEFAULT = "Default"


class CreateMode(str, Enum):
    """
    Specifies the mode of database creation.

    Default: regular database creation.

    Copy: creates a database as a copy of an existing database. sourceDatabaseId must be specified as the resource ID of the source database.

    OnlineSecondary/NonReadableSecondary: creates a database as a (readable or nonreadable) secondary replica of an existing database. sourceDatabaseId must be specified as the resource ID of the existing primary database.

    PointInTimeRestore: Creates a database by restoring a point in time backup of an existing database. sourceDatabaseId must be specified as the resource ID of the existing database, and restorePointInTime must be specified.

    Recovery: Creates a database by restoring a geo-replicated backup. sourceDatabaseId must be specified as the recoverable database resource ID to restore.

    Restore: Creates a database by restoring a backup of a deleted database. sourceDatabaseId must be specified. If sourceDatabaseId is the database's original resource ID, then sourceDatabaseDeletionDate must be specified. Otherwise sourceDatabaseId must be the restorable dropped database resource ID and sourceDatabaseDeletionDate is ignored. restorePointInTime may also be specified to restore from an earlier point in time.

    RestoreLongTermRetentionBackup: Creates a database by restoring from a long term retention vault. recoveryServicesRecoveryPointResourceId must be specified as the recovery point resource ID.

    Copy, NonReadableSecondary, OnlineSecondary and RestoreLongTermRetentionBackup are not supported for DataWarehouse edition.
    """
    COPY = "Copy"
    DEFAULT = "Default"
    NON_READABLE_SECONDARY = "NonReadableSecondary"
    ONLINE_SECONDARY = "OnlineSecondary"
    POINT_IN_TIME_RESTORE = "PointInTimeRestore"
    RECOVERY = "Recovery"
    RESTORE = "Restore"
    RESTORE_LONG_TERM_RETENTION_BACKUP = "RestoreLongTermRetentionBackup"


class DataMaskingState(str, Enum):
    """
    The state of the data masking policy.
    """
    DISABLED = "Disabled"
    ENABLED = "Enabled"


class DatabaseEdition(str, Enum):
    """
    The edition of the database. The DatabaseEditions enumeration contains all the valid editions. If createMode is NonReadableSecondary or OnlineSecondary, this value is ignored.
    
    The list of SKUs may vary by region and support offer. To determine the SKUs (including the SKU name, tier/edition, family, and capacity) that are available to your subscription in an Azure region, use the `Capabilities_ListByLocation` REST API or one of the following commands:
    
    ```azurecli
    az sql db list-editions -l <location> -o table
    ````
    
    ```powershell
    Get-AzSqlServerServiceObjective -Location <location>
    ````
    """
    WEB = "Web"
    BUSINESS = "Business"
    BASIC = "Basic"
    STANDARD = "Standard"
    PREMIUM = "Premium"
    PREMIUM_RS = "PremiumRS"
    FREE = "Free"
    STRETCH = "Stretch"
    DATA_WAREHOUSE = "DataWarehouse"
    SYSTEM = "System"
    SYSTEM2 = "System2"
    GENERAL_PURPOSE = "GeneralPurpose"
    BUSINESS_CRITICAL = "BusinessCritical"
    HYPERSCALE = "Hyperscale"


class ElasticPoolEdition(str, Enum):
    """
    The edition of the elastic pool.
    """
    BASIC = "Basic"
    STANDARD = "Standard"
    PREMIUM = "Premium"
    GENERAL_PURPOSE = "GeneralPurpose"
    BUSINESS_CRITICAL = "BusinessCritical"


class GeoBackupPolicyState(str, Enum):
    """
    The state of the geo backup policy.
    """
    DISABLED = "Disabled"
    ENABLED = "Enabled"


class ReadScale(str, Enum):
    """
    Conditional. If the database is a geo-secondary, readScale indicates whether read-only connections are allowed to this database or not. Not supported for DataWarehouse edition.
    """
    ENABLED = "Enabled"
    DISABLED = "Disabled"


class SampleName(str, Enum):
    """
    Indicates the name of the sample schema to apply when creating this database. If createMode is not Default, this value is ignored. Not supported for DataWarehouse edition.
    """
    ADVENTURE_WORKS_LT = "AdventureWorksLT"


class SecurityAlertPolicyEmailAccountAdmins(str, Enum):
    """
    Specifies that the alert is sent to the account administrators.
    """
    ENABLED = "Enabled"
    DISABLED = "Disabled"


class SecurityAlertPolicyState(str, Enum):
    """
    Specifies the state of the policy. If state is Enabled, storageEndpoint and storageAccountAccessKey are required.
    """
    NEW = "New"
    ENABLED = "Enabled"
    DISABLED = "Disabled"


class SecurityAlertPolicyUseServerDefault(str, Enum):
    """
    Specifies whether to use the default server policy.
    """
    ENABLED = "Enabled"
    DISABLED = "Disabled"


class ServerVersion(str, Enum):
    """
    The version of the server.
    """
    SERVER_VERSION_2_0 = "2.0"
    SERVER_VERSION_12_0 = "12.0"


class ServiceObjectiveName(str, Enum):
    """
    The name of the configured service level objective of the database. This is the service level objective that is in the process of being applied to the database. Once successfully updated, it will match the value of serviceLevelObjective property. 
    
    The list of SKUs may vary by region and support offer. To determine the SKUs (including the SKU name, tier/edition, family, and capacity) that are available to your subscription in an Azure region, use the `Capabilities_ListByLocation` REST API or one of the following commands:
    
    ```azurecli
    az sql db list-editions -l <location> -o table
    ````
    
    ```powershell
    Get-AzSqlServerServiceObjective -Location <location>
    ````
    """
    SYSTEM = "System"
    SYSTEM0 = "System0"
    SYSTEM1 = "System1"
    SYSTEM2 = "System2"
    SYSTEM3 = "System3"
    SYSTEM4 = "System4"
    SYSTEM2_L = "System2L"
    SYSTEM3_L = "System3L"
    SYSTEM4_L = "System4L"
    FREE = "Free"
    BASIC = "Basic"
    S0 = "S0"
    S1 = "S1"
    S2 = "S2"
    S3 = "S3"
    S4 = "S4"
    S6 = "S6"
    S7 = "S7"
    S9 = "S9"
    S12 = "S12"
    P1 = "P1"
    P2 = "P2"
    P3 = "P3"
    P4 = "P4"
    P6 = "P6"
    P11 = "P11"
    P15 = "P15"
    PRS1 = "PRS1"
    PRS2 = "PRS2"
    PRS4 = "PRS4"
    PRS6 = "PRS6"
    DW100 = "DW100"
    DW200 = "DW200"
    DW300 = "DW300"
    DW400 = "DW400"
    DW500 = "DW500"
    DW600 = "DW600"
    DW1000 = "DW1000"
    DW1200 = "DW1200"
    DW1000C = "DW1000c"
    DW1500 = "DW1500"
    DW1500C = "DW1500c"
    DW2000 = "DW2000"
    DW2000C = "DW2000c"
    DW3000 = "DW3000"
    DW2500C = "DW2500c"
    DW3000C = "DW3000c"
    DW6000 = "DW6000"
    DW5000C = "DW5000c"
    DW6000C = "DW6000c"
    DW7500C = "DW7500c"
    DW10000C = "DW10000c"
    DW15000C = "DW15000c"
    DW30000C = "DW30000c"
    DS100 = "DS100"
    DS200 = "DS200"
    DS300 = "DS300"
    DS400 = "DS400"
    DS500 = "DS500"
    DS600 = "DS600"
    DS1000 = "DS1000"
    DS1200 = "DS1200"
    DS1500 = "DS1500"
    DS2000 = "DS2000"
    ELASTIC_POOL = "ElasticPool"


class TransparentDataEncryptionStatus(str, Enum):
    """
    The status of the database transparent data encryption.
    """
    ENABLED = "Enabled"
    DISABLED = "Disabled"
