# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'AzureActiveDirectoryResponse',
    'ClientCertificateResponse',
    'EndpointRangeDescriptionResponse',
    'LoadBalancingRuleResponse',
    'SettingsParameterDescriptionResponse',
    'SettingsSectionDescriptionResponse',
    'SkuResponse',
    'SubResourceResponse',
    'VMSSExtensionResponse',
    'VaultCertificateResponse',
    'VaultSecretGroupResponse',
]

@pulumi.output_type
class AzureActiveDirectoryResponse(dict):
    """
    The settings to enable AAD authentication on the cluster.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientApplication":
            suggest = "client_application"
        elif key == "clusterApplication":
            suggest = "cluster_application"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureActiveDirectoryResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureActiveDirectoryResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureActiveDirectoryResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_application: Optional[str] = None,
                 cluster_application: Optional[str] = None,
                 tenant_id: Optional[str] = None):
        """
        The settings to enable AAD authentication on the cluster.
        :param str client_application: Azure active directory client application id.
        :param str cluster_application: Azure active directory cluster application id.
        :param str tenant_id: Azure active directory tenant id.
        """
        if client_application is not None:
            pulumi.set(__self__, "client_application", client_application)
        if cluster_application is not None:
            pulumi.set(__self__, "cluster_application", cluster_application)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter(name="clientApplication")
    def client_application(self) -> Optional[str]:
        """
        Azure active directory client application id.
        """
        return pulumi.get(self, "client_application")

    @property
    @pulumi.getter(name="clusterApplication")
    def cluster_application(self) -> Optional[str]:
        """
        Azure active directory cluster application id.
        """
        return pulumi.get(self, "cluster_application")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[str]:
        """
        Azure active directory tenant id.
        """
        return pulumi.get(self, "tenant_id")


@pulumi.output_type
class ClientCertificateResponse(dict):
    """
    Client Certificate definition.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isAdmin":
            suggest = "is_admin"
        elif key == "commonName":
            suggest = "common_name"
        elif key == "issuerThumbprint":
            suggest = "issuer_thumbprint"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClientCertificateResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClientCertificateResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClientCertificateResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 is_admin: bool,
                 common_name: Optional[str] = None,
                 issuer_thumbprint: Optional[str] = None,
                 thumbprint: Optional[str] = None):
        """
        Client Certificate definition.
        :param bool is_admin: Whether the certificate is admin or not.
        :param str common_name: Certificate Common name.
        :param str issuer_thumbprint: Issuer thumbprint for the certificate. Only used together with CommonName.
        :param str thumbprint: Certificate Thumbprint.
        """
        pulumi.set(__self__, "is_admin", is_admin)
        if common_name is not None:
            pulumi.set(__self__, "common_name", common_name)
        if issuer_thumbprint is not None:
            pulumi.set(__self__, "issuer_thumbprint", issuer_thumbprint)
        if thumbprint is not None:
            pulumi.set(__self__, "thumbprint", thumbprint)

    @property
    @pulumi.getter(name="isAdmin")
    def is_admin(self) -> bool:
        """
        Whether the certificate is admin or not.
        """
        return pulumi.get(self, "is_admin")

    @property
    @pulumi.getter(name="commonName")
    def common_name(self) -> Optional[str]:
        """
        Certificate Common name.
        """
        return pulumi.get(self, "common_name")

    @property
    @pulumi.getter(name="issuerThumbprint")
    def issuer_thumbprint(self) -> Optional[str]:
        """
        Issuer thumbprint for the certificate. Only used together with CommonName.
        """
        return pulumi.get(self, "issuer_thumbprint")

    @property
    @pulumi.getter
    def thumbprint(self) -> Optional[str]:
        """
        Certificate Thumbprint.
        """
        return pulumi.get(self, "thumbprint")


@pulumi.output_type
class EndpointRangeDescriptionResponse(dict):
    """
    Port range details
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endPort":
            suggest = "end_port"
        elif key == "startPort":
            suggest = "start_port"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EndpointRangeDescriptionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EndpointRangeDescriptionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EndpointRangeDescriptionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 end_port: int,
                 start_port: int):
        """
        Port range details
        :param int end_port: End port of a range of ports
        :param int start_port: Starting port of a range of ports
        """
        pulumi.set(__self__, "end_port", end_port)
        pulumi.set(__self__, "start_port", start_port)

    @property
    @pulumi.getter(name="endPort")
    def end_port(self) -> int:
        """
        End port of a range of ports
        """
        return pulumi.get(self, "end_port")

    @property
    @pulumi.getter(name="startPort")
    def start_port(self) -> int:
        """
        Starting port of a range of ports
        """
        return pulumi.get(self, "start_port")


@pulumi.output_type
class LoadBalancingRuleResponse(dict):
    """
    Describes a load balancing rule.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backendPort":
            suggest = "backend_port"
        elif key == "frontendPort":
            suggest = "frontend_port"
        elif key == "probeProtocol":
            suggest = "probe_protocol"
        elif key == "probeRequestPath":
            suggest = "probe_request_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LoadBalancingRuleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LoadBalancingRuleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LoadBalancingRuleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backend_port: int,
                 frontend_port: int,
                 probe_protocol: str,
                 protocol: str,
                 probe_request_path: Optional[str] = None):
        """
        Describes a load balancing rule.
        :param int backend_port: The port used for internal connections on the endpoint. Acceptable values are between 1 and 65535.
        :param int frontend_port: The port for the external endpoint. Port numbers for each rule must be unique within the Load Balancer. Acceptable values are between 1 and 65534.
        :param str probe_protocol: the reference to the load balancer probe used by the load balancing rule.
        :param str protocol: The reference to the transport protocol used by the load balancing rule.
        :param str probe_request_path: The probe request path. Only supported for HTTP/HTTPS probes.
        """
        pulumi.set(__self__, "backend_port", backend_port)
        pulumi.set(__self__, "frontend_port", frontend_port)
        pulumi.set(__self__, "probe_protocol", probe_protocol)
        pulumi.set(__self__, "protocol", protocol)
        if probe_request_path is not None:
            pulumi.set(__self__, "probe_request_path", probe_request_path)

    @property
    @pulumi.getter(name="backendPort")
    def backend_port(self) -> int:
        """
        The port used for internal connections on the endpoint. Acceptable values are between 1 and 65535.
        """
        return pulumi.get(self, "backend_port")

    @property
    @pulumi.getter(name="frontendPort")
    def frontend_port(self) -> int:
        """
        The port for the external endpoint. Port numbers for each rule must be unique within the Load Balancer. Acceptable values are between 1 and 65534.
        """
        return pulumi.get(self, "frontend_port")

    @property
    @pulumi.getter(name="probeProtocol")
    def probe_protocol(self) -> str:
        """
        the reference to the load balancer probe used by the load balancing rule.
        """
        return pulumi.get(self, "probe_protocol")

    @property
    @pulumi.getter
    def protocol(self) -> str:
        """
        The reference to the transport protocol used by the load balancing rule.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="probeRequestPath")
    def probe_request_path(self) -> Optional[str]:
        """
        The probe request path. Only supported for HTTP/HTTPS probes.
        """
        return pulumi.get(self, "probe_request_path")


@pulumi.output_type
class SettingsParameterDescriptionResponse(dict):
    """
    Describes a parameter in fabric settings of the cluster.
    """
    def __init__(__self__, *,
                 name: str,
                 value: str):
        """
        Describes a parameter in fabric settings of the cluster.
        :param str name: The parameter name of fabric setting.
        :param str value: The parameter value of fabric setting.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The parameter name of fabric setting.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The parameter value of fabric setting.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class SettingsSectionDescriptionResponse(dict):
    """
    Describes a section in the fabric settings of the cluster.
    """
    def __init__(__self__, *,
                 name: str,
                 parameters: Sequence['outputs.SettingsParameterDescriptionResponse']):
        """
        Describes a section in the fabric settings of the cluster.
        :param str name: The section name of the fabric settings.
        :param Sequence['SettingsParameterDescriptionResponse'] parameters: The collection of parameters in the section.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The section name of the fabric settings.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def parameters(self) -> Sequence['outputs.SettingsParameterDescriptionResponse']:
        """
        The collection of parameters in the section.
        """
        return pulumi.get(self, "parameters")


@pulumi.output_type
class SkuResponse(dict):
    """
    Sku definition
    """
    def __init__(__self__, *,
                 name: str):
        """
        Sku definition
        :param str name: Sku Name.
        """
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Sku Name.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class SubResourceResponse(dict):
    """
    Azure resource identifier.
    """
    def __init__(__self__, *,
                 id: Optional[str] = None):
        """
        Azure resource identifier.
        :param str id: Azure resource identifier.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Azure resource identifier.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class VMSSExtensionResponse(dict):
    """
    Specifies set of extensions that should be installed onto the virtual machines.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "typeHandlerVersion":
            suggest = "type_handler_version"
        elif key == "autoUpgradeMinorVersion":
            suggest = "auto_upgrade_minor_version"
        elif key == "forceUpdateTag":
            suggest = "force_update_tag"
        elif key == "protectedSettings":
            suggest = "protected_settings"
        elif key == "provisionAfterExtensions":
            suggest = "provision_after_extensions"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VMSSExtensionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VMSSExtensionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VMSSExtensionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 provisioning_state: str,
                 publisher: str,
                 type: str,
                 type_handler_version: str,
                 auto_upgrade_minor_version: Optional[bool] = None,
                 force_update_tag: Optional[str] = None,
                 protected_settings: Optional[Any] = None,
                 provision_after_extensions: Optional[Sequence[str]] = None,
                 settings: Optional[Any] = None):
        """
        Specifies set of extensions that should be installed onto the virtual machines.
        :param str name: The name of the extension.
        :param str provisioning_state: The provisioning state, which only appears in the response.
        :param str publisher: The name of the extension handler publisher.
        :param str type: Specifies the type of the extension; an example is "CustomScriptExtension".
        :param str type_handler_version: Specifies the version of the script handler.
        :param bool auto_upgrade_minor_version: Indicates whether the extension should use a newer minor version if one is available at deployment time. Once deployed, however, the extension will not upgrade minor versions unless redeployed, even with this property set to true.
        :param str force_update_tag: If a value is provided and is different from the previous value, the extension handler will be forced to update even if the extension configuration has not changed.
        :param Any protected_settings: The extension can contain either protectedSettings or protectedSettingsFromKeyVault or no protected settings at all.
        :param Sequence[str] provision_after_extensions: Collection of extension names after which this extension needs to be provisioned.
        :param Any settings: Json formatted public settings for the extension.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        pulumi.set(__self__, "publisher", publisher)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "type_handler_version", type_handler_version)
        if auto_upgrade_minor_version is not None:
            pulumi.set(__self__, "auto_upgrade_minor_version", auto_upgrade_minor_version)
        if force_update_tag is not None:
            pulumi.set(__self__, "force_update_tag", force_update_tag)
        if protected_settings is not None:
            pulumi.set(__self__, "protected_settings", protected_settings)
        if provision_after_extensions is not None:
            pulumi.set(__self__, "provision_after_extensions", provision_after_extensions)
        if settings is not None:
            pulumi.set(__self__, "settings", settings)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the extension.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state, which only appears in the response.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def publisher(self) -> str:
        """
        The name of the extension handler publisher.
        """
        return pulumi.get(self, "publisher")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Specifies the type of the extension; an example is "CustomScriptExtension".
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="typeHandlerVersion")
    def type_handler_version(self) -> str:
        """
        Specifies the version of the script handler.
        """
        return pulumi.get(self, "type_handler_version")

    @property
    @pulumi.getter(name="autoUpgradeMinorVersion")
    def auto_upgrade_minor_version(self) -> Optional[bool]:
        """
        Indicates whether the extension should use a newer minor version if one is available at deployment time. Once deployed, however, the extension will not upgrade minor versions unless redeployed, even with this property set to true.
        """
        return pulumi.get(self, "auto_upgrade_minor_version")

    @property
    @pulumi.getter(name="forceUpdateTag")
    def force_update_tag(self) -> Optional[str]:
        """
        If a value is provided and is different from the previous value, the extension handler will be forced to update even if the extension configuration has not changed.
        """
        return pulumi.get(self, "force_update_tag")

    @property
    @pulumi.getter(name="protectedSettings")
    def protected_settings(self) -> Optional[Any]:
        """
        The extension can contain either protectedSettings or protectedSettingsFromKeyVault or no protected settings at all.
        """
        return pulumi.get(self, "protected_settings")

    @property
    @pulumi.getter(name="provisionAfterExtensions")
    def provision_after_extensions(self) -> Optional[Sequence[str]]:
        """
        Collection of extension names after which this extension needs to be provisioned.
        """
        return pulumi.get(self, "provision_after_extensions")

    @property
    @pulumi.getter
    def settings(self) -> Optional[Any]:
        """
        Json formatted public settings for the extension.
        """
        return pulumi.get(self, "settings")


@pulumi.output_type
class VaultCertificateResponse(dict):
    """
    Describes a single certificate reference in a Key Vault, and where the certificate should reside on the VM.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "certificateStore":
            suggest = "certificate_store"
        elif key == "certificateUrl":
            suggest = "certificate_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VaultCertificateResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VaultCertificateResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VaultCertificateResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 certificate_store: str,
                 certificate_url: str):
        """
        Describes a single certificate reference in a Key Vault, and where the certificate should reside on the VM.
        :param str certificate_store: For Windows VMs, specifies the certificate store on the Virtual Machine to which the certificate should be added. The specified certificate store is implicitly in the LocalMachine account. <br><br>For Linux VMs, the certificate file is placed under the /var/lib/waagent directory, with the file name <UppercaseThumbprint>.crt for the X509 certificate file and <UppercaseThumbprint>.prv for private key. Both of these files are .pem formatted.
        :param str certificate_url: This is the URL of a certificate that has been uploaded to Key Vault as a secret. For adding a secret to the Key Vault, see [Add a key or secret to the key vault](https://docs.microsoft.com/azure/key-vault/key-vault-get-started/#add). In this case, your certificate needs to be It is the Base64 encoding of the following JSON Object which is encoded in UTF-8: <br><br> {<br>  "data":"<Base64-encoded-certificate>",<br>  "dataType":"pfx",<br>  "password":"<pfx-file-password>"<br>}
        """
        pulumi.set(__self__, "certificate_store", certificate_store)
        pulumi.set(__self__, "certificate_url", certificate_url)

    @property
    @pulumi.getter(name="certificateStore")
    def certificate_store(self) -> str:
        """
        For Windows VMs, specifies the certificate store on the Virtual Machine to which the certificate should be added. The specified certificate store is implicitly in the LocalMachine account. <br><br>For Linux VMs, the certificate file is placed under the /var/lib/waagent directory, with the file name <UppercaseThumbprint>.crt for the X509 certificate file and <UppercaseThumbprint>.prv for private key. Both of these files are .pem formatted.
        """
        return pulumi.get(self, "certificate_store")

    @property
    @pulumi.getter(name="certificateUrl")
    def certificate_url(self) -> str:
        """
        This is the URL of a certificate that has been uploaded to Key Vault as a secret. For adding a secret to the Key Vault, see [Add a key or secret to the key vault](https://docs.microsoft.com/azure/key-vault/key-vault-get-started/#add). In this case, your certificate needs to be It is the Base64 encoding of the following JSON Object which is encoded in UTF-8: <br><br> {<br>  "data":"<Base64-encoded-certificate>",<br>  "dataType":"pfx",<br>  "password":"<pfx-file-password>"<br>}
        """
        return pulumi.get(self, "certificate_url")


@pulumi.output_type
class VaultSecretGroupResponse(dict):
    """
    Specifies set of certificates that should be installed onto the virtual machines.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceVault":
            suggest = "source_vault"
        elif key == "vaultCertificates":
            suggest = "vault_certificates"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VaultSecretGroupResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VaultSecretGroupResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VaultSecretGroupResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 source_vault: 'outputs.SubResourceResponse',
                 vault_certificates: Sequence['outputs.VaultCertificateResponse']):
        """
        Specifies set of certificates that should be installed onto the virtual machines.
        :param 'SubResourceResponse' source_vault: The relative URL of the Key Vault containing all of the certificates in VaultCertificates.
        :param Sequence['VaultCertificateResponse'] vault_certificates: The list of key vault references in SourceVault which contain certificates.
        """
        pulumi.set(__self__, "source_vault", source_vault)
        pulumi.set(__self__, "vault_certificates", vault_certificates)

    @property
    @pulumi.getter(name="sourceVault")
    def source_vault(self) -> 'outputs.SubResourceResponse':
        """
        The relative URL of the Key Vault containing all of the certificates in VaultCertificates.
        """
        return pulumi.get(self, "source_vault")

    @property
    @pulumi.getter(name="vaultCertificates")
    def vault_certificates(self) -> Sequence['outputs.VaultCertificateResponse']:
        """
        The list of key vault references in SourceVault which contain certificates.
        """
        return pulumi.get(self, "vault_certificates")


