# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'AzureActiveDirectoryResponse',
    'CertificateDescriptionResponse',
    'ClientCertificateCommonNameResponse',
    'ClientCertificateThumbprintResponse',
    'ClusterHealthPolicyResponse',
    'ClusterUpgradeDeltaHealthPolicyResponse',
    'ClusterUpgradePolicyResponse',
    'ClusterVersionDetailsResponse',
    'DiagnosticsStorageAccountConfigResponse',
    'EndpointRangeDescriptionResponse',
    'NodeTypeDescriptionResponse',
    'SettingsParameterDescriptionResponse',
    'SettingsSectionDescriptionResponse',
]

@pulumi.output_type
class AzureActiveDirectoryResponse(dict):
    """
    The settings to enable AAD authentication on the cluster
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientApplication":
            suggest = "client_application"
        elif key == "clusterApplication":
            suggest = "cluster_application"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureActiveDirectoryResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureActiveDirectoryResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureActiveDirectoryResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_application: Optional[str] = None,
                 cluster_application: Optional[str] = None,
                 tenant_id: Optional[str] = None):
        """
        The settings to enable AAD authentication on the cluster
        :param str client_application: Azure active directory client application id
        :param str cluster_application: Azure active directory cluster application id
        :param str tenant_id: Azure active directory tenant id
        """
        if client_application is not None:
            pulumi.set(__self__, "client_application", client_application)
        if cluster_application is not None:
            pulumi.set(__self__, "cluster_application", cluster_application)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter(name="clientApplication")
    def client_application(self) -> Optional[str]:
        """
        Azure active directory client application id
        """
        return pulumi.get(self, "client_application")

    @property
    @pulumi.getter(name="clusterApplication")
    def cluster_application(self) -> Optional[str]:
        """
        Azure active directory cluster application id
        """
        return pulumi.get(self, "cluster_application")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[str]:
        """
        Azure active directory tenant id
        """
        return pulumi.get(self, "tenant_id")


@pulumi.output_type
class CertificateDescriptionResponse(dict):
    """
    Certificate details
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "thumbprintSecondary":
            suggest = "thumbprint_secondary"
        elif key == "x509StoreName":
            suggest = "x509_store_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateDescriptionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateDescriptionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateDescriptionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 thumbprint: str,
                 thumbprint_secondary: Optional[str] = None,
                 x509_store_name: Optional[str] = None):
        """
        Certificate details
        :param str thumbprint: Thumbprint of the primary certificate
        :param str thumbprint_secondary: Thumbprint of the secondary certificate
        :param str x509_store_name: The local certificate store location
        """
        pulumi.set(__self__, "thumbprint", thumbprint)
        if thumbprint_secondary is not None:
            pulumi.set(__self__, "thumbprint_secondary", thumbprint_secondary)
        if x509_store_name is not None:
            pulumi.set(__self__, "x509_store_name", x509_store_name)

    @property
    @pulumi.getter
    def thumbprint(self) -> str:
        """
        Thumbprint of the primary certificate
        """
        return pulumi.get(self, "thumbprint")

    @property
    @pulumi.getter(name="thumbprintSecondary")
    def thumbprint_secondary(self) -> Optional[str]:
        """
        Thumbprint of the secondary certificate
        """
        return pulumi.get(self, "thumbprint_secondary")

    @property
    @pulumi.getter(name="x509StoreName")
    def x509_store_name(self) -> Optional[str]:
        """
        The local certificate store location
        """
        return pulumi.get(self, "x509_store_name")


@pulumi.output_type
class ClientCertificateCommonNameResponse(dict):
    """
    Client certificate details using common name
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "certificateCommonName":
            suggest = "certificate_common_name"
        elif key == "certificateIssuerThumbprint":
            suggest = "certificate_issuer_thumbprint"
        elif key == "isAdmin":
            suggest = "is_admin"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClientCertificateCommonNameResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClientCertificateCommonNameResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClientCertificateCommonNameResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 certificate_common_name: str,
                 certificate_issuer_thumbprint: str,
                 is_admin: bool):
        """
        Client certificate details using common name
        :param str certificate_common_name: Certificate common name to be granted access; be careful using wild card common names
        :param str certificate_issuer_thumbprint: Certificate issuer thumbprint
        :param bool is_admin: Is this certificate used for admin access from the client, if false , it is used or query only access
        """
        pulumi.set(__self__, "certificate_common_name", certificate_common_name)
        pulumi.set(__self__, "certificate_issuer_thumbprint", certificate_issuer_thumbprint)
        pulumi.set(__self__, "is_admin", is_admin)

    @property
    @pulumi.getter(name="certificateCommonName")
    def certificate_common_name(self) -> str:
        """
        Certificate common name to be granted access; be careful using wild card common names
        """
        return pulumi.get(self, "certificate_common_name")

    @property
    @pulumi.getter(name="certificateIssuerThumbprint")
    def certificate_issuer_thumbprint(self) -> str:
        """
        Certificate issuer thumbprint
        """
        return pulumi.get(self, "certificate_issuer_thumbprint")

    @property
    @pulumi.getter(name="isAdmin")
    def is_admin(self) -> bool:
        """
        Is this certificate used for admin access from the client, if false , it is used or query only access
        """
        return pulumi.get(self, "is_admin")


@pulumi.output_type
class ClientCertificateThumbprintResponse(dict):
    """
    Client certificate details using thumbprint
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "certificateThumbprint":
            suggest = "certificate_thumbprint"
        elif key == "isAdmin":
            suggest = "is_admin"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClientCertificateThumbprintResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClientCertificateThumbprintResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClientCertificateThumbprintResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 certificate_thumbprint: str,
                 is_admin: bool):
        """
        Client certificate details using thumbprint
        :param str certificate_thumbprint: Certificate thumbprint
        :param bool is_admin: Is this certificate used for admin access from the client, if false, it is used or query only access
        """
        pulumi.set(__self__, "certificate_thumbprint", certificate_thumbprint)
        pulumi.set(__self__, "is_admin", is_admin)

    @property
    @pulumi.getter(name="certificateThumbprint")
    def certificate_thumbprint(self) -> str:
        """
        Certificate thumbprint
        """
        return pulumi.get(self, "certificate_thumbprint")

    @property
    @pulumi.getter(name="isAdmin")
    def is_admin(self) -> bool:
        """
        Is this certificate used for admin access from the client, if false, it is used or query only access
        """
        return pulumi.get(self, "is_admin")


@pulumi.output_type
class ClusterHealthPolicyResponse(dict):
    """
    Defines a health policy used to evaluate the health of the cluster or of a cluster node.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxPercentUnhealthyApplications":
            suggest = "max_percent_unhealthy_applications"
        elif key == "maxPercentUnhealthyNodes":
            suggest = "max_percent_unhealthy_nodes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterHealthPolicyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterHealthPolicyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterHealthPolicyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_percent_unhealthy_applications: Optional[int] = None,
                 max_percent_unhealthy_nodes: Optional[int] = None):
        """
        Defines a health policy used to evaluate the health of the cluster or of a cluster node.
        :param int max_percent_unhealthy_applications: The maximum allowed percentage of unhealthy applications before reporting an error. For example, to allow 10% of applications to be unhealthy, this value would be 10. 
        :param int max_percent_unhealthy_nodes: The maximum allowed percentage of unhealthy nodes before reporting an error. For example, to allow 10% of nodes to be unhealthy, this value would be 10. 
        """
        if max_percent_unhealthy_applications is not None:
            pulumi.set(__self__, "max_percent_unhealthy_applications", max_percent_unhealthy_applications)
        if max_percent_unhealthy_nodes is not None:
            pulumi.set(__self__, "max_percent_unhealthy_nodes", max_percent_unhealthy_nodes)

    @property
    @pulumi.getter(name="maxPercentUnhealthyApplications")
    def max_percent_unhealthy_applications(self) -> Optional[int]:
        """
        The maximum allowed percentage of unhealthy applications before reporting an error. For example, to allow 10% of applications to be unhealthy, this value would be 10. 
        """
        return pulumi.get(self, "max_percent_unhealthy_applications")

    @property
    @pulumi.getter(name="maxPercentUnhealthyNodes")
    def max_percent_unhealthy_nodes(self) -> Optional[int]:
        """
        The maximum allowed percentage of unhealthy nodes before reporting an error. For example, to allow 10% of nodes to be unhealthy, this value would be 10. 
        """
        return pulumi.get(self, "max_percent_unhealthy_nodes")


@pulumi.output_type
class ClusterUpgradeDeltaHealthPolicyResponse(dict):
    """
    Delta health policy for the cluster
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxPercentDeltaUnhealthyApplications":
            suggest = "max_percent_delta_unhealthy_applications"
        elif key == "maxPercentDeltaUnhealthyNodes":
            suggest = "max_percent_delta_unhealthy_nodes"
        elif key == "maxPercentUpgradeDomainDeltaUnhealthyNodes":
            suggest = "max_percent_upgrade_domain_delta_unhealthy_nodes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterUpgradeDeltaHealthPolicyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterUpgradeDeltaHealthPolicyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterUpgradeDeltaHealthPolicyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_percent_delta_unhealthy_applications: int,
                 max_percent_delta_unhealthy_nodes: int,
                 max_percent_upgrade_domain_delta_unhealthy_nodes: int):
        """
        Delta health policy for the cluster
        :param int max_percent_delta_unhealthy_applications: Additional unhealthy applications percentage
        :param int max_percent_delta_unhealthy_nodes: Additional unhealthy nodes percentage
        :param int max_percent_upgrade_domain_delta_unhealthy_nodes: Additional unhealthy nodes percentage per upgrade domain 
        """
        pulumi.set(__self__, "max_percent_delta_unhealthy_applications", max_percent_delta_unhealthy_applications)
        pulumi.set(__self__, "max_percent_delta_unhealthy_nodes", max_percent_delta_unhealthy_nodes)
        pulumi.set(__self__, "max_percent_upgrade_domain_delta_unhealthy_nodes", max_percent_upgrade_domain_delta_unhealthy_nodes)

    @property
    @pulumi.getter(name="maxPercentDeltaUnhealthyApplications")
    def max_percent_delta_unhealthy_applications(self) -> int:
        """
        Additional unhealthy applications percentage
        """
        return pulumi.get(self, "max_percent_delta_unhealthy_applications")

    @property
    @pulumi.getter(name="maxPercentDeltaUnhealthyNodes")
    def max_percent_delta_unhealthy_nodes(self) -> int:
        """
        Additional unhealthy nodes percentage
        """
        return pulumi.get(self, "max_percent_delta_unhealthy_nodes")

    @property
    @pulumi.getter(name="maxPercentUpgradeDomainDeltaUnhealthyNodes")
    def max_percent_upgrade_domain_delta_unhealthy_nodes(self) -> int:
        """
        Additional unhealthy nodes percentage per upgrade domain 
        """
        return pulumi.get(self, "max_percent_upgrade_domain_delta_unhealthy_nodes")


@pulumi.output_type
class ClusterUpgradePolicyResponse(dict):
    """
    Cluster upgrade policy
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "healthCheckRetryTimeout":
            suggest = "health_check_retry_timeout"
        elif key == "healthCheckStableDuration":
            suggest = "health_check_stable_duration"
        elif key == "healthCheckWaitDuration":
            suggest = "health_check_wait_duration"
        elif key == "healthPolicy":
            suggest = "health_policy"
        elif key == "upgradeDomainTimeout":
            suggest = "upgrade_domain_timeout"
        elif key == "upgradeReplicaSetCheckTimeout":
            suggest = "upgrade_replica_set_check_timeout"
        elif key == "upgradeTimeout":
            suggest = "upgrade_timeout"
        elif key == "deltaHealthPolicy":
            suggest = "delta_health_policy"
        elif key == "forceRestart":
            suggest = "force_restart"
        elif key == "overrideUserUpgradePolicy":
            suggest = "override_user_upgrade_policy"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterUpgradePolicyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterUpgradePolicyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterUpgradePolicyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 health_check_retry_timeout: str,
                 health_check_stable_duration: str,
                 health_check_wait_duration: str,
                 health_policy: 'outputs.ClusterHealthPolicyResponse',
                 upgrade_domain_timeout: str,
                 upgrade_replica_set_check_timeout: str,
                 upgrade_timeout: str,
                 delta_health_policy: Optional['outputs.ClusterUpgradeDeltaHealthPolicyResponse'] = None,
                 force_restart: Optional[bool] = None,
                 override_user_upgrade_policy: Optional[bool] = None):
        """
        Cluster upgrade policy
        :param str health_check_retry_timeout: The length of time that health checks can fail continuously,it represents .Net TimeSpan
        :param str health_check_stable_duration: The length of time that health checks must pass continuously,it represents .Net TimeSpan
        :param str health_check_wait_duration: The length of time to wait after completing an upgrade domain before performing health checks, it represents .Net TimeSpan
        :param 'ClusterHealthPolicyResponse' health_policy: Cluster health Policy
        :param str upgrade_domain_timeout: The timeout for any upgrade domain,it represents .Net TimeSpan
        :param str upgrade_replica_set_check_timeout: Timeout for replica set upgrade to complete,it represents .Net TimeSpan
        :param str upgrade_timeout: The upgrade timeout,it represents .Net TimeSpan
        :param 'ClusterUpgradeDeltaHealthPolicyResponse' delta_health_policy: Delta health policy
        :param bool force_restart: Force node to restart or not
        :param bool override_user_upgrade_policy: Use the user defined upgrade policy or not
        """
        pulumi.set(__self__, "health_check_retry_timeout", health_check_retry_timeout)
        pulumi.set(__self__, "health_check_stable_duration", health_check_stable_duration)
        pulumi.set(__self__, "health_check_wait_duration", health_check_wait_duration)
        pulumi.set(__self__, "health_policy", health_policy)
        pulumi.set(__self__, "upgrade_domain_timeout", upgrade_domain_timeout)
        pulumi.set(__self__, "upgrade_replica_set_check_timeout", upgrade_replica_set_check_timeout)
        pulumi.set(__self__, "upgrade_timeout", upgrade_timeout)
        if delta_health_policy is not None:
            pulumi.set(__self__, "delta_health_policy", delta_health_policy)
        if force_restart is not None:
            pulumi.set(__self__, "force_restart", force_restart)
        if override_user_upgrade_policy is not None:
            pulumi.set(__self__, "override_user_upgrade_policy", override_user_upgrade_policy)

    @property
    @pulumi.getter(name="healthCheckRetryTimeout")
    def health_check_retry_timeout(self) -> str:
        """
        The length of time that health checks can fail continuously,it represents .Net TimeSpan
        """
        return pulumi.get(self, "health_check_retry_timeout")

    @property
    @pulumi.getter(name="healthCheckStableDuration")
    def health_check_stable_duration(self) -> str:
        """
        The length of time that health checks must pass continuously,it represents .Net TimeSpan
        """
        return pulumi.get(self, "health_check_stable_duration")

    @property
    @pulumi.getter(name="healthCheckWaitDuration")
    def health_check_wait_duration(self) -> str:
        """
        The length of time to wait after completing an upgrade domain before performing health checks, it represents .Net TimeSpan
        """
        return pulumi.get(self, "health_check_wait_duration")

    @property
    @pulumi.getter(name="healthPolicy")
    def health_policy(self) -> 'outputs.ClusterHealthPolicyResponse':
        """
        Cluster health Policy
        """
        return pulumi.get(self, "health_policy")

    @property
    @pulumi.getter(name="upgradeDomainTimeout")
    def upgrade_domain_timeout(self) -> str:
        """
        The timeout for any upgrade domain,it represents .Net TimeSpan
        """
        return pulumi.get(self, "upgrade_domain_timeout")

    @property
    @pulumi.getter(name="upgradeReplicaSetCheckTimeout")
    def upgrade_replica_set_check_timeout(self) -> str:
        """
        Timeout for replica set upgrade to complete,it represents .Net TimeSpan
        """
        return pulumi.get(self, "upgrade_replica_set_check_timeout")

    @property
    @pulumi.getter(name="upgradeTimeout")
    def upgrade_timeout(self) -> str:
        """
        The upgrade timeout,it represents .Net TimeSpan
        """
        return pulumi.get(self, "upgrade_timeout")

    @property
    @pulumi.getter(name="deltaHealthPolicy")
    def delta_health_policy(self) -> Optional['outputs.ClusterUpgradeDeltaHealthPolicyResponse']:
        """
        Delta health policy
        """
        return pulumi.get(self, "delta_health_policy")

    @property
    @pulumi.getter(name="forceRestart")
    def force_restart(self) -> Optional[bool]:
        """
        Force node to restart or not
        """
        return pulumi.get(self, "force_restart")

    @property
    @pulumi.getter(name="overrideUserUpgradePolicy")
    def override_user_upgrade_policy(self) -> Optional[bool]:
        """
        Use the user defined upgrade policy or not
        """
        return pulumi.get(self, "override_user_upgrade_policy")


@pulumi.output_type
class ClusterVersionDetailsResponse(dict):
    """
    The detail of the ServiceFabric runtime version result
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "codeVersion":
            suggest = "code_version"
        elif key == "supportExpiryUtc":
            suggest = "support_expiry_utc"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterVersionDetailsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterVersionDetailsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterVersionDetailsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 code_version: Optional[str] = None,
                 environment: Optional[str] = None,
                 support_expiry_utc: Optional[str] = None):
        """
        The detail of the ServiceFabric runtime version result
        :param str code_version: The ServiceFabric runtime version of the cluster
        :param str environment: Cluster operating system
        :param str support_expiry_utc: The date of expiry of support of the version
        """
        if code_version is not None:
            pulumi.set(__self__, "code_version", code_version)
        if environment is not None:
            pulumi.set(__self__, "environment", environment)
        if support_expiry_utc is not None:
            pulumi.set(__self__, "support_expiry_utc", support_expiry_utc)

    @property
    @pulumi.getter(name="codeVersion")
    def code_version(self) -> Optional[str]:
        """
        The ServiceFabric runtime version of the cluster
        """
        return pulumi.get(self, "code_version")

    @property
    @pulumi.getter
    def environment(self) -> Optional[str]:
        """
        Cluster operating system
        """
        return pulumi.get(self, "environment")

    @property
    @pulumi.getter(name="supportExpiryUtc")
    def support_expiry_utc(self) -> Optional[str]:
        """
        The date of expiry of support of the version
        """
        return pulumi.get(self, "support_expiry_utc")


@pulumi.output_type
class DiagnosticsStorageAccountConfigResponse(dict):
    """
    Diagnostics storage account config
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "blobEndpoint":
            suggest = "blob_endpoint"
        elif key == "protectedAccountKeyName":
            suggest = "protected_account_key_name"
        elif key == "queueEndpoint":
            suggest = "queue_endpoint"
        elif key == "storageAccountName":
            suggest = "storage_account_name"
        elif key == "tableEndpoint":
            suggest = "table_endpoint"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DiagnosticsStorageAccountConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DiagnosticsStorageAccountConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DiagnosticsStorageAccountConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 blob_endpoint: str,
                 protected_account_key_name: str,
                 queue_endpoint: str,
                 storage_account_name: str,
                 table_endpoint: str):
        """
        Diagnostics storage account config
        :param str blob_endpoint: Diagnostics storage account blob endpoint
        :param str protected_account_key_name: Protected Diagnostics storage key name
        :param str queue_endpoint: Diagnostics storage account queue endpoint
        :param str storage_account_name: Diagnostics storage account name
        :param str table_endpoint: Diagnostics storage account table endpoint
        """
        pulumi.set(__self__, "blob_endpoint", blob_endpoint)
        pulumi.set(__self__, "protected_account_key_name", protected_account_key_name)
        pulumi.set(__self__, "queue_endpoint", queue_endpoint)
        pulumi.set(__self__, "storage_account_name", storage_account_name)
        pulumi.set(__self__, "table_endpoint", table_endpoint)

    @property
    @pulumi.getter(name="blobEndpoint")
    def blob_endpoint(self) -> str:
        """
        Diagnostics storage account blob endpoint
        """
        return pulumi.get(self, "blob_endpoint")

    @property
    @pulumi.getter(name="protectedAccountKeyName")
    def protected_account_key_name(self) -> str:
        """
        Protected Diagnostics storage key name
        """
        return pulumi.get(self, "protected_account_key_name")

    @property
    @pulumi.getter(name="queueEndpoint")
    def queue_endpoint(self) -> str:
        """
        Diagnostics storage account queue endpoint
        """
        return pulumi.get(self, "queue_endpoint")

    @property
    @pulumi.getter(name="storageAccountName")
    def storage_account_name(self) -> str:
        """
        Diagnostics storage account name
        """
        return pulumi.get(self, "storage_account_name")

    @property
    @pulumi.getter(name="tableEndpoint")
    def table_endpoint(self) -> str:
        """
        Diagnostics storage account table endpoint
        """
        return pulumi.get(self, "table_endpoint")


@pulumi.output_type
class EndpointRangeDescriptionResponse(dict):
    """
    Port range details
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endPort":
            suggest = "end_port"
        elif key == "startPort":
            suggest = "start_port"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EndpointRangeDescriptionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EndpointRangeDescriptionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EndpointRangeDescriptionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 end_port: int,
                 start_port: int):
        """
        Port range details
        :param int end_port: End port of a range of ports
        :param int start_port: Starting port of a range of ports
        """
        pulumi.set(__self__, "end_port", end_port)
        pulumi.set(__self__, "start_port", start_port)

    @property
    @pulumi.getter(name="endPort")
    def end_port(self) -> int:
        """
        End port of a range of ports
        """
        return pulumi.get(self, "end_port")

    @property
    @pulumi.getter(name="startPort")
    def start_port(self) -> int:
        """
        Starting port of a range of ports
        """
        return pulumi.get(self, "start_port")


@pulumi.output_type
class NodeTypeDescriptionResponse(dict):
    """
    Describes a node type in the cluster, each node type represents sub set of nodes in the cluster
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientConnectionEndpointPort":
            suggest = "client_connection_endpoint_port"
        elif key == "httpGatewayEndpointPort":
            suggest = "http_gateway_endpoint_port"
        elif key == "isPrimary":
            suggest = "is_primary"
        elif key == "vmInstanceCount":
            suggest = "vm_instance_count"
        elif key == "applicationPorts":
            suggest = "application_ports"
        elif key == "durabilityLevel":
            suggest = "durability_level"
        elif key == "ephemeralPorts":
            suggest = "ephemeral_ports"
        elif key == "placementProperties":
            suggest = "placement_properties"
        elif key == "reverseProxyEndpointPort":
            suggest = "reverse_proxy_endpoint_port"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NodeTypeDescriptionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NodeTypeDescriptionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NodeTypeDescriptionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_connection_endpoint_port: int,
                 http_gateway_endpoint_port: int,
                 is_primary: bool,
                 name: str,
                 vm_instance_count: int,
                 application_ports: Optional['outputs.EndpointRangeDescriptionResponse'] = None,
                 capacities: Optional[Mapping[str, str]] = None,
                 durability_level: Optional[str] = None,
                 ephemeral_ports: Optional['outputs.EndpointRangeDescriptionResponse'] = None,
                 placement_properties: Optional[Mapping[str, str]] = None,
                 reverse_proxy_endpoint_port: Optional[int] = None):
        """
        Describes a node type in the cluster, each node type represents sub set of nodes in the cluster
        :param int client_connection_endpoint_port: The TCP cluster management endpoint port
        :param int http_gateway_endpoint_port: The HTTP cluster management endpoint port
        :param bool is_primary: Mark this as the primary node type
        :param str name: Name of the node type
        :param int vm_instance_count: The number of node instances in the node type
        :param 'EndpointRangeDescriptionResponse' application_ports: Ports used by applications
        :param Mapping[str, str] capacities: The capacity tags applied to the nodes in the node type, the cluster resource manager uses these tags to understand how much of a resource a node has
        :param str durability_level: Node type durability Level
        :param 'EndpointRangeDescriptionResponse' ephemeral_ports: System assigned application ports
        :param Mapping[str, str] placement_properties: The placement tags applied to nodes in the node type, which can be used to indicate where certain services (workload) should run
        :param int reverse_proxy_endpoint_port: Endpoint used by reverse proxy
        """
        pulumi.set(__self__, "client_connection_endpoint_port", client_connection_endpoint_port)
        pulumi.set(__self__, "http_gateway_endpoint_port", http_gateway_endpoint_port)
        pulumi.set(__self__, "is_primary", is_primary)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "vm_instance_count", vm_instance_count)
        if application_ports is not None:
            pulumi.set(__self__, "application_ports", application_ports)
        if capacities is not None:
            pulumi.set(__self__, "capacities", capacities)
        if durability_level is not None:
            pulumi.set(__self__, "durability_level", durability_level)
        if ephemeral_ports is not None:
            pulumi.set(__self__, "ephemeral_ports", ephemeral_ports)
        if placement_properties is not None:
            pulumi.set(__self__, "placement_properties", placement_properties)
        if reverse_proxy_endpoint_port is not None:
            pulumi.set(__self__, "reverse_proxy_endpoint_port", reverse_proxy_endpoint_port)

    @property
    @pulumi.getter(name="clientConnectionEndpointPort")
    def client_connection_endpoint_port(self) -> int:
        """
        The TCP cluster management endpoint port
        """
        return pulumi.get(self, "client_connection_endpoint_port")

    @property
    @pulumi.getter(name="httpGatewayEndpointPort")
    def http_gateway_endpoint_port(self) -> int:
        """
        The HTTP cluster management endpoint port
        """
        return pulumi.get(self, "http_gateway_endpoint_port")

    @property
    @pulumi.getter(name="isPrimary")
    def is_primary(self) -> bool:
        """
        Mark this as the primary node type
        """
        return pulumi.get(self, "is_primary")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the node type
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="vmInstanceCount")
    def vm_instance_count(self) -> int:
        """
        The number of node instances in the node type
        """
        return pulumi.get(self, "vm_instance_count")

    @property
    @pulumi.getter(name="applicationPorts")
    def application_ports(self) -> Optional['outputs.EndpointRangeDescriptionResponse']:
        """
        Ports used by applications
        """
        return pulumi.get(self, "application_ports")

    @property
    @pulumi.getter
    def capacities(self) -> Optional[Mapping[str, str]]:
        """
        The capacity tags applied to the nodes in the node type, the cluster resource manager uses these tags to understand how much of a resource a node has
        """
        return pulumi.get(self, "capacities")

    @property
    @pulumi.getter(name="durabilityLevel")
    def durability_level(self) -> Optional[str]:
        """
        Node type durability Level
        """
        return pulumi.get(self, "durability_level")

    @property
    @pulumi.getter(name="ephemeralPorts")
    def ephemeral_ports(self) -> Optional['outputs.EndpointRangeDescriptionResponse']:
        """
        System assigned application ports
        """
        return pulumi.get(self, "ephemeral_ports")

    @property
    @pulumi.getter(name="placementProperties")
    def placement_properties(self) -> Optional[Mapping[str, str]]:
        """
        The placement tags applied to nodes in the node type, which can be used to indicate where certain services (workload) should run
        """
        return pulumi.get(self, "placement_properties")

    @property
    @pulumi.getter(name="reverseProxyEndpointPort")
    def reverse_proxy_endpoint_port(self) -> Optional[int]:
        """
        Endpoint used by reverse proxy
        """
        return pulumi.get(self, "reverse_proxy_endpoint_port")


@pulumi.output_type
class SettingsParameterDescriptionResponse(dict):
    """
    ServiceFabric settings under sections
    """
    def __init__(__self__, *,
                 name: str,
                 value: str):
        """
        ServiceFabric settings under sections
        :param str name: The name of settings property
        :param str value: The value of the property
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of settings property
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The value of the property
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class SettingsSectionDescriptionResponse(dict):
    """
    ServiceFabric section settings
    """
    def __init__(__self__, *,
                 name: str,
                 parameters: Sequence['outputs.SettingsParameterDescriptionResponse']):
        """
        ServiceFabric section settings
        :param str name: The name of settings section
        :param Sequence['SettingsParameterDescriptionResponse'] parameters: Collection of settings in the section, each setting is a tuple consisting of setting name and value
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of settings section
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def parameters(self) -> Sequence['outputs.SettingsParameterDescriptionResponse']:
        """
        Collection of settings in the section, each setting is a tuple consisting of setting name and value
        """
        return pulumi.get(self, "parameters")


