# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'AzureFileshareProtectedItemExtendedInfoResponse',
    'AzureFileshareProtectedItemResponse',
    'AzureIaaSClassicComputeVMProtectedItemResponse',
    'AzureIaaSComputeVMProtectedItemResponse',
    'AzureIaaSVMHealthDetailsResponse',
    'AzureIaaSVMProtectedItemExtendedInfoResponse',
    'AzureIaaSVMProtectedItemResponse',
    'AzureSqlProtectedItemExtendedInfoResponse',
    'AzureSqlProtectedItemResponse',
    'AzureVmWorkloadProtectedItemExtendedInfoResponse',
    'AzureVmWorkloadProtectedItemResponse',
    'AzureVmWorkloadSAPAseDatabaseProtectedItemResponse',
    'AzureVmWorkloadSAPHanaDatabaseProtectedItemResponse',
    'AzureVmWorkloadSQLDatabaseProtectedItemResponse',
    'DPMProtectedItemExtendedInfoResponse',
    'DPMProtectedItemResponse',
    'DiskExclusionPropertiesResponse',
    'ErrorDetailResponse',
    'ExtendedPropertiesResponse',
    'GenericProtectedItemResponse',
    'MabFileFolderProtectedItemExtendedInfoResponse',
    'MabFileFolderProtectedItemResponse',
]

@pulumi.output_type
class AzureFileshareProtectedItemExtendedInfoResponse(dict):
    """
    Additional information about Azure File Share backup item.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceState":
            suggest = "resource_state"
        elif key == "resourceStateSyncTime":
            suggest = "resource_state_sync_time"
        elif key == "oldestRecoveryPoint":
            suggest = "oldest_recovery_point"
        elif key == "policyState":
            suggest = "policy_state"
        elif key == "recoveryPointCount":
            suggest = "recovery_point_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureFileshareProtectedItemExtendedInfoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureFileshareProtectedItemExtendedInfoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureFileshareProtectedItemExtendedInfoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 resource_state: str,
                 resource_state_sync_time: str,
                 oldest_recovery_point: Optional[str] = None,
                 policy_state: Optional[str] = None,
                 recovery_point_count: Optional[int] = None):
        """
        Additional information about Azure File Share backup item.
        :param str resource_state: Indicates the state of this resource. Possible values are from enum ResourceState {Invalid, Active, SoftDeleted, Deleted}
        :param str resource_state_sync_time: The resource state sync time for this backup item.
        :param str oldest_recovery_point: The oldest backup copy available for this item in the service.
        :param str policy_state: Indicates consistency of policy object and policy applied to this backup item.
        :param int recovery_point_count: Number of available backup copies associated with this backup item.
        """
        pulumi.set(__self__, "resource_state", resource_state)
        pulumi.set(__self__, "resource_state_sync_time", resource_state_sync_time)
        if oldest_recovery_point is not None:
            pulumi.set(__self__, "oldest_recovery_point", oldest_recovery_point)
        if policy_state is not None:
            pulumi.set(__self__, "policy_state", policy_state)
        if recovery_point_count is not None:
            pulumi.set(__self__, "recovery_point_count", recovery_point_count)

    @property
    @pulumi.getter(name="resourceState")
    def resource_state(self) -> str:
        """
        Indicates the state of this resource. Possible values are from enum ResourceState {Invalid, Active, SoftDeleted, Deleted}
        """
        return pulumi.get(self, "resource_state")

    @property
    @pulumi.getter(name="resourceStateSyncTime")
    def resource_state_sync_time(self) -> str:
        """
        The resource state sync time for this backup item.
        """
        return pulumi.get(self, "resource_state_sync_time")

    @property
    @pulumi.getter(name="oldestRecoveryPoint")
    def oldest_recovery_point(self) -> Optional[str]:
        """
        The oldest backup copy available for this item in the service.
        """
        return pulumi.get(self, "oldest_recovery_point")

    @property
    @pulumi.getter(name="policyState")
    def policy_state(self) -> Optional[str]:
        """
        Indicates consistency of policy object and policy applied to this backup item.
        """
        return pulumi.get(self, "policy_state")

    @property
    @pulumi.getter(name="recoveryPointCount")
    def recovery_point_count(self) -> Optional[int]:
        """
        Number of available backup copies associated with this backup item.
        """
        return pulumi.get(self, "recovery_point_count")


@pulumi.output_type
class AzureFileshareProtectedItemResponse(dict):
    """
    Azure File Share workload-specific backup item.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backupManagementType":
            suggest = "backup_management_type"
        elif key == "backupSetName":
            suggest = "backup_set_name"
        elif key == "containerName":
            suggest = "container_name"
        elif key == "createMode":
            suggest = "create_mode"
        elif key == "deferredDeleteTimeInUTC":
            suggest = "deferred_delete_time_in_utc"
        elif key == "deferredDeleteTimeRemaining":
            suggest = "deferred_delete_time_remaining"
        elif key == "extendedInfo":
            suggest = "extended_info"
        elif key == "friendlyName":
            suggest = "friendly_name"
        elif key == "healthStatus":
            suggest = "health_status"
        elif key == "isDeferredDeleteScheduleUpcoming":
            suggest = "is_deferred_delete_schedule_upcoming"
        elif key == "isRehydrate":
            suggest = "is_rehydrate"
        elif key == "isScheduledForDeferredDelete":
            suggest = "is_scheduled_for_deferred_delete"
        elif key == "lastBackupStatus":
            suggest = "last_backup_status"
        elif key == "lastBackupTime":
            suggest = "last_backup_time"
        elif key == "lastRecoveryPoint":
            suggest = "last_recovery_point"
        elif key == "policyId":
            suggest = "policy_id"
        elif key == "protectedItemType":
            suggest = "protected_item_type"
        elif key == "protectionState":
            suggest = "protection_state"
        elif key == "protectionStatus":
            suggest = "protection_status"
        elif key == "sourceResourceId":
            suggest = "source_resource_id"
        elif key == "workloadType":
            suggest = "workload_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureFileshareProtectedItemResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureFileshareProtectedItemResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureFileshareProtectedItemResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backup_management_type: Optional[str] = None,
                 backup_set_name: Optional[str] = None,
                 container_name: Optional[str] = None,
                 create_mode: Optional[str] = None,
                 deferred_delete_time_in_utc: Optional[str] = None,
                 deferred_delete_time_remaining: Optional[str] = None,
                 extended_info: Optional['outputs.AzureFileshareProtectedItemExtendedInfoResponse'] = None,
                 friendly_name: Optional[str] = None,
                 health_status: Optional[str] = None,
                 is_deferred_delete_schedule_upcoming: Optional[bool] = None,
                 is_rehydrate: Optional[bool] = None,
                 is_scheduled_for_deferred_delete: Optional[bool] = None,
                 last_backup_status: Optional[str] = None,
                 last_backup_time: Optional[str] = None,
                 last_recovery_point: Optional[str] = None,
                 policy_id: Optional[str] = None,
                 protected_item_type: Optional[str] = None,
                 protection_state: Optional[str] = None,
                 protection_status: Optional[str] = None,
                 source_resource_id: Optional[str] = None,
                 workload_type: Optional[str] = None):
        """
        Azure File Share workload-specific backup item.
        :param str backup_management_type: Type of backup management for the backed up item.
        :param str backup_set_name: Name of the backup set the backup item belongs to
        :param str container_name: Unique name of container
        :param str create_mode: Create mode to indicate recovery of existing soft deleted data source or creation of new data source.
        :param str deferred_delete_time_in_utc: Time for deferred deletion in UTC
        :param str deferred_delete_time_remaining: Time remaining before the DS marked for deferred delete is permanently deleted
        :param 'AzureFileshareProtectedItemExtendedInfoResponse' extended_info: Additional information with this backup item.
        :param str friendly_name: Friendly name of the fileshare represented by this backup item.
        :param str health_status: backups running status for this backup item.
        :param bool is_deferred_delete_schedule_upcoming: Flag to identify whether the deferred deleted DS is to be purged soon
        :param bool is_rehydrate: Flag to identify that deferred deleted DS is to be moved into Pause state
        :param bool is_scheduled_for_deferred_delete: Flag to identify whether the DS is scheduled for deferred delete
        :param str last_backup_status: Last backup operation status. Possible values: Healthy, Unhealthy.
        :param str last_backup_time: Timestamp of the last backup operation on this backup item.
        :param str last_recovery_point: Timestamp when the last (latest) backup copy was created for this backup item.
        :param str policy_id: ID of the backup policy with which this item is backed up.
        :param str protected_item_type: backup item type.
               Expected value is 'AzureFileShareProtectedItem'.
        :param str protection_state: Backup state of this backup item.
        :param str protection_status: Backup status of this backup item.
        :param str source_resource_id: ARM ID of the resource to be backed up.
        :param str workload_type: Type of workload this item represents.
        """
        if backup_management_type is not None:
            pulumi.set(__self__, "backup_management_type", backup_management_type)
        if backup_set_name is not None:
            pulumi.set(__self__, "backup_set_name", backup_set_name)
        if container_name is not None:
            pulumi.set(__self__, "container_name", container_name)
        if create_mode is not None:
            pulumi.set(__self__, "create_mode", create_mode)
        if deferred_delete_time_in_utc is not None:
            pulumi.set(__self__, "deferred_delete_time_in_utc", deferred_delete_time_in_utc)
        if deferred_delete_time_remaining is not None:
            pulumi.set(__self__, "deferred_delete_time_remaining", deferred_delete_time_remaining)
        if extended_info is not None:
            pulumi.set(__self__, "extended_info", extended_info)
        if friendly_name is not None:
            pulumi.set(__self__, "friendly_name", friendly_name)
        if health_status is not None:
            pulumi.set(__self__, "health_status", health_status)
        if is_deferred_delete_schedule_upcoming is not None:
            pulumi.set(__self__, "is_deferred_delete_schedule_upcoming", is_deferred_delete_schedule_upcoming)
        if is_rehydrate is not None:
            pulumi.set(__self__, "is_rehydrate", is_rehydrate)
        if is_scheduled_for_deferred_delete is not None:
            pulumi.set(__self__, "is_scheduled_for_deferred_delete", is_scheduled_for_deferred_delete)
        if last_backup_status is not None:
            pulumi.set(__self__, "last_backup_status", last_backup_status)
        if last_backup_time is not None:
            pulumi.set(__self__, "last_backup_time", last_backup_time)
        if last_recovery_point is not None:
            pulumi.set(__self__, "last_recovery_point", last_recovery_point)
        if policy_id is not None:
            pulumi.set(__self__, "policy_id", policy_id)
        if protected_item_type is not None:
            pulumi.set(__self__, "protected_item_type", 'AzureFileShareProtectedItem')
        if protection_state is not None:
            pulumi.set(__self__, "protection_state", protection_state)
        if protection_status is not None:
            pulumi.set(__self__, "protection_status", protection_status)
        if source_resource_id is not None:
            pulumi.set(__self__, "source_resource_id", source_resource_id)
        if workload_type is not None:
            pulumi.set(__self__, "workload_type", workload_type)

    @property
    @pulumi.getter(name="backupManagementType")
    def backup_management_type(self) -> Optional[str]:
        """
        Type of backup management for the backed up item.
        """
        return pulumi.get(self, "backup_management_type")

    @property
    @pulumi.getter(name="backupSetName")
    def backup_set_name(self) -> Optional[str]:
        """
        Name of the backup set the backup item belongs to
        """
        return pulumi.get(self, "backup_set_name")

    @property
    @pulumi.getter(name="containerName")
    def container_name(self) -> Optional[str]:
        """
        Unique name of container
        """
        return pulumi.get(self, "container_name")

    @property
    @pulumi.getter(name="createMode")
    def create_mode(self) -> Optional[str]:
        """
        Create mode to indicate recovery of existing soft deleted data source or creation of new data source.
        """
        return pulumi.get(self, "create_mode")

    @property
    @pulumi.getter(name="deferredDeleteTimeInUTC")
    def deferred_delete_time_in_utc(self) -> Optional[str]:
        """
        Time for deferred deletion in UTC
        """
        return pulumi.get(self, "deferred_delete_time_in_utc")

    @property
    @pulumi.getter(name="deferredDeleteTimeRemaining")
    def deferred_delete_time_remaining(self) -> Optional[str]:
        """
        Time remaining before the DS marked for deferred delete is permanently deleted
        """
        return pulumi.get(self, "deferred_delete_time_remaining")

    @property
    @pulumi.getter(name="extendedInfo")
    def extended_info(self) -> Optional['outputs.AzureFileshareProtectedItemExtendedInfoResponse']:
        """
        Additional information with this backup item.
        """
        return pulumi.get(self, "extended_info")

    @property
    @pulumi.getter(name="friendlyName")
    def friendly_name(self) -> Optional[str]:
        """
        Friendly name of the fileshare represented by this backup item.
        """
        return pulumi.get(self, "friendly_name")

    @property
    @pulumi.getter(name="healthStatus")
    def health_status(self) -> Optional[str]:
        """
        backups running status for this backup item.
        """
        return pulumi.get(self, "health_status")

    @property
    @pulumi.getter(name="isDeferredDeleteScheduleUpcoming")
    def is_deferred_delete_schedule_upcoming(self) -> Optional[bool]:
        """
        Flag to identify whether the deferred deleted DS is to be purged soon
        """
        return pulumi.get(self, "is_deferred_delete_schedule_upcoming")

    @property
    @pulumi.getter(name="isRehydrate")
    def is_rehydrate(self) -> Optional[bool]:
        """
        Flag to identify that deferred deleted DS is to be moved into Pause state
        """
        return pulumi.get(self, "is_rehydrate")

    @property
    @pulumi.getter(name="isScheduledForDeferredDelete")
    def is_scheduled_for_deferred_delete(self) -> Optional[bool]:
        """
        Flag to identify whether the DS is scheduled for deferred delete
        """
        return pulumi.get(self, "is_scheduled_for_deferred_delete")

    @property
    @pulumi.getter(name="lastBackupStatus")
    def last_backup_status(self) -> Optional[str]:
        """
        Last backup operation status. Possible values: Healthy, Unhealthy.
        """
        return pulumi.get(self, "last_backup_status")

    @property
    @pulumi.getter(name="lastBackupTime")
    def last_backup_time(self) -> Optional[str]:
        """
        Timestamp of the last backup operation on this backup item.
        """
        return pulumi.get(self, "last_backup_time")

    @property
    @pulumi.getter(name="lastRecoveryPoint")
    def last_recovery_point(self) -> Optional[str]:
        """
        Timestamp when the last (latest) backup copy was created for this backup item.
        """
        return pulumi.get(self, "last_recovery_point")

    @property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> Optional[str]:
        """
        ID of the backup policy with which this item is backed up.
        """
        return pulumi.get(self, "policy_id")

    @property
    @pulumi.getter(name="protectedItemType")
    def protected_item_type(self) -> Optional[str]:
        """
        backup item type.
        Expected value is 'AzureFileShareProtectedItem'.
        """
        return pulumi.get(self, "protected_item_type")

    @property
    @pulumi.getter(name="protectionState")
    def protection_state(self) -> Optional[str]:
        """
        Backup state of this backup item.
        """
        return pulumi.get(self, "protection_state")

    @property
    @pulumi.getter(name="protectionStatus")
    def protection_status(self) -> Optional[str]:
        """
        Backup status of this backup item.
        """
        return pulumi.get(self, "protection_status")

    @property
    @pulumi.getter(name="sourceResourceId")
    def source_resource_id(self) -> Optional[str]:
        """
        ARM ID of the resource to be backed up.
        """
        return pulumi.get(self, "source_resource_id")

    @property
    @pulumi.getter(name="workloadType")
    def workload_type(self) -> Optional[str]:
        """
        Type of workload this item represents.
        """
        return pulumi.get(self, "workload_type")


@pulumi.output_type
class AzureIaaSClassicComputeVMProtectedItemResponse(dict):
    """
    IaaS VM workload-specific backup item representing the Classic Compute VM.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backupManagementType":
            suggest = "backup_management_type"
        elif key == "backupSetName":
            suggest = "backup_set_name"
        elif key == "containerName":
            suggest = "container_name"
        elif key == "createMode":
            suggest = "create_mode"
        elif key == "deferredDeleteTimeInUTC":
            suggest = "deferred_delete_time_in_utc"
        elif key == "deferredDeleteTimeRemaining":
            suggest = "deferred_delete_time_remaining"
        elif key == "extendedInfo":
            suggest = "extended_info"
        elif key == "extendedProperties":
            suggest = "extended_properties"
        elif key == "friendlyName":
            suggest = "friendly_name"
        elif key == "healthDetails":
            suggest = "health_details"
        elif key == "healthStatus":
            suggest = "health_status"
        elif key == "isDeferredDeleteScheduleUpcoming":
            suggest = "is_deferred_delete_schedule_upcoming"
        elif key == "isRehydrate":
            suggest = "is_rehydrate"
        elif key == "isScheduledForDeferredDelete":
            suggest = "is_scheduled_for_deferred_delete"
        elif key == "lastBackupStatus":
            suggest = "last_backup_status"
        elif key == "lastBackupTime":
            suggest = "last_backup_time"
        elif key == "lastRecoveryPoint":
            suggest = "last_recovery_point"
        elif key == "policyId":
            suggest = "policy_id"
        elif key == "protectedItemDataId":
            suggest = "protected_item_data_id"
        elif key == "protectedItemType":
            suggest = "protected_item_type"
        elif key == "protectionState":
            suggest = "protection_state"
        elif key == "protectionStatus":
            suggest = "protection_status"
        elif key == "sourceResourceId":
            suggest = "source_resource_id"
        elif key == "virtualMachineId":
            suggest = "virtual_machine_id"
        elif key == "workloadType":
            suggest = "workload_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureIaaSClassicComputeVMProtectedItemResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureIaaSClassicComputeVMProtectedItemResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureIaaSClassicComputeVMProtectedItemResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backup_management_type: Optional[str] = None,
                 backup_set_name: Optional[str] = None,
                 container_name: Optional[str] = None,
                 create_mode: Optional[str] = None,
                 deferred_delete_time_in_utc: Optional[str] = None,
                 deferred_delete_time_remaining: Optional[str] = None,
                 extended_info: Optional['outputs.AzureIaaSVMProtectedItemExtendedInfoResponse'] = None,
                 extended_properties: Optional['outputs.ExtendedPropertiesResponse'] = None,
                 friendly_name: Optional[str] = None,
                 health_details: Optional[Sequence['outputs.AzureIaaSVMHealthDetailsResponse']] = None,
                 health_status: Optional[str] = None,
                 is_deferred_delete_schedule_upcoming: Optional[bool] = None,
                 is_rehydrate: Optional[bool] = None,
                 is_scheduled_for_deferred_delete: Optional[bool] = None,
                 last_backup_status: Optional[str] = None,
                 last_backup_time: Optional[str] = None,
                 last_recovery_point: Optional[str] = None,
                 policy_id: Optional[str] = None,
                 protected_item_data_id: Optional[str] = None,
                 protected_item_type: Optional[str] = None,
                 protection_state: Optional[str] = None,
                 protection_status: Optional[str] = None,
                 source_resource_id: Optional[str] = None,
                 virtual_machine_id: Optional[str] = None,
                 workload_type: Optional[str] = None):
        """
        IaaS VM workload-specific backup item representing the Classic Compute VM.
        :param str backup_management_type: Type of backup management for the backed up item.
        :param str backup_set_name: Name of the backup set the backup item belongs to
        :param str container_name: Unique name of container
        :param str create_mode: Create mode to indicate recovery of existing soft deleted data source or creation of new data source.
        :param str deferred_delete_time_in_utc: Time for deferred deletion in UTC
        :param str deferred_delete_time_remaining: Time remaining before the DS marked for deferred delete is permanently deleted
        :param 'AzureIaaSVMProtectedItemExtendedInfoResponse' extended_info: Additional information for this backup item.
        :param 'ExtendedPropertiesResponse' extended_properties: Extended Properties for Azure IaasVM Backup.
        :param str friendly_name: Friendly name of the VM represented by this backup item.
        :param Sequence['AzureIaaSVMHealthDetailsResponse'] health_details: Health details on this backup item.
        :param str health_status: Health status of protected item
        :param bool is_deferred_delete_schedule_upcoming: Flag to identify whether the deferred deleted DS is to be purged soon
        :param bool is_rehydrate: Flag to identify that deferred deleted DS is to be moved into Pause state
        :param bool is_scheduled_for_deferred_delete: Flag to identify whether the DS is scheduled for deferred delete
        :param str last_backup_status: Last backup operation status.
        :param str last_backup_time: Timestamp of the last backup operation on this backup item.
        :param str last_recovery_point: Timestamp when the last (latest) backup copy was created for this backup item.
        :param str policy_id: ID of the backup policy with which this item is backed up.
        :param str protected_item_data_id: Data ID of the protected item.
        :param str protected_item_type: backup item type.
               Expected value is 'Microsoft.ClassicCompute/virtualMachines'.
        :param str protection_state: Backup state of this backup item.
        :param str protection_status: Backup status of this backup item.
        :param str source_resource_id: ARM ID of the resource to be backed up.
        :param str virtual_machine_id: Fully qualified ARM ID of the virtual machine represented by this item.
        :param str workload_type: Type of workload this item represents.
        """
        if backup_management_type is not None:
            pulumi.set(__self__, "backup_management_type", backup_management_type)
        if backup_set_name is not None:
            pulumi.set(__self__, "backup_set_name", backup_set_name)
        if container_name is not None:
            pulumi.set(__self__, "container_name", container_name)
        if create_mode is not None:
            pulumi.set(__self__, "create_mode", create_mode)
        if deferred_delete_time_in_utc is not None:
            pulumi.set(__self__, "deferred_delete_time_in_utc", deferred_delete_time_in_utc)
        if deferred_delete_time_remaining is not None:
            pulumi.set(__self__, "deferred_delete_time_remaining", deferred_delete_time_remaining)
        if extended_info is not None:
            pulumi.set(__self__, "extended_info", extended_info)
        if extended_properties is not None:
            pulumi.set(__self__, "extended_properties", extended_properties)
        if friendly_name is not None:
            pulumi.set(__self__, "friendly_name", friendly_name)
        if health_details is not None:
            pulumi.set(__self__, "health_details", health_details)
        if health_status is not None:
            pulumi.set(__self__, "health_status", health_status)
        if is_deferred_delete_schedule_upcoming is not None:
            pulumi.set(__self__, "is_deferred_delete_schedule_upcoming", is_deferred_delete_schedule_upcoming)
        if is_rehydrate is not None:
            pulumi.set(__self__, "is_rehydrate", is_rehydrate)
        if is_scheduled_for_deferred_delete is not None:
            pulumi.set(__self__, "is_scheduled_for_deferred_delete", is_scheduled_for_deferred_delete)
        if last_backup_status is not None:
            pulumi.set(__self__, "last_backup_status", last_backup_status)
        if last_backup_time is not None:
            pulumi.set(__self__, "last_backup_time", last_backup_time)
        if last_recovery_point is not None:
            pulumi.set(__self__, "last_recovery_point", last_recovery_point)
        if policy_id is not None:
            pulumi.set(__self__, "policy_id", policy_id)
        if protected_item_data_id is not None:
            pulumi.set(__self__, "protected_item_data_id", protected_item_data_id)
        if protected_item_type is not None:
            pulumi.set(__self__, "protected_item_type", 'Microsoft.ClassicCompute/virtualMachines')
        if protection_state is not None:
            pulumi.set(__self__, "protection_state", protection_state)
        if protection_status is not None:
            pulumi.set(__self__, "protection_status", protection_status)
        if source_resource_id is not None:
            pulumi.set(__self__, "source_resource_id", source_resource_id)
        if virtual_machine_id is not None:
            pulumi.set(__self__, "virtual_machine_id", virtual_machine_id)
        if workload_type is not None:
            pulumi.set(__self__, "workload_type", workload_type)

    @property
    @pulumi.getter(name="backupManagementType")
    def backup_management_type(self) -> Optional[str]:
        """
        Type of backup management for the backed up item.
        """
        return pulumi.get(self, "backup_management_type")

    @property
    @pulumi.getter(name="backupSetName")
    def backup_set_name(self) -> Optional[str]:
        """
        Name of the backup set the backup item belongs to
        """
        return pulumi.get(self, "backup_set_name")

    @property
    @pulumi.getter(name="containerName")
    def container_name(self) -> Optional[str]:
        """
        Unique name of container
        """
        return pulumi.get(self, "container_name")

    @property
    @pulumi.getter(name="createMode")
    def create_mode(self) -> Optional[str]:
        """
        Create mode to indicate recovery of existing soft deleted data source or creation of new data source.
        """
        return pulumi.get(self, "create_mode")

    @property
    @pulumi.getter(name="deferredDeleteTimeInUTC")
    def deferred_delete_time_in_utc(self) -> Optional[str]:
        """
        Time for deferred deletion in UTC
        """
        return pulumi.get(self, "deferred_delete_time_in_utc")

    @property
    @pulumi.getter(name="deferredDeleteTimeRemaining")
    def deferred_delete_time_remaining(self) -> Optional[str]:
        """
        Time remaining before the DS marked for deferred delete is permanently deleted
        """
        return pulumi.get(self, "deferred_delete_time_remaining")

    @property
    @pulumi.getter(name="extendedInfo")
    def extended_info(self) -> Optional['outputs.AzureIaaSVMProtectedItemExtendedInfoResponse']:
        """
        Additional information for this backup item.
        """
        return pulumi.get(self, "extended_info")

    @property
    @pulumi.getter(name="extendedProperties")
    def extended_properties(self) -> Optional['outputs.ExtendedPropertiesResponse']:
        """
        Extended Properties for Azure IaasVM Backup.
        """
        return pulumi.get(self, "extended_properties")

    @property
    @pulumi.getter(name="friendlyName")
    def friendly_name(self) -> Optional[str]:
        """
        Friendly name of the VM represented by this backup item.
        """
        return pulumi.get(self, "friendly_name")

    @property
    @pulumi.getter(name="healthDetails")
    def health_details(self) -> Optional[Sequence['outputs.AzureIaaSVMHealthDetailsResponse']]:
        """
        Health details on this backup item.
        """
        return pulumi.get(self, "health_details")

    @property
    @pulumi.getter(name="healthStatus")
    def health_status(self) -> Optional[str]:
        """
        Health status of protected item
        """
        return pulumi.get(self, "health_status")

    @property
    @pulumi.getter(name="isDeferredDeleteScheduleUpcoming")
    def is_deferred_delete_schedule_upcoming(self) -> Optional[bool]:
        """
        Flag to identify whether the deferred deleted DS is to be purged soon
        """
        return pulumi.get(self, "is_deferred_delete_schedule_upcoming")

    @property
    @pulumi.getter(name="isRehydrate")
    def is_rehydrate(self) -> Optional[bool]:
        """
        Flag to identify that deferred deleted DS is to be moved into Pause state
        """
        return pulumi.get(self, "is_rehydrate")

    @property
    @pulumi.getter(name="isScheduledForDeferredDelete")
    def is_scheduled_for_deferred_delete(self) -> Optional[bool]:
        """
        Flag to identify whether the DS is scheduled for deferred delete
        """
        return pulumi.get(self, "is_scheduled_for_deferred_delete")

    @property
    @pulumi.getter(name="lastBackupStatus")
    def last_backup_status(self) -> Optional[str]:
        """
        Last backup operation status.
        """
        return pulumi.get(self, "last_backup_status")

    @property
    @pulumi.getter(name="lastBackupTime")
    def last_backup_time(self) -> Optional[str]:
        """
        Timestamp of the last backup operation on this backup item.
        """
        return pulumi.get(self, "last_backup_time")

    @property
    @pulumi.getter(name="lastRecoveryPoint")
    def last_recovery_point(self) -> Optional[str]:
        """
        Timestamp when the last (latest) backup copy was created for this backup item.
        """
        return pulumi.get(self, "last_recovery_point")

    @property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> Optional[str]:
        """
        ID of the backup policy with which this item is backed up.
        """
        return pulumi.get(self, "policy_id")

    @property
    @pulumi.getter(name="protectedItemDataId")
    def protected_item_data_id(self) -> Optional[str]:
        """
        Data ID of the protected item.
        """
        return pulumi.get(self, "protected_item_data_id")

    @property
    @pulumi.getter(name="protectedItemType")
    def protected_item_type(self) -> Optional[str]:
        """
        backup item type.
        Expected value is 'Microsoft.ClassicCompute/virtualMachines'.
        """
        return pulumi.get(self, "protected_item_type")

    @property
    @pulumi.getter(name="protectionState")
    def protection_state(self) -> Optional[str]:
        """
        Backup state of this backup item.
        """
        return pulumi.get(self, "protection_state")

    @property
    @pulumi.getter(name="protectionStatus")
    def protection_status(self) -> Optional[str]:
        """
        Backup status of this backup item.
        """
        return pulumi.get(self, "protection_status")

    @property
    @pulumi.getter(name="sourceResourceId")
    def source_resource_id(self) -> Optional[str]:
        """
        ARM ID of the resource to be backed up.
        """
        return pulumi.get(self, "source_resource_id")

    @property
    @pulumi.getter(name="virtualMachineId")
    def virtual_machine_id(self) -> Optional[str]:
        """
        Fully qualified ARM ID of the virtual machine represented by this item.
        """
        return pulumi.get(self, "virtual_machine_id")

    @property
    @pulumi.getter(name="workloadType")
    def workload_type(self) -> Optional[str]:
        """
        Type of workload this item represents.
        """
        return pulumi.get(self, "workload_type")


@pulumi.output_type
class AzureIaaSComputeVMProtectedItemResponse(dict):
    """
    IaaS VM workload-specific backup item representing the Azure Resource Manager VM.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backupManagementType":
            suggest = "backup_management_type"
        elif key == "backupSetName":
            suggest = "backup_set_name"
        elif key == "containerName":
            suggest = "container_name"
        elif key == "createMode":
            suggest = "create_mode"
        elif key == "deferredDeleteTimeInUTC":
            suggest = "deferred_delete_time_in_utc"
        elif key == "deferredDeleteTimeRemaining":
            suggest = "deferred_delete_time_remaining"
        elif key == "extendedInfo":
            suggest = "extended_info"
        elif key == "extendedProperties":
            suggest = "extended_properties"
        elif key == "friendlyName":
            suggest = "friendly_name"
        elif key == "healthDetails":
            suggest = "health_details"
        elif key == "healthStatus":
            suggest = "health_status"
        elif key == "isDeferredDeleteScheduleUpcoming":
            suggest = "is_deferred_delete_schedule_upcoming"
        elif key == "isRehydrate":
            suggest = "is_rehydrate"
        elif key == "isScheduledForDeferredDelete":
            suggest = "is_scheduled_for_deferred_delete"
        elif key == "lastBackupStatus":
            suggest = "last_backup_status"
        elif key == "lastBackupTime":
            suggest = "last_backup_time"
        elif key == "lastRecoveryPoint":
            suggest = "last_recovery_point"
        elif key == "policyId":
            suggest = "policy_id"
        elif key == "protectedItemDataId":
            suggest = "protected_item_data_id"
        elif key == "protectedItemType":
            suggest = "protected_item_type"
        elif key == "protectionState":
            suggest = "protection_state"
        elif key == "protectionStatus":
            suggest = "protection_status"
        elif key == "sourceResourceId":
            suggest = "source_resource_id"
        elif key == "virtualMachineId":
            suggest = "virtual_machine_id"
        elif key == "workloadType":
            suggest = "workload_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureIaaSComputeVMProtectedItemResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureIaaSComputeVMProtectedItemResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureIaaSComputeVMProtectedItemResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backup_management_type: Optional[str] = None,
                 backup_set_name: Optional[str] = None,
                 container_name: Optional[str] = None,
                 create_mode: Optional[str] = None,
                 deferred_delete_time_in_utc: Optional[str] = None,
                 deferred_delete_time_remaining: Optional[str] = None,
                 extended_info: Optional['outputs.AzureIaaSVMProtectedItemExtendedInfoResponse'] = None,
                 extended_properties: Optional['outputs.ExtendedPropertiesResponse'] = None,
                 friendly_name: Optional[str] = None,
                 health_details: Optional[Sequence['outputs.AzureIaaSVMHealthDetailsResponse']] = None,
                 health_status: Optional[str] = None,
                 is_deferred_delete_schedule_upcoming: Optional[bool] = None,
                 is_rehydrate: Optional[bool] = None,
                 is_scheduled_for_deferred_delete: Optional[bool] = None,
                 last_backup_status: Optional[str] = None,
                 last_backup_time: Optional[str] = None,
                 last_recovery_point: Optional[str] = None,
                 policy_id: Optional[str] = None,
                 protected_item_data_id: Optional[str] = None,
                 protected_item_type: Optional[str] = None,
                 protection_state: Optional[str] = None,
                 protection_status: Optional[str] = None,
                 source_resource_id: Optional[str] = None,
                 virtual_machine_id: Optional[str] = None,
                 workload_type: Optional[str] = None):
        """
        IaaS VM workload-specific backup item representing the Azure Resource Manager VM.
        :param str backup_management_type: Type of backup management for the backed up item.
        :param str backup_set_name: Name of the backup set the backup item belongs to
        :param str container_name: Unique name of container
        :param str create_mode: Create mode to indicate recovery of existing soft deleted data source or creation of new data source.
        :param str deferred_delete_time_in_utc: Time for deferred deletion in UTC
        :param str deferred_delete_time_remaining: Time remaining before the DS marked for deferred delete is permanently deleted
        :param 'AzureIaaSVMProtectedItemExtendedInfoResponse' extended_info: Additional information for this backup item.
        :param 'ExtendedPropertiesResponse' extended_properties: Extended Properties for Azure IaasVM Backup.
        :param str friendly_name: Friendly name of the VM represented by this backup item.
        :param Sequence['AzureIaaSVMHealthDetailsResponse'] health_details: Health details on this backup item.
        :param str health_status: Health status of protected item
        :param bool is_deferred_delete_schedule_upcoming: Flag to identify whether the deferred deleted DS is to be purged soon
        :param bool is_rehydrate: Flag to identify that deferred deleted DS is to be moved into Pause state
        :param bool is_scheduled_for_deferred_delete: Flag to identify whether the DS is scheduled for deferred delete
        :param str last_backup_status: Last backup operation status.
        :param str last_backup_time: Timestamp of the last backup operation on this backup item.
        :param str last_recovery_point: Timestamp when the last (latest) backup copy was created for this backup item.
        :param str policy_id: ID of the backup policy with which this item is backed up.
        :param str protected_item_data_id: Data ID of the protected item.
        :param str protected_item_type: backup item type.
               Expected value is 'Microsoft.Compute/virtualMachines'.
        :param str protection_state: Backup state of this backup item.
        :param str protection_status: Backup status of this backup item.
        :param str source_resource_id: ARM ID of the resource to be backed up.
        :param str virtual_machine_id: Fully qualified ARM ID of the virtual machine represented by this item.
        :param str workload_type: Type of workload this item represents.
        """
        if backup_management_type is not None:
            pulumi.set(__self__, "backup_management_type", backup_management_type)
        if backup_set_name is not None:
            pulumi.set(__self__, "backup_set_name", backup_set_name)
        if container_name is not None:
            pulumi.set(__self__, "container_name", container_name)
        if create_mode is not None:
            pulumi.set(__self__, "create_mode", create_mode)
        if deferred_delete_time_in_utc is not None:
            pulumi.set(__self__, "deferred_delete_time_in_utc", deferred_delete_time_in_utc)
        if deferred_delete_time_remaining is not None:
            pulumi.set(__self__, "deferred_delete_time_remaining", deferred_delete_time_remaining)
        if extended_info is not None:
            pulumi.set(__self__, "extended_info", extended_info)
        if extended_properties is not None:
            pulumi.set(__self__, "extended_properties", extended_properties)
        if friendly_name is not None:
            pulumi.set(__self__, "friendly_name", friendly_name)
        if health_details is not None:
            pulumi.set(__self__, "health_details", health_details)
        if health_status is not None:
            pulumi.set(__self__, "health_status", health_status)
        if is_deferred_delete_schedule_upcoming is not None:
            pulumi.set(__self__, "is_deferred_delete_schedule_upcoming", is_deferred_delete_schedule_upcoming)
        if is_rehydrate is not None:
            pulumi.set(__self__, "is_rehydrate", is_rehydrate)
        if is_scheduled_for_deferred_delete is not None:
            pulumi.set(__self__, "is_scheduled_for_deferred_delete", is_scheduled_for_deferred_delete)
        if last_backup_status is not None:
            pulumi.set(__self__, "last_backup_status", last_backup_status)
        if last_backup_time is not None:
            pulumi.set(__self__, "last_backup_time", last_backup_time)
        if last_recovery_point is not None:
            pulumi.set(__self__, "last_recovery_point", last_recovery_point)
        if policy_id is not None:
            pulumi.set(__self__, "policy_id", policy_id)
        if protected_item_data_id is not None:
            pulumi.set(__self__, "protected_item_data_id", protected_item_data_id)
        if protected_item_type is not None:
            pulumi.set(__self__, "protected_item_type", 'Microsoft.Compute/virtualMachines')
        if protection_state is not None:
            pulumi.set(__self__, "protection_state", protection_state)
        if protection_status is not None:
            pulumi.set(__self__, "protection_status", protection_status)
        if source_resource_id is not None:
            pulumi.set(__self__, "source_resource_id", source_resource_id)
        if virtual_machine_id is not None:
            pulumi.set(__self__, "virtual_machine_id", virtual_machine_id)
        if workload_type is not None:
            pulumi.set(__self__, "workload_type", workload_type)

    @property
    @pulumi.getter(name="backupManagementType")
    def backup_management_type(self) -> Optional[str]:
        """
        Type of backup management for the backed up item.
        """
        return pulumi.get(self, "backup_management_type")

    @property
    @pulumi.getter(name="backupSetName")
    def backup_set_name(self) -> Optional[str]:
        """
        Name of the backup set the backup item belongs to
        """
        return pulumi.get(self, "backup_set_name")

    @property
    @pulumi.getter(name="containerName")
    def container_name(self) -> Optional[str]:
        """
        Unique name of container
        """
        return pulumi.get(self, "container_name")

    @property
    @pulumi.getter(name="createMode")
    def create_mode(self) -> Optional[str]:
        """
        Create mode to indicate recovery of existing soft deleted data source or creation of new data source.
        """
        return pulumi.get(self, "create_mode")

    @property
    @pulumi.getter(name="deferredDeleteTimeInUTC")
    def deferred_delete_time_in_utc(self) -> Optional[str]:
        """
        Time for deferred deletion in UTC
        """
        return pulumi.get(self, "deferred_delete_time_in_utc")

    @property
    @pulumi.getter(name="deferredDeleteTimeRemaining")
    def deferred_delete_time_remaining(self) -> Optional[str]:
        """
        Time remaining before the DS marked for deferred delete is permanently deleted
        """
        return pulumi.get(self, "deferred_delete_time_remaining")

    @property
    @pulumi.getter(name="extendedInfo")
    def extended_info(self) -> Optional['outputs.AzureIaaSVMProtectedItemExtendedInfoResponse']:
        """
        Additional information for this backup item.
        """
        return pulumi.get(self, "extended_info")

    @property
    @pulumi.getter(name="extendedProperties")
    def extended_properties(self) -> Optional['outputs.ExtendedPropertiesResponse']:
        """
        Extended Properties for Azure IaasVM Backup.
        """
        return pulumi.get(self, "extended_properties")

    @property
    @pulumi.getter(name="friendlyName")
    def friendly_name(self) -> Optional[str]:
        """
        Friendly name of the VM represented by this backup item.
        """
        return pulumi.get(self, "friendly_name")

    @property
    @pulumi.getter(name="healthDetails")
    def health_details(self) -> Optional[Sequence['outputs.AzureIaaSVMHealthDetailsResponse']]:
        """
        Health details on this backup item.
        """
        return pulumi.get(self, "health_details")

    @property
    @pulumi.getter(name="healthStatus")
    def health_status(self) -> Optional[str]:
        """
        Health status of protected item
        """
        return pulumi.get(self, "health_status")

    @property
    @pulumi.getter(name="isDeferredDeleteScheduleUpcoming")
    def is_deferred_delete_schedule_upcoming(self) -> Optional[bool]:
        """
        Flag to identify whether the deferred deleted DS is to be purged soon
        """
        return pulumi.get(self, "is_deferred_delete_schedule_upcoming")

    @property
    @pulumi.getter(name="isRehydrate")
    def is_rehydrate(self) -> Optional[bool]:
        """
        Flag to identify that deferred deleted DS is to be moved into Pause state
        """
        return pulumi.get(self, "is_rehydrate")

    @property
    @pulumi.getter(name="isScheduledForDeferredDelete")
    def is_scheduled_for_deferred_delete(self) -> Optional[bool]:
        """
        Flag to identify whether the DS is scheduled for deferred delete
        """
        return pulumi.get(self, "is_scheduled_for_deferred_delete")

    @property
    @pulumi.getter(name="lastBackupStatus")
    def last_backup_status(self) -> Optional[str]:
        """
        Last backup operation status.
        """
        return pulumi.get(self, "last_backup_status")

    @property
    @pulumi.getter(name="lastBackupTime")
    def last_backup_time(self) -> Optional[str]:
        """
        Timestamp of the last backup operation on this backup item.
        """
        return pulumi.get(self, "last_backup_time")

    @property
    @pulumi.getter(name="lastRecoveryPoint")
    def last_recovery_point(self) -> Optional[str]:
        """
        Timestamp when the last (latest) backup copy was created for this backup item.
        """
        return pulumi.get(self, "last_recovery_point")

    @property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> Optional[str]:
        """
        ID of the backup policy with which this item is backed up.
        """
        return pulumi.get(self, "policy_id")

    @property
    @pulumi.getter(name="protectedItemDataId")
    def protected_item_data_id(self) -> Optional[str]:
        """
        Data ID of the protected item.
        """
        return pulumi.get(self, "protected_item_data_id")

    @property
    @pulumi.getter(name="protectedItemType")
    def protected_item_type(self) -> Optional[str]:
        """
        backup item type.
        Expected value is 'Microsoft.Compute/virtualMachines'.
        """
        return pulumi.get(self, "protected_item_type")

    @property
    @pulumi.getter(name="protectionState")
    def protection_state(self) -> Optional[str]:
        """
        Backup state of this backup item.
        """
        return pulumi.get(self, "protection_state")

    @property
    @pulumi.getter(name="protectionStatus")
    def protection_status(self) -> Optional[str]:
        """
        Backup status of this backup item.
        """
        return pulumi.get(self, "protection_status")

    @property
    @pulumi.getter(name="sourceResourceId")
    def source_resource_id(self) -> Optional[str]:
        """
        ARM ID of the resource to be backed up.
        """
        return pulumi.get(self, "source_resource_id")

    @property
    @pulumi.getter(name="virtualMachineId")
    def virtual_machine_id(self) -> Optional[str]:
        """
        Fully qualified ARM ID of the virtual machine represented by this item.
        """
        return pulumi.get(self, "virtual_machine_id")

    @property
    @pulumi.getter(name="workloadType")
    def workload_type(self) -> Optional[str]:
        """
        Type of workload this item represents.
        """
        return pulumi.get(self, "workload_type")


@pulumi.output_type
class AzureIaaSVMHealthDetailsResponse(dict):
    """
    Azure IaaS VM workload-specific Health Details.
    """
    def __init__(__self__, *,
                 code: int,
                 message: str,
                 recommendations: Sequence[str],
                 title: str):
        """
        Azure IaaS VM workload-specific Health Details.
        :param int code: Health Code
        :param str message: Health Message
        :param Sequence[str] recommendations: Health Recommended Actions
        :param str title: Health Title
        """
        pulumi.set(__self__, "code", code)
        pulumi.set(__self__, "message", message)
        pulumi.set(__self__, "recommendations", recommendations)
        pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter
    def code(self) -> int:
        """
        Health Code
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter
    def message(self) -> str:
        """
        Health Message
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def recommendations(self) -> Sequence[str]:
        """
        Health Recommended Actions
        """
        return pulumi.get(self, "recommendations")

    @property
    @pulumi.getter
    def title(self) -> str:
        """
        Health Title
        """
        return pulumi.get(self, "title")


@pulumi.output_type
class AzureIaaSVMProtectedItemExtendedInfoResponse(dict):
    """
    Additional information on Azure IaaS VM specific backup item.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "oldestRecoveryPoint":
            suggest = "oldest_recovery_point"
        elif key == "policyInconsistent":
            suggest = "policy_inconsistent"
        elif key == "recoveryPointCount":
            suggest = "recovery_point_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureIaaSVMProtectedItemExtendedInfoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureIaaSVMProtectedItemExtendedInfoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureIaaSVMProtectedItemExtendedInfoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 oldest_recovery_point: Optional[str] = None,
                 policy_inconsistent: Optional[bool] = None,
                 recovery_point_count: Optional[int] = None):
        """
        Additional information on Azure IaaS VM specific backup item.
        :param str oldest_recovery_point: The oldest backup copy available for this backup item.
        :param bool policy_inconsistent: Specifies if backup policy associated with the backup item is inconsistent.
        :param int recovery_point_count: Number of backup copies available for this backup item.
        """
        if oldest_recovery_point is not None:
            pulumi.set(__self__, "oldest_recovery_point", oldest_recovery_point)
        if policy_inconsistent is not None:
            pulumi.set(__self__, "policy_inconsistent", policy_inconsistent)
        if recovery_point_count is not None:
            pulumi.set(__self__, "recovery_point_count", recovery_point_count)

    @property
    @pulumi.getter(name="oldestRecoveryPoint")
    def oldest_recovery_point(self) -> Optional[str]:
        """
        The oldest backup copy available for this backup item.
        """
        return pulumi.get(self, "oldest_recovery_point")

    @property
    @pulumi.getter(name="policyInconsistent")
    def policy_inconsistent(self) -> Optional[bool]:
        """
        Specifies if backup policy associated with the backup item is inconsistent.
        """
        return pulumi.get(self, "policy_inconsistent")

    @property
    @pulumi.getter(name="recoveryPointCount")
    def recovery_point_count(self) -> Optional[int]:
        """
        Number of backup copies available for this backup item.
        """
        return pulumi.get(self, "recovery_point_count")


@pulumi.output_type
class AzureIaaSVMProtectedItemResponse(dict):
    """
    IaaS VM workload-specific backup item.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backupManagementType":
            suggest = "backup_management_type"
        elif key == "backupSetName":
            suggest = "backup_set_name"
        elif key == "containerName":
            suggest = "container_name"
        elif key == "createMode":
            suggest = "create_mode"
        elif key == "deferredDeleteTimeInUTC":
            suggest = "deferred_delete_time_in_utc"
        elif key == "deferredDeleteTimeRemaining":
            suggest = "deferred_delete_time_remaining"
        elif key == "extendedInfo":
            suggest = "extended_info"
        elif key == "extendedProperties":
            suggest = "extended_properties"
        elif key == "friendlyName":
            suggest = "friendly_name"
        elif key == "healthDetails":
            suggest = "health_details"
        elif key == "healthStatus":
            suggest = "health_status"
        elif key == "isDeferredDeleteScheduleUpcoming":
            suggest = "is_deferred_delete_schedule_upcoming"
        elif key == "isRehydrate":
            suggest = "is_rehydrate"
        elif key == "isScheduledForDeferredDelete":
            suggest = "is_scheduled_for_deferred_delete"
        elif key == "lastBackupStatus":
            suggest = "last_backup_status"
        elif key == "lastBackupTime":
            suggest = "last_backup_time"
        elif key == "lastRecoveryPoint":
            suggest = "last_recovery_point"
        elif key == "policyId":
            suggest = "policy_id"
        elif key == "protectedItemDataId":
            suggest = "protected_item_data_id"
        elif key == "protectedItemType":
            suggest = "protected_item_type"
        elif key == "protectionState":
            suggest = "protection_state"
        elif key == "protectionStatus":
            suggest = "protection_status"
        elif key == "sourceResourceId":
            suggest = "source_resource_id"
        elif key == "virtualMachineId":
            suggest = "virtual_machine_id"
        elif key == "workloadType":
            suggest = "workload_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureIaaSVMProtectedItemResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureIaaSVMProtectedItemResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureIaaSVMProtectedItemResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backup_management_type: Optional[str] = None,
                 backup_set_name: Optional[str] = None,
                 container_name: Optional[str] = None,
                 create_mode: Optional[str] = None,
                 deferred_delete_time_in_utc: Optional[str] = None,
                 deferred_delete_time_remaining: Optional[str] = None,
                 extended_info: Optional['outputs.AzureIaaSVMProtectedItemExtendedInfoResponse'] = None,
                 extended_properties: Optional['outputs.ExtendedPropertiesResponse'] = None,
                 friendly_name: Optional[str] = None,
                 health_details: Optional[Sequence['outputs.AzureIaaSVMHealthDetailsResponse']] = None,
                 health_status: Optional[str] = None,
                 is_deferred_delete_schedule_upcoming: Optional[bool] = None,
                 is_rehydrate: Optional[bool] = None,
                 is_scheduled_for_deferred_delete: Optional[bool] = None,
                 last_backup_status: Optional[str] = None,
                 last_backup_time: Optional[str] = None,
                 last_recovery_point: Optional[str] = None,
                 policy_id: Optional[str] = None,
                 protected_item_data_id: Optional[str] = None,
                 protected_item_type: Optional[str] = None,
                 protection_state: Optional[str] = None,
                 protection_status: Optional[str] = None,
                 source_resource_id: Optional[str] = None,
                 virtual_machine_id: Optional[str] = None,
                 workload_type: Optional[str] = None):
        """
        IaaS VM workload-specific backup item.
        :param str backup_management_type: Type of backup management for the backed up item.
        :param str backup_set_name: Name of the backup set the backup item belongs to
        :param str container_name: Unique name of container
        :param str create_mode: Create mode to indicate recovery of existing soft deleted data source or creation of new data source.
        :param str deferred_delete_time_in_utc: Time for deferred deletion in UTC
        :param str deferred_delete_time_remaining: Time remaining before the DS marked for deferred delete is permanently deleted
        :param 'AzureIaaSVMProtectedItemExtendedInfoResponse' extended_info: Additional information for this backup item.
        :param 'ExtendedPropertiesResponse' extended_properties: Extended Properties for Azure IaasVM Backup.
        :param str friendly_name: Friendly name of the VM represented by this backup item.
        :param Sequence['AzureIaaSVMHealthDetailsResponse'] health_details: Health details on this backup item.
        :param str health_status: Health status of protected item
        :param bool is_deferred_delete_schedule_upcoming: Flag to identify whether the deferred deleted DS is to be purged soon
        :param bool is_rehydrate: Flag to identify that deferred deleted DS is to be moved into Pause state
        :param bool is_scheduled_for_deferred_delete: Flag to identify whether the DS is scheduled for deferred delete
        :param str last_backup_status: Last backup operation status.
        :param str last_backup_time: Timestamp of the last backup operation on this backup item.
        :param str last_recovery_point: Timestamp when the last (latest) backup copy was created for this backup item.
        :param str policy_id: ID of the backup policy with which this item is backed up.
        :param str protected_item_data_id: Data ID of the protected item.
        :param str protected_item_type: backup item type.
               Expected value is 'AzureIaaSVMProtectedItem'.
        :param str protection_state: Backup state of this backup item.
        :param str protection_status: Backup status of this backup item.
        :param str source_resource_id: ARM ID of the resource to be backed up.
        :param str virtual_machine_id: Fully qualified ARM ID of the virtual machine represented by this item.
        :param str workload_type: Type of workload this item represents.
        """
        if backup_management_type is not None:
            pulumi.set(__self__, "backup_management_type", backup_management_type)
        if backup_set_name is not None:
            pulumi.set(__self__, "backup_set_name", backup_set_name)
        if container_name is not None:
            pulumi.set(__self__, "container_name", container_name)
        if create_mode is not None:
            pulumi.set(__self__, "create_mode", create_mode)
        if deferred_delete_time_in_utc is not None:
            pulumi.set(__self__, "deferred_delete_time_in_utc", deferred_delete_time_in_utc)
        if deferred_delete_time_remaining is not None:
            pulumi.set(__self__, "deferred_delete_time_remaining", deferred_delete_time_remaining)
        if extended_info is not None:
            pulumi.set(__self__, "extended_info", extended_info)
        if extended_properties is not None:
            pulumi.set(__self__, "extended_properties", extended_properties)
        if friendly_name is not None:
            pulumi.set(__self__, "friendly_name", friendly_name)
        if health_details is not None:
            pulumi.set(__self__, "health_details", health_details)
        if health_status is not None:
            pulumi.set(__self__, "health_status", health_status)
        if is_deferred_delete_schedule_upcoming is not None:
            pulumi.set(__self__, "is_deferred_delete_schedule_upcoming", is_deferred_delete_schedule_upcoming)
        if is_rehydrate is not None:
            pulumi.set(__self__, "is_rehydrate", is_rehydrate)
        if is_scheduled_for_deferred_delete is not None:
            pulumi.set(__self__, "is_scheduled_for_deferred_delete", is_scheduled_for_deferred_delete)
        if last_backup_status is not None:
            pulumi.set(__self__, "last_backup_status", last_backup_status)
        if last_backup_time is not None:
            pulumi.set(__self__, "last_backup_time", last_backup_time)
        if last_recovery_point is not None:
            pulumi.set(__self__, "last_recovery_point", last_recovery_point)
        if policy_id is not None:
            pulumi.set(__self__, "policy_id", policy_id)
        if protected_item_data_id is not None:
            pulumi.set(__self__, "protected_item_data_id", protected_item_data_id)
        if protected_item_type is not None:
            pulumi.set(__self__, "protected_item_type", 'AzureIaaSVMProtectedItem')
        if protection_state is not None:
            pulumi.set(__self__, "protection_state", protection_state)
        if protection_status is not None:
            pulumi.set(__self__, "protection_status", protection_status)
        if source_resource_id is not None:
            pulumi.set(__self__, "source_resource_id", source_resource_id)
        if virtual_machine_id is not None:
            pulumi.set(__self__, "virtual_machine_id", virtual_machine_id)
        if workload_type is not None:
            pulumi.set(__self__, "workload_type", workload_type)

    @property
    @pulumi.getter(name="backupManagementType")
    def backup_management_type(self) -> Optional[str]:
        """
        Type of backup management for the backed up item.
        """
        return pulumi.get(self, "backup_management_type")

    @property
    @pulumi.getter(name="backupSetName")
    def backup_set_name(self) -> Optional[str]:
        """
        Name of the backup set the backup item belongs to
        """
        return pulumi.get(self, "backup_set_name")

    @property
    @pulumi.getter(name="containerName")
    def container_name(self) -> Optional[str]:
        """
        Unique name of container
        """
        return pulumi.get(self, "container_name")

    @property
    @pulumi.getter(name="createMode")
    def create_mode(self) -> Optional[str]:
        """
        Create mode to indicate recovery of existing soft deleted data source or creation of new data source.
        """
        return pulumi.get(self, "create_mode")

    @property
    @pulumi.getter(name="deferredDeleteTimeInUTC")
    def deferred_delete_time_in_utc(self) -> Optional[str]:
        """
        Time for deferred deletion in UTC
        """
        return pulumi.get(self, "deferred_delete_time_in_utc")

    @property
    @pulumi.getter(name="deferredDeleteTimeRemaining")
    def deferred_delete_time_remaining(self) -> Optional[str]:
        """
        Time remaining before the DS marked for deferred delete is permanently deleted
        """
        return pulumi.get(self, "deferred_delete_time_remaining")

    @property
    @pulumi.getter(name="extendedInfo")
    def extended_info(self) -> Optional['outputs.AzureIaaSVMProtectedItemExtendedInfoResponse']:
        """
        Additional information for this backup item.
        """
        return pulumi.get(self, "extended_info")

    @property
    @pulumi.getter(name="extendedProperties")
    def extended_properties(self) -> Optional['outputs.ExtendedPropertiesResponse']:
        """
        Extended Properties for Azure IaasVM Backup.
        """
        return pulumi.get(self, "extended_properties")

    @property
    @pulumi.getter(name="friendlyName")
    def friendly_name(self) -> Optional[str]:
        """
        Friendly name of the VM represented by this backup item.
        """
        return pulumi.get(self, "friendly_name")

    @property
    @pulumi.getter(name="healthDetails")
    def health_details(self) -> Optional[Sequence['outputs.AzureIaaSVMHealthDetailsResponse']]:
        """
        Health details on this backup item.
        """
        return pulumi.get(self, "health_details")

    @property
    @pulumi.getter(name="healthStatus")
    def health_status(self) -> Optional[str]:
        """
        Health status of protected item
        """
        return pulumi.get(self, "health_status")

    @property
    @pulumi.getter(name="isDeferredDeleteScheduleUpcoming")
    def is_deferred_delete_schedule_upcoming(self) -> Optional[bool]:
        """
        Flag to identify whether the deferred deleted DS is to be purged soon
        """
        return pulumi.get(self, "is_deferred_delete_schedule_upcoming")

    @property
    @pulumi.getter(name="isRehydrate")
    def is_rehydrate(self) -> Optional[bool]:
        """
        Flag to identify that deferred deleted DS is to be moved into Pause state
        """
        return pulumi.get(self, "is_rehydrate")

    @property
    @pulumi.getter(name="isScheduledForDeferredDelete")
    def is_scheduled_for_deferred_delete(self) -> Optional[bool]:
        """
        Flag to identify whether the DS is scheduled for deferred delete
        """
        return pulumi.get(self, "is_scheduled_for_deferred_delete")

    @property
    @pulumi.getter(name="lastBackupStatus")
    def last_backup_status(self) -> Optional[str]:
        """
        Last backup operation status.
        """
        return pulumi.get(self, "last_backup_status")

    @property
    @pulumi.getter(name="lastBackupTime")
    def last_backup_time(self) -> Optional[str]:
        """
        Timestamp of the last backup operation on this backup item.
        """
        return pulumi.get(self, "last_backup_time")

    @property
    @pulumi.getter(name="lastRecoveryPoint")
    def last_recovery_point(self) -> Optional[str]:
        """
        Timestamp when the last (latest) backup copy was created for this backup item.
        """
        return pulumi.get(self, "last_recovery_point")

    @property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> Optional[str]:
        """
        ID of the backup policy with which this item is backed up.
        """
        return pulumi.get(self, "policy_id")

    @property
    @pulumi.getter(name="protectedItemDataId")
    def protected_item_data_id(self) -> Optional[str]:
        """
        Data ID of the protected item.
        """
        return pulumi.get(self, "protected_item_data_id")

    @property
    @pulumi.getter(name="protectedItemType")
    def protected_item_type(self) -> Optional[str]:
        """
        backup item type.
        Expected value is 'AzureIaaSVMProtectedItem'.
        """
        return pulumi.get(self, "protected_item_type")

    @property
    @pulumi.getter(name="protectionState")
    def protection_state(self) -> Optional[str]:
        """
        Backup state of this backup item.
        """
        return pulumi.get(self, "protection_state")

    @property
    @pulumi.getter(name="protectionStatus")
    def protection_status(self) -> Optional[str]:
        """
        Backup status of this backup item.
        """
        return pulumi.get(self, "protection_status")

    @property
    @pulumi.getter(name="sourceResourceId")
    def source_resource_id(self) -> Optional[str]:
        """
        ARM ID of the resource to be backed up.
        """
        return pulumi.get(self, "source_resource_id")

    @property
    @pulumi.getter(name="virtualMachineId")
    def virtual_machine_id(self) -> Optional[str]:
        """
        Fully qualified ARM ID of the virtual machine represented by this item.
        """
        return pulumi.get(self, "virtual_machine_id")

    @property
    @pulumi.getter(name="workloadType")
    def workload_type(self) -> Optional[str]:
        """
        Type of workload this item represents.
        """
        return pulumi.get(self, "workload_type")


@pulumi.output_type
class AzureSqlProtectedItemExtendedInfoResponse(dict):
    """
    Additional information on Azure Sql specific protected item.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "oldestRecoveryPoint":
            suggest = "oldest_recovery_point"
        elif key == "policyState":
            suggest = "policy_state"
        elif key == "recoveryPointCount":
            suggest = "recovery_point_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureSqlProtectedItemExtendedInfoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureSqlProtectedItemExtendedInfoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureSqlProtectedItemExtendedInfoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 oldest_recovery_point: Optional[str] = None,
                 policy_state: Optional[str] = None,
                 recovery_point_count: Optional[int] = None):
        """
        Additional information on Azure Sql specific protected item.
        :param str oldest_recovery_point: The oldest backup copy available for this item in the service.
        :param str policy_state: State of the backup policy associated with this backup item.
        :param int recovery_point_count: Number of available backup copies associated with this backup item.
        """
        if oldest_recovery_point is not None:
            pulumi.set(__self__, "oldest_recovery_point", oldest_recovery_point)
        if policy_state is not None:
            pulumi.set(__self__, "policy_state", policy_state)
        if recovery_point_count is not None:
            pulumi.set(__self__, "recovery_point_count", recovery_point_count)

    @property
    @pulumi.getter(name="oldestRecoveryPoint")
    def oldest_recovery_point(self) -> Optional[str]:
        """
        The oldest backup copy available for this item in the service.
        """
        return pulumi.get(self, "oldest_recovery_point")

    @property
    @pulumi.getter(name="policyState")
    def policy_state(self) -> Optional[str]:
        """
        State of the backup policy associated with this backup item.
        """
        return pulumi.get(self, "policy_state")

    @property
    @pulumi.getter(name="recoveryPointCount")
    def recovery_point_count(self) -> Optional[int]:
        """
        Number of available backup copies associated with this backup item.
        """
        return pulumi.get(self, "recovery_point_count")


@pulumi.output_type
class AzureSqlProtectedItemResponse(dict):
    """
    Azure SQL workload-specific backup item.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backupManagementType":
            suggest = "backup_management_type"
        elif key == "backupSetName":
            suggest = "backup_set_name"
        elif key == "containerName":
            suggest = "container_name"
        elif key == "createMode":
            suggest = "create_mode"
        elif key == "deferredDeleteTimeInUTC":
            suggest = "deferred_delete_time_in_utc"
        elif key == "deferredDeleteTimeRemaining":
            suggest = "deferred_delete_time_remaining"
        elif key == "extendedInfo":
            suggest = "extended_info"
        elif key == "isDeferredDeleteScheduleUpcoming":
            suggest = "is_deferred_delete_schedule_upcoming"
        elif key == "isRehydrate":
            suggest = "is_rehydrate"
        elif key == "isScheduledForDeferredDelete":
            suggest = "is_scheduled_for_deferred_delete"
        elif key == "lastRecoveryPoint":
            suggest = "last_recovery_point"
        elif key == "policyId":
            suggest = "policy_id"
        elif key == "protectedItemDataId":
            suggest = "protected_item_data_id"
        elif key == "protectedItemType":
            suggest = "protected_item_type"
        elif key == "protectionState":
            suggest = "protection_state"
        elif key == "sourceResourceId":
            suggest = "source_resource_id"
        elif key == "workloadType":
            suggest = "workload_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureSqlProtectedItemResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureSqlProtectedItemResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureSqlProtectedItemResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backup_management_type: Optional[str] = None,
                 backup_set_name: Optional[str] = None,
                 container_name: Optional[str] = None,
                 create_mode: Optional[str] = None,
                 deferred_delete_time_in_utc: Optional[str] = None,
                 deferred_delete_time_remaining: Optional[str] = None,
                 extended_info: Optional['outputs.AzureSqlProtectedItemExtendedInfoResponse'] = None,
                 is_deferred_delete_schedule_upcoming: Optional[bool] = None,
                 is_rehydrate: Optional[bool] = None,
                 is_scheduled_for_deferred_delete: Optional[bool] = None,
                 last_recovery_point: Optional[str] = None,
                 policy_id: Optional[str] = None,
                 protected_item_data_id: Optional[str] = None,
                 protected_item_type: Optional[str] = None,
                 protection_state: Optional[str] = None,
                 source_resource_id: Optional[str] = None,
                 workload_type: Optional[str] = None):
        """
        Azure SQL workload-specific backup item.
        :param str backup_management_type: Type of backup management for the backed up item.
        :param str backup_set_name: Name of the backup set the backup item belongs to
        :param str container_name: Unique name of container
        :param str create_mode: Create mode to indicate recovery of existing soft deleted data source or creation of new data source.
        :param str deferred_delete_time_in_utc: Time for deferred deletion in UTC
        :param str deferred_delete_time_remaining: Time remaining before the DS marked for deferred delete is permanently deleted
        :param 'AzureSqlProtectedItemExtendedInfoResponse' extended_info: Additional information for this backup item.
        :param bool is_deferred_delete_schedule_upcoming: Flag to identify whether the deferred deleted DS is to be purged soon
        :param bool is_rehydrate: Flag to identify that deferred deleted DS is to be moved into Pause state
        :param bool is_scheduled_for_deferred_delete: Flag to identify whether the DS is scheduled for deferred delete
        :param str last_recovery_point: Timestamp when the last (latest) backup copy was created for this backup item.
        :param str policy_id: ID of the backup policy with which this item is backed up.
        :param str protected_item_data_id: Internal ID of a backup item. Used by Azure SQL Backup engine to contact Recovery Services.
        :param str protected_item_type: backup item type.
               Expected value is 'Microsoft.Sql/servers/databases'.
        :param str protection_state: Backup state of the backed up item.
        :param str source_resource_id: ARM ID of the resource to be backed up.
        :param str workload_type: Type of workload this item represents.
        """
        if backup_management_type is not None:
            pulumi.set(__self__, "backup_management_type", backup_management_type)
        if backup_set_name is not None:
            pulumi.set(__self__, "backup_set_name", backup_set_name)
        if container_name is not None:
            pulumi.set(__self__, "container_name", container_name)
        if create_mode is not None:
            pulumi.set(__self__, "create_mode", create_mode)
        if deferred_delete_time_in_utc is not None:
            pulumi.set(__self__, "deferred_delete_time_in_utc", deferred_delete_time_in_utc)
        if deferred_delete_time_remaining is not None:
            pulumi.set(__self__, "deferred_delete_time_remaining", deferred_delete_time_remaining)
        if extended_info is not None:
            pulumi.set(__self__, "extended_info", extended_info)
        if is_deferred_delete_schedule_upcoming is not None:
            pulumi.set(__self__, "is_deferred_delete_schedule_upcoming", is_deferred_delete_schedule_upcoming)
        if is_rehydrate is not None:
            pulumi.set(__self__, "is_rehydrate", is_rehydrate)
        if is_scheduled_for_deferred_delete is not None:
            pulumi.set(__self__, "is_scheduled_for_deferred_delete", is_scheduled_for_deferred_delete)
        if last_recovery_point is not None:
            pulumi.set(__self__, "last_recovery_point", last_recovery_point)
        if policy_id is not None:
            pulumi.set(__self__, "policy_id", policy_id)
        if protected_item_data_id is not None:
            pulumi.set(__self__, "protected_item_data_id", protected_item_data_id)
        if protected_item_type is not None:
            pulumi.set(__self__, "protected_item_type", 'Microsoft.Sql/servers/databases')
        if protection_state is not None:
            pulumi.set(__self__, "protection_state", protection_state)
        if source_resource_id is not None:
            pulumi.set(__self__, "source_resource_id", source_resource_id)
        if workload_type is not None:
            pulumi.set(__self__, "workload_type", workload_type)

    @property
    @pulumi.getter(name="backupManagementType")
    def backup_management_type(self) -> Optional[str]:
        """
        Type of backup management for the backed up item.
        """
        return pulumi.get(self, "backup_management_type")

    @property
    @pulumi.getter(name="backupSetName")
    def backup_set_name(self) -> Optional[str]:
        """
        Name of the backup set the backup item belongs to
        """
        return pulumi.get(self, "backup_set_name")

    @property
    @pulumi.getter(name="containerName")
    def container_name(self) -> Optional[str]:
        """
        Unique name of container
        """
        return pulumi.get(self, "container_name")

    @property
    @pulumi.getter(name="createMode")
    def create_mode(self) -> Optional[str]:
        """
        Create mode to indicate recovery of existing soft deleted data source or creation of new data source.
        """
        return pulumi.get(self, "create_mode")

    @property
    @pulumi.getter(name="deferredDeleteTimeInUTC")
    def deferred_delete_time_in_utc(self) -> Optional[str]:
        """
        Time for deferred deletion in UTC
        """
        return pulumi.get(self, "deferred_delete_time_in_utc")

    @property
    @pulumi.getter(name="deferredDeleteTimeRemaining")
    def deferred_delete_time_remaining(self) -> Optional[str]:
        """
        Time remaining before the DS marked for deferred delete is permanently deleted
        """
        return pulumi.get(self, "deferred_delete_time_remaining")

    @property
    @pulumi.getter(name="extendedInfo")
    def extended_info(self) -> Optional['outputs.AzureSqlProtectedItemExtendedInfoResponse']:
        """
        Additional information for this backup item.
        """
        return pulumi.get(self, "extended_info")

    @property
    @pulumi.getter(name="isDeferredDeleteScheduleUpcoming")
    def is_deferred_delete_schedule_upcoming(self) -> Optional[bool]:
        """
        Flag to identify whether the deferred deleted DS is to be purged soon
        """
        return pulumi.get(self, "is_deferred_delete_schedule_upcoming")

    @property
    @pulumi.getter(name="isRehydrate")
    def is_rehydrate(self) -> Optional[bool]:
        """
        Flag to identify that deferred deleted DS is to be moved into Pause state
        """
        return pulumi.get(self, "is_rehydrate")

    @property
    @pulumi.getter(name="isScheduledForDeferredDelete")
    def is_scheduled_for_deferred_delete(self) -> Optional[bool]:
        """
        Flag to identify whether the DS is scheduled for deferred delete
        """
        return pulumi.get(self, "is_scheduled_for_deferred_delete")

    @property
    @pulumi.getter(name="lastRecoveryPoint")
    def last_recovery_point(self) -> Optional[str]:
        """
        Timestamp when the last (latest) backup copy was created for this backup item.
        """
        return pulumi.get(self, "last_recovery_point")

    @property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> Optional[str]:
        """
        ID of the backup policy with which this item is backed up.
        """
        return pulumi.get(self, "policy_id")

    @property
    @pulumi.getter(name="protectedItemDataId")
    def protected_item_data_id(self) -> Optional[str]:
        """
        Internal ID of a backup item. Used by Azure SQL Backup engine to contact Recovery Services.
        """
        return pulumi.get(self, "protected_item_data_id")

    @property
    @pulumi.getter(name="protectedItemType")
    def protected_item_type(self) -> Optional[str]:
        """
        backup item type.
        Expected value is 'Microsoft.Sql/servers/databases'.
        """
        return pulumi.get(self, "protected_item_type")

    @property
    @pulumi.getter(name="protectionState")
    def protection_state(self) -> Optional[str]:
        """
        Backup state of the backed up item.
        """
        return pulumi.get(self, "protection_state")

    @property
    @pulumi.getter(name="sourceResourceId")
    def source_resource_id(self) -> Optional[str]:
        """
        ARM ID of the resource to be backed up.
        """
        return pulumi.get(self, "source_resource_id")

    @property
    @pulumi.getter(name="workloadType")
    def workload_type(self) -> Optional[str]:
        """
        Type of workload this item represents.
        """
        return pulumi.get(self, "workload_type")


@pulumi.output_type
class AzureVmWorkloadProtectedItemExtendedInfoResponse(dict):
    """
    Additional information on Azure Workload for SQL specific backup item.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "oldestRecoveryPoint":
            suggest = "oldest_recovery_point"
        elif key == "policyState":
            suggest = "policy_state"
        elif key == "recoveryPointCount":
            suggest = "recovery_point_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureVmWorkloadProtectedItemExtendedInfoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureVmWorkloadProtectedItemExtendedInfoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureVmWorkloadProtectedItemExtendedInfoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 oldest_recovery_point: Optional[str] = None,
                 policy_state: Optional[str] = None,
                 recovery_point_count: Optional[int] = None):
        """
        Additional information on Azure Workload for SQL specific backup item.
        :param str oldest_recovery_point: The oldest backup copy available for this backup item.
        :param str policy_state: Indicates consistency of policy object and policy applied to this backup item.
        :param int recovery_point_count: Number of backup copies available for this backup item.
        """
        if oldest_recovery_point is not None:
            pulumi.set(__self__, "oldest_recovery_point", oldest_recovery_point)
        if policy_state is not None:
            pulumi.set(__self__, "policy_state", policy_state)
        if recovery_point_count is not None:
            pulumi.set(__self__, "recovery_point_count", recovery_point_count)

    @property
    @pulumi.getter(name="oldestRecoveryPoint")
    def oldest_recovery_point(self) -> Optional[str]:
        """
        The oldest backup copy available for this backup item.
        """
        return pulumi.get(self, "oldest_recovery_point")

    @property
    @pulumi.getter(name="policyState")
    def policy_state(self) -> Optional[str]:
        """
        Indicates consistency of policy object and policy applied to this backup item.
        """
        return pulumi.get(self, "policy_state")

    @property
    @pulumi.getter(name="recoveryPointCount")
    def recovery_point_count(self) -> Optional[int]:
        """
        Number of backup copies available for this backup item.
        """
        return pulumi.get(self, "recovery_point_count")


@pulumi.output_type
class AzureVmWorkloadProtectedItemResponse(dict):
    """
    Azure VM workload-specific protected item.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backupManagementType":
            suggest = "backup_management_type"
        elif key == "backupSetName":
            suggest = "backup_set_name"
        elif key == "containerName":
            suggest = "container_name"
        elif key == "createMode":
            suggest = "create_mode"
        elif key == "deferredDeleteTimeInUTC":
            suggest = "deferred_delete_time_in_utc"
        elif key == "deferredDeleteTimeRemaining":
            suggest = "deferred_delete_time_remaining"
        elif key == "extendedInfo":
            suggest = "extended_info"
        elif key == "friendlyName":
            suggest = "friendly_name"
        elif key == "isDeferredDeleteScheduleUpcoming":
            suggest = "is_deferred_delete_schedule_upcoming"
        elif key == "isRehydrate":
            suggest = "is_rehydrate"
        elif key == "isScheduledForDeferredDelete":
            suggest = "is_scheduled_for_deferred_delete"
        elif key == "lastBackupErrorDetail":
            suggest = "last_backup_error_detail"
        elif key == "lastBackupStatus":
            suggest = "last_backup_status"
        elif key == "lastBackupTime":
            suggest = "last_backup_time"
        elif key == "lastRecoveryPoint":
            suggest = "last_recovery_point"
        elif key == "parentName":
            suggest = "parent_name"
        elif key == "parentType":
            suggest = "parent_type"
        elif key == "policyId":
            suggest = "policy_id"
        elif key == "protectedItemDataSourceId":
            suggest = "protected_item_data_source_id"
        elif key == "protectedItemHealthStatus":
            suggest = "protected_item_health_status"
        elif key == "protectedItemType":
            suggest = "protected_item_type"
        elif key == "protectionState":
            suggest = "protection_state"
        elif key == "protectionStatus":
            suggest = "protection_status"
        elif key == "serverName":
            suggest = "server_name"
        elif key == "sourceResourceId":
            suggest = "source_resource_id"
        elif key == "workloadType":
            suggest = "workload_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureVmWorkloadProtectedItemResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureVmWorkloadProtectedItemResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureVmWorkloadProtectedItemResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backup_management_type: Optional[str] = None,
                 backup_set_name: Optional[str] = None,
                 container_name: Optional[str] = None,
                 create_mode: Optional[str] = None,
                 deferred_delete_time_in_utc: Optional[str] = None,
                 deferred_delete_time_remaining: Optional[str] = None,
                 extended_info: Optional['outputs.AzureVmWorkloadProtectedItemExtendedInfoResponse'] = None,
                 friendly_name: Optional[str] = None,
                 is_deferred_delete_schedule_upcoming: Optional[bool] = None,
                 is_rehydrate: Optional[bool] = None,
                 is_scheduled_for_deferred_delete: Optional[bool] = None,
                 last_backup_error_detail: Optional['outputs.ErrorDetailResponse'] = None,
                 last_backup_status: Optional[str] = None,
                 last_backup_time: Optional[str] = None,
                 last_recovery_point: Optional[str] = None,
                 parent_name: Optional[str] = None,
                 parent_type: Optional[str] = None,
                 policy_id: Optional[str] = None,
                 protected_item_data_source_id: Optional[str] = None,
                 protected_item_health_status: Optional[str] = None,
                 protected_item_type: Optional[str] = None,
                 protection_state: Optional[str] = None,
                 protection_status: Optional[str] = None,
                 server_name: Optional[str] = None,
                 source_resource_id: Optional[str] = None,
                 workload_type: Optional[str] = None):
        """
        Azure VM workload-specific protected item.
        :param str backup_management_type: Type of backup management for the backed up item.
        :param str backup_set_name: Name of the backup set the backup item belongs to
        :param str container_name: Unique name of container
        :param str create_mode: Create mode to indicate recovery of existing soft deleted data source or creation of new data source.
        :param str deferred_delete_time_in_utc: Time for deferred deletion in UTC
        :param str deferred_delete_time_remaining: Time remaining before the DS marked for deferred delete is permanently deleted
        :param 'AzureVmWorkloadProtectedItemExtendedInfoResponse' extended_info: Additional information for this backup item.
        :param str friendly_name: Friendly name of the DB represented by this backup item.
        :param bool is_deferred_delete_schedule_upcoming: Flag to identify whether the deferred deleted DS is to be purged soon
        :param bool is_rehydrate: Flag to identify that deferred deleted DS is to be moved into Pause state
        :param bool is_scheduled_for_deferred_delete: Flag to identify whether the DS is scheduled for deferred delete
        :param 'ErrorDetailResponse' last_backup_error_detail: Error details in last backup
        :param str last_backup_status: Last backup operation status. Possible values: Healthy, Unhealthy.
        :param str last_backup_time: Timestamp of the last backup operation on this backup item.
        :param str last_recovery_point: Timestamp when the last (latest) backup copy was created for this backup item.
        :param str parent_name: Parent name of the DB such as Instance or Availability Group.
        :param str parent_type: Parent type of protected item, example: for a DB, standalone server or distributed
        :param str policy_id: ID of the backup policy with which this item is backed up.
        :param str protected_item_data_source_id: Data ID of the protected item.
        :param str protected_item_health_status: Health status of the backup item, evaluated based on last heartbeat received
        :param str protected_item_type: backup item type.
               Expected value is 'AzureVmWorkloadProtectedItem'.
        :param str protection_state: Backup state of this backup item.
        :param str protection_status: Backup status of this backup item.
        :param str server_name: Host/Cluster Name for instance or AG
        :param str source_resource_id: ARM ID of the resource to be backed up.
        :param str workload_type: Type of workload this item represents.
        """
        if backup_management_type is not None:
            pulumi.set(__self__, "backup_management_type", backup_management_type)
        if backup_set_name is not None:
            pulumi.set(__self__, "backup_set_name", backup_set_name)
        if container_name is not None:
            pulumi.set(__self__, "container_name", container_name)
        if create_mode is not None:
            pulumi.set(__self__, "create_mode", create_mode)
        if deferred_delete_time_in_utc is not None:
            pulumi.set(__self__, "deferred_delete_time_in_utc", deferred_delete_time_in_utc)
        if deferred_delete_time_remaining is not None:
            pulumi.set(__self__, "deferred_delete_time_remaining", deferred_delete_time_remaining)
        if extended_info is not None:
            pulumi.set(__self__, "extended_info", extended_info)
        if friendly_name is not None:
            pulumi.set(__self__, "friendly_name", friendly_name)
        if is_deferred_delete_schedule_upcoming is not None:
            pulumi.set(__self__, "is_deferred_delete_schedule_upcoming", is_deferred_delete_schedule_upcoming)
        if is_rehydrate is not None:
            pulumi.set(__self__, "is_rehydrate", is_rehydrate)
        if is_scheduled_for_deferred_delete is not None:
            pulumi.set(__self__, "is_scheduled_for_deferred_delete", is_scheduled_for_deferred_delete)
        if last_backup_error_detail is not None:
            pulumi.set(__self__, "last_backup_error_detail", last_backup_error_detail)
        if last_backup_status is not None:
            pulumi.set(__self__, "last_backup_status", last_backup_status)
        if last_backup_time is not None:
            pulumi.set(__self__, "last_backup_time", last_backup_time)
        if last_recovery_point is not None:
            pulumi.set(__self__, "last_recovery_point", last_recovery_point)
        if parent_name is not None:
            pulumi.set(__self__, "parent_name", parent_name)
        if parent_type is not None:
            pulumi.set(__self__, "parent_type", parent_type)
        if policy_id is not None:
            pulumi.set(__self__, "policy_id", policy_id)
        if protected_item_data_source_id is not None:
            pulumi.set(__self__, "protected_item_data_source_id", protected_item_data_source_id)
        if protected_item_health_status is not None:
            pulumi.set(__self__, "protected_item_health_status", protected_item_health_status)
        if protected_item_type is not None:
            pulumi.set(__self__, "protected_item_type", 'AzureVmWorkloadProtectedItem')
        if protection_state is not None:
            pulumi.set(__self__, "protection_state", protection_state)
        if protection_status is not None:
            pulumi.set(__self__, "protection_status", protection_status)
        if server_name is not None:
            pulumi.set(__self__, "server_name", server_name)
        if source_resource_id is not None:
            pulumi.set(__self__, "source_resource_id", source_resource_id)
        if workload_type is not None:
            pulumi.set(__self__, "workload_type", workload_type)

    @property
    @pulumi.getter(name="backupManagementType")
    def backup_management_type(self) -> Optional[str]:
        """
        Type of backup management for the backed up item.
        """
        return pulumi.get(self, "backup_management_type")

    @property
    @pulumi.getter(name="backupSetName")
    def backup_set_name(self) -> Optional[str]:
        """
        Name of the backup set the backup item belongs to
        """
        return pulumi.get(self, "backup_set_name")

    @property
    @pulumi.getter(name="containerName")
    def container_name(self) -> Optional[str]:
        """
        Unique name of container
        """
        return pulumi.get(self, "container_name")

    @property
    @pulumi.getter(name="createMode")
    def create_mode(self) -> Optional[str]:
        """
        Create mode to indicate recovery of existing soft deleted data source or creation of new data source.
        """
        return pulumi.get(self, "create_mode")

    @property
    @pulumi.getter(name="deferredDeleteTimeInUTC")
    def deferred_delete_time_in_utc(self) -> Optional[str]:
        """
        Time for deferred deletion in UTC
        """
        return pulumi.get(self, "deferred_delete_time_in_utc")

    @property
    @pulumi.getter(name="deferredDeleteTimeRemaining")
    def deferred_delete_time_remaining(self) -> Optional[str]:
        """
        Time remaining before the DS marked for deferred delete is permanently deleted
        """
        return pulumi.get(self, "deferred_delete_time_remaining")

    @property
    @pulumi.getter(name="extendedInfo")
    def extended_info(self) -> Optional['outputs.AzureVmWorkloadProtectedItemExtendedInfoResponse']:
        """
        Additional information for this backup item.
        """
        return pulumi.get(self, "extended_info")

    @property
    @pulumi.getter(name="friendlyName")
    def friendly_name(self) -> Optional[str]:
        """
        Friendly name of the DB represented by this backup item.
        """
        return pulumi.get(self, "friendly_name")

    @property
    @pulumi.getter(name="isDeferredDeleteScheduleUpcoming")
    def is_deferred_delete_schedule_upcoming(self) -> Optional[bool]:
        """
        Flag to identify whether the deferred deleted DS is to be purged soon
        """
        return pulumi.get(self, "is_deferred_delete_schedule_upcoming")

    @property
    @pulumi.getter(name="isRehydrate")
    def is_rehydrate(self) -> Optional[bool]:
        """
        Flag to identify that deferred deleted DS is to be moved into Pause state
        """
        return pulumi.get(self, "is_rehydrate")

    @property
    @pulumi.getter(name="isScheduledForDeferredDelete")
    def is_scheduled_for_deferred_delete(self) -> Optional[bool]:
        """
        Flag to identify whether the DS is scheduled for deferred delete
        """
        return pulumi.get(self, "is_scheduled_for_deferred_delete")

    @property
    @pulumi.getter(name="lastBackupErrorDetail")
    def last_backup_error_detail(self) -> Optional['outputs.ErrorDetailResponse']:
        """
        Error details in last backup
        """
        return pulumi.get(self, "last_backup_error_detail")

    @property
    @pulumi.getter(name="lastBackupStatus")
    def last_backup_status(self) -> Optional[str]:
        """
        Last backup operation status. Possible values: Healthy, Unhealthy.
        """
        return pulumi.get(self, "last_backup_status")

    @property
    @pulumi.getter(name="lastBackupTime")
    def last_backup_time(self) -> Optional[str]:
        """
        Timestamp of the last backup operation on this backup item.
        """
        return pulumi.get(self, "last_backup_time")

    @property
    @pulumi.getter(name="lastRecoveryPoint")
    def last_recovery_point(self) -> Optional[str]:
        """
        Timestamp when the last (latest) backup copy was created for this backup item.
        """
        return pulumi.get(self, "last_recovery_point")

    @property
    @pulumi.getter(name="parentName")
    def parent_name(self) -> Optional[str]:
        """
        Parent name of the DB such as Instance or Availability Group.
        """
        return pulumi.get(self, "parent_name")

    @property
    @pulumi.getter(name="parentType")
    def parent_type(self) -> Optional[str]:
        """
        Parent type of protected item, example: for a DB, standalone server or distributed
        """
        return pulumi.get(self, "parent_type")

    @property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> Optional[str]:
        """
        ID of the backup policy with which this item is backed up.
        """
        return pulumi.get(self, "policy_id")

    @property
    @pulumi.getter(name="protectedItemDataSourceId")
    def protected_item_data_source_id(self) -> Optional[str]:
        """
        Data ID of the protected item.
        """
        return pulumi.get(self, "protected_item_data_source_id")

    @property
    @pulumi.getter(name="protectedItemHealthStatus")
    def protected_item_health_status(self) -> Optional[str]:
        """
        Health status of the backup item, evaluated based on last heartbeat received
        """
        return pulumi.get(self, "protected_item_health_status")

    @property
    @pulumi.getter(name="protectedItemType")
    def protected_item_type(self) -> Optional[str]:
        """
        backup item type.
        Expected value is 'AzureVmWorkloadProtectedItem'.
        """
        return pulumi.get(self, "protected_item_type")

    @property
    @pulumi.getter(name="protectionState")
    def protection_state(self) -> Optional[str]:
        """
        Backup state of this backup item.
        """
        return pulumi.get(self, "protection_state")

    @property
    @pulumi.getter(name="protectionStatus")
    def protection_status(self) -> Optional[str]:
        """
        Backup status of this backup item.
        """
        return pulumi.get(self, "protection_status")

    @property
    @pulumi.getter(name="serverName")
    def server_name(self) -> Optional[str]:
        """
        Host/Cluster Name for instance or AG
        """
        return pulumi.get(self, "server_name")

    @property
    @pulumi.getter(name="sourceResourceId")
    def source_resource_id(self) -> Optional[str]:
        """
        ARM ID of the resource to be backed up.
        """
        return pulumi.get(self, "source_resource_id")

    @property
    @pulumi.getter(name="workloadType")
    def workload_type(self) -> Optional[str]:
        """
        Type of workload this item represents.
        """
        return pulumi.get(self, "workload_type")


@pulumi.output_type
class AzureVmWorkloadSAPAseDatabaseProtectedItemResponse(dict):
    """
    Azure VM workload-specific protected item representing SAP ASE Database.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backupManagementType":
            suggest = "backup_management_type"
        elif key == "backupSetName":
            suggest = "backup_set_name"
        elif key == "containerName":
            suggest = "container_name"
        elif key == "createMode":
            suggest = "create_mode"
        elif key == "deferredDeleteTimeInUTC":
            suggest = "deferred_delete_time_in_utc"
        elif key == "deferredDeleteTimeRemaining":
            suggest = "deferred_delete_time_remaining"
        elif key == "extendedInfo":
            suggest = "extended_info"
        elif key == "friendlyName":
            suggest = "friendly_name"
        elif key == "isDeferredDeleteScheduleUpcoming":
            suggest = "is_deferred_delete_schedule_upcoming"
        elif key == "isRehydrate":
            suggest = "is_rehydrate"
        elif key == "isScheduledForDeferredDelete":
            suggest = "is_scheduled_for_deferred_delete"
        elif key == "lastBackupErrorDetail":
            suggest = "last_backup_error_detail"
        elif key == "lastBackupStatus":
            suggest = "last_backup_status"
        elif key == "lastBackupTime":
            suggest = "last_backup_time"
        elif key == "lastRecoveryPoint":
            suggest = "last_recovery_point"
        elif key == "parentName":
            suggest = "parent_name"
        elif key == "parentType":
            suggest = "parent_type"
        elif key == "policyId":
            suggest = "policy_id"
        elif key == "protectedItemDataSourceId":
            suggest = "protected_item_data_source_id"
        elif key == "protectedItemHealthStatus":
            suggest = "protected_item_health_status"
        elif key == "protectedItemType":
            suggest = "protected_item_type"
        elif key == "protectionState":
            suggest = "protection_state"
        elif key == "protectionStatus":
            suggest = "protection_status"
        elif key == "serverName":
            suggest = "server_name"
        elif key == "sourceResourceId":
            suggest = "source_resource_id"
        elif key == "workloadType":
            suggest = "workload_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureVmWorkloadSAPAseDatabaseProtectedItemResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureVmWorkloadSAPAseDatabaseProtectedItemResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureVmWorkloadSAPAseDatabaseProtectedItemResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backup_management_type: Optional[str] = None,
                 backup_set_name: Optional[str] = None,
                 container_name: Optional[str] = None,
                 create_mode: Optional[str] = None,
                 deferred_delete_time_in_utc: Optional[str] = None,
                 deferred_delete_time_remaining: Optional[str] = None,
                 extended_info: Optional['outputs.AzureVmWorkloadProtectedItemExtendedInfoResponse'] = None,
                 friendly_name: Optional[str] = None,
                 is_deferred_delete_schedule_upcoming: Optional[bool] = None,
                 is_rehydrate: Optional[bool] = None,
                 is_scheduled_for_deferred_delete: Optional[bool] = None,
                 last_backup_error_detail: Optional['outputs.ErrorDetailResponse'] = None,
                 last_backup_status: Optional[str] = None,
                 last_backup_time: Optional[str] = None,
                 last_recovery_point: Optional[str] = None,
                 parent_name: Optional[str] = None,
                 parent_type: Optional[str] = None,
                 policy_id: Optional[str] = None,
                 protected_item_data_source_id: Optional[str] = None,
                 protected_item_health_status: Optional[str] = None,
                 protected_item_type: Optional[str] = None,
                 protection_state: Optional[str] = None,
                 protection_status: Optional[str] = None,
                 server_name: Optional[str] = None,
                 source_resource_id: Optional[str] = None,
                 workload_type: Optional[str] = None):
        """
        Azure VM workload-specific protected item representing SAP ASE Database.
        :param str backup_management_type: Type of backup management for the backed up item.
        :param str backup_set_name: Name of the backup set the backup item belongs to
        :param str container_name: Unique name of container
        :param str create_mode: Create mode to indicate recovery of existing soft deleted data source or creation of new data source.
        :param str deferred_delete_time_in_utc: Time for deferred deletion in UTC
        :param str deferred_delete_time_remaining: Time remaining before the DS marked for deferred delete is permanently deleted
        :param 'AzureVmWorkloadProtectedItemExtendedInfoResponse' extended_info: Additional information for this backup item.
        :param str friendly_name: Friendly name of the DB represented by this backup item.
        :param bool is_deferred_delete_schedule_upcoming: Flag to identify whether the deferred deleted DS is to be purged soon
        :param bool is_rehydrate: Flag to identify that deferred deleted DS is to be moved into Pause state
        :param bool is_scheduled_for_deferred_delete: Flag to identify whether the DS is scheduled for deferred delete
        :param 'ErrorDetailResponse' last_backup_error_detail: Error details in last backup
        :param str last_backup_status: Last backup operation status. Possible values: Healthy, Unhealthy.
        :param str last_backup_time: Timestamp of the last backup operation on this backup item.
        :param str last_recovery_point: Timestamp when the last (latest) backup copy was created for this backup item.
        :param str parent_name: Parent name of the DB such as Instance or Availability Group.
        :param str parent_type: Parent type of protected item, example: for a DB, standalone server or distributed
        :param str policy_id: ID of the backup policy with which this item is backed up.
        :param str protected_item_data_source_id: Data ID of the protected item.
        :param str protected_item_health_status: Health status of the backup item, evaluated based on last heartbeat received
        :param str protected_item_type: backup item type.
               Expected value is 'AzureVmWorkloadSAPAseDatabase'.
        :param str protection_state: Backup state of this backup item.
        :param str protection_status: Backup status of this backup item.
        :param str server_name: Host/Cluster Name for instance or AG
        :param str source_resource_id: ARM ID of the resource to be backed up.
        :param str workload_type: Type of workload this item represents.
        """
        if backup_management_type is not None:
            pulumi.set(__self__, "backup_management_type", backup_management_type)
        if backup_set_name is not None:
            pulumi.set(__self__, "backup_set_name", backup_set_name)
        if container_name is not None:
            pulumi.set(__self__, "container_name", container_name)
        if create_mode is not None:
            pulumi.set(__self__, "create_mode", create_mode)
        if deferred_delete_time_in_utc is not None:
            pulumi.set(__self__, "deferred_delete_time_in_utc", deferred_delete_time_in_utc)
        if deferred_delete_time_remaining is not None:
            pulumi.set(__self__, "deferred_delete_time_remaining", deferred_delete_time_remaining)
        if extended_info is not None:
            pulumi.set(__self__, "extended_info", extended_info)
        if friendly_name is not None:
            pulumi.set(__self__, "friendly_name", friendly_name)
        if is_deferred_delete_schedule_upcoming is not None:
            pulumi.set(__self__, "is_deferred_delete_schedule_upcoming", is_deferred_delete_schedule_upcoming)
        if is_rehydrate is not None:
            pulumi.set(__self__, "is_rehydrate", is_rehydrate)
        if is_scheduled_for_deferred_delete is not None:
            pulumi.set(__self__, "is_scheduled_for_deferred_delete", is_scheduled_for_deferred_delete)
        if last_backup_error_detail is not None:
            pulumi.set(__self__, "last_backup_error_detail", last_backup_error_detail)
        if last_backup_status is not None:
            pulumi.set(__self__, "last_backup_status", last_backup_status)
        if last_backup_time is not None:
            pulumi.set(__self__, "last_backup_time", last_backup_time)
        if last_recovery_point is not None:
            pulumi.set(__self__, "last_recovery_point", last_recovery_point)
        if parent_name is not None:
            pulumi.set(__self__, "parent_name", parent_name)
        if parent_type is not None:
            pulumi.set(__self__, "parent_type", parent_type)
        if policy_id is not None:
            pulumi.set(__self__, "policy_id", policy_id)
        if protected_item_data_source_id is not None:
            pulumi.set(__self__, "protected_item_data_source_id", protected_item_data_source_id)
        if protected_item_health_status is not None:
            pulumi.set(__self__, "protected_item_health_status", protected_item_health_status)
        if protected_item_type is not None:
            pulumi.set(__self__, "protected_item_type", 'AzureVmWorkloadSAPAseDatabase')
        if protection_state is not None:
            pulumi.set(__self__, "protection_state", protection_state)
        if protection_status is not None:
            pulumi.set(__self__, "protection_status", protection_status)
        if server_name is not None:
            pulumi.set(__self__, "server_name", server_name)
        if source_resource_id is not None:
            pulumi.set(__self__, "source_resource_id", source_resource_id)
        if workload_type is not None:
            pulumi.set(__self__, "workload_type", workload_type)

    @property
    @pulumi.getter(name="backupManagementType")
    def backup_management_type(self) -> Optional[str]:
        """
        Type of backup management for the backed up item.
        """
        return pulumi.get(self, "backup_management_type")

    @property
    @pulumi.getter(name="backupSetName")
    def backup_set_name(self) -> Optional[str]:
        """
        Name of the backup set the backup item belongs to
        """
        return pulumi.get(self, "backup_set_name")

    @property
    @pulumi.getter(name="containerName")
    def container_name(self) -> Optional[str]:
        """
        Unique name of container
        """
        return pulumi.get(self, "container_name")

    @property
    @pulumi.getter(name="createMode")
    def create_mode(self) -> Optional[str]:
        """
        Create mode to indicate recovery of existing soft deleted data source or creation of new data source.
        """
        return pulumi.get(self, "create_mode")

    @property
    @pulumi.getter(name="deferredDeleteTimeInUTC")
    def deferred_delete_time_in_utc(self) -> Optional[str]:
        """
        Time for deferred deletion in UTC
        """
        return pulumi.get(self, "deferred_delete_time_in_utc")

    @property
    @pulumi.getter(name="deferredDeleteTimeRemaining")
    def deferred_delete_time_remaining(self) -> Optional[str]:
        """
        Time remaining before the DS marked for deferred delete is permanently deleted
        """
        return pulumi.get(self, "deferred_delete_time_remaining")

    @property
    @pulumi.getter(name="extendedInfo")
    def extended_info(self) -> Optional['outputs.AzureVmWorkloadProtectedItemExtendedInfoResponse']:
        """
        Additional information for this backup item.
        """
        return pulumi.get(self, "extended_info")

    @property
    @pulumi.getter(name="friendlyName")
    def friendly_name(self) -> Optional[str]:
        """
        Friendly name of the DB represented by this backup item.
        """
        return pulumi.get(self, "friendly_name")

    @property
    @pulumi.getter(name="isDeferredDeleteScheduleUpcoming")
    def is_deferred_delete_schedule_upcoming(self) -> Optional[bool]:
        """
        Flag to identify whether the deferred deleted DS is to be purged soon
        """
        return pulumi.get(self, "is_deferred_delete_schedule_upcoming")

    @property
    @pulumi.getter(name="isRehydrate")
    def is_rehydrate(self) -> Optional[bool]:
        """
        Flag to identify that deferred deleted DS is to be moved into Pause state
        """
        return pulumi.get(self, "is_rehydrate")

    @property
    @pulumi.getter(name="isScheduledForDeferredDelete")
    def is_scheduled_for_deferred_delete(self) -> Optional[bool]:
        """
        Flag to identify whether the DS is scheduled for deferred delete
        """
        return pulumi.get(self, "is_scheduled_for_deferred_delete")

    @property
    @pulumi.getter(name="lastBackupErrorDetail")
    def last_backup_error_detail(self) -> Optional['outputs.ErrorDetailResponse']:
        """
        Error details in last backup
        """
        return pulumi.get(self, "last_backup_error_detail")

    @property
    @pulumi.getter(name="lastBackupStatus")
    def last_backup_status(self) -> Optional[str]:
        """
        Last backup operation status. Possible values: Healthy, Unhealthy.
        """
        return pulumi.get(self, "last_backup_status")

    @property
    @pulumi.getter(name="lastBackupTime")
    def last_backup_time(self) -> Optional[str]:
        """
        Timestamp of the last backup operation on this backup item.
        """
        return pulumi.get(self, "last_backup_time")

    @property
    @pulumi.getter(name="lastRecoveryPoint")
    def last_recovery_point(self) -> Optional[str]:
        """
        Timestamp when the last (latest) backup copy was created for this backup item.
        """
        return pulumi.get(self, "last_recovery_point")

    @property
    @pulumi.getter(name="parentName")
    def parent_name(self) -> Optional[str]:
        """
        Parent name of the DB such as Instance or Availability Group.
        """
        return pulumi.get(self, "parent_name")

    @property
    @pulumi.getter(name="parentType")
    def parent_type(self) -> Optional[str]:
        """
        Parent type of protected item, example: for a DB, standalone server or distributed
        """
        return pulumi.get(self, "parent_type")

    @property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> Optional[str]:
        """
        ID of the backup policy with which this item is backed up.
        """
        return pulumi.get(self, "policy_id")

    @property
    @pulumi.getter(name="protectedItemDataSourceId")
    def protected_item_data_source_id(self) -> Optional[str]:
        """
        Data ID of the protected item.
        """
        return pulumi.get(self, "protected_item_data_source_id")

    @property
    @pulumi.getter(name="protectedItemHealthStatus")
    def protected_item_health_status(self) -> Optional[str]:
        """
        Health status of the backup item, evaluated based on last heartbeat received
        """
        return pulumi.get(self, "protected_item_health_status")

    @property
    @pulumi.getter(name="protectedItemType")
    def protected_item_type(self) -> Optional[str]:
        """
        backup item type.
        Expected value is 'AzureVmWorkloadSAPAseDatabase'.
        """
        return pulumi.get(self, "protected_item_type")

    @property
    @pulumi.getter(name="protectionState")
    def protection_state(self) -> Optional[str]:
        """
        Backup state of this backup item.
        """
        return pulumi.get(self, "protection_state")

    @property
    @pulumi.getter(name="protectionStatus")
    def protection_status(self) -> Optional[str]:
        """
        Backup status of this backup item.
        """
        return pulumi.get(self, "protection_status")

    @property
    @pulumi.getter(name="serverName")
    def server_name(self) -> Optional[str]:
        """
        Host/Cluster Name for instance or AG
        """
        return pulumi.get(self, "server_name")

    @property
    @pulumi.getter(name="sourceResourceId")
    def source_resource_id(self) -> Optional[str]:
        """
        ARM ID of the resource to be backed up.
        """
        return pulumi.get(self, "source_resource_id")

    @property
    @pulumi.getter(name="workloadType")
    def workload_type(self) -> Optional[str]:
        """
        Type of workload this item represents.
        """
        return pulumi.get(self, "workload_type")


@pulumi.output_type
class AzureVmWorkloadSAPHanaDatabaseProtectedItemResponse(dict):
    """
    Azure VM workload-specific protected item representing SAP HANA Database.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backupManagementType":
            suggest = "backup_management_type"
        elif key == "backupSetName":
            suggest = "backup_set_name"
        elif key == "containerName":
            suggest = "container_name"
        elif key == "createMode":
            suggest = "create_mode"
        elif key == "deferredDeleteTimeInUTC":
            suggest = "deferred_delete_time_in_utc"
        elif key == "deferredDeleteTimeRemaining":
            suggest = "deferred_delete_time_remaining"
        elif key == "extendedInfo":
            suggest = "extended_info"
        elif key == "friendlyName":
            suggest = "friendly_name"
        elif key == "isDeferredDeleteScheduleUpcoming":
            suggest = "is_deferred_delete_schedule_upcoming"
        elif key == "isRehydrate":
            suggest = "is_rehydrate"
        elif key == "isScheduledForDeferredDelete":
            suggest = "is_scheduled_for_deferred_delete"
        elif key == "lastBackupErrorDetail":
            suggest = "last_backup_error_detail"
        elif key == "lastBackupStatus":
            suggest = "last_backup_status"
        elif key == "lastBackupTime":
            suggest = "last_backup_time"
        elif key == "lastRecoveryPoint":
            suggest = "last_recovery_point"
        elif key == "parentName":
            suggest = "parent_name"
        elif key == "parentType":
            suggest = "parent_type"
        elif key == "policyId":
            suggest = "policy_id"
        elif key == "protectedItemDataSourceId":
            suggest = "protected_item_data_source_id"
        elif key == "protectedItemHealthStatus":
            suggest = "protected_item_health_status"
        elif key == "protectedItemType":
            suggest = "protected_item_type"
        elif key == "protectionState":
            suggest = "protection_state"
        elif key == "protectionStatus":
            suggest = "protection_status"
        elif key == "serverName":
            suggest = "server_name"
        elif key == "sourceResourceId":
            suggest = "source_resource_id"
        elif key == "workloadType":
            suggest = "workload_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureVmWorkloadSAPHanaDatabaseProtectedItemResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureVmWorkloadSAPHanaDatabaseProtectedItemResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureVmWorkloadSAPHanaDatabaseProtectedItemResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backup_management_type: Optional[str] = None,
                 backup_set_name: Optional[str] = None,
                 container_name: Optional[str] = None,
                 create_mode: Optional[str] = None,
                 deferred_delete_time_in_utc: Optional[str] = None,
                 deferred_delete_time_remaining: Optional[str] = None,
                 extended_info: Optional['outputs.AzureVmWorkloadProtectedItemExtendedInfoResponse'] = None,
                 friendly_name: Optional[str] = None,
                 is_deferred_delete_schedule_upcoming: Optional[bool] = None,
                 is_rehydrate: Optional[bool] = None,
                 is_scheduled_for_deferred_delete: Optional[bool] = None,
                 last_backup_error_detail: Optional['outputs.ErrorDetailResponse'] = None,
                 last_backup_status: Optional[str] = None,
                 last_backup_time: Optional[str] = None,
                 last_recovery_point: Optional[str] = None,
                 parent_name: Optional[str] = None,
                 parent_type: Optional[str] = None,
                 policy_id: Optional[str] = None,
                 protected_item_data_source_id: Optional[str] = None,
                 protected_item_health_status: Optional[str] = None,
                 protected_item_type: Optional[str] = None,
                 protection_state: Optional[str] = None,
                 protection_status: Optional[str] = None,
                 server_name: Optional[str] = None,
                 source_resource_id: Optional[str] = None,
                 workload_type: Optional[str] = None):
        """
        Azure VM workload-specific protected item representing SAP HANA Database.
        :param str backup_management_type: Type of backup management for the backed up item.
        :param str backup_set_name: Name of the backup set the backup item belongs to
        :param str container_name: Unique name of container
        :param str create_mode: Create mode to indicate recovery of existing soft deleted data source or creation of new data source.
        :param str deferred_delete_time_in_utc: Time for deferred deletion in UTC
        :param str deferred_delete_time_remaining: Time remaining before the DS marked for deferred delete is permanently deleted
        :param 'AzureVmWorkloadProtectedItemExtendedInfoResponse' extended_info: Additional information for this backup item.
        :param str friendly_name: Friendly name of the DB represented by this backup item.
        :param bool is_deferred_delete_schedule_upcoming: Flag to identify whether the deferred deleted DS is to be purged soon
        :param bool is_rehydrate: Flag to identify that deferred deleted DS is to be moved into Pause state
        :param bool is_scheduled_for_deferred_delete: Flag to identify whether the DS is scheduled for deferred delete
        :param 'ErrorDetailResponse' last_backup_error_detail: Error details in last backup
        :param str last_backup_status: Last backup operation status. Possible values: Healthy, Unhealthy.
        :param str last_backup_time: Timestamp of the last backup operation on this backup item.
        :param str last_recovery_point: Timestamp when the last (latest) backup copy was created for this backup item.
        :param str parent_name: Parent name of the DB such as Instance or Availability Group.
        :param str parent_type: Parent type of protected item, example: for a DB, standalone server or distributed
        :param str policy_id: ID of the backup policy with which this item is backed up.
        :param str protected_item_data_source_id: Data ID of the protected item.
        :param str protected_item_health_status: Health status of the backup item, evaluated based on last heartbeat received
        :param str protected_item_type: backup item type.
               Expected value is 'AzureVmWorkloadSAPHanaDatabase'.
        :param str protection_state: Backup state of this backup item.
        :param str protection_status: Backup status of this backup item.
        :param str server_name: Host/Cluster Name for instance or AG
        :param str source_resource_id: ARM ID of the resource to be backed up.
        :param str workload_type: Type of workload this item represents.
        """
        if backup_management_type is not None:
            pulumi.set(__self__, "backup_management_type", backup_management_type)
        if backup_set_name is not None:
            pulumi.set(__self__, "backup_set_name", backup_set_name)
        if container_name is not None:
            pulumi.set(__self__, "container_name", container_name)
        if create_mode is not None:
            pulumi.set(__self__, "create_mode", create_mode)
        if deferred_delete_time_in_utc is not None:
            pulumi.set(__self__, "deferred_delete_time_in_utc", deferred_delete_time_in_utc)
        if deferred_delete_time_remaining is not None:
            pulumi.set(__self__, "deferred_delete_time_remaining", deferred_delete_time_remaining)
        if extended_info is not None:
            pulumi.set(__self__, "extended_info", extended_info)
        if friendly_name is not None:
            pulumi.set(__self__, "friendly_name", friendly_name)
        if is_deferred_delete_schedule_upcoming is not None:
            pulumi.set(__self__, "is_deferred_delete_schedule_upcoming", is_deferred_delete_schedule_upcoming)
        if is_rehydrate is not None:
            pulumi.set(__self__, "is_rehydrate", is_rehydrate)
        if is_scheduled_for_deferred_delete is not None:
            pulumi.set(__self__, "is_scheduled_for_deferred_delete", is_scheduled_for_deferred_delete)
        if last_backup_error_detail is not None:
            pulumi.set(__self__, "last_backup_error_detail", last_backup_error_detail)
        if last_backup_status is not None:
            pulumi.set(__self__, "last_backup_status", last_backup_status)
        if last_backup_time is not None:
            pulumi.set(__self__, "last_backup_time", last_backup_time)
        if last_recovery_point is not None:
            pulumi.set(__self__, "last_recovery_point", last_recovery_point)
        if parent_name is not None:
            pulumi.set(__self__, "parent_name", parent_name)
        if parent_type is not None:
            pulumi.set(__self__, "parent_type", parent_type)
        if policy_id is not None:
            pulumi.set(__self__, "policy_id", policy_id)
        if protected_item_data_source_id is not None:
            pulumi.set(__self__, "protected_item_data_source_id", protected_item_data_source_id)
        if protected_item_health_status is not None:
            pulumi.set(__self__, "protected_item_health_status", protected_item_health_status)
        if protected_item_type is not None:
            pulumi.set(__self__, "protected_item_type", 'AzureVmWorkloadSAPHanaDatabase')
        if protection_state is not None:
            pulumi.set(__self__, "protection_state", protection_state)
        if protection_status is not None:
            pulumi.set(__self__, "protection_status", protection_status)
        if server_name is not None:
            pulumi.set(__self__, "server_name", server_name)
        if source_resource_id is not None:
            pulumi.set(__self__, "source_resource_id", source_resource_id)
        if workload_type is not None:
            pulumi.set(__self__, "workload_type", workload_type)

    @property
    @pulumi.getter(name="backupManagementType")
    def backup_management_type(self) -> Optional[str]:
        """
        Type of backup management for the backed up item.
        """
        return pulumi.get(self, "backup_management_type")

    @property
    @pulumi.getter(name="backupSetName")
    def backup_set_name(self) -> Optional[str]:
        """
        Name of the backup set the backup item belongs to
        """
        return pulumi.get(self, "backup_set_name")

    @property
    @pulumi.getter(name="containerName")
    def container_name(self) -> Optional[str]:
        """
        Unique name of container
        """
        return pulumi.get(self, "container_name")

    @property
    @pulumi.getter(name="createMode")
    def create_mode(self) -> Optional[str]:
        """
        Create mode to indicate recovery of existing soft deleted data source or creation of new data source.
        """
        return pulumi.get(self, "create_mode")

    @property
    @pulumi.getter(name="deferredDeleteTimeInUTC")
    def deferred_delete_time_in_utc(self) -> Optional[str]:
        """
        Time for deferred deletion in UTC
        """
        return pulumi.get(self, "deferred_delete_time_in_utc")

    @property
    @pulumi.getter(name="deferredDeleteTimeRemaining")
    def deferred_delete_time_remaining(self) -> Optional[str]:
        """
        Time remaining before the DS marked for deferred delete is permanently deleted
        """
        return pulumi.get(self, "deferred_delete_time_remaining")

    @property
    @pulumi.getter(name="extendedInfo")
    def extended_info(self) -> Optional['outputs.AzureVmWorkloadProtectedItemExtendedInfoResponse']:
        """
        Additional information for this backup item.
        """
        return pulumi.get(self, "extended_info")

    @property
    @pulumi.getter(name="friendlyName")
    def friendly_name(self) -> Optional[str]:
        """
        Friendly name of the DB represented by this backup item.
        """
        return pulumi.get(self, "friendly_name")

    @property
    @pulumi.getter(name="isDeferredDeleteScheduleUpcoming")
    def is_deferred_delete_schedule_upcoming(self) -> Optional[bool]:
        """
        Flag to identify whether the deferred deleted DS is to be purged soon
        """
        return pulumi.get(self, "is_deferred_delete_schedule_upcoming")

    @property
    @pulumi.getter(name="isRehydrate")
    def is_rehydrate(self) -> Optional[bool]:
        """
        Flag to identify that deferred deleted DS is to be moved into Pause state
        """
        return pulumi.get(self, "is_rehydrate")

    @property
    @pulumi.getter(name="isScheduledForDeferredDelete")
    def is_scheduled_for_deferred_delete(self) -> Optional[bool]:
        """
        Flag to identify whether the DS is scheduled for deferred delete
        """
        return pulumi.get(self, "is_scheduled_for_deferred_delete")

    @property
    @pulumi.getter(name="lastBackupErrorDetail")
    def last_backup_error_detail(self) -> Optional['outputs.ErrorDetailResponse']:
        """
        Error details in last backup
        """
        return pulumi.get(self, "last_backup_error_detail")

    @property
    @pulumi.getter(name="lastBackupStatus")
    def last_backup_status(self) -> Optional[str]:
        """
        Last backup operation status. Possible values: Healthy, Unhealthy.
        """
        return pulumi.get(self, "last_backup_status")

    @property
    @pulumi.getter(name="lastBackupTime")
    def last_backup_time(self) -> Optional[str]:
        """
        Timestamp of the last backup operation on this backup item.
        """
        return pulumi.get(self, "last_backup_time")

    @property
    @pulumi.getter(name="lastRecoveryPoint")
    def last_recovery_point(self) -> Optional[str]:
        """
        Timestamp when the last (latest) backup copy was created for this backup item.
        """
        return pulumi.get(self, "last_recovery_point")

    @property
    @pulumi.getter(name="parentName")
    def parent_name(self) -> Optional[str]:
        """
        Parent name of the DB such as Instance or Availability Group.
        """
        return pulumi.get(self, "parent_name")

    @property
    @pulumi.getter(name="parentType")
    def parent_type(self) -> Optional[str]:
        """
        Parent type of protected item, example: for a DB, standalone server or distributed
        """
        return pulumi.get(self, "parent_type")

    @property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> Optional[str]:
        """
        ID of the backup policy with which this item is backed up.
        """
        return pulumi.get(self, "policy_id")

    @property
    @pulumi.getter(name="protectedItemDataSourceId")
    def protected_item_data_source_id(self) -> Optional[str]:
        """
        Data ID of the protected item.
        """
        return pulumi.get(self, "protected_item_data_source_id")

    @property
    @pulumi.getter(name="protectedItemHealthStatus")
    def protected_item_health_status(self) -> Optional[str]:
        """
        Health status of the backup item, evaluated based on last heartbeat received
        """
        return pulumi.get(self, "protected_item_health_status")

    @property
    @pulumi.getter(name="protectedItemType")
    def protected_item_type(self) -> Optional[str]:
        """
        backup item type.
        Expected value is 'AzureVmWorkloadSAPHanaDatabase'.
        """
        return pulumi.get(self, "protected_item_type")

    @property
    @pulumi.getter(name="protectionState")
    def protection_state(self) -> Optional[str]:
        """
        Backup state of this backup item.
        """
        return pulumi.get(self, "protection_state")

    @property
    @pulumi.getter(name="protectionStatus")
    def protection_status(self) -> Optional[str]:
        """
        Backup status of this backup item.
        """
        return pulumi.get(self, "protection_status")

    @property
    @pulumi.getter(name="serverName")
    def server_name(self) -> Optional[str]:
        """
        Host/Cluster Name for instance or AG
        """
        return pulumi.get(self, "server_name")

    @property
    @pulumi.getter(name="sourceResourceId")
    def source_resource_id(self) -> Optional[str]:
        """
        ARM ID of the resource to be backed up.
        """
        return pulumi.get(self, "source_resource_id")

    @property
    @pulumi.getter(name="workloadType")
    def workload_type(self) -> Optional[str]:
        """
        Type of workload this item represents.
        """
        return pulumi.get(self, "workload_type")


@pulumi.output_type
class AzureVmWorkloadSQLDatabaseProtectedItemResponse(dict):
    """
    Azure VM workload-specific protected item representing SQL Database.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backupManagementType":
            suggest = "backup_management_type"
        elif key == "backupSetName":
            suggest = "backup_set_name"
        elif key == "containerName":
            suggest = "container_name"
        elif key == "createMode":
            suggest = "create_mode"
        elif key == "deferredDeleteTimeInUTC":
            suggest = "deferred_delete_time_in_utc"
        elif key == "deferredDeleteTimeRemaining":
            suggest = "deferred_delete_time_remaining"
        elif key == "extendedInfo":
            suggest = "extended_info"
        elif key == "friendlyName":
            suggest = "friendly_name"
        elif key == "isDeferredDeleteScheduleUpcoming":
            suggest = "is_deferred_delete_schedule_upcoming"
        elif key == "isRehydrate":
            suggest = "is_rehydrate"
        elif key == "isScheduledForDeferredDelete":
            suggest = "is_scheduled_for_deferred_delete"
        elif key == "lastBackupErrorDetail":
            suggest = "last_backup_error_detail"
        elif key == "lastBackupStatus":
            suggest = "last_backup_status"
        elif key == "lastBackupTime":
            suggest = "last_backup_time"
        elif key == "lastRecoveryPoint":
            suggest = "last_recovery_point"
        elif key == "parentName":
            suggest = "parent_name"
        elif key == "parentType":
            suggest = "parent_type"
        elif key == "policyId":
            suggest = "policy_id"
        elif key == "protectedItemDataSourceId":
            suggest = "protected_item_data_source_id"
        elif key == "protectedItemHealthStatus":
            suggest = "protected_item_health_status"
        elif key == "protectedItemType":
            suggest = "protected_item_type"
        elif key == "protectionState":
            suggest = "protection_state"
        elif key == "protectionStatus":
            suggest = "protection_status"
        elif key == "serverName":
            suggest = "server_name"
        elif key == "sourceResourceId":
            suggest = "source_resource_id"
        elif key == "workloadType":
            suggest = "workload_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureVmWorkloadSQLDatabaseProtectedItemResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureVmWorkloadSQLDatabaseProtectedItemResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureVmWorkloadSQLDatabaseProtectedItemResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backup_management_type: Optional[str] = None,
                 backup_set_name: Optional[str] = None,
                 container_name: Optional[str] = None,
                 create_mode: Optional[str] = None,
                 deferred_delete_time_in_utc: Optional[str] = None,
                 deferred_delete_time_remaining: Optional[str] = None,
                 extended_info: Optional['outputs.AzureVmWorkloadProtectedItemExtendedInfoResponse'] = None,
                 friendly_name: Optional[str] = None,
                 is_deferred_delete_schedule_upcoming: Optional[bool] = None,
                 is_rehydrate: Optional[bool] = None,
                 is_scheduled_for_deferred_delete: Optional[bool] = None,
                 last_backup_error_detail: Optional['outputs.ErrorDetailResponse'] = None,
                 last_backup_status: Optional[str] = None,
                 last_backup_time: Optional[str] = None,
                 last_recovery_point: Optional[str] = None,
                 parent_name: Optional[str] = None,
                 parent_type: Optional[str] = None,
                 policy_id: Optional[str] = None,
                 protected_item_data_source_id: Optional[str] = None,
                 protected_item_health_status: Optional[str] = None,
                 protected_item_type: Optional[str] = None,
                 protection_state: Optional[str] = None,
                 protection_status: Optional[str] = None,
                 server_name: Optional[str] = None,
                 source_resource_id: Optional[str] = None,
                 workload_type: Optional[str] = None):
        """
        Azure VM workload-specific protected item representing SQL Database.
        :param str backup_management_type: Type of backup management for the backed up item.
        :param str backup_set_name: Name of the backup set the backup item belongs to
        :param str container_name: Unique name of container
        :param str create_mode: Create mode to indicate recovery of existing soft deleted data source or creation of new data source.
        :param str deferred_delete_time_in_utc: Time for deferred deletion in UTC
        :param str deferred_delete_time_remaining: Time remaining before the DS marked for deferred delete is permanently deleted
        :param 'AzureVmWorkloadProtectedItemExtendedInfoResponse' extended_info: Additional information for this backup item.
        :param str friendly_name: Friendly name of the DB represented by this backup item.
        :param bool is_deferred_delete_schedule_upcoming: Flag to identify whether the deferred deleted DS is to be purged soon
        :param bool is_rehydrate: Flag to identify that deferred deleted DS is to be moved into Pause state
        :param bool is_scheduled_for_deferred_delete: Flag to identify whether the DS is scheduled for deferred delete
        :param 'ErrorDetailResponse' last_backup_error_detail: Error details in last backup
        :param str last_backup_status: Last backup operation status. Possible values: Healthy, Unhealthy.
        :param str last_backup_time: Timestamp of the last backup operation on this backup item.
        :param str last_recovery_point: Timestamp when the last (latest) backup copy was created for this backup item.
        :param str parent_name: Parent name of the DB such as Instance or Availability Group.
        :param str parent_type: Parent type of protected item, example: for a DB, standalone server or distributed
        :param str policy_id: ID of the backup policy with which this item is backed up.
        :param str protected_item_data_source_id: Data ID of the protected item.
        :param str protected_item_health_status: Health status of the backup item, evaluated based on last heartbeat received
        :param str protected_item_type: backup item type.
               Expected value is 'AzureVmWorkloadSQLDatabase'.
        :param str protection_state: Backup state of this backup item.
        :param str protection_status: Backup status of this backup item.
        :param str server_name: Host/Cluster Name for instance or AG
        :param str source_resource_id: ARM ID of the resource to be backed up.
        :param str workload_type: Type of workload this item represents.
        """
        if backup_management_type is not None:
            pulumi.set(__self__, "backup_management_type", backup_management_type)
        if backup_set_name is not None:
            pulumi.set(__self__, "backup_set_name", backup_set_name)
        if container_name is not None:
            pulumi.set(__self__, "container_name", container_name)
        if create_mode is not None:
            pulumi.set(__self__, "create_mode", create_mode)
        if deferred_delete_time_in_utc is not None:
            pulumi.set(__self__, "deferred_delete_time_in_utc", deferred_delete_time_in_utc)
        if deferred_delete_time_remaining is not None:
            pulumi.set(__self__, "deferred_delete_time_remaining", deferred_delete_time_remaining)
        if extended_info is not None:
            pulumi.set(__self__, "extended_info", extended_info)
        if friendly_name is not None:
            pulumi.set(__self__, "friendly_name", friendly_name)
        if is_deferred_delete_schedule_upcoming is not None:
            pulumi.set(__self__, "is_deferred_delete_schedule_upcoming", is_deferred_delete_schedule_upcoming)
        if is_rehydrate is not None:
            pulumi.set(__self__, "is_rehydrate", is_rehydrate)
        if is_scheduled_for_deferred_delete is not None:
            pulumi.set(__self__, "is_scheduled_for_deferred_delete", is_scheduled_for_deferred_delete)
        if last_backup_error_detail is not None:
            pulumi.set(__self__, "last_backup_error_detail", last_backup_error_detail)
        if last_backup_status is not None:
            pulumi.set(__self__, "last_backup_status", last_backup_status)
        if last_backup_time is not None:
            pulumi.set(__self__, "last_backup_time", last_backup_time)
        if last_recovery_point is not None:
            pulumi.set(__self__, "last_recovery_point", last_recovery_point)
        if parent_name is not None:
            pulumi.set(__self__, "parent_name", parent_name)
        if parent_type is not None:
            pulumi.set(__self__, "parent_type", parent_type)
        if policy_id is not None:
            pulumi.set(__self__, "policy_id", policy_id)
        if protected_item_data_source_id is not None:
            pulumi.set(__self__, "protected_item_data_source_id", protected_item_data_source_id)
        if protected_item_health_status is not None:
            pulumi.set(__self__, "protected_item_health_status", protected_item_health_status)
        if protected_item_type is not None:
            pulumi.set(__self__, "protected_item_type", 'AzureVmWorkloadSQLDatabase')
        if protection_state is not None:
            pulumi.set(__self__, "protection_state", protection_state)
        if protection_status is not None:
            pulumi.set(__self__, "protection_status", protection_status)
        if server_name is not None:
            pulumi.set(__self__, "server_name", server_name)
        if source_resource_id is not None:
            pulumi.set(__self__, "source_resource_id", source_resource_id)
        if workload_type is not None:
            pulumi.set(__self__, "workload_type", workload_type)

    @property
    @pulumi.getter(name="backupManagementType")
    def backup_management_type(self) -> Optional[str]:
        """
        Type of backup management for the backed up item.
        """
        return pulumi.get(self, "backup_management_type")

    @property
    @pulumi.getter(name="backupSetName")
    def backup_set_name(self) -> Optional[str]:
        """
        Name of the backup set the backup item belongs to
        """
        return pulumi.get(self, "backup_set_name")

    @property
    @pulumi.getter(name="containerName")
    def container_name(self) -> Optional[str]:
        """
        Unique name of container
        """
        return pulumi.get(self, "container_name")

    @property
    @pulumi.getter(name="createMode")
    def create_mode(self) -> Optional[str]:
        """
        Create mode to indicate recovery of existing soft deleted data source or creation of new data source.
        """
        return pulumi.get(self, "create_mode")

    @property
    @pulumi.getter(name="deferredDeleteTimeInUTC")
    def deferred_delete_time_in_utc(self) -> Optional[str]:
        """
        Time for deferred deletion in UTC
        """
        return pulumi.get(self, "deferred_delete_time_in_utc")

    @property
    @pulumi.getter(name="deferredDeleteTimeRemaining")
    def deferred_delete_time_remaining(self) -> Optional[str]:
        """
        Time remaining before the DS marked for deferred delete is permanently deleted
        """
        return pulumi.get(self, "deferred_delete_time_remaining")

    @property
    @pulumi.getter(name="extendedInfo")
    def extended_info(self) -> Optional['outputs.AzureVmWorkloadProtectedItemExtendedInfoResponse']:
        """
        Additional information for this backup item.
        """
        return pulumi.get(self, "extended_info")

    @property
    @pulumi.getter(name="friendlyName")
    def friendly_name(self) -> Optional[str]:
        """
        Friendly name of the DB represented by this backup item.
        """
        return pulumi.get(self, "friendly_name")

    @property
    @pulumi.getter(name="isDeferredDeleteScheduleUpcoming")
    def is_deferred_delete_schedule_upcoming(self) -> Optional[bool]:
        """
        Flag to identify whether the deferred deleted DS is to be purged soon
        """
        return pulumi.get(self, "is_deferred_delete_schedule_upcoming")

    @property
    @pulumi.getter(name="isRehydrate")
    def is_rehydrate(self) -> Optional[bool]:
        """
        Flag to identify that deferred deleted DS is to be moved into Pause state
        """
        return pulumi.get(self, "is_rehydrate")

    @property
    @pulumi.getter(name="isScheduledForDeferredDelete")
    def is_scheduled_for_deferred_delete(self) -> Optional[bool]:
        """
        Flag to identify whether the DS is scheduled for deferred delete
        """
        return pulumi.get(self, "is_scheduled_for_deferred_delete")

    @property
    @pulumi.getter(name="lastBackupErrorDetail")
    def last_backup_error_detail(self) -> Optional['outputs.ErrorDetailResponse']:
        """
        Error details in last backup
        """
        return pulumi.get(self, "last_backup_error_detail")

    @property
    @pulumi.getter(name="lastBackupStatus")
    def last_backup_status(self) -> Optional[str]:
        """
        Last backup operation status. Possible values: Healthy, Unhealthy.
        """
        return pulumi.get(self, "last_backup_status")

    @property
    @pulumi.getter(name="lastBackupTime")
    def last_backup_time(self) -> Optional[str]:
        """
        Timestamp of the last backup operation on this backup item.
        """
        return pulumi.get(self, "last_backup_time")

    @property
    @pulumi.getter(name="lastRecoveryPoint")
    def last_recovery_point(self) -> Optional[str]:
        """
        Timestamp when the last (latest) backup copy was created for this backup item.
        """
        return pulumi.get(self, "last_recovery_point")

    @property
    @pulumi.getter(name="parentName")
    def parent_name(self) -> Optional[str]:
        """
        Parent name of the DB such as Instance or Availability Group.
        """
        return pulumi.get(self, "parent_name")

    @property
    @pulumi.getter(name="parentType")
    def parent_type(self) -> Optional[str]:
        """
        Parent type of protected item, example: for a DB, standalone server or distributed
        """
        return pulumi.get(self, "parent_type")

    @property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> Optional[str]:
        """
        ID of the backup policy with which this item is backed up.
        """
        return pulumi.get(self, "policy_id")

    @property
    @pulumi.getter(name="protectedItemDataSourceId")
    def protected_item_data_source_id(self) -> Optional[str]:
        """
        Data ID of the protected item.
        """
        return pulumi.get(self, "protected_item_data_source_id")

    @property
    @pulumi.getter(name="protectedItemHealthStatus")
    def protected_item_health_status(self) -> Optional[str]:
        """
        Health status of the backup item, evaluated based on last heartbeat received
        """
        return pulumi.get(self, "protected_item_health_status")

    @property
    @pulumi.getter(name="protectedItemType")
    def protected_item_type(self) -> Optional[str]:
        """
        backup item type.
        Expected value is 'AzureVmWorkloadSQLDatabase'.
        """
        return pulumi.get(self, "protected_item_type")

    @property
    @pulumi.getter(name="protectionState")
    def protection_state(self) -> Optional[str]:
        """
        Backup state of this backup item.
        """
        return pulumi.get(self, "protection_state")

    @property
    @pulumi.getter(name="protectionStatus")
    def protection_status(self) -> Optional[str]:
        """
        Backup status of this backup item.
        """
        return pulumi.get(self, "protection_status")

    @property
    @pulumi.getter(name="serverName")
    def server_name(self) -> Optional[str]:
        """
        Host/Cluster Name for instance or AG
        """
        return pulumi.get(self, "server_name")

    @property
    @pulumi.getter(name="sourceResourceId")
    def source_resource_id(self) -> Optional[str]:
        """
        ARM ID of the resource to be backed up.
        """
        return pulumi.get(self, "source_resource_id")

    @property
    @pulumi.getter(name="workloadType")
    def workload_type(self) -> Optional[str]:
        """
        Type of workload this item represents.
        """
        return pulumi.get(self, "workload_type")


@pulumi.output_type
class DPMProtectedItemExtendedInfoResponse(dict):
    """
    Additional information of DPM Protected item.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "diskStorageUsedInBytes":
            suggest = "disk_storage_used_in_bytes"
        elif key == "isCollocated":
            suggest = "is_collocated"
        elif key == "isPresentOnCloud":
            suggest = "is_present_on_cloud"
        elif key == "lastBackupStatus":
            suggest = "last_backup_status"
        elif key == "lastRefreshedAt":
            suggest = "last_refreshed_at"
        elif key == "oldestRecoveryPoint":
            suggest = "oldest_recovery_point"
        elif key == "onPremiseLatestRecoveryPoint":
            suggest = "on_premise_latest_recovery_point"
        elif key == "onPremiseOldestRecoveryPoint":
            suggest = "on_premise_oldest_recovery_point"
        elif key == "onPremiseRecoveryPointCount":
            suggest = "on_premise_recovery_point_count"
        elif key == "protectableObjectLoadPath":
            suggest = "protectable_object_load_path"
        elif key == "protectionGroupName":
            suggest = "protection_group_name"
        elif key == "recoveryPointCount":
            suggest = "recovery_point_count"
        elif key == "totalDiskStorageSizeInBytes":
            suggest = "total_disk_storage_size_in_bytes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DPMProtectedItemExtendedInfoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DPMProtectedItemExtendedInfoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DPMProtectedItemExtendedInfoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 disk_storage_used_in_bytes: Optional[str] = None,
                 is_collocated: Optional[bool] = None,
                 is_present_on_cloud: Optional[bool] = None,
                 last_backup_status: Optional[str] = None,
                 last_refreshed_at: Optional[str] = None,
                 oldest_recovery_point: Optional[str] = None,
                 on_premise_latest_recovery_point: Optional[str] = None,
                 on_premise_oldest_recovery_point: Optional[str] = None,
                 on_premise_recovery_point_count: Optional[int] = None,
                 protectable_object_load_path: Optional[Mapping[str, str]] = None,
                 protected: Optional[bool] = None,
                 protection_group_name: Optional[str] = None,
                 recovery_point_count: Optional[int] = None,
                 total_disk_storage_size_in_bytes: Optional[str] = None):
        """
        Additional information of DPM Protected item.
        :param str disk_storage_used_in_bytes: Used Disk storage in bytes.
        :param bool is_collocated: To check if backup item is collocated.
        :param bool is_present_on_cloud: To check if backup item is cloud protected.
        :param str last_backup_status: Last backup status information on backup item.
        :param str last_refreshed_at: Last refresh time on backup item.
        :param str oldest_recovery_point: Oldest cloud recovery point time.
        :param str on_premise_latest_recovery_point: latest disk recovery point time.
        :param str on_premise_oldest_recovery_point: Oldest disk recovery point time.
        :param int on_premise_recovery_point_count: disk recovery point count.
        :param Mapping[str, str] protectable_object_load_path: Attribute to provide information on various DBs.
        :param bool protected: To check if backup item is disk protected.
        :param str protection_group_name: Protection group name of the backup item.
        :param int recovery_point_count: cloud recovery point count.
        :param str total_disk_storage_size_in_bytes: total Disk storage in bytes.
        """
        if disk_storage_used_in_bytes is not None:
            pulumi.set(__self__, "disk_storage_used_in_bytes", disk_storage_used_in_bytes)
        if is_collocated is not None:
            pulumi.set(__self__, "is_collocated", is_collocated)
        if is_present_on_cloud is not None:
            pulumi.set(__self__, "is_present_on_cloud", is_present_on_cloud)
        if last_backup_status is not None:
            pulumi.set(__self__, "last_backup_status", last_backup_status)
        if last_refreshed_at is not None:
            pulumi.set(__self__, "last_refreshed_at", last_refreshed_at)
        if oldest_recovery_point is not None:
            pulumi.set(__self__, "oldest_recovery_point", oldest_recovery_point)
        if on_premise_latest_recovery_point is not None:
            pulumi.set(__self__, "on_premise_latest_recovery_point", on_premise_latest_recovery_point)
        if on_premise_oldest_recovery_point is not None:
            pulumi.set(__self__, "on_premise_oldest_recovery_point", on_premise_oldest_recovery_point)
        if on_premise_recovery_point_count is not None:
            pulumi.set(__self__, "on_premise_recovery_point_count", on_premise_recovery_point_count)
        if protectable_object_load_path is not None:
            pulumi.set(__self__, "protectable_object_load_path", protectable_object_load_path)
        if protected is not None:
            pulumi.set(__self__, "protected", protected)
        if protection_group_name is not None:
            pulumi.set(__self__, "protection_group_name", protection_group_name)
        if recovery_point_count is not None:
            pulumi.set(__self__, "recovery_point_count", recovery_point_count)
        if total_disk_storage_size_in_bytes is not None:
            pulumi.set(__self__, "total_disk_storage_size_in_bytes", total_disk_storage_size_in_bytes)

    @property
    @pulumi.getter(name="diskStorageUsedInBytes")
    def disk_storage_used_in_bytes(self) -> Optional[str]:
        """
        Used Disk storage in bytes.
        """
        return pulumi.get(self, "disk_storage_used_in_bytes")

    @property
    @pulumi.getter(name="isCollocated")
    def is_collocated(self) -> Optional[bool]:
        """
        To check if backup item is collocated.
        """
        return pulumi.get(self, "is_collocated")

    @property
    @pulumi.getter(name="isPresentOnCloud")
    def is_present_on_cloud(self) -> Optional[bool]:
        """
        To check if backup item is cloud protected.
        """
        return pulumi.get(self, "is_present_on_cloud")

    @property
    @pulumi.getter(name="lastBackupStatus")
    def last_backup_status(self) -> Optional[str]:
        """
        Last backup status information on backup item.
        """
        return pulumi.get(self, "last_backup_status")

    @property
    @pulumi.getter(name="lastRefreshedAt")
    def last_refreshed_at(self) -> Optional[str]:
        """
        Last refresh time on backup item.
        """
        return pulumi.get(self, "last_refreshed_at")

    @property
    @pulumi.getter(name="oldestRecoveryPoint")
    def oldest_recovery_point(self) -> Optional[str]:
        """
        Oldest cloud recovery point time.
        """
        return pulumi.get(self, "oldest_recovery_point")

    @property
    @pulumi.getter(name="onPremiseLatestRecoveryPoint")
    def on_premise_latest_recovery_point(self) -> Optional[str]:
        """
        latest disk recovery point time.
        """
        return pulumi.get(self, "on_premise_latest_recovery_point")

    @property
    @pulumi.getter(name="onPremiseOldestRecoveryPoint")
    def on_premise_oldest_recovery_point(self) -> Optional[str]:
        """
        Oldest disk recovery point time.
        """
        return pulumi.get(self, "on_premise_oldest_recovery_point")

    @property
    @pulumi.getter(name="onPremiseRecoveryPointCount")
    def on_premise_recovery_point_count(self) -> Optional[int]:
        """
        disk recovery point count.
        """
        return pulumi.get(self, "on_premise_recovery_point_count")

    @property
    @pulumi.getter(name="protectableObjectLoadPath")
    def protectable_object_load_path(self) -> Optional[Mapping[str, str]]:
        """
        Attribute to provide information on various DBs.
        """
        return pulumi.get(self, "protectable_object_load_path")

    @property
    @pulumi.getter
    def protected(self) -> Optional[bool]:
        """
        To check if backup item is disk protected.
        """
        return pulumi.get(self, "protected")

    @property
    @pulumi.getter(name="protectionGroupName")
    def protection_group_name(self) -> Optional[str]:
        """
        Protection group name of the backup item.
        """
        return pulumi.get(self, "protection_group_name")

    @property
    @pulumi.getter(name="recoveryPointCount")
    def recovery_point_count(self) -> Optional[int]:
        """
        cloud recovery point count.
        """
        return pulumi.get(self, "recovery_point_count")

    @property
    @pulumi.getter(name="totalDiskStorageSizeInBytes")
    def total_disk_storage_size_in_bytes(self) -> Optional[str]:
        """
        total Disk storage in bytes.
        """
        return pulumi.get(self, "total_disk_storage_size_in_bytes")


@pulumi.output_type
class DPMProtectedItemResponse(dict):
    """
    Additional information on Backup engine specific backup item.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backupEngineName":
            suggest = "backup_engine_name"
        elif key == "backupManagementType":
            suggest = "backup_management_type"
        elif key == "backupSetName":
            suggest = "backup_set_name"
        elif key == "containerName":
            suggest = "container_name"
        elif key == "createMode":
            suggest = "create_mode"
        elif key == "deferredDeleteTimeInUTC":
            suggest = "deferred_delete_time_in_utc"
        elif key == "deferredDeleteTimeRemaining":
            suggest = "deferred_delete_time_remaining"
        elif key == "extendedInfo":
            suggest = "extended_info"
        elif key == "friendlyName":
            suggest = "friendly_name"
        elif key == "isDeferredDeleteScheduleUpcoming":
            suggest = "is_deferred_delete_schedule_upcoming"
        elif key == "isRehydrate":
            suggest = "is_rehydrate"
        elif key == "isScheduledForDeferredDelete":
            suggest = "is_scheduled_for_deferred_delete"
        elif key == "lastRecoveryPoint":
            suggest = "last_recovery_point"
        elif key == "policyId":
            suggest = "policy_id"
        elif key == "protectedItemType":
            suggest = "protected_item_type"
        elif key == "protectionState":
            suggest = "protection_state"
        elif key == "sourceResourceId":
            suggest = "source_resource_id"
        elif key == "workloadType":
            suggest = "workload_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DPMProtectedItemResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DPMProtectedItemResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DPMProtectedItemResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backup_engine_name: Optional[str] = None,
                 backup_management_type: Optional[str] = None,
                 backup_set_name: Optional[str] = None,
                 container_name: Optional[str] = None,
                 create_mode: Optional[str] = None,
                 deferred_delete_time_in_utc: Optional[str] = None,
                 deferred_delete_time_remaining: Optional[str] = None,
                 extended_info: Optional['outputs.DPMProtectedItemExtendedInfoResponse'] = None,
                 friendly_name: Optional[str] = None,
                 is_deferred_delete_schedule_upcoming: Optional[bool] = None,
                 is_rehydrate: Optional[bool] = None,
                 is_scheduled_for_deferred_delete: Optional[bool] = None,
                 last_recovery_point: Optional[str] = None,
                 policy_id: Optional[str] = None,
                 protected_item_type: Optional[str] = None,
                 protection_state: Optional[str] = None,
                 source_resource_id: Optional[str] = None,
                 workload_type: Optional[str] = None):
        """
        Additional information on Backup engine specific backup item.
        :param str backup_engine_name: Backup Management server protecting this backup item
        :param str backup_management_type: Type of backup management for the backed up item.
        :param str backup_set_name: Name of the backup set the backup item belongs to
        :param str container_name: Unique name of container
        :param str create_mode: Create mode to indicate recovery of existing soft deleted data source or creation of new data source.
        :param str deferred_delete_time_in_utc: Time for deferred deletion in UTC
        :param str deferred_delete_time_remaining: Time remaining before the DS marked for deferred delete is permanently deleted
        :param 'DPMProtectedItemExtendedInfoResponse' extended_info: Extended info of the backup item.
        :param str friendly_name: Friendly name of the managed item
        :param bool is_deferred_delete_schedule_upcoming: Flag to identify whether the deferred deleted DS is to be purged soon
        :param bool is_rehydrate: Flag to identify that deferred deleted DS is to be moved into Pause state
        :param bool is_scheduled_for_deferred_delete: Flag to identify whether the DS is scheduled for deferred delete
        :param str last_recovery_point: Timestamp when the last (latest) backup copy was created for this backup item.
        :param str policy_id: ID of the backup policy with which this item is backed up.
        :param str protected_item_type: backup item type.
               Expected value is 'DPMProtectedItem'.
        :param str protection_state: Protection state of the backup engine
        :param str source_resource_id: ARM ID of the resource to be backed up.
        :param str workload_type: Type of workload this item represents.
        """
        if backup_engine_name is not None:
            pulumi.set(__self__, "backup_engine_name", backup_engine_name)
        if backup_management_type is not None:
            pulumi.set(__self__, "backup_management_type", backup_management_type)
        if backup_set_name is not None:
            pulumi.set(__self__, "backup_set_name", backup_set_name)
        if container_name is not None:
            pulumi.set(__self__, "container_name", container_name)
        if create_mode is not None:
            pulumi.set(__self__, "create_mode", create_mode)
        if deferred_delete_time_in_utc is not None:
            pulumi.set(__self__, "deferred_delete_time_in_utc", deferred_delete_time_in_utc)
        if deferred_delete_time_remaining is not None:
            pulumi.set(__self__, "deferred_delete_time_remaining", deferred_delete_time_remaining)
        if extended_info is not None:
            pulumi.set(__self__, "extended_info", extended_info)
        if friendly_name is not None:
            pulumi.set(__self__, "friendly_name", friendly_name)
        if is_deferred_delete_schedule_upcoming is not None:
            pulumi.set(__self__, "is_deferred_delete_schedule_upcoming", is_deferred_delete_schedule_upcoming)
        if is_rehydrate is not None:
            pulumi.set(__self__, "is_rehydrate", is_rehydrate)
        if is_scheduled_for_deferred_delete is not None:
            pulumi.set(__self__, "is_scheduled_for_deferred_delete", is_scheduled_for_deferred_delete)
        if last_recovery_point is not None:
            pulumi.set(__self__, "last_recovery_point", last_recovery_point)
        if policy_id is not None:
            pulumi.set(__self__, "policy_id", policy_id)
        if protected_item_type is not None:
            pulumi.set(__self__, "protected_item_type", 'DPMProtectedItem')
        if protection_state is not None:
            pulumi.set(__self__, "protection_state", protection_state)
        if source_resource_id is not None:
            pulumi.set(__self__, "source_resource_id", source_resource_id)
        if workload_type is not None:
            pulumi.set(__self__, "workload_type", workload_type)

    @property
    @pulumi.getter(name="backupEngineName")
    def backup_engine_name(self) -> Optional[str]:
        """
        Backup Management server protecting this backup item
        """
        return pulumi.get(self, "backup_engine_name")

    @property
    @pulumi.getter(name="backupManagementType")
    def backup_management_type(self) -> Optional[str]:
        """
        Type of backup management for the backed up item.
        """
        return pulumi.get(self, "backup_management_type")

    @property
    @pulumi.getter(name="backupSetName")
    def backup_set_name(self) -> Optional[str]:
        """
        Name of the backup set the backup item belongs to
        """
        return pulumi.get(self, "backup_set_name")

    @property
    @pulumi.getter(name="containerName")
    def container_name(self) -> Optional[str]:
        """
        Unique name of container
        """
        return pulumi.get(self, "container_name")

    @property
    @pulumi.getter(name="createMode")
    def create_mode(self) -> Optional[str]:
        """
        Create mode to indicate recovery of existing soft deleted data source or creation of new data source.
        """
        return pulumi.get(self, "create_mode")

    @property
    @pulumi.getter(name="deferredDeleteTimeInUTC")
    def deferred_delete_time_in_utc(self) -> Optional[str]:
        """
        Time for deferred deletion in UTC
        """
        return pulumi.get(self, "deferred_delete_time_in_utc")

    @property
    @pulumi.getter(name="deferredDeleteTimeRemaining")
    def deferred_delete_time_remaining(self) -> Optional[str]:
        """
        Time remaining before the DS marked for deferred delete is permanently deleted
        """
        return pulumi.get(self, "deferred_delete_time_remaining")

    @property
    @pulumi.getter(name="extendedInfo")
    def extended_info(self) -> Optional['outputs.DPMProtectedItemExtendedInfoResponse']:
        """
        Extended info of the backup item.
        """
        return pulumi.get(self, "extended_info")

    @property
    @pulumi.getter(name="friendlyName")
    def friendly_name(self) -> Optional[str]:
        """
        Friendly name of the managed item
        """
        return pulumi.get(self, "friendly_name")

    @property
    @pulumi.getter(name="isDeferredDeleteScheduleUpcoming")
    def is_deferred_delete_schedule_upcoming(self) -> Optional[bool]:
        """
        Flag to identify whether the deferred deleted DS is to be purged soon
        """
        return pulumi.get(self, "is_deferred_delete_schedule_upcoming")

    @property
    @pulumi.getter(name="isRehydrate")
    def is_rehydrate(self) -> Optional[bool]:
        """
        Flag to identify that deferred deleted DS is to be moved into Pause state
        """
        return pulumi.get(self, "is_rehydrate")

    @property
    @pulumi.getter(name="isScheduledForDeferredDelete")
    def is_scheduled_for_deferred_delete(self) -> Optional[bool]:
        """
        Flag to identify whether the DS is scheduled for deferred delete
        """
        return pulumi.get(self, "is_scheduled_for_deferred_delete")

    @property
    @pulumi.getter(name="lastRecoveryPoint")
    def last_recovery_point(self) -> Optional[str]:
        """
        Timestamp when the last (latest) backup copy was created for this backup item.
        """
        return pulumi.get(self, "last_recovery_point")

    @property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> Optional[str]:
        """
        ID of the backup policy with which this item is backed up.
        """
        return pulumi.get(self, "policy_id")

    @property
    @pulumi.getter(name="protectedItemType")
    def protected_item_type(self) -> Optional[str]:
        """
        backup item type.
        Expected value is 'DPMProtectedItem'.
        """
        return pulumi.get(self, "protected_item_type")

    @property
    @pulumi.getter(name="protectionState")
    def protection_state(self) -> Optional[str]:
        """
        Protection state of the backup engine
        """
        return pulumi.get(self, "protection_state")

    @property
    @pulumi.getter(name="sourceResourceId")
    def source_resource_id(self) -> Optional[str]:
        """
        ARM ID of the resource to be backed up.
        """
        return pulumi.get(self, "source_resource_id")

    @property
    @pulumi.getter(name="workloadType")
    def workload_type(self) -> Optional[str]:
        """
        Type of workload this item represents.
        """
        return pulumi.get(self, "workload_type")


@pulumi.output_type
class DiskExclusionPropertiesResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "diskLunList":
            suggest = "disk_lun_list"
        elif key == "isInclusionList":
            suggest = "is_inclusion_list"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DiskExclusionPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DiskExclusionPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DiskExclusionPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 disk_lun_list: Optional[Sequence[int]] = None,
                 is_inclusion_list: Optional[bool] = None):
        """
        :param Sequence[int] disk_lun_list: List of Disks' Logical Unit Numbers (LUN) to be used for VM Protection.
        :param bool is_inclusion_list: Flag to indicate whether DiskLunList is to be included/ excluded from backup.
        """
        if disk_lun_list is not None:
            pulumi.set(__self__, "disk_lun_list", disk_lun_list)
        if is_inclusion_list is not None:
            pulumi.set(__self__, "is_inclusion_list", is_inclusion_list)

    @property
    @pulumi.getter(name="diskLunList")
    def disk_lun_list(self) -> Optional[Sequence[int]]:
        """
        List of Disks' Logical Unit Numbers (LUN) to be used for VM Protection.
        """
        return pulumi.get(self, "disk_lun_list")

    @property
    @pulumi.getter(name="isInclusionList")
    def is_inclusion_list(self) -> Optional[bool]:
        """
        Flag to indicate whether DiskLunList is to be included/ excluded from backup.
        """
        return pulumi.get(self, "is_inclusion_list")


@pulumi.output_type
class ErrorDetailResponse(dict):
    """
    Error Detail class which encapsulates Code, Message and Recommendations.
    """
    def __init__(__self__, *,
                 code: str,
                 message: str,
                 recommendations: Sequence[str]):
        """
        Error Detail class which encapsulates Code, Message and Recommendations.
        :param str code: Error code.
        :param str message: Error Message related to the Code.
        :param Sequence[str] recommendations: List of recommendation strings.
        """
        pulumi.set(__self__, "code", code)
        pulumi.set(__self__, "message", message)
        pulumi.set(__self__, "recommendations", recommendations)

    @property
    @pulumi.getter
    def code(self) -> str:
        """
        Error code.
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter
    def message(self) -> str:
        """
        Error Message related to the Code.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def recommendations(self) -> Sequence[str]:
        """
        List of recommendation strings.
        """
        return pulumi.get(self, "recommendations")


@pulumi.output_type
class ExtendedPropertiesResponse(dict):
    """
    Extended Properties for Azure IaasVM Backup.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "diskExclusionProperties":
            suggest = "disk_exclusion_properties"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ExtendedPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ExtendedPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ExtendedPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 disk_exclusion_properties: Optional['outputs.DiskExclusionPropertiesResponse'] = None):
        """
        Extended Properties for Azure IaasVM Backup.
        :param 'DiskExclusionPropertiesResponse' disk_exclusion_properties: Extended Properties for Disk Exclusion.
        """
        if disk_exclusion_properties is not None:
            pulumi.set(__self__, "disk_exclusion_properties", disk_exclusion_properties)

    @property
    @pulumi.getter(name="diskExclusionProperties")
    def disk_exclusion_properties(self) -> Optional['outputs.DiskExclusionPropertiesResponse']:
        """
        Extended Properties for Disk Exclusion.
        """
        return pulumi.get(self, "disk_exclusion_properties")


@pulumi.output_type
class GenericProtectedItemResponse(dict):
    """
    Base class for backup items.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backupManagementType":
            suggest = "backup_management_type"
        elif key == "backupSetName":
            suggest = "backup_set_name"
        elif key == "containerName":
            suggest = "container_name"
        elif key == "createMode":
            suggest = "create_mode"
        elif key == "deferredDeleteTimeInUTC":
            suggest = "deferred_delete_time_in_utc"
        elif key == "deferredDeleteTimeRemaining":
            suggest = "deferred_delete_time_remaining"
        elif key == "fabricName":
            suggest = "fabric_name"
        elif key == "friendlyName":
            suggest = "friendly_name"
        elif key == "isDeferredDeleteScheduleUpcoming":
            suggest = "is_deferred_delete_schedule_upcoming"
        elif key == "isRehydrate":
            suggest = "is_rehydrate"
        elif key == "isScheduledForDeferredDelete":
            suggest = "is_scheduled_for_deferred_delete"
        elif key == "lastRecoveryPoint":
            suggest = "last_recovery_point"
        elif key == "policyId":
            suggest = "policy_id"
        elif key == "policyState":
            suggest = "policy_state"
        elif key == "protectedItemId":
            suggest = "protected_item_id"
        elif key == "protectedItemType":
            suggest = "protected_item_type"
        elif key == "protectionState":
            suggest = "protection_state"
        elif key == "sourceAssociations":
            suggest = "source_associations"
        elif key == "sourceResourceId":
            suggest = "source_resource_id"
        elif key == "workloadType":
            suggest = "workload_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GenericProtectedItemResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GenericProtectedItemResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GenericProtectedItemResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backup_management_type: Optional[str] = None,
                 backup_set_name: Optional[str] = None,
                 container_name: Optional[str] = None,
                 create_mode: Optional[str] = None,
                 deferred_delete_time_in_utc: Optional[str] = None,
                 deferred_delete_time_remaining: Optional[str] = None,
                 fabric_name: Optional[str] = None,
                 friendly_name: Optional[str] = None,
                 is_deferred_delete_schedule_upcoming: Optional[bool] = None,
                 is_rehydrate: Optional[bool] = None,
                 is_scheduled_for_deferred_delete: Optional[bool] = None,
                 last_recovery_point: Optional[str] = None,
                 policy_id: Optional[str] = None,
                 policy_state: Optional[str] = None,
                 protected_item_id: Optional[float] = None,
                 protected_item_type: Optional[str] = None,
                 protection_state: Optional[str] = None,
                 source_associations: Optional[Mapping[str, str]] = None,
                 source_resource_id: Optional[str] = None,
                 workload_type: Optional[str] = None):
        """
        Base class for backup items.
        :param str backup_management_type: Type of backup management for the backed up item.
        :param str backup_set_name: Name of the backup set the backup item belongs to
        :param str container_name: Unique name of container
        :param str create_mode: Create mode to indicate recovery of existing soft deleted data source or creation of new data source.
        :param str deferred_delete_time_in_utc: Time for deferred deletion in UTC
        :param str deferred_delete_time_remaining: Time remaining before the DS marked for deferred delete is permanently deleted
        :param str fabric_name: Name of this backup item's fabric.
        :param str friendly_name: Friendly name of the container.
        :param bool is_deferred_delete_schedule_upcoming: Flag to identify whether the deferred deleted DS is to be purged soon
        :param bool is_rehydrate: Flag to identify that deferred deleted DS is to be moved into Pause state
        :param bool is_scheduled_for_deferred_delete: Flag to identify whether the DS is scheduled for deferred delete
        :param str last_recovery_point: Timestamp when the last (latest) backup copy was created for this backup item.
        :param str policy_id: ID of the backup policy with which this item is backed up.
        :param str policy_state: Indicates consistency of policy object and policy applied to this backup item.
        :param float protected_item_id: Data Plane Service ID of the protected item.
        :param str protected_item_type: backup item type.
               Expected value is 'GenericProtectedItem'.
        :param str protection_state: Backup state of this backup item.
        :param Mapping[str, str] source_associations: Loosely coupled (type, value) associations (example - parent of a protected item)
        :param str source_resource_id: ARM ID of the resource to be backed up.
        :param str workload_type: Type of workload this item represents.
        """
        if backup_management_type is not None:
            pulumi.set(__self__, "backup_management_type", backup_management_type)
        if backup_set_name is not None:
            pulumi.set(__self__, "backup_set_name", backup_set_name)
        if container_name is not None:
            pulumi.set(__self__, "container_name", container_name)
        if create_mode is not None:
            pulumi.set(__self__, "create_mode", create_mode)
        if deferred_delete_time_in_utc is not None:
            pulumi.set(__self__, "deferred_delete_time_in_utc", deferred_delete_time_in_utc)
        if deferred_delete_time_remaining is not None:
            pulumi.set(__self__, "deferred_delete_time_remaining", deferred_delete_time_remaining)
        if fabric_name is not None:
            pulumi.set(__self__, "fabric_name", fabric_name)
        if friendly_name is not None:
            pulumi.set(__self__, "friendly_name", friendly_name)
        if is_deferred_delete_schedule_upcoming is not None:
            pulumi.set(__self__, "is_deferred_delete_schedule_upcoming", is_deferred_delete_schedule_upcoming)
        if is_rehydrate is not None:
            pulumi.set(__self__, "is_rehydrate", is_rehydrate)
        if is_scheduled_for_deferred_delete is not None:
            pulumi.set(__self__, "is_scheduled_for_deferred_delete", is_scheduled_for_deferred_delete)
        if last_recovery_point is not None:
            pulumi.set(__self__, "last_recovery_point", last_recovery_point)
        if policy_id is not None:
            pulumi.set(__self__, "policy_id", policy_id)
        if policy_state is not None:
            pulumi.set(__self__, "policy_state", policy_state)
        if protected_item_id is not None:
            pulumi.set(__self__, "protected_item_id", protected_item_id)
        if protected_item_type is not None:
            pulumi.set(__self__, "protected_item_type", 'GenericProtectedItem')
        if protection_state is not None:
            pulumi.set(__self__, "protection_state", protection_state)
        if source_associations is not None:
            pulumi.set(__self__, "source_associations", source_associations)
        if source_resource_id is not None:
            pulumi.set(__self__, "source_resource_id", source_resource_id)
        if workload_type is not None:
            pulumi.set(__self__, "workload_type", workload_type)

    @property
    @pulumi.getter(name="backupManagementType")
    def backup_management_type(self) -> Optional[str]:
        """
        Type of backup management for the backed up item.
        """
        return pulumi.get(self, "backup_management_type")

    @property
    @pulumi.getter(name="backupSetName")
    def backup_set_name(self) -> Optional[str]:
        """
        Name of the backup set the backup item belongs to
        """
        return pulumi.get(self, "backup_set_name")

    @property
    @pulumi.getter(name="containerName")
    def container_name(self) -> Optional[str]:
        """
        Unique name of container
        """
        return pulumi.get(self, "container_name")

    @property
    @pulumi.getter(name="createMode")
    def create_mode(self) -> Optional[str]:
        """
        Create mode to indicate recovery of existing soft deleted data source or creation of new data source.
        """
        return pulumi.get(self, "create_mode")

    @property
    @pulumi.getter(name="deferredDeleteTimeInUTC")
    def deferred_delete_time_in_utc(self) -> Optional[str]:
        """
        Time for deferred deletion in UTC
        """
        return pulumi.get(self, "deferred_delete_time_in_utc")

    @property
    @pulumi.getter(name="deferredDeleteTimeRemaining")
    def deferred_delete_time_remaining(self) -> Optional[str]:
        """
        Time remaining before the DS marked for deferred delete is permanently deleted
        """
        return pulumi.get(self, "deferred_delete_time_remaining")

    @property
    @pulumi.getter(name="fabricName")
    def fabric_name(self) -> Optional[str]:
        """
        Name of this backup item's fabric.
        """
        return pulumi.get(self, "fabric_name")

    @property
    @pulumi.getter(name="friendlyName")
    def friendly_name(self) -> Optional[str]:
        """
        Friendly name of the container.
        """
        return pulumi.get(self, "friendly_name")

    @property
    @pulumi.getter(name="isDeferredDeleteScheduleUpcoming")
    def is_deferred_delete_schedule_upcoming(self) -> Optional[bool]:
        """
        Flag to identify whether the deferred deleted DS is to be purged soon
        """
        return pulumi.get(self, "is_deferred_delete_schedule_upcoming")

    @property
    @pulumi.getter(name="isRehydrate")
    def is_rehydrate(self) -> Optional[bool]:
        """
        Flag to identify that deferred deleted DS is to be moved into Pause state
        """
        return pulumi.get(self, "is_rehydrate")

    @property
    @pulumi.getter(name="isScheduledForDeferredDelete")
    def is_scheduled_for_deferred_delete(self) -> Optional[bool]:
        """
        Flag to identify whether the DS is scheduled for deferred delete
        """
        return pulumi.get(self, "is_scheduled_for_deferred_delete")

    @property
    @pulumi.getter(name="lastRecoveryPoint")
    def last_recovery_point(self) -> Optional[str]:
        """
        Timestamp when the last (latest) backup copy was created for this backup item.
        """
        return pulumi.get(self, "last_recovery_point")

    @property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> Optional[str]:
        """
        ID of the backup policy with which this item is backed up.
        """
        return pulumi.get(self, "policy_id")

    @property
    @pulumi.getter(name="policyState")
    def policy_state(self) -> Optional[str]:
        """
        Indicates consistency of policy object and policy applied to this backup item.
        """
        return pulumi.get(self, "policy_state")

    @property
    @pulumi.getter(name="protectedItemId")
    def protected_item_id(self) -> Optional[float]:
        """
        Data Plane Service ID of the protected item.
        """
        return pulumi.get(self, "protected_item_id")

    @property
    @pulumi.getter(name="protectedItemType")
    def protected_item_type(self) -> Optional[str]:
        """
        backup item type.
        Expected value is 'GenericProtectedItem'.
        """
        return pulumi.get(self, "protected_item_type")

    @property
    @pulumi.getter(name="protectionState")
    def protection_state(self) -> Optional[str]:
        """
        Backup state of this backup item.
        """
        return pulumi.get(self, "protection_state")

    @property
    @pulumi.getter(name="sourceAssociations")
    def source_associations(self) -> Optional[Mapping[str, str]]:
        """
        Loosely coupled (type, value) associations (example - parent of a protected item)
        """
        return pulumi.get(self, "source_associations")

    @property
    @pulumi.getter(name="sourceResourceId")
    def source_resource_id(self) -> Optional[str]:
        """
        ARM ID of the resource to be backed up.
        """
        return pulumi.get(self, "source_resource_id")

    @property
    @pulumi.getter(name="workloadType")
    def workload_type(self) -> Optional[str]:
        """
        Type of workload this item represents.
        """
        return pulumi.get(self, "workload_type")


@pulumi.output_type
class MabFileFolderProtectedItemExtendedInfoResponse(dict):
    """
    Additional information on the backed up item.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lastRefreshedAt":
            suggest = "last_refreshed_at"
        elif key == "oldestRecoveryPoint":
            suggest = "oldest_recovery_point"
        elif key == "recoveryPointCount":
            suggest = "recovery_point_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MabFileFolderProtectedItemExtendedInfoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MabFileFolderProtectedItemExtendedInfoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MabFileFolderProtectedItemExtendedInfoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 last_refreshed_at: Optional[str] = None,
                 oldest_recovery_point: Optional[str] = None,
                 recovery_point_count: Optional[int] = None):
        """
        Additional information on the backed up item.
        :param str last_refreshed_at: Last time when the agent data synced to service.
        :param str oldest_recovery_point: The oldest backup copy available.
        :param int recovery_point_count: Number of backup copies associated with the backup item.
        """
        if last_refreshed_at is not None:
            pulumi.set(__self__, "last_refreshed_at", last_refreshed_at)
        if oldest_recovery_point is not None:
            pulumi.set(__self__, "oldest_recovery_point", oldest_recovery_point)
        if recovery_point_count is not None:
            pulumi.set(__self__, "recovery_point_count", recovery_point_count)

    @property
    @pulumi.getter(name="lastRefreshedAt")
    def last_refreshed_at(self) -> Optional[str]:
        """
        Last time when the agent data synced to service.
        """
        return pulumi.get(self, "last_refreshed_at")

    @property
    @pulumi.getter(name="oldestRecoveryPoint")
    def oldest_recovery_point(self) -> Optional[str]:
        """
        The oldest backup copy available.
        """
        return pulumi.get(self, "oldest_recovery_point")

    @property
    @pulumi.getter(name="recoveryPointCount")
    def recovery_point_count(self) -> Optional[int]:
        """
        Number of backup copies associated with the backup item.
        """
        return pulumi.get(self, "recovery_point_count")


@pulumi.output_type
class MabFileFolderProtectedItemResponse(dict):
    """
    MAB workload-specific backup item.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backupManagementType":
            suggest = "backup_management_type"
        elif key == "backupSetName":
            suggest = "backup_set_name"
        elif key == "computerName":
            suggest = "computer_name"
        elif key == "containerName":
            suggest = "container_name"
        elif key == "createMode":
            suggest = "create_mode"
        elif key == "deferredDeleteSyncTimeInUTC":
            suggest = "deferred_delete_sync_time_in_utc"
        elif key == "deferredDeleteTimeInUTC":
            suggest = "deferred_delete_time_in_utc"
        elif key == "deferredDeleteTimeRemaining":
            suggest = "deferred_delete_time_remaining"
        elif key == "extendedInfo":
            suggest = "extended_info"
        elif key == "friendlyName":
            suggest = "friendly_name"
        elif key == "isDeferredDeleteScheduleUpcoming":
            suggest = "is_deferred_delete_schedule_upcoming"
        elif key == "isRehydrate":
            suggest = "is_rehydrate"
        elif key == "isScheduledForDeferredDelete":
            suggest = "is_scheduled_for_deferred_delete"
        elif key == "lastBackupStatus":
            suggest = "last_backup_status"
        elif key == "lastBackupTime":
            suggest = "last_backup_time"
        elif key == "lastRecoveryPoint":
            suggest = "last_recovery_point"
        elif key == "policyId":
            suggest = "policy_id"
        elif key == "protectedItemType":
            suggest = "protected_item_type"
        elif key == "protectionState":
            suggest = "protection_state"
        elif key == "sourceResourceId":
            suggest = "source_resource_id"
        elif key == "workloadType":
            suggest = "workload_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MabFileFolderProtectedItemResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MabFileFolderProtectedItemResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MabFileFolderProtectedItemResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backup_management_type: Optional[str] = None,
                 backup_set_name: Optional[str] = None,
                 computer_name: Optional[str] = None,
                 container_name: Optional[str] = None,
                 create_mode: Optional[str] = None,
                 deferred_delete_sync_time_in_utc: Optional[float] = None,
                 deferred_delete_time_in_utc: Optional[str] = None,
                 deferred_delete_time_remaining: Optional[str] = None,
                 extended_info: Optional['outputs.MabFileFolderProtectedItemExtendedInfoResponse'] = None,
                 friendly_name: Optional[str] = None,
                 is_deferred_delete_schedule_upcoming: Optional[bool] = None,
                 is_rehydrate: Optional[bool] = None,
                 is_scheduled_for_deferred_delete: Optional[bool] = None,
                 last_backup_status: Optional[str] = None,
                 last_backup_time: Optional[str] = None,
                 last_recovery_point: Optional[str] = None,
                 policy_id: Optional[str] = None,
                 protected_item_type: Optional[str] = None,
                 protection_state: Optional[str] = None,
                 source_resource_id: Optional[str] = None,
                 workload_type: Optional[str] = None):
        """
        MAB workload-specific backup item.
        :param str backup_management_type: Type of backup management for the backed up item.
        :param str backup_set_name: Name of the backup set the backup item belongs to
        :param str computer_name: Name of the computer associated with this backup item.
        :param str container_name: Unique name of container
        :param str create_mode: Create mode to indicate recovery of existing soft deleted data source or creation of new data source.
        :param float deferred_delete_sync_time_in_utc: Sync time for deferred deletion in UTC
        :param str deferred_delete_time_in_utc: Time for deferred deletion in UTC
        :param str deferred_delete_time_remaining: Time remaining before the DS marked for deferred delete is permanently deleted
        :param 'MabFileFolderProtectedItemExtendedInfoResponse' extended_info: Additional information with this backup item.
        :param str friendly_name: Friendly name of this backup item.
        :param bool is_deferred_delete_schedule_upcoming: Flag to identify whether the deferred deleted DS is to be purged soon
        :param bool is_rehydrate: Flag to identify that deferred deleted DS is to be moved into Pause state
        :param bool is_scheduled_for_deferred_delete: Flag to identify whether the DS is scheduled for deferred delete
        :param str last_backup_status: Status of last backup operation.
        :param str last_backup_time: Timestamp of the last backup operation on this backup item.
        :param str last_recovery_point: Timestamp when the last (latest) backup copy was created for this backup item.
        :param str policy_id: ID of the backup policy with which this item is backed up.
        :param str protected_item_type: backup item type.
               Expected value is 'MabFileFolderProtectedItem'.
        :param str protection_state: Protected, ProtectionStopped, IRPending or ProtectionError
        :param str source_resource_id: ARM ID of the resource to be backed up.
        :param str workload_type: Type of workload this item represents.
        """
        if backup_management_type is not None:
            pulumi.set(__self__, "backup_management_type", backup_management_type)
        if backup_set_name is not None:
            pulumi.set(__self__, "backup_set_name", backup_set_name)
        if computer_name is not None:
            pulumi.set(__self__, "computer_name", computer_name)
        if container_name is not None:
            pulumi.set(__self__, "container_name", container_name)
        if create_mode is not None:
            pulumi.set(__self__, "create_mode", create_mode)
        if deferred_delete_sync_time_in_utc is not None:
            pulumi.set(__self__, "deferred_delete_sync_time_in_utc", deferred_delete_sync_time_in_utc)
        if deferred_delete_time_in_utc is not None:
            pulumi.set(__self__, "deferred_delete_time_in_utc", deferred_delete_time_in_utc)
        if deferred_delete_time_remaining is not None:
            pulumi.set(__self__, "deferred_delete_time_remaining", deferred_delete_time_remaining)
        if extended_info is not None:
            pulumi.set(__self__, "extended_info", extended_info)
        if friendly_name is not None:
            pulumi.set(__self__, "friendly_name", friendly_name)
        if is_deferred_delete_schedule_upcoming is not None:
            pulumi.set(__self__, "is_deferred_delete_schedule_upcoming", is_deferred_delete_schedule_upcoming)
        if is_rehydrate is not None:
            pulumi.set(__self__, "is_rehydrate", is_rehydrate)
        if is_scheduled_for_deferred_delete is not None:
            pulumi.set(__self__, "is_scheduled_for_deferred_delete", is_scheduled_for_deferred_delete)
        if last_backup_status is not None:
            pulumi.set(__self__, "last_backup_status", last_backup_status)
        if last_backup_time is not None:
            pulumi.set(__self__, "last_backup_time", last_backup_time)
        if last_recovery_point is not None:
            pulumi.set(__self__, "last_recovery_point", last_recovery_point)
        if policy_id is not None:
            pulumi.set(__self__, "policy_id", policy_id)
        if protected_item_type is not None:
            pulumi.set(__self__, "protected_item_type", 'MabFileFolderProtectedItem')
        if protection_state is not None:
            pulumi.set(__self__, "protection_state", protection_state)
        if source_resource_id is not None:
            pulumi.set(__self__, "source_resource_id", source_resource_id)
        if workload_type is not None:
            pulumi.set(__self__, "workload_type", workload_type)

    @property
    @pulumi.getter(name="backupManagementType")
    def backup_management_type(self) -> Optional[str]:
        """
        Type of backup management for the backed up item.
        """
        return pulumi.get(self, "backup_management_type")

    @property
    @pulumi.getter(name="backupSetName")
    def backup_set_name(self) -> Optional[str]:
        """
        Name of the backup set the backup item belongs to
        """
        return pulumi.get(self, "backup_set_name")

    @property
    @pulumi.getter(name="computerName")
    def computer_name(self) -> Optional[str]:
        """
        Name of the computer associated with this backup item.
        """
        return pulumi.get(self, "computer_name")

    @property
    @pulumi.getter(name="containerName")
    def container_name(self) -> Optional[str]:
        """
        Unique name of container
        """
        return pulumi.get(self, "container_name")

    @property
    @pulumi.getter(name="createMode")
    def create_mode(self) -> Optional[str]:
        """
        Create mode to indicate recovery of existing soft deleted data source or creation of new data source.
        """
        return pulumi.get(self, "create_mode")

    @property
    @pulumi.getter(name="deferredDeleteSyncTimeInUTC")
    def deferred_delete_sync_time_in_utc(self) -> Optional[float]:
        """
        Sync time for deferred deletion in UTC
        """
        return pulumi.get(self, "deferred_delete_sync_time_in_utc")

    @property
    @pulumi.getter(name="deferredDeleteTimeInUTC")
    def deferred_delete_time_in_utc(self) -> Optional[str]:
        """
        Time for deferred deletion in UTC
        """
        return pulumi.get(self, "deferred_delete_time_in_utc")

    @property
    @pulumi.getter(name="deferredDeleteTimeRemaining")
    def deferred_delete_time_remaining(self) -> Optional[str]:
        """
        Time remaining before the DS marked for deferred delete is permanently deleted
        """
        return pulumi.get(self, "deferred_delete_time_remaining")

    @property
    @pulumi.getter(name="extendedInfo")
    def extended_info(self) -> Optional['outputs.MabFileFolderProtectedItemExtendedInfoResponse']:
        """
        Additional information with this backup item.
        """
        return pulumi.get(self, "extended_info")

    @property
    @pulumi.getter(name="friendlyName")
    def friendly_name(self) -> Optional[str]:
        """
        Friendly name of this backup item.
        """
        return pulumi.get(self, "friendly_name")

    @property
    @pulumi.getter(name="isDeferredDeleteScheduleUpcoming")
    def is_deferred_delete_schedule_upcoming(self) -> Optional[bool]:
        """
        Flag to identify whether the deferred deleted DS is to be purged soon
        """
        return pulumi.get(self, "is_deferred_delete_schedule_upcoming")

    @property
    @pulumi.getter(name="isRehydrate")
    def is_rehydrate(self) -> Optional[bool]:
        """
        Flag to identify that deferred deleted DS is to be moved into Pause state
        """
        return pulumi.get(self, "is_rehydrate")

    @property
    @pulumi.getter(name="isScheduledForDeferredDelete")
    def is_scheduled_for_deferred_delete(self) -> Optional[bool]:
        """
        Flag to identify whether the DS is scheduled for deferred delete
        """
        return pulumi.get(self, "is_scheduled_for_deferred_delete")

    @property
    @pulumi.getter(name="lastBackupStatus")
    def last_backup_status(self) -> Optional[str]:
        """
        Status of last backup operation.
        """
        return pulumi.get(self, "last_backup_status")

    @property
    @pulumi.getter(name="lastBackupTime")
    def last_backup_time(self) -> Optional[str]:
        """
        Timestamp of the last backup operation on this backup item.
        """
        return pulumi.get(self, "last_backup_time")

    @property
    @pulumi.getter(name="lastRecoveryPoint")
    def last_recovery_point(self) -> Optional[str]:
        """
        Timestamp when the last (latest) backup copy was created for this backup item.
        """
        return pulumi.get(self, "last_recovery_point")

    @property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> Optional[str]:
        """
        ID of the backup policy with which this item is backed up.
        """
        return pulumi.get(self, "policy_id")

    @property
    @pulumi.getter(name="protectedItemType")
    def protected_item_type(self) -> Optional[str]:
        """
        backup item type.
        Expected value is 'MabFileFolderProtectedItem'.
        """
        return pulumi.get(self, "protected_item_type")

    @property
    @pulumi.getter(name="protectionState")
    def protection_state(self) -> Optional[str]:
        """
        Protected, ProtectionStopped, IRPending or ProtectionError
        """
        return pulumi.get(self, "protection_state")

    @property
    @pulumi.getter(name="sourceResourceId")
    def source_resource_id(self) -> Optional[str]:
        """
        ARM ID of the resource to be backed up.
        """
        return pulumi.get(self, "source_resource_id")

    @property
    @pulumi.getter(name="workloadType")
    def workload_type(self) -> Optional[str]:
        """
        Type of workload this item represents.
        """
        return pulumi.get(self, "workload_type")


