# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'AzureIaaSVMProtectionPolicyResponse',
    'AzureSqlProtectionPolicyResponse',
    'DailyRetentionFormatResponse',
    'DailyRetentionScheduleResponse',
    'DayResponse',
    'IdentityDataResponse',
    'LongTermRetentionPolicyResponse',
    'LongTermSchedulePolicyResponse',
    'MabProtectionPolicyResponse',
    'MonthlyRetentionScheduleResponse',
    'PrivateEndpointConnectionVaultPropertiesResponse',
    'PrivateEndpointResponse',
    'RetentionDurationResponse',
    'SimpleRetentionPolicyResponse',
    'SimpleSchedulePolicyResponse',
    'SkuResponse',
    'UpgradeDetailsResponse',
    'VaultPrivateEndpointConnectionResponse',
    'VaultPrivateLinkServiceConnectionStateResponse',
    'VaultPropertiesResponse',
    'WeeklyRetentionFormatResponse',
    'WeeklyRetentionScheduleResponse',
    'YearlyRetentionScheduleResponse',
]

@pulumi.output_type
class AzureIaaSVMProtectionPolicyResponse(dict):
    """
    Azure VM (also known as IaaS VM) workload-specific backup policy.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backupManagementType":
            suggest = "backup_management_type"
        elif key == "protectedItemsCount":
            suggest = "protected_items_count"
        elif key == "retentionPolicy":
            suggest = "retention_policy"
        elif key == "schedulePolicy":
            suggest = "schedule_policy"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureIaaSVMProtectionPolicyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureIaaSVMProtectionPolicyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureIaaSVMProtectionPolicyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backup_management_type: Optional[str] = None,
                 protected_items_count: Optional[int] = None,
                 retention_policy: Optional[Any] = None,
                 schedule_policy: Optional[Any] = None):
        """
        Azure VM (also known as IaaS VM) workload-specific backup policy.
        :param str backup_management_type: This property is used as the discriminator for deciding the specific types in the polymorphic chain of types.
               Expected value is 'AzureIaasVM'.
        :param int protected_items_count: The number of items associated with this policy.
        :param Union['LongTermRetentionPolicyResponse', 'SimpleRetentionPolicyResponse'] retention_policy: The retention policy with the details on backup copy retention ranges.
        :param Union['LongTermSchedulePolicyResponse', 'SimpleSchedulePolicyResponse'] schedule_policy: The backup schedule specified as part of backup policy.
        """
        if backup_management_type is not None:
            pulumi.set(__self__, "backup_management_type", 'AzureIaasVM')
        if protected_items_count is not None:
            pulumi.set(__self__, "protected_items_count", protected_items_count)
        if retention_policy is not None:
            pulumi.set(__self__, "retention_policy", retention_policy)
        if schedule_policy is not None:
            pulumi.set(__self__, "schedule_policy", schedule_policy)

    @property
    @pulumi.getter(name="backupManagementType")
    def backup_management_type(self) -> Optional[str]:
        """
        This property is used as the discriminator for deciding the specific types in the polymorphic chain of types.
        Expected value is 'AzureIaasVM'.
        """
        return pulumi.get(self, "backup_management_type")

    @property
    @pulumi.getter(name="protectedItemsCount")
    def protected_items_count(self) -> Optional[int]:
        """
        The number of items associated with this policy.
        """
        return pulumi.get(self, "protected_items_count")

    @property
    @pulumi.getter(name="retentionPolicy")
    def retention_policy(self) -> Optional[Any]:
        """
        The retention policy with the details on backup copy retention ranges.
        """
        return pulumi.get(self, "retention_policy")

    @property
    @pulumi.getter(name="schedulePolicy")
    def schedule_policy(self) -> Optional[Any]:
        """
        The backup schedule specified as part of backup policy.
        """
        return pulumi.get(self, "schedule_policy")


@pulumi.output_type
class AzureSqlProtectionPolicyResponse(dict):
    """
     The Azure SQL workload-specific backup policy.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backupManagementType":
            suggest = "backup_management_type"
        elif key == "protectedItemsCount":
            suggest = "protected_items_count"
        elif key == "retentionPolicy":
            suggest = "retention_policy"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureSqlProtectionPolicyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureSqlProtectionPolicyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureSqlProtectionPolicyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backup_management_type: Optional[str] = None,
                 protected_items_count: Optional[int] = None,
                 retention_policy: Optional[Any] = None):
        """
         The Azure SQL workload-specific backup policy.
        :param str backup_management_type: This property is used as the discriminator for deciding the specific types in the polymorphic chain of types.
               Expected value is 'AzureSql'.
        :param int protected_items_count: The number of items associated with this policy.
        :param Union['LongTermRetentionPolicyResponse', 'SimpleRetentionPolicyResponse'] retention_policy: The retention policy details.
        """
        if backup_management_type is not None:
            pulumi.set(__self__, "backup_management_type", 'AzureSql')
        if protected_items_count is not None:
            pulumi.set(__self__, "protected_items_count", protected_items_count)
        if retention_policy is not None:
            pulumi.set(__self__, "retention_policy", retention_policy)

    @property
    @pulumi.getter(name="backupManagementType")
    def backup_management_type(self) -> Optional[str]:
        """
        This property is used as the discriminator for deciding the specific types in the polymorphic chain of types.
        Expected value is 'AzureSql'.
        """
        return pulumi.get(self, "backup_management_type")

    @property
    @pulumi.getter(name="protectedItemsCount")
    def protected_items_count(self) -> Optional[int]:
        """
        The number of items associated with this policy.
        """
        return pulumi.get(self, "protected_items_count")

    @property
    @pulumi.getter(name="retentionPolicy")
    def retention_policy(self) -> Optional[Any]:
        """
        The retention policy details.
        """
        return pulumi.get(self, "retention_policy")


@pulumi.output_type
class DailyRetentionFormatResponse(dict):
    """
    Daily retention format.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "daysOfTheMonth":
            suggest = "days_of_the_month"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DailyRetentionFormatResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DailyRetentionFormatResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DailyRetentionFormatResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 days_of_the_month: Optional[Sequence['outputs.DayResponse']] = None):
        """
        Daily retention format.
        :param Sequence['DayResponse'] days_of_the_month: List of days of the month.
        """
        if days_of_the_month is not None:
            pulumi.set(__self__, "days_of_the_month", days_of_the_month)

    @property
    @pulumi.getter(name="daysOfTheMonth")
    def days_of_the_month(self) -> Optional[Sequence['outputs.DayResponse']]:
        """
        List of days of the month.
        """
        return pulumi.get(self, "days_of_the_month")


@pulumi.output_type
class DailyRetentionScheduleResponse(dict):
    """
    Daily retention schedule.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "retentionDuration":
            suggest = "retention_duration"
        elif key == "retentionTimes":
            suggest = "retention_times"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DailyRetentionScheduleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DailyRetentionScheduleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DailyRetentionScheduleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 retention_duration: Optional['outputs.RetentionDurationResponse'] = None,
                 retention_times: Optional[Sequence[str]] = None):
        """
        Daily retention schedule.
        :param 'RetentionDurationResponse' retention_duration: The retention duration of retention policy.
        :param Sequence[str] retention_times: The retention times of retention policy.
        """
        if retention_duration is not None:
            pulumi.set(__self__, "retention_duration", retention_duration)
        if retention_times is not None:
            pulumi.set(__self__, "retention_times", retention_times)

    @property
    @pulumi.getter(name="retentionDuration")
    def retention_duration(self) -> Optional['outputs.RetentionDurationResponse']:
        """
        The retention duration of retention policy.
        """
        return pulumi.get(self, "retention_duration")

    @property
    @pulumi.getter(name="retentionTimes")
    def retention_times(self) -> Optional[Sequence[str]]:
        """
        The retention times of retention policy.
        """
        return pulumi.get(self, "retention_times")


@pulumi.output_type
class DayResponse(dict):
    """
    Day of the week.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isLast":
            suggest = "is_last"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DayResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DayResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DayResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 date: Optional[int] = None,
                 is_last: Optional[bool] = None):
        """
        Day of the week.
        """
        if date is not None:
            pulumi.set(__self__, "date", date)
        if is_last is not None:
            pulumi.set(__self__, "is_last", is_last)

    @property
    @pulumi.getter
    def date(self) -> Optional[int]:
        return pulumi.get(self, "date")

    @property
    @pulumi.getter(name="isLast")
    def is_last(self) -> Optional[bool]:
        return pulumi.get(self, "is_last")


@pulumi.output_type
class IdentityDataResponse(dict):
    """
    Identity for the resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "principalId":
            suggest = "principal_id"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IdentityDataResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IdentityDataResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IdentityDataResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 principal_id: str,
                 tenant_id: str,
                 type: str):
        """
        Identity for the resource.
        :param str principal_id: The principal ID of resource identity.
        :param str tenant_id: The tenant ID of resource.
        :param str type: The identity type.
        """
        pulumi.set(__self__, "principal_id", principal_id)
        pulumi.set(__self__, "tenant_id", tenant_id)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> str:
        """
        The principal ID of resource identity.
        """
        return pulumi.get(self, "principal_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> str:
        """
        The tenant ID of resource.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The identity type.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class LongTermRetentionPolicyResponse(dict):
    """
    Long-term retention policy.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dailySchedule":
            suggest = "daily_schedule"
        elif key == "monthlySchedule":
            suggest = "monthly_schedule"
        elif key == "retentionPolicyType":
            suggest = "retention_policy_type"
        elif key == "weeklySchedule":
            suggest = "weekly_schedule"
        elif key == "yearlySchedule":
            suggest = "yearly_schedule"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LongTermRetentionPolicyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LongTermRetentionPolicyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LongTermRetentionPolicyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 daily_schedule: Optional['outputs.DailyRetentionScheduleResponse'] = None,
                 monthly_schedule: Optional['outputs.MonthlyRetentionScheduleResponse'] = None,
                 retention_policy_type: Optional[str] = None,
                 weekly_schedule: Optional['outputs.WeeklyRetentionScheduleResponse'] = None,
                 yearly_schedule: Optional['outputs.YearlyRetentionScheduleResponse'] = None):
        """
        Long-term retention policy.
        :param 'DailyRetentionScheduleResponse' daily_schedule: Daily retention schedule of the backup policy.
        :param 'MonthlyRetentionScheduleResponse' monthly_schedule: Monthly retention schedule of the backup policy.
        :param str retention_policy_type: This property is used as the discriminator for deciding the specific types in the polymorphic chain of types.
               Expected value is 'LongTermRetentionPolicy'.
        :param 'WeeklyRetentionScheduleResponse' weekly_schedule: Weekly retention schedule of the backup policy.
        :param 'YearlyRetentionScheduleResponse' yearly_schedule: Yearly retention schedule of the backup policy.
        """
        if daily_schedule is not None:
            pulumi.set(__self__, "daily_schedule", daily_schedule)
        if monthly_schedule is not None:
            pulumi.set(__self__, "monthly_schedule", monthly_schedule)
        if retention_policy_type is not None:
            pulumi.set(__self__, "retention_policy_type", 'LongTermRetentionPolicy')
        if weekly_schedule is not None:
            pulumi.set(__self__, "weekly_schedule", weekly_schedule)
        if yearly_schedule is not None:
            pulumi.set(__self__, "yearly_schedule", yearly_schedule)

    @property
    @pulumi.getter(name="dailySchedule")
    def daily_schedule(self) -> Optional['outputs.DailyRetentionScheduleResponse']:
        """
        Daily retention schedule of the backup policy.
        """
        return pulumi.get(self, "daily_schedule")

    @property
    @pulumi.getter(name="monthlySchedule")
    def monthly_schedule(self) -> Optional['outputs.MonthlyRetentionScheduleResponse']:
        """
        Monthly retention schedule of the backup policy.
        """
        return pulumi.get(self, "monthly_schedule")

    @property
    @pulumi.getter(name="retentionPolicyType")
    def retention_policy_type(self) -> Optional[str]:
        """
        This property is used as the discriminator for deciding the specific types in the polymorphic chain of types.
        Expected value is 'LongTermRetentionPolicy'.
        """
        return pulumi.get(self, "retention_policy_type")

    @property
    @pulumi.getter(name="weeklySchedule")
    def weekly_schedule(self) -> Optional['outputs.WeeklyRetentionScheduleResponse']:
        """
        Weekly retention schedule of the backup policy.
        """
        return pulumi.get(self, "weekly_schedule")

    @property
    @pulumi.getter(name="yearlySchedule")
    def yearly_schedule(self) -> Optional['outputs.YearlyRetentionScheduleResponse']:
        """
        Yearly retention schedule of the backup policy.
        """
        return pulumi.get(self, "yearly_schedule")


@pulumi.output_type
class LongTermSchedulePolicyResponse(dict):
    """
    Long-term policy schedule.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "schedulePolicyType":
            suggest = "schedule_policy_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LongTermSchedulePolicyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LongTermSchedulePolicyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LongTermSchedulePolicyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 schedule_policy_type: Optional[str] = None):
        """
        Long-term policy schedule.
        :param str schedule_policy_type: This property is used as the discriminator for deciding the specific types in the polymorphic chain of types.
               Expected value is 'LongTermSchedulePolicy'.
        """
        if schedule_policy_type is not None:
            pulumi.set(__self__, "schedule_policy_type", 'LongTermSchedulePolicy')

    @property
    @pulumi.getter(name="schedulePolicyType")
    def schedule_policy_type(self) -> Optional[str]:
        """
        This property is used as the discriminator for deciding the specific types in the polymorphic chain of types.
        Expected value is 'LongTermSchedulePolicy'.
        """
        return pulumi.get(self, "schedule_policy_type")


@pulumi.output_type
class MabProtectionPolicyResponse(dict):
    """
    The backup policy for the file or folder container.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backupManagementType":
            suggest = "backup_management_type"
        elif key == "protectedItemsCount":
            suggest = "protected_items_count"
        elif key == "retentionPolicy":
            suggest = "retention_policy"
        elif key == "schedulePolicy":
            suggest = "schedule_policy"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MabProtectionPolicyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MabProtectionPolicyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MabProtectionPolicyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backup_management_type: Optional[str] = None,
                 protected_items_count: Optional[int] = None,
                 retention_policy: Optional[Any] = None,
                 schedule_policy: Optional[Any] = None):
        """
        The backup policy for the file or folder container.
        :param str backup_management_type: This property is used as the discriminator for deciding the specific types in the polymorphic chain of types.
               Expected value is 'MAB'.
        :param int protected_items_count: The number of items associated with this policy.
        :param Union['LongTermRetentionPolicyResponse', 'SimpleRetentionPolicyResponse'] retention_policy: The details specified in the Retention policy.
        :param Union['LongTermSchedulePolicyResponse', 'SimpleSchedulePolicyResponse'] schedule_policy: The schedule specified in the backup policy.
        """
        if backup_management_type is not None:
            pulumi.set(__self__, "backup_management_type", 'MAB')
        if protected_items_count is not None:
            pulumi.set(__self__, "protected_items_count", protected_items_count)
        if retention_policy is not None:
            pulumi.set(__self__, "retention_policy", retention_policy)
        if schedule_policy is not None:
            pulumi.set(__self__, "schedule_policy", schedule_policy)

    @property
    @pulumi.getter(name="backupManagementType")
    def backup_management_type(self) -> Optional[str]:
        """
        This property is used as the discriminator for deciding the specific types in the polymorphic chain of types.
        Expected value is 'MAB'.
        """
        return pulumi.get(self, "backup_management_type")

    @property
    @pulumi.getter(name="protectedItemsCount")
    def protected_items_count(self) -> Optional[int]:
        """
        The number of items associated with this policy.
        """
        return pulumi.get(self, "protected_items_count")

    @property
    @pulumi.getter(name="retentionPolicy")
    def retention_policy(self) -> Optional[Any]:
        """
        The details specified in the Retention policy.
        """
        return pulumi.get(self, "retention_policy")

    @property
    @pulumi.getter(name="schedulePolicy")
    def schedule_policy(self) -> Optional[Any]:
        """
        The schedule specified in the backup policy.
        """
        return pulumi.get(self, "schedule_policy")


@pulumi.output_type
class MonthlyRetentionScheduleResponse(dict):
    """
    The monthly retention schedule.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "retentionDuration":
            suggest = "retention_duration"
        elif key == "retentionScheduleDaily":
            suggest = "retention_schedule_daily"
        elif key == "retentionScheduleFormatType":
            suggest = "retention_schedule_format_type"
        elif key == "retentionScheduleWeekly":
            suggest = "retention_schedule_weekly"
        elif key == "retentionTimes":
            suggest = "retention_times"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MonthlyRetentionScheduleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MonthlyRetentionScheduleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MonthlyRetentionScheduleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 retention_duration: Optional['outputs.RetentionDurationResponse'] = None,
                 retention_schedule_daily: Optional['outputs.DailyRetentionFormatResponse'] = None,
                 retention_schedule_format_type: Optional[str] = None,
                 retention_schedule_weekly: Optional['outputs.WeeklyRetentionFormatResponse'] = None,
                 retention_times: Optional[Sequence[str]] = None):
        """
        The monthly retention schedule.
        :param 'RetentionDurationResponse' retention_duration: Retention duration of the retention policy.
        :param 'DailyRetentionFormatResponse' retention_schedule_daily: Daily retention format for the monthly retention policy.
        :param str retention_schedule_format_type: Retention schedule format type for monthly retention policy.
        :param 'WeeklyRetentionFormatResponse' retention_schedule_weekly: Weekly retention format for the monthly retention policy.
        :param Sequence[str] retention_times: Retention times of the retention policy.
        """
        if retention_duration is not None:
            pulumi.set(__self__, "retention_duration", retention_duration)
        if retention_schedule_daily is not None:
            pulumi.set(__self__, "retention_schedule_daily", retention_schedule_daily)
        if retention_schedule_format_type is not None:
            pulumi.set(__self__, "retention_schedule_format_type", retention_schedule_format_type)
        if retention_schedule_weekly is not None:
            pulumi.set(__self__, "retention_schedule_weekly", retention_schedule_weekly)
        if retention_times is not None:
            pulumi.set(__self__, "retention_times", retention_times)

    @property
    @pulumi.getter(name="retentionDuration")
    def retention_duration(self) -> Optional['outputs.RetentionDurationResponse']:
        """
        Retention duration of the retention policy.
        """
        return pulumi.get(self, "retention_duration")

    @property
    @pulumi.getter(name="retentionScheduleDaily")
    def retention_schedule_daily(self) -> Optional['outputs.DailyRetentionFormatResponse']:
        """
        Daily retention format for the monthly retention policy.
        """
        return pulumi.get(self, "retention_schedule_daily")

    @property
    @pulumi.getter(name="retentionScheduleFormatType")
    def retention_schedule_format_type(self) -> Optional[str]:
        """
        Retention schedule format type for monthly retention policy.
        """
        return pulumi.get(self, "retention_schedule_format_type")

    @property
    @pulumi.getter(name="retentionScheduleWeekly")
    def retention_schedule_weekly(self) -> Optional['outputs.WeeklyRetentionFormatResponse']:
        """
        Weekly retention format for the monthly retention policy.
        """
        return pulumi.get(self, "retention_schedule_weekly")

    @property
    @pulumi.getter(name="retentionTimes")
    def retention_times(self) -> Optional[Sequence[str]]:
        """
        Retention times of the retention policy.
        """
        return pulumi.get(self, "retention_times")


@pulumi.output_type
class PrivateEndpointConnectionVaultPropertiesResponse(dict):
    """
    Information to be stored in Vault properties as an element of privateEndpointConnections List.
    """
    def __init__(__self__, *,
                 id: str,
                 properties: 'outputs.VaultPrivateEndpointConnectionResponse'):
        """
        Information to be stored in Vault properties as an element of privateEndpointConnections List.
        :param str id: Format of id subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.[Service]/{resource}/{resourceName}/privateEndpointConnections/{connectionName}.
        :param 'VaultPrivateEndpointConnectionResponse' properties: Private Endpoint Connection Response Properties.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "properties", properties)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Format of id subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.[Service]/{resource}/{resourceName}/privateEndpointConnections/{connectionName}.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def properties(self) -> 'outputs.VaultPrivateEndpointConnectionResponse':
        """
        Private Endpoint Connection Response Properties.
        """
        return pulumi.get(self, "properties")


@pulumi.output_type
class PrivateEndpointResponse(dict):
    """
    The Private Endpoint network resource that is linked to the Private Endpoint connection.
    """
    def __init__(__self__, *,
                 id: str):
        """
        The Private Endpoint network resource that is linked to the Private Endpoint connection.
        :param str id: Gets or sets id.
        """
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Gets or sets id.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class RetentionDurationResponse(dict):
    """
    Retention duration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "durationType":
            suggest = "duration_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RetentionDurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RetentionDurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RetentionDurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 count: Optional[int] = None,
                 duration_type: Optional[str] = None):
        """
        Retention duration.
        :param int count: Count of the duration types. Retention duration is determined by the combining the Count times and durationType. 
                  For example, if Count = 3 and durationType = Weeks, then the retention duration is three weeks.
        :param str duration_type: The retention duration type of the retention policy.
        """
        if count is not None:
            pulumi.set(__self__, "count", count)
        if duration_type is not None:
            pulumi.set(__self__, "duration_type", duration_type)

    @property
    @pulumi.getter
    def count(self) -> Optional[int]:
        """
        Count of the duration types. Retention duration is determined by the combining the Count times and durationType. 
           For example, if Count = 3 and durationType = Weeks, then the retention duration is three weeks.
        """
        return pulumi.get(self, "count")

    @property
    @pulumi.getter(name="durationType")
    def duration_type(self) -> Optional[str]:
        """
        The retention duration type of the retention policy.
        """
        return pulumi.get(self, "duration_type")


@pulumi.output_type
class SimpleRetentionPolicyResponse(dict):
    """
    Simple policy retention.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "retentionDuration":
            suggest = "retention_duration"
        elif key == "retentionPolicyType":
            suggest = "retention_policy_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SimpleRetentionPolicyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SimpleRetentionPolicyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SimpleRetentionPolicyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 retention_duration: Optional['outputs.RetentionDurationResponse'] = None,
                 retention_policy_type: Optional[str] = None):
        """
        Simple policy retention.
        :param 'RetentionDurationResponse' retention_duration: Retention duration of the protection policy.
        :param str retention_policy_type: This property is used as the discriminator for deciding the specific types in the polymorphic chain of types.
               Expected value is 'SimpleRetentionPolicy'.
        """
        if retention_duration is not None:
            pulumi.set(__self__, "retention_duration", retention_duration)
        if retention_policy_type is not None:
            pulumi.set(__self__, "retention_policy_type", 'SimpleRetentionPolicy')

    @property
    @pulumi.getter(name="retentionDuration")
    def retention_duration(self) -> Optional['outputs.RetentionDurationResponse']:
        """
        Retention duration of the protection policy.
        """
        return pulumi.get(self, "retention_duration")

    @property
    @pulumi.getter(name="retentionPolicyType")
    def retention_policy_type(self) -> Optional[str]:
        """
        This property is used as the discriminator for deciding the specific types in the polymorphic chain of types.
        Expected value is 'SimpleRetentionPolicy'.
        """
        return pulumi.get(self, "retention_policy_type")


@pulumi.output_type
class SimpleSchedulePolicyResponse(dict):
    """
    Simple policy schedule.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "schedulePolicyType":
            suggest = "schedule_policy_type"
        elif key == "scheduleRunDays":
            suggest = "schedule_run_days"
        elif key == "scheduleRunFrequency":
            suggest = "schedule_run_frequency"
        elif key == "scheduleRunTimes":
            suggest = "schedule_run_times"
        elif key == "scheduleWeeklyFrequency":
            suggest = "schedule_weekly_frequency"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SimpleSchedulePolicyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SimpleSchedulePolicyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SimpleSchedulePolicyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 schedule_policy_type: Optional[str] = None,
                 schedule_run_days: Optional[Sequence[str]] = None,
                 schedule_run_frequency: Optional[str] = None,
                 schedule_run_times: Optional[Sequence[str]] = None,
                 schedule_weekly_frequency: Optional[int] = None):
        """
        Simple policy schedule.
        :param str schedule_policy_type: This property is used as the discriminator for deciding the specific types in the polymorphic chain of types.
               Expected value is 'SimpleSchedulePolicy'.
        :param Sequence[str] schedule_run_days: This list is the days of the week when the schedule runs.
        :param str schedule_run_frequency: Defines the frequency interval (daily or weekly) for the schedule policy.
        :param Sequence[str] schedule_run_times: List of times, during a day, when the schedule runs.
        :param int schedule_weekly_frequency: The number of times per week the schedule runs.
        """
        if schedule_policy_type is not None:
            pulumi.set(__self__, "schedule_policy_type", 'SimpleSchedulePolicy')
        if schedule_run_days is not None:
            pulumi.set(__self__, "schedule_run_days", schedule_run_days)
        if schedule_run_frequency is not None:
            pulumi.set(__self__, "schedule_run_frequency", schedule_run_frequency)
        if schedule_run_times is not None:
            pulumi.set(__self__, "schedule_run_times", schedule_run_times)
        if schedule_weekly_frequency is not None:
            pulumi.set(__self__, "schedule_weekly_frequency", schedule_weekly_frequency)

    @property
    @pulumi.getter(name="schedulePolicyType")
    def schedule_policy_type(self) -> Optional[str]:
        """
        This property is used as the discriminator for deciding the specific types in the polymorphic chain of types.
        Expected value is 'SimpleSchedulePolicy'.
        """
        return pulumi.get(self, "schedule_policy_type")

    @property
    @pulumi.getter(name="scheduleRunDays")
    def schedule_run_days(self) -> Optional[Sequence[str]]:
        """
        This list is the days of the week when the schedule runs.
        """
        return pulumi.get(self, "schedule_run_days")

    @property
    @pulumi.getter(name="scheduleRunFrequency")
    def schedule_run_frequency(self) -> Optional[str]:
        """
        Defines the frequency interval (daily or weekly) for the schedule policy.
        """
        return pulumi.get(self, "schedule_run_frequency")

    @property
    @pulumi.getter(name="scheduleRunTimes")
    def schedule_run_times(self) -> Optional[Sequence[str]]:
        """
        List of times, during a day, when the schedule runs.
        """
        return pulumi.get(self, "schedule_run_times")

    @property
    @pulumi.getter(name="scheduleWeeklyFrequency")
    def schedule_weekly_frequency(self) -> Optional[int]:
        """
        The number of times per week the schedule runs.
        """
        return pulumi.get(self, "schedule_weekly_frequency")


@pulumi.output_type
class SkuResponse(dict):
    """
    Identifies the unique system identifier for each Azure resource.
    """
    def __init__(__self__, *,
                 name: str):
        """
        Identifies the unique system identifier for each Azure resource.
        :param str name: The Sku name.
        """
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The Sku name.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class UpgradeDetailsResponse(dict):
    """
    Details for upgrading vault.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endTimeUtc":
            suggest = "end_time_utc"
        elif key == "lastUpdatedTimeUtc":
            suggest = "last_updated_time_utc"
        elif key == "operationId":
            suggest = "operation_id"
        elif key == "previousResourceId":
            suggest = "previous_resource_id"
        elif key == "startTimeUtc":
            suggest = "start_time_utc"
        elif key == "triggerType":
            suggest = "trigger_type"
        elif key == "upgradedResourceId":
            suggest = "upgraded_resource_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UpgradeDetailsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UpgradeDetailsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UpgradeDetailsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 end_time_utc: str,
                 last_updated_time_utc: str,
                 message: str,
                 operation_id: str,
                 previous_resource_id: str,
                 start_time_utc: str,
                 status: str,
                 trigger_type: str,
                 upgraded_resource_id: str):
        """
        Details for upgrading vault.
        :param str end_time_utc: UTC time at which the upgrade operation has ended.
        :param str last_updated_time_utc: UTC time at which the upgrade operation status was last updated.
        :param str message: Message to the user containing information about the upgrade operation.
        :param str operation_id: ID of the vault upgrade operation.
        :param str previous_resource_id: Resource ID of the vault before the upgrade.
        :param str start_time_utc: UTC time at which the upgrade operation has started.
        :param str status: Status of the vault upgrade operation.
        :param str trigger_type: The way the vault upgrade was triggered.
        :param str upgraded_resource_id: Resource ID of the upgraded vault.
        """
        pulumi.set(__self__, "end_time_utc", end_time_utc)
        pulumi.set(__self__, "last_updated_time_utc", last_updated_time_utc)
        pulumi.set(__self__, "message", message)
        pulumi.set(__self__, "operation_id", operation_id)
        pulumi.set(__self__, "previous_resource_id", previous_resource_id)
        pulumi.set(__self__, "start_time_utc", start_time_utc)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "trigger_type", trigger_type)
        pulumi.set(__self__, "upgraded_resource_id", upgraded_resource_id)

    @property
    @pulumi.getter(name="endTimeUtc")
    def end_time_utc(self) -> str:
        """
        UTC time at which the upgrade operation has ended.
        """
        return pulumi.get(self, "end_time_utc")

    @property
    @pulumi.getter(name="lastUpdatedTimeUtc")
    def last_updated_time_utc(self) -> str:
        """
        UTC time at which the upgrade operation status was last updated.
        """
        return pulumi.get(self, "last_updated_time_utc")

    @property
    @pulumi.getter
    def message(self) -> str:
        """
        Message to the user containing information about the upgrade operation.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter(name="operationId")
    def operation_id(self) -> str:
        """
        ID of the vault upgrade operation.
        """
        return pulumi.get(self, "operation_id")

    @property
    @pulumi.getter(name="previousResourceId")
    def previous_resource_id(self) -> str:
        """
        Resource ID of the vault before the upgrade.
        """
        return pulumi.get(self, "previous_resource_id")

    @property
    @pulumi.getter(name="startTimeUtc")
    def start_time_utc(self) -> str:
        """
        UTC time at which the upgrade operation has started.
        """
        return pulumi.get(self, "start_time_utc")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Status of the vault upgrade operation.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="triggerType")
    def trigger_type(self) -> str:
        """
        The way the vault upgrade was triggered.
        """
        return pulumi.get(self, "trigger_type")

    @property
    @pulumi.getter(name="upgradedResourceId")
    def upgraded_resource_id(self) -> str:
        """
        Resource ID of the upgraded vault.
        """
        return pulumi.get(self, "upgraded_resource_id")


@pulumi.output_type
class VaultPrivateEndpointConnectionResponse(dict):
    """
    Private Endpoint Connection Response Properties.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "privateEndpoint":
            suggest = "private_endpoint"
        elif key == "privateLinkServiceConnectionState":
            suggest = "private_link_service_connection_state"
        elif key == "provisioningState":
            suggest = "provisioning_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VaultPrivateEndpointConnectionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VaultPrivateEndpointConnectionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VaultPrivateEndpointConnectionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 private_endpoint: 'outputs.PrivateEndpointResponse',
                 private_link_service_connection_state: 'outputs.VaultPrivateLinkServiceConnectionStateResponse',
                 provisioning_state: str):
        """
        Private Endpoint Connection Response Properties.
        :param 'PrivateEndpointResponse' private_endpoint: The Private Endpoint network resource that is linked to the Private Endpoint connection.
        :param 'VaultPrivateLinkServiceConnectionStateResponse' private_link_service_connection_state: Gets or sets private link service connection state.
        :param str provisioning_state: Gets or sets provisioning state of the private endpoint connection.
        """
        pulumi.set(__self__, "private_endpoint", private_endpoint)
        pulumi.set(__self__, "private_link_service_connection_state", private_link_service_connection_state)
        pulumi.set(__self__, "provisioning_state", provisioning_state)

    @property
    @pulumi.getter(name="privateEndpoint")
    def private_endpoint(self) -> 'outputs.PrivateEndpointResponse':
        """
        The Private Endpoint network resource that is linked to the Private Endpoint connection.
        """
        return pulumi.get(self, "private_endpoint")

    @property
    @pulumi.getter(name="privateLinkServiceConnectionState")
    def private_link_service_connection_state(self) -> 'outputs.VaultPrivateLinkServiceConnectionStateResponse':
        """
        Gets or sets private link service connection state.
        """
        return pulumi.get(self, "private_link_service_connection_state")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        Gets or sets provisioning state of the private endpoint connection.
        """
        return pulumi.get(self, "provisioning_state")


@pulumi.output_type
class VaultPrivateLinkServiceConnectionStateResponse(dict):
    """
    Gets or sets private link service connection state.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "actionsRequired":
            suggest = "actions_required"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VaultPrivateLinkServiceConnectionStateResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VaultPrivateLinkServiceConnectionStateResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VaultPrivateLinkServiceConnectionStateResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 actions_required: str,
                 description: str,
                 status: str):
        """
        Gets or sets private link service connection state.
        :param str actions_required: Gets or sets actions required.
        :param str description: Gets or sets description.
        :param str status: Gets or sets the status.
        """
        pulumi.set(__self__, "actions_required", actions_required)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="actionsRequired")
    def actions_required(self) -> str:
        """
        Gets or sets actions required.
        """
        return pulumi.get(self, "actions_required")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Gets or sets description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Gets or sets the status.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class VaultPropertiesResponse(dict):
    """
    Properties of the vault.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "privateEndpointConnections":
            suggest = "private_endpoint_connections"
        elif key == "privateEndpointStateForBackup":
            suggest = "private_endpoint_state_for_backup"
        elif key == "privateEndpointStateForSiteRecovery":
            suggest = "private_endpoint_state_for_site_recovery"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "upgradeDetails":
            suggest = "upgrade_details"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VaultPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VaultPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VaultPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 private_endpoint_connections: Sequence['outputs.PrivateEndpointConnectionVaultPropertiesResponse'],
                 private_endpoint_state_for_backup: str,
                 private_endpoint_state_for_site_recovery: str,
                 provisioning_state: str,
                 upgrade_details: Optional['outputs.UpgradeDetailsResponse'] = None):
        """
        Properties of the vault.
        :param Sequence['PrivateEndpointConnectionVaultPropertiesResponse'] private_endpoint_connections: List of private endpoint connection.
        :param str private_endpoint_state_for_backup: Private endpoint state for backup.
        :param str private_endpoint_state_for_site_recovery: Private endpoint state for site recovery.
        :param str provisioning_state: Provisioning State.
        :param 'UpgradeDetailsResponse' upgrade_details: Details for upgrading vault.
        """
        pulumi.set(__self__, "private_endpoint_connections", private_endpoint_connections)
        pulumi.set(__self__, "private_endpoint_state_for_backup", private_endpoint_state_for_backup)
        pulumi.set(__self__, "private_endpoint_state_for_site_recovery", private_endpoint_state_for_site_recovery)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if upgrade_details is not None:
            pulumi.set(__self__, "upgrade_details", upgrade_details)

    @property
    @pulumi.getter(name="privateEndpointConnections")
    def private_endpoint_connections(self) -> Sequence['outputs.PrivateEndpointConnectionVaultPropertiesResponse']:
        """
        List of private endpoint connection.
        """
        return pulumi.get(self, "private_endpoint_connections")

    @property
    @pulumi.getter(name="privateEndpointStateForBackup")
    def private_endpoint_state_for_backup(self) -> str:
        """
        Private endpoint state for backup.
        """
        return pulumi.get(self, "private_endpoint_state_for_backup")

    @property
    @pulumi.getter(name="privateEndpointStateForSiteRecovery")
    def private_endpoint_state_for_site_recovery(self) -> str:
        """
        Private endpoint state for site recovery.
        """
        return pulumi.get(self, "private_endpoint_state_for_site_recovery")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        Provisioning State.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="upgradeDetails")
    def upgrade_details(self) -> Optional['outputs.UpgradeDetailsResponse']:
        """
        Details for upgrading vault.
        """
        return pulumi.get(self, "upgrade_details")


@pulumi.output_type
class WeeklyRetentionFormatResponse(dict):
    """
    Weekly retention format.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "daysOfTheWeek":
            suggest = "days_of_the_week"
        elif key == "weeksOfTheMonth":
            suggest = "weeks_of_the_month"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WeeklyRetentionFormatResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WeeklyRetentionFormatResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WeeklyRetentionFormatResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 days_of_the_week: Optional[Sequence[str]] = None,
                 weeks_of_the_month: Optional[Sequence[str]] = None):
        """
        Weekly retention format.
        :param Sequence[str] days_of_the_week: List of days of the week.
        :param Sequence[str] weeks_of_the_month: List of weeks of the month.
        """
        if days_of_the_week is not None:
            pulumi.set(__self__, "days_of_the_week", days_of_the_week)
        if weeks_of_the_month is not None:
            pulumi.set(__self__, "weeks_of_the_month", weeks_of_the_month)

    @property
    @pulumi.getter(name="daysOfTheWeek")
    def days_of_the_week(self) -> Optional[Sequence[str]]:
        """
        List of days of the week.
        """
        return pulumi.get(self, "days_of_the_week")

    @property
    @pulumi.getter(name="weeksOfTheMonth")
    def weeks_of_the_month(self) -> Optional[Sequence[str]]:
        """
        List of weeks of the month.
        """
        return pulumi.get(self, "weeks_of_the_month")


@pulumi.output_type
class WeeklyRetentionScheduleResponse(dict):
    """
    Weekly retention schedule.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "daysOfTheWeek":
            suggest = "days_of_the_week"
        elif key == "retentionDuration":
            suggest = "retention_duration"
        elif key == "retentionTimes":
            suggest = "retention_times"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WeeklyRetentionScheduleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WeeklyRetentionScheduleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WeeklyRetentionScheduleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 days_of_the_week: Optional[Sequence[str]] = None,
                 retention_duration: Optional['outputs.RetentionDurationResponse'] = None,
                 retention_times: Optional[Sequence[str]] = None):
        """
        Weekly retention schedule.
        :param Sequence[str] days_of_the_week: List of the days of the week for the weekly retention policy.
        :param 'RetentionDurationResponse' retention_duration: Retention duration of retention policy.
        :param Sequence[str] retention_times: Retention times of the retention policy.
        """
        if days_of_the_week is not None:
            pulumi.set(__self__, "days_of_the_week", days_of_the_week)
        if retention_duration is not None:
            pulumi.set(__self__, "retention_duration", retention_duration)
        if retention_times is not None:
            pulumi.set(__self__, "retention_times", retention_times)

    @property
    @pulumi.getter(name="daysOfTheWeek")
    def days_of_the_week(self) -> Optional[Sequence[str]]:
        """
        List of the days of the week for the weekly retention policy.
        """
        return pulumi.get(self, "days_of_the_week")

    @property
    @pulumi.getter(name="retentionDuration")
    def retention_duration(self) -> Optional['outputs.RetentionDurationResponse']:
        """
        Retention duration of retention policy.
        """
        return pulumi.get(self, "retention_duration")

    @property
    @pulumi.getter(name="retentionTimes")
    def retention_times(self) -> Optional[Sequence[str]]:
        """
        Retention times of the retention policy.
        """
        return pulumi.get(self, "retention_times")


@pulumi.output_type
class YearlyRetentionScheduleResponse(dict):
    """
    Yearly retention schedule.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "monthsOfYear":
            suggest = "months_of_year"
        elif key == "retentionDuration":
            suggest = "retention_duration"
        elif key == "retentionScheduleDaily":
            suggest = "retention_schedule_daily"
        elif key == "retentionScheduleFormatType":
            suggest = "retention_schedule_format_type"
        elif key == "retentionScheduleWeekly":
            suggest = "retention_schedule_weekly"
        elif key == "retentionTimes":
            suggest = "retention_times"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in YearlyRetentionScheduleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        YearlyRetentionScheduleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        YearlyRetentionScheduleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 months_of_year: Optional[Sequence[str]] = None,
                 retention_duration: Optional['outputs.RetentionDurationResponse'] = None,
                 retention_schedule_daily: Optional['outputs.DailyRetentionFormatResponse'] = None,
                 retention_schedule_format_type: Optional[str] = None,
                 retention_schedule_weekly: Optional['outputs.WeeklyRetentionFormatResponse'] = None,
                 retention_times: Optional[Sequence[str]] = None):
        """
        Yearly retention schedule.
        :param Sequence[str] months_of_year: List of the months of year for the yearly retention policy.
        :param 'RetentionDurationResponse' retention_duration: Retention duration for the retention policy.
        :param 'DailyRetentionFormatResponse' retention_schedule_daily: Daily retention format for the yearly retention policy.
        :param str retention_schedule_format_type: Retention schedule format for the yearly retention policy.
        :param 'WeeklyRetentionFormatResponse' retention_schedule_weekly: Weekly retention format for the yearly retention policy.
        :param Sequence[str] retention_times: Retention times for the retention policy.
        """
        if months_of_year is not None:
            pulumi.set(__self__, "months_of_year", months_of_year)
        if retention_duration is not None:
            pulumi.set(__self__, "retention_duration", retention_duration)
        if retention_schedule_daily is not None:
            pulumi.set(__self__, "retention_schedule_daily", retention_schedule_daily)
        if retention_schedule_format_type is not None:
            pulumi.set(__self__, "retention_schedule_format_type", retention_schedule_format_type)
        if retention_schedule_weekly is not None:
            pulumi.set(__self__, "retention_schedule_weekly", retention_schedule_weekly)
        if retention_times is not None:
            pulumi.set(__self__, "retention_times", retention_times)

    @property
    @pulumi.getter(name="monthsOfYear")
    def months_of_year(self) -> Optional[Sequence[str]]:
        """
        List of the months of year for the yearly retention policy.
        """
        return pulumi.get(self, "months_of_year")

    @property
    @pulumi.getter(name="retentionDuration")
    def retention_duration(self) -> Optional['outputs.RetentionDurationResponse']:
        """
        Retention duration for the retention policy.
        """
        return pulumi.get(self, "retention_duration")

    @property
    @pulumi.getter(name="retentionScheduleDaily")
    def retention_schedule_daily(self) -> Optional['outputs.DailyRetentionFormatResponse']:
        """
        Daily retention format for the yearly retention policy.
        """
        return pulumi.get(self, "retention_schedule_daily")

    @property
    @pulumi.getter(name="retentionScheduleFormatType")
    def retention_schedule_format_type(self) -> Optional[str]:
        """
        Retention schedule format for the yearly retention policy.
        """
        return pulumi.get(self, "retention_schedule_format_type")

    @property
    @pulumi.getter(name="retentionScheduleWeekly")
    def retention_schedule_weekly(self) -> Optional['outputs.WeeklyRetentionFormatResponse']:
        """
        Weekly retention format for the yearly retention policy.
        """
        return pulumi.get(self, "retention_schedule_weekly")

    @property
    @pulumi.getter(name="retentionTimes")
    def retention_times(self) -> Optional[Sequence[str]]:
        """
        Retention times for the retention policy.
        """
        return pulumi.get(self, "retention_times")


