# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'AssessmentPropertiesResponse',
    'CollectorAgentPropertiesResponse',
    'CollectorBodyAgentSpnPropertiesResponse',
    'CollectorPropertiesResponse',
    'GroupPropertiesResponse',
    'ImportCollectorPropertiesResponse',
    'PrivateEndpointConnectionPropertiesResponse',
    'PrivateEndpointConnectionResponse',
    'PrivateLinkServiceConnectionStateResponse',
    'ProjectPropertiesResponse',
    'ResourceIdResponse',
    'VmUptimeResponse',
]

@pulumi.output_type
class AssessmentPropertiesResponse(dict):
    """
    Properties of an assessment.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "azureDiskType":
            suggest = "azure_disk_type"
        elif key == "azureHybridUseBenefit":
            suggest = "azure_hybrid_use_benefit"
        elif key == "azureLocation":
            suggest = "azure_location"
        elif key == "azureOfferCode":
            suggest = "azure_offer_code"
        elif key == "azurePricingTier":
            suggest = "azure_pricing_tier"
        elif key == "azureStorageRedundancy":
            suggest = "azure_storage_redundancy"
        elif key == "azureVmFamilies":
            suggest = "azure_vm_families"
        elif key == "confidenceRatingInPercentage":
            suggest = "confidence_rating_in_percentage"
        elif key == "createdTimestamp":
            suggest = "created_timestamp"
        elif key == "discountPercentage":
            suggest = "discount_percentage"
        elif key == "eaSubscriptionId":
            suggest = "ea_subscription_id"
        elif key == "monthlyBandwidthCost":
            suggest = "monthly_bandwidth_cost"
        elif key == "monthlyComputeCost":
            suggest = "monthly_compute_cost"
        elif key == "monthlyPremiumStorageCost":
            suggest = "monthly_premium_storage_cost"
        elif key == "monthlyStandardSSDStorageCost":
            suggest = "monthly_standard_ssd_storage_cost"
        elif key == "monthlyStorageCost":
            suggest = "monthly_storage_cost"
        elif key == "numberOfMachines":
            suggest = "number_of_machines"
        elif key == "perfDataEndTime":
            suggest = "perf_data_end_time"
        elif key == "perfDataStartTime":
            suggest = "perf_data_start_time"
        elif key == "pricesTimestamp":
            suggest = "prices_timestamp"
        elif key == "reservedInstance":
            suggest = "reserved_instance"
        elif key == "scalingFactor":
            suggest = "scaling_factor"
        elif key == "sizingCriterion":
            suggest = "sizing_criterion"
        elif key == "timeRange":
            suggest = "time_range"
        elif key == "updatedTimestamp":
            suggest = "updated_timestamp"
        elif key == "vmUptime":
            suggest = "vm_uptime"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AssessmentPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AssessmentPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AssessmentPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 azure_disk_type: str,
                 azure_hybrid_use_benefit: str,
                 azure_location: str,
                 azure_offer_code: str,
                 azure_pricing_tier: str,
                 azure_storage_redundancy: str,
                 azure_vm_families: Sequence[str],
                 confidence_rating_in_percentage: float,
                 created_timestamp: str,
                 currency: str,
                 discount_percentage: float,
                 ea_subscription_id: str,
                 monthly_bandwidth_cost: float,
                 monthly_compute_cost: float,
                 monthly_premium_storage_cost: float,
                 monthly_standard_ssd_storage_cost: float,
                 monthly_storage_cost: float,
                 number_of_machines: int,
                 percentile: str,
                 perf_data_end_time: str,
                 perf_data_start_time: str,
                 prices_timestamp: str,
                 reserved_instance: str,
                 scaling_factor: float,
                 sizing_criterion: str,
                 stage: str,
                 status: str,
                 time_range: str,
                 updated_timestamp: str,
                 vm_uptime: 'outputs.VmUptimeResponse'):
        """
        Properties of an assessment.
        :param str azure_disk_type: Storage type selected for this disk.
        :param str azure_hybrid_use_benefit: AHUB discount on windows virtual machines.
        :param str azure_location: Target Azure location for which the machines should be assessed. These enums are the same as used by Compute API.
        :param str azure_offer_code: Offer code according to which cost estimation is done.
        :param str azure_pricing_tier: Pricing tier for Size evaluation.
        :param str azure_storage_redundancy: Storage Redundancy type offered by Azure.
        :param Sequence[str] azure_vm_families: List of azure VM families.
        :param float confidence_rating_in_percentage: Confidence rating percentage for assessment. Can be in the range [0, 100].
        :param str created_timestamp: Time when this project was created. Date-Time represented in ISO-8601 format.
        :param str currency: Currency to report prices in.
        :param float discount_percentage: Custom discount percentage to be applied on final costs. Can be in the range [0, 100].
        :param str ea_subscription_id: Enterprise agreement subscription arm id.
        :param float monthly_bandwidth_cost: Monthly network cost estimate for the machines that are part of this assessment as a group, for a 31-day month.
        :param float monthly_compute_cost: Monthly compute cost estimate for the machines that are part of this assessment as a group, for a 31-day month.
        :param float monthly_premium_storage_cost: Monthly premium storage cost estimate for the machines that are part of this assessment as a group, for a 31-day month.
        :param float monthly_standard_ssd_storage_cost: Monthly standard SSD storage cost estimate for the machines that are part of this assessment as a group, for a 31-day month.
        :param float monthly_storage_cost: Monthly storage cost estimate for the machines that are part of this assessment as a group, for a 31-day month.
        :param int number_of_machines: Number of assessed machines part of this assessment.
        :param str percentile: Percentile of performance data used to recommend Azure size.
        :param str perf_data_end_time: End time to consider performance data for assessment
        :param str perf_data_start_time: Start time to consider performance data for assessment
        :param str prices_timestamp: Time when the Azure Prices were queried. Date-Time represented in ISO-8601 format.
        :param str reserved_instance: Azure reserved instance.
        :param float scaling_factor: Scaling factor used over utilization data to add a performance buffer for new machines to be created in Azure. Min Value = 1.0, Max value = 1.9, Default = 1.3.
        :param str sizing_criterion: Assessment sizing criterion.
        :param str stage: User configurable setting that describes the status of the assessment.
        :param str status: Whether the assessment has been created and is valid.
        :param str time_range: Time range of performance data used to recommend a size.
        :param str updated_timestamp: Time when this project was last updated. Date-Time represented in ISO-8601 format.
        :param 'VmUptimeResponse' vm_uptime: Specify the duration for which the VMs are up in the on-premises environment.
        """
        pulumi.set(__self__, "azure_disk_type", azure_disk_type)
        pulumi.set(__self__, "azure_hybrid_use_benefit", azure_hybrid_use_benefit)
        pulumi.set(__self__, "azure_location", azure_location)
        pulumi.set(__self__, "azure_offer_code", azure_offer_code)
        pulumi.set(__self__, "azure_pricing_tier", azure_pricing_tier)
        pulumi.set(__self__, "azure_storage_redundancy", azure_storage_redundancy)
        pulumi.set(__self__, "azure_vm_families", azure_vm_families)
        pulumi.set(__self__, "confidence_rating_in_percentage", confidence_rating_in_percentage)
        pulumi.set(__self__, "created_timestamp", created_timestamp)
        pulumi.set(__self__, "currency", currency)
        pulumi.set(__self__, "discount_percentage", discount_percentage)
        pulumi.set(__self__, "ea_subscription_id", ea_subscription_id)
        pulumi.set(__self__, "monthly_bandwidth_cost", monthly_bandwidth_cost)
        pulumi.set(__self__, "monthly_compute_cost", monthly_compute_cost)
        pulumi.set(__self__, "monthly_premium_storage_cost", monthly_premium_storage_cost)
        pulumi.set(__self__, "monthly_standard_ssd_storage_cost", monthly_standard_ssd_storage_cost)
        pulumi.set(__self__, "monthly_storage_cost", monthly_storage_cost)
        pulumi.set(__self__, "number_of_machines", number_of_machines)
        pulumi.set(__self__, "percentile", percentile)
        pulumi.set(__self__, "perf_data_end_time", perf_data_end_time)
        pulumi.set(__self__, "perf_data_start_time", perf_data_start_time)
        pulumi.set(__self__, "prices_timestamp", prices_timestamp)
        pulumi.set(__self__, "reserved_instance", reserved_instance)
        pulumi.set(__self__, "scaling_factor", scaling_factor)
        pulumi.set(__self__, "sizing_criterion", sizing_criterion)
        pulumi.set(__self__, "stage", stage)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "time_range", time_range)
        pulumi.set(__self__, "updated_timestamp", updated_timestamp)
        pulumi.set(__self__, "vm_uptime", vm_uptime)

    @property
    @pulumi.getter(name="azureDiskType")
    def azure_disk_type(self) -> str:
        """
        Storage type selected for this disk.
        """
        return pulumi.get(self, "azure_disk_type")

    @property
    @pulumi.getter(name="azureHybridUseBenefit")
    def azure_hybrid_use_benefit(self) -> str:
        """
        AHUB discount on windows virtual machines.
        """
        return pulumi.get(self, "azure_hybrid_use_benefit")

    @property
    @pulumi.getter(name="azureLocation")
    def azure_location(self) -> str:
        """
        Target Azure location for which the machines should be assessed. These enums are the same as used by Compute API.
        """
        return pulumi.get(self, "azure_location")

    @property
    @pulumi.getter(name="azureOfferCode")
    def azure_offer_code(self) -> str:
        """
        Offer code according to which cost estimation is done.
        """
        return pulumi.get(self, "azure_offer_code")

    @property
    @pulumi.getter(name="azurePricingTier")
    def azure_pricing_tier(self) -> str:
        """
        Pricing tier for Size evaluation.
        """
        return pulumi.get(self, "azure_pricing_tier")

    @property
    @pulumi.getter(name="azureStorageRedundancy")
    def azure_storage_redundancy(self) -> str:
        """
        Storage Redundancy type offered by Azure.
        """
        return pulumi.get(self, "azure_storage_redundancy")

    @property
    @pulumi.getter(name="azureVmFamilies")
    def azure_vm_families(self) -> Sequence[str]:
        """
        List of azure VM families.
        """
        return pulumi.get(self, "azure_vm_families")

    @property
    @pulumi.getter(name="confidenceRatingInPercentage")
    def confidence_rating_in_percentage(self) -> float:
        """
        Confidence rating percentage for assessment. Can be in the range [0, 100].
        """
        return pulumi.get(self, "confidence_rating_in_percentage")

    @property
    @pulumi.getter(name="createdTimestamp")
    def created_timestamp(self) -> str:
        """
        Time when this project was created. Date-Time represented in ISO-8601 format.
        """
        return pulumi.get(self, "created_timestamp")

    @property
    @pulumi.getter
    def currency(self) -> str:
        """
        Currency to report prices in.
        """
        return pulumi.get(self, "currency")

    @property
    @pulumi.getter(name="discountPercentage")
    def discount_percentage(self) -> float:
        """
        Custom discount percentage to be applied on final costs. Can be in the range [0, 100].
        """
        return pulumi.get(self, "discount_percentage")

    @property
    @pulumi.getter(name="eaSubscriptionId")
    def ea_subscription_id(self) -> str:
        """
        Enterprise agreement subscription arm id.
        """
        return pulumi.get(self, "ea_subscription_id")

    @property
    @pulumi.getter(name="monthlyBandwidthCost")
    def monthly_bandwidth_cost(self) -> float:
        """
        Monthly network cost estimate for the machines that are part of this assessment as a group, for a 31-day month.
        """
        return pulumi.get(self, "monthly_bandwidth_cost")

    @property
    @pulumi.getter(name="monthlyComputeCost")
    def monthly_compute_cost(self) -> float:
        """
        Monthly compute cost estimate for the machines that are part of this assessment as a group, for a 31-day month.
        """
        return pulumi.get(self, "monthly_compute_cost")

    @property
    @pulumi.getter(name="monthlyPremiumStorageCost")
    def monthly_premium_storage_cost(self) -> float:
        """
        Monthly premium storage cost estimate for the machines that are part of this assessment as a group, for a 31-day month.
        """
        return pulumi.get(self, "monthly_premium_storage_cost")

    @property
    @pulumi.getter(name="monthlyStandardSSDStorageCost")
    def monthly_standard_ssd_storage_cost(self) -> float:
        """
        Monthly standard SSD storage cost estimate for the machines that are part of this assessment as a group, for a 31-day month.
        """
        return pulumi.get(self, "monthly_standard_ssd_storage_cost")

    @property
    @pulumi.getter(name="monthlyStorageCost")
    def monthly_storage_cost(self) -> float:
        """
        Monthly storage cost estimate for the machines that are part of this assessment as a group, for a 31-day month.
        """
        return pulumi.get(self, "monthly_storage_cost")

    @property
    @pulumi.getter(name="numberOfMachines")
    def number_of_machines(self) -> int:
        """
        Number of assessed machines part of this assessment.
        """
        return pulumi.get(self, "number_of_machines")

    @property
    @pulumi.getter
    def percentile(self) -> str:
        """
        Percentile of performance data used to recommend Azure size.
        """
        return pulumi.get(self, "percentile")

    @property
    @pulumi.getter(name="perfDataEndTime")
    def perf_data_end_time(self) -> str:
        """
        End time to consider performance data for assessment
        """
        return pulumi.get(self, "perf_data_end_time")

    @property
    @pulumi.getter(name="perfDataStartTime")
    def perf_data_start_time(self) -> str:
        """
        Start time to consider performance data for assessment
        """
        return pulumi.get(self, "perf_data_start_time")

    @property
    @pulumi.getter(name="pricesTimestamp")
    def prices_timestamp(self) -> str:
        """
        Time when the Azure Prices were queried. Date-Time represented in ISO-8601 format.
        """
        return pulumi.get(self, "prices_timestamp")

    @property
    @pulumi.getter(name="reservedInstance")
    def reserved_instance(self) -> str:
        """
        Azure reserved instance.
        """
        return pulumi.get(self, "reserved_instance")

    @property
    @pulumi.getter(name="scalingFactor")
    def scaling_factor(self) -> float:
        """
        Scaling factor used over utilization data to add a performance buffer for new machines to be created in Azure. Min Value = 1.0, Max value = 1.9, Default = 1.3.
        """
        return pulumi.get(self, "scaling_factor")

    @property
    @pulumi.getter(name="sizingCriterion")
    def sizing_criterion(self) -> str:
        """
        Assessment sizing criterion.
        """
        return pulumi.get(self, "sizing_criterion")

    @property
    @pulumi.getter
    def stage(self) -> str:
        """
        User configurable setting that describes the status of the assessment.
        """
        return pulumi.get(self, "stage")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Whether the assessment has been created and is valid.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="timeRange")
    def time_range(self) -> str:
        """
        Time range of performance data used to recommend a size.
        """
        return pulumi.get(self, "time_range")

    @property
    @pulumi.getter(name="updatedTimestamp")
    def updated_timestamp(self) -> str:
        """
        Time when this project was last updated. Date-Time represented in ISO-8601 format.
        """
        return pulumi.get(self, "updated_timestamp")

    @property
    @pulumi.getter(name="vmUptime")
    def vm_uptime(self) -> 'outputs.VmUptimeResponse':
        """
        Specify the duration for which the VMs are up in the on-premises environment.
        """
        return pulumi.get(self, "vm_uptime")


@pulumi.output_type
class CollectorAgentPropertiesResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lastHeartbeatUtc":
            suggest = "last_heartbeat_utc"
        elif key == "spnDetails":
            suggest = "spn_details"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CollectorAgentPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CollectorAgentPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CollectorAgentPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: str,
                 last_heartbeat_utc: str,
                 version: str,
                 spn_details: Optional['outputs.CollectorBodyAgentSpnPropertiesResponse'] = None):
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "last_heartbeat_utc", last_heartbeat_utc)
        pulumi.set(__self__, "version", version)
        if spn_details is not None:
            pulumi.set(__self__, "spn_details", spn_details)

    @property
    @pulumi.getter
    def id(self) -> str:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lastHeartbeatUtc")
    def last_heartbeat_utc(self) -> str:
        return pulumi.get(self, "last_heartbeat_utc")

    @property
    @pulumi.getter
    def version(self) -> str:
        return pulumi.get(self, "version")

    @property
    @pulumi.getter(name="spnDetails")
    def spn_details(self) -> Optional['outputs.CollectorBodyAgentSpnPropertiesResponse']:
        return pulumi.get(self, "spn_details")


@pulumi.output_type
class CollectorBodyAgentSpnPropertiesResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "applicationId":
            suggest = "application_id"
        elif key == "objectId":
            suggest = "object_id"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CollectorBodyAgentSpnPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CollectorBodyAgentSpnPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CollectorBodyAgentSpnPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 application_id: Optional[str] = None,
                 audience: Optional[str] = None,
                 authority: Optional[str] = None,
                 object_id: Optional[str] = None,
                 tenant_id: Optional[str] = None):
        """
        :param str application_id: Application/client Id for the service principal with which the on-premise management/data plane components would communicate with our Azure services.
        :param str audience: Intended audience for the service principal.
        :param str authority: AAD Authority URL which was used to request the token for the service principal.
        :param str object_id: Object Id of the service principal with which the on-premise management/data plane components would communicate with our Azure services.
        :param str tenant_id: Tenant Id for the service principal with which the on-premise management/data plane components would communicate with our Azure services.
        """
        if application_id is not None:
            pulumi.set(__self__, "application_id", application_id)
        if audience is not None:
            pulumi.set(__self__, "audience", audience)
        if authority is not None:
            pulumi.set(__self__, "authority", authority)
        if object_id is not None:
            pulumi.set(__self__, "object_id", object_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> Optional[str]:
        """
        Application/client Id for the service principal with which the on-premise management/data plane components would communicate with our Azure services.
        """
        return pulumi.get(self, "application_id")

    @property
    @pulumi.getter
    def audience(self) -> Optional[str]:
        """
        Intended audience for the service principal.
        """
        return pulumi.get(self, "audience")

    @property
    @pulumi.getter
    def authority(self) -> Optional[str]:
        """
        AAD Authority URL which was used to request the token for the service principal.
        """
        return pulumi.get(self, "authority")

    @property
    @pulumi.getter(name="objectId")
    def object_id(self) -> Optional[str]:
        """
        Object Id of the service principal with which the on-premise management/data plane components would communicate with our Azure services.
        """
        return pulumi.get(self, "object_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[str]:
        """
        Tenant Id for the service principal with which the on-premise management/data plane components would communicate with our Azure services.
        """
        return pulumi.get(self, "tenant_id")


@pulumi.output_type
class CollectorPropertiesResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createdTimestamp":
            suggest = "created_timestamp"
        elif key == "updatedTimestamp":
            suggest = "updated_timestamp"
        elif key == "agentProperties":
            suggest = "agent_properties"
        elif key == "discoverySiteId":
            suggest = "discovery_site_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CollectorPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CollectorPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CollectorPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 created_timestamp: str,
                 updated_timestamp: str,
                 agent_properties: Optional['outputs.CollectorAgentPropertiesResponse'] = None,
                 discovery_site_id: Optional[str] = None):
        """
        :param str created_timestamp: Time when this collector was created. Date-Time represented in ISO-8601 format.
        :param str updated_timestamp: Time when this collector was updated. Date-Time represented in ISO-8601 format.
        :param str discovery_site_id: The ARM id of the discovery service site.
        """
        pulumi.set(__self__, "created_timestamp", created_timestamp)
        pulumi.set(__self__, "updated_timestamp", updated_timestamp)
        if agent_properties is not None:
            pulumi.set(__self__, "agent_properties", agent_properties)
        if discovery_site_id is not None:
            pulumi.set(__self__, "discovery_site_id", discovery_site_id)

    @property
    @pulumi.getter(name="createdTimestamp")
    def created_timestamp(self) -> str:
        """
        Time when this collector was created. Date-Time represented in ISO-8601 format.
        """
        return pulumi.get(self, "created_timestamp")

    @property
    @pulumi.getter(name="updatedTimestamp")
    def updated_timestamp(self) -> str:
        """
        Time when this collector was updated. Date-Time represented in ISO-8601 format.
        """
        return pulumi.get(self, "updated_timestamp")

    @property
    @pulumi.getter(name="agentProperties")
    def agent_properties(self) -> Optional['outputs.CollectorAgentPropertiesResponse']:
        return pulumi.get(self, "agent_properties")

    @property
    @pulumi.getter(name="discoverySiteId")
    def discovery_site_id(self) -> Optional[str]:
        """
        The ARM id of the discovery service site.
        """
        return pulumi.get(self, "discovery_site_id")


@pulumi.output_type
class GroupPropertiesResponse(dict):
    """
    Properties of group resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "areAssessmentsRunning":
            suggest = "are_assessments_running"
        elif key == "createdTimestamp":
            suggest = "created_timestamp"
        elif key == "groupStatus":
            suggest = "group_status"
        elif key == "machineCount":
            suggest = "machine_count"
        elif key == "updatedTimestamp":
            suggest = "updated_timestamp"
        elif key == "groupType":
            suggest = "group_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GroupPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GroupPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GroupPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 are_assessments_running: bool,
                 assessments: Sequence[str],
                 created_timestamp: str,
                 group_status: str,
                 machine_count: int,
                 updated_timestamp: str,
                 group_type: Optional[str] = None):
        """
        Properties of group resource.
        :param bool are_assessments_running: If the assessments are in running state.
        :param Sequence[str] assessments: List of References to Assessments created on this group.
        :param str created_timestamp: Time when this group was created. Date-Time represented in ISO-8601 format.
        :param str group_status: Whether the group has been created and is valid.
        :param int machine_count: Number of machines part of this group.
        :param str updated_timestamp: Time when this group was last updated. Date-Time represented in ISO-8601 format.
        :param str group_type: The type of group.
        """
        pulumi.set(__self__, "are_assessments_running", are_assessments_running)
        pulumi.set(__self__, "assessments", assessments)
        pulumi.set(__self__, "created_timestamp", created_timestamp)
        pulumi.set(__self__, "group_status", group_status)
        pulumi.set(__self__, "machine_count", machine_count)
        pulumi.set(__self__, "updated_timestamp", updated_timestamp)
        if group_type is not None:
            pulumi.set(__self__, "group_type", group_type)

    @property
    @pulumi.getter(name="areAssessmentsRunning")
    def are_assessments_running(self) -> bool:
        """
        If the assessments are in running state.
        """
        return pulumi.get(self, "are_assessments_running")

    @property
    @pulumi.getter
    def assessments(self) -> Sequence[str]:
        """
        List of References to Assessments created on this group.
        """
        return pulumi.get(self, "assessments")

    @property
    @pulumi.getter(name="createdTimestamp")
    def created_timestamp(self) -> str:
        """
        Time when this group was created. Date-Time represented in ISO-8601 format.
        """
        return pulumi.get(self, "created_timestamp")

    @property
    @pulumi.getter(name="groupStatus")
    def group_status(self) -> str:
        """
        Whether the group has been created and is valid.
        """
        return pulumi.get(self, "group_status")

    @property
    @pulumi.getter(name="machineCount")
    def machine_count(self) -> int:
        """
        Number of machines part of this group.
        """
        return pulumi.get(self, "machine_count")

    @property
    @pulumi.getter(name="updatedTimestamp")
    def updated_timestamp(self) -> str:
        """
        Time when this group was last updated. Date-Time represented in ISO-8601 format.
        """
        return pulumi.get(self, "updated_timestamp")

    @property
    @pulumi.getter(name="groupType")
    def group_type(self) -> Optional[str]:
        """
        The type of group.
        """
        return pulumi.get(self, "group_type")


@pulumi.output_type
class ImportCollectorPropertiesResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createdTimestamp":
            suggest = "created_timestamp"
        elif key == "updatedTimestamp":
            suggest = "updated_timestamp"
        elif key == "discoverySiteId":
            suggest = "discovery_site_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ImportCollectorPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ImportCollectorPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ImportCollectorPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 created_timestamp: str,
                 updated_timestamp: str,
                 discovery_site_id: Optional[str] = None):
        pulumi.set(__self__, "created_timestamp", created_timestamp)
        pulumi.set(__self__, "updated_timestamp", updated_timestamp)
        if discovery_site_id is not None:
            pulumi.set(__self__, "discovery_site_id", discovery_site_id)

    @property
    @pulumi.getter(name="createdTimestamp")
    def created_timestamp(self) -> str:
        return pulumi.get(self, "created_timestamp")

    @property
    @pulumi.getter(name="updatedTimestamp")
    def updated_timestamp(self) -> str:
        return pulumi.get(self, "updated_timestamp")

    @property
    @pulumi.getter(name="discoverySiteId")
    def discovery_site_id(self) -> Optional[str]:
        return pulumi.get(self, "discovery_site_id")


@pulumi.output_type
class PrivateEndpointConnectionPropertiesResponse(dict):
    """
    Private endpoint connection properties.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "privateEndpoint":
            suggest = "private_endpoint"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "privateLinkServiceConnectionState":
            suggest = "private_link_service_connection_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PrivateEndpointConnectionPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PrivateEndpointConnectionPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PrivateEndpointConnectionPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 private_endpoint: 'outputs.ResourceIdResponse',
                 provisioning_state: str,
                 private_link_service_connection_state: Optional['outputs.PrivateLinkServiceConnectionStateResponse'] = None):
        """
        Private endpoint connection properties.
        :param 'ResourceIdResponse' private_endpoint: ARM id for the private endpoint resource corresponding to the connection.
        :param str provisioning_state: Indicates whether there is an ongoing operation on the private endpoint.
        :param 'PrivateLinkServiceConnectionStateResponse' private_link_service_connection_state: State of the private endpoint connection.
        """
        pulumi.set(__self__, "private_endpoint", private_endpoint)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if private_link_service_connection_state is not None:
            pulumi.set(__self__, "private_link_service_connection_state", private_link_service_connection_state)

    @property
    @pulumi.getter(name="privateEndpoint")
    def private_endpoint(self) -> 'outputs.ResourceIdResponse':
        """
        ARM id for the private endpoint resource corresponding to the connection.
        """
        return pulumi.get(self, "private_endpoint")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        Indicates whether there is an ongoing operation on the private endpoint.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="privateLinkServiceConnectionState")
    def private_link_service_connection_state(self) -> Optional['outputs.PrivateLinkServiceConnectionStateResponse']:
        """
        State of the private endpoint connection.
        """
        return pulumi.get(self, "private_link_service_connection_state")


@pulumi.output_type
class PrivateEndpointConnectionResponse(dict):
    """
    A private endpoint connection for a project.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "eTag":
            suggest = "e_tag"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PrivateEndpointConnectionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PrivateEndpointConnectionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PrivateEndpointConnectionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: str,
                 name: str,
                 properties: 'outputs.PrivateEndpointConnectionPropertiesResponse',
                 type: str,
                 e_tag: Optional[str] = None):
        """
        A private endpoint connection for a project.
        :param str id: Path reference to this private endpoint endpoint connection. /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Migrate/assessmentProjects/{projectName}/privateEndpointConnections/{privateEndpointConnectionName}
        :param str name: Name of the private endpoint endpoint connection.
        :param 'PrivateEndpointConnectionPropertiesResponse' properties: Properties of the private endpoint endpoint connection.
        :param str type: Type of the object = [Microsoft.Migrate/assessmentProjects/privateEndpointConnections].
        :param str e_tag: For optimistic concurrency control.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "properties", properties)
        pulumi.set(__self__, "type", type)
        if e_tag is not None:
            pulumi.set(__self__, "e_tag", e_tag)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Path reference to this private endpoint endpoint connection. /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Migrate/assessmentProjects/{projectName}/privateEndpointConnections/{privateEndpointConnectionName}
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the private endpoint endpoint connection.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def properties(self) -> 'outputs.PrivateEndpointConnectionPropertiesResponse':
        """
        Properties of the private endpoint endpoint connection.
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of the object = [Microsoft.Migrate/assessmentProjects/privateEndpointConnections].
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="eTag")
    def e_tag(self) -> Optional[str]:
        """
        For optimistic concurrency control.
        """
        return pulumi.get(self, "e_tag")


@pulumi.output_type
class PrivateLinkServiceConnectionStateResponse(dict):
    """
    State of a private endpoint connection.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "actionsRequired":
            suggest = "actions_required"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PrivateLinkServiceConnectionStateResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PrivateLinkServiceConnectionStateResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PrivateLinkServiceConnectionStateResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 actions_required: Optional[str] = None,
                 description: Optional[str] = None,
                 status: Optional[str] = None):
        """
        State of a private endpoint connection.
        :param str actions_required: Actions required on the private endpoint connection.
        :param str description: Description of the private endpoint connection.
        :param str status: Connection status of the private endpoint connection.
        """
        if actions_required is not None:
            pulumi.set(__self__, "actions_required", actions_required)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="actionsRequired")
    def actions_required(self) -> Optional[str]:
        """
        Actions required on the private endpoint connection.
        """
        return pulumi.get(self, "actions_required")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Description of the private endpoint connection.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        Connection status of the private endpoint connection.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class ProjectPropertiesResponse(dict):
    """
    Properties of a project.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createdTimestamp":
            suggest = "created_timestamp"
        elif key == "lastAssessmentTimestamp":
            suggest = "last_assessment_timestamp"
        elif key == "numberOfAssessments":
            suggest = "number_of_assessments"
        elif key == "numberOfGroups":
            suggest = "number_of_groups"
        elif key == "numberOfMachines":
            suggest = "number_of_machines"
        elif key == "privateEndpointConnections":
            suggest = "private_endpoint_connections"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "serviceEndpoint":
            suggest = "service_endpoint"
        elif key == "updatedTimestamp":
            suggest = "updated_timestamp"
        elif key == "assessmentSolutionId":
            suggest = "assessment_solution_id"
        elif key == "customerStorageAccountArmId":
            suggest = "customer_storage_account_arm_id"
        elif key == "customerWorkspaceId":
            suggest = "customer_workspace_id"
        elif key == "customerWorkspaceLocation":
            suggest = "customer_workspace_location"
        elif key == "projectStatus":
            suggest = "project_status"
        elif key == "publicNetworkAccess":
            suggest = "public_network_access"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProjectPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProjectPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProjectPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 created_timestamp: str,
                 last_assessment_timestamp: str,
                 number_of_assessments: int,
                 number_of_groups: int,
                 number_of_machines: int,
                 private_endpoint_connections: Sequence['outputs.PrivateEndpointConnectionResponse'],
                 provisioning_state: str,
                 service_endpoint: str,
                 updated_timestamp: str,
                 assessment_solution_id: Optional[str] = None,
                 customer_storage_account_arm_id: Optional[str] = None,
                 customer_workspace_id: Optional[str] = None,
                 customer_workspace_location: Optional[str] = None,
                 project_status: Optional[str] = None,
                 public_network_access: Optional[str] = None):
        """
        Properties of a project.
        :param str created_timestamp: Time when this project was created. Date-Time represented in ISO-8601 format.
        :param str last_assessment_timestamp: Time when last assessment was created. Date-Time represented in ISO-8601 format. This value will be null until assessment is created.
        :param int number_of_assessments: Number of assessments created in the project.
        :param int number_of_groups: Number of groups created in the project.
        :param int number_of_machines: Number of machines in the project.
        :param Sequence['PrivateEndpointConnectionResponse'] private_endpoint_connections: The list of private endpoint connections to the project.
        :param str provisioning_state: Provisioning state of the project.
        :param str service_endpoint: Endpoint at which the collector agent can call agent REST API.
        :param str updated_timestamp: Time when this project was last updated. Date-Time represented in ISO-8601 format.
        :param str assessment_solution_id: Assessment solution ARM id tracked by Microsoft.Migrate/migrateProjects.
        :param str customer_storage_account_arm_id: The ARM id of the storage account used for interactions when public access is disabled.
        :param str customer_workspace_id: The ARM id of service map workspace created by customer.
        :param str customer_workspace_location: Location of service map workspace created by customer.
        :param str project_status: Assessment project status.
        :param str public_network_access: This value can be set to 'enabled' to avoid breaking changes on existing customer resources and templates. If set to 'disabled', traffic over public interface is not allowed, and private endpoint connections would be the exclusive access method.
        """
        pulumi.set(__self__, "created_timestamp", created_timestamp)
        pulumi.set(__self__, "last_assessment_timestamp", last_assessment_timestamp)
        pulumi.set(__self__, "number_of_assessments", number_of_assessments)
        pulumi.set(__self__, "number_of_groups", number_of_groups)
        pulumi.set(__self__, "number_of_machines", number_of_machines)
        pulumi.set(__self__, "private_endpoint_connections", private_endpoint_connections)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        pulumi.set(__self__, "service_endpoint", service_endpoint)
        pulumi.set(__self__, "updated_timestamp", updated_timestamp)
        if assessment_solution_id is not None:
            pulumi.set(__self__, "assessment_solution_id", assessment_solution_id)
        if customer_storage_account_arm_id is not None:
            pulumi.set(__self__, "customer_storage_account_arm_id", customer_storage_account_arm_id)
        if customer_workspace_id is not None:
            pulumi.set(__self__, "customer_workspace_id", customer_workspace_id)
        if customer_workspace_location is not None:
            pulumi.set(__self__, "customer_workspace_location", customer_workspace_location)
        if project_status is not None:
            pulumi.set(__self__, "project_status", project_status)
        if public_network_access is not None:
            pulumi.set(__self__, "public_network_access", public_network_access)

    @property
    @pulumi.getter(name="createdTimestamp")
    def created_timestamp(self) -> str:
        """
        Time when this project was created. Date-Time represented in ISO-8601 format.
        """
        return pulumi.get(self, "created_timestamp")

    @property
    @pulumi.getter(name="lastAssessmentTimestamp")
    def last_assessment_timestamp(self) -> str:
        """
        Time when last assessment was created. Date-Time represented in ISO-8601 format. This value will be null until assessment is created.
        """
        return pulumi.get(self, "last_assessment_timestamp")

    @property
    @pulumi.getter(name="numberOfAssessments")
    def number_of_assessments(self) -> int:
        """
        Number of assessments created in the project.
        """
        return pulumi.get(self, "number_of_assessments")

    @property
    @pulumi.getter(name="numberOfGroups")
    def number_of_groups(self) -> int:
        """
        Number of groups created in the project.
        """
        return pulumi.get(self, "number_of_groups")

    @property
    @pulumi.getter(name="numberOfMachines")
    def number_of_machines(self) -> int:
        """
        Number of machines in the project.
        """
        return pulumi.get(self, "number_of_machines")

    @property
    @pulumi.getter(name="privateEndpointConnections")
    def private_endpoint_connections(self) -> Sequence['outputs.PrivateEndpointConnectionResponse']:
        """
        The list of private endpoint connections to the project.
        """
        return pulumi.get(self, "private_endpoint_connections")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        Provisioning state of the project.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="serviceEndpoint")
    def service_endpoint(self) -> str:
        """
        Endpoint at which the collector agent can call agent REST API.
        """
        return pulumi.get(self, "service_endpoint")

    @property
    @pulumi.getter(name="updatedTimestamp")
    def updated_timestamp(self) -> str:
        """
        Time when this project was last updated. Date-Time represented in ISO-8601 format.
        """
        return pulumi.get(self, "updated_timestamp")

    @property
    @pulumi.getter(name="assessmentSolutionId")
    def assessment_solution_id(self) -> Optional[str]:
        """
        Assessment solution ARM id tracked by Microsoft.Migrate/migrateProjects.
        """
        return pulumi.get(self, "assessment_solution_id")

    @property
    @pulumi.getter(name="customerStorageAccountArmId")
    def customer_storage_account_arm_id(self) -> Optional[str]:
        """
        The ARM id of the storage account used for interactions when public access is disabled.
        """
        return pulumi.get(self, "customer_storage_account_arm_id")

    @property
    @pulumi.getter(name="customerWorkspaceId")
    def customer_workspace_id(self) -> Optional[str]:
        """
        The ARM id of service map workspace created by customer.
        """
        return pulumi.get(self, "customer_workspace_id")

    @property
    @pulumi.getter(name="customerWorkspaceLocation")
    def customer_workspace_location(self) -> Optional[str]:
        """
        Location of service map workspace created by customer.
        """
        return pulumi.get(self, "customer_workspace_location")

    @property
    @pulumi.getter(name="projectStatus")
    def project_status(self) -> Optional[str]:
        """
        Assessment project status.
        """
        return pulumi.get(self, "project_status")

    @property
    @pulumi.getter(name="publicNetworkAccess")
    def public_network_access(self) -> Optional[str]:
        """
        This value can be set to 'enabled' to avoid breaking changes on existing customer resources and templates. If set to 'disabled', traffic over public interface is not allowed, and private endpoint connections would be the exclusive access method.
        """
        return pulumi.get(self, "public_network_access")


@pulumi.output_type
class ResourceIdResponse(dict):
    """
    ARM id for a resource.
    """
    def __init__(__self__, *,
                 id: str):
        """
        ARM id for a resource.
        """
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> str:
        return pulumi.get(self, "id")


@pulumi.output_type
class VmUptimeResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "daysPerMonth":
            suggest = "days_per_month"
        elif key == "hoursPerDay":
            suggest = "hours_per_day"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VmUptimeResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VmUptimeResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VmUptimeResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 days_per_month: Optional[float] = None,
                 hours_per_day: Optional[float] = None):
        """
        :param float days_per_month: Number of days in a month for VM uptime.
        :param float hours_per_day: Number of hours per day for VM uptime.
        """
        if days_per_month is not None:
            pulumi.set(__self__, "days_per_month", days_per_month)
        if hours_per_day is not None:
            pulumi.set(__self__, "hours_per_day", hours_per_day)

    @property
    @pulumi.getter(name="daysPerMonth")
    def days_per_month(self) -> Optional[float]:
        """
        Number of days in a month for VM uptime.
        """
        return pulumi.get(self, "days_per_month")

    @property
    @pulumi.getter(name="hoursPerDay")
    def hours_per_day(self) -> Optional[float]:
        """
        Number of hours per day for VM uptime.
        """
        return pulumi.get(self, "hours_per_day")


